/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.tree.GradientBoostedTrees;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.mllib.util.MLUtils;
import scala.Tuple2;

public class JavaGradientBoostingClassificationExample {
    public static void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("JavaGradientBoostedTreesClassificationExample");
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        String datapath = "data/mllib/sample_libsvm_data.txt";
        JavaRDD data = MLUtils.loadLibSVMFile((SparkContext)jsc.sc(), (String)datapath).toJavaRDD();
        JavaRDD[] splits = data.randomSplit(new double[]{0.7, 0.3});
        JavaRDD trainingData = splits[0];
        JavaRDD testData = splits[1];
        BoostingStrategy boostingStrategy = BoostingStrategy.defaultParams((String)"Classification");
        boostingStrategy.setNumIterations(3);
        boostingStrategy.getTreeStrategy().setNumClasses(2);
        boostingStrategy.getTreeStrategy().setMaxDepth(5);
        HashMap categoricalFeaturesInfo = new HashMap();
        boostingStrategy.treeStrategy().setCategoricalFeaturesInfo(categoricalFeaturesInfo);
        GradientBoostedTreesModel model = GradientBoostedTrees.train((JavaRDD)trainingData, (BoostingStrategy)boostingStrategy);
        JavaPairRDD predictionAndLabel = testData.mapToPair((PairFunction & Serializable)p -> new Tuple2((Object)model.predict(p.features()), (Object)p.label()));
        double testErr = (double)predictionAndLabel.filter((Function & Serializable)pl -> !((Double)pl._1()).equals(pl._2())).count() / (double)testData.count();
        System.out.println("Test Error: " + testErr);
        System.out.println("Learned classification GBT model:\n" + model.toDebugString());
        model.save(jsc.sc(), "target/tmp/myGradientBoostingClassificationModel");
        GradientBoostedTreesModel sameModel = GradientBoostedTreesModel.load((SparkContext)jsc.sc(), (String)"target/tmp/myGradientBoostingClassificationModel");
        jsc.stop();
    }
}

