/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

public final class UnsafeRowUtils$ {
    public static final UnsafeRowUtils$ MODULE$ = new UnsafeRowUtils$();

    private Option<String> validateStructuralIntegrityWithReasonImpl(UnsafeRow row, StructType expectedSchema) {
        Option option;
        Object object = new Object();
        try {
            if (expectedSchema.fields().length != row.numFields()) {
                return new Some((Object)new StringBuilder(0).append("Field length mismatch: ").append(new StringBuilder(20).append("expected: ").append(expectedSchema.fields().length).append(", actual: ").append(row.numFields()).toString()).toString());
            }
            int bitSetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(row.numFields());
            int rowSizeInBytes = row.getSizeInBytes();
            if (expectedSchema.fields().length > 0 && bitSetWidthInBytes >= rowSizeInBytes) {
                return new Some((Object)new StringBuilder(0).append("rowSizeInBytes should not exceed bitSetWidthInBytes, ").append(new StringBuilder(38).append("bitSetWidthInBytes: ").append(bitSetWidthInBytes).append(", rowSizeInBytes: ").append(rowSizeInBytes).toString()).toString());
            }
            IntRef varLenFieldsSizeInBytes = IntRef.create((int)0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])expectedSchema.fields()))), (Function1 & Serializable)x0$1 -> {
                UnsafeRowUtils$.$anonfun$validateStructuralIntegrityWithReasonImpl$1(row, bitSetWidthInBytes, rowSizeInBytes, object, varLenFieldsSizeInBytes, x0$1);
                return BoxedUnit.UNIT;
            });
            if (bitSetWidthInBytes + 8 * row.numFields() + varLenFieldsSizeInBytes.elem > rowSizeInBytes) {
                return new Some((Object)new StringBuilder(0).append("Row total length invalid: ").append(new StringBuilder(13).append("calculated: ").append(bitSetWidthInBytes + 8 * row.numFields() + varLenFieldsSizeInBytes.elem).append(" ").toString()).append(new StringBuilder(16).append("rowSizeInBytes: ").append(rowSizeInBytes).toString()).toString());
            }
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public Option<String> validateStructuralIntegrityWithReason(UnsafeRow row, StructType expectedSchema) {
        return this.validateStructuralIntegrityWithReasonImpl(row, expectedSchema).map((Function1 & Serializable)errorMessage -> new StringBuilder(0).append(new StringBuilder(20).append("Error message is: ").append((String)errorMessage).append(", ").toString()).append(new StringBuilder(18).append("UnsafeRow status: ").append(MODULE$.getStructuralIntegrityStatus(row, expectedSchema)).toString()).toString());
    }

    public Tuple2<Object, Object> getOffsetAndSize(UnsafeRow row, int index) {
        long offsetAndSize = row.getLong(index);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        return new Tuple2.mcII.sp(offset, size);
    }

    public boolean avoidSetNullAt(DataType dt) {
        DecimalType decimalType;
        DataType dataType = dt;
        boolean bl = dataType instanceof DecimalType && (decimalType = (DecimalType)dataType).precision() > Decimal$.MODULE$.MAX_LONG_DIGITS() ? true : CalendarIntervalType$.MODULE$.equals(dataType);
        return bl;
    }

    public String getStructuralIntegrityStatus(UnsafeRow row, StructType expectedSchema) {
        int minLength = Math.min(row.numFields(), expectedSchema.fields().length);
        String[] fieldStatusArr = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])expectedSchema.fields()), minLength)))), (Function1 & Serializable)x0$1 -> {
            String string;
            int index;
            StructField field;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                field = (StructField)tuple2._1();
                index = tuple2._2$mcI$sp();
                if (!UnsafeRow.isFixedLength(field.dataType())) {
                    Tuple2<Object, Object> tuple22 = MODULE$.getOffsetAndSize(row, index);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    int offset = tuple22._1$mcI$sp();
                    int size = tuple22._2$mcI$sp();
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(offset, size);
                    Tuple2.mcII.sp sp3 = sp2;
                    int offset2 = sp3._1$mcI$sp();
                    int size2 = sp3._2$mcI$sp();
                    string = new StringBuilder(16).append("offset: ").append(offset2).append(", size: ").append(size2).toString();
                } else {
                    string = "";
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            String offsetAndSizeStr = string;
            String string2 = new StringBuilder(0).append(new StringBuilder(32).append("[UnsafeRowFieldStatus] index: ").append(index).append(", ").toString()).append(new StringBuilder(31).append("expectedFieldType: ").append(field.dataType()).append(", isNull: ").append(row.isNullAt(index)).append(", ").toString()).append(new StringBuilder(17).append("isFixedLength: ").append(UnsafeRow.isFixedLength(field.dataType())).append(". ").append(offsetAndSizeStr).toString()).toString();
            return string2;
        }, ClassTag$.MODULE$.apply(String.class));
        return new StringBuilder(0).append(new StringBuilder(36).append("[UnsafeRowStatus] expectedSchema: ").append(expectedSchema).append(", ").toString()).append(new StringBuilder(40).append("expectedSchemaNumFields: ").append(expectedSchema.fields().length).append(", numFields: ").append(row.numFields()).append(", ").toString()).append(new StringBuilder(22).append("bitSetWidthInBytes: ").append(UnsafeRow.calculateBitSetWidthInBytes(row.numFields())).append(", ").toString()).append(new StringBuilder(30).append("rowSizeInBytes: ").append(row.getSizeInBytes()).append("\nfieldStatus:\n").toString()).append(Predef$.MODULE$.wrapRefArray((Object[])fieldStatusArr).mkString("\n")).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$validateStructuralIntegrityWithReasonImpl$1(UnsafeRow row$1, int bitSetWidthInBytes$1, int rowSizeInBytes$1, Object nonLocalReturnKey1$1, IntRef varLenFieldsSizeInBytes$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (!UnsafeRow.isFixedLength(field.dataType()) && !row$1.isNullAt(index)) {
                Tuple2<Object, Object> tuple22 = MODULE$.getOffsetAndSize(row$1, index);
                if (tuple22 == null) throw new MatchError(tuple22);
                int offset = tuple22._1$mcI$sp();
                int size = tuple22._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(offset, size);
                Tuple2.mcII.sp sp3 = sp2;
                int offset2 = sp3._1$mcI$sp();
                int size2 = sp3._2$mcI$sp();
                if (size2 < 0) throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(56).append("Variable-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                if (offset2 < bitSetWidthInBytes$1 + 8 * row$1.numFields()) throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(56).append("Variable-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                if (offset2 + size2 > rowSizeInBytes$1) {
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(56).append("Variable-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                }
                varLenFieldsSizeInBytes$1.elem += size2;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (UnsafeRow.isFixedLength(field.dataType()) && !row$1.isNullAt(index)) {
                DataType dataType = field.dataType();
                if (BooleanType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 1 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(53).append("Fixed-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 8 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(53).append("Fixed-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 16 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(53).append("Fixed-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 32 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(53).append("Fixed-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 32 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(53).append("Fixed-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (row$1.isNullAt(index)) {
                DecimalType decimalType;
                DataType dataType = field.dataType();
                if (dataType instanceof DecimalType && !UnsafeRow.isFixedLength((DataType)(decimalType = (DecimalType)dataType))) {
                    Tuple2<Object, Object> tuple23 = MODULE$.getOffsetAndSize(row$1, index);
                    if (tuple23 == null) throw new MatchError(tuple23);
                    int offset = tuple23._1$mcI$sp();
                    int size = tuple23._2$mcI$sp();
                    Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(offset, size);
                    Tuple2.mcII.sp sp5 = sp4;
                    int offset3 = sp5._1$mcI$sp();
                    int size3 = sp5._2$mcI$sp();
                    if (size3 != 0) throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(0).append("Variable-length decimal field special case validation error: ").append(new StringBuilder(16).append("field: ").append(field).append(", index: ").append(index).toString()).toString()));
                    if (offset3 != 0) {
                        if (offset3 < bitSetWidthInBytes$1 + 8 * row$1.numFields()) throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(0).append("Variable-length decimal field special case validation error: ").append(new StringBuilder(16).append("field: ").append(field).append(", index: ").append(index).toString()).toString()));
                        if (offset3 > rowSizeInBytes$1) {
                            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(0).append("Variable-length decimal field special case validation error: ").append(new StringBuilder(16).append("field: ").append(field).append(", index: ").append(index).toString()).toString()));
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (row$1.getLong(index) != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(0).append("Variable-length offset-size validation error: ").append(new StringBuilder(16).append("field: ").append(field).append(", index: ").append(index).toString()).toString()));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private UnsafeRowUtils$() {
    }
}

