/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005-3Q\u0001C\u0005\u0001\u0017MA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006]\u0001!\ta\f\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0011\u0019)\u0004\u0001)A\u0005W!9a\u0007\u0001b\u0001\n\u00139\u0004B\u0002\u001d\u0001A\u0003%\u0001\u0006C\u0003:\u0001\u0011\u0005!H\u0001\bGK\u0006$XO]3F]\u000e|G-\u001a:\u000b\u0005)Y\u0011a\u00024fCR,(/\u001a\u0006\u0003\u00195\t!!\u001c7\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c2\u0001\u0001\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111\u0004\n\b\u00039\tr!!H\u0011\u000e\u0003yQ!a\b\u0011\u0002\rq\u0012xn\u001c;?\u0007\u0001I\u0011aF\u0005\u0003GY\tq\u0001]1dW\u0006<W-\u0003\u0002&M\ta1+\u001a:jC2L'0\u00192mK*\u00111EF\u0001\f]Vlg)Z1ukJ,7\u000fE\u0002\u0016S-J!A\u000b\f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Ua\u0013BA\u0017\u0017\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u0012\u0004CA\u0019\u0001\u001b\u0005I\u0001\"B\u0014\u0003\u0001\u0004A\u0013AC8viB,HoU5{KV\t1&A\u0006pkR\u0004X\u000f^*ju\u0016\u0004\u0013!D8viB,Ho\u00144gg\u0016$8/F\u0001)\u00039yW\u000f\u001e9vi>3gm]3ug\u0002\nACZ8sK\u0006\u001c\u0007NT8ou\u0016\u0014xnT;uaV$HcA\u001e?\u0007B\u0011Q\u0003P\u0005\u0003{Y\u0011A!\u00168ji\")qh\u0002a\u0001\u0001\u0006)a/\u00197vKB\u0011Q#Q\u0005\u0003\u0005Z\u00111!\u00118z\u0011\u0015!u\u00011\u0001F\u0003\u00051\u0007#B\u000bGW![\u0014BA$\u0017\u0005%1UO\\2uS>t'\u0007\u0005\u0002\u0016\u0013&\u0011!J\u0006\u0002\u0007\t>,(\r\\3")
public class FeatureEncoder
implements Serializable {
    private final int[] numFeatures;
    private final int outputSize;
    private final int[] outputOffsets;

    public int outputSize() {
        return this.outputSize;
    }

    private int[] outputOffsets() {
        return this.outputOffsets;
    }

    public void foreachNonzeroOutput(Object value, Function2<Object, Object, BoxedUnit> f) {
        Object object = value;
        if (object instanceof Double) {
            BoxedUnit boxedUnit;
            double d = BoxesRunTime.unboxToDouble((Object)object);
            Predef$.MODULE$.assert(this.numFeatures.length == 1, (Function0 & Serializable)() -> new StringBuilder(41).append(DoubleType$.MODULE$.catalogString()).append(" columns should only contain one feature.").toString());
            int numOutputCols = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(this.numFeatures)));
            if (numOutputCols > 1) {
                Predef$.MODULE$.assert(d >= 0.0 && d == (double)((int)d) && d < (double)numOutputCols, (Function0 & Serializable)() -> new StringBuilder(45).append("Values from column must be indices, but got ").append(d).append(".").toString());
                f.apply$mcVID$sp((int)d, 1.0);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                f.apply$mcVID$sp(0, d);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            Predef$.MODULE$.assert(this.numFeatures.length == vector.size(), (Function0 & Serializable)() -> new StringBuilder(34).append("Vector column size was ").append(vector.size()).append(", expected ").append($this.numFeatures.length).toString());
            vector.foreachActive((Function2)(JFunction2.mcVID.sp & Serializable)(i, v) -> {
                int numOutputCols = $this.numFeatures[i];
                if (numOutputCols > 1) {
                    Predef$.MODULE$.assert(v >= 0.0 && v == (double)((int)v) && v < (double)numOutputCols, (Function0 & Serializable)() -> new StringBuilder(45).append("Values from column must be indices, but got ").append(v).append(".").toString());
                    f.apply$mcVID$sp(this.outputOffsets()[i] + (int)v, 1.0);
                } else {
                    f.apply$mcVID$sp(this.outputOffsets()[i], v);
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (object == null) {
                throw new SparkException("Values to interact cannot be null.");
            }
            throw new SparkException(new StringBuilder(27).append(object).append(" of type ").append(object.getClass().getName()).append(" is not supported.").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public FeatureEncoder(int[] numFeatures) {
        void var2_2;
        this.numFeatures = numFeatures;
        Predef$.MODULE$.assert(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.intArrayOps(numFeatures), (Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 > 0), (Function0 & Serializable)() -> "Features counts must all be positive.");
        this.outputSize = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(numFeatures).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int[] arr = new int[numFeatures.length];
        for (int i = 1; i < arr.length; ++i) {
            arr[i] = arr[i - 1] + numFeatures[i - 1];
        }
        this.outputOffsets = var2_2;
    }
}

