/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReaderV1;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReaderV2;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReaderV3;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReaderV4;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00054Aa\u0003\u0007\u00017!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!1\u0004A!A!\u0002\u00139\u0004\"B\u001f\u0001\t\u0003q\u0004\"\u0002#\u0001\t\u0013)\u0005\u0002C(\u0001\u0011\u000b\u0007I\u0011\u0002)\t\u000fQ\u0003!\u0019!C\t+\"1a\u000b\u0001Q\u0001\n\u0019C\u0001b\u0016\u0001\t\u0006\u0004%I\u0001\u0017\u0005\u00069\u0002!\t!\u0018\u0002!'R\fG/Z*u_J,7\t[1oO\u0016dwn\u001a*fC\u0012,'OR1di>\u0014\u0018P\u0003\u0002\u000e\u001d\u0005)1\u000f^1uK*\u0011q\u0002E\u0001\ngR\u0014X-Y7j]\u001eT!!\u0005\n\u0002\u0013\u0015DXmY;uS>t'BA\n\u0015\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+Y\tQa\u001d9be.T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u000b\u0002\u0011%tG/\u001a:oC2L!a\n\u0013\u0003\u000f1{wmZ5oO\u0006\u0011a-\u001c\t\u0003U-j\u0011AD\u0005\u0003Y9\u0011Qc\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'/\u0001\u0006gS2,Gk\u001c*fC\u0012\u0004\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u0005\u0019\u001c(BA\u001a\u0017\u0003\u0019A\u0017\rZ8pa&\u0011Q\u0007\r\u0002\u0005!\u0006$\b.\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGB\u0011\u0001hO\u0007\u0002s)\u0011!\bF\u0001\u0003S>L!\u0001P\u001d\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0017A\u0002\u001fj]&$h\b\u0006\u0003@\u0003\n\u001b\u0005C\u0001!\u0001\u001b\u0005a\u0001\"\u0002\u0015\u0005\u0001\u0004I\u0003\"B\u0017\u0005\u0001\u0004q\u0003\"\u0002\u001c\u0005\u0001\u00049\u0014\u0001\u00053fG>l\u0007O]3tgN#(/Z1n)\t1U\n\u0005\u0002H\u00176\t\u0001J\u0003\u0002;\u0013*\t!*\u0001\u0003kCZ\f\u0017B\u0001'I\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0007\"\u0002(\u0006\u0001\u00041\u0015aC5oaV$8\u000b\u001e:fC6\fAb]8ve\u000e,7\u000b\u001e:fC6,\u0012!\u0015\t\u0003_IK!a\u0015\u0019\u0003#\u0019\u001bF)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW.A\u0003j]B,H/F\u0001G\u0003\u0019Ig\u000e];uA\u0005\u00012\r[1oO\u0016dun\u001a,feNLwN\\\u000b\u00023B\u0011QDW\u0005\u00037z\u0011Qa\u00155peR\f\u0001dY8ogR\u0014Xo\u0019;DQ\u0006tw-\u001a7pOJ+\u0017\rZ3s)\u0005q\u0006C\u0001!`\u0013\t\u0001GBA\rTi\u0006$Xm\u0015;pe\u0016\u001c\u0005.\u00198hK2|wMU3bI\u0016\u0014\b")
public class StateStoreChangelogReaderFactory
implements Logging {
    private FSDataInputStream sourceStream;
    private short changeLogVersion;
    private final CheckpointFileManager fm;
    private final Path fileToRead;
    private final CompressionCodec compressionCodec;
    private final DataInputStream input;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private DataInputStream decompressStream(DataInputStream inputStream) {
        InputStream compressed = this.compressionCodec.compressedInputStream((InputStream)inputStream);
        return new DataInputStream(compressed);
    }

    private FSDataInputStream sourceStream$lzycompute() {
        StateStoreChangelogReaderFactory stateStoreChangelogReaderFactory = this;
        synchronized (stateStoreChangelogReaderFactory) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sourceStream = this.liftedTree1$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sourceStream;
    }

    private FSDataInputStream sourceStream() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sourceStream$lzycompute();
        }
        return this.sourceStream;
    }

    public DataInputStream input() {
        return this.input;
    }

    private short changeLogVersion$lzycompute() {
        StateStoreChangelogReaderFactory stateStoreChangelogReaderFactory = this;
        synchronized (stateStoreChangelogReaderFactory) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.changeLogVersion = this.liftedTree2$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.changeLogVersion;
    }

    private short changeLogVersion() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.changeLogVersion$lzycompute();
        }
        return this.changeLogVersion;
    }

    public StateStoreChangelogReader constructChangelogReader() {
        StateStoreChangelogReader reader = null;
        try {
            short s = this.changeLogVersion();
            reader = switch (s) {
                case 1 -> new StateStoreChangelogReaderV1(this.fm, this.fileToRead, this.compressionCodec);
                case 2 -> new StateStoreChangelogReaderV2(this.fm, this.fileToRead, this.compressionCodec);
                case 3 -> new StateStoreChangelogReaderV3(this.fm, this.fileToRead, this.compressionCodec);
                case 4 -> new StateStoreChangelogReaderV4(this.fm, this.fileToRead, this.compressionCodec);
                default -> throw QueryExecutionErrors$.MODULE$.invalidChangeLogReaderVersion((long)s);
            };
        }
        finally {
            if (this.input() != null) {
                this.input().close();
            }
        }
        return reader;
    }

    private final /* synthetic */ FSDataInputStream liftedTree1$1() {
        FSDataInputStream fSDataInputStream;
        try {
            fSDataInputStream = this.fm.open(this.fileToRead);
        }
        catch (FileNotFoundException f) {
            throw QueryExecutionErrors$.MODULE$.failedToReadStreamingStateFileError(this.fileToRead, (Throwable)f);
        }
        return fSDataInputStream;
    }

    private final /* synthetic */ short liftedTree2$1() {
        short s;
        try {
            String versionStr = this.input().readUTF();
            s = !versionStr.startsWith("v") ? (short)1 : StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(versionStr), "v")));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof EOFException ? true : (throwable2 instanceof UTFDataFormatException ? true : throwable2 instanceof NumberFormatException)) {
                s = 1;
            }
            throw throwable;
        }
        return s;
    }

    public StateStoreChangelogReaderFactory(CheckpointFileManager fm, Path fileToRead, CompressionCodec compressionCodec) {
        this.fm = fm;
        this.fileToRead = fileToRead;
        this.compressionCodec = compressionCodec;
        Logging.$init$((Logging)this);
        this.input = this.decompressStream((DataInputStream)this.sourceStream());
    }
}

