/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.execution.ConnectProgressExecutionListener;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.PreSharedKeyAuthenticationInterceptor;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SparkConnectExecutionManager;
import org.apache.spark.sql.connect.service.SparkConnectInterceptorRegistry$;
import org.apache.spark.sql.connect.service.SparkConnectService;
import org.apache.spark.sql.connect.service.SparkConnectSessionManager;
import org.apache.spark.sql.connect.service.SparkConnectStreamingQueryCache;
import org.apache.spark.sql.connect.service.SparkConnectStreamingQueryCache$;
import org.apache.spark.sql.connect.service.SparkListenerConnectServiceEnd;
import org.apache.spark.sql.connect.service.SparkListenerConnectServiceStarted;
import org.apache.spark.sql.connect.ui.SparkConnectServerAppStatusStore;
import org.apache.spark.sql.connect.ui.SparkConnectServerListener;
import org.apache.spark.sql.connect.ui.SparkConnectServerListener$;
import org.apache.spark.sql.connect.ui.SparkConnectServerTab;
import org.apache.spark.sql.connect.ui.SparkConnectServerTab$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStore;
import org.slf4j.Logger;
import org.sparkproject.connect.grpc.BindableService;
import org.sparkproject.connect.grpc.Server;
import org.sparkproject.connect.grpc.ServerInterceptor;
import org.sparkproject.connect.grpc.netty.NettyServerBuilder;
import org.sparkproject.connect.grpc.protobuf.services.ProtoReflectionService;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class SparkConnectService$
implements Logging {
    public static final SparkConnectService$ MODULE$ = new SparkConnectService$();
    private static SparkConnectExecutionManager executionManager;
    private static SparkConnectSessionManager sessionManager;
    private static Server server;
    private static InetSocketAddress bindingAddress;
    private static Option<SparkConnectServerTab> uiTab;
    private static SparkConnectServerListener listener;
    private static Option<ConnectProgressExecutionListener> executionListener;
    private static LiveListenerBus listenerBus;
    private static final SparkConnectStreamingQueryCache streamingSessionManager;
    private static volatile boolean started;
    private static volatile boolean stopped;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile byte bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        uiTab = None$.MODULE$;
        executionListener = None$.MODULE$;
        streamingSessionManager = new SparkConnectStreamingQueryCache(SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$1(), SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$2(), SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$3());
        started = false;
        stopped = false;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Server server() {
        return server;
    }

    public void server_$eq(Server x$1) {
        server = x$1;
    }

    public InetSocketAddress bindingAddress() {
        return bindingAddress;
    }

    public void bindingAddress_$eq(InetSocketAddress x$1) {
        bindingAddress = x$1;
    }

    public Option<SparkConnectServerTab> uiTab() {
        return uiTab;
    }

    public void uiTab_$eq(Option<SparkConnectServerTab> x$1) {
        uiTab = x$1;
    }

    public SparkConnectServerListener listener() {
        return listener;
    }

    public void listener_$eq(SparkConnectServerListener x$1) {
        listener = x$1;
    }

    public Option<ConnectProgressExecutionListener> executionListener() {
        return executionListener;
    }

    public void executionListener_$eq(Option<ConnectProgressExecutionListener> x$1) {
        executionListener = x$1;
    }

    public LiveListenerBus listenerBus() {
        return listenerBus;
    }

    public void listenerBus_$eq(LiveListenerBus x$1) {
        listenerBus = x$1;
    }

    public int localPort() {
        Predef$.MODULE$.assert(this.server() != null);
        return this.server().getPort();
    }

    public String hostAddress() {
        return Utils$.MODULE$.localCanonicalHostName();
    }

    private SparkConnectExecutionManager executionManager$lzycompute() {
        SparkConnectService$ sparkConnectService$ = this;
        synchronized (sparkConnectService$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                executionManager = new SparkConnectExecutionManager();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return executionManager;
    }

    public SparkConnectExecutionManager executionManager() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.executionManager$lzycompute();
        }
        return executionManager;
    }

    private SparkConnectSessionManager sessionManager$lzycompute() {
        SparkConnectService$ sparkConnectService$ = this;
        synchronized (sparkConnectService$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                sessionManager = new SparkConnectSessionManager();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return sessionManager;
    }

    public SparkConnectSessionManager sessionManager() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.sessionManager$lzycompute();
        }
        return sessionManager;
    }

    public SparkConnectStreamingQueryCache streamingSessionManager() {
        return streamingSessionManager;
    }

    public boolean started() {
        return started;
    }

    public void started_$eq(boolean x$1) {
        started = x$1;
    }

    public boolean stopped() {
        return stopped;
    }

    public void stopped_$eq(boolean x$1) {
        stopped = x$1;
    }

    public SessionHolder getOrCreateIsolatedSession(String userId, String sessionId, Option<String> previoslyObservedSessionId) {
        return this.sessionManager().getOrCreateIsolatedSession(new SessionKey(userId, sessionId), previoslyObservedSessionId);
    }

    public SessionHolder getOrCreateIsolatedSession(String userId, String sessionId) {
        return this.getOrCreateIsolatedSession(userId, sessionId, (Option<String>)None$.MODULE$);
    }

    public Either<Object, Seq<ExecuteInfo>> listActiveExecutions() {
        return this.executionManager().listActiveExecutions();
    }

    private void createListenerAndUI(SparkContext sc) {
        ElementTrackingStore kvStore = (ElementTrackingStore)sc.statusStore().store();
        this.listener_$eq(new SparkConnectServerListener(kvStore, sc.conf(), SparkConnectServerListener$.MODULE$.$lessinit$greater$default$3()));
        sc.listenerBus().addToStatusQueue((SparkListenerInterface)this.listener());
        this.uiTab_$eq((Option<SparkConnectServerTab>)(BoxesRunTime.unboxToBoolean((Object)sc.conf().get(UI$.MODULE$.UI_ENABLED())) ? new Some((Object)new SparkConnectServerTab(new SparkConnectServerAppStatusStore((KVStore)kvStore), SparkConnectServerTab$.MODULE$.getSparkUI(sc))) : None$.MODULE$));
        this.executionListener_$eq((Option<ConnectProgressExecutionListener>)new Some((Object)new ConnectProgressExecutionListener()));
        sc.addSparkListener((SparkListenerInterface)this.executionListener().get());
        this.listenerBus_$eq(sc.listenerBus());
    }

    private void startGRPCService() {
        boolean debugMode = SparkEnv$.MODULE$.get().conf().getBoolean("spark.connect.grpc.debug.enabled", false);
        Option bindAddress = (Option)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_BINDING_ADDRESS());
        int startPort = BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_BINDING_PORT()));
        SparkConnectService sparkConnectService = new SparkConnectService(debugMode);
        None$ protoReflectionService = debugMode ? new Some((Object)ProtoReflectionService.newInstance()) : None$.MODULE$;
        Seq<ServerInterceptor> configuredInterceptors = SparkConnectInterceptorRegistry$.MODULE$.createConfiguredInterceptors();
        Function1 & Serializable startServiceFn = arg_0 -> SparkConnectService$.$anonfun$startGRPCService$1$adapted(bindAddress, sparkConnectService, configuredInterceptors, (Option)protoReflectionService, arg_0);
        int maxRetries = BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_PORT_MAX_RETRIES()));
        Utils$.MODULE$.startServiceOnPort(startPort, (Function1)startServiceFn, maxRetries, this.getClass().getName());
    }

    public synchronized void start(SparkContext sc) {
        if (this.started()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The Spark Connect service has already started.");
            return;
        }
        this.startGRPCService();
        this.createListenerAndUI(sc);
        this.started_$eq(true);
        this.stopped_$eq(false);
        this.postSparkConnectServiceStarted();
    }

    public synchronized void stop(Option<Object> timeout, Option<TimeUnit> unit) {
        if (this.stopped()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The Spark Connect service has already been stopped.");
            return;
        }
        if (!this.started()) {
            throw new IllegalStateException("Attempting to stop the Spark Connect service that has not been started.");
        }
        if (this.server() != null) {
            if (timeout.isDefined() && unit.isDefined()) {
                this.server().shutdown();
                v0 = BoxesRunTime.boxToBoolean((boolean)this.server().awaitTermination(BoxesRunTime.unboxToLong((Object)timeout.get()), (TimeUnit)((Object)unit.get())));
            } else {
                v0 = this.server().shutdownNow();
            }
        } else {
            v0 = BoxedUnit.UNIT;
        }
        this.streamingSessionManager().shutdown();
        this.executionManager().shutdown();
        this.sessionManager().shutdown();
        this.uiTab().foreach((Function1 & Serializable)x$6 -> {
            x$6.detach();
            return BoxedUnit.UNIT;
        });
        this.started_$eq(false);
        this.stopped_$eq(true);
        this.postSparkConnectServiceEnd();
    }

    public Option<Object> stop$default$1() {
        return None$.MODULE$;
    }

    public Option<TimeUnit> stop$default$2() {
        return None$.MODULE$;
    }

    private void postSparkConnectServiceStarted() {
        this.postServiceEvent((Function1<InetSocketAddress, SparkListenerEvent>)(Function1 & Serializable)isa -> new SparkListenerConnectServiceStarted(MODULE$.hostAddress(), isa.getPort(), System.currentTimeMillis()));
    }

    public void postSparkConnectServiceEnd() {
        this.postServiceEvent((Function1<InetSocketAddress, SparkListenerEvent>)(Function1 & Serializable)isa -> new SparkListenerConnectServiceEnd(MODULE$.hostAddress(), isa.getPort(), System.currentTimeMillis()));
    }

    private void postServiceEvent(Function1<InetSocketAddress, SparkListenerEvent> eventBuilder) {
        if (this.server() == null) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The Spark Connect event was dropped because the server bus has not been created and set.");
            return;
        }
        if (this.bindingAddress() == null) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The Spark Connect event was dropped because the internal server address is not set.");
            return;
        }
        if (this.listenerBus() == null) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "The Spark Connect event was dropped because the listener bus has not been set.");
            return;
        }
        this.listenerBus().post((SparkListenerEvent)eventBuilder.apply((Object)this.bindingAddress()));
    }

    public String extractErrorMessage(Throwable st) {
        String message = StringUtils.abbreviate((String)st.getMessage(), (int)2048);
        return this.convertNullString(message);
    }

    public String convertNullString(String str) {
        if (str != null) {
            return str;
        }
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$startGRPCService$5(SocketAddress x$5) {
        return x$5 instanceof InetSocketAddress;
    }

    public static final /* synthetic */ Tuple2 $anonfun$startGRPCService$1(Option bindAddress$1, SparkConnectService sparkConnectService$1, Seq configuredInterceptors$1, Option protoReflectionService$1, int port) {
        NettyServerBuilder nettyServerBuilder;
        Option option = bindAddress$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            String hostname = (String)some.value();
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"start GRPC service at: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HOST$.MODULE$, (Object)hostname)}))));
            nettyServerBuilder = NettyServerBuilder.forAddress(new InetSocketAddress(hostname, port));
        } else {
            nettyServerBuilder = NettyServerBuilder.forPort(port);
        }
        NettyServerBuilder sb = nettyServerBuilder;
        sb.maxInboundMessageSize((int)BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_MAX_INBOUND_MESSAGE_SIZE()))).addService(sparkConnectService$1);
        Connect$.MODULE$.getAuthenticateToken().foreach((Function1 & Serializable)token -> (NettyServerBuilder)sb.intercept(new PreSharedKeyAuthenticationInterceptor((String)token)));
        SparkConnectInterceptorRegistry$.MODULE$.chainInterceptors(sb, (Seq<ServerInterceptor>)configuredInterceptors$1);
        protoReflectionService$1.foreach((Function1 & Serializable)service -> (NettyServerBuilder)sb.addService((BindableService)service));
        MODULE$.server_$eq(sb.build());
        MODULE$.server().start();
        MODULE$.bindingAddress_$eq((InetSocketAddress)CollectionConverters$.MODULE$.ListHasAsScala(MODULE$.server().getListenSockets()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectService$.$anonfun$startGRPCService$5(x$5))).get());
        return new Tuple2((Object)MODULE$.server(), (Object)BoxesRunTime.boxToInteger((int)MODULE$.server().getPort()));
    }

    private SparkConnectService$() {
    }

    public static final /* synthetic */ Tuple2 $anonfun$startGRPCService$1$adapted(Option bindAddress$1, SparkConnectService sparkConnectService$1, Seq configuredInterceptors$1, Option protoReflectionService$1, Object port) {
        return SparkConnectService$.$anonfun$startGRPCService$1(bindAddress$1, sparkConnectService$1, configuredInterceptors$1, protoReflectionService$1, BoxesRunTime.unboxToInt((Object)port));
    }
}

