/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.EnumSet;
import java.util.Map;
import org.apache.spark.SSLOptions;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.ui.JettyUtils;
import org.apache.spark.ui.JettyUtils$;
import org.apache.spark.ui.JettyUtils$ServletParams$;
import org.apache.spark.ui.ProxyRedirectHandler;
import org.apache.spark.ui.ServerInfo;
import org.apache.spark.util.Utils$;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import org.sparkproject.jetty.client.HttpClient;
import org.sparkproject.jetty.client.api.Response;
import org.sparkproject.jetty.client.http.HttpClientTransportOverHTTP;
import org.sparkproject.jetty.proxy.ProxyServlet;
import org.sparkproject.jetty.server.AbstractConnectionFactory;
import org.sparkproject.jetty.server.ConnectionFactory;
import org.sparkproject.jetty.server.HttpConfiguration;
import org.sparkproject.jetty.server.HttpConnectionFactory;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.SecureRequestCustomizer;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.server.ServerConnector;
import org.sparkproject.jetty.server.handler.AbstractHandler;
import org.sparkproject.jetty.server.handler.ContextHandler;
import org.sparkproject.jetty.server.handler.ContextHandlerCollection;
import org.sparkproject.jetty.server.handler.ErrorHandler;
import org.sparkproject.jetty.servlet.DefaultServlet;
import org.sparkproject.jetty.servlet.FilterHolder;
import org.sparkproject.jetty.servlet.ServletContextHandler;
import org.sparkproject.jetty.servlet.ServletHolder;
import org.sparkproject.jetty.util.ssl.SslContextFactory;
import org.sparkproject.jetty.util.thread.QueuedThreadPool;
import org.sparkproject.jetty.util.thread.ScheduledExecutorScheduler;
import org.sparkproject.jetty.util.thread.Scheduler;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.xml.Node;

public final class JettyUtils$
implements Logging {
    public static final JettyUtils$ MODULE$ = new JettyUtils$();
    private static final String SPARK_CONNECTOR_NAME;
    private static final String REDIRECT_CONNECTOR_NAME;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        SPARK_CONNECTOR_NAME = "Spark";
        REDIRECT_CONNECTOR_NAME = "HttpsRedirect";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String SPARK_CONNECTOR_NAME() {
        return SPARK_CONNECTOR_NAME;
    }

    public String REDIRECT_CONNECTOR_NAME() {
        return REDIRECT_CONNECTOR_NAME;
    }

    public JettyUtils.ServletParams<JValue> jsonResponderToServlet(Function1<HttpServletRequest, JValue> responder) {
        return new JettyUtils.ServletParams<JValue>(responder, "text/json", (Function1 & Serializable)in -> JsonMethods$.MODULE$.pretty(JsonMethods$.MODULE$.render(in, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())));
    }

    public JettyUtils.ServletParams<Seq<Node>> htmlResponderToServlet(Function1<HttpServletRequest, Seq<Node>> responder) {
        return new JettyUtils.ServletParams<Seq<Node>>(responder, "text/html", (Function1 & Serializable)in -> "<!DOCTYPE html>" + in.toString());
    }

    public JettyUtils.ServletParams<String> textResponderToServlet(Function1<HttpServletRequest, String> responder) {
        return new JettyUtils.ServletParams<Object>(responder, "text/plain", JettyUtils$ServletParams$.MODULE$.$lessinit$greater$default$3());
    }

    private <T> HttpServlet createServlet(JettyUtils.ServletParams<T> servletParams, SparkConf conf) {
        return new HttpServlet(servletParams){
            private final JettyUtils.ServletParams servletParams$1;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                try {
                    response.setContentType(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s;charset=utf-8"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.servletParams$1.contentType()})));
                    response.setStatus(200);
                    Object result = this.servletParams$1.responder().apply((Object)request);
                    response.getWriter().print((String)this.servletParams$1.extractFn().apply(result));
                }
                catch (IllegalArgumentException e) {
                    response.sendError(400, e.getMessage());
                }
                catch (Exception e) {
                    JettyUtils$.MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> JettyUtils$.MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"GET ", " failed: "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.URI$.MODULE$, (Object)request.getRequestURI())})).$plus(JettyUtils$.MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ERROR$.MODULE$, (Object)e)})))), (Throwable)e);
                    throw e;
                }
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse res) {
                res.sendError(405);
            }
            {
                this.servletParams$1 = servletParams$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$doGet$1(jakarta.servlet.http.HttpServletRequest java.lang.Exception )}, serializedLambda);
            }
        };
    }

    public <T> ServletContextHandler createServletHandler(String path, JettyUtils.ServletParams<T> servletParams, SparkConf conf, String basePath) {
        return this.createServletHandler(path, this.createServlet(servletParams, conf), basePath);
    }

    /*
     * Unable to fully structure code
     */
    public ServletContextHandler createServletHandler(String path, HttpServlet servlet, String basePath) {
        v0 = basePath;
        var5_4 = "";
        if (v0 != null ? v0.equals(var5_4) == false : var5_4 != null) ** GOTO lbl-1000
        v1 = path;
        var6_5 = "/";
        if (!(v1 != null ? v1.equals(var6_5) == false : var6_5 != null)) {
            v2 = path;
        } else lbl-1000:
        // 2 sources

        {
            v2 = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(basePath + path), "/");
        }
        prefixedPath = v2;
        contextHandler = new ServletContextHandler();
        holder = new ServletHolder((Servlet)servlet);
        contextHandler.setContextPath(prefixedPath);
        contextHandler.addServlet(holder, "/");
        return contextHandler;
    }

    public <T> String createServletHandler$default$4() {
        return "";
    }

    public ServletContextHandler createRedirectHandler(String srcPath, String destPath, Function1<HttpServletRequest, BoxedUnit> beforeRedirect, String basePath, Set<String> httpMethods) {
        String prefixedDestPath = basePath + destPath;
        HttpServlet servlet = new HttpServlet(httpMethods, beforeRedirect, prefixedDestPath){
            private final Set httpMethods$1;
            private final Function1 beforeRedirect$1;
            private final String prefixedDestPath$1;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                if (this.httpMethods$1.contains((Object)"GET")) {
                    this.doRequest(request, response);
                    return;
                }
                response.sendError(405);
            }

            public void doPost(HttpServletRequest request, HttpServletResponse response) {
                if (this.httpMethods$1.contains((Object)"POST")) {
                    this.doRequest(request, response);
                    return;
                }
                response.sendError(405);
            }

            private void doRequest(HttpServletRequest request, HttpServletResponse response) {
                this.beforeRedirect$1.apply((Object)request);
                URL requestURL = new URI(request.getRequestURL().toString()).toURL();
                String newUrl = new URL(requestURL, this.prefixedDestPath$1).toString();
                response.sendRedirect(newUrl);
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse res) {
                res.sendError(405);
            }
            {
                this.httpMethods$1 = httpMethods$1;
                this.beforeRedirect$1 = beforeRedirect$1;
                this.prefixedDestPath$1 = prefixedDestPath$1;
            }
        };
        return this.createServletHandler(srcPath, servlet, basePath);
    }

    public Function1<HttpServletRequest, BoxedUnit> createRedirectHandler$default$3() {
        return (Function1 & Serializable)x -> {
            JettyUtils$.$anonfun$createRedirectHandler$default$3$1(x);
            return BoxedUnit.UNIT;
        };
    }

    public String createRedirectHandler$default$4() {
        return "";
    }

    public Set<String> createRedirectHandler$default$5() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"GET"}));
    }

    public ServletContextHandler createStaticHandler(String resourceBase, String path) {
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setInitParameter("org.sparkproject.jetty.servlet.Default.gzip", "false");
        DefaultServlet staticHandler = new DefaultServlet();
        ServletHolder holder = new ServletHolder((Servlet)staticHandler);
        Option option = Option$.MODULE$.apply((Object)Utils$.MODULE$.getSparkClassLoader().getResource(resourceBase));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new Exception("Could not find resource path for Web UI: " + resourceBase);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        URL res = (URL)some.value();
        holder.setInitParameter("resourceBase", res.toString());
        contextHandler.setContextPath(path);
        contextHandler.addServlet(holder, "/");
        return contextHandler;
    }

    public ServletContextHandler createProxyHandler(Function1<String, Option<String>> idToUiAddress) {
        ProxyServlet servlet = new ProxyServlet(idToUiAddress){
            private final Function1 idToUiAddress$1;

            public String rewriteTarget(HttpServletRequest request) {
                String path = request.getPathInfo();
                if (path == null) {
                    return null;
                }
                int prefixTrailingSlashIndex = path.indexOf(47, 1);
                String prefix = prefixTrailingSlashIndex == -1 ? path : path.substring(0, prefixTrailingSlashIndex);
                String id = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(prefix), 1);
                return (String)((Option)this.idToUiAddress$1.apply((Object)id)).map((Function1 & Serializable)x$1 -> JettyUtils$.MODULE$.createProxyURI(prefix, (String)x$1, path, request.getQueryString())).filter((Function1 & Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)anon.3.$anonfun$rewriteTarget$2(this, uri))).map((Function1 & Serializable)x$2 -> x$2.toString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            public HttpClient newHttpClient() {
                int numSelectors = package$.MODULE$.max(1, package$.MODULE$.min(8, Runtime.getRuntime().availableProcessors() / 2));
                return new HttpClient(new HttpClientTransportOverHTTP(numSelectors));
            }

            public String filterServerResponseHeader(HttpServletRequest clientRequest, Response serverResponse, String headerName, String headerValue) {
                String newHeader;
                if (headerName.equalsIgnoreCase("location") && (newHeader = JettyUtils$.MODULE$.createProxyLocationHeader(headerValue, clientRequest, serverResponse.getRequest().getURI())) != null) {
                    return newHeader;
                }
                return super.filterServerResponseHeader(clientRequest, serverResponse, headerName, headerValue);
            }

            public static final /* synthetic */ boolean $anonfun$rewriteTarget$2(anon.3 $this, URI uri) {
                return uri != null && $this.validateDestination(uri.getHost(), uri.getPort());
            }
            {
                this.idToUiAddress$1 = idToUiAddress$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$rewriteTarget$1(java.lang.String java.lang.String jakarta.servlet.http.HttpServletRequest java.lang.String ), $anonfun$rewriteTarget$2$adapted(org.apache.spark.ui.JettyUtils$$anon$3 java.net.URI ), $anonfun$rewriteTarget$3(java.net.URI )}, serializedLambda);
            }
        };
        ServletContextHandler contextHandler = new ServletContextHandler();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        contextHandler.setContextPath("/proxy");
        contextHandler.addServlet(holder, "/*");
        return contextHandler;
    }

    public ServerInfo startJettyServer(String hostName, int port, SSLOptions sslOptions, SparkConf conf, String serverName, int poolSize) {
        ServerInfo serverInfo;
        long stopTimeout = BoxesRunTime.unboxToLong((Object)conf.get(UI$.MODULE$.UI_JETTY_STOP_TIMEOUT()));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Start Jetty ", ":", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HOST$.MODULE$, (Object)hostName), new MDC((LogKey)LogKeys.PORT$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)port))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" for ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SERVER_NAME$.MODULE$, (Object)serverName)})))));
        QueuedThreadPool pool = new QueuedThreadPool(poolSize);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(serverName))) {
            pool.setName(serverName);
        }
        pool.setDaemon(true);
        Server server = new Server(pool);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setServer(server);
        server.addBean(errorHandler);
        ContextHandlerCollection collection = new ContextHandlerCollection();
        Option option = (Option)conf.get(UI$.MODULE$.PROXY_REDIRECT_URI());
        if (option instanceof Some) {
            Some some = (Some)option;
            String proxyUri = (String)some.value();
            ProxyRedirectHandler proxyHandler = new ProxyRedirectHandler(proxyUri);
            proxyHandler.setHandler(collection);
            server.setHandler(proxyHandler);
        } else {
            server.setHandler(collection);
        }
        ScheduledExecutorScheduler serverExecutor = new ScheduledExecutorScheduler(serverName + "-JettyScheduler", true);
        try {
            server.setStopTimeout(stopTimeout);
            server.start();
            IntRef minThreads = IntRef.create((int)1);
            HttpConfiguration httpConfig = new HttpConfiguration();
            int requestHeaderSize = (int)BoxesRunTime.unboxToLong((Object)conf.get(UI$.MODULE$.UI_REQUEST_HEADER_SIZE()));
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Using requestHeaderSize: " + requestHeaderSize);
            httpConfig.setRequestHeaderSize(requestHeaderSize);
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Using setSendServerVersion: false");
            httpConfig.setSendServerVersion(false);
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Using setSendXPoweredBy: false");
            httpConfig.setSendXPoweredBy(false);
            Option securePort = sslOptions.createJettySslContextFactoryServer().map((Function1 & Serializable)factory -> BoxesRunTime.boxToInteger((int)JettyUtils$.$anonfun$startJettyServer$5(httpConfig, sslOptions, port, serverName, conf, server, serverExecutor, hostName, minThreads, factory)));
            Tuple2 tuple2 = Utils$.MODULE$.startServiceOnPort(port, (Function1 & Serializable)currentPort -> JettyUtils$.httpConnect$1(BoxesRunTime.unboxToInt((Object)currentPort), httpConfig, server, serverExecutor, hostName, minThreads), conf, serverName);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ServerConnector httpConnector = (ServerConnector)tuple2._1();
            int httpPort = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)httpConnector, (Object)BoxesRunTime.boxToInteger((int)httpPort));
            ServerConnector httpConnector2 = (ServerConnector)tuple22._1();
            int httpPort2 = tuple22._2$mcI$sp();
            Option option2 = securePort;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                int p = BoxesRunTime.unboxToInt((Object)some.value());
                httpConnector2.setName(this.REDIRECT_CONNECTOR_NAME());
                ContextHandler redirector = this.createRedirectHttpsHandler(p, "https");
                collection.addHandler(redirector);
                redirector.start();
            } else if (None$.MODULE$.equals(option2)) {
                httpConnector2.setName(this.SPARK_CONNECTOR_NAME());
            } else {
                throw new MatchError((Object)option2);
            }
            server.addConnector(httpConnector2);
            pool.setMaxThreads(package$.MODULE$.max(pool.getMaxThreads(), minThreads.elem));
            serverInfo = new ServerInfo(server, httpPort2, (Option<Object>)securePort, conf, collection);
        }
        catch (Exception e) {
            server.stop();
            if (serverExecutor.isStarted()) {
                serverExecutor.stop();
            }
            if (pool.isStarted()) {
                pool.stop();
            }
            throw e;
        }
        return serverInfo;
    }

    public String startJettyServer$default$5() {
        return "";
    }

    public int startJettyServer$default$6() {
        return 200;
    }

    private ContextHandler createRedirectHttpsHandler(int securePort, String scheme) {
        ContextHandler redirectHandler = new ContextHandler();
        redirectHandler.setContextPath("/");
        redirectHandler.setVirtualHosts(this.toVirtualHosts((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.REDIRECT_CONNECTOR_NAME()})));
        redirectHandler.setHandler(new AbstractHandler(scheme, securePort){
            private final String scheme$1;
            private final int securePort$1;

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                if (baseRequest.isSecure()) {
                    return;
                }
                String httpsURI = JettyUtils$.MODULE$.org$apache$spark$ui$JettyUtils$$createRedirectURI(this.scheme$1, this.securePort$1, baseRequest);
                response.setContentLength(0);
                response.sendRedirect(response.encodeRedirectURL(httpsURI));
                baseRequest.setHandled(true);
            }
            {
                this.scheme$1 = scheme$1;
                this.securePort$1 = securePort$1;
            }
        });
        return redirectHandler;
    }

    public URI createProxyURI(String prefix, String target, String path, String query) {
        if (!path.startsWith(prefix)) {
            return null;
        }
        StringBuilder uri = new StringBuilder(target);
        String rest = path.substring(prefix.length());
        if (!rest.isEmpty()) {
            Object object = !rest.startsWith("/") && !uri.endsWith((Iterable)Predef$.MODULE$.wrapString("/")) ? uri.append("/") : BoxedUnit.UNIT;
            v1 = uri.append(rest);
        } else {
            v1 = BoxedUnit.UNIT;
        }
        Object queryString = query == null ? "" : "?" + query;
        return URI.create(uri.toString() + (String)queryString).normalize();
    }

    public String createProxyLocationHeader(String headerValue, HttpServletRequest clientRequest, URI targetUri) {
        String toReplace = targetUri.getScheme() + "://" + targetUri.getAuthority();
        if (headerValue.startsWith(toReplace)) {
            String id = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(clientRequest.getPathInfo().substring("/proxy/".length())), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)JettyUtils$.$anonfun$createProxyLocationHeader$1(BoxesRunTime.unboxToChar((Object)x$5))));
            String headerPath = headerValue.substring(toReplace.length());
            return clientRequest.getScheme() + "://" + clientRequest.getHeader("host") + "/proxy/" + id + headerPath;
        }
        return null;
    }

    public void addFilter(ServletContextHandler handler, String filter, scala.collection.immutable.Map<String, String> params) {
        FilterHolder holder = new FilterHolder();
        holder.setClassName(filter);
        params.foreach((Function1 & Serializable)x0$1 -> {
            JettyUtils$.$anonfun$addFilter$1(holder, x0$1);
            return BoxedUnit.UNIT;
        });
        handler.addFilter(holder, "/*", EnumSet.allOf(DispatcherType.class));
    }

    private String decodeURL(String url, String encoding) {
        if (url == null) {
            return null;
        }
        return URLDecoder.decode(url, encoding);
    }

    public String org$apache$spark$ui$JettyUtils$$createRedirectURI(String scheme, int port, Request request) {
        String server = request.getServerName();
        String redirectServer = server.contains(":") && !server.startsWith("[") ? "[" + server + "]" : server;
        String authority = redirectServer + ":" + port;
        String queryEncoding = request.getQueryEncoding() != null ? request.getQueryEncoding() : "UTF-8";
        String requestURI = this.decodeURL(request.getRequestURI(), queryEncoding);
        String queryString = this.decodeURL(request.getQueryString(), queryEncoding);
        return new URI(scheme, authority, requestURI, queryString, null).toString();
    }

    public String[] toVirtualHosts(Seq<String> connectors) {
        return (String[])((IterableOnceOps)connectors.map((Function1 & Serializable)x$6 -> "@" + x$6)).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ void $anonfun$createRedirectHandler$default$3$1(HttpServletRequest x) {
    }

    private static final Tuple2 newConnector$1(ConnectionFactory[] connectionFactories, int port, Server server$1, ScheduledExecutorScheduler serverExecutor$1, String hostName$1, IntRef minThreads$1) {
        ServerConnector connector = new ServerConnector(server$1, null, (Scheduler)serverExecutor$1, null, -1, -1, connectionFactories);
        connector.setPort(port);
        connector.setHost(hostName$1);
        connector.setReuseAddress(!Utils$.MODULE$.isWindows());
        connector.setIdleTimeout(8000L);
        connector.setAcceptQueueSize(package$.MODULE$.min(connector.getAcceptors(), 8));
        connector.start();
        minThreads$1.elem += connector.getAcceptors() * 2;
        return new Tuple2((Object)connector, (Object)BoxesRunTime.boxToInteger((int)connector.getLocalPort()));
    }

    private static final Tuple2 sslConnect$1(int currentPort, ConnectionFactory[] connectionFactories$1, Server server$1, ScheduledExecutorScheduler serverExecutor$1, String hostName$1, IntRef minThreads$1) {
        return JettyUtils$.newConnector$1(connectionFactories$1, currentPort, server$1, serverExecutor$1, hostName$1, minThreads$1);
    }

    public static final /* synthetic */ int $anonfun$startJettyServer$5(HttpConfiguration httpConfig$1, SSLOptions sslOptions$1, int port$1, String serverName$1, SparkConf conf$1, Server server$1, ScheduledExecutorScheduler serverExecutor$1, String hostName$1, IntRef minThreads$1, SslContextFactory.Server factory) {
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setSniHostCheck(false);
        httpConfig$1.addCustomizer(src);
        int securePort = BoxesRunTime.unboxToInt((Object)sslOptions$1.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            if (port$1 > 0) {
                return Utils$.MODULE$.userPort(port$1, 400);
            }
            return 0;
        }));
        Object secureServerName = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(serverName$1)) ? serverName$1 + " (HTTPS)" : serverName$1;
        ConnectionFactory[] connectionFactories = AbstractConnectionFactory.getFactories(factory, new HttpConnectionFactory(httpConfig$1));
        Tuple2 tuple2 = Utils$.MODULE$.startServiceOnPort(securePort, (Function1 & Serializable)currentPort -> JettyUtils$.sslConnect$1(BoxesRunTime.unboxToInt((Object)currentPort), connectionFactories, server$1, serverExecutor$1, hostName$1, minThreads$1), conf$1, (String)secureServerName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ServerConnector connector = (ServerConnector)tuple2._1();
        int boundPort = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)connector, (Object)BoxesRunTime.boxToInteger((int)boundPort));
        ServerConnector connector2 = (ServerConnector)tuple22._1();
        int boundPort2 = tuple22._2$mcI$sp();
        connector2.setName(MODULE$.SPARK_CONNECTOR_NAME());
        server$1.addConnector(connector2);
        return boundPort2;
    }

    private static final Tuple2 httpConnect$1(int currentPort, HttpConfiguration httpConfig$1, Server server$1, ScheduledExecutorScheduler serverExecutor$1, String hostName$1, IntRef minThreads$1) {
        return JettyUtils$.newConnector$1((ConnectionFactory[])((Object[])new ConnectionFactory[]{new HttpConnectionFactory(httpConfig$1)}), currentPort, server$1, serverExecutor$1, hostName$1, minThreads$1);
    }

    public static final /* synthetic */ boolean $anonfun$createProxyLocationHeader$1(char x$5) {
        return x$5 != '/';
    }

    public static final /* synthetic */ void $anonfun$addFilter$1(FilterHolder holder$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            holder$1.setInitParameter(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private JettyUtils$() {
    }
}

