/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.api.java.JavaFutureAction;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;

public final class JavaStatusTrackerDemo {
    public static final String APP_NAME = "JavaStatusAPIDemo";

    public static void main(String[] args) throws Exception {
        SparkSession spark = SparkSession.builder().appName(APP_NAME).getOrCreate();
        JavaSparkContext jsc = new JavaSparkContext(spark.sparkContext());
        JavaRDD rdd = jsc.parallelize(Arrays.asList(1, 2, 3, 4, 5), 5).map(new IdentityWithDelay());
        JavaFutureAction jobFuture = rdd.collectAsync();
        while (!jobFuture.isDone()) {
            Thread.sleep(1000L);
            List jobIds = jobFuture.jobIds();
            if (jobIds.isEmpty()) continue;
            int currentJobId = (Integer)jobIds.get(jobIds.size() - 1);
            SparkJobInfo jobInfo = jsc.statusTracker().getJobInfo(currentJobId);
            SparkStageInfo stageInfo = jsc.statusTracker().getStageInfo(jobInfo.stageIds()[0]);
            System.out.println(stageInfo.numTasks() + " tasks total: " + stageInfo.numActiveTasks() + " active, " + stageInfo.numCompletedTasks() + " complete");
        }
        System.out.println("Job results are: " + String.valueOf(jobFuture.get()));
        spark.stop();
    }

    public static final class IdentityWithDelay<T>
    implements Function<T, T> {
        public T call(T x) throws Exception {
            Thread.sleep(2000L);
            return x;
        }
    }
}

