/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.schema.Schema;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttrBundleParam
extends Expression {
    private final ImmutableSet<String> includeAttrs;
    private final ImmutableMap<AttributeValidator, Attribute> attrs;
    private final ImmutableList<String> subBundles;

    public AttrBundleParam(Node fromNode, Schema schema, Set<String> includeAttrs, Map<AttributeValidator, Attribute> attrs, List<String> subBundles) {
        super(fromNode, schema);
        this.includeAttrs = ImmutableSet.copyOf(includeAttrs);
        this.attrs = ImmutableMap.copyOf(attrs);
        this.subBundles = ImmutableList.copyOf(subBundles);
    }

    public AttrBundleParam withAttrs(Map<AttributeValidator, Attribute> newAttrs) {
        return new AttrBundleParam(this, this.getSchema(), this.includeAttrs, newAttrs, this.subBundles);
    }

    public AttrBundleParam transform(ExhaustiveExpressionVisitor visitor) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.attrs.entrySet()) {
            builder.put(entry.getKey(), visitor.visitAttribute((Attribute)entry.getValue()));
        }
        return this.withAttrs(builder.build());
    }

    public Map<AttributeValidator, Attribute> getAttrs() {
        return this.attrs;
    }

    public Set<String> getIncludeAttrs() {
        return this.includeAttrs;
    }

    public List<String> getSubBundles() {
        return this.subBundles;
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitAttrBundleParam(this);
    }

    public String toString() {
        return "AttrBundleParam()@" + this.getSourcePosition();
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof AttrBundleParam && this.equals((AttrBundleParam)that);
    }

    public boolean equals(AttrBundleParam that) {
        return this.equalsExpression(that) && Objects.equal(this.getIncludeAttrs(), that.getIncludeAttrs()) && Objects.equal(this.getAttrs(), that.getAttrs()) && Objects.equal(this.getSubBundles(), that.getSubBundles());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getIncludeAttrs(), this.getAttrs(), this.getSubBundles());
    }
}

