/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.Serializable;
import java.util.Random;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.ObjectUtils;
import net.sf.jasperreports.engine.util.StyleResolver;

public abstract class JRTemplateElement
implements JRCommonElement,
Serializable,
JRPropertiesHolder,
Deduplicable {
    private static final long serialVersionUID = 10200L;
    private static final Random randomId = new Random();
    private String key;
    private ModeEnum mode;
    private Color forecolor;
    private Color backcolor;
    protected JROrigin origin;
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRStyle parentStyle;
    private final String id;
    private JRPropertiesMap propertiesMap;

    protected JRTemplateElement(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        this.origin = origin;
        this.defaultStyleProvider = defaultStyleProvider;
        this.id = this.createId();
    }

    protected JRTemplateElement(String id) {
        this.id = id;
    }

    private String createId() {
        return System.identityHashCode(this) + "_" + System.currentTimeMillis() + "_" + randomId.nextInt();
    }

    public void setElement(JRElement element) {
        this.parentStyle = element.getStyle();
        this.key = element.getKey();
        this.mode = element.getOwnMode();
        this.forecolor = element.getOwnForecolor();
        this.backcolor = element.getOwnBackcolor();
    }

    public JROrigin getOrigin() {
        return this.origin;
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    protected StyleResolver getStyleResolver() {
        if (this.getDefaultStyleProvider() != null) {
            return this.getDefaultStyleProvider().getStyleResolver();
        }
        return StyleResolver.getInstance();
    }

    @Override
    public JRStyle getStyle() {
        return this.parentStyle;
    }

    protected JRStyle getBaseStyle() {
        if (this.parentStyle != null) {
            return this.parentStyle;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultStyle();
        }
        return null;
    }

    @Override
    public int getWidth() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHeight() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModeEnum getMode() {
        return this.getStyleResolver().getMode(this, ModeEnum.OPAQUE);
    }

    @Override
    public ModeEnum getOwnMode() {
        return this.mode;
    }

    @Override
    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    @Override
    public Color getForecolor() {
        return this.getStyleResolver().getForecolor(this);
    }

    @Override
    public Color getOwnForecolor() {
        return this.forecolor;
    }

    @Override
    public void setForecolor(Color forecolor) {
        this.forecolor = forecolor;
    }

    @Override
    public Color getBackcolor() {
        return this.getStyleResolver().getBackcolor(this);
    }

    @Override
    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    @Override
    public void setBackcolor(Color backcolor) {
        this.backcolor = backcolor;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getStyleNameReference() {
        return null;
    }

    @Override
    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            this.propertiesMap = new JRPropertiesMap();
        }
        return this.propertiesMap;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    public void setStyle(JRStyle style) {
        this.parentStyle = style;
    }

    protected void addTemplateHash(ObjectUtils.HashCode hash) {
        hash.addIdentity(this.defaultStyleProvider == null ? null : this.defaultStyleProvider.getDefaultStyle());
        hash.addIdentity(this.parentStyle);
        hash.add(this.origin);
        hash.add(this.key);
        hash.add(this.mode);
        hash.add(this.forecolor);
        hash.add(this.backcolor);
        hash.add(this.propertiesMap);
    }

    protected boolean templateIdentical(JRTemplateElement template) {
        return (this.defaultStyleProvider == null ? template.defaultStyleProvider == null : template.defaultStyleProvider != null && ObjectUtils.equalsIdentity(this.defaultStyleProvider.getDefaultStyle(), template.defaultStyleProvider.getDefaultStyle())) && ObjectUtils.equalsIdentity(this.parentStyle, template.parentStyle) && ObjectUtils.equals(this.origin, template.origin) && ObjectUtils.equals(this.key, template.key) && ObjectUtils.equals(this.mode, template.mode) && ObjectUtils.equals(this.forecolor, template.forecolor) && ObjectUtils.equals(this.backcolor, template.backcolor) && ObjectUtils.equals(this.propertiesMap, template.propertiesMap);
    }

    public void populateStyle() {
        this.mode = this.getMode();
        this.forecolor = this.getForecolor();
        this.backcolor = this.getBackcolor();
    }
}

