/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils.stats;

import java.util.concurrent.atomic.LongAdder;

public class TransformStatistics {
    private static final LongAdder encoderCount = new LongAdder();
    private static final LongAdder recodeBuildTime = new LongAdder();
    private static final LongAdder binningBuildTime = new LongAdder();
    private static final LongAdder imputeBuildTime = new LongAdder();
    private static final LongAdder recodeApplyTime = new LongAdder();
    private static final LongAdder dummyCodeApplyTime = new LongAdder();
    private static final LongAdder passThroughApplyTime = new LongAdder();
    private static final LongAdder featureHashingApplyTime = new LongAdder();
    private static final LongAdder binningApplyTime = new LongAdder();
    private static final LongAdder UDFApplyTime = new LongAdder();
    private static final LongAdder omitApplyTime = new LongAdder();
    private static final LongAdder imputeApplyTime = new LongAdder();
    private static final LongAdder outMatrixPreProcessingTime = new LongAdder();
    private static final LongAdder outMatrixPostProcessingTime = new LongAdder();
    private static final LongAdder mapSizeEstimationTime = new LongAdder();

    public static void incEncoderCount(long encoders) {
        encoderCount.add(encoders);
    }

    public static void incRecodeApplyTime(long t) {
        recodeApplyTime.add(t);
    }

    public static void incDummyCodeApplyTime(long t) {
        dummyCodeApplyTime.add(t);
    }

    public static void incBinningApplyTime(long t) {
        binningApplyTime.add(t);
    }

    public static void incUDFApplyTime(long t) {
        UDFApplyTime.add(t);
    }

    public static void incPassThroughApplyTime(long t) {
        passThroughApplyTime.add(t);
    }

    public static void incFeatureHashingApplyTime(long t) {
        featureHashingApplyTime.add(t);
    }

    public static void incOmitApplyTime(long t) {
        omitApplyTime.add(t);
    }

    public static void incImputeApplyTime(long t) {
        imputeApplyTime.add(t);
    }

    public static void incRecodeBuildTime(long t) {
        recodeBuildTime.add(t);
    }

    public static void incBinningBuildTime(long t) {
        binningBuildTime.add(t);
    }

    public static void incImputeBuildTime(long t) {
        imputeBuildTime.add(t);
    }

    public static void incOutMatrixPreProcessingTime(long t) {
        outMatrixPreProcessingTime.add(t);
    }

    public static void incOutMatrixPostProcessingTime(long t) {
        outMatrixPostProcessingTime.add(t);
    }

    public static void incMapSizeEstimationTime(long t) {
        mapSizeEstimationTime.add(t);
    }

    public static long getEncodeBuildTime() {
        return binningBuildTime.longValue() + imputeBuildTime.longValue() + recodeBuildTime.longValue();
    }

    public static long getEncodeApplyTime() {
        return dummyCodeApplyTime.longValue() + binningApplyTime.longValue() + featureHashingApplyTime.longValue() + passThroughApplyTime.longValue() + recodeApplyTime.longValue() + UDFApplyTime.longValue() + omitApplyTime.longValue() + imputeApplyTime.longValue();
    }

    public static void reset() {
        encoderCount.reset();
        recodeBuildTime.reset();
        binningBuildTime.reset();
        imputeBuildTime.reset();
        recodeApplyTime.reset();
        dummyCodeApplyTime.reset();
        passThroughApplyTime.reset();
        featureHashingApplyTime.reset();
        binningApplyTime.reset();
        UDFApplyTime.reset();
        omitApplyTime.reset();
        imputeApplyTime.reset();
        outMatrixPreProcessingTime.reset();
        outMatrixPostProcessingTime.reset();
        mapSizeEstimationTime.reset();
    }

    public static String displayStatistics() {
        if (encoderCount.longValue() > 0L) {
            StringBuilder sb = new StringBuilder();
            sb.append("TransformEncode num. encoders:\t").append(encoderCount.longValue()).append("\n");
            sb.append("TransformEncode build time:\t").append(String.format("%.3f", (double)TransformStatistics.getEncodeBuildTime() * 1.0E-9)).append(" sec.\n");
            if (recodeBuildTime.longValue() > 0L) {
                sb.append("\tRecode build time:\t").append(String.format("%.3f", (double)recodeBuildTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            if (binningBuildTime.longValue() > 0L) {
                sb.append("\tBinning build time:\t").append(String.format("%.3f", (double)binningBuildTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            if (imputeBuildTime.longValue() > 0L) {
                sb.append("\tImpute build time:\t").append(String.format("%.3f", (double)imputeBuildTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            sb.append("TransformEncode apply time:\t").append(String.format("%.3f", (double)TransformStatistics.getEncodeApplyTime() * 1.0E-9)).append(" sec.\n");
            if (recodeApplyTime.longValue() > 0L) {
                sb.append("\tRecode apply time:\t").append(String.format("%.3f", (double)recodeApplyTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            if (binningApplyTime.longValue() > 0L) {
                sb.append("\tBinning apply time:\t").append(String.format("%.3f", (double)binningApplyTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            if (dummyCodeApplyTime.longValue() > 0L) {
                sb.append("\tDummyCode apply time:\t").append(String.format("%.3f", (double)dummyCodeApplyTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            if (featureHashingApplyTime.longValue() > 0L) {
                sb.append("\tHashing apply time:\t").append(String.format("%.3f", (double)featureHashingApplyTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            if (passThroughApplyTime.longValue() > 0L) {
                sb.append("\tPassThrough apply time:\t").append(String.format("%.3f", (double)passThroughApplyTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            if (UDFApplyTime.longValue() > 0L) {
                sb.append("\tUDF apply time:\t").append(String.format("%.3f", (double)UDFApplyTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            if (omitApplyTime.longValue() > 0L) {
                sb.append("\tOmit apply time:\t").append(String.format("%.3f", (double)omitApplyTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            if (imputeApplyTime.longValue() > 0L) {
                sb.append("\tImpute apply time:\t").append(String.format("%.3f", (double)imputeApplyTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            sb.append("TransformEncode PreProc. time:\t").append(String.format("%.3f", (double)outMatrixPreProcessingTime.longValue() * 1.0E-9)).append(" sec.\n");
            sb.append("TransformEncode PostProc. time:\t").append(String.format("%.3f", (double)outMatrixPostProcessingTime.longValue() * 1.0E-9)).append(" sec.\n");
            if (mapSizeEstimationTime.longValue() > 0L) {
                sb.append("TransformEncode SizeEst. time:\t").append(String.format("%.3f", (double)mapSizeEstimationTime.longValue() * 1.0E-9)).append(" sec.\n");
            }
            return sb.toString();
        }
        return "";
    }
}

