/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.sample;

public interface ShlosserEstimator {
    public static int distinctCount(long numVals, int[] freqCounts, long nRows, long sampleSize) {
        if (freqCounts[0] == 0) {
            return (int)numVals;
        }
        double q = (double)sampleSize / (double)nRows;
        double oneMinusQ = 1.0 - q;
        double numberSum = 0.0;
        double denomSum = 0.0;
        double p1 = 0.0;
        int i = 0;
        while (i < freqCounts.length) {
            p1 = Math.pow(oneMinusQ, i) * (double)freqCounts[i];
            numberSum += p1 * oneMinusQ;
            denomSum += (double)(++i) * q * p1;
        }
        return (int)Math.round((double)numVals + (double)freqCounts[0] * numberSum / denomSum);
    }
}

