/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.extensions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.Token;
import org.apache.uima.UimaContext;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.AbstractStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.extensions.IRutaActionExtension;
import org.apache.uima.ruta.extensions.IRutaAnnotationFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaBlockExtension;
import org.apache.uima.ruta.extensions.IRutaBooleanFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaConditionExtension;
import org.apache.uima.ruta.extensions.IRutaExtension;
import org.apache.uima.ruta.extensions.IRutaNumberFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaStringFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaTypeFunctionExtension;
import org.apache.uima.ruta.extensions.RutaParseException;

public class RutaExternalFactory {
    private Map<String, IRutaConditionExtension> conditionExtensions = new HashMap<String, IRutaConditionExtension>();
    private Map<String, IRutaActionExtension> actionExtensions = new HashMap<String, IRutaActionExtension>();
    private Map<String, IRutaTypeFunctionExtension> typeFunctionExtensions;
    private Map<String, IRutaAnnotationFunctionExtension> annotationFunctionExtensions;
    private Map<String, IRutaBooleanFunctionExtension> booleanFunctionExtensions = new HashMap<String, IRutaBooleanFunctionExtension>();
    private Map<String, IRutaStringFunctionExtension> stringFunctionExtensions = new HashMap<String, IRutaStringFunctionExtension>();
    private Map<String, IRutaNumberFunctionExtension> numberFunctionExtensions = new HashMap<String, IRutaNumberFunctionExtension>();
    private Map<String, IRutaBlockExtension> blockExtensions;
    private UimaContext context;

    public RutaExternalFactory() {
        this.typeFunctionExtensions = new HashMap<String, IRutaTypeFunctionExtension>();
        this.annotationFunctionExtensions = new HashMap<String, IRutaAnnotationFunctionExtension>();
        this.blockExtensions = new HashMap<String, IRutaBlockExtension>();
    }

    public AbstractRutaCondition createExternalCondition(Token id, List<RutaExpression> args) throws RutaParseException {
        String name = id.getText();
        IRutaConditionExtension extension = this.conditionExtensions.get(name);
        if (extension != null) {
            return extension.createCondition(name, args);
        }
        return null;
    }

    public AbstractRutaAction createExternalAction(Token id, List<RutaExpression> args) throws RutaParseException {
        String name = id.getText();
        IRutaActionExtension extension = this.actionExtensions.get(name);
        if (extension != null) {
            return extension.createAction(name, args);
        }
        return null;
    }

    public ITypeExpression createExternalTypeFunction(Token id, List<RutaExpression> args) throws RutaParseException {
        String name = id.getText();
        IRutaTypeFunctionExtension extension = this.typeFunctionExtensions.get(name);
        if (extension != null) {
            return extension.createTypeFunction(name, args);
        }
        return null;
    }

    public IAnnotationExpression createExternalAnnotationFunction(Token id, List<RutaExpression> args) throws RutaParseException {
        String name = id.getText();
        IRutaAnnotationFunctionExtension extension = this.annotationFunctionExtensions.get(name);
        if (extension != null) {
            return extension.createAnnotationFunction(name, args);
        }
        return null;
    }

    public IBooleanExpression createExternalBooleanFunction(Token id, List<RutaExpression> args) throws RutaParseException {
        String name = id.getText();
        IRutaBooleanFunctionExtension extension = this.booleanFunctionExtensions.get(name);
        if (extension != null) {
            return extension.createBooleanFunction(name, args);
        }
        return null;
    }

    public AbstractStringExpression createExternalStringFunction(Token id, List<RutaExpression> args) throws RutaParseException {
        String name = id.getText();
        IRutaStringFunctionExtension extension = this.stringFunctionExtensions.get(name);
        if (extension != null) {
            return extension.createStringFunction(name, args);
        }
        return null;
    }

    public INumberExpression createExternalNumberFunction(Token id, List<RutaExpression> args) throws RutaParseException {
        String name = id.getText();
        IRutaNumberFunctionExtension extension = this.numberFunctionExtensions.get(name);
        if (extension != null) {
            return extension.createNumberFunction(name, args);
        }
        return null;
    }

    public RutaBlock createExternalBlock(Token type, List<RutaExpression> args, RutaBlock env) throws RutaParseException {
        if (type == null) {
            return null;
        }
        String t = type.getText();
        IRutaBlockExtension extension = this.blockExtensions.get(t);
        if (extension != null) {
            RutaBlock rutaBlock = extension.createBlock(t, args, env);
            rutaBlock.setContext(this.context);
            return rutaBlock;
        }
        return null;
    }

    public void addExtension(String id, IRutaExtension extension) {
        if (extension instanceof IRutaActionExtension) {
            this.addActionExtension(id, (IRutaActionExtension)extension);
        } else if (extension instanceof IRutaConditionExtension) {
            this.addConditionExtension(id, (IRutaConditionExtension)extension);
        } else if (extension instanceof IRutaBooleanFunctionExtension) {
            this.addBooleanFunctionExtension(id, (IRutaBooleanFunctionExtension)extension);
        } else if (extension instanceof IRutaStringFunctionExtension) {
            this.addStringFunctionExtension(id, (IRutaStringFunctionExtension)extension);
        } else if (extension instanceof IRutaNumberFunctionExtension) {
            this.addNumberFunctionExtension(id, (IRutaNumberFunctionExtension)extension);
        } else if (extension instanceof IRutaTypeFunctionExtension) {
            this.addTypeFunctionExtension(id, (IRutaTypeFunctionExtension)extension);
        } else if (extension instanceof IRutaBlockExtension) {
            this.addBlockExtension(id, (IRutaBlockExtension)extension);
        }
    }

    public void addConditionExtension(String id, IRutaConditionExtension extension) {
        this.conditionExtensions.put(id, extension);
    }

    public void addActionExtension(String id, IRutaActionExtension extension) {
        this.actionExtensions.put(id, extension);
    }

    public void addNumberFunctionExtension(String id, IRutaNumberFunctionExtension extension) {
        this.numberFunctionExtensions.put(id, extension);
    }

    public void addBooleanFunctionExtension(String id, IRutaBooleanFunctionExtension extension) {
        this.booleanFunctionExtensions.put(id, extension);
    }

    public void addStringFunctionExtension(String id, IRutaStringFunctionExtension extension) {
        this.stringFunctionExtensions.put(id, extension);
    }

    public void addTypeFunctionExtension(String id, IRutaTypeFunctionExtension extension) {
        this.typeFunctionExtensions.put(id, extension);
    }

    public void addBlockExtension(String id, IRutaBlockExtension extension) {
        this.blockExtensions.put(id, extension);
    }

    public boolean isInitialized() {
        return !this.actionExtensions.isEmpty() || !this.conditionExtensions.isEmpty() || !this.booleanFunctionExtensions.isEmpty() || !this.numberFunctionExtensions.isEmpty() || !this.stringFunctionExtensions.isEmpty() || !this.typeFunctionExtensions.isEmpty();
    }

    public Map<String, IRutaNumberFunctionExtension> getNumberFunctionExtensions() {
        return this.numberFunctionExtensions;
    }

    public void setNumberFunctionExtensions(Map<String, IRutaNumberFunctionExtension> numberFunctionExtensions) {
        this.numberFunctionExtensions = numberFunctionExtensions;
    }

    public Map<String, IRutaStringFunctionExtension> getStringFunctionExtensions() {
        return this.stringFunctionExtensions;
    }

    public void setStringFunctionExtensions(Map<String, IRutaStringFunctionExtension> stringFunctionExtensions) {
        this.stringFunctionExtensions = stringFunctionExtensions;
    }

    public Map<String, IRutaBooleanFunctionExtension> getBooleanFunctionExtensions() {
        return this.booleanFunctionExtensions;
    }

    public void setBooleanFunctionExtensions(Map<String, IRutaBooleanFunctionExtension> booleanFunctionExtensions) {
        this.booleanFunctionExtensions = booleanFunctionExtensions;
    }

    public Map<String, IRutaTypeFunctionExtension> getTypeFunctionExtensions() {
        return this.typeFunctionExtensions;
    }

    public void setTypeFunctionExtensions(Map<String, IRutaTypeFunctionExtension> typeFunctionExtensions) {
        this.typeFunctionExtensions = typeFunctionExtensions;
    }

    public Map<String, IRutaAnnotationFunctionExtension> getAnnotationFunctionExtensions() {
        return this.annotationFunctionExtensions;
    }

    public void setAnnotationFunctionExtensions(Map<String, IRutaAnnotationFunctionExtension> annotationFunctionExtensions) {
        this.annotationFunctionExtensions = annotationFunctionExtensions;
    }

    public Map<String, IRutaActionExtension> getActionExtensions() {
        return this.actionExtensions;
    }

    public void setActionExtensions(Map<String, IRutaActionExtension> actionExtensions) {
        this.actionExtensions = actionExtensions;
    }

    public Map<String, IRutaConditionExtension> getConditionExtensions() {
        return this.conditionExtensions;
    }

    public void setConditionExtensions(Map<String, IRutaConditionExtension> conditionExtensions) {
        this.conditionExtensions = conditionExtensions;
    }

    public Map<String, IRutaBlockExtension> getBlockExtensions() {
        return this.blockExtensions;
    }

    public void setBlockExtensions(Map<String, IRutaBlockExtension> blockExtensions) {
        this.blockExtensions = blockExtensions;
    }

    public UimaContext getContext() {
        return this.context;
    }

    public void setContext(UimaContext context) {
        this.context = context;
    }
}

