/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.contextmenu;

import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

abstract class TypeMenu
extends ContributionItem {
    private Type mParentType;
    private TypeSystem mTypeSystem;

    TypeMenu(Type parentType, TypeSystem typeSystem) {
        this.mParentType = parentType;
        this.mTypeSystem = typeSystem;
    }

    public void fill(Menu menu, int index) {
        this.fillTypeMenu(this.mParentType, menu, false);
    }

    private void fillTypeMenu(Type parentType, Menu parentMenu, boolean isParentIncluded) {
        List childs = this.mTypeSystem.getDirectSubtypes(parentType);
        if (childs.size() != 0) {
            Menu newSubMenu;
            if (isParentIncluded) {
                MenuItem subMenuItem = new MenuItem(parentMenu, 64);
                subMenuItem.setText(parentType.getName());
                newSubMenu = new Menu(subMenuItem);
                subMenuItem.setMenu(newSubMenu);
            } else {
                newSubMenu = parentMenu;
            }
            this.insertAction(parentType, newSubMenu);
            for (Type child : childs) {
                this.fillTypeMenu(child, newSubMenu, true);
            }
        } else {
            this.insertAction(parentType, parentMenu);
        }
    }

    protected abstract void insertAction(Type var1, Menu var2);
}

