/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.config;

import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uniffle.common.config.Reconfigurable;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReconfigurableBase
implements Reconfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigurableBase.class);
    public static final String RECONFIGURABLE_FILE_NAME = "reconfigurable.file.name";
    private final RssConf rssConf;
    private final ScheduledExecutorService scheduledExecutorService;
    private final long checkIntervalSec;
    private final AtomicLong lastModify = new AtomicLong(0L);

    public ReconfigurableBase(RssConf rssConf) {
        this.rssConf = rssConf;
        this.scheduledExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor("ReconfigurableThread");
        this.checkIntervalSec = rssConf.getLong(RssBaseConf.RSS_RECONFIGURE_INTERVAL_SEC);
    }

    public void startReconfigureThread() {
        this.scheduledExecutorService.scheduleAtFixedRate(this::checkConfiguration, this.checkIntervalSec, this.checkIntervalSec, TimeUnit.SECONDS);
    }

    public void stopReconfigureThread() {
        this.scheduledExecutorService.shutdownNow();
    }

    private void checkConfiguration() {
        String fileName = this.rssConf.getString(RECONFIGURABLE_FILE_NAME, "");
        if (fileName.isEmpty()) {
            LOG.warn("Config file name isn't set, we skip checking");
            return;
        }
        File configFile = new File(fileName);
        if (!configFile.exists()) {
            LOG.warn("Config file doesn't exist, we skip checking");
            return;
        }
        long newLastModify = configFile.lastModified();
        if (this.lastModify.get() == 0L) {
            this.lastModify.set(newLastModify);
            return;
        }
        if (newLastModify != this.lastModify.get()) {
            LOG.warn("Server detect the modification of file {}, we start to reconfigure", (Object)fileName);
            this.lastModify.set(newLastModify);
            this.reconfigure(this.reloadConfiguration());
        }
    }

    protected abstract RssConf reloadConfiguration();
}

