/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RequestMessage;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.io.netty.buffer.ByteBuf;

public class GetLocalShuffleIndexRequest
extends RequestMessage {
    private String appId;
    private int shuffleId;
    private int partitionId;
    private int partitionNumPerRange;
    private int partitionNum;

    public GetLocalShuffleIndexRequest(long requestId, String appId, int shuffleId, int partitionId, int partitionNumPerRange, int partitionNum) {
        super(requestId);
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.partitionNumPerRange = partitionNumPerRange;
        this.partitionNum = partitionNum;
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_LOCAL_SHUFFLE_INDEX_REQUEST;
    }

    @Override
    public int encodedLength() {
        return 8 + ByteBufUtils.encodedLength(this.appId) + 16;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.getRequestId());
        ByteBufUtils.writeLengthAndString(buf, this.appId);
        buf.writeInt(this.shuffleId);
        buf.writeInt(this.partitionId);
        buf.writeInt(this.partitionNumPerRange);
        buf.writeInt(this.partitionNum);
    }

    public static GetLocalShuffleIndexRequest decode(ByteBuf byteBuf) {
        long requestId = byteBuf.readLong();
        String appId = ByteBufUtils.readLengthAndString(byteBuf);
        int shuffleId = byteBuf.readInt();
        int partitionId = byteBuf.readInt();
        int partitionNumPerRange = byteBuf.readInt();
        int partitionNum = byteBuf.readInt();
        return new GetLocalShuffleIndexRequest(requestId, appId, shuffleId, partitionId, partitionNumPerRange, partitionNum);
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public int getPartitionNumPerRange() {
        return this.partitionNumPerRange;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }
}

