/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.SortWriteBuffer;
import org.apache.hadoop.mapreduce.RssMRUtils;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.response.SendShuffleDataResult;
import org.apache.uniffle.com.google.common.collect.Lists;
import org.apache.uniffle.com.google.common.collect.Maps;
import org.apache.uniffle.com.google.common.collect.Sets;
import org.apache.uniffle.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.compression.Codec;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.ChecksumUtils;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortWriteBufferManager<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(SortWriteBufferManager.class);
    private final long maxMemSize;
    private final Map<Integer, SortWriteBuffer<K, V>> buffers = JavaUtils.newConcurrentMap();
    private final Map<Integer, Integer> partitionToSeqNo = Maps.newHashMap();
    private final Counters.Counter mapOutputByteCounter;
    private final Counters.Counter mapOutputRecordCounter;
    private long uncompressedDataLen = 0L;
    private long compressTime = 0L;
    private final long taskAttemptId;
    private final AtomicLong memoryUsedSize = new AtomicLong(0L);
    private final int batch;
    private final AtomicLong inSendListBytes = new AtomicLong(0L);
    private final Map<Integer, List<ShuffleServerInfo>> partitionToServers;
    private final double memoryThreshold;
    private final double sendThreshold;
    private final ReentrantLock memoryLock = new ReentrantLock();
    private final Condition full = this.memoryLock.newCondition();
    private final Serializer<K> keySerializer;
    private final Serializer<V> valSerializer;
    private final RawComparator<K> comparator;
    private final Set<Long> successBlockIds;
    private final Set<Long> failedBlockIds;
    private final List<SortWriteBuffer<K, V>> waitSendBuffers = Lists.newLinkedList();
    private final String appId;
    private final ShuffleWriteClient shuffleWriteClient;
    private final long sendCheckTimeout;
    private final long sendCheckInterval;
    private final Set<Long> allBlockIds = Sets.newConcurrentHashSet();
    private final int bitmapSplitNum;
    private final Map<Integer, List<Long>> partitionToBlocks = JavaUtils.newConcurrentMap();
    private final long maxSegmentSize;
    private final boolean isMemoryShuffleEnabled;
    private final int numMaps;
    private long copyTime = 0L;
    private long sortTime = 0L;
    private final long maxBufferSize;
    private final ExecutorService sendExecutorService;
    private final RssConf rssConf;
    private final Codec codec;

    public SortWriteBufferManager(long maxMemSize, long taskAttemptId, int batch, Serializer<K> keySerializer, Serializer<V> valSerializer, RawComparator<K> comparator, double memoryThreshold, String appId, ShuffleWriteClient shuffleWriteClient, long sendCheckInterval, long sendCheckTimeout, Map<Integer, List<ShuffleServerInfo>> partitionToServers, Set<Long> successBlockIds, Set<Long> failedBlockIds, Counters.Counter mapOutputByteCounter, Counters.Counter mapOutputRecordCounter, int bitmapSplitNum, long maxSegmentSize, int numMaps, boolean isMemoryShuffleEnabled, int sendThreadNum, double sendThreshold, long maxBufferSize, RssConf rssConf) {
        this.maxMemSize = maxMemSize;
        this.taskAttemptId = taskAttemptId;
        this.batch = batch;
        this.keySerializer = keySerializer;
        this.valSerializer = valSerializer;
        this.comparator = comparator;
        this.memoryThreshold = memoryThreshold;
        this.appId = appId;
        this.shuffleWriteClient = shuffleWriteClient;
        this.sendCheckInterval = sendCheckInterval;
        this.sendCheckTimeout = sendCheckTimeout;
        this.partitionToServers = partitionToServers;
        this.successBlockIds = successBlockIds;
        this.failedBlockIds = failedBlockIds;
        this.mapOutputByteCounter = mapOutputByteCounter;
        this.mapOutputRecordCounter = mapOutputRecordCounter;
        this.bitmapSplitNum = bitmapSplitNum;
        this.maxSegmentSize = maxSegmentSize;
        this.numMaps = numMaps;
        this.isMemoryShuffleEnabled = isMemoryShuffleEnabled;
        this.sendThreshold = sendThreshold;
        this.maxBufferSize = maxBufferSize;
        this.sendExecutorService = ThreadUtils.getDaemonFixedThreadPool(sendThreadNum, "send-thread");
        this.rssConf = rssConf;
        this.codec = Codec.newInstance(rssConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(int partitionId, K key, V value) throws IOException, InterruptedException {
        this.memoryLock.lock();
        try {
            while (this.memoryUsedSize.get() > this.maxMemSize) {
                LOG.warn("memoryUsedSize {} is more than {}, inSendListBytes {}", new Object[]{this.memoryUsedSize, this.maxMemSize, this.inSendListBytes});
                this.full.await();
            }
        }
        finally {
            this.memoryLock.unlock();
        }
        this.checkFailedBlocks();
        this.buffers.computeIfAbsent(partitionId, k -> {
            SortWriteBuffer<K, V> sortWriterBuffer = new SortWriteBuffer<K, V>(partitionId, this.comparator, this.maxSegmentSize, this.keySerializer, this.valSerializer);
            this.waitSendBuffers.add(sortWriterBuffer);
            return sortWriterBuffer;
        });
        SortWriteBuffer<K, V> buffer = this.buffers.get(partitionId);
        long length = buffer.addRecord(key, value);
        if (length > this.maxMemSize) {
            throw new RssException("record is too big");
        }
        LOG.debug("memoryUsedSize {} increase {}", (Object)this.memoryUsedSize, (Object)length);
        this.memoryUsedSize.addAndGet(length);
        if ((long)buffer.getDataLength() > this.maxBufferSize) {
            if (this.waitSendBuffers.remove(buffer)) {
                this.sendBufferToServers(buffer);
            } else {
                LOG.error("waitSendBuffers don't contain buffer {}", buffer);
            }
        }
        if ((double)this.memoryUsedSize.get() > (double)this.maxMemSize * this.memoryThreshold && (double)this.inSendListBytes.get() <= (double)this.maxMemSize * this.sendThreshold) {
            this.sendBuffersToServers();
        }
        this.mapOutputRecordCounter.increment(1L);
        this.mapOutputByteCounter.increment(length);
    }

    private void sendBufferToServers(SortWriteBuffer<K, V> buffer) {
        ArrayList<ShuffleBlockInfo> shuffleBlocks = Lists.newArrayList();
        this.prepareBufferForSend(shuffleBlocks, buffer);
        this.sendShuffleBlocks(shuffleBlocks);
    }

    void sendBuffersToServers() {
        this.waitSendBuffers.sort(new Comparator<SortWriteBuffer<K, V>>(){

            @Override
            public int compare(SortWriteBuffer<K, V> o1, SortWriteBuffer<K, V> o2) {
                return o2.getDataLength() - o1.getDataLength();
            }
        });
        int sendSize = Math.min(this.batch, this.waitSendBuffers.size());
        Iterator<SortWriteBuffer<K, V>> iterator = this.waitSendBuffers.iterator();
        ArrayList<ShuffleBlockInfo> shuffleBlocks = Lists.newArrayList();
        for (int index = 0; iterator.hasNext() && index < sendSize; ++index) {
            SortWriteBuffer<K, V> buffer = iterator.next();
            this.prepareBufferForSend(shuffleBlocks, buffer);
            iterator.remove();
        }
        this.sendShuffleBlocks(shuffleBlocks);
    }

    private void prepareBufferForSend(List<ShuffleBlockInfo> shuffleBlocks, SortWriteBuffer buffer) {
        this.buffers.remove(buffer.getPartitionId());
        ShuffleBlockInfo block = this.createShuffleBlock(buffer);
        buffer.clear();
        shuffleBlocks.add(block);
        this.allBlockIds.add(block.getBlockId());
        this.partitionToBlocks.computeIfAbsent(block.getPartitionId(), key -> Lists.newArrayList());
        this.partitionToBlocks.get(block.getPartitionId()).add(block.getBlockId());
    }

    private void sendShuffleBlocks(final List<ShuffleBlockInfo> shuffleBlocks) {
        this.sendExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long size = 0L;
                try {
                    for (ShuffleBlockInfo block : shuffleBlocks) {
                        size += block.getFreeMemory();
                    }
                    SendShuffleDataResult result = SortWriteBufferManager.this.shuffleWriteClient.sendShuffleData(SortWriteBufferManager.this.appId, shuffleBlocks, () -> false);
                    SortWriteBufferManager.this.successBlockIds.addAll(result.getSuccessBlockIds());
                    SortWriteBufferManager.this.failedBlockIds.addAll(result.getFailedBlockIds());
                }
                catch (Throwable t) {
                    LOG.warn("send shuffle data exception ", t);
                }
                finally {
                    try {
                        SortWriteBufferManager.this.memoryLock.lock();
                        LOG.debug("memoryUsedSize {} decrease {}", (Object)SortWriteBufferManager.this.memoryUsedSize, (Object)size);
                        SortWriteBufferManager.this.memoryUsedSize.addAndGet(-size);
                        SortWriteBufferManager.this.inSendListBytes.addAndGet(-size);
                        SortWriteBufferManager.this.full.signalAll();
                    }
                    finally {
                        SortWriteBufferManager.this.memoryLock.unlock();
                    }
                }
            }
        });
    }

    public void waitSendFinished() {
        long start;
        block3: {
            while (!this.waitSendBuffers.isEmpty()) {
                this.sendBuffersToServers();
            }
            start = System.currentTimeMillis();
            do {
                this.checkFailedBlocks();
                this.allBlockIds.removeAll(this.successBlockIds);
                if (this.allBlockIds.isEmpty()) break block3;
                LOG.info("Wait " + this.allBlockIds.size() + " blocks sent to shuffle server");
                Uninterruptibles.sleepUninterruptibly(this.sendCheckInterval, TimeUnit.MILLISECONDS);
            } while (System.currentTimeMillis() - start <= this.sendCheckTimeout);
            String errorMsg = "Timeout: failed because " + this.allBlockIds.size() + " blocks can't be sent to shuffle server in " + this.sendCheckTimeout + " ms.";
            LOG.error(errorMsg);
            throw new RssException(errorMsg);
        }
        long commitDuration = 0L;
        if (!this.isMemoryShuffleEnabled) {
            long s = System.currentTimeMillis();
            this.sendCommit();
            commitDuration = System.currentTimeMillis() - s;
        }
        start = System.currentTimeMillis();
        this.shuffleWriteClient.reportShuffleResult(this.partitionToServers, this.appId, 0, this.taskAttemptId, this.partitionToBlocks, this.bitmapSplitNum);
        LOG.info("Report shuffle result for task[{}] with bitmapNum[{}] cost {} ms", new Object[]{this.taskAttemptId, this.bitmapSplitNum, System.currentTimeMillis() - start});
        LOG.info("Task uncompressed data length {} compress time cost {} ms, commit time cost {} ms, copy time cost {} ms, sort time cost {} ms", new Object[]{this.uncompressedDataLen, this.compressTime, commitDuration, this.copyTime, this.sortTime});
    }

    private void checkFailedBlocks() {
        if (this.failedBlockIds.size() > 0) {
            String errorMsg = "Send failed: failed because " + this.failedBlockIds.size() + " blocks can't be sent to shuffle server.";
            LOG.error(errorMsg);
            throw new RssException(errorMsg);
        }
    }

    ShuffleBlockInfo createShuffleBlock(SortWriteBuffer wb) {
        byte[] data = wb.getData();
        this.copyTime += wb.getCopyTime();
        this.sortTime += wb.getSortTime();
        int partitionId = wb.getPartitionId();
        int uncompressLength = data.length;
        long start = System.currentTimeMillis();
        byte[] compressed = this.codec.compress(data);
        long crc32 = ChecksumUtils.getCrc32(compressed);
        this.compressTime += System.currentTimeMillis() - start;
        long blockId = RssMRUtils.getBlockId(partitionId, this.taskAttemptId, this.getNextSeqNo(partitionId));
        this.uncompressedDataLen += (long)data.length;
        this.inSendListBytes.addAndGet(wb.getDataLength());
        return new ShuffleBlockInfo(0, partitionId, blockId, compressed.length, crc32, compressed, this.partitionToServers.get(partitionId), uncompressLength, (long)wb.getDataLength(), this.taskAttemptId);
    }

    protected void sendCommit() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        HashSet<ShuffleServerInfo> serverInfos = Sets.newHashSet();
        for (List<ShuffleServerInfo> serverInfoLists : this.partitionToServers.values()) {
            for (ShuffleServerInfo serverInfo : serverInfoLists) {
                serverInfos.add(serverInfo);
            }
        }
        Future<Boolean> future = executor.submit(() -> this.shuffleWriteClient.sendCommit(serverInfos, this.appId, 0, this.numMaps));
        long start = System.currentTimeMillis();
        int currentWait = 200;
        int maxWait = 5000;
        while (!future.isDone()) {
            LOG.info("Wait commit to shuffle server for task[" + this.taskAttemptId + "] cost " + (System.currentTimeMillis() - start) + " ms");
            Uninterruptibles.sleepUninterruptibly(currentWait, TimeUnit.MILLISECONDS);
            currentWait = Math.min(currentWait * 2, maxWait);
        }
        try {
            if (!future.get().booleanValue()) {
                throw new RssException("Failed to commit task to shuffle server");
            }
        }
        catch (InterruptedException ie) {
            LOG.warn("Ignore the InterruptedException which should be caused by internal killed");
        }
        catch (Exception e) {
            throw new RssException("Exception happened when get commit status", e);
        }
        finally {
            executor.shutdown();
        }
    }

    List<SortWriteBuffer<K, V>> getWaitSendBuffers() {
        return this.waitSendBuffers;
    }

    private int getNextSeqNo(int partitionId) {
        this.partitionToSeqNo.computeIfAbsent(partitionId, key -> 0);
        int seqNo = this.partitionToSeqNo.get(partitionId);
        this.partitionToSeqNo.put(partitionId, seqNo + 1);
        return seqNo;
    }

    public void freeAllResources() {
        this.sendExecutorService.shutdownNow();
    }
}

