/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import java.util.List;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;

public class Encoders {
    public static void encodeShuffleServerInfo(ShuffleServerInfo shuffleServerInfo, ByteBuf byteBuf) {
        ByteBufUtils.writeLengthAndString(byteBuf, shuffleServerInfo.getId());
        ByteBufUtils.writeLengthAndString(byteBuf, shuffleServerInfo.getHost());
        byteBuf.writeInt(shuffleServerInfo.getGrpcPort());
        byteBuf.writeInt(shuffleServerInfo.getNettyPort());
    }

    public static void encodeShuffleBlockInfo(ShuffleBlockInfo shuffleBlockInfo, ByteBuf byteBuf) {
        byteBuf.writeInt(shuffleBlockInfo.getPartitionId());
        byteBuf.writeLong(shuffleBlockInfo.getBlockId());
        byteBuf.writeInt(shuffleBlockInfo.getLength());
        byteBuf.writeInt(shuffleBlockInfo.getShuffleId());
        byteBuf.writeLong(shuffleBlockInfo.getCrc());
        byteBuf.writeLong(shuffleBlockInfo.getTaskAttemptId());
        shuffleBlockInfo.copyDataTo(byteBuf);
        List<ShuffleServerInfo> shuffleServerInfoList = shuffleBlockInfo.getShuffleServerInfos();
        byteBuf.writeInt(shuffleServerInfoList.size());
        for (ShuffleServerInfo shuffleServerInfo : shuffleServerInfoList) {
            Encoders.encodeShuffleServerInfo(shuffleServerInfo, byteBuf);
        }
        byteBuf.writeInt(shuffleBlockInfo.getUncompressLength());
        byteBuf.writeLong(shuffleBlockInfo.getFreeMemory());
    }

    public static int encodeLengthOfShuffleServerInfo(ShuffleServerInfo shuffleServerInfo) {
        return ByteBufUtils.encodedLength(shuffleServerInfo.getId()) + ByteBufUtils.encodedLength(shuffleServerInfo.getHost()) + 8;
    }

    public static int encodeLengthOfShuffleBlockInfo(ShuffleBlockInfo shuffleBlockInfo) {
        int encodeLength = 52 + shuffleBlockInfo.getLength() + 4;
        for (ShuffleServerInfo shuffleServerInfo : shuffleBlockInfo.getShuffleServerInfos()) {
            encodeLength += Encoders.encodeLengthOfShuffleServerInfo(shuffleServerInfo);
        }
        return encodeLength;
    }

    public static void encodePartitionRanges(List<PartitionRange> partitionRanges, ByteBuf byteBuf) {
        byteBuf.writeInt(partitionRanges.size());
        for (PartitionRange partitionRange : partitionRanges) {
            byteBuf.writeInt(partitionRange.getStart());
            byteBuf.writeInt(partitionRange.getEnd());
        }
    }

    public static void encodeBufferSegments(List<BufferSegment> bufferSegments, ByteBuf byteBuf) {
        byteBuf.writeInt(bufferSegments.size());
        for (BufferSegment bufferSegment : bufferSegments) {
            byteBuf.writeLong(bufferSegment.getBlockId());
            byteBuf.writeInt(bufferSegment.getOffset());
            byteBuf.writeInt(bufferSegment.getLength());
            byteBuf.writeInt(bufferSegment.getUncompressLength());
            byteBuf.writeLong(bufferSegment.getCrc());
            byteBuf.writeLong(bufferSegment.getTaskAttemptId());
        }
    }

    public static int encodeLengthOfBufferSegments(List<BufferSegment> bufferSegments) {
        return 4 + bufferSegments.size() * 36;
    }
}

