/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.compression;

import java.nio.ByteBuffer;
import org.apache.uniffle.common.compression.Lz4Codec;
import org.apache.uniffle.common.compression.NoOpCodec;
import org.apache.uniffle.common.compression.SnappyCodec;
import org.apache.uniffle.common.compression.ZstdCodec;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;

public abstract class Codec {
    public static Codec newInstance(RssConf rssConf) {
        Type type = rssConf.get(RssClientConf.COMPRESSION_TYPE);
        switch (type) {
            case ZSTD: {
                return ZstdCodec.getInstance(rssConf.get(RssClientConf.ZSTD_COMPRESSION_LEVEL));
            }
            case SNAPPY: {
                return SnappyCodec.getInstance();
            }
            case NOOP: {
                return NoOpCodec.getInstance();
            }
        }
        return Lz4Codec.getInstance();
    }

    public abstract void decompress(ByteBuffer var1, int var2, ByteBuffer var3, int var4);

    public abstract byte[] compress(byte[] var1);

    public abstract int compress(ByteBuffer var1, ByteBuffer var2);

    public abstract int maxCompressedLength(int var1);

    public static enum Type {
        LZ4,
        ZSTD,
        NOOP,
        SNAPPY;

    }
}

