/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.memoize;

import aQute.lib.memoize.Memoize;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

class ReferenceMemoizingSupplier<T>
implements Memoize<T> {
    private final Supplier<? extends T> supplier;
    private final Function<? super T, ? extends Reference<? extends T>> reference;
    private volatile Reference<? extends T> memoized;

    ReferenceMemoizingSupplier(Supplier<? extends T> supplier, Function<? super T, ? extends Reference<? extends T>> reference) {
        this.supplier = Objects.requireNonNull(supplier);
        this.reference = Objects.requireNonNull(reference);
        this.memoized = new WeakReference<Object>(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T referent = this.memoized.get();
        if (referent == null) {
            ReferenceMemoizingSupplier referenceMemoizingSupplier = this;
            synchronized (referenceMemoizingSupplier) {
                referent = this.memoized.get();
                if (referent == null) {
                    referent = this.supplier.get();
                    this.memoized = Objects.requireNonNull(this.reference.apply(referent));
                }
            }
        }
        return referent;
    }

    @Override
    public T peek() {
        T referent = this.memoized.get();
        return referent;
    }
}

