/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.atomic.AtomicInteger;

public final class CountDown {
    private final AtomicInteger countDown;
    private final int originalCount;

    public CountDown(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater or equal to 0 but was: " + count);
        }
        this.originalCount = count;
        this.countDown = new AtomicInteger(count);
    }

    public boolean countDown() {
        int current;
        assert (this.originalCount > 0);
        do {
            current = this.countDown.get();
            assert (current >= 0);
            if (current != 0) continue;
            return false;
        } while (!this.countDown.compareAndSet(current, current - 1));
        return current == 1;
    }

    public boolean fastForward() {
        assert (this.originalCount > 0);
        assert (this.countDown.get() >= 0);
        return this.countDown.getAndSet(0) > 0;
    }

    public boolean isCountedDown() {
        assert (this.countDown.get() >= 0);
        return this.countDown.get() == 0;
    }
}

