/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import java.io.Serializable;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.NonexistentConversationException;
import javax.inject.Inject;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.cdi.AutoConversation;
import org.apache.wicket.cdi.CdiContainer;
import org.apache.wicket.cdi.ConversationExpiredException;
import org.apache.wicket.cdi.ConversationIdMetaKey;
import org.apache.wicket.cdi.ConversationPropagation;
import org.apache.wicket.cdi.ConversationalComponent;
import org.apache.wicket.cdi.ICdiAwareRequestCycleListener;
import org.apache.wicket.cdi.IConversationPropagation;
import org.apache.wicket.core.request.handler.BufferedResponseRequestHandler;
import org.apache.wicket.core.request.handler.IPageClassRequestHandler;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.mapper.StalePageException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationPropagator
extends AbstractRequestCycleListener {
    private static final Logger logger = LoggerFactory.getLogger(ConversationPropagator.class);
    private static final MetaDataKey<String> CID_KEY = ConversationIdMetaKey.INSTANCE;
    private static final MetaDataKey<Boolean> CONVERSATION_STARTED_KEY = new MetaDataKey<Boolean>(){};
    public static final String CID = "cid";
    private final CdiContainer container;
    private final IConversationPropagation propagation;
    private final Application application;
    private final boolean auto;
    @Inject
    Conversation conversation_;
    @Inject
    AutoConversation autoConversation;

    public ConversationPropagator(Application application, CdiContainer container, IConversationPropagation propagation) {
        this(application, container, propagation, false);
    }

    public ConversationPropagator(Application application, CdiContainer container, IConversationPropagation propagation, boolean auto) {
        Args.notNull((Object)application, (String)"application");
        Args.notNull((Object)container, (String)"container");
        Args.notNull((Object)propagation, (String)"propagation");
        if (propagation == ConversationPropagation.NONE) {
            throw new IllegalArgumentException("If propagation is NONE do not set up the propagator");
        }
        this.application = application;
        this.container = container;
        this.propagation = propagation;
        this.auto = auto;
        container.getNonContextualManager().postConstruct(this);
    }

    private Conversation getConversation(RequestCycle cycle) {
        return Boolean.TRUE.equals(cycle.getMetaData(CONVERSATION_STARTED_KEY)) ? this.conversation_ : null;
    }

    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        Conversation current;
        String cid = cycle.getRequest().getRequestParameters().getParameterValue(CID).toString();
        Page page = ConversationPropagator.getPage(handler);
        if (cid == null && page != null) {
            cid = (String)((Object)page.getMetaData(CID_KEY));
        }
        if ((current = this.getConversation(cycle)) != null && !Objects.isEqual((Object)current.getId(), (Object)cid)) {
            logger.info("Conversation {} has expired for {}", (Object)cid, (Object)page);
            throw new ConversationExpiredException(null, cid, page, handler);
        }
        this.activateConversationIfNeeded(cycle, handler, cid);
    }

    public IRequestHandler onException(RequestCycle cycle, Exception ex) {
        String cid;
        IRequestablePage requestable;
        if (ex instanceof StalePageException && (requestable = ((StalePageException)ex).getPage()) instanceof Page && (cid = this.container.getConversationMarker((Page)requestable)) != null) {
            try {
                this.activateConversationIfNeeded(cycle, null, cid);
                return null;
            }
            catch (ConversationExpiredException e) {
                // empty catch block
            }
        }
        this.activateConversationIfNeeded(cycle, null, null);
        return null;
    }

    private void activateConversationIfNeeded(RequestCycle cycle, IRequestHandler handler, String cid) {
        Conversation current = this.getConversation(cycle);
        if (current != null || !this.activateForHandler(handler)) {
            return;
        }
        logger.debug("Activating conversation {}", (Object)cid);
        try {
            this.container.activateConversationalContext(cycle, cid);
            this.fireOnAfterConversationStarted(cycle);
        }
        catch (NonexistentConversationException e) {
            logger.info("Unable to restore conversation with id {}", (Object)cid, (Object)e.getMessage());
            logger.debug("Unable to restore conversation", (Throwable)e);
            this.fireOnAfterConversationStarted(cycle);
            throw new ConversationExpiredException(e, cid, ConversationPropagator.getPage(handler), handler);
        }
        cycle.setMetaData(CONVERSATION_STARTED_KEY, (Object)true);
    }

    private void fireOnAfterConversationStarted(RequestCycle cycle) {
        for (IRequestCycleListener listener : this.application.getRequestCycleListeners()) {
            if (!(listener instanceof ICdiAwareRequestCycleListener)) continue;
            ((ICdiAwareRequestCycleListener)listener).onAfterConversationActivated(cycle);
        }
    }

    public void onRequestHandlerExecuted(RequestCycle cycle, IRequestHandler handler) {
        Conversation conversation = this.getConversation(cycle);
        if (conversation == null) {
            return;
        }
        Page page = ConversationPropagator.getPage(handler);
        if (page == null) {
            return;
        }
        this.autoEndIfNecessary(page, handler, conversation);
        this.autoBeginIfNecessary(page, handler, conversation);
        if (this.propagation.propagatesViaPage(page, handler)) {
            this.setConversationOnPage(conversation, page);
        }
    }

    public void onRequestHandlerScheduled(RequestCycle cycle, IRequestHandler handler) {
        Conversation conversation = this.getConversation(cycle);
        if (conversation == null || conversation.isTransient()) {
            return;
        }
        Page page = ConversationPropagator.getPage(handler);
        if (page != null && this.propagation.propagatesViaPage(page, handler)) {
            this.setConversationOnPage(conversation, page);
        }
        if (this.propagation.propagatesViaParameters(handler)) {
            logger.debug("Propagating non-transient conversation {} via page parameters of handler {}", (Object)conversation.getId(), (Object)handler);
            PageParameters parameters = this.getPageParameters(handler);
            if (parameters != null) {
                parameters.set(CID, (Object)conversation.getId());
            }
        }
    }

    protected void setConversationOnPage(Conversation conversation, Page page) {
        if (conversation == null || conversation.isTransient()) {
            logger.debug("Detaching transient conversation {} via meta of page instance {}", (Object)(conversation == null ? "null" : conversation.getId()), (Object)page);
            page.setMetaData(CID_KEY, null);
        } else {
            logger.debug("Propagating non-transient conversation {} via meta of page instance {}", (Object)conversation.getId(), (Object)page);
            page.setMetaData(CID_KEY, (Serializable)((Object)conversation.getId()));
        }
    }

    public void onUrlMapped(RequestCycle cycle, IRequestHandler handler, Url url) {
        if (handler instanceof ResourceReferenceRequestHandler && ((ResourceReferenceRequestHandler)handler).getResourceReference() instanceof PackageResourceReference) {
            return;
        }
        Conversation conversation = this.getConversation(cycle);
        if (conversation == null || conversation.isTransient()) {
            return;
        }
        if (this.propagation.propagatesViaParameters(handler)) {
            logger.debug("Propagating non-transient conversation {} via url", (Object)conversation.getId());
            url.setQueryParameter(CID, (Object)conversation.getId());
        }
    }

    public void onDetach(RequestCycle cycle) {
        Conversation conversation = this.getConversation(cycle);
        if (conversation != null) {
            logger.debug("Deactivating conversation {}", (Object)conversation.getId());
            for (IRequestCycleListener listener : this.application.getRequestCycleListeners()) {
                if (!(listener instanceof ICdiAwareRequestCycleListener)) continue;
                ((ICdiAwareRequestCycleListener)listener).onBeforeConversationDeactivated(cycle);
            }
            this.container.deactivateConversationalContext(cycle);
            cycle.setMetaData(CONVERSATION_STARTED_KEY, null);
        }
    }

    protected boolean activateForHandler(IRequestHandler handler) {
        return handler == null || !(handler instanceof BufferedResponseRequestHandler);
    }

    protected void autoBeginIfNecessary(Page page, IRequestHandler handler, Conversation conversation) {
        if (!(this.auto && conversation != null && conversation.isTransient() && page != null && this.propagation.propagatesViaPage(page, handler) && this.hasConversationalComponent(page))) {
            return;
        }
        conversation.begin();
        this.autoConversation.setAutomatic(true);
        logger.debug("Auto-began conversation {} for page {}", (Object)conversation.getId(), (Object)page);
    }

    protected void autoEndIfNecessary(Page page, IRequestHandler handler, Conversation conversation) {
        if (!this.auto || conversation == null || conversation.isTransient() || page == null || !this.propagation.propagatesViaPage(page, handler) || this.hasConversationalComponent(page) || !this.autoConversation.isAutomatic()) {
            return;
        }
        String cid = conversation.getId();
        this.autoConversation.setAutomatic(false);
        conversation.end();
        logger.debug("Auto-ended conversation {} for page {}", (Object)cid, (Object)page);
    }

    protected boolean hasConversationalComponent(Page page) {
        Boolean hasConversational = (Boolean)Visits.visit((Iterable)page, (IVisitor)new IVisitor<Component, Boolean>(){

            public void component(Component object, IVisit<Boolean> visit) {
                if (object instanceof ConversationalComponent) {
                    visit.stop((Object)true);
                }
            }
        });
        return hasConversational == null ? false : hasConversational;
    }

    public static Page getPage(IRequestHandler handler) {
        IPageRequestHandler pageHandler;
        while (handler instanceof IRequestHandlerDelegate) {
            handler = ((IRequestHandlerDelegate)handler).getDelegateHandler();
        }
        if (handler instanceof IPageRequestHandler && (pageHandler = (IPageRequestHandler)handler).isPageInstanceCreated()) {
            return (Page)pageHandler.getPage();
        }
        return null;
    }

    protected PageParameters getPageParameters(IRequestHandler handler) {
        if (handler instanceof IPageClassRequestHandler) {
            IPageClassRequestHandler pageHandler = (IPageClassRequestHandler)handler;
            return pageHandler.getPageParameters();
        }
        return null;
    }
}

