
/*
Copyright Â© 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, European Research Consortium 
for Informatics and Mathematics, Keio University). All 
Rights Reserved. This work is distributed under the W3CÂ® Software License [1] in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even 
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 

[1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
*/



   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
function getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodeinsertbefore02";
   }

var docsLoaded = -1000000;
var builder = null;

//
//   This function is called by the testing framework before
//      running the test suite.
//
//   If there are no configuration exceptions, asynchronous
//        document loading is started.  Otherwise, the status
//        is set to complete and the exception is immediately
//        raised when entering the body of the test.
//
function setUpPage() {
   setUpPageStatus = 'running';
   try {
     //
     //   creates test document builder, may throw exception
     //
     builder = createConfiguredBuilder();

      docsLoaded = 0;
      
      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      docsLoaded += preload(docRef, "doc", "hc_staff");
        
       if (docsLoaded == 1) {
          setUpPage = 'complete';
       }
    } catch(ex) {
    	catchInitializationError(builder, ex);
        setUpPage = 'complete';
    }
}



//
//   This method is called on the completion of 
//      each asychronous load started in setUpTests.
//
//   When every synchronous loaded document has completed,
//      the page status is changed which allows the
//      body of the test to be executed.
function loadComplete() {
    if (++docsLoaded == 1) {
        setUpPageStatus = 'complete';
    }
}


/**
* 
	Using insertBefore on a new Document node attempt to insert a new Comment node before
	this DocumentType node and verify the name of the inserted Comment node.  Now
	attempt to insert a new Processing Instruction node before the new Comment and 
	verify the target of the inserted ProcessingInstruction.

* @author IBM
* @author Neil Delima
* @see http://www.w3.org/TR/2004/REC-DOM-Level-3-Core-20040407/core#ID-952280727
*/
function nodeinsertbefore02() {
   var success;
    if(checkInitialization(builder, "nodeinsertbefore02") != null) return;
    var doc;
      var newDoc;
      var domImpl;
      var newDocType;
      var newComment;
      var insertedComment;
      var data;
      var newPI;
      var insertedPI;
      var target;
      var nullPubId = null;

      var nullSysId = null;

      var rootNS;
      var rootName;
      var docElem;
      
      var docRef = null;
      if (typeof(this.doc) != 'undefined') {
        docRef = this.doc;
      }
      doc = load(docRef, "doc", "hc_staff");
      docElem = doc.documentElement;

      rootNS = docElem.namespaceURI;

      rootName = docElem.tagName;

      domImpl = doc.implementation;
newDocType = domImpl.createDocumentType(rootName,nullPubId,nullSysId);
      newDoc = domImpl.createDocument(rootNS,rootName,newDocType);
      newComment = newDoc.createComment("Comment");
      newPI = newDoc.createProcessingInstruction("PITarget","PIData");
      insertedComment = newDoc.insertBefore(newComment,newDocType);
      data = insertedComment.data;

      assertEquals("nodeinsertbefore02_1","Comment",data);
       insertedPI = newDoc.insertBefore(newPI,newComment);
      target = insertedPI.target;

      assertEquals("nodeinsertbefore02_2","PITarget",target);
       
}




function runTest() {
   nodeinsertbefore02();
}
