description(
"This test verifies that the bit twiddling done in JavaScriptCore's integer machinery works correctly on the current platform."
);

shouldBe("(-1).toString()", '"-1"');
shouldBe("(0).toString()", '"0"');
shouldBe("(-0).toString()", '"0"');
debug("");

var answers = [
['"-128"', '"-129"', '"127"', '"128"'],
['"-256"', '"-257"', '"255"', '"256"'],
['"-512"', '"-513"', '"511"', '"512"'],
['"-1024"', '"-1025"', '"1023"', '"1024"'],
['"-2048"', '"-2049"', '"2047"', '"2048"'],
['"-4096"', '"-4097"', '"4095"', '"4096"'],
['"-8192"', '"-8193"', '"8191"', '"8192"'],
['"-16384"', '"-16385"', '"16383"', '"16384"'],
['"-32768"', '"-32769"', '"32767"', '"32768"'],
['"-65536"', '"-65537"', '"65535"', '"65536"'],
['"-131072"', '"-131073"', '"131071"', '"131072"'],
['"-262144"', '"-262145"', '"262143"', '"262144"'],
['"-524288"', '"-524289"', '"524287"', '"524288"'],
['"-1048576"', '"-1048577"', '"1048575"', '"1048576"'],
['"-2097152"', '"-2097153"', '"2097151"', '"2097152"'],
['"-4194304"', '"-4194305"', '"4194303"', '"4194304"'],
['"-8388608"', '"-8388609"', '"8388607"', '"8388608"'],
['"-16777216"', '"-16777217"', '"16777215"', '"16777216"'],
['"-33554432"', '"-33554433"', '"33554431"', '"33554432"'],
['"-67108864"', '"-67108865"', '"67108863"', '"67108864"'],
['"-134217728"', '"-134217729"', '"134217727"', '"134217728"'],
['"-268435456"', '"-268435457"', '"268435455"', '"268435456"'],
['"-536870912"', '"-536870913"', '"536870911"', '"536870912"'],
['"-1073741824"', '"-1073741825"', '"1073741823"', '"1073741824"'],
['"-2147483648"', '"-2147483649"', '"2147483647"', '"2147483648"'],
['"-4294967296"', '"-4294967297"', '"4294967295"', '"4294967296"'],
['"-8589934592"', '"-8589934593"', '"8589934591"', '"8589934592"'],
['"-17179869184"', '"-17179869185"', '"17179869183"', '"17179869184"'],
['"-34359738368"', '"-34359738369"', '"34359738367"', '"34359738368"'],
['"-68719476736"', '"-68719476737"', '"68719476735"', '"68719476736"'],
['"-137438953472"', '"-137438953473"', '"137438953471"', '"137438953472"'],
['"-274877906944"', '"-274877906945"', '"274877906943"', '"274877906944"'],
['"-549755813888"', '"-549755813889"', '"549755813887"', '"549755813888"'],
['"-1099511627776"', '"-1099511627777"', '"1099511627775"', '"1099511627776"'],
['"-2199023255552"', '"-2199023255553"', '"2199023255551"', '"2199023255552"'],
['"-4398046511104"', '"-4398046511105"', '"4398046511103"', '"4398046511104"'],
['"-8796093022208"', '"-8796093022209"', '"8796093022207"', '"8796093022208"'],
['"-17592186044416"', '"-17592186044417"', '"17592186044415"', '"17592186044416"'],
['"-35184372088832"', '"-35184372088833"', '"35184372088831"', '"35184372088832"'],
['"-70368744177664"', '"-70368744177665"', '"70368744177663"', '"70368744177664"'],
['"-140737488355328"', '"-140737488355329"', '"140737488355327"', '"140737488355328"'],
['"-281474976710656"', '"-281474976710657"', '"281474976710655"', '"281474976710656"'],
['"-562949953421312"', '"-562949953421313"', '"562949953421311"', '"562949953421312"'],
['"-1125899906842624"', '"-1125899906842625"', '"1125899906842623"', '"1125899906842624"'],
['"-2251799813685248"', '"-2251799813685249"', '"2251799813685247"', '"2251799813685248"'],
['"-4503599627370496"', '"-4503599627370497"', '"4503599627370495"', '"4503599627370496"'],
['"-9007199254740992"', '"-9007199254740992"', '"9007199254740991"', '"9007199254740992"'],
['"-18014398509481984"', '"-18014398509481984"', '"18014398509481984"', '"18014398509481984"'],
['"-36028797018963970"', '"-36028797018963970"', '"36028797018963970"', '"36028797018963970"'],
['"-72057594037927940"', '"-72057594037927940"', '"72057594037927940"', '"72057594037927940"'],
['"-144115188075855870"', '"-144115188075855870"', '"144115188075855870"', '"144115188075855870"'],
['"-288230376151711740"', '"-288230376151711740"', '"288230376151711740"', '"288230376151711740"'],
['"-576460752303423500"', '"-576460752303423500"', '"576460752303423500"', '"576460752303423500"'],
['"-1152921504606847000"', '"-1152921504606847000"', '"1152921504606847000"', '"1152921504606847000"'],
['"-2305843009213694000"', '"-2305843009213694000"', '"2305843009213694000"', '"2305843009213694000"'],
['"-4611686018427388000"', '"-4611686018427388000"', '"4611686018427388000"', '"4611686018427388000"'],
['"-9223372036854776000"', '"-9223372036854776000"', '"9223372036854776000"', '"9223372036854776000"'],
['"-18446744073709552000"', '"-18446744073709552000"', '"18446744073709552000"', '"18446744073709552000"'],
['"-36893488147419103000"', '"-36893488147419103000"', '"36893488147419103000"', '"36893488147419103000"'],
['"-73786976294838210000"', '"-73786976294838210000"', '"73786976294838210000"', '"73786976294838210000"'],
['"-147573952589676410000"', '"-147573952589676410000"', '"147573952589676410000"', '"147573952589676410000"'],
['"-295147905179352830000"', '"-295147905179352830000"', '"295147905179352830000"', '"295147905179352830000"'],
['"-590295810358705700000"', '"-590295810358705700000"', '"590295810358705700000"', '"590295810358705700000"'],
['"-1.1805916207174113e+21"', '"-1.1805916207174113e+21"', '"1.1805916207174113e+21"', '"1.1805916207174113e+21"'],
['"-2.3611832414348226e+21"', '"-2.3611832414348226e+21"', '"2.3611832414348226e+21"', '"2.3611832414348226e+21"'],
['"-4.722366482869645e+21"', '"-4.722366482869645e+21"', '"4.722366482869645e+21"', '"4.722366482869645e+21"'],
['"-9.44473296573929e+21"', '"-9.44473296573929e+21"', '"9.44473296573929e+21"', '"9.44473296573929e+21"'],
['"-1.888946593147858e+22"', '"-1.888946593147858e+22"', '"1.888946593147858e+22"', '"1.888946593147858e+22"'],
['"-3.777893186295716e+22"', '"-3.777893186295716e+22"', '"3.777893186295716e+22"', '"3.777893186295716e+22"'],
['"-7.555786372591432e+22"', '"-7.555786372591432e+22"', '"7.555786372591432e+22"', '"7.555786372591432e+22"'],
['"-1.5111572745182865e+23"', '"-1.5111572745182865e+23"', '"1.5111572745182865e+23"', '"1.5111572745182865e+23"'],
['"-3.022314549036573e+23"', '"-3.022314549036573e+23"', '"3.022314549036573e+23"', '"3.022314549036573e+23"'],
['"-6.044629098073146e+23"', '"-6.044629098073146e+23"', '"6.044629098073146e+23"', '"6.044629098073146e+23"'],
['"-1.2089258196146292e+24"', '"-1.2089258196146292e+24"', '"1.2089258196146292e+24"', '"1.2089258196146292e+24"'],
['"-2.4178516392292583e+24"', '"-2.4178516392292583e+24"', '"2.4178516392292583e+24"', '"2.4178516392292583e+24"'],
['"-4.835703278458517e+24"', '"-4.835703278458517e+24"', '"4.835703278458517e+24"', '"4.835703278458517e+24"'],
['"-9.671406556917033e+24"', '"-9.671406556917033e+24"', '"9.671406556917033e+24"', '"9.671406556917033e+24"'],
['"-1.9342813113834067e+25"', '"-1.9342813113834067e+25"', '"1.9342813113834067e+25"', '"1.9342813113834067e+25"'],
['"-3.8685626227668134e+25"', '"-3.8685626227668134e+25"', '"3.8685626227668134e+25"', '"3.8685626227668134e+25"'],
['"-7.737125245533627e+25"', '"-7.737125245533627e+25"', '"7.737125245533627e+25"', '"7.737125245533627e+25"'],
['"-1.5474250491067253e+26"', '"-1.5474250491067253e+26"', '"1.5474250491067253e+26"', '"1.5474250491067253e+26"'],
['"-3.094850098213451e+26"', '"-3.094850098213451e+26"', '"3.094850098213451e+26"', '"3.094850098213451e+26"'],
['"-6.189700196426902e+26"', '"-6.189700196426902e+26"', '"6.189700196426902e+26"', '"6.189700196426902e+26"'],
['"-1.2379400392853803e+27"', '"-1.2379400392853803e+27"', '"1.2379400392853803e+27"', '"1.2379400392853803e+27"'],
['"-2.4758800785707605e+27"', '"-2.4758800785707605e+27"', '"2.4758800785707605e+27"', '"2.4758800785707605e+27"'],
['"-4.951760157141521e+27"', '"-4.951760157141521e+27"', '"4.951760157141521e+27"', '"4.951760157141521e+27"'],
['"-9.903520314283042e+27"', '"-9.903520314283042e+27"', '"9.903520314283042e+27"', '"9.903520314283042e+27"'],
['"-1.9807040628566084e+28"', '"-1.9807040628566084e+28"', '"1.9807040628566084e+28"', '"1.9807040628566084e+28"'],
['"-3.961408125713217e+28"', '"-3.961408125713217e+28"', '"3.961408125713217e+28"', '"3.961408125713217e+28"'],
['"-7.922816251426434e+28"', '"-7.922816251426434e+28"', '"7.922816251426434e+28"', '"7.922816251426434e+28"'],
['"-1.5845632502852868e+29"', '"-1.5845632502852868e+29"', '"1.5845632502852868e+29"', '"1.5845632502852868e+29"'],
['"-3.1691265005705735e+29"', '"-3.1691265005705735e+29"', '"3.1691265005705735e+29"', '"3.1691265005705735e+29"'],
['"-6.338253001141147e+29"', '"-6.338253001141147e+29"', '"6.338253001141147e+29"', '"6.338253001141147e+29"'],
['"-1.2676506002282294e+30"', '"-1.2676506002282294e+30"', '"1.2676506002282294e+30"', '"1.2676506002282294e+30"'],
['"-2.535301200456459e+30"', '"-2.535301200456459e+30"', '"2.535301200456459e+30"', '"2.535301200456459e+30"'],
['"-5.070602400912918e+30"', '"-5.070602400912918e+30"', '"5.070602400912918e+30"', '"5.070602400912918e+30"'],
['"-1.0141204801825835e+31"', '"-1.0141204801825835e+31"', '"1.0141204801825835e+31"', '"1.0141204801825835e+31"'],
['"-2.028240960365167e+31"', '"-2.028240960365167e+31"', '"2.028240960365167e+31"', '"2.028240960365167e+31"'],
['"-4.056481920730334e+31"', '"-4.056481920730334e+31"', '"4.056481920730334e+31"', '"4.056481920730334e+31"'],
['"-8.112963841460668e+31"', '"-8.112963841460668e+31"', '"8.112963841460668e+31"', '"8.112963841460668e+31"'],
['"-1.6225927682921336e+32"', '"-1.6225927682921336e+32"', '"1.6225927682921336e+32"', '"1.6225927682921336e+32"'],
['"-3.2451855365842673e+32"', '"-3.2451855365842673e+32"', '"3.2451855365842673e+32"', '"3.2451855365842673e+32"'],
['"-6.490371073168535e+32"', '"-6.490371073168535e+32"', '"6.490371073168535e+32"', '"6.490371073168535e+32"'],
['"-1.298074214633707e+33"', '"-1.298074214633707e+33"', '"1.298074214633707e+33"', '"1.298074214633707e+33"'],
['"-2.596148429267414e+33"', '"-2.596148429267414e+33"', '"2.596148429267414e+33"', '"2.596148429267414e+33"'],
['"-5.192296858534828e+33"', '"-5.192296858534828e+33"', '"5.192296858534828e+33"', '"5.192296858534828e+33"'],
['"-1.0384593717069655e+34"', '"-1.0384593717069655e+34"', '"1.0384593717069655e+34"', '"1.0384593717069655e+34"'],
['"-2.076918743413931e+34"', '"-2.076918743413931e+34"', '"2.076918743413931e+34"', '"2.076918743413931e+34"'],
['"-4.153837486827862e+34"', '"-4.153837486827862e+34"', '"4.153837486827862e+34"', '"4.153837486827862e+34"'],
['"-8.307674973655724e+34"', '"-8.307674973655724e+34"', '"8.307674973655724e+34"', '"8.307674973655724e+34"'],
['"-1.661534994731145e+35"', '"-1.661534994731145e+35"', '"1.661534994731145e+35"', '"1.661534994731145e+35"'],
['"-3.32306998946229e+35"', '"-3.32306998946229e+35"', '"3.32306998946229e+35"', '"3.32306998946229e+35"'],
['"-6.64613997892458e+35"', '"-6.64613997892458e+35"', '"6.64613997892458e+35"', '"6.64613997892458e+35"'],
['"-1.329227995784916e+36"', '"-1.329227995784916e+36"', '"1.329227995784916e+36"', '"1.329227995784916e+36"'],
['"-2.658455991569832e+36"', '"-2.658455991569832e+36"', '"2.658455991569832e+36"', '"2.658455991569832e+36"'],
['"-5.316911983139664e+36"', '"-5.316911983139664e+36"', '"5.316911983139664e+36"', '"5.316911983139664e+36"'],
['"-1.0633823966279327e+37"', '"-1.0633823966279327e+37"', '"1.0633823966279327e+37"', '"1.0633823966279327e+37"'],
['"-2.1267647932558654e+37"', '"-2.1267647932558654e+37"', '"2.1267647932558654e+37"', '"2.1267647932558654e+37"'],
['"-4.253529586511731e+37"', '"-4.253529586511731e+37"', '"4.253529586511731e+37"', '"4.253529586511731e+37"'],
['"-8.507059173023462e+37"', '"-8.507059173023462e+37"', '"8.507059173023462e+37"', '"8.507059173023462e+37"'],
['"-1.7014118346046923e+38"', '"-1.7014118346046923e+38"', '"1.7014118346046923e+38"', '"1.7014118346046923e+38"']
];
    
for (var valueBits = 8; valueBits <= 128; valueBits++) {
    debug("bits used to store value: " + valueBits);
    var max = Math.pow(2, valueBits - 1) - 1;
    var min = -Math.pow(2, valueBits - 1);
    shouldBe("min.toString()", answers[valueBits-8][0]);
    shouldBe("(min - 1).toString()", answers[valueBits-8][1]);
    shouldBe("max.toString()", answers[valueBits-8][2]);
    shouldBe("(max + 1).toString()", answers[valueBits-8][3]);
}

var successfullyParsed = true;
