description("Tests whether changes to SVG through native objects and the DOM stay in sync.");

var svgDoc = document.implementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
var rect = svgDoc.createElementNS("http://www.w3.org/2000/svg", "rect");
rect.setAttribute("x", 100);
rect.setAttribute("y", 100);

shouldBe("rect.x.baseVal.value", "100");
shouldBe("rect.getAttribute('x')", "'100'");
shouldBe("rect.y.baseVal.value", "100");
shouldBe("rect.getAttribute('y')", "'100'");

rect.x.baseVal.value = 200;
rect.setAttribute("y", 200);

shouldBe("rect.x.baseVal.value", "200");
shouldBe("rect.getAttribute('x')", "'200'");
shouldBe("rect.y.baseVal.value", "200");
shouldBe("rect.getAttribute('y')", "'200'");

var successfullyParsed = true;
