﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/budgets/model/DescribeBudgetRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Budgets::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DescribeBudgetRequest::SerializePayload() const {
  JsonValue payload;

  if (m_accountIdHasBeenSet) {
    payload.WithString("AccountId", m_accountId);
  }

  if (m_budgetNameHasBeenSet) {
    payload.WithString("BudgetName", m_budgetName);
  }

  if (m_showFilterExpressionHasBeenSet) {
    payload.WithBool("ShowFilterExpression", m_showFilterExpression);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DescribeBudgetRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSBudgetServiceGateway.DescribeBudget"));
  return headers;
}
