/* src/bazaar.p/bz-root-curated-config.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include "bz-curated-row.h"

G_BEGIN_DECLS



#define BZ_TYPE_ROOT_CURATED_CONFIG (bz_root_curated_config_get_type ())
G_DECLARE_FINAL_TYPE (BzRootCuratedConfig, bz_root_curated_config, BZ, ROOT_CURATED_CONFIG, GObject)

BzRootCuratedConfig *
bz_root_curated_config_new (void);

const char *
bz_root_curated_config_get_css (BzRootCuratedConfig *self);

GListModel *
bz_root_curated_config_get_templates (BzRootCuratedConfig *self);

GListModel *
bz_root_curated_config_get_rows (BzRootCuratedConfig *self);

void
bz_root_curated_config_set_css (BzRootCuratedConfig *self,
    const char *css);

void
bz_root_curated_config_set_templates (BzRootCuratedConfig *self,
    GListModel *templates);

void
bz_root_curated_config_set_rows (BzRootCuratedConfig *self,
    GListModel *rows);

G_END_DECLS

/* End of src/bazaar.p/bz-root-curated-config.h */
