/* util-object.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-object.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))

/**
 * Creates a set of property bindings from source to dest with the given binding flags.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeList*
geary_object_utils_mirror_properties (GObject* source,
                                      GObject* dest,
                                      GBindingFlags flags)
{
	GeeHashSet* source_properties = NULL;
	GObjectClass* _tmp0_;
	guint _tmp1_ = 0;
	GParamSpec** _tmp2_;
	GParamSpec** _tmp3_;
	gint _tmp3__length1;
	GearyIterable* _tmp4_;
	GearyIterable* _tmp5_;
	GeeHashSet* _tmp6_;
	GeeHashSet* _tmp7_;
	GeeHashSet* dest_properties = NULL;
	GObjectClass* _tmp8_;
	guint _tmp9_ = 0;
	GParamSpec** _tmp10_;
	GParamSpec** _tmp11_;
	gint _tmp11__length1;
	GearyIterable* _tmp12_;
	GearyIterable* _tmp13_;
	GeeHashSet* _tmp14_;
	GeeHashSet* _tmp15_;
	GeeHashSet* _tmp16_;
	GeeHashSet* _tmp17_;
	GeeList* bindings = NULL;
	GeeArrayList* _tmp18_;
	GeeList* _tmp31_ = NULL;
	GeeList* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	GeeList* _tmp36_;
	GeeList* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (source, G_TYPE_OBJECT), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dest, G_TYPE_OBJECT), NULL);
	_tmp0_ = G_OBJECT_GET_CLASS (source);
	_tmp2_ = g_object_class_list_properties (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp4_ = geary_iterate_array (G_TYPE_PARAM, (GBoxedCopyFunc) g_param_spec_ref, (GDestroyNotify) g_param_spec_unref, _tmp3_, (gint) _tmp1_, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_iterable_to_hash_set (_tmp5_, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	_tmp3_ = (g_free (_tmp3_), NULL);
	source_properties = _tmp7_;
	_tmp8_ = G_OBJECT_GET_CLASS (dest);
	_tmp10_ = g_object_class_list_properties (_tmp8_, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp9_;
	_tmp12_ = geary_iterate_array (G_TYPE_PARAM, (GBoxedCopyFunc) g_param_spec_ref, (GDestroyNotify) g_param_spec_unref, _tmp11_, (gint) _tmp9_, NULL, NULL, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = geary_iterable_to_hash_set (_tmp13_, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp13_);
	_tmp11_ = (g_free (_tmp11_), NULL);
	dest_properties = _tmp15_;
	_tmp16_ = source_properties;
	_tmp17_ = dest_properties;
	gee_collection_retain_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp18_ = gee_array_list_new (G_TYPE_BINDING, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	bindings = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_LIST, GeeList);
	{
		GeeIterator* _ps_it = NULL;
		GeeHashSet* _tmp19_;
		GeeIterator* _tmp20_;
		_tmp19_ = source_properties;
		_tmp20_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_ps_it = _tmp20_;
		while (TRUE) {
			GeeIterator* _tmp21_;
			GParamSpec* ps = NULL;
			GeeIterator* _tmp22_;
			gpointer _tmp23_;
			GParamSpec* _tmp24_;
			_tmp21_ = _ps_it;
			if (!gee_iterator_next (_tmp21_)) {
				break;
			}
			_tmp22_ = _ps_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			ps = (GParamSpec*) _tmp23_;
			_tmp24_ = ps;
			if ((_tmp24_->flags & G_PARAM_WRITABLE) != 0) {
				GeeList* _tmp25_;
				GParamSpec* _tmp26_;
				const gchar* _tmp27_;
				GParamSpec* _tmp28_;
				const gchar* _tmp29_;
				GBinding* _tmp30_;
				_tmp25_ = bindings;
				_tmp26_ = ps;
				_tmp27_ = _tmp26_->name;
				_tmp28_ = ps;
				_tmp29_ = _tmp28_->name;
				_tmp30_ = g_object_bind_property_with_closures (source, _tmp27_, dest, _tmp29_, flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection), _tmp30_);
			}
			_g_param_spec_unref0 (ps);
		}
		_g_object_unref0 (_ps_it);
	}
	_tmp32_ = bindings;
	_tmp33_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp34_ = _tmp33_;
	if (_tmp34_ > 0) {
		GeeList* _tmp35_;
		_tmp35_ = bindings;
		_tmp31_ = _tmp35_;
	} else {
		_tmp31_ = NULL;
	}
	_tmp36_ = _g_object_ref0 (_tmp31_);
	result = _tmp36_;
	_g_object_unref0 (bindings);
	_g_object_unref0 (dest_properties);
	_g_object_unref0 (source_properties);
	return result;
}

/**
 * Removes a property mirror created by mirror_properties
 */
void
geary_object_utils_unmirror_properties (GeeList* bindings)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (bindings, GEE_TYPE_LIST));
	{
		GeeList* _b_list = NULL;
		gint _b_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _b_index = 0;
		_b_list = bindings;
		_tmp0_ = _b_list;
		_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp2_ = _tmp1_;
		_b_size = _tmp2_;
		_b_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			GBinding* b = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			GBinding* _tmp7_;
			_b_index = _b_index + 1;
			_tmp3_ = _b_index;
			_tmp4_ = _b_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _b_list;
			_tmp6_ = gee_list_get (_tmp5_, _b_index);
			b = (GBinding*) _tmp6_;
			_tmp7_ = b;
			g_object_unref (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, G_TYPE_OBJECT, GObject));
			_g_object_unref0 (b);
		}
	}
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (bindings, GEE_TYPE_COLLECTION, GeeCollection));
}

/** Convenience method for getting an enum value's nick name. */
gchar*
geary_object_utils_to_enum_nick (GType e_type,
                                 GBoxedCopyFunc e_dup_func,
                                 GDestroyNotify e_destroy_func,
                                 GType type,
                                 gconstpointer value)
{
	GEnumClass* enum_type = NULL;
	GTypeClass* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = g_type_class_ref (type);
	enum_type = (GEnumClass*) _tmp0_;
	_tmp1_ = (*g_enum_get_value (enum_type, (gint) value)).value_nick;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	_g_type_class_unref0 (enum_type);
	return result;
}

/** Convenience method for getting an enum value's from its nick name. */
gpointer
geary_object_utils_from_enum_nick (GType e_type,
                                   GBoxedCopyFunc e_dup_func,
                                   GDestroyNotify e_destroy_func,
                                   GType type,
                                   const gchar* nick,
                                   GError** error)
{
	GEnumClass* enum_type = NULL;
	GTypeClass* _tmp0_;
	GEnumValue* e_value = NULL;
	GEnumClass* _tmp1_;
	GEnumValue* _tmp2_;
	GEnumValue* _tmp5_;
	gpointer _tmp6_;
	GError* _inner_error0_ = NULL;
	gpointer result;
	g_return_val_if_fail (nick != NULL, NULL);
	_tmp0_ = g_type_class_ref (type);
	enum_type = (GEnumClass*) _tmp0_;
	_tmp1_ = enum_type;
	e_value = g_enum_get_value_by_nick (_tmp1_, nick);
	_tmp2_ = e_value;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		GError* _tmp4_;
		_tmp3_ = g_type_name (e_type);
		_tmp4_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_BAD_PARAMETERS, "Unknown %s enum value: %s", _tmp3_, nick);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_type_class_unref0 (enum_type);
			return NULL;
		} else {
			_g_type_class_unref0 (enum_type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = e_value;
	_tmp6_ = ((((gconstpointer) (*_tmp5_).value) != NULL) && (e_dup_func != NULL)) ? e_dup_func ((gpointer) ((gconstpointer) (*_tmp5_).value)) : ((gpointer) ((gconstpointer) (*_tmp5_).value));
	result = _tmp6_;
	_g_type_class_unref0 (enum_type);
	return result;
}

