/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_pfb_arb_resampler_fff = R"doc(Polyphase filterbank arbitrary resampler with float input, float output and float taps.

This block takes in a signal stream and performs arbitrary resampling. The resampling rate can be any real number . The resampling is done by constructing  filters where  is the interpolation rate. We then calculate  where .


Using  and , we can perform rational resampling where  is a rational number close to the input rate  where we have  filters and we cycle through them as a polyphase filterbank with a stride of  so that .


To get the arbitrary rate, we want to interpolate between two points. For each value out, we take an output from the current filter, , and the next filter  and then linearly interpolate between the two based on the real resampling rate we want.


The linear interpolation only provides us with an approximation to the real sampling rate specified. The error is a quantization error between the two filters we used as our interpolation points. To this end, the number of filters, , used determines the quantization error; the larger , the smaller the noise. You can design for a specified noise floor by setting the filter size (parameters ). The size defaults to 32 filters, which is about as good as most implementations need.


The trick with designing this filter is in how to specify the taps of the prototype filter. Like the PFB interpolator, the taps are specified using the interpolated filter rate. In this case, that rate is the input sample rate multiplied by the number of filters in the filterbank, which is also the interpolation rate. All other values should be relative to this rate.


For example, for a 32-filter arbitrary resampler and using the GNU Radio's firdes utility to build the filter, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as the interpolation rate ().





The theory behind this block can be found in Chapter 7.5 of the following book:

Constructor Specific Documentation:

Build the polyphase filterbank arbitrary resampler.

Args:
    rate : (float) Specifies the resampling rate to use
    taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
    filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_pfb_arb_resampler_fff_0 =
    R"doc()doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_pfb_arb_resampler_fff_1 =
    R"doc()doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_make = R"doc(Polyphase filterbank arbitrary resampler with float input, float output and float taps.

This block takes in a signal stream and performs arbitrary resampling. The resampling rate can be any real number . The resampling is done by constructing  filters where  is the interpolation rate. We then calculate  where .


Using  and , we can perform rational resampling where  is a rational number close to the input rate  where we have  filters and we cycle through them as a polyphase filterbank with a stride of  so that .


To get the arbitrary rate, we want to interpolate between two points. For each value out, we take an output from the current filter, , and the next filter  and then linearly interpolate between the two based on the real resampling rate we want.


The linear interpolation only provides us with an approximation to the real sampling rate specified. The error is a quantization error between the two filters we used as our interpolation points. To this end, the number of filters, , used determines the quantization error; the larger , the smaller the noise. You can design for a specified noise floor by setting the filter size (parameters ). The size defaults to 32 filters, which is about as good as most implementations need.


The trick with designing this filter is in how to specify the taps of the prototype filter. Like the PFB interpolator, the taps are specified using the interpolated filter rate. In this case, that rate is the input sample rate multiplied by the number of filters in the filterbank, which is also the interpolation rate. All other values should be relative to this rate.


For example, for a 32-filter arbitrary resampler and using the GNU Radio's firdes utility to build the filter, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as the interpolation rate ().





The theory behind this block can be found in Chapter 7.5 of the following book:

Constructor Specific Documentation:

Build the polyphase filterbank arbitrary resampler.

Args:
    rate : (float) Specifies the resampling rate to use
    taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the filter_size sampling rate.
    filter_size : (unsigned int) The number of filters in the filter bank. This is directly related to quantization noise introduced during the resampling. Defaults to 32 filters.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_set_taps = R"doc(Resets the filterbank's filter taps with the new prototype filter)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_taps = R"doc(Return a vector<vector<>> of the filterbank taps)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_print_taps = R"doc(Print all of the filterbank taps to screen.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_set_rate = R"doc(Sets the resampling rate of the block.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_set_phase = R"doc(Sets the current phase offset in radians (0 to 2pi).)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_phase = R"doc(Gets the current phase of the resampler in radians (2 to 2pi).)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_taps_per_filter = R"doc(Gets the number of taps per filter.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_interpolation_rate = R"doc(Gets the interpolation rate of the filter.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_decimation_rate = R"doc(Gets the decimation rate of the filter.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_fractional_rate = R"doc(Gets the fractional rate of the filter.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_group_delay = R"doc(Get the group delay of the filter.)doc";


static const char* __doc_gr_filter_pfb_arb_resampler_fff_phase_offset = R"doc(Calculates the phase offset expected by a sine wave of frequency  and sampling rate  (assuming input sine wave has 0 degree phase).)doc";
