{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11Monitor
    ( 

-- * Exported types
    X11Monitor(..)                          ,
    IsX11Monitor                            ,
    toX11Monitor                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isPrimary]("GI.Gdk.Objects.Monitor#g:method:isPrimary"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.Monitor#g:method:getDisplay"), [getGeometry]("GI.Gdk.Objects.Monitor#g:method:getGeometry"), [getHeightMm]("GI.Gdk.Objects.Monitor#g:method:getHeightMm"), [getManufacturer]("GI.Gdk.Objects.Monitor#g:method:getManufacturer"), [getModel]("GI.Gdk.Objects.Monitor#g:method:getModel"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRefreshRate]("GI.Gdk.Objects.Monitor#g:method:getRefreshRate"), [getScaleFactor]("GI.Gdk.Objects.Monitor#g:method:getScaleFactor"), [getSubpixelLayout]("GI.Gdk.Objects.Monitor#g:method:getSubpixelLayout"), [getWidthMm]("GI.Gdk.Objects.Monitor#g:method:getWidthMm"), [getWorkarea]("GI.Gdk.Objects.Monitor#g:method:getWorkarea").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveX11MonitorMethod                 ,
#endif

-- ** getOutput #method:getOutput#

    x11MonitorGetOutput                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor

#endif

-- | Memory-managed wrapper type.
newtype X11Monitor = X11Monitor (SP.ManagedPtr X11Monitor)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11Monitor where
    toManagedPtr (X11Monitor p) = p

foreign import ccall "gdk_x11_monitor_get_type"
    c_gdk_x11_monitor_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11Monitor where
    glibType = c_gdk_x11_monitor_get_type

instance B.Types.GObject X11Monitor

-- | Type class for types which can be safely cast to t'X11Monitor', for instance with `toX11Monitor`.
class (SP.GObject o, O.IsDescendantOf X11Monitor o) => IsX11Monitor o
instance (SP.GObject o, O.IsDescendantOf X11Monitor o) => IsX11Monitor o

instance O.HasParentTypes X11Monitor
type instance O.ParentTypes X11Monitor = '[Gdk.Monitor.Monitor, GObject.Object.Object]

-- | Cast to t'X11Monitor', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toX11Monitor :: (MIO.MonadIO m, IsX11Monitor o) => o -> m X11Monitor
toX11Monitor = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11Monitor

-- | Convert t'X11Monitor' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11Monitor) where
    gvalueGType_ = c_gdk_x11_monitor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11Monitor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11Monitor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11Monitor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11MonitorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11MonitorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11MonitorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11MonitorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11MonitorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11MonitorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11MonitorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11MonitorMethod "isPrimary" o = Gdk.Monitor.MonitorIsPrimaryMethodInfo
    ResolveX11MonitorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11MonitorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11MonitorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11MonitorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11MonitorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11MonitorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11MonitorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11MonitorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11MonitorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11MonitorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11MonitorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11MonitorMethod "getDisplay" o = Gdk.Monitor.MonitorGetDisplayMethodInfo
    ResolveX11MonitorMethod "getGeometry" o = Gdk.Monitor.MonitorGetGeometryMethodInfo
    ResolveX11MonitorMethod "getHeightMm" o = Gdk.Monitor.MonitorGetHeightMmMethodInfo
    ResolveX11MonitorMethod "getManufacturer" o = Gdk.Monitor.MonitorGetManufacturerMethodInfo
    ResolveX11MonitorMethod "getModel" o = Gdk.Monitor.MonitorGetModelMethodInfo
    ResolveX11MonitorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11MonitorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11MonitorMethod "getRefreshRate" o = Gdk.Monitor.MonitorGetRefreshRateMethodInfo
    ResolveX11MonitorMethod "getScaleFactor" o = Gdk.Monitor.MonitorGetScaleFactorMethodInfo
    ResolveX11MonitorMethod "getSubpixelLayout" o = Gdk.Monitor.MonitorGetSubpixelLayoutMethodInfo
    ResolveX11MonitorMethod "getWidthMm" o = Gdk.Monitor.MonitorGetWidthMmMethodInfo
    ResolveX11MonitorMethod "getWorkarea" o = Gdk.Monitor.MonitorGetWorkareaMethodInfo
    ResolveX11MonitorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11MonitorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11MonitorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11MonitorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11MonitorMethod t X11Monitor, O.OverloadedMethod info X11Monitor p) => OL.IsLabel t (X11Monitor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11MonitorMethod t X11Monitor, O.OverloadedMethod info X11Monitor p, R.HasField t X11Monitor p) => R.HasField t X11Monitor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11MonitorMethod t X11Monitor, O.OverloadedMethodInfo info X11Monitor) => OL.IsLabel t (O.MethodProxy info X11Monitor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11Monitor
type instance O.AttributeList X11Monitor = X11MonitorAttributeList
type X11MonitorAttributeList = ('[ '("display", Gdk.Monitor.MonitorDisplayPropertyInfo), '("geometry", Gdk.Monitor.MonitorGeometryPropertyInfo), '("heightMm", Gdk.Monitor.MonitorHeightMmPropertyInfo), '("manufacturer", Gdk.Monitor.MonitorManufacturerPropertyInfo), '("model", Gdk.Monitor.MonitorModelPropertyInfo), '("refreshRate", Gdk.Monitor.MonitorRefreshRatePropertyInfo), '("scaleFactor", Gdk.Monitor.MonitorScaleFactorPropertyInfo), '("subpixelLayout", Gdk.Monitor.MonitorSubpixelLayoutPropertyInfo), '("widthMm", Gdk.Monitor.MonitorWidthMmPropertyInfo), '("workarea", Gdk.Monitor.MonitorWorkareaPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11Monitor = X11MonitorSignalList
type X11MonitorSignalList = ('[ '("invalidate", Gdk.Monitor.MonitorInvalidateSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method X11Monitor::get_output
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_monitor_get_output" gdk_x11_monitor_get_output :: 
    Ptr Gdk.Monitor.Monitor ->              -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO FCT.CULong

-- | /No description available in the introspection data./
x11MonitorGetOutput ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Monitor.IsMonitor a) =>
    a
    -> m FCT.CULong
x11MonitorGetOutput monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- gdk_x11_monitor_get_output monitor'
    touchManagedPtr monitor
    return result

#if defined(ENABLE_OVERLOADING)
#endif


