{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Gio.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "namespace Gio"
 , ""
 , "# The length argument is an out value, but it is not marked as such in"
 , "# the bindings."
 , "ignore TlsPassword.get_value"
 , ""
 , "# These API elements refer to symbols which are dynamically loaded,"
 , "# so the linker cannot resolve them."
 , "ignore IOModule"
 , "ignore io_modules_load_all_in_directory"
 , "ignore io_modules_load_all_in_directory_with_scope"
 , ""
 , "# This is a user_data type argument, but it is not marked as such."
 , "set-attr Gio/AsyncReadyCallback/@parameters/data closure 2"
 , ""
 , "# The object data is nullable, but it is not marked as such"
 , "set-attr Gio/TaskThreadFunc/@parameters/source_object nullable 1"
 , ""
 , "# Properly marked as filename in recent Gio versions."
 , "set-attr Gio/AppInfo/get_executable/@return-value/@type name filename"
 , ""
 , "# The return value is nullable, but it is not marked as such."
 , "set-attr Gio/AppInfo/get_icon/@return-value nullable 1"
 , ""
 , "# Return value is nullable, but not marked as such."
 , "# https://github.com/haskell-gi/haskell-gi/issues/139"
 , "set-attr Gio/Volume/get_mount/@return-value nullable 1"
 , ""
 , "# Return value is nullable, but is only marked as such in recent"
 , "# versions."
 , "set-attr Gio/InetAddress/new_from_string/@return-value nullable 1"
 , ""
 , "# Return value is nullable, but it is only marked as such in recent"
 , "# versions."
 , "set-attr Gio/DBusNodeInfo/lookup_interface/@return-value nullable 1"
 , ""
 , "# These are useful to expose"
 , "set-attr Gio/SeekableIface haskell-gi-force-visible 1"
 , "set-attr Gio/InputStreamClass haskell-gi-force-visible 1"
 , ""
 , "# These are included by mistake in the introspection data of"
 , "# glib-2.60.0, but they are linux-specific."
 , "# See https://github.com/haskell-gi/haskell-gi/issues/218"
 , "if osx"
 , "   delete-node Gio/DesktopAppInfo"
 , "   delete-node Gio/DesktopAppInfoClass"
 , "   delete-node Gio/DesktopAppInfoLookup"
 , "   delete-node Gio/DesktopAppInfoLookupIface"
 , "   delete-node Gio/DesktopAppLaunchCallback"
 , "endif"
 , ""
 , "if windows"
 , "   delete-node Gio/DesktopAppInfo"
 , "   delete-node Gio/DesktopAppInfoClass"
 , "   delete-node Gio/DesktopAppInfoLookup"
 , "   delete-node Gio/DesktopAppInfoLookupIface"
 , "   delete-node Gio/DesktopAppLaunchCallback"
 , "endif"
 , ""
 , "# The return value can be null, but it is not marked as such in the"
 , "# introspection data, leading to a rather confusing error message:"
 , "# https://github.com/haskell-gi/haskell-gi/issues/142"
 , "# https://github.com/haskell-gi/haskell-gi/issues/143"
 , "set-attr Gio/Application/new/@return-value nullable 1"
 , ""
 , "# The 'parameter' parameter for the activate callback is nullable, but"
 , "# it is not marked as such in the introspection data."
 , "set-attr Gio/ActionEntry/activate/activate/@parameters/parameter nullable 1"
 , ""
 , "# Not supported on Windows."
 , "if windows"
 , "   ignore DBusMessage.get_unix_fd_list"
 , "   ignore DBusMessage.set_unix_fd_list"
 , "   ignore DBusMethodInvocation.return_value_with_unix_fd_list"
 , "   ignore unix_mounts_changed_since"
 , "   ignore unix_mount_points_changed_since"
 , "   ignore unix_mount_is_system_internal"
 , "   ignore unix_mount_is_readonly"
 , "   ignore unix_mount_guess_symbolic_icon"
 , "   ignore unix_mount_guess_should_display"
 , "   ignore unix_mount_guess_name"
 , "   ignore unix_mount_guess_icon"
 , "   ignore unix_mount_guess_can_eject"
 , "   ignore unix_mount_get_mount_path"
 , "   ignore unix_mount_get_fs_type"
 , "   ignore unix_mount_get_device_path"
 , "   ignore unix_mount_free"
 , "   ignore unix_mount_compare"
 , "   ignore unix_is_mount_path_system_internal"
 , "   ignore unix_is_mount_path_system_internal"
 , "   ignore DBusConnection.call_with_unix_fd_list_finish"
 , "   ignore DBusConnection.call_with_unix_fd_list_sync"
 , "   ignore DBusConnection.call_with_unix_fd_list"
 , "   ignore UnixFDList.get_type"
 , "   ignore UnixFDList.append"
 , "   ignore UnixFDList.get"
 , "   ignore UnixFDList.get_length"
 , "   ignore UnixFDList.peek_fds"
 , "   ignore UnixFDList.steal_fds"
 , "   ignore UnixFDList.new"
 , "   ignore UnixFDList.new_from_array"
 , "   ignore DBusProxy.call_with_unix_fd_list_finish"
 , "   ignore DBusProxy.call_with_unix_fd_list_sync"
 , "   ignore DBusProxy.call_with_unix_fd_list"
 , "endif"
 , ""
 , "# Wrongly included in the OSX introspection data, see"
 , "# https://github.com/haskell-gi/haskell-gi/issues/227"
 , "if osx"
 , "   delete-node Gio/content_type_get_mime_dirs"
 , "   delete-node Gio/content_type_set_mime_dirs"
 , "endif"
 , ""
 , "# ... and similarly in windows"
 , "if windows"
 , "   delete-node Gio/content_type_get_mime_dirs"
 , "   delete-node Gio/content_type_set_mime_dirs"
 , "endif"
 , ""
 , "# Generated from gio 2.84.1 with xsltproc Nullable.xslt Gio-2.0.gir"
 , "set-attr Gio/Action/parse_detailed_name/@parameters/target_value nullable 1"
 , "set-attr Gio/Action/print_detailed_name/@parameters/target_value nullable 1"
 , "set-attr Gio/Action/activate/@parameters/parameter nullable 1"
 , "set-attr Gio/Action/get_parameter_type/@return-value nullable 1"
 , "set-attr Gio/Action/get_state/@return-value nullable 1"
 , "set-attr Gio/Action/get_state_hint/@return-value nullable 1"
 , "set-attr Gio/Action/get_state_type/@return-value nullable 1"
 , "set-attr Gio/Action/activate/@parameters/parameter nullable 1"
 , "set-attr Gio/Action/get_parameter_type/@return-value nullable 1"
 , "set-attr Gio/Action/get_state/@return-value nullable 1"
 , "set-attr Gio/Action/get_state_hint/@return-value nullable 1"
 , "set-attr Gio/Action/get_state_type/@return-value nullable 1"
 , "set-attr Gio/ActionEntry/activate/activate/@parameters/user_data nullable 1"
 , "set-attr Gio/ActionEntry/change_state/change_state/@parameters/user_data nullable 1"
 , "set-attr Gio/ActionGroup/activate_action/@parameters/parameter nullable 1"
 , "set-attr Gio/ActionGroup/get_action_parameter_type/@return-value nullable 1"
 , "set-attr Gio/ActionGroup/get_action_state/@return-value nullable 1"
 , "set-attr Gio/ActionGroup/get_action_state_hint/@return-value nullable 1"
 , "set-attr Gio/ActionGroup/get_action_state_type/@return-value nullable 1"
 , "set-attr Gio/ActionGroup/activate_action/@parameters/parameter nullable 1"
 , "set-attr Gio/ActionGroup/get_action_parameter_type/@return-value nullable 1"
 , "set-attr Gio/ActionGroup/get_action_state/@return-value nullable 1"
 , "set-attr Gio/ActionGroup/get_action_state_hint/@return-value nullable 1"
 , "set-attr Gio/ActionGroup/get_action_state_type/@return-value nullable 1"
 , "set-attr Gio/ActionGroupInterface/get_action_parameter_type/get_action_parameter_type/@return-value nullable 1"
 , "set-attr Gio/ActionGroupInterface/get_action_state_type/get_action_state_type/@return-value nullable 1"
 , "set-attr Gio/ActionGroupInterface/get_action_state_hint/get_action_state_hint/@return-value nullable 1"
 , "set-attr Gio/ActionGroupInterface/get_action_state/get_action_state/@return-value nullable 1"
 , "set-attr Gio/ActionGroupInterface/activate_action/activate_action/@parameters/parameter nullable 1"
 , "set-attr Gio/ActionInterface/get_parameter_type/get_parameter_type/@return-value nullable 1"
 , "set-attr Gio/ActionInterface/get_state_type/get_state_type/@return-value nullable 1"
 , "set-attr Gio/ActionInterface/get_state_hint/get_state_hint/@return-value nullable 1"
 , "set-attr Gio/ActionInterface/get_state/get_state/@return-value nullable 1"
 , "set-attr Gio/ActionInterface/activate/activate/@parameters/parameter nullable 1"
 , "set-attr Gio/ActionMap/lookup_action/@return-value nullable 1"
 , "set-attr Gio/ActionMap/add_action_entries/@parameters/user_data nullable 1"
 , "set-attr Gio/ActionMap/lookup_action/@return-value nullable 1"
 , "set-attr Gio/ActionMapInterface/lookup_action/lookup_action/@return-value nullable 1"
 , "set-attr Gio/AppInfo/create_from_commandline/@parameters/application_name nullable 1"
 , "set-attr Gio/AppInfo/get_default_for_type/@return-value nullable 1"
 , "set-attr Gio/AppInfo/get_default_for_type_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AppInfo/get_default_for_type_async/@parameters/callback nullable 1"
 , "set-attr Gio/AppInfo/get_default_for_type_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AppInfo/get_default_for_uri_scheme/@return-value nullable 1"
 , "set-attr Gio/AppInfo/get_default_for_uri_scheme_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AppInfo/get_default_for_uri_scheme_async/@parameters/callback nullable 1"
 , "set-attr Gio/AppInfo/get_default_for_uri_scheme_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AppInfo/launch_default_for_uri/@parameters/context nullable 1"
 , "set-attr Gio/AppInfo/launch_default_for_uri_async/@parameters/context nullable 1"
 , "set-attr Gio/AppInfo/launch_default_for_uri_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AppInfo/launch_default_for_uri_async/@parameters/callback nullable 1"
 , "set-attr Gio/AppInfo/launch_default_for_uri_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AppInfo/get_commandline/@return-value nullable 1"
 , "set-attr Gio/AppInfo/get_description/@return-value nullable 1"
 , "set-attr Gio/AppInfo/get_icon/@return-value nullable 1"
 , "set-attr Gio/AppInfo/get_id/@return-value nullable 1"
 , "set-attr Gio/AppInfo/launch/@parameters/files nullable 1"
 , "set-attr Gio/AppInfo/launch/@parameters/context nullable 1"
 , "set-attr Gio/AppInfo/launch_uris/@parameters/uris nullable 1"
 , "set-attr Gio/AppInfo/launch_uris/@parameters/context nullable 1"
 , "set-attr Gio/AppInfo/launch_uris_async/@parameters/uris nullable 1"
 , "set-attr Gio/AppInfo/launch_uris_async/@parameters/context nullable 1"
 , "set-attr Gio/AppInfo/launch_uris_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AppInfo/launch_uris_async/@parameters/callback nullable 1"
 , "set-attr Gio/AppInfo/launch_uris_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AppInfo/get_commandline/@return-value nullable 1"
 , "set-attr Gio/AppInfo/get_description/@return-value nullable 1"
 , "set-attr Gio/AppInfo/get_icon/@return-value nullable 1"
 , "set-attr Gio/AppInfo/get_id/@return-value nullable 1"
 , "set-attr Gio/AppInfo/launch/@parameters/files nullable 1"
 , "set-attr Gio/AppInfo/launch/@parameters/context nullable 1"
 , "set-attr Gio/AppInfo/launch_uris/@parameters/uris nullable 1"
 , "set-attr Gio/AppInfo/launch_uris/@parameters/context nullable 1"
 , "set-attr Gio/AppInfo/launch_uris_async/@parameters/uris nullable 1"
 , "set-attr Gio/AppInfo/launch_uris_async/@parameters/context nullable 1"
 , "set-attr Gio/AppInfo/launch_uris_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AppInfo/launch_uris_async/@parameters/callback nullable 1"
 , "set-attr Gio/AppInfo/launch_uris_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AppInfoIface/get_id/get_id/@return-value nullable 1"
 , "set-attr Gio/AppInfoIface/get_description/get_description/@return-value nullable 1"
 , "set-attr Gio/AppInfoIface/get_icon/get_icon/@return-value nullable 1"
 , "set-attr Gio/AppInfoIface/launch/launch/@parameters/files nullable 1"
 , "set-attr Gio/AppInfoIface/launch/launch/@parameters/context nullable 1"
 , "set-attr Gio/AppInfoIface/launch_uris/launch_uris/@parameters/uris nullable 1"
 , "set-attr Gio/AppInfoIface/launch_uris/launch_uris/@parameters/context nullable 1"
 , "set-attr Gio/AppInfoIface/get_commandline/get_commandline/@return-value nullable 1"
 , "set-attr Gio/AppInfoIface/launch_uris_async/launch_uris_async/@parameters/uris nullable 1"
 , "set-attr Gio/AppInfoIface/launch_uris_async/launch_uris_async/@parameters/context nullable 1"
 , "set-attr Gio/AppInfoIface/launch_uris_async/launch_uris_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AppInfoIface/launch_uris_async/launch_uris_async/@parameters/callback nullable 1"
 , "set-attr Gio/AppInfoIface/launch_uris_async/launch_uris_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AppLaunchContext/get_display/@return-value nullable 1"
 , "set-attr Gio/AppLaunchContext/get_startup_notify_id/@return-value nullable 1"
 , "set-attr Gio/AppLaunchContext/get_startup_notify_id/@parameters/info nullable 1"
 , "set-attr Gio/AppLaunchContext/get_startup_notify_id/@parameters/files nullable 1"
 , "set-attr Gio/AppLaunchContext/get_display/@return-value nullable 1"
 , "set-attr Gio/AppLaunchContext/get_startup_notify_id/@return-value nullable 1"
 , "set-attr Gio/AppLaunchContext/get_startup_notify_id/@parameters/info nullable 1"
 , "set-attr Gio/AppLaunchContext/get_startup_notify_id/@parameters/files nullable 1"
 , "set-attr Gio/AppLaunchContext/launch-started/@parameters/platform_data nullable 1"
 , "set-attr Gio/AppLaunchContextClass/get_display/get_display/@return-value nullable 1"
 , "set-attr Gio/AppLaunchContextClass/get_startup_notify_id/get_startup_notify_id/@return-value nullable 1"
 , "set-attr Gio/AppLaunchContextClass/get_startup_notify_id/get_startup_notify_id/@parameters/info nullable 1"
 , "set-attr Gio/AppLaunchContextClass/get_startup_notify_id/get_startup_notify_id/@parameters/files nullable 1"
 , "set-attr Gio/Application/new/@parameters/application_id nullable 1"
 , "set-attr Gio/Application/get_default/@return-value nullable 1"
 , "set-attr Gio/Application/add_main_option/@parameters/arg_description nullable 1"
 , "set-attr Gio/Application/get_application_id/@return-value nullable 1"
 , "set-attr Gio/Application/get_dbus_connection/@return-value nullable 1"
 , "set-attr Gio/Application/get_dbus_object_path/@return-value nullable 1"
 , "set-attr Gio/Application/get_resource_base_path/@return-value nullable 1"
 , "set-attr Gio/Application/get_version/@return-value nullable 1"
 , "set-attr Gio/Application/register/@parameters/cancellable nullable 1"
 , "set-attr Gio/Application/run/@parameters/argv nullable 1"
 , "set-attr Gio/Application/send_notification/@parameters/id nullable 1"
 , "set-attr Gio/Application/set_action_group/@parameters/action_group nullable 1"
 , "set-attr Gio/Application/set_application_id/@parameters/application_id nullable 1"
 , "set-attr Gio/Application/set_default/@parameters/application nullable 1"
 , "set-attr Gio/Application/set_option_context_description/@parameters/description nullable 1"
 , "set-attr Gio/Application/set_option_context_parameter_string/@parameters/parameter_string nullable 1"
 , "set-attr Gio/Application/set_option_context_summary/@parameters/summary nullable 1"
 , "set-attr Gio/Application/set_resource_base_path/@parameters/resource_path nullable 1"
 , "set-attr Gio/ApplicationCommandLine/get_stdin/@return-value nullable 1"
 , "set-attr Gio/ApplicationCommandLine/get_cwd/@return-value nullable 1"
 , "set-attr Gio/ApplicationCommandLine/get_platform_data/@return-value nullable 1"
 , "set-attr Gio/ApplicationCommandLine/get_stdin/@return-value nullable 1"
 , "set-attr Gio/ApplicationCommandLine/getenv/@return-value nullable 1"
 , "set-attr Gio/ApplicationCommandLineClass/get_stdin/get_stdin/@return-value nullable 1"
 , "set-attr Gio/AsyncInitable/new_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AsyncInitable/new_async/@parameters/callback nullable 1"
 , "set-attr Gio/AsyncInitable/new_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AsyncInitable/new_async/@parameters/first_property_name nullable 1"
 , "set-attr Gio/AsyncInitable/new_valist_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AsyncInitable/new_valist_async/@parameters/callback nullable 1"
 , "set-attr Gio/AsyncInitable/new_valist_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AsyncInitable/newv_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AsyncInitable/newv_async/@parameters/callback nullable 1"
 , "set-attr Gio/AsyncInitable/newv_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AsyncInitable/init_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AsyncInitable/init_async/@parameters/callback nullable 1"
 , "set-attr Gio/AsyncInitable/init_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AsyncInitable/init_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AsyncInitable/init_async/@parameters/callback nullable 1"
 , "set-attr Gio/AsyncInitable/init_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AsyncInitableIface/init_async/init_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/AsyncInitableIface/init_async/init_async/@parameters/callback nullable 1"
 , "set-attr Gio/AsyncInitableIface/init_async/init_async/@parameters/user_data nullable 1"
 , "set-attr Gio/AsyncReadyCallback/@parameters/source_object nullable 1"
 , "set-attr Gio/AsyncReadyCallback/@parameters/data nullable 1"
 , "set-attr Gio/AsyncResult/get_source_object/@return-value nullable 1"
 , "set-attr Gio/AsyncResult/get_user_data/@return-value nullable 1"
 , "set-attr Gio/AsyncResult/is_tagged/@parameters/source_tag nullable 1"
 , "set-attr Gio/AsyncResult/get_source_object/@return-value nullable 1"
 , "set-attr Gio/AsyncResult/get_user_data/@return-value nullable 1"
 , "set-attr Gio/AsyncResult/is_tagged/@parameters/source_tag nullable 1"
 , "set-attr Gio/AsyncResultIface/get_user_data/get_user_data/@return-value nullable 1"
 , "set-attr Gio/AsyncResultIface/get_source_object/get_source_object/@return-value nullable 1"
 , "set-attr Gio/AsyncResultIface/is_tagged/is_tagged/@parameters/source_tag nullable 1"
 , "set-attr Gio/BufferedInputStream/fill/@parameters/cancellable nullable 1"
 , "set-attr Gio/BufferedInputStream/fill_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/BufferedInputStream/fill_async/@parameters/callback nullable 1"
 , "set-attr Gio/BufferedInputStream/fill_async/@parameters/user_data nullable 1"
 , "set-attr Gio/BufferedInputStream/fill/@parameters/cancellable nullable 1"
 , "set-attr Gio/BufferedInputStream/fill_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/BufferedInputStream/fill_async/@parameters/callback nullable 1"
 , "set-attr Gio/BufferedInputStream/fill_async/@parameters/user_data nullable 1"
 , "set-attr Gio/BufferedInputStream/read_byte/@parameters/cancellable nullable 1"
 , "set-attr Gio/BufferedInputStreamClass/fill/fill/@parameters/cancellable nullable 1"
 , "set-attr Gio/BufferedInputStreamClass/fill_async/fill_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/BufferedInputStreamClass/fill_async/fill_async/@parameters/callback nullable 1"
 , "set-attr Gio/BufferedInputStreamClass/fill_async/fill_async/@parameters/user_data nullable 1"
 , "set-attr Gio/BusAcquiredCallback/@parameters/user_data nullable 1"
 , "set-attr Gio/BusNameAcquiredCallback/@parameters/user_data nullable 1"
 , "set-attr Gio/BusNameAppearedCallback/@parameters/user_data nullable 1"
 , "set-attr Gio/BusNameLostCallback/@parameters/user_data nullable 1"
 , "set-attr Gio/BusNameVanishedCallback/@parameters/user_data nullable 1"
 , "set-attr Gio/Cancellable/get_current/@return-value nullable 1"
 , "set-attr Gio/Cancellable/cancelled/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/cancel/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/connect/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/connect/@parameters/data nullable 1"
 , "set-attr Gio/Cancellable/connect/@parameters/data_destroy_func nullable 1"
 , "set-attr Gio/Cancellable/disconnect/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/get_fd/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/is_cancelled/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/make_pollfd/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/pop_current/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/push_current/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/release_fd/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/reset/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/set_error_if_cancelled/@parameters/cancellable nullable 1"
 , "set-attr Gio/Cancellable/source_new/@parameters/cancellable nullable 1"
 , "set-attr Gio/CancellableClass/cancelled/cancelled/@parameters/cancellable nullable 1"
 , "set-attr Gio/CancellableSourceFunc/@parameters/cancellable nullable 1"
 , "set-attr Gio/CancellableSourceFunc/@parameters/data nullable 1"
 , "set-attr Gio/Converter/convert/@parameters/inbuf nullable 1"
 , "set-attr Gio/ConverterIface/convert/convert/@parameters/inbuf nullable 1"
 , "set-attr Gio/Credentials/get_native/@return-value nullable 1"
 , "set-attr Gio/DBusActionGroup/get/@parameters/bus_name nullable 1"
 , "set-attr Gio/DBusAnnotationInfo/lookup/@return-value nullable 1"
 , "set-attr Gio/DBusAnnotationInfo/lookup/@parameters/annotations nullable 1"
 , "set-attr Gio/DBusAuthObserver/authorize_authenticated_peer/@parameters/credentials nullable 1"
 , "set-attr Gio/DBusAuthObserver/authorize-authenticated-peer/@parameters/credentials nullable 1"
 , "set-attr Gio/DBusConnection/new_for_address_sync/@parameters/observer nullable 1"
 , "set-attr Gio/DBusConnection/new_for_address_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/new_sync/@parameters/guid nullable 1"
 , "set-attr Gio/DBusConnection/new_sync/@parameters/observer nullable 1"
 , "set-attr Gio/DBusConnection/new_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/new/@parameters/guid nullable 1"
 , "set-attr Gio/DBusConnection/new/@parameters/observer nullable 1"
 , "set-attr Gio/DBusConnection/new/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/new/@parameters/callback nullable 1"
 , "set-attr Gio/DBusConnection/new/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusConnection/new_for_address/@parameters/observer nullable 1"
 , "set-attr Gio/DBusConnection/new_for_address/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/new_for_address/@parameters/callback nullable 1"
 , "set-attr Gio/DBusConnection/new_for_address/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusConnection/add_filter/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusConnection/call/@parameters/bus_name nullable 1"
 , "set-attr Gio/DBusConnection/call/@parameters/parameters nullable 1"
 , "set-attr Gio/DBusConnection/call/@parameters/reply_type nullable 1"
 , "set-attr Gio/DBusConnection/call/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/call/@parameters/callback nullable 1"
 , "set-attr Gio/DBusConnection/call/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusConnection/call_sync/@parameters/bus_name nullable 1"
 , "set-attr Gio/DBusConnection/call_sync/@parameters/parameters nullable 1"
 , "set-attr Gio/DBusConnection/call_sync/@parameters/reply_type nullable 1"
 , "set-attr Gio/DBusConnection/call_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list/@parameters/bus_name nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list/@parameters/parameters nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list/@parameters/reply_type nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list/@parameters/fd_list nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list/@parameters/callback nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list_finish/@parameters/out_fd_list nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list_sync/@parameters/bus_name nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list_sync/@parameters/parameters nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list_sync/@parameters/reply_type nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list_sync/@parameters/fd_list nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list_sync/@parameters/out_fd_list nullable 1"
 , "set-attr Gio/DBusConnection/call_with_unix_fd_list_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/close/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/close/@parameters/callback nullable 1"
 , "set-attr Gio/DBusConnection/close/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusConnection/close_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/emit_signal/@parameters/destination_bus_name nullable 1"
 , "set-attr Gio/DBusConnection/emit_signal/@parameters/parameters nullable 1"
 , "set-attr Gio/DBusConnection/flush/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/flush/@parameters/callback nullable 1"
 , "set-attr Gio/DBusConnection/flush/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusConnection/flush_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/get_peer_credentials/@return-value nullable 1"
 , "set-attr Gio/DBusConnection/get_unique_name/@return-value nullable 1"
 , "set-attr Gio/DBusConnection/register_object/@parameters/vtable nullable 1"
 , "set-attr Gio/DBusConnection/register_object/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusConnection/register_object_with_closures/@parameters/method_call_closure nullable 1"
 , "set-attr Gio/DBusConnection/register_object_with_closures/@parameters/get_property_closure nullable 1"
 , "set-attr Gio/DBusConnection/register_object_with_closures/@parameters/set_property_closure nullable 1"
 , "set-attr Gio/DBusConnection/register_object_with_closures2/@parameters/method_call_closure nullable 1"
 , "set-attr Gio/DBusConnection/register_object_with_closures2/@parameters/get_property_closure nullable 1"
 , "set-attr Gio/DBusConnection/register_object_with_closures2/@parameters/set_property_closure nullable 1"
 , "set-attr Gio/DBusConnection/register_subtree/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusConnection/send_message_with_reply/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/send_message_with_reply/@parameters/callback nullable 1"
 , "set-attr Gio/DBusConnection/send_message_with_reply/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusConnection/send_message_with_reply_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusConnection/signal_subscribe/@parameters/sender nullable 1"
 , "set-attr Gio/DBusConnection/signal_subscribe/@parameters/interface_name nullable 1"
 , "set-attr Gio/DBusConnection/signal_subscribe/@parameters/member nullable 1"
 , "set-attr Gio/DBusConnection/signal_subscribe/@parameters/object_path nullable 1"
 , "set-attr Gio/DBusConnection/signal_subscribe/@parameters/arg0 nullable 1"
 , "set-attr Gio/DBusConnection/signal_subscribe/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusConnection/signal_subscribe/@parameters/user_data_free_func nullable 1"
 , "set-attr Gio/DBusConnection/closed/@parameters/error nullable 1"
 , "set-attr Gio/DBusError/get_remote_error/@return-value nullable 1"
 , "set-attr Gio/DBusError/set_dbus_error/@parameters/format nullable 1"
 , "set-attr Gio/DBusError/set_dbus_error_valist/@parameters/format nullable 1"
 , "set-attr Gio/DBusInterface/dup_object/@return-value nullable 1"
 , "set-attr Gio/DBusInterface/get_object/@return-value nullable 1"
 , "set-attr Gio/DBusInterface/set_object/@parameters/object nullable 1"
 , "set-attr Gio/DBusInterface/dup_object/@return-value nullable 1"
 , "set-attr Gio/DBusInterface/get_object/@return-value nullable 1"
 , "set-attr Gio/DBusInterface/set_object/@parameters/object nullable 1"
 , "set-attr Gio/DBusInterfaceGetPropertyFunc/@parameters/sender nullable 1"
 , "set-attr Gio/DBusInterfaceGetPropertyFunc/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusInterfaceIface/get_object/get_object/@return-value nullable 1"
 , "set-attr Gio/DBusInterfaceIface/set_object/set_object/@parameters/object nullable 1"
 , "set-attr Gio/DBusInterfaceIface/dup_object/dup_object/@return-value nullable 1"
 , "set-attr Gio/DBusInterfaceInfo/lookup_method/@return-value nullable 1"
 , "set-attr Gio/DBusInterfaceInfo/lookup_property/@return-value nullable 1"
 , "set-attr Gio/DBusInterfaceInfo/lookup_signal/@return-value nullable 1"
 , "set-attr Gio/DBusInterfaceMethodCallFunc/@parameters/sender nullable 1"
 , "set-attr Gio/DBusInterfaceMethodCallFunc/@parameters/interface_name nullable 1"
 , "set-attr Gio/DBusInterfaceMethodCallFunc/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusInterfaceSetPropertyFunc/@parameters/sender nullable 1"
 , "set-attr Gio/DBusInterfaceSetPropertyFunc/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusInterfaceSkeleton/get_connection/@return-value nullable 1"
 , "set-attr Gio/DBusInterfaceSkeleton/get_object_path/@return-value nullable 1"
 , "set-attr Gio/DBusMenuModel/get/@parameters/bus_name nullable 1"
 , "set-attr Gio/DBusMessage/new_method_call/@parameters/name nullable 1"
 , "set-attr Gio/DBusMessage/new_method_call/@parameters/interface_ nullable 1"
 , "set-attr Gio/DBusMessage/get_arg0/@return-value nullable 1"
 , "set-attr Gio/DBusMessage/get_arg0_path/@return-value nullable 1"
 , "set-attr Gio/DBusMessage/get_body/@return-value nullable 1"
 , "set-attr Gio/DBusMessage/get_destination/@return-value nullable 1"
 , "set-attr Gio/DBusMessage/get_error_name/@return-value nullable 1"
 , "set-attr Gio/DBusMessage/get_header/@return-value nullable 1"
 , "set-attr Gio/DBusMessage/get_interface/@return-value nullable 1"
 , "set-attr Gio/DBusMessage/get_member/@return-value nullable 1"
 , "set-attr Gio/DBusMessage/get_path/@return-value nullable 1"
 , "set-attr Gio/DBusMessage/get_sender/@return-value nullable 1"
 , "set-attr Gio/DBusMessage/get_unix_fd_list/@return-value nullable 1"
 , "set-attr Gio/DBusMessage/set_destination/@parameters/value nullable 1"
 , "set-attr Gio/DBusMessage/set_error_name/@parameters/message nullable 1"
 , "set-attr Gio/DBusMessage/set_header/@parameters/value nullable 1"
 , "set-attr Gio/DBusMessage/set_interface/@parameters/value nullable 1"
 , "set-attr Gio/DBusMessage/set_member/@parameters/value nullable 1"
 , "set-attr Gio/DBusMessage/set_path/@parameters/value nullable 1"
 , "set-attr Gio/DBusMessage/set_sender/@parameters/value nullable 1"
 , "set-attr Gio/DBusMessage/set_signature/@parameters/value nullable 1"
 , "set-attr Gio/DBusMessage/set_unix_fd_list/@parameters/fd_list nullable 1"
 , "set-attr Gio/DBusMessageFilterFunction/@return-value nullable 1"
 , "set-attr Gio/DBusMessageFilterFunction/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusMethodInvocation/get_interface_name/@return-value nullable 1"
 , "set-attr Gio/DBusMethodInvocation/get_method_info/@return-value nullable 1"
 , "set-attr Gio/DBusMethodInvocation/get_property_info/@return-value nullable 1"
 , "set-attr Gio/DBusMethodInvocation/get_sender/@return-value nullable 1"
 , "set-attr Gio/DBusMethodInvocation/get_user_data/@return-value nullable 1"
 , "set-attr Gio/DBusMethodInvocation/return_value/@parameters/parameters nullable 1"
 , "set-attr Gio/DBusMethodInvocation/return_value_with_unix_fd_list/@parameters/parameters nullable 1"
 , "set-attr Gio/DBusMethodInvocation/return_value_with_unix_fd_list/@parameters/fd_list nullable 1"
 , "set-attr Gio/DBusNodeInfo/lookup_interface/@return-value nullable 1"
 , "set-attr Gio/DBusObject/get_interface/@return-value nullable 1"
 , "set-attr Gio/DBusObject/get_interface/@return-value nullable 1"
 , "set-attr Gio/DBusObjectIface/get_interface/get_interface/@return-value nullable 1"
 , "set-attr Gio/DBusObjectManager/get_interface/@return-value nullable 1"
 , "set-attr Gio/DBusObjectManager/get_object/@return-value nullable 1"
 , "set-attr Gio/DBusObjectManager/get_interface/@return-value nullable 1"
 , "set-attr Gio/DBusObjectManager/get_object/@return-value nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_for_bus_sync/@parameters/get_proxy_type_func nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_for_bus_sync/@parameters/get_proxy_type_user_data nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_for_bus_sync/@parameters/get_proxy_type_destroy_notify nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_for_bus_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_sync/@parameters/name nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_sync/@parameters/get_proxy_type_func nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_sync/@parameters/get_proxy_type_user_data nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_sync/@parameters/get_proxy_type_destroy_notify nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new/@parameters/get_proxy_type_func nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new/@parameters/get_proxy_type_user_data nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new/@parameters/get_proxy_type_destroy_notify nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new/@parameters/callback nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_for_bus/@parameters/get_proxy_type_func nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_for_bus/@parameters/get_proxy_type_user_data nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_for_bus/@parameters/get_proxy_type_destroy_notify nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_for_bus/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_for_bus/@parameters/callback nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/new_for_bus/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusObjectManagerClient/get_name_owner/@return-value nullable 1"
 , "set-attr Gio/DBusObjectManagerIface/get_object/get_object/@return-value nullable 1"
 , "set-attr Gio/DBusObjectManagerIface/get_interface/get_interface/@return-value nullable 1"
 , "set-attr Gio/DBusObjectManagerServer/get_connection/@return-value nullable 1"
 , "set-attr Gio/DBusObjectManagerServer/set_connection/@parameters/connection nullable 1"
 , "set-attr Gio/DBusProxy/new_for_bus_sync/@parameters/info nullable 1"
 , "set-attr Gio/DBusProxy/new_for_bus_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusProxy/new_sync/@parameters/info nullable 1"
 , "set-attr Gio/DBusProxy/new_sync/@parameters/name nullable 1"
 , "set-attr Gio/DBusProxy/new_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusProxy/new/@parameters/info nullable 1"
 , "set-attr Gio/DBusProxy/new/@parameters/name nullable 1"
 , "set-attr Gio/DBusProxy/new/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusProxy/new/@parameters/callback nullable 1"
 , "set-attr Gio/DBusProxy/new/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusProxy/new_for_bus/@parameters/info nullable 1"
 , "set-attr Gio/DBusProxy/new_for_bus/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusProxy/new_for_bus/@parameters/callback nullable 1"
 , "set-attr Gio/DBusProxy/new_for_bus/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusProxy/call/@parameters/parameters nullable 1"
 , "set-attr Gio/DBusProxy/call/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusProxy/call/@parameters/callback nullable 1"
 , "set-attr Gio/DBusProxy/call/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusProxy/call_sync/@parameters/parameters nullable 1"
 , "set-attr Gio/DBusProxy/call_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusProxy/call_with_unix_fd_list/@parameters/parameters nullable 1"
 , "set-attr Gio/DBusProxy/call_with_unix_fd_list/@parameters/fd_list nullable 1"
 , "set-attr Gio/DBusProxy/call_with_unix_fd_list/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusProxy/call_with_unix_fd_list/@parameters/callback nullable 1"
 , "set-attr Gio/DBusProxy/call_with_unix_fd_list/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusProxy/call_with_unix_fd_list_finish/@parameters/out_fd_list nullable 1"
 , "set-attr Gio/DBusProxy/call_with_unix_fd_list_sync/@parameters/parameters nullable 1"
 , "set-attr Gio/DBusProxy/call_with_unix_fd_list_sync/@parameters/fd_list nullable 1"
 , "set-attr Gio/DBusProxy/call_with_unix_fd_list_sync/@parameters/out_fd_list nullable 1"
 , "set-attr Gio/DBusProxy/call_with_unix_fd_list_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusProxy/get_cached_property/@return-value nullable 1"
 , "set-attr Gio/DBusProxy/get_cached_property_names/@return-value nullable 1"
 , "set-attr Gio/DBusProxy/get_interface_info/@return-value nullable 1"
 , "set-attr Gio/DBusProxy/get_name/@return-value nullable 1"
 , "set-attr Gio/DBusProxy/get_name_owner/@return-value nullable 1"
 , "set-attr Gio/DBusProxy/set_cached_property/@parameters/value nullable 1"
 , "set-attr Gio/DBusProxy/set_interface_info/@parameters/info nullable 1"
 , "set-attr Gio/DBusProxy/g-signal/@parameters/sender_name nullable 1"
 , "set-attr Gio/DBusProxyTypeFunc/@parameters/interface_name nullable 1"
 , "set-attr Gio/DBusProxyTypeFunc/@parameters/data nullable 1"
 , "set-attr Gio/DBusServer/new_sync/@parameters/observer nullable 1"
 , "set-attr Gio/DBusServer/new_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/DBusSignalCallback/@parameters/sender_name nullable 1"
 , "set-attr Gio/DBusSignalCallback/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusSubtreeDispatchFunc/@return-value nullable 1"
 , "set-attr Gio/DBusSubtreeDispatchFunc/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusSubtreeEnumerateFunc/@parameters/user_data nullable 1"
 , "set-attr Gio/DBusSubtreeIntrospectFunc/@return-value nullable 1"
 , "set-attr Gio/DBusSubtreeIntrospectFunc/@parameters/user_data nullable 1"
 , "set-attr Gio/DataInputStream/read_byte/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_int16/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_int32/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_int64/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_line/@return-value nullable 1"
 , "set-attr Gio/DataInputStream/read_line/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_line_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_line_async/@parameters/callback nullable 1"
 , "set-attr Gio/DataInputStream/read_line_async/@parameters/user_data nullable 1"
 , "set-attr Gio/DataInputStream/read_line_finish/@return-value nullable 1"
 , "set-attr Gio/DataInputStream/read_line_finish_utf8/@return-value nullable 1"
 , "set-attr Gio/DataInputStream/read_line_utf8/@return-value nullable 1"
 , "set-attr Gio/DataInputStream/read_line_utf8/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_uint16/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_uint32/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_uint64/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_until/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_until_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_until_async/@parameters/callback nullable 1"
 , "set-attr Gio/DataInputStream/read_until_async/@parameters/user_data nullable 1"
 , "set-attr Gio/DataInputStream/read_upto/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_upto_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataInputStream/read_upto_async/@parameters/callback nullable 1"
 , "set-attr Gio/DataInputStream/read_upto_async/@parameters/user_data nullable 1"
 , "set-attr Gio/DataOutputStream/put_byte/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataOutputStream/put_int16/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataOutputStream/put_int32/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataOutputStream/put_int64/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataOutputStream/put_string/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataOutputStream/put_uint16/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataOutputStream/put_uint32/@parameters/cancellable nullable 1"
 , "set-attr Gio/DataOutputStream/put_uint64/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBased/condition_wait/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBased/create_source/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBased/receive_messages/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBased/send_messages/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBased/condition_wait/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBased/create_source/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBased/receive_messages/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBased/send_messages/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBasedInterface/receive_messages/receive_messages/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBasedInterface/send_messages/send_messages/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBasedInterface/create_source/create_source/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBasedInterface/condition_wait/condition_wait/@parameters/cancellable nullable 1"
 , "set-attr Gio/DatagramBasedSourceFunc/@parameters/data nullable 1"
 , "set-attr Gio/DebugControllerDBus/new/@return-value nullable 1"
 , "set-attr Gio/DebugControllerDBus/new/@parameters/cancellable nullable 1"
 , "set-attr Gio/DesktopAppInfo/new/@return-value nullable 1"
 , "set-attr Gio/DesktopAppInfo/new_from_filename/@return-value nullable 1"
 , "set-attr Gio/DesktopAppInfo/new_from_keyfile/@return-value nullable 1"
 , "set-attr Gio/DesktopAppInfo/get_categories/@return-value nullable 1"
 , "set-attr Gio/DesktopAppInfo/get_filename/@return-value nullable 1"
 , "set-attr Gio/DesktopAppInfo/get_generic_name/@return-value nullable 1"
 , "set-attr Gio/DesktopAppInfo/get_locale_string/@return-value nullable 1"
 , "set-attr Gio/DesktopAppInfo/get_show_in/@parameters/desktop_env nullable 1"
 , "set-attr Gio/DesktopAppInfo/get_startup_wm_class/@return-value nullable 1"
 , "set-attr Gio/DesktopAppInfo/get_string/@return-value nullable 1"
 , "set-attr Gio/DesktopAppInfo/launch_action/@parameters/launch_context nullable 1"
 , "set-attr Gio/DesktopAppInfo/launch_uris_as_manager/@parameters/launch_context nullable 1"
 , "set-attr Gio/DesktopAppInfo/launch_uris_as_manager/@parameters/user_setup nullable 1"
 , "set-attr Gio/DesktopAppInfo/launch_uris_as_manager/@parameters/user_setup_data nullable 1"
 , "set-attr Gio/DesktopAppInfo/launch_uris_as_manager/@parameters/pid_callback nullable 1"
 , "set-attr Gio/DesktopAppInfo/launch_uris_as_manager/@parameters/pid_callback_data nullable 1"
 , "set-attr Gio/DesktopAppInfo/launch_uris_as_manager_with_fds/@parameters/launch_context nullable 1"
 , "set-attr Gio/DesktopAppInfo/launch_uris_as_manager_with_fds/@parameters/user_setup nullable 1"
 , "set-attr Gio/DesktopAppInfo/launch_uris_as_manager_with_fds/@parameters/user_setup_data nullable 1"
 , "set-attr Gio/DesktopAppInfo/launch_uris_as_manager_with_fds/@parameters/pid_callback nullable 1"
 , "set-attr Gio/DesktopAppInfo/launch_uris_as_manager_with_fds/@parameters/pid_callback_data nullable 1"
 , "set-attr Gio/DesktopAppInfoLookup/get_default_for_uri_scheme/@return-value nullable 1"
 , "set-attr Gio/DesktopAppInfoLookup/get_default_for_uri_scheme/@return-value nullable 1"
 , "set-attr Gio/DesktopAppInfoLookupIface/get_default_for_uri_scheme/get_default_for_uri_scheme/@return-value nullable 1"
 , "set-attr Gio/DesktopAppLaunchCallback/@parameters/user_data nullable 1"
 , "set-attr Gio/Drive/eject/@parameters/cancellable nullable 1"
 , "set-attr Gio/Drive/eject/@parameters/callback nullable 1"
 , "set-attr Gio/Drive/eject/@parameters/user_data nullable 1"
 , "set-attr Gio/Drive/eject_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Drive/eject_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/Drive/eject_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/Drive/eject_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/Drive/get_identifier/@return-value nullable 1"
 , "set-attr Gio/Drive/get_sort_key/@return-value nullable 1"
 , "set-attr Gio/Drive/poll_for_media/@parameters/cancellable nullable 1"
 , "set-attr Gio/Drive/poll_for_media/@parameters/callback nullable 1"
 , "set-attr Gio/Drive/poll_for_media/@parameters/user_data nullable 1"
 , "set-attr Gio/Drive/start/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Drive/start/@parameters/cancellable nullable 1"
 , "set-attr Gio/Drive/start/@parameters/callback nullable 1"
 , "set-attr Gio/Drive/start/@parameters/user_data nullable 1"
 , "set-attr Gio/Drive/stop/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Drive/stop/@parameters/cancellable nullable 1"
 , "set-attr Gio/Drive/stop/@parameters/callback nullable 1"
 , "set-attr Gio/Drive/stop/@parameters/user_data nullable 1"
 , "set-attr Gio/Drive/eject/@parameters/cancellable nullable 1"
 , "set-attr Gio/Drive/eject/@parameters/callback nullable 1"
 , "set-attr Gio/Drive/eject/@parameters/user_data nullable 1"
 , "set-attr Gio/Drive/eject_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Drive/eject_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/Drive/eject_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/Drive/eject_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/Drive/get_identifier/@return-value nullable 1"
 , "set-attr Gio/Drive/get_sort_key/@return-value nullable 1"
 , "set-attr Gio/Drive/poll_for_media/@parameters/cancellable nullable 1"
 , "set-attr Gio/Drive/poll_for_media/@parameters/callback nullable 1"
 , "set-attr Gio/Drive/poll_for_media/@parameters/user_data nullable 1"
 , "set-attr Gio/Drive/start/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Drive/start/@parameters/cancellable nullable 1"
 , "set-attr Gio/Drive/start/@parameters/callback nullable 1"
 , "set-attr Gio/Drive/start/@parameters/user_data nullable 1"
 , "set-attr Gio/Drive/stop/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Drive/stop/@parameters/cancellable nullable 1"
 , "set-attr Gio/Drive/stop/@parameters/callback nullable 1"
 , "set-attr Gio/Drive/stop/@parameters/user_data nullable 1"
 , "set-attr Gio/DriveIface/eject/eject/@parameters/cancellable nullable 1"
 , "set-attr Gio/DriveIface/eject/eject/@parameters/callback nullable 1"
 , "set-attr Gio/DriveIface/eject/eject/@parameters/user_data nullable 1"
 , "set-attr Gio/DriveIface/poll_for_media/poll_for_media/@parameters/cancellable nullable 1"
 , "set-attr Gio/DriveIface/poll_for_media/poll_for_media/@parameters/callback nullable 1"
 , "set-attr Gio/DriveIface/poll_for_media/poll_for_media/@parameters/user_data nullable 1"
 , "set-attr Gio/DriveIface/get_identifier/get_identifier/@return-value nullable 1"
 , "set-attr Gio/DriveIface/start/start/@parameters/mount_operation nullable 1"
 , "set-attr Gio/DriveIface/start/start/@parameters/cancellable nullable 1"
 , "set-attr Gio/DriveIface/start/start/@parameters/callback nullable 1"
 , "set-attr Gio/DriveIface/start/start/@parameters/user_data nullable 1"
 , "set-attr Gio/DriveIface/stop/stop/@parameters/mount_operation nullable 1"
 , "set-attr Gio/DriveIface/stop/stop/@parameters/cancellable nullable 1"
 , "set-attr Gio/DriveIface/stop/stop/@parameters/callback nullable 1"
 , "set-attr Gio/DriveIface/stop/stop/@parameters/user_data nullable 1"
 , "set-attr Gio/DriveIface/eject_with_operation/eject_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/DriveIface/eject_with_operation/eject_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/DriveIface/eject_with_operation/eject_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/DriveIface/eject_with_operation/eject_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/DriveIface/get_sort_key/get_sort_key/@return-value nullable 1"
 , "set-attr Gio/DtlsClientConnection/new/@parameters/server_identity nullable 1"
 , "set-attr Gio/DtlsConnection/get_negotiated_protocol/@return-value nullable 1"
 , "set-attr Gio/DtlsConnection/handshake/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnection/handshake_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnection/handshake_async/@parameters/callback nullable 1"
 , "set-attr Gio/DtlsConnection/handshake_async/@parameters/user_data nullable 1"
 , "set-attr Gio/DtlsConnection/set_advertised_protocols/@parameters/protocols nullable 1"
 , "set-attr Gio/DtlsConnection/shutdown/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnection/shutdown_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnection/shutdown_async/@parameters/callback nullable 1"
 , "set-attr Gio/DtlsConnection/shutdown_async/@parameters/user_data nullable 1"
 , "set-attr Gio/DtlsConnection/close/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnection/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnection/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/DtlsConnection/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/DtlsConnection/get_certificate/@return-value nullable 1"
 , "set-attr Gio/DtlsConnection/get_ciphersuite_name/@return-value nullable 1"
 , "set-attr Gio/DtlsConnection/get_database/@return-value nullable 1"
 , "set-attr Gio/DtlsConnection/get_interaction/@return-value nullable 1"
 , "set-attr Gio/DtlsConnection/get_negotiated_protocol/@return-value nullable 1"
 , "set-attr Gio/DtlsConnection/get_peer_certificate/@return-value nullable 1"
 , "set-attr Gio/DtlsConnection/handshake/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnection/handshake_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnection/handshake_async/@parameters/callback nullable 1"
 , "set-attr Gio/DtlsConnection/handshake_async/@parameters/user_data nullable 1"
 , "set-attr Gio/DtlsConnection/set_advertised_protocols/@parameters/protocols nullable 1"
 , "set-attr Gio/DtlsConnection/set_database/@parameters/database nullable 1"
 , "set-attr Gio/DtlsConnection/set_interaction/@parameters/interaction nullable 1"
 , "set-attr Gio/DtlsConnection/shutdown/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnection/shutdown_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnection/shutdown_async/@parameters/callback nullable 1"
 , "set-attr Gio/DtlsConnection/shutdown_async/@parameters/user_data nullable 1"
 , "set-attr Gio/DtlsConnectionInterface/handshake/handshake/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnectionInterface/handshake_async/handshake_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnectionInterface/handshake_async/handshake_async/@parameters/callback nullable 1"
 , "set-attr Gio/DtlsConnectionInterface/handshake_async/handshake_async/@parameters/user_data nullable 1"
 , "set-attr Gio/DtlsConnectionInterface/shutdown/shutdown/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnectionInterface/shutdown_async/shutdown_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/DtlsConnectionInterface/shutdown_async/shutdown_async/@parameters/callback nullable 1"
 , "set-attr Gio/DtlsConnectionInterface/shutdown_async/shutdown_async/@parameters/user_data nullable 1"
 , "set-attr Gio/DtlsConnectionInterface/set_advertised_protocols/set_advertised_protocols/@parameters/protocols nullable 1"
 , "set-attr Gio/DtlsConnectionInterface/get_negotiated_protocol/get_negotiated_protocol/@return-value nullable 1"
 , "set-attr Gio/DtlsServerConnection/new/@parameters/certificate nullable 1"
 , "set-attr Gio/EmblemedIcon/new/@parameters/emblem nullable 1"
 , "set-attr Gio/File/new_tmp/@parameters/tmpl nullable 1"
 , "set-attr Gio/File/new_tmp_async/@parameters/tmpl nullable 1"
 , "set-attr Gio/File/new_tmp_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/new_tmp_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/new_tmp_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/new_tmp_dir_async/@parameters/tmpl nullable 1"
 , "set-attr Gio/File/new_tmp_dir_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/new_tmp_dir_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/new_tmp_dir_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/append_to/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/append_to_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/append_to_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/append_to_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/copy/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/copy/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/copy/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/File/copy_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/copy_async/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/copy_async/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/File/copy_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/copy_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/create/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/create_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/create_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/create_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/create_readwrite/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/create_readwrite_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/create_readwrite_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/create_readwrite_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/delete_file/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/delete_file_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/delete_file_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/delete_file_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/eject_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/eject_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/eject_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/eject_mountable_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/File/eject_mountable_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/eject_mountable_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/File/eject_mountable_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/File/enumerate_children/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/enumerate_children_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/enumerate_children_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/enumerate_children_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/find_enclosing_mount/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/find_enclosing_mount_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/find_enclosing_mount_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/find_enclosing_mount_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/get_basename/@return-value nullable 1"
 , "set-attr Gio/File/get_parent/@return-value nullable 1"
 , "set-attr Gio/File/get_path/@return-value nullable 1"
 , "set-attr Gio/File/get_relative_path/@return-value nullable 1"
 , "set-attr Gio/File/get_uri_scheme/@return-value nullable 1"
 , "set-attr Gio/File/make_directory/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/make_directory_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/make_directory_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/make_directory_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/make_symbolic_link/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/make_symbolic_link_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/make_symbolic_link_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/make_symbolic_link_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/measure_disk_usage/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/measure_disk_usage/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/measure_disk_usage/@parameters/progress_data nullable 1"
 , "set-attr Gio/File/measure_disk_usage_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/measure_disk_usage_async/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/measure_disk_usage_async/@parameters/progress_data nullable 1"
 , "set-attr Gio/File/measure_disk_usage_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/measure_disk_usage_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/monitor_dir/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/monitor_file/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/mount_enclosing_volume/@parameters/mount_operation nullable 1"
 , "set-attr Gio/File/mount_enclosing_volume/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/mount_enclosing_volume/@parameters/callback nullable 1"
 , "set-attr Gio/File/mount_enclosing_volume/@parameters/user_data nullable 1"
 , "set-attr Gio/File/mount_mountable/@parameters/mount_operation nullable 1"
 , "set-attr Gio/File/mount_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/mount_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/mount_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/move/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/move/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/move/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/File/move_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/move_async/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/move_async/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/File/move_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/move_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/open_readwrite/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/open_readwrite_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/open_readwrite_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/open_readwrite_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/poll_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/poll_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/poll_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/query_exists/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_filesystem_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_filesystem_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_filesystem_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/query_filesystem_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/query_settable_attributes/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_writable_namespaces/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/read_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/read_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/read_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/read_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace/@parameters/etag nullable 1"
 , "set-attr Gio/File/replace/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace_async/@parameters/etag nullable 1"
 , "set-attr Gio/File/replace_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/replace_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/replace_readwrite/@parameters/etag nullable 1"
 , "set-attr Gio/File/replace_readwrite/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace_readwrite_async/@parameters/etag nullable 1"
 , "set-attr Gio/File/replace_readwrite_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace_readwrite_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/replace_readwrite_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/set_attribute/@parameters/value_p nullable 1"
 , "set-attr Gio/File/set_attribute/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_attributes_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_attributes_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/set_attributes_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/set_attributes_from_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_display_name/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_display_name_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_display_name_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/set_display_name_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/start_mountable/@parameters/start_operation nullable 1"
 , "set-attr Gio/File/start_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/start_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/start_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/stop_mountable/@parameters/mount_operation nullable 1"
 , "set-attr Gio/File/stop_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/stop_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/stop_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/trash/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/trash_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/trash_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/trash_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/unmount_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/unmount_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/unmount_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/unmount_mountable_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/File/unmount_mountable_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/unmount_mountable_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/File/unmount_mountable_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/File/append_to/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/append_to_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/append_to_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/append_to_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/build_attribute_list_for_copy/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/copy/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/copy/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/copy/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/File/copy_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/copy_async/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/copy_async/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/File/copy_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/copy_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/copy_async_with_closures/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/copy_async_with_closures/@parameters/progress_callback_closure nullable 1"
 , "set-attr Gio/File/copy_attributes/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/create/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/create_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/create_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/create_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/create_readwrite/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/create_readwrite_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/create_readwrite_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/create_readwrite_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/delete/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/delete_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/delete_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/delete_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/eject_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/eject_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/eject_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/eject_mountable_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/File/eject_mountable_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/eject_mountable_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/File/eject_mountable_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/File/enumerate_children/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/enumerate_children_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/enumerate_children_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/enumerate_children_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/find_enclosing_mount/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/find_enclosing_mount_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/find_enclosing_mount_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/find_enclosing_mount_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/get_basename/@return-value nullable 1"
 , "set-attr Gio/File/get_parent/@return-value nullable 1"
 , "set-attr Gio/File/get_path/@return-value nullable 1"
 , "set-attr Gio/File/get_relative_path/@return-value nullable 1"
 , "set-attr Gio/File/get_uri_scheme/@return-value nullable 1"
 , "set-attr Gio/File/has_parent/@parameters/parent nullable 1"
 , "set-attr Gio/File/load_bytes/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/load_bytes/@parameters/etag_out nullable 1"
 , "set-attr Gio/File/load_bytes_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/load_bytes_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/load_bytes_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/load_bytes_finish/@parameters/etag_out nullable 1"
 , "set-attr Gio/File/load_contents/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/load_contents/@parameters/etag_out nullable 1"
 , "set-attr Gio/File/load_contents_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/load_contents_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/load_contents_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/load_contents_finish/@parameters/etag_out nullable 1"
 , "set-attr Gio/File/load_partial_contents_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/load_partial_contents_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/load_partial_contents_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/load_partial_contents_finish/@parameters/etag_out nullable 1"
 , "set-attr Gio/File/make_directory/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/make_directory_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/make_directory_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/make_directory_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/make_directory_with_parents/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/make_symbolic_link/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/make_symbolic_link_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/make_symbolic_link_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/make_symbolic_link_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/measure_disk_usage/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/measure_disk_usage/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/measure_disk_usage/@parameters/progress_data nullable 1"
 , "set-attr Gio/File/measure_disk_usage_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/measure_disk_usage_async/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/measure_disk_usage_async/@parameters/progress_data nullable 1"
 , "set-attr Gio/File/measure_disk_usage_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/measure_disk_usage_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/monitor/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/monitor_directory/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/monitor_file/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/mount_enclosing_volume/@parameters/mount_operation nullable 1"
 , "set-attr Gio/File/mount_enclosing_volume/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/mount_enclosing_volume/@parameters/callback nullable 1"
 , "set-attr Gio/File/mount_enclosing_volume/@parameters/user_data nullable 1"
 , "set-attr Gio/File/mount_mountable/@parameters/mount_operation nullable 1"
 , "set-attr Gio/File/mount_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/mount_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/mount_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/move/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/move/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/move/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/File/move_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/move_async/@parameters/progress_callback nullable 1"
 , "set-attr Gio/File/move_async/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/File/move_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/move_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/move_async_with_closures/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/move_async_with_closures/@parameters/progress_callback_closure nullable 1"
 , "set-attr Gio/File/open_readwrite/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/open_readwrite_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/open_readwrite_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/open_readwrite_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/peek_path/@return-value nullable 1"
 , "set-attr Gio/File/poll_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/poll_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/poll_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/query_default_handler/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_default_handler_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_default_handler_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/query_default_handler_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/query_exists/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_file_type/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_filesystem_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_filesystem_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_filesystem_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/query_filesystem_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/query_settable_attributes/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/query_writable_namespaces/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/read/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/read_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/read_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/read_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/replace/@parameters/etag nullable 1"
 , "set-attr Gio/File/replace/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace_async/@parameters/etag nullable 1"
 , "set-attr Gio/File/replace_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/replace_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/replace_contents/@parameters/etag nullable 1"
 , "set-attr Gio/File/replace_contents/@parameters/new_etag nullable 1"
 , "set-attr Gio/File/replace_contents/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace_contents_async/@parameters/etag nullable 1"
 , "set-attr Gio/File/replace_contents_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace_contents_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/replace_contents_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/replace_contents_bytes_async/@parameters/etag nullable 1"
 , "set-attr Gio/File/replace_contents_bytes_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace_contents_bytes_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/replace_contents_bytes_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/replace_contents_finish/@parameters/new_etag nullable 1"
 , "set-attr Gio/File/replace_readwrite/@parameters/etag nullable 1"
 , "set-attr Gio/File/replace_readwrite/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace_readwrite_async/@parameters/etag nullable 1"
 , "set-attr Gio/File/replace_readwrite_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/replace_readwrite_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/replace_readwrite_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/set_attribute/@parameters/value_p nullable 1"
 , "set-attr Gio/File/set_attribute/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_attribute_byte_string/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_attribute_int32/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_attribute_int64/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_attribute_string/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_attribute_uint32/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_attribute_uint64/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_attributes_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_attributes_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/set_attributes_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/set_attributes_from_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_display_name/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_display_name_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/set_display_name_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/set_display_name_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/start_mountable/@parameters/start_operation nullable 1"
 , "set-attr Gio/File/start_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/start_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/start_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/stop_mountable/@parameters/mount_operation nullable 1"
 , "set-attr Gio/File/stop_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/stop_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/stop_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/trash/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/trash_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/trash_async/@parameters/callback nullable 1"
 , "set-attr Gio/File/trash_async/@parameters/user_data nullable 1"
 , "set-attr Gio/File/unmount_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/unmount_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/File/unmount_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/File/unmount_mountable_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/File/unmount_mountable_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/File/unmount_mountable_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/File/unmount_mountable_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/FileAttributeMatcher/enumerate_next/@return-value nullable 1"
 , "set-attr Gio/FileAttributeMatcher/subtract/@return-value nullable 1"
 , "set-attr Gio/FileAttributeMatcher/subtract/@parameters/matcher nullable 1"
 , "set-attr Gio/FileAttributeMatcher/subtract/@parameters/subtract nullable 1"
 , "set-attr Gio/FileAttributeMatcher/to_string/@parameters/matcher nullable 1"
 , "set-attr Gio/FileEnumerator/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumerator/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileEnumerator/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileEnumerator/close_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumerator/next_file/@return-value nullable 1"
 , "set-attr Gio/FileEnumerator/next_file/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumerator/next_files_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumerator/next_files_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileEnumerator/next_files_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileEnumerator/close/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumerator/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumerator/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileEnumerator/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileEnumerator/iterate/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumerator/next_file/@return-value nullable 1"
 , "set-attr Gio/FileEnumerator/next_file/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumerator/next_files_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumerator/next_files_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileEnumerator/next_files_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileEnumeratorClass/next_file/next_file/@return-value nullable 1"
 , "set-attr Gio/FileEnumeratorClass/next_file/next_file/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumeratorClass/close_fn/close_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumeratorClass/next_files_async/next_files_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumeratorClass/next_files_async/next_files_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileEnumeratorClass/next_files_async/next_files_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileEnumeratorClass/close_async/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileEnumeratorClass/close_async/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileEnumeratorClass/close_async/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIOStream/get_etag/@return-value nullable 1"
 , "set-attr Gio/FileIOStream/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIOStream/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIOStream/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIOStream/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIOStream/seek/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIOStream/truncate_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIOStream/get_etag/@return-value nullable 1"
 , "set-attr Gio/FileIOStream/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIOStream/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIOStream/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIOStream/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIOStreamClass/seek/seek/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIOStreamClass/truncate_fn/truncate_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIOStreamClass/query_info/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIOStreamClass/query_info_async/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIOStreamClass/query_info_async/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIOStreamClass/query_info_async/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIOStreamClass/get_etag/get_etag/@return-value nullable 1"
 , "set-attr Gio/FileIface/get_uri_scheme/get_uri_scheme/@return-value nullable 1"
 , "set-attr Gio/FileIface/get_basename/get_basename/@return-value nullable 1"
 , "set-attr Gio/FileIface/get_path/get_path/@return-value nullable 1"
 , "set-attr Gio/FileIface/get_parent/get_parent/@return-value nullable 1"
 , "set-attr Gio/FileIface/get_relative_path/get_relative_path/@return-value nullable 1"
 , "set-attr Gio/FileIface/enumerate_children/enumerate_children/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/enumerate_children_async/enumerate_children_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/enumerate_children_async/enumerate_children_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/enumerate_children_async/enumerate_children_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/query_info/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/query_info_async/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/query_info_async/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/query_info_async/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/query_filesystem_info/query_filesystem_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/query_filesystem_info_async/query_filesystem_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/query_filesystem_info_async/query_filesystem_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/query_filesystem_info_async/query_filesystem_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/find_enclosing_mount/find_enclosing_mount/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/find_enclosing_mount_async/find_enclosing_mount_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/find_enclosing_mount_async/find_enclosing_mount_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/find_enclosing_mount_async/find_enclosing_mount_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/set_display_name/set_display_name/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/set_display_name_async/set_display_name_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/set_display_name_async/set_display_name_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/set_display_name_async/set_display_name_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/query_settable_attributes/query_settable_attributes/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/query_writable_namespaces/query_writable_namespaces/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/set_attribute/set_attribute/@parameters/value_p nullable 1"
 , "set-attr Gio/FileIface/set_attribute/set_attribute/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/set_attributes_from_info/set_attributes_from_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/set_attributes_async/set_attributes_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/set_attributes_async/set_attributes_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/set_attributes_async/set_attributes_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/read_fn/read_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/read_async/read_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/read_async/read_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/read_async/read_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/append_to/append_to/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/append_to_async/append_to_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/append_to_async/append_to_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/append_to_async/append_to_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/create/create/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/create_async/create_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/create_async/create_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/create_async/create_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/replace/replace/@parameters/etag nullable 1"
 , "set-attr Gio/FileIface/replace/replace/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/replace_async/replace_async/@parameters/etag nullable 1"
 , "set-attr Gio/FileIface/replace_async/replace_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/replace_async/replace_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/replace_async/replace_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/delete_file/delete_file/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/delete_file_async/delete_file_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/delete_file_async/delete_file_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/delete_file_async/delete_file_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/trash/trash/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/trash_async/trash_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/trash_async/trash_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/trash_async/trash_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/make_directory/make_directory/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/make_directory_async/make_directory_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/make_directory_async/make_directory_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/make_directory_async/make_directory_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/make_symbolic_link/make_symbolic_link/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/make_symbolic_link_async/make_symbolic_link_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/make_symbolic_link_async/make_symbolic_link_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/make_symbolic_link_async/make_symbolic_link_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/copy/copy/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/copy/copy/@parameters/progress_callback nullable 1"
 , "set-attr Gio/FileIface/copy/copy/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/FileIface/copy_async/copy_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/copy_async/copy_async/@parameters/progress_callback nullable 1"
 , "set-attr Gio/FileIface/copy_async/copy_async/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/FileIface/copy_async/copy_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/copy_async/copy_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/move/move/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/move/move/@parameters/progress_callback nullable 1"
 , "set-attr Gio/FileIface/move/move/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/FileIface/move_async/move_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/move_async/move_async/@parameters/progress_callback nullable 1"
 , "set-attr Gio/FileIface/move_async/move_async/@parameters/progress_callback_data nullable 1"
 , "set-attr Gio/FileIface/move_async/move_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/move_async/move_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/mount_mountable/mount_mountable/@parameters/mount_operation nullable 1"
 , "set-attr Gio/FileIface/mount_mountable/mount_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/mount_mountable/mount_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/mount_mountable/mount_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/unmount_mountable/unmount_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/unmount_mountable/unmount_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/unmount_mountable/unmount_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/eject_mountable/eject_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/eject_mountable/eject_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/eject_mountable/eject_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/mount_enclosing_volume/mount_enclosing_volume/@parameters/mount_operation nullable 1"
 , "set-attr Gio/FileIface/mount_enclosing_volume/mount_enclosing_volume/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/mount_enclosing_volume/mount_enclosing_volume/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/mount_enclosing_volume/mount_enclosing_volume/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/monitor_dir/monitor_dir/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/monitor_file/monitor_file/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/open_readwrite/open_readwrite/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/open_readwrite_async/open_readwrite_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/open_readwrite_async/open_readwrite_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/open_readwrite_async/open_readwrite_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/create_readwrite/create_readwrite/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/create_readwrite_async/create_readwrite_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/create_readwrite_async/create_readwrite_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/create_readwrite_async/create_readwrite_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/replace_readwrite/replace_readwrite/@parameters/etag nullable 1"
 , "set-attr Gio/FileIface/replace_readwrite/replace_readwrite/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/replace_readwrite_async/replace_readwrite_async/@parameters/etag nullable 1"
 , "set-attr Gio/FileIface/replace_readwrite_async/replace_readwrite_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/replace_readwrite_async/replace_readwrite_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/replace_readwrite_async/replace_readwrite_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/start_mountable/start_mountable/@parameters/start_operation nullable 1"
 , "set-attr Gio/FileIface/start_mountable/start_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/start_mountable/start_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/start_mountable/start_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/stop_mountable/stop_mountable/@parameters/mount_operation nullable 1"
 , "set-attr Gio/FileIface/stop_mountable/stop_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/stop_mountable/stop_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/stop_mountable/stop_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/unmount_mountable_with_operation/unmount_mountable_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/FileIface/unmount_mountable_with_operation/unmount_mountable_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/unmount_mountable_with_operation/unmount_mountable_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/unmount_mountable_with_operation/unmount_mountable_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/eject_mountable_with_operation/eject_mountable_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/FileIface/eject_mountable_with_operation/eject_mountable_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/eject_mountable_with_operation/eject_mountable_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/eject_mountable_with_operation/eject_mountable_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/poll_mountable/poll_mountable/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/poll_mountable/poll_mountable/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/poll_mountable/poll_mountable/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/measure_disk_usage/measure_disk_usage/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/measure_disk_usage/measure_disk_usage/@parameters/progress_callback nullable 1"
 , "set-attr Gio/FileIface/measure_disk_usage/measure_disk_usage/@parameters/progress_data nullable 1"
 , "set-attr Gio/FileIface/measure_disk_usage_async/measure_disk_usage_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileIface/measure_disk_usage_async/measure_disk_usage_async/@parameters/progress_callback nullable 1"
 , "set-attr Gio/FileIface/measure_disk_usage_async/measure_disk_usage_async/@parameters/progress_data nullable 1"
 , "set-attr Gio/FileIface/measure_disk_usage_async/measure_disk_usage_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileIface/measure_disk_usage_async/measure_disk_usage_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileIface/query_exists/query_exists/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileInfo/get_access_date_time/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_attribute_as_string/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_attribute_byte_string/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_attribute_file_path/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_attribute_object/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_attribute_string/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_attribute_stringv/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_content_type/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_creation_date_time/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_deletion_date/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_etag/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_icon/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_modification_date_time/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_symbolic_icon/@return-value nullable 1"
 , "set-attr Gio/FileInfo/get_symlink_target/@return-value nullable 1"
 , "set-attr Gio/FileInfo/list_attributes/@return-value nullable 1"
 , "set-attr Gio/FileInfo/list_attributes/@parameters/name_space nullable 1"
 , "set-attr Gio/FileInputStream/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileInputStream/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileInputStream/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileInputStream/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileInputStream/seek/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileInputStream/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileInputStream/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileInputStream/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileInputStream/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileInputStreamClass/seek/seek/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileInputStreamClass/query_info/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileInputStreamClass/query_info_async/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileInputStreamClass/query_info_async/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileInputStreamClass/query_info_async/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileMeasureProgressCallback/@parameters/data nullable 1"
 , "set-attr Gio/FileMonitor/changed/@parameters/other_file nullable 1"
 , "set-attr Gio/FileOutputStream/get_etag/@return-value nullable 1"
 , "set-attr Gio/FileOutputStream/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileOutputStream/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileOutputStream/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileOutputStream/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileOutputStream/seek/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileOutputStream/truncate_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileOutputStream/get_etag/@return-value nullable 1"
 , "set-attr Gio/FileOutputStream/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileOutputStream/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileOutputStream/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileOutputStream/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileOutputStreamClass/seek/seek/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileOutputStreamClass/truncate_fn/truncate_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileOutputStreamClass/query_info/query_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileOutputStreamClass/query_info_async/query_info_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/FileOutputStreamClass/query_info_async/query_info_async/@parameters/callback nullable 1"
 , "set-attr Gio/FileOutputStreamClass/query_info_async/query_info_async/@parameters/user_data nullable 1"
 , "set-attr Gio/FileOutputStreamClass/get_etag/get_etag/@return-value nullable 1"
 , "set-attr Gio/FileProgressCallback/@parameters/data nullable 1"
 , "set-attr Gio/FileReadMoreCallback/@parameters/callback_data nullable 1"
 , "set-attr Gio/FilenameCompleter/get_completion_suffix/@return-value nullable 1"
 , "set-attr Gio/IOSchedulerJob/send_to_mainloop/@parameters/user_data nullable 1"
 , "set-attr Gio/IOSchedulerJob/send_to_mainloop/@parameters/notify nullable 1"
 , "set-attr Gio/IOSchedulerJob/send_to_mainloop_async/@parameters/user_data nullable 1"
 , "set-attr Gio/IOSchedulerJob/send_to_mainloop_async/@parameters/notify nullable 1"
 , "set-attr Gio/IOSchedulerJobFunc/@parameters/cancellable nullable 1"
 , "set-attr Gio/IOSchedulerJobFunc/@parameters/data nullable 1"
 , "set-attr Gio/IOStream/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/IOStream/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/IOStream/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/IOStream/close_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/IOStream/close/@parameters/cancellable nullable 1"
 , "set-attr Gio/IOStream/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/IOStream/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/IOStream/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/IOStream/splice_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/IOStream/splice_async/@parameters/callback nullable 1"
 , "set-attr Gio/IOStream/splice_async/@parameters/user_data nullable 1"
 , "set-attr Gio/IOStreamClass/close_fn/close_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/IOStreamClass/close_async/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/IOStreamClass/close_async/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/IOStreamClass/close_async/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Icon/deserialize/@return-value nullable 1"
 , "set-attr Gio/Icon/equal/@parameters/icon1 nullable 1"
 , "set-attr Gio/Icon/equal/@parameters/icon2 nullable 1"
 , "set-attr Gio/Icon/serialize/@return-value nullable 1"
 , "set-attr Gio/Icon/equal/@parameters/icon1 nullable 1"
 , "set-attr Gio/Icon/equal/@parameters/icon2 nullable 1"
 , "set-attr Gio/Icon/serialize/@return-value nullable 1"
 , "set-attr Gio/Icon/to_string/@return-value nullable 1"
 , "set-attr Gio/IconIface/equal/equal/@parameters/icon1 nullable 1"
 , "set-attr Gio/IconIface/equal/equal/@parameters/icon2 nullable 1"
 , "set-attr Gio/IconIface/serialize/serialize/@return-value nullable 1"
 , "set-attr Gio/InetAddress/new_from_string/@return-value nullable 1"
 , "set-attr Gio/InetSocketAddress/new_from_string/@return-value nullable 1"
 , "set-attr Gio/Initable/new/@parameters/cancellable nullable 1"
 , "set-attr Gio/Initable/new/@parameters/first_property_name nullable 1"
 , "set-attr Gio/Initable/new_valist/@parameters/cancellable nullable 1"
 , "set-attr Gio/Initable/newv/@parameters/cancellable nullable 1"
 , "set-attr Gio/Initable/init/@parameters/cancellable nullable 1"
 , "set-attr Gio/Initable/init/@parameters/cancellable nullable 1"
 , "set-attr Gio/InitableIface/init/init/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/InputStream/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/InputStream/close_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/read_async/@parameters/buffer nullable 1"
 , "set-attr Gio/InputStream/read_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/read_async/@parameters/callback nullable 1"
 , "set-attr Gio/InputStream/read_async/@parameters/user_data nullable 1"
 , "set-attr Gio/InputStream/read_fn/@parameters/buffer nullable 1"
 , "set-attr Gio/InputStream/read_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/skip/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/skip_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/skip_async/@parameters/callback nullable 1"
 , "set-attr Gio/InputStream/skip_async/@parameters/user_data nullable 1"
 , "set-attr Gio/InputStream/close/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/InputStream/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/InputStream/read/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/read_all/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/read_all_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/read_all_async/@parameters/callback nullable 1"
 , "set-attr Gio/InputStream/read_all_async/@parameters/user_data nullable 1"
 , "set-attr Gio/InputStream/read_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/read_async/@parameters/callback nullable 1"
 , "set-attr Gio/InputStream/read_async/@parameters/user_data nullable 1"
 , "set-attr Gio/InputStream/read_bytes/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/read_bytes_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/read_bytes_async/@parameters/callback nullable 1"
 , "set-attr Gio/InputStream/read_bytes_async/@parameters/user_data nullable 1"
 , "set-attr Gio/InputStream/skip/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/skip_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStream/skip_async/@parameters/callback nullable 1"
 , "set-attr Gio/InputStream/skip_async/@parameters/user_data nullable 1"
 , "set-attr Gio/InputStreamClass/read_fn/read_fn/@parameters/buffer nullable 1"
 , "set-attr Gio/InputStreamClass/read_fn/read_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStreamClass/skip/skip/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStreamClass/close_fn/close_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStreamClass/read_async/read_async/@parameters/buffer nullable 1"
 , "set-attr Gio/InputStreamClass/read_async/read_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStreamClass/read_async/read_async/@parameters/callback nullable 1"
 , "set-attr Gio/InputStreamClass/read_async/read_async/@parameters/user_data nullable 1"
 , "set-attr Gio/InputStreamClass/skip_async/skip_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStreamClass/skip_async/skip_async/@parameters/callback nullable 1"
 , "set-attr Gio/InputStreamClass/skip_async/skip_async/@parameters/user_data nullable 1"
 , "set-attr Gio/InputStreamClass/close_async/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/InputStreamClass/close_async/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/InputStreamClass/close_async/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ListModel/get_item/@return-value nullable 1"
 , "set-attr Gio/ListModel/get_item/@return-value nullable 1"
 , "set-attr Gio/ListModel/get_object/@return-value nullable 1"
 , "set-attr Gio/ListModelInterface/get_item/get_item/@return-value nullable 1"
 , "set-attr Gio/ListStore/find_with_equal_func/@parameters/item nullable 1"
 , "set-attr Gio/ListStore/find_with_equal_func_full/@parameters/item nullable 1"
 , "set-attr Gio/ListStore/find_with_equal_func_full/@parameters/user_data nullable 1"
 , "set-attr Gio/ListStore/insert_sorted/@parameters/user_data nullable 1"
 , "set-attr Gio/ListStore/sort/@parameters/user_data nullable 1"
 , "set-attr Gio/LoadableIcon/load/@parameters/cancellable nullable 1"
 , "set-attr Gio/LoadableIcon/load_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/LoadableIcon/load_async/@parameters/callback nullable 1"
 , "set-attr Gio/LoadableIcon/load_async/@parameters/user_data nullable 1"
 , "set-attr Gio/LoadableIcon/load/@parameters/cancellable nullable 1"
 , "set-attr Gio/LoadableIcon/load_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/LoadableIcon/load_async/@parameters/callback nullable 1"
 , "set-attr Gio/LoadableIcon/load_async/@parameters/user_data nullable 1"
 , "set-attr Gio/LoadableIconIface/load/load/@parameters/cancellable nullable 1"
 , "set-attr Gio/LoadableIconIface/load_async/load_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/LoadableIconIface/load_async/load_async/@parameters/callback nullable 1"
 , "set-attr Gio/LoadableIconIface/load_async/load_async/@parameters/user_data nullable 1"
 , "set-attr Gio/MemoryInputStream/new_from_data/@parameters/destroy nullable 1"
 , "set-attr Gio/MemoryInputStream/add_data/@parameters/destroy nullable 1"
 , "set-attr Gio/MemoryOutputStream/new/@parameters/data nullable 1"
 , "set-attr Gio/MemoryOutputStream/new/@parameters/realloc_function nullable 1"
 , "set-attr Gio/MemoryOutputStream/new/@parameters/destroy_function nullable 1"
 , "set-attr Gio/MemoryOutputStream/get_data/@return-value nullable 1"
 , "set-attr Gio/MemoryOutputStream/steal_data/@return-value nullable 1"
 , "set-attr Gio/Menu/append/@parameters/label nullable 1"
 , "set-attr Gio/Menu/append/@parameters/detailed_action nullable 1"
 , "set-attr Gio/Menu/append_section/@parameters/label nullable 1"
 , "set-attr Gio/Menu/append_submenu/@parameters/label nullable 1"
 , "set-attr Gio/Menu/insert/@parameters/label nullable 1"
 , "set-attr Gio/Menu/insert/@parameters/detailed_action nullable 1"
 , "set-attr Gio/Menu/insert_section/@parameters/label nullable 1"
 , "set-attr Gio/Menu/insert_submenu/@parameters/label nullable 1"
 , "set-attr Gio/Menu/prepend/@parameters/label nullable 1"
 , "set-attr Gio/Menu/prepend/@parameters/detailed_action nullable 1"
 , "set-attr Gio/Menu/prepend_section/@parameters/label nullable 1"
 , "set-attr Gio/Menu/prepend_submenu/@parameters/label nullable 1"
 , "set-attr Gio/MenuItem/new/@parameters/label nullable 1"
 , "set-attr Gio/MenuItem/new/@parameters/detailed_action nullable 1"
 , "set-attr Gio/MenuItem/new_section/@parameters/label nullable 1"
 , "set-attr Gio/MenuItem/new_submenu/@parameters/label nullable 1"
 , "set-attr Gio/MenuItem/get_attribute_value/@return-value nullable 1"
 , "set-attr Gio/MenuItem/get_attribute_value/@parameters/expected_type nullable 1"
 , "set-attr Gio/MenuItem/get_link/@return-value nullable 1"
 , "set-attr Gio/MenuItem/set_action_and_target/@parameters/action nullable 1"
 , "set-attr Gio/MenuItem/set_action_and_target/@parameters/format_string nullable 1"
 , "set-attr Gio/MenuItem/set_action_and_target_value/@parameters/action nullable 1"
 , "set-attr Gio/MenuItem/set_action_and_target_value/@parameters/target_value nullable 1"
 , "set-attr Gio/MenuItem/set_attribute/@parameters/format_string nullable 1"
 , "set-attr Gio/MenuItem/set_attribute_value/@parameters/value nullable 1"
 , "set-attr Gio/MenuItem/set_label/@parameters/label nullable 1"
 , "set-attr Gio/MenuItem/set_link/@parameters/model nullable 1"
 , "set-attr Gio/MenuItem/set_section/@parameters/section nullable 1"
 , "set-attr Gio/MenuItem/set_submenu/@parameters/submenu nullable 1"
 , "set-attr Gio/MenuModel/get_item_attribute_value/@return-value nullable 1"
 , "set-attr Gio/MenuModel/get_item_attribute_value/@parameters/expected_type nullable 1"
 , "set-attr Gio/MenuModel/get_item_link/@return-value nullable 1"
 , "set-attr Gio/MenuModel/get_item_attribute_value/@return-value nullable 1"
 , "set-attr Gio/MenuModel/get_item_attribute_value/@parameters/expected_type nullable 1"
 , "set-attr Gio/MenuModel/get_item_link/@return-value nullable 1"
 , "set-attr Gio/MenuModelClass/get_item_attribute_value/get_item_attribute_value/@return-value nullable 1"
 , "set-attr Gio/MenuModelClass/get_item_attribute_value/get_item_attribute_value/@parameters/expected_type nullable 1"
 , "set-attr Gio/MenuModelClass/get_item_link/get_item_link/@return-value nullable 1"
 , "set-attr Gio/Mount/eject/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/eject/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/eject/@parameters/user_data nullable 1"
 , "set-attr Gio/Mount/eject_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Mount/eject_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/eject_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/eject_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/Mount/get_drive/@return-value nullable 1"
 , "set-attr Gio/Mount/get_sort_key/@return-value nullable 1"
 , "set-attr Gio/Mount/get_uuid/@return-value nullable 1"
 , "set-attr Gio/Mount/get_volume/@return-value nullable 1"
 , "set-attr Gio/Mount/guess_content_type/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/guess_content_type/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/guess_content_type/@parameters/user_data nullable 1"
 , "set-attr Gio/Mount/guess_content_type_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/remount/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Mount/remount/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/remount/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/remount/@parameters/user_data nullable 1"
 , "set-attr Gio/Mount/unmount/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/unmount/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/unmount/@parameters/user_data nullable 1"
 , "set-attr Gio/Mount/unmount_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Mount/unmount_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/unmount_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/unmount_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/Mount/eject/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/eject/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/eject/@parameters/user_data nullable 1"
 , "set-attr Gio/Mount/eject_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Mount/eject_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/eject_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/eject_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/Mount/get_drive/@return-value nullable 1"
 , "set-attr Gio/Mount/get_sort_key/@return-value nullable 1"
 , "set-attr Gio/Mount/get_uuid/@return-value nullable 1"
 , "set-attr Gio/Mount/get_volume/@return-value nullable 1"
 , "set-attr Gio/Mount/guess_content_type/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/guess_content_type/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/guess_content_type/@parameters/user_data nullable 1"
 , "set-attr Gio/Mount/guess_content_type_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/remount/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Mount/remount/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/remount/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/remount/@parameters/user_data nullable 1"
 , "set-attr Gio/Mount/unmount/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/unmount/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/unmount/@parameters/user_data nullable 1"
 , "set-attr Gio/Mount/unmount_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Mount/unmount_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/Mount/unmount_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/Mount/unmount_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/MountIface/get_uuid/get_uuid/@return-value nullable 1"
 , "set-attr Gio/MountIface/get_volume/get_volume/@return-value nullable 1"
 , "set-attr Gio/MountIface/get_drive/get_drive/@return-value nullable 1"
 , "set-attr Gio/MountIface/unmount/unmount/@parameters/cancellable nullable 1"
 , "set-attr Gio/MountIface/unmount/unmount/@parameters/callback nullable 1"
 , "set-attr Gio/MountIface/unmount/unmount/@parameters/user_data nullable 1"
 , "set-attr Gio/MountIface/eject/eject/@parameters/cancellable nullable 1"
 , "set-attr Gio/MountIface/eject/eject/@parameters/callback nullable 1"
 , "set-attr Gio/MountIface/eject/eject/@parameters/user_data nullable 1"
 , "set-attr Gio/MountIface/remount/remount/@parameters/mount_operation nullable 1"
 , "set-attr Gio/MountIface/remount/remount/@parameters/cancellable nullable 1"
 , "set-attr Gio/MountIface/remount/remount/@parameters/callback nullable 1"
 , "set-attr Gio/MountIface/remount/remount/@parameters/user_data nullable 1"
 , "set-attr Gio/MountIface/guess_content_type/guess_content_type/@parameters/cancellable nullable 1"
 , "set-attr Gio/MountIface/guess_content_type/guess_content_type/@parameters/callback nullable 1"
 , "set-attr Gio/MountIface/guess_content_type/guess_content_type/@parameters/user_data nullable 1"
 , "set-attr Gio/MountIface/guess_content_type_sync/guess_content_type_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/MountIface/unmount_with_operation/unmount_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/MountIface/unmount_with_operation/unmount_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/MountIface/unmount_with_operation/unmount_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/MountIface/unmount_with_operation/unmount_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/MountIface/eject_with_operation/eject_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/MountIface/eject_with_operation/eject_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/MountIface/eject_with_operation/eject_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/MountIface/eject_with_operation/eject_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/MountIface/get_sort_key/get_sort_key/@return-value nullable 1"
 , "set-attr Gio/MountOperation/get_domain/@return-value nullable 1"
 , "set-attr Gio/MountOperation/get_password/@return-value nullable 1"
 , "set-attr Gio/MountOperation/get_username/@return-value nullable 1"
 , "set-attr Gio/MountOperation/set_domain/@parameters/domain nullable 1"
 , "set-attr Gio/MountOperation/set_password/@parameters/password nullable 1"
 , "set-attr Gio/MountOperation/set_username/@parameters/username nullable 1"
 , "set-attr Gio/NativeSocketAddress/new/@parameters/native nullable 1"
 , "set-attr Gio/NetworkAddress/get_scheme/@return-value nullable 1"
 , "set-attr Gio/NetworkMonitor/can_reach/@parameters/cancellable nullable 1"
 , "set-attr Gio/NetworkMonitor/can_reach_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/NetworkMonitor/can_reach_async/@parameters/callback nullable 1"
 , "set-attr Gio/NetworkMonitor/can_reach_async/@parameters/user_data nullable 1"
 , "set-attr Gio/NetworkMonitor/can_reach/@parameters/cancellable nullable 1"
 , "set-attr Gio/NetworkMonitor/can_reach_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/NetworkMonitor/can_reach_async/@parameters/callback nullable 1"
 , "set-attr Gio/NetworkMonitor/can_reach_async/@parameters/user_data nullable 1"
 , "set-attr Gio/NetworkMonitorInterface/can_reach/can_reach/@parameters/cancellable nullable 1"
 , "set-attr Gio/NetworkMonitorInterface/can_reach_async/can_reach_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/NetworkMonitorInterface/can_reach_async/can_reach_async/@parameters/callback nullable 1"
 , "set-attr Gio/NetworkMonitorInterface/can_reach_async/can_reach_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Notification/add_button_with_target/@parameters/target_format nullable 1"
 , "set-attr Gio/Notification/add_button_with_target_value/@parameters/target nullable 1"
 , "set-attr Gio/Notification/set_body/@parameters/body nullable 1"
 , "set-attr Gio/Notification/set_category/@parameters/category nullable 1"
 , "set-attr Gio/Notification/set_default_action_and_target/@parameters/target_format nullable 1"
 , "set-attr Gio/Notification/set_default_action_and_target_value/@parameters/target nullable 1"
 , "set-attr Gio/OutputStream/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/close_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/flush/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/flush_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/flush_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/flush_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/splice/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/splice_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/splice_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/splice_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/write_async/@parameters/buffer nullable 1"
 , "set-attr Gio/OutputStream/write_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/write_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/write_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/write_fn/@parameters/buffer nullable 1"
 , "set-attr Gio/OutputStream/write_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/writev_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/writev_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/writev_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/writev_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/close/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/flush/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/flush_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/flush_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/flush_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/printf/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/splice/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/splice_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/splice_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/splice_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/vprintf/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/write/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/write_all/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/write_all_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/write_all_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/write_all_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/write_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/write_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/write_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/write_bytes/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/write_bytes_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/write_bytes_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/write_bytes_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/writev/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/writev_all/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/writev_all_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/writev_all_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/writev_all_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStream/writev_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStream/writev_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStream/writev_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStreamClass/write_fn/write_fn/@parameters/buffer nullable 1"
 , "set-attr Gio/OutputStreamClass/write_fn/write_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStreamClass/splice/splice/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStreamClass/flush/flush/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStreamClass/close_fn/close_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStreamClass/write_async/write_async/@parameters/buffer nullable 1"
 , "set-attr Gio/OutputStreamClass/write_async/write_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStreamClass/write_async/write_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStreamClass/write_async/write_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStreamClass/splice_async/splice_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStreamClass/splice_async/splice_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStreamClass/splice_async/splice_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStreamClass/flush_async/flush_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStreamClass/flush_async/flush_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStreamClass/flush_async/flush_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStreamClass/close_async/close_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStreamClass/close_async/close_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStreamClass/close_async/close_async/@parameters/user_data nullable 1"
 , "set-attr Gio/OutputStreamClass/writev_fn/writev_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStreamClass/writev_async/writev_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/OutputStreamClass/writev_async/writev_async/@parameters/callback nullable 1"
 , "set-attr Gio/OutputStreamClass/writev_async/writev_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Permission/acquire/@parameters/cancellable nullable 1"
 , "set-attr Gio/Permission/acquire_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Permission/acquire_async/@parameters/callback nullable 1"
 , "set-attr Gio/Permission/acquire_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Permission/release/@parameters/cancellable nullable 1"
 , "set-attr Gio/Permission/release_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Permission/release_async/@parameters/callback nullable 1"
 , "set-attr Gio/Permission/release_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Permission/acquire/@parameters/cancellable nullable 1"
 , "set-attr Gio/Permission/acquire_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Permission/acquire_async/@parameters/callback nullable 1"
 , "set-attr Gio/Permission/acquire_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Permission/release/@parameters/cancellable nullable 1"
 , "set-attr Gio/Permission/release_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Permission/release_async/@parameters/callback nullable 1"
 , "set-attr Gio/Permission/release_async/@parameters/user_data nullable 1"
 , "set-attr Gio/PermissionClass/acquire/acquire/@parameters/cancellable nullable 1"
 , "set-attr Gio/PermissionClass/acquire_async/acquire_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/PermissionClass/acquire_async/acquire_async/@parameters/callback nullable 1"
 , "set-attr Gio/PermissionClass/acquire_async/acquire_async/@parameters/user_data nullable 1"
 , "set-attr Gio/PermissionClass/release/release/@parameters/cancellable nullable 1"
 , "set-attr Gio/PermissionClass/release_async/release_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/PermissionClass/release_async/release_async/@parameters/callback nullable 1"
 , "set-attr Gio/PermissionClass/release_async/release_async/@parameters/user_data nullable 1"
 , "set-attr Gio/PollableInputStream/create_source/@parameters/cancellable nullable 1"
 , "set-attr Gio/PollableInputStream/read_nonblocking/@parameters/buffer nullable 1"
 , "set-attr Gio/PollableInputStream/create_source/@parameters/cancellable nullable 1"
 , "set-attr Gio/PollableInputStream/read_nonblocking/@parameters/cancellable nullable 1"
 , "set-attr Gio/PollableInputStreamInterface/create_source/create_source/@parameters/cancellable nullable 1"
 , "set-attr Gio/PollableInputStreamInterface/read_nonblocking/read_nonblocking/@parameters/buffer nullable 1"
 , "set-attr Gio/PollableOutputStream/create_source/@parameters/cancellable nullable 1"
 , "set-attr Gio/PollableOutputStream/write_nonblocking/@parameters/buffer nullable 1"
 , "set-attr Gio/PollableOutputStream/create_source/@parameters/cancellable nullable 1"
 , "set-attr Gio/PollableOutputStream/write_nonblocking/@parameters/cancellable nullable 1"
 , "set-attr Gio/PollableOutputStream/writev_nonblocking/@parameters/cancellable nullable 1"
 , "set-attr Gio/PollableOutputStreamInterface/create_source/create_source/@parameters/cancellable nullable 1"
 , "set-attr Gio/PollableOutputStreamInterface/write_nonblocking/write_nonblocking/@parameters/buffer nullable 1"
 , "set-attr Gio/PollableSourceFunc/@parameters/data nullable 1"
 , "set-attr Gio/Proxy/get_default_for_protocol/@return-value nullable 1"
 , "set-attr Gio/Proxy/connect/@parameters/cancellable nullable 1"
 , "set-attr Gio/Proxy/connect_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Proxy/connect_async/@parameters/callback nullable 1"
 , "set-attr Gio/Proxy/connect_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Proxy/connect/@parameters/cancellable nullable 1"
 , "set-attr Gio/Proxy/connect_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Proxy/connect_async/@parameters/callback nullable 1"
 , "set-attr Gio/Proxy/connect_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ProxyAddress/new/@parameters/username nullable 1"
 , "set-attr Gio/ProxyAddress/new/@parameters/password nullable 1"
 , "set-attr Gio/ProxyAddress/get_password/@return-value nullable 1"
 , "set-attr Gio/ProxyAddress/get_uri/@return-value nullable 1"
 , "set-attr Gio/ProxyAddress/get_username/@return-value nullable 1"
 , "set-attr Gio/ProxyInterface/connect/connect/@parameters/cancellable nullable 1"
 , "set-attr Gio/ProxyInterface/connect_async/connect_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/ProxyInterface/connect_async/connect_async/@parameters/callback nullable 1"
 , "set-attr Gio/ProxyInterface/connect_async/connect_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ProxyResolver/lookup/@parameters/cancellable nullable 1"
 , "set-attr Gio/ProxyResolver/lookup_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/ProxyResolver/lookup_async/@parameters/callback nullable 1"
 , "set-attr Gio/ProxyResolver/lookup_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ProxyResolver/lookup/@parameters/cancellable nullable 1"
 , "set-attr Gio/ProxyResolver/lookup_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/ProxyResolver/lookup_async/@parameters/callback nullable 1"
 , "set-attr Gio/ProxyResolver/lookup_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ProxyResolverInterface/lookup/lookup/@parameters/cancellable nullable 1"
 , "set-attr Gio/ProxyResolverInterface/lookup_async/lookup_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/ProxyResolverInterface/lookup_async/lookup_async/@parameters/callback nullable 1"
 , "set-attr Gio/ProxyResolverInterface/lookup_async/lookup_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ReallocFunc/@return-value nullable 1"
 , "set-attr Gio/ReallocFunc/@parameters/data nullable 1"
 , "set-attr Gio/RemoteActionGroup/activate_action_full/@parameters/parameter nullable 1"
 , "set-attr Gio/RemoteActionGroup/activate_action_full/@parameters/parameter nullable 1"
 , "set-attr Gio/RemoteActionGroupInterface/activate_action_full/activate_action_full/@parameters/parameter nullable 1"
 , "set-attr Gio/Resolver/lookup_by_address/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_address_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_address_async/@parameters/callback nullable 1"
 , "set-attr Gio/Resolver/lookup_by_address_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_async/@parameters/callback nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_with_flags/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_with_flags_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_with_flags_async/@parameters/callback nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_with_flags_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Resolver/lookup_records/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_records_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_records_async/@parameters/callback nullable 1"
 , "set-attr Gio/Resolver/lookup_records_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Resolver/lookup_service/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_service_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_service_async/@parameters/callback nullable 1"
 , "set-attr Gio/Resolver/lookup_service_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Resolver/lookup_by_address/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_address_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_address_async/@parameters/callback nullable 1"
 , "set-attr Gio/Resolver/lookup_by_address_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_async/@parameters/callback nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_with_flags/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_with_flags_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_with_flags_async/@parameters/callback nullable 1"
 , "set-attr Gio/Resolver/lookup_by_name_with_flags_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Resolver/lookup_records/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_records_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_records_async/@parameters/callback nullable 1"
 , "set-attr Gio/Resolver/lookup_records_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Resolver/lookup_service/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_service_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Resolver/lookup_service_async/@parameters/callback nullable 1"
 , "set-attr Gio/Resolver/lookup_service_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_name/lookup_by_name/@parameters/cancellable nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_name_async/lookup_by_name_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_name_async/lookup_by_name_async/@parameters/callback nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_name_async/lookup_by_name_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_address/lookup_by_address/@parameters/cancellable nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_address_async/lookup_by_address_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_address_async/lookup_by_address_async/@parameters/callback nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_address_async/lookup_by_address_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ResolverClass/lookup_service/lookup_service/@parameters/cancellable nullable 1"
 , "set-attr Gio/ResolverClass/lookup_service_async/lookup_service_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/ResolverClass/lookup_service_async/lookup_service_async/@parameters/callback nullable 1"
 , "set-attr Gio/ResolverClass/lookup_service_async/lookup_service_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ResolverClass/lookup_records/lookup_records/@parameters/cancellable nullable 1"
 , "set-attr Gio/ResolverClass/lookup_records_async/lookup_records_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/ResolverClass/lookup_records_async/lookup_records_async/@parameters/callback nullable 1"
 , "set-attr Gio/ResolverClass/lookup_records_async/lookup_records_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_name_with_flags_async/lookup_by_name_with_flags_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_name_with_flags_async/lookup_by_name_with_flags_async/@parameters/callback nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_name_with_flags_async/lookup_by_name_with_flags_async/@parameters/user_data nullable 1"
 , "set-attr Gio/ResolverClass/lookup_by_name_with_flags/lookup_by_name_with_flags/@parameters/cancellable nullable 1"
 , "set-attr Gio/Seekable/seek/@parameters/cancellable nullable 1"
 , "set-attr Gio/Seekable/truncate_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/Seekable/seek/@parameters/cancellable nullable 1"
 , "set-attr Gio/Seekable/truncate/@parameters/cancellable nullable 1"
 , "set-attr Gio/SeekableIface/seek/seek/@parameters/cancellable nullable 1"
 , "set-attr Gio/SeekableIface/truncate_fn/truncate_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/Settings/new_full/@parameters/backend nullable 1"
 , "set-attr Gio/Settings/new_full/@parameters/path nullable 1"
 , "set-attr Gio/Settings/bind_with_mapping/@parameters/get_mapping nullable 1"
 , "set-attr Gio/Settings/bind_with_mapping/@parameters/set_mapping nullable 1"
 , "set-attr Gio/Settings/bind_with_mapping/@parameters/user_data nullable 1"
 , "set-attr Gio/Settings/bind_with_mapping_closures/@parameters/get_mapping nullable 1"
 , "set-attr Gio/Settings/bind_with_mapping_closures/@parameters/set_mapping nullable 1"
 , "set-attr Gio/Settings/get_default_value/@return-value nullable 1"
 , "set-attr Gio/Settings/get_mapped/@return-value nullable 1"
 , "set-attr Gio/Settings/get_mapped/@parameters/user_data nullable 1"
 , "set-attr Gio/Settings/get_user_value/@return-value nullable 1"
 , "set-attr Gio/Settings/set_strv/@parameters/value nullable 1"
 , "set-attr Gio/Settings/change-event/@parameters/keys nullable 1"
 , "set-attr Gio/SettingsBackend/reset/@parameters/origin_tag nullable 1"
 , "set-attr Gio/SettingsBackend/write/@parameters/origin_tag nullable 1"
 , "set-attr Gio/SettingsBackend/write_tree/@parameters/origin_tag nullable 1"
 , "set-attr Gio/SettingsBackend/changed/@parameters/origin_tag nullable 1"
 , "set-attr Gio/SettingsBackend/changed_tree/@parameters/origin_tag nullable 1"
 , "set-attr Gio/SettingsBackend/keys_changed/@parameters/origin_tag nullable 1"
 , "set-attr Gio/SettingsBackend/path_changed/@parameters/origin_tag nullable 1"
 , "set-attr Gio/SettingsBackendClass/write/write/@parameters/origin_tag nullable 1"
 , "set-attr Gio/SettingsBackendClass/write_tree/write_tree/@parameters/origin_tag nullable 1"
 , "set-attr Gio/SettingsBackendClass/reset/reset/@parameters/origin_tag nullable 1"
 , "set-attr Gio/SettingsBindGetMapping/@parameters/user_data nullable 1"
 , "set-attr Gio/SettingsBindSetMapping/@return-value nullable 1"
 , "set-attr Gio/SettingsBindSetMapping/@parameters/user_data nullable 1"
 , "set-attr Gio/SettingsGetMapping/@parameters/value nullable 1"
 , "set-attr Gio/SettingsGetMapping/@parameters/result nullable 1"
 , "set-attr Gio/SettingsGetMapping/@parameters/user_data nullable 1"
 , "set-attr Gio/SettingsSchema/get_path/@return-value nullable 1"
 , "set-attr Gio/SettingsSchemaKey/get_description/@return-value nullable 1"
 , "set-attr Gio/SettingsSchemaKey/get_summary/@return-value nullable 1"
 , "set-attr Gio/SettingsSchemaSource/new_from_directory/@parameters/parent nullable 1"
 , "set-attr Gio/SettingsSchemaSource/lookup/@return-value nullable 1"
 , "set-attr Gio/SettingsSchemaSource/get_default/@return-value nullable 1"
 , "set-attr Gio/SimpleAction/new/@parameters/parameter_type nullable 1"
 , "set-attr Gio/SimpleAction/new_stateful/@parameters/parameter_type nullable 1"
 , "set-attr Gio/SimpleAction/set_state_hint/@parameters/state_hint nullable 1"
 , "set-attr Gio/SimpleAction/activate/@parameters/parameter nullable 1"
 , "set-attr Gio/SimpleAction/change-state/@parameters/value nullable 1"
 , "set-attr Gio/SimpleActionGroup/add_entries/@parameters/user_data nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new/@parameters/source_object nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new/@parameters/callback nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new/@parameters/user_data nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new/@parameters/source_tag nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new_error/@parameters/source_object nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new_error/@parameters/callback nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new_error/@parameters/user_data nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new_from_error/@parameters/source_object nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new_from_error/@parameters/callback nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new_from_error/@parameters/user_data nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new_take_error/@parameters/source_object nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new_take_error/@parameters/callback nullable 1"
 , "set-attr Gio/SimpleAsyncResult/new_take_error/@parameters/user_data nullable 1"
 , "set-attr Gio/SimpleAsyncResult/is_valid/@parameters/source nullable 1"
 , "set-attr Gio/SimpleAsyncResult/is_valid/@parameters/source_tag nullable 1"
 , "set-attr Gio/SimpleAsyncResult/get_op_res_gpointer/@return-value nullable 1"
 , "set-attr Gio/SimpleAsyncResult/get_source_tag/@return-value nullable 1"
 , "set-attr Gio/SimpleAsyncResult/run_in_thread/@parameters/cancellable nullable 1"
 , "set-attr Gio/SimpleAsyncResult/set_check_cancellable/@parameters/check_cancellable nullable 1"
 , "set-attr Gio/SimpleAsyncResult/set_op_res_gpointer/@parameters/op_res nullable 1"
 , "set-attr Gio/SimpleAsyncThreadFunc/@parameters/cancellable nullable 1"
 , "set-attr Gio/SimpleProxyResolver/new/@parameters/default_proxy nullable 1"
 , "set-attr Gio/SimpleProxyResolver/new/@parameters/ignore_hosts nullable 1"
 , "set-attr Gio/SimpleProxyResolver/set_default_proxy/@parameters/default_proxy nullable 1"
 , "set-attr Gio/Socket/accept/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/condition_timed_wait/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/condition_wait/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/connect/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/create_source/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/join_multicast_group/@parameters/iface nullable 1"
 , "set-attr Gio/Socket/join_multicast_group_ssm/@parameters/source_specific nullable 1"
 , "set-attr Gio/Socket/join_multicast_group_ssm/@parameters/iface nullable 1"
 , "set-attr Gio/Socket/leave_multicast_group/@parameters/iface nullable 1"
 , "set-attr Gio/Socket/leave_multicast_group_ssm/@parameters/source_specific nullable 1"
 , "set-attr Gio/Socket/leave_multicast_group_ssm/@parameters/iface nullable 1"
 , "set-attr Gio/Socket/receive/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/receive_bytes/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/receive_bytes_from/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/receive_from/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/receive_message/@parameters/messages nullable 1"
 , "set-attr Gio/Socket/receive_message/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/receive_messages/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/receive_with_blocking/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/send/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/send_message/@parameters/address nullable 1"
 , "set-attr Gio/Socket/send_message/@parameters/messages nullable 1"
 , "set-attr Gio/Socket/send_message/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/send_message_with_timeout/@parameters/address nullable 1"
 , "set-attr Gio/Socket/send_message_with_timeout/@parameters/messages nullable 1"
 , "set-attr Gio/Socket/send_message_with_timeout/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/send_messages/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/send_to/@parameters/address nullable 1"
 , "set-attr Gio/Socket/send_to/@parameters/cancellable nullable 1"
 , "set-attr Gio/Socket/send_with_blocking/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketAddress/to_native/@parameters/dest nullable 1"
 , "set-attr Gio/SocketAddress/to_native/@parameters/dest nullable 1"
 , "set-attr Gio/SocketAddressClass/to_native/to_native/@parameters/dest nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next/@return-value nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next_async/@parameters/callback nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next_async/@parameters/user_data nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next_finish/@return-value nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next/@return-value nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next_async/@parameters/callback nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next_async/@parameters/user_data nullable 1"
 , "set-attr Gio/SocketAddressEnumerator/next_finish/@return-value nullable 1"
 , "set-attr Gio/SocketAddressEnumeratorClass/next/next/@return-value nullable 1"
 , "set-attr Gio/SocketAddressEnumeratorClass/next/next/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketAddressEnumeratorClass/next_async/next_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketAddressEnumeratorClass/next_async/next_async/@parameters/callback nullable 1"
 , "set-attr Gio/SocketAddressEnumeratorClass/next_async/next_async/@parameters/user_data nullable 1"
 , "set-attr Gio/SocketAddressEnumeratorClass/next_finish/next_finish/@return-value nullable 1"
 , "set-attr Gio/SocketClient/connect/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketClient/connect_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketClient/connect_async/@parameters/callback nullable 1"
 , "set-attr Gio/SocketClient/connect_async/@parameters/user_data nullable 1"
 , "set-attr Gio/SocketClient/connect_to_host/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketClient/connect_to_host_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketClient/connect_to_host_async/@parameters/callback nullable 1"
 , "set-attr Gio/SocketClient/connect_to_host_async/@parameters/user_data nullable 1"
 , "set-attr Gio/SocketClient/connect_to_service/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketClient/connect_to_service_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketClient/connect_to_service_async/@parameters/callback nullable 1"
 , "set-attr Gio/SocketClient/connect_to_service_async/@parameters/user_data nullable 1"
 , "set-attr Gio/SocketClient/connect_to_uri/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketClient/connect_to_uri_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketClient/connect_to_uri_async/@parameters/callback nullable 1"
 , "set-attr Gio/SocketClient/connect_to_uri_async/@parameters/user_data nullable 1"
 , "set-attr Gio/SocketClient/get_local_address/@return-value nullable 1"
 , "set-attr Gio/SocketClient/set_local_address/@parameters/address nullable 1"
 , "set-attr Gio/SocketClient/set_proxy_resolver/@parameters/proxy_resolver nullable 1"
 , "set-attr Gio/SocketClient/event/@parameters/connection nullable 1"
 , "set-attr Gio/SocketConnection/connect/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketConnection/connect_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketConnection/connect_async/@parameters/callback nullable 1"
 , "set-attr Gio/SocketConnection/connect_async/@parameters/user_data nullable 1"
 , "set-attr Gio/SocketControlMessage/deserialize/@return-value nullable 1"
 , "set-attr Gio/SocketListener/accept/@parameters/source_object nullable 1"
 , "set-attr Gio/SocketListener/accept/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketListener/accept_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketListener/accept_async/@parameters/callback nullable 1"
 , "set-attr Gio/SocketListener/accept_async/@parameters/user_data nullable 1"
 , "set-attr Gio/SocketListener/accept_finish/@parameters/source_object nullable 1"
 , "set-attr Gio/SocketListener/accept_socket/@parameters/source_object nullable 1"
 , "set-attr Gio/SocketListener/accept_socket/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketListener/accept_socket_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/SocketListener/accept_socket_async/@parameters/callback nullable 1"
 , "set-attr Gio/SocketListener/accept_socket_async/@parameters/user_data nullable 1"
 , "set-attr Gio/SocketListener/accept_socket_finish/@parameters/source_object nullable 1"
 , "set-attr Gio/SocketListener/add_address/@parameters/source_object nullable 1"
 , "set-attr Gio/SocketListener/add_any_inet_port/@parameters/source_object nullable 1"
 , "set-attr Gio/SocketListener/add_inet_port/@parameters/source_object nullable 1"
 , "set-attr Gio/SocketListener/add_socket/@parameters/source_object nullable 1"
 , "set-attr Gio/SocketService/incoming/@parameters/source_object nullable 1"
 , "set-attr Gio/SocketSourceFunc/@parameters/data nullable 1"
 , "set-attr Gio/Subprocess/new/@parameters/error nullable 1"
 , "set-attr Gio/Subprocess/communicate/@parameters/stdin_buf nullable 1"
 , "set-attr Gio/Subprocess/communicate/@parameters/cancellable nullable 1"
 , "set-attr Gio/Subprocess/communicate/@parameters/stdout_buf nullable 1"
 , "set-attr Gio/Subprocess/communicate/@parameters/stderr_buf nullable 1"
 , "set-attr Gio/Subprocess/communicate_async/@parameters/stdin_buf nullable 1"
 , "set-attr Gio/Subprocess/communicate_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Subprocess/communicate_async/@parameters/callback nullable 1"
 , "set-attr Gio/Subprocess/communicate_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Subprocess/communicate_finish/@parameters/stdout_buf nullable 1"
 , "set-attr Gio/Subprocess/communicate_finish/@parameters/stderr_buf nullable 1"
 , "set-attr Gio/Subprocess/communicate_utf8/@parameters/stdin_buf nullable 1"
 , "set-attr Gio/Subprocess/communicate_utf8/@parameters/cancellable nullable 1"
 , "set-attr Gio/Subprocess/communicate_utf8/@parameters/stdout_buf nullable 1"
 , "set-attr Gio/Subprocess/communicate_utf8/@parameters/stderr_buf nullable 1"
 , "set-attr Gio/Subprocess/communicate_utf8_async/@parameters/stdin_buf nullable 1"
 , "set-attr Gio/Subprocess/communicate_utf8_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Subprocess/communicate_utf8_async/@parameters/callback nullable 1"
 , "set-attr Gio/Subprocess/communicate_utf8_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Subprocess/communicate_utf8_finish/@parameters/stdout_buf nullable 1"
 , "set-attr Gio/Subprocess/communicate_utf8_finish/@parameters/stderr_buf nullable 1"
 , "set-attr Gio/Subprocess/get_identifier/@return-value nullable 1"
 , "set-attr Gio/Subprocess/get_stderr_pipe/@return-value nullable 1"
 , "set-attr Gio/Subprocess/get_stdin_pipe/@return-value nullable 1"
 , "set-attr Gio/Subprocess/get_stdout_pipe/@return-value nullable 1"
 , "set-attr Gio/Subprocess/wait/@parameters/cancellable nullable 1"
 , "set-attr Gio/Subprocess/wait_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Subprocess/wait_async/@parameters/callback nullable 1"
 , "set-attr Gio/Subprocess/wait_async/@parameters/user_data nullable 1"
 , "set-attr Gio/Subprocess/wait_check/@parameters/cancellable nullable 1"
 , "set-attr Gio/Subprocess/wait_check_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/Subprocess/wait_check_async/@parameters/callback nullable 1"
 , "set-attr Gio/Subprocess/wait_check_async/@parameters/user_data nullable 1"
 , "set-attr Gio/SubprocessLauncher/getenv/@return-value nullable 1"
 , "set-attr Gio/SubprocessLauncher/set_child_setup/@parameters/user_data nullable 1"
 , "set-attr Gio/SubprocessLauncher/set_stderr_file_path/@parameters/path nullable 1"
 , "set-attr Gio/SubprocessLauncher/set_stdin_file_path/@parameters/path nullable 1"
 , "set-attr Gio/SubprocessLauncher/set_stdout_file_path/@parameters/path nullable 1"
 , "set-attr Gio/Task/new/@parameters/source_object nullable 1"
 , "set-attr Gio/Task/new/@parameters/cancellable nullable 1"
 , "set-attr Gio/Task/new/@parameters/callback nullable 1"
 , "set-attr Gio/Task/new/@parameters/callback_data nullable 1"
 , "set-attr Gio/Task/is_valid/@parameters/source_object nullable 1"
 , "set-attr Gio/Task/report_error/@parameters/source_object nullable 1"
 , "set-attr Gio/Task/report_error/@parameters/callback nullable 1"
 , "set-attr Gio/Task/report_error/@parameters/callback_data nullable 1"
 , "set-attr Gio/Task/report_error/@parameters/source_tag nullable 1"
 , "set-attr Gio/Task/report_new_error/@parameters/source_object nullable 1"
 , "set-attr Gio/Task/report_new_error/@parameters/callback nullable 1"
 , "set-attr Gio/Task/report_new_error/@parameters/callback_data nullable 1"
 , "set-attr Gio/Task/report_new_error/@parameters/source_tag nullable 1"
 , "set-attr Gio/Task/get_cancellable/@return-value nullable 1"
 , "set-attr Gio/Task/get_name/@return-value nullable 1"
 , "set-attr Gio/Task/get_source_object/@return-value nullable 1"
 , "set-attr Gio/Task/get_source_tag/@return-value nullable 1"
 , "set-attr Gio/Task/get_task_data/@return-value nullable 1"
 , "set-attr Gio/Task/propagate_pointer/@return-value nullable 1"
 , "set-attr Gio/Task/return_pointer/@parameters/result nullable 1"
 , "set-attr Gio/Task/return_pointer/@parameters/result_destroy nullable 1"
 , "set-attr Gio/Task/return_value/@parameters/result nullable 1"
 , "set-attr Gio/Task/set_name/@parameters/name nullable 1"
 , "set-attr Gio/Task/set_source_tag/@parameters/source_tag nullable 1"
 , "set-attr Gio/Task/set_static_name/@parameters/name nullable 1"
 , "set-attr Gio/Task/set_task_data/@parameters/task_data nullable 1"
 , "set-attr Gio/Task/set_task_data/@parameters/task_data_destroy nullable 1"
 , "set-attr Gio/TaskThreadFunc/@parameters/task_data nullable 1"
 , "set-attr Gio/TaskThreadFunc/@parameters/cancellable nullable 1"
 , "set-attr Gio/TestDBus/get_bus_address/@return-value nullable 1"
 , "set-attr Gio/ThreadedSocketService/run/@parameters/source_object nullable 1"
 , "set-attr Gio/TlsBackend/set_default_database/@parameters/database nullable 1"
 , "set-attr Gio/TlsCertificate/new_from_pkcs11_uris/@parameters/private_key_pkcs11_uri nullable 1"
 , "set-attr Gio/TlsCertificate/new_from_pkcs12/@parameters/password nullable 1"
 , "set-attr Gio/TlsCertificate/verify/@parameters/identity nullable 1"
 , "set-attr Gio/TlsCertificate/verify/@parameters/trusted_ca nullable 1"
 , "set-attr Gio/TlsCertificate/get_dns_names/@return-value nullable 1"
 , "set-attr Gio/TlsCertificate/get_ip_addresses/@return-value nullable 1"
 , "set-attr Gio/TlsCertificate/get_issuer/@return-value nullable 1"
 , "set-attr Gio/TlsCertificate/get_issuer_name/@return-value nullable 1"
 , "set-attr Gio/TlsCertificate/get_not_valid_after/@return-value nullable 1"
 , "set-attr Gio/TlsCertificate/get_not_valid_before/@return-value nullable 1"
 , "set-attr Gio/TlsCertificate/get_subject_name/@return-value nullable 1"
 , "set-attr Gio/TlsCertificate/verify/@parameters/identity nullable 1"
 , "set-attr Gio/TlsCertificate/verify/@parameters/trusted_ca nullable 1"
 , "set-attr Gio/TlsCertificateClass/verify/verify/@parameters/identity nullable 1"
 , "set-attr Gio/TlsCertificateClass/verify/verify/@parameters/trusted_ca nullable 1"
 , "set-attr Gio/TlsClientConnection/new/@parameters/server_identity nullable 1"
 , "set-attr Gio/TlsClientConnection/get_server_identity/@return-value nullable 1"
 , "set-attr Gio/TlsConnection/get_negotiated_protocol/@return-value nullable 1"
 , "set-attr Gio/TlsConnection/handshake/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsConnection/handshake_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsConnection/handshake_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsConnection/handshake_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsConnection/get_certificate/@return-value nullable 1"
 , "set-attr Gio/TlsConnection/get_ciphersuite_name/@return-value nullable 1"
 , "set-attr Gio/TlsConnection/get_database/@return-value nullable 1"
 , "set-attr Gio/TlsConnection/get_interaction/@return-value nullable 1"
 , "set-attr Gio/TlsConnection/get_negotiated_protocol/@return-value nullable 1"
 , "set-attr Gio/TlsConnection/get_peer_certificate/@return-value nullable 1"
 , "set-attr Gio/TlsConnection/handshake/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsConnection/handshake_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsConnection/handshake_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsConnection/handshake_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsConnection/set_advertised_protocols/@parameters/protocols nullable 1"
 , "set-attr Gio/TlsConnection/set_database/@parameters/database nullable 1"
 , "set-attr Gio/TlsConnection/set_interaction/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsConnectionClass/handshake/handshake/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsConnectionClass/handshake_async/handshake_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsConnectionClass/handshake_async/handshake_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsConnectionClass/handshake_async/handshake_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsConnectionClass/get_negotiated_protocol/get_negotiated_protocol/@return-value nullable 1"
 , "set-attr Gio/TlsDatabase/create_certificate_handle/@return-value nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle/@return-value nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain/@parameters/identity nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain_async/@parameters/identity nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsDatabase/create_certificate_handle/@return-value nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle/@return-value nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_for_handle_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificate_issuer_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabase/lookup_certificates_issued_by_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain/@parameters/identity nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain_async/@parameters/identity nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabase/verify_chain_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsDatabaseClass/verify_chain/verify_chain/@parameters/identity nullable 1"
 , "set-attr Gio/TlsDatabaseClass/verify_chain/verify_chain/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabaseClass/verify_chain/verify_chain/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabaseClass/verify_chain_async/verify_chain_async/@parameters/identity nullable 1"
 , "set-attr Gio/TlsDatabaseClass/verify_chain_async/verify_chain_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabaseClass/verify_chain_async/verify_chain_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabaseClass/verify_chain_async/verify_chain_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabaseClass/verify_chain_async/verify_chain_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsDatabaseClass/create_certificate_handle/create_certificate_handle/@return-value nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_for_handle/lookup_certificate_for_handle/@return-value nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_for_handle/lookup_certificate_for_handle/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_for_handle/lookup_certificate_for_handle/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_for_handle_async/lookup_certificate_for_handle_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_for_handle_async/lookup_certificate_for_handle_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_for_handle_async/lookup_certificate_for_handle_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_for_handle_async/lookup_certificate_for_handle_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_issuer/lookup_certificate_issuer/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_issuer/lookup_certificate_issuer/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_issuer_async/lookup_certificate_issuer_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_issuer_async/lookup_certificate_issuer_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_issuer_async/lookup_certificate_issuer_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificate_issuer_async/lookup_certificate_issuer_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificates_issued_by/lookup_certificates_issued_by/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificates_issued_by/lookup_certificates_issued_by/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificates_issued_by_async/lookup_certificates_issued_by_async/@parameters/interaction nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificates_issued_by_async/lookup_certificates_issued_by_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificates_issued_by_async/lookup_certificates_issued_by_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsDatabaseClass/lookup_certificates_issued_by_async/lookup_certificates_issued_by_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsInteraction/ask_password/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteraction/ask_password_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteraction/ask_password_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsInteraction/ask_password_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsInteraction/request_certificate/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteraction/request_certificate_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteraction/request_certificate_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsInteraction/request_certificate_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsInteraction/ask_password/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteraction/ask_password_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteraction/ask_password_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsInteraction/ask_password_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsInteraction/invoke_ask_password/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteraction/invoke_request_certificate/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteraction/request_certificate/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteraction/request_certificate_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteraction/request_certificate_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsInteraction/request_certificate_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsInteractionClass/ask_password/ask_password/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteractionClass/ask_password_async/ask_password_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteractionClass/ask_password_async/ask_password_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsInteractionClass/ask_password_async/ask_password_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsInteractionClass/request_certificate/request_certificate/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteractionClass/request_certificate_async/request_certificate_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/TlsInteractionClass/request_certificate_async/request_certificate_async/@parameters/callback nullable 1"
 , "set-attr Gio/TlsInteractionClass/request_certificate_async/request_certificate_async/@parameters/user_data nullable 1"
 , "set-attr Gio/TlsPassword/set_value/@parameters/destroy nullable 1"
 , "set-attr Gio/TlsPassword/set_value_full/@parameters/destroy nullable 1"
 , "set-attr Gio/TlsPasswordClass/set_value/set_value/@parameters/destroy nullable 1"
 , "set-attr Gio/TlsServerConnection/new/@parameters/certificate nullable 1"
 , "set-attr Gio/UnixConnection/receive_credentials/@parameters/cancellable nullable 1"
 , "set-attr Gio/UnixConnection/receive_credentials_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/UnixConnection/receive_credentials_async/@parameters/callback nullable 1"
 , "set-attr Gio/UnixConnection/receive_credentials_async/@parameters/user_data nullable 1"
 , "set-attr Gio/UnixConnection/receive_fd/@parameters/cancellable nullable 1"
 , "set-attr Gio/UnixConnection/send_credentials/@parameters/cancellable nullable 1"
 , "set-attr Gio/UnixConnection/send_credentials_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/UnixConnection/send_credentials_async/@parameters/callback nullable 1"
 , "set-attr Gio/UnixConnection/send_credentials_async/@parameters/user_data nullable 1"
 , "set-attr Gio/UnixConnection/send_fd/@parameters/cancellable nullable 1"
 , "set-attr Gio/UnixMountEntry/get_options/@return-value nullable 1"
 , "set-attr Gio/UnixMountEntry/get_root_path/@return-value nullable 1"
 , "set-attr Gio/UnixMountEntry/at/@return-value nullable 1"
 , "set-attr Gio/UnixMountEntry/for/@return-value nullable 1"
 , "set-attr Gio/UnixMountPoint/get_options/@return-value nullable 1"
 , "set-attr Gio/UnixMountPoint/at/@return-value nullable 1"
 , "set-attr Gio/Vfs/local_file_add_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/Vfs/local_file_add_info/@parameters/extra_data nullable 1"
 , "set-attr Gio/Vfs/local_file_set_attributes/@parameters/cancellable nullable 1"
 , "set-attr Gio/Vfs/register_uri_scheme/@parameters/uri_func nullable 1"
 , "set-attr Gio/Vfs/register_uri_scheme/@parameters/uri_data nullable 1"
 , "set-attr Gio/Vfs/register_uri_scheme/@parameters/uri_destroy nullable 1"
 , "set-attr Gio/Vfs/register_uri_scheme/@parameters/parse_name_func nullable 1"
 , "set-attr Gio/Vfs/register_uri_scheme/@parameters/parse_name_data nullable 1"
 , "set-attr Gio/Vfs/register_uri_scheme/@parameters/parse_name_destroy nullable 1"
 , "set-attr Gio/VfsClass/local_file_add_info/local_file_add_info/@parameters/cancellable nullable 1"
 , "set-attr Gio/VfsClass/local_file_add_info/local_file_add_info/@parameters/extra_data nullable 1"
 , "set-attr Gio/VfsClass/local_file_set_attributes/local_file_set_attributes/@parameters/cancellable nullable 1"
 , "set-attr Gio/VfsFileLookupFunc/@return-value nullable 1"
 , "set-attr Gio/VfsFileLookupFunc/@parameters/user_data nullable 1"
 , "set-attr Gio/Volume/eject/@parameters/cancellable nullable 1"
 , "set-attr Gio/Volume/eject/@parameters/callback nullable 1"
 , "set-attr Gio/Volume/eject/@parameters/user_data nullable 1"
 , "set-attr Gio/Volume/eject_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Volume/eject_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/Volume/eject_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/Volume/eject_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/Volume/get_activation_root/@return-value nullable 1"
 , "set-attr Gio/Volume/get_drive/@return-value nullable 1"
 , "set-attr Gio/Volume/get_identifier/@return-value nullable 1"
 , "set-attr Gio/Volume/get_mount/@return-value nullable 1"
 , "set-attr Gio/Volume/get_sort_key/@return-value nullable 1"
 , "set-attr Gio/Volume/get_uuid/@return-value nullable 1"
 , "set-attr Gio/Volume/mount_fn/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Volume/mount_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/Volume/mount_fn/@parameters/callback nullable 1"
 , "set-attr Gio/Volume/mount_fn/@parameters/user_data nullable 1"
 , "set-attr Gio/Volume/eject/@parameters/cancellable nullable 1"
 , "set-attr Gio/Volume/eject/@parameters/callback nullable 1"
 , "set-attr Gio/Volume/eject/@parameters/user_data nullable 1"
 , "set-attr Gio/Volume/eject_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Volume/eject_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/Volume/eject_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/Volume/eject_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/Volume/get_activation_root/@return-value nullable 1"
 , "set-attr Gio/Volume/get_drive/@return-value nullable 1"
 , "set-attr Gio/Volume/get_identifier/@return-value nullable 1"
 , "set-attr Gio/Volume/get_mount/@return-value nullable 1"
 , "set-attr Gio/Volume/get_sort_key/@return-value nullable 1"
 , "set-attr Gio/Volume/get_uuid/@return-value nullable 1"
 , "set-attr Gio/Volume/mount/@parameters/mount_operation nullable 1"
 , "set-attr Gio/Volume/mount/@parameters/cancellable nullable 1"
 , "set-attr Gio/Volume/mount/@parameters/callback nullable 1"
 , "set-attr Gio/Volume/mount/@parameters/user_data nullable 1"
 , "set-attr Gio/VolumeIface/get_uuid/get_uuid/@return-value nullable 1"
 , "set-attr Gio/VolumeIface/get_drive/get_drive/@return-value nullable 1"
 , "set-attr Gio/VolumeIface/get_mount/get_mount/@return-value nullable 1"
 , "set-attr Gio/VolumeIface/mount_fn/mount_fn/@parameters/mount_operation nullable 1"
 , "set-attr Gio/VolumeIface/mount_fn/mount_fn/@parameters/cancellable nullable 1"
 , "set-attr Gio/VolumeIface/mount_fn/mount_fn/@parameters/callback nullable 1"
 , "set-attr Gio/VolumeIface/mount_fn/mount_fn/@parameters/user_data nullable 1"
 , "set-attr Gio/VolumeIface/eject/eject/@parameters/cancellable nullable 1"
 , "set-attr Gio/VolumeIface/eject/eject/@parameters/callback nullable 1"
 , "set-attr Gio/VolumeIface/eject/eject/@parameters/user_data nullable 1"
 , "set-attr Gio/VolumeIface/get_identifier/get_identifier/@return-value nullable 1"
 , "set-attr Gio/VolumeIface/get_activation_root/get_activation_root/@return-value nullable 1"
 , "set-attr Gio/VolumeIface/eject_with_operation/eject_with_operation/@parameters/mount_operation nullable 1"
 , "set-attr Gio/VolumeIface/eject_with_operation/eject_with_operation/@parameters/cancellable nullable 1"
 , "set-attr Gio/VolumeIface/eject_with_operation/eject_with_operation/@parameters/callback nullable 1"
 , "set-attr Gio/VolumeIface/eject_with_operation/eject_with_operation/@parameters/user_data nullable 1"
 , "set-attr Gio/VolumeIface/get_sort_key/get_sort_key/@return-value nullable 1"
 , "set-attr Gio/VolumeMonitor/get_mount_for_uuid/@return-value nullable 1"
 , "set-attr Gio/VolumeMonitor/get_volume_for_uuid/@return-value nullable 1"
 , "set-attr Gio/VolumeMonitor/get_mount_for_uuid/@return-value nullable 1"
 , "set-attr Gio/VolumeMonitor/get_volume_for_uuid/@return-value nullable 1"
 , "set-attr Gio/VolumeMonitorClass/get_volume_for_uuid/get_volume_for_uuid/@return-value nullable 1"
 , "set-attr Gio/VolumeMonitorClass/get_mount_for_uuid/get_mount_for_uuid/@return-value nullable 1"
 , "set-attr Gio/ZlibCompressor/get_file_info/@return-value nullable 1"
 , "set-attr Gio/ZlibCompressor/set_file_info/@parameters/file_info nullable 1"
 , "set-attr Gio/ZlibDecompressor/get_file_info/@return-value nullable 1"
 , "set-attr Gio/action_parse_detailed_name/@parameters/target_value nullable 1"
 , "set-attr Gio/action_print_detailed_name/@parameters/target_value nullable 1"
 , "set-attr Gio/app_info_create_from_commandline/@parameters/application_name nullable 1"
 , "set-attr Gio/app_info_get_default_for_type/@return-value nullable 1"
 , "set-attr Gio/app_info_get_default_for_type_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/app_info_get_default_for_type_async/@parameters/callback nullable 1"
 , "set-attr Gio/app_info_get_default_for_type_async/@parameters/user_data nullable 1"
 , "set-attr Gio/app_info_get_default_for_uri_scheme/@return-value nullable 1"
 , "set-attr Gio/app_info_get_default_for_uri_scheme_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/app_info_get_default_for_uri_scheme_async/@parameters/callback nullable 1"
 , "set-attr Gio/app_info_get_default_for_uri_scheme_async/@parameters/user_data nullable 1"
 , "set-attr Gio/app_info_launch_default_for_uri/@parameters/context nullable 1"
 , "set-attr Gio/app_info_launch_default_for_uri_async/@parameters/context nullable 1"
 , "set-attr Gio/app_info_launch_default_for_uri_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/app_info_launch_default_for_uri_async/@parameters/callback nullable 1"
 , "set-attr Gio/app_info_launch_default_for_uri_async/@parameters/user_data nullable 1"
 , "set-attr Gio/async_initable_newv_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/async_initable_newv_async/@parameters/callback nullable 1"
 , "set-attr Gio/async_initable_newv_async/@parameters/user_data nullable 1"
 , "set-attr Gio/bus_get/@parameters/cancellable nullable 1"
 , "set-attr Gio/bus_get/@parameters/callback nullable 1"
 , "set-attr Gio/bus_get/@parameters/user_data nullable 1"
 , "set-attr Gio/bus_get_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/bus_own_name/@parameters/bus_acquired_handler nullable 1"
 , "set-attr Gio/bus_own_name/@parameters/name_acquired_handler nullable 1"
 , "set-attr Gio/bus_own_name/@parameters/name_lost_handler nullable 1"
 , "set-attr Gio/bus_own_name/@parameters/user_data nullable 1"
 , "set-attr Gio/bus_own_name/@parameters/user_data_free_func nullable 1"
 , "set-attr Gio/bus_own_name_on_connection/@parameters/name_acquired_handler nullable 1"
 , "set-attr Gio/bus_own_name_on_connection/@parameters/name_lost_handler nullable 1"
 , "set-attr Gio/bus_own_name_on_connection/@parameters/user_data nullable 1"
 , "set-attr Gio/bus_own_name_on_connection/@parameters/user_data_free_func nullable 1"
 , "set-attr Gio/bus_own_name_on_connection_with_closures/@parameters/name_acquired_closure nullable 1"
 , "set-attr Gio/bus_own_name_on_connection_with_closures/@parameters/name_lost_closure nullable 1"
 , "set-attr Gio/bus_own_name_with_closures/@parameters/bus_acquired_closure nullable 1"
 , "set-attr Gio/bus_own_name_with_closures/@parameters/name_acquired_closure nullable 1"
 , "set-attr Gio/bus_own_name_with_closures/@parameters/name_lost_closure nullable 1"
 , "set-attr Gio/bus_watch_name/@parameters/name_appeared_handler nullable 1"
 , "set-attr Gio/bus_watch_name/@parameters/name_vanished_handler nullable 1"
 , "set-attr Gio/bus_watch_name/@parameters/user_data nullable 1"
 , "set-attr Gio/bus_watch_name/@parameters/user_data_free_func nullable 1"
 , "set-attr Gio/bus_watch_name_on_connection/@parameters/name_appeared_handler nullable 1"
 , "set-attr Gio/bus_watch_name_on_connection/@parameters/name_vanished_handler nullable 1"
 , "set-attr Gio/bus_watch_name_on_connection/@parameters/user_data nullable 1"
 , "set-attr Gio/bus_watch_name_on_connection/@parameters/user_data_free_func nullable 1"
 , "set-attr Gio/bus_watch_name_on_connection_with_closures/@parameters/name_appeared_closure nullable 1"
 , "set-attr Gio/bus_watch_name_on_connection_with_closures/@parameters/name_vanished_closure nullable 1"
 , "set-attr Gio/bus_watch_name_with_closures/@parameters/name_appeared_closure nullable 1"
 , "set-attr Gio/bus_watch_name_with_closures/@parameters/name_vanished_closure nullable 1"
 , "set-attr Gio/content_type_from_mime_type/@return-value nullable 1"
 , "set-attr Gio/content_type_get_generic_icon_name/@return-value nullable 1"
 , "set-attr Gio/content_type_get_mime_type/@return-value nullable 1"
 , "set-attr Gio/content_type_guess/@parameters/filename nullable 1"
 , "set-attr Gio/content_type_guess/@parameters/data nullable 1"
 , "set-attr Gio/content_type_set_mime_dirs/@parameters/dirs nullable 1"
 , "set-attr Gio/dbus_address_get_for_bus_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/dbus_address_get_stream/@parameters/cancellable nullable 1"
 , "set-attr Gio/dbus_address_get_stream/@parameters/callback nullable 1"
 , "set-attr Gio/dbus_address_get_stream/@parameters/user_data nullable 1"
 , "set-attr Gio/dbus_address_get_stream_finish/@parameters/out_guid nullable 1"
 , "set-attr Gio/dbus_address_get_stream_sync/@parameters/out_guid nullable 1"
 , "set-attr Gio/dbus_address_get_stream_sync/@parameters/cancellable nullable 1"
 , "set-attr Gio/dbus_annotation_info_lookup/@return-value nullable 1"
 , "set-attr Gio/dbus_annotation_info_lookup/@parameters/annotations nullable 1"
 , "set-attr Gio/dbus_error_get_remote_error/@return-value nullable 1"
 , "set-attr Gio/dbus_unescape_object_path/@return-value nullable 1"
 , "set-attr Gio/dtls_client_connection_new/@parameters/server_identity nullable 1"
 , "set-attr Gio/dtls_server_connection_new/@parameters/certificate nullable 1"
 , "set-attr Gio/file_new_tmp/@parameters/tmpl nullable 1"
 , "set-attr Gio/file_new_tmp_async/@parameters/tmpl nullable 1"
 , "set-attr Gio/file_new_tmp_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/file_new_tmp_async/@parameters/callback nullable 1"
 , "set-attr Gio/file_new_tmp_async/@parameters/user_data nullable 1"
 , "set-attr Gio/file_new_tmp_dir_async/@parameters/tmpl nullable 1"
 , "set-attr Gio/file_new_tmp_dir_async/@parameters/cancellable nullable 1"
 , "set-attr Gio/file_new_tmp_dir_async/@parameters/callback nullable 1"
 , "set-attr Gio/file_new_tmp_dir_async/@parameters/user_data nullable 1"
 , "set-attr Gio/icon_deserialize/@return-value nullable 1"
 , "set-attr Gio/initable_newv/@parameters/cancellable nullable 1"
 , "set-attr Gio/io_scheduler_push_job/@parameters/user_data nullable 1"
 , "set-attr Gio/io_scheduler_push_job/@parameters/notify nullable 1"
 , "set-attr Gio/io_scheduler_push_job/@parameters/cancellable nullable 1"
 , "set-attr Gio/keyfile_settings_backend_new/@parameters/root_group nullable 1"
 , "set-attr Gio/pollable_source_new_full/@parameters/child_source nullable 1"
 , "set-attr Gio/pollable_source_new_full/@parameters/cancellable nullable 1"
 , "set-attr Gio/pollable_stream_read/@parameters/cancellable nullable 1"
 , "set-attr Gio/pollable_stream_write/@parameters/cancellable nullable 1"
 , "set-attr Gio/pollable_stream_write_all/@parameters/cancellable nullable 1"
 , "set-attr Gio/proxy_get_default_for_protocol/@return-value nullable 1"
 , "set-attr Gio/settings_schema_source_get_default/@return-value nullable 1"
 , "set-attr Gio/simple_async_report_error_in_idle/@parameters/object nullable 1"
 , "set-attr Gio/simple_async_report_error_in_idle/@parameters/callback nullable 1"
 , "set-attr Gio/simple_async_report_error_in_idle/@parameters/user_data nullable 1"
 , "set-attr Gio/simple_async_report_gerror_in_idle/@parameters/object nullable 1"
 , "set-attr Gio/simple_async_report_gerror_in_idle/@parameters/callback nullable 1"
 , "set-attr Gio/simple_async_report_gerror_in_idle/@parameters/user_data nullable 1"
 , "set-attr Gio/simple_async_report_take_gerror_in_idle/@parameters/object nullable 1"
 , "set-attr Gio/simple_async_report_take_gerror_in_idle/@parameters/callback nullable 1"
 , "set-attr Gio/simple_async_report_take_gerror_in_idle/@parameters/user_data nullable 1"
 , "set-attr Gio/tls_client_connection_new/@parameters/server_identity nullable 1"
 , "set-attr Gio/tls_server_connection_new/@parameters/certificate nullable 1"
 , "set-attr Gio/unix_mount_at/@return-value nullable 1"
 , "set-attr Gio/unix_mount_entries_get_from_file/@return-value nullable 1"
 , "set-attr Gio/unix_mount_entry_at/@return-value nullable 1"
 , "set-attr Gio/unix_mount_entry_for/@return-value nullable 1"
 , "set-attr Gio/unix_mount_for/@return-value nullable 1"
 , "set-attr Gio/unix_mount_get_options/@return-value nullable 1"
 , "set-attr Gio/unix_mount_get_root_path/@return-value nullable 1"
 , "set-attr Gio/unix_mount_point_at/@return-value nullable 1"
 , "set-attr Gio/unix_mount_points_get_from_file/@return-value nullable 1"
 , "set-attr Gio/unix_mounts_get_from_file/@return-value nullable 1"]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.Gio.Config"
 , "GI.Gio"
 , "GI.Gio.Callbacks"
 , "GI.Gio.Constants"
 , "GI.Gio.Enums"
 , "GI.Gio.Flags"
 , "GI.Gio.Functions"
 , "GI.Gio.Interfaces"
 , "GI.Gio.Interfaces.Action"
 , "GI.Gio.Interfaces.ActionGroup"
 , "GI.Gio.Interfaces.ActionMap"
 , "GI.Gio.Interfaces.AppInfo"
 , "GI.Gio.Interfaces.AsyncInitable"
 , "GI.Gio.Interfaces.AsyncResult"
 , "GI.Gio.Interfaces.Converter"
 , "GI.Gio.Interfaces.DBusInterface"
 , "GI.Gio.Interfaces.DBusObject"
 , "GI.Gio.Interfaces.DBusObjectManager"
 , "GI.Gio.Interfaces.DatagramBased"
 , "GI.Gio.Interfaces.DebugController"
 , "GI.Gio.Interfaces.Drive"
 , "GI.Gio.Interfaces.DtlsClientConnection"
 , "GI.Gio.Interfaces.DtlsConnection"
 , "GI.Gio.Interfaces.DtlsServerConnection"
 , "GI.Gio.Interfaces.File"
 , "GI.Gio.Interfaces.Icon"
 , "GI.Gio.Interfaces.Initable"
 , "GI.Gio.Interfaces.ListModel"
 , "GI.Gio.Interfaces.LoadableIcon"
 , "GI.Gio.Interfaces.MemoryMonitor"
 , "GI.Gio.Interfaces.Mount"
 , "GI.Gio.Interfaces.NetworkMonitor"
 , "GI.Gio.Interfaces.PollableInputStream"
 , "GI.Gio.Interfaces.PollableOutputStream"
 , "GI.Gio.Interfaces.PowerProfileMonitor"
 , "GI.Gio.Interfaces.Proxy"
 , "GI.Gio.Interfaces.ProxyResolver"
 , "GI.Gio.Interfaces.RemoteActionGroup"
 , "GI.Gio.Interfaces.Seekable"
 , "GI.Gio.Interfaces.SocketConnectable"
 , "GI.Gio.Interfaces.TlsBackend"
 , "GI.Gio.Interfaces.TlsClientConnection"
 , "GI.Gio.Interfaces.TlsFileDatabase"
 , "GI.Gio.Interfaces.TlsServerConnection"
 , "GI.Gio.Interfaces.Volume"
 , "GI.Gio.Objects"
 , "GI.Gio.Objects.AppInfoMonitor"
 , "GI.Gio.Objects.AppLaunchContext"
 , "GI.Gio.Objects.Application"
 , "GI.Gio.Objects.ApplicationCommandLine"
 , "GI.Gio.Objects.BufferedInputStream"
 , "GI.Gio.Objects.BufferedOutputStream"
 , "GI.Gio.Objects.BytesIcon"
 , "GI.Gio.Objects.Cancellable"
 , "GI.Gio.Objects.CharsetConverter"
 , "GI.Gio.Objects.ConverterInputStream"
 , "GI.Gio.Objects.ConverterOutputStream"
 , "GI.Gio.Objects.Credentials"
 , "GI.Gio.Objects.DBusActionGroup"
 , "GI.Gio.Objects.DBusAuthObserver"
 , "GI.Gio.Objects.DBusConnection"
 , "GI.Gio.Objects.DBusInterfaceSkeleton"
 , "GI.Gio.Objects.DBusMenuModel"
 , "GI.Gio.Objects.DBusMessage"
 , "GI.Gio.Objects.DBusMethodInvocation"
 , "GI.Gio.Objects.DBusObjectManagerClient"
 , "GI.Gio.Objects.DBusObjectManagerServer"
 , "GI.Gio.Objects.DBusObjectProxy"
 , "GI.Gio.Objects.DBusObjectSkeleton"
 , "GI.Gio.Objects.DBusProxy"
 , "GI.Gio.Objects.DBusServer"
 , "GI.Gio.Objects.DataInputStream"
 , "GI.Gio.Objects.DataOutputStream"
 , "GI.Gio.Objects.DebugControllerDBus"
 , "GI.Gio.Objects.Emblem"
 , "GI.Gio.Objects.EmblemedIcon"
 , "GI.Gio.Objects.FileEnumerator"
 , "GI.Gio.Objects.FileIOStream"
 , "GI.Gio.Objects.FileIcon"
 , "GI.Gio.Objects.FileInfo"
 , "GI.Gio.Objects.FileInputStream"
 , "GI.Gio.Objects.FileMonitor"
 , "GI.Gio.Objects.FileOutputStream"
 , "GI.Gio.Objects.FilenameCompleter"
 , "GI.Gio.Objects.FilterInputStream"
 , "GI.Gio.Objects.FilterOutputStream"
 , "GI.Gio.Objects.IOStream"
 , "GI.Gio.Objects.InetAddress"
 , "GI.Gio.Objects.InetAddressMask"
 , "GI.Gio.Objects.InetSocketAddress"
 , "GI.Gio.Objects.InputStream"
 , "GI.Gio.Objects.ListStore"
 , "GI.Gio.Objects.MemoryInputStream"
 , "GI.Gio.Objects.MemoryOutputStream"
 , "GI.Gio.Objects.Menu"
 , "GI.Gio.Objects.MenuAttributeIter"
 , "GI.Gio.Objects.MenuItem"
 , "GI.Gio.Objects.MenuLinkIter"
 , "GI.Gio.Objects.MenuModel"
 , "GI.Gio.Objects.MountOperation"
 , "GI.Gio.Objects.NativeSocketAddress"
 , "GI.Gio.Objects.NativeVolumeMonitor"
 , "GI.Gio.Objects.NetworkAddress"
 , "GI.Gio.Objects.NetworkService"
 , "GI.Gio.Objects.Notification"
 , "GI.Gio.Objects.OutputStream"
 , "GI.Gio.Objects.Permission"
 , "GI.Gio.Objects.PropertyAction"
 , "GI.Gio.Objects.ProxyAddress"
 , "GI.Gio.Objects.ProxyAddressEnumerator"
 , "GI.Gio.Objects.Resolver"
 , "GI.Gio.Objects.Settings"
 , "GI.Gio.Objects.SettingsBackend"
 , "GI.Gio.Objects.SimpleAction"
 , "GI.Gio.Objects.SimpleActionGroup"
 , "GI.Gio.Objects.SimpleAsyncResult"
 , "GI.Gio.Objects.SimpleIOStream"
 , "GI.Gio.Objects.SimplePermission"
 , "GI.Gio.Objects.SimpleProxyResolver"
 , "GI.Gio.Objects.Socket"
 , "GI.Gio.Objects.SocketAddress"
 , "GI.Gio.Objects.SocketAddressEnumerator"
 , "GI.Gio.Objects.SocketClient"
 , "GI.Gio.Objects.SocketConnection"
 , "GI.Gio.Objects.SocketControlMessage"
 , "GI.Gio.Objects.SocketListener"
 , "GI.Gio.Objects.SocketService"
 , "GI.Gio.Objects.Subprocess"
 , "GI.Gio.Objects.SubprocessLauncher"
 , "GI.Gio.Objects.Task"
 , "GI.Gio.Objects.TcpConnection"
 , "GI.Gio.Objects.TcpWrapperConnection"
 , "GI.Gio.Objects.TestDBus"
 , "GI.Gio.Objects.ThemedIcon"
 , "GI.Gio.Objects.ThreadedResolver"
 , "GI.Gio.Objects.ThreadedSocketService"
 , "GI.Gio.Objects.TlsCertificate"
 , "GI.Gio.Objects.TlsConnection"
 , "GI.Gio.Objects.TlsDatabase"
 , "GI.Gio.Objects.TlsInteraction"
 , "GI.Gio.Objects.TlsPassword"
 , "GI.Gio.Objects.UnixConnection"
 , "GI.Gio.Objects.UnixCredentialsMessage"
 , "GI.Gio.Objects.UnixFDList"
 , "GI.Gio.Objects.UnixSocketAddress"
 , "GI.Gio.Objects.Vfs"
 , "GI.Gio.Objects.VolumeMonitor"
 , "GI.Gio.Objects.ZlibCompressor"
 , "GI.Gio.Objects.ZlibDecompressor"
 , "GI.Gio.Structs"
 , "GI.Gio.Structs.ActionEntry"
 , "GI.Gio.Structs.DBusAnnotationInfo"
 , "GI.Gio.Structs.DBusArgInfo"
 , "GI.Gio.Structs.DBusErrorEntry"
 , "GI.Gio.Structs.DBusInterfaceInfo"
 , "GI.Gio.Structs.DBusInterfaceVTable"
 , "GI.Gio.Structs.DBusMethodInfo"
 , "GI.Gio.Structs.DBusNodeInfo"
 , "GI.Gio.Structs.DBusPropertyInfo"
 , "GI.Gio.Structs.DBusSignalInfo"
 , "GI.Gio.Structs.DBusSubtreeVTable"
 , "GI.Gio.Structs.FileAttributeInfo"
 , "GI.Gio.Structs.FileAttributeInfoList"
 , "GI.Gio.Structs.FileAttributeMatcher"
 , "GI.Gio.Structs.IOExtension"
 , "GI.Gio.Structs.IOExtensionPoint"
 , "GI.Gio.Structs.IOModuleScope"
 , "GI.Gio.Structs.IOSchedulerJob"
 , "GI.Gio.Structs.IOStreamAdapter"
 , "GI.Gio.Structs.InputMessage"
 , "GI.Gio.Structs.InputStreamClass"
 , "GI.Gio.Structs.InputVector"
 , "GI.Gio.Structs.OutputMessage"
 , "GI.Gio.Structs.OutputVector"
 , "GI.Gio.Structs.Resource"
 , "GI.Gio.Structs.SeekableIface"
 , "GI.Gio.Structs.SettingsSchema"
 , "GI.Gio.Structs.SettingsSchemaKey"
 , "GI.Gio.Structs.SettingsSchemaSource"
 , "GI.Gio.Structs.SrvTarget"
 , "GI.Gio.Structs.StaticResource"]
