/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// SuccessPolicyApplyConfiguration represents a declarative configuration of the SuccessPolicy type for use
// with apply.
//
// SuccessPolicy describes when a Job can be declared as succeeded based on the success of some indexes.
type SuccessPolicyApplyConfiguration struct {
	// rules represents the list of alternative rules for the declaring the Jobs
	// as successful before `.status.succeeded >= .spec.completions`. Once any of the rules are met,
	// the "SuccessCriteriaMet" condition is added, and the lingering pods are removed.
	// The terminal state for such a Job has the "Complete" condition.
	// Additionally, these rules are evaluated in order; Once the Job meets one of the rules,
	// other rules are ignored. At most 20 elements are allowed.
	Rules []SuccessPolicyRuleApplyConfiguration `json:"rules,omitempty"`
}

// SuccessPolicyApplyConfiguration constructs a declarative configuration of the SuccessPolicy type for use with
// apply.
func SuccessPolicy() *SuccessPolicyApplyConfiguration {
	return &SuccessPolicyApplyConfiguration{}
}

// WithRules adds the given value to the Rules field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Rules field.
func (b *SuccessPolicyApplyConfiguration) WithRules(values ...*SuccessPolicyRuleApplyConfiguration) *SuccessPolicyApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRules")
		}
		b.Rules = append(b.Rules, *values[i])
	}
	return b
}
