#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkHyperTreeGridGenerateFieldStrategy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridAxisClip_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridAxisCut_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridAxisReflection_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridCellCenters_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridCellCenterStrategy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridCellSizeStrategy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridContour_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridDepthLimiter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridEvaluateCoarse_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridExtractGhostCells_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridFeatureEdges_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridGenerateFields_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridGeometry_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridGradient_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridPlaneCutter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridRemoveGhostCells_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridThreshold_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridToDualGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridToUnstructuredGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridValidCellStrategy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridVisibleLeavesSize_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridTotalVisibleVolumeStrategy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageDataToHyperTreeGrid_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersHyperTreeCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkHyperTreeGridGenerateFieldStrategy_Init(csi);
  vtkHyperTreeGridAxisClip_Init(csi);
  vtkHyperTreeGridAxisCut_Init(csi);
  vtkHyperTreeGridAxisReflection_Init(csi);
  vtkHyperTreeGridCellCenters_Init(csi);
  vtkHyperTreeGridCellCenterStrategy_Init(csi);
  vtkHyperTreeGridCellSizeStrategy_Init(csi);
  vtkHyperTreeGridContour_Init(csi);
  vtkHyperTreeGridDepthLimiter_Init(csi);
  vtkHyperTreeGridEvaluateCoarse_Init(csi);
  vtkHyperTreeGridExtractGhostCells_Init(csi);
  vtkHyperTreeGridFeatureEdges_Init(csi);
  vtkHyperTreeGridGenerateFields_Init(csi);
  vtkHyperTreeGridGeometry_Init(csi);
  vtkHyperTreeGridGradient_Init(csi);
  vtkHyperTreeGridPlaneCutter_Init(csi);
  vtkHyperTreeGridRemoveGhostCells_Init(csi);
  vtkHyperTreeGridThreshold_Init(csi);
  vtkHyperTreeGridToDualGrid_Init(csi);
  vtkHyperTreeGridToUnstructuredGrid_Init(csi);
  vtkHyperTreeGridValidCellStrategy_Init(csi);
  vtkHyperTreeGridVisibleLeavesSize_Init(csi);
  vtkHyperTreeGridTotalVisibleVolumeStrategy_Init(csi);
  vtkImageDataToHyperTreeGrid_Init(csi);
}
