// python wrapper for vtkGeometryRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkGeometryRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkGeometryRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGeometryRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkPVDataRepresentation_ClassNew
extern "C" { PyObject *PyvtkPVDataRepresentation_ClassNew(); }
#define DECLARED_PyvtkPVDataRepresentation_ClassNew
#endif
#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGeometryRepresentation_RepresentationTypes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkGeometryRepresentation.RepresentationTypes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkGeometryRepresentation_RepresentationTypes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkGeometryRepresentation_RepresentationTypes_Type, static_cast<int>(val));
}


static PyObject *
PyvtkGeometryRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGeometryRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGeometryRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGeometryRepresentation *tempr = vtkGeometryRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGeometryRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGeometryRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGeometryRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGeometryRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_ProcessViewRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessViewRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkInformationRequestKey *temp0 = nullptr;
  vtkInformation *temp1 = nullptr;
  vtkInformation *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformationRequestKey") &&
      ap.GetVTKObject(temp1, "vtkInformation") &&
      ap.GetVTKObject(temp2, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessViewRequest(temp0, temp1, temp2) :
      op->vtkGeometryRepresentation::ProcessViewRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVisibility(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetBlockColorsDistinctValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockColorsDistinctValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBlockColorsDistinctValues(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetBlockColorsDistinctValues(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetBlockColorsDistinctValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockColorsDistinctValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBlockColorsDistinctValues() :
      op->vtkGeometryRepresentation::GetBlockColorsDistinctValues());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetSuppressLOD(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSuppressLOD");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSuppressLOD(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetSuppressLOD(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_DisableLightingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableLightingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DisableLightingOn();
    }
    else
    {
      op->vtkGeometryRepresentation::DisableLightingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_DisableLightingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableLightingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DisableLightingOff();
    }
    else
    {
      op->vtkGeometryRepresentation::DisableLightingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetDisableLighting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisableLighting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisableLighting(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetDisableLighting(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetDisableLighting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisableLighting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisableLighting() :
      op->vtkGeometryRepresentation::GetDisableLighting());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetAmbient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAmbient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAmbient(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetAmbient(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetDiffuse(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDiffuse");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDiffuse(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetDiffuse(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetSpecular(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecular");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSpecular(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetSpecular(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetAmbient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAmbient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetAmbient() :
      op->vtkGeometryRepresentation::GetAmbient());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetDiffuse(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDiffuse");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetDiffuse() :
      op->vtkGeometryRepresentation::GetDiffuse());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetSpecular(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSpecular");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetSpecular() :
      op->vtkGeometryRepresentation::GetSpecular());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetCoordinateShiftScaleMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoordinateShiftScaleMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCoordinateShiftScaleMethod(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetCoordinateShiftScaleMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetCoordinateShiftScaleMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCoordinateShiftScaleMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCoordinateShiftScaleMethod() :
      op->vtkGeometryRepresentation::GetCoordinateShiftScaleMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetRepresentation_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRepresentation(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetRepresentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGeometryRepresentation_SetRepresentation_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRepresentation(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetRepresentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGeometryRepresentation_SetRepresentation_Methods[] = {
  {"SetRepresentation", PyvtkGeometryRepresentation_SetRepresentation_s1, METH_VARARGS,
   "@i"},
  {"SetRepresentation", PyvtkGeometryRepresentation_SetRepresentation_s2, METH_VARARGS,
   "@z"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkGeometryRepresentation_SetRepresentation(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkGeometryRepresentation_SetRepresentation_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetRepresentation");
  return nullptr;
}


static PyObject *
PyvtkGeometryRepresentation_GetRepresentationMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepresentationMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRepresentationMinValue() :
      op->vtkGeometryRepresentation::GetRepresentationMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetRepresentationMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepresentationMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRepresentationMaxValue() :
      op->vtkGeometryRepresentation::GetRepresentationMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetRepresentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepresentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRepresentation() :
      op->vtkGeometryRepresentation::GetRepresentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetRenderedDataObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderedDataObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetRenderedDataObject(temp0) :
      op->vtkGeometryRepresentation::GetRenderedDataObject(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetRequestGhostCellsIfNeeded(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRequestGhostCellsIfNeeded");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRequestGhostCellsIfNeeded(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetRequestGhostCellsIfNeeded(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetRequestGhostCellsIfNeeded(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRequestGhostCellsIfNeeded");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRequestGhostCellsIfNeeded() :
      op->vtkGeometryRepresentation::GetRequestGhostCellsIfNeeded());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_RequestGhostCellsIfNeededOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RequestGhostCellsIfNeededOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RequestGhostCellsIfNeededOn();
    }
    else
    {
      op->vtkGeometryRepresentation::RequestGhostCellsIfNeededOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_RequestGhostCellsIfNeededOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RequestGhostCellsIfNeededOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RequestGhostCellsIfNeededOff();
    }
    else
    {
      op->vtkGeometryRepresentation::RequestGhostCellsIfNeededOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetNormalArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNormalArray(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetNormalArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetTCoordArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTCoordArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTCoordArray(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetTCoordArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetTangentArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTangentArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTangentArray(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetTangentArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetUseOutline(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseOutline");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseOutline(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetUseOutline(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetTriangulate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTriangulate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTriangulate(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetTriangulate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetNonlinearSubdivisionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNonlinearSubdivisionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNonlinearSubdivisionLevel(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetNonlinearSubdivisionLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetMatchBoundariesIgnoringCellOrder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMatchBoundariesIgnoringCellOrder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMatchBoundariesIgnoringCellOrder(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetMatchBoundariesIgnoringCellOrder(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetGenerateFeatureEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateFeatureEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateFeatureEdges(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetGenerateFeatureEdges(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetComputePointNormals(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputePointNormals");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputePointNormals(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetComputePointNormals(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetSplitting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSplitting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSplitting(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetSplitting(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetFeatureAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFeatureAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFeatureAngle(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetFeatureAngle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetAmbientColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAmbientColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetAmbientColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetAmbientColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetDiffuseColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDiffuseColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetDiffuseColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetDiffuseColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetLighting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLighting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLighting(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetLighting(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetEdgeColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEdgeColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetEdgeColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetEdgeColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetInteractiveSelectionColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInteractiveSelectionColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetInteractiveSelectionColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetInteractiveSelectionColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetInterpolation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpolation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInterpolation(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetInterpolation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetLineWidth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLineWidth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLineWidth(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetLineWidth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetOpacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOpacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOpacity(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetOpacity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetEdgeOpacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEdgeOpacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEdgeOpacity(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetEdgeOpacity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetPointSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointSize(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetPointSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetSpecularColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecularColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSpecularColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetSpecularColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetSpecularPower(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecularPower");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSpecularPower(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetSpecularPower(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetLuminosity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLuminosity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLuminosity(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetLuminosity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetRenderPointsAsSpheres(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderPointsAsSpheres");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRenderPointsAsSpheres(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetRenderPointsAsSpheres(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetRenderLinesAsTubes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderLinesAsTubes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRenderLinesAsTubes(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetRenderLinesAsTubes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetRoughness(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRoughness");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRoughness(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetRoughness(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetMetallic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMetallic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMetallic(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetMetallic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetEdgeTint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEdgeTint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetEdgeTint(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetEdgeTint(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetAnisotropy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnisotropy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAnisotropy(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetAnisotropy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetAnisotropyRotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnisotropyRotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAnisotropyRotation(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetAnisotropyRotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetBaseIOR(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBaseIOR");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBaseIOR(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetBaseIOR(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetCoatIOR(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoatIOR");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCoatIOR(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetCoatIOR(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetCoatStrength(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoatStrength");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCoatStrength(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetCoatStrength(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetCoatRoughness(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoatRoughness");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCoatRoughness(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetCoatRoughness(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetCoatNormalScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoatNormalScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCoatNormalScale(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetCoatNormalScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetCoatColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoatColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetCoatColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetCoatColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetBaseColorTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBaseColorTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkTexture *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTexture"))
  {
    if (ap.IsBound())
    {
      op->SetBaseColorTexture(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetBaseColorTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetMaterialTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaterialTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkTexture *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTexture"))
  {
    if (ap.IsBound())
    {
      op->SetMaterialTexture(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetMaterialTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetAnisotropyTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnisotropyTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkTexture *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTexture"))
  {
    if (ap.IsBound())
    {
      op->SetAnisotropyTexture(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetAnisotropyTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetNormalTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkTexture *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTexture"))
  {
    if (ap.IsBound())
    {
      op->SetNormalTexture(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetNormalTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetCoatNormalTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoatNormalTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkTexture *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTexture"))
  {
    if (ap.IsBound())
    {
      op->SetCoatNormalTexture(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetCoatNormalTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetEmissiveTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEmissiveTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkTexture *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTexture"))
  {
    if (ap.IsBound())
    {
      op->SetEmissiveTexture(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetEmissiveTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetNormalScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNormalScale(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetNormalScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetOcclusionStrength(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOcclusionStrength");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOcclusionStrength(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetOcclusionStrength(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetEmissiveFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEmissiveFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetEmissiveFactor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetEmissiveFactor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetShowTexturesOnBackface(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShowTexturesOnBackface");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShowTexturesOnBackface(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetShowTexturesOnBackface(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetOrientation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrientation(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetOrientation(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetOrigin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrigin(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetOrigin(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetPickable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPickable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPickable(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetPickable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPosition(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetPosition(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetScale(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetScale(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkTexture *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTexture"))
  {
    if (ap.IsBound())
    {
      op->SetTexture(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetUserTransform(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUserTransform");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const size_t size0 = 16;
  double temp0[16];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetUserTransform(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetUserTransform(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetFlipTextures(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method SetFlipTextures."
    " (" "Use SetTextureTransform instead" ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(self, args, "SetFlipTextures");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFlipTextures(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetFlipTextures(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetCoordinateSystem(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoordinateSystem");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCoordinateSystem(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetCoordinateSystem(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetTextureTransform(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTextureTransform");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkTransform *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTransform"))
  {
    if (ap.IsBound())
    {
      op->SetTextureTransform(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetTextureTransform(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetTextureTransform(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTextureTransform");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkTransform *tempr = (ap.IsBound() ?
      op->GetTextureTransform() :
      op->vtkGeometryRepresentation::GetTextureTransform());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetRepeatTextures(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRepeatTextures");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRepeatTextures(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetRepeatTextures(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetRepeatTextures(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepeatTextures");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRepeatTextures() :
      op->vtkGeometryRepresentation::GetRepeatTextures());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetInterpolateTextures(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpolateTextures");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInterpolateTextures(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetInterpolateTextures(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetInterpolateTextures(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInterpolateTextures");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetInterpolateTextures() :
      op->vtkGeometryRepresentation::GetInterpolateTextures());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetUseMipmapTextures(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseMipmapTextures");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseMipmapTextures(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetUseMipmapTextures(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetUseMipmapTextures(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseMipmapTextures");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseMipmapTextures() :
      op->vtkGeometryRepresentation::GetUseMipmapTextures());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetInterpolateScalarsBeforeMapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpolateScalarsBeforeMapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInterpolateScalarsBeforeMapping(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetInterpolateScalarsBeforeMapping(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetLookupTable(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetLookupTable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetColorMissingArraysWithNanColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColorMissingArraysWithNanColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetColorMissingArraysWithNanColor(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetColorMissingArraysWithNanColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetSeamlessU(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSeamlessU");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSeamlessU(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetSeamlessU(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetSeamlessV(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSeamlessV");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSeamlessV(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetSeamlessV(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetMapScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMapScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMapScalars(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetMapScalars(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetStatic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStatic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStatic(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetStatic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkSelection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSelection"))
  {
    if (ap.IsBound())
    {
      op->SetSelection(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetSelection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetActor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVLODActor *tempr = (ap.IsBound() ?
      op->GetActor() :
      op->vtkGeometryRepresentation::GetActor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetActiveAssembly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActiveAssembly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActiveAssembly(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetActiveAssembly(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetActiveAssembly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveAssembly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetActiveAssembly() :
      op->vtkGeometryRepresentation::GetActiveAssembly());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_AddBlockSelector(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddBlockSelector");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddBlockSelector(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::AddBlockSelector(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_RemoveAllBlockSelectors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllBlockSelectors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllBlockSelectors();
    }
    else
    {
      op->vtkGeometryRepresentation::RemoveAllBlockSelectors();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetBlockColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetBlockColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkGeometryRepresentation::SetBlockColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_RemoveAllBlockColors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllBlockColors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllBlockColors();
    }
    else
    {
      op->vtkGeometryRepresentation::RemoveAllBlockColors();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetBlockOpacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockOpacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetBlockOpacity(temp0, temp1);
    }
    else
    {
      op->vtkGeometryRepresentation::SetBlockOpacity(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_RemoveAllBlockOpacities(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllBlockOpacities");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllBlockOpacities();
    }
    else
    {
      op->vtkGeometryRepresentation::RemoveAllBlockOpacities();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetBlockInterpolateScalarsBeforeMapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockInterpolateScalarsBeforeMapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetBlockInterpolateScalarsBeforeMapping(temp0, temp1);
    }
    else
    {
      op->vtkGeometryRepresentation::SetBlockInterpolateScalarsBeforeMapping(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_RemoveAllBlockInterpolateScalarsBeforeMappings(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllBlockInterpolateScalarsBeforeMappings");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllBlockInterpolateScalarsBeforeMappings();
    }
    else
    {
      op->vtkGeometryRepresentation::RemoveAllBlockInterpolateScalarsBeforeMappings();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetBlockMapScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockMapScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetBlockMapScalars(temp0, temp1);
    }
    else
    {
      op->vtkGeometryRepresentation::SetBlockMapScalars(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_RemoveAllBlockMapScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllBlockMapScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllBlockMapScalars();
    }
    else
    {
      op->vtkGeometryRepresentation::RemoveAllBlockMapScalars();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetBlockArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  const char *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBlockArrayName(temp0, temp1, temp2);
    }
    else
    {
      op->vtkGeometryRepresentation::SetBlockArrayName(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_RemoveAllBlockArrayNames(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllBlockArrayNames");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllBlockArrayNames();
    }
    else
    {
      op->vtkGeometryRepresentation::RemoveAllBlockArrayNames();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetBlockLookupTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockLookupTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetBlockLookupTable(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetBlockLookupTable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_RemoveAllBlockLookupTables(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllBlockLookupTables");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllBlockLookupTables();
    }
    else
    {
      op->vtkGeometryRepresentation::RemoveAllBlockLookupTables();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetColorArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColorArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetColorArrayName() :
      op->vtkGeometryRepresentation::GetColorArrayName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetBounds(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetBounds");

  vtkDataObject *temp0 = nullptr;
  const size_t size1 = 6;
  double temp1[6];
  double save1[6];
  vtkCompositeDataDisplayAttributes *temp2 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkDataObject") &&
      ap.GetArray(temp1, size1) &&
      ap.GetVTKObject(temp2, "vtkCompositeDataDisplayAttributes"))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    bool tempr = vtkGeometryRepresentation::GetBounds(temp0, temp1, temp2);

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetEnableScaling(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableScaling");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableScaling(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetEnableScaling(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetScalingArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScalingArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScalingArrayName(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetScalingArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetScalingFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScalingFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  vtkPiecewiseFunction *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPiecewiseFunction"))
  {
    if (ap.IsBound())
    {
      op->SetScalingFunction(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetScalingFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetMaterial(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaterial");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaterial(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetMaterial(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetUseDataPartitions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseDataPartitions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseDataPartitions(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetUseDataPartitions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetUseDataPartitions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseDataPartitions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseDataPartitions() :
      op->vtkGeometryRepresentation::GetUseDataPartitions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetUseShaderReplacements(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseShaderReplacements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseShaderReplacements(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetUseShaderReplacements(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetUseShaderReplacements(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseShaderReplacements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseShaderReplacements() :
      op->vtkGeometryRepresentation::GetUseShaderReplacements());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetShaderReplacements(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShaderReplacements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShaderReplacements(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetShaderReplacements(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetArrayIdNames(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArrayIdNames");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetArrayIdNames(temp0, temp1);
    }
    else
    {
      op->vtkGeometryRepresentation::SetArrayIdNames(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_SetPlaceHolderDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPlaceHolderDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPlaceHolderDataType(temp0);
    }
    else
    {
      op->vtkGeometryRepresentation::SetPlaceHolderDataType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeometryRepresentation_GetPlaceHolderDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPlaceHolderDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeometryRepresentation *op = static_cast<vtkGeometryRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPlaceHolderDataType() :
      op->vtkGeometryRepresentation::GetPlaceHolderDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkGeometryRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkGeometryRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGeometryRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGeometryRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkGeometryRepresentation\nC++: static vtkGeometryRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGeometryRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkGeometryRepresentation\nC++: vtkGeometryRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGeometryRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGeometryRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ProcessViewRequest", PyvtkGeometryRepresentation_ProcessViewRequest, METH_VARARGS,
   "ProcessViewRequest(self, request_type:vtkInformationRequestKey,\n    inInfo:vtkInformation, outInfo:vtkInformation) -> int\nC++: int ProcessViewRequest(\n    vtkInformationRequestKey *request_type,\n    vtkInformation *inInfo, vtkInformation *outInfo) override;\n\nvtkAlgorithm::ProcessRequest() equivalent for rendering passes.\nThis is typically called by the vtkView to request meta-data from\nthe representations or ask them to perform certain tasks e.g.\nPrepareForRendering.\n"},
  {"SetVisibility", PyvtkGeometryRepresentation_SetVisibility, METH_VARARGS,
   "SetVisibility(self, val:bool) -> None\nC++: void SetVisibility(bool val) override;\n\nGet/Set the visibility for this representation. When the\nvisibility of representation of false, all view passes are\nignored.\n"},
  {"SetBlockColorsDistinctValues", PyvtkGeometryRepresentation_SetBlockColorsDistinctValues, METH_VARARGS,
   "SetBlockColorsDistinctValues(self, distinctValues:int) -> None\nC++: void SetBlockColorsDistinctValues(int distinctValues)\n\nDetermines the number of distinct values in vtkBlockColors See\nalso vtkPVGeometryFilter\n"},
  {"GetBlockColorsDistinctValues", PyvtkGeometryRepresentation_GetBlockColorsDistinctValues, METH_VARARGS,
   "GetBlockColorsDistinctValues(self) -> int\nC++: int GetBlockColorsDistinctValues()\n\n"},
  {"SetSuppressLOD", PyvtkGeometryRepresentation_SetSuppressLOD, METH_VARARGS,
   "SetSuppressLOD(self, suppress:bool) -> None\nC++: virtual void SetSuppressLOD(bool suppress)\n\nEnable/Disable LOD;\n"},
  {"DisableLightingOn", PyvtkGeometryRepresentation_DisableLightingOn, METH_VARARGS,
   "DisableLightingOn(self) -> None\nC++: virtual void DisableLightingOn()\n\nDisables the lighting on the object. It only displays the Diffuse\ncomponent of the lighting color of the object.\n"},
  {"DisableLightingOff", PyvtkGeometryRepresentation_DisableLightingOff, METH_VARARGS,
   "DisableLightingOff(self) -> None\nC++: virtual void DisableLightingOff()\n\n"},
  {"SetDisableLighting", PyvtkGeometryRepresentation_SetDisableLighting, METH_VARARGS,
   "SetDisableLighting(self, _arg:bool) -> None\nC++: virtual void SetDisableLighting(bool _arg)\n\n"},
  {"GetDisableLighting", PyvtkGeometryRepresentation_GetDisableLighting, METH_VARARGS,
   "GetDisableLighting(self) -> bool\nC++: virtual bool GetDisableLighting()\n\n"},
  {"SetAmbient", PyvtkGeometryRepresentation_SetAmbient, METH_VARARGS,
   "SetAmbient(self, _arg:float) -> None\nC++: virtual void SetAmbient(double _arg)\n\nSet the lighting properties of the object.\nvtkGeometryRepresentation overrides these based of the following\nconditions:\n\\li When Representation is wireframe or points, it disables\n    diffuse or\nspecular.\n\\li When scalar coloring is employed, it disabled specular.\n"},
  {"SetDiffuse", PyvtkGeometryRepresentation_SetDiffuse, METH_VARARGS,
   "SetDiffuse(self, _arg:float) -> None\nC++: virtual void SetDiffuse(double _arg)\n\n"},
  {"SetSpecular", PyvtkGeometryRepresentation_SetSpecular, METH_VARARGS,
   "SetSpecular(self, _arg:float) -> None\nC++: virtual void SetSpecular(double _arg)\n\n"},
  {"GetAmbient", PyvtkGeometryRepresentation_GetAmbient, METH_VARARGS,
   "GetAmbient(self) -> float\nC++: virtual double GetAmbient()\n\n"},
  {"GetDiffuse", PyvtkGeometryRepresentation_GetDiffuse, METH_VARARGS,
   "GetDiffuse(self) -> float\nC++: virtual double GetDiffuse()\n\n"},
  {"GetSpecular", PyvtkGeometryRepresentation_GetSpecular, METH_VARARGS,
   "GetSpecular(self) -> float\nC++: virtual double GetSpecular()\n\n"},
  {"SetCoordinateShiftScaleMethod", PyvtkGeometryRepresentation_SetCoordinateShiftScaleMethod, METH_VARARGS,
   "SetCoordinateShiftScaleMethod(self, val:int) -> None\nC++: void SetCoordinateShiftScaleMethod(int val)\n\nSet the shift scale method for the point coordinates see\nvtkOpenGLVertexBufferObject.h for more information.\n"},
  {"GetCoordinateShiftScaleMethod", PyvtkGeometryRepresentation_GetCoordinateShiftScaleMethod, METH_VARARGS,
   "GetCoordinateShiftScaleMethod(self) -> int\nC++: int GetCoordinateShiftScaleMethod()\n\n"},
  {"SetRepresentation", PyvtkGeometryRepresentation_SetRepresentation, METH_VARARGS,
   "SetRepresentation(self, _arg:int) -> None\nC++: virtual void SetRepresentation(int _arg)\nSetRepresentation(self, __a:str) -> None\nC++: virtual void SetRepresentation(const char *)\n\nSet the representation type. This adds VTK_SURFACE_WITH_EDGES to\nthose defined in vtkProperty.\n"},
  {"GetRepresentationMinValue", PyvtkGeometryRepresentation_GetRepresentationMinValue, METH_VARARGS,
   "GetRepresentationMinValue(self) -> int\nC++: virtual int GetRepresentationMinValue()\n\n"},
  {"GetRepresentationMaxValue", PyvtkGeometryRepresentation_GetRepresentationMaxValue, METH_VARARGS,
   "GetRepresentationMaxValue(self) -> int\nC++: virtual int GetRepresentationMaxValue()\n\n"},
  {"GetRepresentation", PyvtkGeometryRepresentation_GetRepresentation, METH_VARARGS,
   "GetRepresentation(self) -> int\nC++: virtual int GetRepresentation()\n\n"},
  {"GetRenderedDataObject", PyvtkGeometryRepresentation_GetRenderedDataObject, METH_VARARGS,
   "GetRenderedDataObject(self, port:int) -> vtkDataObject\nC++: vtkDataObject *GetRenderedDataObject(int port) override;\n\nReturns the data object that is rendered from the given input\nport.\n"},
  {"SetRequestGhostCellsIfNeeded", PyvtkGeometryRepresentation_SetRequestGhostCellsIfNeeded, METH_VARARGS,
   "SetRequestGhostCellsIfNeeded(self, _arg:bool) -> None\nC++: virtual void SetRequestGhostCellsIfNeeded(bool _arg)\n\nRepresentations that use geometry representation as the internal\nrepresentation should turn this flag off so that we don't end up\nrequesting ghost cells twice.\n"},
  {"GetRequestGhostCellsIfNeeded", PyvtkGeometryRepresentation_GetRequestGhostCellsIfNeeded, METH_VARARGS,
   "GetRequestGhostCellsIfNeeded(self) -> bool\nC++: virtual bool GetRequestGhostCellsIfNeeded()\n\n"},
  {"RequestGhostCellsIfNeededOn", PyvtkGeometryRepresentation_RequestGhostCellsIfNeededOn, METH_VARARGS,
   "RequestGhostCellsIfNeededOn(self) -> None\nC++: virtual void RequestGhostCellsIfNeededOn()\n\n"},
  {"RequestGhostCellsIfNeededOff", PyvtkGeometryRepresentation_RequestGhostCellsIfNeededOff, METH_VARARGS,
   "RequestGhostCellsIfNeededOff(self) -> None\nC++: virtual void RequestGhostCellsIfNeededOff()\n\n"},
  {"SetNormalArray", PyvtkGeometryRepresentation_SetNormalArray, METH_VARARGS,
   "SetNormalArray(self, val:str) -> None\nC++: virtual void SetNormalArray(const char *val)\n\nSet the normal array used for smooth shading. It must be a three\ncomponents array.\n"},
  {"SetTCoordArray", PyvtkGeometryRepresentation_SetTCoordArray, METH_VARARGS,
   "SetTCoordArray(self, val:str) -> None\nC++: virtual void SetTCoordArray(const char *val)\n\nSet the texture coordinates array used for texture mapping. It\nmust be a two components array.\n"},
  {"SetTangentArray", PyvtkGeometryRepresentation_SetTangentArray, METH_VARARGS,
   "SetTangentArray(self, val:str) -> None\nC++: virtual void SetTangentArray(const char *val)\n\nSet the tangent coordinates array used for normal mapping. It\nmust be a three components array.\n"},
  {"SetUseOutline", PyvtkGeometryRepresentation_SetUseOutline, METH_VARARGS,
   "SetUseOutline(self, __a:int) -> None\nC++: virtual void SetUseOutline(int)\n\n"},
  {"SetTriangulate", PyvtkGeometryRepresentation_SetTriangulate, METH_VARARGS,
   "SetTriangulate(self, __a:int) -> None\nC++: void SetTriangulate(int)\n\n"},
  {"SetNonlinearSubdivisionLevel", PyvtkGeometryRepresentation_SetNonlinearSubdivisionLevel, METH_VARARGS,
   "SetNonlinearSubdivisionLevel(self, __a:int) -> None\nC++: void SetNonlinearSubdivisionLevel(int)\n\n"},
  {"SetMatchBoundariesIgnoringCellOrder", PyvtkGeometryRepresentation_SetMatchBoundariesIgnoringCellOrder, METH_VARARGS,
   "SetMatchBoundariesIgnoringCellOrder(self, __a:int) -> None\nC++: void SetMatchBoundariesIgnoringCellOrder(int)\n\n"},
  {"SetGenerateFeatureEdges", PyvtkGeometryRepresentation_SetGenerateFeatureEdges, METH_VARARGS,
   "SetGenerateFeatureEdges(self, __a:bool) -> None\nC++: virtual void SetGenerateFeatureEdges(bool)\n\n"},
  {"SetComputePointNormals", PyvtkGeometryRepresentation_SetComputePointNormals, METH_VARARGS,
   "SetComputePointNormals(self, __a:bool) -> None\nC++: void SetComputePointNormals(bool)\n\n"},
  {"SetSplitting", PyvtkGeometryRepresentation_SetSplitting, METH_VARARGS,
   "SetSplitting(self, __a:bool) -> None\nC++: void SetSplitting(bool)\n\n"},
  {"SetFeatureAngle", PyvtkGeometryRepresentation_SetFeatureAngle, METH_VARARGS,
   "SetFeatureAngle(self, __a:float) -> None\nC++: void SetFeatureAngle(double)\n\n"},
  {"SetAmbientColor", PyvtkGeometryRepresentation_SetAmbientColor, METH_VARARGS,
   "SetAmbientColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetAmbientColor(double r, double g, double b)\n\n"},
  {"SetColor", PyvtkGeometryRepresentation_SetColor, METH_VARARGS,
   "SetColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetColor(double r, double g, double b)\n\n"},
  {"SetDiffuseColor", PyvtkGeometryRepresentation_SetDiffuseColor, METH_VARARGS,
   "SetDiffuseColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetDiffuseColor(double r, double g, double b)\n\n"},
  {"SetLighting", PyvtkGeometryRepresentation_SetLighting, METH_VARARGS,
   "SetLighting(self, lighting:bool) -> None\nC++: virtual void SetLighting(bool lighting)\n\n"},
  {"SetEdgeColor", PyvtkGeometryRepresentation_SetEdgeColor, METH_VARARGS,
   "SetEdgeColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetEdgeColor(double r, double g, double b)\n\n"},
  {"SetInteractiveSelectionColor", PyvtkGeometryRepresentation_SetInteractiveSelectionColor, METH_VARARGS,
   "SetInteractiveSelectionColor(self, r:float, g:float, b:float)\n    -> None\nC++: virtual void SetInteractiveSelectionColor(double r, double g,\n     double b)\n\n"},
  {"SetInterpolation", PyvtkGeometryRepresentation_SetInterpolation, METH_VARARGS,
   "SetInterpolation(self, val:int) -> None\nC++: virtual void SetInterpolation(int val)\n\n"},
  {"SetLineWidth", PyvtkGeometryRepresentation_SetLineWidth, METH_VARARGS,
   "SetLineWidth(self, val:float) -> None\nC++: virtual void SetLineWidth(double val)\n\n"},
  {"SetOpacity", PyvtkGeometryRepresentation_SetOpacity, METH_VARARGS,
   "SetOpacity(self, val:float) -> None\nC++: virtual void SetOpacity(double val)\n\n"},
  {"SetEdgeOpacity", PyvtkGeometryRepresentation_SetEdgeOpacity, METH_VARARGS,
   "SetEdgeOpacity(self, val:float) -> None\nC++: virtual void SetEdgeOpacity(double val)\n\n"},
  {"SetPointSize", PyvtkGeometryRepresentation_SetPointSize, METH_VARARGS,
   "SetPointSize(self, val:float) -> None\nC++: virtual void SetPointSize(double val)\n\n"},
  {"SetSpecularColor", PyvtkGeometryRepresentation_SetSpecularColor, METH_VARARGS,
   "SetSpecularColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetSpecularColor(double r, double g, double b)\n\n"},
  {"SetSpecularPower", PyvtkGeometryRepresentation_SetSpecularPower, METH_VARARGS,
   "SetSpecularPower(self, val:float) -> None\nC++: virtual void SetSpecularPower(double val)\n\n"},
  {"SetLuminosity", PyvtkGeometryRepresentation_SetLuminosity, METH_VARARGS,
   "SetLuminosity(self, val:float) -> None\nC++: virtual void SetLuminosity(double val)\n\n"},
  {"SetRenderPointsAsSpheres", PyvtkGeometryRepresentation_SetRenderPointsAsSpheres, METH_VARARGS,
   "SetRenderPointsAsSpheres(self, __a:bool) -> None\nC++: virtual void SetRenderPointsAsSpheres(bool)\n\n"},
  {"SetRenderLinesAsTubes", PyvtkGeometryRepresentation_SetRenderLinesAsTubes, METH_VARARGS,
   "SetRenderLinesAsTubes(self, __a:bool) -> None\nC++: virtual void SetRenderLinesAsTubes(bool)\n\n"},
  {"SetRoughness", PyvtkGeometryRepresentation_SetRoughness, METH_VARARGS,
   "SetRoughness(self, val:float) -> None\nC++: virtual void SetRoughness(double val)\n\n"},
  {"SetMetallic", PyvtkGeometryRepresentation_SetMetallic, METH_VARARGS,
   "SetMetallic(self, val:float) -> None\nC++: virtual void SetMetallic(double val)\n\n"},
  {"SetEdgeTint", PyvtkGeometryRepresentation_SetEdgeTint, METH_VARARGS,
   "SetEdgeTint(self, r:float, g:float, b:float) -> None\nC++: virtual void SetEdgeTint(double r, double g, double b)\n\n"},
  {"SetAnisotropy", PyvtkGeometryRepresentation_SetAnisotropy, METH_VARARGS,
   "SetAnisotropy(self, val:float) -> None\nC++: virtual void SetAnisotropy(double val)\n\n"},
  {"SetAnisotropyRotation", PyvtkGeometryRepresentation_SetAnisotropyRotation, METH_VARARGS,
   "SetAnisotropyRotation(self, val:float) -> None\nC++: virtual void SetAnisotropyRotation(double val)\n\n"},
  {"SetBaseIOR", PyvtkGeometryRepresentation_SetBaseIOR, METH_VARARGS,
   "SetBaseIOR(self, val:float) -> None\nC++: virtual void SetBaseIOR(double val)\n\n"},
  {"SetCoatIOR", PyvtkGeometryRepresentation_SetCoatIOR, METH_VARARGS,
   "SetCoatIOR(self, val:float) -> None\nC++: virtual void SetCoatIOR(double val)\n\n"},
  {"SetCoatStrength", PyvtkGeometryRepresentation_SetCoatStrength, METH_VARARGS,
   "SetCoatStrength(self, val:float) -> None\nC++: virtual void SetCoatStrength(double val)\n\n"},
  {"SetCoatRoughness", PyvtkGeometryRepresentation_SetCoatRoughness, METH_VARARGS,
   "SetCoatRoughness(self, val:float) -> None\nC++: virtual void SetCoatRoughness(double val)\n\n"},
  {"SetCoatNormalScale", PyvtkGeometryRepresentation_SetCoatNormalScale, METH_VARARGS,
   "SetCoatNormalScale(self, val:float) -> None\nC++: virtual void SetCoatNormalScale(double val)\n\n"},
  {"SetCoatColor", PyvtkGeometryRepresentation_SetCoatColor, METH_VARARGS,
   "SetCoatColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetCoatColor(double r, double g, double b)\n\n"},
  {"SetBaseColorTexture", PyvtkGeometryRepresentation_SetBaseColorTexture, METH_VARARGS,
   "SetBaseColorTexture(self, tex:vtkTexture) -> None\nC++: virtual void SetBaseColorTexture(vtkTexture *tex)\n\n"},
  {"SetMaterialTexture", PyvtkGeometryRepresentation_SetMaterialTexture, METH_VARARGS,
   "SetMaterialTexture(self, tex:vtkTexture) -> None\nC++: virtual void SetMaterialTexture(vtkTexture *tex)\n\n"},
  {"SetAnisotropyTexture", PyvtkGeometryRepresentation_SetAnisotropyTexture, METH_VARARGS,
   "SetAnisotropyTexture(self, tex:vtkTexture) -> None\nC++: virtual void SetAnisotropyTexture(vtkTexture *tex)\n\n"},
  {"SetNormalTexture", PyvtkGeometryRepresentation_SetNormalTexture, METH_VARARGS,
   "SetNormalTexture(self, tex:vtkTexture) -> None\nC++: virtual void SetNormalTexture(vtkTexture *tex)\n\n"},
  {"SetCoatNormalTexture", PyvtkGeometryRepresentation_SetCoatNormalTexture, METH_VARARGS,
   "SetCoatNormalTexture(self, tex:vtkTexture) -> None\nC++: virtual void SetCoatNormalTexture(vtkTexture *tex)\n\n"},
  {"SetEmissiveTexture", PyvtkGeometryRepresentation_SetEmissiveTexture, METH_VARARGS,
   "SetEmissiveTexture(self, tex:vtkTexture) -> None\nC++: virtual void SetEmissiveTexture(vtkTexture *tex)\n\n"},
  {"SetNormalScale", PyvtkGeometryRepresentation_SetNormalScale, METH_VARARGS,
   "SetNormalScale(self, val:float) -> None\nC++: virtual void SetNormalScale(double val)\n\n"},
  {"SetOcclusionStrength", PyvtkGeometryRepresentation_SetOcclusionStrength, METH_VARARGS,
   "SetOcclusionStrength(self, val:float) -> None\nC++: virtual void SetOcclusionStrength(double val)\n\n"},
  {"SetEmissiveFactor", PyvtkGeometryRepresentation_SetEmissiveFactor, METH_VARARGS,
   "SetEmissiveFactor(self, rval:float, gval:float, bval:float)\n    -> None\nC++: virtual void SetEmissiveFactor(double rval, double gval,\n    double bval)\n\n"},
  {"SetShowTexturesOnBackface", PyvtkGeometryRepresentation_SetShowTexturesOnBackface, METH_VARARGS,
   "SetShowTexturesOnBackface(self, __a:bool) -> None\nC++: virtual void SetShowTexturesOnBackface(bool)\n\n"},
  {"SetOrientation", PyvtkGeometryRepresentation_SetOrientation, METH_VARARGS,
   "SetOrientation(self, __a:float, __b:float, __c:float) -> None\nC++: virtual void SetOrientation(double, double, double)\n\n"},
  {"SetOrigin", PyvtkGeometryRepresentation_SetOrigin, METH_VARARGS,
   "SetOrigin(self, __a:float, __b:float, __c:float) -> None\nC++: virtual void SetOrigin(double, double, double)\n\n"},
  {"SetPickable", PyvtkGeometryRepresentation_SetPickable, METH_VARARGS,
   "SetPickable(self, val:int) -> None\nC++: virtual void SetPickable(int val)\n\n"},
  {"SetPosition", PyvtkGeometryRepresentation_SetPosition, METH_VARARGS,
   "SetPosition(self, __a:float, __b:float, __c:float) -> None\nC++: virtual void SetPosition(double, double, double)\n\n"},
  {"SetScale", PyvtkGeometryRepresentation_SetScale, METH_VARARGS,
   "SetScale(self, __a:float, __b:float, __c:float) -> None\nC++: virtual void SetScale(double, double, double)\n\n"},
  {"SetTexture", PyvtkGeometryRepresentation_SetTexture, METH_VARARGS,
   "SetTexture(self, __a:vtkTexture) -> None\nC++: virtual void SetTexture(vtkTexture *)\n\n"},
  {"SetUserTransform", PyvtkGeometryRepresentation_SetUserTransform, METH_VARARGS,
   "SetUserTransform(self, __a:(float, float, float, float, float,\n    float, float, float, float, float, float, float, float, float,\n     float, float)) -> None\nC++: virtual void SetUserTransform(const double[16])\n\n"},
  {"SetFlipTextures", PyvtkGeometryRepresentation_SetFlipTextures, METH_VARARGS,
   "SetFlipTextures(self, __a:bool) -> None\nC++: virtual void SetFlipTextures(bool)\n\n"},
  {"SetCoordinateSystem", PyvtkGeometryRepresentation_SetCoordinateSystem, METH_VARARGS,
   "SetCoordinateSystem(self, __a:int) -> None\nC++: virtual void SetCoordinateSystem(int)\n\n"},
  {"SetTextureTransform", PyvtkGeometryRepresentation_SetTextureTransform, METH_VARARGS,
   "SetTextureTransform(self, __a:vtkTransform) -> None\nC++: virtual void SetTextureTransform(vtkTransform *)\n\n"},
  {"GetTextureTransform", PyvtkGeometryRepresentation_GetTextureTransform, METH_VARARGS,
   "GetTextureTransform(self) -> vtkTransform\nC++: virtual vtkTransform *GetTextureTransform()\n\n"},
  {"SetRepeatTextures", PyvtkGeometryRepresentation_SetRepeatTextures, METH_VARARGS,
   "SetRepeatTextures(self, __a:bool) -> None\nC++: virtual void SetRepeatTextures(bool)\n\n"},
  {"GetRepeatTextures", PyvtkGeometryRepresentation_GetRepeatTextures, METH_VARARGS,
   "GetRepeatTextures(self) -> bool\nC++: virtual bool GetRepeatTextures()\n\n"},
  {"SetInterpolateTextures", PyvtkGeometryRepresentation_SetInterpolateTextures, METH_VARARGS,
   "SetInterpolateTextures(self, __a:bool) -> None\nC++: virtual void SetInterpolateTextures(bool)\n\n"},
  {"GetInterpolateTextures", PyvtkGeometryRepresentation_GetInterpolateTextures, METH_VARARGS,
   "GetInterpolateTextures(self) -> bool\nC++: virtual bool GetInterpolateTextures()\n\n"},
  {"SetUseMipmapTextures", PyvtkGeometryRepresentation_SetUseMipmapTextures, METH_VARARGS,
   "SetUseMipmapTextures(self, __a:bool) -> None\nC++: virtual void SetUseMipmapTextures(bool)\n\n"},
  {"GetUseMipmapTextures", PyvtkGeometryRepresentation_GetUseMipmapTextures, METH_VARARGS,
   "GetUseMipmapTextures(self) -> bool\nC++: virtual bool GetUseMipmapTextures()\n\n"},
  {"SetInterpolateScalarsBeforeMapping", PyvtkGeometryRepresentation_SetInterpolateScalarsBeforeMapping, METH_VARARGS,
   "SetInterpolateScalarsBeforeMapping(self, val:int) -> None\nC++: virtual void SetInterpolateScalarsBeforeMapping(int val)\n\n"},
  {"SetLookupTable", PyvtkGeometryRepresentation_SetLookupTable, METH_VARARGS,
   "SetLookupTable(self, val:vtkScalarsToColors) -> None\nC++: virtual void SetLookupTable(vtkScalarsToColors *val)\n\n"},
  {"SetColorMissingArraysWithNanColor", PyvtkGeometryRepresentation_SetColorMissingArraysWithNanColor, METH_VARARGS,
   "SetColorMissingArraysWithNanColor(self, val:bool) -> None\nC++: virtual void SetColorMissingArraysWithNanColor(bool val)\n\n"},
  {"SetSeamlessU", PyvtkGeometryRepresentation_SetSeamlessU, METH_VARARGS,
   "SetSeamlessU(self, __a:bool) -> None\nC++: virtual void SetSeamlessU(bool)\n\n"},
  {"SetSeamlessV", PyvtkGeometryRepresentation_SetSeamlessV, METH_VARARGS,
   "SetSeamlessV(self, __a:bool) -> None\nC++: virtual void SetSeamlessV(bool)\n\n"},
  {"SetMapScalars", PyvtkGeometryRepresentation_SetMapScalars, METH_VARARGS,
   "SetMapScalars(self, val:int) -> None\nC++: virtual void SetMapScalars(int val)\n\nSets if scalars are mapped through a color-map or are used\ndirectly as colors. 0 maps to VTK_COLOR_MODE_DIRECT_SCALARS 1\nmaps to VTK_COLOR_MODE_MAP_SCALARS@see\nvtkScalarsToColors::MapScalars\n"},
  {"SetStatic", PyvtkGeometryRepresentation_SetStatic, METH_VARARGS,
   "SetStatic(self, val:int) -> None\nC++: virtual void SetStatic(int val)\n\n"},
  {"SetSelection", PyvtkGeometryRepresentation_SetSelection, METH_VARARGS,
   "SetSelection(self, selection:vtkSelection) -> None\nC++: virtual void SetSelection(vtkSelection *selection)\n\nSets the selection used by the mapper.\n"},
  {"GetActor", PyvtkGeometryRepresentation_GetActor, METH_VARARGS,
   "GetActor(self) -> vtkPVLODActor\nC++: vtkPVLODActor *GetActor()\n\nProvides access to the actor used by this representation.\n"},
  {"SetActiveAssembly", PyvtkGeometryRepresentation_SetActiveAssembly, METH_VARARGS,
   "SetActiveAssembly(self, _arg:str) -> None\nC++: virtual void SetActiveAssembly(const char *_arg)\n\nGet/Set the name of the assembly to use for mapping block\nvisibilities, colors and opacities.\n\nThe default is Hierarchy.\n"},
  {"GetActiveAssembly", PyvtkGeometryRepresentation_GetActiveAssembly, METH_VARARGS,
   "GetActiveAssembly(self) -> str\nC++: virtual char *GetActiveAssembly()\n\n"},
  {"AddBlockSelector", PyvtkGeometryRepresentation_AddBlockSelector, METH_VARARGS,
   "AddBlockSelector(self, selector:str) -> None\nC++: void AddBlockSelector(const char *selector)\n\nUpdate list of selectors that determine the selected blocks.\n"},
  {"RemoveAllBlockSelectors", PyvtkGeometryRepresentation_RemoveAllBlockSelectors, METH_VARARGS,
   "RemoveAllBlockSelectors(self) -> None\nC++: void RemoveAllBlockSelectors()\n\n"},
  {"SetBlockColor", PyvtkGeometryRepresentation_SetBlockColor, METH_VARARGS,
   "SetBlockColor(self, selector:str, r:float, g:float, b:float)\n    -> None\nC++: void SetBlockColor(const char *selector, double r, double g,\n    double b)\n\nSet the color for a single block.\n"},
  {"RemoveAllBlockColors", PyvtkGeometryRepresentation_RemoveAllBlockColors, METH_VARARGS,
   "RemoveAllBlockColors(self) -> None\nC++: void RemoveAllBlockColors()\n\n"},
  {"SetBlockOpacity", PyvtkGeometryRepresentation_SetBlockOpacity, METH_VARARGS,
   "SetBlockOpacity(self, selector:str, opacity:float) -> None\nC++: void SetBlockOpacity(const char *selector, double opacity)\n\nSet the opacity for a single block.\n"},
  {"RemoveAllBlockOpacities", PyvtkGeometryRepresentation_RemoveAllBlockOpacities, METH_VARARGS,
   "RemoveAllBlockOpacities(self) -> None\nC++: void RemoveAllBlockOpacities()\n\n"},
  {"SetBlockInterpolateScalarsBeforeMapping", PyvtkGeometryRepresentation_SetBlockInterpolateScalarsBeforeMapping, METH_VARARGS,
   "SetBlockInterpolateScalarsBeforeMapping(self, selector:str,\n    interpolate:bool) -> None\nC++: void SetBlockInterpolateScalarsBeforeMapping(\n    const char *selector, bool interpolate)\n\nSet if to interpolate scalars before mapping for a single block.\n"},
  {"RemoveAllBlockInterpolateScalarsBeforeMappings", PyvtkGeometryRepresentation_RemoveAllBlockInterpolateScalarsBeforeMappings, METH_VARARGS,
   "RemoveAllBlockInterpolateScalarsBeforeMappings(self) -> None\nC++: void RemoveAllBlockInterpolateScalarsBeforeMappings()\n\n"},
  {"SetBlockMapScalars", PyvtkGeometryRepresentation_SetBlockMapScalars, METH_VARARGS,
   "SetBlockMapScalars(self, selector:str, val:int) -> None\nC++: void SetBlockMapScalars(const char *selector, int val)\n\nSet the block to map scalars for a single block.\n\nNote: Similar to SetMapScalars, but for blocks.\n"},
  {"RemoveAllBlockMapScalars", PyvtkGeometryRepresentation_RemoveAllBlockMapScalars, METH_VARARGS,
   "RemoveAllBlockMapScalars(self) -> None\nC++: void RemoveAllBlockMapScalars()\n\n"},
  {"SetBlockArrayName", PyvtkGeometryRepresentation_SetBlockArrayName, METH_VARARGS,
   "SetBlockArrayName(self, selector:str, assoc:int, arrayName:str)\n    -> None\nC++: void SetBlockArrayName(const char *selector, int assoc,\n    const char *arrayName)\n\nSet the color array for a single block.\n"},
  {"RemoveAllBlockArrayNames", PyvtkGeometryRepresentation_RemoveAllBlockArrayNames, METH_VARARGS,
   "RemoveAllBlockArrayNames(self) -> None\nC++: void RemoveAllBlockArrayNames()\n\n"},
  {"SetBlockLookupTable", PyvtkGeometryRepresentation_SetBlockLookupTable, METH_VARARGS,
   "SetBlockLookupTable(self, lut:vtkScalarsToColors) -> None\nC++: void SetBlockLookupTable(vtkScalarsToColors *lut)\n\nSet the look up table for a single block.\n\nNote: we need two methods because we can't wrap a string and a\nvtkObject using either vtkSMStringVectorProperty or\nvtkSMProxyProperty.\n"},
  {"RemoveAllBlockLookupTables", PyvtkGeometryRepresentation_RemoveAllBlockLookupTables, METH_VARARGS,
   "RemoveAllBlockLookupTables(self) -> None\nC++: void RemoveAllBlockLookupTables()\n\n"},
  {"GetColorArrayName", PyvtkGeometryRepresentation_GetColorArrayName, METH_VARARGS,
   "GetColorArrayName(self) -> str\nC++: const char *GetColorArrayName()\n\nConvenience method to get the array name used to scalar color\nwith.\n"},
  {"GetBounds", PyvtkGeometryRepresentation_GetBounds, METH_VARARGS,
   "GetBounds(dataObject:vtkDataObject, bounds:[float, float, float,\n    float, float, float],\n    cdAttributes:vtkCompositeDataDisplayAttributes) -> bool\nC++: static bool GetBounds(vtkDataObject *dataObject,\n    double bounds[6],\n    vtkCompositeDataDisplayAttributes *cdAttributes)\n\nConvenience method to get bounds from a dataset/composite\ndataset. If a vtkCompositeDataDisplayAttributes cdAttributes is\nprovided and if the input data dataObject is vtkCompositeDataSet,\nonly visible blocks of the data will be used to compute the\nbounds. Returns true if valid bounds were computed.\n"},
  {"SetEnableScaling", PyvtkGeometryRepresentation_SetEnableScaling, METH_VARARGS,
   "SetEnableScaling(self, v:int) -> None\nC++: virtual void SetEnableScaling(int v)\n\nFor OSPRay controls sizing of implicit spheres (points) and\ncylinders (lines)\n"},
  {"SetScalingArrayName", PyvtkGeometryRepresentation_SetScalingArrayName, METH_VARARGS,
   "SetScalingArrayName(self, __a:str) -> None\nC++: virtual void SetScalingArrayName(const char *)\n\n"},
  {"SetScalingFunction", PyvtkGeometryRepresentation_SetScalingFunction, METH_VARARGS,
   "SetScalingFunction(self, pwf:vtkPiecewiseFunction) -> None\nC++: virtual void SetScalingFunction(vtkPiecewiseFunction *pwf)\n\n"},
  {"SetMaterial", PyvtkGeometryRepresentation_SetMaterial, METH_VARARGS,
   "SetMaterial(self, __a:str) -> None\nC++: virtual void SetMaterial(const char *)\n\nFor OSPRay, choose from among available materials.\n"},
  {"SetUseDataPartitions", PyvtkGeometryRepresentation_SetUseDataPartitions, METH_VARARGS,
   "SetUseDataPartitions(self, _arg:bool) -> None\nC++: virtual void SetUseDataPartitions(bool _arg)\n\nSpecify whether or not to redistribute the data. The default is\nfalse since that is the only way in general to guarantee correct\nrendering. Can set to true if all rendered data sets are based on\nthe same data partitioning in order to save on the data\nredistribution.\n"},
  {"GetUseDataPartitions", PyvtkGeometryRepresentation_GetUseDataPartitions, METH_VARARGS,
   "GetUseDataPartitions(self) -> bool\nC++: virtual bool GetUseDataPartitions()\n\n"},
  {"SetUseShaderReplacements", PyvtkGeometryRepresentation_SetUseShaderReplacements, METH_VARARGS,
   "SetUseShaderReplacements(self, __a:bool) -> None\nC++: virtual void SetUseShaderReplacements(bool)\n\nSpecify whether or not to shader replacements string must be\nused.\n"},
  {"GetUseShaderReplacements", PyvtkGeometryRepresentation_GetUseShaderReplacements, METH_VARARGS,
   "GetUseShaderReplacements(self) -> bool\nC++: virtual bool GetUseShaderReplacements()\n\n"},
  {"SetShaderReplacements", PyvtkGeometryRepresentation_SetShaderReplacements, METH_VARARGS,
   "SetShaderReplacements(self, __a:str) -> None\nC++: virtual void SetShaderReplacements(const char *)\n\nSpecify shader replacements using a Json string. Please refer to\nthe XML definition of the property for details about the expected\nJson string format.\n"},
  {"SetArrayIdNames", PyvtkGeometryRepresentation_SetArrayIdNames, METH_VARARGS,
   "SetArrayIdNames(self, pointArray:str, cellArray:str) -> None\nC++: void SetArrayIdNames(const char *pointArray,\n    const char *cellArray) override;\n\nSpecify the array names used for the selection. Use nullptr to\nuse default ones. (\"vtkOriginalPointIds\" and\n\"vtkOriginalCellIds\")\n"},
  {"SetPlaceHolderDataType", PyvtkGeometryRepresentation_SetPlaceHolderDataType, METH_VARARGS,
   "SetPlaceHolderDataType(self, datatype:int) -> None\nC++: void SetPlaceHolderDataType(int datatype)\n\nSet/Get the placeholder data type.\n\nThis value is set by the proxy and is needed to ensure that the\nclient knows the type of the input that lives on the server.\n\nIn the past, we were always creating a placeholder of type\nvtkMultiBlockDataSet when no input was available on the client.\nThis is no longer valid because vtkPVGeometryFilter can now\ngenerate also vtkPartitionedDataSetCollection.\n\nThis can be potentially removed in the future once\nvtkMultiBlockDataSet is deprecated.\n"},
  {"GetPlaceHolderDataType", PyvtkGeometryRepresentation_GetPlaceHolderDataType, METH_VARARGS,
   "GetPlaceHolderDataType(self) -> int\nC++: virtual int GetPlaceHolderDataType()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGeometryRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("block_colors_distinct_values"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetBlockColorsDistinctValues(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetBlockColorsDistinctValues(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetBlockColorsDistinctValues(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBlockColorsDistinctValues/SetBlockColorsDistinctValues\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("suppress_lod"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetSuppressLOD(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetSuppressLOD(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSuppressLOD\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("disable_lighting"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetDisableLighting(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetDisableLighting(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetDisableLighting(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisableLighting/SetDisableLighting\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ambient"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetAmbient(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetAmbient(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetAmbient(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAmbient/SetAmbient\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("diffuse"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetDiffuse(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetDiffuse(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetDiffuse(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDiffuse/SetDiffuse\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("specular"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetSpecular(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetSpecular(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetSpecular(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSpecular/SetSpecular\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coordinate_shift_scale_method"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetCoordinateShiftScaleMethod(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetCoordinateShiftScaleMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetCoordinateShiftScaleMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCoordinateShiftScaleMethod/SetCoordinateShiftScaleMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("representation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetRepresentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetRepresentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetRepresentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRepresentation/SetRepresentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("representation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetRepresentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetRepresentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRepresentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("request_ghost_cells_if_needed"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetRequestGhostCellsIfNeeded(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetRequestGhostCellsIfNeeded(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetRequestGhostCellsIfNeeded(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRequestGhostCellsIfNeeded/SetRequestGhostCellsIfNeeded\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("normal_array"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetNormalArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetNormalArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNormalArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("t_coord_array"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetTCoordArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetTCoordArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTCoordArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tangent_array"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetTangentArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetTangentArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTangentArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_outline"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetUseOutline(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetUseOutline(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseOutline\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("triangulate"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetTriangulate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetTriangulate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTriangulate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("nonlinear_subdivision_level"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetNonlinearSubdivisionLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetNonlinearSubdivisionLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNonlinearSubdivisionLevel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("match_boundaries_ignoring_cell_order"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetMatchBoundariesIgnoringCellOrder(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetMatchBoundariesIgnoringCellOrder(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMatchBoundariesIgnoringCellOrder\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_feature_edges"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetGenerateFeatureEdges(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetGenerateFeatureEdges(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGenerateFeatureEdges\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_point_normals"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetComputePointNormals(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetComputePointNormals(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetComputePointNormals\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("splitting"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetSplitting(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetSplitting(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSplitting\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("feature_angle"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetFeatureAngle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetFeatureAngle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFeatureAngle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ambient_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetAmbientColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetAmbientColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAmbientColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("diffuse_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetDiffuseColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetDiffuseColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDiffuseColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lighting"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetLighting(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetLighting(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLighting\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetEdgeColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetEdgeColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEdgeColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactive_selection_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetInteractiveSelectionColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetInteractiveSelectionColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInteractiveSelectionColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interpolation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetInterpolation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetInterpolation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInterpolation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("line_width"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetLineWidth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetLineWidth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLineWidth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("opacity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetOpacity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetOpacity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOpacity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_opacity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetEdgeOpacity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetEdgeOpacity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEdgeOpacity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetPointSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetPointSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("specular_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetSpecularColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetSpecularColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSpecularColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("specular_power"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetSpecularPower(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetSpecularPower(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSpecularPower\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("luminosity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetLuminosity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetLuminosity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLuminosity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_points_as_spheres"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetRenderPointsAsSpheres(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetRenderPointsAsSpheres(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRenderPointsAsSpheres\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_lines_as_tubes"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetRenderLinesAsTubes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetRenderLinesAsTubes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRenderLinesAsTubes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("roughness"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetRoughness(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetRoughness(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRoughness\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("metallic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetMetallic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetMetallic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMetallic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_tint"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetEdgeTint(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetEdgeTint(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEdgeTint\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("anisotropy"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetAnisotropy(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetAnisotropy(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAnisotropy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("anisotropy_rotation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetAnisotropyRotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetAnisotropyRotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAnisotropyRotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("base_ior"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetBaseIOR(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetBaseIOR(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBaseIOR\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coat_ior"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetCoatIOR(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetCoatIOR(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCoatIOR\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coat_strength"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetCoatStrength(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetCoatStrength(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCoatStrength\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coat_roughness"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetCoatRoughness(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetCoatRoughness(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCoatRoughness\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coat_normal_scale"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetCoatNormalScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetCoatNormalScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCoatNormalScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coat_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetCoatColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetCoatColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCoatColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("base_color_texture"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetBaseColorTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetBaseColorTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBaseColorTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("material_texture"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetMaterialTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetMaterialTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaterialTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("anisotropy_texture"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetAnisotropyTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetAnisotropyTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAnisotropyTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("normal_texture"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetNormalTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetNormalTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNormalTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coat_normal_texture"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetCoatNormalTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetCoatNormalTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCoatNormalTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("emissive_texture"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetEmissiveTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetEmissiveTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEmissiveTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("normal_scale"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetNormalScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetNormalScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNormalScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("occlusion_strength"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetOcclusionStrength(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetOcclusionStrength(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOcclusionStrength\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("emissive_factor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetEmissiveFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetEmissiveFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEmissiveFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("show_textures_on_backface"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetShowTexturesOnBackface(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetShowTexturesOnBackface(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetShowTexturesOnBackface\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetOrientation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetOrientation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("origin"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetOrigin(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetOrigin(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrigin\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pickable"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetPickable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetPickable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPickable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("position"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scale"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("texture"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("user_transform"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetUserTransform(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetUserTransform(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUserTransform\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("flip_textures"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetFlipTextures(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetFlipTextures(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFlipTextures\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coordinate_system"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetCoordinateSystem(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetCoordinateSystem(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCoordinateSystem\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("texture_transform"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetTextureTransform(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetTextureTransform(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetTextureTransform(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTextureTransform/SetTextureTransform\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("repeat_textures"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetRepeatTextures(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetRepeatTextures(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetRepeatTextures(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRepeatTextures/SetRepeatTextures\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interpolate_textures"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetInterpolateTextures(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetInterpolateTextures(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetInterpolateTextures(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInterpolateTextures/SetInterpolateTextures\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_mipmap_textures"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetUseMipmapTextures(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetUseMipmapTextures(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetUseMipmapTextures(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseMipmapTextures/SetUseMipmapTextures\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interpolate_scalars_before_mapping"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetInterpolateScalarsBeforeMapping(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetInterpolateScalarsBeforeMapping(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInterpolateScalarsBeforeMapping\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lookup_table"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetLookupTable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetLookupTable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLookupTable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("color_missing_arrays_with_nan_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetColorMissingArraysWithNanColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetColorMissingArraysWithNanColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetColorMissingArraysWithNanColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("seamless_u"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetSeamlessU(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetSeamlessU(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSeamlessU\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("seamless_v"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetSeamlessV(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetSeamlessV(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSeamlessV\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("map_scalars"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetMapScalars(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetMapScalars(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMapScalars\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("static"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetStatic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetStatic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetStatic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("selection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetSelection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetSelection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_assembly"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetActiveAssembly(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetActiveAssembly(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetActiveAssembly(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetActiveAssembly/SetActiveAssembly\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("block_lookup_table"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetBlockLookupTable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetBlockLookupTable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBlockLookupTable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_scaling"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetEnableScaling(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetEnableScaling(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnableScaling\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scaling_array_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetScalingArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetScalingArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScalingArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scaling_function"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetScalingFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetScalingFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScalingFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("material"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetMaterial(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetMaterial(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaterial\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_data_partitions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetUseDataPartitions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetUseDataPartitions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetUseDataPartitions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseDataPartitions/SetUseDataPartitions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_shader_replacements"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetUseShaderReplacements(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetUseShaderReplacements(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetUseShaderReplacements(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseShaderReplacements/SetUseShaderReplacements\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("shader_replacements"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetShaderReplacements(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetShaderReplacements(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetShaderReplacements\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("place_holder_data_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetPlaceHolderDataType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeometryRepresentation_SetPlaceHolderDataType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeometryRepresentation_SetPlaceHolderDataType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPlaceHolderDataType/SetPlaceHolderDataType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("actor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetActor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("color_array_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeometryRepresentation_GetColorArrayName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetColorArrayName\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGeometryRepresentation_Doc =
  "vtkGeometryRepresentation - representation for showing any datasets\nas external shell of polygons.\n\n"
  "Superclass: vtkPVDataRepresentation\n\n"
  "vtkGeometryRepresentation is a representation for showing polygon\n"
  "geometry. It handles non-polygonal datasets by extracting external\n"
  "surfaces. One can use this representation to show\n"
  "surface/wireframe/points/surface-with-edges.@par Thanks: The addition\n"
  "of a transformation matrix was supported by CEA/DIF Commissariat a\n"
  "l'Energie Atomique, Centre DAM Ile-De-France, Arpajon, France.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGeometryRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkGeometryRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGeometryRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkGeometryRepresentation_StaticNew()
{
  return vtkGeometryRepresentation::New();
}

PyObject *PyvtkGeometryRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGeometryRepresentation_Type, PyvtkGeometryRepresentation_Methods,
    "vtkGeometryRepresentation",
 &PyvtkGeometryRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVDataRepresentation_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkGeometryRepresentation_RepresentationTypes_Type);
  PyVTKEnum_Add(&PyvtkGeometryRepresentation_RepresentationTypes_Type, "vtkGeometryRepresentation.RepresentationTypes");

  o = (PyObject *)&PyvtkGeometryRepresentation_RepresentationTypes_Type;
  if (PyDict_SetItemString(d, "RepresentationTypes", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 4; c++)
  {
    typedef vtkGeometryRepresentation::RepresentationTypes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[4] = {
        { "POINTS", vtkGeometryRepresentation::POINTS },
        { "WIREFRAME", vtkGeometryRepresentation::WIREFRAME },
        { "SURFACE", vtkGeometryRepresentation::SURFACE },
        { "SURFACE_WITH_EDGES", vtkGeometryRepresentation::SURFACE_WITH_EDGES },
      };

    o = PyvtkGeometryRepresentation_RepresentationTypes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGeometryRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkGeometryRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkGeometryRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkGeometryRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

