// python wrapper for vtkSelectArraysExtractBlocks
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSelectArraysExtractBlocks.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSelectArraysExtractBlocks(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSelectArraysExtractBlocks_ClassNew(); }


static PyObject *
PyvtkSelectArraysExtractBlocks_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSelectArraysExtractBlocks::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSelectArraysExtractBlocks::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSelectArraysExtractBlocks *tempr = vtkSelectArraysExtractBlocks::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSelectArraysExtractBlocks *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSelectArraysExtractBlocks::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSelectArraysExtractBlocks::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSelectArraysExtractBlocks::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_SetPassArraysEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPassArraysEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPassArraysEnabled(temp0);
    }
    else
    {
      op->vtkSelectArraysExtractBlocks::SetPassArraysEnabled(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetPassArraysEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPassArraysEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPassArraysEnabled() :
      op->vtkSelectArraysExtractBlocks::GetPassArraysEnabled());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_PassArraysEnabledOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PassArraysEnabledOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PassArraysEnabledOn();
    }
    else
    {
      op->vtkSelectArraysExtractBlocks::PassArraysEnabledOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_PassArraysEnabledOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PassArraysEnabledOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PassArraysEnabledOff();
    }
    else
    {
      op->vtkSelectArraysExtractBlocks::PassArraysEnabledOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_SetExtractBlocksEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExtractBlocksEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExtractBlocksEnabled(temp0);
    }
    else
    {
      op->vtkSelectArraysExtractBlocks::SetExtractBlocksEnabled(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetExtractBlocksEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExtractBlocksEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExtractBlocksEnabled() :
      op->vtkSelectArraysExtractBlocks::GetExtractBlocksEnabled());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_ExtractBlocksEnabledOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExtractBlocksEnabledOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExtractBlocksEnabledOn();
    }
    else
    {
      op->vtkSelectArraysExtractBlocks::ExtractBlocksEnabledOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_ExtractBlocksEnabledOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExtractBlocksEnabledOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExtractBlocksEnabledOff();
    }
    else
    {
      op->vtkSelectArraysExtractBlocks::ExtractBlocksEnabledOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetPointDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetPointDataArraySelection() :
      op->vtkSelectArraysExtractBlocks::GetPointDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetCellDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetCellDataArraySelection() :
      op->vtkSelectArraysExtractBlocks::GetCellDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetFieldDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetFieldDataArraySelection() :
      op->vtkSelectArraysExtractBlocks::GetFieldDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetVertexDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVertexDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetVertexDataArraySelection() :
      op->vtkSelectArraysExtractBlocks::GetVertexDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetEdgeDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEdgeDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetEdgeDataArraySelection() :
      op->vtkSelectArraysExtractBlocks::GetEdgeDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetRowDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRowDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetRowDataArraySelection() :
      op->vtkSelectArraysExtractBlocks::GetRowDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_AddSelector(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddSelector");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->AddSelector(temp0) :
      op->vtkSelectArraysExtractBlocks::AddSelector(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_ClearSelectors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearSelectors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearSelectors();
    }
    else
    {
      op->vtkSelectArraysExtractBlocks::ClearSelectors();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_SetAssemblyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAssemblyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAssemblyName(temp0);
    }
    else
    {
      op->vtkSelectArraysExtractBlocks::SetAssemblyName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetAssemblyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAssemblyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetAssemblyName() :
      op->vtkSelectArraysExtractBlocks::GetAssemblyName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSelectArraysExtractBlocks_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSelectArraysExtractBlocks *op = static_cast<vtkSelectArraysExtractBlocks *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkSelectArraysExtractBlocks::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSelectArraysExtractBlocks_Methods[] = {
  {"IsTypeOf", PyvtkSelectArraysExtractBlocks_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSelectArraysExtractBlocks_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSelectArraysExtractBlocks_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSelectArraysExtractBlocks\nC++: static vtkSelectArraysExtractBlocks *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSelectArraysExtractBlocks_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSelectArraysExtractBlocks\nC++: vtkSelectArraysExtractBlocks *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSelectArraysExtractBlocks_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSelectArraysExtractBlocks_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetPassArraysEnabled", PyvtkSelectArraysExtractBlocks_SetPassArraysEnabled, METH_VARARGS,
   "SetPassArraysEnabled(self, _arg:bool) -> None\nC++: virtual void SetPassArraysEnabled(bool _arg)\n\nEnable/disable the internal vtkPassSelectedArrays filter. When\ndisabled, this filter passes all input arrays irrespective of the\narray selection. Default is `true`.\n"},
  {"GetPassArraysEnabled", PyvtkSelectArraysExtractBlocks_GetPassArraysEnabled, METH_VARARGS,
   "GetPassArraysEnabled(self) -> bool\nC++: virtual bool GetPassArraysEnabled()\n\n"},
  {"PassArraysEnabledOn", PyvtkSelectArraysExtractBlocks_PassArraysEnabledOn, METH_VARARGS,
   "PassArraysEnabledOn(self) -> None\nC++: virtual void PassArraysEnabledOn()\n\n"},
  {"PassArraysEnabledOff", PyvtkSelectArraysExtractBlocks_PassArraysEnabledOff, METH_VARARGS,
   "PassArraysEnabledOff(self) -> None\nC++: virtual void PassArraysEnabledOff()\n\n"},
  {"SetExtractBlocksEnabled", PyvtkSelectArraysExtractBlocks_SetExtractBlocksEnabled, METH_VARARGS,
   "SetExtractBlocksEnabled(self, _arg:bool) -> None\nC++: virtual void SetExtractBlocksEnabled(bool _arg)\n\nEnable/disable the internal vtkExtractBlockUsingDataAssembly\nfilter. When disabled, this filter passes all input blocks\nirrespective of the block selection. Default is `true`.\n"},
  {"GetExtractBlocksEnabled", PyvtkSelectArraysExtractBlocks_GetExtractBlocksEnabled, METH_VARARGS,
   "GetExtractBlocksEnabled(self) -> bool\nC++: virtual bool GetExtractBlocksEnabled()\n\n"},
  {"ExtractBlocksEnabledOn", PyvtkSelectArraysExtractBlocks_ExtractBlocksEnabledOn, METH_VARARGS,
   "ExtractBlocksEnabledOn(self) -> None\nC++: virtual void ExtractBlocksEnabledOn()\n\n"},
  {"ExtractBlocksEnabledOff", PyvtkSelectArraysExtractBlocks_ExtractBlocksEnabledOff, METH_VARARGS,
   "ExtractBlocksEnabledOff(self) -> None\nC++: virtual void ExtractBlocksEnabledOff()\n\n"},
  {"GetPointDataArraySelection", PyvtkSelectArraysExtractBlocks_GetPointDataArraySelection, METH_VARARGS,
   "GetPointDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetPointDataArraySelection()\n\nConvenience methods that call `GetArraySelection` with\ncorresponding association type.\n\nForwarded to internal vtkPassSelectedArrays filter.\n"},
  {"GetCellDataArraySelection", PyvtkSelectArraysExtractBlocks_GetCellDataArraySelection, METH_VARARGS,
   "GetCellDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetCellDataArraySelection()\n\n"},
  {"GetFieldDataArraySelection", PyvtkSelectArraysExtractBlocks_GetFieldDataArraySelection, METH_VARARGS,
   "GetFieldDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetFieldDataArraySelection()\n\n"},
  {"GetVertexDataArraySelection", PyvtkSelectArraysExtractBlocks_GetVertexDataArraySelection, METH_VARARGS,
   "GetVertexDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetVertexDataArraySelection()\n\n"},
  {"GetEdgeDataArraySelection", PyvtkSelectArraysExtractBlocks_GetEdgeDataArraySelection, METH_VARARGS,
   "GetEdgeDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetEdgeDataArraySelection()\n\n"},
  {"GetRowDataArraySelection", PyvtkSelectArraysExtractBlocks_GetRowDataArraySelection, METH_VARARGS,
   "GetRowDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetRowDataArraySelection()\n\n"},
  {"AddSelector", PyvtkSelectArraysExtractBlocks_AddSelector, METH_VARARGS,
   "AddSelector(self, selector:str) -> bool\nC++: bool AddSelector(const char *selector)\n\nAPI to set selectors. Multiple selectors can be added using\n`AddSelector`. The order in which selectors are specified is not\npreserved and has no impact on the result.\n\n`AddSelector` returns true if the selector was added, false if\nthe selector was already specified and hence not added.\n\nForwarded to internal vtkExtractBlockUsingDataAssembly filter.\n\n@sa vtkDataAssembly::SelectNodes\n"},
  {"ClearSelectors", PyvtkSelectArraysExtractBlocks_ClearSelectors, METH_VARARGS,
   "ClearSelectors(self) -> None\nC++: void ClearSelectors()\n\n"},
  {"SetAssemblyName", PyvtkSelectArraysExtractBlocks_SetAssemblyName, METH_VARARGS,
   "SetAssemblyName(self, assemblyName:str) -> None\nC++: void SetAssemblyName(const char *assemblyName)\n\nGet/Set the active assembly to use. The chosen assembly is used\nin combination with the selectors specified to determine which\nblocks are to be extracted.\n\nForwarded to internal vtkExtractBlockUsingDataAssembly filter.\n\nBy default, this is set to\nvtkDataAssemblyUtilities::HierarchyName().\n"},
  {"GetAssemblyName", PyvtkSelectArraysExtractBlocks_GetAssemblyName, METH_VARARGS,
   "GetAssemblyName(self) -> str\nC++: const char *GetAssemblyName()\n\n"},
  {"GetMTime", PyvtkSelectArraysExtractBlocks_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nOverride GetMTime because we rely on internal filters that have\ntheir own MTime\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSelectArraysExtractBlocks_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("pass_arrays_enabled"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSelectArraysExtractBlocks_GetPassArraysEnabled(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSelectArraysExtractBlocks_SetPassArraysEnabled(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSelectArraysExtractBlocks_SetPassArraysEnabled(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPassArraysEnabled/SetPassArraysEnabled\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("extract_blocks_enabled"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSelectArraysExtractBlocks_GetExtractBlocksEnabled(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSelectArraysExtractBlocks_SetExtractBlocksEnabled(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSelectArraysExtractBlocks_SetExtractBlocksEnabled(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExtractBlocksEnabled/SetExtractBlocksEnabled\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("assembly_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSelectArraysExtractBlocks_GetAssemblyName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSelectArraysExtractBlocks_SetAssemblyName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSelectArraysExtractBlocks_SetAssemblyName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAssemblyName/SetAssemblyName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSelectArraysExtractBlocks_GetPointDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPointDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSelectArraysExtractBlocks_GetCellDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCellDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSelectArraysExtractBlocks_GetFieldDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFieldDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("vertex_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSelectArraysExtractBlocks_GetVertexDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetVertexDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSelectArraysExtractBlocks_GetEdgeDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEdgeDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("row_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSelectArraysExtractBlocks_GetRowDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRowDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSelectArraysExtractBlocks_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSelectArraysExtractBlocks_Doc =
  "vtkSelectArraysExtractBlocks - Selects arrays and extracts blocks.\n\n"
  "Superclass: vtkCompositeDataSetAlgorithm\n\n"
  "vtkSelectArraysExtractBlocks is a meta-filter combining the\n"
  "vtkPassSelectedArrays and vtkExtractBlockUsingDataAssembly filters.\n"
  "It is intended to be used as a pre-processing filter for certain\n"
  "composite writers. It adds the possibility to choose the blocks to\n"
  "write, in addition to the data arrays.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSelectArraysExtractBlocks_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsExtraction.vtkSelectArraysExtractBlocks", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSelectArraysExtractBlocks_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSelectArraysExtractBlocks_StaticNew()
{
  return vtkSelectArraysExtractBlocks::New();
}

PyObject *PyvtkSelectArraysExtractBlocks_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSelectArraysExtractBlocks_Type, PyvtkSelectArraysExtractBlocks_Methods,
    "vtkSelectArraysExtractBlocks",
 &PyvtkSelectArraysExtractBlocks_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkCompositeDataSetAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSelectArraysExtractBlocks_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSelectArraysExtractBlocks(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSelectArraysExtractBlocks_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSelectArraysExtractBlocks", o) != 0)
  {
    Py_DECREF(o);
  }

}

