/*
 * $Id: identity.c,v 1.1 2001/03/15 22:16:13 jpormann Exp jpormann $
 *
 * procstatd - Copyright (c) 1999 by Robert G. Brown, rgb@phy.duke.edu
 *         GPL version 2b (b for beverage) granted.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * procstatd - A daemon to extract statistics from /proc/stat and publish them
 *         on demand via a socket connection or broadcast.
 */

#include "procstatd.h"

/*
 * Set hostname and IP number for the node at the init stage, ignore
 * get/eval attempts (but keep the stubs for symmetry).
 */

void init_identity()
{

 int i,numfields;

 /* IDENT */

 /* JBP: for some reason, a few of our machines return the name.ee.duke.edu */
 /*      so we'll cut that off now */
 i = 0;
 while( (i<BUFLEN) && (hostname[i]!='.') ) {
    i++;
 }
 if( hostname[i] == '.' ) {
    hostname[i] = 0;
 }
 /* JBP: removed equals-signs, used to be "ident=%s=%s" */
 sprintf(stats[IDENT].name,"ident %s %s",hostname,hostip);	/* Label it. */
 stats[IDENT].source = SYS_DATA;		/* Tag its source for xref */
 stats[IDENT].avail = 1;			/* Yes, we found it */
 stats[IDENT].current = 0;		/* current value (eth0) */

}  /* End init_identity() */

void get_identity()
{

  /* Dummy routine.  Identity never changes.  We hope. */

} /* End get_indentity() */

void eval_identity()
{

  /* Dummy routine.  Identity never changes.  We hope. */

} /* End eval_time() */
