// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A2__F222

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx)xyzw" };
#else
{ R"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊bf16@16_32_T_T_3_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1101)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x132c622du, 0x0258f0b7u, 471, 83 }, // 132c622d0258f0b7 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_16_16_True__CO__wave1_warp2_stg1--Arch_gfx1101
    { 0x24588e37u, 0x28f9c4fcu, 471, 16 }, // 24588e3728f9c4fc = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_16_16_True__CO__wave2_warp2_stg1--Arch_gfx1101
    { 0x2ef9ed6au, 0x139932cbu, 471, 33 }, // 2ef9ed6a139932cb = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_16_16_True__CO__wave3_warp2_stg1--Arch_gfx1101
    { 0x1e14e834u, 0x23dccb2du, 471, 50 }, // 1e14e83423dccb2d = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_16_16_True__CO__wave4_warp2_stg1--Arch_gfx1101
    { 0x2248fe8eu, 0xde9438c7u, 411, 83 }, // 2248fe8ede9438c7 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave1_warp2_stg1--Arch_gfx1101
    { 0x745b224eu, 0xd5439467u, 411, 202 }, // 745b224ed5439467 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave1_warp4_stg1--Arch_gfx1101
    { 0xe4d3001fu, 0x0b770903u, 411, 16 }, // e4d3001f0b770903 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave2_warp2_stg1--Arch_gfx1101
    { 0x19bbe4f6u, 0xf034543du, 411, 116 }, // 19bbe4f6f034543d = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave2_warp4_stg1--Arch_gfx1101
    { 0x32a8221eu, 0x5703fc5fu, 411, 167 }, // 32a8221e5703fc5f = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave3_warp4_stg1--Arch_gfx1101
    { 0xfdd98b43u, 0xa6507427u, 411, 133 }, // fdd98b43a6507427 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave4_warp4_stg1--Arch_gfx1101
    { 0x22adb978u, 0x01bcff59u, 426, 202 }, // 22adb97801bcff59 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_32_32_True__CO__wave1_warp4_stg1--Arch_gfx1101
    { 0x6b572f80u, 0x89723905u, 426, 116 }, // 6b572f8089723905 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_32_32_True__CO__wave2_warp4_stg1--Arch_gfx1101
    { 0xd9f00be0u, 0x77be0f52u, 426, 167 }, // d9f00be077be0f52 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_32_32_True__CO__wave3_warp4_stg1--Arch_gfx1101
    { 0xc3168477u, 0x0434c2d0u, 426, 133 }, // c31684770434c2d0 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_32_32_True__CO__wave4_warp4_stg1--Arch_gfx1101
    { 0x72811b77u, 0x98e09994u, 235, 202 }, // 72811b7798e09994 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_64_32_False__CO__wave1_warp4_stg1--Arch_gfx1101
    { 0x65d3bac5u, 0xe75e0353u, 235, 116 }, // 65d3bac5e75e0353 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_64_32_False__CO__wave2_warp4_stg1--Arch_gfx1101
    { 0x10a30e34u, 0x1334d57eu, 235, 167 }, // 10a30e341334d57e = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_64_32_False__CO__wave3_warp4_stg1--Arch_gfx1101
    { 0x2bfb5e05u, 0xa7f9cc10u, 441, 202 }, // 2bfb5e05a7f9cc10 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_64_32_True__CO__wave1_warp4_stg1--Arch_gfx1101
    { 0x0b70d6e2u, 0x70939939u, 441, 116 }, // 0b70d6e270939939 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_64_32_True__CO__wave2_warp4_stg1--Arch_gfx1101
    { 0xde1f26d3u, 0xead09b0eu, 441, 167 }, // de1f26d3ead09b0e = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊bf16@16_32_T_T_3_0___gfx11xx__P__2_2_64_32_True__CO__wave3_warp4_stg1--Arch_gfx1101
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1101_mod0
{{ 7, 1, 3, 0, 2, 0, 2, 3, 0, 3},
 { 7,12,11,10,13,12,11,12,10,10},
 { 8,11,12,12,13,12,13,12,11,10},
 { 8,12,13,12,11,13,12,11,11,10},
 { 9,10,10,12,10,11,10,10,11,11},
 { 5,11,19,17,17,10,10,11,11,11},
 { 5,17,17,19,19,17,17,17,17,10},
 { 6,18,19,18,17,17,19,15,14,14},
 { 4,18,17,17,17,19,19,14,17,15},
 { 6,18,17,18,17,19,16,17,17,17}}
// End of GPU gfx1101_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A2__F222 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 11;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 11;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*bf16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 32
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 3
// Window_left = "i32"
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = "*i32"
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1100_mod0') AND inputs$Q_dtype = 'torch.bfloat16' AND inputs$BLOCK_DMODEL = 32 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = True AND inputs$CAUSAL_TYPE = 3 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

