/*
 * Copyright (c) 2021 Miroslav Stampar (miroslav@sqlmap.org)
 * Copyright (c) 2014 CORE Security Technologies
 *
 * This software is provided under under the Apache Software License.
 * See the accompanying LICENSE file for more information.
 *
 */

#ifndef __PCAPY_H__

#ifndef Py_TYPE  // python3 compatible
    #define Py_TYPE(ob) (((PyObject*)(ob))->ob_type)
#endif

extern "C" {
#ifdef WIN32
__declspec(dllexport)
char *get_windows_interface_friendly_name(const char *interface_devicename);
static char* luid_to_guid(char *luid);
#endif

#if PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC PyInit_pcapy(void);
#else
void initpcapy(void);
#endif
}

// exception object
extern PyObject* PcapError;

#endif // __PCAPY_H__
