/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace X86 {
enum {
  FeatureADX = 0,
  FeatureAES = 1,
  FeatureAMXAVX512 = 2,
  FeatureAMXBF16 = 3,
  FeatureAMXCOMPLEX = 4,
  FeatureAMXFP8 = 5,
  FeatureAMXFP16 = 6,
  FeatureAMXINT8 = 7,
  FeatureAMXMOVRS = 8,
  FeatureAMXTF32 = 9,
  FeatureAMXTILE = 10,
  FeatureAMXTRANSPOSE = 11,
  FeatureAVX = 12,
  FeatureAVX2 = 13,
  FeatureAVX10_1 = 14,
  FeatureAVX10_1_512 = 15,
  FeatureAVX10_2 = 16,
  FeatureAVX10_2_512 = 17,
  FeatureAVX512 = 18,
  FeatureAVXIFMA = 19,
  FeatureAVXNECONVERT = 20,
  FeatureAVXVNNI = 21,
  FeatureAVXVNNIINT8 = 22,
  FeatureAVXVNNIINT16 = 23,
  FeatureBF16 = 24,
  FeatureBITALG = 25,
  FeatureBMI = 26,
  FeatureBMI2 = 27,
  FeatureBWI = 28,
  FeatureCCMP = 29,
  FeatureCDI = 30,
  FeatureCF = 31,
  FeatureCLDEMOTE = 32,
  FeatureCLFLUSHOPT = 33,
  FeatureCLWB = 34,
  FeatureCLZERO = 35,
  FeatureCMOV = 36,
  FeatureCMPCCXADD = 37,
  FeatureCRC32 = 38,
  FeatureCX8 = 39,
  FeatureCX16 = 40,
  FeatureDQI = 41,
  FeatureEGPR = 42,
  FeatureENQCMD = 43,
  FeatureERMSB = 44,
  FeatureEVEX512 = 45,
  FeatureF16C = 46,
  FeatureFMA = 47,
  FeatureFMA4 = 48,
  FeatureFP16 = 49,
  FeatureFSGSBase = 50,
  FeatureFSRM = 51,
  FeatureFXSR = 52,
  FeatureGFNI = 53,
  FeatureHRESET = 54,
  FeatureHardenSlsIJmp = 55,
  FeatureHardenSlsRet = 56,
  FeatureIFMA = 57,
  FeatureINVPCID = 58,
  FeatureKL = 59,
  FeatureLAHFSAHF64 = 60,
  FeatureLVIControlFlowIntegrity = 61,
  FeatureLVILoadHardening = 62,
  FeatureLWP = 63,
  FeatureLZCNT = 64,
  FeatureMMX = 65,
  FeatureMOVBE = 66,
  FeatureMOVDIR64B = 67,
  FeatureMOVDIRI = 68,
  FeatureMOVRS = 69,
  FeatureMWAITX = 70,
  FeatureNDD = 71,
  FeatureNF = 72,
  FeatureNOPL = 73,
  FeaturePCLMUL = 74,
  FeaturePCONFIG = 75,
  FeaturePKU = 76,
  FeaturePOPCNT = 77,
  FeaturePPX = 78,
  FeaturePREFETCHI = 79,
  FeaturePRFCHW = 80,
  FeaturePTWRITE = 81,
  FeaturePush2Pop2 = 82,
  FeatureRAOINT = 83,
  FeatureRDPID = 84,
  FeatureRDPRU = 85,
  FeatureRDRAND = 86,
  FeatureRDSEED = 87,
  FeatureRTM = 88,
  FeatureRetpoline = 89,
  FeatureRetpolineExternalThunk = 90,
  FeatureRetpolineIndirectBranches = 91,
  FeatureRetpolineIndirectCalls = 92,
  FeatureSERIALIZE = 93,
  FeatureSGX = 94,
  FeatureSHA = 95,
  FeatureSHA512 = 96,
  FeatureSHSTK = 97,
  FeatureSM3 = 98,
  FeatureSM4 = 99,
  FeatureSSE1 = 100,
  FeatureSSE2 = 101,
  FeatureSSE3 = 102,
  FeatureSSE4A = 103,
  FeatureSSE41 = 104,
  FeatureSSE42 = 105,
  FeatureSSEUnalignedMem = 106,
  FeatureSSSE3 = 107,
  FeatureSoftFloat = 108,
  FeatureSpeculativeExecutionSideEffectSuppression = 109,
  FeatureTBM = 110,
  FeatureTSXLDTRK = 111,
  FeatureTaggedGlobals = 112,
  FeatureUINTR = 113,
  FeatureUSERMSR = 114,
  FeatureUseGPR32InInlineAsm = 115,
  FeatureVAES = 116,
  FeatureVBMI = 117,
  FeatureVBMI2 = 118,
  FeatureVLX = 119,
  FeatureVNNI = 120,
  FeatureVP2INTERSECT = 121,
  FeatureVPCLMULQDQ = 122,
  FeatureVPOPCNTDQ = 123,
  FeatureWAITPKG = 124,
  FeatureWBNOINVD = 125,
  FeatureWIDEKL = 126,
  FeatureX86_64 = 127,
  FeatureX87 = 128,
  FeatureXOP = 129,
  FeatureXSAVE = 130,
  FeatureXSAVEC = 131,
  FeatureXSAVEOPT = 132,
  FeatureXSAVES = 133,
  FeatureZU = 134,
  Is16Bit = 135,
  Is32Bit = 136,
  Is64Bit = 137,
  ProcIntelAtom = 138,
  TuningAllowLight256Bit = 139,
  TuningBranchFusion = 140,
  TuningBranchHint = 141,
  TuningFast7ByteNOP = 142,
  TuningFast11ByteNOP = 143,
  TuningFast15ByteNOP = 144,
  TuningFastBEXTR = 145,
  TuningFastDPWSSD = 146,
  TuningFastGather = 147,
  TuningFastHorizontalOps = 148,
  TuningFastImm16 = 149,
  TuningFastImmVectorShift = 150,
  TuningFastLZCNT = 151,
  TuningFastMOVBE = 152,
  TuningFastSHLDRotate = 153,
  TuningFastScalarFSQRT = 154,
  TuningFastScalarShiftMasks = 155,
  TuningFastVariableCrossLaneShuffle = 156,
  TuningFastVariablePerLaneShuffle = 157,
  TuningFastVectorFSQRT = 158,
  TuningFastVectorShiftMasks = 159,
  TuningGETMANTFalseDeps = 160,
  TuningInsertVZEROUPPER = 161,
  TuningLEAForSP = 162,
  TuningLEAUsesAG = 163,
  TuningLZCNTFalseDeps = 164,
  TuningMULCFalseDeps = 165,
  TuningMULLQFalseDeps = 166,
  TuningMacroFusion = 167,
  TuningNoDomainDelay = 168,
  TuningNoDomainDelayBlend = 169,
  TuningNoDomainDelayMov = 170,
  TuningNoDomainDelayShuffle = 171,
  TuningPERMFalseDeps = 172,
  TuningPOPCNTFalseDeps = 173,
  TuningPadShortFunctions = 174,
  TuningPrefer128Bit = 175,
  TuningPrefer256Bit = 176,
  TuningPreferMaskRegisters = 177,
  TuningPreferMovmskOverVTest = 178,
  TuningPreferNoGather = 179,
  TuningPreferNoScatter = 180,
  TuningPreferShiftShuffle = 181,
  TuningRANGEFalseDeps = 182,
  TuningSBBDepBreaking = 183,
  TuningSlow3OpsLEA = 184,
  TuningSlowDivide32 = 185,
  TuningSlowDivide64 = 186,
  TuningSlowIncDec = 187,
  TuningSlowLEA = 188,
  TuningSlowPMADDWD = 189,
  TuningSlowPMULLD = 190,
  TuningSlowSHLD = 191,
  TuningSlowTwoMemOps = 192,
  TuningSlowUAMem16 = 193,
  TuningSlowUAMem32 = 194,
  TuningUseGLMDivSqrtCosts = 195,
  TuningUseSLMArithCosts = 196,
  NumSubtargetFeatures = 197
};
} // end namespace X86
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MACRO
GET_SUBTARGETINFO_MACRO(AllowLight256Bit, false, allowLight256Bit)
GET_SUBTARGETINFO_MACRO(AllowTaggedGlobals, false, allowTaggedGlobals)
GET_SUBTARGETINFO_MACRO(DeprecatedUseRetpoline, false, deprecatedUseRetpoline)
GET_SUBTARGETINFO_MACRO(FastImmVectorShift, false, fastImmVectorShift)
GET_SUBTARGETINFO_MACRO(HardenSlsIJmp, false, hardenSlsIJmp)
GET_SUBTARGETINFO_MACRO(HardenSlsRet, false, hardenSlsRet)
GET_SUBTARGETINFO_MACRO(HasADX, false, hasADX)
GET_SUBTARGETINFO_MACRO(HasAES, false, hasAES)
GET_SUBTARGETINFO_MACRO(HasAMXAVX512, false, hasAMXAVX512)
GET_SUBTARGETINFO_MACRO(HasAMXBF16, false, hasAMXBF16)
GET_SUBTARGETINFO_MACRO(HasAMXCOMPLEX, false, hasAMXCOMPLEX)
GET_SUBTARGETINFO_MACRO(HasAMXFP16, false, hasAMXFP16)
GET_SUBTARGETINFO_MACRO(HasAMXFP8, false, hasAMXFP8)
GET_SUBTARGETINFO_MACRO(HasAMXINT8, false, hasAMXINT8)
GET_SUBTARGETINFO_MACRO(HasAMXMOVRS, false, hasAMXMOVRS)
GET_SUBTARGETINFO_MACRO(HasAMXTF32, false, hasAMXTF32)
GET_SUBTARGETINFO_MACRO(HasAMXTILE, false, hasAMXTILE)
GET_SUBTARGETINFO_MACRO(HasAMXTRANSPOSE, false, hasAMXTRANSPOSE)
GET_SUBTARGETINFO_MACRO(HasAVX10_1, false, hasAVX10_1)
GET_SUBTARGETINFO_MACRO(HasAVX10_1_512, false, hasAVX10_1_512)
GET_SUBTARGETINFO_MACRO(HasAVX10_2, false, hasAVX10_2)
GET_SUBTARGETINFO_MACRO(HasAVX10_2_512, false, hasAVX10_2_512)
GET_SUBTARGETINFO_MACRO(HasAVXIFMA, false, hasAVXIFMA)
GET_SUBTARGETINFO_MACRO(HasAVXNECONVERT, false, hasAVXNECONVERT)
GET_SUBTARGETINFO_MACRO(HasAVXVNNI, false, hasAVXVNNI)
GET_SUBTARGETINFO_MACRO(HasAVXVNNIINT16, false, hasAVXVNNIINT16)
GET_SUBTARGETINFO_MACRO(HasAVXVNNIINT8, false, hasAVXVNNIINT8)
GET_SUBTARGETINFO_MACRO(HasBF16, false, hasBF16)
GET_SUBTARGETINFO_MACRO(HasBITALG, false, hasBITALG)
GET_SUBTARGETINFO_MACRO(HasBMI, false, hasBMI)
GET_SUBTARGETINFO_MACRO(HasBMI2, false, hasBMI2)
GET_SUBTARGETINFO_MACRO(HasBWI, false, hasBWI)
GET_SUBTARGETINFO_MACRO(HasBranchFusion, false, hasBranchFusion)
GET_SUBTARGETINFO_MACRO(HasBranchHint, false, hasBranchHint)
GET_SUBTARGETINFO_MACRO(HasCCMP, false, hasCCMP)
GET_SUBTARGETINFO_MACRO(HasCDI, false, hasCDI)
GET_SUBTARGETINFO_MACRO(HasCF, false, hasCF)
GET_SUBTARGETINFO_MACRO(HasCLDEMOTE, false, hasCLDEMOTE)
GET_SUBTARGETINFO_MACRO(HasCLFLUSHOPT, false, hasCLFLUSHOPT)
GET_SUBTARGETINFO_MACRO(HasCLWB, false, hasCLWB)
GET_SUBTARGETINFO_MACRO(HasCLZERO, false, hasCLZERO)
GET_SUBTARGETINFO_MACRO(HasCMOV, false, hasCMOV)
GET_SUBTARGETINFO_MACRO(HasCMPCCXADD, false, hasCMPCCXADD)
GET_SUBTARGETINFO_MACRO(HasCRC32, false, hasCRC32)
GET_SUBTARGETINFO_MACRO(HasCX16, false, hasCX16)
GET_SUBTARGETINFO_MACRO(HasCX8, false, hasCX8)
GET_SUBTARGETINFO_MACRO(HasDQI, false, hasDQI)
GET_SUBTARGETINFO_MACRO(HasEGPR, false, hasEGPR)
GET_SUBTARGETINFO_MACRO(HasENQCMD, false, hasENQCMD)
GET_SUBTARGETINFO_MACRO(HasERMSB, false, hasERMSB)
GET_SUBTARGETINFO_MACRO(HasEVEX512, false, hasEVEX512)
GET_SUBTARGETINFO_MACRO(HasF16C, false, hasF16C)
GET_SUBTARGETINFO_MACRO(HasFMA, false, hasFMA)
GET_SUBTARGETINFO_MACRO(HasFMA4, false, hasFMA4)
GET_SUBTARGETINFO_MACRO(HasFP16, false, hasFP16)
GET_SUBTARGETINFO_MACRO(HasFSGSBase, false, hasFSGSBase)
GET_SUBTARGETINFO_MACRO(HasFSRM, false, hasFSRM)
GET_SUBTARGETINFO_MACRO(HasFXSR, false, hasFXSR)
GET_SUBTARGETINFO_MACRO(HasFast11ByteNOP, false, hasFast11ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast15ByteNOP, false, hasFast15ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast7ByteNOP, false, hasFast7ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFastBEXTR, false, hasFastBEXTR)
GET_SUBTARGETINFO_MACRO(HasFastDPWSSD, false, hasFastDPWSSD)
GET_SUBTARGETINFO_MACRO(HasFastGather, false, hasFastGather)
GET_SUBTARGETINFO_MACRO(HasFastHorizontalOps, false, hasFastHorizontalOps)
GET_SUBTARGETINFO_MACRO(HasFastImm16, false, hasFastImm16)
GET_SUBTARGETINFO_MACRO(HasFastLZCNT, false, hasFastLZCNT)
GET_SUBTARGETINFO_MACRO(HasFastMOVBE, false, hasFastMOVBE)
GET_SUBTARGETINFO_MACRO(HasFastSHLDRotate, false, hasFastSHLDRotate)
GET_SUBTARGETINFO_MACRO(HasFastScalarFSQRT, false, hasFastScalarFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastScalarShiftMasks, false, hasFastScalarShiftMasks)
GET_SUBTARGETINFO_MACRO(HasFastVariableCrossLaneShuffle, false, hasFastVariableCrossLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVariablePerLaneShuffle, false, hasFastVariablePerLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVectorFSQRT, false, hasFastVectorFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastVectorShiftMasks, false, hasFastVectorShiftMasks)
GET_SUBTARGETINFO_MACRO(HasGETMANTFalseDeps, false, hasGETMANTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasGFNI, false, hasGFNI)
GET_SUBTARGETINFO_MACRO(HasHRESET, false, hasHRESET)
GET_SUBTARGETINFO_MACRO(HasIFMA, false, hasIFMA)
GET_SUBTARGETINFO_MACRO(HasINVPCID, false, hasINVPCID)
GET_SUBTARGETINFO_MACRO(HasKL, false, hasKL)
GET_SUBTARGETINFO_MACRO(HasLAHFSAHF64, false, hasLAHFSAHF64)
GET_SUBTARGETINFO_MACRO(HasLWP, false, hasLWP)
GET_SUBTARGETINFO_MACRO(HasLZCNT, false, hasLZCNT)
GET_SUBTARGETINFO_MACRO(HasLZCNTFalseDeps, false, hasLZCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMMX, false, hasMMX)
GET_SUBTARGETINFO_MACRO(HasMOVBE, false, hasMOVBE)
GET_SUBTARGETINFO_MACRO(HasMOVDIR64B, false, hasMOVDIR64B)
GET_SUBTARGETINFO_MACRO(HasMOVDIRI, false, hasMOVDIRI)
GET_SUBTARGETINFO_MACRO(HasMOVRS, false, hasMOVRS)
GET_SUBTARGETINFO_MACRO(HasMULCFalseDeps, false, hasMULCFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMULLQFalseDeps, false, hasMULLQFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMWAITX, false, hasMWAITX)
GET_SUBTARGETINFO_MACRO(HasMacroFusion, false, hasMacroFusion)
GET_SUBTARGETINFO_MACRO(HasNDD, false, hasNDD)
GET_SUBTARGETINFO_MACRO(HasNF, false, hasNF)
GET_SUBTARGETINFO_MACRO(HasNOPL, false, hasNOPL)
GET_SUBTARGETINFO_MACRO(HasPCLMUL, false, hasPCLMUL)
GET_SUBTARGETINFO_MACRO(HasPCONFIG, false, hasPCONFIG)
GET_SUBTARGETINFO_MACRO(HasPERMFalseDeps, false, hasPERMFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPKU, false, hasPKU)
GET_SUBTARGETINFO_MACRO(HasPOPCNT, false, hasPOPCNT)
GET_SUBTARGETINFO_MACRO(HasPOPCNTFalseDeps, false, hasPOPCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPPX, false, hasPPX)
GET_SUBTARGETINFO_MACRO(HasPREFETCHI, false, hasPREFETCHI)
GET_SUBTARGETINFO_MACRO(HasPRFCHW, false, hasPRFCHW)
GET_SUBTARGETINFO_MACRO(HasPTWRITE, false, hasPTWRITE)
GET_SUBTARGETINFO_MACRO(HasPush2Pop2, false, hasPush2Pop2)
GET_SUBTARGETINFO_MACRO(HasRANGEFalseDeps, false, hasRANGEFalseDeps)
GET_SUBTARGETINFO_MACRO(HasRAOINT, false, hasRAOINT)
GET_SUBTARGETINFO_MACRO(HasRDPID, false, hasRDPID)
GET_SUBTARGETINFO_MACRO(HasRDPRU, false, hasRDPRU)
GET_SUBTARGETINFO_MACRO(HasRDRAND, false, hasRDRAND)
GET_SUBTARGETINFO_MACRO(HasRDSEED, false, hasRDSEED)
GET_SUBTARGETINFO_MACRO(HasRTM, false, hasRTM)
GET_SUBTARGETINFO_MACRO(HasSBBDepBreaking, false, hasSBBDepBreaking)
GET_SUBTARGETINFO_MACRO(HasSERIALIZE, false, hasSERIALIZE)
GET_SUBTARGETINFO_MACRO(HasSGX, false, hasSGX)
GET_SUBTARGETINFO_MACRO(HasSHA, false, hasSHA)
GET_SUBTARGETINFO_MACRO(HasSHA512, false, hasSHA512)
GET_SUBTARGETINFO_MACRO(HasSHSTK, false, hasSHSTK)
GET_SUBTARGETINFO_MACRO(HasSM3, false, hasSM3)
GET_SUBTARGETINFO_MACRO(HasSM4, false, hasSM4)
GET_SUBTARGETINFO_MACRO(HasSSE4A, false, hasSSE4A)
GET_SUBTARGETINFO_MACRO(HasSSEUnalignedMem, false, hasSSEUnalignedMem)
GET_SUBTARGETINFO_MACRO(HasSlowDivide32, false, hasSlowDivide32)
GET_SUBTARGETINFO_MACRO(HasSlowDivide64, false, hasSlowDivide64)
GET_SUBTARGETINFO_MACRO(HasTBM, false, hasTBM)
GET_SUBTARGETINFO_MACRO(HasTSXLDTRK, false, hasTSXLDTRK)
GET_SUBTARGETINFO_MACRO(HasUINTR, false, hasUINTR)
GET_SUBTARGETINFO_MACRO(HasUSERMSR, false, hasUSERMSR)
GET_SUBTARGETINFO_MACRO(HasVAES, false, hasVAES)
GET_SUBTARGETINFO_MACRO(HasVBMI, false, hasVBMI)
GET_SUBTARGETINFO_MACRO(HasVBMI2, false, hasVBMI2)
GET_SUBTARGETINFO_MACRO(HasVLX, false, hasVLX)
GET_SUBTARGETINFO_MACRO(HasVNNI, false, hasVNNI)
GET_SUBTARGETINFO_MACRO(HasVP2INTERSECT, false, hasVP2INTERSECT)
GET_SUBTARGETINFO_MACRO(HasVPCLMULQDQ, false, hasVPCLMULQDQ)
GET_SUBTARGETINFO_MACRO(HasVPOPCNTDQ, false, hasVPOPCNTDQ)
GET_SUBTARGETINFO_MACRO(HasWAITPKG, false, hasWAITPKG)
GET_SUBTARGETINFO_MACRO(HasWBNOINVD, false, hasWBNOINVD)
GET_SUBTARGETINFO_MACRO(HasWIDEKL, false, hasWIDEKL)
GET_SUBTARGETINFO_MACRO(HasX86_64, false, hasX86_64)
GET_SUBTARGETINFO_MACRO(HasX87, false, hasX87)
GET_SUBTARGETINFO_MACRO(HasXOP, false, hasXOP)
GET_SUBTARGETINFO_MACRO(HasXSAVE, false, hasXSAVE)
GET_SUBTARGETINFO_MACRO(HasXSAVEC, false, hasXSAVEC)
GET_SUBTARGETINFO_MACRO(HasXSAVEOPT, false, hasXSAVEOPT)
GET_SUBTARGETINFO_MACRO(HasXSAVES, false, hasXSAVES)
GET_SUBTARGETINFO_MACRO(HasZU, false, hasZU)
GET_SUBTARGETINFO_MACRO(InsertVZEROUPPER, false, insertVZEROUPPER)
GET_SUBTARGETINFO_MACRO(Is16Bit, false, is16Bit)
GET_SUBTARGETINFO_MACRO(Is32Bit, false, is32Bit)
GET_SUBTARGETINFO_MACRO(Is64Bit, false, is64Bit)
GET_SUBTARGETINFO_MACRO(IsAtom, false, isAtom)
GET_SUBTARGETINFO_MACRO(IsPMADDWDSlow, false, isPMADDWDSlow)
GET_SUBTARGETINFO_MACRO(IsPMULLDSlow, false, isPMULLDSlow)
GET_SUBTARGETINFO_MACRO(IsSHLDSlow, false, isSHLDSlow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem16Slow, false, isUnalignedMem16Slow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem32Slow, false, isUnalignedMem32Slow)
GET_SUBTARGETINFO_MACRO(LeaUsesAG, false, leaUsesAG)
GET_SUBTARGETINFO_MACRO(NoDomainDelay, false, noDomainDelay)
GET_SUBTARGETINFO_MACRO(NoDomainDelayBlend, false, noDomainDelayBlend)
GET_SUBTARGETINFO_MACRO(NoDomainDelayMov, false, noDomainDelayMov)
GET_SUBTARGETINFO_MACRO(NoDomainDelayShuffle, false, noDomainDelayShuffle)
GET_SUBTARGETINFO_MACRO(PadShortFunctions, false, padShortFunctions)
GET_SUBTARGETINFO_MACRO(Prefer128Bit, false, prefer128Bit)
GET_SUBTARGETINFO_MACRO(Prefer256Bit, false, prefer256Bit)
GET_SUBTARGETINFO_MACRO(PreferGather, true, preferGather)
GET_SUBTARGETINFO_MACRO(PreferLowerShuffleAsShift, false, preferLowerShuffleAsShift)
GET_SUBTARGETINFO_MACRO(PreferMaskRegisters, false, preferMaskRegisters)
GET_SUBTARGETINFO_MACRO(PreferMovmskOverVTest, false, preferMovmskOverVTest)
GET_SUBTARGETINFO_MACRO(PreferScatter, true, preferScatter)
GET_SUBTARGETINFO_MACRO(Slow3OpsLEA, false, slow3OpsLEA)
GET_SUBTARGETINFO_MACRO(SlowIncDec, false, slowIncDec)
GET_SUBTARGETINFO_MACRO(SlowLEA, false, slowLEA)
GET_SUBTARGETINFO_MACRO(SlowTwoMemOps, false, slowTwoMemOps)
GET_SUBTARGETINFO_MACRO(UseGLMDivSqrtCosts, false, useGLMDivSqrtCosts)
GET_SUBTARGETINFO_MACRO(UseInlineAsmGPR32, false, useInlineAsmGPR32)
GET_SUBTARGETINFO_MACRO(UseLVIControlFlowIntegrity, false, useLVIControlFlowIntegrity)
GET_SUBTARGETINFO_MACRO(UseLVILoadHardening, false, useLVILoadHardening)
GET_SUBTARGETINFO_MACRO(UseLeaForSP, false, useLeaForSP)
GET_SUBTARGETINFO_MACRO(UseRetpolineExternalThunk, false, useRetpolineExternalThunk)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectBranches, false, useRetpolineIndirectBranches)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectCalls, false, useRetpolineIndirectCalls)
GET_SUBTARGETINFO_MACRO(UseSLMArithCosts, false, useSLMArithCosts)
GET_SUBTARGETINFO_MACRO(UseSoftFloat, false, useSoftFloat)
GET_SUBTARGETINFO_MACRO(UseSpeculativeExecutionSideEffectSuppression, false, useSpeculativeExecutionSideEffectSuppression)
#undef GET_SUBTARGETINFO_MACRO
#endif // GET_SUBTARGETINFO_MACRO


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV X86FeatureKV[] = {
  { "16bit-mode", "16-bit mode (i8086)", X86::Is16Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "32bit-mode", "32-bit mode (80386)", X86::Is32Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit", "Support 64-bit instructions", X86::FeatureX86_64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit-mode", "64-bit mode (x86_64)", X86::Is64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "adx", "Support ADX instructions", X86::FeatureADX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "aes", "Enable AES instructions", X86::FeatureAES, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "allow-light-256-bit", "Enable generation of 256-bit load/stores even if we prefer 128-bit", X86::TuningAllowLight256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-avx512", "Support AMX-AVX512 instructions", X86::FeatureAMXAVX512, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-bf16", "Support AMX-BF16 instructions", X86::FeatureAMXBF16, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-complex", "Support AMX-COMPLEX instructions", X86::FeatureAMXCOMPLEX, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-fp16", "Support AMX amx-fp16 instructions", X86::FeatureAMXFP16, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-fp8", "Support AMX-FP8 instructions", X86::FeatureAMXFP8, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-int8", "Support AMX-INT8 instructions", X86::FeatureAMXINT8, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-movrs", "Support AMX-MOVRS instructions", X86::FeatureAMXMOVRS, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-tf32", "Support AMX-TF32 instructions", X86::FeatureAMXTF32, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-tile", "Support AMX-TILE instructions", X86::FeatureAMXTILE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-transpose", "Support AMX amx-transpose instructions", X86::FeatureAMXTRANSPOSE, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx", "Enable AVX instructions", X86::FeatureAVX, { { { 0x0ULL, 0x20000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.1-256", "Support AVX10.1 up to 256-bit instruction", X86::FeatureAVX10_1, { { { 0x202000043000000ULL, 0x960000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.1-512", "Support AVX10.1 up to 512-bit instruction", X86::FeatureAVX10_1_512, { { { 0x200000004000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.2-256", "Support AVX10.2 up to 256-bit instruction", X86::FeatureAVX10_2, { { { 0x4000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.2-512", "Support AVX10.2 up to 512-bit instruction", X86::FeatureAVX10_2_512, { { { 0x18000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx2", "Enable AVX2 instructions", X86::FeatureAVX2, { { { 0x1000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bf16", "Support bfloat16 floating point", X86::FeatureBF16, { { { 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bitalg", "Enable AVX-512 Bit Algorithms", X86::FeatureBITALG, { { { 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bw", "Enable AVX-512 Byte and Word Instructions", X86::FeatureBWI, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512cd", "Enable AVX-512 Conflict Detection Instructions", X86::FeatureCDI, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512dq", "Enable AVX-512 Doubleword and Quadword Instructions", X86::FeatureDQI, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512f", "Enable AVX-512 instructions", X86::FeatureAVX512, { { { 0xc00000002000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512fp16", "Support 16-bit floating point", X86::FeatureFP16, { { { 0x20010000000ULL, 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512ifma", "Enable AVX-512 Integer Fused Multiple-Add", X86::FeatureIFMA, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi", "Enable AVX-512 Vector Byte Manipulation Instructions", X86::FeatureVBMI, { { { 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi2", "Enable AVX-512 further Vector Byte Manipulation Instructions", X86::FeatureVBMI2, { { { 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vl", "Enable AVX-512 Vector Length eXtensions", X86::FeatureVLX, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vnni", "Enable AVX-512 Vector Neural Network Instructions", X86::FeatureVNNI, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vp2intersect", "Enable AVX-512 vp2intersect", X86::FeatureVP2INTERSECT, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vpopcntdq", "Enable AVX-512 Population Count Instructions", X86::FeatureVPOPCNTDQ, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxifma", "Enable AVX-IFMA", X86::FeatureAVXIFMA, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxneconvert", "Support AVX-NE-CONVERT instructions", X86::FeatureAVXNECONVERT, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnni", "Support AVX_VNNI encoding", X86::FeatureAVXVNNI, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnniint16", "Enable AVX-VNNI-INT16", X86::FeatureAVXVNNIINT16, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnniint8", "Enable AVX-VNNI-INT8", X86::FeatureAVXVNNIINT8, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi", "Support BMI instructions", X86::FeatureBMI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi2", "Support BMI2 instructions", X86::FeatureBMI2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branch-hint", "Target has branch hint feature", X86::TuningBranchHint, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branchfusion", "CMP/TEST can be fused with conditional branches", X86::TuningBranchFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ccmp", "Support conditional cmp & test instructions", X86::FeatureCCMP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cf", "Support conditional faulting", X86::FeatureCF, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cldemote", "Enable Cache Line Demote", X86::FeatureCLDEMOTE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clflushopt", "Flush A Cache Line Optimized", X86::FeatureCLFLUSHOPT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clwb", "Cache Line Write Back", X86::FeatureCLWB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clzero", "Enable Cache Line Zero", X86::FeatureCLZERO, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmov", "Enable conditional move instructions", X86::FeatureCMOV, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmpccxadd", "Support CMPCCXADD instructions", X86::FeatureCMPCCXADD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "crc32", "Enable SSE 4.2 CRC32 instruction (used when SSE4.2 is supported but function is GPR only)", X86::FeatureCRC32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx16", "64-bit with cmpxchg16b (this is true for most x86-64 chips, but not the first AMD chips)", X86::FeatureCX16, { { { 0x8000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx8", "Support CMPXCHG8B instructions", X86::FeatureCX8, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "egpr", "Support extended general purpose register", X86::FeatureEGPR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "enqcmd", "Has ENQCMD instructions", X86::FeatureENQCMD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ermsb", "REP MOVS/STOS are fast", X86::FeatureERMSB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "evex512", "Support ZMM and 64-bit mask instructions", X86::FeatureEVEX512, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "f16c", "Support 16-bit floating point conversion instructions", X86::FeatureF16C, { { { 0x1000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-getmant", "VGETMANTSS/SD/SH and VGETMANDPS/PD(memory version) has a false dependency on dest register", X86::TuningGETMANTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-lzcnt-tzcnt", "LZCNT/TZCNT have a false dependency on dest register", X86::TuningLZCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mulc", "VF[C]MULCPH/SH has a false dependency on dest register", X86::TuningMULCFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mullq", "VPMULLQ has a false dependency on dest register", X86::TuningMULLQFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-perm", "VPERMD/Q/PS/PD has a false dependency on dest register", X86::TuningPERMFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-popcnt", "POPCNT has a false dependency on dest register", X86::TuningPOPCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-range", "VRANGEPD/PS/SD/SS has a false dependency on dest register", X86::TuningRANGEFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-11bytenop", "Target can quickly decode up to 11 byte NOPs", X86::TuningFast11ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-15bytenop", "Target can quickly decode up to 15 byte NOPs", X86::TuningFast15ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-7bytenop", "Target can quickly decode up to 7 byte NOPs", X86::TuningFast7ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-bextr", "Indicates that the BEXTR instruction is implemented as a single uop with good throughput", X86::TuningFastBEXTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-dpwssd", "Prefer vpdpwssd instruction over vpmaddwd+vpaddd instruction sequence", X86::TuningFastDPWSSD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-gather", "Indicates if gather is reasonably fast (this is true for Skylake client and all AVX-512 CPUs)", X86::TuningFastGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-hops", "Prefer horizontal vector math instructions (haddp, phsub, etc.) over normal vector instructions with shuffles", X86::TuningFastHorizontalOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-imm16", "Prefer a i16 instruction with i16 immediate over extension to i32", X86::TuningFastImm16, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-lzcnt", "LZCNT instructions are as fast as most simple integer ops", X86::TuningFastLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-movbe", "Prefer a movbe over a single-use load + bswap / single-use bswap + store", X86::TuningFastMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-fsqrt", "Scalar SQRT is fast (disable Newton-Raphson)", X86::TuningFastScalarFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-shift-masks", "Prefer a left/right scalar logical shift pair over a shift+and pair", X86::TuningFastScalarShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-shld-rotate", "SHLD can be used as a faster rotate", X86::TuningFastSHLDRotate, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-crosslane-shuffle", "Cross-lane shuffles with variable masks are fast", X86::TuningFastVariableCrossLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-perlane-shuffle", "Per-lane shuffles with variable masks are fast", X86::TuningFastVariablePerLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-fsqrt", "Vector SQRT is fast (disable Newton-Raphson)", X86::TuningFastVectorFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-shift-masks", "Prefer a left/right vector logical shift pair over a shift+and pair", X86::TuningFastVectorShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "faster-shift-than-shuffle", "Shifts are faster (or as fast) as shuffle", X86::TuningPreferShiftShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma", "Enable three-operand fused multiple-add", X86::FeatureFMA, { { { 0x1000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma4", "Enable four-operand fused multiple-add", X86::FeatureFMA4, { { { 0x1000ULL, 0x8000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsgsbase", "Support FS/GS Base instructions", X86::FeatureFSGSBase, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsrm", "REP MOVSB of short lengths is faster", X86::FeatureFSRM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fxsr", "Support fxsave/fxrestore instructions", X86::FeatureFXSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "gfni", "Enable Galois Field Arithmetic Instructions", X86::FeatureGFNI, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ijmp", "Harden against straight line speculation across indirect JMP instructions.", X86::FeatureHardenSlsIJmp, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ret", "Harden against straight line speculation across RET instructions.", X86::FeatureHardenSlsRet, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "hreset", "Has hreset instruction", X86::FeatureHRESET, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivl-to-divb", "Use 8-bit divide for positive values less than 256", X86::TuningSlowDivide32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivq-to-divl", "Use 32-bit divide for positive values less than 2^32", X86::TuningSlowDivide64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "inline-asm-use-gpr32", "Enable use of GPR32 in inline assembly for APX", X86::FeatureUseGPR32InInlineAsm, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "invpcid", "Invalidate Process-Context Identifier", X86::FeatureINVPCID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "kl", "Support Key Locker kl Instructions", X86::FeatureKL, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-sp", "Use LEA for adjusting the stack pointer (this is an optimization for Intel Atom processors)", X86::TuningLEAForSP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-uses-ag", "LEA instruction needs inputs at AG stage", X86::TuningLEAUsesAG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-cfi", "Prevent indirect calls/branches from using a memory operand, and precede all indirect calls/branches from a register with an LFENCE instruction to serialize control flow. Also decompose RET instructions into a POP+LFENCE+JMP sequence.", X86::FeatureLVIControlFlowIntegrity, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-load-hardening", "Insert LFENCE instructions to prevent data speculatively injected into loads from being used maliciously.", X86::FeatureLVILoadHardening, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lwp", "Enable LWP instructions", X86::FeatureLWP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lzcnt", "Support LZCNT instruction", X86::FeatureLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "macrofusion", "Various instructions can be fused with conditional branches", X86::TuningMacroFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mmx", "Enable MMX instructions", X86::FeatureMMX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movbe", "Support MOVBE instruction", X86::FeatureMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdir64b", "Support movdir64b instruction (direct store 64 bytes)", X86::FeatureMOVDIR64B, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdiri", "Support movdiri instruction (direct store integer)", X86::FeatureMOVDIRI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movrs", "Enable MOVRS", X86::FeatureMOVRS, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mwaitx", "Enable MONITORX/MWAITX timer functionality", X86::FeatureMWAITX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ndd", "Support non-destructive destination", X86::FeatureNDD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nf", "Support status flags update suppression", X86::FeatureNF, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay", "Has no bypass delay when using the 'wrong' domain", X86::TuningNoDomainDelay, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-blend", "Has no bypass delay when using the 'wrong' blend type", X86::TuningNoDomainDelayBlend, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-mov", "Has no bypass delay when using the 'wrong' mov type", X86::TuningNoDomainDelayMov, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-shuffle", "Has no bypass delay when using the 'wrong' shuffle type", X86::TuningNoDomainDelayShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nopl", "Enable NOPL instruction (generally pentium pro+)", X86::FeatureNOPL, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pad-short-functions", "Pad short functions (to prevent a stall when returning too early)", X86::TuningPadShortFunctions, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pclmul", "Enable packed carry-less multiplication instructions", X86::FeaturePCLMUL, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pconfig", "platform configuration instruction", X86::FeaturePCONFIG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pku", "Enable protection keys", X86::FeaturePKU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "popcnt", "Support POPCNT instruction", X86::FeaturePOPCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ppx", "Support Push-Pop Acceleration", X86::FeaturePPX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-128-bit", "Prefer 128-bit AVX instructions", X86::TuningPrefer128Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-256-bit", "Prefer 256-bit AVX instructions", X86::TuningPrefer256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-mask-registers", "Prefer AVX512 mask registers over PTEST/MOVMSK", X86::TuningPreferMaskRegisters, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-movmsk-over-vtest", "Prefer movmsk over vtest instruction", X86::TuningPreferMovmskOverVTest, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-no-gather", "Prefer no gather instructions", X86::TuningPreferNoGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-no-scatter", "Prefer no scatter instructions", X86::TuningPreferNoScatter, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchi", "Prefetch instruction with T0 or T1 Hint", X86::FeaturePREFETCHI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prfchw", "Support PRFCHW instructions", X86::FeaturePRFCHW, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ptwrite", "Support ptwrite instruction", X86::FeaturePTWRITE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "push2pop2", "Support PUSH2/POP2 instructions", X86::FeaturePush2Pop2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "raoint", "Support RAO-INT instructions", X86::FeatureRAOINT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpid", "Support RDPID instructions", X86::FeatureRDPID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpru", "Support RDPRU instructions", X86::FeatureRDPRU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdrnd", "Support RDRAND instruction", X86::FeatureRDRAND, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdseed", "Support RDSEED instruction", X86::FeatureRDSEED, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline", "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct", X86::FeatureRetpoline, { { { 0x0ULL, 0x18000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-external-thunk", "When lowering an indirect call or branch using a `retpoline`, rely on the specified user provided thunk rather than emitting one ourselves. Only has effect when combined with some other retpoline feature", X86::FeatureRetpolineExternalThunk, { { { 0x0ULL, 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-branches", "Remove speculation of indirect branches from the generated code", X86::FeatureRetpolineIndirectBranches, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-calls", "Remove speculation of indirect calls from the generated code", X86::FeatureRetpolineIndirectCalls, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rtm", "Support RTM instructions", X86::FeatureRTM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sahf", "Support LAHF and SAHF instructions in 64-bit mode", X86::FeatureLAHFSAHF64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sbb-dep-breaking", "SBB with same register has no source dependency", X86::TuningSBBDepBreaking, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "serialize", "Has serialize instruction", X86::FeatureSERIALIZE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "seses", "Prevent speculative execution side channel timing attacks by inserting a speculation barrier before memory reads, memory writes, and conditional branches. Implies LVI Control Flow integrity.", X86::FeatureSpeculativeExecutionSideEffectSuppression, { { { 0x2000000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sgx", "Enable Software Guard Extensions", X86::FeatureSGX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha", "Enable SHA instructions", X86::FeatureSHA, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha512", "Support SHA512 instructions", X86::FeatureSHA512, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "shstk", "Support CET Shadow-Stack instructions", X86::FeatureSHSTK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-3ops-lea", "LEA instruction with 3 ops or certain registers is slow", X86::TuningSlow3OpsLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-incdec", "INC and DEC instructions are slower than ADD and SUB", X86::TuningSlowIncDec, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-lea", "LEA instruction with certain arguments is slow", X86::TuningSlowLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmaddwd", "PMADDWD is slower than PMULLD", X86::TuningSlowPMADDWD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmulld", "PMULLD instruction is slow (compared to PMULLW/PMULHW and PMULUDQ)", X86::TuningSlowPMULLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-shld", "SHLD instruction is slow", X86::TuningSlowSHLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-two-mem-ops", "Two memory operand instructions are slow", X86::TuningSlowTwoMemOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-16", "Slow unaligned 16-byte memory access", X86::TuningSlowUAMem16, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-32", "Slow unaligned 32-byte memory access", X86::TuningSlowUAMem32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sm3", "Support SM3 instructions", X86::FeatureSM3, { { { 0x1000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sm4", "Support SM4 instructions", X86::FeatureSM4, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "soft-float", "Use software floating point features", X86::FeatureSoftFloat, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse", "Enable SSE instructions", X86::FeatureSSE1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse-unaligned-mem", "Allow unaligned memory operands with SSE instructions (this may require setting a configuration bit in the processor)", X86::FeatureSSEUnalignedMem, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse2", "Enable SSE2 instructions", X86::FeatureSSE2, { { { 0x0ULL, 0x1000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse3", "Enable SSE3 instructions", X86::FeatureSSE3, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.1", "Enable SSE 4.1 instructions", X86::FeatureSSE41, { { { 0x0ULL, 0x80000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.2", "Enable SSE 4.2 instructions", X86::FeatureSSE42, { { { 0x0ULL, 0x10000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4a", "Support SSE 4a instructions", X86::FeatureSSE4A, { { { 0x0ULL, 0x4000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ssse3", "Enable SSSE3 instructions", X86::FeatureSSSE3, { { { 0x0ULL, 0x4000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tagged-globals", "Use an instruction sequence for taking the address of a global that allows a memory tag in the upper address bits.", X86::FeatureTaggedGlobals, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tbm", "Enable TBM instructions", X86::FeatureTBM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tsxldtrk", "Support TSXLDTRK instructions", X86::FeatureTSXLDTRK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tuning-fast-imm-vector-shift", "Vector shifts are fast (2/cycle) as opposed to slow (1/cycle)", X86::TuningFastImmVectorShift, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "uintr", "Has UINTR Instructions", X86::FeatureUINTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-glm-div-sqrt-costs", "Use Goldmont specific floating point div/sqrt costs", X86::TuningUseGLMDivSqrtCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-slm-arith-costs", "Use Silvermont specific arithmetic costs", X86::TuningUseSLMArithCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "usermsr", "Support USERMSR instructions", X86::FeatureUSERMSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vaes", "Promote selected AES instructions to AVX512/AVX registers", X86::FeatureVAES, { { { 0x2002ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vpclmulqdq", "Enable vpclmulqdq instructions", X86::FeatureVPCLMULQDQ, { { { 0x1000ULL, 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vzeroupper", "Should insert vzeroupper instructions", X86::TuningInsertVZEROUPPER, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "waitpkg", "Wait and pause enhancements", X86::FeatureWAITPKG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "wbnoinvd", "Write Back No Invalidate", X86::FeatureWBNOINVD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "widekl", "Support Key Locker wide Instructions", X86::FeatureWIDEKL, { { { 0x800000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "x87", "Enable X87 float instructions", X86::FeatureX87, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xop", "Enable XOP instructions", X86::FeatureXOP, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsave", "Support xsave instructions", X86::FeatureXSAVE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsavec", "Support xsavec instructions", X86::FeatureXSAVEC, { { { 0x0ULL, 0x0ULL, 0x4ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaveopt", "Support xsaveopt instructions", X86::FeatureXSAVEOPT, { { { 0x0ULL, 0x0ULL, 0x4ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaves", "Support xsaves instructions", X86::FeatureXSAVES, { { { 0x0ULL, 0x0ULL, 0x4ULL, 0x0ULL, 0x0ULL, } } } },
  { "zu", "Support zero-upper SETcc/IMUL", X86::FeatureZU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, ReleaseAtCycle, AcquireAtCycle}
extern const llvm::MCWriteProcResEntry X86WriteProcResTable[] = {
  { 0,  0,  0 }, // Invalid
  { 5,  1,   0}, // #1
  {28,  1,   0}, // #2
  { 1,  1,   0}, // #3
  { 2,  1,   0}, // #4
  { 3,  1,   0}, // #5
  { 4,  1,   0}, // #6
  { 5,  1,   0}, // #7
  { 6,  1,   0}, // #8
  { 7,  1,   0}, // #9
  { 8,  1,   0}, // #10
  {28,  1,   0}, // #11
  { 4,  1,   0}, // #12
  { 5,  1,   0}, // #13
  { 7,  1,   0}, // #14
  { 8,  1,   0}, // #15
  {28,  1,   0}, // #16
  { 4,  2,   0}, // #17
  { 5,  3,   0}, // #18
  { 7,  2,   0}, // #19
  { 8,  2,   0}, // #20
  {15,  2,   0}, // #21
  {16,  1,   0}, // #22
  {19,  1,   0}, // #23
  {23,  1,   0}, // #24
  {28,  6,   0}, // #25
  { 4,  1,   0}, // #26
  { 5,  1,   0}, // #27
  { 7,  1,   0}, // #28
  { 8,  1,   0}, // #29
  {13,  1,   0}, // #30
  {14,  1,   0}, // #31
  {15,  1,   0}, // #32
  {16,  1,   0}, // #33
  {28,  2,   0}, // #34
  { 4,  1,   0}, // #35
  { 5,  1,   0}, // #36
  {28,  1,   0}, // #37
  { 2,  1,   0}, // #38
  { 3,  1,   0}, // #39
  { 4,  1,   0}, // #40
  { 5,  1,   0}, // #41
  { 9,  1,   0}, // #42
  {10,  1,   0}, // #43
  {11,  1,   0}, // #44
  {28,  1,   0}, // #45
  {15,  2,   0}, // #46
  {16,  1,   0}, // #47
  {19,  1,   0}, // #48
  {23,  1,   0}, // #49
  {28,  3,   0}, // #50
  {15,  1,   0}, // #51
  {19,  1,   0}, // #52
  {23,  1,   0}, // #53
  {28,  2,   0}, // #54
  {15,  1,   0}, // #55
  {16,  1,   0}, // #56
  {28,  1,   0}, // #57
  { 5,  1,   0}, // #58
  {15,  2,   0}, // #59
  {16,  1,   0}, // #60
  {19,  1,   0}, // #61
  {23,  1,   0}, // #62
  {28,  4,   0}, // #63
  { 4,  1,   0}, // #64
  { 5,  2,   0}, // #65
  { 7,  1,   0}, // #66
  { 8,  1,   0}, // #67
  {15,  2,   0}, // #68
  {16,  1,   0}, // #69
  {19,  1,   0}, // #70
  {23,  1,   0}, // #71
  {28,  5,   0}, // #72
  { 4,  1,   0}, // #73
  { 5,  2,   0}, // #74
  { 7,  1,   0}, // #75
  { 8,  1,   0}, // #76
  {28,  2,   0}, // #77
  { 3,  1,   0}, // #78
  { 4,  1,   0}, // #79
  { 5,  1,   0}, // #80
  {10,  1,   0}, // #81
  {11,  1,   0}, // #82
  {15,  1,   0}, // #83
  {16,  1,   0}, // #84
  {28,  2,   0}, // #85
  { 3,  1,   0}, // #86
  { 4,  1,   0}, // #87
  { 5,  1,   0}, // #88
  {10,  1,   0}, // #89
  {11,  1,   0}, // #90
  {28,  1,   0}, // #91
  { 3,  1,   0}, // #92
  { 4,  1,   0}, // #93
  { 5,  1,   0}, // #94
  { 6,  1,   0}, // #95
  { 7,  1,   0}, // #96
  {10,  1,   0}, // #97
  {11,  1,   0}, // #98
  {20,  1,   0}, // #99
  {28,  1,   0}, // #100
  { 2,  1,   0}, // #101
  { 3,  1,   0}, // #102
  { 4,  1,   0}, // #103
  { 5,  1,   0}, // #104
  {15,  1,   0}, // #105
  {16,  1,   0}, // #106
  {28,  2,   0}, // #107
  { 2,  1,   0}, // #108
  { 3,  1,   0}, // #109
  { 4,  1,   0}, // #110
  { 5,  1,   0}, // #111
  {28,  1,   0}, // #112
  { 2,  2,   0}, // #113
  { 3,  2,   0}, // #114
  { 4,  2,   0}, // #115
  { 5,  2,   0}, // #116
  {15,  1,   0}, // #117
  {16,  1,   0}, // #118
  {28,  3,   0}, // #119
  { 2,  2,   0}, // #120
  { 3,  2,   0}, // #121
  { 4,  2,   0}, // #122
  { 5,  2,   0}, // #123
  {28,  2,   0}, // #124
  { 1,  4,   0}, // #125
  { 2,  5,   0}, // #126
  { 3, 11,   0}, // #127
  { 4, 13,   0}, // #128
  { 5, 13,   0}, // #129
  { 6,  7,   0}, // #130
  { 7,  9,   0}, // #131
  { 8,  6,   0}, // #132
  {10,  6,   0}, // #133
  {11,  6,   0}, // #134
  {15,  1,   0}, // #135
  {16,  1,   0}, // #136
  {20,  3,   0}, // #137
  {28, 14,   0}, // #138
  { 1,  4,   0}, // #139
  { 2,  5,   0}, // #140
  { 3, 12,   0}, // #141
  { 4, 14,   0}, // #142
  { 5, 14,   0}, // #143
  { 6,  7,   0}, // #144
  { 7,  9,   0}, // #145
  { 8,  6,   0}, // #146
  {10,  6,   0}, // #147
  {11,  6,   0}, // #148
  {20,  3,   0}, // #149
  {28, 14,   0}, // #150
  { 2,  1,   0}, // #151
  { 3,  1,   0}, // #152
  { 4,  2,   0}, // #153
  { 5,  2,   0}, // #154
  { 7,  1,   0}, // #155
  { 8,  1,   0}, // #156
  { 9,  1,   0}, // #157
  {10,  1,   0}, // #158
  {11,  1,   0}, // #159
  {15,  1,   0}, // #160
  {16,  1,   0}, // #161
  {28,  3,   0}, // #162
  { 2,  1,   0}, // #163
  { 3,  1,   0}, // #164
  { 4,  2,   0}, // #165
  { 5,  2,   0}, // #166
  { 7,  1,   0}, // #167
  { 8,  1,   0}, // #168
  { 9,  1,   0}, // #169
  {10,  1,   0}, // #170
  {11,  1,   0}, // #171
  {28,  2,   0}, // #172
  { 5,  1,   0}, // #173
  {11,  1,   0}, // #174
  {15,  1,   0}, // #175
  {16,  1,   0}, // #176
  {28,  2,   0}, // #177
  { 5,  1,   0}, // #178
  {11,  1,   0}, // #179
  {28,  1,   0}, // #180
  { 2,  1,   0}, // #181
  { 3,  1,   0}, // #182
  { 4,  1,   0}, // #183
  { 5,  1,   0}, // #184
  { 9,  1,   0}, // #185
  {10,  1,   0}, // #186
  {11,  1,   0}, // #187
  {15,  1,   0}, // #188
  {16,  1,   0}, // #189
  {28,  2,   0}, // #190
  { 2,  1,   0}, // #191
  { 3,  1,   0}, // #192
  { 4,  3,   0}, // #193
  { 5,  9,   0}, // #194
  { 7,  2,   0}, // #195
  { 8,  2,   0}, // #196
  { 9,  1,   0}, // #197
  {10,  1,   0}, // #198
  {11,  3,   0}, // #199
  {15,  1,   0}, // #200
  {16,  1,   0}, // #201
  {28, 10,   0}, // #202
  { 2,  1,   0}, // #203
  { 3,  1,   0}, // #204
  { 4,  1,   0}, // #205
  { 5,  1,   0}, // #206
  { 9,  1,   0}, // #207
  {10,  1,   0}, // #208
  {11,  1,   0}, // #209
  {15,  2,   0}, // #210
  {16,  1,   0}, // #211
  {19,  1,   0}, // #212
  {23,  1,   0}, // #213
  {28,  4,   0}, // #214
  { 2,  1,   0}, // #215
  { 3,  1,   0}, // #216
  { 4,  3,   0}, // #217
  { 5,  8,   0}, // #218
  { 7,  2,   0}, // #219
  { 8,  2,   0}, // #220
  { 9,  1,   0}, // #221
  {10,  1,   0}, // #222
  {11,  3,   0}, // #223
  {15,  2,   0}, // #224
  {16,  1,   0}, // #225
  {19,  1,   0}, // #226
  {23,  1,   0}, // #227
  {28, 11,   0}, // #228
  { 4,  1,   0}, // #229
  { 5,  1,   0}, // #230
  { 7,  1,   0}, // #231
  { 8,  1,   0}, // #232
  {15,  1,   0}, // #233
  {16,  1,   0}, // #234
  {28,  2,   0}, // #235
  { 5,  3,   0}, // #236
  {28,  3,   0}, // #237
  { 4,  2,   0}, // #238
  { 5,  5,   0}, // #239
  { 7,  2,   0}, // #240
  { 8,  2,   0}, // #241
  {28,  5,   0}, // #242
  { 1,  1,   0}, // #243
  { 2,  1,   0}, // #244
  { 3,  1,   0}, // #245
  { 4,  1,   0}, // #246
  { 5,  1,   0}, // #247
  { 6,  1,   0}, // #248
  { 7,  1,   0}, // #249
  { 8,  1,   0}, // #250
  {15,  1,   0}, // #251
  {16,  1,   0}, // #252
  {28,  2,   0}, // #253
  { 2,  1,   0}, // #254
  { 3,  2,   0}, // #255
  { 4,  2,   0}, // #256
  { 5,  2,   0}, // #257
  { 6,  1,   0}, // #258
  { 7,  1,   0}, // #259
  {10,  1,   0}, // #260
  {11,  1,   0}, // #261
  {20,  1,   0}, // #262
  {28,  2,   0}, // #263
  { 2,  1,   0}, // #264
  { 3,  2,   0}, // #265
  { 4,  2,   0}, // #266
  { 5,  2,   0}, // #267
  { 6,  1,   0}, // #268
  { 7,  1,   0}, // #269
  {10,  1,   0}, // #270
  {11,  1,   0}, // #271
  {15,  1,   0}, // #272
  {16,  1,   0}, // #273
  {20,  1,   0}, // #274
  {28,  3,   0}, // #275
  { 1,  1,   0}, // #276
  { 2,  2,   0}, // #277
  { 3,  2,   0}, // #278
  { 4,  2,   0}, // #279
  { 5,  2,   0}, // #280
  { 6,  1,   0}, // #281
  { 7,  1,   0}, // #282
  { 8,  1,   0}, // #283
  {15,  1,   0}, // #284
  {16,  1,   0}, // #285
  {28,  3,   0}, // #286
  { 1,  1,   0}, // #287
  { 2,  2,   0}, // #288
  { 3,  2,   0}, // #289
  { 4,  2,   0}, // #290
  { 5,  2,   0}, // #291
  { 6,  1,   0}, // #292
  { 7,  1,   0}, // #293
  { 8,  1,   0}, // #294
  {28,  2,   0}, // #295
  { 2,  3,   0}, // #296
  { 3,  3,   0}, // #297
  { 4,  3,   0}, // #298
  { 5,  4,   0}, // #299
  { 9,  3,   0}, // #300
  {10,  3,   0}, // #301
  {11,  3,   0}, // #302
  {15,  1,   0}, // #303
  {16,  1,   0}, // #304
  {28,  5,   0}, // #305
  { 2,  3,   0}, // #306
  { 3,  3,   0}, // #307
  { 4,  3,   0}, // #308
  { 5,  4,   0}, // #309
  { 9,  3,   0}, // #310
  {10,  3,   0}, // #311
  {11,  3,   0}, // #312
  {28,  4,   0}, // #313
  { 2,  3,   0}, // #314
  { 3,  3,   0}, // #315
  { 4,  3,   0}, // #316
  { 5,  3,   0}, // #317
  { 9,  3,   0}, // #318
  {10,  3,   0}, // #319
  {11,  3,   0}, // #320
  {15,  1,   0}, // #321
  {16,  1,   0}, // #322
  {28,  4,   0}, // #323
  { 2,  3,   0}, // #324
  { 3,  3,   0}, // #325
  { 4,  3,   0}, // #326
  { 5,  3,   0}, // #327
  { 9,  3,   0}, // #328
  {10,  3,   0}, // #329
  {11,  3,   0}, // #330
  {28,  3,   0}, // #331
  { 2,  2,   0}, // #332
  { 3,  3,   0}, // #333
  { 4,  3,   0}, // #334
  { 5,  3,   0}, // #335
  {10,  1,   0}, // #336
  {11,  1,   0}, // #337
  {15,  1,   0}, // #338
  {16,  1,   0}, // #339
  {28,  4,   0}, // #340
  { 2,  2,   0}, // #341
  { 3,  3,   0}, // #342
  { 4,  3,   0}, // #343
  { 5,  3,   0}, // #344
  {10,  1,   0}, // #345
  {11,  1,   0}, // #346
  {28,  3,   0}, // #347
  { 2,  2,   0}, // #348
  { 3,  5,   0}, // #349
  { 4,  6,   0}, // #350
  { 5,  6,   0}, // #351
  { 6,  1,   0}, // #352
  { 7,  2,   0}, // #353
  { 8,  1,   0}, // #354
  {10,  3,   0}, // #355
  {11,  3,   0}, // #356
  {15,  1,   0}, // #357
  {16,  1,   0}, // #358
  {20,  1,   0}, // #359
  {28,  7,   0}, // #360
  { 2,  2,   0}, // #361
  { 3,  5,   0}, // #362
  { 4,  6,   0}, // #363
  { 5,  6,   0}, // #364
  { 6,  1,   0}, // #365
  { 7,  2,   0}, // #366
  { 8,  1,   0}, // #367
  {10,  3,   0}, // #368
  {11,  3,   0}, // #369
  {20,  1,   0}, // #370
  {28,  6,   0}, // #371
  { 3,  1,   0}, // #372
  { 4,  1,   0}, // #373
  { 5,  1,   0}, // #374
  {10,  1,   0}, // #375
  {11,  1,   0}, // #376
  {15,  1,   0}, // #377
  {19,  1,   0}, // #378
  {23,  1,   0}, // #379
  {28,  3,   0}, // #380
  { 1,  1,   0}, // #381
  { 2,  1,   0}, // #382
  { 3,  2,   0}, // #383
  { 4,  2,   0}, // #384
  { 5,  2,   0}, // #385
  { 6,  1,   0}, // #386
  { 7,  1,   0}, // #387
  { 8,  1,   0}, // #388
  {10,  1,   0}, // #389
  {11,  1,   0}, // #390
  {28,  2,   0}, // #391
  { 3,  1,   0}, // #392
  { 4,  1,   0}, // #393
  { 5,  1,   0}, // #394
  { 6,  1,   0}, // #395
  { 7,  1,   0}, // #396
  {10,  1,   0}, // #397
  {11,  1,   0}, // #398
  {13,  1,   0}, // #399
  {14,  1,   0}, // #400
  {15,  1,   0}, // #401
  {16,  1,   0}, // #402
  {20,  1,   0}, // #403
  {28,  2,   0}, // #404
  { 1,  1,   0}, // #405
  { 2,  1,   0}, // #406
  { 3,  9,   0}, // #407
  { 4, 10,   0}, // #408
  { 5, 10,   0}, // #409
  { 6,  9,   0}, // #410
  { 7, 10,   0}, // #411
  { 8,  2,   0}, // #412
  {28, 10,   0}, // #413
  { 3,  2,   0}, // #414
  { 4,  2,   0}, // #415
  { 5,  2,   0}, // #416
  { 6,  2,   0}, // #417
  { 7,  2,   0}, // #418
  {28,  2,   0}, // #419
  { 3,  3,   0}, // #420
  { 4,  3,   0}, // #421
  { 5,  3,   0}, // #422
  { 6,  2,   0}, // #423
  { 7,  2,   0}, // #424
  {10,  3,   0}, // #425
  {11,  3,   0}, // #426
  {15,  1,   0}, // #427
  {16,  1,   0}, // #428
  {20,  2,   0}, // #429
  {28,  4,   0}, // #430
  { 3,  3,   0}, // #431
  { 4,  3,   0}, // #432
  { 5,  3,   0}, // #433
  { 6,  2,   0}, // #434
  { 7,  2,   0}, // #435
  {10,  3,   0}, // #436
  {11,  3,   0}, // #437
  {20,  2,   0}, // #438
  {28,  3,   0}, // #439
  { 2,  1,   0}, // #440
  { 3,  1,   0}, // #441
  { 4,  2,   0}, // #442
  { 5,  4,   0}, // #443
  { 7,  1,   0}, // #444
  { 8,  1,   0}, // #445
  { 9,  1,   0}, // #446
  {10,  1,   0}, // #447
  {11,  1,   0}, // #448
  {15,  1,   0}, // #449
  {16,  1,   0}, // #450
  {28,  5,   0}, // #451
  { 2,  1,   0}, // #452
  { 3,  1,   0}, // #453
  { 4,  2,   0}, // #454
  { 5,  4,   0}, // #455
  { 7,  1,   0}, // #456
  { 8,  1,   0}, // #457
  { 9,  1,   0}, // #458
  {10,  1,   0}, // #459
  {11,  1,   0}, // #460
  {28,  4,   0}, // #461
  { 2,  1,   0}, // #462
  { 3,  1,   0}, // #463
  { 4,  1,   0}, // #464
  { 5,  2,   0}, // #465
  { 9,  1,   0}, // #466
  {10,  1,   0}, // #467
  {11,  1,   0}, // #468
  {15,  1,   0}, // #469
  {16,  1,   0}, // #470
  {28,  3,   0}, // #471
  { 2,  1,   0}, // #472
  { 3,  1,   0}, // #473
  { 4,  1,   0}, // #474
  { 5,  2,   0}, // #475
  { 9,  1,   0}, // #476
  {10,  1,   0}, // #477
  {11,  1,   0}, // #478
  {28,  2,   0}, // #479
  { 2,  1,   0}, // #480
  { 3,  1,   0}, // #481
  { 4,  2,   0}, // #482
  { 5,  3,   0}, // #483
  { 7,  1,   0}, // #484
  { 8,  1,   0}, // #485
  { 9,  1,   0}, // #486
  {10,  1,   0}, // #487
  {11,  1,   0}, // #488
  {15,  1,   0}, // #489
  {16,  1,   0}, // #490
  {28,  4,   0}, // #491
  { 2,  1,   0}, // #492
  { 3,  1,   0}, // #493
  { 4,  2,   0}, // #494
  { 5,  3,   0}, // #495
  { 7,  1,   0}, // #496
  { 8,  1,   0}, // #497
  { 9,  1,   0}, // #498
  {10,  1,   0}, // #499
  {11,  1,   0}, // #500
  {28,  3,   0}, // #501
  { 2,  1,   0}, // #502
  { 3,  2,   0}, // #503
  { 4,  2,   0}, // #504
  { 5,  2,   0}, // #505
  { 6,  1,   0}, // #506
  { 7,  1,   0}, // #507
  { 9,  1,   0}, // #508
  {10,  2,   0}, // #509
  {11,  2,   0}, // #510
  {15,  1,   0}, // #511
  {16,  1,   0}, // #512
  {20,  1,   0}, // #513
  {28,  3,   0}, // #514
  { 2,  1,   0}, // #515
  { 3,  2,   0}, // #516
  { 4,  2,   0}, // #517
  { 5,  2,   0}, // #518
  { 6,  1,   0}, // #519
  { 7,  1,   0}, // #520
  { 9,  1,   0}, // #521
  {10,  2,   0}, // #522
  {11,  2,   0}, // #523
  {20,  1,   0}, // #524
  {28,  2,   0}, // #525
  { 3,  1,   0}, // #526
  { 4,  1,   0}, // #527
  { 5,  1,   0}, // #528
  { 6,  1,   0}, // #529
  { 7,  1,   0}, // #530
  {10,  1,   0}, // #531
  {11,  1,   0}, // #532
  {15,  1,   0}, // #533
  {16,  1,   0}, // #534
  {20,  1,   0}, // #535
  {28,  2,   0}, // #536
  { 1,  1,   0}, // #537
  { 2,  1,   0}, // #538
  { 3,  2,   0}, // #539
  { 4,  3,   0}, // #540
  { 5,  3,   0}, // #541
  { 6,  1,   0}, // #542
  { 7,  2,   0}, // #543
  { 8,  2,   0}, // #544
  {15,  1,   0}, // #545
  {16,  1,   0}, // #546
  {28,  4,   0}, // #547
  { 3,  1,   0}, // #548
  { 4,  1,   0}, // #549
  { 5,  1,   0}, // #550
  { 6,  1,   0}, // #551
  { 7,  1,   0}, // #552
  {28,  1,   0}, // #553
  { 3,  1,   0}, // #554
  { 4,  1,   0}, // #555
  { 5,  1,   0}, // #556
  { 6,  1,   0}, // #557
  { 7,  1,   0}, // #558
  {15,  1,   0}, // #559
  {16,  1,   0}, // #560
  {28,  2,   0}, // #561
  { 3,  3,   0}, // #562
  { 4,  3,   0}, // #563
  { 5,  3,   0}, // #564
  { 6,  3,   0}, // #565
  { 7,  3,   0}, // #566
  {10,  2,   0}, // #567
  {11,  2,   0}, // #568
  {15,  1,   0}, // #569
  {16,  1,   0}, // #570
  {20,  2,   0}, // #571
  {28,  4,   0}, // #572
  { 3,  3,   0}, // #573
  { 4,  3,   0}, // #574
  { 5,  3,   0}, // #575
  { 6,  3,   0}, // #576
  { 7,  3,   0}, // #577
  {10,  2,   0}, // #578
  {11,  2,   0}, // #579
  {20,  2,   0}, // #580
  {28,  3,   0}, // #581
  { 3,  2,   0}, // #582
  { 4,  2,   0}, // #583
  { 5,  2,   0}, // #584
  { 6,  1,   0}, // #585
  { 7,  1,   0}, // #586
  {10,  2,   0}, // #587
  {11,  2,   0}, // #588
  {20,  1,   0}, // #589
  {28,  2,   0}, // #590
  { 1,  1,   0}, // #591
  { 2,  1,   0}, // #592
  { 3,  2,   0}, // #593
  { 4,  2,   0}, // #594
  { 5,  2,   0}, // #595
  { 6,  2,   0}, // #596
  { 7,  2,   0}, // #597
  { 8,  1,   0}, // #598
  {10,  1,   0}, // #599
  {11,  1,   0}, // #600
  {15,  1,   0}, // #601
  {16,  1,   0}, // #602
  {20,  1,   0}, // #603
  {28,  3,   0}, // #604
  { 1,  1,   0}, // #605
  { 2,  1,   0}, // #606
  { 3,  2,   0}, // #607
  { 4,  2,   0}, // #608
  { 5,  2,   0}, // #609
  { 6,  2,   0}, // #610
  { 7,  2,   0}, // #611
  { 8,  1,   0}, // #612
  {10,  1,   0}, // #613
  {11,  1,   0}, // #614
  {20,  1,   0}, // #615
  {28,  2,   0}, // #616
  { 3,  2,   0}, // #617
  { 4,  2,   0}, // #618
  { 5,  2,   0}, // #619
  { 6,  1,   0}, // #620
  { 7,  1,   0}, // #621
  {10,  2,   0}, // #622
  {11,  2,   0}, // #623
  {15,  1,   0}, // #624
  {16,  1,   0}, // #625
  {20,  1,   0}, // #626
  {28,  3,   0}, // #627
  { 1,  3,   0}, // #628
  { 2,  4,   0}, // #629
  { 3,  6,   0}, // #630
  { 4,  7,   0}, // #631
  { 5,  7,   0}, // #632
  { 6,  4,   0}, // #633
  { 7,  5,   0}, // #634
  { 8,  4,   0}, // #635
  { 9,  1,   0}, // #636
  {10,  2,   0}, // #637
  {11,  2,   0}, // #638
  {15,  1,   0}, // #639
  {16,  1,   0}, // #640
  {20,  1,   0}, // #641
  {28,  8,   0}, // #642
  { 1,  3,   0}, // #643
  { 2,  4,   0}, // #644
  { 3,  7,   0}, // #645
  { 4,  8,   0}, // #646
  { 5,  8,   0}, // #647
  { 6,  4,   0}, // #648
  { 7,  5,   0}, // #649
  { 8,  4,   0}, // #650
  { 9,  1,   0}, // #651
  {10,  2,   0}, // #652
  {11,  2,   0}, // #653
  {20,  1,   0}, // #654
  {28,  8,   0}, // #655
  { 1,  3,   0}, // #656
  { 2,  4,   0}, // #657
  { 3,  7,   0}, // #658
  { 4,  8,   0}, // #659
  { 5,  8,   0}, // #660
  { 6,  4,   0}, // #661
  { 7,  5,   0}, // #662
  { 8,  4,   0}, // #663
  { 9,  1,   0}, // #664
  {10,  2,   0}, // #665
  {11,  2,   0}, // #666
  {15,  1,   0}, // #667
  {16,  1,   0}, // #668
  {20,  1,   0}, // #669
  {28,  9,   0}, // #670
  { 1,  3,   0}, // #671
  { 2,  4,   0}, // #672
  { 3,  8,   0}, // #673
  { 4,  9,   0}, // #674
  { 5,  9,   0}, // #675
  { 6,  4,   0}, // #676
  { 7,  5,   0}, // #677
  { 8,  4,   0}, // #678
  { 9,  1,   0}, // #679
  {10,  2,   0}, // #680
  {11,  2,   0}, // #681
  {20,  1,   0}, // #682
  {28,  9,   0}, // #683
  { 1,  3,   0}, // #684
  { 2,  3,   0}, // #685
  { 3,  3,   0}, // #686
  { 4,  3,   0}, // #687
  { 5,  3,   0}, // #688
  { 6,  3,   0}, // #689
  { 7,  3,   0}, // #690
  { 8,  3,   0}, // #691
  {15,  1,   0}, // #692
  {16,  1,   0}, // #693
  {28,  4,   0}, // #694
  { 1,  3,   0}, // #695
  { 2,  3,   0}, // #696
  { 3,  3,   0}, // #697
  { 4,  3,   0}, // #698
  { 5,  3,   0}, // #699
  { 6,  3,   0}, // #700
  { 7,  3,   0}, // #701
  { 8,  3,   0}, // #702
  {28,  3,   0}, // #703
  { 3,  3,   0}, // #704
  { 4,  3,   0}, // #705
  { 5,  3,   0}, // #706
  {10,  2,   0}, // #707
  {11,  2,   0}, // #708
  {15,  1,   0}, // #709
  {16,  1,   0}, // #710
  {28,  4,   0}, // #711
  { 3,  3,   0}, // #712
  { 4,  3,   0}, // #713
  { 5,  3,   0}, // #714
  {10,  2,   0}, // #715
  {11,  2,   0}, // #716
  {28,  3,   0}, // #717
  { 2,  1,   0}, // #718
  { 3,  2,   0}, // #719
  { 4,  2,   0}, // #720
  { 5,  2,   0}, // #721
  {10,  1,   0}, // #722
  {11,  1,   0}, // #723
  {28,  2,   0}, // #724
  { 4,  4,   0}, // #725
  { 5,  6,   0}, // #726
  { 7,  4,   0}, // #727
  { 8,  4,   0}, // #728
  {28,  6,   0}, // #729
  { 2,  2,   0}, // #730
  { 3,  2,   0}, // #731
  { 4,  5,   0}, // #732
  { 5,  7,   0}, // #733
  { 7,  3,   0}, // #734
  { 8,  3,   0}, // #735
  { 9,  2,   0}, // #736
  {10,  2,   0}, // #737
  {11,  2,   0}, // #738
  {15,  2,   0}, // #739
  {16,  1,   0}, // #740
  {19,  1,   0}, // #741
  {23,  1,   0}, // #742
  {28, 10,   0}, // #743
  { 2,  2,   0}, // #744
  { 3,  2,   0}, // #745
  { 4,  7,   0}, // #746
  { 5,  9,   0}, // #747
  { 7,  5,   0}, // #748
  { 8,  5,   0}, // #749
  { 9,  2,   0}, // #750
  {10,  2,   0}, // #751
  {11,  2,   0}, // #752
  {28,  9,   0}, // #753
  { 4,  2,   0}, // #754
  { 5,  3,   0}, // #755
  { 7,  2,   0}, // #756
  { 8,  2,   0}, // #757
  {28,  3,   0}, // #758
  { 4,  2,   0}, // #759
  { 5,  2,   0}, // #760
  { 7,  2,   0}, // #761
  { 8,  2,   0}, // #762
  {28,  2,   0}, // #763
  { 4,  1,   0}, // #764
  { 5,  1,   0}, // #765
  { 7,  1,   0}, // #766
  { 8,  1,   0}, // #767
  {15,  2,   0}, // #768
  {16,  1,   0}, // #769
  {19,  1,   0}, // #770
  {23,  1,   0}, // #771
  {28,  4,   0}, // #772
  { 4,  2,   0}, // #773
  { 5,  2,   0}, // #774
  { 7,  2,   0}, // #775
  { 8,  2,   0}, // #776
  {15,  2,   0}, // #777
  {16,  1,   0}, // #778
  {19,  1,   0}, // #779
  {23,  1,   0}, // #780
  {28,  5,   0}, // #781
  { 4,  4,   0}, // #782
  { 5,  4,   0}, // #783
  { 7,  4,   0}, // #784
  { 8,  4,   0}, // #785
  {28,  4,   0}, // #786
  { 4,  2,   0}, // #787
  { 5,  2,   0}, // #788
  { 7,  2,   0}, // #789
  { 8,  2,   0}, // #790
  {15,  1,   0}, // #791
  {19,  1,   0}, // #792
  {23,  1,   0}, // #793
  {28,  4,   0}, // #794
  { 2,  1,   0}, // #795
  { 3,  1,   0}, // #796
  { 4,  2,   0}, // #797
  { 5,  3,   0}, // #798
  { 7,  1,   0}, // #799
  { 8,  1,   0}, // #800
  { 9,  1,   0}, // #801
  {10,  1,   0}, // #802
  {11,  1,   0}, // #803
  {15,  2,   0}, // #804
  {16,  1,   0}, // #805
  {19,  1,   0}, // #806
  {23,  1,   0}, // #807
  {28,  6,   0}, // #808
  { 2,  1,   0}, // #809
  { 3,  1,   0}, // #810
  { 4,  1,   0}, // #811
  { 5,  2,   0}, // #812
  { 9,  1,   0}, // #813
  {10,  1,   0}, // #814
  {11,  1,   0}, // #815
  {15,  2,   0}, // #816
  {16,  1,   0}, // #817
  {19,  1,   0}, // #818
  {23,  1,   0}, // #819
  {28,  5,   0}, // #820
  { 1,  1,   0}, // #821
  { 2,  1,   0}, // #822
  { 3,  1,   0}, // #823
  { 4,  1,   0}, // #824
  { 5,  1,   0}, // #825
  { 6,  1,   0}, // #826
  { 7,  1,   0}, // #827
  { 8,  1,   0}, // #828
  {28,  1,   0}, // #829
  {29,  7,   0}, // #830
  { 1,  1,   0}, // #831
  { 2,  1,   0}, // #832
  { 3,  1,   0}, // #833
  { 4,  2,   0}, // #834
  { 5,  2,   0}, // #835
  { 6,  1,   0}, // #836
  { 7,  2,   0}, // #837
  { 8,  2,   0}, // #838
  {15,  1,   0}, // #839
  {19,  1,   0}, // #840
  {23,  1,   0}, // #841
  {28,  4,   0}, // #842
  { 3,  3,   0}, // #843
  { 4,  3,   0}, // #844
  { 5,  3,   0}, // #845
  {15,  1,   0}, // #846
  {16,  1,   0}, // #847
  {28,  4,   0}, // #848
  { 3,  3,   0}, // #849
  { 4,  3,   0}, // #850
  { 5,  3,   0}, // #851
  {28,  3,   0}, // #852
  { 2,  1,   0}, // #853
  { 3,  1,   0}, // #854
  { 4,  1,   0}, // #855
  { 5,  1,   0}, // #856
  {15,  1,   0}, // #857
  {19,  1,   0}, // #858
  {23,  1,   0}, // #859
  {28,  3,   0}, // #860
  { 1,  1,   0}, // #861
  { 2,  1,   0}, // #862
  { 3,  1,   0}, // #863
  { 4,  1,   0}, // #864
  { 5,  1,   0}, // #865
  { 6,  1,   0}, // #866
  { 7,  1,   0}, // #867
  { 8,  1,   0}, // #868
  {15,  1,   0}, // #869
  {19,  1,   0}, // #870
  {23,  1,   0}, // #871
  {28,  3,   0}, // #872
  { 1,  1,   0}, // #873
  { 2,  1,   0}, // #874
  { 3,  2,   0}, // #875
  { 4,  2,   0}, // #876
  { 5,  2,   0}, // #877
  { 6,  1,   0}, // #878
  { 7,  1,   0}, // #879
  { 8,  1,   0}, // #880
  {28,  2,   0}, // #881
  { 1,  2,   0}, // #882
  { 2,  3,   0}, // #883
  { 3,  7,   0}, // #884
  { 4, 15,   0}, // #885
  { 5, 15,   0}, // #886
  { 6,  6,   0}, // #887
  { 7, 10,   0}, // #888
  { 8,  6,   0}, // #889
  { 9,  1,   0}, // #890
  {10,  3,   0}, // #891
  {11,  3,   0}, // #892
  {20,  2,   0}, // #893
  {21,  4,   0}, // #894
  {28, 15,   0}, // #895
  { 2,  1,   0}, // #896
  { 3,  3,   0}, // #897
  { 4,  3,   0}, // #898
  { 5,  3,   0}, // #899
  { 6,  2,   0}, // #900
  { 7,  2,   0}, // #901
  {10,  2,   0}, // #902
  {11,  2,   0}, // #903
  {20,  2,   0}, // #904
  {28,  3,   0}, // #905
  { 1,  1,   0}, // #906
  { 2,  2,   0}, // #907
  { 3,  3,   0}, // #908
  { 4,  3,   0}, // #909
  { 5,  3,   0}, // #910
  { 6,  2,   0}, // #911
  { 7,  2,   0}, // #912
  { 8,  1,   0}, // #913
  {10,  1,   0}, // #914
  {11,  1,   0}, // #915
  {20,  1,   0}, // #916
  {28,  3,   0}, // #917
  {14,  1,   0}, // #918
  {15,  1,   0}, // #919
  {18,  1,   0}, // #920
  {19,  1,   0}, // #921
  {28,  2,   0}, // #922
  { 5,  4,   0}, // #923
  {15,  2,   0}, // #924
  {16,  1,   0}, // #925
  {19,  1,   0}, // #926
  {23,  1,   0}, // #927
  {28,  7,   0}, // #928
  { 4,  1,   0}, // #929
  { 5,  6,   0}, // #930
  { 7,  1,   0}, // #931
  { 8,  1,   0}, // #932
  {15,  2,   0}, // #933
  {16,  1,   0}, // #934
  {19,  1,   0}, // #935
  {23,  1,   0}, // #936
  {28,  9,   0}, // #937
  { 4,  2,   0}, // #938
  { 5,  2,   0}, // #939
  { 7,  1,   0}, // #940
  { 8,  1,   0}, // #941
  {28,  2,   0}, // #942
  {13,  1,   0}, // #943
  {14,  1,   0}, // #944
  {15,  1,   0}, // #945
  {16,  1,   0}, // #946
  {28,  1,   0}, // #947
  { 1,  1,   0}, // #948
  { 2,  1,   0}, // #949
  { 3,  2,   0}, // #950
  { 4,  2,   0}, // #951
  { 5,  2,   0}, // #952
  { 6,  2,   0}, // #953
  { 7,  2,   0}, // #954
  { 8,  1,   0}, // #955
  {13,  1,   0}, // #956
  {14,  1,   0}, // #957
  {15,  1,   0}, // #958
  {16,  1,   0}, // #959
  {28,  3,   0}, // #960
  { 3,  1,   0}, // #961
  { 4,  1,   0}, // #962
  { 5,  1,   0}, // #963
  { 6,  1,   0}, // #964
  { 7,  1,   0}, // #965
  {10,  1,   0}, // #966
  {11,  1,   0}, // #967
  {14,  1,   0}, // #968
  {15,  1,   0}, // #969
  {18,  1,   0}, // #970
  {19,  1,   0}, // #971
  {20,  1,   0}, // #972
  {28,  3,   0}, // #973
  { 2,  1,   0}, // #974
  { 3,  1,   0}, // #975
  { 4,  7,   0}, // #976
  { 5, 11,   0}, // #977
  { 7,  6,   0}, // #978
  { 8,  6,   0}, // #979
  { 9,  1,   0}, // #980
  {10,  1,   0}, // #981
  {11,  1,   0}, // #982
  {28, 11,   0}, // #983
  { 4,  1,   0}, // #984
  { 5,  1,   0}, // #985
  { 7,  1,   0}, // #986
  { 8,  1,   0}, // #987
  {14,  1,   0}, // #988
  {15,  1,   0}, // #989
  {18,  1,   0}, // #990
  {19,  1,   0}, // #991
  {21,  1,   0}, // #992
  {28,  3,   0}, // #993
  { 3,  1,   0}, // #994
  { 4,  2,   0}, // #995
  { 5,  2,   0}, // #996
  { 6,  1,   0}, // #997
  { 7,  2,   0}, // #998
  { 8,  1,   0}, // #999
  {10,  1,   0}, // #1000
  {11,  1,   0}, // #1001
  {20,  1,   0}, // #1002
  {28,  2,   0}, // #1003
  { 2,  2,   0}, // #1004
  { 3,  2,   0}, // #1005
  { 4,  9,   0}, // #1006
  { 5, 13,   0}, // #1007
  { 7,  7,   0}, // #1008
  { 8,  7,   0}, // #1009
  { 9,  2,   0}, // #1010
  {10,  2,   0}, // #1011
  {11,  2,   0}, // #1012
  {15,  2,   0}, // #1013
  {16,  1,   0}, // #1014
  {19,  1,   0}, // #1015
  {23,  1,   0}, // #1016
  {28, 16,   0}, // #1017
  { 2,  1,   0}, // #1018
  { 3,  1,   0}, // #1019
  { 4,  5,   0}, // #1020
  { 5,  7,   0}, // #1021
  { 7,  4,   0}, // #1022
  { 8,  4,   0}, // #1023
  { 9,  1,   0}, // #1024
  {10,  1,   0}, // #1025
  {11,  1,   0}, // #1026
  {28,  7,   0}, // #1027
  { 1,  2,   0}, // #1028
  { 2,  2,   0}, // #1029
  { 3,  6,   0}, // #1030
  { 4, 12,   0}, // #1031
  { 5, 19,   0}, // #1032
  { 6,  4,   0}, // #1033
  { 7, 10,   0}, // #1034
  { 8,  8,   0}, // #1035
  {10,  4,   0}, // #1036
  {11,  4,   0}, // #1037
  {15,  2,   0}, // #1038
  {16,  1,   0}, // #1039
  {19,  1,   0}, // #1040
  {20,  2,   0}, // #1041
  {23,  1,   0}, // #1042
  {28, 22,   0}, // #1043
  { 4,  4,   0}, // #1044
  { 5,  4,   0}, // #1045
  {28,  4,   0}, // #1046
  { 1,  2,   0}, // #1047
  { 2,  8,   0}, // #1048
  { 3, 12,   0}, // #1049
  { 4, 21,   0}, // #1050
  { 5, 21,   0}, // #1051
  { 6,  5,   0}, // #1052
  { 7, 14,   0}, // #1053
  { 8,  9,   0}, // #1054
  { 9,  4,   0}, // #1055
  {10,  7,   0}, // #1056
  {11,  7,   0}, // #1057
  {20,  3,   0}, // #1058
  {28, 21,   0}, // #1059
  { 1,  2,   0}, // #1060
  { 2,  4,   0}, // #1061
  { 3, 13,   0}, // #1062
  { 4, 34,   0}, // #1063
  { 5, 34,   0}, // #1064
  { 6, 11,   0}, // #1065
  { 7, 32,   0}, // #1066
  { 8, 23,   0}, // #1067
  { 9,  2,   0}, // #1068
  {10, 11,   0}, // #1069
  {11, 11,   0}, // #1070
  {15, 19,   0}, // #1071
  {16, 14,   0}, // #1072
  {19,  4,   0}, // #1073
  {20,  9,   0}, // #1074
  {23,  5,   0}, // #1075
  {28, 57,   0}, // #1076
  { 2,  1,   0}, // #1077
  { 3,  1,   0}, // #1078
  { 4,  3,   0}, // #1079
  { 5,  9,   0}, // #1080
  { 7,  2,   0}, // #1081
  { 8,  2,   0}, // #1082
  { 9,  1,   0}, // #1083
  {10,  1,   0}, // #1084
  {11,  1,   0}, // #1085
  {15,  1,   0}, // #1086
  {16,  1,   0}, // #1087
  {28, 10,   0}, // #1088
  { 3,  1,   0}, // #1089
  { 4, 10,   0}, // #1090
  { 5, 10,   0}, // #1091
  { 6,  1,   0}, // #1092
  { 7,  3,   0}, // #1093
  { 8,  2,   0}, // #1094
  {10,  1,   0}, // #1095
  {11,  1,   0}, // #1096
  {20,  1,   0}, // #1097
  {21,  2,   0}, // #1098
  {28, 10,   0}, // #1099
  { 1,  7,   0}, // #1100
  { 2, 24,   0}, // #1101
  { 3, 44,   0}, // #1102
  { 4, 70,   0}, // #1103
  { 5, 75,   0}, // #1104
  { 6, 26,   0}, // #1105
  { 7, 52,   0}, // #1106
  { 8, 32,   0}, // #1107
  { 9, 17,   0}, // #1108
  {10, 36,   0}, // #1109
  {11, 37,   0}, // #1110
  {15, 10,   0}, // #1111
  {16,  9,   0}, // #1112
  {19,  1,   0}, // #1113
  {20, 19,   0}, // #1114
  {23,  1,   0}, // #1115
  {28, 86,   0}, // #1116
  { 3,  9,   0}, // #1117
  { 4, 15,   0}, // #1118
  { 5, 15,   0}, // #1119
  { 6,  9,   0}, // #1120
  { 7,  9,   0}, // #1121
  {10,  6,   0}, // #1122
  {11,  6,   0}, // #1123
  {20,  6,   0}, // #1124
  {28, 15,   0}, // #1125
  { 1,  5,   0}, // #1126
  { 2, 20,   0}, // #1127
  { 3, 35,   0}, // #1128
  { 4, 61,   0}, // #1129
  { 5, 66,   0}, // #1130
  { 6, 20,   0}, // #1131
  { 7, 46,   0}, // #1132
  { 8, 31,   0}, // #1133
  { 9, 15,   0}, // #1134
  {10, 30,   0}, // #1135
  {11, 30,   0}, // #1136
  {15,  6,   0}, // #1137
  {16,  5,   0}, // #1138
  {19,  1,   0}, // #1139
  {20, 15,   0}, // #1140
  {23,  1,   0}, // #1141
  {28, 73,   0}, // #1142
  { 1,  5,   0}, // #1143
  { 2, 20,   0}, // #1144
  { 3, 36,   0}, // #1145
  { 4, 61,   0}, // #1146
  { 5, 66,   0}, // #1147
  { 6, 21,   0}, // #1148
  { 7, 46,   0}, // #1149
  { 8, 30,   0}, // #1150
  { 9, 15,   0}, // #1151
  {10, 30,   0}, // #1152
  {11, 30,   0}, // #1153
  {15,  6,   0}, // #1154
  {16,  5,   0}, // #1155
  {19,  1,   0}, // #1156
  {20, 15,   0}, // #1157
  {23,  1,   0}, // #1158
  {28, 73,   0}, // #1159
  { 1,  6,   0}, // #1160
  { 2, 23,   0}, // #1161
  { 3, 41,   0}, // #1162
  { 4, 68,   0}, // #1163
  { 5, 73,   0}, // #1164
  { 6, 24,   0}, // #1165
  { 7, 51,   0}, // #1166
  { 8, 33,   0}, // #1167
  { 9, 16,   0}, // #1168
  {10, 34,   0}, // #1169
  {11, 34,   0}, // #1170
  {15,  9,   0}, // #1171
  {16,  8,   0}, // #1172
  {19,  1,   0}, // #1173
  {20, 18,   0}, // #1174
  {23,  1,   0}, // #1175
  {28, 83,   0}, // #1176
  { 2,  9,   0}, // #1177
  { 3, 23,   0}, // #1178
  { 4, 53,   0}, // #1179
  { 5, 54,   0}, // #1180
  { 6,  3,   0}, // #1181
  { 7, 33,   0}, // #1182
  { 8, 20,   0}, // #1183
  { 9,  8,   0}, // #1184
  {10, 15,   0}, // #1185
  {11, 16,   0}, // #1186
  {20,  2,   0}, // #1187
  {28, 54,   0}, // #1188
  { 1,  7,   0}, // #1189
  { 2, 26,   0}, // #1190
  { 3, 46,   0}, // #1191
  { 4, 71,   0}, // #1192
  { 5, 79,   0}, // #1193
  { 6, 27,   0}, // #1194
  { 7, 52,   0}, // #1195
  { 8, 32,   0}, // #1196
  { 9, 19,   0}, // #1197
  {10, 39,   0}, // #1198
  {11, 41,   0}, // #1199
  {15,  8,   0}, // #1200
  {16,  8,   0}, // #1201
  {20, 20,   0}, // #1202
  {28, 87,   0}, // #1203
  { 1,  7,   0}, // #1204
  { 2, 26,   0}, // #1205
  { 3, 46,   0}, // #1206
  { 4, 71,   0}, // #1207
  { 5, 79,   0}, // #1208
  { 6, 27,   0}, // #1209
  { 7, 52,   0}, // #1210
  { 8, 32,   0}, // #1211
  { 9, 19,   0}, // #1212
  {10, 39,   0}, // #1213
  {11, 41,   0}, // #1214
  {15,  7,   0}, // #1215
  {16,  7,   0}, // #1216
  {20, 20,   0}, // #1217
  {28, 86,   0}, // #1218
  { 1,  2,   0}, // #1219
  { 2,  9,   0}, // #1220
  { 3, 14,   0}, // #1221
  { 4, 24,   0}, // #1222
  { 5, 24,   0}, // #1223
  { 6,  7,   0}, // #1224
  { 7, 17,   0}, // #1225
  { 8, 12,   0}, // #1226
  { 9,  6,   0}, // #1227
  {10, 11,   0}, // #1228
  {11, 11,   0}, // #1229
  {15,  1,   0}, // #1230
  {19,  1,   0}, // #1231
  {20,  5,   0}, // #1232
  {23,  1,   0}, // #1233
  {28, 26,   0}, // #1234
  { 1,  2,   0}, // #1235
  { 2, 12,   0}, // #1236
  { 3, 17,   0}, // #1237
  { 4, 27,   0}, // #1238
  { 5, 32,   0}, // #1239
  { 6,  7,   0}, // #1240
  { 7, 17,   0}, // #1241
  { 8, 12,   0}, // #1242
  { 9, 10,   0}, // #1243
  {10, 15,   0}, // #1244
  {11, 15,   0}, // #1245
  {15, 40,   0}, // #1246
  {16,  2,   0}, // #1247
  {19, 38,   0}, // #1248
  {20,  5,   0}, // #1249
  {23, 38,   0}, // #1250
  {28, 110,   0}, // #1251
  { 1,  4,   0}, // #1252
  { 2,  4,   0}, // #1253
  { 3,  6,   0}, // #1254
  { 4, 57,   0}, // #1255
  { 5, 57,   0}, // #1256
  { 6,  5,   0}, // #1257
  { 7,  9,   0}, // #1258
  { 8,  8,   0}, // #1259
  {10,  1,   0}, // #1260
  {11,  1,   0}, // #1261
  {13, 33,   0}, // #1262
  {14, 33,   0}, // #1263
  {15, 33,   0}, // #1264
  {16, 33,   0}, // #1265
  {21,  2,   0}, // #1266
  {28, 90,   0}, // #1267
  { 1,  8,   0}, // #1268
  { 2, 35,   0}, // #1269
  { 3, 79,   0}, // #1270
  { 4, 142,   0}, // #1271
  { 5, 142,   0}, // #1272
  { 6, 37,   0}, // #1273
  { 7, 100,   0}, // #1274
  { 8, 71,   0}, // #1275
  { 9, 21,   0}, // #1276
  {10, 46,   0}, // #1277
  {11, 46,   0}, // #1278
  {15,  1,   0}, // #1279
  {19,  1,   0}, // #1280
  {20, 10,   0}, // #1281
  {23,  1,   0}, // #1282
  {28, 144,   0}, // #1283
  { 1,  1,   0}, // #1284
  { 2,  1,   0}, // #1285
  { 3,  1,   0}, // #1286
  { 4,  2,   0}, // #1287
  { 5,  2,   0}, // #1288
  { 6,  1,   0}, // #1289
  { 7,  1,   0}, // #1290
  { 8,  1,   0}, // #1291
  {28,  2,   0}, // #1292
  { 3,  2,   0}, // #1293
  { 4,  2,   0}, // #1294
  { 5,  2,   0}, // #1295
  { 6,  1,   0}, // #1296
  { 7,  1,   0}, // #1297
  {28,  2,   0}, // #1298
  { 2,  1,   0}, // #1299
  { 3,  1,   0}, // #1300
  { 4,  1,   0}, // #1301
  { 5,  1,   0}, // #1302
  { 9,  1,   0}, // #1303
  {10,  1,   0}, // #1304
  {11,  1,   0}, // #1305
  {15,  1,   0}, // #1306
  {19,  1,   0}, // #1307
  {23,  1,   0}, // #1308
  {28,  3,   0}, // #1309
  { 2,  1,   0}, // #1310
  { 3,  1,   0}, // #1311
  { 4,  3,   0}, // #1312
  { 5,  3,   0}, // #1313
  { 7,  2,   0}, // #1314
  { 8,  2,   0}, // #1315
  { 9,  1,   0}, // #1316
  {10,  1,   0}, // #1317
  {11,  1,   0}, // #1318
  {28,  3,   0}, // #1319
  { 3,  1,   0}, // #1320
  { 4,  1,   0}, // #1321
  { 5,  1,   0}, // #1322
  { 6,  1,   0}, // #1323
  { 7,  1,   0}, // #1324
  {10,  1,   0}, // #1325
  {11,  1,   0}, // #1326
  {15,  1,   0}, // #1327
  {19,  1,   0}, // #1328
  {20,  1,   0}, // #1329
  {23,  1,   0}, // #1330
  {28,  3,   0}, // #1331
  { 5,  2,   0}, // #1332
  {15,  1,   0}, // #1333
  {19,  1,   0}, // #1334
  {23,  1,   0}, // #1335
  {28,  4,   0}, // #1336
  { 2,  1,   0}, // #1337
  { 3,  1,   0}, // #1338
  { 4,  2,   0}, // #1339
  { 5,  2,   0}, // #1340
  { 7,  1,   0}, // #1341
  { 8,  1,   0}, // #1342
  { 9,  1,   0}, // #1343
  {10,  1,   0}, // #1344
  {11,  1,   0}, // #1345
  {15,  1,   0}, // #1346
  {19,  1,   0}, // #1347
  {23,  1,   0}, // #1348
  {28,  4,   0}, // #1349
  { 1,  5,   0}, // #1350
  { 2, 13,   0}, // #1351
  { 3, 13,   0}, // #1352
  { 4, 13,   0}, // #1353
  { 5, 13,   0}, // #1354
  { 6,  5,   0}, // #1355
  { 7,  5,   0}, // #1356
  { 8,  5,   0}, // #1357
  { 9,  8,   0}, // #1358
  {10,  8,   0}, // #1359
  {11,  8,   0}, // #1360
  {15, 21,   0}, // #1361
  {16, 21,   0}, // #1362
  {28, 34,   0}, // #1363
  { 4,  1,   0}, // #1364
  { 5,  1,   0}, // #1365
  { 7,  1,   0}, // #1366
  { 8,  1,   0}, // #1367
  {13,  1,   0}, // #1368
  {14,  1,   0}, // #1369
  {15,  1,   0}, // #1370
  {16,  1,   0}, // #1371
  {21,  1,   0}, // #1372
  {28,  2,   0}, // #1373
  { 1,  1,   0}, // #1374
  { 2,  1,   0}, // #1375
  { 3,  1,   0}, // #1376
  { 4,  1,   0}, // #1377
  { 5,  1,   0}, // #1378
  { 6,  1,   0}, // #1379
  { 7,  1,   0}, // #1380
  { 8,  1,   0}, // #1381
  {14,  1,   0}, // #1382
  {15,  1,   0}, // #1383
  {18,  1,   0}, // #1384
  {19,  1,   0}, // #1385
  {28,  3,   0}, // #1386
  { 5,  5,   0}, // #1387
  {15,  2,   0}, // #1388
  {16,  2,   0}, // #1389
  {28,  7,   0}, // #1390
  { 5,  2,   0}, // #1391
  {15,  2,   0}, // #1392
  {16,  1,   0}, // #1393
  {19,  1,   0}, // #1394
  {23,  1,   0}, // #1395
  {28,  5,   0}, // #1396
  { 4,  2,   0}, // #1397
  { 5,  2,   0}, // #1398
  { 7,  1,   0}, // #1399
  { 8,  1,   0}, // #1400
  {13,  1,   0}, // #1401
  {14,  2,   0}, // #1402
  {15,  2,   0}, // #1403
  {16,  1,   0}, // #1404
  {18,  1,   0}, // #1405
  {19,  1,   0}, // #1406
  {21,  1,   0}, // #1407
  {28,  5,   0}, // #1408
  { 4,  1,   0}, // #1409
  { 5,  3,   0}, // #1410
  { 7,  1,   0}, // #1411
  { 8,  1,   0}, // #1412
  {15,  2,   0}, // #1413
  {16,  1,   0}, // #1414
  {19,  1,   0}, // #1415
  {23,  1,   0}, // #1416
  {28,  6,   0}, // #1417
  { 3,  2,   0}, // #1418
  { 4,  2,   0}, // #1419
  { 5,  2,   0}, // #1420
  { 6,  2,   0}, // #1421
  { 7,  2,   0}, // #1422
  {10,  2,   0}, // #1423
  {11,  2,   0}, // #1424
  {13,  1,   0}, // #1425
  {14,  1,   0}, // #1426
  {15,  1,   0}, // #1427
  {16,  1,   0}, // #1428
  {20,  2,   0}, // #1429
  {28,  3,   0}, // #1430
  { 1,  1,   0}, // #1431
  { 2,  1,   0}, // #1432
  { 3,  1,   0}, // #1433
  { 4,  1,   0}, // #1434
  { 5,  1,   0}, // #1435
  { 6,  1,   0}, // #1436
  { 7,  1,   0}, // #1437
  { 8,  1,   0}, // #1438
  {13,  1,   0}, // #1439
  {14,  1,   0}, // #1440
  {15,  1,   0}, // #1441
  {16,  1,   0}, // #1442
  {28,  2,   0}, // #1443
  { 1,  1,   0}, // #1444
  { 2,  1,   0}, // #1445
  { 3,  2,   0}, // #1446
  { 4,  2,   0}, // #1447
  { 5,  2,   0}, // #1448
  { 6,  2,   0}, // #1449
  { 7,  2,   0}, // #1450
  { 8,  1,   0}, // #1451
  {10,  1,   0}, // #1452
  {11,  1,   0}, // #1453
  {13,  1,   0}, // #1454
  {14,  1,   0}, // #1455
  {15,  1,   0}, // #1456
  {16,  1,   0}, // #1457
  {20,  1,   0}, // #1458
  {28,  3,   0}, // #1459
  { 2,  3,   0}, // #1460
  { 3,  4,   0}, // #1461
  { 4,  7,   0}, // #1462
  { 5, 10,   0}, // #1463
  { 7,  3,   0}, // #1464
  { 8,  3,   0}, // #1465
  { 9,  3,   0}, // #1466
  {10,  3,   0}, // #1467
  {11,  4,   0}, // #1468
  {28, 10,   0}, // #1469
  { 4,  2,   0}, // #1470
  { 5,  2,   0}, // #1471
  { 7,  2,   0}, // #1472
  { 8,  2,   0}, // #1473
  {15,  1,   0}, // #1474
  {16,  1,   0}, // #1475
  {28,  3,   0}, // #1476
  { 2,  2,   0}, // #1477
  { 3,  3,   0}, // #1478
  { 4,  9,   0}, // #1479
  { 5, 18,   0}, // #1480
  { 6,  1,   0}, // #1481
  { 7,  7,   0}, // #1482
  { 8,  6,   0}, // #1483
  { 9,  2,   0}, // #1484
  {10,  3,   0}, // #1485
  {11,  3,   0}, // #1486
  {20,  1,   0}, // #1487
  {28, 18,   0}, // #1488
  { 1,  2,   0}, // #1489
  { 2,  9,   0}, // #1490
  { 3, 14,   0}, // #1491
  { 4, 21,   0}, // #1492
  { 5, 24,   0}, // #1493
  { 6,  4,   0}, // #1494
  { 7, 11,   0}, // #1495
  { 8,  7,   0}, // #1496
  { 9,  7,   0}, // #1497
  {10, 12,   0}, // #1498
  {11, 12,   0}, // #1499
  {15,  1,   0}, // #1500
  {16,  1,   0}, // #1501
  {20,  2,   0}, // #1502
  {28, 25,   0}, // #1503
  { 2,  2,   0}, // #1504
  { 3,  2,   0}, // #1505
  { 4,  2,   0}, // #1506
  { 5,  3,   0}, // #1507
  { 9,  2,   0}, // #1508
  {10,  2,   0}, // #1509
  {11,  2,   0}, // #1510
  {15,  2,   0}, // #1511
  {19,  2,   0}, // #1512
  {23,  2,   0}, // #1513
  {28,  7,   0}, // #1514
  { 4,  1,   0}, // #1515
  { 5,  1,   0}, // #1516
  { 7,  1,   0}, // #1517
  { 8,  1,   0}, // #1518
  {15,  1,   0}, // #1519
  {19,  1,   0}, // #1520
  {23,  1,   0}, // #1521
  {28,  3,   0}, // #1522
  { 2,  5,   0}, // #1523
  { 3,  5,   0}, // #1524
  { 4, 16,   0}, // #1525
  { 5, 23,   0}, // #1526
  { 7, 11,   0}, // #1527
  { 8,  8,   0}, // #1528
  { 9,  5,   0}, // #1529
  {10,  5,   0}, // #1530
  {11,  5,   0}, // #1531
  {28, 23,   0}, // #1532
  { 3,  2,   0}, // #1533
  { 4,  2,   0}, // #1534
  { 5,  2,   0}, // #1535
  { 6,  2,   0}, // #1536
  { 7,  2,   0}, // #1537
  {10,  2,   0}, // #1538
  {11,  2,   0}, // #1539
  {15,  1,   0}, // #1540
  {16,  1,   0}, // #1541
  {20,  2,   0}, // #1542
  {28,  3,   0}, // #1543
  { 3,  2,   0}, // #1544
  { 4,  2,   0}, // #1545
  { 5,  2,   0}, // #1546
  { 6,  2,   0}, // #1547
  { 7,  2,   0}, // #1548
  {10,  2,   0}, // #1549
  {11,  2,   0}, // #1550
  {20,  2,   0}, // #1551
  {28,  2,   0}, // #1552
  { 1,  1,   0}, // #1553
  { 2,  6,   0}, // #1554
  { 3,  8,   0}, // #1555
  { 4, 17,   0}, // #1556
  { 5, 20,   0}, // #1557
  { 6,  2,   0}, // #1558
  { 7, 11,   0}, // #1559
  { 8,  9,   0}, // #1560
  { 9,  5,   0}, // #1561
  {10,  7,   0}, // #1562
  {11,  7,   0}, // #1563
  {15,  2,   0}, // #1564
  {16,  2,   0}, // #1565
  {20,  1,   0}, // #1566
  {28, 22,   0}, // #1567
  { 1,  1,   0}, // #1568
  { 2,  4,   0}, // #1569
  { 3,  5,   0}, // #1570
  { 4, 10,   0}, // #1571
  { 5, 10,   0}, // #1572
  { 6,  2,   0}, // #1573
  { 7,  7,   0}, // #1574
  { 8,  6,   0}, // #1575
  { 9,  3,   0}, // #1576
  {10,  4,   0}, // #1577
  {11,  4,   0}, // #1578
  {15,  3,   0}, // #1579
  {16,  3,   0}, // #1580
  {20,  1,   0}, // #1581
  {28, 13,   0}, // #1582
  { 2,  8,   0}, // #1583
  { 3, 14,   0}, // #1584
  { 4, 30,   0}, // #1585
  { 5, 54,   0}, // #1586
  { 6,  2,   0}, // #1587
  { 7, 18,   0}, // #1588
  { 8, 14,   0}, // #1589
  { 9,  8,   0}, // #1590
  {10, 10,   0}, // #1591
  {11, 11,   0}, // #1592
  {20,  2,   0}, // #1593
  {28, 54,   0}, // #1594
  { 2,  3,   0}, // #1595
  { 3,  3,   0}, // #1596
  { 4,  7,   0}, // #1597
  { 5, 10,   0}, // #1598
  { 7,  4,   0}, // #1599
  { 8,  4,   0}, // #1600
  { 9,  3,   0}, // #1601
  {10,  3,   0}, // #1602
  {11,  3,   0}, // #1603
  {28, 10,   0}, // #1604
  { 2,  3,   0}, // #1605
  { 3,  4,   0}, // #1606
  { 4, 10,   0}, // #1607
  { 5, 15,   0}, // #1608
  { 6,  1,   0}, // #1609
  { 7,  7,   0}, // #1610
  { 8,  6,   0}, // #1611
  { 9,  3,   0}, // #1612
  {10,  4,   0}, // #1613
  {11,  4,   0}, // #1614
  {20,  1,   0}, // #1615
  {28, 15,   0}, // #1616
  { 2,  1,   0}, // #1617
  { 3,  1,   0}, // #1618
  { 4, 30,   0}, // #1619
  { 5, 30,   0}, // #1620
  { 7,  8,   0}, // #1621
  { 8,  8,   0}, // #1622
  { 9,  1,   0}, // #1623
  {10,  1,   0}, // #1624
  {11,  1,   0}, // #1625
  {13,  1,   0}, // #1626
  {14,  1,   0}, // #1627
  {15,  1,   0}, // #1628
  {16,  1,   0}, // #1629
  {21,  8,   0}, // #1630
  {28, 31,   0}, // #1631
  { 2, 35,   0}, // #1632
  { 3, 90,   0}, // #1633
  { 4, 134,   0}, // #1634
  { 5, 134,   0}, // #1635
  { 6, 34,   0}, // #1636
  { 7, 78,   0}, // #1637
  { 8, 44,   0}, // #1638
  { 9, 21,   0}, // #1639
  {10, 51,   0}, // #1640
  {11, 51,   0}, // #1641
  {15,  5,   0}, // #1642
  {16,  4,   0}, // #1643
  {19,  1,   0}, // #1644
  {20,  9,   0}, // #1645
  {23,  1,   0}, // #1646
  {28, 140,   0}, // #1647
  { 2, 52,   0}, // #1648
  { 3, 97,   0}, // #1649
  { 4, 150,   0}, // #1650
  { 5, 150,   0}, // #1651
  { 6, 45,   0}, // #1652
  { 7, 98,   0}, // #1653
  { 8, 53,   0}, // #1654
  { 9, 27,   0}, // #1655
  {10, 37,   0}, // #1656
  {11, 37,   0}, // #1657
  {15,  5,   0}, // #1658
  {16,  4,   0}, // #1659
  {19,  1,   0}, // #1660
  {20, 10,   0}, // #1661
  {23,  1,   0}, // #1662
  {28, 156,   0}, // #1663
  { 2,  1,   0}, // #1664
  { 3,  4,   0}, // #1665
  { 4, 15,   0}, // #1666
  { 5, 15,   0}, // #1667
  { 6,  2,   0}, // #1668
  { 7,  5,   0}, // #1669
  { 8,  3,   0}, // #1670
  { 9,  1,   0}, // #1671
  {10,  4,   0}, // #1672
  {11,  4,   0}, // #1673
  {13,  1,   0}, // #1674
  {14,  2,   0}, // #1675
  {15,  2,   0}, // #1676
  {16,  1,   0}, // #1677
  {18,  1,   0}, // #1678
  {19,  1,   0}, // #1679
  {20,  2,   0}, // #1680
  {21,  3,   0}, // #1681
  {28, 18,   0}, // #1682
  { 1,  2,   0}, // #1683
  { 2,  2,   0}, // #1684
  { 3,  7,   0}, // #1685
  { 4, 56,   0}, // #1686
  { 5, 56,   0}, // #1687
  { 6,  7,   0}, // #1688
  { 7, 17,   0}, // #1689
  { 8, 12,   0}, // #1690
  {13,  8,   0}, // #1691
  {14,  8,   0}, // #1692
  {15,  8,   0}, // #1693
  {16,  8,   0}, // #1694
  {28, 64,   0}, // #1695
  { 1,  4,   0}, // #1696
  { 2,  4,   0}, // #1697
  { 3,  6,   0}, // #1698
  { 4, 57,   0}, // #1699
  { 5, 57,   0}, // #1700
  { 6,  5,   0}, // #1701
  { 7, 11,   0}, // #1702
  { 8, 10,   0}, // #1703
  {10,  1,   0}, // #1704
  {11,  1,   0}, // #1705
  {13, 31,   0}, // #1706
  {14, 31,   0}, // #1707
  {15, 31,   0}, // #1708
  {16, 31,   0}, // #1709
  {21,  4,   0}, // #1710
  {28, 88,   0}, // #1711
  { 1,  9,   0}, // #1712
  { 2, 10,   0}, // #1713
  { 3, 26,   0}, // #1714
  { 4, 78,   0}, // #1715
  { 5, 78,   0}, // #1716
  { 6, 25,   0}, // #1717
  { 7, 47,   0}, // #1718
  { 8, 31,   0}, // #1719
  { 9,  1,   0}, // #1720
  {10, 17,   0}, // #1721
  {11, 17,   0}, // #1722
  {14, 11,   0}, // #1723
  {15, 11,   0}, // #1724
  {18, 11,   0}, // #1725
  {19, 11,   0}, // #1726
  {20, 16,   0}, // #1727
  {21,  1,   0}, // #1728
  {28, 100,   0}, // #1729
  { 1,  1,   0}, // #1730
  { 2,  1,   0}, // #1731
  { 3,  3,   0}, // #1732
  { 4,  3,   0}, // #1733
  { 5,  3,   0}, // #1734
  { 6,  1,   0}, // #1735
  { 7,  1,   0}, // #1736
  { 8,  1,   0}, // #1737
  {10,  1,   0}, // #1738
  {11,  1,   0}, // #1739
  {15,  2,   0}, // #1740
  {16,  2,   0}, // #1741
  {28,  5,   0}, // #1742
  { 1,  1,   0}, // #1743
  { 2,  1,   0}, // #1744
  { 3,  4,   0}, // #1745
  { 4,  4,   0}, // #1746
  { 5,  4,   0}, // #1747
  { 6,  1,   0}, // #1748
  { 7,  1,   0}, // #1749
  { 8,  1,   0}, // #1750
  {10,  2,   0}, // #1751
  {11,  2,   0}, // #1752
  {15,  4,   0}, // #1753
  {16,  4,   0}, // #1754
  {28,  8,   0}, // #1755
  { 1,  1,   0}, // #1756
  { 2,  1,   0}, // #1757
  { 3,  4,   0}, // #1758
  { 4,  4,   0}, // #1759
  { 5,  4,   0}, // #1760
  { 6,  1,   0}, // #1761
  { 7,  1,   0}, // #1762
  { 8,  1,   0}, // #1763
  {10,  2,   0}, // #1764
  {11,  2,   0}, // #1765
  {15,  8,   0}, // #1766
  {16,  8,   0}, // #1767
  {28, 12,   0}, // #1768
  { 4,  2,   0}, // #1769
  { 5,  2,   0}, // #1770
  { 7,  1,   0}, // #1771
  { 8,  1,   0}, // #1772
  {13,  1,   0}, // #1773
  {14,  1,   0}, // #1774
  {15,  1,   0}, // #1775
  {16,  1,   0}, // #1776
  {21,  1,   0}, // #1777
  {28,  3,   0}, // #1778
  { 2,  1,   0}, // #1779
  { 3,  1,   0}, // #1780
  { 4,  3,   0}, // #1781
  { 5,  3,   0}, // #1782
  { 7,  2,   0}, // #1783
  { 8,  2,   0}, // #1784
  { 9,  1,   0}, // #1785
  {10,  1,   0}, // #1786
  {11,  1,   0}, // #1787
  {15,  1,   0}, // #1788
  {16,  1,   0}, // #1789
  {28,  4,   0}, // #1790
  { 1,  2,   0}, // #1791
  { 2,  2,   0}, // #1792
  { 3,  2,   0}, // #1793
  { 4,  2,   0}, // #1794
  { 5,  2,   0}, // #1795
  { 6,  2,   0}, // #1796
  { 7,  2,   0}, // #1797
  { 8,  2,   0}, // #1798
  {15,  1,   0}, // #1799
  {19,  1,   0}, // #1800
  {23,  1,   0}, // #1801
  {28,  4,   0}, // #1802
  { 2,  3,   0}, // #1803
  { 3,  6,   0}, // #1804
  { 4,  7,   0}, // #1805
  { 5,  7,   0}, // #1806
  { 6,  1,   0}, // #1807
  { 7,  2,   0}, // #1808
  { 8,  1,   0}, // #1809
  {10,  1,   0}, // #1810
  {11,  1,   0}, // #1811
  {20,  1,   0}, // #1812
  {28,  7,   0}, // #1813
  { 2,  3,   0}, // #1814
  { 3,  6,   0}, // #1815
  { 4,  7,   0}, // #1816
  { 5,  7,   0}, // #1817
  { 6,  1,   0}, // #1818
  { 7,  2,   0}, // #1819
  { 8,  1,   0}, // #1820
  {10,  1,   0}, // #1821
  {11,  1,   0}, // #1822
  {15,  1,   0}, // #1823
  {16,  1,   0}, // #1824
  {20,  1,   0}, // #1825
  {28,  8,   0}, // #1826
  { 2,  2,   0}, // #1827
  { 3,  6,   0}, // #1828
  { 4,  7,   0}, // #1829
  { 5,  7,   0}, // #1830
  { 7,  1,   0}, // #1831
  { 8,  1,   0}, // #1832
  {10,  2,   0}, // #1833
  {11,  2,   0}, // #1834
  {28,  7,   0}, // #1835
  { 2,  2,   0}, // #1836
  { 3,  6,   0}, // #1837
  { 4,  7,   0}, // #1838
  { 5,  7,   0}, // #1839
  { 7,  1,   0}, // #1840
  { 8,  1,   0}, // #1841
  {10,  2,   0}, // #1842
  {11,  2,   0}, // #1843
  {15,  1,   0}, // #1844
  {16,  1,   0}, // #1845
  {28,  8,   0}, // #1846
  { 2,  1,   0}, // #1847
  { 3,  3,   0}, // #1848
  { 4,  3,   0}, // #1849
  { 5,  3,   0}, // #1850
  {10,  1,   0}, // #1851
  {11,  1,   0}, // #1852
  {28,  3,   0}, // #1853
  { 2,  1,   0}, // #1854
  { 3,  3,   0}, // #1855
  { 4,  3,   0}, // #1856
  { 5,  3,   0}, // #1857
  {10,  1,   0}, // #1858
  {11,  1,   0}, // #1859
  {15,  1,   0}, // #1860
  {16,  1,   0}, // #1861
  {28,  4,   0}, // #1862
  { 4,  1,   0}, // #1863
  { 5,  2,   0}, // #1864
  { 7,  1,   0}, // #1865
  { 8,  1,   0}, // #1866
  {15,  1,   0}, // #1867
  {16,  1,   0}, // #1868
  {28,  3,   0}, // #1869
  { 4,  1,   0}, // #1870
  { 5,  5,   0}, // #1871
  { 7,  1,   0}, // #1872
  { 8,  1,   0}, // #1873
  {15,  2,   0}, // #1874
  {16,  1,   0}, // #1875
  {19,  1,   0}, // #1876
  {23,  1,   0}, // #1877
  {28,  8,   0}, // #1878
  { 2,  2,   0}, // #1879
  { 3,  2,   0}, // #1880
  { 4,  5,   0}, // #1881
  { 5,  7,   0}, // #1882
  { 7,  3,   0}, // #1883
  { 8,  3,   0}, // #1884
  { 9,  2,   0}, // #1885
  {10,  2,   0}, // #1886
  {11,  2,   0}, // #1887
  {28,  7,   0}, // #1888
  { 1,  1,   0}, // #1889
  { 2,  4,   0}, // #1890
  { 3,  5,   0}, // #1891
  { 4,  9,   0}, // #1892
  { 5, 13,   0}, // #1893
  { 6,  2,   0}, // #1894
  { 7,  6,   0}, // #1895
  { 8,  5,   0}, // #1896
  { 9,  3,   0}, // #1897
  {10,  4,   0}, // #1898
  {11,  4,   0}, // #1899
  {15,  2,   0}, // #1900
  {16,  2,   0}, // #1901
  {20,  1,   0}, // #1902
  {28, 15,   0}, // #1903
  { 1,  1,   0}, // #1904
  { 2,  1,   0}, // #1905
  { 3,  3,   0}, // #1906
  { 4,  3,   0}, // #1907
  { 5,  3,   0}, // #1908
  { 6,  3,   0}, // #1909
  { 7,  3,   0}, // #1910
  { 8,  1,   0}, // #1911
  {10,  2,   0}, // #1912
  {11,  2,   0}, // #1913
  {20,  2,   0}, // #1914
  {28,  3,   0}, // #1915
  { 2,  1,   0}, // #1916
  { 3,  3,   0}, // #1917
  { 4,  3,   0}, // #1918
  { 5,  3,   0}, // #1919
  {10,  2,   0}, // #1920
  {11,  2,   0}, // #1921
  {28,  3,   0}, // #1922
  { 1,  1,   0}, // #1923
  { 2,  1,   0}, // #1924
  { 3,  3,   0}, // #1925
  { 4,  3,   0}, // #1926
  { 5,  3,   0}, // #1927
  { 6,  3,   0}, // #1928
  { 7,  3,   0}, // #1929
  { 8,  1,   0}, // #1930
  {10,  2,   0}, // #1931
  {11,  2,   0}, // #1932
  {15,  1,   0}, // #1933
  {16,  1,   0}, // #1934
  {20,  2,   0}, // #1935
  {28,  4,   0}, // #1936
  { 2,  1,   0}, // #1937
  { 3,  3,   0}, // #1938
  { 4,  3,   0}, // #1939
  { 5,  3,   0}, // #1940
  {10,  2,   0}, // #1941
  {11,  2,   0}, // #1942
  {15,  1,   0}, // #1943
  {16,  1,   0}, // #1944
  {28,  4,   0}, // #1945
  { 2, 52,   0}, // #1946
  { 3, 125,   0}, // #1947
  { 4, 178,   0}, // #1948
  { 5, 178,   0}, // #1949
  { 6, 41,   0}, // #1950
  { 7, 94,   0}, // #1951
  { 8, 53,   0}, // #1952
  { 9, 29,   0}, // #1953
  {10, 69,   0}, // #1954
  {11, 69,   0}, // #1955
  {15,  6,   0}, // #1956
  {16,  4,   0}, // #1957
  {19,  2,   0}, // #1958
  {20,  8,   0}, // #1959
  {23,  2,   0}, // #1960
  {28, 186,   0}, // #1961
  { 4,  1,   0}, // #1962
  { 5,  1,   0}, // #1963
  {13,  1,   0}, // #1964
  {14,  2,   0}, // #1965
  {15,  2,   0}, // #1966
  {16,  1,   0}, // #1967
  {18,  1,   0}, // #1968
  {19,  1,   0}, // #1969
  {28,  4,   0}, // #1970
  { 2,  1,   0}, // #1971
  { 3,  1,   0}, // #1972
  { 4,  3,   0}, // #1973
  { 5,  8,   0}, // #1974
  { 7,  2,   0}, // #1975
  { 8,  2,   0}, // #1976
  { 9,  1,   0}, // #1977
  {10,  1,   0}, // #1978
  {11,  1,   0}, // #1979
  {15,  1,   0}, // #1980
  {16,  1,   0}, // #1981
  {28,  9,   0}, // #1982
  { 2,  1,   0}, // #1983
  { 3,  1,   0}, // #1984
  { 4,  3,   0}, // #1985
  { 5,  7,   0}, // #1986
  { 7,  2,   0}, // #1987
  { 8,  2,   0}, // #1988
  { 9,  1,   0}, // #1989
  {10,  1,   0}, // #1990
  {11,  1,   0}, // #1991
  {15,  2,   0}, // #1992
  {16,  1,   0}, // #1993
  {19,  1,   0}, // #1994
  {23,  1,   0}, // #1995
  {28, 10,   0}, // #1996
  { 4,  1,   0}, // #1997
  { 5,  2,   0}, // #1998
  { 7,  1,   0}, // #1999
  { 8,  1,   0}, // #2000
  {15,  1,   0}, // #2001
  {19,  1,   0}, // #2002
  {23,  1,   0}, // #2003
  {28,  4,   0}, // #2004
  { 2,  1,   0}, // #2005
  { 3,  4,   0}, // #2006
  { 4, 10,   0}, // #2007
  { 5, 10,   0}, // #2008
  { 6,  3,   0}, // #2009
  { 7,  9,   0}, // #2010
  { 8,  6,   0}, // #2011
  { 9,  1,   0}, // #2012
  {10,  4,   0}, // #2013
  {11,  4,   0}, // #2014
  {20,  3,   0}, // #2015
  {28, 10,   0}, // #2016
  { 1,  7,   0}, // #2017
  { 2, 26,   0}, // #2018
  { 3, 47,   0}, // #2019
  { 4, 73,   0}, // #2020
  { 5, 80,   0}, // #2021
  { 6, 28,   0}, // #2022
  { 7, 54,   0}, // #2023
  { 8, 33,   0}, // #2024
  { 9, 19,   0}, // #2025
  {10, 40,   0}, // #2026
  {11, 42,   0}, // #2027
  {15,  7,   0}, // #2028
  {16,  7,   0}, // #2029
  {20, 21,   0}, // #2030
  {28, 87,   0}, // #2031
  { 1,  7,   0}, // #2032
  { 2, 27,   0}, // #2033
  { 3, 47,   0}, // #2034
  { 4, 73,   0}, // #2035
  { 5, 80,   0}, // #2036
  { 6, 27,   0}, // #2037
  { 7, 53,   0}, // #2038
  { 8, 33,   0}, // #2039
  { 9, 19,   0}, // #2040
  {10, 39,   0}, // #2041
  {11, 42,   0}, // #2042
  {15,  7,   0}, // #2043
  {16,  7,   0}, // #2044
  {20, 20,   0}, // #2045
  {28, 87,   0}, // #2046
  { 1,  7,   0}, // #2047
  { 2, 28,   0}, // #2048
  { 3, 48,   0}, // #2049
  { 4, 76,   0}, // #2050
  { 5, 84,   0}, // #2051
  { 6, 27,   0}, // #2052
  { 7, 55,   0}, // #2053
  { 8, 35,   0}, // #2054
  { 9, 21,   0}, // #2055
  {10, 41,   0}, // #2056
  {11, 43,   0}, // #2057
  {15, 10,   0}, // #2058
  {16, 10,   0}, // #2059
  {20, 20,   0}, // #2060
  {28, 94,   0}, // #2061
  { 1,  7,   0}, // #2062
  { 2, 28,   0}, // #2063
  { 3, 49,   0}, // #2064
  { 4, 77,   0}, // #2065
  { 5, 88,   0}, // #2066
  { 6, 28,   0}, // #2067
  { 7, 56,   0}, // #2068
  { 8, 35,   0}, // #2069
  { 9, 21,   0}, // #2070
  {10, 42,   0}, // #2071
  {11, 44,   0}, // #2072
  {15, 11,   0}, // #2073
  {16, 11,   0}, // #2074
  {20, 21,   0}, // #2075
  {28, 99,   0}, // #2076
  { 1,  7,   0}, // #2077
  { 2, 24,   0}, // #2078
  { 3, 43,   0}, // #2079
  { 4, 67,   0}, // #2080
  { 5, 73,   0}, // #2081
  { 6, 26,   0}, // #2082
  { 7, 50,   0}, // #2083
  { 8, 31,   0}, // #2084
  { 9, 17,   0}, // #2085
  {10, 36,   0}, // #2086
  {11, 36,   0}, // #2087
  {15,  9,   0}, // #2088
  {16,  8,   0}, // #2089
  {19,  1,   0}, // #2090
  {20, 19,   0}, // #2091
  {23,  1,   0}, // #2092
  {28, 83,   0}, // #2093
  { 1,  7,   0}, // #2094
  { 2, 24,   0}, // #2095
  { 3, 46,   0}, // #2096
  { 4, 74,   0}, // #2097
  { 5, 79,   0}, // #2098
  { 6, 28,   0}, // #2099
  { 7, 56,   0}, // #2100
  { 8, 34,   0}, // #2101
  { 9, 17,   0}, // #2102
  {10, 38,   0}, // #2103
  {11, 38,   0}, // #2104
  {15, 12,   0}, // #2105
  {16, 11,   0}, // #2106
  {19,  1,   0}, // #2107
  {20, 21,   0}, // #2108
  {23,  1,   0}, // #2109
  {28, 92,   0}, // #2110
  { 1,  5,   0}, // #2111
  { 2, 11,   0}, // #2112
  { 3, 18,   0}, // #2113
  { 4, 26,   0}, // #2114
  { 5, 32,   0}, // #2115
  { 6, 12,   0}, // #2116
  { 7, 20,   0}, // #2117
  { 8, 13,   0}, // #2118
  { 9,  6,   0}, // #2119
  {10, 13,   0}, // #2120
  {11, 15,   0}, // #2121
  {15,  5,   0}, // #2122
  {19,  5,   0}, // #2123
  {20,  7,   0}, // #2124
  {23,  5,   0}, // #2125
  {28, 42,   0}, // #2126
  { 4,  1,   0}, // #2127
  { 5,  1,   0}, // #2128
  { 7,  1,   0}, // #2129
  { 8,  1,   0}, // #2130
  {21,  1,   0}, // #2131
  {28,  1,   0}, // #2132
  { 1,  8,   0}, // #2133
  { 2, 22,   0}, // #2134
  { 3, 23,   0}, // #2135
  { 4, 25,   0}, // #2136
  { 5, 25,   0}, // #2137
  { 6,  9,   0}, // #2138
  { 7, 11,   0}, // #2139
  { 8, 10,   0}, // #2140
  { 9, 14,   0}, // #2141
  {10, 15,   0}, // #2142
  {11, 15,   0}, // #2143
  {15,  3,   0}, // #2144
  {16,  3,   0}, // #2145
  {20,  1,   0}, // #2146
  {28, 28,   0}, // #2147
  { 1,  1,   0}, // #2148
  { 2,  6,   0}, // #2149
  { 3,  9,   0}, // #2150
  { 4, 18,   0}, // #2151
  { 5, 20,   0}, // #2152
  { 6,  4,   0}, // #2153
  { 7, 13,   0}, // #2154
  { 8, 10,   0}, // #2155
  { 9,  5,   0}, // #2156
  {10,  6,   0}, // #2157
  {11,  6,   0}, // #2158
  {15,  3,   0}, // #2159
  {16,  3,   0}, // #2160
  {20,  1,   0}, // #2161
  {28, 23,   0}, // #2162
  { 1,  1,   0}, // #2163
  { 2,  4,   0}, // #2164
  { 3,  4,   0}, // #2165
  { 4,  8,   0}, // #2166
  { 5, 10,   0}, // #2167
  { 6,  1,   0}, // #2168
  { 7,  5,   0}, // #2169
  { 8,  5,   0}, // #2170
  { 9,  3,   0}, // #2171
  {10,  3,   0}, // #2172
  {11,  3,   0}, // #2173
  {15,  3,   0}, // #2174
  {16,  2,   0}, // #2175
  {19,  1,   0}, // #2176
  {23,  1,   0}, // #2177
  {28, 14,   0}, // #2178
  { 2,  3,   0}, // #2179
  { 3,  4,   0}, // #2180
  { 4,  9,   0}, // #2181
  { 5, 10,   0}, // #2182
  { 6,  1,   0}, // #2183
  { 7,  6,   0}, // #2184
  { 8,  5,   0}, // #2185
  { 9,  3,   0}, // #2186
  {10,  3,   0}, // #2187
  {11,  3,   0}, // #2188
  {15,  3,   0}, // #2189
  {16,  2,   0}, // #2190
  {19,  1,   0}, // #2191
  {23,  1,   0}, // #2192
  {28, 14,   0}, // #2193
  { 2,  3,   0}, // #2194
  { 3,  3,   0}, // #2195
  { 4,  8,   0}, // #2196
  { 5,  8,   0}, // #2197
  { 7,  5,   0}, // #2198
  { 8,  5,   0}, // #2199
  { 9,  3,   0}, // #2200
  {10,  3,   0}, // #2201
  {11,  3,   0}, // #2202
  {15,  3,   0}, // #2203
  {16,  2,   0}, // #2204
  {19,  1,   0}, // #2205
  {23,  1,   0}, // #2206
  {28, 12,   0}, // #2207
  { 2,  3,   0}, // #2208
  { 3,  3,   0}, // #2209
  { 4,  7,   0}, // #2210
  { 5,  8,   0}, // #2211
  { 7,  4,   0}, // #2212
  { 8,  4,   0}, // #2213
  { 9,  3,   0}, // #2214
  {10,  3,   0}, // #2215
  {11,  3,   0}, // #2216
  {15,  2,   0}, // #2217
  {16,  1,   0}, // #2218
  {19,  1,   0}, // #2219
  {23,  1,   0}, // #2220
  {28, 11,   0}, // #2221
  { 1,  1,   0}, // #2222
  { 2,  4,   0}, // #2223
  { 3, 12,   0}, // #2224
  { 4, 20,   0}, // #2225
  { 5, 22,   0}, // #2226
  { 6,  8,   0}, // #2227
  { 7, 16,   0}, // #2228
  { 8,  9,   0}, // #2229
  { 9,  3,   0}, // #2230
  {10, 10,   0}, // #2231
  {11, 10,   0}, // #2232
  {15,  3,   0}, // #2233
  {16,  1,   0}, // #2234
  {19,  2,   0}, // #2235
  {20,  7,   0}, // #2236
  {23,  2,   0}, // #2237
  {28, 27,   0}, // #2238
  { 2,  1,   0}, // #2239
  { 3,  6,   0}, // #2240
  { 4, 13,   0}, // #2241
  { 5, 18,   0}, // #2242
  { 6,  5,   0}, // #2243
  { 7, 12,   0}, // #2244
  { 8,  7,   0}, // #2245
  { 9,  1,   0}, // #2246
  {10,  6,   0}, // #2247
  {11,  6,   0}, // #2248
  {15,  2,   0}, // #2249
  {19,  2,   0}, // #2250
  {20,  5,   0}, // #2251
  {23,  2,   0}, // #2252
  {28, 22,   0}, // #2253
  { 2,  8,   0}, // #2254
  { 3, 22,   0}, // #2255
  { 4, 38,   0}, // #2256
  { 5, 44,   0}, // #2257
  { 6, 12,   0}, // #2258
  { 7, 28,   0}, // #2259
  { 8, 16,   0}, // #2260
  { 9,  7,   0}, // #2261
  {10, 19,   0}, // #2262
  {11, 21,   0}, // #2263
  {15,  2,   0}, // #2264
  {19,  2,   0}, // #2265
  {20, 12,   0}, // #2266
  {23,  2,   0}, // #2267
  {28, 48,   0}, // #2268
  { 3,  1,   0}, // #2269
  { 4,  2,   0}, // #2270
  { 5,  3,   0}, // #2271
  { 6,  1,   0}, // #2272
  { 7,  2,   0}, // #2273
  { 8,  1,   0}, // #2274
  {10,  1,   0}, // #2275
  {11,  1,   0}, // #2276
  {20,  1,   0}, // #2277
  {28,  3,   0}, // #2278
  { 2,  4,   0}, // #2279
  { 3, 10,   0}, // #2280
  { 4, 18,   0}, // #2281
  { 5, 24,   0}, // #2282
  { 6,  3,   0}, // #2283
  { 7, 11,   0}, // #2284
  { 8,  8,   0}, // #2285
  { 9,  4,   0}, // #2286
  {10,  7,   0}, // #2287
  {11,  9,   0}, // #2288
  {20,  3,   0}, // #2289
  {28, 24,   0}, // #2290
  { 1,  6,   0}, // #2291
  { 2, 21,   0}, // #2292
  { 3, 38,   0}, // #2293
  { 4, 66,   0}, // #2294
  { 5, 70,   0}, // #2295
  { 6, 23,   0}, // #2296
  { 7, 51,   0}, // #2297
  { 8, 34,   0}, // #2298
  { 9, 15,   0}, // #2299
  {10, 31,   0}, // #2300
  {11, 31,   0}, // #2301
  {15,  8,   0}, // #2302
  {16,  7,   0}, // #2303
  {19,  1,   0}, // #2304
  {20, 16,   0}, // #2305
  {23,  1,   0}, // #2306
  {28, 79,   0}, // #2307
  { 1,  6,   0}, // #2308
  { 2, 21,   0}, // #2309
  { 3, 37,   0}, // #2310
  { 4, 64,   0}, // #2311
  { 5, 70,   0}, // #2312
  { 6, 22,   0}, // #2313
  { 7, 49,   0}, // #2314
  { 8, 33,   0}, // #2315
  { 9, 15,   0}, // #2316
  {10, 31,   0}, // #2317
  {11, 31,   0}, // #2318
  {15,  8,   0}, // #2319
  {16,  7,   0}, // #2320
  {19,  1,   0}, // #2321
  {20, 16,   0}, // #2322
  {23,  1,   0}, // #2323
  {28, 79,   0}, // #2324
  { 1,  6,   0}, // #2325
  { 2, 21,   0}, // #2326
  { 3, 40,   0}, // #2327
  { 4, 70,   0}, // #2328
  { 5, 74,   0}, // #2329
  { 6, 25,   0}, // #2330
  { 7, 55,   0}, // #2331
  { 8, 36,   0}, // #2332
  { 9, 15,   0}, // #2333
  {10, 33,   0}, // #2334
  {11, 33,   0}, // #2335
  {15, 10,   0}, // #2336
  {16,  9,   0}, // #2337
  {19,  1,   0}, // #2338
  {20, 18,   0}, // #2339
  {23,  1,   0}, // #2340
  {28, 85,   0}, // #2341
  { 1,  6,   0}, // #2342
  { 2, 21,   0}, // #2343
  { 3, 39,   0}, // #2344
  { 4, 68,   0}, // #2345
  { 5, 74,   0}, // #2346
  { 6, 24,   0}, // #2347
  { 7, 53,   0}, // #2348
  { 8, 35,   0}, // #2349
  { 9, 15,   0}, // #2350
  {10, 33,   0}, // #2351
  {11, 33,   0}, // #2352
  {15, 10,   0}, // #2353
  {16,  9,   0}, // #2354
  {19,  1,   0}, // #2355
  {20, 18,   0}, // #2356
  {23,  1,   0}, // #2357
  {28, 85,   0}, // #2358
  { 1,  7,   0}, // #2359
  { 2, 23,   0}, // #2360
  { 3, 40,   0}, // #2361
  { 4, 65,   0}, // #2362
  { 5, 71,   0}, // #2363
  { 6, 24,   0}, // #2364
  { 7, 49,   0}, // #2365
  { 8, 32,   0}, // #2366
  { 9, 16,   0}, // #2367
  {10, 33,   0}, // #2368
  {11, 33,   0}, // #2369
  {15,  8,   0}, // #2370
  {16,  7,   0}, // #2371
  {19,  1,   0}, // #2372
  {20, 17,   0}, // #2373
  {23,  1,   0}, // #2374
  {28, 80,   0}, // #2375
  { 1,  7,   0}, // #2376
  { 2, 23,   0}, // #2377
  { 3, 43,   0}, // #2378
  { 4, 71,   0}, // #2379
  { 5, 77,   0}, // #2380
  { 6, 27,   0}, // #2381
  { 7, 55,   0}, // #2382
  { 8, 35,   0}, // #2383
  { 9, 16,   0}, // #2384
  {10, 36,   0}, // #2385
  {11, 36,   0}, // #2386
  {15, 11,   0}, // #2387
  {16, 10,   0}, // #2388
  {19,  1,   0}, // #2389
  {20, 20,   0}, // #2390
  {23,  1,   0}, // #2391
  {28, 89,   0}, // #2392
  { 4,  2,   0}, // #2393
  { 5,  3,   0}, // #2394
  { 7,  2,   0}, // #2395
  { 8,  2,   0}, // #2396
  {15,  1,   0}, // #2397
  {16,  1,   0}, // #2398
  {21,  2,   0}, // #2399
  {28,  4,   0}, // #2400
  { 4,  2,   0}, // #2401
  { 5,  3,   0}, // #2402
  { 7,  2,   0}, // #2403
  { 8,  2,   0}, // #2404
  {21,  2,   0}, // #2405
  {28,  3,   0}, // #2406
  { 4,  2,   0}, // #2407
  { 5,  4,   0}, // #2408
  { 7,  2,   0}, // #2409
  { 8,  2,   0}, // #2410
  {21,  2,   0}, // #2411
  {28,  4,   0}, // #2412
  { 2,  2,   0}, // #2413
  { 3,  2,   0}, // #2414
  { 4,  7,   0}, // #2415
  { 5,  8,   0}, // #2416
  { 7,  5,   0}, // #2417
  { 8,  5,   0}, // #2418
  { 9,  2,   0}, // #2419
  {10,  2,   0}, // #2420
  {11,  2,   0}, // #2421
  {15,  2,   0}, // #2422
  {16,  1,   0}, // #2423
  {19,  1,   0}, // #2424
  {23,  1,   0}, // #2425
  {28, 11,   0}, // #2426
  { 2,  3,   0}, // #2427
  { 3,  3,   0}, // #2428
  { 4,  7,   0}, // #2429
  { 5,  9,   0}, // #2430
  { 7,  4,   0}, // #2431
  { 8,  4,   0}, // #2432
  { 9,  3,   0}, // #2433
  {10,  3,   0}, // #2434
  {11,  3,   0}, // #2435
  {15,  2,   0}, // #2436
  {16,  1,   0}, // #2437
  {19,  1,   0}, // #2438
  {23,  1,   0}, // #2439
  {28, 12,   0}, // #2440
  { 1,  2,   0}, // #2441
  { 2,  9,   0}, // #2442
  { 3, 16,   0}, // #2443
  { 4, 24,   0}, // #2444
  { 5, 24,   0}, // #2445
  { 6,  6,   0}, // #2446
  { 7, 14,   0}, // #2447
  { 8,  7,   0}, // #2448
  { 9,  7,   0}, // #2449
  {10, 11,   0}, // #2450
  {11, 11,   0}, // #2451
  {15,  1,   0}, // #2452
  {16,  1,   0}, // #2453
  {20,  4,   0}, // #2454
  {28, 25,   0}, // #2455
  { 2,  1,   0}, // #2456
  { 3,  1,   0}, // #2457
  { 4,  3,   0}, // #2458
  { 5,  5,   0}, // #2459
  { 7,  2,   0}, // #2460
  { 8,  2,   0}, // #2461
  { 9,  1,   0}, // #2462
  {10,  1,   0}, // #2463
  {11,  1,   0}, // #2464
  {15,  1,   0}, // #2465
  {19,  1,   0}, // #2466
  {23,  1,   0}, // #2467
  {28,  7,   0}, // #2468
  { 3,  1,   0}, // #2469
  { 4,  1,   0}, // #2470
  { 5,  2,   0}, // #2471
  { 6,  1,   0}, // #2472
  { 7,  1,   0}, // #2473
  {10,  1,   0}, // #2474
  {11,  1,   0}, // #2475
  {20,  1,   0}, // #2476
  {28,  2,   0}, // #2477
  { 2,  1,   0}, // #2478
  { 3,  1,   0}, // #2479
  { 4,  5,   0}, // #2480
  { 5,  6,   0}, // #2481
  { 7,  4,   0}, // #2482
  { 8,  4,   0}, // #2483
  { 9,  1,   0}, // #2484
  {10,  1,   0}, // #2485
  {11,  1,   0}, // #2486
  {28,  6,   0}, // #2487
  { 1,  6,   0}, // #2488
  { 2, 13,   0}, // #2489
  { 3, 13,   0}, // #2490
  { 4, 13,   0}, // #2491
  { 5, 13,   0}, // #2492
  { 6,  6,   0}, // #2493
  { 7,  6,   0}, // #2494
  { 8,  6,   0}, // #2495
  { 9,  7,   0}, // #2496
  {10,  7,   0}, // #2497
  {11,  7,   0}, // #2498
  {15, 18,   0}, // #2499
  {16, 18,   0}, // #2500
  {28, 31,   0}, // #2501
  { 1,  6,   0}, // #2502
  { 2, 13,   0}, // #2503
  { 3, 13,   0}, // #2504
  { 4, 13,   0}, // #2505
  { 5, 13,   0}, // #2506
  { 6,  6,   0}, // #2507
  { 7,  6,   0}, // #2508
  { 8,  6,   0}, // #2509
  { 9,  7,   0}, // #2510
  {10,  7,   0}, // #2511
  {11,  7,   0}, // #2512
  {15, 17,   0}, // #2513
  {16, 17,   0}, // #2514
  {28, 30,   0}, // #2515
  { 1,  5,   0}, // #2516
  { 2, 13,   0}, // #2517
  { 3, 13,   0}, // #2518
  { 4, 13,   0}, // #2519
  { 5, 13,   0}, // #2520
  { 6,  5,   0}, // #2521
  { 7,  5,   0}, // #2522
  { 8,  5,   0}, // #2523
  { 9,  8,   0}, // #2524
  {10,  8,   0}, // #2525
  {11,  8,   0}, // #2526
  {15, 20,   0}, // #2527
  {16, 20,   0}, // #2528
  {28, 33,   0}, // #2529
  { 1,  1,   0}, // #2530
  { 2,  1,   0}, // #2531
  { 3,  1,   0}, // #2532
  { 4,  2,   0}, // #2533
  { 5,  2,   0}, // #2534
  { 6,  1,   0}, // #2535
  { 7,  2,   0}, // #2536
  { 8,  2,   0}, // #2537
  {15,  1,   0}, // #2538
  {16,  1,   0}, // #2539
  {28,  3,   0}, // #2540
  { 2,  4,   0}, // #2541
  { 3,  5,   0}, // #2542
  { 4,  6,   0}, // #2543
  { 5,  8,   0}, // #2544
  { 6,  1,   0}, // #2545
  { 7,  2,   0}, // #2546
  { 8,  1,   0}, // #2547
  { 9,  4,   0}, // #2548
  {10,  5,   0}, // #2549
  {11,  5,   0}, // #2550
  {20,  1,   0}, // #2551
  {28,  8,   0}, // #2552
  { 1,  1,   0}, // #2553
  { 2, 43,   0}, // #2554
  { 3, 91,   0}, // #2555
  { 4, 143,   0}, // #2556
  { 5, 143,   0}, // #2557
  { 6, 49,   0}, // #2558
  { 7, 101,   0}, // #2559
  { 8, 53,   0}, // #2560
  { 9, 23,   0}, // #2561
  {10, 35,   0}, // #2562
  {11, 35,   0}, // #2563
  {15,  6,   0}, // #2564
  {16,  4,   0}, // #2565
  {19,  2,   0}, // #2566
  {20, 12,   0}, // #2567
  {23,  2,   0}, // #2568
  {28, 151,   0}, // #2569
  { 1,  1,   0}, // #2570
  { 2, 43,   0}, // #2571
  { 3, 91,   0}, // #2572
  { 4, 144,   0}, // #2573
  { 5, 144,   0}, // #2574
  { 6, 49,   0}, // #2575
  { 7, 102,   0}, // #2576
  { 8, 54,   0}, // #2577
  { 9, 23,   0}, // #2578
  {10, 35,   0}, // #2579
  {11, 35,   0}, // #2580
  {15,  6,   0}, // #2581
  {16,  4,   0}, // #2582
  {19,  2,   0}, // #2583
  {20, 12,   0}, // #2584
  {23,  2,   0}, // #2585
  {28, 152,   0}, // #2586
  { 2, 52,   0}, // #2587
  { 3, 97,   0}, // #2588
  { 4, 149,   0}, // #2589
  { 5, 149,   0}, // #2590
  { 6, 45,   0}, // #2591
  { 7, 97,   0}, // #2592
  { 8, 52,   0}, // #2593
  { 9, 27,   0}, // #2594
  {10, 37,   0}, // #2595
  {11, 37,   0}, // #2596
  {15,  5,   0}, // #2597
  {16,  4,   0}, // #2598
  {19,  1,   0}, // #2599
  {20, 10,   0}, // #2600
  {23,  1,   0}, // #2601
  {28, 155,   0}, // #2602
  { 2, 52,   0}, // #2603
  { 3, 123,   0}, // #2604
  { 4, 176,   0}, // #2605
  { 5, 176,   0}, // #2606
  { 6, 41,   0}, // #2607
  { 7, 94,   0}, // #2608
  { 8, 53,   0}, // #2609
  { 9, 29,   0}, // #2610
  {10, 68,   0}, // #2611
  {11, 68,   0}, // #2612
  {15,  6,   0}, // #2613
  {16,  4,   0}, // #2614
  {19,  2,   0}, // #2615
  {20,  9,   0}, // #2616
  {23,  2,   0}, // #2617
  {28, 184,   0}, // #2618
  { 1,  1,   0}, // #2619
  { 3,  2,   0}, // #2620
  { 1,  1,   0}, // #2621
  { 3,  1,   0}, // #2622
  { 1,  6,   0}, // #2623
  { 2,  6,   0}, // #2624
  { 3, 12,   0}, // #2625
  { 1,  5,   0}, // #2626
  { 2,  5,   0}, // #2627
  { 3, 10,   0}, // #2628
  { 1, 16,   0}, // #2629
  { 2, 16,   0}, // #2630
  { 3, 32,   0}, // #2631
  { 3, 15,   0}, // #2632
  { 1, 10,   0}, // #2633
  { 2, 10,   0}, // #2634
  { 3, 20,   0}, // #2635
  { 1,  9,   0}, // #2636
  { 2,  9,   0}, // #2637
  { 3, 18,   0}, // #2638
  { 1,  5,   0}, // #2639
  { 3,  5,   0}, // #2640
  { 1,  7,   0}, // #2641
  { 2,  7,   0}, // #2642
  { 3, 14,   0}, // #2643
  { 1,  8,   0}, // #2644
  { 2,  8,   0}, // #2645
  { 3, 16,   0}, // #2646
  { 1, 12,   0}, // #2647
  { 2, 12,   0}, // #2648
  { 3, 24,   0}, // #2649
  { 1, 11,   0}, // #2650
  { 2, 11,   0}, // #2651
  { 3, 22,   0}, // #2652
  { 1, 50,   0}, // #2653
  { 2, 50,   0}, // #2654
  { 3, 100,   0}, // #2655
  { 1, 130,   0}, // #2656
  { 2, 130,   0}, // #2657
  { 3, 260,   0}, // #2658
  { 1, 68,   0}, // #2659
  { 2, 68,   0}, // #2660
  { 3, 136,   0}, // #2661
  { 1, 125,   0}, // #2662
  { 2, 125,   0}, // #2663
  { 3, 250,   0}, // #2664
  { 1, 70,   0}, // #2665
  { 2, 70,   0}, // #2666
  { 3, 140,   0}, // #2667
  { 1, 34,   0}, // #2668
  { 2, 34,   0}, // #2669
  { 3, 68,   0}, // #2670
  { 1, 62,   0}, // #2671
  { 2, 62,   0}, // #2672
  { 3, 124,   0}, // #2673
  { 1,  2,   0}, // #2674
  { 3,  2,   0}, // #2675
  { 1, 14,   0}, // #2676
  { 2, 14,   0}, // #2677
  { 3, 28,   0}, // #2678
  { 1,  3,   0}, // #2679
  { 3,  3,   0}, // #2680
  { 1,  4,   0}, // #2681
  { 2,  4,   0}, // #2682
  { 3,  8,   0}, // #2683
  { 1,  3,   0}, // #2684
  { 2,  3,   0}, // #2685
  { 3,  6,   0}, // #2686
  { 1,  2,   0}, // #2687
  { 2,  2,   0}, // #2688
  { 3,  4,   0}, // #2689
  { 1,  4,   0}, // #2690
  { 3,  4,   0}, // #2691
  { 1, 71,   0}, // #2692
  { 3, 71,   0}, // #2693
  { 1, 15,   0}, // #2694
  { 2, 15,   0}, // #2695
  { 3, 30,   0}, // #2696
  { 3, 21,   0}, // #2697
  { 3, 25,   0}, // #2698
  { 3, 29,   0}, // #2699
  { 3, 45,   0}, // #2700
  { 3, 55,   0}, // #2701
  { 3, 59,   0}, // #2702
  { 3, 63,   0}, // #2703
  { 3, 72,   0}, // #2704
  { 3, 74,   0}, // #2705
  { 3, 77,   0}, // #2706
  { 3, 78,   0}, // #2707
  { 3, 92,   0}, // #2708
  { 3, 94,   0}, // #2709
  { 3, 99,   0}, // #2710
  { 3, 121,   0}, // #2711
  { 3, 127,   0}, // #2712
  { 3, 130,   0}, // #2713
  { 3, 141,   0}, // #2714
  { 3, 146,   0}, // #2715
  { 3, 147,   0}, // #2716
  { 3, 168,   0}, // #2717
  { 3, 174,   0}, // #2718
  { 3, 183,   0}, // #2719
  { 3, 202,   0}, // #2720
  { 9,  6,   0}, // #2721
  {10,  2,   0}, // #2722
  { 4,  1,   0}, // #2723
  { 6,  1,   0}, // #2724
  { 5,  2,   0}, // #2725
  { 6,  2,   0}, // #2726
  {10,  1,   0}, // #2727
  { 5,  1,   0}, // #2728
  { 6,  1,   0}, // #2729
  {10,  1,   0}, // #2730
  { 4,  5,   0}, // #2731
  { 6,  5,   0}, // #2732
  {10,  1,   0}, // #2733
  { 4,  4,   0}, // #2734
  { 6,  4,   0}, // #2735
  {10,  1,   0}, // #2736
  { 4,  1,   0}, // #2737
  { 6,  1,   0}, // #2738
  {10,  1,   0}, // #2739
  { 7, 10,   0}, // #2740
  { 8, 10,   0}, // #2741
  { 9, 20,   0}, // #2742
  {10,  1,   0}, // #2743
  { 7,  1,   0}, // #2744
  { 8,  1,   0}, // #2745
  { 9,  2,   0}, // #2746
  {10,  1,   0}, // #2747
  { 7,  1,   0}, // #2748
  { 8,  1,   0}, // #2749
  { 9,  2,   0}, // #2750
  {10,  2,   0}, // #2751
  { 4,  2,   0}, // #2752
  { 6,  2,   0}, // #2753
  {10,  1,   0}, // #2754
  { 1, 25,   0}, // #2755
  { 9,  1,   0}, // #2756
  {10,  1,   0}, // #2757
  { 2, 69,   0}, // #2758
  { 4,  1,   0}, // #2759
  { 6,  1,   0}, // #2760
  {10,  1,   0}, // #2761
  { 2, 39,   0}, // #2762
  { 4,  1,   0}, // #2763
  { 6,  1,   0}, // #2764
  {10,  1,   0}, // #2765
  { 2, 17,   0}, // #2766
  { 4,  1,   0}, // #2767
  { 6,  1,   0}, // #2768
  {10,  1,   0}, // #2769
  { 2, 32,   0}, // #2770
  { 4,  1,   0}, // #2771
  { 6,  1,   0}, // #2772
  {10,  1,   0}, // #2773
  { 5,  8,   0}, // #2774
  { 6,  8,   0}, // #2775
  {10,  1,   0}, // #2776
  { 5, 12,   0}, // #2777
  { 6, 12,   0}, // #2778
  {10,  1,   0}, // #2779
  { 4,  1,   0}, // #2780
  { 6,  1,   0}, // #2781
  {10,  2,   0}, // #2782
  { 6, 10,   0}, // #2783
  { 5,  6,   0}, // #2784
  { 6,  6,   0}, // #2785
  {10,  1,   0}, // #2786
  { 8,  5,   0}, // #2787
  { 9,  5,   0}, // #2788
  {10,  1,   0}, // #2789
  { 8,  4,   0}, // #2790
  { 9,  4,   0}, // #2791
  {10,  1,   0}, // #2792
  { 8,  7,   0}, // #2793
  { 9,  7,   0}, // #2794
  {10,  1,   0}, // #2795
  { 8,  2,   0}, // #2796
  { 9,  2,   0}, // #2797
  {10,  1,   0}, // #2798
  { 7,  1,   0}, // #2799
  { 9,  1,   0}, // #2800
  {10,  1,   0}, // #2801
  { 3,  4,   0}, // #2802
  { 4,  1,   0}, // #2803
  { 6,  1,   0}, // #2804
  {10,  1,   0}, // #2805
  { 3,  2,   0}, // #2806
  { 4,  1,   0}, // #2807
  { 6,  1,   0}, // #2808
  {10,  1,   0}, // #2809
  { 4, 10,   0}, // #2810
  { 6, 10,   0}, // #2811
  {10,  1,   0}, // #2812
  { 4, 21,   0}, // #2813
  { 6, 21,   0}, // #2814
  {10,  1,   0}, // #2815
  { 4, 17,   0}, // #2816
  { 6, 17,   0}, // #2817
  {10,  1,   0}, // #2818
  { 4, 13,   0}, // #2819
  { 6, 13,   0}, // #2820
  {10,  1,   0}, // #2821
  { 4, 11,   0}, // #2822
  { 6, 11,   0}, // #2823
  {10,  1,   0}, // #2824
  { 7,  2,   0}, // #2825
  { 9,  2,   0}, // #2826
  {10,  1,   0}, // #2827
  { 4,  8,   0}, // #2828
  { 6,  8,   0}, // #2829
  {10,  1,   0}, // #2830
  { 2, 70,   0}, // #2831
  { 4,  1,   0}, // #2832
  { 6,  1,   0}, // #2833
  {10,  1,   0}, // #2834
  { 2, 40,   0}, // #2835
  { 4,  1,   0}, // #2836
  { 6,  1,   0}, // #2837
  {10,  1,   0}, // #2838
  { 2, 35,   0}, // #2839
  { 4,  1,   0}, // #2840
  { 6,  1,   0}, // #2841
  {10,  1,   0}, // #2842
  { 2, 20,   0}, // #2843
  { 4,  1,   0}, // #2844
  { 6,  1,   0}, // #2845
  {10,  1,   0}, // #2846
  { 5,  2,   0}, // #2847
  { 8,  2,   0}, // #2848
  {11,  1,   0}, // #2849
  {14,  1,   0}, // #2850
  {20,  1,   0}, // #2851
  { 2,  1,   0}, // #2852
  { 5,  1,   0}, // #2853
  { 7,  1,   0}, // #2854
  { 8,  1,   0}, // #2855
  { 1,  2,   0}, // #2856
  { 5, 44,   0}, // #2857
  { 7, 44,   0}, // #2858
  { 8, 44,   0}, // #2859
  {22,  1,   0}, // #2860
  {24,  1,   0}, // #2861
  { 1,  3,   0}, // #2862
  { 2,  1,   0}, // #2863
  { 5,  1,   0}, // #2864
  { 7,  1,   0}, // #2865
  { 8,  1,   0}, // #2866
  {22,  3,   0}, // #2867
  { 5,  1,   0}, // #2868
  { 8,  1,   0}, // #2869
  { 1,  1,   0}, // #2870
  {24,  1,   0}, // #2871
  { 5,  6,   0}, // #2872
  { 8,  6,   0}, // #2873
  { 1,  1,   0}, // #2874
  {13,  1,   0}, // #2875
  {14,  3,   0}, // #2876
  {20,  3,   0}, // #2877
  {24,  1,   0}, // #2878
  { 1,  3,   0}, // #2879
  {10,  3,   0}, // #2880
  {14,  1,   0}, // #2881
  {19,  1,   0}, // #2882
  {22,  3,   0}, // #2883
  { 1,  1,   0}, // #2884
  {13,  2,   0}, // #2885
  {14, 36,   0}, // #2886
  {20, 36,   0}, // #2887
  {24,  1,   0}, // #2888
  { 1,  4,   0}, // #2889
  { 5,  2,   0}, // #2890
  { 8,  2,   0}, // #2891
  {22,  3,   0}, // #2892
  {24,  1,   0}, // #2893
  {10,  4,   0}, // #2894
  {14,  1,   0}, // #2895
  {16,  1,   0}, // #2896
  {19,  1,   0}, // #2897
  { 1,  3,   0}, // #2898
  { 5,  2,   0}, // #2899
  { 8,  2,   0}, // #2900
  {22,  3,   0}, // #2901
  { 1,  3,   0}, // #2902
  {10,  1,   0}, // #2903
  {14,  1,   0}, // #2904
  {15,  1,   0}, // #2905
  {19,  1,   0}, // #2906
  {22,  3,   0}, // #2907
  { 1,  3,   0}, // #2908
  {12,  1,   0}, // #2909
  {14,  1,   0}, // #2910
  {15,  1,   0}, // #2911
  {19,  1,   0}, // #2912
  {22,  3,   0}, // #2913
  { 1,  3,   0}, // #2914
  {11,  1,   0}, // #2915
  {14,  1,   0}, // #2916
  {20,  1,   0}, // #2917
  {22,  3,   0}, // #2918
  { 1,  3,   0}, // #2919
  {14,  1,   0}, // #2920
  {16,  1,   0}, // #2921
  {19,  1,   0}, // #2922
  {21,  1,   0}, // #2923
  {22,  3,   0}, // #2924
  { 1,  3,   0}, // #2925
  { 5,  6,   0}, // #2926
  { 8,  6,   0}, // #2927
  {22,  3,   0}, // #2928
  { 1,  3,   0}, // #2929
  { 5,  8,   0}, // #2930
  { 8,  8,   0}, // #2931
  {22,  3,   0}, // #2932
  { 1,  2,   0}, // #2933
  { 5,  7,   0}, // #2934
  { 8,  7,   0}, // #2935
  {22,  2,   0}, // #2936
  { 1,  1,   0}, // #2937
  { 5, 42,   0}, // #2938
  { 8, 42,   0}, // #2939
  {22,  1,   0}, // #2940
  { 1,  1,   0}, // #2941
  { 5, 44,   0}, // #2942
  { 8, 44,   0}, // #2943
  {22,  1,   0}, // #2944
  { 1,  3,   0}, // #2945
  { 5,  1,   0}, // #2946
  { 8,  1,   0}, // #2947
  {22,  3,   0}, // #2948
  { 1,  2,   0}, // #2949
  {22,  2,   0}, // #2950
  { 5,  3,   0}, // #2951
  { 7,  3,   0}, // #2952
  { 8,  3,   0}, // #2953
  { 1,  3,   0}, // #2954
  { 5,  1,   0}, // #2955
  { 6,  1,   0}, // #2956
  { 8,  1,   0}, // #2957
  {10,  1,   0}, // #2958
  {14,  1,   0}, // #2959
  {15,  1,   0}, // #2960
  {19,  1,   0}, // #2961
  {22,  3,   0}, // #2962
  { 1,  3,   0}, // #2963
  { 5,  4,   0}, // #2964
  { 8,  4,   0}, // #2965
  {22,  3,   0}, // #2966
  { 1,  3,   0}, // #2967
  { 9,  1,   0}, // #2968
  {13,  1,   0}, // #2969
  {14,  1,   0}, // #2970
  {15,  1,   0}, // #2971
  {19,  1,   0}, // #2972
  {22,  3,   0}, // #2973
  { 1,  3,   0}, // #2974
  { 5,  1,   0}, // #2975
  { 6,  1,   0}, // #2976
  { 8,  1,   0}, // #2977
  { 9,  1,   0}, // #2978
  {10,  1,   0}, // #2979
  {13,  1,   0}, // #2980
  {14,  1,   0}, // #2981
  {15,  1,   0}, // #2982
  {19,  1,   0}, // #2983
  {22,  3,   0}, // #2984
  { 1,  3,   0}, // #2985
  { 9,  2,   0}, // #2986
  {13,  1,   0}, // #2987
  {14,  1,   0}, // #2988
  {15,  1,   0}, // #2989
  {19,  1,   0}, // #2990
  {22,  3,   0}, // #2991
  { 1,  3,   0}, // #2992
  { 4, 15,   0}, // #2993
  { 5,  1,   0}, // #2994
  { 7,  1,   0}, // #2995
  { 8,  1,   0}, // #2996
  {22,  3,   0}, // #2997
  { 1,  3,   0}, // #2998
  { 4, 14,   0}, // #2999
  { 5,  1,   0}, // #3000
  { 7,  1,   0}, // #3001
  { 8,  1,   0}, // #3002
  {22,  3,   0}, // #3003
  { 1,  3,   0}, // #3004
  { 4, 12,   0}, // #3005
  { 5,  1,   0}, // #3006
  { 7,  1,   0}, // #3007
  { 8,  1,   0}, // #3008
  {22,  3,   0}, // #3009
  { 1,  3,   0}, // #3010
  {10,  9,   0}, // #3011
  {14,  1,   0}, // #3012
  {16,  1,   0}, // #3013
  {19,  1,   0}, // #3014
  {22,  3,   0}, // #3015
  { 1,  3,   0}, // #3016
  {10, 10,   0}, // #3017
  {14,  1,   0}, // #3018
  {16,  1,   0}, // #3019
  {19,  1,   0}, // #3020
  {22,  3,   0}, // #3021
  { 1,  3,   0}, // #3022
  {10, 14,   0}, // #3023
  {14,  1,   0}, // #3024
  {16,  1,   0}, // #3025
  {19,  1,   0}, // #3026
  {22,  3,   0}, // #3027
  { 1,  1,   0}, // #3028
  {13,  1,   0}, // #3029
  {14,  2,   0}, // #3030
  {16,  2,   0}, // #3031
  {19,  2,   0}, // #3032
  {24,  1,   0}, // #3033
  { 5,  1,   0}, // #3034
  { 6,  1,   0}, // #3035
  { 8,  1,   0}, // #3036
  {10,  3,   0}, // #3037
  {14,  1,   0}, // #3038
  {15,  1,   0}, // #3039
  {19,  1,   0}, // #3040
  {10,  1,   0}, // #3041
  {14,  1,   0}, // #3042
  {19,  1,   0}, // #3043
  {13,  1,   0}, // #3044
  {14,  1,   0}, // #3045
  {16,  1,   0}, // #3046
  {19,  1,   0}, // #3047
  { 1,  3,   0}, // #3048
  {10,  5,   0}, // #3049
  {14,  1,   0}, // #3050
  {15,  1,   0}, // #3051
  {19,  1,   0}, // #3052
  {22,  3,   0}, // #3053
  { 1,  3,   0}, // #3054
  { 4, 17,   0}, // #3055
  { 5,  1,   0}, // #3056
  { 7,  1,   0}, // #3057
  { 8,  1,   0}, // #3058
  {22,  3,   0}, // #3059
  { 1,  3,   0}, // #3060
  { 4, 25,   0}, // #3061
  { 5,  1,   0}, // #3062
  { 7,  1,   0}, // #3063
  { 8,  1,   0}, // #3064
  {22,  3,   0}, // #3065
  { 1,  3,   0}, // #3066
  { 5,  1,   0}, // #3067
  { 7,  1,   0}, // #3068
  { 8,  1,   0}, // #3069
  {22,  3,   0}, // #3070
  {23,  5,   0}, // #3071
  { 5,  1,   0}, // #3072
  { 7,  1,   0}, // #3073
  { 8,  1,   0}, // #3074
  {23,  5,   0}, // #3075
  { 1,  3,   0}, // #3076
  { 5,  1,   0}, // #3077
  { 7,  1,   0}, // #3078
  { 8,  1,   0}, // #3079
  {22,  3,   0}, // #3080
  {23,  2,   0}, // #3081
  { 5,  1,   0}, // #3082
  { 7,  1,   0}, // #3083
  { 8,  1,   0}, // #3084
  {23,  2,   0}, // #3085
  { 1,  3,   0}, // #3086
  { 5,  1,   0}, // #3087
  { 7,  1,   0}, // #3088
  { 8,  1,   0}, // #3089
  {22,  3,   0}, // #3090
  {23,  4,   0}, // #3091
  { 5,  1,   0}, // #3092
  { 7,  1,   0}, // #3093
  { 8,  1,   0}, // #3094
  {23,  4,   0}, // #3095
  { 1,  3,   0}, // #3096
  { 5,  1,   0}, // #3097
  { 7,  1,   0}, // #3098
  { 8,  1,   0}, // #3099
  {22,  3,   0}, // #3100
  {23,  6,   0}, // #3101
  { 5,  1,   0}, // #3102
  { 7,  1,   0}, // #3103
  { 8,  1,   0}, // #3104
  {23,  6,   0}, // #3105
  { 1,  3,   0}, // #3106
  {10,  2,   0}, // #3107
  {14,  1,   0}, // #3108
  {19,  1,   0}, // #3109
  {22,  3,   0}, // #3110
  { 1,  3,   0}, // #3111
  {11,  3,   0}, // #3112
  {14,  1,   0}, // #3113
  {19,  1,   0}, // #3114
  {22,  3,   0}, // #3115
  { 1,  1,   0}, // #3116
  {22,  1,   0}, // #3117
  { 1,  3,   0}, // #3118
  { 5,  2,   0}, // #3119
  { 6,  2,   0}, // #3120
  { 8,  2,   0}, // #3121
  {22,  3,   0}, // #3122
  {11,  2,   0}, // #3123
  {14,  1,   0}, // #3124
  {19,  1,   0}, // #3125
  { 1,  1,   0}, // #3126
  {13,  1,   0}, // #3127
  {14,  1,   0}, // #3128
  {16,  1,   0}, // #3129
  {19,  1,   0}, // #3130
  {24,  1,   0}, // #3131
  {11,  1,   0}, // #3132
  {14,  1,   0}, // #3133
  {19,  1,   0}, // #3134
  { 1,  3,   0}, // #3135
  {11,  4,   0}, // #3136
  {14,  1,   0}, // #3137
  {19,  1,   0}, // #3138
  {22,  3,   0}, // #3139
  { 1,  3,   0}, // #3140
  {11,  2,   0}, // #3141
  {14,  1,   0}, // #3142
  {19,  1,   0}, // #3143
  {22,  3,   0}, // #3144
  { 1,  3,   0}, // #3145
  {12,  4,   0}, // #3146
  {14,  1,   0}, // #3147
  {15,  1,   0}, // #3148
  {19,  1,   0}, // #3149
  {22,  3,   0}, // #3150
  { 1,  3,   0}, // #3151
  {10,  1,   0}, // #3152
  {14,  1,   0}, // #3153
  {16,  1,   0}, // #3154
  {19,  1,   0}, // #3155
  {22,  3,   0}, // #3156
  { 1,  3,   0}, // #3157
  {12,  7,   0}, // #3158
  {14,  1,   0}, // #3159
  {15,  1,   0}, // #3160
  {19,  1,   0}, // #3161
  {22,  3,   0}, // #3162
  { 1, 23,   0}, // #3163
  { 5,  1,   0}, // #3164
  { 6,  1,   0}, // #3165
  { 8,  1,   0}, // #3166
  {10,  1,   0}, // #3167
  {11, 10,   0}, // #3168
  {14,  1,   0}, // #3169
  {16,  1,   0}, // #3170
  {19,  1,   0}, // #3171
  {22, 13,   0}, // #3172
  {24, 10,   0}, // #3173
  { 1, 20,   0}, // #3174
  { 5,  1,   0}, // #3175
  { 6,  1,   0}, // #3176
  { 8,  1,   0}, // #3177
  {10,  1,   0}, // #3178
  {11, 10,   0}, // #3179
  {14,  1,   0}, // #3180
  {16,  1,   0}, // #3181
  {19,  1,   0}, // #3182
  {22, 10,   0}, // #3183
  {24, 10,   0}, // #3184
  { 1,  3,   0}, // #3185
  { 5,  1,   0}, // #3186
  { 6,  1,   0}, // #3187
  { 8,  1,   0}, // #3188
  {10,  6,   0}, // #3189
  {14,  1,   0}, // #3190
  {16,  1,   0}, // #3191
  {19,  1,   0}, // #3192
  {22,  3,   0}, // #3193
  { 1,  3,   0}, // #3194
  { 5,  1,   0}, // #3195
  { 6,  1,   0}, // #3196
  { 8,  1,   0}, // #3197
  {10,  8,   0}, // #3198
  {14,  1,   0}, // #3199
  {16,  1,   0}, // #3200
  {19,  1,   0}, // #3201
  {22,  3,   0}, // #3202
  { 1,  3,   0}, // #3203
  {11,  1,   0}, // #3204
  {14,  1,   0}, // #3205
  {15,  1,   0}, // #3206
  {19,  1,   0}, // #3207
  {22,  3,   0}, // #3208
  { 1,  3,   0}, // #3209
  {11,  1,   0}, // #3210
  {12,  2,   0}, // #3211
  {14,  3,   0}, // #3212
  {15,  2,   0}, // #3213
  {19,  3,   0}, // #3214
  {22,  3,   0}, // #3215
  { 1,  3,   0}, // #3216
  {22,  2,   0}, // #3217
  {24,  1,   0}, // #3218
  { 1,  4,   0}, // #3219
  { 5,  1,   0}, // #3220
  { 8,  1,   0}, // #3221
  {22,  3,   0}, // #3222
  {24,  1,   0}, // #3223
  { 1,  3,   0}, // #3224
  {13,  1,   0}, // #3225
  {14,  1,   0}, // #3226
  {16,  1,   0}, // #3227
  {19,  1,   0}, // #3228
  {22,  3,   0}, // #3229
  { 1,  3,   0}, // #3230
  {10,  2,   0}, // #3231
  {14,  1,   0}, // #3232
  {16,  1,   0}, // #3233
  {19,  1,   0}, // #3234
  {22,  3,   0}, // #3235
  { 1,  1,   0}, // #3236
  { 5,  1,   0}, // #3237
  { 8,  1,   0}, // #3238
  {24,  1,   0}, // #3239
  { 1,  1,   0}, // #3240
  { 5, 22,   0}, // #3241
  { 8, 22,   0}, // #3242
  {22,  1,   0}, // #3243
  {10, 18,   0}, // #3244
  {14,  1,   0}, // #3245
  {16,  1,   0}, // #3246
  {19,  1,   0}, // #3247
  { 1, 18,   0}, // #3248
  {24, 18,   0}, // #3249
  { 1,  3,   0}, // #3250
  {10,  3,   0}, // #3251
  {14,  1,   0}, // #3252
  {22,  3,   0}, // #3253
  { 1,  3,   0}, // #3254
  {10,  2,   0}, // #3255
  {14,  1,   0}, // #3256
  {15,  1,   0}, // #3257
  {19,  1,   0}, // #3258
  {22,  3,   0}, // #3259
  { 1,  3,   0}, // #3260
  {14,  2,   0}, // #3261
  {16,  2,   0}, // #3262
  {19,  2,   0}, // #3263
  {21,  2,   0}, // #3264
  {22,  3,   0}, // #3265
  { 1,  3,   0}, // #3266
  {11,  2,   0}, // #3267
  {14,  2,   0}, // #3268
  {20,  2,   0}, // #3269
  {22,  3,   0}, // #3270
  { 1,  3,   0}, // #3271
  {11,  1,   0}, // #3272
  {14,  1,   0}, // #3273
  {19,  1,   0}, // #3274
  {22,  3,   0}, // #3275
  { 1,  3,   0}, // #3276
  { 9,  2,   0}, // #3277
  {10,  1,   0}, // #3278
  {13,  1,   0}, // #3279
  {14,  1,   0}, // #3280
  {15,  1,   0}, // #3281
  {19,  1,   0}, // #3282
  {22,  3,   0}, // #3283
  { 1,  1,   0}, // #3284
  { 9,  2,   0}, // #3285
  {10,  1,   0}, // #3286
  {13,  1,   0}, // #3287
  {14,  1,   0}, // #3288
  {15,  1,   0}, // #3289
  {19,  1,   0}, // #3290
  {24,  1,   0}, // #3291
  { 1,  1,   0}, // #3292
  { 9,  2,   0}, // #3293
  {13,  1,   0}, // #3294
  {14,  1,   0}, // #3295
  {15,  1,   0}, // #3296
  {19,  1,   0}, // #3297
  {24,  1,   0}, // #3298
  { 1,  3,   0}, // #3299
  {10, 18,   0}, // #3300
  {14,  2,   0}, // #3301
  {16,  2,   0}, // #3302
  {19,  2,   0}, // #3303
  {22,  3,   0}, // #3304
  { 1,  3,   0}, // #3305
  {10, 25,   0}, // #3306
  {14,  2,   0}, // #3307
  {16,  2,   0}, // #3308
  {19,  2,   0}, // #3309
  {22,  3,   0}, // #3310
  { 1,  3,   0}, // #3311
  {13,  1,   0}, // #3312
  {14,  2,   0}, // #3313
  {16,  2,   0}, // #3314
  {19,  2,   0}, // #3315
  {22,  3,   0}, // #3316
  { 1,  3,   0}, // #3317
  {10,  8,   0}, // #3318
  {14,  1,   0}, // #3319
  {15,  1,   0}, // #3320
  {19,  1,   0}, // #3321
  {22,  3,   0}, // #3322
  { 1,  3,   0}, // #3323
  {11,  3,   0}, // #3324
  {14,  2,   0}, // #3325
  {19,  2,   0}, // #3326
  {22,  3,   0}, // #3327
  { 1,  2,   0}, // #3328
  {10, 376,   0}, // #3329
  {14,  2,   0}, // #3330
  {19,  2,   0}, // #3331
  {24,  2,   0}, // #3332
  { 1,  3,   0}, // #3333
  {10,  4,   0}, // #3334
  {14,  2,   0}, // #3335
  {19,  2,   0}, // #3336
  {22,  3,   0}, // #3337
  { 1,  1,   0}, // #3338
  {10, 188,   0}, // #3339
  {14,  1,   0}, // #3340
  {19,  1,   0}, // #3341
  {24,  1,   0}, // #3342
  { 1,  3,   0}, // #3343
  {10,  4,   0}, // #3344
  {14,  1,   0}, // #3345
  {19,  1,   0}, // #3346
  {22,  3,   0}, // #3347
  {10,  2,   0}, // #3348
  {14,  2,   0}, // #3349
  {19,  2,   0}, // #3350
  { 1,  2,   0}, // #3351
  {13,  2,   0}, // #3352
  {14, 36,   0}, // #3353
  {20, 36,   0}, // #3354
  {24,  2,   0}, // #3355
  {11,  2,   0}, // #3356
  {14,  2,   0}, // #3357
  {19,  2,   0}, // #3358
  { 1,  3,   0}, // #3359
  {11,  4,   0}, // #3360
  {14,  2,   0}, // #3361
  {19,  2,   0}, // #3362
  {22,  3,   0}, // #3363
  { 1,  2,   0}, // #3364
  {13,  2,   0}, // #3365
  {14,  2,   0}, // #3366
  {16,  2,   0}, // #3367
  {19,  2,   0}, // #3368
  {24,  2,   0}, // #3369
  { 1,  3,   0}, // #3370
  { 5,  1,   0}, // #3371
  { 6,  1,   0}, // #3372
  { 8,  1,   0}, // #3373
  {10,  4,   0}, // #3374
  {14,  2,   0}, // #3375
  {19,  2,   0}, // #3376
  {22,  3,   0}, // #3377
  { 1,  3,   0}, // #3378
  {10,  1,   0}, // #3379
  {14,  2,   0}, // #3380
  {16,  2,   0}, // #3381
  {19,  2,   0}, // #3382
  {22,  3,   0}, // #3383
  { 1,  3,   0}, // #3384
  {10,  2,   0}, // #3385
  {14,  2,   0}, // #3386
  {16,  2,   0}, // #3387
  {19,  2,   0}, // #3388
  {22,  3,   0}, // #3389
  { 1,  3,   0}, // #3390
  { 5,  1,   0}, // #3391
  { 6,  1,   0}, // #3392
  { 8,  1,   0}, // #3393
  {10,  4,   0}, // #3394
  {14,  4,   0}, // #3395
  {19,  4,   0}, // #3396
  {22,  3,   0}, // #3397
  { 9,  3,   0}, // #3398
  {13,  1,   0}, // #3399
  {14,  1,   0}, // #3400
  {15,  1,   0}, // #3401
  {19,  1,   0}, // #3402
  { 5, 23,   0}, // #3403
  { 7, 23,   0}, // #3404
  { 8, 23,   0}, // #3405
  { 5, 21,   0}, // #3406
  { 7, 21,   0}, // #3407
  { 8, 21,   0}, // #3408
  { 5, 26,   0}, // #3409
  { 7, 26,   0}, // #3410
  { 8, 26,   0}, // #3411
  { 5, 69,   0}, // #3412
  { 7, 69,   0}, // #3413
  { 8, 69,   0}, // #3414
  { 5, 14,   0}, // #3415
  { 8, 14,   0}, // #3416
  { 5, 25,   0}, // #3417
  { 8, 25,   0}, // #3418
  { 5, 20,   0}, // #3419
  { 7, 20,   0}, // #3420
  { 8, 20,   0}, // #3421
  { 1,  3,   0}, // #3422
  {10, 10,   0}, // #3423
  {14,  1,   0}, // #3424
  {15,  1,   0}, // #3425
  {19,  1,   0}, // #3426
  {22,  3,   0}, // #3427
  { 1,  3,   0}, // #3428
  {10, 18,   0}, // #3429
  {14,  1,   0}, // #3430
  {15,  1,   0}, // #3431
  {19,  1,   0}, // #3432
  {22,  3,   0}, // #3433
  { 1,  1,   0}, // #3434
  {10,  4,   0}, // #3435
  {14,  2,   0}, // #3436
  {19,  2,   0}, // #3437
  {22,  1,   0}, // #3438
  { 5, 375,   0}, // #3439
  { 8, 375,   0}, // #3440
  { 5, 24,   0}, // #3441
  { 8, 24,   0}, // #3442
  {10,  6,   0}, // #3443
  {14,  1,   0}, // #3444
  {19,  1,   0}, // #3445
  {10,  8,   0}, // #3446
  {14,  1,   0}, // #3447
  {19,  1,   0}, // #3448
  { 5,  3,   0}, // #3449
  { 8,  3,   0}, // #3450
  { 5, 18,   0}, // #3451
  { 8, 18,   0}, // #3452
  { 5, 88,   0}, // #3453
  { 8, 88,   0}, // #3454
  { 1,  3,   0}, // #3455
  { 5,  3,   0}, // #3456
  { 8,  3,   0}, // #3457
  {22,  3,   0}, // #3458
  { 5, 10,   0}, // #3459
  { 8, 10,   0}, // #3460
  { 5, 12,   0}, // #3461
  { 8, 12,   0}, // #3462
  { 5, 17,   0}, // #3463
  { 8, 17,   0}, // #3464
  { 5,  5,   0}, // #3465
  { 8,  5,   0}, // #3466
  { 5, 23,   0}, // #3467
  { 8, 23,   0}, // #3468
  { 5, 20,   0}, // #3469
  { 8, 20,   0}, // #3470
  { 5, 19,   0}, // #3471
  { 8, 19,   0}, // #3472
  { 5, 13,   0}, // #3473
  { 8, 13,   0}, // #3474
  { 5, 21,   0}, // #3475
  { 8, 21,   0}, // #3476
  { 5, 15,   0}, // #3477
  { 8, 15,   0}, // #3478
  {13,  1,   0}, // #3479
  {14, 10,   0}, // #3480
  {16, 10,   0}, // #3481
  {19, 10,   0}, // #3482
  {13,  1,   0}, // #3483
  {14,  3,   0}, // #3484
  {16,  3,   0}, // #3485
  {19,  3,   0}, // #3486
  {13,  1,   0}, // #3487
  {14,  4,   0}, // #3488
  {16,  4,   0}, // #3489
  {19,  4,   0}, // #3490
  {11,  1,   0}, // #3491
  {12,  1,   0}, // #3492
  {14,  1,   0}, // #3493
  {15,  1,   0}, // #3494
  {19,  1,   0}, // #3495
  {11,  1,   0}, // #3496
  {22,  1,   0}, // #3497
  { 1,  1,   0}, // #3498
  { 4,  1,   0}, // #3499
  { 1,  2,   0}, // #3500
  { 4,  1,   0}, // #3501
  {11,  1,   0}, // #3502
  {15,  1,   0}, // #3503
  {18,  1,   0}, // #3504
  {20,  1,   0}, // #3505
  {21,  1,   0}, // #3506
  {22,  1,   0}, // #3507
  { 1,  1,   0}, // #3508
  {11,  1,   0}, // #3509
  {21,  1,   0}, // #3510
  { 1,  1,   0}, // #3511
  {11,  1,   0}, // #3512
  {16,  1,   0}, // #3513
  {22,  1,   0}, // #3514
  { 1,  1,   0}, // #3515
  { 4,  2,   0}, // #3516
  { 1,  1,   0}, // #3517
  { 4, 12,   0}, // #3518
  { 1,  1,   0}, // #3519
  { 4, 16,   0}, // #3520
  { 1,  1,   0}, // #3521
  {11,  2,   0}, // #3522
  {14,  1,   0}, // #3523
  {16,  1,   0}, // #3524
  {17,  1,   0}, // #3525
  {19,  1,   0}, // #3526
  {21,  1,   0}, // #3527
  {22,  1,   0}, // #3528
  { 1,  1,   0}, // #3529
  {11,  1,   0}, // #3530
  {12,  1,   0}, // #3531
  {16,  1,   0}, // #3532
  {17,  1,   0}, // #3533
  {18,  1,   0}, // #3534
  {22,  1,   0}, // #3535
  { 1,  1,   0}, // #3536
  {11,  1,   0}, // #3537
  {15,  1,   0}, // #3538
  {18,  1,   0}, // #3539
  {20,  1,   0}, // #3540
  {21,  1,   0}, // #3541
  {22,  1,   0}, // #3542
  { 1,  1,   0}, // #3543
  {11,  2,   0}, // #3544
  {15,  2,   0}, // #3545
  {18,  2,   0}, // #3546
  {20,  2,   0}, // #3547
  {21,  2,   0}, // #3548
  {22,  2,   0}, // #3549
  { 1,  1,   0}, // #3550
  { 4,  1,   0}, // #3551
  { 7,  1,   0}, // #3552
  {10, 17,   0}, // #3553
  { 1,  1,   0}, // #3554
  { 4,  1,   0}, // #3555
  { 7,  1,   0}, // #3556
  {10, 25,   0}, // #3557
  { 1,  1,   0}, // #3558
  { 4,  1,   0}, // #3559
  { 7,  1,   0}, // #3560
  {10, 41,   0}, // #3561
  { 1,  1,   0}, // #3562
  { 4,  1,   0}, // #3563
  { 7,  1,   0}, // #3564
  {10, 15,   0}, // #3565
  { 1,  1,   0}, // #3566
  {11,  5,   0}, // #3567
  {15,  5,   0}, // #3568
  {18,  5,   0}, // #3569
  {20,  5,   0}, // #3570
  {21,  5,   0}, // #3571
  {22,  5,   0}, // #3572
  { 1,  1,   0}, // #3573
  {11,  3,   0}, // #3574
  {15,  3,   0}, // #3575
  {18,  3,   0}, // #3576
  {20,  3,   0}, // #3577
  {21,  3,   0}, // #3578
  {22,  3,   0}, // #3579
  { 1,  1,   0}, // #3580
  {11,  5,   0}, // #3581
  {14,  3,   0}, // #3582
  {17,  3,   0}, // #3583
  {19,  5,   0}, // #3584
  {21,  3,   0}, // #3585
  {11,  3,   0}, // #3586
  {14,  2,   0}, // #3587
  {17,  2,   0}, // #3588
  {19,  3,   0}, // #3589
  {21,  2,   0}, // #3590
  { 1,  1,   0}, // #3591
  {11,  1,   0}, // #3592
  {22,  1,   0}, // #3593
  { 1,  1,   0}, // #3594
  { 4,  1,   0}, // #3595
  { 6,  1,   0}, // #3596
  {23,  1,   0}, // #3597
  { 1,  1,   0}, // #3598
  {11,  1,   0}, // #3599
  {19,  1,   0}, // #3600
  { 1,  1,   0}, // #3601
  {11,  1,   0}, // #3602
  {20,  1,   0}, // #3603
  {22,  1,   0}, // #3604
  {11,  1,   0}, // #3605
  {14,  1,   0}, // #3606
  {17,  1,   0}, // #3607
  {19,  1,   0}, // #3608
  {21,  1,   0}, // #3609
  { 1,  1,   0}, // #3610
  {11,  1,   0}, // #3611
  {14,  1,   0}, // #3612
  {17,  1,   0}, // #3613
  {19,  1,   0}, // #3614
  {21,  1,   0}, // #3615
  { 1,  1,   0}, // #3616
  { 4,  1,   0}, // #3617
  { 6,  1,   0}, // #3618
  {23,  2,   0}, // #3619
  { 1,  1,   0}, // #3620
  {11,  2,   0}, // #3621
  {12,  2,   0}, // #3622
  {16,  2,   0}, // #3623
  {17,  2,   0}, // #3624
  {18,  2,   0}, // #3625
  {22,  2,   0}, // #3626
  { 1,  1,   0}, // #3627
  {11,  2,   0}, // #3628
  {19,  2,   0}, // #3629
  { 1,  1,   0}, // #3630
  {11,  8,   0}, // #3631
  {15,  8,   0}, // #3632
  {18,  8,   0}, // #3633
  {20,  8,   0}, // #3634
  {21,  8,   0}, // #3635
  {22,  8,   0}, // #3636
  {11, 20,   0}, // #3637
  {15, 20,   0}, // #3638
  {18, 20,   0}, // #3639
  {20, 20,   0}, // #3640
  {21, 20,   0}, // #3641
  {22, 20,   0}, // #3642
  { 1,  1,   0}, // #3643
  {11,  2,   0}, // #3644
  {21,  2,   0}, // #3645
  { 1,  1,   0}, // #3646
  {11,  2,   0}, // #3647
  {16,  2,   0}, // #3648
  {22,  2,   0}, // #3649
  { 1,  1,   0}, // #3650
  {11,  6,   0}, // #3651
  {15,  6,   0}, // #3652
  {18,  6,   0}, // #3653
  {20,  6,   0}, // #3654
  {21,  6,   0}, // #3655
  {22,  6,   0}, // #3656
  { 1,  1,   0}, // #3657
  {11,  9,   0}, // #3658
  {15,  9,   0}, // #3659
  {18,  9,   0}, // #3660
  {20,  9,   0}, // #3661
  {21,  9,   0}, // #3662
  {22,  9,   0}, // #3663
  { 1,  1,   0}, // #3664
  {11,  2,   0}, // #3665
  {22,  2,   0}, // #3666
  { 1,  1,   0}, // #3667
  {11,  3,   0}, // #3668
  {16,  3,   0}, // #3669
  {22,  3,   0}, // #3670
  { 1,  1,   0}, // #3671
  {11,  4,   0}, // #3672
  {19,  4,   0}, // #3673
  {11,  2,   0}, // #3674
  {14,  2,   0}, // #3675
  {17,  2,   0}, // #3676
  {19,  2,   0}, // #3677
  {21,  2,   0}, // #3678
  { 1,  1,   0}, // #3679
  {11,  4,   0}, // #3680
  {12,  4,   0}, // #3681
  {16,  4,   0}, // #3682
  {17,  4,   0}, // #3683
  {18,  4,   0}, // #3684
  {22,  4,   0}, // #3685
  { 1,  1,   0}, // #3686
  {11,  2,   0}, // #3687
  {14,  2,   0}, // #3688
  {17,  2,   0}, // #3689
  {19,  2,   0}, // #3690
  {21,  2,   0}, // #3691
  { 1,  1,   0}, // #3692
  {11,  2,   0}, // #3693
  {13,  2,   0}, // #3694
  {16,  2,   0}, // #3695
  {19,  2,   0}, // #3696
  {20,  2,   0}, // #3697
  {22,  2,   0}, // #3698
  { 1,  1,   0}, // #3699
  {11,  4,   0}, // #3700
  {13,  4,   0}, // #3701
  {16,  4,   0}, // #3702
  {19,  4,   0}, // #3703
  {20,  4,   0}, // #3704
  {22,  4,   0}, // #3705
  { 1,  1,   0}, // #3706
  {11, 10,   0}, // #3707
  {15, 10,   0}, // #3708
  {18, 10,   0}, // #3709
  {20, 10,   0}, // #3710
  {21, 10,   0}, // #3711
  {22, 10,   0}, // #3712
  { 1,  1,   0}, // #3713
  {11, 16,   0}, // #3714
  {15, 16,   0}, // #3715
  {18, 16,   0}, // #3716
  {20, 16,   0}, // #3717
  {21, 16,   0}, // #3718
  {22, 16,   0}, // #3719
  {11,  2,   0}, // #3720
  {15,  1,   0}, // #3721
  {18,  1,   0}, // #3722
  {19,  1,   0}, // #3723
  {20,  1,   0}, // #3724
  {21,  1,   0}, // #3725
  {22,  1,   0}, // #3726
  { 1,  1,   0}, // #3727
  {11,  2,   0}, // #3728
  {15,  1,   0}, // #3729
  {18,  1,   0}, // #3730
  {19,  1,   0}, // #3731
  {20,  1,   0}, // #3732
  {21,  1,   0}, // #3733
  {22,  1,   0}, // #3734
  { 4,  1,   0}, // #3735
  { 9,  1,   0}, // #3736
  { 1,  1,   0}, // #3737
  {11,  1,   0}, // #3738
  {17,  1,   0}, // #3739
  { 1,  5,   0}, // #3740
  {11,  3,   0}, // #3741
  {14,  2,   0}, // #3742
  {17,  2,   0}, // #3743
  {19,  3,   0}, // #3744
  {21,  2,   0}, // #3745
  { 1,  1,   0}, // #3746
  {11,  1,   0}, // #3747
  {18,  1,   0}, // #3748
  {22,  1,   0}, // #3749
  { 1,  1,   0}, // #3750
  {11,  3,   0}, // #3751
  {18,  3,   0}, // #3752
  {22,  3,   0}, // #3753
  { 1,  1,   0}, // #3754
  {11,  2,   0}, // #3755
  {18,  2,   0}, // #3756
  {22,  2,   0}, // #3757
  { 1,  1,   0}, // #3758
  { 4,  1,   0}, // #3759
  { 9,  1,   0}, // #3760
  {11,  6,   0}, // #3761
  {12,  3,   0}, // #3762
  {16,  3,   0}, // #3763
  {17,  3,   0}, // #3764
  {18,  3,   0}, // #3765
  {19,  3,   0}, // #3766
  {22,  3,   0}, // #3767
  { 1,  1,   0}, // #3768
  {11,  6,   0}, // #3769
  {12,  3,   0}, // #3770
  {16,  3,   0}, // #3771
  {17,  3,   0}, // #3772
  {18,  3,   0}, // #3773
  {19,  3,   0}, // #3774
  {22,  3,   0}, // #3775
  {11,  2,   0}, // #3776
  {15,  1,   0}, // #3777
  {18,  1,   0}, // #3778
  {20,  1,   0}, // #3779
  {21,  1,   0}, // #3780
  {22,  2,   0}, // #3781
  {11,  2,   0}, // #3782
  {14,  1,   0}, // #3783
  {15,  1,   0}, // #3784
  {17,  1,   0}, // #3785
  {18,  1,   0}, // #3786
  {19,  1,   0}, // #3787
  {20,  1,   0}, // #3788
  {21,  2,   0}, // #3789
  {22,  1,   0}, // #3790
  { 1,  1,   0}, // #3791
  {11,  2,   0}, // #3792
  {14,  1,   0}, // #3793
  {15,  1,   0}, // #3794
  {17,  1,   0}, // #3795
  {18,  1,   0}, // #3796
  {19,  1,   0}, // #3797
  {20,  1,   0}, // #3798
  {21,  2,   0}, // #3799
  {22,  1,   0}, // #3800
  {11,  2,   0}, // #3801
  {14,  1,   0}, // #3802
  {17,  1,   0}, // #3803
  {19,  2,   0}, // #3804
  {21,  1,   0}, // #3805
  {11,  2,   0}, // #3806
  {13,  1,   0}, // #3807
  {16,  1,   0}, // #3808
  {18,  1,   0}, // #3809
  {19,  1,   0}, // #3810
  {20,  1,   0}, // #3811
  {22,  2,   0}, // #3812
  {11,  1,   0}, // #3813
  {13,  1,   0}, // #3814
  {16,  1,   0}, // #3815
  {19,  1,   0}, // #3816
  {20,  1,   0}, // #3817
  {22,  1,   0}, // #3818
  { 1,  1,   0}, // #3819
  {11,  1,   0}, // #3820
  {13,  1,   0}, // #3821
  {16,  1,   0}, // #3822
  {19,  1,   0}, // #3823
  {20,  1,   0}, // #3824
  {22,  1,   0}, // #3825
  {22,  1,   0}, // #3826
  {23,  1,   0}, // #3827
  {15,  1,   0}, // #3828
  {19,  1,   0}, // #3829
  {22,  1,   0}, // #3830
  {23,  1,   0}, // #3831
  {14,  1,   0}, // #3832
  {20,  1,   0}, // #3833
  {22,  1,   0}, // #3834
  {23,  1,   0}, // #3835
  { 7,  1,   0}, // #3836
  {12,  1,   0}, // #3837
  {14,  2,   0}, // #3838
  {17,  1,   0}, // #3839
  {20,  2,   0}, // #3840
  {21,  2,   0}, // #3841
  {22,  3,   0}, // #3842
  {23,  6,   0}, // #3843
  {14,  1,   0}, // #3844
  {17,  1,   0}, // #3845
  {20,  1,   0}, // #3846
  {21,  1,   0}, // #3847
  {22,  1,   0}, // #3848
  {23,  2,   0}, // #3849
  { 7,  1,   0}, // #3850
  {12,  1,   0}, // #3851
  {21,  1,   0}, // #3852
  {23,  2,   0}, // #3853
  { 4,  1,   0}, // #3854
  {11,  1,   0}, // #3855
  {15,  1,   0}, // #3856
  {16,  1,   0}, // #3857
  {19,  1,   0}, // #3858
  {22,  1,   0}, // #3859
  {23,  1,   0}, // #3860
  {17,  1,   0}, // #3861
  {21,  1,   0}, // #3862
  {23,  1,   0}, // #3863
  { 7,  1,   0}, // #3864
  {12,  1,   0}, // #3865
  {17,  1,   0}, // #3866
  {21,  2,   0}, // #3867
  {22,  1,   0}, // #3868
  {23,  4,   0}, // #3869
  { 8,  1,   0}, // #3870
  {13,  1,   0}, // #3871
  {15,  1,   0}, // #3872
  {18,  1,   0}, // #3873
  {19,  1,   0}, // #3874
  {20,  1,   0}, // #3875
  {22,  1,   0}, // #3876
  {23,  1,   0}, // #3877
  {17,  1,   0}, // #3878
  {21,  1,   0}, // #3879
  {22,  1,   0}, // #3880
  {23,  2,   0}, // #3881
  { 4,  1,   0}, // #3882
  {11,  1,   0}, // #3883
  {15,  1,   0}, // #3884
  {16,  1,   0}, // #3885
  {17,  1,   0}, // #3886
  {19,  1,   0}, // #3887
  {21,  1,   0}, // #3888
  {22,  1,   0}, // #3889
  {23,  2,   0}, // #3890
  { 8,  1,   0}, // #3891
  {13,  1,   0}, // #3892
  {15,  1,   0}, // #3893
  {17,  1,   0}, // #3894
  {18,  1,   0}, // #3895
  {19,  1,   0}, // #3896
  {20,  1,   0}, // #3897
  {21,  1,   0}, // #3898
  {22,  1,   0}, // #3899
  {23,  2,   0}, // #3900
  { 8,  2,   0}, // #3901
  {13,  2,   0}, // #3902
  {15,  2,   0}, // #3903
  {17,  1,   0}, // #3904
  {18,  2,   0}, // #3905
  {19,  2,   0}, // #3906
  {20,  2,   0}, // #3907
  {21,  1,   0}, // #3908
  {22,  2,   0}, // #3909
  {23,  3,   0}, // #3910
  { 8,  2,   0}, // #3911
  {13,  2,   0}, // #3912
  {15,  2,   0}, // #3913
  {18,  2,   0}, // #3914
  {19,  2,   0}, // #3915
  {20,  2,   0}, // #3916
  {22,  2,   0}, // #3917
  {23,  2,   0}, // #3918
  { 3,  2,   0}, // #3919
  { 8,  7,   0}, // #3920
  {11,  2,   0}, // #3921
  {12,  2,   0}, // #3922
  {13,  9,   0}, // #3923
  {14,  2,   0}, // #3924
  {15,  7,   0}, // #3925
  {17,  1,   0}, // #3926
  {18,  7,   0}, // #3927
  {19, 10,   0}, // #3928
  {20,  9,   0}, // #3929
  {21,  1,   0}, // #3930
  {22, 10,   0}, // #3931
  {23, 11,   0}, // #3932
  { 3,  2,   0}, // #3933
  { 8,  7,   0}, // #3934
  {11,  2,   0}, // #3935
  {12,  2,   0}, // #3936
  {13,  9,   0}, // #3937
  {14,  2,   0}, // #3938
  {15,  7,   0}, // #3939
  {18,  7,   0}, // #3940
  {19, 11,   0}, // #3941
  {20,  9,   0}, // #3942
  {22, 11,   0}, // #3943
  {23, 11,   0}, // #3944
  {14,  1,   0}, // #3945
  {15,  1,   0}, // #3946
  {17,  1,   0}, // #3947
  {19,  1,   0}, // #3948
  {20,  1,   0}, // #3949
  {21,  1,   0}, // #3950
  {22,  2,   0}, // #3951
  {23,  3,   0}, // #3952
  {14,  1,   0}, // #3953
  {15,  1,   0}, // #3954
  {19,  1,   0}, // #3955
  {20,  1,   0}, // #3956
  {22,  2,   0}, // #3957
  {23,  2,   0}, // #3958
  {15,  1,   0}, // #3959
  {17,  1,   0}, // #3960
  {19,  1,   0}, // #3961
  {21,  1,   0}, // #3962
  {22,  1,   0}, // #3963
  {23,  2,   0}, // #3964
  { 7,  1,   0}, // #3965
  {12,  1,   0}, // #3966
  {14,  1,   0}, // #3967
  {17,  1,   0}, // #3968
  {20,  1,   0}, // #3969
  {21,  2,   0}, // #3970
  {22,  1,   0}, // #3971
  {23,  4,   0}, // #3972
  {22,  3,   0}, // #3973
  {23,  3,   0}, // #3974
  {14,  2,   0}, // #3975
  {20,  2,   0}, // #3976
  {22,  5,   0}, // #3977
  {23,  5,   0}, // #3978
  { 4,  1,   0}, // #3979
  { 8,  1,   0}, // #3980
  {11,  1,   0}, // #3981
  {13,  1,   0}, // #3982
  {15,  2,   0}, // #3983
  {16,  1,   0}, // #3984
  {18,  1,   0}, // #3985
  {19,  2,   0}, // #3986
  {20,  1,   0}, // #3987
  {22,  2,   0}, // #3988
  {23,  2,   0}, // #3989
  { 4,  1,   0}, // #3990
  { 8,  1,   0}, // #3991
  {11,  1,   0}, // #3992
  {13,  1,   0}, // #3993
  {15,  2,   0}, // #3994
  {16,  1,   0}, // #3995
  {17,  1,   0}, // #3996
  {18,  1,   0}, // #3997
  {19,  2,   0}, // #3998
  {20,  1,   0}, // #3999
  {21,  1,   0}, // #4000
  {22,  2,   0}, // #4001
  {23,  3,   0}, // #4002
  { 3,  1,   0}, // #4003
  {11,  1,   0}, // #4004
  {12,  1,   0}, // #4005
  {13,  1,   0}, // #4006
  {14,  1,   0}, // #4007
  {17,  1,   0}, // #4008
  {19,  1,   0}, // #4009
  {20,  1,   0}, // #4010
  {21,  1,   0}, // #4011
  {22,  1,   0}, // #4012
  {23,  2,   0}, // #4013
  { 3,  1,   0}, // #4014
  { 8,  1,   0}, // #4015
  {11,  1,   0}, // #4016
  {12,  1,   0}, // #4017
  {13,  2,   0}, // #4018
  {14,  1,   0}, // #4019
  {15,  1,   0}, // #4020
  {18,  1,   0}, // #4021
  {19,  2,   0}, // #4022
  {20,  2,   0}, // #4023
  {22,  2,   0}, // #4024
  {23,  2,   0}, // #4025
  { 3,  1,   0}, // #4026
  { 4,  1,   0}, // #4027
  {11,  2,   0}, // #4028
  {12,  1,   0}, // #4029
  {13,  1,   0}, // #4030
  {14,  1,   0}, // #4031
  {15,  1,   0}, // #4032
  {16,  1,   0}, // #4033
  {17,  1,   0}, // #4034
  {19,  2,   0}, // #4035
  {20,  1,   0}, // #4036
  {21,  1,   0}, // #4037
  {22,  2,   0}, // #4038
  {23,  3,   0}, // #4039
  { 3,  1,   0}, // #4040
  { 4,  1,   0}, // #4041
  {11,  2,   0}, // #4042
  {12,  1,   0}, // #4043
  {13,  1,   0}, // #4044
  {14,  1,   0}, // #4045
  {15,  1,   0}, // #4046
  {16,  1,   0}, // #4047
  {19,  2,   0}, // #4048
  {20,  1,   0}, // #4049
  {22,  2,   0}, // #4050
  {23,  2,   0}, // #4051
  { 3,  2,   0}, // #4052
  { 4,  2,   0}, // #4053
  { 8,  2,   0}, // #4054
  {11,  4,   0}, // #4055
  {12,  2,   0}, // #4056
  {13,  4,   0}, // #4057
  {14,  2,   0}, // #4058
  {15,  4,   0}, // #4059
  {16,  2,   0}, // #4060
  {17,  1,   0}, // #4061
  {18,  2,   0}, // #4062
  {19,  6,   0}, // #4063
  {20,  4,   0}, // #4064
  {21,  1,   0}, // #4065
  {22,  7,   0}, // #4066
  {23,  8,   0}, // #4067
  { 3,  7,   0}, // #4068
  { 4,  7,   0}, // #4069
  { 8,  3,   0}, // #4070
  { 9,  3,   0}, // #4071
  {11, 15,   0}, // #4072
  {12,  7,   0}, // #4073
  {13, 10,   0}, // #4074
  {14, 10,   0}, // #4075
  {15, 10,   0}, // #4076
  {16, 10,   0}, // #4077
  {18,  6,   0}, // #4078
  {19, 18,   0}, // #4079
  {20, 13,   0}, // #4080
  {22, 32,   0}, // #4081
  {23, 32,   0}, // #4082
  { 1, 10,   0}, // #4083
  { 3,  1,   0}, // #4084
  {11,  1,   0}, // #4085
  {12,  1,   0}, // #4086
  {13,  1,   0}, // #4087
  {14,  1,   0}, // #4088
  {19,  1,   0}, // #4089
  {20,  1,   0}, // #4090
  {22,  1,   0}, // #4091
  {23,  1,   0}, // #4092
  { 2,  8,   0}, // #4093
  { 3,  1,   0}, // #4094
  {11,  1,   0}, // #4095
  {12,  1,   0}, // #4096
  {13,  1,   0}, // #4097
  {14,  1,   0}, // #4098
  {17,  1,   0}, // #4099
  {19,  1,   0}, // #4100
  {20,  1,   0}, // #4101
  {21,  1,   0}, // #4102
  {22,  1,   0}, // #4103
  {23,  2,   0}, // #4104
  { 2,  8,   0}, // #4105
  { 3,  1,   0}, // #4106
  {11,  1,   0}, // #4107
  {12,  1,   0}, // #4108
  {13,  1,   0}, // #4109
  {14,  1,   0}, // #4110
  {19,  1,   0}, // #4111
  {20,  1,   0}, // #4112
  {22,  1,   0}, // #4113
  {23,  1,   0}, // #4114
  { 2,  5,   0}, // #4115
  { 3,  1,   0}, // #4116
  {11,  1,   0}, // #4117
  {12,  1,   0}, // #4118
  {13,  1,   0}, // #4119
  {14,  1,   0}, // #4120
  {17,  1,   0}, // #4121
  {19,  1,   0}, // #4122
  {20,  1,   0}, // #4123
  {21,  1,   0}, // #4124
  {22,  1,   0}, // #4125
  {23,  2,   0}, // #4126
  { 2,  5,   0}, // #4127
  { 3,  1,   0}, // #4128
  {11,  1,   0}, // #4129
  {12,  1,   0}, // #4130
  {13,  1,   0}, // #4131
  {14,  1,   0}, // #4132
  {19,  1,   0}, // #4133
  {20,  1,   0}, // #4134
  {22,  1,   0}, // #4135
  {23,  1,   0}, // #4136
  { 2,  3,   0}, // #4137
  { 3,  1,   0}, // #4138
  {11,  1,   0}, // #4139
  {12,  1,   0}, // #4140
  {13,  1,   0}, // #4141
  {14,  1,   0}, // #4142
  {19,  1,   0}, // #4143
  {20,  1,   0}, // #4144
  {22,  1,   0}, // #4145
  {23,  1,   0}, // #4146
  { 2,  4,   0}, // #4147
  { 3,  1,   0}, // #4148
  {11,  1,   0}, // #4149
  {12,  1,   0}, // #4150
  {13,  1,   0}, // #4151
  {14,  1,   0}, // #4152
  {19,  1,   0}, // #4153
  {20,  1,   0}, // #4154
  {22,  1,   0}, // #4155
  {23,  1,   0}, // #4156
  { 3,  1,   0}, // #4157
  { 4,  1,   0}, // #4158
  { 8,  1,   0}, // #4159
  {11,  2,   0}, // #4160
  {12,  1,   0}, // #4161
  {13,  2,   0}, // #4162
  {14,  1,   0}, // #4163
  {15,  2,   0}, // #4164
  {16,  1,   0}, // #4165
  {17,  1,   0}, // #4166
  {18,  1,   0}, // #4167
  {19,  3,   0}, // #4168
  {20,  2,   0}, // #4169
  {21,  1,   0}, // #4170
  {22,  3,   0}, // #4171
  {23,  4,   0}, // #4172
  { 3,  1,   0}, // #4173
  { 4,  1,   0}, // #4174
  { 8,  1,   0}, // #4175
  {11,  2,   0}, // #4176
  {12,  1,   0}, // #4177
  {13,  2,   0}, // #4178
  {14,  1,   0}, // #4179
  {15,  2,   0}, // #4180
  {16,  1,   0}, // #4181
  {18,  1,   0}, // #4182
  {19,  3,   0}, // #4183
  {20,  2,   0}, // #4184
  {22,  3,   0}, // #4185
  {23,  3,   0}, // #4186
  { 3,  2,   0}, // #4187
  { 4,  1,   0}, // #4188
  { 8,  1,   0}, // #4189
  {11,  3,   0}, // #4190
  {12,  2,   0}, // #4191
  {13,  3,   0}, // #4192
  {14,  3,   0}, // #4193
  {15,  2,   0}, // #4194
  {16,  1,   0}, // #4195
  {17,  1,   0}, // #4196
  {18,  1,   0}, // #4197
  {19,  4,   0}, // #4198
  {20,  4,   0}, // #4199
  {21,  1,   0}, // #4200
  {22,  5,   0}, // #4201
  {23,  6,   0}, // #4202
  { 3,  2,   0}, // #4203
  { 4,  1,   0}, // #4204
  { 8,  1,   0}, // #4205
  {11,  3,   0}, // #4206
  {12,  2,   0}, // #4207
  {13,  3,   0}, // #4208
  {14,  2,   0}, // #4209
  {15,  2,   0}, // #4210
  {16,  1,   0}, // #4211
  {18,  1,   0}, // #4212
  {19,  4,   0}, // #4213
  {20,  3,   0}, // #4214
  {22,  4,   0}, // #4215
  {23,  4,   0}, // #4216
  { 7,  1,   0}, // #4217
  { 8,  1,   0}, // #4218
  {12,  1,   0}, // #4219
  {13,  1,   0}, // #4220
  {15,  1,   0}, // #4221
  {18,  1,   0}, // #4222
  {19,  1,   0}, // #4223
  {20,  1,   0}, // #4224
  {21,  1,   0}, // #4225
  {22,  1,   0}, // #4226
  {23,  3,   0}, // #4227
  {11,  8,   0}, // #4228
  {15,  1,   0}, // #4229
  {19, 30,   0}, // #4230
  {22, 31,   0}, // #4231
  {23, 31,   0}, // #4232
  {11,  2,   0}, // #4233
  {19,  2,   0}, // #4234
  {22,  2,   0}, // #4235
  {23,  2,   0}, // #4236
  { 4,  1,   0}, // #4237
  { 8,  2,   0}, // #4238
  {11,  1,   0}, // #4239
  {13,  2,   0}, // #4240
  {15,  3,   0}, // #4241
  {16,  1,   0}, // #4242
  {17,  1,   0}, // #4243
  {18,  2,   0}, // #4244
  {19,  3,   0}, // #4245
  {20,  2,   0}, // #4246
  {21,  1,   0}, // #4247
  {22,  3,   0}, // #4248
  {23,  4,   0}, // #4249
  { 4,  1,   0}, // #4250
  { 8,  2,   0}, // #4251
  {11,  1,   0}, // #4252
  {13,  2,   0}, // #4253
  {15,  3,   0}, // #4254
  {16,  1,   0}, // #4255
  {18,  2,   0}, // #4256
  {19,  3,   0}, // #4257
  {20,  2,   0}, // #4258
  {22,  3,   0}, // #4259
  {23,  3,   0}, // #4260
  { 4,  1,   0}, // #4261
  {11,  1,   0}, // #4262
  {14,  1,   0}, // #4263
  {15,  1,   0}, // #4264
  {16,  1,   0}, // #4265
  {17,  1,   0}, // #4266
  {19,  1,   0}, // #4267
  {20,  1,   0}, // #4268
  {21,  1,   0}, // #4269
  {22,  4,   0}, // #4270
  {23,  5,   0}, // #4271
  { 4,  1,   0}, // #4272
  {11,  1,   0}, // #4273
  {14,  1,   0}, // #4274
  {15,  1,   0}, // #4275
  {16,  1,   0}, // #4276
  {19,  1,   0}, // #4277
  {20,  1,   0}, // #4278
  {22,  4,   0}, // #4279
  {23,  4,   0}, // #4280
  { 4,  1,   0}, // #4281
  {11,  1,   0}, // #4282
  {15,  1,   0}, // #4283
  {16,  1,   0}, // #4284
  {17,  1,   0}, // #4285
  {19,  1,   0}, // #4286
  {21,  1,   0}, // #4287
  {22,  2,   0}, // #4288
  {23,  3,   0}, // #4289
  { 4,  1,   0}, // #4290
  {11,  1,   0}, // #4291
  {15,  1,   0}, // #4292
  {16,  1,   0}, // #4293
  {19,  1,   0}, // #4294
  {22,  2,   0}, // #4295
  {23,  2,   0}, // #4296
  { 4,  1,   0}, // #4297
  {11,  1,   0}, // #4298
  {14,  1,   0}, // #4299
  {15,  1,   0}, // #4300
  {16,  1,   0}, // #4301
  {17,  1,   0}, // #4302
  {19,  1,   0}, // #4303
  {20,  1,   0}, // #4304
  {21,  1,   0}, // #4305
  {22,  3,   0}, // #4306
  {23,  4,   0}, // #4307
  { 4,  1,   0}, // #4308
  {11,  1,   0}, // #4309
  {14,  1,   0}, // #4310
  {15,  1,   0}, // #4311
  {16,  1,   0}, // #4312
  {19,  1,   0}, // #4313
  {20,  1,   0}, // #4314
  {22,  3,   0}, // #4315
  {23,  3,   0}, // #4316
  { 3,  1,   0}, // #4317
  {11,  1,   0}, // #4318
  {12,  1,   0}, // #4319
  {13,  1,   0}, // #4320
  {14,  1,   0}, // #4321
  {17,  1,   0}, // #4322
  {19,  1,   0}, // #4323
  {20,  1,   0}, // #4324
  {21,  1,   0}, // #4325
  {22,  2,   0}, // #4326
  {23,  3,   0}, // #4327
  {11,  1,   0}, // #4328
  {19,  1,   0}, // #4329
  {22,  1,   0}, // #4330
  {23,  1,   0}, // #4331
  { 7,  1,   0}, // #4332
  {12,  1,   0}, // #4333
  {17,  1,   0}, // #4334
  {21,  1,   0}, // #4335
  {23,  2,   0}, // #4336
  { 8,  2,   0}, // #4337
  {13,  2,   0}, // #4338
  {15,  3,   0}, // #4339
  {17,  1,   0}, // #4340
  {18,  2,   0}, // #4341
  {19,  3,   0}, // #4342
  {20,  2,   0}, // #4343
  {21,  1,   0}, // #4344
  {22,  3,   0}, // #4345
  {23,  4,   0}, // #4346
  { 8,  2,   0}, // #4347
  {13,  2,   0}, // #4348
  {15,  3,   0}, // #4349
  {18,  2,   0}, // #4350
  {19,  3,   0}, // #4351
  {20,  2,   0}, // #4352
  {22,  3,   0}, // #4353
  {23,  3,   0}, // #4354
  { 3,  1,   0}, // #4355
  { 8,  2,   0}, // #4356
  {11,  1,   0}, // #4357
  {12,  1,   0}, // #4358
  {13,  3,   0}, // #4359
  {14,  1,   0}, // #4360
  {15,  2,   0}, // #4361
  {17,  1,   0}, // #4362
  {18,  2,   0}, // #4363
  {19,  3,   0}, // #4364
  {20,  3,   0}, // #4365
  {21,  1,   0}, // #4366
  {22,  3,   0}, // #4367
  {23,  4,   0}, // #4368
  { 3,  1,   0}, // #4369
  { 8,  2,   0}, // #4370
  {11,  1,   0}, // #4371
  {12,  1,   0}, // #4372
  {13,  3,   0}, // #4373
  {14,  1,   0}, // #4374
  {15,  2,   0}, // #4375
  {18,  2,   0}, // #4376
  {19,  3,   0}, // #4377
  {20,  3,   0}, // #4378
  {22,  3,   0}, // #4379
  {23,  3,   0}, // #4380
  {11,  1,   0}, // #4381
  {17,  1,   0}, // #4382
  {19,  1,   0}, // #4383
  {21,  1,   0}, // #4384
  {22,  1,   0}, // #4385
  {23,  2,   0}, // #4386
  { 3,  4,   0}, // #4387
  { 8,  3,   0}, // #4388
  {11,  4,   0}, // #4389
  {12,  4,   0}, // #4390
  {13,  7,   0}, // #4391
  {14,  4,   0}, // #4392
  {15,  3,   0}, // #4393
  {17,  1,   0}, // #4394
  {18,  3,   0}, // #4395
  {19,  7,   0}, // #4396
  {20,  7,   0}, // #4397
  {21,  1,   0}, // #4398
  {22,  8,   0}, // #4399
  {23,  9,   0}, // #4400
  { 3,  4,   0}, // #4401
  { 8,  3,   0}, // #4402
  {11,  4,   0}, // #4403
  {12,  4,   0}, // #4404
  {13,  7,   0}, // #4405
  {14,  4,   0}, // #4406
  {15,  3,   0}, // #4407
  {18,  3,   0}, // #4408
  {19,  7,   0}, // #4409
  {20,  7,   0}, // #4410
  {22,  8,   0}, // #4411
  {23,  8,   0}, // #4412
  { 3,  4,   0}, // #4413
  { 8,  3,   0}, // #4414
  {11,  4,   0}, // #4415
  {12,  4,   0}, // #4416
  {13,  7,   0}, // #4417
  {14,  4,   0}, // #4418
  {15,  3,   0}, // #4419
  {17,  1,   0}, // #4420
  {18,  3,   0}, // #4421
  {19,  8,   0}, // #4422
  {20,  7,   0}, // #4423
  {21,  1,   0}, // #4424
  {22,  9,   0}, // #4425
  {23, 10,   0}, // #4426
  { 3,  4,   0}, // #4427
  { 8,  3,   0}, // #4428
  {11,  4,   0}, // #4429
  {12,  4,   0}, // #4430
  {13,  7,   0}, // #4431
  {14,  4,   0}, // #4432
  {15,  3,   0}, // #4433
  {18,  3,   0}, // #4434
  {19,  8,   0}, // #4435
  {20,  7,   0}, // #4436
  {22,  9,   0}, // #4437
  {23,  9,   0}, // #4438
  { 3,  3,   0}, // #4439
  {11,  3,   0}, // #4440
  {12,  3,   0}, // #4441
  {13,  3,   0}, // #4442
  {14,  3,   0}, // #4443
  {17,  1,   0}, // #4444
  {19,  3,   0}, // #4445
  {20,  3,   0}, // #4446
  {21,  1,   0}, // #4447
  {22,  3,   0}, // #4448
  {23,  4,   0}, // #4449
  { 3,  3,   0}, // #4450
  {11,  3,   0}, // #4451
  {12,  3,   0}, // #4452
  {13,  3,   0}, // #4453
  {14,  3,   0}, // #4454
  {19,  3,   0}, // #4455
  {20,  3,   0}, // #4456
  {22,  3,   0}, // #4457
  {23,  3,   0}, // #4458
  { 3,  2,   0}, // #4459
  {11,  2,   0}, // #4460
  {12,  2,   0}, // #4461
  {13,  2,   0}, // #4462
  {14,  2,   0}, // #4463
  {17,  1,   0}, // #4464
  {19,  2,   0}, // #4465
  {20,  2,   0}, // #4466
  {21,  1,   0}, // #4467
  {22,  2,   0}, // #4468
  {23,  3,   0}, // #4469
  { 3,  2,   0}, // #4470
  {11,  2,   0}, // #4471
  {12,  2,   0}, // #4472
  {13,  2,   0}, // #4473
  {14,  2,   0}, // #4474
  {19,  2,   0}, // #4475
  {20,  2,   0}, // #4476
  {22,  2,   0}, // #4477
  {23,  2,   0}, // #4478
  { 7,  1,   0}, // #4479
  {12,  1,   0}, // #4480
  {17,  1,   0}, // #4481
  {21,  2,   0}, // #4482
  {23,  3,   0}, // #4483
  { 3,  1,   0}, // #4484
  { 8,  1,   0}, // #4485
  {11,  1,   0}, // #4486
  {12,  1,   0}, // #4487
  {13,  2,   0}, // #4488
  {14,  1,   0}, // #4489
  {15,  1,   0}, // #4490
  {17,  1,   0}, // #4491
  {18,  1,   0}, // #4492
  {19,  2,   0}, // #4493
  {20,  2,   0}, // #4494
  {21,  1,   0}, // #4495
  {22,  2,   0}, // #4496
  {23,  3,   0}, // #4497
  {14,  2,   0}, // #4498
  {17,  1,   0}, // #4499
  {20,  2,   0}, // #4500
  {21,  1,   0}, // #4501
  {22,  2,   0}, // #4502
  {23,  3,   0}, // #4503
  { 7,  1,   0}, // #4504
  {12,  1,   0}, // #4505
  {14,  3,   0}, // #4506
  {17,  1,   0}, // #4507
  {20,  3,   0}, // #4508
  {21,  2,   0}, // #4509
  {22,  3,   0}, // #4510
  {23,  6,   0}, // #4511
  {14,  6,   0}, // #4512
  {17,  1,   0}, // #4513
  {20,  6,   0}, // #4514
  {21,  1,   0}, // #4515
  {22,  6,   0}, // #4516
  {23,  7,   0}, // #4517
  {14,  3,   0}, // #4518
  {20,  3,   0}, // #4519
  {22,  3,   0}, // #4520
  {23,  3,   0}, // #4521
  { 4,  2,   0}, // #4522
  {11,  2,   0}, // #4523
  {15,  2,   0}, // #4524
  {16,  2,   0}, // #4525
  {17,  1,   0}, // #4526
  {19,  2,   0}, // #4527
  {21,  1,   0}, // #4528
  {22,  2,   0}, // #4529
  {23,  3,   0}, // #4530
  { 4,  2,   0}, // #4531
  {11,  2,   0}, // #4532
  {15,  2,   0}, // #4533
  {16,  2,   0}, // #4534
  {19,  2,   0}, // #4535
  {22,  2,   0}, // #4536
  {23,  2,   0}, // #4537
  { 7,  1,   0}, // #4538
  {12,  1,   0}, // #4539
  {14,  1,   0}, // #4540
  {20,  1,   0}, // #4541
  {21,  1,   0}, // #4542
  {22,  1,   0}, // #4543
  {23,  3,   0}, // #4544
  { 4,  1,   0}, // #4545
  {11,  1,   0}, // #4546
  {14,  1,   0}, // #4547
  {15,  1,   0}, // #4548
  {16,  1,   0}, // #4549
  {17,  1,   0}, // #4550
  {19,  1,   0}, // #4551
  {20,  1,   0}, // #4552
  {21,  2,   0}, // #4553
  {22,  4,   0}, // #4554
  {23,  6,   0}, // #4555
  { 4,  1,   0}, // #4556
  {11,  1,   0}, // #4557
  {15,  1,   0}, // #4558
  {16,  1,   0}, // #4559
  {17,  1,   0}, // #4560
  {19,  1,   0}, // #4561
  {21,  2,   0}, // #4562
  {22,  2,   0}, // #4563
  {23,  4,   0}, // #4564
  { 2, 14,   0}, // #4565
  { 3,  1,   0}, // #4566
  {11,  1,   0}, // #4567
  {12,  1,   0}, // #4568
  {13,  1,   0}, // #4569
  {14,  1,   0}, // #4570
  {17,  1,   0}, // #4571
  {19,  1,   0}, // #4572
  {20,  1,   0}, // #4573
  {21,  1,   0}, // #4574
  {22,  1,   0}, // #4575
  {23,  2,   0}, // #4576
  { 2, 14,   0}, // #4577
  { 3,  1,   0}, // #4578
  {11,  1,   0}, // #4579
  {12,  1,   0}, // #4580
  {13,  1,   0}, // #4581
  {14,  1,   0}, // #4582
  {19,  1,   0}, // #4583
  {20,  1,   0}, // #4584
  {22,  1,   0}, // #4585
  {23,  1,   0}, // #4586
  { 2,  7,   0}, // #4587
  { 3,  1,   0}, // #4588
  {11,  1,   0}, // #4589
  {12,  1,   0}, // #4590
  {13,  1,   0}, // #4591
  {14,  1,   0}, // #4592
  {17,  1,   0}, // #4593
  {19,  1,   0}, // #4594
  {20,  1,   0}, // #4595
  {21,  1,   0}, // #4596
  {22,  1,   0}, // #4597
  {23,  2,   0}, // #4598
  { 2,  7,   0}, // #4599
  { 3,  1,   0}, // #4600
  {11,  1,   0}, // #4601
  {12,  1,   0}, // #4602
  {13,  1,   0}, // #4603
  {14,  1,   0}, // #4604
  {19,  1,   0}, // #4605
  {20,  1,   0}, // #4606
  {22,  1,   0}, // #4607
  {23,  1,   0}, // #4608
  { 2,  9,   0}, // #4609
  { 3,  1,   0}, // #4610
  {11,  1,   0}, // #4611
  {12,  1,   0}, // #4612
  {13,  1,   0}, // #4613
  {14,  1,   0}, // #4614
  {19,  1,   0}, // #4615
  {20,  1,   0}, // #4616
  {22,  1,   0}, // #4617
  {23,  1,   0}, // #4618
  { 4,  1,   0}, // #4619
  { 7,  1,   0}, // #4620
  {11,  1,   0}, // #4621
  {12,  1,   0}, // #4622
  {15,  1,   0}, // #4623
  {16,  1,   0}, // #4624
  {19,  1,   0}, // #4625
  {21,  1,   0}, // #4626
  {22,  1,   0}, // #4627
  {23,  3,   0}, // #4628
  { 2, 10,   0}, // #4629
  { 3,  2,   0}, // #4630
  {11,  2,   0}, // #4631
  {12,  2,   0}, // #4632
  {13,  2,   0}, // #4633
  {14,  2,   0}, // #4634
  {17,  1,   0}, // #4635
  {19,  3,   0}, // #4636
  {20,  2,   0}, // #4637
  {21,  1,   0}, // #4638
  {22,  3,   0}, // #4639
  {23,  4,   0}, // #4640
  { 2, 10,   0}, // #4641
  { 3,  2,   0}, // #4642
  {11,  2,   0}, // #4643
  {12,  2,   0}, // #4644
  {13,  2,   0}, // #4645
  {14,  2,   0}, // #4646
  {19,  3,   0}, // #4647
  {20,  2,   0}, // #4648
  {22,  3,   0}, // #4649
  {23,  3,   0}, // #4650
  { 2, 16,   0}, // #4651
  { 3,  2,   0}, // #4652
  {11,  2,   0}, // #4653
  {12,  2,   0}, // #4654
  {13,  2,   0}, // #4655
  {14,  2,   0}, // #4656
  {17,  1,   0}, // #4657
  {19,  3,   0}, // #4658
  {20,  2,   0}, // #4659
  {21,  1,   0}, // #4660
  {22,  3,   0}, // #4661
  {23,  4,   0}, // #4662
  { 2, 16,   0}, // #4663
  { 3,  2,   0}, // #4664
  {11,  2,   0}, // #4665
  {12,  2,   0}, // #4666
  {13,  2,   0}, // #4667
  {14,  2,   0}, // #4668
  {19,  3,   0}, // #4669
  {20,  2,   0}, // #4670
  {22,  3,   0}, // #4671
  {23,  3,   0}, // #4672
  { 3,  1,   0}, // #4673
  { 4,  1,   0}, // #4674
  { 7,  1,   0}, // #4675
  {11,  2,   0}, // #4676
  {12,  2,   0}, // #4677
  {13,  1,   0}, // #4678
  {14,  1,   0}, // #4679
  {15,  1,   0}, // #4680
  {16,  1,   0}, // #4681
  {17,  1,   0}, // #4682
  {19,  2,   0}, // #4683
  {20,  1,   0}, // #4684
  {21,  1,   0}, // #4685
  {22,  2,   0}, // #4686
  {23,  4,   0}, // #4687
  { 3,  2,   0}, // #4688
  { 8,  1,   0}, // #4689
  {11,  2,   0}, // #4690
  {12,  2,   0}, // #4691
  {13,  3,   0}, // #4692
  {14,  2,   0}, // #4693
  {15,  1,   0}, // #4694
  {17,  1,   0}, // #4695
  {18,  1,   0}, // #4696
  {19,  3,   0}, // #4697
  {20,  3,   0}, // #4698
  {21,  1,   0}, // #4699
  {22,  3,   0}, // #4700
  {23,  4,   0}, // #4701
  { 3,  2,   0}, // #4702
  { 8,  1,   0}, // #4703
  {11,  2,   0}, // #4704
  {12,  2,   0}, // #4705
  {13,  3,   0}, // #4706
  {14,  2,   0}, // #4707
  {15,  1,   0}, // #4708
  {18,  1,   0}, // #4709
  {19,  3,   0}, // #4710
  {20,  3,   0}, // #4711
  {22,  3,   0}, // #4712
  {23,  3,   0}, // #4713
  { 2, 14,   0}, // #4714
  { 3,  2,   0}, // #4715
  {11,  2,   0}, // #4716
  {12,  2,   0}, // #4717
  {13,  2,   0}, // #4718
  {14,  2,   0}, // #4719
  {17,  1,   0}, // #4720
  {19,  3,   0}, // #4721
  {20,  2,   0}, // #4722
  {21,  1,   0}, // #4723
  {22,  3,   0}, // #4724
  {23,  4,   0}, // #4725
  { 2, 14,   0}, // #4726
  { 3,  2,   0}, // #4727
  {11,  2,   0}, // #4728
  {12,  2,   0}, // #4729
  {13,  2,   0}, // #4730
  {14,  2,   0}, // #4731
  {19,  3,   0}, // #4732
  {20,  2,   0}, // #4733
  {22,  3,   0}, // #4734
  {23,  3,   0}, // #4735
  { 2, 28,   0}, // #4736
  { 3,  2,   0}, // #4737
  {11,  2,   0}, // #4738
  {12,  2,   0}, // #4739
  {13,  2,   0}, // #4740
  {14,  2,   0}, // #4741
  {17,  1,   0}, // #4742
  {19,  3,   0}, // #4743
  {20,  2,   0}, // #4744
  {21,  1,   0}, // #4745
  {22,  3,   0}, // #4746
  {23,  4,   0}, // #4747
  { 2, 28,   0}, // #4748
  { 3,  2,   0}, // #4749
  {11,  2,   0}, // #4750
  {12,  2,   0}, // #4751
  {13,  2,   0}, // #4752
  {14,  2,   0}, // #4753
  {19,  3,   0}, // #4754
  {20,  2,   0}, // #4755
  {22,  3,   0}, // #4756
  {23,  3,   0}, // #4757
  {14,  1,   0}, // #4758
  {17,  1,   0}, // #4759
  {20,  1,   0}, // #4760
  {21,  2,   0}, // #4761
  {22,  3,   0}, // #4762
  {23,  5,   0}, // #4763
  { 4,  2,   0}, // #4764
  {11,  2,   0}, // #4765
  {14,  3,   0}, // #4766
  {15,  3,   0}, // #4767
  {16,  2,   0}, // #4768
  {17,  1,   0}, // #4769
  {19,  3,   0}, // #4770
  {20,  3,   0}, // #4771
  {21,  2,   0}, // #4772
  {22,  9,   0}, // #4773
  {23, 11,   0}, // #4774
  { 3,  2,   0}, // #4775
  { 4,  1,   0}, // #4776
  { 9,  4,   0}, // #4777
  {11,  3,   0}, // #4778
  {12,  2,   0}, // #4779
  {13,  2,   0}, // #4780
  {14,  6,   0}, // #4781
  {15,  1,   0}, // #4782
  {16,  5,   0}, // #4783
  {18,  4,   0}, // #4784
  {19,  3,   0}, // #4785
  {20,  6,   0}, // #4786
  {22, 12,   0}, // #4787
  {23, 12,   0}, // #4788
  {17,  1,   0}, // #4789
  {21,  1,   0}, // #4790
  {22,  2,   0}, // #4791
  {23,  3,   0}, // #4792
  { 9,  1,   0}, // #4793
  {14,  1,   0}, // #4794
  {16,  1,   0}, // #4795
  {18,  1,   0}, // #4796
  {20,  1,   0}, // #4797
  {22,  3,   0}, // #4798
  {23,  3,   0}, // #4799
  { 7,  1,   0}, // #4800
  {12,  1,   0}, // #4801
  {17,  1,   0}, // #4802
  {21,  2,   0}, // #4803
  {22,  3,   0}, // #4804
  {23,  6,   0}, // #4805
  {14,  1,   0}, // #4806
  {20,  1,   0}, // #4807
  {22,  2,   0}, // #4808
  {23,  2,   0}, // #4809
  { 3,  1,   0}, // #4810
  {11,  2,   0}, // #4811
  {12,  1,   0}, // #4812
  {13,  1,   0}, // #4813
  {14,  1,   0}, // #4814
  {17,  1,   0}, // #4815
  {19,  2,   0}, // #4816
  {20,  1,   0}, // #4817
  {21,  1,   0}, // #4818
  {22,  2,   0}, // #4819
  {23,  3,   0}, // #4820
  {14,  2,   0}, // #4821
  {20,  2,   0}, // #4822
  {22, 11,   0}, // #4823
  {23, 11,   0}, // #4824
  { 7,  1,   0}, // #4825
  { 9,  1,   0}, // #4826
  {12,  1,   0}, // #4827
  {14,  1,   0}, // #4828
  {16,  1,   0}, // #4829
  {18,  1,   0}, // #4830
  {20,  1,   0}, // #4831
  {21,  1,   0}, // #4832
  {22,  1,   0}, // #4833
  {23,  3,   0}, // #4834
  { 9,  1,   0}, // #4835
  {14,  1,   0}, // #4836
  {16,  1,   0}, // #4837
  {18,  1,   0}, // #4838
  {20,  1,   0}, // #4839
  {22,  5,   0}, // #4840
  {23,  5,   0}, // #4841
  { 7,  1,   0}, // #4842
  {12,  1,   0}, // #4843
  {14,  4,   0}, // #4844
  {15,  2,   0}, // #4845
  {17,  1,   0}, // #4846
  {19,  2,   0}, // #4847
  {20,  4,   0}, // #4848
  {21,  2,   0}, // #4849
  {22, 11,   0}, // #4850
  {23, 14,   0}, // #4851
  { 9,  2,   0}, // #4852
  {14,  4,   0}, // #4853
  {15,  1,   0}, // #4854
  {16,  2,   0}, // #4855
  {18,  2,   0}, // #4856
  {19,  1,   0}, // #4857
  {20,  4,   0}, // #4858
  {22,  7,   0}, // #4859
  {23,  7,   0}, // #4860
  { 9,  1,   0}, // #4861
  {14,  1,   0}, // #4862
  {16,  1,   0}, // #4863
  {18,  1,   0}, // #4864
  {20,  1,   0}, // #4865
  {22,  6,   0}, // #4866
  {23,  6,   0}, // #4867
  { 3,  2,   0}, // #4868
  { 7,  1,   0}, // #4869
  { 8,  4,   0}, // #4870
  {11,  2,   0}, // #4871
  {12,  3,   0}, // #4872
  {13,  6,   0}, // #4873
  {14,  6,   0}, // #4874
  {15,  4,   0}, // #4875
  {17,  1,   0}, // #4876
  {18,  4,   0}, // #4877
  {19,  6,   0}, // #4878
  {20, 10,   0}, // #4879
  {21,  2,   0}, // #4880
  {22, 16,   0}, // #4881
  {23, 19,   0}, // #4882
  { 8,  2,   0}, // #4883
  {13,  2,   0}, // #4884
  {15,  2,   0}, // #4885
  {18,  2,   0}, // #4886
  {19,  2,   0}, // #4887
  {20,  2,   0}, // #4888
  {22, 22,   0}, // #4889
  {23, 22,   0}, // #4890
  { 7,  1,   0}, // #4891
  { 8,  1,   0}, // #4892
  { 9,  1,   0}, // #4893
  {12,  1,   0}, // #4894
  {13,  1,   0}, // #4895
  {14,  2,   0}, // #4896
  {15,  1,   0}, // #4897
  {16,  1,   0}, // #4898
  {17,  1,   0}, // #4899
  {18,  2,   0}, // #4900
  {19,  1,   0}, // #4901
  {20,  3,   0}, // #4902
  {21,  2,   0}, // #4903
  {22,  5,   0}, // #4904
  {23,  8,   0}, // #4905
  { 8,  6,   0}, // #4906
  {11,  3,   0}, // #4907
  {13,  6,   0}, // #4908
  {15,  6,   0}, // #4909
  {18,  6,   0}, // #4910
  {19,  9,   0}, // #4911
  {20,  6,   0}, // #4912
  {22, 15,   0}, // #4913
  {23, 15,   0}, // #4914
  { 8,  1,   0}, // #4915
  { 9,  5,   0}, // #4916
  {13,  1,   0}, // #4917
  {14,  9,   0}, // #4918
  {15,  1,   0}, // #4919
  {16,  5,   0}, // #4920
  {17,  2,   0}, // #4921
  {18,  6,   0}, // #4922
  {19,  1,   0}, // #4923
  {20, 10,   0}, // #4924
  {21,  3,   0}, // #4925
  {22, 20,   0}, // #4926
  {23, 23,   0}, // #4927
  { 8,  1,   0}, // #4928
  { 9,  5,   0}, // #4929
  {13,  1,   0}, // #4930
  {14,  9,   0}, // #4931
  {15,  1,   0}, // #4932
  {16,  5,   0}, // #4933
  {17,  3,   0}, // #4934
  {18,  6,   0}, // #4935
  {19,  1,   0}, // #4936
  {20, 10,   0}, // #4937
  {21,  3,   0}, // #4938
  {22, 20,   0}, // #4939
  {23, 23,   0}, // #4940
  { 8,  1,   0}, // #4941
  { 9,  1,   0}, // #4942
  {13,  1,   0}, // #4943
  {14,  2,   0}, // #4944
  {15,  1,   0}, // #4945
  {16,  1,   0}, // #4946
  {18,  2,   0}, // #4947
  {19,  1,   0}, // #4948
  {20,  3,   0}, // #4949
  {22,  8,   0}, // #4950
  {23,  8,   0}, // #4951
  { 3,  4,   0}, // #4952
  { 9,  2,   0}, // #4953
  {11,  4,   0}, // #4954
  {12,  4,   0}, // #4955
  {13,  5,   0}, // #4956
  {14,  8,   0}, // #4957
  {15,  1,   0}, // #4958
  {16,  2,   0}, // #4959
  {17, 33,   0}, // #4960
  {18,  2,   0}, // #4961
  {19,  6,   0}, // #4962
  {20,  9,   0}, // #4963
  {21, 33,   0}, // #4964
  {22, 57,   0}, // #4965
  {23, 90,   0}, // #4966
  { 9,  1,   0}, // #4967
  {14,  1,   0}, // #4968
  {16,  1,   0}, // #4969
  {17,  1,   0}, // #4970
  {18,  1,   0}, // #4971
  {20,  1,   0}, // #4972
  {21,  1,   0}, // #4973
  {22,  2,   0}, // #4974
  {23,  3,   0}, // #4975
  { 3,  1,   0}, // #4976
  {11,  1,   0}, // #4977
  {12,  1,   0}, // #4978
  {13,  1,   0}, // #4979
  {14,  1,   0}, // #4980
  {19,  1,   0}, // #4981
  {20,  1,   0}, // #4982
  {22,  2,   0}, // #4983
  {23,  2,   0}, // #4984
  {11,  1,   0}, // #4985
  {19,  2,   0}, // #4986
  {22,  2,   0}, // #4987
  {23,  2,   0}, // #4988
  {14,  1,   0}, // #4989
  {20,  1,   0}, // #4990
  {22,  3,   0}, // #4991
  {23,  3,   0}, // #4992
  { 4,  2,   0}, // #4993
  {11,  2,   0}, // #4994
  {14,  4,   0}, // #4995
  {15,  2,   0}, // #4996
  {16,  2,   0}, // #4997
  {19,  2,   0}, // #4998
  {20,  4,   0}, // #4999
  {22,  8,   0}, // #5000
  {23,  8,   0}, // #5001
  { 7,  1,   0}, // #5002
  {12,  1,   0}, // #5003
  {21,  1,   0}, // #5004
  {22,  1,   0}, // #5005
  {23,  3,   0}, // #5006
  { 7,  1,   0}, // #5007
  {12,  1,   0}, // #5008
  {14,  1,   0}, // #5009
  {20,  1,   0}, // #5010
  {21,  1,   0}, // #5011
  {22,  2,   0}, // #5012
  {23,  4,   0}, // #5013
  { 7,  1,   0}, // #5014
  { 9,  1,   0}, // #5015
  {12,  1,   0}, // #5016
  {14,  1,   0}, // #5017
  {16,  1,   0}, // #5018
  {18,  1,   0}, // #5019
  {20,  1,   0}, // #5020
  {21,  1,   0}, // #5021
  {22,  2,   0}, // #5022
  {23,  4,   0}, // #5023
  { 7,  1,   0}, // #5024
  {12,  1,   0}, // #5025
  {21,  1,   0}, // #5026
  {22,  4,   0}, // #5027
  {23,  6,   0}, // #5028
  { 9,  1,   0}, // #5029
  {14,  1,   0}, // #5030
  {16,  1,   0}, // #5031
  {18,  1,   0}, // #5032
  {20,  1,   0}, // #5033
  {22,  2,   0}, // #5034
  {23,  2,   0}, // #5035
  { 9,  1,   0}, // #5036
  {14,  1,   0}, // #5037
  {16,  1,   0}, // #5038
  {17,  1,   0}, // #5039
  {18,  1,   0}, // #5040
  {20,  1,   0}, // #5041
  {21,  1,   0}, // #5042
  {22,  1,   0}, // #5043
  {23,  2,   0}, // #5044
  { 3,  1,   0}, // #5045
  { 7,  1,   0}, // #5046
  {11,  1,   0}, // #5047
  {12,  2,   0}, // #5048
  {13,  1,   0}, // #5049
  {14,  1,   0}, // #5050
  {19,  1,   0}, // #5051
  {20,  1,   0}, // #5052
  {21,  1,   0}, // #5053
  {22,  1,   0}, // #5054
  {23,  3,   0}, // #5055
  { 4,  1,   0}, // #5056
  { 9,  1,   0}, // #5057
  {11,  1,   0}, // #5058
  {14,  2,   0}, // #5059
  {15,  1,   0}, // #5060
  {16,  2,   0}, // #5061
  {18,  1,   0}, // #5062
  {19,  1,   0}, // #5063
  {20,  2,   0}, // #5064
  {22,  4,   0}, // #5065
  {23,  4,   0}, // #5066
  { 7,  1,   0}, // #5067
  { 9,  1,   0}, // #5068
  {12,  1,   0}, // #5069
  {14,  1,   0}, // #5070
  {16,  1,   0}, // #5071
  {17,  1,   0}, // #5072
  {18,  1,   0}, // #5073
  {20,  1,   0}, // #5074
  {21,  2,   0}, // #5075
  {22,  2,   0}, // #5076
  {23,  5,   0}, // #5077
  { 7,  1,   0}, // #5078
  {12,  1,   0}, // #5079
  {14,  2,   0}, // #5080
  {17,  1,   0}, // #5081
  {20,  2,   0}, // #5082
  {21,  2,   0}, // #5083
  {22,  2,   0}, // #5084
  {23,  5,   0}, // #5085
  { 7,  1,   0}, // #5086
  {12,  1,   0}, // #5087
  {17,  1,   0}, // #5088
  {21,  2,   0}, // #5089
  {22,  2,   0}, // #5090
  {23,  5,   0}, // #5091
  { 8,  1,   0}, // #5092
  { 9,  1,   0}, // #5093
  {13,  1,   0}, // #5094
  {14,  1,   0}, // #5095
  {15,  1,   0}, // #5096
  {16,  1,   0}, // #5097
  {18,  2,   0}, // #5098
  {19,  1,   0}, // #5099
  {20,  2,   0}, // #5100
  {22,  2,   0}, // #5101
  {23,  2,   0}, // #5102
  {14,  1,   0}, // #5103
  {17,  1,   0}, // #5104
  {20,  1,   0}, // #5105
  {21,  1,   0}, // #5106
  {22,  4,   0}, // #5107
  {23,  5,   0}, // #5108
  { 9,  1,   0}, // #5109
  {14,  1,   0}, // #5110
  {16,  1,   0}, // #5111
  {18,  1,   0}, // #5112
  {20,  1,   0}, // #5113
  {22,  1,   0}, // #5114
  {23,  1,   0}, // #5115
  { 7,  1,   0}, // #5116
  {12,  1,   0}, // #5117
  {15,  1,   0}, // #5118
  {19,  1,   0}, // #5119
  {21,  1,   0}, // #5120
  {22,  1,   0}, // #5121
  {23,  3,   0}, // #5122
  {14,  2,   0}, // #5123
  {20,  2,   0}, // #5124
  {22,  2,   0}, // #5125
  {23,  2,   0}, // #5126
  { 8,  1,   0}, // #5127
  {13,  1,   0}, // #5128
  {15,  1,   0}, // #5129
  {17,  1,   0}, // #5130
  {18,  1,   0}, // #5131
  {19,  2,   0}, // #5132
  {20,  1,   0}, // #5133
  {21,  1,   0}, // #5134
  {22,  2,   0}, // #5135
  {23,  3,   0}, // #5136
  { 4,  2,   0}, // #5137
  { 9,  2,   0}, // #5138
  {11,  2,   0}, // #5139
  {14,  2,   0}, // #5140
  {15,  2,   0}, // #5141
  {16,  4,   0}, // #5142
  {17,  1,   0}, // #5143
  {18,  2,   0}, // #5144
  {19,  2,   0}, // #5145
  {20,  2,   0}, // #5146
  {21,  1,   0}, // #5147
  {22,  7,   0}, // #5148
  {23,  8,   0}, // #5149
  { 4,  1,   0}, // #5150
  { 9,  2,   0}, // #5151
  {11,  1,   0}, // #5152
  {14,  2,   0}, // #5153
  {15,  1,   0}, // #5154
  {16,  3,   0}, // #5155
  {17,  1,   0}, // #5156
  {18,  2,   0}, // #5157
  {19,  1,   0}, // #5158
  {20,  2,   0}, // #5159
  {21,  1,   0}, // #5160
  {22,  4,   0}, // #5161
  {23,  5,   0}, // #5162
  { 4,  1,   0}, // #5163
  { 9,  1,   0}, // #5164
  {11,  1,   0}, // #5165
  {14,  2,   0}, // #5166
  {15,  1,   0}, // #5167
  {16,  2,   0}, // #5168
  {18,  1,   0}, // #5169
  {19,  1,   0}, // #5170
  {20,  2,   0}, // #5171
  {22,  3,   0}, // #5172
  {23,  3,   0}, // #5173
  {14,  1,   0}, // #5174
  {20,  1,   0}, // #5175
  {22,  5,   0}, // #5176
  {23,  5,   0}, // #5177
  { 4,  1,   0}, // #5178
  {11,  1,   0}, // #5179
  {14,  4,   0}, // #5180
  {15,  2,   0}, // #5181
  {16,  1,   0}, // #5182
  {17,  1,   0}, // #5183
  {19,  2,   0}, // #5184
  {20,  4,   0}, // #5185
  {21,  2,   0}, // #5186
  {22,  8,   0}, // #5187
  {23, 10,   0}, // #5188
  { 4,  2,   0}, // #5189
  {11,  2,   0}, // #5190
  {14,  2,   0}, // #5191
  {15,  2,   0}, // #5192
  {16,  2,   0}, // #5193
  {19,  2,   0}, // #5194
  {20,  2,   0}, // #5195
  {22,  7,   0}, // #5196
  {23,  7,   0}, // #5197
  { 4,  1,   0}, // #5198
  {11,  1,   0}, // #5199
  {14,  4,   0}, // #5200
  {15,  2,   0}, // #5201
  {16,  1,   0}, // #5202
  {19,  2,   0}, // #5203
  {20,  4,   0}, // #5204
  {22,  9,   0}, // #5205
  {23,  9,   0}, // #5206
  { 4,  2,   0}, // #5207
  {11,  2,   0}, // #5208
  {14,  3,   0}, // #5209
  {15,  3,   0}, // #5210
  {16,  2,   0}, // #5211
  {19,  3,   0}, // #5212
  {20,  3,   0}, // #5213
  {22, 10,   0}, // #5214
  {23, 10,   0}, // #5215
  { 9,  3,   0}, // #5216
  {14,  3,   0}, // #5217
  {16,  3,   0}, // #5218
  {17,  1,   0}, // #5219
  {18,  3,   0}, // #5220
  {20,  3,   0}, // #5221
  {21,  1,   0}, // #5222
  {22, 18,   0}, // #5223
  {23, 19,   0}, // #5224
  { 7,  1,   0}, // #5225
  { 9,  5,   0}, // #5226
  {12,  1,   0}, // #5227
  {14,  5,   0}, // #5228
  {16,  5,   0}, // #5229
  {17,  1,   0}, // #5230
  {18,  5,   0}, // #5231
  {20,  5,   0}, // #5232
  {21,  2,   0}, // #5233
  {22, 24,   0}, // #5234
  {23, 27,   0}, // #5235
  { 7,  1,   0}, // #5236
  { 9,  6,   0}, // #5237
  {12,  1,   0}, // #5238
  {14,  6,   0}, // #5239
  {16,  6,   0}, // #5240
  {17,  1,   0}, // #5241
  {18,  6,   0}, // #5242
  {20,  6,   0}, // #5243
  {21,  2,   0}, // #5244
  {22, 25,   0}, // #5245
  {23, 28,   0}, // #5246
  { 3,  2,   0}, // #5247
  {11,  4,   0}, // #5248
  {12,  2,   0}, // #5249
  {13,  3,   0}, // #5250
  {14, 12,   0}, // #5251
  {17,  8,   0}, // #5252
  {19,  7,   0}, // #5253
  {20, 13,   0}, // #5254
  {21,  8,   0}, // #5255
  {22, 56,   0}, // #5256
  {23, 64,   0}, // #5257
  { 3,  4,   0}, // #5258
  { 9,  4,   0}, // #5259
  {11,  4,   0}, // #5260
  {12,  4,   0}, // #5261
  {13,  5,   0}, // #5262
  {14, 10,   0}, // #5263
  {15,  1,   0}, // #5264
  {16,  4,   0}, // #5265
  {17, 31,   0}, // #5266
  {18,  4,   0}, // #5267
  {19,  6,   0}, // #5268
  {20, 11,   0}, // #5269
  {21, 31,   0}, // #5270
  {22, 57,   0}, // #5271
  {23, 88,   0}, // #5272
  { 3,  9,   0}, // #5273
  { 4,  9,   0}, // #5274
  { 7, 11,   0}, // #5275
  { 8,  8,   0}, // #5276
  { 9,  1,   0}, // #5277
  {11, 18,   0}, // #5278
  {12, 20,   0}, // #5279
  {13, 17,   0}, // #5280
  {14, 31,   0}, // #5281
  {15, 17,   0}, // #5282
  {16, 10,   0}, // #5283
  {18,  9,   0}, // #5284
  {19, 26,   0}, // #5285
  {20, 39,   0}, // #5286
  {21, 11,   0}, // #5287
  {22, 78,   0}, // #5288
  {23, 100,   0}, // #5289
  { 7,  1,   0}, // #5290
  { 8,  3,   0}, // #5291
  {12,  1,   0}, // #5292
  {13,  3,   0}, // #5293
  {15,  3,   0}, // #5294
  {17,  2,   0}, // #5295
  {18,  3,   0}, // #5296
  {19,  3,   0}, // #5297
  {20,  3,   0}, // #5298
  {21,  2,   0}, // #5299
  {22,  4,   0}, // #5300
  {23,  7,   0}, // #5301
  { 7,  1,   0}, // #5302
  { 8,  3,   0}, // #5303
  {12,  1,   0}, // #5304
  {13,  3,   0}, // #5305
  {15,  3,   0}, // #5306
  {17,  4,   0}, // #5307
  {18,  3,   0}, // #5308
  {19,  3,   0}, // #5309
  {20,  3,   0}, // #5310
  {21,  4,   0}, // #5311
  {22,  4,   0}, // #5312
  {23,  9,   0}, // #5313
  { 7,  1,   0}, // #5314
  { 8,  4,   0}, // #5315
  {12,  1,   0}, // #5316
  {13,  4,   0}, // #5317
  {15,  4,   0}, // #5318
  {17,  4,   0}, // #5319
  {18,  4,   0}, // #5320
  {19,  4,   0}, // #5321
  {20,  4,   0}, // #5322
  {21,  4,   0}, // #5323
  {22,  5,   0}, // #5324
  {23, 10,   0}, // #5325
  { 7,  1,   0}, // #5326
  { 8,  4,   0}, // #5327
  {12,  1,   0}, // #5328
  {13,  4,   0}, // #5329
  {15,  4,   0}, // #5330
  {17,  8,   0}, // #5331
  {18,  4,   0}, // #5332
  {19,  4,   0}, // #5333
  {20,  4,   0}, // #5334
  {21,  8,   0}, // #5335
  {22,  5,   0}, // #5336
  {23, 14,   0}, // #5337
  { 7,  1,   0}, // #5338
  { 8,  5,   0}, // #5339
  {12,  1,   0}, // #5340
  {13,  5,   0}, // #5341
  {15,  5,   0}, // #5342
  {17,  2,   0}, // #5343
  {18,  5,   0}, // #5344
  {19,  5,   0}, // #5345
  {20,  5,   0}, // #5346
  {21,  2,   0}, // #5347
  {22,  6,   0}, // #5348
  {23,  9,   0}, // #5349
  { 9,  1,   0}, // #5350
  {14,  1,   0}, // #5351
  {16,  1,   0}, // #5352
  {17,  1,   0}, // #5353
  {18,  1,   0}, // #5354
  {20,  1,   0}, // #5355
  {21,  1,   0}, // #5356
  {22, 17,   0}, // #5357
  {23, 18,   0}, // #5358
  {14,  1,   0}, // #5359
  {17,  1,   0}, // #5360
  {20,  1,   0}, // #5361
  {21,  1,   0}, // #5362
  {22,  2,   0}, // #5363
  {23,  3,   0}, // #5364
  { 9,  1,   0}, // #5365
  {16,  1,   0}, // #5366
  { 3,  3,   0}, // #5367
  {11,  1,   0}, // #5368
  {12,  2,   0}, // #5369
  {14,  1,   0}, // #5370
  { 8,  1,   0}, // #5371
  { 9,  1,   0}, // #5372
  {12,  1,   0}, // #5373
  {14,  1,   0}, // #5374
  {15,  1,   0}, // #5375
  { 8,  2,   0}, // #5376
  { 9,  2,   0}, // #5377
  {12,  2,   0}, // #5378
  {14,  2,   0}, // #5379
  {15,  2,   0}, // #5380
  { 3,  1,   0}, // #5381
  {11,  1,   0}, // #5382
  {12,  2,   0}, // #5383
  {14,  1,   0}, // #5384
  { 3,  2,   0}, // #5385
  {11,  1,   0}, // #5386
  {12,  2,   0}, // #5387
  {14,  1,   0}, // #5388
  { 3,  2,   0}, // #5389
  {11,  1,   0}, // #5390
  {12,  1,   0}, // #5391
  { 5,  1,   0}, // #5392
  { 7,  1,   0}, // #5393
  { 9,  1,   0}, // #5394
  {10,  1,   0}, // #5395
  {11,  1,   0}, // #5396
  {12,  1,   0}, // #5397
  { 7,  1,   0}, // #5398
  { 9,  2,   0}, // #5399
  {11,  1,   0}, // #5400
  {12,  1,   0}, // #5401
  {16,  1,   0}, // #5402
  {19,  1,   0}, // #5403
  { 7,  1,   0}, // #5404
  { 9,  2,   0}, // #5405
  {16,  1,   0}, // #5406
  {19,  1,   0}, // #5407
  { 7,  1,   0}, // #5408
  { 9,  1,   0}, // #5409
  {11,  1,   0}, // #5410
  {12,  1,   0}, // #5411
  {19,  1,   0}, // #5412
  { 7,  1,   0}, // #5413
  { 9,  1,   0}, // #5414
  {19,  1,   0}, // #5415
  { 9,  4,   0}, // #5416
  {10,  4,   0}, // #5417
  {11,  1,   0}, // #5418
  {12,  1,   0}, // #5419
  { 3,  8,   0}, // #5420
  {11,  1,   0}, // #5421
  {12,  1,   0}, // #5422
  { 1,  1,   0}, // #5423
  { 3,  1,   0}, // #5424
  { 5,  1,   0}, // #5425
  { 7,  1,   0}, // #5426
  { 9,  1,   0}, // #5427
  {10,  1,   0}, // #5428
  {11,  1,   0}, // #5429
  {12,  1,   0}, // #5430
  { 3,  4,   0}, // #5431
  {11,  1,   0}, // #5432
  {12,  1,   0}, // #5433
  { 8,  1,   0}, // #5434
  { 9,  1,   0}, // #5435
  {11,  1,   0}, // #5436
  {12,  1,   0}, // #5437
  {15,  1,   0}, // #5438
  { 8,  1,   0}, // #5439
  { 9,  1,   0}, // #5440
  {15,  1,   0}, // #5441
  { 1,  1,   0}, // #5442
  { 3,  1,   0}, // #5443
  { 5,  1,   0}, // #5444
  { 7,  1,   0}, // #5445
  { 8,  1,   0}, // #5446
  { 9,  2,   0}, // #5447
  {10,  1,   0}, // #5448
  {11,  1,   0}, // #5449
  {12,  1,   0}, // #5450
  {15,  1,   0}, // #5451
  { 1,  1,   0}, // #5452
  { 3,  1,   0}, // #5453
  { 5,  1,   0}, // #5454
  { 7,  1,   0}, // #5455
  { 8,  1,   0}, // #5456
  { 9,  2,   0}, // #5457
  {10,  1,   0}, // #5458
  {15,  1,   0}, // #5459
  { 8,  1,   0}, // #5460
  { 9,  1,   0}, // #5461
  {11,  1,   0}, // #5462
  {12,  1,   0}, // #5463
  {15,  2,   0}, // #5464
  { 8,  1,   0}, // #5465
  { 9,  1,   0}, // #5466
  {15,  2,   0}, // #5467
  { 2,  1,   0}, // #5468
  { 3,  1,   0}, // #5469
  { 4, 17,   0}, // #5470
  {11,  1,   0}, // #5471
  {12,  1,   0}, // #5472
  { 2,  1,   0}, // #5473
  { 3,  1,   0}, // #5474
  { 4, 25,   0}, // #5475
  {11,  1,   0}, // #5476
  {12,  1,   0}, // #5477
  { 2,  1,   0}, // #5478
  { 3,  1,   0}, // #5479
  { 4, 41,   0}, // #5480
  {11,  1,   0}, // #5481
  {12,  1,   0}, // #5482
  { 2,  1,   0}, // #5483
  { 3,  1,   0}, // #5484
  { 4, 12,   0}, // #5485
  {11,  1,   0}, // #5486
  {12,  1,   0}, // #5487
  { 6, 19,   0}, // #5488
  { 8,  1,   0}, // #5489
  { 9,  1,   0}, // #5490
  {10, 19,   0}, // #5491
  {11,  1,   0}, // #5492
  {12,  1,   0}, // #5493
  { 5,  3,   0}, // #5494
  { 6,  3,   0}, // #5495
  { 8,  1,   0}, // #5496
  { 9,  1,   0}, // #5497
  {10,  6,   0}, // #5498
  {11,  1,   0}, // #5499
  {12,  1,   0}, // #5500
  { 9,  1,   0}, // #5501
  {11,  1,   0}, // #5502
  {12,  1,   0}, // #5503
  {16,  1,   0}, // #5504
  { 2,  1,   0}, // #5505
  { 3,  1,   0}, // #5506
  {11,  1,   0}, // #5507
  {12,  1,   0}, // #5508
  {13,  3,   0}, // #5509
  { 2,  1,   0}, // #5510
  { 3,  1,   0}, // #5511
  {13,  3,   0}, // #5512
  { 2,  1,   0}, // #5513
  { 3,  1,   0}, // #5514
  {11,  1,   0}, // #5515
  {12,  1,   0}, // #5516
  {13,  1,   0}, // #5517
  { 2,  1,   0}, // #5518
  { 3,  1,   0}, // #5519
  {11,  1,   0}, // #5520
  {12,  1,   0}, // #5521
  {13,  2,   0}, // #5522
  { 2,  1,   0}, // #5523
  { 3,  1,   0}, // #5524
  {13,  1,   0}, // #5525
  { 2,  1,   0}, // #5526
  { 3,  1,   0}, // #5527
  {13,  2,   0}, // #5528
  { 2,  1,   0}, // #5529
  { 3,  1,   0}, // #5530
  {11,  1,   0}, // #5531
  {12,  1,   0}, // #5532
  {13,  4,   0}, // #5533
  { 2,  1,   0}, // #5534
  { 3,  1,   0}, // #5535
  {13,  4,   0}, // #5536
  { 7,  1,   0}, // #5537
  { 9,  1,   0}, // #5538
  {11,  1,   0}, // #5539
  {12,  1,   0}, // #5540
  {19,  2,   0}, // #5541
  { 7,  1,   0}, // #5542
  { 9,  1,   0}, // #5543
  {19,  2,   0}, // #5544
  { 6,  2,   0}, // #5545
  { 8,  1,   0}, // #5546
  { 9,  1,   0}, // #5547
  {10,  2,   0}, // #5548
  {11,  1,   0}, // #5549
  {12,  1,   0}, // #5550
  { 6,  1,   0}, // #5551
  { 8,  1,   0}, // #5552
  { 9,  1,   0}, // #5553
  {10,  1,   0}, // #5554
  {11,  1,   0}, // #5555
  {12,  1,   0}, // #5556
  { 9,  4,   0}, // #5557
  {11,  1,   0}, // #5558
  {12,  1,   0}, // #5559
  {16,  4,   0}, // #5560
  { 9,  4,   0}, // #5561
  {16,  4,   0}, // #5562
  { 1,  1,   0}, // #5563
  { 3,  1,   0}, // #5564
  { 5,  1,   0}, // #5565
  { 8,  1,   0}, // #5566
  { 9,  1,   0}, // #5567
  {10,  1,   0}, // #5568
  {11,  3,   0}, // #5569
  {12,  5,   0}, // #5570
  {14,  2,   0}, // #5571
  {16, 10,   0}, // #5572
  {18,  4,   0}, // #5573
  { 1,  1,   0}, // #5574
  { 3,  1,   0}, // #5575
  { 5,  1,   0}, // #5576
  { 8,  1,   0}, // #5577
  { 9,  1,   0}, // #5578
  {10,  1,   0}, // #5579
  {11,  2,   0}, // #5580
  {12,  4,   0}, // #5581
  {14,  2,   0}, // #5582
  {16, 10,   0}, // #5583
  {18,  4,   0}, // #5584
  { 1,  1,   0}, // #5585
  { 3,  1,   0}, // #5586
  { 5,  1,   0}, // #5587
  { 7,  1,   0}, // #5588
  { 8,  2,   0}, // #5589
  { 9,  3,   0}, // #5590
  {10,  1,   0}, // #5591
  {11,  1,   0}, // #5592
  {12,  1,   0}, // #5593
  {16,  2,   0}, // #5594
  {18,  2,   0}, // #5595
  { 1,  1,   0}, // #5596
  { 3,  1,   0}, // #5597
  { 5,  1,   0}, // #5598
  { 7,  1,   0}, // #5599
  { 8,  2,   0}, // #5600
  { 9,  3,   0}, // #5601
  {10,  1,   0}, // #5602
  {16,  2,   0}, // #5603
  {18,  2,   0}, // #5604
  { 7,  2,   0}, // #5605
  { 9,  3,   0}, // #5606
  {11,  1,   0}, // #5607
  {12,  1,   0}, // #5608
  {16,  1,   0}, // #5609
  {19,  2,   0}, // #5610
  { 7,  2,   0}, // #5611
  { 9,  3,   0}, // #5612
  {16,  1,   0}, // #5613
  {19,  2,   0}, // #5614
  { 9,  1,   0}, // #5615
  {11,  1,   0}, // #5616
  {12,  1,   0}, // #5617
  {16,  4,   0}, // #5618
  { 9,  1,   0}, // #5619
  {16,  4,   0}, // #5620
  { 3,  1,   0}, // #5621
  {12,  1,   0}, // #5622
  {14,  1,   0}, // #5623
  { 3, 22,   0}, // #5624
  {11,  1,   0}, // #5625
  {12,  1,   0}, // #5626
  { 6, 27,   0}, // #5627
  { 8,  1,   0}, // #5628
  { 9,  1,   0}, // #5629
  {10, 27,   0}, // #5630
  {11,  1,   0}, // #5631
  {12,  1,   0}, // #5632
  { 6, 21,   0}, // #5633
  { 8,  1,   0}, // #5634
  { 9,  1,   0}, // #5635
  {10, 21,   0}, // #5636
  {11,  1,   0}, // #5637
  {12,  1,   0}, // #5638
  { 6, 35,   0}, // #5639
  { 8,  1,   0}, // #5640
  { 9,  1,   0}, // #5641
  {10, 35,   0}, // #5642
  { 5,  2,   0}, // #5643
  { 7,  2,   0}, // #5644
  { 9,  2,   0}, // #5645
  {10,  2,   0}, // #5646
  {11,  2,   0}, // #5647
  {12,  2,   0}, // #5648
  { 8,  2,   0}, // #5649
  { 9,  2,   0}, // #5650
  {15,  2,   0}, // #5651
  { 9,  6,   0}, // #5652
  {10,  6,   0}, // #5653
  {11,  2,   0}, // #5654
  {12,  2,   0}, // #5655
  { 9,  2,   0}, // #5656
  {10,  2,   0}, // #5657
  {11,  1,   0}, // #5658
  {12,  1,   0}, // #5659
  { 8,  2,   0}, // #5660
  { 9,  2,   0}, // #5661
  {10,  4,   0}, // #5662
  {11,  2,   0}, // #5663
  {12,  2,   0}, // #5664
  {15,  2,   0}, // #5665
  { 8,  2,   0}, // #5666
  { 9,  2,   0}, // #5667
  {10,  4,   0}, // #5668
  {15,  2,   0}, // #5669
  { 8,  2,   0}, // #5670
  { 9,  2,   0}, // #5671
  {11,  2,   0}, // #5672
  {12,  2,   0}, // #5673
  {15,  2,   0}, // #5674
  { 8,  2,   0}, // #5675
  { 9,  2,   0}, // #5676
  {10,  2,   0}, // #5677
  {12,  1,   0}, // #5678
  {14,  1,   0}, // #5679
  {15,  2,   0}, // #5680
  { 8,  2,   0}, // #5681
  { 9,  2,   0}, // #5682
  {10,  2,   0}, // #5683
  {15,  2,   0}, // #5684
  { 6, 38,   0}, // #5685
  { 8,  2,   0}, // #5686
  { 9,  2,   0}, // #5687
  {10, 38,   0}, // #5688
  {11,  2,   0}, // #5689
  {12,  2,   0}, // #5690
  { 5,  6,   0}, // #5691
  { 6,  6,   0}, // #5692
  { 8,  2,   0}, // #5693
  { 9,  2,   0}, // #5694
  {10, 12,   0}, // #5695
  {11,  2,   0}, // #5696
  {12,  2,   0}, // #5697
  { 3,  4,   0}, // #5698
  { 5,  1,   0}, // #5699
  { 7,  1,   0}, // #5700
  { 8,  4,   0}, // #5701
  { 9,  5,   0}, // #5702
  {10,  1,   0}, // #5703
  {11,  4,   0}, // #5704
  {12,  8,   0}, // #5705
  {14,  4,   0}, // #5706
  {15,  4,   0}, // #5707
  { 9,  4,   0}, // #5708
  {10,  4,   0}, // #5709
  {11,  2,   0}, // #5710
  {12,  2,   0}, // #5711
  { 3,  2,   0}, // #5712
  { 5,  1,   0}, // #5713
  { 7,  1,   0}, // #5714
  { 8,  2,   0}, // #5715
  { 9,  3,   0}, // #5716
  {10,  1,   0}, // #5717
  {11,  2,   0}, // #5718
  {12,  4,   0}, // #5719
  {14,  2,   0}, // #5720
  {15,  2,   0}, // #5721
  { 3,  8,   0}, // #5722
  { 5,  1,   0}, // #5723
  { 7,  1,   0}, // #5724
  { 8, 10,   0}, // #5725
  { 9, 11,   0}, // #5726
  {10,  1,   0}, // #5727
  {11,  8,   0}, // #5728
  {12, 16,   0}, // #5729
  {14,  8,   0}, // #5730
  {15, 10,   0}, // #5731
  { 3,  4,   0}, // #5732
  { 5,  1,   0}, // #5733
  { 7,  1,   0}, // #5734
  { 8,  5,   0}, // #5735
  { 9,  6,   0}, // #5736
  {10,  1,   0}, // #5737
  {11,  4,   0}, // #5738
  {12,  8,   0}, // #5739
  {14,  4,   0}, // #5740
  {15,  5,   0}, // #5741
  { 9,  2,   0}, // #5742
  {16,  2,   0}, // #5743
  { 6,  2,   0}, // #5744
  { 8,  2,   0}, // #5745
  { 9,  2,   0}, // #5746
  {10,  2,   0}, // #5747
  {11,  2,   0}, // #5748
  {12,  2,   0}, // #5749
  { 6,  4,   0}, // #5750
  { 8,  2,   0}, // #5751
  { 9,  2,   0}, // #5752
  {10,  4,   0}, // #5753
  {11,  2,   0}, // #5754
  {12,  2,   0}, // #5755
  { 9,  2,   0}, // #5756
  {10,  6,   0}, // #5757
  {11,  2,   0}, // #5758
  {12,  2,   0}, // #5759
  { 9,  1,   0}, // #5760
  {10,  4,   0}, // #5761
  {11,  1,   0}, // #5762
  {12,  1,   0}, // #5763
  { 9,  4,   0}, // #5764
  {11,  2,   0}, // #5765
  {12,  2,   0}, // #5766
  {16,  4,   0}, // #5767
  { 9,  2,   0}, // #5768
  {11,  1,   0}, // #5769
  {12,  1,   0}, // #5770
  {16,  2,   0}, // #5771
  { 1,  1,   0}, // #5772
  { 3,  1,   0}, // #5773
  { 5,  2,   0}, // #5774
  { 9,  2,   0}, // #5775
  {10,  4,   0}, // #5776
  {11,  2,   0}, // #5777
  {12,  2,   0}, // #5778
  { 6, 42,   0}, // #5779
  { 8,  2,   0}, // #5780
  { 9,  2,   0}, // #5781
  {10, 42,   0}, // #5782
  {11,  2,   0}, // #5783
  {12,  2,   0}, // #5784
  { 6, 54,   0}, // #5785
  { 8,  2,   0}, // #5786
  { 9,  2,   0}, // #5787
  {10, 54,   0}, // #5788
  {11,  2,   0}, // #5789
  {12,  2,   0}, // #5790
  { 3,  2,   0}, // #5791
  {11, 16,   0}, // #5792
  {12, 32,   0}, // #5793
  {14, 16,   0}, // #5794
  { 9,  2,   0}, // #5795
  {10,  4,   0}, // #5796
  {11,  1,   0}, // #5797
  {12,  1,   0}, // #5798
  { 3, 42,   0}, // #5799
  { 5,  1,   0}, // #5800
  { 7,  1,   0}, // #5801
  { 8,  2,   0}, // #5802
  { 9,  3,   0}, // #5803
  {10,  1,   0}, // #5804
  {11,  2,   0}, // #5805
  {12, 18,   0}, // #5806
  {14, 16,   0}, // #5807
  {15,  2,   0}, // #5808
  { 3,  3,   0}, // #5809
  {11, 19,   0}, // #5810
  {12, 38,   0}, // #5811
  {14, 19,   0}, // #5812
  { 3,  6,   0}, // #5813
  {11, 38,   0}, // #5814
  {12, 76,   0}, // #5815
  {14, 38,   0}, // #5816
  { 3,  3,   0}, // #5817
  {11, 16,   0}, // #5818
  {12, 32,   0}, // #5819
  {14, 16,   0}, // #5820
  { 3,  3,   0}, // #5821
  {11, 17,   0}, // #5822
  {12, 34,   0}, // #5823
  {14, 17,   0}, // #5824
  { 3,  6,   0}, // #5825
  {11,  1,   0}, // #5826
  {12,  2,   0}, // #5827
  {14,  1,   0}, // #5828
  { 2,  1,   0}, // #5829
  { 3,  1,   0}, // #5830
  {12,  1,   0}, // #5831
  {14,  1,   0}, // #5832
  { 3,  1,   0}, // #5833
  {11, 19,   0}, // #5834
  {12, 38,   0}, // #5835
  {14, 19,   0}, // #5836
  {13,  1,   0}, // #5837
  {19,  1,   0}, // #5838
  {20,  1,   0}, // #5839
  {22,  1,   0}, // #5840
  {23,  1,   0}, // #5841
  { 3,  3,   0}, // #5842
  { 8,  6,   0}, // #5843
  {11,  3,   0}, // #5844
  {12,  3,   0}, // #5845
  {13,  9,   0}, // #5846
  {14,  3,   0}, // #5847
  {15,  6,   0}, // #5848
  {17,  1,   0}, // #5849
  {18,  6,   0}, // #5850
  {19, 10,   0}, // #5851
  {20,  9,   0}, // #5852
  {21,  1,   0}, // #5853
  {22, 10,   0}, // #5854
  {23, 11,   0}, // #5855
  { 3,  3,   0}, // #5856
  { 8,  6,   0}, // #5857
  {11,  3,   0}, // #5858
  {12,  3,   0}, // #5859
  {13,  9,   0}, // #5860
  {14,  3,   0}, // #5861
  {15,  6,   0}, // #5862
  {18,  6,   0}, // #5863
  {19, 11,   0}, // #5864
  {20,  9,   0}, // #5865
  {22, 11,   0}, // #5866
  {23, 11,   0}, // #5867
  { 8,  1,   0}, // #5868
  {11,  1,   0}, // #5869
  {13,  1,   0}, // #5870
  {15,  1,   0}, // #5871
  {17,  1,   0}, // #5872
  {18,  1,   0}, // #5873
  {19,  2,   0}, // #5874
  {20,  1,   0}, // #5875
  {21,  1,   0}, // #5876
  {22,  2,   0}, // #5877
  {23,  3,   0}, // #5878
  { 8,  1,   0}, // #5879
  {11,  1,   0}, // #5880
  {13,  1,   0}, // #5881
  {15,  1,   0}, // #5882
  {18,  1,   0}, // #5883
  {19,  2,   0}, // #5884
  {20,  1,   0}, // #5885
  {22,  2,   0}, // #5886
  {23,  2,   0}, // #5887
  {11,  2,   0}, // #5888
  {17,  1,   0}, // #5889
  {19,  2,   0}, // #5890
  {21,  1,   0}, // #5891
  {22,  2,   0}, // #5892
  {23,  3,   0}, // #5893
  { 1, 10,   0}, // #5894
  { 3,  1,   0}, // #5895
  {11,  1,   0}, // #5896
  {12,  1,   0}, // #5897
  {13,  1,   0}, // #5898
  {14,  1,   0}, // #5899
  {17,  1,   0}, // #5900
  {19,  1,   0}, // #5901
  {20,  1,   0}, // #5902
  {21,  1,   0}, // #5903
  {22,  1,   0}, // #5904
  {23,  2,   0}, // #5905
  { 3,  7,   0}, // #5906
  { 4,  2,   0}, // #5907
  { 8,  8,   0}, // #5908
  { 9,  3,   0}, // #5909
  {11,  9,   0}, // #5910
  {12,  7,   0}, // #5911
  {13, 16,   0}, // #5912
  {14, 10,   0}, // #5913
  {15, 10,   0}, // #5914
  {16,  5,   0}, // #5915
  {18, 11,   0}, // #5916
  {19, 18,   0}, // #5917
  {20, 19,   0}, // #5918
  {22, 32,   0}, // #5919
  {23, 32,   0}, // #5920
  { 2,  4,   0}, // #5921
  { 3,  1,   0}, // #5922
  {11,  1,   0}, // #5923
  {12,  1,   0}, // #5924
  {13,  1,   0}, // #5925
  {14,  1,   0}, // #5926
  {17,  1,   0}, // #5927
  {19,  1,   0}, // #5928
  {20,  1,   0}, // #5929
  {21,  1,   0}, // #5930
  {22,  1,   0}, // #5931
  {23,  2,   0}, // #5932
  { 2,  3,   0}, // #5933
  { 3,  1,   0}, // #5934
  {11,  1,   0}, // #5935
  {12,  1,   0}, // #5936
  {13,  1,   0}, // #5937
  {14,  1,   0}, // #5938
  {17,  1,   0}, // #5939
  {19,  1,   0}, // #5940
  {20,  1,   0}, // #5941
  {21,  1,   0}, // #5942
  {22,  1,   0}, // #5943
  {23,  2,   0}, // #5944
  { 8,  1,   0}, // #5945
  {13,  1,   0}, // #5946
  {15,  1,   0}, // #5947
  {17,  1,   0}, // #5948
  {18,  1,   0}, // #5949
  {19,  3,   0}, // #5950
  {20,  1,   0}, // #5951
  {21,  1,   0}, // #5952
  {22,  3,   0}, // #5953
  {23,  4,   0}, // #5954
  { 8,  1,   0}, // #5955
  {13,  1,   0}, // #5956
  {15,  1,   0}, // #5957
  {18,  1,   0}, // #5958
  {19,  3,   0}, // #5959
  {20,  1,   0}, // #5960
  {22,  3,   0}, // #5961
  {23,  3,   0}, // #5962
  { 8,  1,   0}, // #5963
  {11,  3,   0}, // #5964
  {13,  1,   0}, // #5965
  {14,  1,   0}, // #5966
  {15,  1,   0}, // #5967
  {17,  1,   0}, // #5968
  {18,  1,   0}, // #5969
  {19,  4,   0}, // #5970
  {20,  2,   0}, // #5971
  {21,  1,   0}, // #5972
  {22,  5,   0}, // #5973
  {23,  6,   0}, // #5974
  { 8,  1,   0}, // #5975
  {11,  3,   0}, // #5976
  {13,  1,   0}, // #5977
  {15,  1,   0}, // #5978
  {18,  1,   0}, // #5979
  {19,  4,   0}, // #5980
  {20,  1,   0}, // #5981
  {22,  4,   0}, // #5982
  {23,  4,   0}, // #5983
  {13,  9,   0}, // #5984
  {19,  9,   0}, // #5985
  {20,  9,   0}, // #5986
  {22, 10,   0}, // #5987
  {23, 10,   0}, // #5988
  {13,  2,   0}, // #5989
  {19,  2,   0}, // #5990
  {20,  2,   0}, // #5991
  {22,  2,   0}, // #5992
  {23,  2,   0}, // #5993
  { 8,  2,   0}, // #5994
  {11,  1,   0}, // #5995
  {13,  2,   0}, // #5996
  {15,  2,   0}, // #5997
  {17,  1,   0}, // #5998
  {18,  2,   0}, // #5999
  {19,  3,   0}, // #6000
  {20,  2,   0}, // #6001
  {21,  1,   0}, // #6002
  {22,  3,   0}, // #6003
  {23,  4,   0}, // #6004
  { 8,  2,   0}, // #6005
  {11,  1,   0}, // #6006
  {13,  2,   0}, // #6007
  {15,  2,   0}, // #6008
  {18,  2,   0}, // #6009
  {19,  3,   0}, // #6010
  {20,  2,   0}, // #6011
  {22,  3,   0}, // #6012
  {23,  3,   0}, // #6013
  { 3,  2,   0}, // #6014
  { 8,  4,   0}, // #6015
  {11,  2,   0}, // #6016
  {12,  2,   0}, // #6017
  {13,  6,   0}, // #6018
  {14,  2,   0}, // #6019
  {15,  4,   0}, // #6020
  {17,  1,   0}, // #6021
  {18,  4,   0}, // #6022
  {19,  6,   0}, // #6023
  {20,  6,   0}, // #6024
  {21,  1,   0}, // #6025
  {22,  7,   0}, // #6026
  {23,  8,   0}, // #6027
  { 3,  4,   0}, // #6028
  { 4,  2,   0}, // #6029
  { 8,  4,   0}, // #6030
  { 9,  8,   0}, // #6031
  {11,  6,   0}, // #6032
  {12,  4,   0}, // #6033
  {13,  8,   0}, // #6034
  {14, 26,   0}, // #6035
  {15,  6,   0}, // #6036
  {16, 10,   0}, // #6037
  {18, 12,   0}, // #6038
  {19, 10,   0}, // #6039
  {20, 30,   0}, // #6040
  {22, 66,   0}, // #6041
  {23, 66,   0}, // #6042
  {13,  1,   0}, // #6043
  {17,  1,   0}, // #6044
  {19,  1,   0}, // #6045
  {20,  1,   0}, // #6046
  {21,  1,   0}, // #6047
  {22,  1,   0}, // #6048
  {23,  2,   0}, // #6049
  { 8,  2,   0}, // #6050
  {13,  3,   0}, // #6051
  {15,  2,   0}, // #6052
  {17,  1,   0}, // #6053
  {18,  2,   0}, // #6054
  {19,  3,   0}, // #6055
  {20,  3,   0}, // #6056
  {21,  1,   0}, // #6057
  {22,  3,   0}, // #6058
  {23,  4,   0}, // #6059
  { 8,  2,   0}, // #6060
  {13,  3,   0}, // #6061
  {15,  2,   0}, // #6062
  {18,  2,   0}, // #6063
  {19,  3,   0}, // #6064
  {20,  3,   0}, // #6065
  {22,  3,   0}, // #6066
  {23,  3,   0}, // #6067
  { 8,  2,   0}, // #6068
  {13,  2,   0}, // #6069
  {15,  2,   0}, // #6070
  {17,  1,   0}, // #6071
  {18,  2,   0}, // #6072
  {19,  3,   0}, // #6073
  {20,  2,   0}, // #6074
  {21,  1,   0}, // #6075
  {22,  3,   0}, // #6076
  {23,  4,   0}, // #6077
  { 8,  2,   0}, // #6078
  {13,  2,   0}, // #6079
  {15,  2,   0}, // #6080
  {18,  2,   0}, // #6081
  {19,  3,   0}, // #6082
  {20,  2,   0}, // #6083
  {22,  3,   0}, // #6084
  {23,  3,   0}, // #6085
  { 4,  1,   0}, // #6086
  {11,  1,   0}, // #6087
  {14,  2,   0}, // #6088
  {15,  1,   0}, // #6089
  {16,  1,   0}, // #6090
  {17,  1,   0}, // #6091
  {19,  1,   0}, // #6092
  {20,  2,   0}, // #6093
  {21,  2,   0}, // #6094
  {22,  4,   0}, // #6095
  {23,  6,   0}, // #6096
  { 4,  1,   0}, // #6097
  {11,  1,   0}, // #6098
  {14,  2,   0}, // #6099
  {15,  1,   0}, // #6100
  {16,  1,   0}, // #6101
  {19,  1,   0}, // #6102
  {20,  2,   0}, // #6103
  {22,  4,   0}, // #6104
  {23,  4,   0}, // #6105
  { 2,  6,   0}, // #6106
  { 3,  1,   0}, // #6107
  {11,  1,   0}, // #6108
  {12,  1,   0}, // #6109
  {13,  1,   0}, // #6110
  {14,  1,   0}, // #6111
  {17,  1,   0}, // #6112
  {19,  1,   0}, // #6113
  {20,  1,   0}, // #6114
  {21,  1,   0}, // #6115
  {22,  1,   0}, // #6116
  {23,  2,   0}, // #6117
  { 2,  6,   0}, // #6118
  { 3,  1,   0}, // #6119
  {11,  1,   0}, // #6120
  {12,  1,   0}, // #6121
  {13,  1,   0}, // #6122
  {14,  1,   0}, // #6123
  {19,  1,   0}, // #6124
  {20,  1,   0}, // #6125
  {22,  1,   0}, // #6126
  {23,  1,   0}, // #6127
  { 8,  1,   0}, // #6128
  {13,  2,   0}, // #6129
  {15,  1,   0}, // #6130
  {17,  1,   0}, // #6131
  {18,  1,   0}, // #6132
  {19,  2,   0}, // #6133
  {20,  2,   0}, // #6134
  {21,  1,   0}, // #6135
  {22,  2,   0}, // #6136
  {23,  3,   0}, // #6137
  { 8,  1,   0}, // #6138
  {13,  2,   0}, // #6139
  {15,  1,   0}, // #6140
  {18,  1,   0}, // #6141
  {19,  2,   0}, // #6142
  {20,  2,   0}, // #6143
  {22,  2,   0}, // #6144
  {23,  2,   0}, // #6145
  {13,  2,   0}, // #6146
  {17,  1,   0}, // #6147
  {19,  2,   0}, // #6148
  {20,  2,   0}, // #6149
  {21,  1,   0}, // #6150
  {22,  2,   0}, // #6151
  {23,  3,   0}, // #6152
  { 7,  1,   0}, // #6153
  { 8,  1,   0}, // #6154
  {11,  1,   0}, // #6155
  {12,  1,   0}, // #6156
  {13,  1,   0}, // #6157
  {15,  1,   0}, // #6158
  {18,  1,   0}, // #6159
  {19,  2,   0}, // #6160
  {20,  1,   0}, // #6161
  {21,  1,   0}, // #6162
  {22,  2,   0}, // #6163
  {23,  4,   0}, // #6164
  { 7,  1,   0}, // #6165
  { 8,  1,   0}, // #6166
  {12,  1,   0}, // #6167
  {13,  2,   0}, // #6168
  {15,  1,   0}, // #6169
  {18,  1,   0}, // #6170
  {19,  2,   0}, // #6171
  {20,  2,   0}, // #6172
  {21,  1,   0}, // #6173
  {22,  2,   0}, // #6174
  {23,  4,   0}, // #6175
  { 2, 10,   0}, // #6176
  { 3,  2,   0}, // #6177
  { 8,  1,   0}, // #6178
  {11,  2,   0}, // #6179
  {12,  2,   0}, // #6180
  {13,  3,   0}, // #6181
  {14,  2,   0}, // #6182
  {15,  1,   0}, // #6183
  {17,  1,   0}, // #6184
  {18,  1,   0}, // #6185
  {19,  3,   0}, // #6186
  {20,  3,   0}, // #6187
  {21,  1,   0}, // #6188
  {22,  3,   0}, // #6189
  {23,  4,   0}, // #6190
  { 2, 10,   0}, // #6191
  { 3,  2,   0}, // #6192
  { 8,  1,   0}, // #6193
  {11,  2,   0}, // #6194
  {12,  2,   0}, // #6195
  {13,  3,   0}, // #6196
  {14,  2,   0}, // #6197
  {15,  1,   0}, // #6198
  {18,  1,   0}, // #6199
  {19,  3,   0}, // #6200
  {20,  3,   0}, // #6201
  {22,  3,   0}, // #6202
  {23,  3,   0}, // #6203
  { 2, 16,   0}, // #6204
  { 3,  2,   0}, // #6205
  { 8,  1,   0}, // #6206
  {11,  2,   0}, // #6207
  {12,  2,   0}, // #6208
  {13,  3,   0}, // #6209
  {14,  2,   0}, // #6210
  {15,  1,   0}, // #6211
  {17,  1,   0}, // #6212
  {18,  1,   0}, // #6213
  {19,  3,   0}, // #6214
  {20,  3,   0}, // #6215
  {21,  1,   0}, // #6216
  {22,  3,   0}, // #6217
  {23,  4,   0}, // #6218
  { 2, 16,   0}, // #6219
  { 3,  2,   0}, // #6220
  { 8,  1,   0}, // #6221
  {11,  2,   0}, // #6222
  {12,  2,   0}, // #6223
  {13,  3,   0}, // #6224
  {14,  2,   0}, // #6225
  {15,  1,   0}, // #6226
  {18,  1,   0}, // #6227
  {19,  3,   0}, // #6228
  {20,  3,   0}, // #6229
  {22,  3,   0}, // #6230
  {23,  3,   0}, // #6231
  { 3,  1,   0}, // #6232
  { 7,  1,   0}, // #6233
  {11,  1,   0}, // #6234
  {12,  2,   0}, // #6235
  {13,  1,   0}, // #6236
  {14,  1,   0}, // #6237
  {17,  1,   0}, // #6238
  {19,  1,   0}, // #6239
  {20,  1,   0}, // #6240
  {21,  1,   0}, // #6241
  {22,  1,   0}, // #6242
  {23,  3,   0}, // #6243
  { 2, 12,   0}, // #6244
  { 3,  2,   0}, // #6245
  { 8,  1,   0}, // #6246
  {11,  2,   0}, // #6247
  {12,  2,   0}, // #6248
  {13,  3,   0}, // #6249
  {14,  2,   0}, // #6250
  {15,  1,   0}, // #6251
  {17,  1,   0}, // #6252
  {18,  1,   0}, // #6253
  {19,  3,   0}, // #6254
  {20,  3,   0}, // #6255
  {21,  1,   0}, // #6256
  {22,  3,   0}, // #6257
  {23,  4,   0}, // #6258
  { 2, 12,   0}, // #6259
  { 3,  2,   0}, // #6260
  { 8,  1,   0}, // #6261
  {11,  2,   0}, // #6262
  {12,  2,   0}, // #6263
  {13,  3,   0}, // #6264
  {14,  2,   0}, // #6265
  {15,  1,   0}, // #6266
  {18,  1,   0}, // #6267
  {19,  3,   0}, // #6268
  {20,  3,   0}, // #6269
  {22,  3,   0}, // #6270
  {23,  3,   0}, // #6271
  { 2, 12,   0}, // #6272
  { 3,  1,   0}, // #6273
  {11,  1,   0}, // #6274
  {12,  1,   0}, // #6275
  {13,  1,   0}, // #6276
  {14,  1,   0}, // #6277
  {17,  1,   0}, // #6278
  {19,  1,   0}, // #6279
  {20,  1,   0}, // #6280
  {21,  1,   0}, // #6281
  {22,  1,   0}, // #6282
  {23,  2,   0}, // #6283
  { 2, 12,   0}, // #6284
  { 3,  1,   0}, // #6285
  {11,  1,   0}, // #6286
  {12,  1,   0}, // #6287
  {13,  1,   0}, // #6288
  {14,  1,   0}, // #6289
  {19,  1,   0}, // #6290
  {20,  1,   0}, // #6291
  {22,  1,   0}, // #6292
  {23,  1,   0}, // #6293
  { 2, 24,   0}, // #6294
  { 3,  2,   0}, // #6295
  { 8,  1,   0}, // #6296
  {11,  2,   0}, // #6297
  {12,  2,   0}, // #6298
  {13,  3,   0}, // #6299
  {14,  2,   0}, // #6300
  {15,  1,   0}, // #6301
  {17,  1,   0}, // #6302
  {18,  1,   0}, // #6303
  {19,  3,   0}, // #6304
  {20,  3,   0}, // #6305
  {21,  1,   0}, // #6306
  {22,  3,   0}, // #6307
  {23,  4,   0}, // #6308
  { 2, 24,   0}, // #6309
  { 3,  2,   0}, // #6310
  { 8,  1,   0}, // #6311
  {11,  2,   0}, // #6312
  {12,  2,   0}, // #6313
  {13,  3,   0}, // #6314
  {14,  2,   0}, // #6315
  {15,  1,   0}, // #6316
  {18,  1,   0}, // #6317
  {19,  3,   0}, // #6318
  {20,  3,   0}, // #6319
  {22,  3,   0}, // #6320
  {23,  3,   0}, // #6321
  { 4,  2,   0}, // #6322
  {11,  2,   0}, // #6323
  {14,  4,   0}, // #6324
  {15,  3,   0}, // #6325
  {16,  2,   0}, // #6326
  {17,  1,   0}, // #6327
  {19,  3,   0}, // #6328
  {20,  4,   0}, // #6329
  {21,  2,   0}, // #6330
  {22,  9,   0}, // #6331
  {23, 11,   0}, // #6332
  { 3,  2,   0}, // #6333
  { 4,  1,   0}, // #6334
  { 8,  2,   0}, // #6335
  { 9,  4,   0}, // #6336
  {11,  3,   0}, // #6337
  {12,  2,   0}, // #6338
  {13,  6,   0}, // #6339
  {14,  6,   0}, // #6340
  {15,  3,   0}, // #6341
  {16,  5,   0}, // #6342
  {18,  6,   0}, // #6343
  {19,  7,   0}, // #6344
  {20, 10,   0}, // #6345
  {22, 15,   0}, // #6346
  {23, 15,   0}, // #6347
  { 3,  1,   0}, // #6348
  { 8,  1,   0}, // #6349
  {11,  2,   0}, // #6350
  {12,  1,   0}, // #6351
  {13,  2,   0}, // #6352
  {14,  1,   0}, // #6353
  {15,  1,   0}, // #6354
  {18,  1,   0}, // #6355
  {19,  3,   0}, // #6356
  {20,  2,   0}, // #6357
  {22,  3,   0}, // #6358
  {23,  3,   0}, // #6359
  { 7,  1,   0}, // #6360
  { 9,  1,   0}, // #6361
  {12,  1,   0}, // #6362
  {14,  2,   0}, // #6363
  {16,  1,   0}, // #6364
  {17,  1,   0}, // #6365
  {18,  1,   0}, // #6366
  {20,  2,   0}, // #6367
  {21,  2,   0}, // #6368
  {22,  5,   0}, // #6369
  {23,  8,   0}, // #6370
  { 3,  1,   0}, // #6371
  {11,  1,   0}, // #6372
  {12,  1,   0}, // #6373
  {13,  2,   0}, // #6374
  {14,  1,   0}, // #6375
  {17,  1,   0}, // #6376
  {19,  2,   0}, // #6377
  {20,  2,   0}, // #6378
  {21,  1,   0}, // #6379
  {22,  2,   0}, // #6380
  {23,  3,   0}, // #6381
  { 9,  1,   0}, // #6382
  {14,  1,   0}, // #6383
  {16,  1,   0}, // #6384
  {18,  1,   0}, // #6385
  {20,  1,   0}, // #6386
  {22,  4,   0}, // #6387
  {23,  4,   0}, // #6388
  { 9,  1,   0}, // #6389
  {14,  4,   0}, // #6390
  {15,  1,   0}, // #6391
  {16,  1,   0}, // #6392
  {18,  1,   0}, // #6393
  {19,  1,   0}, // #6394
  {20,  4,   0}, // #6395
  {22,  7,   0}, // #6396
  {23,  7,   0}, // #6397
  { 8,  1,   0}, // #6398
  { 9,  2,   0}, // #6399
  {13,  1,   0}, // #6400
  {14,  2,   0}, // #6401
  {15,  1,   0}, // #6402
  {16,  2,   0}, // #6403
  {18,  3,   0}, // #6404
  {19,  1,   0}, // #6405
  {20,  3,   0}, // #6406
  {22, 10,   0}, // #6407
  {23, 10,   0}, // #6408
  { 8,  6,   0}, // #6409
  {13,  9,   0}, // #6410
  {15,  6,   0}, // #6411
  {18,  6,   0}, // #6412
  {19,  9,   0}, // #6413
  {20,  9,   0}, // #6414
  {22, 15,   0}, // #6415
  {23, 15,   0}, // #6416
  { 4,  1,   0}, // #6417
  { 9,  5,   0}, // #6418
  {11,  1,   0}, // #6419
  {13,  4,   0}, // #6420
  {14,  5,   0}, // #6421
  {15,  1,   0}, // #6422
  {16,  6,   0}, // #6423
  {18,  5,   0}, // #6424
  {19,  5,   0}, // #6425
  {20,  9,   0}, // #6426
  {22, 10,   0}, // #6427
  {23, 10,   0}, // #6428
  { 4,  1,   0}, // #6429
  { 9,  1,   0}, // #6430
  {11,  1,   0}, // #6431
  {14,  1,   0}, // #6432
  {15,  1,   0}, // #6433
  {16,  2,   0}, // #6434
  {18,  1,   0}, // #6435
  {19,  1,   0}, // #6436
  {20,  1,   0}, // #6437
  {22,  4,   0}, // #6438
  {23,  4,   0}, // #6439
  { 4,  1,   0}, // #6440
  {11,  1,   0}, // #6441
  {14,  5,   0}, // #6442
  {15,  2,   0}, // #6443
  {16,  1,   0}, // #6444
  {17,  1,   0}, // #6445
  {19,  2,   0}, // #6446
  {20,  5,   0}, // #6447
  {21,  2,   0}, // #6448
  {22,  8,   0}, // #6449
  {23, 10,   0}, // #6450
  { 4,  2,   0}, // #6451
  {11,  2,   0}, // #6452
  {14,  3,   0}, // #6453
  {15,  2,   0}, // #6454
  {16,  2,   0}, // #6455
  {19,  2,   0}, // #6456
  {20,  3,   0}, // #6457
  {22,  7,   0}, // #6458
  {23,  7,   0}, // #6459
  { 4,  1,   0}, // #6460
  {11,  1,   0}, // #6461
  {14,  5,   0}, // #6462
  {15,  2,   0}, // #6463
  {16,  1,   0}, // #6464
  {19,  2,   0}, // #6465
  {20,  5,   0}, // #6466
  {22,  9,   0}, // #6467
  {23,  9,   0}, // #6468
  { 4,  2,   0}, // #6469
  {11,  2,   0}, // #6470
  {14,  4,   0}, // #6471
  {15,  3,   0}, // #6472
  {16,  2,   0}, // #6473
  {19,  3,   0}, // #6474
  {20,  4,   0}, // #6475
  {22, 10,   0}, // #6476
  {23, 10,   0}, // #6477
  { 4,  1,   0}, // #6478
  { 9,  8,   0}, // #6479
  {11,  1,   0}, // #6480
  {14,  8,   0}, // #6481
  {15,  1,   0}, // #6482
  {16,  9,   0}, // #6483
  {17,  1,   0}, // #6484
  {18,  8,   0}, // #6485
  {19,  1,   0}, // #6486
  {20,  8,   0}, // #6487
  {21,  1,   0}, // #6488
  {22, 30,   0}, // #6489
  {23, 31,   0}, // #6490
  { 7,  1,   0}, // #6491
  { 9, 10,   0}, // #6492
  {12,  1,   0}, // #6493
  {14, 10,   0}, // #6494
  {16, 10,   0}, // #6495
  {17,  1,   0}, // #6496
  {18, 10,   0}, // #6497
  {20, 10,   0}, // #6498
  {21,  2,   0}, // #6499
  {22, 36,   0}, // #6500
  {23, 39,   0}, // #6501
  { 7,  1,   0}, // #6502
  { 9, 11,   0}, // #6503
  {12,  1,   0}, // #6504
  {14, 11,   0}, // #6505
  {16, 11,   0}, // #6506
  {17,  1,   0}, // #6507
  {18, 11,   0}, // #6508
  {20, 11,   0}, // #6509
  {21,  2,   0}, // #6510
  {22, 37,   0}, // #6511
  {23, 40,   0}, // #6512
  { 4,  1,   0}, // #6513
  { 7,  1,   0}, // #6514
  { 8,  2,   0}, // #6515
  { 9,  3,   0}, // #6516
  {11,  1,   0}, // #6517
  {12,  1,   0}, // #6518
  {13,  2,   0}, // #6519
  {14,  3,   0}, // #6520
  {15,  4,   0}, // #6521
  {16,  4,   0}, // #6522
  {17,  1,   0}, // #6523
  {18,  5,   0}, // #6524
  {19,  4,   0}, // #6525
  {20,  5,   0}, // #6526
  {21,  2,   0}, // #6527
  {22, 15,   0}, // #6528
  {23, 18,   0}, // #6529
  { 3,  2,   0}, // #6530
  {11,  2,   0}, // #6531
  {12,  2,   0}, // #6532
  {13,  7,   0}, // #6533
  {14, 12,   0}, // #6534
  {17,  8,   0}, // #6535
  {19,  7,   0}, // #6536
  {20, 17,   0}, // #6537
  {21,  8,   0}, // #6538
  {22, 56,   0}, // #6539
  {23, 64,   0}, // #6540
  { 3,  9,   0}, // #6541
  { 4,  1,   0}, // #6542
  { 7, 11,   0}, // #6543
  { 8, 16,   0}, // #6544
  { 9,  1,   0}, // #6545
  {11, 10,   0}, // #6546
  {12, 20,   0}, // #6547
  {13, 25,   0}, // #6548
  {14, 31,   0}, // #6549
  {15, 17,   0}, // #6550
  {16,  2,   0}, // #6551
  {18, 17,   0}, // #6552
  {19, 26,   0}, // #6553
  {20, 47,   0}, // #6554
  {21, 11,   0}, // #6555
  {22, 78,   0}, // #6556
  {23, 100,   0}, // #6557
  { 3,  1,   0}, // #6558
  { 8,  1,   0}, // #6559
  {11,  1,   0}, // #6560
  {12,  1,   0}, // #6561
  {13,  2,   0}, // #6562
  {14,  1,   0}, // #6563
  {15,  1,   0}, // #6564
  {17,  2,   0}, // #6565
  {18,  1,   0}, // #6566
  {19,  3,   0}, // #6567
  {20,  2,   0}, // #6568
  {21,  2,   0}, // #6569
  {22,  3,   0}, // #6570
  {23,  5,   0}, // #6571
  { 3,  1,   0}, // #6572
  { 8,  1,   0}, // #6573
  {11,  1,   0}, // #6574
  {12,  1,   0}, // #6575
  {13,  2,   0}, // #6576
  {14,  1,   0}, // #6577
  {15,  1,   0}, // #6578
  {17,  4,   0}, // #6579
  {18,  1,   0}, // #6580
  {19,  3,   0}, // #6581
  {20,  2,   0}, // #6582
  {21,  4,   0}, // #6583
  {22,  3,   0}, // #6584
  {23,  7,   0}, // #6585
  { 3,  1,   0}, // #6586
  { 8,  1,   0}, // #6587
  {11,  1,   0}, // #6588
  {12,  1,   0}, // #6589
  {13,  2,   0}, // #6590
  {14,  1,   0}, // #6591
  {15,  1,   0}, // #6592
  {17,  8,   0}, // #6593
  {18,  1,   0}, // #6594
  {19,  3,   0}, // #6595
  {20,  2,   0}, // #6596
  {21,  8,   0}, // #6597
  {22,  3,   0}, // #6598
  {23, 11,   0}, // #6599
  { 8,  5,   0}, // #6600
  {11,  5,   0}, // #6601
  {13,  5,   0}, // #6602
  {15,  5,   0}, // #6603
  {18,  5,   0}, // #6604
  {19, 14,   0}, // #6605
  {20,  5,   0}, // #6606
  {22, 14,   0}, // #6607
  {23, 14,   0}, // #6608
  { 8,  9,   0}, // #6609
  {11,  7,   0}, // #6610
  {13,  9,   0}, // #6611
  {15,  9,   0}, // #6612
  {18,  9,   0}, // #6613
  {19, 21,   0}, // #6614
  {20,  9,   0}, // #6615
  {22, 21,   0}, // #6616
  {23, 21,   0}, // #6617
  { 8, 17,   0}, // #6618
  {11, 11,   0}, // #6619
  {13, 17,   0}, // #6620
  {15, 17,   0}, // #6621
  {18, 17,   0}, // #6622
  {19, 35,   0}, // #6623
  {20, 17,   0}, // #6624
  {22, 35,   0}, // #6625
  {23, 35,   0}, // #6626
  { 7,  2,   0}, // #6627
  {12,  2,   0}, // #6628
  {15,  1,   0}, // #6629
  {19,  1,   0}, // #6630
  {21,  2,   0}, // #6631
  {22,  1,   0}, // #6632
  {23,  5,   0}, // #6633
  { 7,  1,   0}, // #6634
  {11,  1,   0}, // #6635
  {12,  1,   0}, // #6636
  {19,  1,   0}, // #6637
  {21,  1,   0}, // #6638
  {22,  1,   0}, // #6639
  {23,  3,   0}, // #6640
  { 7,  1,   0}, // #6641
  { 8,  2,   0}, // #6642
  {12,  1,   0}, // #6643
  {13,  2,   0}, // #6644
  {15,  2,   0}, // #6645
  {18,  2,   0}, // #6646
  {19,  2,   0}, // #6647
  {20,  2,   0}, // #6648
  {21,  1,   0}, // #6649
  {22,  2,   0}, // #6650
  {23,  4,   0}, // #6651
  { 8,  1,   0}, // #6652
  {13,  1,   0}, // #6653
  {15,  1,   0}, // #6654
  {17,  1,   0}, // #6655
  {18,  1,   0}, // #6656
  {19,  1,   0}, // #6657
  {20,  1,   0}, // #6658
  {21,  1,   0}, // #6659
  {22,  2,   0}, // #6660
  {23,  3,   0}, // #6661
  { 3,  1,   0}, // #6662
  { 7,  2,   0}, // #6663
  {11,  1,   0}, // #6664
  {12,  3,   0}, // #6665
  {13,  1,   0}, // #6666
  {14,  1,   0}, // #6667
  {19,  1,   0}, // #6668
  {20,  1,   0}, // #6669
  {21,  2,   0}, // #6670
  {22,  3,   0}, // #6671
  {23,  7,   0}, // #6672
  { 3,  1,   0}, // #6673
  { 7,  4,   0}, // #6674
  {11,  1,   0}, // #6675
  {12,  5,   0}, // #6676
  {13,  1,   0}, // #6677
  {14,  1,   0}, // #6678
  {19,  1,   0}, // #6679
  {20,  1,   0}, // #6680
  {21,  4,   0}, // #6681
  {22,  3,   0}, // #6682
  {23, 11,   0}, // #6683
  { 3,  1,   0}, // #6684
  { 7,  8,   0}, // #6685
  {11,  1,   0}, // #6686
  {12,  9,   0}, // #6687
  {13,  1,   0}, // #6688
  {14,  1,   0}, // #6689
  {19,  1,   0}, // #6690
  {20,  1,   0}, // #6691
  {21,  8,   0}, // #6692
  {22,  3,   0}, // #6693
  {23, 19,   0}, // #6694
  { 3,  1,   0}, // #6695
  { 7, 16,   0}, // #6696
  { 8,  1,   0}, // #6697
  {11,  1,   0}, // #6698
  {12, 17,   0}, // #6699
  {13,  2,   0}, // #6700
  {14,  1,   0}, // #6701
  {15,  1,   0}, // #6702
  {18,  1,   0}, // #6703
  {19,  2,   0}, // #6704
  {20,  2,   0}, // #6705
  {21, 16,   0}, // #6706
  {22,  4,   0}, // #6707
  {23, 36,   0}, // #6708
  { 3,  1,   0}, // #6709
  { 7,  2,   0}, // #6710
  { 8,  1,   0}, // #6711
  {11,  1,   0}, // #6712
  {12,  3,   0}, // #6713
  {13,  2,   0}, // #6714
  {14,  1,   0}, // #6715
  {15,  1,   0}, // #6716
  {18,  1,   0}, // #6717
  {19,  2,   0}, // #6718
  {20,  2,   0}, // #6719
  {21,  2,   0}, // #6720
  {22,  4,   0}, // #6721
  {23,  8,   0}, // #6722
  { 3,  1,   0}, // #6723
  { 7,  4,   0}, // #6724
  { 8,  1,   0}, // #6725
  {11,  1,   0}, // #6726
  {12,  5,   0}, // #6727
  {13,  2,   0}, // #6728
  {14,  1,   0}, // #6729
  {15,  1,   0}, // #6730
  {18,  1,   0}, // #6731
  {19,  2,   0}, // #6732
  {20,  2,   0}, // #6733
  {21,  4,   0}, // #6734
  {22,  4,   0}, // #6735
  {23, 12,   0}, // #6736
  { 3,  1,   0}, // #6737
  { 7,  8,   0}, // #6738
  { 8,  1,   0}, // #6739
  {11,  1,   0}, // #6740
  {12,  9,   0}, // #6741
  {13,  2,   0}, // #6742
  {14,  1,   0}, // #6743
  {15,  1,   0}, // #6744
  {18,  1,   0}, // #6745
  {19,  2,   0}, // #6746
  {20,  2,   0}, // #6747
  {21,  8,   0}, // #6748
  {22,  4,   0}, // #6749
  {23, 20,   0}, // #6750
  {11,  3,   0}, // #6751
  {19,  3,   0}, // #6752
  {22,  3,   0}, // #6753
  {23,  3,   0}, // #6754
  {13,  3,   0}, // #6755
  {19,  3,   0}, // #6756
  {20,  3,   0}, // #6757
  {22,  3,   0}, // #6758
  {23,  3,   0}, // #6759
  { 4,  1,   0}, // #6760
  { 8,  2,   0}, // #6761
  {11,  3,   0}, // #6762
  {13,  2,   0}, // #6763
  {15,  3,   0}, // #6764
  {16,  1,   0}, // #6765
  {17,  1,   0}, // #6766
  {18,  2,   0}, // #6767
  {19,  7,   0}, // #6768
  {20,  2,   0}, // #6769
  {21,  1,   0}, // #6770
  {22,  7,   0}, // #6771
  {23,  8,   0}, // #6772
  {11,  3,   0}, // #6773
  {17,  1,   0}, // #6774
  {19,  3,   0}, // #6775
  {21,  1,   0}, // #6776
  {22,  3,   0}, // #6777
  {23,  4,   0}, // #6778
  {13,  3,   0}, // #6779
  {17,  1,   0}, // #6780
  {19,  3,   0}, // #6781
  {20,  3,   0}, // #6782
  {21,  1,   0}, // #6783
  {22,  3,   0}, // #6784
  {23,  4,   0}, // #6785
  { 3,  1,   0}, // #6786
  {11,  1,   0}, // #6787
  {12,  1,   0}, // #6788
  {13,  1,   0}, // #6789
  {14,  1,   0}, // #6790
  {17,  2,   0}, // #6791
  {19,  2,   0}, // #6792
  {20,  1,   0}, // #6793
  {21,  2,   0}, // #6794
  {22,  3,   0}, // #6795
  {23,  5,   0}, // #6796
  { 3,  1,   0}, // #6797
  {11,  1,   0}, // #6798
  {12,  1,   0}, // #6799
  {13,  1,   0}, // #6800
  {14,  1,   0}, // #6801
  {17,  4,   0}, // #6802
  {19,  2,   0}, // #6803
  {20,  1,   0}, // #6804
  {21,  4,   0}, // #6805
  {22,  3,   0}, // #6806
  {23,  7,   0}, // #6807
  { 3,  1,   0}, // #6808
  {11,  1,   0}, // #6809
  {12,  1,   0}, // #6810
  {13,  1,   0}, // #6811
  {14,  1,   0}, // #6812
  {17,  8,   0}, // #6813
  {19,  2,   0}, // #6814
  {20,  1,   0}, // #6815
  {21,  8,   0}, // #6816
  {22,  3,   0}, // #6817
  {23, 11,   0}, // #6818
  { 3,  1,   0}, // #6819
  {11,  1,   0}, // #6820
  {12,  1,   0}, // #6821
  {13,  1,   0}, // #6822
  {14,  1,   0}, // #6823
  {17, 16,   0}, // #6824
  {19,  2,   0}, // #6825
  {20,  1,   0}, // #6826
  {21, 16,   0}, // #6827
  {22,  3,   0}, // #6828
  {23, 19,   0}, // #6829
  { 8,  5,   0}, // #6830
  {11,  5,   0}, // #6831
  {13,  5,   0}, // #6832
  {15,  5,   0}, // #6833
  {17,  1,   0}, // #6834
  {18,  5,   0}, // #6835
  {19, 14,   0}, // #6836
  {20,  5,   0}, // #6837
  {21,  1,   0}, // #6838
  {22, 14,   0}, // #6839
  {23, 15,   0}, // #6840
  { 8,  9,   0}, // #6841
  {11,  7,   0}, // #6842
  {13,  9,   0}, // #6843
  {15,  9,   0}, // #6844
  {17,  1,   0}, // #6845
  {18,  9,   0}, // #6846
  {19, 21,   0}, // #6847
  {20,  9,   0}, // #6848
  {21,  1,   0}, // #6849
  {22, 21,   0}, // #6850
  {23, 22,   0}, // #6851
  { 8, 17,   0}, // #6852
  {11, 11,   0}, // #6853
  {13, 17,   0}, // #6854
  {15, 17,   0}, // #6855
  {17,  1,   0}, // #6856
  {18, 17,   0}, // #6857
  {19, 35,   0}, // #6858
  {20, 17,   0}, // #6859
  {21,  1,   0}, // #6860
  {22, 35,   0}, // #6861
  {23, 36,   0}, // #6862
  { 7,  1,   0}, // #6863
  {12,  1,   0}, // #6864
  {14,  2,   0}, // #6865
  {20,  2,   0}, // #6866
  {21,  1,   0}, // #6867
  {22,  2,   0}, // #6868
  {23,  4,   0}, // #6869
  { 4,  1,   0}, // #6870
  { 7,  1,   0}, // #6871
  { 9,  1,   0}, // #6872
  {11,  1,   0}, // #6873
  {12,  1,   0}, // #6874
  { 6,  1,   0}, // #6875
  { 8,  1,   0}, // #6876
  { 9,  1,   0}, // #6877
  {11,  1,   0}, // #6878
  {12,  1,   0}, // #6879
  { 5,  1,   0}, // #6880
  { 6,  2,   0}, // #6881
  { 8,  2,   0}, // #6882
  { 9,  2,   0}, // #6883
  {10,  2,   0}, // #6884
  {11,  3,   0}, // #6885
  {12,  6,   0}, // #6886
  { 6,  1,   0}, // #6887
  { 8,  1,   0}, // #6888
  { 9,  1,   0}, // #6889
  {10,  1,   0}, // #6890
  {11,  1,   0}, // #6891
  {12,  2,   0}, // #6892
  { 5,  1,   0}, // #6893
  {10,  1,   0}, // #6894
  {12,  2,   0}, // #6895
  {10,  1,   0}, // #6896
  {12,  1,   0}, // #6897
  { 5,  1,   0}, // #6898
  {10,  2,   0}, // #6899
  {11,  1,   0}, // #6900
  {12,  4,   0}, // #6901
  { 5,  1,   0}, // #6902
  {10,  2,   0}, // #6903
  {11,  3,   0}, // #6904
  {12,  6,   0}, // #6905
  { 8,  1,   0}, // #6906
  {10,  1,   0}, // #6907
  {11,  2,   0}, // #6908
  {12,  3,   0}, // #6909
  { 4,  1,   0}, // #6910
  { 7,  1,   0}, // #6911
  { 9,  1,   0}, // #6912
  {10,  1,   0}, // #6913
  {11,  1,   0}, // #6914
  {12,  2,   0}, // #6915
  { 6,  1,   0}, // #6916
  { 8,  1,   0}, // #6917
  { 9,  1,   0}, // #6918
  {10,  1,   0}, // #6919
  {11,  2,   0}, // #6920
  {12,  3,   0}, // #6921
  { 6,  1,   0}, // #6922
  { 8,  1,   0}, // #6923
  { 9,  1,   0}, // #6924
  {11,  2,   0}, // #6925
  {12,  2,   0}, // #6926
  { 6,  2,   0}, // #6927
  { 8,  2,   0}, // #6928
  { 9,  2,   0}, // #6929
  {10,  1,   0}, // #6930
  {11,  2,   0}, // #6931
  {12,  3,   0}, // #6932
  { 6,  2,   0}, // #6933
  { 8,  2,   0}, // #6934
  { 9,  2,   0}, // #6935
  {11,  2,   0}, // #6936
  {12,  2,   0}, // #6937
  {10,  1,   0}, // #6938
  {11, 10,   0}, // #6939
  {12, 11,   0}, // #6940
  {11, 11,   0}, // #6941
  {12, 11,   0}, // #6942
  { 4,  1,   0}, // #6943
  { 7,  1,   0}, // #6944
  { 8,  1,   0}, // #6945
  { 9,  1,   0}, // #6946
  {10,  1,   0}, // #6947
  {11,  2,   0}, // #6948
  {12,  3,   0}, // #6949
  { 4,  1,   0}, // #6950
  { 7,  1,   0}, // #6951
  { 8,  1,   0}, // #6952
  { 9,  1,   0}, // #6953
  {11,  2,   0}, // #6954
  {12,  2,   0}, // #6955
  { 8,  1,   0}, // #6956
  {10,  1,   0}, // #6957
  {11,  1,   0}, // #6958
  {12,  2,   0}, // #6959
  { 8,  2,   0}, // #6960
  {10,  1,   0}, // #6961
  {11,  2,   0}, // #6962
  {12,  3,   0}, // #6963
  { 8,  2,   0}, // #6964
  {11,  2,   0}, // #6965
  {12,  2,   0}, // #6966
  { 5,  1,   0}, // #6967
  { 6,  1,   0}, // #6968
  { 8,  2,   0}, // #6969
  { 9,  1,   0}, // #6970
  {10,  2,   0}, // #6971
  {11,  3,   0}, // #6972
  {12,  6,   0}, // #6973
  { 5,  1,   0}, // #6974
  { 8,  1,   0}, // #6975
  {10,  2,   0}, // #6976
  {11,  1,   0}, // #6977
  {12,  4,   0}, // #6978
  { 6,  2,   0}, // #6979
  { 8,  3,   0}, // #6980
  { 9,  2,   0}, // #6981
  {11,  3,   0}, // #6982
  {12,  3,   0}, // #6983
  { 8,  1,   0}, // #6984
  {11,  4,   0}, // #6985
  {12,  4,   0}, // #6986
  { 4,  1,   0}, // #6987
  { 6,  1,   0}, // #6988
  { 7,  1,   0}, // #6989
  { 8,  1,   0}, // #6990
  { 9,  2,   0}, // #6991
  {10,  1,   0}, // #6992
  {11,  2,   0}, // #6993
  {12,  3,   0}, // #6994
  { 4,  1,   0}, // #6995
  { 6,  1,   0}, // #6996
  { 7,  1,   0}, // #6997
  { 8,  1,   0}, // #6998
  { 9,  2,   0}, // #6999
  {11,  2,   0}, // #7000
  {12,  2,   0}, // #7001
  { 3,  1,   0}, // #7002
  { 7,  1,   0}, // #7003
  { 8,  1,   0}, // #7004
  {10,  1,   0}, // #7005
  {11,  1,   0}, // #7006
  {12,  2,   0}, // #7007
  { 3,  1,   0}, // #7008
  { 6,  1,   0}, // #7009
  { 7,  1,   0}, // #7010
  { 8,  2,   0}, // #7011
  { 9,  1,   0}, // #7012
  {11,  2,   0}, // #7013
  {12,  2,   0}, // #7014
  { 3,  1,   0}, // #7015
  { 4,  1,   0}, // #7016
  { 7,  2,   0}, // #7017
  { 8,  1,   0}, // #7018
  { 9,  1,   0}, // #7019
  {10,  1,   0}, // #7020
  {11,  2,   0}, // #7021
  {12,  3,   0}, // #7022
  { 3,  1,   0}, // #7023
  { 4,  1,   0}, // #7024
  { 7,  2,   0}, // #7025
  { 8,  1,   0}, // #7026
  { 9,  1,   0}, // #7027
  {11,  2,   0}, // #7028
  {12,  2,   0}, // #7029
  { 4,  1,   0}, // #7030
  { 6,  2,   0}, // #7031
  { 7,  1,   0}, // #7032
  { 8,  2,   0}, // #7033
  { 9,  3,   0}, // #7034
  {11,  3,   0}, // #7035
  {12,  3,   0}, // #7036
  { 1, 10,   0}, // #7037
  { 3,  1,   0}, // #7038
  { 7,  1,   0}, // #7039
  { 8,  1,   0}, // #7040
  {10,  1,   0}, // #7041
  {11,  1,   0}, // #7042
  {12,  2,   0}, // #7043
  { 1, 10,   0}, // #7044
  { 3,  1,   0}, // #7045
  { 7,  1,   0}, // #7046
  { 8,  1,   0}, // #7047
  {11,  1,   0}, // #7048
  {12,  1,   0}, // #7049
  { 2, 22,   0}, // #7050
  { 3,  1,   0}, // #7051
  { 7,  1,   0}, // #7052
  { 8,  1,   0}, // #7053
  {10,  1,   0}, // #7054
  {11,  1,   0}, // #7055
  {12,  2,   0}, // #7056
  { 2, 22,   0}, // #7057
  { 3,  1,   0}, // #7058
  { 7,  1,   0}, // #7059
  { 8,  1,   0}, // #7060
  {11,  1,   0}, // #7061
  {12,  1,   0}, // #7062
  { 2, 14,   0}, // #7063
  { 3,  1,   0}, // #7064
  { 7,  1,   0}, // #7065
  { 8,  1,   0}, // #7066
  {10,  1,   0}, // #7067
  {11,  1,   0}, // #7068
  {12,  2,   0}, // #7069
  { 2, 14,   0}, // #7070
  { 3,  1,   0}, // #7071
  { 7,  1,   0}, // #7072
  { 8,  1,   0}, // #7073
  {11,  1,   0}, // #7074
  {12,  1,   0}, // #7075
  { 3,  1,   0}, // #7076
  { 4,  1,   0}, // #7077
  { 6,  1,   0}, // #7078
  { 7,  2,   0}, // #7079
  { 8,  2,   0}, // #7080
  { 9,  2,   0}, // #7081
  {10,  1,   0}, // #7082
  {11,  3,   0}, // #7083
  {12,  4,   0}, // #7084
  { 3,  1,   0}, // #7085
  { 4,  1,   0}, // #7086
  { 6,  1,   0}, // #7087
  { 7,  2,   0}, // #7088
  { 8,  2,   0}, // #7089
  { 9,  2,   0}, // #7090
  {11,  3,   0}, // #7091
  {12,  3,   0}, // #7092
  { 3,  1,   0}, // #7093
  { 4,  2,   0}, // #7094
  { 6,  2,   0}, // #7095
  { 7,  3,   0}, // #7096
  { 8,  3,   0}, // #7097
  { 9,  4,   0}, // #7098
  {10,  1,   0}, // #7099
  {11,  5,   0}, // #7100
  {12,  6,   0}, // #7101
  { 3,  1,   0}, // #7102
  { 4,  2,   0}, // #7103
  { 6,  1,   0}, // #7104
  { 7,  3,   0}, // #7105
  { 8,  2,   0}, // #7106
  { 9,  3,   0}, // #7107
  {11,  4,   0}, // #7108
  {12,  4,   0}, // #7109
  { 5,  1,   0}, // #7110
  { 9,  1,   0}, // #7111
  {10,  1,   0}, // #7112
  {11,  1,   0}, // #7113
  {12,  3,   0}, // #7114
  { 3,  1,   0}, // #7115
  { 7,  1,   0}, // #7116
  { 8,  1,   0}, // #7117
  { 9,  1,   0}, // #7118
  {11,  2,   0}, // #7119
  {12,  2,   0}, // #7120
  {11, 31,   0}, // #7121
  {12, 31,   0}, // #7122
  { 4,  1,   0}, // #7123
  { 6,  2,   0}, // #7124
  { 7,  1,   0}, // #7125
  { 8,  2,   0}, // #7126
  { 9,  3,   0}, // #7127
  {10,  1,   0}, // #7128
  {11,  3,   0}, // #7129
  {12,  4,   0}, // #7130
  { 4,  1,   0}, // #7131
  { 7,  1,   0}, // #7132
  { 8,  1,   0}, // #7133
  { 9,  1,   0}, // #7134
  {10,  1,   0}, // #7135
  {11,  4,   0}, // #7136
  {12,  5,   0}, // #7137
  { 4,  1,   0}, // #7138
  { 7,  1,   0}, // #7139
  { 8,  1,   0}, // #7140
  { 9,  1,   0}, // #7141
  {11,  4,   0}, // #7142
  {12,  4,   0}, // #7143
  { 4,  1,   0}, // #7144
  { 7,  1,   0}, // #7145
  { 9,  1,   0}, // #7146
  {10,  1,   0}, // #7147
  {11,  2,   0}, // #7148
  {12,  3,   0}, // #7149
  { 4,  1,   0}, // #7150
  { 7,  1,   0}, // #7151
  { 9,  1,   0}, // #7152
  {11,  2,   0}, // #7153
  {12,  2,   0}, // #7154
  { 4,  1,   0}, // #7155
  { 7,  1,   0}, // #7156
  { 8,  1,   0}, // #7157
  { 9,  1,   0}, // #7158
  {10,  1,   0}, // #7159
  {11,  3,   0}, // #7160
  {12,  4,   0}, // #7161
  { 4,  1,   0}, // #7162
  { 7,  1,   0}, // #7163
  { 8,  1,   0}, // #7164
  { 9,  1,   0}, // #7165
  {11,  3,   0}, // #7166
  {12,  3,   0}, // #7167
  { 3,  1,   0}, // #7168
  { 5,  1,   0}, // #7169
  { 6,  1,   0}, // #7170
  { 7,  1,   0}, // #7171
  { 8,  2,   0}, // #7172
  { 9,  1,   0}, // #7173
  {10,  1,   0}, // #7174
  {11,  2,   0}, // #7175
  {12,  4,   0}, // #7176
  { 6,  1,   0}, // #7177
  { 8,  1,   0}, // #7178
  { 9,  2,   0}, // #7179
  {11,  2,   0}, // #7180
  {12,  2,   0}, // #7181
  { 3,  1,   0}, // #7182
  { 7,  1,   0}, // #7183
  { 8,  1,   0}, // #7184
  { 9,  2,   0}, // #7185
  {10,  1,   0}, // #7186
  {11,  3,   0}, // #7187
  {12,  4,   0}, // #7188
  { 3,  1,   0}, // #7189
  { 7,  1,   0}, // #7190
  { 8,  1,   0}, // #7191
  { 9,  2,   0}, // #7192
  {11,  3,   0}, // #7193
  {12,  3,   0}, // #7194
  {10,  1,   0}, // #7195
  {11, 17,   0}, // #7196
  {12, 18,   0}, // #7197
  {11, 18,   0}, // #7198
  {12, 18,   0}, // #7199
  {10,  1,   0}, // #7200
  {11,  7,   0}, // #7201
  {12,  8,   0}, // #7202
  {11,  8,   0}, // #7203
  {12,  8,   0}, // #7204
  { 3,  3,   0}, // #7205
  { 7,  3,   0}, // #7206
  { 8,  3,   0}, // #7207
  {10,  1,   0}, // #7208
  {11,  3,   0}, // #7209
  {12,  4,   0}, // #7210
  { 3,  3,   0}, // #7211
  { 7,  3,   0}, // #7212
  { 8,  3,   0}, // #7213
  {11,  3,   0}, // #7214
  {12,  3,   0}, // #7215
  { 5,  1,   0}, // #7216
  {10,  2,   0}, // #7217
  {12,  3,   0}, // #7218
  { 3,  1,   0}, // #7219
  { 7,  1,   0}, // #7220
  { 8,  1,   0}, // #7221
  { 9,  1,   0}, // #7222
  {10,  1,   0}, // #7223
  {11,  2,   0}, // #7224
  {12,  3,   0}, // #7225
  { 3,  1,   0}, // #7226
  { 6,  1,   0}, // #7227
  { 7,  1,   0}, // #7228
  { 8,  2,   0}, // #7229
  { 9,  1,   0}, // #7230
  {10,  1,   0}, // #7231
  {11,  2,   0}, // #7232
  {12,  3,   0}, // #7233
  { 5,  1,   0}, // #7234
  { 8,  2,   0}, // #7235
  {10,  2,   0}, // #7236
  {11,  2,   0}, // #7237
  {12,  5,   0}, // #7238
  { 8,  4,   0}, // #7239
  {10,  1,   0}, // #7240
  {11,  4,   0}, // #7241
  {12,  5,   0}, // #7242
  { 5,  1,   0}, // #7243
  { 8,  3,   0}, // #7244
  {10,  2,   0}, // #7245
  {11,  3,   0}, // #7246
  {12,  6,   0}, // #7247
  { 8,  6,   0}, // #7248
  {10,  1,   0}, // #7249
  {11,  6,   0}, // #7250
  {12,  7,   0}, // #7251
  { 5,  1,   0}, // #7252
  { 8,  1,   0}, // #7253
  {10,  1,   0}, // #7254
  {11,  1,   0}, // #7255
  {12,  3,   0}, // #7256
  { 5,  1,   0}, // #7257
  { 8,  3,   0}, // #7258
  {10,  2,   0}, // #7259
  {11,  4,   0}, // #7260
  {12,  7,   0}, // #7261
  { 5,  1,   0}, // #7262
  { 8,  1,   0}, // #7263
  {10,  2,   0}, // #7264
  {11,  2,   0}, // #7265
  {12,  5,   0}, // #7266
  { 2, 21,   0}, // #7267
  { 3,  1,   0}, // #7268
  { 7,  1,   0}, // #7269
  { 8,  1,   0}, // #7270
  {10,  1,   0}, // #7271
  {11,  1,   0}, // #7272
  {12,  2,   0}, // #7273
  { 2, 21,   0}, // #7274
  { 3,  1,   0}, // #7275
  { 7,  1,   0}, // #7276
  { 8,  1,   0}, // #7277
  {11,  1,   0}, // #7278
  {12,  1,   0}, // #7279
  { 2, 24,   0}, // #7280
  { 3,  1,   0}, // #7281
  { 7,  1,   0}, // #7282
  { 8,  1,   0}, // #7283
  {11,  1,   0}, // #7284
  {12,  1,   0}, // #7285
  { 7,  1,   0}, // #7286
  {10,  1,   0}, // #7287
  {11,  1,   0}, // #7288
  {12,  2,   0}, // #7289
  { 3,  1,   0}, // #7290
  { 4,  1,   0}, // #7291
  { 5,  1,   0}, // #7292
  { 7,  2,   0}, // #7293
  { 8,  1,   0}, // #7294
  { 9,  1,   0}, // #7295
  {10,  1,   0}, // #7296
  {11,  2,   0}, // #7297
  {12,  4,   0}, // #7298
  { 2, 28,   0}, // #7299
  { 3,  2,   0}, // #7300
  { 7,  2,   0}, // #7301
  { 8,  3,   0}, // #7302
  {10,  1,   0}, // #7303
  {11,  3,   0}, // #7304
  {12,  4,   0}, // #7305
  { 2, 28,   0}, // #7306
  { 3,  2,   0}, // #7307
  { 7,  2,   0}, // #7308
  { 8,  3,   0}, // #7309
  {11,  3,   0}, // #7310
  {12,  3,   0}, // #7311
  { 2, 44,   0}, // #7312
  { 3,  2,   0}, // #7313
  { 7,  2,   0}, // #7314
  { 8,  3,   0}, // #7315
  {10,  1,   0}, // #7316
  {11,  3,   0}, // #7317
  {12,  4,   0}, // #7318
  { 2, 44,   0}, // #7319
  { 3,  2,   0}, // #7320
  { 7,  2,   0}, // #7321
  { 8,  3,   0}, // #7322
  {11,  3,   0}, // #7323
  {12,  3,   0}, // #7324
  { 5,  1,   0}, // #7325
  { 7,  2,   0}, // #7326
  {10,  1,   0}, // #7327
  {11,  2,   0}, // #7328
  {12,  4,   0}, // #7329
  { 8,  7,   0}, // #7330
  {10,  4,   0}, // #7331
  {11,  7,   0}, // #7332
  {12, 11,   0}, // #7333
  { 5,  1,   0}, // #7334
  {10,  2,   0}, // #7335
  {11,  2,   0}, // #7336
  {12,  5,   0}, // #7337
  { 6,  1,   0}, // #7338
  { 7,  1,   0}, // #7339
  { 8,  1,   0}, // #7340
  { 9,  1,   0}, // #7341
  {10,  1,   0}, // #7342
  {11,  2,   0}, // #7343
  {12,  3,   0}, // #7344
  { 5,  1,   0}, // #7345
  { 6,  2,   0}, // #7346
  { 8,  2,   0}, // #7347
  { 9,  2,   0}, // #7348
  {10,  2,   0}, // #7349
  {11,  2,   0}, // #7350
  {12,  5,   0}, // #7351
  { 4,  1,   0}, // #7352
  { 5,  1,   0}, // #7353
  { 7,  1,   0}, // #7354
  { 9,  1,   0}, // #7355
  {10,  2,   0}, // #7356
  {11,  1,   0}, // #7357
  {12,  4,   0}, // #7358
  { 4,  1,   0}, // #7359
  { 6,  3,   0}, // #7360
  { 7,  1,   0}, // #7361
  { 8,  5,   0}, // #7362
  { 9,  4,   0}, // #7363
  {11, 12,   0}, // #7364
  {12, 12,   0}, // #7365
  { 5,  1,   0}, // #7366
  { 6,  1,   0}, // #7367
  { 8,  1,   0}, // #7368
  { 9,  1,   0}, // #7369
  {10,  2,   0}, // #7370
  {11,  1,   0}, // #7371
  {12,  4,   0}, // #7372
  { 6,  1,   0}, // #7373
  { 8,  1,   0}, // #7374
  { 9,  1,   0}, // #7375
  {11,  4,   0}, // #7376
  {12,  4,   0}, // #7377
  { 4,  1,   0}, // #7378
  { 6,  3,   0}, // #7379
  { 7,  1,   0}, // #7380
  { 8,  3,   0}, // #7381
  { 9,  4,   0}, // #7382
  {11,  8,   0}, // #7383
  {12,  8,   0}, // #7384
  { 5,  1,   0}, // #7385
  { 6,  2,   0}, // #7386
  { 7,  1,   0}, // #7387
  { 8,  2,   0}, // #7388
  { 9,  2,   0}, // #7389
  {10,  1,   0}, // #7390
  {11,  3,   0}, // #7391
  {12,  5,   0}, // #7392
  { 3,  1,   0}, // #7393
  { 7,  1,   0}, // #7394
  { 8,  1,   0}, // #7395
  {11,  2,   0}, // #7396
  {12,  2,   0}, // #7397
  { 8,  2,   0}, // #7398
  {11,  3,   0}, // #7399
  {12,  3,   0}, // #7400
  { 4,  1,   0}, // #7401
  { 6,  1,   0}, // #7402
  { 7,  1,   0}, // #7403
  { 8,  5,   0}, // #7404
  { 9,  2,   0}, // #7405
  {11,  8,   0}, // #7406
  {12,  8,   0}, // #7407
  { 8,  8,   0}, // #7408
  {11,  8,   0}, // #7409
  {12,  8,   0}, // #7410
  { 4,  1,   0}, // #7411
  { 5,  1,   0}, // #7412
  { 7,  1,   0}, // #7413
  { 9,  1,   0}, // #7414
  {10,  1,   0}, // #7415
  {11,  1,   0}, // #7416
  {12,  3,   0}, // #7417
  { 5,  1,   0}, // #7418
  { 6,  1,   0}, // #7419
  { 8,  1,   0}, // #7420
  { 9,  1,   0}, // #7421
  {10,  1,   0}, // #7422
  {11,  1,   0}, // #7423
  {12,  3,   0}, // #7424
  { 5,  1,   0}, // #7425
  {10,  1,   0}, // #7426
  {11,  1,   0}, // #7427
  {12,  3,   0}, // #7428
  { 3,  1,   0}, // #7429
  { 5,  1,   0}, // #7430
  { 7,  1,   0}, // #7431
  { 8,  1,   0}, // #7432
  { 9,  1,   0}, // #7433
  {10,  1,   0}, // #7434
  {11,  2,   0}, // #7435
  {12,  4,   0}, // #7436
  { 5,  1,   0}, // #7437
  { 6,  1,   0}, // #7438
  { 7,  1,   0}, // #7439
  { 8,  1,   0}, // #7440
  { 9,  1,   0}, // #7441
  {10,  1,   0}, // #7442
  {11,  2,   0}, // #7443
  {12,  4,   0}, // #7444
  { 3,  1,   0}, // #7445
  { 5,  1,   0}, // #7446
  { 7,  1,   0}, // #7447
  { 8,  1,   0}, // #7448
  {10,  2,   0}, // #7449
  {11,  1,   0}, // #7450
  {12,  4,   0}, // #7451
  { 4,  1,   0}, // #7452
  { 6,  2,   0}, // #7453
  { 7,  1,   0}, // #7454
  { 8,  2,   0}, // #7455
  { 9,  3,   0}, // #7456
  {11,  4,   0}, // #7457
  {12,  4,   0}, // #7458
  {10,  2,   0}, // #7459
  {11,  3,   0}, // #7460
  {12,  5,   0}, // #7461
  { 5,  1,   0}, // #7462
  { 6,  1,   0}, // #7463
  { 7,  1,   0}, // #7464
  { 8,  1,   0}, // #7465
  { 9,  1,   0}, // #7466
  {10,  2,   0}, // #7467
  {11,  2,   0}, // #7468
  {12,  5,   0}, // #7469
  { 5,  1,   0}, // #7470
  { 8,  2,   0}, // #7471
  {10,  2,   0}, // #7472
  {11,  3,   0}, // #7473
  {12,  6,   0}, // #7474
  { 4,  2,   0}, // #7475
  { 7,  2,   0}, // #7476
  { 9,  2,   0}, // #7477
  {10,  1,   0}, // #7478
  {11,  2,   0}, // #7479
  {12,  3,   0}, // #7480
  { 8,  2,   0}, // #7481
  {10,  1,   0}, // #7482
  {11,  3,   0}, // #7483
  {12,  4,   0}, // #7484
  { 5,  1,   0}, // #7485
  { 8,  2,   0}, // #7486
  {10,  1,   0}, // #7487
  {11,  2,   0}, // #7488
  {12,  4,   0}, // #7489
  { 3,  1,   0}, // #7490
  { 4,  1,   0}, // #7491
  { 8,  1,   0}, // #7492
  { 9,  1,   0}, // #7493
  {11,  2,   0}, // #7494
  {12,  1,   0}, // #7495
  {13,  2,   0}, // #7496
  {14,  2,   0}, // #7497
  {15,  2,   0}, // #7498
  {16,  2,   0}, // #7499
  {18,  2,   0}, // #7500
  {19,  3,   0}, // #7501
  {20,  3,   0}, // #7502
  {22,  4,   0}, // #7503
  {23,  4,   0}, // #7504
  { 4,  1,   0}, // #7505
  { 9,  1,   0}, // #7506
  {11,  1,   0}, // #7507
  {14,  1,   0}, // #7508
  {15,  1,   0}, // #7509
  {16,  2,   0}, // #7510
  {17,  1,   0}, // #7511
  {18,  1,   0}, // #7512
  {19,  1,   0}, // #7513
  {20,  1,   0}, // #7514
  {21,  1,   0}, // #7515
  {22,  2,   0}, // #7516
  {23,  3,   0}, // #7517
  { 4,  1,   0}, // #7518
  { 9,  1,   0}, // #7519
  {11,  1,   0}, // #7520
  {14,  1,   0}, // #7521
  {15,  1,   0}, // #7522
  {16,  2,   0}, // #7523
  {18,  1,   0}, // #7524
  {19,  1,   0}, // #7525
  {20,  1,   0}, // #7526
  {22,  2,   0}, // #7527
  {23,  2,   0}, // #7528
  { 2, 17,   0}, // #7529
  { 3,  1,   0}, // #7530
  {11,  1,   0}, // #7531
  {12,  1,   0}, // #7532
  {13,  1,   0}, // #7533
  {14,  1,   0}, // #7534
  {19,  1,   0}, // #7535
  {20,  1,   0}, // #7536
  {22,  1,   0}, // #7537
  {23,  1,   0}, // #7538
  { 4,  1,   0}, // #7539
  { 7,  1,   0}, // #7540
  { 8,  1,   0}, // #7541
  {11,  1,   0}, // #7542
  {12,  1,   0}, // #7543
  {13,  1,   0}, // #7544
  {15,  2,   0}, // #7545
  {16,  1,   0}, // #7546
  {18,  1,   0}, // #7547
  {19,  2,   0}, // #7548
  {20,  1,   0}, // #7549
  {21,  1,   0}, // #7550
  {22,  2,   0}, // #7551
  {23,  4,   0}, // #7552
  { 2, 14,   0}, // #7553
  { 3,  2,   0}, // #7554
  {11,  2,   0}, // #7555
  {12,  2,   0}, // #7556
  {13,  2,   0}, // #7557
  {14,  2,   0}, // #7558
  {15,  1,   0}, // #7559
  {17,  1,   0}, // #7560
  {19,  3,   0}, // #7561
  {20,  2,   0}, // #7562
  {21,  1,   0}, // #7563
  {22,  3,   0}, // #7564
  {23,  4,   0}, // #7565
  { 2, 14,   0}, // #7566
  { 3,  2,   0}, // #7567
  {11,  2,   0}, // #7568
  {12,  2,   0}, // #7569
  {13,  2,   0}, // #7570
  {14,  2,   0}, // #7571
  {15,  1,   0}, // #7572
  {19,  3,   0}, // #7573
  {20,  2,   0}, // #7574
  {22,  3,   0}, // #7575
  {23,  3,   0}, // #7576
  { 2, 28,   0}, // #7577
  { 3,  2,   0}, // #7578
  {11,  2,   0}, // #7579
  {12,  2,   0}, // #7580
  {13,  2,   0}, // #7581
  {14,  2,   0}, // #7582
  {15,  1,   0}, // #7583
  {17,  1,   0}, // #7584
  {19,  3,   0}, // #7585
  {20,  2,   0}, // #7586
  {21,  1,   0}, // #7587
  {22,  3,   0}, // #7588
  {23,  4,   0}, // #7589
  { 2, 28,   0}, // #7590
  { 3,  2,   0}, // #7591
  {11,  2,   0}, // #7592
  {12,  2,   0}, // #7593
  {13,  2,   0}, // #7594
  {14,  2,   0}, // #7595
  {15,  1,   0}, // #7596
  {19,  3,   0}, // #7597
  {20,  2,   0}, // #7598
  {22,  3,   0}, // #7599
  {23,  3,   0}, // #7600
  { 3,  2,   0}, // #7601
  { 4,  1,   0}, // #7602
  { 8,  2,   0}, // #7603
  { 9,  4,   0}, // #7604
  {11,  5,   0}, // #7605
  {12,  2,   0}, // #7606
  {13,  4,   0}, // #7607
  {14,  6,   0}, // #7608
  {15,  3,   0}, // #7609
  {16,  5,   0}, // #7610
  {18,  6,   0}, // #7611
  {19,  7,   0}, // #7612
  {20,  8,   0}, // #7613
  {22, 15,   0}, // #7614
  {23, 15,   0}, // #7615
  { 7,  1,   0}, // #7616
  {12,  1,   0}, // #7617
  {17,  2,   0}, // #7618
  {21,  2,   0}, // #7619
  {22,  2,   0}, // #7620
  {23,  5,   0}, // #7621
  {17,  1,   0}, // #7622
  {21,  1,   0}, // #7623
  {22, 14,   0}, // #7624
  {23, 15,   0}, // #7625
  {17,  2,   0}, // #7626
  {21,  2,   0}, // #7627
  {22,  3,   0}, // #7628
  {23,  5,   0}, // #7629
  { 9,  2,   0}, // #7630
  {14,  2,   0}, // #7631
  {16,  2,   0}, // #7632
  {17,  1,   0}, // #7633
  {18,  2,   0}, // #7634
  {19,  1,   0}, // #7635
  {20,  2,   0}, // #7636
  {21,  1,   0}, // #7637
  {22,  3,   0}, // #7638
  {23,  4,   0}, // #7639
  {17,  1,   0}, // #7640
  {19, 16,   0}, // #7641
  {21,  1,   0}, // #7642
  {22, 16,   0}, // #7643
  {23, 17,   0}, // #7644
  { 3,  2,   0}, // #7645
  { 8,  2,   0}, // #7646
  {11,  2,   0}, // #7647
  {12,  2,   0}, // #7648
  {13,  4,   0}, // #7649
  {14,  4,   0}, // #7650
  {15,  3,   0}, // #7651
  {17,  2,   0}, // #7652
  {18,  2,   0}, // #7653
  {19,  8,   0}, // #7654
  {20,  6,   0}, // #7655
  {21,  2,   0}, // #7656
  {22, 10,   0}, // #7657
  {23, 12,   0}, // #7658
  { 3,  3,   0}, // #7659
  { 8,  3,   0}, // #7660
  {11,  3,   0}, // #7661
  {12,  3,   0}, // #7662
  {13,  6,   0}, // #7663
  {14,  7,   0}, // #7664
  {15,  4,   0}, // #7665
  {17,  4,   0}, // #7666
  {18,  3,   0}, // #7667
  {19, 12,   0}, // #7668
  {20, 10,   0}, // #7669
  {21,  4,   0}, // #7670
  {22, 16,   0}, // #7671
  {23, 20,   0}, // #7672
  { 3,  5,   0}, // #7673
  { 8,  3,   0}, // #7674
  {11,  5,   0}, // #7675
  {12,  5,   0}, // #7676
  {13,  8,   0}, // #7677
  {14, 13,   0}, // #7678
  {15,  4,   0}, // #7679
  {17,  8,   0}, // #7680
  {18,  3,   0}, // #7681
  {19, 18,   0}, // #7682
  {20, 16,   0}, // #7683
  {21,  8,   0}, // #7684
  {22, 26,   0}, // #7685
  {23, 34,   0}, // #7686
  { 3,  3,   0}, // #7687
  { 8,  3,   0}, // #7688
  {11,  3,   0}, // #7689
  {12,  3,   0}, // #7690
  {13,  6,   0}, // #7691
  {14,  5,   0}, // #7692
  {15,  4,   0}, // #7693
  {17,  2,   0}, // #7694
  {18,  3,   0}, // #7695
  {19, 10,   0}, // #7696
  {20,  8,   0}, // #7697
  {21,  2,   0}, // #7698
  {22, 12,   0}, // #7699
  {23, 14,   0}, // #7700
  { 3,  5,   0}, // #7701
  { 8,  3,   0}, // #7702
  {11,  5,   0}, // #7703
  {12,  5,   0}, // #7704
  {13,  8,   0}, // #7705
  {14,  9,   0}, // #7706
  {15,  4,   0}, // #7707
  {17,  4,   0}, // #7708
  {18,  3,   0}, // #7709
  {19, 14,   0}, // #7710
  {20, 12,   0}, // #7711
  {21,  4,   0}, // #7712
  {22, 18,   0}, // #7713
  {23, 22,   0}, // #7714
  { 3,  3,   0}, // #7715
  { 8,  3,   0}, // #7716
  {11,  3,   0}, // #7717
  {12,  3,   0}, // #7718
  {13,  6,   0}, // #7719
  {14,  5,   0}, // #7720
  {15,  4,   0}, // #7721
  {17,  2,   0}, // #7722
  {18,  3,   0}, // #7723
  {19, 11,   0}, // #7724
  {20,  8,   0}, // #7725
  {21,  2,   0}, // #7726
  {22, 13,   0}, // #7727
  {23, 15,   0}, // #7728
  {14,  1,   0}, // #7729
  {17,  1,   0}, // #7730
  {20,  1,   0}, // #7731
  {21,  1,   0}, // #7732
  {22,  3,   0}, // #7733
  {23,  4,   0}, // #7734
  { 4,  2,   0}, // #7735
  { 5,  3,   0}, // #7736
  { 7,  2,   0}, // #7737
  { 8,  2,   0}, // #7738
  {14,  2,   0}, // #7739
  {15,  1,   0}, // #7740
  {18,  1,   0}, // #7741
  {23,  1,   0}, // #7742
  {28,  6,   0}, // #7743
  { 4,  1,   0}, // #7744
  { 5,  1,   0}, // #7745
  { 7,  1,   0}, // #7746
  { 8,  1,   0}, // #7747
  {14,  1,   0}, // #7748
  {15,  1,   0}, // #7749
  {28,  2,   0}, // #7750
  {14,  2,   0}, // #7751
  {15,  1,   0}, // #7752
  {18,  1,   0}, // #7753
  {23,  1,   0}, // #7754
  {28,  3,   0}, // #7755
  {14,  1,   0}, // #7756
  {18,  1,   0}, // #7757
  {23,  1,   0}, // #7758
  {28,  2,   0}, // #7759
  {14,  1,   0}, // #7760
  {15,  1,   0}, // #7761
  {28,  1,   0}, // #7762
  { 5,  1,   0}, // #7763
  {14,  2,   0}, // #7764
  {15,  1,   0}, // #7765
  {18,  1,   0}, // #7766
  {23,  1,   0}, // #7767
  {28,  4,   0}, // #7768
  { 4,  1,   0}, // #7769
  { 5,  2,   0}, // #7770
  { 7,  1,   0}, // #7771
  { 8,  1,   0}, // #7772
  {14,  2,   0}, // #7773
  {15,  1,   0}, // #7774
  {18,  1,   0}, // #7775
  {23,  1,   0}, // #7776
  {28,  5,   0}, // #7777
  { 3,  1,   0}, // #7778
  { 4,  1,   0}, // #7779
  { 5,  1,   0}, // #7780
  {10,  1,   0}, // #7781
  {11,  1,   0}, // #7782
  {14,  1,   0}, // #7783
  {15,  1,   0}, // #7784
  {28,  2,   0}, // #7785
  { 2,  1,   0}, // #7786
  { 3,  1,   0}, // #7787
  { 4,  1,   0}, // #7788
  { 5,  1,   0}, // #7789
  {14,  1,   0}, // #7790
  {15,  1,   0}, // #7791
  {28,  2,   0}, // #7792
  { 2,  2,   0}, // #7793
  { 3,  2,   0}, // #7794
  { 4,  2,   0}, // #7795
  { 5,  2,   0}, // #7796
  {14,  1,   0}, // #7797
  {15,  1,   0}, // #7798
  {28,  3,   0}, // #7799
  { 1,  4,   0}, // #7800
  { 2,  5,   0}, // #7801
  { 3, 11,   0}, // #7802
  { 4, 13,   0}, // #7803
  { 5, 13,   0}, // #7804
  { 6,  7,   0}, // #7805
  { 7,  9,   0}, // #7806
  { 8,  6,   0}, // #7807
  {10,  6,   0}, // #7808
  {11,  6,   0}, // #7809
  {14,  1,   0}, // #7810
  {15,  1,   0}, // #7811
  {19,  3,   0}, // #7812
  {20,  3,   0}, // #7813
  {28, 14,   0}, // #7814
  { 1,  4,   0}, // #7815
  { 2,  5,   0}, // #7816
  { 3, 12,   0}, // #7817
  { 4, 14,   0}, // #7818
  { 5, 14,   0}, // #7819
  { 6,  7,   0}, // #7820
  { 7,  9,   0}, // #7821
  { 8,  6,   0}, // #7822
  {10,  6,   0}, // #7823
  {11,  6,   0}, // #7824
  {19,  3,   0}, // #7825
  {20,  3,   0}, // #7826
  {28, 14,   0}, // #7827
  { 2,  1,   0}, // #7828
  { 3,  1,   0}, // #7829
  { 4,  2,   0}, // #7830
  { 5,  2,   0}, // #7831
  { 7,  1,   0}, // #7832
  { 8,  1,   0}, // #7833
  { 9,  1,   0}, // #7834
  {10,  1,   0}, // #7835
  {11,  1,   0}, // #7836
  {14,  1,   0}, // #7837
  {15,  1,   0}, // #7838
  {28,  3,   0}, // #7839
  { 5,  1,   0}, // #7840
  {11,  1,   0}, // #7841
  {14,  1,   0}, // #7842
  {15,  1,   0}, // #7843
  {28,  2,   0}, // #7844
  { 2,  1,   0}, // #7845
  { 3,  1,   0}, // #7846
  { 4,  1,   0}, // #7847
  { 5,  1,   0}, // #7848
  { 9,  1,   0}, // #7849
  {10,  1,   0}, // #7850
  {11,  1,   0}, // #7851
  {14,  1,   0}, // #7852
  {15,  1,   0}, // #7853
  {28,  2,   0}, // #7854
  { 2,  1,   0}, // #7855
  { 3,  1,   0}, // #7856
  { 4,  3,   0}, // #7857
  { 5,  9,   0}, // #7858
  { 7,  2,   0}, // #7859
  { 8,  2,   0}, // #7860
  { 9,  1,   0}, // #7861
  {10,  1,   0}, // #7862
  {11,  3,   0}, // #7863
  {14,  1,   0}, // #7864
  {15,  1,   0}, // #7865
  {28, 10,   0}, // #7866
  { 2,  1,   0}, // #7867
  { 3,  1,   0}, // #7868
  { 4,  1,   0}, // #7869
  { 5,  1,   0}, // #7870
  { 9,  1,   0}, // #7871
  {10,  1,   0}, // #7872
  {11,  1,   0}, // #7873
  {14,  2,   0}, // #7874
  {15,  1,   0}, // #7875
  {18,  1,   0}, // #7876
  {23,  1,   0}, // #7877
  {28,  4,   0}, // #7878
  { 2,  1,   0}, // #7879
  { 3,  1,   0}, // #7880
  { 4,  3,   0}, // #7881
  { 5,  8,   0}, // #7882
  { 7,  2,   0}, // #7883
  { 8,  2,   0}, // #7884
  { 9,  1,   0}, // #7885
  {10,  1,   0}, // #7886
  {11,  3,   0}, // #7887
  {14,  2,   0}, // #7888
  {15,  1,   0}, // #7889
  {18,  1,   0}, // #7890
  {23,  1,   0}, // #7891
  {28, 11,   0}, // #7892
  { 1,  1,   0}, // #7893
  { 2,  1,   0}, // #7894
  { 3,  1,   0}, // #7895
  { 4,  1,   0}, // #7896
  { 5,  1,   0}, // #7897
  { 6,  1,   0}, // #7898
  { 7,  1,   0}, // #7899
  { 8,  1,   0}, // #7900
  {14,  1,   0}, // #7901
  {15,  1,   0}, // #7902
  {28,  2,   0}, // #7903
  { 3,  1,   0}, // #7904
  { 4,  1,   0}, // #7905
  { 5,  1,   0}, // #7906
  { 6,  1,   0}, // #7907
  { 7,  1,   0}, // #7908
  {10,  1,   0}, // #7909
  {11,  1,   0}, // #7910
  {19,  1,   0}, // #7911
  {20,  1,   0}, // #7912
  {28,  1,   0}, // #7913
  { 2,  1,   0}, // #7914
  { 3,  2,   0}, // #7915
  { 4,  2,   0}, // #7916
  { 5,  2,   0}, // #7917
  { 6,  1,   0}, // #7918
  { 7,  1,   0}, // #7919
  {10,  1,   0}, // #7920
  {11,  1,   0}, // #7921
  {19,  1,   0}, // #7922
  {20,  1,   0}, // #7923
  {28,  2,   0}, // #7924
  { 2,  1,   0}, // #7925
  { 3,  2,   0}, // #7926
  { 4,  2,   0}, // #7927
  { 5,  2,   0}, // #7928
  { 6,  1,   0}, // #7929
  { 7,  1,   0}, // #7930
  {10,  1,   0}, // #7931
  {11,  1,   0}, // #7932
  {14,  1,   0}, // #7933
  {15,  1,   0}, // #7934
  {19,  1,   0}, // #7935
  {20,  1,   0}, // #7936
  {28,  3,   0}, // #7937
  { 1,  1,   0}, // #7938
  { 2,  2,   0}, // #7939
  { 3,  2,   0}, // #7940
  { 4,  2,   0}, // #7941
  { 5,  2,   0}, // #7942
  { 6,  1,   0}, // #7943
  { 7,  1,   0}, // #7944
  { 8,  1,   0}, // #7945
  {14,  1,   0}, // #7946
  {15,  1,   0}, // #7947
  {28,  3,   0}, // #7948
  { 2,  1,   0}, // #7949
  { 3,  3,   0}, // #7950
  { 4,  3,   0}, // #7951
  { 5,  3,   0}, // #7952
  { 6,  1,   0}, // #7953
  { 7,  1,   0}, // #7954
  {10,  1,   0}, // #7955
  {11,  1,   0}, // #7956
  {19,  1,   0}, // #7957
  {20,  1,   0}, // #7958
  {28,  3,   0}, // #7959
  { 2,  3,   0}, // #7960
  { 3,  3,   0}, // #7961
  { 4,  3,   0}, // #7962
  { 5,  4,   0}, // #7963
  { 9,  3,   0}, // #7964
  {10,  3,   0}, // #7965
  {11,  3,   0}, // #7966
  {14,  1,   0}, // #7967
  {15,  1,   0}, // #7968
  {28,  5,   0}, // #7969
  { 2,  3,   0}, // #7970
  { 3,  3,   0}, // #7971
  { 4,  3,   0}, // #7972
  { 5,  3,   0}, // #7973
  { 9,  3,   0}, // #7974
  {10,  3,   0}, // #7975
  {11,  3,   0}, // #7976
  {14,  1,   0}, // #7977
  {15,  1,   0}, // #7978
  {28,  4,   0}, // #7979
  { 2,  2,   0}, // #7980
  { 3,  3,   0}, // #7981
  { 4,  3,   0}, // #7982
  { 5,  3,   0}, // #7983
  {10,  1,   0}, // #7984
  {11,  1,   0}, // #7985
  {14,  1,   0}, // #7986
  {15,  1,   0}, // #7987
  {28,  4,   0}, // #7988
  { 2,  2,   0}, // #7989
  { 3,  5,   0}, // #7990
  { 4,  6,   0}, // #7991
  { 5,  6,   0}, // #7992
  { 6,  1,   0}, // #7993
  { 7,  2,   0}, // #7994
  { 8,  1,   0}, // #7995
  {10,  3,   0}, // #7996
  {11,  3,   0}, // #7997
  {14,  1,   0}, // #7998
  {15,  1,   0}, // #7999
  {19,  1,   0}, // #8000
  {20,  1,   0}, // #8001
  {28,  7,   0}, // #8002
  { 2,  2,   0}, // #8003
  { 3,  5,   0}, // #8004
  { 4,  6,   0}, // #8005
  { 5,  6,   0}, // #8006
  { 6,  1,   0}, // #8007
  { 7,  2,   0}, // #8008
  { 8,  1,   0}, // #8009
  {10,  3,   0}, // #8010
  {11,  3,   0}, // #8011
  {19,  1,   0}, // #8012
  {20,  1,   0}, // #8013
  {28,  6,   0}, // #8014
  { 3,  1,   0}, // #8015
  { 4,  1,   0}, // #8016
  { 5,  1,   0}, // #8017
  {10,  1,   0}, // #8018
  {11,  1,   0}, // #8019
  {14,  1,   0}, // #8020
  {18,  1,   0}, // #8021
  {23,  1,   0}, // #8022
  {28,  3,   0}, // #8023
  { 3,  1,   0}, // #8024
  { 4,  1,   0}, // #8025
  { 5,  1,   0}, // #8026
  { 6,  1,   0}, // #8027
  { 7,  1,   0}, // #8028
  {10,  1,   0}, // #8029
  {11,  1,   0}, // #8030
  {14,  1,   0}, // #8031
  {15,  1,   0}, // #8032
  {19,  1,   0}, // #8033
  {20,  1,   0}, // #8034
  {28,  2,   0}, // #8035
  { 3,  3,   0}, // #8036
  { 4,  3,   0}, // #8037
  { 5,  3,   0}, // #8038
  { 6,  2,   0}, // #8039
  { 7,  2,   0}, // #8040
  {10,  3,   0}, // #8041
  {11,  3,   0}, // #8042
  {14,  1,   0}, // #8043
  {15,  1,   0}, // #8044
  {19,  2,   0}, // #8045
  {20,  2,   0}, // #8046
  {28,  4,   0}, // #8047
  { 3,  3,   0}, // #8048
  { 4,  3,   0}, // #8049
  { 5,  3,   0}, // #8050
  { 6,  2,   0}, // #8051
  { 7,  2,   0}, // #8052
  {10,  3,   0}, // #8053
  {11,  3,   0}, // #8054
  {19,  2,   0}, // #8055
  {20,  2,   0}, // #8056
  {28,  3,   0}, // #8057
  { 2,  1,   0}, // #8058
  { 3,  1,   0}, // #8059
  { 4,  2,   0}, // #8060
  { 5,  4,   0}, // #8061
  { 7,  1,   0}, // #8062
  { 8,  1,   0}, // #8063
  { 9,  1,   0}, // #8064
  {10,  1,   0}, // #8065
  {11,  1,   0}, // #8066
  {14,  1,   0}, // #8067
  {15,  1,   0}, // #8068
  {28,  5,   0}, // #8069
  { 2,  1,   0}, // #8070
  { 3,  1,   0}, // #8071
  { 4,  1,   0}, // #8072
  { 5,  2,   0}, // #8073
  { 9,  1,   0}, // #8074
  {10,  1,   0}, // #8075
  {11,  1,   0}, // #8076
  {14,  1,   0}, // #8077
  {15,  1,   0}, // #8078
  {28,  3,   0}, // #8079
  { 2,  1,   0}, // #8080
  { 3,  1,   0}, // #8081
  { 4,  2,   0}, // #8082
  { 5,  3,   0}, // #8083
  { 7,  1,   0}, // #8084
  { 8,  1,   0}, // #8085
  { 9,  1,   0}, // #8086
  {10,  1,   0}, // #8087
  {11,  1,   0}, // #8088
  {14,  1,   0}, // #8089
  {15,  1,   0}, // #8090
  {28,  4,   0}, // #8091
  { 2,  1,   0}, // #8092
  { 3,  2,   0}, // #8093
  { 4,  2,   0}, // #8094
  { 5,  2,   0}, // #8095
  { 6,  1,   0}, // #8096
  { 7,  1,   0}, // #8097
  { 9,  1,   0}, // #8098
  {10,  2,   0}, // #8099
  {11,  2,   0}, // #8100
  {14,  1,   0}, // #8101
  {15,  1,   0}, // #8102
  {19,  1,   0}, // #8103
  {20,  1,   0}, // #8104
  {28,  3,   0}, // #8105
  { 2,  1,   0}, // #8106
  { 3,  2,   0}, // #8107
  { 4,  2,   0}, // #8108
  { 5,  2,   0}, // #8109
  { 6,  1,   0}, // #8110
  { 7,  1,   0}, // #8111
  { 9,  1,   0}, // #8112
  {10,  2,   0}, // #8113
  {11,  2,   0}, // #8114
  {19,  1,   0}, // #8115
  {20,  1,   0}, // #8116
  {28,  2,   0}, // #8117
  { 1,  1,   0}, // #8118
  { 2,  1,   0}, // #8119
  { 3,  2,   0}, // #8120
  { 4,  3,   0}, // #8121
  { 5,  3,   0}, // #8122
  { 6,  1,   0}, // #8123
  { 7,  2,   0}, // #8124
  { 8,  2,   0}, // #8125
  {14,  1,   0}, // #8126
  {15,  1,   0}, // #8127
  {28,  4,   0}, // #8128
  { 3,  1,   0}, // #8129
  { 4,  1,   0}, // #8130
  { 5,  1,   0}, // #8131
  { 6,  1,   0}, // #8132
  { 7,  1,   0}, // #8133
  {14,  1,   0}, // #8134
  {15,  1,   0}, // #8135
  {28,  2,   0}, // #8136
  { 3,  3,   0}, // #8137
  { 4,  3,   0}, // #8138
  { 5,  3,   0}, // #8139
  { 6,  3,   0}, // #8140
  { 7,  3,   0}, // #8141
  {10,  2,   0}, // #8142
  {11,  2,   0}, // #8143
  {14,  1,   0}, // #8144
  {15,  1,   0}, // #8145
  {19,  2,   0}, // #8146
  {20,  2,   0}, // #8147
  {28,  4,   0}, // #8148
  { 3,  3,   0}, // #8149
  { 4,  3,   0}, // #8150
  { 5,  3,   0}, // #8151
  { 6,  3,   0}, // #8152
  { 7,  3,   0}, // #8153
  {10,  2,   0}, // #8154
  {11,  2,   0}, // #8155
  {19,  2,   0}, // #8156
  {20,  2,   0}, // #8157
  {28,  3,   0}, // #8158
  { 3,  2,   0}, // #8159
  { 4,  2,   0}, // #8160
  { 5,  2,   0}, // #8161
  { 6,  1,   0}, // #8162
  { 7,  1,   0}, // #8163
  {10,  2,   0}, // #8164
  {11,  2,   0}, // #8165
  {19,  1,   0}, // #8166
  {20,  1,   0}, // #8167
  {28,  2,   0}, // #8168
  { 1,  1,   0}, // #8169
  { 2,  1,   0}, // #8170
  { 3,  2,   0}, // #8171
  { 4,  2,   0}, // #8172
  { 5,  2,   0}, // #8173
  { 6,  2,   0}, // #8174
  { 7,  2,   0}, // #8175
  { 8,  1,   0}, // #8176
  {10,  1,   0}, // #8177
  {11,  1,   0}, // #8178
  {14,  1,   0}, // #8179
  {15,  1,   0}, // #8180
  {19,  1,   0}, // #8181
  {20,  1,   0}, // #8182
  {28,  3,   0}, // #8183
  { 1,  1,   0}, // #8184
  { 2,  1,   0}, // #8185
  { 3,  2,   0}, // #8186
  { 4,  2,   0}, // #8187
  { 5,  2,   0}, // #8188
  { 6,  2,   0}, // #8189
  { 7,  2,   0}, // #8190
  { 8,  1,   0}, // #8191
  {10,  1,   0}, // #8192
  {11,  1,   0}, // #8193
  {19,  1,   0}, // #8194
  {20,  1,   0}, // #8195
  {28,  2,   0}, // #8196
  { 3,  2,   0}, // #8197
  { 4,  2,   0}, // #8198
  { 5,  2,   0}, // #8199
  { 6,  1,   0}, // #8200
  { 7,  1,   0}, // #8201
  {10,  2,   0}, // #8202
  {11,  2,   0}, // #8203
  {14,  1,   0}, // #8204
  {15,  1,   0}, // #8205
  {19,  1,   0}, // #8206
  {20,  1,   0}, // #8207
  {28,  3,   0}, // #8208
  { 1,  3,   0}, // #8209
  { 2,  4,   0}, // #8210
  { 3,  6,   0}, // #8211
  { 4,  7,   0}, // #8212
  { 5,  7,   0}, // #8213
  { 6,  4,   0}, // #8214
  { 7,  5,   0}, // #8215
  { 8,  4,   0}, // #8216
  { 9,  1,   0}, // #8217
  {10,  2,   0}, // #8218
  {11,  2,   0}, // #8219
  {14,  1,   0}, // #8220
  {15,  1,   0}, // #8221
  {19,  1,   0}, // #8222
  {20,  1,   0}, // #8223
  {28,  8,   0}, // #8224
  { 1,  3,   0}, // #8225
  { 2,  4,   0}, // #8226
  { 3,  7,   0}, // #8227
  { 4,  8,   0}, // #8228
  { 5,  8,   0}, // #8229
  { 6,  4,   0}, // #8230
  { 7,  5,   0}, // #8231
  { 8,  4,   0}, // #8232
  { 9,  1,   0}, // #8233
  {10,  2,   0}, // #8234
  {11,  2,   0}, // #8235
  {19,  1,   0}, // #8236
  {20,  1,   0}, // #8237
  {28,  8,   0}, // #8238
  { 1,  3,   0}, // #8239
  { 2,  4,   0}, // #8240
  { 3,  7,   0}, // #8241
  { 4,  8,   0}, // #8242
  { 5,  8,   0}, // #8243
  { 6,  4,   0}, // #8244
  { 7,  5,   0}, // #8245
  { 8,  4,   0}, // #8246
  { 9,  1,   0}, // #8247
  {10,  2,   0}, // #8248
  {11,  2,   0}, // #8249
  {14,  1,   0}, // #8250
  {15,  1,   0}, // #8251
  {19,  1,   0}, // #8252
  {20,  1,   0}, // #8253
  {28,  9,   0}, // #8254
  { 1,  3,   0}, // #8255
  { 2,  4,   0}, // #8256
  { 3,  8,   0}, // #8257
  { 4,  9,   0}, // #8258
  { 5,  9,   0}, // #8259
  { 6,  4,   0}, // #8260
  { 7,  5,   0}, // #8261
  { 8,  4,   0}, // #8262
  { 9,  1,   0}, // #8263
  {10,  2,   0}, // #8264
  {11,  2,   0}, // #8265
  {19,  1,   0}, // #8266
  {20,  1,   0}, // #8267
  {28,  9,   0}, // #8268
  { 1,  3,   0}, // #8269
  { 2,  3,   0}, // #8270
  { 3,  3,   0}, // #8271
  { 4,  3,   0}, // #8272
  { 5,  3,   0}, // #8273
  { 6,  3,   0}, // #8274
  { 7,  3,   0}, // #8275
  { 8,  3,   0}, // #8276
  {14,  1,   0}, // #8277
  {15,  1,   0}, // #8278
  {28,  4,   0}, // #8279
  { 3,  3,   0}, // #8280
  { 4,  3,   0}, // #8281
  { 5,  3,   0}, // #8282
  {10,  2,   0}, // #8283
  {11,  2,   0}, // #8284
  {14,  1,   0}, // #8285
  {15,  1,   0}, // #8286
  {28,  4,   0}, // #8287
  { 2,  2,   0}, // #8288
  { 3,  2,   0}, // #8289
  { 4,  5,   0}, // #8290
  { 5,  7,   0}, // #8291
  { 7,  3,   0}, // #8292
  { 8,  3,   0}, // #8293
  { 9,  2,   0}, // #8294
  {10,  2,   0}, // #8295
  {11,  2,   0}, // #8296
  {14,  2,   0}, // #8297
  {15,  1,   0}, // #8298
  {18,  1,   0}, // #8299
  {23,  1,   0}, // #8300
  {28, 10,   0}, // #8301
  { 4,  1,   0}, // #8302
  { 5,  1,   0}, // #8303
  { 7,  1,   0}, // #8304
  { 8,  1,   0}, // #8305
  {14,  2,   0}, // #8306
  {15,  1,   0}, // #8307
  {18,  1,   0}, // #8308
  {23,  1,   0}, // #8309
  {28,  4,   0}, // #8310
  { 4,  2,   0}, // #8311
  { 5,  2,   0}, // #8312
  { 7,  2,   0}, // #8313
  { 8,  2,   0}, // #8314
  {14,  2,   0}, // #8315
  {15,  1,   0}, // #8316
  {18,  1,   0}, // #8317
  {23,  1,   0}, // #8318
  {28,  5,   0}, // #8319
  { 4,  2,   0}, // #8320
  { 5,  2,   0}, // #8321
  { 7,  2,   0}, // #8322
  { 8,  2,   0}, // #8323
  {14,  1,   0}, // #8324
  {18,  1,   0}, // #8325
  {23,  1,   0}, // #8326
  {28,  4,   0}, // #8327
  { 2,  1,   0}, // #8328
  { 3,  1,   0}, // #8329
  { 4,  2,   0}, // #8330
  { 5,  3,   0}, // #8331
  { 7,  1,   0}, // #8332
  { 8,  1,   0}, // #8333
  { 9,  1,   0}, // #8334
  {10,  1,   0}, // #8335
  {11,  1,   0}, // #8336
  {14,  2,   0}, // #8337
  {15,  1,   0}, // #8338
  {18,  1,   0}, // #8339
  {23,  1,   0}, // #8340
  {28,  6,   0}, // #8341
  { 2,  1,   0}, // #8342
  { 3,  1,   0}, // #8343
  { 4,  1,   0}, // #8344
  { 5,  2,   0}, // #8345
  { 9,  1,   0}, // #8346
  {10,  1,   0}, // #8347
  {11,  1,   0}, // #8348
  {14,  2,   0}, // #8349
  {15,  1,   0}, // #8350
  {18,  1,   0}, // #8351
  {23,  1,   0}, // #8352
  {28,  5,   0}, // #8353
  { 1,  1,   0}, // #8354
  { 2,  1,   0}, // #8355
  { 3,  1,   0}, // #8356
  { 4,  2,   0}, // #8357
  { 5,  2,   0}, // #8358
  { 6,  1,   0}, // #8359
  { 7,  2,   0}, // #8360
  { 8,  2,   0}, // #8361
  {14,  1,   0}, // #8362
  {18,  1,   0}, // #8363
  {23,  1,   0}, // #8364
  {28,  4,   0}, // #8365
  { 3,  2,   0}, // #8366
  { 4,  2,   0}, // #8367
  { 5,  2,   0}, // #8368
  { 6,  2,   0}, // #8369
  { 7,  2,   0}, // #8370
  {10,  2,   0}, // #8371
  {11,  2,   0}, // #8372
  {19,  2,   0}, // #8373
  {20,  2,   0}, // #8374
  {28,  2,   0}, // #8375
  { 1,  1,   0}, // #8376
  { 2,  1,   0}, // #8377
  { 3,  4,   0}, // #8378
  { 4,  5,   0}, // #8379
  { 5,  5,   0}, // #8380
  { 6,  4,   0}, // #8381
  { 7,  5,   0}, // #8382
  { 8,  2,   0}, // #8383
  {10,  1,   0}, // #8384
  {11,  1,   0}, // #8385
  {14,  1,   0}, // #8386
  {15,  1,   0}, // #8387
  {19,  1,   0}, // #8388
  {20,  1,   0}, // #8389
  {28,  6,   0}, // #8390
  { 1,  1,   0}, // #8391
  { 2,  1,   0}, // #8392
  { 3,  4,   0}, // #8393
  { 4,  4,   0}, // #8394
  { 5,  4,   0}, // #8395
  { 6,  4,   0}, // #8396
  { 7,  4,   0}, // #8397
  { 8,  1,   0}, // #8398
  {10,  1,   0}, // #8399
  {11,  1,   0}, // #8400
  {19,  1,   0}, // #8401
  {20,  1,   0}, // #8402
  {28,  4,   0}, // #8403
  { 2,  1,   0}, // #8404
  { 3,  1,   0}, // #8405
  { 4,  1,   0}, // #8406
  { 5,  1,   0}, // #8407
  {14,  1,   0}, // #8408
  {18,  1,   0}, // #8409
  {23,  1,   0}, // #8410
  {28,  3,   0}, // #8411
  { 1,  1,   0}, // #8412
  { 2,  1,   0}, // #8413
  { 3,  1,   0}, // #8414
  { 4,  1,   0}, // #8415
  { 5,  1,   0}, // #8416
  { 6,  1,   0}, // #8417
  { 7,  1,   0}, // #8418
  { 8,  1,   0}, // #8419
  {14,  1,   0}, // #8420
  {18,  1,   0}, // #8421
  {23,  1,   0}, // #8422
  {28,  3,   0}, // #8423
  { 1,  2,   0}, // #8424
  { 2,  2,   0}, // #8425
  { 3,  3,   0}, // #8426
  { 4,  3,   0}, // #8427
  { 5,  3,   0}, // #8428
  { 6,  3,   0}, // #8429
  { 7,  3,   0}, // #8430
  { 8,  2,   0}, // #8431
  {14,  1,   0}, // #8432
  {15,  1,   0}, // #8433
  {28,  4,   0}, // #8434
  { 1,  2,   0}, // #8435
  { 2,  2,   0}, // #8436
  { 3,  3,   0}, // #8437
  { 4,  3,   0}, // #8438
  { 5,  3,   0}, // #8439
  { 6,  3,   0}, // #8440
  { 7,  3,   0}, // #8441
  { 8,  2,   0}, // #8442
  {28,  3,   0}, // #8443
  { 1,  2,   0}, // #8444
  { 2,  2,   0}, // #8445
  { 3,  2,   0}, // #8446
  { 4,  2,   0}, // #8447
  { 5,  2,   0}, // #8448
  { 6,  2,   0}, // #8449
  { 7,  2,   0}, // #8450
  { 8,  2,   0}, // #8451
  {14,  1,   0}, // #8452
  {15,  1,   0}, // #8453
  {28,  3,   0}, // #8454
  { 1,  2,   0}, // #8455
  { 2,  2,   0}, // #8456
  { 3,  2,   0}, // #8457
  { 4,  2,   0}, // #8458
  { 5,  2,   0}, // #8459
  { 6,  2,   0}, // #8460
  { 7,  2,   0}, // #8461
  { 8,  2,   0}, // #8462
  {28,  2,   0}, // #8463
  { 1,  2,   0}, // #8464
  { 2,  3,   0}, // #8465
  { 3,  7,   0}, // #8466
  { 4, 15,   0}, // #8467
  { 5, 15,   0}, // #8468
  { 6,  6,   0}, // #8469
  { 7, 10,   0}, // #8470
  { 8,  6,   0}, // #8471
  { 9,  1,   0}, // #8472
  {10,  3,   0}, // #8473
  {11,  3,   0}, // #8474
  {19,  2,   0}, // #8475
  {20,  2,   0}, // #8476
  {21,  4,   0}, // #8477
  {28, 15,   0}, // #8478
  { 2,  1,   0}, // #8479
  { 3,  3,   0}, // #8480
  { 4,  3,   0}, // #8481
  { 5,  3,   0}, // #8482
  { 6,  2,   0}, // #8483
  { 7,  2,   0}, // #8484
  {10,  2,   0}, // #8485
  {11,  2,   0}, // #8486
  {19,  2,   0}, // #8487
  {20,  2,   0}, // #8488
  {28,  3,   0}, // #8489
  { 1,  1,   0}, // #8490
  { 2,  2,   0}, // #8491
  { 3,  3,   0}, // #8492
  { 4,  3,   0}, // #8493
  { 5,  3,   0}, // #8494
  { 6,  2,   0}, // #8495
  { 7,  2,   0}, // #8496
  { 8,  1,   0}, // #8497
  {10,  1,   0}, // #8498
  {11,  1,   0}, // #8499
  {19,  1,   0}, // #8500
  {20,  1,   0}, // #8501
  {28,  3,   0}, // #8502
  { 5,  3,   0}, // #8503
  {14,  1,   0}, // #8504
  {15,  1,   0}, // #8505
  {28,  4,   0}, // #8506
  {17,  1,   0}, // #8507
  {18,  2,   0}, // #8508
  {28,  2,   0}, // #8509
  { 5,  4,   0}, // #8510
  {14,  2,   0}, // #8511
  {15,  1,   0}, // #8512
  {18,  1,   0}, // #8513
  {23,  1,   0}, // #8514
  {28,  7,   0}, // #8515
  { 4,  1,   0}, // #8516
  { 5,  6,   0}, // #8517
  { 7,  1,   0}, // #8518
  { 8,  1,   0}, // #8519
  {14,  2,   0}, // #8520
  {15,  1,   0}, // #8521
  {18,  1,   0}, // #8522
  {23,  1,   0}, // #8523
  {28,  9,   0}, // #8524
  { 1,  1,   0}, // #8525
  { 2,  1,   0}, // #8526
  { 3,  2,   0}, // #8527
  { 4,  2,   0}, // #8528
  { 5,  2,   0}, // #8529
  { 6,  2,   0}, // #8530
  { 7,  2,   0}, // #8531
  { 8,  1,   0}, // #8532
  {14,  1,   0}, // #8533
  {15,  1,   0}, // #8534
  {28,  3,   0}, // #8535
  { 3,  1,   0}, // #8536
  { 4,  1,   0}, // #8537
  { 5,  1,   0}, // #8538
  { 6,  1,   0}, // #8539
  { 7,  1,   0}, // #8540
  {10,  1,   0}, // #8541
  {11,  1,   0}, // #8542
  {17,  1,   0}, // #8543
  {18,  2,   0}, // #8544
  {19,  1,   0}, // #8545
  {20,  1,   0}, // #8546
  {28,  3,   0}, // #8547
  { 4,  1,   0}, // #8548
  { 5,  1,   0}, // #8549
  { 7,  1,   0}, // #8550
  { 8,  1,   0}, // #8551
  {17,  1,   0}, // #8552
  {18,  2,   0}, // #8553
  {21,  1,   0}, // #8554
  {28,  3,   0}, // #8555
  { 3,  1,   0}, // #8556
  { 4,  2,   0}, // #8557
  { 5,  2,   0}, // #8558
  { 6,  1,   0}, // #8559
  { 7,  2,   0}, // #8560
  { 8,  1,   0}, // #8561
  {10,  1,   0}, // #8562
  {11,  1,   0}, // #8563
  {19,  1,   0}, // #8564
  {20,  1,   0}, // #8565
  {28,  2,   0}, // #8566
  { 2,  2,   0}, // #8567
  { 3,  2,   0}, // #8568
  { 4,  9,   0}, // #8569
  { 5, 13,   0}, // #8570
  { 7,  7,   0}, // #8571
  { 8,  7,   0}, // #8572
  { 9,  2,   0}, // #8573
  {10,  2,   0}, // #8574
  {11,  2,   0}, // #8575
  {14,  2,   0}, // #8576
  {15,  1,   0}, // #8577
  {18,  1,   0}, // #8578
  {23,  1,   0}, // #8579
  {28, 16,   0}, // #8580
  { 1,  2,   0}, // #8581
  { 2,  2,   0}, // #8582
  { 3,  6,   0}, // #8583
  { 4, 12,   0}, // #8584
  { 5, 19,   0}, // #8585
  { 6,  4,   0}, // #8586
  { 7, 10,   0}, // #8587
  { 8,  8,   0}, // #8588
  {10,  4,   0}, // #8589
  {11,  4,   0}, // #8590
  {14,  2,   0}, // #8591
  {15,  1,   0}, // #8592
  {18,  1,   0}, // #8593
  {19,  2,   0}, // #8594
  {20,  2,   0}, // #8595
  {23,  1,   0}, // #8596
  {28, 22,   0}, // #8597
  { 1,  2,   0}, // #8598
  { 2,  8,   0}, // #8599
  { 3, 12,   0}, // #8600
  { 4, 21,   0}, // #8601
  { 5, 21,   0}, // #8602
  { 6,  5,   0}, // #8603
  { 7, 14,   0}, // #8604
  { 8,  9,   0}, // #8605
  { 9,  4,   0}, // #8606
  {10,  7,   0}, // #8607
  {11,  7,   0}, // #8608
  {19,  3,   0}, // #8609
  {20,  3,   0}, // #8610
  {28, 21,   0}, // #8611
  { 1,  2,   0}, // #8612
  { 2,  4,   0}, // #8613
  { 3, 13,   0}, // #8614
  { 4, 34,   0}, // #8615
  { 5, 34,   0}, // #8616
  { 6, 11,   0}, // #8617
  { 7, 32,   0}, // #8618
  { 8, 23,   0}, // #8619
  { 9,  2,   0}, // #8620
  {10, 11,   0}, // #8621
  {11, 11,   0}, // #8622
  {14, 19,   0}, // #8623
  {15, 14,   0}, // #8624
  {18,  4,   0}, // #8625
  {19,  9,   0}, // #8626
  {20,  9,   0}, // #8627
  {23,  5,   0}, // #8628
  {28, 57,   0}, // #8629
  { 2,  1,   0}, // #8630
  { 3,  1,   0}, // #8631
  { 4,  3,   0}, // #8632
  { 5,  9,   0}, // #8633
  { 7,  2,   0}, // #8634
  { 8,  2,   0}, // #8635
  { 9,  1,   0}, // #8636
  {10,  1,   0}, // #8637
  {11,  1,   0}, // #8638
  {14,  1,   0}, // #8639
  {15,  1,   0}, // #8640
  {28, 10,   0}, // #8641
  { 3,  1,   0}, // #8642
  { 4, 10,   0}, // #8643
  { 5, 10,   0}, // #8644
  { 6,  1,   0}, // #8645
  { 7,  3,   0}, // #8646
  { 8,  2,   0}, // #8647
  {10,  1,   0}, // #8648
  {11,  1,   0}, // #8649
  {19,  1,   0}, // #8650
  {20,  1,   0}, // #8651
  {21,  2,   0}, // #8652
  {28, 10,   0}, // #8653
  { 1,  7,   0}, // #8654
  { 2, 24,   0}, // #8655
  { 3, 44,   0}, // #8656
  { 4, 70,   0}, // #8657
  { 5, 75,   0}, // #8658
  { 6, 26,   0}, // #8659
  { 7, 52,   0}, // #8660
  { 8, 32,   0}, // #8661
  { 9, 17,   0}, // #8662
  {10, 36,   0}, // #8663
  {11, 37,   0}, // #8664
  {14, 10,   0}, // #8665
  {15,  9,   0}, // #8666
  {18,  1,   0}, // #8667
  {19, 19,   0}, // #8668
  {20, 19,   0}, // #8669
  {23,  1,   0}, // #8670
  {28, 86,   0}, // #8671
  { 3,  9,   0}, // #8672
  { 4, 15,   0}, // #8673
  { 5, 15,   0}, // #8674
  { 6,  9,   0}, // #8675
  { 7,  9,   0}, // #8676
  {10,  6,   0}, // #8677
  {11,  6,   0}, // #8678
  {19,  6,   0}, // #8679
  {20,  6,   0}, // #8680
  {28, 15,   0}, // #8681
  { 1,  5,   0}, // #8682
  { 2, 20,   0}, // #8683
  { 3, 35,   0}, // #8684
  { 4, 61,   0}, // #8685
  { 5, 66,   0}, // #8686
  { 6, 20,   0}, // #8687
  { 7, 46,   0}, // #8688
  { 8, 31,   0}, // #8689
  { 9, 15,   0}, // #8690
  {10, 30,   0}, // #8691
  {11, 30,   0}, // #8692
  {14,  6,   0}, // #8693
  {15,  5,   0}, // #8694
  {18,  1,   0}, // #8695
  {19, 15,   0}, // #8696
  {20, 15,   0}, // #8697
  {23,  1,   0}, // #8698
  {28, 73,   0}, // #8699
  { 1,  5,   0}, // #8700
  { 2, 20,   0}, // #8701
  { 3, 36,   0}, // #8702
  { 4, 61,   0}, // #8703
  { 5, 66,   0}, // #8704
  { 6, 21,   0}, // #8705
  { 7, 46,   0}, // #8706
  { 8, 30,   0}, // #8707
  { 9, 15,   0}, // #8708
  {10, 30,   0}, // #8709
  {11, 30,   0}, // #8710
  {14,  6,   0}, // #8711
  {15,  5,   0}, // #8712
  {18,  1,   0}, // #8713
  {19, 15,   0}, // #8714
  {20, 15,   0}, // #8715
  {23,  1,   0}, // #8716
  {28, 73,   0}, // #8717
  { 1,  6,   0}, // #8718
  { 2, 23,   0}, // #8719
  { 3, 41,   0}, // #8720
  { 4, 68,   0}, // #8721
  { 5, 73,   0}, // #8722
  { 6, 24,   0}, // #8723
  { 7, 51,   0}, // #8724
  { 8, 33,   0}, // #8725
  { 9, 16,   0}, // #8726
  {10, 34,   0}, // #8727
  {11, 34,   0}, // #8728
  {14,  9,   0}, // #8729
  {15,  8,   0}, // #8730
  {18,  1,   0}, // #8731
  {19, 18,   0}, // #8732
  {20, 18,   0}, // #8733
  {23,  1,   0}, // #8734
  {28, 83,   0}, // #8735
  { 2,  9,   0}, // #8736
  { 3, 23,   0}, // #8737
  { 4, 53,   0}, // #8738
  { 5, 54,   0}, // #8739
  { 6,  3,   0}, // #8740
  { 7, 33,   0}, // #8741
  { 8, 20,   0}, // #8742
  { 9,  8,   0}, // #8743
  {10, 15,   0}, // #8744
  {11, 16,   0}, // #8745
  {19,  2,   0}, // #8746
  {20,  2,   0}, // #8747
  {28, 54,   0}, // #8748
  { 1,  7,   0}, // #8749
  { 2, 26,   0}, // #8750
  { 3, 46,   0}, // #8751
  { 4, 71,   0}, // #8752
  { 5, 79,   0}, // #8753
  { 6, 27,   0}, // #8754
  { 7, 52,   0}, // #8755
  { 8, 32,   0}, // #8756
  { 9, 19,   0}, // #8757
  {10, 39,   0}, // #8758
  {11, 41,   0}, // #8759
  {14,  8,   0}, // #8760
  {15,  8,   0}, // #8761
  {19, 20,   0}, // #8762
  {20, 20,   0}, // #8763
  {28, 87,   0}, // #8764
  { 1,  7,   0}, // #8765
  { 2, 26,   0}, // #8766
  { 3, 46,   0}, // #8767
  { 4, 71,   0}, // #8768
  { 5, 79,   0}, // #8769
  { 6, 27,   0}, // #8770
  { 7, 52,   0}, // #8771
  { 8, 32,   0}, // #8772
  { 9, 19,   0}, // #8773
  {10, 39,   0}, // #8774
  {11, 41,   0}, // #8775
  {14,  7,   0}, // #8776
  {15,  7,   0}, // #8777
  {19, 20,   0}, // #8778
  {20, 20,   0}, // #8779
  {28, 86,   0}, // #8780
  { 1,  2,   0}, // #8781
  { 2,  9,   0}, // #8782
  { 3, 14,   0}, // #8783
  { 4, 24,   0}, // #8784
  { 5, 24,   0}, // #8785
  { 6,  7,   0}, // #8786
  { 7, 17,   0}, // #8787
  { 8, 12,   0}, // #8788
  { 9,  6,   0}, // #8789
  {10, 11,   0}, // #8790
  {11, 11,   0}, // #8791
  {14,  1,   0}, // #8792
  {18,  1,   0}, // #8793
  {19,  5,   0}, // #8794
  {20,  5,   0}, // #8795
  {23,  1,   0}, // #8796
  {28, 26,   0}, // #8797
  { 1,  2,   0}, // #8798
  { 2, 12,   0}, // #8799
  { 3, 17,   0}, // #8800
  { 4, 27,   0}, // #8801
  { 5, 32,   0}, // #8802
  { 6,  7,   0}, // #8803
  { 7, 17,   0}, // #8804
  { 8, 12,   0}, // #8805
  { 9, 10,   0}, // #8806
  {10, 15,   0}, // #8807
  {11, 15,   0}, // #8808
  {14, 40,   0}, // #8809
  {15,  2,   0}, // #8810
  {18, 38,   0}, // #8811
  {19,  5,   0}, // #8812
  {20,  5,   0}, // #8813
  {23, 38,   0}, // #8814
  {28, 110,   0}, // #8815
  { 1,  4,   0}, // #8816
  { 2,  4,   0}, // #8817
  { 3,  6,   0}, // #8818
  { 4, 10,   0}, // #8819
  { 5, 10,   0}, // #8820
  { 6,  5,   0}, // #8821
  { 7,  9,   0}, // #8822
  { 8,  8,   0}, // #8823
  {10,  1,   0}, // #8824
  {11,  1,   0}, // #8825
  {13, 47,   0}, // #8826
  {14, 80,   0}, // #8827
  {15, 80,   0}, // #8828
  {21,  2,   0}, // #8829
  {28, 90,   0}, // #8830
  { 1,  8,   0}, // #8831
  { 2, 35,   0}, // #8832
  { 3, 79,   0}, // #8833
  { 4, 142,   0}, // #8834
  { 5, 142,   0}, // #8835
  { 6, 37,   0}, // #8836
  { 7, 100,   0}, // #8837
  { 8, 71,   0}, // #8838
  { 9, 21,   0}, // #8839
  {10, 46,   0}, // #8840
  {11, 46,   0}, // #8841
  {14,  1,   0}, // #8842
  {18,  1,   0}, // #8843
  {19, 10,   0}, // #8844
  {20, 10,   0}, // #8845
  {23,  1,   0}, // #8846
  {28, 144,   0}, // #8847
  { 2,  1,   0}, // #8848
  { 3,  1,   0}, // #8849
  { 4,  1,   0}, // #8850
  { 5,  1,   0}, // #8851
  { 9,  1,   0}, // #8852
  {10,  1,   0}, // #8853
  {11,  1,   0}, // #8854
  {14,  1,   0}, // #8855
  {18,  1,   0}, // #8856
  {23,  1,   0}, // #8857
  {28,  3,   0}, // #8858
  { 3,  1,   0}, // #8859
  { 4,  1,   0}, // #8860
  { 5,  1,   0}, // #8861
  { 6,  1,   0}, // #8862
  { 7,  1,   0}, // #8863
  {10,  1,   0}, // #8864
  {11,  1,   0}, // #8865
  {14,  1,   0}, // #8866
  {18,  1,   0}, // #8867
  {19,  1,   0}, // #8868
  {20,  1,   0}, // #8869
  {23,  1,   0}, // #8870
  {28,  3,   0}, // #8871
  { 5,  2,   0}, // #8872
  {14,  1,   0}, // #8873
  {18,  1,   0}, // #8874
  {23,  1,   0}, // #8875
  {28,  4,   0}, // #8876
  { 2,  1,   0}, // #8877
  { 3,  1,   0}, // #8878
  { 4,  2,   0}, // #8879
  { 5,  2,   0}, // #8880
  { 7,  1,   0}, // #8881
  { 8,  1,   0}, // #8882
  { 9,  1,   0}, // #8883
  {10,  1,   0}, // #8884
  {11,  1,   0}, // #8885
  {14,  1,   0}, // #8886
  {18,  1,   0}, // #8887
  {23,  1,   0}, // #8888
  {28,  4,   0}, // #8889
  { 1,  5,   0}, // #8890
  { 2, 13,   0}, // #8891
  { 3, 13,   0}, // #8892
  { 4, 13,   0}, // #8893
  { 5, 13,   0}, // #8894
  { 6,  5,   0}, // #8895
  { 7,  5,   0}, // #8896
  { 8,  5,   0}, // #8897
  { 9,  8,   0}, // #8898
  {10,  8,   0}, // #8899
  {11,  8,   0}, // #8900
  {14, 21,   0}, // #8901
  {15, 21,   0}, // #8902
  {28, 34,   0}, // #8903
  { 4,  1,   0}, // #8904
  { 5,  1,   0}, // #8905
  { 7,  1,   0}, // #8906
  { 8,  1,   0}, // #8907
  {14,  1,   0}, // #8908
  {15,  1,   0}, // #8909
  {21,  1,   0}, // #8910
  {28,  2,   0}, // #8911
  { 1,  1,   0}, // #8912
  { 2,  1,   0}, // #8913
  { 3,  1,   0}, // #8914
  { 4,  1,   0}, // #8915
  { 5,  1,   0}, // #8916
  { 6,  1,   0}, // #8917
  { 7,  1,   0}, // #8918
  { 8,  1,   0}, // #8919
  {17,  1,   0}, // #8920
  {18,  2,   0}, // #8921
  {28,  3,   0}, // #8922
  { 5,  5,   0}, // #8923
  {14,  2,   0}, // #8924
  {15,  2,   0}, // #8925
  {28,  7,   0}, // #8926
  { 5,  2,   0}, // #8927
  {14,  2,   0}, // #8928
  {15,  1,   0}, // #8929
  {18,  1,   0}, // #8930
  {23,  1,   0}, // #8931
  {28,  5,   0}, // #8932
  { 4,  1,   0}, // #8933
  { 5,  1,   0}, // #8934
  { 7,  1,   0}, // #8935
  { 8,  1,   0}, // #8936
  {13,  1,   0}, // #8937
  {14,  2,   0}, // #8938
  {15,  2,   0}, // #8939
  {17,  1,   0}, // #8940
  {18,  2,   0}, // #8941
  {21,  1,   0}, // #8942
  {28,  5,   0}, // #8943
  { 4,  1,   0}, // #8944
  { 5,  3,   0}, // #8945
  { 7,  1,   0}, // #8946
  { 8,  1,   0}, // #8947
  {14,  2,   0}, // #8948
  {15,  1,   0}, // #8949
  {18,  1,   0}, // #8950
  {23,  1,   0}, // #8951
  {28,  6,   0}, // #8952
  { 3,  2,   0}, // #8953
  { 4,  2,   0}, // #8954
  { 5,  2,   0}, // #8955
  { 6,  2,   0}, // #8956
  { 7,  2,   0}, // #8957
  {10,  2,   0}, // #8958
  {11,  2,   0}, // #8959
  {14,  1,   0}, // #8960
  {15,  1,   0}, // #8961
  {19,  2,   0}, // #8962
  {20,  2,   0}, // #8963
  {28,  3,   0}, // #8964
  { 4,  2,   0}, // #8965
  { 5,  2,   0}, // #8966
  { 7,  2,   0}, // #8967
  { 8,  2,   0}, // #8968
  {14,  1,   0}, // #8969
  {15,  1,   0}, // #8970
  {28,  3,   0}, // #8971
  { 2,  2,   0}, // #8972
  { 3,  3,   0}, // #8973
  { 4,  9,   0}, // #8974
  { 5, 18,   0}, // #8975
  { 6,  1,   0}, // #8976
  { 7,  7,   0}, // #8977
  { 8,  6,   0}, // #8978
  { 9,  2,   0}, // #8979
  {10,  3,   0}, // #8980
  {11,  3,   0}, // #8981
  {19,  1,   0}, // #8982
  {20,  1,   0}, // #8983
  {28, 18,   0}, // #8984
  { 1,  2,   0}, // #8985
  { 2,  9,   0}, // #8986
  { 3, 14,   0}, // #8987
  { 4, 21,   0}, // #8988
  { 5, 24,   0}, // #8989
  { 6,  4,   0}, // #8990
  { 7, 11,   0}, // #8991
  { 8,  7,   0}, // #8992
  { 9,  7,   0}, // #8993
  {10, 12,   0}, // #8994
  {11, 12,   0}, // #8995
  {14,  1,   0}, // #8996
  {15,  1,   0}, // #8997
  {19,  2,   0}, // #8998
  {20,  2,   0}, // #8999
  {28, 25,   0}, // #9000
  { 2,  2,   0}, // #9001
  { 3,  2,   0}, // #9002
  { 4,  2,   0}, // #9003
  { 5,  3,   0}, // #9004
  { 9,  2,   0}, // #9005
  {10,  2,   0}, // #9006
  {11,  2,   0}, // #9007
  {14,  2,   0}, // #9008
  {18,  2,   0}, // #9009
  {23,  2,   0}, // #9010
  {28,  7,   0}, // #9011
  { 4,  1,   0}, // #9012
  { 5,  1,   0}, // #9013
  { 7,  1,   0}, // #9014
  { 8,  1,   0}, // #9015
  {14,  1,   0}, // #9016
  {18,  1,   0}, // #9017
  {23,  1,   0}, // #9018
  {28,  3,   0}, // #9019
  { 1,  1,   0}, // #9020
  { 2,  6,   0}, // #9021
  { 3,  8,   0}, // #9022
  { 4, 17,   0}, // #9023
  { 5, 20,   0}, // #9024
  { 6,  2,   0}, // #9025
  { 7, 11,   0}, // #9026
  { 8,  9,   0}, // #9027
  { 9,  5,   0}, // #9028
  {10,  7,   0}, // #9029
  {11,  7,   0}, // #9030
  {14,  2,   0}, // #9031
  {15,  2,   0}, // #9032
  {19,  1,   0}, // #9033
  {20,  1,   0}, // #9034
  {28, 22,   0}, // #9035
  { 1,  1,   0}, // #9036
  { 2,  4,   0}, // #9037
  { 3,  5,   0}, // #9038
  { 4, 10,   0}, // #9039
  { 5, 10,   0}, // #9040
  { 6,  2,   0}, // #9041
  { 7,  7,   0}, // #9042
  { 8,  6,   0}, // #9043
  { 9,  3,   0}, // #9044
  {10,  4,   0}, // #9045
  {11,  4,   0}, // #9046
  {14,  3,   0}, // #9047
  {15,  3,   0}, // #9048
  {19,  1,   0}, // #9049
  {20,  1,   0}, // #9050
  {28, 13,   0}, // #9051
  { 2,  8,   0}, // #9052
  { 3, 14,   0}, // #9053
  { 4, 30,   0}, // #9054
  { 5, 54,   0}, // #9055
  { 6,  2,   0}, // #9056
  { 7, 18,   0}, // #9057
  { 8, 14,   0}, // #9058
  { 9,  8,   0}, // #9059
  {10, 10,   0}, // #9060
  {11, 11,   0}, // #9061
  {19,  2,   0}, // #9062
  {20,  2,   0}, // #9063
  {28, 54,   0}, // #9064
  { 2,  3,   0}, // #9065
  { 3,  4,   0}, // #9066
  { 4, 10,   0}, // #9067
  { 5, 15,   0}, // #9068
  { 6,  1,   0}, // #9069
  { 7,  7,   0}, // #9070
  { 8,  6,   0}, // #9071
  { 9,  3,   0}, // #9072
  {10,  4,   0}, // #9073
  {11,  4,   0}, // #9074
  {19,  1,   0}, // #9075
  {20,  1,   0}, // #9076
  {28, 15,   0}, // #9077
  { 2,  1,   0}, // #9078
  { 3,  1,   0}, // #9079
  { 4,  9,   0}, // #9080
  { 5,  9,   0}, // #9081
  { 7,  8,   0}, // #9082
  { 8,  8,   0}, // #9083
  { 9,  1,   0}, // #9084
  {10,  1,   0}, // #9085
  {11,  1,   0}, // #9086
  {13, 21,   0}, // #9087
  {14, 22,   0}, // #9088
  {15, 22,   0}, // #9089
  {21,  8,   0}, // #9090
  {28, 31,   0}, // #9091
  { 2, 35,   0}, // #9092
  { 3, 90,   0}, // #9093
  { 4, 134,   0}, // #9094
  { 5, 134,   0}, // #9095
  { 6, 34,   0}, // #9096
  { 7, 78,   0}, // #9097
  { 8, 44,   0}, // #9098
  { 9, 21,   0}, // #9099
  {10, 51,   0}, // #9100
  {11, 51,   0}, // #9101
  {14,  5,   0}, // #9102
  {15,  4,   0}, // #9103
  {18,  1,   0}, // #9104
  {19,  9,   0}, // #9105
  {20,  9,   0}, // #9106
  {23,  1,   0}, // #9107
  {28, 140,   0}, // #9108
  { 2, 52,   0}, // #9109
  { 3, 97,   0}, // #9110
  { 4, 150,   0}, // #9111
  { 5, 150,   0}, // #9112
  { 6, 45,   0}, // #9113
  { 7, 98,   0}, // #9114
  { 8, 53,   0}, // #9115
  { 9, 27,   0}, // #9116
  {10, 37,   0}, // #9117
  {11, 37,   0}, // #9118
  {14,  5,   0}, // #9119
  {15,  4,   0}, // #9120
  {18,  1,   0}, // #9121
  {19, 10,   0}, // #9122
  {20, 10,   0}, // #9123
  {23,  1,   0}, // #9124
  {28, 156,   0}, // #9125
  { 2,  1,   0}, // #9126
  { 3,  4,   0}, // #9127
  { 4,  7,   0}, // #9128
  { 5,  7,   0}, // #9129
  { 6,  2,   0}, // #9130
  { 7,  5,   0}, // #9131
  { 8,  3,   0}, // #9132
  { 9,  1,   0}, // #9133
  {10,  4,   0}, // #9134
  {11,  4,   0}, // #9135
  {13,  1,   0}, // #9136
  {14,  9,   0}, // #9137
  {15,  9,   0}, // #9138
  {17,  1,   0}, // #9139
  {18,  2,   0}, // #9140
  {19,  2,   0}, // #9141
  {20,  2,   0}, // #9142
  {21,  3,   0}, // #9143
  {28, 18,   0}, // #9144
  { 1,  2,   0}, // #9145
  { 2,  2,   0}, // #9146
  { 3,  7,   0}, // #9147
  { 4, 17,   0}, // #9148
  { 5, 17,   0}, // #9149
  { 6,  7,   0}, // #9150
  { 7, 17,   0}, // #9151
  { 8, 12,   0}, // #9152
  {13, 39,   0}, // #9153
  {14, 47,   0}, // #9154
  {15, 47,   0}, // #9155
  {28, 64,   0}, // #9156
  { 1,  4,   0}, // #9157
  { 2,  4,   0}, // #9158
  { 3,  6,   0}, // #9159
  { 4, 12,   0}, // #9160
  { 5, 12,   0}, // #9161
  { 6,  5,   0}, // #9162
  { 7, 11,   0}, // #9163
  { 8, 10,   0}, // #9164
  {10,  1,   0}, // #9165
  {11,  1,   0}, // #9166
  {13, 45,   0}, // #9167
  {14, 76,   0}, // #9168
  {15, 76,   0}, // #9169
  {21,  4,   0}, // #9170
  {28, 88,   0}, // #9171
  { 1,  9,   0}, // #9172
  { 2, 10,   0}, // #9173
  { 3, 26,   0}, // #9174
  { 4, 59,   0}, // #9175
  { 5, 59,   0}, // #9176
  { 6, 25,   0}, // #9177
  { 7, 47,   0}, // #9178
  { 8, 31,   0}, // #9179
  { 9,  1,   0}, // #9180
  {10, 17,   0}, // #9181
  {11, 17,   0}, // #9182
  {17, 30,   0}, // #9183
  {18, 41,   0}, // #9184
  {19, 16,   0}, // #9185
  {20, 16,   0}, // #9186
  {21,  1,   0}, // #9187
  {28, 100,   0}, // #9188
  { 1,  1,   0}, // #9189
  { 2,  1,   0}, // #9190
  { 3,  3,   0}, // #9191
  { 4,  3,   0}, // #9192
  { 5,  3,   0}, // #9193
  { 6,  1,   0}, // #9194
  { 7,  1,   0}, // #9195
  { 8,  1,   0}, // #9196
  {10,  1,   0}, // #9197
  {11,  1,   0}, // #9198
  {14,  2,   0}, // #9199
  {15,  2,   0}, // #9200
  {28,  5,   0}, // #9201
  { 1,  1,   0}, // #9202
  { 2,  1,   0}, // #9203
  { 3,  4,   0}, // #9204
  { 4,  4,   0}, // #9205
  { 5,  4,   0}, // #9206
  { 6,  1,   0}, // #9207
  { 7,  1,   0}, // #9208
  { 8,  1,   0}, // #9209
  {10,  2,   0}, // #9210
  {11,  2,   0}, // #9211
  {14,  4,   0}, // #9212
  {15,  4,   0}, // #9213
  {28,  8,   0}, // #9214
  { 1,  1,   0}, // #9215
  { 2,  1,   0}, // #9216
  { 3,  4,   0}, // #9217
  { 4,  4,   0}, // #9218
  { 5,  4,   0}, // #9219
  { 6,  1,   0}, // #9220
  { 7,  1,   0}, // #9221
  { 8,  1,   0}, // #9222
  {10,  2,   0}, // #9223
  {11,  2,   0}, // #9224
  {14,  8,   0}, // #9225
  {15,  8,   0}, // #9226
  {28, 12,   0}, // #9227
  { 4,  1,   0}, // #9228
  { 5,  1,   0}, // #9229
  { 7,  1,   0}, // #9230
  { 8,  1,   0}, // #9231
  {13,  1,   0}, // #9232
  {14,  2,   0}, // #9233
  {15,  2,   0}, // #9234
  {21,  1,   0}, // #9235
  {28,  3,   0}, // #9236
  { 2,  1,   0}, // #9237
  { 3,  1,   0}, // #9238
  { 4,  3,   0}, // #9239
  { 5,  3,   0}, // #9240
  { 7,  2,   0}, // #9241
  { 8,  2,   0}, // #9242
  { 9,  1,   0}, // #9243
  {10,  1,   0}, // #9244
  {11,  1,   0}, // #9245
  {14,  1,   0}, // #9246
  {15,  1,   0}, // #9247
  {28,  4,   0}, // #9248
  { 1,  2,   0}, // #9249
  { 2,  2,   0}, // #9250
  { 3,  2,   0}, // #9251
  { 4,  2,   0}, // #9252
  { 5,  2,   0}, // #9253
  { 6,  2,   0}, // #9254
  { 7,  2,   0}, // #9255
  { 8,  2,   0}, // #9256
  {14,  1,   0}, // #9257
  {18,  1,   0}, // #9258
  {23,  1,   0}, // #9259
  {28,  4,   0}, // #9260
  { 2,  3,   0}, // #9261
  { 3,  6,   0}, // #9262
  { 4,  7,   0}, // #9263
  { 5,  7,   0}, // #9264
  { 6,  1,   0}, // #9265
  { 7,  2,   0}, // #9266
  { 8,  1,   0}, // #9267
  {10,  1,   0}, // #9268
  {11,  1,   0}, // #9269
  {19,  1,   0}, // #9270
  {20,  1,   0}, // #9271
  {28,  7,   0}, // #9272
  { 2,  3,   0}, // #9273
  { 3,  6,   0}, // #9274
  { 4,  7,   0}, // #9275
  { 5,  7,   0}, // #9276
  { 6,  1,   0}, // #9277
  { 7,  2,   0}, // #9278
  { 8,  1,   0}, // #9279
  {10,  1,   0}, // #9280
  {11,  1,   0}, // #9281
  {14,  1,   0}, // #9282
  {15,  1,   0}, // #9283
  {19,  1,   0}, // #9284
  {20,  1,   0}, // #9285
  {28,  8,   0}, // #9286
  { 2,  2,   0}, // #9287
  { 3,  6,   0}, // #9288
  { 4,  7,   0}, // #9289
  { 5,  7,   0}, // #9290
  { 7,  1,   0}, // #9291
  { 8,  1,   0}, // #9292
  {10,  2,   0}, // #9293
  {11,  2,   0}, // #9294
  {14,  1,   0}, // #9295
  {15,  1,   0}, // #9296
  {28,  8,   0}, // #9297
  { 2,  1,   0}, // #9298
  { 3,  3,   0}, // #9299
  { 4,  3,   0}, // #9300
  { 5,  3,   0}, // #9301
  {10,  1,   0}, // #9302
  {11,  1,   0}, // #9303
  {14,  1,   0}, // #9304
  {15,  1,   0}, // #9305
  {28,  4,   0}, // #9306
  { 4,  1,   0}, // #9307
  { 5,  2,   0}, // #9308
  { 7,  1,   0}, // #9309
  { 8,  1,   0}, // #9310
  {14,  1,   0}, // #9311
  {15,  1,   0}, // #9312
  {28,  3,   0}, // #9313
  { 4,  1,   0}, // #9314
  { 5,  5,   0}, // #9315
  { 7,  1,   0}, // #9316
  { 8,  1,   0}, // #9317
  {14,  2,   0}, // #9318
  {15,  1,   0}, // #9319
  {18,  1,   0}, // #9320
  {23,  1,   0}, // #9321
  {28,  8,   0}, // #9322
  { 2,  2,   0}, // #9323
  { 3,  4,   0}, // #9324
  { 4,  4,   0}, // #9325
  { 5,  4,   0}, // #9326
  { 6,  2,   0}, // #9327
  { 7,  2,   0}, // #9328
  {10,  2,   0}, // #9329
  {11,  2,   0}, // #9330
  {19,  2,   0}, // #9331
  {20,  2,   0}, // #9332
  {28,  4,   0}, // #9333
  { 1,  2,   0}, // #9334
  { 2,  2,   0}, // #9335
  { 3,  4,   0}, // #9336
  { 4,  4,   0}, // #9337
  { 5,  4,   0}, // #9338
  { 6,  4,   0}, // #9339
  { 7,  4,   0}, // #9340
  { 8,  2,   0}, // #9341
  {10,  2,   0}, // #9342
  {11,  2,   0}, // #9343
  {19,  2,   0}, // #9344
  {20,  2,   0}, // #9345
  {28,  4,   0}, // #9346
  { 2,  1,   0}, // #9347
  { 3,  2,   0}, // #9348
  { 4,  2,   0}, // #9349
  { 5,  2,   0}, // #9350
  {28,  2,   0}, // #9351
  { 1,  1,   0}, // #9352
  { 2,  1,   0}, // #9353
  { 3,  2,   0}, // #9354
  { 4,  2,   0}, // #9355
  { 5,  2,   0}, // #9356
  { 6,  2,   0}, // #9357
  { 7,  2,   0}, // #9358
  { 8,  1,   0}, // #9359
  {28,  2,   0}, // #9360
  { 2,  5,   0}, // #9361
  { 3, 15,   0}, // #9362
  { 4, 15,   0}, // #9363
  { 5, 15,   0}, // #9364
  { 6,  5,   0}, // #9365
  { 7,  5,   0}, // #9366
  {10,  5,   0}, // #9367
  {11,  5,   0}, // #9368
  {19,  5,   0}, // #9369
  {20,  5,   0}, // #9370
  {28, 15,   0}, // #9371
  { 2,  7,   0}, // #9372
  { 3, 22,   0}, // #9373
  { 4, 23,   0}, // #9374
  { 5, 23,   0}, // #9375
  { 6,  9,   0}, // #9376
  { 7, 10,   0}, // #9377
  { 8,  1,   0}, // #9378
  {10,  9,   0}, // #9379
  {11,  9,   0}, // #9380
  {19,  9,   0}, // #9381
  {20,  9,   0}, // #9382
  {28, 23,   0}, // #9383
  { 1, 11,   0}, // #9384
  { 2, 11,   0}, // #9385
  { 3, 37,   0}, // #9386
  { 4, 37,   0}, // #9387
  { 5, 37,   0}, // #9388
  { 6, 37,   0}, // #9389
  { 7, 37,   0}, // #9390
  { 8, 11,   0}, // #9391
  {10, 17,   0}, // #9392
  {11, 17,   0}, // #9393
  {19, 17,   0}, // #9394
  {20, 17,   0}, // #9395
  {28, 37,   0}, // #9396
  { 1,  1,   0}, // #9397
  { 2,  4,   0}, // #9398
  { 3,  5,   0}, // #9399
  { 4,  9,   0}, // #9400
  { 5, 13,   0}, // #9401
  { 6,  2,   0}, // #9402
  { 7,  6,   0}, // #9403
  { 8,  5,   0}, // #9404
  { 9,  3,   0}, // #9405
  {10,  4,   0}, // #9406
  {11,  4,   0}, // #9407
  {14,  2,   0}, // #9408
  {15,  2,   0}, // #9409
  {19,  1,   0}, // #9410
  {20,  1,   0}, // #9411
  {28, 15,   0}, // #9412
  { 1,  1,   0}, // #9413
  { 2,  1,   0}, // #9414
  { 3,  3,   0}, // #9415
  { 4,  3,   0}, // #9416
  { 5,  3,   0}, // #9417
  { 6,  3,   0}, // #9418
  { 7,  3,   0}, // #9419
  { 8,  1,   0}, // #9420
  {10,  2,   0}, // #9421
  {11,  2,   0}, // #9422
  {19,  2,   0}, // #9423
  {20,  2,   0}, // #9424
  {28,  3,   0}, // #9425
  { 1,  1,   0}, // #9426
  { 2,  1,   0}, // #9427
  { 3,  3,   0}, // #9428
  { 4,  3,   0}, // #9429
  { 5,  3,   0}, // #9430
  { 6,  3,   0}, // #9431
  { 7,  3,   0}, // #9432
  { 8,  1,   0}, // #9433
  {10,  2,   0}, // #9434
  {11,  2,   0}, // #9435
  {14,  1,   0}, // #9436
  {15,  1,   0}, // #9437
  {19,  2,   0}, // #9438
  {20,  2,   0}, // #9439
  {28,  4,   0}, // #9440
  { 2,  1,   0}, // #9441
  { 3,  3,   0}, // #9442
  { 4,  3,   0}, // #9443
  { 5,  3,   0}, // #9444
  {10,  2,   0}, // #9445
  {11,  2,   0}, // #9446
  {14,  1,   0}, // #9447
  {15,  1,   0}, // #9448
  {28,  4,   0}, // #9449
  { 2, 52,   0}, // #9450
  { 3, 125,   0}, // #9451
  { 4, 178,   0}, // #9452
  { 5, 178,   0}, // #9453
  { 6, 41,   0}, // #9454
  { 7, 94,   0}, // #9455
  { 8, 53,   0}, // #9456
  { 9, 29,   0}, // #9457
  {10, 69,   0}, // #9458
  {11, 69,   0}, // #9459
  {14,  6,   0}, // #9460
  {15,  4,   0}, // #9461
  {18,  2,   0}, // #9462
  {19,  8,   0}, // #9463
  {20,  8,   0}, // #9464
  {23,  2,   0}, // #9465
  {28, 186,   0}, // #9466
  { 3,  2,   0}, // #9467
  { 4,  2,   0}, // #9468
  { 5,  2,   0}, // #9469
  { 6,  1,   0}, // #9470
  { 7,  1,   0}, // #9471
  {10,  2,   0}, // #9472
  {11,  2,   0}, // #9473
  {14,  1,   0}, // #9474
  {18,  1,   0}, // #9475
  {19,  1,   0}, // #9476
  {20,  1,   0}, // #9477
  {23,  1,   0}, // #9478
  {28,  4,   0}, // #9479
  { 3,  2,   0}, // #9480
  { 4,  2,   0}, // #9481
  { 5,  2,   0}, // #9482
  { 6,  2,   0}, // #9483
  { 7,  2,   0}, // #9484
  {10,  2,   0}, // #9485
  {11,  2,   0}, // #9486
  {14,  1,   0}, // #9487
  {18,  1,   0}, // #9488
  {19,  2,   0}, // #9489
  {20,  2,   0}, // #9490
  {23,  1,   0}, // #9491
  {28,  4,   0}, // #9492
  { 1,  1,   0}, // #9493
  { 2,  2,   0}, // #9494
  { 3,  2,   0}, // #9495
  { 4,  2,   0}, // #9496
  { 5,  3,   0}, // #9497
  { 6,  1,   0}, // #9498
  { 7,  1,   0}, // #9499
  { 8,  1,   0}, // #9500
  {14,  2,   0}, // #9501
  {18,  2,   0}, // #9502
  {23,  2,   0}, // #9503
  {28,  7,   0}, // #9504
  { 1,  1,   0}, // #9505
  { 2,  2,   0}, // #9506
  { 3,  2,   0}, // #9507
  { 4,  2,   0}, // #9508
  { 5,  3,   0}, // #9509
  { 6,  1,   0}, // #9510
  { 7,  1,   0}, // #9511
  { 8,  1,   0}, // #9512
  {14,  4,   0}, // #9513
  {18,  4,   0}, // #9514
  {23,  4,   0}, // #9515
  {28, 11,   0}, // #9516
  { 1,  2,   0}, // #9517
  { 2,  2,   0}, // #9518
  { 3,  2,   0}, // #9519
  { 4,  2,   0}, // #9520
  { 5,  3,   0}, // #9521
  { 6,  2,   0}, // #9522
  { 7,  2,   0}, // #9523
  { 8,  2,   0}, // #9524
  {14,  8,   0}, // #9525
  {18,  8,   0}, // #9526
  {23,  8,   0}, // #9527
  {28, 19,   0}, // #9528
  { 1,  2,   0}, // #9529
  { 2,  2,   0}, // #9530
  { 3,  2,   0}, // #9531
  { 4,  2,   0}, // #9532
  { 5,  3,   0}, // #9533
  { 6,  2,   0}, // #9534
  { 7,  2,   0}, // #9535
  { 8,  2,   0}, // #9536
  {14, 16,   0}, // #9537
  {18, 16,   0}, // #9538
  {23, 16,   0}, // #9539
  {28, 35,   0}, // #9540
  { 1,  1,   0}, // #9541
  { 2,  2,   0}, // #9542
  { 3,  2,   0}, // #9543
  { 4,  2,   0}, // #9544
  { 5,  3,   0}, // #9545
  { 6,  1,   0}, // #9546
  { 7,  1,   0}, // #9547
  { 8,  1,   0}, // #9548
  {14,  8,   0}, // #9549
  {18,  8,   0}, // #9550
  {23,  8,   0}, // #9551
  {28, 19,   0}, // #9552
  { 3,  3,   0}, // #9553
  { 4,  3,   0}, // #9554
  { 5,  3,   0}, // #9555
  { 6,  2,   0}, // #9556
  { 7,  2,   0}, // #9557
  {10,  2,   0}, // #9558
  {11,  2,   0}, // #9559
  {14,  1,   0}, // #9560
  {15,  1,   0}, // #9561
  {19,  2,   0}, // #9562
  {20,  2,   0}, // #9563
  {28,  4,   0}, // #9564
  { 2,  3,   0}, // #9565
  { 3,  3,   0}, // #9566
  { 4,  3,   0}, // #9567
  { 5,  3,   0}, // #9568
  {28,  3,   0}, // #9569
  { 2,  5,   0}, // #9570
  { 3, 14,   0}, // #9571
  { 4, 14,   0}, // #9572
  { 5, 14,   0}, // #9573
  { 6,  5,   0}, // #9574
  { 7,  5,   0}, // #9575
  {10,  5,   0}, // #9576
  {11,  5,   0}, // #9577
  {14,  1,   0}, // #9578
  {15,  1,   0}, // #9579
  {19,  5,   0}, // #9580
  {20,  5,   0}, // #9581
  {28, 15,   0}, // #9582
  { 2,  3,   0}, // #9583
  { 3,  3,   0}, // #9584
  { 4,  3,   0}, // #9585
  { 5,  3,   0}, // #9586
  {14,  1,   0}, // #9587
  {15,  1,   0}, // #9588
  {28,  4,   0}, // #9589
  { 1,  1,   0}, // #9590
  { 2,  1,   0}, // #9591
  { 3,  2,   0}, // #9592
  { 4,  2,   0}, // #9593
  { 5,  2,   0}, // #9594
  { 6,  1,   0}, // #9595
  { 7,  1,   0}, // #9596
  { 8,  1,   0}, // #9597
  {10,  1,   0}, // #9598
  {11,  1,   0}, // #9599
  {14,  2,   0}, // #9600
  {15,  2,   0}, // #9601
  {28,  4,   0}, // #9602
  { 1,  1,   0}, // #9603
  { 2,  1,   0}, // #9604
  { 3,  3,   0}, // #9605
  { 4,  3,   0}, // #9606
  { 5,  3,   0}, // #9607
  { 6,  1,   0}, // #9608
  { 7,  1,   0}, // #9609
  { 8,  1,   0}, // #9610
  {10,  2,   0}, // #9611
  {11,  2,   0}, // #9612
  {14,  4,   0}, // #9613
  {15,  4,   0}, // #9614
  {28,  7,   0}, // #9615
  { 1,  1,   0}, // #9616
  { 2,  1,   0}, // #9617
  { 3,  3,   0}, // #9618
  { 4,  3,   0}, // #9619
  { 5,  3,   0}, // #9620
  { 6,  1,   0}, // #9621
  { 7,  1,   0}, // #9622
  { 8,  1,   0}, // #9623
  {10,  2,   0}, // #9624
  {11,  2,   0}, // #9625
  {14,  8,   0}, // #9626
  {15,  8,   0}, // #9627
  {28, 11,   0}, // #9628
  { 1,  1,   0}, // #9629
  { 2,  1,   0}, // #9630
  { 3,  3,   0}, // #9631
  { 4,  3,   0}, // #9632
  { 5,  3,   0}, // #9633
  { 6,  3,   0}, // #9634
  { 7,  3,   0}, // #9635
  { 8,  1,   0}, // #9636
  {10,  2,   0}, // #9637
  {11,  2,   0}, // #9638
  {14, 16,   0}, // #9639
  {15, 16,   0}, // #9640
  {19,  2,   0}, // #9641
  {20,  2,   0}, // #9642
  {28, 19,   0}, // #9643
  { 1,  7,   0}, // #9644
  { 2,  7,   0}, // #9645
  { 3, 22,   0}, // #9646
  { 4, 22,   0}, // #9647
  { 5, 22,   0}, // #9648
  { 6, 22,   0}, // #9649
  { 7, 22,   0}, // #9650
  { 8,  7,   0}, // #9651
  {10,  9,   0}, // #9652
  {11,  9,   0}, // #9653
  {19,  9,   0}, // #9654
  {20,  9,   0}, // #9655
  {28, 22,   0}, // #9656
  { 2,  7,   0}, // #9657
  { 3, 21,   0}, // #9658
  { 4, 22,   0}, // #9659
  { 5, 22,   0}, // #9660
  { 6,  9,   0}, // #9661
  { 7, 10,   0}, // #9662
  { 8,  1,   0}, // #9663
  {10,  9,   0}, // #9664
  {11,  9,   0}, // #9665
  {14,  1,   0}, // #9666
  {15,  1,   0}, // #9667
  {19,  9,   0}, // #9668
  {20,  9,   0}, // #9669
  {28, 23,   0}, // #9670
  { 1,  7,   0}, // #9671
  { 2,  7,   0}, // #9672
  { 3, 21,   0}, // #9673
  { 4, 21,   0}, // #9674
  { 5, 21,   0}, // #9675
  { 6, 21,   0}, // #9676
  { 7, 21,   0}, // #9677
  { 8,  7,   0}, // #9678
  {10,  9,   0}, // #9679
  {11,  9,   0}, // #9680
  {14,  1,   0}, // #9681
  {15,  1,   0}, // #9682
  {19,  9,   0}, // #9683
  {20,  9,   0}, // #9684
  {28, 22,   0}, // #9685
  { 1, 11,   0}, // #9686
  { 2, 11,   0}, // #9687
  { 3, 36,   0}, // #9688
  { 4, 36,   0}, // #9689
  { 5, 36,   0}, // #9690
  { 6, 36,   0}, // #9691
  { 7, 36,   0}, // #9692
  { 8, 11,   0}, // #9693
  {10, 17,   0}, // #9694
  {11, 17,   0}, // #9695
  {14,  1,   0}, // #9696
  {15,  1,   0}, // #9697
  {19, 17,   0}, // #9698
  {20, 17,   0}, // #9699
  {28, 37,   0}, // #9700
  {13,  1,   0}, // #9701
  {14,  2,   0}, // #9702
  {15,  2,   0}, // #9703
  {17,  1,   0}, // #9704
  {18,  2,   0}, // #9705
  {28,  4,   0}, // #9706
  { 2,  1,   0}, // #9707
  { 3,  1,   0}, // #9708
  { 4,  3,   0}, // #9709
  { 5,  8,   0}, // #9710
  { 7,  2,   0}, // #9711
  { 8,  2,   0}, // #9712
  { 9,  1,   0}, // #9713
  {10,  1,   0}, // #9714
  {11,  1,   0}, // #9715
  {14,  1,   0}, // #9716
  {15,  1,   0}, // #9717
  {28,  9,   0}, // #9718
  { 2,  1,   0}, // #9719
  { 3,  1,   0}, // #9720
  { 4,  3,   0}, // #9721
  { 5,  7,   0}, // #9722
  { 7,  2,   0}, // #9723
  { 8,  2,   0}, // #9724
  { 9,  1,   0}, // #9725
  {10,  1,   0}, // #9726
  {11,  1,   0}, // #9727
  {14,  2,   0}, // #9728
  {15,  1,   0}, // #9729
  {18,  1,   0}, // #9730
  {23,  1,   0}, // #9731
  {28, 10,   0}, // #9732
  { 4,  1,   0}, // #9733
  { 5,  2,   0}, // #9734
  { 7,  1,   0}, // #9735
  { 8,  1,   0}, // #9736
  {14,  1,   0}, // #9737
  {18,  1,   0}, // #9738
  {23,  1,   0}, // #9739
  {28,  4,   0}, // #9740
  { 2,  1,   0}, // #9741
  { 3,  4,   0}, // #9742
  { 4, 10,   0}, // #9743
  { 5, 10,   0}, // #9744
  { 6,  3,   0}, // #9745
  { 7,  9,   0}, // #9746
  { 8,  6,   0}, // #9747
  { 9,  1,   0}, // #9748
  {10,  4,   0}, // #9749
  {11,  4,   0}, // #9750
  {19,  3,   0}, // #9751
  {20,  3,   0}, // #9752
  {28, 10,   0}, // #9753
  { 1,  7,   0}, // #9754
  { 2, 26,   0}, // #9755
  { 3, 47,   0}, // #9756
  { 4, 73,   0}, // #9757
  { 5, 80,   0}, // #9758
  { 6, 28,   0}, // #9759
  { 7, 54,   0}, // #9760
  { 8, 33,   0}, // #9761
  { 9, 19,   0}, // #9762
  {10, 40,   0}, // #9763
  {11, 42,   0}, // #9764
  {14,  7,   0}, // #9765
  {15,  7,   0}, // #9766
  {19, 21,   0}, // #9767
  {20, 21,   0}, // #9768
  {28, 87,   0}, // #9769
  { 1,  7,   0}, // #9770
  { 2, 27,   0}, // #9771
  { 3, 47,   0}, // #9772
  { 4, 73,   0}, // #9773
  { 5, 80,   0}, // #9774
  { 6, 27,   0}, // #9775
  { 7, 53,   0}, // #9776
  { 8, 33,   0}, // #9777
  { 9, 19,   0}, // #9778
  {10, 39,   0}, // #9779
  {11, 42,   0}, // #9780
  {14,  7,   0}, // #9781
  {15,  7,   0}, // #9782
  {19, 20,   0}, // #9783
  {20, 20,   0}, // #9784
  {28, 87,   0}, // #9785
  { 1,  7,   0}, // #9786
  { 2, 28,   0}, // #9787
  { 3, 48,   0}, // #9788
  { 4, 76,   0}, // #9789
  { 5, 84,   0}, // #9790
  { 6, 27,   0}, // #9791
  { 7, 55,   0}, // #9792
  { 8, 35,   0}, // #9793
  { 9, 21,   0}, // #9794
  {10, 41,   0}, // #9795
  {11, 43,   0}, // #9796
  {14, 10,   0}, // #9797
  {15, 10,   0}, // #9798
  {19, 20,   0}, // #9799
  {20, 20,   0}, // #9800
  {28, 94,   0}, // #9801
  { 1,  7,   0}, // #9802
  { 2, 28,   0}, // #9803
  { 3, 49,   0}, // #9804
  { 4, 77,   0}, // #9805
  { 5, 88,   0}, // #9806
  { 6, 28,   0}, // #9807
  { 7, 56,   0}, // #9808
  { 8, 35,   0}, // #9809
  { 9, 21,   0}, // #9810
  {10, 42,   0}, // #9811
  {11, 44,   0}, // #9812
  {14, 11,   0}, // #9813
  {15, 11,   0}, // #9814
  {19, 21,   0}, // #9815
  {20, 21,   0}, // #9816
  {28, 99,   0}, // #9817
  { 1,  7,   0}, // #9818
  { 2, 24,   0}, // #9819
  { 3, 43,   0}, // #9820
  { 4, 67,   0}, // #9821
  { 5, 73,   0}, // #9822
  { 6, 26,   0}, // #9823
  { 7, 50,   0}, // #9824
  { 8, 31,   0}, // #9825
  { 9, 17,   0}, // #9826
  {10, 36,   0}, // #9827
  {11, 36,   0}, // #9828
  {14,  9,   0}, // #9829
  {15,  8,   0}, // #9830
  {18,  1,   0}, // #9831
  {19, 19,   0}, // #9832
  {20, 19,   0}, // #9833
  {23,  1,   0}, // #9834
  {28, 83,   0}, // #9835
  { 1,  7,   0}, // #9836
  { 2, 24,   0}, // #9837
  { 3, 46,   0}, // #9838
  { 4, 74,   0}, // #9839
  { 5, 79,   0}, // #9840
  { 6, 28,   0}, // #9841
  { 7, 56,   0}, // #9842
  { 8, 34,   0}, // #9843
  { 9, 17,   0}, // #9844
  {10, 38,   0}, // #9845
  {11, 38,   0}, // #9846
  {14, 12,   0}, // #9847
  {15, 11,   0}, // #9848
  {18,  1,   0}, // #9849
  {19, 21,   0}, // #9850
  {20, 21,   0}, // #9851
  {23,  1,   0}, // #9852
  {28, 92,   0}, // #9853
  { 1,  5,   0}, // #9854
  { 2, 11,   0}, // #9855
  { 3, 18,   0}, // #9856
  { 4, 26,   0}, // #9857
  { 5, 32,   0}, // #9858
  { 6, 12,   0}, // #9859
  { 7, 20,   0}, // #9860
  { 8, 13,   0}, // #9861
  { 9,  6,   0}, // #9862
  {10, 13,   0}, // #9863
  {11, 15,   0}, // #9864
  {14,  5,   0}, // #9865
  {18,  5,   0}, // #9866
  {19,  7,   0}, // #9867
  {20,  7,   0}, // #9868
  {23,  5,   0}, // #9869
  {28, 42,   0}, // #9870
  { 1,  8,   0}, // #9871
  { 2, 22,   0}, // #9872
  { 3, 23,   0}, // #9873
  { 4, 25,   0}, // #9874
  { 5, 25,   0}, // #9875
  { 6,  9,   0}, // #9876
  { 7, 11,   0}, // #9877
  { 8, 10,   0}, // #9878
  { 9, 14,   0}, // #9879
  {10, 15,   0}, // #9880
  {11, 15,   0}, // #9881
  {14,  3,   0}, // #9882
  {15,  3,   0}, // #9883
  {19,  1,   0}, // #9884
  {20,  1,   0}, // #9885
  {28, 28,   0}, // #9886
  { 1,  1,   0}, // #9887
  { 2,  6,   0}, // #9888
  { 3,  9,   0}, // #9889
  { 4, 18,   0}, // #9890
  { 5, 20,   0}, // #9891
  { 6,  4,   0}, // #9892
  { 7, 13,   0}, // #9893
  { 8, 10,   0}, // #9894
  { 9,  5,   0}, // #9895
  {10,  6,   0}, // #9896
  {11,  6,   0}, // #9897
  {14,  3,   0}, // #9898
  {15,  3,   0}, // #9899
  {19,  1,   0}, // #9900
  {20,  1,   0}, // #9901
  {28, 23,   0}, // #9902
  { 1,  1,   0}, // #9903
  { 2,  4,   0}, // #9904
  { 3,  4,   0}, // #9905
  { 4,  8,   0}, // #9906
  { 5, 10,   0}, // #9907
  { 6,  1,   0}, // #9908
  { 7,  5,   0}, // #9909
  { 8,  5,   0}, // #9910
  { 9,  3,   0}, // #9911
  {10,  3,   0}, // #9912
  {11,  3,   0}, // #9913
  {14,  3,   0}, // #9914
  {15,  2,   0}, // #9915
  {18,  1,   0}, // #9916
  {23,  1,   0}, // #9917
  {28, 14,   0}, // #9918
  { 2,  3,   0}, // #9919
  { 3,  4,   0}, // #9920
  { 4,  9,   0}, // #9921
  { 5, 10,   0}, // #9922
  { 6,  1,   0}, // #9923
  { 7,  6,   0}, // #9924
  { 8,  5,   0}, // #9925
  { 9,  3,   0}, // #9926
  {10,  3,   0}, // #9927
  {11,  3,   0}, // #9928
  {14,  3,   0}, // #9929
  {15,  2,   0}, // #9930
  {18,  1,   0}, // #9931
  {23,  1,   0}, // #9932
  {28, 14,   0}, // #9933
  { 2,  3,   0}, // #9934
  { 3,  3,   0}, // #9935
  { 4,  8,   0}, // #9936
  { 5,  8,   0}, // #9937
  { 7,  5,   0}, // #9938
  { 8,  5,   0}, // #9939
  { 9,  3,   0}, // #9940
  {10,  3,   0}, // #9941
  {11,  3,   0}, // #9942
  {14,  3,   0}, // #9943
  {15,  2,   0}, // #9944
  {18,  1,   0}, // #9945
  {23,  1,   0}, // #9946
  {28, 12,   0}, // #9947
  { 2,  3,   0}, // #9948
  { 3,  3,   0}, // #9949
  { 4,  7,   0}, // #9950
  { 5,  8,   0}, // #9951
  { 7,  4,   0}, // #9952
  { 8,  4,   0}, // #9953
  { 9,  3,   0}, // #9954
  {10,  3,   0}, // #9955
  {11,  3,   0}, // #9956
  {14,  2,   0}, // #9957
  {15,  1,   0}, // #9958
  {18,  1,   0}, // #9959
  {23,  1,   0}, // #9960
  {28, 11,   0}, // #9961
  { 1,  1,   0}, // #9962
  { 2,  4,   0}, // #9963
  { 3, 12,   0}, // #9964
  { 4, 20,   0}, // #9965
  { 5, 22,   0}, // #9966
  { 6,  8,   0}, // #9967
  { 7, 16,   0}, // #9968
  { 8,  9,   0}, // #9969
  { 9,  3,   0}, // #9970
  {10, 10,   0}, // #9971
  {11, 10,   0}, // #9972
  {14,  3,   0}, // #9973
  {15,  1,   0}, // #9974
  {18,  2,   0}, // #9975
  {19,  7,   0}, // #9976
  {20,  7,   0}, // #9977
  {23,  2,   0}, // #9978
  {28, 27,   0}, // #9979
  { 2,  1,   0}, // #9980
  { 3,  6,   0}, // #9981
  { 4, 13,   0}, // #9982
  { 5, 18,   0}, // #9983
  { 6,  5,   0}, // #9984
  { 7, 12,   0}, // #9985
  { 8,  7,   0}, // #9986
  { 9,  1,   0}, // #9987
  {10,  6,   0}, // #9988
  {11,  6,   0}, // #9989
  {14,  2,   0}, // #9990
  {18,  2,   0}, // #9991
  {19,  5,   0}, // #9992
  {20,  5,   0}, // #9993
  {23,  2,   0}, // #9994
  {28, 22,   0}, // #9995
  { 2,  8,   0}, // #9996
  { 3, 22,   0}, // #9997
  { 4, 38,   0}, // #9998
  { 5, 44,   0}, // #9999
  { 6, 12,   0}, // #10000
  { 7, 28,   0}, // #10001
  { 8, 16,   0}, // #10002
  { 9,  7,   0}, // #10003
  {10, 19,   0}, // #10004
  {11, 21,   0}, // #10005
  {14,  2,   0}, // #10006
  {18,  2,   0}, // #10007
  {19, 12,   0}, // #10008
  {20, 12,   0}, // #10009
  {23,  2,   0}, // #10010
  {28, 48,   0}, // #10011
  { 3,  1,   0}, // #10012
  { 4,  2,   0}, // #10013
  { 5,  3,   0}, // #10014
  { 6,  1,   0}, // #10015
  { 7,  2,   0}, // #10016
  { 8,  1,   0}, // #10017
  {10,  1,   0}, // #10018
  {11,  1,   0}, // #10019
  {19,  1,   0}, // #10020
  {20,  1,   0}, // #10021
  {28,  3,   0}, // #10022
  { 2,  4,   0}, // #10023
  { 3, 10,   0}, // #10024
  { 4, 18,   0}, // #10025
  { 5, 24,   0}, // #10026
  { 6,  3,   0}, // #10027
  { 7, 11,   0}, // #10028
  { 8,  8,   0}, // #10029
  { 9,  4,   0}, // #10030
  {10,  7,   0}, // #10031
  {11,  9,   0}, // #10032
  {19,  3,   0}, // #10033
  {20,  3,   0}, // #10034
  {28, 24,   0}, // #10035
  { 1,  6,   0}, // #10036
  { 2, 21,   0}, // #10037
  { 3, 38,   0}, // #10038
  { 4, 66,   0}, // #10039
  { 5, 70,   0}, // #10040
  { 6, 23,   0}, // #10041
  { 7, 51,   0}, // #10042
  { 8, 34,   0}, // #10043
  { 9, 15,   0}, // #10044
  {10, 31,   0}, // #10045
  {11, 31,   0}, // #10046
  {14,  8,   0}, // #10047
  {15,  7,   0}, // #10048
  {18,  1,   0}, // #10049
  {19, 16,   0}, // #10050
  {20, 16,   0}, // #10051
  {23,  1,   0}, // #10052
  {28, 79,   0}, // #10053
  { 1,  6,   0}, // #10054
  { 2, 21,   0}, // #10055
  { 3, 37,   0}, // #10056
  { 4, 64,   0}, // #10057
  { 5, 70,   0}, // #10058
  { 6, 22,   0}, // #10059
  { 7, 49,   0}, // #10060
  { 8, 33,   0}, // #10061
  { 9, 15,   0}, // #10062
  {10, 31,   0}, // #10063
  {11, 31,   0}, // #10064
  {14,  8,   0}, // #10065
  {15,  7,   0}, // #10066
  {18,  1,   0}, // #10067
  {19, 16,   0}, // #10068
  {20, 16,   0}, // #10069
  {23,  1,   0}, // #10070
  {28, 79,   0}, // #10071
  { 1,  6,   0}, // #10072
  { 2, 21,   0}, // #10073
  { 3, 40,   0}, // #10074
  { 4, 70,   0}, // #10075
  { 5, 74,   0}, // #10076
  { 6, 25,   0}, // #10077
  { 7, 55,   0}, // #10078
  { 8, 36,   0}, // #10079
  { 9, 15,   0}, // #10080
  {10, 33,   0}, // #10081
  {11, 33,   0}, // #10082
  {14, 10,   0}, // #10083
  {15,  9,   0}, // #10084
  {18,  1,   0}, // #10085
  {19, 18,   0}, // #10086
  {20, 18,   0}, // #10087
  {23,  1,   0}, // #10088
  {28, 85,   0}, // #10089
  { 1,  6,   0}, // #10090
  { 2, 21,   0}, // #10091
  { 3, 39,   0}, // #10092
  { 4, 68,   0}, // #10093
  { 5, 74,   0}, // #10094
  { 6, 24,   0}, // #10095
  { 7, 53,   0}, // #10096
  { 8, 35,   0}, // #10097
  { 9, 15,   0}, // #10098
  {10, 33,   0}, // #10099
  {11, 33,   0}, // #10100
  {14, 10,   0}, // #10101
  {15,  9,   0}, // #10102
  {18,  1,   0}, // #10103
  {19, 18,   0}, // #10104
  {20, 18,   0}, // #10105
  {23,  1,   0}, // #10106
  {28, 85,   0}, // #10107
  { 1,  7,   0}, // #10108
  { 2, 23,   0}, // #10109
  { 3, 40,   0}, // #10110
  { 4, 65,   0}, // #10111
  { 5, 71,   0}, // #10112
  { 6, 24,   0}, // #10113
  { 7, 49,   0}, // #10114
  { 8, 32,   0}, // #10115
  { 9, 16,   0}, // #10116
  {10, 33,   0}, // #10117
  {11, 33,   0}, // #10118
  {14,  8,   0}, // #10119
  {15,  7,   0}, // #10120
  {18,  1,   0}, // #10121
  {19, 17,   0}, // #10122
  {20, 17,   0}, // #10123
  {23,  1,   0}, // #10124
  {28, 80,   0}, // #10125
  { 1,  7,   0}, // #10126
  { 2, 23,   0}, // #10127
  { 3, 43,   0}, // #10128
  { 4, 71,   0}, // #10129
  { 5, 77,   0}, // #10130
  { 6, 27,   0}, // #10131
  { 7, 55,   0}, // #10132
  { 8, 35,   0}, // #10133
  { 9, 16,   0}, // #10134
  {10, 36,   0}, // #10135
  {11, 36,   0}, // #10136
  {14, 11,   0}, // #10137
  {15, 10,   0}, // #10138
  {18,  1,   0}, // #10139
  {19, 20,   0}, // #10140
  {20, 20,   0}, // #10141
  {23,  1,   0}, // #10142
  {28, 89,   0}, // #10143
  { 4,  2,   0}, // #10144
  { 5,  3,   0}, // #10145
  { 7,  2,   0}, // #10146
  { 8,  2,   0}, // #10147
  {14,  1,   0}, // #10148
  {15,  1,   0}, // #10149
  {21,  2,   0}, // #10150
  {28,  4,   0}, // #10151
  { 2,  2,   0}, // #10152
  { 3,  2,   0}, // #10153
  { 4,  7,   0}, // #10154
  { 5,  8,   0}, // #10155
  { 7,  5,   0}, // #10156
  { 8,  5,   0}, // #10157
  { 9,  2,   0}, // #10158
  {10,  2,   0}, // #10159
  {11,  2,   0}, // #10160
  {14,  2,   0}, // #10161
  {15,  1,   0}, // #10162
  {18,  1,   0}, // #10163
  {23,  1,   0}, // #10164
  {28, 11,   0}, // #10165
  { 2,  3,   0}, // #10166
  { 3,  3,   0}, // #10167
  { 4,  7,   0}, // #10168
  { 5,  9,   0}, // #10169
  { 7,  4,   0}, // #10170
  { 8,  4,   0}, // #10171
  { 9,  3,   0}, // #10172
  {10,  3,   0}, // #10173
  {11,  3,   0}, // #10174
  {14,  2,   0}, // #10175
  {15,  1,   0}, // #10176
  {18,  1,   0}, // #10177
  {23,  1,   0}, // #10178
  {28, 12,   0}, // #10179
  { 1,  2,   0}, // #10180
  { 2,  9,   0}, // #10181
  { 3, 16,   0}, // #10182
  { 4, 24,   0}, // #10183
  { 5, 24,   0}, // #10184
  { 6,  6,   0}, // #10185
  { 7, 14,   0}, // #10186
  { 8,  7,   0}, // #10187
  { 9,  7,   0}, // #10188
  {10, 11,   0}, // #10189
  {11, 11,   0}, // #10190
  {14,  1,   0}, // #10191
  {15,  1,   0}, // #10192
  {19,  4,   0}, // #10193
  {20,  4,   0}, // #10194
  {28, 25,   0}, // #10195
  { 2,  1,   0}, // #10196
  { 3,  1,   0}, // #10197
  { 4,  3,   0}, // #10198
  { 5,  5,   0}, // #10199
  { 7,  2,   0}, // #10200
  { 8,  2,   0}, // #10201
  { 9,  1,   0}, // #10202
  {10,  1,   0}, // #10203
  {11,  1,   0}, // #10204
  {14,  1,   0}, // #10205
  {18,  1,   0}, // #10206
  {23,  1,   0}, // #10207
  {28,  7,   0}, // #10208
  { 3,  1,   0}, // #10209
  { 4,  1,   0}, // #10210
  { 5,  2,   0}, // #10211
  { 6,  1,   0}, // #10212
  { 7,  1,   0}, // #10213
  {10,  1,   0}, // #10214
  {11,  1,   0}, // #10215
  {19,  1,   0}, // #10216
  {20,  1,   0}, // #10217
  {28,  2,   0}, // #10218
  { 1,  6,   0}, // #10219
  { 2, 13,   0}, // #10220
  { 3, 13,   0}, // #10221
  { 4, 13,   0}, // #10222
  { 5, 13,   0}, // #10223
  { 6,  6,   0}, // #10224
  { 7,  6,   0}, // #10225
  { 8,  6,   0}, // #10226
  { 9,  7,   0}, // #10227
  {10,  7,   0}, // #10228
  {11,  7,   0}, // #10229
  {14, 18,   0}, // #10230
  {15, 18,   0}, // #10231
  {28, 31,   0}, // #10232
  { 1,  6,   0}, // #10233
  { 2, 13,   0}, // #10234
  { 3, 13,   0}, // #10235
  { 4, 13,   0}, // #10236
  { 5, 13,   0}, // #10237
  { 6,  6,   0}, // #10238
  { 7,  6,   0}, // #10239
  { 8,  6,   0}, // #10240
  { 9,  7,   0}, // #10241
  {10,  7,   0}, // #10242
  {11,  7,   0}, // #10243
  {14, 17,   0}, // #10244
  {15, 17,   0}, // #10245
  {28, 30,   0}, // #10246
  { 1,  5,   0}, // #10247
  { 2, 13,   0}, // #10248
  { 3, 13,   0}, // #10249
  { 4, 13,   0}, // #10250
  { 5, 13,   0}, // #10251
  { 6,  5,   0}, // #10252
  { 7,  5,   0}, // #10253
  { 8,  5,   0}, // #10254
  { 9,  8,   0}, // #10255
  {10,  8,   0}, // #10256
  {11,  8,   0}, // #10257
  {14, 20,   0}, // #10258
  {15, 20,   0}, // #10259
  {28, 33,   0}, // #10260
  { 1,  1,   0}, // #10261
  { 2,  1,   0}, // #10262
  { 3,  1,   0}, // #10263
  { 4,  2,   0}, // #10264
  { 5,  2,   0}, // #10265
  { 6,  1,   0}, // #10266
  { 7,  2,   0}, // #10267
  { 8,  2,   0}, // #10268
  {14,  1,   0}, // #10269
  {15,  1,   0}, // #10270
  {28,  3,   0}, // #10271
  { 2,  4,   0}, // #10272
  { 3,  5,   0}, // #10273
  { 4,  6,   0}, // #10274
  { 5,  8,   0}, // #10275
  { 6,  1,   0}, // #10276
  { 7,  2,   0}, // #10277
  { 8,  1,   0}, // #10278
  { 9,  4,   0}, // #10279
  {10,  5,   0}, // #10280
  {11,  5,   0}, // #10281
  {19,  1,   0}, // #10282
  {20,  1,   0}, // #10283
  {28,  8,   0}, // #10284
  { 1,  1,   0}, // #10285
  { 2, 43,   0}, // #10286
  { 3, 91,   0}, // #10287
  { 4, 143,   0}, // #10288
  { 5, 143,   0}, // #10289
  { 6, 49,   0}, // #10290
  { 7, 101,   0}, // #10291
  { 8, 53,   0}, // #10292
  { 9, 23,   0}, // #10293
  {10, 35,   0}, // #10294
  {11, 35,   0}, // #10295
  {14,  6,   0}, // #10296
  {15,  4,   0}, // #10297
  {18,  2,   0}, // #10298
  {19, 12,   0}, // #10299
  {20, 12,   0}, // #10300
  {23,  2,   0}, // #10301
  {28, 151,   0}, // #10302
  { 1,  1,   0}, // #10303
  { 2, 43,   0}, // #10304
  { 3, 91,   0}, // #10305
  { 4, 144,   0}, // #10306
  { 5, 144,   0}, // #10307
  { 6, 49,   0}, // #10308
  { 7, 102,   0}, // #10309
  { 8, 54,   0}, // #10310
  { 9, 23,   0}, // #10311
  {10, 35,   0}, // #10312
  {11, 35,   0}, // #10313
  {14,  6,   0}, // #10314
  {15,  4,   0}, // #10315
  {18,  2,   0}, // #10316
  {19, 12,   0}, // #10317
  {20, 12,   0}, // #10318
  {23,  2,   0}, // #10319
  {28, 152,   0}, // #10320
  { 2, 52,   0}, // #10321
  { 3, 97,   0}, // #10322
  { 4, 149,   0}, // #10323
  { 5, 149,   0}, // #10324
  { 6, 45,   0}, // #10325
  { 7, 97,   0}, // #10326
  { 8, 52,   0}, // #10327
  { 9, 27,   0}, // #10328
  {10, 37,   0}, // #10329
  {11, 37,   0}, // #10330
  {14,  5,   0}, // #10331
  {15,  4,   0}, // #10332
  {18,  1,   0}, // #10333
  {19, 10,   0}, // #10334
  {20, 10,   0}, // #10335
  {23,  1,   0}, // #10336
  {28, 155,   0}, // #10337
  { 2, 52,   0}, // #10338
  { 3, 123,   0}, // #10339
  { 4, 176,   0}, // #10340
  { 5, 176,   0}, // #10341
  { 6, 41,   0}, // #10342
  { 7, 94,   0}, // #10343
  { 8, 53,   0}, // #10344
  { 9, 29,   0}, // #10345
  {10, 68,   0}, // #10346
  {11, 68,   0}, // #10347
  {14,  6,   0}, // #10348
  {15,  4,   0}, // #10349
  {18,  2,   0}, // #10350
  {19,  9,   0}, // #10351
  {20,  9,   0}, // #10352
  {23,  2,   0}, // #10353
  {28, 184,   0}, // #10354
  { 2,  1,   0}, // #10355
  { 3,  3,   0}, // #10356
  { 4,  3,   0}, // #10357
  { 5,  3,   0}, // #10358
  { 6,  1,   0}, // #10359
  { 7,  1,   0}, // #10360
  {10,  2,   0}, // #10361
  {11,  2,   0}, // #10362
  {14,  1,   0}, // #10363
  {15,  1,   0}, // #10364
  {19,  1,   0}, // #10365
  {20,  1,   0}, // #10366
  {28,  4,   0}, // #10367
  { 2,  1,   0}, // #10368
  { 3,  3,   0}, // #10369
  { 4,  3,   0}, // #10370
  { 5,  3,   0}, // #10371
  { 6,  1,   0}, // #10372
  { 7,  1,   0}, // #10373
  {10,  2,   0}, // #10374
  {11,  2,   0}, // #10375
  {19,  1,   0}, // #10376
  {20,  1,   0}, // #10377
  {28,  3,   0}, // #10378
  { 2,  2,   0}, // #10379
  { 3,  4,   0}, // #10380
  { 4,  4,   0}, // #10381
  { 5,  4,   0}, // #10382
  { 6,  1,   0}, // #10383
  { 7,  1,   0}, // #10384
  {10,  2,   0}, // #10385
  {11,  2,   0}, // #10386
  {14,  1,   0}, // #10387
  {15,  1,   0}, // #10388
  {19,  1,   0}, // #10389
  {20,  1,   0}, // #10390
  {28,  5,   0}, // #10391
  { 2,  2,   0}, // #10392
  { 3,  4,   0}, // #10393
  { 4,  4,   0}, // #10394
  { 5,  4,   0}, // #10395
  { 6,  1,   0}, // #10396
  { 7,  1,   0}, // #10397
  {10,  2,   0}, // #10398
  {11,  2,   0}, // #10399
  {19,  1,   0}, // #10400
  {20,  1,   0}, // #10401
  {28,  4,   0}, // #10402
  { 1,  2,   0}, // #10403
  { 2,  2,   0}, // #10404
  { 3,  4,   0}, // #10405
  { 4,  4,   0}, // #10406
  { 5,  4,   0}, // #10407
  { 6,  4,   0}, // #10408
  { 7,  4,   0}, // #10409
  { 8,  2,   0}, // #10410
  {10,  2,   0}, // #10411
  {11,  2,   0}, // #10412
  {14,  1,   0}, // #10413
  {15,  1,   0}, // #10414
  {19,  2,   0}, // #10415
  {20,  2,   0}, // #10416
  {28,  5,   0}, // #10417
  { 2,  2,   0}, // #10418
  { 3,  5,   0}, // #10419
  { 4,  6,   0}, // #10420
  { 5,  6,   0}, // #10421
  { 6,  2,   0}, // #10422
  { 7,  3,   0}, // #10423
  { 8,  1,   0}, // #10424
  {10,  2,   0}, // #10425
  {11,  2,   0}, // #10426
  {14,  1,   0}, // #10427
  {15,  1,   0}, // #10428
  {19,  2,   0}, // #10429
  {20,  2,   0}, // #10430
  {28,  7,   0}, // #10431
  { 2,  2,   0}, // #10432
  { 3,  5,   0}, // #10433
  { 4,  5,   0}, // #10434
  { 5,  5,   0}, // #10435
  { 6,  2,   0}, // #10436
  { 7,  2,   0}, // #10437
  {10,  2,   0}, // #10438
  {11,  2,   0}, // #10439
  {19,  2,   0}, // #10440
  {20,  2,   0}, // #10441
  {28,  5,   0}, // #10442
  { 2,  2,   0}, // #10443
  { 3,  4,   0}, // #10444
  { 4,  5,   0}, // #10445
  { 5,  5,   0}, // #10446
  { 6,  2,   0}, // #10447
  { 7,  3,   0}, // #10448
  { 8,  1,   0}, // #10449
  {10,  2,   0}, // #10450
  {11,  2,   0}, // #10451
  {14,  1,   0}, // #10452
  {15,  1,   0}, // #10453
  {19,  2,   0}, // #10454
  {20,  2,   0}, // #10455
  {28,  6,   0}, // #10456
  { 1,  2,   0}, // #10457
  { 2,  2,   0}, // #10458
  { 3,  4,   0}, // #10459
  { 4,  5,   0}, // #10460
  { 5,  5,   0}, // #10461
  { 6,  4,   0}, // #10462
  { 7,  5,   0}, // #10463
  { 8,  3,   0}, // #10464
  {10,  2,   0}, // #10465
  {11,  2,   0}, // #10466
  {14,  1,   0}, // #10467
  {15,  1,   0}, // #10468
  {19,  2,   0}, // #10469
  {20,  2,   0}, // #10470
  {28,  6,   0}, // #10471
  { 2,  2,   0}, // #10472
  { 3,  5,   0}, // #10473
  { 4,  6,   0}, // #10474
  { 5,  6,   0}, // #10475
  { 6,  2,   0}, // #10476
  { 7,  3,   0}, // #10477
  { 8,  1,   0}, // #10478
  {10,  2,   0}, // #10479
  {11,  2,   0}, // #10480
  {19,  2,   0}, // #10481
  {20,  2,   0}, // #10482
  {28,  6,   0}, // #10483
  { 2,  2,   0}, // #10484
  { 3,  4,   0}, // #10485
  { 4,  4,   0}, // #10486
  { 5,  4,   0}, // #10487
  { 6,  2,   0}, // #10488
  { 7,  2,   0}, // #10489
  {10,  2,   0}, // #10490
  {11,  2,   0}, // #10491
  {14,  1,   0}, // #10492
  {15,  1,   0}, // #10493
  {19,  2,   0}, // #10494
  {20,  2,   0}, // #10495
  {28,  5,   0}, // #10496
  { 2,  1,   0}, // #10497
  { 3,  4,   0}, // #10498
  { 4,  5,   0}, // #10499
  { 5,  5,   0}, // #10500
  { 6,  1,   0}, // #10501
  { 7,  2,   0}, // #10502
  { 8,  1,   0}, // #10503
  {10,  1,   0}, // #10504
  {11,  1,   0}, // #10505
  {14,  1,   0}, // #10506
  {15,  1,   0}, // #10507
  {19,  1,   0}, // #10508
  {20,  1,   0}, // #10509
  {28,  6,   0}, // #10510
  { 2,  1,   0}, // #10511
  { 3,  4,   0}, // #10512
  { 4,  4,   0}, // #10513
  { 5,  4,   0}, // #10514
  { 6,  1,   0}, // #10515
  { 7,  1,   0}, // #10516
  {10,  1,   0}, // #10517
  {11,  1,   0}, // #10518
  {19,  1,   0}, // #10519
  {20,  1,   0}, // #10520
  {28,  4,   0}, // #10521
  { 2,  1,   0}, // #10522
  { 3,  4,   0}, // #10523
  { 4,  4,   0}, // #10524
  { 5,  4,   0}, // #10525
  { 6,  1,   0}, // #10526
  { 7,  1,   0}, // #10527
  {10,  2,   0}, // #10528
  {11,  2,   0}, // #10529
  {14,  1,   0}, // #10530
  {15,  1,   0}, // #10531
  {19,  1,   0}, // #10532
  {20,  1,   0}, // #10533
  {28,  5,   0}, // #10534
  { 2,  1,   0}, // #10535
  { 3,  4,   0}, // #10536
  { 4,  4,   0}, // #10537
  { 5,  4,   0}, // #10538
  { 6,  1,   0}, // #10539
  { 7,  1,   0}, // #10540
  {10,  2,   0}, // #10541
  {11,  2,   0}, // #10542
  {19,  1,   0}, // #10543
  {20,  1,   0}, // #10544
  {28,  4,   0}, // #10545
  { 1,  1,   0}, // #10546
  { 2,  1,   0}, // #10547
  { 3,  4,   0}, // #10548
  { 4,  4,   0}, // #10549
  { 5,  4,   0}, // #10550
  { 6,  4,   0}, // #10551
  { 7,  4,   0}, // #10552
  { 8,  1,   0}, // #10553
  {10,  2,   0}, // #10554
  {11,  2,   0}, // #10555
  {14,  1,   0}, // #10556
  {15,  1,   0}, // #10557
  {19,  2,   0}, // #10558
  {20,  2,   0}, // #10559
  {28,  5,   0}, // #10560
  { 1,  1,   0}, // #10561
  { 2,  1,   0}, // #10562
  { 3,  4,   0}, // #10563
  { 4,  4,   0}, // #10564
  { 5,  4,   0}, // #10565
  { 6,  4,   0}, // #10566
  { 7,  4,   0}, // #10567
  { 8,  1,   0}, // #10568
  {10,  2,   0}, // #10569
  {11,  2,   0}, // #10570
  {19,  2,   0}, // #10571
  {20,  2,   0}, // #10572
  {28,  4,   0}, // #10573
  { 2,  2,   0}, // #10574
  { 3,  5,   0}, // #10575
  { 4,  6,   0}, // #10576
  { 5,  6,   0}, // #10577
  { 6,  1,   0}, // #10578
  { 7,  2,   0}, // #10579
  { 8,  1,   0}, // #10580
  {10,  1,   0}, // #10581
  {11,  1,   0}, // #10582
  {14,  1,   0}, // #10583
  {15,  1,   0}, // #10584
  {19,  1,   0}, // #10585
  {20,  1,   0}, // #10586
  {28,  7,   0}, // #10587
  { 2,  2,   0}, // #10588
  { 3,  4,   0}, // #10589
  { 4,  4,   0}, // #10590
  { 5,  4,   0}, // #10591
  { 6,  1,   0}, // #10592
  { 7,  1,   0}, // #10593
  {10,  1,   0}, // #10594
  {11,  1,   0}, // #10595
  {19,  1,   0}, // #10596
  {20,  1,   0}, // #10597
  {28,  4,   0}, // #10598
  { 2,  2,   0}, // #10599
  { 3,  3,   0}, // #10600
  { 4,  3,   0}, // #10601
  { 5,  3,   0}, // #10602
  { 6,  1,   0}, // #10603
  { 7,  1,   0}, // #10604
  {10,  1,   0}, // #10605
  {11,  1,   0}, // #10606
  {14,  1,   0}, // #10607
  {15,  1,   0}, // #10608
  {19,  1,   0}, // #10609
  {20,  1,   0}, // #10610
  {28,  4,   0}, // #10611
  { 2,  2,   0}, // #10612
  { 3,  3,   0}, // #10613
  { 4,  3,   0}, // #10614
  { 5,  3,   0}, // #10615
  { 6,  1,   0}, // #10616
  { 7,  1,   0}, // #10617
  {10,  1,   0}, // #10618
  {11,  1,   0}, // #10619
  {19,  1,   0}, // #10620
  {20,  1,   0}, // #10621
  {28,  3,   0}, // #10622
  { 1,  1,   0}, // #10623
  { 2,  2,   0}, // #10624
  { 3,  3,   0}, // #10625
  { 4,  3,   0}, // #10626
  { 5,  3,   0}, // #10627
  { 6,  1,   0}, // #10628
  { 7,  1,   0}, // #10629
  { 8,  1,   0}, // #10630
  {28,  3,   0}, // #10631
  { 2,  1,   0}, // #10632
  { 3,  2,   0}, // #10633
  { 4,  2,   0}, // #10634
  { 5,  2,   0}, // #10635
  {14,  1,   0}, // #10636
  {15,  1,   0}, // #10637
  {28,  3,   0}, // #10638
  { 1,  2,   0}, // #10639
  { 2,  2,   0}, // #10640
  { 3,  3,   0}, // #10641
  { 4,  3,   0}, // #10642
  { 5,  3,   0}, // #10643
  { 6,  2,   0}, // #10644
  { 7,  2,   0}, // #10645
  { 8,  2,   0}, // #10646
  {14,  1,   0}, // #10647
  {15,  1,   0}, // #10648
  {28,  4,   0}, // #10649
  { 1,  2,   0}, // #10650
  { 2,  2,   0}, // #10651
  { 3,  3,   0}, // #10652
  { 4,  3,   0}, // #10653
  { 5,  3,   0}, // #10654
  { 6,  2,   0}, // #10655
  { 7,  2,   0}, // #10656
  { 8,  2,   0}, // #10657
  {28,  3,   0}, // #10658
  { 1,  4,   0}, // #10659
  { 2,  4,   0}, // #10660
  { 3,  7,   0}, // #10661
  { 4,  8,   0}, // #10662
  { 5,  8,   0}, // #10663
  { 6,  7,   0}, // #10664
  { 7,  8,   0}, // #10665
  { 8,  5,   0}, // #10666
  {10,  1,   0}, // #10667
  {11,  1,   0}, // #10668
  {14,  1,   0}, // #10669
  {15,  1,   0}, // #10670
  {19,  1,   0}, // #10671
  {20,  1,   0}, // #10672
  {28,  9,   0}, // #10673
  { 1,  4,   0}, // #10674
  { 2,  4,   0}, // #10675
  { 3,  5,   0}, // #10676
  { 4,  6,   0}, // #10677
  { 5,  6,   0}, // #10678
  { 6,  5,   0}, // #10679
  { 7,  6,   0}, // #10680
  { 8,  5,   0}, // #10681
  {10,  1,   0}, // #10682
  {11,  1,   0}, // #10683
  {19,  1,   0}, // #10684
  {20,  1,   0}, // #10685
  {28,  6,   0}, // #10686
  { 1,  1,   0}, // #10687
  { 2,  1,   0}, // #10688
  { 3,  3,   0}, // #10689
  { 4,  3,   0}, // #10690
  { 5,  3,   0}, // #10691
  { 6,  3,   0}, // #10692
  { 7,  3,   0}, // #10693
  { 8,  1,   0}, // #10694
  {10,  2,   0}, // #10695
  {11,  2,   0}, // #10696
  {14,  8,   0}, // #10697
  {15,  8,   0}, // #10698
  {19,  2,   0}, // #10699
  {20,  2,   0}, // #10700
  {28, 11,   0}, // #10701
  { 5,  1,   0}, // #10702
  {14,  2,   0}, // #10703
  {18,  2,   0}, // #10704
  {23,  2,   0}, // #10705
  {28,  5,   0}, // #10706
  { 3, 11,   0}, // #10707
  { 4, 11,   0}, // #10708
  { 5, 11,   0}, // #10709
  { 6,  8,   0}, // #10710
  { 7,  8,   0}, // #10711
  {10,  8,   0}, // #10712
  {11,  8,   0}, // #10713
  {14,  1,   0}, // #10714
  {15,  1,   0}, // #10715
  {19,  8,   0}, // #10716
  {20,  8,   0}, // #10717
  {28, 12,   0}, // #10718
  { 3, 12,   0}, // #10719
  { 4, 12,   0}, // #10720
  { 5, 12,   0}, // #10721
  { 6,  8,   0}, // #10722
  { 7,  8,   0}, // #10723
  {10,  8,   0}, // #10724
  {11,  8,   0}, // #10725
  {19,  8,   0}, // #10726
  {20,  8,   0}, // #10727
  {28, 12,   0}, // #10728
  { 1,  1,   0}, // #10729
  { 2,  9,   0}, // #10730
  { 3, 29,   0}, // #10731
  { 4, 29,   0}, // #10732
  { 5, 29,   0}, // #10733
  { 6, 12,   0}, // #10734
  { 7, 12,   0}, // #10735
  { 8,  1,   0}, // #10736
  {10, 13,   0}, // #10737
  {11, 13,   0}, // #10738
  {14,  1,   0}, // #10739
  {15,  1,   0}, // #10740
  {19, 11,   0}, // #10741
  {20, 11,   0}, // #10742
  {28, 30,   0}, // #10743
  { 1,  1,   0}, // #10744
  { 2,  9,   0}, // #10745
  { 3, 30,   0}, // #10746
  { 4, 30,   0}, // #10747
  { 5, 30,   0}, // #10748
  { 6, 12,   0}, // #10749
  { 7, 12,   0}, // #10750
  { 8,  1,   0}, // #10751
  {10, 13,   0}, // #10752
  {11, 13,   0}, // #10753
  {19, 11,   0}, // #10754
  {20, 11,   0}, // #10755
  {28, 30,   0}, // #10756
  { 1, 13,   0}, // #10757
  { 2, 13,   0}, // #10758
  { 3, 45,   0}, // #10759
  { 4, 45,   0}, // #10760
  { 5, 45,   0}, // #10761
  { 6, 45,   0}, // #10762
  { 7, 45,   0}, // #10763
  { 8, 13,   0}, // #10764
  {10, 23,   0}, // #10765
  {11, 23,   0}, // #10766
  {14,  1,   0}, // #10767
  {15,  1,   0}, // #10768
  {19, 23,   0}, // #10769
  {20, 23,   0}, // #10770
  {28, 46,   0}, // #10771
  { 1, 13,   0}, // #10772
  { 2, 13,   0}, // #10773
  { 3, 46,   0}, // #10774
  { 4, 46,   0}, // #10775
  { 5, 46,   0}, // #10776
  { 6, 46,   0}, // #10777
  { 7, 46,   0}, // #10778
  { 8, 13,   0}, // #10779
  {10, 23,   0}, // #10780
  {11, 23,   0}, // #10781
  {19, 23,   0}, // #10782
  {20, 23,   0}, // #10783
  {28, 46,   0}, // #10784
  { 3,  4,   0}, // #10785
  { 4,  4,   0}, // #10786
  { 5,  4,   0}, // #10787
  { 6,  4,   0}, // #10788
  { 7,  4,   0}, // #10789
  {10,  4,   0}, // #10790
  {11,  4,   0}, // #10791
  {14,  1,   0}, // #10792
  {15,  1,   0}, // #10793
  {19,  4,   0}, // #10794
  {20,  4,   0}, // #10795
  {28,  5,   0}, // #10796
  { 3,  4,   0}, // #10797
  { 4,  4,   0}, // #10798
  { 5,  4,   0}, // #10799
  { 6,  4,   0}, // #10800
  { 7,  4,   0}, // #10801
  {10,  4,   0}, // #10802
  {11,  4,   0}, // #10803
  {19,  4,   0}, // #10804
  {20,  4,   0}, // #10805
  {28,  4,   0}, // #10806
  { 1,  8,   0}, // #10807
  { 2,  8,   0}, // #10808
  { 3, 29,   0}, // #10809
  { 4, 29,   0}, // #10810
  { 5, 29,   0}, // #10811
  { 6, 29,   0}, // #10812
  { 7, 29,   0}, // #10813
  { 8,  8,   0}, // #10814
  {10, 14,   0}, // #10815
  {11, 14,   0}, // #10816
  {14,  1,   0}, // #10817
  {15,  1,   0}, // #10818
  {19, 14,   0}, // #10819
  {20, 14,   0}, // #10820
  {28, 30,   0}, // #10821
  { 1,  8,   0}, // #10822
  { 2,  8,   0}, // #10823
  { 3, 30,   0}, // #10824
  { 4, 30,   0}, // #10825
  { 5, 30,   0}, // #10826
  { 6, 30,   0}, // #10827
  { 7, 30,   0}, // #10828
  { 8,  8,   0}, // #10829
  {10, 14,   0}, // #10830
  {11, 14,   0}, // #10831
  {19, 14,   0}, // #10832
  {20, 14,   0}, // #10833
  {28, 30,   0}, // #10834
  { 1,  1,   0}, // #10835
  { 2,  1,   0}, // #10836
  { 3,  3,   0}, // #10837
  { 4,  4,   0}, // #10838
  { 5,  4,   0}, // #10839
  { 6,  3,   0}, // #10840
  { 7,  4,   0}, // #10841
  { 8,  2,   0}, // #10842
  {10,  2,   0}, // #10843
  {11,  2,   0}, // #10844
  {14,  1,   0}, // #10845
  {18,  1,   0}, // #10846
  {19,  2,   0}, // #10847
  {20,  2,   0}, // #10848
  {23,  1,   0}, // #10849
  {28,  6,   0}, // #10850
  { 1,  1,   0}, // #10851
  { 2,  1,   0}, // #10852
  { 3,  3,   0}, // #10853
  { 4,  3,   0}, // #10854
  { 5,  4,   0}, // #10855
  { 6,  3,   0}, // #10856
  { 7,  3,   0}, // #10857
  { 8,  1,   0}, // #10858
  {10,  2,   0}, // #10859
  {11,  2,   0}, // #10860
  {14,  2,   0}, // #10861
  {18,  2,   0}, // #10862
  {19,  2,   0}, // #10863
  {20,  2,   0}, // #10864
  {23,  2,   0}, // #10865
  {28,  8,   0}, // #10866
  { 4,  1,   0}, // #10867
  { 5,  3,   0}, // #10868
  { 7,  1,   0}, // #10869
  { 8,  1,   0}, // #10870
  {28,  3,   0}, // #10871
  {25,  1,   0}, // #10872
  {26,  1,   0}, // #10873
  {15,  1,   0}, // #10874
  {23,  1,   0}, // #10875
  {24,  1,   0}, // #10876
  {25,  1,   0}, // #10877
  {26,  1,   0}, // #10878
  {16,  1,   0}, // #10879
  {24,  1,   0}, // #10880
  {25,  1,   0}, // #10881
  {26,  1,   0}, // #10882
  {16,  2,   0}, // #10883
  {19,  1,   0}, // #10884
  {20,  1,   0}, // #10885
  {22,  1,   0}, // #10886
  {24,  2,   0}, // #10887
  {25,  3,   0}, // #10888
  {26,  6,   0}, // #10889
  {16,  1,   0}, // #10890
  {19,  1,   0}, // #10891
  {24,  1,   0}, // #10892
  {25,  1,   0}, // #10893
  {26,  2,   0}, // #10894
  {17,  1,   0}, // #10895
  {23,  1,   0}, // #10896
  {25,  1,   0}, // #10897
  {26,  1,   0}, // #10898
  {20,  1,   0}, // #10899
  {22,  1,   0}, // #10900
  {26,  2,   0}, // #10901
  { 4,  1,   0}, // #10902
  {13,  1,   0}, // #10903
  {17,  1,   0}, // #10904
  {18,  1,   0}, // #10905
  {23,  1,   0}, // #10906
  {25,  1,   0}, // #10907
  {26,  1,   0}, // #10908
  {19,  1,   0}, // #10909
  {26,  1,   0}, // #10910
  {19,  1,   0}, // #10911
  {20,  1,   0}, // #10912
  {22,  1,   0}, // #10913
  {25,  1,   0}, // #10914
  {26,  4,   0}, // #10915
  { 3,  1,   0}, // #10916
  {13,  1,   0}, // #10917
  {14,  1,   0}, // #10918
  {15,  1,   0}, // #10919
  {16,  1,   0}, // #10920
  {23,  1,   0}, // #10921
  {24,  1,   0}, // #10922
  {25,  1,   0}, // #10923
  {26,  1,   0}, // #10924
  {19,  1,   0}, // #10925
  {25,  1,   0}, // #10926
  {26,  2,   0}, // #10927
  {13,  1,   0}, // #10928
  {19,  1,   0}, // #10929
  {23,  1,   0}, // #10930
  {25,  1,   0}, // #10931
  {26,  2,   0}, // #10932
  {13,  1,   0}, // #10933
  {23,  1,   0}, // #10934
  {25,  1,   0}, // #10935
  {26,  1,   0}, // #10936
  { 3,  1,   0}, // #10937
  {13,  1,   0}, // #10938
  {14,  1,   0}, // #10939
  {15,  1,   0}, // #10940
  {16,  1,   0}, // #10941
  {19,  1,   0}, // #10942
  {23,  1,   0}, // #10943
  {24,  1,   0}, // #10944
  {25,  1,   0}, // #10945
  {26,  2,   0}, // #10946
  { 3,  2,   0}, // #10947
  {13,  2,   0}, // #10948
  {14,  2,   0}, // #10949
  {15,  2,   0}, // #10950
  {16,  2,   0}, // #10951
  {19,  1,   0}, // #10952
  {23,  2,   0}, // #10953
  {24,  2,   0}, // #10954
  {25,  2,   0}, // #10955
  {26,  3,   0}, // #10956
  { 3,  2,   0}, // #10957
  {13,  2,   0}, // #10958
  {14,  2,   0}, // #10959
  {15,  2,   0}, // #10960
  {16,  2,   0}, // #10961
  {23,  2,   0}, // #10962
  {24,  2,   0}, // #10963
  {25,  2,   0}, // #10964
  {26,  2,   0}, // #10965
  { 3,  3,   0}, // #10966
  { 8,  6,   0}, // #10967
  {13,  3,   0}, // #10968
  {14,  3,   0}, // #10969
  {15,  9,   0}, // #10970
  {16,  3,   0}, // #10971
  {17,  6,   0}, // #10972
  {19,  1,   0}, // #10973
  {21,  6,   0}, // #10974
  {23, 10,   0}, // #10975
  {24,  9,   0}, // #10976
  {25, 10,   0}, // #10977
  {26, 11,   0}, // #10978
  { 3,  3,   0}, // #10979
  { 8,  6,   0}, // #10980
  {13,  3,   0}, // #10981
  {14,  3,   0}, // #10982
  {15,  9,   0}, // #10983
  {16,  3,   0}, // #10984
  {17,  6,   0}, // #10985
  {21,  6,   0}, // #10986
  {23, 11,   0}, // #10987
  {24,  9,   0}, // #10988
  {25, 11,   0}, // #10989
  {26, 11,   0}, // #10990
  {16,  1,   0}, // #10991
  {17,  1,   0}, // #10992
  {19,  1,   0}, // #10993
  {23,  1,   0}, // #10994
  {24,  1,   0}, // #10995
  {25,  2,   0}, // #10996
  {26,  3,   0}, // #10997
  {16,  1,   0}, // #10998
  {17,  1,   0}, // #10999
  {23,  1,   0}, // #11000
  {24,  1,   0}, // #11001
  {25,  2,   0}, // #11002
  {26,  2,   0}, // #11003
  {19,  1,   0}, // #11004
  {23,  2,   0}, // #11005
  {25,  2,   0}, // #11006
  {26,  3,   0}, // #11007
  {23,  2,   0}, // #11008
  {25,  2,   0}, // #11009
  {26,  2,   0}, // #11010
  {17,  1,   0}, // #11011
  {19,  1,   0}, // #11012
  {23,  1,   0}, // #11013
  {25,  1,   0}, // #11014
  {26,  2,   0}, // #11015
  { 4,  1,   0}, // #11016
  {13,  1,   0}, // #11017
  {17,  1,   0}, // #11018
  {18,  1,   0}, // #11019
  {19,  1,   0}, // #11020
  {23,  1,   0}, // #11021
  {25,  1,   0}, // #11022
  {26,  2,   0}, // #11023
  {16,  1,   0}, // #11024
  {19,  1,   0}, // #11025
  {20,  1,   0}, // #11026
  {22,  1,   0}, // #11027
  {24,  1,   0}, // #11028
  {25,  1,   0}, // #11029
  {26,  4,   0}, // #11030
  {25,  3,   0}, // #11031
  {26,  3,   0}, // #11032
  {16,  2,   0}, // #11033
  {24,  2,   0}, // #11034
  {25,  5,   0}, // #11035
  {26,  5,   0}, // #11036
  { 8,  1,   0}, // #11037
  {13,  1,   0}, // #11038
  {15,  1,   0}, // #11039
  {17,  1,   0}, // #11040
  {19,  1,   0}, // #11041
  {21,  1,   0}, // #11042
  {23,  2,   0}, // #11043
  {24,  1,   0}, // #11044
  {25,  2,   0}, // #11045
  {26,  3,   0}, // #11046
  { 8,  1,   0}, // #11047
  {13,  1,   0}, // #11048
  {15,  1,   0}, // #11049
  {17,  1,   0}, // #11050
  {21,  1,   0}, // #11051
  {23,  2,   0}, // #11052
  {24,  1,   0}, // #11053
  {25,  2,   0}, // #11054
  {26,  2,   0}, // #11055
  {13,  2,   0}, // #11056
  {19,  1,   0}, // #11057
  {23,  2,   0}, // #11058
  {25,  2,   0}, // #11059
  {26,  3,   0}, // #11060
  {13,  2,   0}, // #11061
  {23,  2,   0}, // #11062
  {25,  2,   0}, // #11063
  {26,  2,   0}, // #11064
  { 1, 10,   0}, // #11065
  { 3,  1,   0}, // #11066
  {13,  1,   0}, // #11067
  {14,  1,   0}, // #11068
  {15,  1,   0}, // #11069
  {16,  1,   0}, // #11070
  {19,  1,   0}, // #11071
  {23,  1,   0}, // #11072
  {24,  1,   0}, // #11073
  {25,  1,   0}, // #11074
  {26,  2,   0}, // #11075
  { 3,  7,   0}, // #11076
  { 4,  2,   0}, // #11077
  { 8,  8,   0}, // #11078
  { 9,  3,   0}, // #11079
  {13,  9,   0}, // #11080
  {14,  7,   0}, // #11081
  {15, 16,   0}, // #11082
  {16, 10,   0}, // #11083
  {17, 10,   0}, // #11084
  {18,  5,   0}, // #11085
  {21, 11,   0}, // #11086
  {23, 18,   0}, // #11087
  {24, 19,   0}, // #11088
  {25, 32,   0}, // #11089
  {26, 32,   0}, // #11090
  { 1, 10,   0}, // #11091
  { 3,  1,   0}, // #11092
  {13,  1,   0}, // #11093
  {14,  1,   0}, // #11094
  {15,  1,   0}, // #11095
  {16,  1,   0}, // #11096
  {23,  1,   0}, // #11097
  {24,  1,   0}, // #11098
  {25,  1,   0}, // #11099
  {26,  1,   0}, // #11100
  { 2,  4,   0}, // #11101
  { 3,  1,   0}, // #11102
  {13,  1,   0}, // #11103
  {14,  1,   0}, // #11104
  {15,  1,   0}, // #11105
  {16,  1,   0}, // #11106
  {19,  1,   0}, // #11107
  {23,  1,   0}, // #11108
  {24,  1,   0}, // #11109
  {25,  1,   0}, // #11110
  {26,  2,   0}, // #11111
  { 2,  4,   0}, // #11112
  { 3,  1,   0}, // #11113
  {13,  1,   0}, // #11114
  {14,  1,   0}, // #11115
  {15,  1,   0}, // #11116
  {16,  1,   0}, // #11117
  {23,  1,   0}, // #11118
  {24,  1,   0}, // #11119
  {25,  1,   0}, // #11120
  {26,  1,   0}, // #11121
  { 2,  3,   0}, // #11122
  { 3,  1,   0}, // #11123
  {13,  1,   0}, // #11124
  {14,  1,   0}, // #11125
  {15,  1,   0}, // #11126
  {16,  1,   0}, // #11127
  {19,  1,   0}, // #11128
  {23,  1,   0}, // #11129
  {24,  1,   0}, // #11130
  {25,  1,   0}, // #11131
  {26,  2,   0}, // #11132
  { 2,  3,   0}, // #11133
  { 3,  1,   0}, // #11134
  {13,  1,   0}, // #11135
  {14,  1,   0}, // #11136
  {15,  1,   0}, // #11137
  {16,  1,   0}, // #11138
  {23,  1,   0}, // #11139
  {24,  1,   0}, // #11140
  {25,  1,   0}, // #11141
  {26,  1,   0}, // #11142
  { 8,  1,   0}, // #11143
  {15,  1,   0}, // #11144
  {17,  1,   0}, // #11145
  {19,  1,   0}, // #11146
  {21,  1,   0}, // #11147
  {23,  3,   0}, // #11148
  {24,  1,   0}, // #11149
  {25,  3,   0}, // #11150
  {26,  4,   0}, // #11151
  { 8,  1,   0}, // #11152
  {15,  1,   0}, // #11153
  {17,  1,   0}, // #11154
  {21,  1,   0}, // #11155
  {23,  3,   0}, // #11156
  {24,  1,   0}, // #11157
  {25,  3,   0}, // #11158
  {26,  3,   0}, // #11159
  { 8,  1,   0}, // #11160
  {15,  1,   0}, // #11161
  {17,  1,   0}, // #11162
  {19,  1,   0}, // #11163
  {21,  1,   0}, // #11164
  {23,  4,   0}, // #11165
  {24,  1,   0}, // #11166
  {25,  4,   0}, // #11167
  {26,  5,   0}, // #11168
  { 8,  1,   0}, // #11169
  {15,  1,   0}, // #11170
  {17,  1,   0}, // #11171
  {21,  1,   0}, // #11172
  {23,  4,   0}, // #11173
  {24,  1,   0}, // #11174
  {25,  4,   0}, // #11175
  {26,  4,   0}, // #11176
  {17,  1,   0}, // #11177
  {20,  1,   0}, // #11178
  {22,  1,   0}, // #11179
  {23,  1,   0}, // #11180
  {25,  1,   0}, // #11181
  {26,  3,   0}, // #11182
  { 3,  1,   0}, // #11183
  {13,  1,   0}, // #11184
  {14,  1,   0}, // #11185
  {15,  1,   0}, // #11186
  {16,  1,   0}, // #11187
  {17,  1,   0}, // #11188
  {23,  2,   0}, // #11189
  {24,  1,   0}, // #11190
  {25,  2,   0}, // #11191
  {26,  2,   0}, // #11192
  {15,  9,   0}, // #11193
  {23,  9,   0}, // #11194
  {24,  9,   0}, // #11195
  {25, 10,   0}, // #11196
  {26, 10,   0}, // #11197
  {15,  2,   0}, // #11198
  {23,  2,   0}, // #11199
  {24,  2,   0}, // #11200
  {25,  2,   0}, // #11201
  {26,  2,   0}, // #11202
  { 8,  2,   0}, // #11203
  {13,  1,   0}, // #11204
  {15,  2,   0}, // #11205
  {17,  2,   0}, // #11206
  {19,  1,   0}, // #11207
  {21,  2,   0}, // #11208
  {23,  3,   0}, // #11209
  {24,  2,   0}, // #11210
  {25,  3,   0}, // #11211
  {26,  4,   0}, // #11212
  { 8,  2,   0}, // #11213
  {13,  1,   0}, // #11214
  {15,  2,   0}, // #11215
  {17,  2,   0}, // #11216
  {21,  2,   0}, // #11217
  {23,  3,   0}, // #11218
  {24,  2,   0}, // #11219
  {25,  3,   0}, // #11220
  {26,  3,   0}, // #11221
  { 3,  2,   0}, // #11222
  { 8,  4,   0}, // #11223
  {13,  2,   0}, // #11224
  {14,  2,   0}, // #11225
  {15,  6,   0}, // #11226
  {16,  2,   0}, // #11227
  {17,  4,   0}, // #11228
  {19,  1,   0}, // #11229
  {21,  4,   0}, // #11230
  {23,  6,   0}, // #11231
  {24,  6,   0}, // #11232
  {25,  7,   0}, // #11233
  {26,  8,   0}, // #11234
  { 3,  4,   0}, // #11235
  { 4,  2,   0}, // #11236
  { 8,  4,   0}, // #11237
  { 9,  8,   0}, // #11238
  {13,  6,   0}, // #11239
  {14,  4,   0}, // #11240
  {15,  8,   0}, // #11241
  {16, 26,   0}, // #11242
  {17,  6,   0}, // #11243
  {18, 10,   0}, // #11244
  {21, 12,   0}, // #11245
  {23, 10,   0}, // #11246
  {24, 30,   0}, // #11247
  {25, 66,   0}, // #11248
  {26, 66,   0}, // #11249
  { 4,  1,   0}, // #11250
  {13,  1,   0}, // #11251
  {16,  1,   0}, // #11252
  {17,  1,   0}, // #11253
  {18,  1,   0}, // #11254
  {19,  1,   0}, // #11255
  {23,  1,   0}, // #11256
  {24,  1,   0}, // #11257
  {25,  4,   0}, // #11258
  {26,  5,   0}, // #11259
  { 4,  1,   0}, // #11260
  {13,  1,   0}, // #11261
  {16,  1,   0}, // #11262
  {17,  1,   0}, // #11263
  {18,  1,   0}, // #11264
  {23,  1,   0}, // #11265
  {24,  1,   0}, // #11266
  {25,  4,   0}, // #11267
  {26,  4,   0}, // #11268
  { 4,  1,   0}, // #11269
  {13,  1,   0}, // #11270
  {17,  1,   0}, // #11271
  {18,  1,   0}, // #11272
  {19,  1,   0}, // #11273
  {23,  1,   0}, // #11274
  {25,  2,   0}, // #11275
  {26,  3,   0}, // #11276
  { 4,  1,   0}, // #11277
  {13,  1,   0}, // #11278
  {17,  1,   0}, // #11279
  {18,  1,   0}, // #11280
  {23,  1,   0}, // #11281
  {25,  2,   0}, // #11282
  {26,  2,   0}, // #11283
  { 4,  1,   0}, // #11284
  {13,  1,   0}, // #11285
  {16,  1,   0}, // #11286
  {17,  1,   0}, // #11287
  {18,  1,   0}, // #11288
  {19,  1,   0}, // #11289
  {23,  1,   0}, // #11290
  {24,  1,   0}, // #11291
  {25,  3,   0}, // #11292
  {26,  4,   0}, // #11293
  { 4,  1,   0}, // #11294
  {13,  1,   0}, // #11295
  {16,  1,   0}, // #11296
  {17,  1,   0}, // #11297
  {18,  1,   0}, // #11298
  {23,  1,   0}, // #11299
  {24,  1,   0}, // #11300
  {25,  3,   0}, // #11301
  {26,  3,   0}, // #11302
  { 4,  1,   0}, // #11303
  { 8,  1,   0}, // #11304
  {13,  1,   0}, // #11305
  {15,  1,   0}, // #11306
  {17,  2,   0}, // #11307
  {18,  1,   0}, // #11308
  {19,  1,   0}, // #11309
  {21,  1,   0}, // #11310
  {23,  2,   0}, // #11311
  {24,  1,   0}, // #11312
  {25,  2,   0}, // #11313
  {26,  3,   0}, // #11314
  { 4,  1,   0}, // #11315
  { 8,  1,   0}, // #11316
  {13,  1,   0}, // #11317
  {15,  1,   0}, // #11318
  {17,  2,   0}, // #11319
  {18,  1,   0}, // #11320
  {21,  1,   0}, // #11321
  {23,  2,   0}, // #11322
  {24,  1,   0}, // #11323
  {25,  2,   0}, // #11324
  {26,  2,   0}, // #11325
  { 8,  1,   0}, // #11326
  {15,  1,   0}, // #11327
  {17,  1,   0}, // #11328
  {21,  1,   0}, // #11329
  {23,  1,   0}, // #11330
  {24,  1,   0}, // #11331
  {25,  1,   0}, // #11332
  {26,  1,   0}, // #11333
  { 3,  1,   0}, // #11334
  {13,  1,   0}, // #11335
  {14,  1,   0}, // #11336
  {15,  1,   0}, // #11337
  {16,  1,   0}, // #11338
  {19,  1,   0}, // #11339
  {23,  1,   0}, // #11340
  {24,  1,   0}, // #11341
  {25,  2,   0}, // #11342
  {26,  3,   0}, // #11343
  {15,  1,   0}, // #11344
  {19,  1,   0}, // #11345
  {23,  1,   0}, // #11346
  {24,  1,   0}, // #11347
  {25,  1,   0}, // #11348
  {26,  2,   0}, // #11349
  { 8,  1,   0}, // #11350
  {15,  1,   0}, // #11351
  {17,  1,   0}, // #11352
  {19,  1,   0}, // #11353
  {21,  1,   0}, // #11354
  {23,  1,   0}, // #11355
  {24,  1,   0}, // #11356
  {25,  1,   0}, // #11357
  {26,  2,   0}, // #11358
  { 8,  2,   0}, // #11359
  {15,  3,   0}, // #11360
  {17,  2,   0}, // #11361
  {19,  1,   0}, // #11362
  {21,  2,   0}, // #11363
  {23,  3,   0}, // #11364
  {24,  3,   0}, // #11365
  {25,  3,   0}, // #11366
  {26,  4,   0}, // #11367
  { 8,  2,   0}, // #11368
  {15,  3,   0}, // #11369
  {17,  2,   0}, // #11370
  {21,  2,   0}, // #11371
  {23,  3,   0}, // #11372
  {24,  3,   0}, // #11373
  {25,  3,   0}, // #11374
  {26,  3,   0}, // #11375
  { 8,  1,   0}, // #11376
  {15,  1,   0}, // #11377
  {17,  2,   0}, // #11378
  {21,  1,   0}, // #11379
  {23,  2,   0}, // #11380
  {24,  1,   0}, // #11381
  {25,  2,   0}, // #11382
  {26,  2,   0}, // #11383
  { 3,  1,   0}, // #11384
  { 8,  1,   0}, // #11385
  {13,  1,   0}, // #11386
  {14,  1,   0}, // #11387
  {15,  2,   0}, // #11388
  {16,  1,   0}, // #11389
  {17,  1,   0}, // #11390
  {19,  1,   0}, // #11391
  {21,  1,   0}, // #11392
  {23,  2,   0}, // #11393
  {24,  2,   0}, // #11394
  {25,  2,   0}, // #11395
  {26,  3,   0}, // #11396
  { 3,  1,   0}, // #11397
  { 8,  1,   0}, // #11398
  {13,  1,   0}, // #11399
  {14,  1,   0}, // #11400
  {15,  2,   0}, // #11401
  {16,  1,   0}, // #11402
  {17,  1,   0}, // #11403
  {21,  1,   0}, // #11404
  {23,  2,   0}, // #11405
  {24,  2,   0}, // #11406
  {25,  2,   0}, // #11407
  {26,  2,   0}, // #11408
  { 8,  1,   0}, // #11409
  {15,  1,   0}, // #11410
  {17,  2,   0}, // #11411
  {19,  1,   0}, // #11412
  {21,  1,   0}, // #11413
  {23,  2,   0}, // #11414
  {24,  1,   0}, // #11415
  {25,  2,   0}, // #11416
  {26,  3,   0}, // #11417
  { 3,  4,   0}, // #11418
  { 8,  3,   0}, // #11419
  {13,  4,   0}, // #11420
  {14,  4,   0}, // #11421
  {15,  7,   0}, // #11422
  {16,  4,   0}, // #11423
  {17,  3,   0}, // #11424
  {19,  1,   0}, // #11425
  {21,  3,   0}, // #11426
  {23,  7,   0}, // #11427
  {24,  7,   0}, // #11428
  {25,  8,   0}, // #11429
  {26,  9,   0}, // #11430
  { 3,  4,   0}, // #11431
  { 8,  3,   0}, // #11432
  {13,  4,   0}, // #11433
  {14,  4,   0}, // #11434
  {15,  7,   0}, // #11435
  {16,  4,   0}, // #11436
  {17,  3,   0}, // #11437
  {21,  3,   0}, // #11438
  {23,  7,   0}, // #11439
  {24,  7,   0}, // #11440
  {25,  8,   0}, // #11441
  {26,  8,   0}, // #11442
  { 3,  4,   0}, // #11443
  { 8,  3,   0}, // #11444
  {13,  4,   0}, // #11445
  {14,  4,   0}, // #11446
  {15,  7,   0}, // #11447
  {16,  4,   0}, // #11448
  {17,  3,   0}, // #11449
  {19,  1,   0}, // #11450
  {21,  3,   0}, // #11451
  {23,  8,   0}, // #11452
  {24,  7,   0}, // #11453
  {25,  9,   0}, // #11454
  {26, 10,   0}, // #11455
  { 3,  4,   0}, // #11456
  { 8,  3,   0}, // #11457
  {13,  4,   0}, // #11458
  {14,  4,   0}, // #11459
  {15,  7,   0}, // #11460
  {16,  4,   0}, // #11461
  {17,  3,   0}, // #11462
  {21,  3,   0}, // #11463
  {23,  8,   0}, // #11464
  {24,  7,   0}, // #11465
  {25,  9,   0}, // #11466
  {26,  9,   0}, // #11467
  { 3,  3,   0}, // #11468
  {13,  3,   0}, // #11469
  {14,  3,   0}, // #11470
  {15,  3,   0}, // #11471
  {16,  3,   0}, // #11472
  {19,  1,   0}, // #11473
  {23,  3,   0}, // #11474
  {24,  3,   0}, // #11475
  {25,  3,   0}, // #11476
  {26,  4,   0}, // #11477
  { 3,  3,   0}, // #11478
  {13,  3,   0}, // #11479
  {14,  3,   0}, // #11480
  {15,  3,   0}, // #11481
  {16,  3,   0}, // #11482
  {23,  3,   0}, // #11483
  {24,  3,   0}, // #11484
  {25,  3,   0}, // #11485
  {26,  3,   0}, // #11486
  {17,  2,   0}, // #11487
  {19,  1,   0}, // #11488
  {23,  3,   0}, // #11489
  {25,  3,   0}, // #11490
  {26,  4,   0}, // #11491
  {17,  2,   0}, // #11492
  {23,  3,   0}, // #11493
  {25,  3,   0}, // #11494
  {26,  3,   0}, // #11495
  {19,  1,   0}, // #11496
  {20,  1,   0}, // #11497
  {22,  1,   0}, // #11498
  {26,  3,   0}, // #11499
  {13,  1,   0}, // #11500
  {17,  1,   0}, // #11501
  {23,  2,   0}, // #11502
  {25,  2,   0}, // #11503
  {26,  2,   0}, // #11504
  {16,  2,   0}, // #11505
  {19,  1,   0}, // #11506
  {24,  2,   0}, // #11507
  {25,  2,   0}, // #11508
  {26,  3,   0}, // #11509
  {16,  3,   0}, // #11510
  {19,  1,   0}, // #11511
  {20,  1,   0}, // #11512
  {22,  1,   0}, // #11513
  {24,  3,   0}, // #11514
  {25,  3,   0}, // #11515
  {26,  6,   0}, // #11516
  {16,  6,   0}, // #11517
  {19,  1,   0}, // #11518
  {24,  6,   0}, // #11519
  {25,  6,   0}, // #11520
  {26,  7,   0}, // #11521
  {16,  3,   0}, // #11522
  {24,  3,   0}, // #11523
  {25,  3,   0}, // #11524
  {26,  3,   0}, // #11525
  {16,  1,   0}, // #11526
  {20,  1,   0}, // #11527
  {22,  1,   0}, // #11528
  {24,  1,   0}, // #11529
  {25,  1,   0}, // #11530
  {26,  3,   0}, // #11531
  { 4,  1,   0}, // #11532
  {13,  1,   0}, // #11533
  {16,  2,   0}, // #11534
  {17,  1,   0}, // #11535
  {18,  1,   0}, // #11536
  {19,  1,   0}, // #11537
  {22,  1,   0}, // #11538
  {23,  1,   0}, // #11539
  {24,  2,   0}, // #11540
  {25,  4,   0}, // #11541
  {26,  6,   0}, // #11542
  { 4,  1,   0}, // #11543
  {13,  1,   0}, // #11544
  {17,  1,   0}, // #11545
  {18,  1,   0}, // #11546
  {19,  1,   0}, // #11547
  {22,  1,   0}, // #11548
  {23,  1,   0}, // #11549
  {25,  2,   0}, // #11550
  {26,  4,   0}, // #11551
  { 4,  1,   0}, // #11552
  {13,  1,   0}, // #11553
  {16,  2,   0}, // #11554
  {17,  1,   0}, // #11555
  {18,  1,   0}, // #11556
  {23,  1,   0}, // #11557
  {24,  2,   0}, // #11558
  {25,  4,   0}, // #11559
  {26,  4,   0}, // #11560
  { 2,  6,   0}, // #11561
  { 3,  1,   0}, // #11562
  {13,  1,   0}, // #11563
  {14,  1,   0}, // #11564
  {15,  1,   0}, // #11565
  {16,  1,   0}, // #11566
  {19,  1,   0}, // #11567
  {23,  1,   0}, // #11568
  {24,  1,   0}, // #11569
  {25,  1,   0}, // #11570
  {26,  2,   0}, // #11571
  { 2,  6,   0}, // #11572
  { 3,  1,   0}, // #11573
  {13,  1,   0}, // #11574
  {14,  1,   0}, // #11575
  {15,  1,   0}, // #11576
  {16,  1,   0}, // #11577
  {23,  1,   0}, // #11578
  {24,  1,   0}, // #11579
  {25,  1,   0}, // #11580
  {26,  1,   0}, // #11581
  { 2,  7,   0}, // #11582
  { 3,  1,   0}, // #11583
  {13,  1,   0}, // #11584
  {14,  1,   0}, // #11585
  {15,  1,   0}, // #11586
  {16,  1,   0}, // #11587
  {23,  1,   0}, // #11588
  {24,  1,   0}, // #11589
  {25,  1,   0}, // #11590
  {26,  1,   0}, // #11591
  { 8,  1,   0}, // #11592
  {15,  1,   0}, // #11593
  {17,  1,   0}, // #11594
  {20,  1,   0}, // #11595
  {21,  1,   0}, // #11596
  {22,  1,   0}, // #11597
  {23,  1,   0}, // #11598
  {24,  1,   0}, // #11599
  {25,  1,   0}, // #11600
  {26,  3,   0}, // #11601
  {15,  2,   0}, // #11602
  {19,  1,   0}, // #11603
  {23,  2,   0}, // #11604
  {24,  2,   0}, // #11605
  {25,  2,   0}, // #11606
  {26,  3,   0}, // #11607
  { 8,  1,   0}, // #11608
  {13,  1,   0}, // #11609
  {15,  1,   0}, // #11610
  {17,  1,   0}, // #11611
  {20,  1,   0}, // #11612
  {21,  1,   0}, // #11613
  {22,  1,   0}, // #11614
  {23,  2,   0}, // #11615
  {24,  1,   0}, // #11616
  {25,  2,   0}, // #11617
  {26,  4,   0}, // #11618
  { 8,  1,   0}, // #11619
  {15,  2,   0}, // #11620
  {17,  1,   0}, // #11621
  {21,  1,   0}, // #11622
  {23,  2,   0}, // #11623
  {24,  2,   0}, // #11624
  {25,  2,   0}, // #11625
  {26,  2,   0}, // #11626
  { 8,  1,   0}, // #11627
  {15,  2,   0}, // #11628
  {17,  1,   0}, // #11629
  {20,  1,   0}, // #11630
  {21,  1,   0}, // #11631
  {22,  1,   0}, // #11632
  {23,  2,   0}, // #11633
  {24,  2,   0}, // #11634
  {25,  2,   0}, // #11635
  {26,  4,   0}, // #11636
  { 2,  5,   0}, // #11637
  { 3,  1,   0}, // #11638
  {13,  1,   0}, // #11639
  {14,  1,   0}, // #11640
  {15,  1,   0}, // #11641
  {16,  1,   0}, // #11642
  {19,  1,   0}, // #11643
  {23,  1,   0}, // #11644
  {24,  1,   0}, // #11645
  {25,  1,   0}, // #11646
  {26,  2,   0}, // #11647
  { 2,  5,   0}, // #11648
  { 3,  1,   0}, // #11649
  {13,  1,   0}, // #11650
  {14,  1,   0}, // #11651
  {15,  1,   0}, // #11652
  {16,  1,   0}, // #11653
  {23,  1,   0}, // #11654
  {24,  1,   0}, // #11655
  {25,  1,   0}, // #11656
  {26,  1,   0}, // #11657
  { 2, 10,   0}, // #11658
  { 3,  2,   0}, // #11659
  { 8,  1,   0}, // #11660
  {13,  2,   0}, // #11661
  {14,  2,   0}, // #11662
  {15,  3,   0}, // #11663
  {16,  2,   0}, // #11664
  {17,  1,   0}, // #11665
  {19,  1,   0}, // #11666
  {21,  1,   0}, // #11667
  {23,  3,   0}, // #11668
  {24,  3,   0}, // #11669
  {25,  3,   0}, // #11670
  {26,  4,   0}, // #11671
  { 2, 10,   0}, // #11672
  { 3,  2,   0}, // #11673
  { 8,  1,   0}, // #11674
  {13,  2,   0}, // #11675
  {14,  2,   0}, // #11676
  {15,  3,   0}, // #11677
  {16,  2,   0}, // #11678
  {17,  1,   0}, // #11679
  {21,  1,   0}, // #11680
  {23,  3,   0}, // #11681
  {24,  3,   0}, // #11682
  {25,  3,   0}, // #11683
  {26,  3,   0}, // #11684
  { 2,  8,   0}, // #11685
  { 3,  1,   0}, // #11686
  {13,  1,   0}, // #11687
  {14,  1,   0}, // #11688
  {15,  1,   0}, // #11689
  {16,  1,   0}, // #11690
  {19,  1,   0}, // #11691
  {23,  1,   0}, // #11692
  {24,  1,   0}, // #11693
  {25,  1,   0}, // #11694
  {26,  2,   0}, // #11695
  { 2,  8,   0}, // #11696
  { 3,  1,   0}, // #11697
  {13,  1,   0}, // #11698
  {14,  1,   0}, // #11699
  {15,  1,   0}, // #11700
  {16,  1,   0}, // #11701
  {23,  1,   0}, // #11702
  {24,  1,   0}, // #11703
  {25,  1,   0}, // #11704
  {26,  1,   0}, // #11705
  { 2, 16,   0}, // #11706
  { 3,  2,   0}, // #11707
  { 8,  1,   0}, // #11708
  {13,  2,   0}, // #11709
  {14,  2,   0}, // #11710
  {15,  3,   0}, // #11711
  {16,  2,   0}, // #11712
  {17,  1,   0}, // #11713
  {19,  1,   0}, // #11714
  {21,  1,   0}, // #11715
  {23,  3,   0}, // #11716
  {24,  3,   0}, // #11717
  {25,  3,   0}, // #11718
  {26,  4,   0}, // #11719
  { 2, 16,   0}, // #11720
  { 3,  2,   0}, // #11721
  { 8,  1,   0}, // #11722
  {13,  2,   0}, // #11723
  {14,  2,   0}, // #11724
  {15,  3,   0}, // #11725
  {16,  2,   0}, // #11726
  {17,  1,   0}, // #11727
  {21,  1,   0}, // #11728
  {23,  3,   0}, // #11729
  {24,  3,   0}, // #11730
  {25,  3,   0}, // #11731
  {26,  3,   0}, // #11732
  { 3,  1,   0}, // #11733
  {13,  1,   0}, // #11734
  {14,  1,   0}, // #11735
  {15,  1,   0}, // #11736
  {16,  1,   0}, // #11737
  {20,  1,   0}, // #11738
  {22,  1,   0}, // #11739
  {23,  1,   0}, // #11740
  {24,  1,   0}, // #11741
  {25,  1,   0}, // #11742
  {26,  3,   0}, // #11743
  { 2, 12,   0}, // #11744
  { 3,  2,   0}, // #11745
  { 8,  1,   0}, // #11746
  {13,  2,   0}, // #11747
  {14,  2,   0}, // #11748
  {15,  3,   0}, // #11749
  {16,  2,   0}, // #11750
  {17,  1,   0}, // #11751
  {19,  1,   0}, // #11752
  {21,  1,   0}, // #11753
  {23,  3,   0}, // #11754
  {24,  3,   0}, // #11755
  {25,  3,   0}, // #11756
  {26,  4,   0}, // #11757
  { 2, 12,   0}, // #11758
  { 3,  2,   0}, // #11759
  { 8,  1,   0}, // #11760
  {13,  2,   0}, // #11761
  {14,  2,   0}, // #11762
  {15,  3,   0}, // #11763
  {16,  2,   0}, // #11764
  {17,  1,   0}, // #11765
  {21,  1,   0}, // #11766
  {23,  3,   0}, // #11767
  {24,  3,   0}, // #11768
  {25,  3,   0}, // #11769
  {26,  3,   0}, // #11770
  { 2, 12,   0}, // #11771
  { 3,  1,   0}, // #11772
  {13,  1,   0}, // #11773
  {14,  1,   0}, // #11774
  {15,  1,   0}, // #11775
  {16,  1,   0}, // #11776
  {19,  1,   0}, // #11777
  {23,  1,   0}, // #11778
  {24,  1,   0}, // #11779
  {25,  1,   0}, // #11780
  {26,  2,   0}, // #11781
  { 2, 12,   0}, // #11782
  { 3,  1,   0}, // #11783
  {13,  1,   0}, // #11784
  {14,  1,   0}, // #11785
  {15,  1,   0}, // #11786
  {16,  1,   0}, // #11787
  {23,  1,   0}, // #11788
  {24,  1,   0}, // #11789
  {25,  1,   0}, // #11790
  {26,  1,   0}, // #11791
  { 2, 24,   0}, // #11792
  { 3,  2,   0}, // #11793
  { 8,  1,   0}, // #11794
  {13,  2,   0}, // #11795
  {14,  2,   0}, // #11796
  {15,  3,   0}, // #11797
  {16,  2,   0}, // #11798
  {17,  1,   0}, // #11799
  {19,  1,   0}, // #11800
  {21,  1,   0}, // #11801
  {23,  3,   0}, // #11802
  {24,  3,   0}, // #11803
  {25,  3,   0}, // #11804
  {26,  4,   0}, // #11805
  { 2, 24,   0}, // #11806
  { 3,  2,   0}, // #11807
  { 8,  1,   0}, // #11808
  {13,  2,   0}, // #11809
  {14,  2,   0}, // #11810
  {15,  3,   0}, // #11811
  {16,  2,   0}, // #11812
  {17,  1,   0}, // #11813
  {21,  1,   0}, // #11814
  {23,  3,   0}, // #11815
  {24,  3,   0}, // #11816
  {25,  3,   0}, // #11817
  {26,  3,   0}, // #11818
  {16,  1,   0}, // #11819
  {19,  1,   0}, // #11820
  {22,  1,   0}, // #11821
  {24,  1,   0}, // #11822
  {25,  3,   0}, // #11823
  {26,  5,   0}, // #11824
  { 4,  2,   0}, // #11825
  {13,  2,   0}, // #11826
  {16,  4,   0}, // #11827
  {17,  3,   0}, // #11828
  {18,  2,   0}, // #11829
  {19,  1,   0}, // #11830
  {22,  1,   0}, // #11831
  {23,  3,   0}, // #11832
  {24,  4,   0}, // #11833
  {25,  9,   0}, // #11834
  {26, 11,   0}, // #11835
  { 8,  2,   0}, // #11836
  {15,  2,   0}, // #11837
  {17,  2,   0}, // #11838
  {21,  2,   0}, // #11839
  {23,  2,   0}, // #11840
  {24,  2,   0}, // #11841
  {25,  2,   0}, // #11842
  {26,  2,   0}, // #11843
  { 3,  2,   0}, // #11844
  { 4,  1,   0}, // #11845
  { 8,  2,   0}, // #11846
  { 9,  4,   0}, // #11847
  {13,  3,   0}, // #11848
  {14,  2,   0}, // #11849
  {15,  6,   0}, // #11850
  {16,  6,   0}, // #11851
  {17,  3,   0}, // #11852
  {18,  5,   0}, // #11853
  {21,  6,   0}, // #11854
  {23,  7,   0}, // #11855
  {24, 10,   0}, // #11856
  {25, 15,   0}, // #11857
  {26, 15,   0}, // #11858
  { 3,  1,   0}, // #11859
  { 8,  1,   0}, // #11860
  {13,  2,   0}, // #11861
  {14,  1,   0}, // #11862
  {15,  2,   0}, // #11863
  {16,  1,   0}, // #11864
  {17,  1,   0}, // #11865
  {21,  1,   0}, // #11866
  {23,  3,   0}, // #11867
  {24,  2,   0}, // #11868
  {25,  3,   0}, // #11869
  {26,  3,   0}, // #11870
  {19,  1,   0}, // #11871
  {25,  2,   0}, // #11872
  {26,  3,   0}, // #11873
  { 9,  1,   0}, // #11874
  {16,  1,   0}, // #11875
  {18,  1,   0}, // #11876
  {21,  1,   0}, // #11877
  {24,  1,   0}, // #11878
  {25,  3,   0}, // #11879
  {26,  3,   0}, // #11880
  { 9,  1,   0}, // #11881
  {16,  2,   0}, // #11882
  {18,  1,   0}, // #11883
  {19,  1,   0}, // #11884
  {20,  1,   0}, // #11885
  {21,  1,   0}, // #11886
  {22,  1,   0}, // #11887
  {24,  2,   0}, // #11888
  {25,  5,   0}, // #11889
  {26,  8,   0}, // #11890
  {16,  1,   0}, // #11891
  {24,  1,   0}, // #11892
  {25,  2,   0}, // #11893
  {26,  2,   0}, // #11894
  { 3,  1,   0}, // #11895
  {13,  1,   0}, // #11896
  {14,  1,   0}, // #11897
  {15,  2,   0}, // #11898
  {16,  1,   0}, // #11899
  {19,  1,   0}, // #11900
  {23,  2,   0}, // #11901
  {24,  2,   0}, // #11902
  {25,  2,   0}, // #11903
  {26,  3,   0}, // #11904
  {16,  2,   0}, // #11905
  {24,  2,   0}, // #11906
  {25, 11,   0}, // #11907
  {26, 11,   0}, // #11908
  { 9,  1,   0}, // #11909
  {16,  1,   0}, // #11910
  {18,  1,   0}, // #11911
  {20,  1,   0}, // #11912
  {21,  1,   0}, // #11913
  {22,  1,   0}, // #11914
  {24,  1,   0}, // #11915
  {25,  1,   0}, // #11916
  {26,  3,   0}, // #11917
  { 9,  1,   0}, // #11918
  {16,  1,   0}, // #11919
  {18,  1,   0}, // #11920
  {21,  1,   0}, // #11921
  {24,  1,   0}, // #11922
  {25,  4,   0}, // #11923
  {26,  4,   0}, // #11924
  {16,  4,   0}, // #11925
  {17,  2,   0}, // #11926
  {19,  1,   0}, // #11927
  {20,  1,   0}, // #11928
  {22,  1,   0}, // #11929
  {23,  2,   0}, // #11930
  {24,  4,   0}, // #11931
  {25, 11,   0}, // #11932
  {26, 14,   0}, // #11933
  { 9,  1,   0}, // #11934
  {16,  4,   0}, // #11935
  {17,  1,   0}, // #11936
  {18,  1,   0}, // #11937
  {21,  1,   0}, // #11938
  {23,  1,   0}, // #11939
  {24,  4,   0}, // #11940
  {25,  7,   0}, // #11941
  {26,  7,   0}, // #11942
  { 9,  1,   0}, // #11943
  {16,  1,   0}, // #11944
  {18,  1,   0}, // #11945
  {21,  1,   0}, // #11946
  {24,  1,   0}, // #11947
  {25,  6,   0}, // #11948
  {26,  6,   0}, // #11949
  { 3,  2,   0}, // #11950
  { 8,  4,   0}, // #11951
  {13,  2,   0}, // #11952
  {14,  2,   0}, // #11953
  {15,  6,   0}, // #11954
  {16,  6,   0}, // #11955
  {17,  4,   0}, // #11956
  {19,  1,   0}, // #11957
  {20,  1,   0}, // #11958
  {21,  4,   0}, // #11959
  {22,  1,   0}, // #11960
  {23,  6,   0}, // #11961
  {24, 10,   0}, // #11962
  {25, 16,   0}, // #11963
  {26, 19,   0}, // #11964
  { 8,  2,   0}, // #11965
  {15,  2,   0}, // #11966
  {17,  2,   0}, // #11967
  {21,  2,   0}, // #11968
  {23,  2,   0}, // #11969
  {24,  2,   0}, // #11970
  {25, 22,   0}, // #11971
  {26, 22,   0}, // #11972
  { 8,  1,   0}, // #11973
  { 9,  2,   0}, // #11974
  {15,  1,   0}, // #11975
  {16,  2,   0}, // #11976
  {17,  1,   0}, // #11977
  {18,  2,   0}, // #11978
  {21,  3,   0}, // #11979
  {23,  1,   0}, // #11980
  {24,  3,   0}, // #11981
  {25, 10,   0}, // #11982
  {26, 10,   0}, // #11983
  { 8,  1,   0}, // #11984
  { 9,  1,   0}, // #11985
  {15,  1,   0}, // #11986
  {16,  2,   0}, // #11987
  {17,  1,   0}, // #11988
  {18,  1,   0}, // #11989
  {19,  1,   0}, // #11990
  {20,  1,   0}, // #11991
  {21,  2,   0}, // #11992
  {22,  1,   0}, // #11993
  {23,  1,   0}, // #11994
  {24,  3,   0}, // #11995
  {25,  5,   0}, // #11996
  {26,  8,   0}, // #11997
  { 8,  6,   0}, // #11998
  {15,  9,   0}, // #11999
  {17,  6,   0}, // #12000
  {21,  6,   0}, // #12001
  {23,  9,   0}, // #12002
  {24,  9,   0}, // #12003
  {25, 15,   0}, // #12004
  {26, 15,   0}, // #12005
  { 8,  1,   0}, // #12006
  { 9,  5,   0}, // #12007
  {15,  1,   0}, // #12008
  {16,  9,   0}, // #12009
  {17,  1,   0}, // #12010
  {18,  5,   0}, // #12011
  {19,  2,   0}, // #12012
  {21,  6,   0}, // #12013
  {22,  1,   0}, // #12014
  {23,  1,   0}, // #12015
  {24, 10,   0}, // #12016
  {25, 20,   0}, // #12017
  {26, 23,   0}, // #12018
  { 8,  1,   0}, // #12019
  { 9,  5,   0}, // #12020
  {15,  1,   0}, // #12021
  {16,  9,   0}, // #12022
  {17,  1,   0}, // #12023
  {18,  5,   0}, // #12024
  {19,  3,   0}, // #12025
  {21,  6,   0}, // #12026
  {23,  1,   0}, // #12027
  {24, 10,   0}, // #12028
  {25, 20,   0}, // #12029
  {26, 23,   0}, // #12030
  { 8,  1,   0}, // #12031
  { 9,  1,   0}, // #12032
  {15,  1,   0}, // #12033
  {16,  2,   0}, // #12034
  {17,  1,   0}, // #12035
  {18,  1,   0}, // #12036
  {21,  2,   0}, // #12037
  {23,  1,   0}, // #12038
  {24,  3,   0}, // #12039
  {25,  8,   0}, // #12040
  {26,  8,   0}, // #12041
  { 3,  4,   0}, // #12042
  { 9,  2,   0}, // #12043
  {13,  4,   0}, // #12044
  {14,  4,   0}, // #12045
  {15,  5,   0}, // #12046
  {16,  8,   0}, // #12047
  {17,  1,   0}, // #12048
  {18,  2,   0}, // #12049
  {19, 33,   0}, // #12050
  {21,  2,   0}, // #12051
  {23,  6,   0}, // #12052
  {24,  9,   0}, // #12053
  {25, 57,   0}, // #12054
  {26, 90,   0}, // #12055
  { 9,  1,   0}, // #12056
  {16,  1,   0}, // #12057
  {18,  1,   0}, // #12058
  {19,  1,   0}, // #12059
  {21,  1,   0}, // #12060
  {24,  1,   0}, // #12061
  {25,  2,   0}, // #12062
  {26,  3,   0}, // #12063
  { 3,  1,   0}, // #12064
  {13,  1,   0}, // #12065
  {14,  1,   0}, // #12066
  {15,  1,   0}, // #12067
  {16,  1,   0}, // #12068
  {23,  1,   0}, // #12069
  {24,  1,   0}, // #12070
  {25,  2,   0}, // #12071
  {26,  2,   0}, // #12072
  {16,  1,   0}, // #12073
  {24,  1,   0}, // #12074
  {25,  3,   0}, // #12075
  {26,  3,   0}, // #12076
  { 4,  2,   0}, // #12077
  {13,  2,   0}, // #12078
  {16,  3,   0}, // #12079
  {17,  2,   0}, // #12080
  {18,  2,   0}, // #12081
  {23,  2,   0}, // #12082
  {24,  3,   0}, // #12083
  {25,  7,   0}, // #12084
  {26,  7,   0}, // #12085
  {20,  1,   0}, // #12086
  {22,  1,   0}, // #12087
  {25,  1,   0}, // #12088
  {26,  3,   0}, // #12089
  {16,  1,   0}, // #12090
  {20,  1,   0}, // #12091
  {22,  1,   0}, // #12092
  {24,  1,   0}, // #12093
  {25,  2,   0}, // #12094
  {26,  4,   0}, // #12095
  { 9,  1,   0}, // #12096
  {16,  1,   0}, // #12097
  {18,  1,   0}, // #12098
  {20,  1,   0}, // #12099
  {21,  1,   0}, // #12100
  {22,  1,   0}, // #12101
  {24,  1,   0}, // #12102
  {25,  2,   0}, // #12103
  {26,  4,   0}, // #12104
  {20,  1,   0}, // #12105
  {22,  1,   0}, // #12106
  {25,  4,   0}, // #12107
  {26,  6,   0}, // #12108
  { 9,  1,   0}, // #12109
  {16,  1,   0}, // #12110
  {18,  1,   0}, // #12111
  {21,  1,   0}, // #12112
  {24,  1,   0}, // #12113
  {25,  2,   0}, // #12114
  {26,  2,   0}, // #12115
  { 9,  1,   0}, // #12116
  {16,  1,   0}, // #12117
  {18,  1,   0}, // #12118
  {19,  1,   0}, // #12119
  {21,  1,   0}, // #12120
  {24,  1,   0}, // #12121
  {25,  1,   0}, // #12122
  {26,  2,   0}, // #12123
  { 4,  1,   0}, // #12124
  { 9,  1,   0}, // #12125
  {13,  1,   0}, // #12126
  {16,  2,   0}, // #12127
  {17,  1,   0}, // #12128
  {18,  2,   0}, // #12129
  {21,  1,   0}, // #12130
  {23,  1,   0}, // #12131
  {24,  2,   0}, // #12132
  {25,  4,   0}, // #12133
  {26,  4,   0}, // #12134
  { 9,  1,   0}, // #12135
  {16,  1,   0}, // #12136
  {18,  1,   0}, // #12137
  {19,  1,   0}, // #12138
  {20,  1,   0}, // #12139
  {21,  1,   0}, // #12140
  {22,  1,   0}, // #12141
  {24,  1,   0}, // #12142
  {25,  2,   0}, // #12143
  {26,  5,   0}, // #12144
  {16,  2,   0}, // #12145
  {19,  1,   0}, // #12146
  {20,  1,   0}, // #12147
  {22,  1,   0}, // #12148
  {24,  2,   0}, // #12149
  {25,  2,   0}, // #12150
  {26,  5,   0}, // #12151
  {19,  1,   0}, // #12152
  {20,  1,   0}, // #12153
  {22,  1,   0}, // #12154
  {25,  2,   0}, // #12155
  {26,  5,   0}, // #12156
  { 8,  2,   0}, // #12157
  {15,  2,   0}, // #12158
  {17,  2,   0}, // #12159
  {19,  1,   0}, // #12160
  {21,  2,   0}, // #12161
  {23,  2,   0}, // #12162
  {24,  2,   0}, // #12163
  {25,  2,   0}, // #12164
  {26,  3,   0}, // #12165
  { 4,  1,   0}, // #12166
  { 9,  5,   0}, // #12167
  {13,  1,   0}, // #12168
  {15,  4,   0}, // #12169
  {16,  5,   0}, // #12170
  {17,  1,   0}, // #12171
  {18,  6,   0}, // #12172
  {21,  5,   0}, // #12173
  {23,  5,   0}, // #12174
  {24,  9,   0}, // #12175
  {25, 10,   0}, // #12176
  {26, 10,   0}, // #12177
  { 9,  1,   0}, // #12178
  {16,  1,   0}, // #12179
  {18,  1,   0}, // #12180
  {21,  1,   0}, // #12181
  {24,  1,   0}, // #12182
  {25,  1,   0}, // #12183
  {26,  1,   0}, // #12184
  {16,  2,   0}, // #12185
  {24,  2,   0}, // #12186
  {25,  2,   0}, // #12187
  {26,  2,   0}, // #12188
  { 4,  1,   0}, // #12189
  { 9,  1,   0}, // #12190
  {13,  1,   0}, // #12191
  {16,  1,   0}, // #12192
  {17,  1,   0}, // #12193
  {18,  2,   0}, // #12194
  {21,  1,   0}, // #12195
  {23,  1,   0}, // #12196
  {24,  1,   0}, // #12197
  {25,  4,   0}, // #12198
  {26,  4,   0}, // #12199
  { 4,  1,   0}, // #12200
  { 9,  2,   0}, // #12201
  {13,  1,   0}, // #12202
  {16,  2,   0}, // #12203
  {17,  1,   0}, // #12204
  {18,  3,   0}, // #12205
  {19,  1,   0}, // #12206
  {21,  2,   0}, // #12207
  {23,  1,   0}, // #12208
  {24,  2,   0}, // #12209
  {25,  4,   0}, // #12210
  {26,  5,   0}, // #12211
  { 4,  1,   0}, // #12212
  { 9,  1,   0}, // #12213
  {13,  1,   0}, // #12214
  {16,  2,   0}, // #12215
  {17,  1,   0}, // #12216
  {18,  2,   0}, // #12217
  {21,  1,   0}, // #12218
  {23,  1,   0}, // #12219
  {24,  2,   0}, // #12220
  {25,  3,   0}, // #12221
  {26,  3,   0}, // #12222
  {16,  1,   0}, // #12223
  {24,  1,   0}, // #12224
  {25,  5,   0}, // #12225
  {26,  5,   0}, // #12226
  { 4,  1,   0}, // #12227
  {13,  1,   0}, // #12228
  {16,  5,   0}, // #12229
  {17,  2,   0}, // #12230
  {18,  1,   0}, // #12231
  {19,  1,   0}, // #12232
  {22,  1,   0}, // #12233
  {23,  2,   0}, // #12234
  {24,  5,   0}, // #12235
  {25,  8,   0}, // #12236
  {26, 10,   0}, // #12237
  { 4,  1,   0}, // #12238
  {13,  1,   0}, // #12239
  {16,  5,   0}, // #12240
  {17,  2,   0}, // #12241
  {18,  1,   0}, // #12242
  {23,  2,   0}, // #12243
  {24,  5,   0}, // #12244
  {25,  9,   0}, // #12245
  {26,  9,   0}, // #12246
  { 4,  2,   0}, // #12247
  {13,  2,   0}, // #12248
  {16,  4,   0}, // #12249
  {17,  3,   0}, // #12250
  {18,  2,   0}, // #12251
  {23,  3,   0}, // #12252
  {24,  4,   0}, // #12253
  {25, 10,   0}, // #12254
  {26, 10,   0}, // #12255
  { 4,  1,   0}, // #12256
  { 9,  8,   0}, // #12257
  {13,  1,   0}, // #12258
  {16,  8,   0}, // #12259
  {17,  1,   0}, // #12260
  {18,  9,   0}, // #12261
  {19,  1,   0}, // #12262
  {21,  8,   0}, // #12263
  {23,  1,   0}, // #12264
  {24,  8,   0}, // #12265
  {25, 30,   0}, // #12266
  {26, 31,   0}, // #12267
  { 9, 10,   0}, // #12268
  {16, 10,   0}, // #12269
  {18, 10,   0}, // #12270
  {19,  1,   0}, // #12271
  {20,  1,   0}, // #12272
  {21, 10,   0}, // #12273
  {22,  1,   0}, // #12274
  {24, 10,   0}, // #12275
  {25, 36,   0}, // #12276
  {26, 39,   0}, // #12277
  { 9, 11,   0}, // #12278
  {16, 11,   0}, // #12279
  {18, 11,   0}, // #12280
  {19,  1,   0}, // #12281
  {20,  1,   0}, // #12282
  {21, 11,   0}, // #12283
  {22,  1,   0}, // #12284
  {24, 11,   0}, // #12285
  {25, 37,   0}, // #12286
  {26, 40,   0}, // #12287
  { 4,  1,   0}, // #12288
  { 8,  2,   0}, // #12289
  { 9,  3,   0}, // #12290
  {13,  1,   0}, // #12291
  {15,  2,   0}, // #12292
  {16,  3,   0}, // #12293
  {17,  4,   0}, // #12294
  {18,  4,   0}, // #12295
  {19,  1,   0}, // #12296
  {20,  1,   0}, // #12297
  {21,  5,   0}, // #12298
  {22,  1,   0}, // #12299
  {23,  4,   0}, // #12300
  {24,  5,   0}, // #12301
  {25, 15,   0}, // #12302
  {26, 18,   0}, // #12303
  { 3,  2,   0}, // #12304
  {13,  2,   0}, // #12305
  {14,  2,   0}, // #12306
  {15,  7,   0}, // #12307
  {16, 12,   0}, // #12308
  {19,  8,   0}, // #12309
  {23,  7,   0}, // #12310
  {24, 17,   0}, // #12311
  {25, 56,   0}, // #12312
  {26, 64,   0}, // #12313
  { 3,  4,   0}, // #12314
  { 9,  4,   0}, // #12315
  {13,  4,   0}, // #12316
  {14,  4,   0}, // #12317
  {15,  5,   0}, // #12318
  {16, 10,   0}, // #12319
  {17,  1,   0}, // #12320
  {18,  4,   0}, // #12321
  {19, 31,   0}, // #12322
  {21,  4,   0}, // #12323
  {23,  6,   0}, // #12324
  {24, 11,   0}, // #12325
  {25, 57,   0}, // #12326
  {26, 88,   0}, // #12327
  { 3,  9,   0}, // #12328
  { 4,  1,   0}, // #12329
  { 8, 16,   0}, // #12330
  { 9,  1,   0}, // #12331
  {13, 10,   0}, // #12332
  {14,  9,   0}, // #12333
  {15, 25,   0}, // #12334
  {16, 31,   0}, // #12335
  {17, 17,   0}, // #12336
  {18,  2,   0}, // #12337
  {20, 11,   0}, // #12338
  {21, 17,   0}, // #12339
  {22, 11,   0}, // #12340
  {23, 26,   0}, // #12341
  {24, 47,   0}, // #12342
  {25, 78,   0}, // #12343
  {26, 100,   0}, // #12344
  { 3,  1,   0}, // #12345
  { 8,  1,   0}, // #12346
  {13,  1,   0}, // #12347
  {14,  1,   0}, // #12348
  {15,  2,   0}, // #12349
  {16,  1,   0}, // #12350
  {17,  1,   0}, // #12351
  {19,  2,   0}, // #12352
  {21,  1,   0}, // #12353
  {23,  3,   0}, // #12354
  {24,  2,   0}, // #12355
  {25,  3,   0}, // #12356
  {26,  5,   0}, // #12357
  { 3,  1,   0}, // #12358
  { 8,  1,   0}, // #12359
  {13,  1,   0}, // #12360
  {14,  1,   0}, // #12361
  {15,  2,   0}, // #12362
  {16,  1,   0}, // #12363
  {17,  1,   0}, // #12364
  {19,  4,   0}, // #12365
  {21,  1,   0}, // #12366
  {23,  3,   0}, // #12367
  {24,  2,   0}, // #12368
  {25,  3,   0}, // #12369
  {26,  7,   0}, // #12370
  { 3,  1,   0}, // #12371
  { 8,  1,   0}, // #12372
  {13,  1,   0}, // #12373
  {14,  1,   0}, // #12374
  {15,  2,   0}, // #12375
  {16,  1,   0}, // #12376
  {17,  1,   0}, // #12377
  {19,  8,   0}, // #12378
  {21,  1,   0}, // #12379
  {23,  3,   0}, // #12380
  {24,  2,   0}, // #12381
  {25,  3,   0}, // #12382
  {26, 11,   0}, // #12383
  { 8,  5,   0}, // #12384
  {13,  5,   0}, // #12385
  {15,  5,   0}, // #12386
  {17,  5,   0}, // #12387
  {21,  5,   0}, // #12388
  {23, 14,   0}, // #12389
  {24,  5,   0}, // #12390
  {25, 14,   0}, // #12391
  {26, 14,   0}, // #12392
  { 8,  9,   0}, // #12393
  {13,  7,   0}, // #12394
  {15,  9,   0}, // #12395
  {17,  9,   0}, // #12396
  {21,  9,   0}, // #12397
  {23, 21,   0}, // #12398
  {24,  9,   0}, // #12399
  {25, 21,   0}, // #12400
  {26, 21,   0}, // #12401
  { 8, 17,   0}, // #12402
  {13, 11,   0}, // #12403
  {15, 17,   0}, // #12404
  {17, 17,   0}, // #12405
  {21, 17,   0}, // #12406
  {23, 35,   0}, // #12407
  {24, 17,   0}, // #12408
  {25, 35,   0}, // #12409
  {26, 35,   0}, // #12410
  { 3,  1,   0}, // #12411
  { 8,  2,   0}, // #12412
  {13,  1,   0}, // #12413
  {14,  1,   0}, // #12414
  {15,  3,   0}, // #12415
  {16,  1,   0}, // #12416
  {17,  2,   0}, // #12417
  {21,  2,   0}, // #12418
  {23,  3,   0}, // #12419
  {24,  3,   0}, // #12420
  {25,  3,   0}, // #12421
  {26,  3,   0}, // #12422
  {13,  1,   0}, // #12423
  {17,  2,   0}, // #12424
  {23,  3,   0}, // #12425
  {25,  3,   0}, // #12426
  {26,  3,   0}, // #12427
  { 3,  1,   0}, // #12428
  { 8,  2,   0}, // #12429
  {13,  1,   0}, // #12430
  {14,  1,   0}, // #12431
  {15,  3,   0}, // #12432
  {16,  1,   0}, // #12433
  {17,  2,   0}, // #12434
  {19,  1,   0}, // #12435
  {21,  2,   0}, // #12436
  {23,  3,   0}, // #12437
  {24,  3,   0}, // #12438
  {25,  3,   0}, // #12439
  {26,  4,   0}, // #12440
  {13,  1,   0}, // #12441
  {17,  2,   0}, // #12442
  {19,  1,   0}, // #12443
  {23,  3,   0}, // #12444
  {25,  3,   0}, // #12445
  {26,  4,   0}, // #12446
  {17,  1,   0}, // #12447
  {20,  2,   0}, // #12448
  {22,  2,   0}, // #12449
  {23,  1,   0}, // #12450
  {25,  1,   0}, // #12451
  {26,  5,   0}, // #12452
  { 8,  2,   0}, // #12453
  {15,  2,   0}, // #12454
  {17,  2,   0}, // #12455
  {21,  2,   0}, // #12456
  {23,  3,   0}, // #12457
  {24,  2,   0}, // #12458
  {25,  3,   0}, // #12459
  {26,  3,   0}, // #12460
  {13,  1,   0}, // #12461
  {20,  1,   0}, // #12462
  {22,  1,   0}, // #12463
  {23,  1,   0}, // #12464
  {25,  1,   0}, // #12465
  {26,  3,   0}, // #12466
  { 8,  2,   0}, // #12467
  {15,  2,   0}, // #12468
  {17,  2,   0}, // #12469
  {20,  1,   0}, // #12470
  {21,  2,   0}, // #12471
  {22,  1,   0}, // #12472
  {23,  2,   0}, // #12473
  {24,  2,   0}, // #12474
  {25,  2,   0}, // #12475
  {26,  4,   0}, // #12476
  { 8,  1,   0}, // #12477
  {15,  1,   0}, // #12478
  {17,  1,   0}, // #12479
  {19,  1,   0}, // #12480
  {21,  1,   0}, // #12481
  {23,  1,   0}, // #12482
  {24,  1,   0}, // #12483
  {25,  2,   0}, // #12484
  {26,  3,   0}, // #12485
  { 3,  1,   0}, // #12486
  {13,  1,   0}, // #12487
  {14,  1,   0}, // #12488
  {15,  1,   0}, // #12489
  {16,  1,   0}, // #12490
  {20,  2,   0}, // #12491
  {22,  2,   0}, // #12492
  {23,  1,   0}, // #12493
  {24,  1,   0}, // #12494
  {25,  3,   0}, // #12495
  {26,  7,   0}, // #12496
  { 3,  1,   0}, // #12497
  {13,  1,   0}, // #12498
  {14,  1,   0}, // #12499
  {15,  1,   0}, // #12500
  {16,  1,   0}, // #12501
  {20,  4,   0}, // #12502
  {22,  4,   0}, // #12503
  {23,  1,   0}, // #12504
  {24,  1,   0}, // #12505
  {25,  3,   0}, // #12506
  {26, 11,   0}, // #12507
  { 3,  1,   0}, // #12508
  {13,  1,   0}, // #12509
  {14,  1,   0}, // #12510
  {15,  1,   0}, // #12511
  {16,  1,   0}, // #12512
  {20,  8,   0}, // #12513
  {22,  8,   0}, // #12514
  {23,  1,   0}, // #12515
  {24,  1,   0}, // #12516
  {25,  3,   0}, // #12517
  {26, 19,   0}, // #12518
  { 3,  1,   0}, // #12519
  { 8,  1,   0}, // #12520
  {13,  1,   0}, // #12521
  {14,  1,   0}, // #12522
  {15,  2,   0}, // #12523
  {16,  1,   0}, // #12524
  {17,  1,   0}, // #12525
  {20, 16,   0}, // #12526
  {21,  1,   0}, // #12527
  {22, 16,   0}, // #12528
  {23,  2,   0}, // #12529
  {24,  2,   0}, // #12530
  {25,  4,   0}, // #12531
  {26, 36,   0}, // #12532
  { 3,  1,   0}, // #12533
  { 8,  1,   0}, // #12534
  {13,  1,   0}, // #12535
  {14,  1,   0}, // #12536
  {15,  2,   0}, // #12537
  {16,  1,   0}, // #12538
  {17,  1,   0}, // #12539
  {20,  2,   0}, // #12540
  {21,  1,   0}, // #12541
  {22,  2,   0}, // #12542
  {23,  2,   0}, // #12543
  {24,  2,   0}, // #12544
  {25,  4,   0}, // #12545
  {26,  8,   0}, // #12546
  { 3,  1,   0}, // #12547
  { 8,  1,   0}, // #12548
  {13,  1,   0}, // #12549
  {14,  1,   0}, // #12550
  {15,  2,   0}, // #12551
  {16,  1,   0}, // #12552
  {17,  1,   0}, // #12553
  {20,  4,   0}, // #12554
  {21,  1,   0}, // #12555
  {22,  4,   0}, // #12556
  {23,  2,   0}, // #12557
  {24,  2,   0}, // #12558
  {25,  4,   0}, // #12559
  {26, 12,   0}, // #12560
  { 3,  1,   0}, // #12561
  { 8,  1,   0}, // #12562
  {13,  1,   0}, // #12563
  {14,  1,   0}, // #12564
  {15,  2,   0}, // #12565
  {16,  1,   0}, // #12566
  {17,  1,   0}, // #12567
  {20,  8,   0}, // #12568
  {21,  1,   0}, // #12569
  {22,  8,   0}, // #12570
  {23,  2,   0}, // #12571
  {24,  2,   0}, // #12572
  {25,  4,   0}, // #12573
  {26, 20,   0}, // #12574
  { 8,  2,   0}, // #12575
  {15,  2,   0}, // #12576
  {17,  2,   0}, // #12577
  {19,  1,   0}, // #12578
  {21,  2,   0}, // #12579
  {23,  3,   0}, // #12580
  {24,  2,   0}, // #12581
  {25,  3,   0}, // #12582
  {26,  4,   0}, // #12583
  {13,  3,   0}, // #12584
  {23,  3,   0}, // #12585
  {25,  3,   0}, // #12586
  {26,  3,   0}, // #12587
  { 3,  1,   0}, // #12588
  {13,  2,   0}, // #12589
  {14,  1,   0}, // #12590
  {15,  1,   0}, // #12591
  {16,  1,   0}, // #12592
  {19,  1,   0}, // #12593
  {23,  2,   0}, // #12594
  {24,  1,   0}, // #12595
  {25,  2,   0}, // #12596
  {26,  3,   0}, // #12597
  { 4,  1,   0}, // #12598
  { 8,  2,   0}, // #12599
  {13,  3,   0}, // #12600
  {15,  2,   0}, // #12601
  {17,  3,   0}, // #12602
  {18,  1,   0}, // #12603
  {19,  1,   0}, // #12604
  {21,  2,   0}, // #12605
  {23,  7,   0}, // #12606
  {24,  2,   0}, // #12607
  {25,  7,   0}, // #12608
  {26,  8,   0}, // #12609
  {13,  3,   0}, // #12610
  {19,  1,   0}, // #12611
  {23,  3,   0}, // #12612
  {25,  3,   0}, // #12613
  {26,  4,   0}, // #12614
  { 3,  1,   0}, // #12615
  {13,  1,   0}, // #12616
  {14,  1,   0}, // #12617
  {15,  1,   0}, // #12618
  {16,  1,   0}, // #12619
  {19,  2,   0}, // #12620
  {23,  2,   0}, // #12621
  {24,  1,   0}, // #12622
  {25,  3,   0}, // #12623
  {26,  5,   0}, // #12624
  { 3,  1,   0}, // #12625
  {13,  1,   0}, // #12626
  {14,  1,   0}, // #12627
  {15,  1,   0}, // #12628
  {16,  1,   0}, // #12629
  {19,  4,   0}, // #12630
  {23,  2,   0}, // #12631
  {24,  1,   0}, // #12632
  {25,  3,   0}, // #12633
  {26,  7,   0}, // #12634
  { 3,  1,   0}, // #12635
  {13,  1,   0}, // #12636
  {14,  1,   0}, // #12637
  {15,  1,   0}, // #12638
  {16,  1,   0}, // #12639
  {19,  8,   0}, // #12640
  {23,  2,   0}, // #12641
  {24,  1,   0}, // #12642
  {25,  3,   0}, // #12643
  {26, 11,   0}, // #12644
  { 3,  1,   0}, // #12645
  {13,  1,   0}, // #12646
  {14,  1,   0}, // #12647
  {15,  1,   0}, // #12648
  {16,  1,   0}, // #12649
  {19, 16,   0}, // #12650
  {23,  2,   0}, // #12651
  {24,  1,   0}, // #12652
  {25,  3,   0}, // #12653
  {26, 19,   0}, // #12654
  { 8,  5,   0}, // #12655
  {13,  5,   0}, // #12656
  {15,  5,   0}, // #12657
  {17,  5,   0}, // #12658
  {19,  1,   0}, // #12659
  {21,  5,   0}, // #12660
  {23, 14,   0}, // #12661
  {24,  5,   0}, // #12662
  {25, 14,   0}, // #12663
  {26, 15,   0}, // #12664
  { 8,  9,   0}, // #12665
  {13,  7,   0}, // #12666
  {15,  9,   0}, // #12667
  {17,  9,   0}, // #12668
  {19,  1,   0}, // #12669
  {21,  9,   0}, // #12670
  {23, 21,   0}, // #12671
  {24,  9,   0}, // #12672
  {25, 21,   0}, // #12673
  {26, 22,   0}, // #12674
  { 8, 17,   0}, // #12675
  {13, 11,   0}, // #12676
  {15, 17,   0}, // #12677
  {17, 17,   0}, // #12678
  {19,  1,   0}, // #12679
  {21, 17,   0}, // #12680
  {23, 35,   0}, // #12681
  {24, 17,   0}, // #12682
  {25, 35,   0}, // #12683
  {26, 36,   0}, // #12684
  {16,  2,   0}, // #12685
  {20,  1,   0}, // #12686
  {22,  1,   0}, // #12687
  {24,  2,   0}, // #12688
  {25,  2,   0}, // #12689
  {26,  4,   0}, // #12690
  { 3,  1,   0}, // #12691
  {11,  2,   0}, // #12692
  {12,  1,   0}, // #12693
  {13,  1,   0}, // #12694
  {14,  1,   0}, // #12695
  {19,  2,   0}, // #12696
  {20,  1,   0}, // #12697
  {22,  2,   0}, // #12698
  {23,  2,   0}, // #12699
  { 8,  1,   0}, // #12700
  {11,  2,   0}, // #12701
  {13,  1,   0}, // #12702
  {15,  1,   0}, // #12703
  {17,  1,   0}, // #12704
  {18,  1,   0}, // #12705
  {19,  3,   0}, // #12706
  {20,  1,   0}, // #12707
  {21,  1,   0}, // #12708
  {22,  3,   0}, // #12709
  {23,  4,   0}, // #12710
  { 8,  1,   0}, // #12711
  {11,  2,   0}, // #12712
  {13,  1,   0}, // #12713
  {15,  1,   0}, // #12714
  {18,  1,   0}, // #12715
  {19,  3,   0}, // #12716
  {20,  1,   0}, // #12717
  {22,  3,   0}, // #12718
  {23,  3,   0}, // #12719
  {22, 16,   0}, // #12720
  {23, 16,   0}, // #12721
  { 7,  1,   0}, // #12722
  { 9, 11,   0}, // #12723
  {12,  1,   0}, // #12724
  {14, 11,   0}, // #12725
  {16, 11,   0}, // #12726
  {17,  1,   0}, // #12727
  {18, 11,   0}, // #12728
  {20, 11,   0}, // #12729
  {21,  2,   0}, // #12730
  {22, 41,   0}, // #12731
  {23, 44,   0}, // #12732
  {12,  1,   0}, // #12733
  {23,  1,   0}, // #12734
  { 1,  2,   0}, // #12735
  { 5,  1,   0}, // #12736
  {12,  1,   0}, // #12737
  {16,  1,   0}, // #12738
  {19,  1,   0}, // #12739
  {21,  1,   0}, // #12740
  {22,  1,   0}, // #12741
  {23,  1,   0}, // #12742
  { 1,  1,   0}, // #12743
  {12,  1,   0}, // #12744
  {22,  1,   0}, // #12745
  { 1,  1,   0}, // #12746
  {12,  1,   0}, // #12747
  {17,  1,   0}, // #12748
  {23,  1,   0}, // #12749
  { 1,  1,   0}, // #12750
  { 5,  2,   0}, // #12751
  { 1,  1,   0}, // #12752
  { 5, 12,   0}, // #12753
  { 1,  1,   0}, // #12754
  { 5, 16,   0}, // #12755
  { 1,  1,   0}, // #12756
  {12,  2,   0}, // #12757
  {15,  1,   0}, // #12758
  {17,  1,   0}, // #12759
  {18,  1,   0}, // #12760
  {20,  1,   0}, // #12761
  {22,  1,   0}, // #12762
  {23,  1,   0}, // #12763
  { 1,  1,   0}, // #12764
  {12,  1,   0}, // #12765
  {13,  1,   0}, // #12766
  {17,  1,   0}, // #12767
  {18,  1,   0}, // #12768
  {19,  1,   0}, // #12769
  {23,  1,   0}, // #12770
  { 1,  1,   0}, // #12771
  {12,  1,   0}, // #12772
  {16,  1,   0}, // #12773
  {19,  1,   0}, // #12774
  {21,  1,   0}, // #12775
  {22,  1,   0}, // #12776
  {23,  1,   0}, // #12777
  { 1,  1,   0}, // #12778
  {12,  2,   0}, // #12779
  {16,  2,   0}, // #12780
  {19,  2,   0}, // #12781
  {21,  2,   0}, // #12782
  {22,  2,   0}, // #12783
  {23,  2,   0}, // #12784
  { 1,  1,   0}, // #12785
  { 5,  1,   0}, // #12786
  { 8,  1,   0}, // #12787
  {11, 17,   0}, // #12788
  { 1,  1,   0}, // #12789
  { 5,  1,   0}, // #12790
  { 8,  1,   0}, // #12791
  {11, 25,   0}, // #12792
  { 1,  1,   0}, // #12793
  { 5,  1,   0}, // #12794
  { 8,  1,   0}, // #12795
  {11, 41,   0}, // #12796
  { 1,  1,   0}, // #12797
  { 5,  1,   0}, // #12798
  { 8,  1,   0}, // #12799
  {11, 15,   0}, // #12800
  { 1,  1,   0}, // #12801
  {12,  6,   0}, // #12802
  {16,  6,   0}, // #12803
  {19,  6,   0}, // #12804
  {21,  6,   0}, // #12805
  {22,  6,   0}, // #12806
  {23,  6,   0}, // #12807
  { 1,  1,   0}, // #12808
  {12,  5,   0}, // #12809
  {16,  5,   0}, // #12810
  {19,  5,   0}, // #12811
  {21,  5,   0}, // #12812
  {22,  5,   0}, // #12813
  {23,  5,   0}, // #12814
  { 1,  1,   0}, // #12815
  {12,  5,   0}, // #12816
  {15,  3,   0}, // #12817
  {18,  3,   0}, // #12818
  {20,  5,   0}, // #12819
  {22,  3,   0}, // #12820
  {12,  3,   0}, // #12821
  {15,  2,   0}, // #12822
  {18,  2,   0}, // #12823
  {20,  3,   0}, // #12824
  {22,  2,   0}, // #12825
  { 1,  1,   0}, // #12826
  {12,  1,   0}, // #12827
  {23,  1,   0}, // #12828
  { 1,  1,   0}, // #12829
  { 5,  1,   0}, // #12830
  { 7,  1,   0}, // #12831
  {24,  1,   0}, // #12832
  { 1,  1,   0}, // #12833
  {12,  1,   0}, // #12834
  {20,  1,   0}, // #12835
  { 1,  1,   0}, // #12836
  {12,  1,   0}, // #12837
  {21,  1,   0}, // #12838
  {23,  1,   0}, // #12839
  {12,  1,   0}, // #12840
  {15,  1,   0}, // #12841
  {18,  1,   0}, // #12842
  {20,  1,   0}, // #12843
  {22,  1,   0}, // #12844
  { 1,  1,   0}, // #12845
  {12,  1,   0}, // #12846
  {15,  1,   0}, // #12847
  {18,  1,   0}, // #12848
  {20,  1,   0}, // #12849
  {22,  1,   0}, // #12850
  { 1,  1,   0}, // #12851
  { 5,  1,   0}, // #12852
  { 7,  1,   0}, // #12853
  {24,  2,   0}, // #12854
  { 1,  1,   0}, // #12855
  {12,  2,   0}, // #12856
  {13,  2,   0}, // #12857
  {17,  2,   0}, // #12858
  {18,  2,   0}, // #12859
  {19,  2,   0}, // #12860
  {23,  2,   0}, // #12861
  { 1,  1,   0}, // #12862
  {12,  2,   0}, // #12863
  {20,  2,   0}, // #12864
  { 1,  1,   0}, // #12865
  {12, 10,   0}, // #12866
  {16, 10,   0}, // #12867
  {19, 10,   0}, // #12868
  {21, 10,   0}, // #12869
  {22, 10,   0}, // #12870
  {23, 10,   0}, // #12871
  { 1,  1,   0}, // #12872
  {12,  7,   0}, // #12873
  {16,  7,   0}, // #12874
  {19,  7,   0}, // #12875
  {21,  7,   0}, // #12876
  {22,  7,   0}, // #12877
  {23,  7,   0}, // #12878
  {12, 20,   0}, // #12879
  {16, 20,   0}, // #12880
  {19, 20,   0}, // #12881
  {21, 20,   0}, // #12882
  {22, 20,   0}, // #12883
  {23, 20,   0}, // #12884
  { 1,  1,   0}, // #12885
  {12,  2,   0}, // #12886
  {17,  2,   0}, // #12887
  {23,  2,   0}, // #12888
  {12,  2,   0}, // #12889
  {15,  2,   0}, // #12890
  {18,  2,   0}, // #12891
  {20,  2,   0}, // #12892
  {22,  2,   0}, // #12893
  { 1,  1,   0}, // #12894
  {12,  2,   0}, // #12895
  {14,  2,   0}, // #12896
  {17,  2,   0}, // #12897
  {20,  2,   0}, // #12898
  {21,  2,   0}, // #12899
  {23,  2,   0}, // #12900
  {12,  2,   0}, // #12901
  {16,  1,   0}, // #12902
  {19,  1,   0}, // #12903
  {20,  1,   0}, // #12904
  {21,  1,   0}, // #12905
  {22,  1,   0}, // #12906
  {23,  1,   0}, // #12907
  { 1,  1,   0}, // #12908
  {12,  2,   0}, // #12909
  {16,  1,   0}, // #12910
  {19,  1,   0}, // #12911
  {20,  1,   0}, // #12912
  {21,  1,   0}, // #12913
  {22,  1,   0}, // #12914
  {23,  1,   0}, // #12915
  { 1,  1,   0}, // #12916
  {12,  1,   0}, // #12917
  {18,  1,   0}, // #12918
  { 1,  5,   0}, // #12919
  {12,  3,   0}, // #12920
  {15,  2,   0}, // #12921
  {18,  2,   0}, // #12922
  {20,  3,   0}, // #12923
  {22,  2,   0}, // #12924
  { 1,  1,   0}, // #12925
  {12,  1,   0}, // #12926
  {19,  1,   0}, // #12927
  {23,  1,   0}, // #12928
  { 1,  1,   0}, // #12929
  {12,  3,   0}, // #12930
  {19,  3,   0}, // #12931
  {23,  3,   0}, // #12932
  { 1,  1,   0}, // #12933
  {12,  3,   0}, // #12934
  {17,  3,   0}, // #12935
  {23,  3,   0}, // #12936
  { 1,  1,   0}, // #12937
  { 5,  1,   0}, // #12938
  {10,  1,   0}, // #12939
  {12,  2,   0}, // #12940
  {16,  1,   0}, // #12941
  {19,  1,   0}, // #12942
  {21,  1,   0}, // #12943
  {22,  1,   0}, // #12944
  {23,  2,   0}, // #12945
  {12,  2,   0}, // #12946
  {15,  1,   0}, // #12947
  {16,  1,   0}, // #12948
  {18,  1,   0}, // #12949
  {19,  1,   0}, // #12950
  {20,  1,   0}, // #12951
  {21,  1,   0}, // #12952
  {22,  2,   0}, // #12953
  {23,  1,   0}, // #12954
  { 1,  1,   0}, // #12955
  {12,  2,   0}, // #12956
  {15,  1,   0}, // #12957
  {16,  1,   0}, // #12958
  {18,  1,   0}, // #12959
  {19,  1,   0}, // #12960
  {20,  1,   0}, // #12961
  {21,  1,   0}, // #12962
  {22,  2,   0}, // #12963
  {23,  1,   0}, // #12964
  {12,  2,   0}, // #12965
  {15,  1,   0}, // #12966
  {18,  1,   0}, // #12967
  {20,  2,   0}, // #12968
  {22,  1,   0}, // #12969
  {12,  2,   0}, // #12970
  {14,  1,   0}, // #12971
  {17,  1,   0}, // #12972
  {19,  1,   0}, // #12973
  {20,  1,   0}, // #12974
  {21,  1,   0}, // #12975
  {23,  2,   0}, // #12976
  {12,  1,   0}, // #12977
  {14,  1,   0}, // #12978
  {17,  1,   0}, // #12979
  {20,  1,   0}, // #12980
  {21,  1,   0}, // #12981
  {23,  1,   0}, // #12982
  { 1,  1,   0}, // #12983
  {12,  1,   0}, // #12984
  {14,  1,   0}, // #12985
  {17,  1,   0}, // #12986
  {20,  1,   0}, // #12987
  {21,  1,   0}, // #12988
  {23,  1,   0}, // #12989
  {11,  1,   0}, // #12990
  {36,  1,   0}, // #12991
  {11,  0,   0}, // #12992
  {36,  0,   0}, // #12993
  {14,  1,   0}, // #12994
  {25,  1,   0}, // #12995
  {28,  1,   0}, // #12996
  {31,  1,   0}, // #12997
  {32,  1,   0}, // #12998
  {13,  1,   0}, // #12999
  {36,  1,   0}, // #13000
  {11, 12,   0}, // #13001
  {36, 12,   0}, // #13002
  { 4,  1,   0}, // #13003
  {13,  1,   0}, // #13004
  {36,  2,   0}, // #13005
  {37,  1,   0}, // #13006
  {38,  1,   0}, // #13007
  {11,  4,   0}, // #13008
  {36,  4,   0}, // #13009
  {11, 100,   0}, // #13010
  {36, 100,   0}, // #13011
  { 4,  1,   0}, // #13012
  {36,  1,   0}, // #13013
  { 4,  1,   0}, // #13014
  {36,  1,   0}, // #13015
  {37,  1,   0}, // #13016
  {39,  1,   0}, // #13017
  {10,  3,   0}, // #13018
  {11,  3,   0}, // #13019
  {36,  3,   0}, // #13020
  {19,  1,   0}, // #13021
  {27,  1,   0}, // #13022
  {37,  1,   0}, // #13023
  {39,  1,   0}, // #13024
  {14,  1,   0}, // #13025
  {19,  1,   0}, // #13026
  {37,  1,   0}, // #13027
  {38,  1,   0}, // #13028
  { 4,  2,   0}, // #13029
  {11,  1,   0}, // #13030
  {36,  3,   0}, // #13031
  {37,  2,   0}, // #13032
  {38,  1,   0}, // #13033
  {39,  1,   0}, // #13034
  {14,  2,   0}, // #13035
  {20,  2,   0}, // #13036
  {21,  2,   0}, // #13037
  {25,  2,   0}, // #13038
  {26,  2,   0}, // #13039
  {28,  2,   0}, // #13040
  {29,  2,   0}, // #13041
  {31,  2,   0}, // #13042
  {32,  2,   0}, // #13043
  { 4,  2,   0}, // #13044
  {11,  4,   0}, // #13045
  {36,  6,   0}, // #13046
  {37,  2,   0}, // #13047
  {38,  1,   0}, // #13048
  {39,  1,   0}, // #13049
  { 4,  1,   0}, // #13050
  {11,  4,   0}, // #13051
  {36,  5,   0}, // #13052
  {37,  1,   0}, // #13053
  {38,  1,   0}, // #13054
  { 4,  1,   0}, // #13055
  {11,  1,   0}, // #13056
  {36,  2,   0}, // #13057
  {37,  1,   0}, // #13058
  {38,  1,   0}, // #13059
  {14,  2,   0}, // #13060
  {19,  1,   0}, // #13061
  {22,  1,   0}, // #13062
  {23,  1,   0}, // #13063
  {25,  1,   0}, // #13064
  {28,  1,   0}, // #13065
  {31,  1,   0}, // #13066
  {32,  1,   0}, // #13067
  {37,  1,   0}, // #13068
  {38,  1,   0}, // #13069
  {14,  1,   0}, // #13070
  {22,  1,   0}, // #13071
  {23,  1,   0}, // #13072
  {25,  1,   0}, // #13073
  {28,  1,   0}, // #13074
  {31,  1,   0}, // #13075
  {32,  1,   0}, // #13076
  {14,  2,   0}, // #13077
  {19,  1,   0}, // #13078
  {20,  1,   0}, // #13079
  {21,  1,   0}, // #13080
  {25,  1,   0}, // #13081
  {26,  1,   0}, // #13082
  {28,  1,   0}, // #13083
  {29,  1,   0}, // #13084
  {31,  1,   0}, // #13085
  {32,  1,   0}, // #13086
  {37,  1,   0}, // #13087
  {38,  1,   0}, // #13088
  {14,  1,   0}, // #13089
  {20,  1,   0}, // #13090
  {21,  1,   0}, // #13091
  {25,  1,   0}, // #13092
  {26,  1,   0}, // #13093
  {28,  1,   0}, // #13094
  {29,  1,   0}, // #13095
  {31,  1,   0}, // #13096
  {32,  1,   0}, // #13097
  {14,  2,   0}, // #13098
  {19,  1,   0}, // #13099
  {25,  1,   0}, // #13100
  {28,  1,   0}, // #13101
  {31,  1,   0}, // #13102
  {32,  1,   0}, // #13103
  {37,  1,   0}, // #13104
  {38,  1,   0}, // #13105
  { 4,  1,   0}, // #13106
  {10,  1,   0}, // #13107
  {11,  1,   0}, // #13108
  {36,  2,   0}, // #13109
  {37,  1,   0}, // #13110
  {38,  1,   0}, // #13111
  {10,  1,   0}, // #13112
  {11,  1,   0}, // #13113
  {36,  1,   0}, // #13114
  { 4,  1,   0}, // #13115
  {11,  2,   0}, // #13116
  {36,  3,   0}, // #13117
  {37,  1,   0}, // #13118
  {38,  1,   0}, // #13119
  {11,  2,   0}, // #13120
  {36,  2,   0}, // #13121
  { 4,  1,   0}, // #13122
  { 6,  3,   0}, // #13123
  {10,  3,   0}, // #13124
  {11,  3,   0}, // #13125
  {36,  4,   0}, // #13126
  {37,  1,   0}, // #13127
  {38,  1,   0}, // #13128
  { 6,  3,   0}, // #13129
  {10,  3,   0}, // #13130
  {11,  3,   0}, // #13131
  {36,  3,   0}, // #13132
  { 4,  1,   0}, // #13133
  { 6,  4,   0}, // #13134
  {10,  4,   0}, // #13135
  {11,  4,   0}, // #13136
  {36,  5,   0}, // #13137
  {37,  1,   0}, // #13138
  {38,  1,   0}, // #13139
  { 6,  4,   0}, // #13140
  {10,  4,   0}, // #13141
  {11,  4,   0}, // #13142
  {36,  4,   0}, // #13143
  { 4,  2,   0}, // #13144
  {10,  1,   0}, // #13145
  {11,  1,   0}, // #13146
  {36,  3,   0}, // #13147
  {37,  2,   0}, // #13148
  {38,  1,   0}, // #13149
  {39,  1,   0}, // #13150
  {10,  2,   0}, // #13151
  {11,  2,   0}, // #13152
  {36,  2,   0}, // #13153
  { 9,  1,   0}, // #13154
  {11,  1,   0}, // #13155
  {36,  1,   0}, // #13156
  { 4,  1,   0}, // #13157
  { 9,  1,   0}, // #13158
  {11,  1,   0}, // #13159
  {36,  2,   0}, // #13160
  {37,  1,   0}, // #13161
  {38,  1,   0}, // #13162
  { 4,  1,   0}, // #13163
  {36,  1,   0}, // #13164
  {37,  1,   0}, // #13165
  {38,  1,   0}, // #13166
  {11, 28,   0}, // #13167
  {36, 28,   0}, // #13168
  {11,  8,   0}, // #13169
  {36,  8,   0}, // #13170
  {14,  3,   0}, // #13171
  {19,  1,   0}, // #13172
  {20,  2,   0}, // #13173
  {21,  2,   0}, // #13174
  {25,  2,   0}, // #13175
  {26,  2,   0}, // #13176
  {28,  2,   0}, // #13177
  {29,  2,   0}, // #13178
  {31,  2,   0}, // #13179
  {32,  2,   0}, // #13180
  {37,  1,   0}, // #13181
  {38,  1,   0}, // #13182
  { 4,  1,   0}, // #13183
  { 6,  1,   0}, // #13184
  {10,  1,   0}, // #13185
  {11,  1,   0}, // #13186
  {36,  2,   0}, // #13187
  {37,  1,   0}, // #13188
  {38,  1,   0}, // #13189
  { 6,  1,   0}, // #13190
  {10,  1,   0}, // #13191
  {11,  1,   0}, // #13192
  {36,  1,   0}, // #13193
  {14,  3,   0}, // #13194
  {19,  1,   0}, // #13195
  {22,  2,   0}, // #13196
  {23,  2,   0}, // #13197
  {25,  2,   0}, // #13198
  {28,  2,   0}, // #13199
  {31,  2,   0}, // #13200
  {32,  2,   0}, // #13201
  {37,  1,   0}, // #13202
  {38,  1,   0}, // #13203
  {14,  2,   0}, // #13204
  {22,  2,   0}, // #13205
  {23,  2,   0}, // #13206
  {25,  2,   0}, // #13207
  {28,  2,   0}, // #13208
  {31,  2,   0}, // #13209
  {32,  2,   0}, // #13210
  { 4,  1,   0}, // #13211
  { 5, 11,   0}, // #13212
  { 9, 11,   0}, // #13213
  {11, 11,   0}, // #13214
  {13, 11,   0}, // #13215
  {36, 12,   0}, // #13216
  {37,  1,   0}, // #13217
  {38,  1,   0}, // #13218
  { 5, 11,   0}, // #13219
  { 9, 11,   0}, // #13220
  {11, 11,   0}, // #13221
  {13, 11,   0}, // #13222
  {36, 11,   0}, // #13223
  { 4,  1,   0}, // #13224
  { 5, 13,   0}, // #13225
  { 9, 13,   0}, // #13226
  {11, 13,   0}, // #13227
  {13, 13,   0}, // #13228
  {36, 14,   0}, // #13229
  {37,  1,   0}, // #13230
  {38,  1,   0}, // #13231
  { 5, 13,   0}, // #13232
  { 9, 13,   0}, // #13233
  {11, 13,   0}, // #13234
  {13, 13,   0}, // #13235
  {36, 13,   0}, // #13236
  { 4,  1,   0}, // #13237
  { 5, 17,   0}, // #13238
  { 9, 17,   0}, // #13239
  {11, 17,   0}, // #13240
  {13, 17,   0}, // #13241
  {36, 18,   0}, // #13242
  {37,  1,   0}, // #13243
  {38,  1,   0}, // #13244
  { 5, 17,   0}, // #13245
  { 9, 17,   0}, // #13246
  {11, 17,   0}, // #13247
  {13, 17,   0}, // #13248
  {36, 17,   0}, // #13249
  { 4,  1,   0}, // #13250
  { 5, 10,   0}, // #13251
  { 9, 10,   0}, // #13252
  {11, 10,   0}, // #13253
  {13, 10,   0}, // #13254
  {36, 11,   0}, // #13255
  {37,  1,   0}, // #13256
  {38,  1,   0}, // #13257
  { 5, 10,   0}, // #13258
  { 9, 10,   0}, // #13259
  {11, 10,   0}, // #13260
  {13, 10,   0}, // #13261
  {36, 10,   0}, // #13262
  {14,  6,   0}, // #13263
  {16,  5,   0}, // #13264
  {19,  1,   0}, // #13265
  {20,  5,   0}, // #13266
  {21,  5,   0}, // #13267
  {24,  5,   0}, // #13268
  {25,  5,   0}, // #13269
  {26,  5,   0}, // #13270
  {28,  5,   0}, // #13271
  {29,  5,   0}, // #13272
  {30,  5,   0}, // #13273
  {31,  5,   0}, // #13274
  {32,  5,   0}, // #13275
  {34,  5,   0}, // #13276
  {35,  5,   0}, // #13277
  {37,  1,   0}, // #13278
  {38,  1,   0}, // #13279
  {14,  5,   0}, // #13280
  {16,  5,   0}, // #13281
  {20,  5,   0}, // #13282
  {21,  5,   0}, // #13283
  {24,  5,   0}, // #13284
  {25,  5,   0}, // #13285
  {26,  5,   0}, // #13286
  {28,  5,   0}, // #13287
  {29,  5,   0}, // #13288
  {30,  5,   0}, // #13289
  {31,  5,   0}, // #13290
  {32,  5,   0}, // #13291
  {34,  5,   0}, // #13292
  {35,  5,   0}, // #13293
  {14,  4,   0}, // #13294
  {16,  3,   0}, // #13295
  {19,  1,   0}, // #13296
  {20,  3,   0}, // #13297
  {21,  3,   0}, // #13298
  {24,  3,   0}, // #13299
  {25,  3,   0}, // #13300
  {26,  3,   0}, // #13301
  {28,  3,   0}, // #13302
  {29,  3,   0}, // #13303
  {30,  3,   0}, // #13304
  {31,  3,   0}, // #13305
  {32,  3,   0}, // #13306
  {34,  3,   0}, // #13307
  {35,  3,   0}, // #13308
  {37,  1,   0}, // #13309
  {38,  1,   0}, // #13310
  {14,  3,   0}, // #13311
  {16,  3,   0}, // #13312
  {20,  3,   0}, // #13313
  {21,  3,   0}, // #13314
  {24,  3,   0}, // #13315
  {25,  3,   0}, // #13316
  {26,  3,   0}, // #13317
  {28,  3,   0}, // #13318
  {29,  3,   0}, // #13319
  {30,  3,   0}, // #13320
  {31,  3,   0}, // #13321
  {32,  3,   0}, // #13322
  {34,  3,   0}, // #13323
  {35,  3,   0}, // #13324
  {14,  7,   0}, // #13325
  {19,  1,   0}, // #13326
  {20,  6,   0}, // #13327
  {21,  6,   0}, // #13328
  {25,  6,   0}, // #13329
  {26,  6,   0}, // #13330
  {28,  6,   0}, // #13331
  {29,  6,   0}, // #13332
  {31,  6,   0}, // #13333
  {32,  6,   0}, // #13334
  {37,  1,   0}, // #13335
  {38,  1,   0}, // #13336
  {14,  6,   0}, // #13337
  {20,  6,   0}, // #13338
  {21,  6,   0}, // #13339
  {25,  6,   0}, // #13340
  {26,  6,   0}, // #13341
  {28,  6,   0}, // #13342
  {29,  6,   0}, // #13343
  {31,  6,   0}, // #13344
  {32,  6,   0}, // #13345
  {14,  9,   0}, // #13346
  {19,  1,   0}, // #13347
  {20,  8,   0}, // #13348
  {21,  8,   0}, // #13349
  {25,  8,   0}, // #13350
  {26,  8,   0}, // #13351
  {28,  8,   0}, // #13352
  {29,  8,   0}, // #13353
  {31,  8,   0}, // #13354
  {32,  8,   0}, // #13355
  {37,  1,   0}, // #13356
  {38,  1,   0}, // #13357
  {14,  8,   0}, // #13358
  {20,  8,   0}, // #13359
  {21,  8,   0}, // #13360
  {25,  8,   0}, // #13361
  {26,  8,   0}, // #13362
  {28,  8,   0}, // #13363
  {29,  8,   0}, // #13364
  {31,  8,   0}, // #13365
  {32,  8,   0}, // #13366
  { 4,  1,   0}, // #13367
  {36,  1,   0}, // #13368
  {37,  2,   0}, // #13369
  {39,  2,   0}, // #13370
  {14,  2,   0}, // #13371
  {16,  1,   0}, // #13372
  {19,  1,   0}, // #13373
  {20,  1,   0}, // #13374
  {21,  1,   0}, // #13375
  {24,  1,   0}, // #13376
  {25,  1,   0}, // #13377
  {26,  1,   0}, // #13378
  {28,  1,   0}, // #13379
  {29,  1,   0}, // #13380
  {30,  1,   0}, // #13381
  {31,  1,   0}, // #13382
  {32,  1,   0}, // #13383
  {34,  1,   0}, // #13384
  {35,  1,   0}, // #13385
  {37,  1,   0}, // #13386
  {38,  1,   0}, // #13387
  {14,  2,   0}, // #13388
  {19,  1,   0}, // #13389
  {25,  1,   0}, // #13390
  {28,  1,   0}, // #13391
  {31,  1,   0}, // #13392
  {32,  1,   0}, // #13393
  {33,  1,   0}, // #13394
  {37,  1,   0}, // #13395
  {38,  1,   0}, // #13396
  {14,  1,   0}, // #13397
  {25,  1,   0}, // #13398
  {28,  1,   0}, // #13399
  {31,  1,   0}, // #13400
  {32,  1,   0}, // #13401
  {33,  1,   0}, // #13402
  {14,  3,   0}, // #13403
  {17,  2,   0}, // #13404
  {19,  1,   0}, // #13405
  {22,  2,   0}, // #13406
  {23,  2,   0}, // #13407
  {24,  2,   0}, // #13408
  {25,  2,   0}, // #13409
  {28,  2,   0}, // #13410
  {30,  2,   0}, // #13411
  {31,  2,   0}, // #13412
  {32,  2,   0}, // #13413
  {34,  2,   0}, // #13414
  {35,  2,   0}, // #13415
  {37,  1,   0}, // #13416
  {38,  1,   0}, // #13417
  {14,  2,   0}, // #13418
  {17,  2,   0}, // #13419
  {22,  2,   0}, // #13420
  {23,  2,   0}, // #13421
  {24,  2,   0}, // #13422
  {25,  2,   0}, // #13423
  {28,  2,   0}, // #13424
  {30,  2,   0}, // #13425
  {31,  2,   0}, // #13426
  {32,  2,   0}, // #13427
  {34,  2,   0}, // #13428
  {35,  2,   0}, // #13429
  {14,  2,   0}, // #13430
  {19,  1,   0}, // #13431
  {24,  1,   0}, // #13432
  {25,  1,   0}, // #13433
  {28,  1,   0}, // #13434
  {30,  1,   0}, // #13435
  {31,  1,   0}, // #13436
  {32,  1,   0}, // #13437
  {34,  1,   0}, // #13438
  {35,  1,   0}, // #13439
  {37,  1,   0}, // #13440
  {38,  1,   0}, // #13441
  {14,  1,   0}, // #13442
  {24,  1,   0}, // #13443
  {25,  1,   0}, // #13444
  {28,  1,   0}, // #13445
  {30,  1,   0}, // #13446
  {31,  1,   0}, // #13447
  {32,  1,   0}, // #13448
  {34,  1,   0}, // #13449
  {35,  1,   0}, // #13450
  { 8,  1,   0}, // #13451
  { 9,  1,   0}, // #13452
  {11,  1,   0}, // #13453
  {36,  1,   0}, // #13454
  { 4,  1,   0}, // #13455
  {11,  6,   0}, // #13456
  {36,  7,   0}, // #13457
  {37,  1,   0}, // #13458
  {38,  1,   0}, // #13459
  {14,  3,   0}, // #13460
  {15,  2,   0}, // #13461
  {19,  1,   0}, // #13462
  {20,  2,   0}, // #13463
  {21,  2,   0}, // #13464
  {25,  2,   0}, // #13465
  {26,  2,   0}, // #13466
  {28,  2,   0}, // #13467
  {29,  2,   0}, // #13468
  {31,  2,   0}, // #13469
  {32,  2,   0}, // #13470
  {33,  2,   0}, // #13471
  {37,  1,   0}, // #13472
  {38,  1,   0}, // #13473
  {14,  2,   0}, // #13474
  {15,  2,   0}, // #13475
  {20,  2,   0}, // #13476
  {21,  2,   0}, // #13477
  {25,  2,   0}, // #13478
  {26,  2,   0}, // #13479
  {28,  2,   0}, // #13480
  {29,  2,   0}, // #13481
  {31,  2,   0}, // #13482
  {32,  2,   0}, // #13483
  {33,  2,   0}, // #13484
  {14,  3,   0}, // #13485
  {19,  3,   0}, // #13486
  {37,  1,   0}, // #13487
  {38,  1,   0}, // #13488
  {14,  1,   0}, // #13489
  {17,  1,   0}, // #13490
  {22,  1,   0}, // #13491
  {23,  1,   0}, // #13492
  {24,  1,   0}, // #13493
  {25,  1,   0}, // #13494
  {28,  1,   0}, // #13495
  {30,  1,   0}, // #13496
  {31,  1,   0}, // #13497
  {32,  1,   0}, // #13498
  {34,  1,   0}, // #13499
  {35,  1,   0}, // #13500
  {14,  3,   0}, // #13501
  {19,  1,   0}, // #13502
  {25,  2,   0}, // #13503
  {28,  2,   0}, // #13504
  {31,  2,   0}, // #13505
  {32,  2,   0}, // #13506
  {37,  1,   0}, // #13507
  {38,  1,   0}, // #13508
  {14,  2,   0}, // #13509
  {25,  2,   0}, // #13510
  {28,  2,   0}, // #13511
  {31,  2,   0}, // #13512
  {32,  2,   0}, // #13513
  {14,  9,   0}, // #13514
  {19,  1,   0}, // #13515
  {25,  8,   0}, // #13516
  {28,  8,   0}, // #13517
  {31,  8,   0}, // #13518
  {32,  8,   0}, // #13519
  {37,  1,   0}, // #13520
  {38,  1,   0}, // #13521
  {14,  8,   0}, // #13522
  {25,  8,   0}, // #13523
  {28,  8,   0}, // #13524
  {31,  8,   0}, // #13525
  {32,  8,   0}, // #13526
  {14,  5,   0}, // #13527
  {19,  1,   0}, // #13528
  {20,  4,   0}, // #13529
  {21,  4,   0}, // #13530
  {25,  4,   0}, // #13531
  {26,  4,   0}, // #13532
  {28,  4,   0}, // #13533
  {29,  4,   0}, // #13534
  {31,  4,   0}, // #13535
  {32,  4,   0}, // #13536
  {37,  1,   0}, // #13537
  {38,  1,   0}, // #13538
  {14,  4,   0}, // #13539
  {20,  4,   0}, // #13540
  {21,  4,   0}, // #13541
  {25,  4,   0}, // #13542
  {26,  4,   0}, // #13543
  {28,  4,   0}, // #13544
  {29,  4,   0}, // #13545
  {31,  4,   0}, // #13546
  {32,  4,   0}, // #13547
  {14, 13,   0}, // #13548
  {19,  1,   0}, // #13549
  {25, 12,   0}, // #13550
  {28, 12,   0}, // #13551
  {31, 12,   0}, // #13552
  {32, 12,   0}, // #13553
  {37,  1,   0}, // #13554
  {38,  1,   0}, // #13555
  {14, 12,   0}, // #13556
  {25, 12,   0}, // #13557
  {28, 12,   0}, // #13558
  {31, 12,   0}, // #13559
  {32, 12,   0}, // #13560
  { 4,  2,   0}, // #13561
  {36,  2,   0}, // #13562
  {37,  3,   0}, // #13563
  {38,  1,   0}, // #13564
  {39,  2,   0}, // #13565
  {14,  2,   0}, // #13566
  {19,  2,   0}, // #13567
  {24,  1,   0}, // #13568
  {25,  1,   0}, // #13569
  {27,  1,   0}, // #13570
  {28,  1,   0}, // #13571
  {30,  1,   0}, // #13572
  {31,  1,   0}, // #13573
  {32,  1,   0}, // #13574
  {34,  1,   0}, // #13575
  {35,  1,   0}, // #13576
  {37,  1,   0}, // #13577
  {38,  1,   0}, // #13578
  {14,  1,   0}, // #13579
  {19,  1,   0}, // #13580
  {24,  1,   0}, // #13581
  {25,  1,   0}, // #13582
  {27,  1,   0}, // #13583
  {28,  1,   0}, // #13584
  {30,  1,   0}, // #13585
  {31,  1,   0}, // #13586
  {32,  1,   0}, // #13587
  {34,  1,   0}, // #13588
  {35,  1,   0}, // #13589
  { 4,  1,   0}, // #13590
  {10,  2,   0}, // #13591
  {11,  2,   0}, // #13592
  {36,  3,   0}, // #13593
  {37,  1,   0}, // #13594
  {38,  1,   0}, // #13595
  {14,  1,   0}, // #13596
  {16,  1,   0}, // #13597
  {20,  1,   0}, // #13598
  {21,  1,   0}, // #13599
  {24,  1,   0}, // #13600
  {25,  1,   0}, // #13601
  {26,  1,   0}, // #13602
  {28,  1,   0}, // #13603
  {29,  1,   0}, // #13604
  {30,  1,   0}, // #13605
  {31,  1,   0}, // #13606
  {32,  1,   0}, // #13607
  {34,  1,   0}, // #13608
  {35,  1,   0}, // #13609
  { 4,  1,   0}, // #13610
  { 9,  2,   0}, // #13611
  {11,  2,   0}, // #13612
  {36,  3,   0}, // #13613
  {37,  1,   0}, // #13614
  {39,  1,   0}, // #13615
  { 9,  2,   0}, // #13616
  {11,  2,   0}, // #13617
  {36,  2,   0}, // #13618
  { 4,  1,   0}, // #13619
  {10,  4,   0}, // #13620
  {11,  4,   0}, // #13621
  {36,  5,   0}, // #13622
  {37,  1,   0}, // #13623
  {38,  1,   0}, // #13624
  {14, 10,   0}, // #13625
  {16,  9,   0}, // #13626
  {19,  1,   0}, // #13627
  {20,  9,   0}, // #13628
  {21,  9,   0}, // #13629
  {24,  9,   0}, // #13630
  {25,  9,   0}, // #13631
  {26,  9,   0}, // #13632
  {28,  9,   0}, // #13633
  {29,  9,   0}, // #13634
  {30,  9,   0}, // #13635
  {31,  9,   0}, // #13636
  {32,  9,   0}, // #13637
  {34,  9,   0}, // #13638
  {35,  9,   0}, // #13639
  {37,  1,   0}, // #13640
  {38,  1,   0}, // #13641
  {14,  9,   0}, // #13642
  {16,  9,   0}, // #13643
  {20,  9,   0}, // #13644
  {21,  9,   0}, // #13645
  {24,  9,   0}, // #13646
  {25,  9,   0}, // #13647
  {26,  9,   0}, // #13648
  {28,  9,   0}, // #13649
  {29,  9,   0}, // #13650
  {30,  9,   0}, // #13651
  {31,  9,   0}, // #13652
  {32,  9,   0}, // #13653
  {34,  9,   0}, // #13654
  {35,  9,   0}, // #13655
  {14, 23,   0}, // #13656
  {16, 23,   0}, // #13657
  {20, 23,   0}, // #13658
  {21, 23,   0}, // #13659
  {24, 23,   0}, // #13660
  {25, 23,   0}, // #13661
  {26, 23,   0}, // #13662
  {28, 23,   0}, // #13663
  {29, 23,   0}, // #13664
  {30, 23,   0}, // #13665
  {31, 23,   0}, // #13666
  {32, 23,   0}, // #13667
  {34, 23,   0}, // #13668
  {35, 23,   0}, // #13669
  { 4,  1,   0}, // #13670
  {11, 60,   0}, // #13671
  {36, 61,   0}, // #13672
  {37,  1,   0}, // #13673
  {39,  1,   0}, // #13674
  {14,  2,   0}, // #13675
  {19,  1,   0}, // #13676
  {22,  2,   0}, // #13677
  {23,  2,   0}, // #13678
  {25,  2,   0}, // #13679
  {27,  1,   0}, // #13680
  {28,  2,   0}, // #13681
  {31,  2,   0}, // #13682
  {32,  2,   0}, // #13683
  {37,  1,   0}, // #13684
  {39,  1,   0}, // #13685
  {14,  1,   0}, // #13686
  {19,  1,   0}, // #13687
  {22,  1,   0}, // #13688
  {23,  1,   0}, // #13689
  {25,  1,   0}, // #13690
  {27,  1,   0}, // #13691
  {28,  1,   0}, // #13692
  {31,  1,   0}, // #13693
  {32,  1,   0}, // #13694
  {37,  1,   0}, // #13695
  {39,  1,   0}, // #13696
  {19,  6,   0}, // #13697
  {27,  6,   0}, // #13698
  {37,  1,   0}, // #13699
  {39,  1,   0}, // #13700
  {19,  4,   0}, // #13701
  {27,  4,   0}, // #13702
  {37,  1,   0}, // #13703
  {39,  1,   0}, // #13704
  {19, 12,   0}, // #13705
  {27, 12,   0}, // #13706
  {37,  1,   0}, // #13707
  {39,  1,   0}, // #13708
  {14,  4,   0}, // #13709
  {19,  1,   0}, // #13710
  {24,  3,   0}, // #13711
  {25,  3,   0}, // #13712
  {28,  3,   0}, // #13713
  {30,  3,   0}, // #13714
  {31,  3,   0}, // #13715
  {32,  3,   0}, // #13716
  {34,  3,   0}, // #13717
  {35,  3,   0}, // #13718
  {37,  1,   0}, // #13719
  {38,  1,   0}, // #13720
  {14,  3,   0}, // #13721
  {24,  3,   0}, // #13722
  {25,  3,   0}, // #13723
  {28,  3,   0}, // #13724
  {30,  3,   0}, // #13725
  {31,  3,   0}, // #13726
  {32,  3,   0}, // #13727
  {34,  3,   0}, // #13728
  {35,  3,   0}, // #13729
  {14,  3,   0}, // #13730
  {19,  1,   0}, // #13731
  {24,  2,   0}, // #13732
  {25,  2,   0}, // #13733
  {28,  2,   0}, // #13734
  {30,  2,   0}, // #13735
  {31,  2,   0}, // #13736
  {32,  2,   0}, // #13737
  {34,  2,   0}, // #13738
  {35,  2,   0}, // #13739
  {37,  1,   0}, // #13740
  {38,  1,   0}, // #13741
  {14,  2,   0}, // #13742
  {24,  2,   0}, // #13743
  {25,  2,   0}, // #13744
  {28,  2,   0}, // #13745
  {30,  2,   0}, // #13746
  {31,  2,   0}, // #13747
  {32,  2,   0}, // #13748
  {34,  2,   0}, // #13749
  {35,  2,   0}, // #13750
  {37, 30,   0}, // #13751
  { 4,  3,   0}, // #13752
  {36,  3,   0}, // #13753
  {37,  1,   0}, // #13754
  {38,  1,   0}, // #13755
  { 4,  1,   0}, // #13756
  {11, 12,   0}, // #13757
  {36, 13,   0}, // #13758
  {37,  1,   0}, // #13759
  {38,  1,   0}, // #13760
  {11, 24,   0}, // #13761
  {36, 24,   0}, // #13762
  {11, 59,   0}, // #13763
  {36, 59,   0}, // #13764
  {10,  6,   0}, // #13765
  {11,  6,   0}, // #13766
  {36,  6,   0}, // #13767
  {10,  8,   0}, // #13768
  {11,  8,   0}, // #13769
  {36,  8,   0}, // #13770
  { 4,  1,   0}, // #13771
  {14,  1,   0}, // #13772
  {15,  1,   0}, // #13773
  {20,  1,   0}, // #13774
  {21,  1,   0}, // #13775
  {25,  1,   0}, // #13776
  {26,  1,   0}, // #13777
  {28,  1,   0}, // #13778
  {29,  1,   0}, // #13779
  {31,  1,   0}, // #13780
  {32,  1,   0}, // #13781
  {33,  1,   0}, // #13782
  {36,  1,   0}, // #13783
  {37,  1,   0}, // #13784
  {38,  1,   0}, // #13785
  { 4,  1,   0}, // #13786
  {14, 24,   0}, // #13787
  {25, 24,   0}, // #13788
  {28, 24,   0}, // #13789
  {31, 24,   0}, // #13790
  {32, 24,   0}, // #13791
  {36,  1,   0}, // #13792
  {37,  1,   0}, // #13793
  {38,  1,   0}, // #13794
  { 4,  1,   0}, // #13795
  {14, 62,   0}, // #13796
  {25, 62,   0}, // #13797
  {28, 62,   0}, // #13798
  {31, 62,   0}, // #13799
  {32, 62,   0}, // #13800
  {36,  1,   0}, // #13801
  {37,  1,   0}, // #13802
  {38,  1,   0}, // #13803
  { 4,  1,   0}, // #13804
  {11,  4,   0}, // #13805
  {36,  5,   0}, // #13806
  {37,  1,   0}, // #13807
  {39,  1,   0}, // #13808
  { 4,  1,   0}, // #13809
  {14,  1,   0}, // #13810
  {16,  1,   0}, // #13811
  {20,  1,   0}, // #13812
  {21,  1,   0}, // #13813
  {24,  1,   0}, // #13814
  {25,  1,   0}, // #13815
  {26,  1,   0}, // #13816
  {28,  1,   0}, // #13817
  {29,  1,   0}, // #13818
  {30,  1,   0}, // #13819
  {31,  1,   0}, // #13820
  {32,  1,   0}, // #13821
  {34,  1,   0}, // #13822
  {35,  1,   0}, // #13823
  {36,  1,   0}, // #13824
  {37,  1,   0}, // #13825
  {38,  1,   0}, // #13826
  {14,  1,   0}, // #13827
  {15,  1,   0}, // #13828
  {19,  1,   0}, // #13829
  {20,  1,   0}, // #13830
  {21,  1,   0}, // #13831
  {25,  1,   0}, // #13832
  {26,  1,   0}, // #13833
  {27,  1,   0}, // #13834
  {28,  1,   0}, // #13835
  {29,  1,   0}, // #13836
  {31,  1,   0}, // #13837
  {32,  1,   0}, // #13838
  {33,  1,   0}, // #13839
  {37,  1,   0}, // #13840
  {39,  1,   0}, // #13841
  {14,  6,   0}, // #13842
  {22,  6,   0}, // #13843
  {23,  6,   0}, // #13844
  {25,  6,   0}, // #13845
  {28,  6,   0}, // #13846
  {31,  6,   0}, // #13847
  {32,  6,   0}, // #13848
  { 4,  1,   0}, // #13849
  {14,  8,   0}, // #13850
  {25,  8,   0}, // #13851
  {28,  8,   0}, // #13852
  {31,  8,   0}, // #13853
  {32,  8,   0}, // #13854
  {36,  1,   0}, // #13855
  {37,  1,   0}, // #13856
  {38,  1,   0}, // #13857
  {14,  3,   0}, // #13858
  {25,  3,   0}, // #13859
  {28,  3,   0}, // #13860
  {31,  3,   0}, // #13861
  {32,  3,   0}, // #13862
  { 4,  1,   0}, // #13863
  {14,  3,   0}, // #13864
  {25,  3,   0}, // #13865
  {28,  3,   0}, // #13866
  {31,  3,   0}, // #13867
  {32,  3,   0}, // #13868
  {36,  1,   0}, // #13869
  {37,  1,   0}, // #13870
  {38,  1,   0}, // #13871
  { 4,  1,   0}, // #13872
  {14,  2,   0}, // #13873
  {25,  2,   0}, // #13874
  {28,  2,   0}, // #13875
  {31,  2,   0}, // #13876
  {32,  2,   0}, // #13877
  {36,  1,   0}, // #13878
  {37,  1,   0}, // #13879
  {38,  1,   0}, // #13880
  { 4,  1,   0}, // #13881
  {11,  7,   0}, // #13882
  {36,  8,   0}, // #13883
  {37,  2,   0}, // #13884
  {38,  1,   0}, // #13885
  {39,  1,   0}, // #13886
  { 4,  1,   0}, // #13887
  {10,  8,   0}, // #13888
  {11,  8,   0}, // #13889
  {36,  9,   0}, // #13890
  {37,  1,   0}, // #13891
  {38,  1,   0}, // #13892
  {14,  5,   0}, // #13893
  {19,  1,   0}, // #13894
  {25,  4,   0}, // #13895
  {28,  4,   0}, // #13896
  {31,  4,   0}, // #13897
  {32,  4,   0}, // #13898
  { 4,  1,   0}, // #13899
  {14,  2,   0}, // #13900
  {16,  2,   0}, // #13901
  {20,  2,   0}, // #13902
  {21,  2,   0}, // #13903
  {24,  2,   0}, // #13904
  {25,  2,   0}, // #13905
  {26,  2,   0}, // #13906
  {28,  2,   0}, // #13907
  {29,  2,   0}, // #13908
  {30,  2,   0}, // #13909
  {31,  2,   0}, // #13910
  {32,  2,   0}, // #13911
  {34,  2,   0}, // #13912
  {35,  2,   0}, // #13913
  {36,  1,   0}, // #13914
  {37,  1,   0}, // #13915
  {38,  1,   0}, // #13916
  {11,  1,   0}, // #13917
  {41,  1,   0}, // #13918
  {11,  0,   0}, // #13919
  {41,  0,   0}, // #13920
  {14,  1,   0}, // #13921
  {28,  1,   0}, // #13922
  {33,  1,   0}, // #13923
  {36,  1,   0}, // #13924
  {37,  1,   0}, // #13925
  {13,  1,   0}, // #13926
  {41,  1,   0}, // #13927
  {11, 12,   0}, // #13928
  {41, 12,   0}, // #13929
  { 4,  1,   0}, // #13930
  {13,  1,   0}, // #13931
  {41,  2,   0}, // #13932
  {42,  1,   0}, // #13933
  {43,  1,   0}, // #13934
  {11,  4,   0}, // #13935
  {41,  4,   0}, // #13936
  {11, 100,   0}, // #13937
  {41, 100,   0}, // #13938
  { 4,  1,   0}, // #13939
  {41,  1,   0}, // #13940
  { 4,  1,   0}, // #13941
  {41,  1,   0}, // #13942
  {42,  1,   0}, // #13943
  {44,  1,   0}, // #13944
  {10,  3,   0}, // #13945
  {11,  3,   0}, // #13946
  {41,  3,   0}, // #13947
  {19,  1,   0}, // #13948
  {32,  1,   0}, // #13949
  {42,  1,   0}, // #13950
  {44,  1,   0}, // #13951
  {14,  1,   0}, // #13952
  {19,  1,   0}, // #13953
  {30,  1,   0}, // #13954
  {42,  1,   0}, // #13955
  {43,  1,   0}, // #13956
  { 4,  2,   0}, // #13957
  {11,  1,   0}, // #13958
  {41,  3,   0}, // #13959
  {42,  2,   0}, // #13960
  {43,  1,   0}, // #13961
  {44,  1,   0}, // #13962
  {14,  2,   0}, // #13963
  {20,  2,   0}, // #13964
  {21,  2,   0}, // #13965
  {24,  2,   0}, // #13966
  {28,  2,   0}, // #13967
  {29,  2,   0}, // #13968
  {33,  2,   0}, // #13969
  {34,  2,   0}, // #13970
  {36,  2,   0}, // #13971
  {37,  2,   0}, // #13972
  { 4,  2,   0}, // #13973
  {11,  4,   0}, // #13974
  {41,  6,   0}, // #13975
  {42,  2,   0}, // #13976
  {43,  1,   0}, // #13977
  {44,  1,   0}, // #13978
  { 4,  1,   0}, // #13979
  {11,  4,   0}, // #13980
  {41,  5,   0}, // #13981
  {42,  1,   0}, // #13982
  {43,  1,   0}, // #13983
  { 4,  1,   0}, // #13984
  {11,  1,   0}, // #13985
  {41,  2,   0}, // #13986
  {42,  1,   0}, // #13987
  {43,  1,   0}, // #13988
  {14,  2,   0}, // #13989
  {19,  1,   0}, // #13990
  {22,  1,   0}, // #13991
  {23,  1,   0}, // #13992
  {26,  1,   0}, // #13993
  {27,  1,   0}, // #13994
  {28,  1,   0}, // #13995
  {30,  1,   0}, // #13996
  {31,  1,   0}, // #13997
  {33,  1,   0}, // #13998
  {36,  1,   0}, // #13999
  {37,  1,   0}, // #14000
  {42,  1,   0}, // #14001
  {43,  1,   0}, // #14002
  {14,  1,   0}, // #14003
  {22,  1,   0}, // #14004
  {23,  1,   0}, // #14005
  {26,  1,   0}, // #14006
  {27,  1,   0}, // #14007
  {28,  1,   0}, // #14008
  {31,  1,   0}, // #14009
  {33,  1,   0}, // #14010
  {36,  1,   0}, // #14011
  {37,  1,   0}, // #14012
  {14,  2,   0}, // #14013
  {19,  1,   0}, // #14014
  {20,  1,   0}, // #14015
  {21,  1,   0}, // #14016
  {24,  1,   0}, // #14017
  {28,  1,   0}, // #14018
  {29,  1,   0}, // #14019
  {30,  1,   0}, // #14020
  {33,  1,   0}, // #14021
  {34,  1,   0}, // #14022
  {36,  1,   0}, // #14023
  {37,  1,   0}, // #14024
  {42,  1,   0}, // #14025
  {43,  1,   0}, // #14026
  {14,  1,   0}, // #14027
  {20,  1,   0}, // #14028
  {21,  1,   0}, // #14029
  {24,  1,   0}, // #14030
  {28,  1,   0}, // #14031
  {29,  1,   0}, // #14032
  {33,  1,   0}, // #14033
  {34,  1,   0}, // #14034
  {36,  1,   0}, // #14035
  {37,  1,   0}, // #14036
  {14,  2,   0}, // #14037
  {19,  1,   0}, // #14038
  {28,  1,   0}, // #14039
  {30,  1,   0}, // #14040
  {33,  1,   0}, // #14041
  {36,  1,   0}, // #14042
  {37,  1,   0}, // #14043
  {42,  1,   0}, // #14044
  {43,  1,   0}, // #14045
  { 4,  1,   0}, // #14046
  {10,  1,   0}, // #14047
  {11,  1,   0}, // #14048
  {41,  2,   0}, // #14049
  {42,  1,   0}, // #14050
  {43,  1,   0}, // #14051
  {10,  1,   0}, // #14052
  {11,  1,   0}, // #14053
  {41,  1,   0}, // #14054
  { 4,  1,   0}, // #14055
  { 6,  1,   0}, // #14056
  {10,  1,   0}, // #14057
  {11,  1,   0}, // #14058
  {41,  2,   0}, // #14059
  {42,  1,   0}, // #14060
  {43,  1,   0}, // #14061
  { 6,  1,   0}, // #14062
  {10,  1,   0}, // #14063
  {11,  1,   0}, // #14064
  {41,  1,   0}, // #14065
  { 4,  2,   0}, // #14066
  {10,  1,   0}, // #14067
  {11,  1,   0}, // #14068
  {41,  3,   0}, // #14069
  {42,  2,   0}, // #14070
  {43,  1,   0}, // #14071
  {44,  1,   0}, // #14072
  {10,  2,   0}, // #14073
  {11,  2,   0}, // #14074
  {41,  2,   0}, // #14075
  { 9,  1,   0}, // #14076
  {11,  1,   0}, // #14077
  {41,  1,   0}, // #14078
  { 4,  1,   0}, // #14079
  { 9,  1,   0}, // #14080
  {11,  1,   0}, // #14081
  {41,  2,   0}, // #14082
  {42,  1,   0}, // #14083
  {43,  1,   0}, // #14084
  { 4,  1,   0}, // #14085
  {41,  1,   0}, // #14086
  {42,  1,   0}, // #14087
  {43,  1,   0}, // #14088
  {11, 28,   0}, // #14089
  {41, 28,   0}, // #14090
  {11,  8,   0}, // #14091
  {41,  8,   0}, // #14092
  {14,  3,   0}, // #14093
  {19,  1,   0}, // #14094
  {20,  2,   0}, // #14095
  {21,  2,   0}, // #14096
  {24,  2,   0}, // #14097
  {28,  2,   0}, // #14098
  {29,  2,   0}, // #14099
  {30,  1,   0}, // #14100
  {33,  2,   0}, // #14101
  {34,  2,   0}, // #14102
  {36,  2,   0}, // #14103
  {37,  2,   0}, // #14104
  {42,  1,   0}, // #14105
  {43,  1,   0}, // #14106
  {14,  3,   0}, // #14107
  {19,  1,   0}, // #14108
  {22,  2,   0}, // #14109
  {23,  2,   0}, // #14110
  {26,  2,   0}, // #14111
  {27,  2,   0}, // #14112
  {28,  2,   0}, // #14113
  {30,  1,   0}, // #14114
  {31,  2,   0}, // #14115
  {33,  2,   0}, // #14116
  {36,  2,   0}, // #14117
  {37,  2,   0}, // #14118
  {42,  1,   0}, // #14119
  {43,  1,   0}, // #14120
  {14,  2,   0}, // #14121
  {22,  2,   0}, // #14122
  {23,  2,   0}, // #14123
  {26,  2,   0}, // #14124
  {27,  2,   0}, // #14125
  {28,  2,   0}, // #14126
  {31,  2,   0}, // #14127
  {33,  2,   0}, // #14128
  {36,  2,   0}, // #14129
  {37,  2,   0}, // #14130
  {14,  6,   0}, // #14131
  {19,  1,   0}, // #14132
  {22,  5,   0}, // #14133
  {23,  5,   0}, // #14134
  {26,  5,   0}, // #14135
  {27,  5,   0}, // #14136
  {28,  5,   0}, // #14137
  {30,  1,   0}, // #14138
  {31,  5,   0}, // #14139
  {33,  5,   0}, // #14140
  {36,  5,   0}, // #14141
  {37,  5,   0}, // #14142
  {42,  1,   0}, // #14143
  {43,  1,   0}, // #14144
  {14,  5,   0}, // #14145
  {22,  5,   0}, // #14146
  {23,  5,   0}, // #14147
  {26,  5,   0}, // #14148
  {27,  5,   0}, // #14149
  {28,  5,   0}, // #14150
  {31,  5,   0}, // #14151
  {33,  5,   0}, // #14152
  {36,  5,   0}, // #14153
  {37,  5,   0}, // #14154
  { 4,  1,   0}, // #14155
  { 5, 11,   0}, // #14156
  { 9, 11,   0}, // #14157
  {11, 11,   0}, // #14158
  {13, 11,   0}, // #14159
  {41, 12,   0}, // #14160
  {42,  1,   0}, // #14161
  {43,  1,   0}, // #14162
  { 5, 11,   0}, // #14163
  { 9, 11,   0}, // #14164
  {11, 11,   0}, // #14165
  {13, 11,   0}, // #14166
  {41, 11,   0}, // #14167
  { 4,  1,   0}, // #14168
  { 5, 13,   0}, // #14169
  { 9, 13,   0}, // #14170
  {11, 13,   0}, // #14171
  {13, 13,   0}, // #14172
  {41, 14,   0}, // #14173
  {42,  1,   0}, // #14174
  {43,  1,   0}, // #14175
  { 5, 13,   0}, // #14176
  { 9, 13,   0}, // #14177
  {11, 13,   0}, // #14178
  {13, 13,   0}, // #14179
  {41, 13,   0}, // #14180
  { 4,  1,   0}, // #14181
  { 5, 17,   0}, // #14182
  { 9, 17,   0}, // #14183
  {11, 17,   0}, // #14184
  {13, 17,   0}, // #14185
  {41, 18,   0}, // #14186
  {42,  1,   0}, // #14187
  {43,  1,   0}, // #14188
  { 5, 17,   0}, // #14189
  { 9, 17,   0}, // #14190
  {11, 17,   0}, // #14191
  {13, 17,   0}, // #14192
  {41, 17,   0}, // #14193
  { 4,  1,   0}, // #14194
  { 5, 10,   0}, // #14195
  { 9, 10,   0}, // #14196
  {11, 10,   0}, // #14197
  {13, 10,   0}, // #14198
  {41, 11,   0}, // #14199
  {42,  1,   0}, // #14200
  {43,  1,   0}, // #14201
  { 5, 10,   0}, // #14202
  { 9, 10,   0}, // #14203
  {11, 10,   0}, // #14204
  {13, 10,   0}, // #14205
  {41, 10,   0}, // #14206
  {14,  6,   0}, // #14207
  {16,  5,   0}, // #14208
  {19,  1,   0}, // #14209
  {20,  5,   0}, // #14210
  {21,  5,   0}, // #14211
  {24,  5,   0}, // #14212
  {25,  5,   0}, // #14213
  {27,  5,   0}, // #14214
  {28,  5,   0}, // #14215
  {29,  5,   0}, // #14216
  {30,  1,   0}, // #14217
  {33,  5,   0}, // #14218
  {34,  5,   0}, // #14219
  {35,  5,   0}, // #14220
  {36,  5,   0}, // #14221
  {37,  5,   0}, // #14222
  {39,  5,   0}, // #14223
  {40,  5,   0}, // #14224
  {42,  1,   0}, // #14225
  {43,  1,   0}, // #14226
  {14,  5,   0}, // #14227
  {16,  5,   0}, // #14228
  {20,  5,   0}, // #14229
  {21,  5,   0}, // #14230
  {24,  5,   0}, // #14231
  {25,  5,   0}, // #14232
  {27,  5,   0}, // #14233
  {28,  5,   0}, // #14234
  {29,  5,   0}, // #14235
  {33,  5,   0}, // #14236
  {34,  5,   0}, // #14237
  {35,  5,   0}, // #14238
  {36,  5,   0}, // #14239
  {37,  5,   0}, // #14240
  {39,  5,   0}, // #14241
  {40,  5,   0}, // #14242
  {14,  4,   0}, // #14243
  {16,  3,   0}, // #14244
  {19,  1,   0}, // #14245
  {20,  3,   0}, // #14246
  {21,  3,   0}, // #14247
  {24,  3,   0}, // #14248
  {25,  3,   0}, // #14249
  {27,  3,   0}, // #14250
  {28,  3,   0}, // #14251
  {29,  3,   0}, // #14252
  {30,  1,   0}, // #14253
  {33,  3,   0}, // #14254
  {34,  3,   0}, // #14255
  {35,  3,   0}, // #14256
  {36,  3,   0}, // #14257
  {37,  3,   0}, // #14258
  {39,  3,   0}, // #14259
  {40,  3,   0}, // #14260
  {42,  1,   0}, // #14261
  {43,  1,   0}, // #14262
  {14,  3,   0}, // #14263
  {16,  3,   0}, // #14264
  {20,  3,   0}, // #14265
  {21,  3,   0}, // #14266
  {24,  3,   0}, // #14267
  {25,  3,   0}, // #14268
  {27,  3,   0}, // #14269
  {28,  3,   0}, // #14270
  {29,  3,   0}, // #14271
  {33,  3,   0}, // #14272
  {34,  3,   0}, // #14273
  {35,  3,   0}, // #14274
  {36,  3,   0}, // #14275
  {37,  3,   0}, // #14276
  {39,  3,   0}, // #14277
  {40,  3,   0}, // #14278
  {14,  7,   0}, // #14279
  {19,  1,   0}, // #14280
  {20,  6,   0}, // #14281
  {21,  6,   0}, // #14282
  {24,  6,   0}, // #14283
  {28,  6,   0}, // #14284
  {29,  6,   0}, // #14285
  {30,  1,   0}, // #14286
  {33,  6,   0}, // #14287
  {34,  6,   0}, // #14288
  {36,  6,   0}, // #14289
  {37,  6,   0}, // #14290
  {42,  1,   0}, // #14291
  {43,  1,   0}, // #14292
  {14,  6,   0}, // #14293
  {20,  6,   0}, // #14294
  {21,  6,   0}, // #14295
  {24,  6,   0}, // #14296
  {28,  6,   0}, // #14297
  {29,  6,   0}, // #14298
  {33,  6,   0}, // #14299
  {34,  6,   0}, // #14300
  {36,  6,   0}, // #14301
  {37,  6,   0}, // #14302
  {14,  9,   0}, // #14303
  {19,  1,   0}, // #14304
  {20,  8,   0}, // #14305
  {21,  8,   0}, // #14306
  {24,  8,   0}, // #14307
  {28,  8,   0}, // #14308
  {29,  8,   0}, // #14309
  {30,  1,   0}, // #14310
  {33,  8,   0}, // #14311
  {34,  8,   0}, // #14312
  {36,  8,   0}, // #14313
  {37,  8,   0}, // #14314
  {42,  1,   0}, // #14315
  {43,  1,   0}, // #14316
  {14,  8,   0}, // #14317
  {20,  8,   0}, // #14318
  {21,  8,   0}, // #14319
  {24,  8,   0}, // #14320
  {28,  8,   0}, // #14321
  {29,  8,   0}, // #14322
  {33,  8,   0}, // #14323
  {34,  8,   0}, // #14324
  {36,  8,   0}, // #14325
  {37,  8,   0}, // #14326
  { 4,  1,   0}, // #14327
  {41,  1,   0}, // #14328
  {42,  2,   0}, // #14329
  {44,  2,   0}, // #14330
  {14,  2,   0}, // #14331
  {19,  2,   0}, // #14332
  {30,  2,   0}, // #14333
  {14,  2,   0}, // #14334
  {16,  1,   0}, // #14335
  {19,  1,   0}, // #14336
  {20,  1,   0}, // #14337
  {21,  1,   0}, // #14338
  {24,  1,   0}, // #14339
  {25,  1,   0}, // #14340
  {27,  1,   0}, // #14341
  {28,  1,   0}, // #14342
  {29,  1,   0}, // #14343
  {30,  1,   0}, // #14344
  {33,  1,   0}, // #14345
  {34,  1,   0}, // #14346
  {35,  1,   0}, // #14347
  {36,  1,   0}, // #14348
  {37,  1,   0}, // #14349
  {39,  1,   0}, // #14350
  {40,  1,   0}, // #14351
  {42,  1,   0}, // #14352
  {43,  1,   0}, // #14353
  {14,  2,   0}, // #14354
  {19,  1,   0}, // #14355
  {28,  1,   0}, // #14356
  {30,  1,   0}, // #14357
  {33,  1,   0}, // #14358
  {36,  1,   0}, // #14359
  {37,  1,   0}, // #14360
  {38,  1,   0}, // #14361
  {42,  1,   0}, // #14362
  {43,  1,   0}, // #14363
  {14,  1,   0}, // #14364
  {28,  1,   0}, // #14365
  {33,  1,   0}, // #14366
  {36,  1,   0}, // #14367
  {37,  1,   0}, // #14368
  {38,  1,   0}, // #14369
  {14,  3,   0}, // #14370
  {17,  2,   0}, // #14371
  {19,  1,   0}, // #14372
  {22,  2,   0}, // #14373
  {23,  2,   0}, // #14374
  {25,  2,   0}, // #14375
  {26,  2,   0}, // #14376
  {27,  2,   0}, // #14377
  {28,  2,   0}, // #14378
  {30,  1,   0}, // #14379
  {31,  2,   0}, // #14380
  {33,  2,   0}, // #14381
  {35,  2,   0}, // #14382
  {36,  2,   0}, // #14383
  {37,  2,   0}, // #14384
  {39,  2,   0}, // #14385
  {40,  2,   0}, // #14386
  {42,  1,   0}, // #14387
  {43,  1,   0}, // #14388
  {14,  2,   0}, // #14389
  {17,  2,   0}, // #14390
  {22,  2,   0}, // #14391
  {23,  2,   0}, // #14392
  {25,  2,   0}, // #14393
  {26,  2,   0}, // #14394
  {27,  2,   0}, // #14395
  {28,  2,   0}, // #14396
  {31,  2,   0}, // #14397
  {33,  2,   0}, // #14398
  {35,  2,   0}, // #14399
  {36,  2,   0}, // #14400
  {37,  2,   0}, // #14401
  {39,  2,   0}, // #14402
  {40,  2,   0}, // #14403
  { 4,  1,   0}, // #14404
  { 6,  3,   0}, // #14405
  {10,  3,   0}, // #14406
  {11,  3,   0}, // #14407
  {41,  4,   0}, // #14408
  {42,  1,   0}, // #14409
  {43,  1,   0}, // #14410
  { 6,  3,   0}, // #14411
  {10,  3,   0}, // #14412
  {11,  3,   0}, // #14413
  {41,  3,   0}, // #14414
  { 4,  1,   0}, // #14415
  { 6,  4,   0}, // #14416
  {10,  4,   0}, // #14417
  {11,  4,   0}, // #14418
  {41,  5,   0}, // #14419
  {42,  1,   0}, // #14420
  {43,  1,   0}, // #14421
  { 6,  4,   0}, // #14422
  {10,  4,   0}, // #14423
  {11,  4,   0}, // #14424
  {41,  4,   0}, // #14425
  {14,  2,   0}, // #14426
  {19,  1,   0}, // #14427
  {25,  1,   0}, // #14428
  {27,  1,   0}, // #14429
  {28,  1,   0}, // #14430
  {30,  1,   0}, // #14431
  {33,  1,   0}, // #14432
  {35,  1,   0}, // #14433
  {36,  1,   0}, // #14434
  {37,  1,   0}, // #14435
  {39,  1,   0}, // #14436
  {40,  1,   0}, // #14437
  {42,  1,   0}, // #14438
  {43,  1,   0}, // #14439
  {14,  1,   0}, // #14440
  {25,  1,   0}, // #14441
  {27,  1,   0}, // #14442
  {28,  1,   0}, // #14443
  {33,  1,   0}, // #14444
  {35,  1,   0}, // #14445
  {36,  1,   0}, // #14446
  {37,  1,   0}, // #14447
  {39,  1,   0}, // #14448
  {40,  1,   0}, // #14449
  { 8,  1,   0}, // #14450
  { 9,  1,   0}, // #14451
  {11,  1,   0}, // #14452
  {41,  1,   0}, // #14453
  { 4,  1,   0}, // #14454
  {11,  6,   0}, // #14455
  {41,  7,   0}, // #14456
  {42,  1,   0}, // #14457
  {43,  1,   0}, // #14458
  {14,  3,   0}, // #14459
  {15,  2,   0}, // #14460
  {19,  1,   0}, // #14461
  {20,  2,   0}, // #14462
  {21,  2,   0}, // #14463
  {24,  2,   0}, // #14464
  {28,  2,   0}, // #14465
  {29,  2,   0}, // #14466
  {30,  1,   0}, // #14467
  {33,  2,   0}, // #14468
  {34,  2,   0}, // #14469
  {36,  2,   0}, // #14470
  {37,  2,   0}, // #14471
  {38,  2,   0}, // #14472
  {42,  1,   0}, // #14473
  {43,  1,   0}, // #14474
  {14,  2,   0}, // #14475
  {15,  2,   0}, // #14476
  {20,  2,   0}, // #14477
  {21,  2,   0}, // #14478
  {24,  2,   0}, // #14479
  {28,  2,   0}, // #14480
  {29,  2,   0}, // #14481
  {33,  2,   0}, // #14482
  {34,  2,   0}, // #14483
  {36,  2,   0}, // #14484
  {37,  2,   0}, // #14485
  {38,  2,   0}, // #14486
  {14,  3,   0}, // #14487
  {19,  3,   0}, // #14488
  {30,  3,   0}, // #14489
  {42,  1,   0}, // #14490
  {43,  1,   0}, // #14491
  {14,  1,   0}, // #14492
  {17,  1,   0}, // #14493
  {22,  1,   0}, // #14494
  {23,  1,   0}, // #14495
  {25,  1,   0}, // #14496
  {26,  1,   0}, // #14497
  {27,  1,   0}, // #14498
  {28,  1,   0}, // #14499
  {31,  1,   0}, // #14500
  {33,  1,   0}, // #14501
  {35,  1,   0}, // #14502
  {36,  1,   0}, // #14503
  {37,  1,   0}, // #14504
  {39,  1,   0}, // #14505
  {40,  1,   0}, // #14506
  {14,  3,   0}, // #14507
  {19,  1,   0}, // #14508
  {28,  2,   0}, // #14509
  {30,  1,   0}, // #14510
  {33,  2,   0}, // #14511
  {36,  2,   0}, // #14512
  {37,  2,   0}, // #14513
  {42,  1,   0}, // #14514
  {43,  1,   0}, // #14515
  {14,  2,   0}, // #14516
  {28,  2,   0}, // #14517
  {33,  2,   0}, // #14518
  {36,  2,   0}, // #14519
  {37,  2,   0}, // #14520
  {14,  9,   0}, // #14521
  {19,  1,   0}, // #14522
  {28,  8,   0}, // #14523
  {30,  1,   0}, // #14524
  {33,  8,   0}, // #14525
  {36,  8,   0}, // #14526
  {37,  8,   0}, // #14527
  {42,  1,   0}, // #14528
  {43,  1,   0}, // #14529
  {14,  8,   0}, // #14530
  {28,  8,   0}, // #14531
  {33,  8,   0}, // #14532
  {36,  8,   0}, // #14533
  {37,  8,   0}, // #14534
  {14,  5,   0}, // #14535
  {19,  1,   0}, // #14536
  {20,  4,   0}, // #14537
  {21,  4,   0}, // #14538
  {24,  4,   0}, // #14539
  {28,  4,   0}, // #14540
  {29,  4,   0}, // #14541
  {30,  1,   0}, // #14542
  {33,  4,   0}, // #14543
  {34,  4,   0}, // #14544
  {36,  4,   0}, // #14545
  {37,  4,   0}, // #14546
  {42,  1,   0}, // #14547
  {43,  1,   0}, // #14548
  {14,  4,   0}, // #14549
  {20,  4,   0}, // #14550
  {21,  4,   0}, // #14551
  {24,  4,   0}, // #14552
  {28,  4,   0}, // #14553
  {29,  4,   0}, // #14554
  {33,  4,   0}, // #14555
  {34,  4,   0}, // #14556
  {36,  4,   0}, // #14557
  {37,  4,   0}, // #14558
  {14, 13,   0}, // #14559
  {19,  1,   0}, // #14560
  {28, 12,   0}, // #14561
  {30,  1,   0}, // #14562
  {33, 12,   0}, // #14563
  {36, 12,   0}, // #14564
  {37, 12,   0}, // #14565
  {42,  1,   0}, // #14566
  {43,  1,   0}, // #14567
  {14, 12,   0}, // #14568
  {28, 12,   0}, // #14569
  {33, 12,   0}, // #14570
  {36, 12,   0}, // #14571
  {37, 12,   0}, // #14572
  { 4,  2,   0}, // #14573
  {41,  2,   0}, // #14574
  {42,  3,   0}, // #14575
  {43,  1,   0}, // #14576
  {44,  2,   0}, // #14577
  {14,  3,   0}, // #14578
  {19,  1,   0}, // #14579
  {25,  2,   0}, // #14580
  {27,  2,   0}, // #14581
  {28,  2,   0}, // #14582
  {30,  1,   0}, // #14583
  {33,  2,   0}, // #14584
  {35,  2,   0}, // #14585
  {36,  2,   0}, // #14586
  {37,  2,   0}, // #14587
  {39,  2,   0}, // #14588
  {40,  2,   0}, // #14589
  {42,  1,   0}, // #14590
  {43,  1,   0}, // #14591
  {14,  2,   0}, // #14592
  {25,  2,   0}, // #14593
  {27,  2,   0}, // #14594
  {28,  2,   0}, // #14595
  {33,  2,   0}, // #14596
  {35,  2,   0}, // #14597
  {36,  2,   0}, // #14598
  {37,  2,   0}, // #14599
  {39,  2,   0}, // #14600
  {40,  2,   0}, // #14601
  {14,  2,   0}, // #14602
  {19,  2,   0}, // #14603
  {25,  1,   0}, // #14604
  {27,  1,   0}, // #14605
  {28,  1,   0}, // #14606
  {30,  1,   0}, // #14607
  {32,  1,   0}, // #14608
  {33,  1,   0}, // #14609
  {35,  1,   0}, // #14610
  {36,  1,   0}, // #14611
  {37,  1,   0}, // #14612
  {39,  1,   0}, // #14613
  {40,  1,   0}, // #14614
  {42,  1,   0}, // #14615
  {43,  1,   0}, // #14616
  {14,  1,   0}, // #14617
  {19,  1,   0}, // #14618
  {25,  1,   0}, // #14619
  {27,  1,   0}, // #14620
  {28,  1,   0}, // #14621
  {32,  1,   0}, // #14622
  {33,  1,   0}, // #14623
  {35,  1,   0}, // #14624
  {36,  1,   0}, // #14625
  {37,  1,   0}, // #14626
  {39,  1,   0}, // #14627
  {40,  1,   0}, // #14628
  { 4,  1,   0}, // #14629
  {10,  2,   0}, // #14630
  {11,  2,   0}, // #14631
  {41,  3,   0}, // #14632
  {42,  1,   0}, // #14633
  {43,  1,   0}, // #14634
  {14,  1,   0}, // #14635
  {16,  1,   0}, // #14636
  {20,  1,   0}, // #14637
  {21,  1,   0}, // #14638
  {24,  1,   0}, // #14639
  {25,  1,   0}, // #14640
  {27,  1,   0}, // #14641
  {28,  1,   0}, // #14642
  {29,  1,   0}, // #14643
  {33,  1,   0}, // #14644
  {34,  1,   0}, // #14645
  {35,  1,   0}, // #14646
  {36,  1,   0}, // #14647
  {37,  1,   0}, // #14648
  {39,  1,   0}, // #14649
  {40,  1,   0}, // #14650
  { 4,  1,   0}, // #14651
  { 9,  2,   0}, // #14652
  {11,  2,   0}, // #14653
  {41,  3,   0}, // #14654
  {42,  1,   0}, // #14655
  {44,  1,   0}, // #14656
  { 9,  2,   0}, // #14657
  {11,  2,   0}, // #14658
  {41,  2,   0}, // #14659
  { 4,  1,   0}, // #14660
  {10,  4,   0}, // #14661
  {11,  4,   0}, // #14662
  {41,  5,   0}, // #14663
  {42,  1,   0}, // #14664
  {43,  1,   0}, // #14665
  {14, 10,   0}, // #14666
  {16,  9,   0}, // #14667
  {19,  1,   0}, // #14668
  {20,  9,   0}, // #14669
  {21,  9,   0}, // #14670
  {24,  9,   0}, // #14671
  {25,  9,   0}, // #14672
  {27,  9,   0}, // #14673
  {28,  9,   0}, // #14674
  {29,  9,   0}, // #14675
  {30,  1,   0}, // #14676
  {33,  9,   0}, // #14677
  {34,  9,   0}, // #14678
  {35,  9,   0}, // #14679
  {36,  9,   0}, // #14680
  {37,  9,   0}, // #14681
  {39,  9,   0}, // #14682
  {40,  9,   0}, // #14683
  {42,  1,   0}, // #14684
  {43,  1,   0}, // #14685
  {14,  9,   0}, // #14686
  {16,  9,   0}, // #14687
  {20,  9,   0}, // #14688
  {21,  9,   0}, // #14689
  {24,  9,   0}, // #14690
  {25,  9,   0}, // #14691
  {27,  9,   0}, // #14692
  {28,  9,   0}, // #14693
  {29,  9,   0}, // #14694
  {33,  9,   0}, // #14695
  {34,  9,   0}, // #14696
  {35,  9,   0}, // #14697
  {36,  9,   0}, // #14698
  {37,  9,   0}, // #14699
  {39,  9,   0}, // #14700
  {40,  9,   0}, // #14701
  {14, 23,   0}, // #14702
  {16, 23,   0}, // #14703
  {20, 23,   0}, // #14704
  {21, 23,   0}, // #14705
  {24, 23,   0}, // #14706
  {25, 23,   0}, // #14707
  {27, 23,   0}, // #14708
  {28, 23,   0}, // #14709
  {29, 23,   0}, // #14710
  {33, 23,   0}, // #14711
  {34, 23,   0}, // #14712
  {35, 23,   0}, // #14713
  {36, 23,   0}, // #14714
  {37, 23,   0}, // #14715
  {39, 23,   0}, // #14716
  {40, 23,   0}, // #14717
  { 4,  1,   0}, // #14718
  {11, 60,   0}, // #14719
  {41, 61,   0}, // #14720
  {42,  1,   0}, // #14721
  {44,  1,   0}, // #14722
  {14,  5,   0}, // #14723
  {19,  1,   0}, // #14724
  {22,  4,   0}, // #14725
  {23,  4,   0}, // #14726
  {26,  4,   0}, // #14727
  {27,  4,   0}, // #14728
  {28,  4,   0}, // #14729
  {30,  1,   0}, // #14730
  {31,  4,   0}, // #14731
  {33,  4,   0}, // #14732
  {36,  4,   0}, // #14733
  {37,  4,   0}, // #14734
  {42,  1,   0}, // #14735
  {43,  1,   0}, // #14736
  {14,  4,   0}, // #14737
  {22,  4,   0}, // #14738
  {23,  4,   0}, // #14739
  {26,  4,   0}, // #14740
  {27,  4,   0}, // #14741
  {28,  4,   0}, // #14742
  {31,  4,   0}, // #14743
  {33,  4,   0}, // #14744
  {36,  4,   0}, // #14745
  {37,  4,   0}, // #14746
  {14,  3,   0}, // #14747
  {19,  1,   0}, // #14748
  {28,  2,   0}, // #14749
  {30,  1,   0}, // #14750
  {33,  2,   0}, // #14751
  {36,  2,   0}, // #14752
  {37,  2,   0}, // #14753
  {38,  2,   0}, // #14754
  {42,  1,   0}, // #14755
  {43,  1,   0}, // #14756
  {14,  2,   0}, // #14757
  {28,  2,   0}, // #14758
  {33,  2,   0}, // #14759
  {36,  2,   0}, // #14760
  {37,  2,   0}, // #14761
  {38,  2,   0}, // #14762
  {14,  2,   0}, // #14763
  {19,  1,   0}, // #14764
  {22,  2,   0}, // #14765
  {23,  2,   0}, // #14766
  {26,  2,   0}, // #14767
  {27,  2,   0}, // #14768
  {28,  2,   0}, // #14769
  {31,  2,   0}, // #14770
  {32,  1,   0}, // #14771
  {33,  2,   0}, // #14772
  {36,  2,   0}, // #14773
  {37,  2,   0}, // #14774
  {42,  1,   0}, // #14775
  {44,  1,   0}, // #14776
  {14,  1,   0}, // #14777
  {19,  1,   0}, // #14778
  {22,  1,   0}, // #14779
  {23,  1,   0}, // #14780
  {26,  1,   0}, // #14781
  {27,  1,   0}, // #14782
  {28,  1,   0}, // #14783
  {31,  1,   0}, // #14784
  {32,  1,   0}, // #14785
  {33,  1,   0}, // #14786
  {36,  1,   0}, // #14787
  {37,  1,   0}, // #14788
  {42,  1,   0}, // #14789
  {44,  1,   0}, // #14790
  {14,  5,   0}, // #14791
  {19,  1,   0}, // #14792
  {28,  4,   0}, // #14793
  {30,  1,   0}, // #14794
  {33,  4,   0}, // #14795
  {36,  4,   0}, // #14796
  {37,  4,   0}, // #14797
  {42,  1,   0}, // #14798
  {43,  1,   0}, // #14799
  {14,  4,   0}, // #14800
  {28,  4,   0}, // #14801
  {33,  4,   0}, // #14802
  {36,  4,   0}, // #14803
  {37,  4,   0}, // #14804
  {14,  7,   0}, // #14805
  {16,  6,   0}, // #14806
  {19,  1,   0}, // #14807
  {20,  6,   0}, // #14808
  {21,  6,   0}, // #14809
  {24,  6,   0}, // #14810
  {25,  6,   0}, // #14811
  {27,  6,   0}, // #14812
  {28,  6,   0}, // #14813
  {29,  6,   0}, // #14814
  {30,  1,   0}, // #14815
  {33,  6,   0}, // #14816
  {34,  6,   0}, // #14817
  {35,  6,   0}, // #14818
  {36,  6,   0}, // #14819
  {37,  6,   0}, // #14820
  {39,  6,   0}, // #14821
  {40,  6,   0}, // #14822
  {42,  1,   0}, // #14823
  {43,  1,   0}, // #14824
  {14,  6,   0}, // #14825
  {16,  6,   0}, // #14826
  {20,  6,   0}, // #14827
  {21,  6,   0}, // #14828
  {24,  6,   0}, // #14829
  {25,  6,   0}, // #14830
  {27,  6,   0}, // #14831
  {28,  6,   0}, // #14832
  {29,  6,   0}, // #14833
  {33,  6,   0}, // #14834
  {34,  6,   0}, // #14835
  {35,  6,   0}, // #14836
  {36,  6,   0}, // #14837
  {37,  6,   0}, // #14838
  {39,  6,   0}, // #14839
  {40,  6,   0}, // #14840
  {14, 11,   0}, // #14841
  {16, 10,   0}, // #14842
  {19,  1,   0}, // #14843
  {20, 10,   0}, // #14844
  {21, 10,   0}, // #14845
  {24, 10,   0}, // #14846
  {25, 10,   0}, // #14847
  {27, 10,   0}, // #14848
  {28, 10,   0}, // #14849
  {29, 10,   0}, // #14850
  {30,  1,   0}, // #14851
  {33, 10,   0}, // #14852
  {34, 10,   0}, // #14853
  {35, 10,   0}, // #14854
  {36, 10,   0}, // #14855
  {37, 10,   0}, // #14856
  {39, 10,   0}, // #14857
  {40, 10,   0}, // #14858
  {42,  1,   0}, // #14859
  {43,  1,   0}, // #14860
  {14, 10,   0}, // #14861
  {16, 10,   0}, // #14862
  {20, 10,   0}, // #14863
  {21, 10,   0}, // #14864
  {24, 10,   0}, // #14865
  {25, 10,   0}, // #14866
  {27, 10,   0}, // #14867
  {28, 10,   0}, // #14868
  {29, 10,   0}, // #14869
  {33, 10,   0}, // #14870
  {34, 10,   0}, // #14871
  {35, 10,   0}, // #14872
  {36, 10,   0}, // #14873
  {37, 10,   0}, // #14874
  {39, 10,   0}, // #14875
  {40, 10,   0}, // #14876
  {19,  6,   0}, // #14877
  {32,  6,   0}, // #14878
  {42,  1,   0}, // #14879
  {44,  1,   0}, // #14880
  {19,  4,   0}, // #14881
  {32,  4,   0}, // #14882
  {42,  1,   0}, // #14883
  {44,  1,   0}, // #14884
  {19, 12,   0}, // #14885
  {32, 12,   0}, // #14886
  {42,  1,   0}, // #14887
  {44,  1,   0}, // #14888
  {14,  4,   0}, // #14889
  {15,  3,   0}, // #14890
  {19,  1,   0}, // #14891
  {20,  3,   0}, // #14892
  {21,  3,   0}, // #14893
  {24,  3,   0}, // #14894
  {28,  3,   0}, // #14895
  {29,  3,   0}, // #14896
  {30,  1,   0}, // #14897
  {33,  3,   0}, // #14898
  {34,  3,   0}, // #14899
  {36,  3,   0}, // #14900
  {37,  3,   0}, // #14901
  {38,  3,   0}, // #14902
  {42,  1,   0}, // #14903
  {43,  1,   0}, // #14904
  {14,  3,   0}, // #14905
  {15,  3,   0}, // #14906
  {20,  3,   0}, // #14907
  {21,  3,   0}, // #14908
  {24,  3,   0}, // #14909
  {28,  3,   0}, // #14910
  {29,  3,   0}, // #14911
  {33,  3,   0}, // #14912
  {34,  3,   0}, // #14913
  {36,  3,   0}, // #14914
  {37,  3,   0}, // #14915
  {38,  3,   0}, // #14916
  {14,  4,   0}, // #14917
  {19,  1,   0}, // #14918
  {25,  3,   0}, // #14919
  {27,  3,   0}, // #14920
  {28,  3,   0}, // #14921
  {30,  1,   0}, // #14922
  {33,  3,   0}, // #14923
  {35,  3,   0}, // #14924
  {36,  3,   0}, // #14925
  {37,  3,   0}, // #14926
  {39,  3,   0}, // #14927
  {40,  3,   0}, // #14928
  {42,  1,   0}, // #14929
  {43,  1,   0}, // #14930
  {14,  3,   0}, // #14931
  {25,  3,   0}, // #14932
  {27,  3,   0}, // #14933
  {28,  3,   0}, // #14934
  {33,  3,   0}, // #14935
  {35,  3,   0}, // #14936
  {36,  3,   0}, // #14937
  {37,  3,   0}, // #14938
  {39,  3,   0}, // #14939
  {40,  3,   0}, // #14940
  {14,  3,   0}, // #14941
  {16,  2,   0}, // #14942
  {19,  1,   0}, // #14943
  {20,  2,   0}, // #14944
  {21,  2,   0}, // #14945
  {24,  2,   0}, // #14946
  {25,  2,   0}, // #14947
  {27,  2,   0}, // #14948
  {28,  2,   0}, // #14949
  {29,  2,   0}, // #14950
  {30,  1,   0}, // #14951
  {33,  2,   0}, // #14952
  {34,  2,   0}, // #14953
  {35,  2,   0}, // #14954
  {36,  2,   0}, // #14955
  {37,  2,   0}, // #14956
  {39,  2,   0}, // #14957
  {40,  2,   0}, // #14958
  {42,  1,   0}, // #14959
  {43,  1,   0}, // #14960
  {14,  2,   0}, // #14961
  {16,  2,   0}, // #14962
  {20,  2,   0}, // #14963
  {21,  2,   0}, // #14964
  {24,  2,   0}, // #14965
  {25,  2,   0}, // #14966
  {27,  2,   0}, // #14967
  {28,  2,   0}, // #14968
  {29,  2,   0}, // #14969
  {33,  2,   0}, // #14970
  {34,  2,   0}, // #14971
  {35,  2,   0}, // #14972
  {36,  2,   0}, // #14973
  {37,  2,   0}, // #14974
  {39,  2,   0}, // #14975
  {40,  2,   0}, // #14976
  {14, 19,   0}, // #14977
  {16, 18,   0}, // #14978
  {19,  1,   0}, // #14979
  {20, 18,   0}, // #14980
  {21, 18,   0}, // #14981
  {24, 18,   0}, // #14982
  {25, 18,   0}, // #14983
  {27, 18,   0}, // #14984
  {28, 18,   0}, // #14985
  {29, 18,   0}, // #14986
  {30,  1,   0}, // #14987
  {33, 18,   0}, // #14988
  {34, 18,   0}, // #14989
  {35, 18,   0}, // #14990
  {36, 18,   0}, // #14991
  {37, 18,   0}, // #14992
  {39, 18,   0}, // #14993
  {40, 18,   0}, // #14994
  {42,  1,   0}, // #14995
  {43,  1,   0}, // #14996
  {14, 18,   0}, // #14997
  {16, 18,   0}, // #14998
  {20, 18,   0}, // #14999
  {21, 18,   0}, // #15000
  {24, 18,   0}, // #15001
  {25, 18,   0}, // #15002
  {27, 18,   0}, // #15003
  {28, 18,   0}, // #15004
  {29, 18,   0}, // #15005
  {33, 18,   0}, // #15006
  {34, 18,   0}, // #15007
  {35, 18,   0}, // #15008
  {36, 18,   0}, // #15009
  {37, 18,   0}, // #15010
  {39, 18,   0}, // #15011
  {40, 18,   0}, // #15012
  {42, 30,   0}, // #15013
  { 4,  1,   0}, // #15014
  {11,  2,   0}, // #15015
  {41,  3,   0}, // #15016
  {42,  1,   0}, // #15017
  {43,  1,   0}, // #15018
  { 4,  3,   0}, // #15019
  {41,  3,   0}, // #15020
  {42,  1,   0}, // #15021
  {43,  1,   0}, // #15022
  { 4,  1,   0}, // #15023
  {11, 12,   0}, // #15024
  {41, 13,   0}, // #15025
  {42,  1,   0}, // #15026
  {43,  1,   0}, // #15027
  {11, 24,   0}, // #15028
  {41, 24,   0}, // #15029
  {11, 59,   0}, // #15030
  {41, 59,   0}, // #15031
  {10,  6,   0}, // #15032
  {11,  6,   0}, // #15033
  {41,  6,   0}, // #15034
  {10,  8,   0}, // #15035
  {11,  8,   0}, // #15036
  {41,  8,   0}, // #15037
  { 4,  1,   0}, // #15038
  {14,  1,   0}, // #15039
  {15,  1,   0}, // #15040
  {20,  1,   0}, // #15041
  {21,  1,   0}, // #15042
  {24,  1,   0}, // #15043
  {28,  1,   0}, // #15044
  {29,  1,   0}, // #15045
  {33,  1,   0}, // #15046
  {34,  1,   0}, // #15047
  {36,  1,   0}, // #15048
  {37,  1,   0}, // #15049
  {38,  1,   0}, // #15050
  {41,  1,   0}, // #15051
  {42,  1,   0}, // #15052
  {43,  1,   0}, // #15053
  { 4,  1,   0}, // #15054
  {14, 24,   0}, // #15055
  {28, 24,   0}, // #15056
  {33, 24,   0}, // #15057
  {36, 24,   0}, // #15058
  {37, 24,   0}, // #15059
  {41,  1,   0}, // #15060
  {42,  1,   0}, // #15061
  {43,  1,   0}, // #15062
  { 4,  1,   0}, // #15063
  {14, 62,   0}, // #15064
  {28, 62,   0}, // #15065
  {33, 62,   0}, // #15066
  {36, 62,   0}, // #15067
  {37, 62,   0}, // #15068
  {41,  1,   0}, // #15069
  {42,  1,   0}, // #15070
  {43,  1,   0}, // #15071
  { 4,  1,   0}, // #15072
  {11,  4,   0}, // #15073
  {41,  5,   0}, // #15074
  {42,  1,   0}, // #15075
  {44,  1,   0}, // #15076
  { 4,  1,   0}, // #15077
  {14,  1,   0}, // #15078
  {16,  1,   0}, // #15079
  {20,  1,   0}, // #15080
  {21,  1,   0}, // #15081
  {24,  1,   0}, // #15082
  {25,  1,   0}, // #15083
  {27,  1,   0}, // #15084
  {28,  1,   0}, // #15085
  {29,  1,   0}, // #15086
  {33,  1,   0}, // #15087
  {34,  1,   0}, // #15088
  {35,  1,   0}, // #15089
  {36,  1,   0}, // #15090
  {37,  1,   0}, // #15091
  {39,  1,   0}, // #15092
  {40,  1,   0}, // #15093
  {41,  1,   0}, // #15094
  {42,  1,   0}, // #15095
  {43,  1,   0}, // #15096
  {14,  1,   0}, // #15097
  {15,  1,   0}, // #15098
  {19,  1,   0}, // #15099
  {20,  1,   0}, // #15100
  {21,  1,   0}, // #15101
  {24,  1,   0}, // #15102
  {28,  1,   0}, // #15103
  {29,  1,   0}, // #15104
  {32,  1,   0}, // #15105
  {33,  1,   0}, // #15106
  {34,  1,   0}, // #15107
  {36,  1,   0}, // #15108
  {37,  1,   0}, // #15109
  {38,  1,   0}, // #15110
  {42,  1,   0}, // #15111
  {44,  1,   0}, // #15112
  { 4,  1,   0}, // #15113
  {14,  8,   0}, // #15114
  {28,  8,   0}, // #15115
  {33,  8,   0}, // #15116
  {36,  8,   0}, // #15117
  {37,  8,   0}, // #15118
  {41,  1,   0}, // #15119
  {42,  1,   0}, // #15120
  {43,  1,   0}, // #15121
  {14,  3,   0}, // #15122
  {28,  3,   0}, // #15123
  {33,  3,   0}, // #15124
  {36,  3,   0}, // #15125
  {37,  3,   0}, // #15126
  { 4,  1,   0}, // #15127
  {14,  3,   0}, // #15128
  {28,  3,   0}, // #15129
  {33,  3,   0}, // #15130
  {36,  3,   0}, // #15131
  {37,  3,   0}, // #15132
  {41,  1,   0}, // #15133
  {42,  1,   0}, // #15134
  {43,  1,   0}, // #15135
  { 4,  1,   0}, // #15136
  {14,  2,   0}, // #15137
  {28,  2,   0}, // #15138
  {33,  2,   0}, // #15139
  {36,  2,   0}, // #15140
  {37,  2,   0}, // #15141
  {41,  1,   0}, // #15142
  {42,  1,   0}, // #15143
  {43,  1,   0}, // #15144
  { 4,  1,   0}, // #15145
  {11,  7,   0}, // #15146
  {41,  8,   0}, // #15147
  {42,  2,   0}, // #15148
  {43,  1,   0}, // #15149
  {44,  1,   0}, // #15150
  { 4,  1,   0}, // #15151
  {10,  8,   0}, // #15152
  {11,  8,   0}, // #15153
  {41,  9,   0}, // #15154
  {42,  1,   0}, // #15155
  {43,  1,   0}, // #15156
  { 4,  1,   0}, // #15157
  {14,  2,   0}, // #15158
  {16,  2,   0}, // #15159
  {20,  2,   0}, // #15160
  {21,  2,   0}, // #15161
  {24,  2,   0}, // #15162
  {25,  2,   0}, // #15163
  {27,  2,   0}, // #15164
  {28,  2,   0}, // #15165
  {29,  2,   0}, // #15166
  {33,  2,   0}, // #15167
  {34,  2,   0}, // #15168
  {35,  2,   0}, // #15169
  {36,  2,   0}, // #15170
  {37,  2,   0}, // #15171
  {39,  2,   0}, // #15172
  {40,  2,   0}, // #15173
  {41,  1,   0}, // #15174
  {42,  1,   0}, // #15175
  {43,  1,   0}, // #15176
  {14,  1,   0}, // #15177
  {30,  1,   0}, // #15178
  {14,  6,   0}, // #15179
  {22,  6,   0}, // #15180
  {23,  6,   0}, // #15181
  {26,  6,   0}, // #15182
  {27,  6,   0}, // #15183
  {28,  6,   0}, // #15184
  {31,  6,   0}, // #15185
  {33,  6,   0}, // #15186
  {36,  6,   0}, // #15187
  {37,  6,   0}, // #15188
  {14,  3,   0}, // #15189
  {20,  3,   0}, // #15190
  {21,  3,   0}, // #15191
  {24,  3,   0}, // #15192
  {28,  3,   0}, // #15193
  {29,  3,   0}, // #15194
  {33,  3,   0}, // #15195
  {34,  3,   0}, // #15196
  {36,  3,   0}, // #15197
  {37,  3,   0}, // #15198
  {14,  5,   0}, // #15199
  {20,  5,   0}, // #15200
  {21,  5,   0}, // #15201
  {24,  5,   0}, // #15202
  {28,  5,   0}, // #15203
  {29,  5,   0}, // #15204
  {33,  5,   0}, // #15205
  {34,  5,   0}, // #15206
  {36,  5,   0}, // #15207
  {37,  5,   0}, // #15208
  {14,  6,   0}, // #15209
  {20,  2,   0}, // #15210
  {21,  2,   0}, // #15211
  {22,  2,   0}, // #15212
  {23,  2,   0}, // #15213
  {24,  2,   0}, // #15214
  {25,  2,   0}, // #15215
  {26,  2,   0}, // #15216
  {27,  4,   0}, // #15217
  {28,  6,   0}, // #15218
  {29,  2,   0}, // #15219
  {31,  2,   0}, // #15220
  {33,  6,   0}, // #15221
  {34,  2,   0}, // #15222
  {35,  2,   0}, // #15223
  {36,  6,   0}, // #15224
  {37,  6,   0}, // #15225
  {39,  2,   0}, // #15226
  {40,  2,   0}, // #15227
  {14,  2,   0}, // #15228
  {27,  2,   0}, // #15229
  {28,  2,   0}, // #15230
  {33,  2,   0}, // #15231
  {36,  2,   0}, // #15232
  {37,  2,   0} // #15233
}; // X86WriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry X86WriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 WriteALU_WriteZero_WriteVecALU_WriteJump_WriteMove_WriteLEA_WriteRMW_WriteADC_WriteFSign_WriteNop_WriteFLogic_WriteFBlend_WriteFVarBlend_WriteBSWAP32_WriteBitTest_WriteBitTestSet_WriteCMOV_WriteFCom_WriteVecALUX_WriteFLDC_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteFLD0_WriteFLD1_WriteVecMoveX_WriteVecShiftImm_WriteFMoveX_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVarShuffleX_WriteVecShiftImmX_WriteShift_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteVecALUY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecLogicY_WriteBlendY_WriteFVarShuffleY_WriteVecShiftImmY_WriteVarVecShift_WriteVarVecShiftY_WriteVarShuffleY_ADLPWriteResGroup40_ADLPWriteResGroup155_ADLPWriteResGroup151_ADLPWriteResGroup188_ADLPWriteResGroup189_ADLPWriteResGroup57_ADLPWriteResGroup21_ADLPWriteResGroup54_ADLPWriteResGroup22_ADLPWriteResGroup191_ADLPWriteResGroup6_ADLPWriteResGroup212_ADLPWriteResGroup173_ADLPWriteResGroup74_ADLPWriteResGroup77_ADLPWriteResGroup85_ADLPWriteResGroup128_ADLPWriteResGroup129_ADLPWriteResGroup130_ADLPWriteResGroup137_ADLPWriteResGroup144_ADLPWriteResGroup187_ADLPWriteResGroup210_ADLPWriteResGroup235_WriteCMPXCHGRMW_WriteJumpLd_WriteFStoreX_WriteFLoadX_AtomWrite0_1_WriteADCLd_WriteALULd_WriteFLogicLd_WriteBSWAP64_WriteBitTestImmLd_WriteCMOVLd_WriteLoad_WriteStore_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecLoadX_WriteFence_WriteVecStoreX_WriteVecMoveFromGpr_WriteVecStoreNT_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecLoadNT_WriteStoreNT_WriteFStoreNTX_WriteShuffleXLd_WriteVecLogicXLd_WriteRotate_WriteRotateCL_WriteShiftLd_WriteShiftCL_WriteSETCC_WriteVecShiftImmXLd_WriteFTestLd_AtomWrite1_1_AtomWrite0_1_1_AtomWrite01_1_WriteSHDrri_WriteLAHFSAHF_WriteVecMoveToGpr_WriteVecTest_WriteSETCCStore_WriteSHDrrcl_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_WriteFStoreY_WriteBZHI_WriteFCMOV_WriteXCHG_WriteFComX_WriteFSqrt80_WriteSTMXCSR_WriteShuffle256_WriteVarShuffle256_WriteVecStoreY_WriteVPMOV256_WriteVecTestY_WriteFTestY_PdWriteTST_F_UCOM_FPPr_PdWriteLEA16r_PdWriteADCSBB64ri32_PdWriteVMOVUPDYmrVMOVUPSYmr_PdWriteVMOVDQUYmr_PdWriteMOVDQArr_PdWriteSETGEmSETGmSETLEmSETLm_WriteBEXTR_WriteFCmp64X_WriteFCmpX_WriteMMXMOVMSK_WriteFMOVMSK_WriteVecMOVMSK_WritePOPCNT_WriteVecShiftX_WriteFVarBlendY_WriteFCmpY_WriteFCmp64Y_WriteVecStoreNTY_WriteFStoreNTY_WriteVarBlendY_WriteVecShiftY_ZnWriteFPU3Lat1_ZnWriteFLDr_ZnWriteFPU0Lat1_ZnWriteFXCH_ZnWriteJCXZ_ZnWriteLD_F80m_ZnWriteLOOPE_ZnWriteCMPXCHG8B_ZnWriteRET_ZnWritePCMPGTQr_ZnWriteFPU01Y_ZnWriteCALLr_ZnXADD_ZnWriteFPU013_ZnWriteSHA1MSG2r_ZnWriteSHA1NEXTEr_WriteBLS_BWWriteResGroup10_BWWriteResGroup2_BWWriteResGroup5_BWWriteResGroup6_BWWriteResGroup4_BWWriteResGroup7_BWWriteResGroup8_BWWriteResGroup9_WriteLZCNT_WritePHAdd_WriteFShuffle256_JWriteVecExtractF128_JWriteZeroIdiomYmm_WriteShuffleZ_WriteFLogicZ_WriteVecALUZ_WriteFMoveZ_WriteFShuffleZ_WriteVecMoveZ_WriteVecLogicZ_WriteFVarShuffleZ_WriteVecShiftImmZ_WriteVarVecShiftZ_WriteVarShuffleZ_SKXWriteResGroup9_SKXWriteResGroup11_SKXWriteResGroup3_SKXWriteResGroup6_SKXWriteResGroup7_SKXWriteResGroup4_SKXWriteResGroup8_SKXWriteResGroup10_SKXWritePSUB_WriteCvtSS2SD_WriteFVarShuffle256_SBWriteResGroup2_SBWriteResGroup5_SBWriteResGroup1_SBWriteResGroup4_SBWriteResGroupVzeroupper_WriteBitTestRegLd_HWWriteBTRSCmr_HWWrite2P1_HWWriteP01_HWWrite2P01_HWWrite2P0156_P23_HWWriteResGroup1_HWWriteINTO_HWWritePushA_HWWritePopA_HWWriteP1_HWWriteBOUND_HWWriteResGroup3_HWWriteResGroup6_HWWriteResGroup7_HWWrite3P01_HWWriteP0156_P23_HWWriteRETI_HWWriteRDPMC_HWWriteRDRAND_HWWriteFNSAVE_HWWriteFRSTOR_HWWriteResGroup2_HWWriteResGroup5_HWWriteResGroup8_HWWriteResGroup9_HWWriteResGroup10_HWWriteADC0_WriteFVarBlendZ_WriteVarBlendZ_SPRWriteResGroup43_SPRWriteResGroup164_SPRWriteResGroup160_SPRWriteResGroup193_SPRWriteResGroup52_SPRWriteResGroup61_SPRWriteResGroup23_SPRWriteResGroup58_SPRWriteResGroup24_SPRWriteResGroup195_SPRWriteResGroup216_SPRWriteResGroup95_SPRWriteResGroup137_SPRWriteResGroup92_SPRWriteResGroup78_SPRWriteResGroup81_SPRWriteResGroup89_SPRWriteResGroup138_SPRWriteResGroup139_SPRWriteResGroup140_SPRWriteResGroup147_SPRWriteResGroup153_SPRWriteResGroup192_SPRWriteResGroup214_SPRWriteResGroup240_SPRWriteResGroup508_ICXWriteResGroup9_ICXWriteResGroup11_ICXWriteResGroup3_ICXWriteResGroup6_ICXWriteResGroup7_ICXWriteResGroup4_ICXWriteResGroup8_ICXWriteResGroup10_ICXWritePSUB_SKLWriteResGroup9_SKLWriteResGroup11_SKLWriteResGroup3_SKLWriteResGroup6_SKLWriteResGroup7_SKLWriteResGroup4_SKLWriteResGroup8_SKLWriteResGroup10_SKLWritePSUB_Zn2WriteFPU3Lat1_Zn2WriteFLDr_Zn2WriteFPU0Lat1_Zn2WriteFXCH_Zn2WriteJCXZ_Zn2WriteLD_F80m_Zn2WriteLOOPE_Zn2WriteCMPXCHG8B_Zn2WriteRET_Zn2WritePCMPGTQr_Zn2WriteFPU01Y_Zn2WriteCALLr_Zn2XADD_Zn2WriteFPU013_Zn2WriteSHA1MSG2r_Zn2WriteSHA1NEXTEr_Zn2WriteXCHG_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_Zn3WriteLFENCE_Zn3WriteMoveExtend_Zn3WriteVecALUXMMX_Zn3WriteRotateR1_Zn3WriteMOVBEmr_Zn3WriteCvtPD2IMMX_Zn3WriteSHA1MSG2rr_SHA1NEXTErr_Zn3WriteALUSlow_Zn3WriteMaterialize32bitImm_Zn3WriteADC8mr_SBB8mr_Zn3WriteWriteXCHGUnrenameable_Zn3WritePOPCNT16rr_Zn3WriteLZCNT16rr_Zn3WriteMOVMMX_Zn3WriteMOVMMXSlow_Zn3WriteVecALUXSlow_Zn3WriteVecALUYSlow_Zn3WriteSFENCE_WriteBSF_WriteBSR_WriteCvtSD2I_WriteVecShiftZ_Zn4WriteLFENCE_Zn4WriteMoveExtend_Zn4WriteRotateR1_Zn4WriteMOVBEmr_Zn4WriteSHA1MSG2rr_SHA1NEXTErr_Zn4WriteALUSlow_Zn4WriteMaterialize32bitImm_Zn4WriteADC8mr_SBB8mr_Zn4WriteWriteXCHGUnrenameable_Zn4WritePOPCNT16rr_Zn4WriteLZCNT16rr_Zn4WriteMOVMMX_Zn4WriteMOVMMXSlow_Zn4WriteVecALUYSlow_Zn4WriteSFENCE_Zn4WriteVecOpMask_Zn4WriteVecOpMaskMemMov_Zn4WriteVecOpMaskKRMov_Zn4WriteSHIFTri
  {12,  0}, // #2 WriteCMPXCHGRMW_WriteFStoreX_WriteFStoreY_WriteRMW_WriteAESDecEncLd_WriteAESKeyGenLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2ILd_WriteStore_WriteFHAddLd_WriteVecStoreX_WriteShiftLd_WriteSHDmrcl_WriteSHDmri_WriteFSqrtX_WriteSTMXCSR_WriteFCmpYLd_WriteFCmp64YLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFMAYLd_WriteVecStoreY_WriteMPSADYLd_WriteFMulYLd_WriteFMul64YLd_WriteVecTestYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFSqrtY_ADLPWriteResGroup36_ADLPWriteResGroup179_ADLPWriteResGroup50_ADLPWriteResGroup176_ADLPWriteResGroup139_ADLPWriteResGroup120_ADLPWriteResGroup142_ADLPWriteResGroup115_ADLPWriteResGroup229_ADLPWriteResGroup69_ADLPWriteResGroup127_ADLPWriteResGroup134_WriteIMul64Ld_WriteIMul64RegLd_WriteDPPD_WriteFRcpXLd_WriteFRsqrtXLd_WriteDiv8_WriteVecExtract_WriteIDiv8_WriteFMOVMSK_WriteCLMul_WritePCmpIStrMLd_WriteVecMOVMSK_PdWriteRCL8rCL_PdWriteRCR8ri_PdWriteVPCLMULQDQrri_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteCvtPD2IYLd_WriteFMAXLd_ZnWriteCVTPD2DQLd_ZnWriteFIST_ZnWriteFPU03_ZnWriteCVSTSI2SILd_WriteMPSADLd_WriteCvtPD2PSYLd_WriteFRndYLd_BWWriteResGroup135_WriteCvtSS2SDLd_WritePCmpIStrILd_WriteDPPSY_WriteCLMulLd_WriteVecIMulYLd_WriteVecIMulZLd_SKXWriteResGroup200_SKXWriteResGroup175_SKXWriteResGroup176_SKXWriteResGroup177_WriteAESIMC_WritePSADBWYLd_WritePSADBWZLd_WriteFHAddYLd_WriteFMulZLd_WriteFMul64ZLd_WritePMULLDYLd_WritePMULLDZLd_SBWriteResGroup111_WriteFRndLd_WriteFMAZLd_WriteCvtI2PDZLd_WriteCvtPD2IZLd_HWWriteResGroup91_3_WriteFAddYLd_WriteFAddZLd_WriteFCmpZLd_WriteCvtI2PSZLd_WriteCvtPS2PHZSt_WriteFRndZLd_WriteFCmp64ZLd_SPRWriteResGroup37_SPRWriteResGroup185_SPRWriteResGroup54_SPRWriteResGroup182_SPRWriteResGroup554_SPRWriteResGroup148_SPRWriteResGroup129_SPRWriteResGroup151_SPRWriteResGroup124_SPRWriteResGroup235_SPRWriteResGroup449_SPRWriteResGroup504_SPRWriteResGroup501_SPRWriteResGroup505_SPRWriteResGroup502_SPRWriteResGroup257_SPRWriteResGroup73_SPRWriteResGroup136_SPRWriteResGroup144_SPRWriteResGroup265_SPRWriteResGroup272_SPRWriteResGroup303_SPRWriteResGroup347_SPRWriteResGroup351_SPRWriteResGroup419_SPRWriteResGroup444_SPRWriteResGroup446_SPRWriteResGroup465_SPRWriteResGroup467_SPRWriteResGroup489_SPRWriteResGroup517_SPRWriteResGroup518_SPRWriteResGroup546_ICXWriteResGroup200_ICXWriteResGroup175_ICXWriteResGroup176_ICXWriteResGroup177_Zn2WriteFIST_Zn2WriteFPU03_WriteVarShuffle256Ld_WriteFRcpZLd_WriteFRsqrtZLd
  { 6,  0}, // #3 WriteJumpLd_WriteBEXTR_WriteBitTestImmLd_WriteFHAdd_WriteCvtPH2PS_WriteCvtPS2PH_WriteVecTestY_ADLPWriteResGroup95_ADLPWriteResGroup5_ADLPWriteResGroup94_ADLPWriteResGroup154_ADLPWriteResGroup238_ADLPWriteResGroup53_ADLPWriteResGroup234_ADLPWriteResGroup30_ADLPWriteResGroup209_ADLPWriteResGroup111_ADLPWriteResGroup232_ADLPWriteResGroup224_ADLPWriteResGroup228_ADLPWriteResGroup141_ADLPWriteResGroup153_WriteFAdd64X_WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul16Imm_WriteIMul32_WriteFLD1_AtomWrite01_6_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCMPXCHG_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLZCNTLd_WritePHAdd_WritePHAddX_WritePOPCNTLd_WriteFRndLd_WriteTZCNTLd_PdWriteALURMW_WriteRMW_WriteBEXTRLd_WriteBLSLd_WriteIMul64_WriteIMul64Reg_WriteIMul64Imm_WriteVecInsertLd_WriteStore_WriteVecTestLd_WriteShuffle256Ld_WriteVarShuffle256Ld_WriteFMaskedStore64Y_WriteFMaskedLoadY_WriteFMaskedStore32Y_WriteVecMaskedLoadY_WriteVPMOV256Ld_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_PdWriteXLAT_PdWriteXADDm_PdWriteVBROADCASTYLd_PdWriteFCOMPm_PdWriteMMX_CVTPD2PIrrMMX_CVTPI2PDrr_PdWriteLXADD_PdWriteBMI1m_PdWriteCRC32r32r32_PdWriteMMX_CVTTPD2PIrr_ZnWriteBTRSCm_ZnWriteSHA1RNDS4r_WriteFLoadY_WriteADCLd_WriteALULd_WriteFLogicLd_WriteFBlendLd_WriteBitTestRegLd_WriteBZHILd_WriteCMOVLd_WriteCvtPS2PDLd_WriteCvtSS2SDLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVarShuffleLd_WriteVecShiftLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteShiftLd_WriteSHDrrcl_WriteCvtPD2PSY_WriteCvtI2PDY_WriteCvtPD2IY_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_BWWriteResGroup69_BWWriteResGroup66_BWWriteResGroup70_BWWriteResGroup58_BWWriteResGroup71_BWWriteResGroup36b_BWWriteResGroup65_BWWriteResGroup62_BWWriteResGroup68_BWWriteResGroup59_BWWriteResGroup64_WriteIMul16Ld_WriteIMul16RegLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddLd_WriteFLogicYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFShuffleYLd_JWriteVBROADCASTYLd_WriteFLoadX_WriteCvtSD2I_WriteCvtSS2I_WriteVecLoadX_WriteCLMul_WriteCvtPS2PHSt_WriteFHAddY_SKXWriteResGroup86_SKXWriteResGroup72_SKXWriteResGroup81_SKXWriteResGroup82_SKXWriteResGroup87_SKXWriteResGroup88_SKXWriteResGroup44c_SKXWriteResGroup71_SKXWriteResGroup76_SKXWriteResGroup84_SKXWriteResGroup92a_SKXWriteResGroup79_SKXWriteResGroup73_SKXWriteResGroup80_SBWriteResGroup48_SBWriteResGroup53_SBWriteResGroup81_SBWriteResGroup49_SBWriteResGroup51_SBWriteResGroup52_WriteCvtI2PDZ_WriteCvtPD2IZ_WriteCvtPS2PHZ_WriteFRndZ_HWWriteResGroup18_HWWriteResGroup108_HWWriteResGroup60b_HWWriteResGroup0_HWWriteResGroup14_HWWriteResGroup107_HWWriteResGroup13_HWWriteResGroup16_SPRWriteResGroup104_SPRWriteResGroup5_SPRWriteResGroup103_SPRWriteResGroup163_SPRWriteResGroup243_SPRWriteResGroup57_SPRWriteResGroup239_SPRWriteResGroup32_SPRWriteResGroup213_SPRWriteResGroup120_SPRWriteResGroup237_SPRWriteResGroup230_SPRWriteResGroup234_SPRWriteResGroup494_SPRWriteResGroup150_SPRWriteResGroup162_SPRWriteResGroup251_SPRWriteResGroup253_SPRWriteResGroup365_SPRWriteResGroup437_SPRWriteResGroup438_SPRWriteResGroup443_SPRWriteResGroup520_SPRWriteResGroup538_ICXWriteResGroup86_ICXWriteResGroup72_ICXWriteResGroup81_ICXWriteResGroup82_ICXWriteResGroup87_ICXWriteResGroup88_ICXWriteResGroup44c_ICXWriteResGroup71_ICXWriteResGroup76_ICXWriteResGroup84_ICXWriteResGroup79_ICXWriteResGroup73_ICXWriteResGroup80_SKLWriteResGroup82_SKLWriteResGroup68_SKLWriteResGroup76_SKLWriteResGroup78_SKLWriteResGroup83_SKLWriteResGroup84_SKLWriteResGroup42c_SKLWriteResGroup67_SKLWriteResGroup72_SKLWriteResGroup80_SKLWriteResGroup88_SKLWriteResGroup75_SKLWriteResGroup69_Zn2WriteBTRSCm_Zn2WriteSHA1RNDS4r_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrM_WriteSHDmrcl_WriteSHDmri_Zn3WriteXCHG32rm_XCHG64rm_Zn3Writerm_SHA256MSG1rm_Zn3WriteSHA1RNDS4rri_Zn3WriteSHA1MSG1rm_Zn3WriteVPERMYri_WriteCvtPD2PSZ_WriteCvtPS2PDZ_Zn4WriteXCHG32rm_XCHG64rm_Zn4Writerm_SHA256MSG1rm_Zn4WriteSHA1RNDS4rri_Zn4WriteSHA1MSG1rm_Zn4WriteVPERMYri_Zn4WriteSCALErr_Zn4WriteBF16_Zn4CONFLICTrr
  {100,  0}, // #4 WriteSystem_WriteMicrocoded_ADLPWriteResGroup168_ADLPWriteResGroup198_ADLPWriteResGroup68_ADLPWriteResGroup269_ADLPWriteResGroup27_ADLPWriteResGroup201_ADLPWriteResGroup203_ADLPWriteResGroup28_ADLPWriteResGroup82_ADLPWriteResGroup96_ADLPWriteResGroup97_ADLPWriteResGroup98_ADLPWriteResGroup99_ADLPWriteResGroup100_ADLPWriteResGroup101_ADLPWriteResGroup135_ADLPWriteResGroup166_ADLPWriteResGroup167_ADLPWriteResGroup184_ADLPWriteResGroup185_ADLPWriteResGroup186_ADLPWriteResGroup199_ADLPWriteResGroup200_ADLPWriteResGroup205_ADLPWriteResGroup218_ADLPWriteResGroup236_ADLPWriteResGroup239_ADLPWriteResGroup270_ZnWriteMicrocoded_SPRWriteResGroup177_SPRWriteResGroup202_SPRWriteResGroup72_SPRWriteResGroup556_SPRWriteResGroup29_SPRWriteResGroup205_SPRWriteResGroup207_SPRWriteResGroup30_SPRWriteResGroup86_SPRWriteResGroup105_SPRWriteResGroup106_SPRWriteResGroup107_SPRWriteResGroup108_SPRWriteResGroup109_SPRWriteResGroup110_SPRWriteResGroup145_SPRWriteResGroup175_SPRWriteResGroup176_SPRWriteResGroup189_SPRWriteResGroup190_SPRWriteResGroup191_SPRWriteResGroup203_SPRWriteResGroup204_SPRWriteResGroup209_SPRWriteResGroup224_SPRWriteResGroup241_SPRWriteResGroup244_SPRWriteResGroup557_SPRWriteResGroup576_Zn2WriteMicrocoded
  { 3,  0}, // #5 WriteSHDrri_WriteFAdd64X_WriteFAddX_WriteBSF_WriteBSR_WriteBZHI_WriteFCMOV_WriteCMPXCHG_WriteFComX_WriteCRC32_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteLAHFSAHF_WriteLZCNT_WriteVecMoveToGpr_WriteVecMoveFromGpr_WritePHAdd_WriteMMXMOVMSK_WritePSADBW_WriteVarShuffle_WriteFMOVMSK_WriteCLMul_WriteVecMOVMSK_WritePOPCNT_WritePSADBWX_WriteTZCNT_WriteFAddY_WriteFAdd64Y_WriteFVarBlendY_WriteShuffle256_WriteFShuffle256_WriteVarShuffle256_WritePSADBWY_WriteVarBlendY_WriteFVarShuffle256_WriteVPMOV256_WriteFTest_ADLPWriteResGroup23_ADLPWriteResGroup104_ADLPWriteResGroup103_ADLPWriteResGroup63_ADLPWriteResGroup118_ADLPWriteResGroup20_ADLPWriteResGroup64_ADLPWriteResGroup170_ADLPWriteResGroup24_ADLPWriteResGroup19_ADLPWriteResGroup226_ADLPWriteResGroup16_ADLPWriteResGroup119_ADLPWriteResGroup124_ADLPWriteResGroup8_ADLPWriteResGroup217_ADLPWriteResGroup245_WriteVecShiftLd_WriteVecShiftXLd_AtomWrite01_3_WriteFLoadX_WriteLoad_WriteXCHG_WriteFCmp64X_WriteFCmpX_WriteVecLoadX_WriteVecLoadNT_WriteFRnd_WriteFMaskedLoad_WriteVecMaskedLoad_WriteCMPXCHGRMW_WriteFLDC_WriteFLD0_WriteFLD1_WriteFStoreNTX_WriteVarShuffleX_WriteSHDrrcl_WriteFStoreNTY_WriteFVarShuffleY_WriteVarVecShift_PdWriteCMPXCHG8rm_PdWriteCMPXCHG8rr_PdWriteCMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm_PdWriteCMPXCHG8B_PdWriteCMPXCHG16B_PdWriteEXTRQ_PdWriteINSERTQI_PdWriteSHLD16rrCLSHLD32rrCLSHRD32rrCL_ZnWriteCVTPS2PDr_ZnWriteMul16_ZnWriteMul32_WriteFMulX_WriteMULX32_WriteMULX64_WritePHAddX_ZnWriteVCVTPS2PDY_WriteFMulY_WritePHAddY_WriteVarVecShiftY_ZnWriteVPERM2r_WriteCvtI2PS_WriteCvtPS2I_WriteFMul64X_WriteRotateCL_WriteShiftCL_WriteFCmpY_WriteFCmp64Y_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMul64Y_WriteVecMOVMSKY_BWWriteResGroup34_BWWriteResGroup38_BWWriteResGroup37_BWWriteResGroup27_BWWriteResGroup28_BWWriteResGroup33_BWWriteSETA_SETBEm_WriteAESDecEnc_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteVecExtractSt_WriteLDMXCSR_WriteMPSAD_WriteVecTest_WriteCvtPH2PSY_WriteCvtI2PDY_WriteCvtPS2PH_WriteFRndY_JSlowLEA16r_JWriteCMPXCHG8rr_WriteCvtPS2PD_WriteCvtSS2SD_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2IZ_WriteCvtPS2PDY_WriteCvtPS2PDZ_WritePSADBWZ_WriteVecTestY_SKXWriteResGroup42_SKXWriteResGroup34_SKXWriteResGroup48_SKXWriteResGroup47_SKXWriteResGroup45_SKXWriteResGroup31_SKXWriteResGroup32_SKXWriteResGroup30_SKXWriteResGroup37_SKXWriteResGroup38_SKXWritePCMPGTQ_SKXWriteSETA_SETBEm_WriteVecALU_WriteFAddZ_WriteFAdd64Z_WriteFCmpZ_WriteCvtI2PSZ_WriteCvtPH2PSZ_WriteFRndZ_WriteFCmp64Z_SBWriteResGroup30_SBWriteResGroup21_SBWriteResGroup22_SBWriteResGroup24_SBWriteResGroup26_2_SBWriteCMOVA_CMOVBErr_SBWriteSETA_SETBEm_WriteVarVecShiftZ_HWWriteResGroup58_HWWriteResGroup45_HWWriteResGroup44_HWWriteResGroup50_HWWriteResGroup51_HWWriteResGroup57_HWWriteCMOVA_CMOVBErr_HWWriteSETA_SETBEm_WriteMove_WriteShuffleZ_WriteVecALUZ_WriteVarShuffleZ_SPRWriteResGroup25_SPRWriteResGroup113_SPRWriteResGroup112_SPRWriteResGroup67_SPRWriteResGroup127_SPRWriteResGroup22_SPRWriteResGroup68_SPRWriteResGroup26_SPRWriteResGroup21_SPRWriteResGroup232_SPRWriteResGroup18_SPRWriteResGroup128_SPRWriteResGroup133_SPRWriteResGroup418_SPRWriteResGroup250_SPRWriteResGroup96_SPRWriteResGroup263_SPRWriteResGroup223_SPRWriteResGroup260_SPRWriteResGroup267_SPRWriteResGroup441_ICXWriteResGroup42_ICXWriteResGroup34_ICXWriteResGroup36_ICXWriteResGroup48_ICXWriteResGroup47_ICXWriteResGroup45_ICXWriteResGroup31_ICXWriteResGroup32_ICXWriteResGroup30_ICXWriteResGroup37_ICXWriteResGroup38_ICXWritePCMPGTQ_ICXWriteSETA_SETBEm_SKLWriteResGroup40_SKLWriteResGroup32_SKLWriteResGroup46_SKLWriteResGroup45_SKLWriteResGroup43_SKLWriteResGroup29_SKLWriteResGroup30_SKLWriteResGroup35_SKLWriteResGroup36_SKLWritePCMPGTQ_SKLWriteSETA_SETBEm_Zn2WriteCVTPD2PSr_Zn2WriteCVTPS2PDr_Zn2WriteCVTSS2SDr_Zn2WriteMul16_Zn2WriteMul32_Zn2WriteCVTPD2PSYr_Zn2WriteVCVTPS2PDY_WriteFTestY_Zn2WriteCVTPD2DQr_Zn2WriteVPERM2r_Zn2WriteCVTDQ2PDr_Zn2WriteCVSTSI2SDr_Zn2WriteEXTRQ_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMulX_WritePHMINPOS_WritePMULLD_WriteFRcpX_WriteFRsqrtX_WriteVecIMulY_WritePMULLDY_WriteFRcpY_WriteFRsqrtY_Zn3WriteCvtI2PSMMX_Zn3WriteCMPXCHG8rr_Zn3WriteCMPXCHG8B_Zn3WriteRotateRightRI_Zn3WriteRotateRightRCL_Zn3WriteVPERM2I128rr_VPERM2F128rr_Zn3WriteEXTRQI_INSERTQI_Zn3WriteSHA256MSG2rr_Zn3WritePDEP_PEXT_Zn3WriteEXTRQ_INSERTQ_WriteVecIMulZ_WriteFMulZ_WriteFMul64Z_WriteFVarShuffleZ_WritePMULLDZ_Zn4WriteCMPXCHG8rr_Zn4WriteCMPXCHG8B_Zn4WriteRotateRightRI_Zn4WriteRotateRightRCL_Zn4WriteVPERM2I128rr_VPERM2F128rr_Zn4WriteEXTRQI_INSERTQI_Zn4WriteSHA256MSG2rr_Zn4WritePDEP_PEXT_Zn4WriteEXTRQ_INSERTQ_Zn4VPTESTZ128_Zn4PERMIT2_128
  { 7,  0}, // #6 WriteFLoadX_WriteAESKeyGen_WriteBLSLd_WriteCMOVLd_WriteCvtSD2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2I_WriteVecLoadX_WriteLDMXCSR_WriteVecLoadNT_WriteCvtPD2PSY_WriteCvtI2PDY_WriteCvtPD2IY_WriteCvtPS2PDY_ADLPWriteResGroup112_ADLPWriteResGroup152_ADLPWriteResGroup92_ADLPWriteResGroup58_ADLPWriteResGroup278_ADLPWriteResGroup208_ADLPWriteResGroup241_ADLPWriteResGroup78_ADLPWriteResGroup18_ADLPWriteResGroup52_ADLPWriteResGroup195_ADLPWriteResGroup106_ADLPWriteResGroup140_ADLPWriteResGroup0_ADLPWriteResGroup12_ADLPWriteResGroup13_ADLPWriteResGroup41_ADLPWriteResGroup143_ADLPWriteResGroup256_WriteFAdd64XLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteIMul16_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddX_AtomWrite0_1_7_AtomWrite0_1_7_4_AtomWrite01_7_WriteFVarBlendLd_WriteCvtSD2SSLd_WriteIMul64_WriteVecIMulLd_WritePSADBWLd_WriteMPSAD_WriteFMul64X_WriteVarBlendLd_WritePHMINPOSLd_WriteFRcpLd_WriteFRsqrtLd_SLMWriteResGroup1rm_WriteFLogicLd_WriteFBlendLd_WriteBSFLd_PdWriteBTSIm_PdWriteBTSRm_WriteFCmp64Ld_WriteFCmpLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WritePCmpIStrM_WritePHAddXLd_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFCmpYLd_WriteFCmp64YLd_WriteFShuffleYLd_WriteVecShiftImmXLd_PdWriteRCR32riRCR64ri_PdWriteVBROADCASTF128_PdWriteVEXTRACTF128mr_PdWriteRCL3264rCL_PdWriteRCR3264rCL_PdWriteVPPERMLd_WriteFHAdd_WriteIMulHLd_WriteFHAddY_WriteRMW_WriteAESDecEnc_WriteBEXTRLd_WriteVecShiftXLd_WriteVecTestLd_WriteCvtPS2PHYSt_WriteVecALUYLd_WriteFMaskedLoad_WriteMPSADY_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoad_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestYLd_BWWriteResGroup80_BWWriteResGroup82_BWWriteResGroup90_BWWriteResGroup84_BWWriteResGroup89_BWWriteResGroup87_BWWriteResGroup88_BWWriteResGroup73_BWWriteResGroup77_BWWriteResGroup79_BWWriteResGroup74_BWWriteCMOVA_CMOVBErm_WriteAESIMCLd_WriteAESKeyGenLd_WriteCvtPS2PDLd_WriteVecIMulXLd_WriteVarShuffleLd_WriteFMulXLd_WriteFMulLd_WriteCLMulLd_WritePCmpIStrI_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRcpXLd_WriteFRsqrtXLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFLoadY_WriteFComXLd_WriteFComLd_WriteCvtPH2PSY_WriteCvtPD2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WriteVecLoadY_WriteFVarShuffleLd_WriteVarVecShiftLd_SKXWriteResGroup100_SKXWriteResGroup99_SKXWriteResGroup95_SKXWriteResGroup89_SKXWriteResGroup101_SKXWriteResGroup111_SKXWriteResGroup104_SKXWriteResGroup109_SKXWriteResGroup107_SKXWriteResGroup108_SKXWriteResGroup96_SKXWriteResGroup90_SKXWriteResGroup93_SKXWriteResGroup92_SKXWriteResGroup93z_SKXWriteResGroup97_SKXWriteResGroup103_SKXWriteResGroup106_SKXWriteResGroup110_SKXWriteResGroup112_SKXWriteResGroup113_SKXWriteResGroup114_SKXWriteCMOVA_CMOVBErm_WriteADCLd_WriteVecInsertLd_WriteCvtPS2PDZLd_WriteVecLoadNTY_WriteFRcpZ_WriteFRsqrtZ_WriteFTestLd_SBWriteResGroup69_SBWriteResGroup25_1_SBWriteResGroup63_SBWriteResGroup59_SBWriteResGroup68_SBWriteResGroup54_SBWriteResGroup58_SBWriteResGroup62_SBWriteResGroup64_SBWriteResGroup66_SBWriteResGroup67_WriteCvtPH2PSZLd_WriteCvtPH2PSYLd_WriteCvtPS2PHZSt_HWWriteResGroup25_HWWriteResGroup37_HWWriteResGroup26_HWWriteResGroup0_1_HWWriteResGroup39_HWWriteXLAT_HWWriteResGroup114_HWWriteResGroup41_HWWriteResGroup17_HWWriteResGroup11_1_HWWriteResGroup36_2_WriteCvtPD2IZ_SPRWriteResGroup121_SPRWriteResGroup161_SPRWriteResGroup82_SPRWriteResGroup62_SPRWriteResGroup565_SPRWriteResGroup212_SPRWriteResGroup246_SPRWriteResGroup20_SPRWriteResGroup199_SPRWriteResGroup115_SPRWriteResGroup149_SPRWriteResGroup464_SPRWriteResGroup39_SPRWriteResGroup268_SPRWriteResGroup0_SPRWriteResGroup15_SPRWriteResGroup44_SPRWriteResGroup152_SPRWriteResGroup415_SPRWriteResGroup93_SPRWriteResGroup271_SPRWriteResGroup470_SPRWriteResGroup486_SPRWriteResGroup488_ICXWriteResGroup100_ICXWriteResGroup99_ICXWriteResGroup95_ICXWriteResGroup89_ICXWriteResGroup101_ICXWriteResGroup111_ICXWriteResGroup104_ICXWriteResGroup109_ICXWriteResGroup107_ICXWriteResGroup108_ICXWriteResGroup92_ICXWriteResGroup96_ICXWriteResGroup90_ICXWriteResGroup93_ICXWriteResGroup93z_ICXWriteResGroup97_ICXWriteResGroup103_ICXWriteResGroup106_ICXWriteResGroup110_ICXWriteResGroup112_ICXWriteResGroup113_ICXWriteResGroup114_ICXWriteCMOVA_CMOVBErm_SKLWriteResGroup95_SKLWriteResGroup94_SKLWriteResGroup91_SKLWriteResGroup85_SKLWriteResGroup96_SKLWriteResGroup103_SKLWriteResGroup98_SKLWriteResGroup102_SKLWriteResGroup100_SKLWriteResGroup101_SKLWriteResGroup92_SKLWriteCMOVA_CMOVBErm_Zn2WriteMul16Ld_Zn2WriteMul32Ld_WriteMULX32Ld_WriteMULX64Ld_WriteFCMOV_WriteCRC32Ld_WriteIMul16Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFVarShuffle256_Zn3WriteCMPXCHG8rm_LCMPXCHG8_Zn3WriteVPERM2F128rm_Zn3WriteSHA256MSG2rm_Zn3WriteXCHG8rm_XCHG16rm_Zn3WriteRotateRightMI_Zn3WriteRotateRightMCL_WriteDPPD_Zn4WriteCMPXCHG8rm_LCMPXCHG8_Zn4WriteVPERM2F128rm_Zn4WriteSHA256MSG2rm_Zn4WriteXCHG8rm_XCHG16rm_Zn4WriteRotateRightMI_Zn4WriteRotateRightMCL_Zn4WriteVPERMPSYrr
  { 8,  0}, // #7 WriteFLoadY_WriteAESIMC_WriteFLogicLd_WriteFBlendLd_WriteFVarBlendLd_WriteBSFLd_WriteBSRLd_WriteBZHILd_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteVecALUXLd_WriteIMul16RegLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64RegLd_WriteIMul64ImmLd_WriteIMul8Ld_WriteFShuffleLd_WriteLZCNTLd_WriteVecInsertLd_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePOPCNTLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteFRnd_WriteTZCNTLd_WriteCvtPH2PSY_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteFMaskedLoad_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecMaskedLoad_WriteVarVecShiftLd_WriteFTestLd_ADLPWriteResGroup37_ADLPWriteResGroup38_ADLPWriteResGroup171_ADLPWriteResGroup117_ADLPWriteResGroup172_ADLPWriteResGroup110_ADLPWriteResGroup225_ADLPWriteResGroup192_ADLPWriteResGroup147_ADLPWriteResGroup150_ADLPWriteResGroup175_ADLPWriteResGroup216_ADLPWriteResGroup240_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WriteIMul16Ld_WritePHAddXLd_AtomWrite01_8_WriteAESDecEnc_WriteAESKeyGen_WriteCvtI2PSLd_WriteCvtPD2PSLd_WriteCvtPS2ILd_WriteCvtSD2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2ILd_WriteVecIMulXLd_WriteIMul32Ld_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePSADBWXLd_SLMWriteResGroup2rm_WriteVarShuffleLd_WriteVecShiftLd_WriteMPSAD_WriteCvtPD2PSY_WriteCvtI2PDY_WriteCvtPD2IY_WriteCvtPS2PDY_WriteFVarShuffleYLd_PdWriteVPERM2F128rm_PdWriteRCL3264ri_WriteCMPXCHGRMW_WriteFLoadX_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_ZnWriteMul16Ld_ZnWriteMul32Ld_WriteVecLoadX_ZnWriteFPU13_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteFStoreNT_WriteMULX32Ld_WriteMULX64Ld_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFCmpYLd_WriteFCmp64YLd_WriteVecALUYLd_WriteFMaskedLoadY_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteVarBlendYLd_WriteVPMOV256Ld_WriteVecShiftImmXLd_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_ZnWriteLEAVE_ZnWritePushA_ZnWritePCMPGTQm_ZnWriteBROADCAST_ZnWriteFPU01Op2_ZnWriteVPBROADCAST256Ld_ZnWritePCMPGTQYm_ZnWriteFPU0Lat1Ld_ZnWriteVPBROADCAST128Ld_ZnWriteVPERM2m_ZnWriteFPU013m_ZnWriteSHA1MSG2Ld_ZnWriteSHA1NEXTELd_BWWriteResGroup100_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteIMul16ImmLd_WritePHAddLd_WriteFMul64XLd_WriteVecMaskedLoadY_BWWriteResGroup97_BWWriteResGroup99_BWWriteResGroup154_BWWriteResGroup91_BWWriteResGroup92_WriteAESDecEncLd_WriteVecMoveFromGpr_WriteMPSADLd_WritePCmpIStrM_WriteVecTestLd_WriteFRndLd_WriteFAddYLd_WriteFAdd64YLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteFRndYLd_SKXWriteResGroup130_WriteCvtSS2SDLd_WritePSADBWLd_WriteShuffleZLd_WriteFLogicZLd_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteCvtPS2IZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteCvtPS2PHYSt_WriteCvtPS2PHZSt_WriteFRndZ_WriteVecALUZLd_WriteFShuffleZLd_WriteVecLogicZLd_WriteVarBlendZLd_WriteFVarShuffleZLd_WriteVecShiftImmZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_WriteVarShuffleZLd_WriteVecShiftZLd_SKXWriteResGroup127_SKXWriteResGroup128_SKXWriteResGroup118_SKXWriteResGroup119_SKXWriteResGroup121_SKXWriteResGroup123_SKXWriteResGroup131_SKXWriteResGroup132_SKXWriteResGroup133_SKXWriteResGroup134_WriteSHDmri_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteFVarShuffle256Ld_WriteFTestYLd_SBWriteResGroup86_SBWriteResGroup84_SBWriteResGroup77_SBWriteResGroup83_SBWriteResGroup85_SBWriteResGroup87_SBWriteCMOVA_CMOVBErm_HWWriteResGroup48_HWWriteResGroup46_HWWriteResGroup47_HWWriteResGroup145_HWWriteResGroup11_2_HWWriteResGroup12_HWWriteResGroup13_1_HWWriteResGroup17_2_HWWriteCMOVA_CMOVBErm_SPRWriteResGroup40_SPRWriteResGroup41_SPRWriteResGroup178_SPRWriteResGroup126_SPRWriteResGroup179_SPRWriteResGroup119_SPRWriteResGroup231_SPRWriteResGroup196_SPRWriteResGroup383_SPRWriteResGroup289_SPRWriteResGroup156_SPRWriteResGroup159_SPRWriteResGroup181_SPRWriteResGroup222_SPRWriteResGroup245_SPRWriteResGroup219_SPRWriteResGroup283_SPRWriteResGroup291_SPRWriteResGroup297_SPRWriteResGroup320_SPRWriteResGroup343_SPRWriteResGroup361_SPRWriteResGroup362_SPRWriteResGroup484_SPRWriteResGroup506_SPRWriteResGroup521_SPRWriteResGroup533_ICXWriteResGroup130_ICXWriteResGroup127_ICXWriteResGroup128_ICXWriteResGroup118_ICXWriteResGroup119_ICXWriteResGroup121_ICXWriteResGroup123_ICXWriteResGroup131_ICXWriteResGroup132_ICXWriteResGroup133_ICXWriteResGroup134_SKLWriteResGroup119_SKLWriteResGroup116_SKLWriteResGroup117_SKLWriteResGroup107_SKLWriteResGroup108_SKLWriteResGroup110_SKLWriteResGroup112_Zn2WriteMul64Ld_Zn2WriteFPU13_Zn2WriteLEAVE_Zn2WritePushA_Zn2WritePCMPGTQm_Zn2WriteBROADCAST_Zn2WriteFPU01Op2_Zn2WriteVPBROADCAST256Ld_Zn2WritePCMPGTQYm_Zn2WriteFPU0Lat1Ld_Zn2WriteVPBROADCAST128Ld_Zn2WriteVPERM2m_Zn2WriteFPU013m_Zn2WriteSHA1MSG2Ld_Zn2WriteSHA1NEXTELd_WriteFLD0_WriteVecTestYLd_Zn3WriteVINSERTF128rmr_Zn3WriteVEXTRACTI128mr_Zn3WriteRotateLeftMI_Zn3WriteRotateLeftMCL_WriteFVarBlendZLd_Zn4WriteVINSERTF128rmr_Zn4WriteVEXTRACTI128mr_Zn4WriteRotateLeftMI_Zn4WriteRotateLeftMCL
  {11,  0}, // #8 WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBitTestRegLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtPS2PDLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDivX_WritePHAddLd_WritePSADBWLd_WriteVarShuffleLd_WriteMPSADLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpIStrI_WritePCmpIStrM_WritePHMINPOSLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteFMALd_WriteFAddYLd_WriteFAdd64YLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WritePSADBWYLd_WriteFDivY_WriteFMAXLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_ADLPWriteResGroup56_ADLPWriteResGroup156_ADLPWriteResGroup263_ADLPWriteResGroup123_AtomWrite01_11_WriteCvtPD2PS_WriteCvtSD2SSLd_WriteAESDecEncLd_WriteAESIMCLd_WriteAESKeyGenLd_WritePMULLD_WriteFHAdd_WriteVecMoveToGpr_WriteVecMoveFromGpr_WriteFHAddY_PdWriteRCR8rCL_PdWriteRCL16ri_ZnWriteCVTPD2PSLd_ZnWriteCVTSS2SDLd_ZnWriteFPU3_WriteVecIMulXLd_WriteVecIMulLd_WritePMULLDLd_WriteFRndLd_ZnWriteCVTPD2PSYLd_WriteVecIMulYLd_WriteFRndYLd_WriteFMul64YLd_WritePMULLDYLd_WriteVecTestYLd_ZnWriteFILD_ZnWriteSHA256RNDS2Ld_BWWriteResGroup122_1_WriteSHDmrcl_WriteFSqrtX_WriteCvtI2PDYLd_WriteFMAYLd_WriteFHAddYLd_WriteFRcpY_WriteFRsqrtY_BWWriteResGroup133_BWWriteResGroup123_BWWriteResGroup131_BWWriteResGroup132_WriteCMPXCHGRMW_WriteDPPS_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_JWriteCMPXCHG8B_JWriteCMPXCHG8rm_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFMAZLd_WriteFAddZLd_WriteFAdd64ZLd_WriteFCmpYLd_WriteFCmpZLd_WriteFCmp64YLd_WriteFCmp64ZLd_WriteMPSADYLd_WriteFMulYLd_WriteFMulZLd_WriteFMul64ZLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_SKXWriteResGroup171_SKXWriteResGroup162_SKXWriteResGroup160_SKXWriteResGroup169_SKXWriteResGroup170_SKXWriteResGroup166_SKXWriteResGroup148_2_SKXWriteResGroup161_SKXWriteResGroup164_SKXWriteResGroup167_WriteFHAddLd_WritePCmpEStrM_WritePSADBWXLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteVecShiftYLd_WriteVecShiftZLd_SBWriteResGroup108_SBWriteResGroup104_SBWriteResGroup106_WriteCLMul_WriteFRsqrtZ_HWWriteResGroup131_HWWriteFRNDINT_HWWriteResGroup91_2_HWWriteResGroup75_HWWriteResGroup129_HWWriteResGroup130_WriteFAddXLd_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WritePSADBWZLd_WriteVarShuffleZLd_SPRWriteResGroup60_SPRWriteResGroup165_SPRWriteResGroup258_SPRWriteResGroup132_SPRWriteResGroup417_SPRWriteResGroup255_SPRWriteResGroup313_SPRWriteResGroup455_SPRWriteResGroup483_SPRWriteResGroup254_SPRWriteResGroup317_SPRWriteResGroup321_SPRWriteResGroup354_SPRWriteResGroup374_SPRWriteResGroup482_SPRWriteResGroup515_SPRWriteResGroup535_SPRWriteResGroup537_WriteCvtPD2PSLd_ICXWriteResGroup171_ICXWriteResGroup162_ICXWriteResGroup160_ICXWriteResGroup169_ICXWriteResGroup170_ICXWriteResGroup166_ICXWriteResGroup148_2_ICXWriteResGroup161_ICXWriteResGroup164_ICXWriteResGroup167_WriteCvtPD2ILd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_SKLWriteResGroup156_SKLWriteResGroup149_SKLWriteResGroup146_SKLWriteResGroup154_SKLWriteResGroup155_Zn2WriteFPU3_Zn2WriteFILD_Zn2WriteCVSTSI2SILd_Zn2WriteSHA256RNDS2Ld_WriteFComXLd_WriteDiv16_WriteFLDC_WriteIDiv16_WriteFLD1_WriteCLMulLd_WriteCvtPH2PSYLd_Zn3WriteVPERMPSYrm_WriteCvtI2PDZLd_WriteCvtPH2PSZLd_WriteCvtPS2IZLd_WriteFDivZ_WriteDPPSY_Zn4WriteVPERMPSYrm
  {10,  0}, // #9 WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteEMMS_WriteIMul16Ld_WriteCLMulLd_WritePMULLD_WritePSADBWXLd_WriteFVarBlendYLd_WriteVarBlendYLd_WritePHAddYLd_WritePMULLDY_ADLPWriteResGroup9_ADLPWriteResGroup169_ADLPWriteResGroup266_ADLPWriteResGroup15_WriteFComXLd_WriteCvtSD2SS_AtomWrite01_10_WriteFMul64XLd_WriteFRcpXLd_WriteFRsqrtXLd_AtomWrite0_1_10_WriteCMPXCHGRMW_WriteBSF_WriteBSR_WriteIMul64Ld_WriteLDMXCSR_WriteMPSADLd_WriteAESIMCLd_WriteAESKeyGenLd_WriteIMul64RegLd_WriteIMul64ImmLd_WritePHAddLd_WriteMMXMOVMSK_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePMULLDLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFAddYLd_WriteFAdd64YLd_WriteFMAXLd_WriteFMAYLd_WriteFMulYLd_WriteFMul64YLd_WriteFRcpYLd_WriteFRsqrtYLd_PdWriteCRC32r64r64_PdWriteRCL16rCL_PdWriteRCR16ri_PdWriteVFRCZP_PdWriteVFRCZS_PdWriteVFRCZY_WriteCRC32Ld_ZnWriteCVTPS2PDLd_WriteFDivX_WriteFComLd_WritePSADBWLd_WritePHAddXLd_WritePSADBWYLd_WriteFDivY_WriteVarVecShiftLd_WriteVarVecShiftYLd_WriteVecIMulXLd_WriteFHAddLd_WriteVecIMulLd_WritePHMINPOSLd_WriteVecTestYLd_BWWriteResGroup115_BWWriteResGroup117_WriteAESDecEncLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtSD2SSLd_WritePCmpIStrI_WritePCmpIStrM_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteCvtPH2PSYLd_WritePSADBWZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WritePMULLDZ_SKXWriteResGroup148_SKXWriteResGroup157_SKXWriteResGroup154_SKXWriteResGroup136_2_SKXWriteResGroup149_SKXWriteResGroup151_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtI2SSLd_WriteCvtSS2ILd_WritePCmpEStrILd_WriteSHDmrcl_WriteFMAZLd_WriteFAddZLd_WriteFAdd64ZLd_WriteFCmpYLd_WriteFCmpZLd_WriteFCmp64YLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSYLd_WriteCvtI2PSZLd_WriteCvtPS2IYLd_WriteCvtPS2IZLd_WriteCvtPS2PHY_WriteCvtPS2PHZ_WriteFRndYLd_WriteFRndZLd_WriteFCmp64ZLd_SBWriteResGroup101_WriteSHDmri_WriteCvtPD2PSZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteVarVecShiftZLd_HWWriteResGroup52_1_SPRWriteResGroup10_SPRWriteResGroup485_SPRWriteResGroup389_SPRWriteResGroup17_SPRWriteResGroup8_SPRWriteResGroup259_SPRWriteResGroup264_SPRWriteResGroup284_SPRWriteResGroup290_SPRWriteResGroup292_SPRWriteResGroup298_SPRWriteResGroup334_SPRWriteResGroup344_SPRWriteResGroup350_SPRWriteResGroup358_SPRWriteResGroup410_SPRWriteResGroup413_SPRWriteResGroup431_SPRWriteResGroup432_SPRWriteResGroup479_SPRWriteResGroup511_SPRWriteResGroup513_ICXWriteResGroup148_ICXWriteResGroup157_ICXWriteResGroup154_ICXWriteResGroup136_2_ICXWriteResGroup149_ICXWriteResGroup151_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtSS2SDLd_SKLWriteResGroup133_SKLWriteResGroup143_SKLWriteResGroup140_Zn2WriteCVTPD2PSLd_Zn2WriteCVTPS2PDLd_Zn2WriteCVTSS2SDLd_WriteVecTestLd_WriteFRndLd_Zn2WriteCVTPD2PSYLd_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteFTestYLd_WriteFTestLd_Zn2WriteCVTPD2DQLd_WriteCvtPS2PDLd_WriteDiv8_WriteIDiv8_WriteVecIMulYLd_WriteCvtPH2PSLd_WritePMULLDYLd_Zn3WriteVZEROALL_Zn3WriteVPERMPDYmi_WriteVecIMulZLd_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteFMulZLd_WriteFMul64ZLd_WriteFVarShuffleZLd_WritePMULLDZLd_Zn4WriteVZEROALL_Zn4WriteVPERMPDYmi
  { 5,  0}, // #10 WriteAESDecEnc_WriteLoad_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2PD_WriteCvtSD2SS_WriteCvtSS2SD_WriteVecIMulX_WriteIMul16_WriteSHDrrcl_WriteVecIMulY_WriteFHAddY_WriteFTestY_ADLPWriteResGroup180_ADLPWriteResGroup181_ADLPWriteResGroup102_ADLPWriteResGroup242_ADLPWriteResGroup288_ADLPWriteResGroup182_ADLPWriteResGroup230_ADLPWriteResGroup29_ADLPWriteResGroup70_ADLPWriteResGroup126_ADLPWriteResGroup132_ADLPWriteResGroup254_ADLPWriteResGroup258_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFCom_WriteFComLd_WriteEMMS_WriteVecIMulXLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLDMXCSR_WriteFMulXLd_WriteFMul64Ld_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRndLd_AtomWrite1_5_AtomWrite0_1_5_AtomWrite01_5_WriteRMW_WriteCMOVLd_WriteCvtI2PS_WriteCvtPS2I_WriteCvtSD2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2I_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteVecShiftLd_WriteVecShiftXLd_SLMWriteResGroup2rr_WriteJumpLd_WriteFLoadX_WriteFLoadY_WriteADCLd_WriteALULd_WriteFAdd64X_WriteAESIMC_WriteAESKeyGen_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteIMul16Imm_WriteVecLoadX_WritePHAdd_WriteVecLoadNT_WriteFMul64X_WritePMULLD_WriteFRcpX_WriteShiftLd_WriteFRsqrtX_WriteFAddY_WriteFAdd64Y_WriteFMAX_WriteFMAY_WriteVecLoadY_WriteVecLoadNTY_WriteFMulY_WriteFMul64Y_WriteFRcpY_WriteFRsqrtY_PdWriteX87Add_PdWriteX87Mul_PdWriteCRC32r32r16_PdWriteCMOVm_WriteBEXTRLd_WriteVecExtractSt_WriteStore_WritePOPCNTLd_ZnWriteCVTPD2PSYr_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPD2IY_WriteCvtPS2IY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_ZnWriteCVTPD2DQr_ZnWriteSTr_ZnWriteXCHGrm_ZnWriteST_FP80m_ZnWriteEXTRACTPSm_ZnWriteMOVBE_ZnWritePop16r_ZnWriteCVTDQ2PDr_ZnWriteCVSTSI2SDr_ZnWriteCVSTSI2SIr_WriteCMPXCHG_WriteCLMul_WritePHMINPOS_WriteCvtPS2PHSt_WritePSADBWY_BWWriteResGroup50_BWWriteResGroup54_BWWriteResGroup36_BWWriteResGroup57_BWWriteResGroup49_BWWriteResGroup47_BWWriteResGroup51_BWWriteResGroup55_BWWritePCMPGTQ_WriteBLSLd_WriteBSR_WriteTZCNTLd_WriteCvtPH2PS_WriteVecIMulZ_SKXWriteResGroup61_SKXWriteResGroup44b_SKXWriteResGroup69_SKXWriteResGroup63_SKXWriteResGroup67_SKXWriteResGroup62_SKXWriteResGroup65_SKXWriteResGroup66_WriteSTMXCSR_WritePSADBWZ_WriteFMAZ_WriteFMulZ_WriteFMul64Z_WritePMULLDY_WritePMULLDZ_SBWriteResGroup33_SBWriteResGroup41_SBWriteResGroup47_SBWriteResGroup76_SBWriteResGroup35_SBWriteResGroup35_2_SBWriteResGroup36_SBWriteResGroup40_SBWriteResGroup45_SBWriteResGroup46_SBWritePCMPGTQ_HWWriteResGroup93_HWWriteResGroup99_HWWriteResGroup60_HWWriteResGroup88_HWWriteResGroup89_HWWriteResGroup94_HWWriteResGroup100_HWWritePCMPGTQ_SPRWriteResGroup186_SPRWriteResGroup111_SPRWriteResGroup247_SPRWriteResGroup575_SPRWriteResGroup187_SPRWriteResGroup236_SPRWriteResGroup367_SPRWriteResGroup340_SPRWriteResGroup31_SPRWriteResGroup74_SPRWriteResGroup135_SPRWriteResGroup142_SPRWriteResGroup414_SPRWriteResGroup252_SPRWriteResGroup463_SPRWriteResGroup469_ICXWriteResGroup61_ICXWriteResGroup44b_ICXWriteResGroup69_ICXWriteResGroup63_ICXWriteResGroup67_ICXWriteResGroup62_ICXWriteResGroup65_ICXWriteResGroup66_SKLWriteResGroup60_SKLWriteResGroup42b_SKLWriteResGroup65_SKLWriteResGroup61_SKLWriteResGroup63_WriteLZCNTLd_Zn2WriteSTr_Zn2WriteXCHGrm_Zn2WriteST_FP80m_Zn2WriteEXTRACTPSm_Zn2WriteMOVBE_Zn2WritePop16r_WriteVarShuffle256_Zn3WriteMOVSlow_Zn3WriteX87Arith_Zn3WriteX87Div_Zn3Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn3WriteRotateM1_WriteBSFLd_WriteBSRLd_WriteFRcpZ_WriteFRsqrtZ_Zn4WriteMOVSlow_Zn4WriteX87Arith_Zn4WriteX87Div_Zn4Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn4WriteRotateM1_Zn4WriteVPERMDYrr_Zn4MOVSrr_Zn4VPTESTZ_Zn4VRSQRT14PDZ256_Zn4PERMIT2Z
  {15,  0}, // #11 WriteAESIMCLd_WriteDiv32_WriteIDiv32_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_ADLPWriteResGroup44_WriteCMPXCHG_WriteSTMXCSR_WriteDPPDLd_WriteDPPS_WriteDiv16_WriteIDiv16_WritePCmpEStrMLd_PdWriteVFRCZm_PdWriteVFRCZYm_WriteDiv8_WriteIDiv8_WriteFDiv64Y_WritePMULLDLd_BWWriteResGroup149_BWWriteResGroup147_WriteDiv8Ld_WriteIDiv8Ld_WriteFRndYLd_WriteFRndZLd_SKXWriteResGroup195_SKXWriteResGroup191_SKXWriteResGroup174_SKXWriteResGroup174z_SKXWriteResGroup194_SBWriteResGroup119_HWWriteResGroup115_HWWriteFXTRACT_HWWriteResGroup188_WriteCvtPD2PSZLd_SPRWriteResGroup47_SPRWriteResGroup299_SPRWriteResGroup266_SPRWriteResGroup498_SPRWriteResGroup500_SPRWriteResGroup473_SPRWriteResGroup300_SPRWriteResGroup218_SPRWriteResGroup269_SPRWriteResGroup281_SPRWriteResGroup304_SPRWriteResGroup311_SPRWriteResGroup328_SPRWriteResGroup341_SPRWriteResGroup382_SPRWriteResGroup393_SPRWriteResGroup397_SPRWriteResGroup408_SPRWriteResGroup411_SPRWriteResGroup475_SPRWriteResGroup493_ICXWriteResGroup195_ICXWriteResGroup191_ICXWriteResGroup174_ICXWriteResGroup174z_ICXWriteResGroup194_SKLWriteResGroup174_SKLWriteResGroup171_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtX_WriteDPPSY_WriteFSqrtY_WriteFSqrtZ
  { 2,  0}, // #12 WriteBLS_WriteBSWAP64_WriteXCHG_WriteFence_WritePHAddX_WriteVecShiftX_WriteRotate_WriteRotateCL_WriteShiftCL_WriteSETCC_WritePHAddY_ADLPWriteResGroup243_ADLPWriteResGroup268_ADLPWriteResGroup84_ADLPWriteResGroup62_ADLPWriteResGroup105_ADLPWriteResGroup55_ADLPWriteResGroup39_ADLPWriteResGroup93_ADLPWriteResGroup222_ADLPWriteResGroup219_ADLPWriteResGroup178_ADLPWriteResGroup11_ADLPWriteResGroup14_ADLPWriteResGroup25_WriteSHDrri_AtomWrite01_2_WriteLAHFSAHF_WriteStore_WriteSETCCStore_WriteSHDrrcl_WriteCMOV_WriteVecALU_WriteFLogic_WriteBEXTR_WriteFBlend_WriteFVarBlend_WriteBitTestSet_WriteFCmp64X_WriteFCmpX_WriteCRC32_WriteVecALUX_WriteEMMS_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLZCNT_WriteVecStore_WriteVecStoreNT_WriteVecMove_WriteVecInsert_WriteVecShiftImm_WriteFStore_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVecShiftImmX_WriteTZCNT_WriteShuffleY_WriteFLogicY_WriteFVarBlendY_WriteFBlendY_WriteFShuffle256_WriteFCmpY_WriteFCmp64Y_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_PdWriteLAHF_PdWriteVEXTRACTF128rr_PdWriteMOVHPm_PdWriteBMI1_PdWriteSAHF_PdWriteBEXTRI_PdWriteBEXTRIm_PdWriteVPPERM_PdWrite3OpsLEA_WriteFSign_WriteVecExtract_WriteVecMoveToGpr_WriteVecTest_WriteShuffle256_WriteVarShuffle256_WriteFVarShuffle256_WriteVecMOVMSKY_WriteFTest_ZnWriteEXTRACTPSr_ZnWriteVINSERT128r_ZnWriteEXTRQ_ZnWriteSHA1MSG1r_WriteCvtPS2PD_WriteCvtSS2SD_WriteVecExtractSt_WriteSTMXCSR_WriteCvtPH2PSY_WriteVarBlendY_BWWriteResGroup14_BWWriteResGroup20_BWWriteResGroup22_BWWriteResGroup12_BWWriteResGroup17_BWWriteResGroup35_BWWriteResGroup25_BWWriteResGroup16_BWWriteResGroup24_BWWriteResGroup87_1_BWWriteCMOVA_CMOVBErr_BWWriteSETA_SETBEr_WriteRMW_WriteAESIMC_WriteAESKeyGen_WriteVecIMulX_WritePSADBW_WriteFMulX_WriteCLMul_WritePHMINPOS_WritePSADBWX_WriteVarShuffleX_WriteFRcpX_WriteFRsqrtX_WriteCvtPS2PDY_WriteFMulY_WriteFRcpY_WriteFRsqrtY_JWriteXCHG8rr_XADDrr_JWriteINSERTQ_JWrite3OpsLEA_WriteFComX_WriteMMXMOVMSK_WriteFMOVMSK_WriteFVarBlendZ_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVarBlendZ_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteFTestY_SKXWriteResGroup17_SKXWriteResGroup23_SKXWriteResGroup25_SKXWriteResGroup14_SKXWriteResGroup44_SKXWriteResGroup28_SKXWriteResGroup20_SKXWriteResGroup27_SKXWriteResGroup107_1_SKXWriteResGroup41_SKXWriteResGroup13_SKXWriteResGroup29_SKXWriteCMOVA_CMOVBErr_SKXWriteSETA_SETBEr_WriteADC_WriteCvtPS2PDZ_WriteVecTestY_SBWriteResGroup18_SBWriteResGroup11_SBWriteResGroup12_SBWriteResGroup15_SBWriteResGroup23_SBWriteSETA_SETBEr_WriteCvtPH2PSZ_HWWriteResGroup30_HWWriteResGroup35_HWWriteResGroup21_HWWriteResGroup28_HWWriteResGroup33_HWWriteResGroup59_HWWriteResGroup24_HWWriteResGroup32_HWWriteResGroup23_HWWriteResGroup23_16_HWWriteResGroup46_1_HWWriteSETA_SETBEr_SPRWriteResGroup248_SPRWriteResGroup555_SPRWriteResGroup88_SPRWriteResGroup66_SPRWriteResGroup114_SPRWriteResGroup59_SPRWriteResGroup42_SPRWriteResGroup28_SPRWriteResGroup102_SPRWriteResGroup228_SPRWriteResGroup225_SPRWriteResGroup184_SPRWriteResGroup13_SPRWriteResGroup16_SPRWriteResGroup27_SPRWriteResGroup491_SPRWriteResGroup509_SPRWriteResGroup514_ICXWriteResGroup17_ICXWriteResGroup23_ICXWriteResGroup25_ICXWriteResGroup14_ICXWriteResGroup44_ICXWriteResGroup28_ICXWriteResGroup53_ICXWriteResGroup20_ICXWriteResGroup27_ICXWriteResGroup107_1_ICXWriteResGroup13_ICXWriteResGroup29_ICXWriteCMOVA_CMOVBErr_ICXWriteSETA_SETBEr_SKLWriteResGroup17_SKLWriteResGroup23_SKLWriteResGroup25_SKLWriteResGroup14_SKLWriteResGroup42_SKLWriteResGroup28_SKLWriteResGroup20_SKLWriteResGroup27_SKLWriteResGroup100_1_SKLWriteResGroup39_SKLWriteResGroup13_SKLWriteCMOVA_CMOVBErr_SKLWriteSETA_SETBEr_Zn2WriteEXTRACTPSr_Zn2WriteVINSERT128r_Zn2WriteSHA1MSG1r_WriteCvtSD2I_WriteCvtSS2I_WritePCmpIStrI_Zn3WriteCvtI2PDMMX_Zn3WriteSHA256MSG1rr_Zn3SlowLEA16r_Zn3WriteTZCNT16rr_Zn3WriteWriteFStoreMMX_Zn3WriteSHA1MSG1rr_Zn3Write3OpsLEA_WriteFCmpZ_WriteFCmp64Z_Zn4WriteSHA256MSG1rr_Zn4SlowLEA16r_Zn4WriteTZCNT16rr_Zn4WriteWriteFStoreMMX_Zn4WriteVecALUXSlow_Zn4WriteSHA1MSG1rr_Zn4WriteVFIXUPIMMPDZrr_VRANGESDrr_Zn4WriteSHIFTrr_Zn4WriteALIGN_Zn4WritePACK_Zn4WriteFCmp64_Zn4MOVDUPZ_Zn4MOVS_Zn4CONFLICTZ128_Zn4PERMILP_Zn4PERMIT2_128rr_Zn4VecALUZSlow_Zn4Write3OpsLEA
  {18,  0}, // #13 WriteRMW_WriteDiv64_WriteFDivXLd_WriteFDivLd_WriteIDiv64_WritePMULLDLd_WriteFSqrt64X_WritePMULLDYLd_WriteFSqrt64Y_ADLPWriteResGroup34_ADLPWriteResGroup206_ADLPWriteResGroup116_AtomWrite01_18_WriteDPPSLd_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteDiv32Ld_WriteDiv64Ld_WriteIDiv32Ld_WriteIDiv64Ld_WritePCmpEStrI_BWWriteResGroup160_BWWriteResGroup159_BWWriteResGroup183_2_WriteFSqrtXLd_WriteFDivYLd_WriteFDivZ_SKXWriteResGroup208_SKXWriteResGroup207_SKXWriteResGroupVEX2_WriteAESIMCLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup149_WriteCvtPS2IZLd_WritePMULLDZLd_SPRWriteResGroup36_SPRWriteResGroup210_SPRWriteResGroup125_SPRWriteResGroup286_SPRWriteResGroup288_SPRWriteResGroup294_SPRWriteResGroup296_SPRWriteResGroup312_SPRWriteResGroup318_SPRWriteResGroup319_SPRWriteResGroup329_SPRWriteResGroup335_SPRWriteResGroup345_SPRWriteResGroup348_SPRWriteResGroup352_SPRWriteResGroup356_ICXWriteResGroup208_ICXWriteResGroup207_ICXWriteResGroupVEX2_SKLWriteResGroup185_SKLWriteResGroup184_SKLWriteResGroupVEX2_WriteFDivZLd_WriteDPPSYLd
  { 4,  0}, // #14 WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteVecExtract_WriteIMul16Imm_WriteIMul32_WriteIMul64_WriteVecInsert_WriteMPSAD_WriteFMul64X_WriteFMulX_WriteMULX32_WriteMULX64_WritePHMINPOS_WriteVecTest_WriteFRcpX_WriteFRsqrtX_WriteFCmpY_WriteFCmp64Y_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMAX_WriteFMAY_WriteMPSADY_WriteFMulY_WriteFMul64Y_WriteVecMOVMSKY_WriteVecShiftY_WriteFRcpY_WriteFRsqrtY_ADLPWriteResGroup83_ADLPWriteResGroup174_ADLPWriteResGroup60_ADLPWriteResGroup51_ADLPWriteResGroup190_ADLPWriteResGroup277_ADLPWriteResGroup121_ADLPWriteResGroup158_ADLPWriteResGroup214_WritePHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteFMulLd_WriteVarShuffleX_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmrcl_WriteSHDmri_AtomWrite01_4_WriteJumpLd_WriteADCLd_WriteALULd_WriteFAdd64X_WriteFLogicLd_WriteFBlendLd_WriteFVarBlend_WriteBitTestImmLd_WriteBitTestRegLd_WriteRMW_WriteCvtSD2SS_WriteCvtSS2SD_WriteVecExtractSt_WriteVecALUXLd_WriteIMul16Reg_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteMMXMOVMSK_WriteVarShuffleLd_WriteFMOVMSK_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlend_WriteBlendLd_WriteStore_WriteVecTestLd_WriteShiftLd_WriteFVarShuffleLd_WriteVecShiftImmXLd_WriteFTestLd_SLMWriteResGroup1rr_WriteBSR_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMulX_WriteIMul32Reg_WriteIMul32Imm_WriteIMul8_WritePOPCNT_WritePSADBWX_WriteFRnd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFRndY_PdWriteMMX_CVTPI2PSrr_PdWriteVPERM2F128rr_PdWriteMOVQ2DQrr_PdWriteVPMACS_WriteAESDecEnc_WriteAESIMC_WriteAESKeyGen_WriteLoad_ZnWriteCVTPD2PSr_ZnWriteCVTSS2SDr_ZnWriteMul64_WritePMULLD_WriteVecIMulY_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_WritePMULLDY_WriteVecTestY_WriteFTestY_ZnWriteCVTPS2PIr_ZnWritePUSH_ZnWriteINSERTQ_ZnWriteSHA256RNDS2r_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtSD2I_WriteCvtSS2I_WriteCvtPS2PDY_BWWriteResGroup42_BWWriteResGroup44_BWWriteResGroup45_BWWriteResGroup41_BWWriteResGroup43_WriteBEXTRLd_WriteBSF_WriteCMOVLd_WriteFHAdd_WriteLZCNTLd_WriteVecMoveToGpr_WritePOPCNTLd_WriteSHDrrcl_WriteFHAddY_WriteFVarShuffleY_WriteFAddX_WriteFAddY_WriteFAddZ_WriteFAdd64Y_WriteFAdd64Z_WriteFCmpZ_WriteCvtI2PDY_WriteCvtI2PDZ_WriteCvtI2PSZ_WriteFMAZ_WriteFCmp64Z_WriteFMulZ_WriteFMul64Z_WriteVecShiftZ_WriteFRcpZ_SKXWriteResGroup54_SKXWriteResGroup55_SKXWriteResGroup57_SKXWriteResGroup49_SKXWriteResGroup50_SKXWriteResGroup33_SKXWriteResGroup50z_SKXWriteResGroup51_WritePCmpEStrI_WriteCvtPD2PSY_WriteCvtPD2PSZ_WriteCvtPD2IY_WriteCvtPD2IZ_SBWriteResGroup31_SBWriteResGroup29_2_SBWriteResGroup24b_WriteCvtPS2PDZ_HWWriteResGroup73_HWWriteMOVS_HWWriteResGroup62_HWWriteResGroup81_HWWriteResGroup72_HWWriteResGroup61_HWWriteCMPS_HWWriteResGroup83_WriteFRndZ_SPRWriteResGroup87_SPRWriteResGroup64_SPRWriteResGroup55_SPRWriteResGroup194_SPRWriteResGroup564_SPRWriteResGroup130_SPRWriteResGroup167_SPRWriteResGroup91_SPRWriteResGroup314_SPRWriteResGroup516_SPRWriteResGroup519_SPRWriteResGroup220_SPRWriteResGroup456_SPRWriteResGroup249_SPRWriteResGroup256_SPRWriteResGroup481_SPRWriteResGroup492_SPRWriteResGroup522_ICXWriteResGroup54_ICXWriteResGroup55_ICXWriteResGroup41_ICXWriteResGroup57_ICXWriteResGroup49_ICXWriteResGroup50_ICXWriteResGroup33_ICXWriteResGroup50z_ICXWriteResGroup51_SKLWriteResGroup53_SKLWriteResGroup55_SKLWriteResGroup54_SKLWriteResGroup57_SKLWriteResGroup47_Zn2WriteMul16Imm_Zn2WriteMul64_WriteVPMOV256_Zn2WriteCVTPS2PIr_Zn2WritePUSH_Zn2WriteCVSTSI2SIr_Zn2WriteINSERTQ_Zn2WriteSHA256RNDS2r_WriteFComX_WriteCLMul_WriteCvtPH2PSY_Zn3WriteCMPXCHG16B_LCMPXCHG16B_Zn3WriteRotateLeftRI_Zn3WriteRotateLeftRCL_Zn3WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn3WriteSHA256RNDS2rr_Zn3WriteMOVBE16rm_WriteCvtPH2PSZ_WriteCvtPS2IZ_WritePSADBWZ_Zn4WriteCMPXCHG16B_LCMPXCHG16B_Zn4WriteRotateLeftRI_Zn4WriteRotateLeftRCL_Zn4WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn4WriteSHA256RNDS2rr_Zn4WriteMOVBE16rm_Zn4WriteVecALU2Slow_Zn4WriteBUSDr_VPMADDr_Zn4MOVSZ_Zn4VPTESTZ256_Zn4PERMIT2_256
  {20,  0}, // #15 WriteDiv16Ld_WriteFDiv64XLd_WriteIDiv16Ld_WriteFSqrtYLd_ADLPWriteResGroup159_ADLPWriteResGroup81_ADLPWriteResGroup48_ADLPWriteResGroup45_ADLPWriteResGroup79_ADLPWriteResGroup80_AtomWrite01_20_WritePCmpEStrMLd_WritePCmpIStrILd_WriteDPPDLd_WriteFDiv64Ld_WriteFSqrt64X_WriteFSqrt80_WriteFSqrt64Y_WriteDPPSYLd_BWWriteResGroup167_BWWriteResGroup165_WriteAESKeyGen_WriteFSqrtZ_SKXWriteResGroup220_SKXWriteResGroup219_SKXWriteResGroup215_SKXWriteResGroupVEX4_WriteFDivXLd_WriteFDivLd_WriteCLMulLd_WriteFSqrtXLd_WriteFSqrtLd_WriteAESIMCLd_WriteDPPSLd_HWWriteResGroup156_HWWriteResGroup154_SPRWriteResGroup168_SPRWriteResGroup85_SPRWriteResGroup51_SPRWriteResGroup495_SPRWriteResGroup457_SPRWriteResGroup83_SPRWriteResGroup84_SPRWriteResGroup346_SPRWriteResGroup349_SPRWriteResGroup357_SPRWriteResGroup525_SPRWriteResGroup529_SPRWriteResGroup540_ICXWriteResGroup220_ICXWriteResGroup219_ICXWriteResGroup215_ICXWriteResGroupVEX4_SKLWriteResGroup193_SKLWriteResGroup192_SKLWriteResGroup189_SKLWriteResGroupVEX4_WriteFDiv64YLd_WriteFDiv64ZLd
  {16,  0}, // #16 WriteDiv16_WriteDPPDLd_WriteIDiv16_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrMLd_WriteFRndYLd_ADLPWriteResGroup267_WriteBSFLd_WriteBSRLd_WriteDiv8Ld_WriteFHAddLd_WriteIDiv8Ld_WritePCmpIStrILd_WriteFHAddYLd_WriteFDivXLd_BWWriteResGroup150_WriteFSqrt64X_WriteFSqrtXLd_WriteFSqrtLd_WritePMULLDYLd_BWWriteResGroup153_WriteDPPSLd_WriteFMaskedStore64Y_WriteFMaskedStore32_JWriteLOCK_CMPXCHG8rm_WriteFDivLd_WritePMULLDLd_WriteFRsqrtZLd_SKXWriteResGroup199_HWWriteResGroup120_HWWriteResGroup186_HWWriteResGroup190_WriteCvtPH2PSZLd_SPRWriteResGroup478_SPRWriteResGroup461_SPRWriteResGroup285_SPRWriteResGroup287_SPRWriteResGroup293_SPRWriteResGroup295_SPRWriteResGroup308_SPRWriteResGroup324_SPRWriteResGroup336_SPRWriteResGroup337_SPRWriteResGroup338_SPRWriteResGroup339_SPRWriteResGroup364_SPRWriteResGroup384_SPRWriteResGroup390_SPRWriteResGroup394_SPRWriteResGroup471_SPRWriteResGroup523_SPRWriteResGroup528_SPRWriteResGroup532_ICXWriteResGroup199_SKLWriteResGroup177_SKLWriteResGroup178
  {19,  0}, // #17 WriteDiv32Ld_WriteFDiv64Ld_WriteVecExtractSt_WriteIDiv32Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFDivYLd_WriteDiv16Ld_WriteIDiv16Ld_WritePCmpEStrILd_WriteDiv8Ld_WriteIDiv8Ld_WriteAESIMCLd_WriteFDiv64XLd_BWWriteResGroup161_WriteDPPSLd_WritePCmpEStrM_BWWriteResGroup183_4_BWWriteResGroup183_3_WriteFDivX_WritePCmpEStrMLd_JWriteLOCK_CMPXCHG8B_JWriteLOCK_ALURMW_WriteFSqrtYLd_SKXWriteGatherEVEX4_WriteDPPSYLd_WriteFDivXLd_HWWriteResGroup135_HWWriteResGroup143_HWWriteFPREM_SPRWriteResGroup503_SPRWriteResGroup48_SPRWriteResGroup270_SPRWriteResGroup301_SPRWriteResGroup325_SPRWriteResGroup553_ICXWriteGatherEVEX4
  {23,  0}, // #18 WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Ld_AtomWrite01_23_WriteFSqrtLd_WritePCmpEStrILd_WriteFSqrt80_WriteFDivYLd_WriteFDiv64Y_BWWriteResGroup176_WriteFDiv64Z_SKXWriteResGroup228_WriteIDiv8_HWWriteResGroup151_SPRWriteResGroup497_SPRWriteResGroup499_SPRWriteResGroup459_SPRWriteResGroup309_SPRWriteResGroup322_ICXWriteResGroup228_SKLWriteResGroup198
  {22,  0}, // #19 WriteDiv8Ld_WriteIDiv8Ld_WriteDPPSYLd_ADLPWriteResGroup46_AtomWrite01_22_WriteFDivLd_WriteFDiv64YLd_BWWriteResGroup172_WriteFMaskedStore32Y_SKXWriteResGroup223_SKXWriteResGroupVEX8_SKXWriteResGroup225_SKXWriteResGroup211_SKXWriteResGroup211_1_WriteFDiv64X_WriteFSqrt64XLd_HWWriteResGroup146_HWWriteResGroup187_SPRWriteResGroup49_SPRWriteResGroup302_SPRWriteResGroup326_SPRWriteResGroup526_SPRWriteResGroup530_ICXWriteResGroup223_ICXWriteResGroupVEX8_ICXWriteResGroup225_ICXWriteResGroup211_ICXWriteResGroup211_1_SKLWriteResGroup196_SKLWriteResGroupVEX8_WriteDPPSLd_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrt80_WriteFSqrtYLd_WriteFSqrtZLd
  {17,  0}, // #20 WriteDiv8_WriteIDiv8_WritePCmpEStrMLd_WriteStore_ADLPWriteResGroup276_ADLPWriteResGroup17_AtomWrite01_17_WritePCmpIStrI_WriteCLMulLd_WriteDiv16_WriteFDivXLd_WriteFDivLd_WriteIDiv16_WriteFDivYLd_WriteFRcpYLd_WriteFRsqrtYLd_BWWriteResGroup183_1_WriteDPPSYLd_JWriteLOCK_CMPXCHGrm_WriteFSqrtLd_WritePMULLDYLd_WritePMULLDZLd_SKXWriteResGroup202_SKXWriteGatherEVEX2_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrtXLd_HWWriteResGroup147_HWWriteResGroup132_HWWriteResGroup185_HWWriteResGroup189_SPRWriteResGroup563_SPRWriteResGroup451_SPRWriteResGroup448_SPRWriteResGroup19_SPRWriteResGroup273_SPRWriteResGroup277_SPRWriteResGroup282_SPRWriteResGroup316_SPRWriteResGroup333_SPRWriteResGroup342_SPRWriteResGroup379_SPRWriteResGroup460_SPRWriteResGroup474_SPRWriteResGroup476_SPRWriteResGroup534_SPRWriteResGroup536_ICXWriteResGroup202_ICXWriteGatherEVEX2_SKLWriteResGroup180_WriteDiv32Ld_WriteDiv64_WriteIDiv32Ld_WriteIDiv64
  {14,  0}, // #21 WriteFDiv64X_WriteDPPS_WriteFDiv64Y_WriteDPPSY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_ADLPWriteResGroup157_WriteIMul64ImmLd_AtomWrite01_14_WritePMULLDLd_WriteAESDecEncLd_WriteDiv32_WriteDiv64_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteIDiv32_WriteIDiv64_WriteMPSADLd_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrtXLd_WriteFSqrt64Ld_WriteFSqrtLd_WriteFDivYLd_WriteFDiv64YLd_WriteFSqrtYLd_WriteFSqrt64YLd_WriteFHAddLd_WriteFHAddYLd_WriteAESIMC_BWWriteResGroup139_1_WriteDPPDLd_BWWriteResGroup146_BWWriteResGroup141_BWWriteResGroup144_BWWriteResGroup145_WritePCmpEStrM_WriteAESIMCLd_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2PSZLd_SKXWriteResGroup187_SKXWriteResGroup190_SKXWriteResGroup188_SKXWriteResGroup189_WriteAESKeyGenLd_WriteCLMul_WriteMPSADYLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup142_HWWriteResGroup184_SPRWriteResGroup166_SPRWriteResGroup496_SPRWriteResGroup276_SPRWriteResGroup280_SPRWriteResGroup315_SPRWriteResGroup331_SPRWriteResGroup355_SPRWriteResGroup363_SPRWriteResGroup381_SPRWriteResGroup445_SPRWriteResGroup447_SPRWriteResGroup466_SPRWriteResGroup468_SPRWriteResGroup487_ICXWriteResGroup187_ICXWriteResGroup190_ICXWriteResGroup188_ICXWriteResGroup189_SKLWriteResGroup169_SKLWriteResGroup170_WriteDiv8Ld_WriteIDiv8Ld_WriteFVarShuffle256Ld
  { 9,  0}, // #22 WriteDPPD_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul64Ld_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecShiftLd_WriteMULX32Ld_WriteMULX64Ld_WritePHAddXLd_WriteVecTestLd_WriteShuffleYLd_WriteFLogicYLd_WriteFBlendYLd_WriteVecALUYLd_WriteFMaskedLoadY_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoadY_WriteVarVecShiftYLd_WriteVarShuffleYLd_WriteVecShiftYLd_ADLPWriteResGroup114_ADLPWriteResGroup122_ADLPWriteResGroup255_ADLPWriteResGroup125_ADLPWriteResGroup197_ADLPWriteResGroup221_ADLPWriteResGroup177_ADLPWriteResGroup244_ADLPWriteResGroup264_WriteBitTestRegLd_WriteFCMOV_WriteFComX_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFHAddLd_WriteFMul64X_WriteFRcpX_WriteFRsqrtX_AtomWrite0_1_9_AtomWrite01_9_WritePHAddLd_WriteAESDecEnc_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtSD2SSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDiv64X_WriteFDivX_WriteVecIMulXLd_WriteVecIMulLd_WritePSADBWLd_WritePHMINPOSLd_WritePSADBWXLd_WriteFRndLd_WriteFSqrt64X_WriteFSqrtX_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteFDivY_WriteFDiv64Y_WriteFRndYLd_WriteFSqrtY_WriteFSqrt64Y_PdWriteX87Div_PdWriteRCR16rCL_ZnWriteMul64Ld_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteFVarShuffle256Ld_WriteFTestLd_ZnWriteFPU02_ZnWriteVINSERT128Ld_ZnWriteFPU01Op2Y_ZnWriteSHA1MSG1Ld_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteIMul16Ld_WriteSHDmri_WriteFAddYLd_WriteFAdd64YLd_WriteFCmpYLd_WriteFCmp64YLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFMul64YLd_WritePHAddYLd_WriteVPMOV256Ld_BWWriteResGroup101_BWWriteResGroup112_BWWriteResGroup108_BWWriteResGroup113_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFMul64XLd_WriteFMul64Ld_WritePMULLDLd_WriteSHDmrcl_WriteFHAddYLd_WriteVecTestYLd_WriteFTestYLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFMulLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFVarBlendYLd_WriteFVarBlendZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSZLd_WriteCvtPH2PSLd_WriteFRsqrtZ_SKXWriteResGroup135_SKXWriteResGroup137_SKXWriteResGroup136_SKXWriteResGroup146_SKXWriteResGroup143_SBWriteResGroup98_WriteFAdd64XLd_WriteFAddXLd_SBWriteResGroup100_WriteRMW_WriteFCmp64XLd_WriteFCmpXLd_WritePOPCNTLd_WriteVarBlendYLd_WriteVarBlendZLd_SBWriteResGroup97_2_SBWriteResGroup95_SBWriteResGroup99_SBWriteResGroupVzeroall_WriteCMPXCHGRMW_HWWriteResGroup69_WriteVarVecShiftLd_HWWriteResGroup66_HWWriteResGroup68_HWWriteResGroup53_1_HWWriteResGroup80_HWWriteResGroup87_WriteShuffleZLd_WriteFLogicZLd_WriteVecALUZLd_WriteFShuffleZLd_WriteVecLogicZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftZLd_WriteVecShiftZLd_SPRWriteResGroup123_SPRWriteResGroup131_SPRWriteResGroup262_SPRWriteResGroup134_SPRWriteResGroup201_SPRWriteResGroup227_SPRWriteResGroup183_SPRWriteResGroup472_SPRWriteResGroup477_SPRWriteResGroup261_SPRWriteResGroup442_SPRWriteResGroup275_SPRWriteResGroup279_SPRWriteResGroup330_SPRWriteResGroup366_SPRWriteResGroup392_SPRWriteResGroup396_SPRWriteResGroup409_SPRWriteResGroup412_SPRWriteResGroup507_SPRWriteResGroup510_SPRWriteResGroup512_SPRWriteResGroup524_ICXWriteResGroup135_ICXWriteResGroup137_ICXWriteResGroup136_ICXWriteResGroup146_ICXWriteResGroup143_WriteCvtPS2PDLd_SKLWriteResGroup123_SKLWriteResGroup121_SKLWriteResGroup131_SKLWriteResGroup128_Zn2WriteFPU02_Zn2WriteVINSERT128Ld_Zn2WriteFPU01Op2Y_Zn2WriteSHA1MSG1Ld_WritePCmpIStrILd_Zn3WriteVPERMDYm_WriteVecShiftXLd_WriteFCmpZLd_WriteFCmp64ZLd_Zn4WriteVPERMYm
  {21,  0}, // #23 WriteDPPSLd_WriteFSqrt80_WriteFDiv64YLd_ADLPWriteResGroup220_AtomWrite01_21_WritePCmpEStrI_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrtYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_BWWriteResGroup171_BWWriteResGroup169_BWWriteResGroup183_5_SKXWriteResGroup205_SKXWriteGatherEVEX8_WriteFDivY_WriteFDivZ_WriteDPPSYLd_WriteFSqrtZ_HWWriteResGroup144_WriteFSqrt64YLd_SPRWriteResGroup226_SPRWriteResGroup274_SPRWriteResGroup278_SPRWriteResGroup305_SPRWriteResGroup353_SPRWriteResGroup380_SPRWriteResGroup391_SPRWriteResGroup395_ICXWriteResGroup205_ICXWriteGatherEVEX8_WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Z
  {13,  0}, // #24 WriteVecIMulXLd_WriteVecIMulLd_WriteSETCCStore_WriteVecIMulYLd_WriteFHAddYLd_ADLPWriteResGroup113_ADLPWriteResGroup33_ADLPWriteResGroup10_ADLPWriteResGroup231_ADLPWriteResGroup223_ADLPWriteResGroup227_ADLPWriteResGroup4_ADLPWriteResGroup7_ADLPWriteResGroup138_ADLPWriteResGroup233_AtomWrite01_13_WriteBSFLd_WriteBSRLd_WriteCLMulLd_WritePCmpIStrM_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteCvtPD2PSYLd_WriteCvtI2PDYLd_WriteCvtPD2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_PdWriteCVTSI642SDrr_CVTSI642SSrr_CVTSI2SDr_CVTSI2SSrr_PdWriteRCL8ri_WriteFDiv64X_ZnWriteSHA1RNDS4Ld_WriteMPSADYLd_WritePCmpIStrMLd_WriteFMaskedStore64_WriteDPPS_WriteDPPSY_SKXWriteResGroup180_SKXWriteResGroup181_SKXWriteResGroup183_WriteAESDecEncLd_WriteMPSADLd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteCvtPS2PHZSt_SBWriteResGroup114_WriteFDivX_WriteFRndYLd_WriteFRndZLd_HWWriteResGroup103_WriteVecIMulZLd_WriteCvtPS2PDZLd_SPRWriteResGroup122_SPRWriteResGroup35_SPRWriteResGroup11_SPRWriteResGroup229_SPRWriteResGroup233_SPRWriteResGroup4_SPRWriteResGroup480_SPRWriteResGroup332_SPRWriteResGroup458_SPRWriteResGroup7_SPRWriteResGroup94_SPRWriteResGroup238_SPRWriteResGroup307_SPRWriteResGroup359_SPRWriteResGroup360_SPRWriteResGroup462_SPRWriteResGroup490_SPRWriteResGroup527_SPRWriteResGroup531_ICXWriteResGroup180_ICXWriteResGroup181_ICXWriteResGroup183_SKLWriteResGroup162_WriteFDiv64Y_Zn2WriteSHA1RNDS4Ld_WriteDiv32_WriteFHAddLd_WriteIDiv32_WritePCmpEStrILd_WritePCmpEStrMLd_WriteCvtPD2PSZLd_WriteFDiv64Z
  {511,  0}, // #25 WriteVecStoreNT_ADLPWriteResGroup145_SPRWriteResGroup154
  {512,  0}, // #26 WriteStoreNT_ADLPWriteResGroup148_SPRWriteResGroup157
  {518,  0}, // #27 WriteFStoreNTX_ADLPWriteResGroup149_SPRWriteResGroup158
  { 3,  0}, // #28 WriteIMulHLd
  { 9,  0}, // #29 WriteMULX32Ld_WriteMULX64Ld
  { 3,  0}, // #30 WriteIMulH
  { 4,  0}, // #31 WriteMULX32_WriteMULX64
  {31,  0}, // #32 WritePCmpEStrILd_WritePCmpIStrILd_WriteEMMS_SBWriteResGroup130_HWWriteResGroup163_HWWriteResGroup165_WriteFSqrt64ZLd_SPRWriteResGroup370_SPRWriteResGroup543
  {12,  0}, // #33 WriteRotateLd_WriteShiftLd_WriteShiftCLLd_ADLPWriteResGroup211_ADLPWriteResGroup271_SPRWriteResGroup215_SPRWriteResGroup558
  { 1,  0}, // #34 WriteRMW_WriteShift
  {12,  0}, // #35 WriteRotateLd_WriteShiftCLLd
  { 2,  0}, // #36 WriteRotate_WriteShiftCL
  {19,  0}, // #37 WriteRotateCLLd
  { 1,  0}, // #38 WriteRMW
  {19,  0}, // #39 WriteRotateCLLd
  { 2,  0}, // #40 WriteRotateCL
  {24,  0}, // #41 WriteFSqrt64XLd_ADLPWriteResGroup109_ADLPWriteResGroup237_WritePCmpEStrILd_WritePCmpEStrMLd_BWWriteResGroup177_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteFSqrt80_HWWriteResGroup162_SPRWriteResGroup118_SPRWriteResGroup450_SPRWriteResGroup242_SPRWriteResGroup306
  { 5,  0}, // #42 WriteLoad
  { 5,  0}, // #43 WriteVecMaskedGatherWriteback
  {507,  0}, // #44 WriteVecStoreNTY
  {542,  0}, // #45 WriteFStoreNTY
  {25,  0}, // #46 WriteFSqrt64YLd_ADLPWriteResGroup32_ADLPWriteResGroup47_AtomWrite01_25_WriteDiv16_WriteDiv32_WriteDiv64_WriteDiv8_WriteIDiv16_WriteIDiv32_WriteIDiv64_WriteIDiv8_WriteDPPS_WriteAESKeyGenLd_WritePCmpEStrMLd_WriteFDivZLd_SKXWriteResGroup233_SKXWriteGatherEVEX16_WriteFDiv64Ld_SPRWriteResGroup34_SPRWriteResGroup50_SPRWriteResGroup454_SPRWriteResGroup327_SPRWriteResGroup539_ICXWriteResGroup233_ICXWriteGatherEVEX16_SKLWriteResGroup202
  {11,  0}, // #47 WriteALULd
  { 1,  0}, // #48 WriteRMW
  {39,  0}, // #49 ADLPWriteResGroup274_ADLPWriteResGroup273_WriteFDivX_WriteFSqrt64ZLd_SPRWriteResGroup561_SPRWriteResGroup560_SPRWriteResGroup373_SPRWriteResGroup542
  { 1,  0}, // #50 WriteRMW
  {32,  0}, // #51 ADLPWriteResGroup31_AtomWrite01_32_WriteDPPSYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_JWriteCMPXCHG16B_WriteFSqrt64Z_SPRWriteResGroup33
  {42,  0}, // #52 ADLPWriteResGroup207_ADLPWriteResGroup280_ADLPWriteResGroup287_ADLPWriteResGroup282_ADLPWriteResGroup283_ADLPWriteResGroup286_WriteFDivXLd_BWWriteResGroup196_WriteFSqrtY_SKXWriteResGroup254_SKXWriteResGroup255_WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd_HWWriteResGroup176_SPRWriteResGroup211_SPRWriteResGroup567_SPRWriteResGroup572_SPRWriteResGroup574_SPRWriteResGroup569_SPRWriteResGroup570_SPRWriteResGroup571_SPRWriteResGroup573_SPRWriteResGroup548_ICXWriteResGroup254_ICXWriteResGroup255_SKLWriteResGroup214_SKLWriteResGroup215
  {126,  0}, // #53 ADLPWriteResGroup49_SPRWriteResGroup53
  {75,  0}, // #54 ADLPWriteResGroup61_BWWriteResGroup200_SKXWriteResGroup263_HWWriteResGroup180_HWWriteFSCALE_SPRWriteResGroup65_ICXWriteResGroup263_SKLWriteResGroup220
  {35,  0}, // #55 ADLPWriteResGroup165_ADLPWriteResGroup164_ADLPWriteResGroup75_ADLPWriteResGroup76_ADLPWriteResGroup71_ADLPWriteResGroup72_ADLPWriteResGroup73_ADLPWriteResGroup160_ADLPWriteResGroup161_ADLPWriteResGroup162_ADLPWriteResGroup163_WriteFSqrt64_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFSqrt64YLd_BWWriteResGroup194_WriteFSqrt80_SKXWriteResGroup248_SKXWriteResGroup247_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Z_HWWriteResGroup170_SPRWriteResGroup174_SPRWriteResGroup173_SPRWriteResGroup79_SPRWriteResGroup80_SPRWriteResGroup75_SPRWriteResGroup76_SPRWriteResGroup77_SPRWriteResGroup169_SPRWriteResGroup170_SPRWriteResGroup171_SPRWriteResGroup172_SPRWriteResGroup545_ICXWriteResGroup248_ICXWriteResGroup247_SKLWriteResGroup210_SKLWriteResGroup209
  {63,  0}, // #56 ADLPWriteResGroup66_ADLPWriteResGroup67_ADLPWriteResGroup108_AtomWrite01_63_BWWriteResGroup199_BWWriteResGroup198_SKXWriteResGroup260_SKXWriteResGroup259_SPRWriteResGroup70_SPRWriteResGroup71_SPRWriteResGroup117_ICXWriteResGroup260_ICXWriteResGroup259_SKLWriteResGroup219_SKLWriteResGroup218
  {81,  0}, // #57 ADLPWriteResGroup248_ADLPWriteResGroup246_SPRWriteResGroup387_SPRWriteResGroup385
  {13,  0}, // #58 ADLPWriteResGroup272_ADLPWriteResGroup193_ADLPWriteResGroup213_ADLPWriteResGroup215_SPRWriteResGroup559_SPRWriteResGroup197_SPRWriteResGroup217_SPRWriteResGroup221
  { 1,  0}, // #59 WriteRMW
  {65,  0}, // #60 ADLPWriteResGroup90_SPRWriteResGroup100
  {70,  0}, // #61 ADLPWriteResGroup107_WriteFDivXLd_WriteFSqrtXLd_SPRWriteResGroup116
  {37,  0}, // #62 ADLPWriteResGroup279_WriteFDiv64Ld_SKXWriteResGroup250_SKXWriteResGroup249_SPRWriteResGroup566_SPRWriteResGroup372_ICXWriteResGroup250_ICXWriteResGroup249_SKLWriteResGroup211
  {27,  0}, // #63 ADLPWriteResGroup42_WriteDPPSY_PdWriteVDPPSrri_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64YLd_WriteFSqrtYLd_WriteFSqrtZLd_SKXWriteResGroup239_HWWriteFPREM1_HWWriteResGroup155_SPRWriteResGroup45_SPRWriteResGroup433_SPRWriteResGroup434_ICXWriteResGroup239_SKLWriteResGroup206
  {30,  0}, // #64 ADLPWriteResGroup43_AtomWrite01_30_WriteDPPSLd_BWWriteResGroup186_WriteFDiv64ZLd_SKXWriteResGroup243_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_HWWriteResGroup161_HWWriteResGroup164_SPRWriteResGroup46_SPRWriteResGroup440_ICXWriteResGroup243_SKLWriteResGroup208
  {41,  0}, // #65 ADLPWriteResGroup281_WriteFSqrtX_WriteDiv64_WriteIDiv64_SKXWriteResGroup253_HWWriteResGroup175_SPRWriteResGroup568_SPRWriteResGroup377_SPRWriteResGroup544_ICXWriteResGroup253_SKLWriteResGroup213
  {46,  0}, // #66 ADLPWriteResGroup285_ADLPWriteResGroup284_AtomWrite01_46_PdWriteVZEROUPPER_JWriteJVZEROUPPER_SKLWriteResGroup216
  {40,  0}, // #67 ADLPWriteResGroup257_WriteFSqrt80_SKXWriteResGroup252_SPRWriteResGroup416_SPRWriteResGroup435_SPRWriteResGroup436_SPRWriteResGroup547_ICXWriteResGroup252_SKLWriteResGroup212
  {62,  0}, // #68 ADLPWriteResGroup59_WriteFDiv64Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv8Ld_WriteFSqrt64Ld_SKXWriteResGroup258_SPRWriteResGroup63_ICXWriteResGroup258_SKLWriteResGroup217
  {106,  0}, // #69 ADLPWriteResGroup65_SKXWriteResGroup266_SPRWriteResGroup69_ICXWriteResGroup266_SKLWriteResGroup223
  {20,  0}, // #70 ADLPWriteResGroup251_SPRWriteResGroup402_SPRWriteResGroup399
  { 5,  0}, // #71 WriteVecMaskedGatherWriteback
  {29,  0}, // #72 ADLPWriteResGroup250_AtomWrite01_29_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteAESKeyGen_WriteFDiv64YLd_WriteFSqrt64Y_BWWriteResGroup182_BWWriteResGroup185_SKXWriteResGroup242_WriteFDivY_WriteFDivZ_WriteFSqrtY_WriteFSqrtZ_SPRWriteResGroup398_SPRWriteResGroup405_SPRWriteResGroup439_ICXWriteResGroup242
  { 5,  0}, // #73 WriteVecMaskedGatherWriteback
  {28,  0}, // #74 ADLPWriteResGroup253_WriteDiv32Ld_WriteIDiv32Ld_WriteIDiv16Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_SPRWriteResGroup407_SPRWriteResGroup400_SPRWriteResGroup401_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64YLd_WriteFSqrt64ZLd
  { 5,  0}, // #75 WriteVecMaskedGatherWriteback
  {30,  0}, // #76 ADLPWriteResGroup252_SPRWriteResGroup403_SPRWriteResGroup406
  { 5,  0}, // #77 WriteVecMaskedGatherWriteback
  {40,  0}, // #78 ADLPWriteResGroup275_SPRWriteResGroup562
  { 1,  0}, // #79 WriteRMW
  {26,  0}, // #80 ADLPWriteResGroup35_AtomWrite01_26_BWWriteResGroup180_WriteFSqrtXLd_WriteFSqrtLd_WriteFDiv64XLd_SPRWriteResGroup38_SPRWriteResGroup310_SPRWriteResGroup323_SPRWriteResGroup453
  {198,  0}, // #81 ADLPWriteResGroup87_SPRWriteResGroup97
  {66,  0}, // #82 ADLPWriteResGroup88_SPRWriteResGroup98
  {71,  0}, // #83 ADLPWriteResGroup89_ADLPWriteResGroup91_WriteFSqrt80_AtomWrite01_71_WriteFSqrt64X_SPRWriteResGroup99_SPRWriteResGroup101
  {217,  0}, // #84 ADLPWriteResGroup133_SPRWriteResGroup143
  {181,  0}, // #85 ADLPWriteResGroup136_SPRWriteResGroup146
  {514,  0}, // #86 ADLPWriteResGroup146_SPRWriteResGroup155
  {20,  0}, // #87 ADLPWriteResGroup194_ADLPWriteResGroup196_SPRWriteResGroup198_SPRWriteResGroup200
  { 1,  0}, // #88 WriteRMW
  {1386,  0}, // #89 ADLPWriteResGroup202_SPRWriteResGroup206
  {1381,  0}, // #90 ADLPWriteResGroup204_SPRWriteResGroup208
  {74,  0}, // #91 ADLPWriteResGroup247_ADLPWriteResGroup249_AtomWrite01_74_WriteFSqrt64XLd_SKXWriteResGroup262_SPRWriteResGroup386_SPRWriteResGroup388_ICXWriteResGroup262
  {521,  0}, // #92 ADLPWriteResGroup259_SPRWriteResGroup423
  {473,  0}, // #93 ADLPWriteResGroup260_SPRWriteResGroup422
  {494,  0}, // #94 ADLPWriteResGroup261_SPRWriteResGroup427
  {470,  0}, // #95 ADLPWriteResGroup262_SPRWriteResGroup421
  {50,  0}, // #96 WriteDiv16Ld_WriteDiv32Ld_WriteDiv8
  {130,  0}, // #97 WriteDiv64Ld_WriteIDiv64Ld_AtomWrite01_130
  {68,  0}, // #98 WriteDiv8Ld_AtomWrite01_68
  {125,  0}, // #99 WriteFDiv64XLd_WriteFSqrt64XLd
  {34,  0}, // #100 WriteFDivLd_WriteFSqrtLd_WriteFDiv64_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_BWWriteResGroup191_JWriteMASKMOVDQU_SBWriteResGroup131_WriteAESKeyGenLd_HWWriteResGroup166
  { 1,  0}, // #101 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #102 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {45,  0}, // #103 AtomWrite01_45_WriteDiv64Ld_WriteIDiv64Ld_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Y_WriteFSqrt64Z_SPRWriteResGroup551
  {48,  0}, // #104 AtomWrite01_48
  {55,  0}, // #105 AtomWrite01_55_SPRWriteResGroup550
  {59,  0}, // #106 AtomWrite01_59_WriteFSqrt64YLd
  {72,  0}, // #107 AtomWrite01_72_WriteFDiv64XLd
  {77,  0}, // #108 AtomWrite01_77
  {78,  0}, // #109 AtomWrite01_78
  {79,  0}, // #110 AtomWrite01_79
  {92,  0}, // #111 AtomWrite01_92
  {94,  0}, // #112 AtomWrite01_94
  {99,  0}, // #113 AtomWrite01_99
  {121,  0}, // #114 AtomWrite01_121
  {127,  0}, // #115 AtomWrite01_127
  {140,  0}, // #116 AtomWrite01_140_SKXWriteResGroup267_SPRWriteResGroup180_ICXWriteResGroup267
  {141,  0}, // #117 AtomWrite01_141
  {146,  0}, // #118 AtomWrite01_146
  {147,  0}, // #119 AtomWrite01_147
  {168,  0}, // #120 AtomWrite01_168
  {174,  0}, // #121 AtomWrite01_174
  {183,  0}, // #122 AtomWrite01_183
  {202,  0}, // #123 AtomWrite01_202
  {69,  0}, // #124 WriteFDiv64X
  { 4,  0}, // #125 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #126 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {44,  0}, // #127 WriteFSqrtXLd_WriteDiv64Ld_WriteIDiv64Ld_SKXWriteResGroup256_ICXWriteResGroup256
  {38,  0}, // #128 WriteFSqrt64Ld_WriteFDivY_WriteFDiv64Y_JWriteLOCK_CMPXCHG16B_SPRWriteResGroup369_SPRWriteResGroup541
  { 5,  0}, // #129 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #130 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {90,  0}, // #131 PdWriteVZEROALL_JWriteJVZEROALL
  {184,  0}, // #132 PdWriteLARrr
  { 3,  0}, // #133 WriteIMulH
  { 3,  0}, // #134 WriteMULX32_WriteMULX64
  { 4,  0}, // #135 WriteLoad
  { 8,  0}, // #136 WriteVecMaskedGatherWriteback
  {33,  0}, // #137 WriteAESKeyGenLd_SPRWriteResGroup452_SPRWriteResGroup371
  {80,  0}, // #138 WriteDiv16_WriteDiv32_WriteDiv64
  { 9,  0}, // #139 WriteIMulHLd
  { 8,  0}, // #140 WriteMULX32Ld_WriteMULX64Ld
  { 4,  0}, // #141 WriteIMulH
  { 3,  0}, // #142 WriteMULX32_WriteMULX64
  { 6,  0}, // #143 WriteRotateLd_WriteShiftLd_WriteALULd
  { 1,  0}, // #144 WriteRMW_WriteRotate_WriteShift
  { 8,  0}, // #145 WriteRotateCLLd_WriteShiftCLLd
  { 1,  0}, // #146 WriteRMW
  { 8,  0}, // #147 WriteRotateCLLd_WriteShiftCLLd
  { 3,  0}, // #148 WriteRotateCL_WriteShiftCL
  {60,  0}, // #149 BWWriteResGroup197
  {115,  0}, // #150 BWWriteResGroup202_HWWriteResGroup183
  { 4,  0}, // #151 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 2,  0}, // #152 WriteRMW
  {43,  0}, // #153 WriteFDivYLd_WriteFDiv64YLd_SPRWriteResGroup378
  {47,  0}, // #154 WriteFSqrtYLd_HWWriteFBLD_SPRWriteResGroup552
  {54,  0}, // #155 WriteFSqrt64Y
  {11,  0}, // #156 JWriteXCHGrm_XCHG_Part_JWriteLOCK_XADDrm_XCHG_Part
  {16,  0}, // #157 JWriteXCHGrm_LdSt_Part
  { 3,  0}, // #158 JWriteXADDrm_XCHG_Part
  {11,  0}, // #159 JWriteXADDrm_LdSt_Part
  {76,  0}, // #160 WriteDiv16_WriteDiv32_WriteDiv64
  {102,  0}, // #161 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {67,  0}, // #162 SKXWriteResGroup261_ICXWriteResGroup261
  { 7,  0}, // #163 WriteRotateLd
  { 1,  0}, // #164 WriteRMW
  { 7,  0}, // #165 WriteRotateLd
  { 2,  0}, // #166 WriteRotate
  {36,  0}, // #167 WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup171_SPRWriteResGroup368
  {52,  0}, // #168 WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd
  {98,  0}, // #169 WriteDiv16_WriteDiv32_WriteDiv64
  {112,  0}, // #170 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {64,  0}, // #171 HWWriteResGroup179_HWWriteResGroup178
  {61,  0}, // #172 HWWriteResGroup177
  {27,  0}, // #173 SPRWriteResGroup404
  { 5,  0}, // #174 WriteVecMaskedGatherWriteback
  {49,  0}, // #175 SPRWriteResGroup375
  {51,  0}, // #176 SPRWriteResGroup376
  {477,  0}, // #177 SPRWriteResGroup420
  {550,  0}, // #178 SPRWriteResGroup424
  {474,  0}, // #179 SPRWriteResGroup425
  {464,  0}, // #180 SPRWriteResGroup426
  {475,  0}, // #181 SPRWriteResGroup428
  {476,  0}, // #182 SPRWriteResGroup429
  {471,  0}, // #183 SPRWriteResGroup430
  {53,  0}, // #184 SPRWriteResGroup549
  { 7,  0}, // #185 WriteIMulHLd
  { 7,  0}, // #186 WriteMULX32Ld_WriteMULX64Ld
  { 8,  0}, // #187 WriteIMulHLd
  { 7,  0} // #188 WriteMULX32Ld_WriteMULX64Ld
}; // X86WriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry X86ReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {0,  0,  5}, // #1
  {5,  0,  5}, // #2
  {6,  0,  5}, // #3
  {0,  0,  5}, // #4
  {6,  0,  5}, // #5
  {0,  0,  6}, // #6
  {1,  0,  0}, // #7
  {0,  0,  6}, // #8
  {6,  0,  6}, // #9
  {0,  0,  6}, // #10
  {1,  0,  6}, // #11
  {0,  0,  5}, // #12
  {1,  0,  5}, // #13
  {0,  0,  3}, // #14
  {5,  0,  3}, // #15
  {6,  0,  3}, // #16
  {0,  0,  3}, // #17
  {6,  0,  3}, // #18
  {0,  0,  3}, // #19
  {1,  0,  3}, // #20
  {0,  0,  4}, // #21
  {5,  0,  4}, // #22
  {6,  0,  4}, // #23
  {0,  0,  4}, // #24
  {6,  0,  4}, // #25
  {0,  0, -10}, // #26
  {1,  0, -10}, // #27
  {0,  0,  8}, // #28
  {0,  0,  8}, // #29
  {6,  0,  8}, // #30
  {0,  0,  8}, // #31
  {1,  0,  8}, // #32
  {0,  0, -6}, // #33
  {1,  0, -6}, // #34
  {5,  0,  3}, // #35
  {6,  0,  3}, // #36
  {7,  0,  3}, // #37
  {8,  0,  3}, // #38
  {0,  0,  7}, // #39
  {0,  0,  7}, // #40
  {6,  0,  7}, // #41
  {0,  0,  7}, // #42
  {1,  0,  7}, // #43
  {0,  0, -1}, // #44
  {1,  0, -1} // #45
}; // X86ReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AlderlakePModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  3, 9,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false, 12, 5,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, false, 17, 9,  2, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        2, false, false, false, 26, 9,  3, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  1, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false, 35, 3,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteLEA")           1, false, false, false, 38, 8,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteRMW")           3, false, false, false, 46, 5,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteADC")           1, false, false, false, 12, 5,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 38, 8,  5, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreX")       2, false, false, false, 51, 4,  2, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 55, 3,  6, 1,  0, 0}, // #14
  {DBGFIELD("WriteFStoreY")       2, false, false, false, 51, 4,  2, 1,  0, 0}, // #15
  {DBGFIELD("WriteFLoadY")        1, false, false, false, 55, 3,  7, 1,  0, 0}, // #16
  {DBGFIELD("WriteMicrocoded")    1, false, false, false, 35, 3,  4, 1,  0, 0}, // #17
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault") 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #18
  {DBGFIELD("WriteFSign")         1, false, false, false,  3, 9,  1, 1,  0, 0}, // #19
  {DBGFIELD("WriteADCRMW")        5, false, false, false, 64, 9,  2, 1,  0, 0}, // #20
  {DBGFIELD("WriteADCLd_ReadAfterLd") 2, false, false, false, 73, 5,  8, 1,  1, 1}, // #21
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 64, 9,  2, 1,  2, 2}, // #22
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 73, 5,  8, 1,  4, 2}, // #23
  {DBGFIELD("WriteALURMW")        4, false, false, false, 58, 6,  2, 1,  0, 0}, // #24
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #25
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 58, 6,  2, 1,  2, 1}, // #26
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #27
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 86, 6,  5, 1,  0, 0}, // #28
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #29
  {DBGFIELD("WriteFAddX")         1, false, false, false, 86, 6,  5, 1,  0, 0}, // #30
  {DBGFIELD("WriteNop")           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #32
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 86, 6,  5, 1,  0, 0}, // #33
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #34
  {DBGFIELD("WriteFAdd")          1, false, false, false, 92, 9,  5, 1,  0, 0}, // #35
  {DBGFIELD("WriteFAddLd")        2, false, false, false, 78, 8,  9, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #37
  {DBGFIELD("WriteAESDecEnc")     1, false, false, false, 108, 5, 10, 1,  0, 0}, // #38
  {DBGFIELD("WriteAESIMCLd")      3, false, false, false, 113, 7, 11, 1,  0, 0}, // #39
  {DBGFIELD("WriteAESIMC")        2, false, false, false, 120, 5,  7, 1,  0, 0}, // #40
  {DBGFIELD("WriteAESKeyGenLd")   14, false, false, false, 125, 14,  2, 1,  0, 0}, // #41
  {DBGFIELD("WriteAESKeyGen")     14, false, false, false, 139, 12,  6, 1,  0, 0}, // #42
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #43
  {DBGFIELD("WriteFLogic")        1, false, false, false, 109, 4,  1, 1,  0, 0}, // #44
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 151, 12,  8, 1,  2, 1}, // #45
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 163, 10,  3, 1,  0, 0}, // #46
  {DBGFIELD("WriteBEXTRLd")       3, false, false, false, 151, 12,  8, 1,  0, 0}, // #47
  {DBGFIELD("WriteALULd")         1, false, false, false,  1, 2,  8, 1,  0, 0}, // #48
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #49
  {DBGFIELD("WriteFBlend")        1, false, false, false, 109, 4,  1, 1,  0, 0}, // #50
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #51
  {DBGFIELD("WriteFVarBlend")     1, false, false, false, 109, 4,  1, 1,  0, 0}, // #52
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 173, 5,  6, 1,  0, 0}, // #53
  {DBGFIELD("WriteBLS")           1, false, false, false, 178, 3, 12, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSFLd")         2, false, false, false, 181, 10,  7, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSF")           1, false, false, false, 38, 8,  5, 1,  0, 0}, // #56
  {DBGFIELD("WriteBSRLd")         2, false, false, false, 181, 10,  7, 1,  0, 0}, // #57
  {DBGFIELD("WriteBSR")           1, false, false, false, 38, 8,  5, 1,  0, 0}, // #58
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 38, 8,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBSWAP64")       2, false, false, false, 163, 10, 12, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, false, 181, 10,  3, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestRegLd")  10, false, false, false, 191, 12,  8, 1,  0, 0}, // #62
  {DBGFIELD("WriteBitTest")       1, false, false, false, 38, 8,  1, 1,  0, 0}, // #63
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 203, 12,  2, 1,  0, 0}, // #64
  {DBGFIELD("WriteBitTestSetRegRMW") 11, false, false, false, 215, 14, 13, 1,  0, 0}, // #65
  {DBGFIELD("WriteBitTestSet")    1, false, false, false, 38, 8,  1, 1,  0, 0}, // #66
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 181, 10,  7, 1,  2, 1}, // #67
  {DBGFIELD("WriteBZHI")          1, false, false, false, 38, 8,  5, 1,  0, 0}, // #68
  {DBGFIELD("WriteCMOV_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #69
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, false, 229, 7,  6, 1,  1, 1}, // #70
  {DBGFIELD("WriteCMOV")          1, false, false, false, 12, 5,  1, 1,  0, 0}, // #71
  {DBGFIELD("WriteLoad")          1, false, false, false, 55, 3, 10, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 38, 8,  5, 1,  0, 0}, // #73
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false,  1, 2,  8, 1,  2, 1}, // #74
  {DBGFIELD("WriteXCHG")          3, false, false, false, 236, 2, 12, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #76
  {DBGFIELD("WriteFCmp64X")       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #77
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #78
  {DBGFIELD("WriteFCmpX")         1, false, false, false, 108, 5, 14, 1,  0, 0}, // #79
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #80
  {DBGFIELD("WriteFCmp64")        1, false, false, false, 108, 5, 14, 1,  0, 0}, // #81
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #82
  {DBGFIELD("WriteFCmp")          1, false, false, false, 108, 5, 14, 1,  0, 0}, // #83
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 238, 5,  5, 1,  0, 0}, // #84
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 243, 11,  7, 1,  6, 1}, // #85
  {DBGFIELD("WriteFComX")         1, false, false, false,  3, 9,  5, 1,  0, 0}, // #86
  {DBGFIELD("WriteFCom")          1, false, false, false, 92, 9,  1, 1,  0, 0}, // #87
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, false, 181, 10,  7, 1,  1, 1}, // #88
  {DBGFIELD("WriteCRC32")         1, false, false, false, 38, 8,  5, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2PD")       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPD2ILd")     3, false, false, false, 264, 12,  2, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPD2I")       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtPD2PSLd")    3, false, false, false, 264, 12,  2, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, false, 254, 10, 10, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 101, 7,  8, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, false, 254, 10, 10, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtSD2ILd")     3, false, false, false, 276, 11,  2, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 2, false, false, false, 287, 9,  6, 1,  0, 0}, // #103
  {DBGFIELD("WriteCvtSD2I")       2, false, false, false, 287, 9,  6, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #105
  {DBGFIELD("WriteCvtSD2SS")      2, false, false, false, 254, 10, 10, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #107
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #108
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 2, false, false, false, 254, 10,  6, 1,  0, 1}, // #109
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 2, false, false, false, 254, 10,  6, 1,  7, 1}, // #110
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #112
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 2, false, false, false, 254, 10,  6, 1,  0, 1}, // #113
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 2, false, false, false, 254, 10,  6, 1,  7, 1}, // #114
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #115
  {DBGFIELD("WriteCvtSS2SD")      2, false, false, false, 254, 10, 10, 1,  0, 0}, // #116
  {DBGFIELD("WriteCvtSS2ILd")     3, false, false, false, 276, 11,  2, 1,  0, 0}, // #117
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 2, false, false, false, 287, 9,  6, 1,  0, 0}, // #118
  {DBGFIELD("WriteCvtSS2I")       2, false, false, false, 287, 9,  6, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 296, 10, 15, 1,  2, 2}, // #120
  {DBGFIELD("WriteDiv16")         4, false, false, false, 306, 8, 16, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 296, 10, 17, 1,  2, 2}, // #122
  {DBGFIELD("WriteDiv32")         4, false, false, false, 306, 8, 11, 1,  0, 0}, // #123
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 314, 10, 18, 1,  2, 2}, // #124
  {DBGFIELD("WriteDiv64")         3, false, false, false, 324, 8, 13, 1,  0, 0}, // #125
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 324, 8, 19, 1,  2, 2}, // #126
  {DBGFIELD("WriteDiv8")          3, false, false, false, 324, 8, 20, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, false, 243, 11, 15, 1,  6, 1}, // #128
  {DBGFIELD("WriteFDiv64X")       1, false, false, false,  3, 9, 21, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, false, 243, 11, 13, 1,  6, 1}, // #130
  {DBGFIELD("WriteFDivX")         1, false, false, false,  3, 9,  8, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd")        2, false, false, false, 243, 11, 13, 1,  0, 0}, // #132
  {DBGFIELD("WriteFDiv")          1, false, false, false,  3, 9,  8, 1,  0, 0}, // #133
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #134
  {DBGFIELD("WriteFDiv64")        1, false, false, false,  3, 9, 21, 1,  0, 0}, // #135
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, false, 243, 11, 13, 1,  6, 1}, // #136
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, false, 332, 9, 16, 1,  6, 1}, // #137
  {DBGFIELD("WriteDPPD")          3, false, false, false, 341, 7, 22, 1,  0, 0}, // #138
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 7, false, false, false, 348, 13, 23, 1,  6, 1}, // #139
  {DBGFIELD("WriteDPPS")          6, false, false, false, 361, 11, 21, 1,  0, 0}, // #140
  {DBGFIELD("WriteStore")         2, false, false, false, 51, 4,  2, 1,  0, 0}, // #141
  {DBGFIELD("WriteVecExtractSt")  3, false, false, false, 372, 9, 17, 1,  0, 0}, // #142
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 381, 11, 14, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 108, 5,  1, 1,  0, 0}, // #144
  {DBGFIELD("WriteFComLd")        2, false, false, false, 392, 13,  7, 1,  0, 0}, // #145
  {DBGFIELD("WriteEMMS")          10, false, false, false, 405, 9,  9, 1,  0, 0}, // #146
  {DBGFIELD("WriteFLDC")          2, false, false, false, 414, 6,  1, 1,  0, 0}, // #147
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #148
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 108, 5, 10, 1,  0, 0}, // #149
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #150
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 420, 11,  2, 1,  6, 1}, // #151
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 431, 9,  3, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 296, 10, 15, 1,  2, 2}, // #153
  {DBGFIELD("WriteIDiv16")        4, false, false, false, 306, 8, 16, 1,  0, 0}, // #154
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 296, 10, 17, 1,  2, 2}, // #155
  {DBGFIELD("WriteIDiv32")        4, false, false, false, 306, 8, 11, 1,  0, 0}, // #156
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 314, 10, 18, 1,  2, 2}, // #157
  {DBGFIELD("WriteIDiv64")        3, false, false, false, 324, 8, 13, 1,  0, 0}, // #158
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 324, 8, 19, 1,  2, 2}, // #159
  {DBGFIELD("WriteIDiv8")         3, false, false, false, 324, 8, 20, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 440, 12,  9, 1,  2, 2}, // #161
  {DBGFIELD("WriteIMul16")        4, false, false, false, 452, 10, 10, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, false, 181, 10,  7, 1,  1, 1}, // #163
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 462, 10, 22, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 38, 8,  5, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 472, 8, 14, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 480, 12, 22, 1,  2, 2}, // #167
  {DBGFIELD("WriteIMul32")        3, false, false, false, 492, 10, 14, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, false, 181, 10,  7, 1,  1, 1}, // #169
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 181, 10,  7, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 38, 8,  5, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 38, 8,  5, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 502, 13, 22, 1,  2, 2}, // #173
  {DBGFIELD("WriteIMul64")        2, false, false, false, 515, 11, 14, 1,  0, 0}, // #174
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, false, 181, 10,  7, 1,  1, 1}, // #175
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 181, 10,  7, 1,  0, 0}, // #176
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 38, 8,  5, 1,  0, 0}, // #177
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 38, 8,  5, 1,  0, 0}, // #178
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 181, 10,  7, 1,  2, 2}, // #179
  {DBGFIELD("WriteIMul8")         1, false, false, false, 38, 8,  5, 1,  0, 0}, // #180
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #181
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 92, 9,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 109, 4,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteShuffle")       1, false, false, false, 92, 9,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 12, 5,  5, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 55, 3,  6, 1,  0, 0}, // #186
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 537, 11,  6, 1,  0, 0}, // #187
  {DBGFIELD("WriteFLD0")          1, false, false, false, 548, 6,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteFLD1")          2, false, false, false, 414, 6,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteFence")         1, false, false, false, 12, 5, 12, 1,  0, 0}, // #190
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 181, 10,  7, 1,  0, 0}, // #191
  {DBGFIELD("WriteLZCNT")         1, false, false, false, 38, 8,  5, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecStoreX")     2, false, false, false, 51, 4,  2, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStore")      2, false, false, false, 51, 4,  2, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false,  3, 9,  5, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 55, 3,  6, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #197
  {DBGFIELD("WriteVecMoveX")      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecStoreNT")    2, false, false, false, 51, 4, 25, 1,  0, 0}, // #199
  {DBGFIELD("WriteVecMove")       1, false, false, false, 548, 6,  1, 1,  0, 0}, // #200
  {DBGFIELD("WriteVecALULd")      2, false, false, false, 243, 11, 22, 1,  0, 0}, // #201
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #202
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, false, 243, 11, 22, 1,  6, 1}, // #203
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, false, 554, 8, 22, 1,  6, 1}, // #204
  {DBGFIELD("WriteVecLogic")      1, false, false, false, 548, 6,  1, 1,  0, 0}, // #205
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 562, 11,  8, 1,  6, 1}, // #206
  {DBGFIELD("WritePHAdd")         3, false, false, false, 573, 9,  5, 1,  0, 0}, // #207
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 78, 8,  7, 1,  1, 1}, // #208
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 582, 9, 14, 1,  7, 1}, // #209
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, false, 243, 11, 24, 1,  6, 1}, // #210
  {DBGFIELD("WriteVecIMul")       1, false, false, false,  3, 9, 10, 1,  0, 0}, // #211
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false,  3, 9,  5, 1,  0, 0}, // #212
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #213
  {DBGFIELD("WritePSADBW")        1, false, false, false, 92, 9,  5, 1,  0, 0}, // #214
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 3, false, false, false, 591, 14,  8, 1,  6, 1}, // #215
  {DBGFIELD("WriteVarShuffle")    2, false, false, false, 605, 12,  5, 1,  0, 0}, // #216
  {DBGFIELD("WriteShuffleLd")     2, false, false, false, 526, 11, 22, 1,  0, 0}, // #217
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false,  3, 9,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, false, 243, 11, 22, 1,  6, 1}, // #219
  {DBGFIELD("WriteVecShift")      1, false, false, false,  3, 9,  1, 1,  0, 0}, // #220
  {DBGFIELD("WriteFMoveX")        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFShuffleLd")    2, false, false, false, 526, 11,  7, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStore")        2, false, false, false, 51, 4,  2, 1,  0, 0}, // #223
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false,  3, 9,  5, 1,  0, 0}, // #224
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 55, 3,  6, 1,  0, 0}, // #225
  {DBGFIELD("WriteStoreNT")       2, false, false, false, 51, 4, 26, 1,  0, 0}, // #226
  {DBGFIELD("WriteFStoreNTX")     2, false, false, false, 51, 4, 27, 1,  0, 0}, // #227
  {DBGFIELD("WriteFStoreNT")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #228
  {DBGFIELD("WriteFLoad")         1, false, false, false, 55, 3,  6, 1,  0, 0}, // #229
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 3, false, false, false, 617, 11,  8, 1,  6, 1}, // #230
  {DBGFIELD("WriteMPSAD")         2, false, false, false, 582, 9, 14, 1,  0, 0}, // #231
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #232
  {DBGFIELD("WriteFMul64X")       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #233
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #234
  {DBGFIELD("WriteFMulX")         1, false, false, false, 108, 5, 14, 1,  0, 0}, // #235
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #236
  {DBGFIELD("WriteFMul64")        1, false, false, false, 108, 5, 14, 1,  0, 0}, // #237
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #238
  {DBGFIELD("WriteFMul")          1, false, false, false, 108, 5, 14, 1,  0, 0}, // #239
  {DBGFIELD("WriteMULX32Ld")      3, false, false, false, 480, 12, 22, 1,  0, 0}, // #240
  {DBGFIELD("WriteMULX32")        2, false, false, false, 492, 10, 14, 1,  0, 0}, // #241
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 480, 12, 28, 2,  2, 1}, // #242
  {DBGFIELD("WriteIMulH_WriteMULX32") 3, false, false, false, 492, 10, 30, 2,  0, 0}, // #243
  {DBGFIELD("WriteMULX64Ld")      2, false, false, false, 502, 13, 22, 1,  0, 0}, // #244
  {DBGFIELD("WriteMULX64")        1, false, false, false, 515, 11, 14, 1,  0, 0}, // #245
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 502, 13, 28, 2,  2, 1}, // #246
  {DBGFIELD("WriteIMulH_WriteMULX64") 2, false, false, false, 515, 11, 30, 2,  0, 0}, // #247
  {DBGFIELD("WriteFMulLd")        2, false, false, false, 101, 7,  8, 1,  0, 0}, // #248
  {DBGFIELD("WriteVecALUXLd")     2, false, false, false, 101, 7,  7, 1,  0, 0}, // #249
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #250
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 86, 6,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #252
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #253
  {DBGFIELD("WriteVarBlend")      1, false, false, false, 109, 4,  1, 1,  0, 0}, // #254
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #255
  {DBGFIELD("WriteBlend")         1, false, false, false, 86, 6,  1, 1,  0, 0}, // #256
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, false, 526, 11,  9, 1,  6, 1}, // #257
  {DBGFIELD("WriteCLMul")         1, false, false, false, 92, 9,  5, 1,  0, 0}, // #258
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8, false, false, false, 628, 15, 32, 1,  6, 1}, // #259
  {DBGFIELD("WritePCmpEStrI")     8, false, false, false, 643, 13, 16, 1,  0, 0}, // #260
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 9, false, false, false, 656, 15, 20, 1,  6, 1}, // #261
  {DBGFIELD("WritePCmpEStrM")     9, false, false, false, 671, 13, 16, 1,  0, 0}, // #262
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, false, 684, 11, 32, 1,  6, 1}, // #263
  {DBGFIELD("WritePCmpIStrI")     3, false, false, false, 695, 9,  8, 1,  0, 0}, // #264
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, false, 684, 11, 16, 1,  6, 1}, // #265
  {DBGFIELD("WritePCmpIStrM")     3, false, false, false, 695, 9,  8, 1,  0, 0}, // #266
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #267
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 704, 8, 22, 1,  6, 1}, // #268
  {DBGFIELD("WritePHAddX")        3, false, false, false, 712, 6, 12, 1,  0, 0}, // #269
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 243, 11,  8, 1,  0, 0}, // #270
  {DBGFIELD("WritePHMINPOS")      1, false, false, false,  3, 9, 14, 1,  0, 0}, // #271
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #272
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false,  3, 9,  5, 1,  0, 0}, // #273
  {DBGFIELD("WriteShuffleXLd")    2, false, false, false, 78, 8,  7, 1,  0, 0}, // #274
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, false, 113, 7, 13, 1,  6, 1}, // #275
  {DBGFIELD("WritePMULLD")        2, false, false, false, 120, 5,  9, 1,  0, 0}, // #276
  {DBGFIELD("WriteCopy")          3, false, false, false, 46, 5, 20, 1,  0, 0}, // #277
  {DBGFIELD("WritePOPCNTLd")      2, false, false, false, 181, 10,  7, 1,  0, 0}, // #278
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 38, 8,  5, 1,  0, 0}, // #279
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 526, 11,  9, 1,  6, 1}, // #280
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 92, 9,  5, 1,  0, 0}, // #281
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #282
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 86, 6,  1, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 108, 5,  1, 1,  0, 0}, // #284
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #285
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 718, 7, 12, 1,  0, 0}, // #286
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, false, 591, 14, 22, 1,  6, 1}, // #287
  {DBGFIELD("WriteVecTest")       2, false, false, false, 605, 12, 14, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateLd_WriteRMW") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #289
  {DBGFIELD("WriteRotateLd_WriteRotate") 6, false, false, false, 725, 5, 35, 2,  0, 0}, // #290
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #291
  {DBGFIELD("WriteRotateCLLd_WriteRotateCL") 9, false, false, false, 744, 10, 39, 2,  0, 0}, // #292
  {DBGFIELD("WriteRotate")        3, false, false, false, 754, 5, 12, 1,  0, 0}, // #293
  {DBGFIELD("WriteRotateCL")      2, false, false, false, 759, 5, 12, 1,  0, 0}, // #294
  {DBGFIELD("WriteFRcpXLd")       2, false, false, false, 243, 11,  8, 1,  0, 0}, // #295
  {DBGFIELD("WriteFRcpX")         1, false, false, false,  3, 9, 14, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRcpLd")        2, false, false, false, 243, 11,  8, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, false, 243, 11,  8, 1,  6, 1}, // #298
  {DBGFIELD("WriteFRcp")          1, false, false, false,  3, 9, 14, 1,  0, 0}, // #299
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 12, 5,  2, 1,  0, 0}, // #300
  {DBGFIELD("WriteShift")         1, false, false, false, 12, 5,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRndLd")        3, false, false, false, 113, 7, 11, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRnd")          2, false, false, false, 120, 5,  7, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #304
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, false, 243, 11,  8, 1,  0, 0}, // #305
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false,  3, 9, 14, 1,  0, 0}, // #306
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, false, 243, 11,  8, 1,  0, 0}, // #307
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, false, 243, 11,  8, 1,  6, 1}, // #308
  {DBGFIELD("WriteFRsqrt")        1, false, false, false,  3, 9, 14, 1,  0, 0}, // #309
  {DBGFIELD("WriteShiftLd_WriteRMW") 4, false, false, false, 764, 9, 33, 2,  0, 0}, // #310
  {DBGFIELD("WriteShiftLd_WriteShift") 2, false, false, false, 759, 5, 33, 2,  0, 0}, // #311
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, false, 773, 9, 33, 2,  0, 0}, // #312
  {DBGFIELD("WriteShiftCLLd_WriteShiftCL") 4, false, false, false, 782, 5, 35, 2,  0, 0}, // #313
  {DBGFIELD("WriteShiftCL")       2, false, false, false, 759, 5, 12, 1,  0, 0}, // #314
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 12, 5,  2, 1,  2, 1}, // #315
  {DBGFIELD("WriteSETCCStore")    4, false, false, false, 787, 8, 24, 1,  0, 0}, // #316
  {DBGFIELD("WriteSETCC")         2, false, false, false, 759, 5, 12, 1,  0, 0}, // #317
  {DBGFIELD("WriteSHDmrcl")       6, false, false, false, 795, 14,  2, 1,  0, 0}, // #318
  {DBGFIELD("WriteSHDmri")        5, false, false, false, 809, 12,  2, 1,  0, 0}, // #319
  {DBGFIELD("WriteSHDrrcl")       3, false, false, false, 492, 10, 10, 1,  0, 0}, // #320
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, false, 243, 11, 41, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false,  3, 9, 13, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, false, 243, 11, 17, 1,  0, 0}, // #323
  {DBGFIELD("WriteFSqrtX")        1, false, false, false,  3, 9,  2, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, false, 243, 11, 18, 1,  0, 0}, // #325
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, false, 243, 11, 18, 1,  6, 1}, // #326
  {DBGFIELD("WriteFSqrt64")       1, false, false, false,  3, 9, 13, 1,  0, 0}, // #327
  {DBGFIELD("WriteFSqrtLd")       2, false, false, false, 243, 11, 17, 1,  0, 0}, // #328
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #329
  {DBGFIELD("WriteFSqrt")         1, false, false, false,  3, 9,  2, 1,  0, 0}, // #330
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 821, 10, 23, 1,  0, 0}, // #331
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 831, 12,  2, 1,  0, 0}, // #332
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 181, 10,  7, 1,  0, 0}, // #333
  {DBGFIELD("WriteTZCNT")         1, false, false, false, 38, 8,  5, 1,  0, 0}, // #334
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFMALd")         2, false, false, false, 101, 7,  8, 1,  0, 0}, // #336
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 78, 8,  8, 1,  6, 1}, // #337
  {DBGFIELD("WriteFAddY")         1, false, false, false, 86, 6,  5, 1,  0, 0}, // #338
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 78, 8,  8, 1,  6, 1}, // #341
  {DBGFIELD("WriteFAdd64Y")       1, false, false, false, 86, 6,  5, 1,  0, 0}, // #342
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #345
  {DBGFIELD("WriteShuffleY")      1, false, false, false, 86, 6,  1, 1,  0, 0}, // #346
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #349
  {DBGFIELD("WriteFLogicY")       1, false, false, false, 109, 4,  1, 1,  0, 0}, // #350
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, false, 254, 10,  7, 1,  0, 0}, // #353
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 254, 10,  3, 1,  0, 0}, // #354
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 4, false, false, false, 843, 6,  9, 1,  6, 1}, // #355
  {DBGFIELD("WriteFVarBlendY")    3, false, false, false, 849, 4,  5, 1,  0, 0}, // #356
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #359
  {DBGFIELD("WriteFBlendY")       1, false, false, false, 109, 4,  1, 1,  0, 0}, // #360
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 4, false, false, false, 843, 6,  9, 1,  8, 2}, // #361
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 102, 6,  7, 1,  8, 2}, // #362
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, false, 526, 11,  8, 1,  0, 0}, // #363
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 92, 9,  5, 1,  0, 0}, // #364
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 78, 8, 22, 1,  0, 0}, // #365
  {DBGFIELD("WriteFShuffle256")   1, false, false, false, 92, 9,  5, 1,  0, 0}, // #366
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #367
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #368
  {DBGFIELD("WriteFCmpY")         1, false, false, false, 108, 5, 14, 1,  0, 0}, // #369
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #372
  {DBGFIELD("WriteFCmp64Y")       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #373
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #374
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #376
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 3, false, false, false, 264, 12, 11, 1,  6, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSY")     2, false, false, false, 254, 10,  6, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #381
  {DBGFIELD("WriteVecIMulY")      1, false, false, false, 108, 5, 10, 1,  0, 0}, // #382
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, false, 101, 7,  2, 1,  0, 0}, // #385
  {DBGFIELD("WriteCvtI2PDY")      2, false, false, false, 254, 10,  6, 1,  0, 0}, // #386
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 101, 7,  2, 1,  0, 0}, // #389
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, false, 108, 5, 14, 1,  0, 0}, // #390
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, false, 264, 12, 11, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD("WriteCvtPD2IYLd")    3, false, false, false, 264, 12, 11, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPD2IY")      2, false, false, false, 254, 10,  6, 1,  0, 0}, // #398
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 101, 7,  2, 1,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, false, 108, 5, 14, 1,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, false, 101, 7,  2, 1,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, false, 254, 10,  6, 1,  0, 0}, // #406
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #407
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, false, 101, 7,  2, 1,  0, 0}, // #409
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, false, 101, 7,  2, 1,  0, 0}, // #410
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, false, 853, 8,  2, 1,  0, 0}, // #411
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, false, 254, 10,  7, 1,  0, 0}, // #412
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, false, 853, 8,  2, 1,  0, 0}, // #413
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 254, 10,  3, 1,  0, 0}, // #414
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #417
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #418
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #419
  {DBGFIELD("WritePSADBWY")       1, false, false, false, 92, 9,  5, 1,  0, 0}, // #420
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #423
  {DBGFIELD("WriteFDivY")         1, false, false, false,  3, 9,  8, 1,  0, 0}, // #424
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, false, 243, 11, 23, 1,  6, 1}, // #427
  {DBGFIELD("WriteFDiv64Y")       1, false, false, false,  3, 9, 21, 1,  0, 0}, // #428
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #431
  {DBGFIELD("WriteFMAX")          1, false, false, false, 108, 5, 14, 1,  0, 0}, // #432
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #433
  {DBGFIELD("WriteFMAY")          1, false, false, false, 108, 5, 14, 1,  0, 0}, // #434
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 7, false, false, false, 348, 13, 19, 1,  6, 1}, // #437
  {DBGFIELD("WriteDPPSY")         6, false, false, false, 361, 11, 21, 1,  0, 0}, // #438
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #439
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  8, 1, 10, 2}, // #440
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 101, 7,  2, 1, 10, 2}, // #441
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, false, 101, 7,  8, 1, 10, 2}, // #443
  {DBGFIELD("WriteFMA")           1, false, false, false, 108, 5, 14, 1,  0, 0}, // #444
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 101, 7,  2, 1,  8, 2}, // #445
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 101, 7,  8, 1,  8, 2}, // #446
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, false, 101, 7,  8, 1,  8, 2}, // #447
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #448
  {DBGFIELD("WriteFRndY")         2, false, false, false, 120, 5,  7, 1,  0, 0}, // #449
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 1, false, false, false, 55, 3, 42, 2,  0, 0}, // #450
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #453
  {DBGFIELD("WriteVecALUY")       1, false, false, false, 108, 5,  1, 1,  0, 0}, // #454
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, false, 420, 11, 24, 1,  6, 1}, // #457
  {DBGFIELD("WriteFHAddY")        3, false, false, false, 431, 9, 10, 1,  0, 0}, // #458
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #459
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #460
  {DBGFIELD("WriteVecLoadY")      1, false, false, false, 55, 3,  7, 1,  0, 0}, // #461
  {DBGFIELD("WriteFMaskedStore64Y") 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #462
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, false, 102, 6, 22, 1,  0, 0}, // #463
  {DBGFIELD("WriteFMaskedStore64") 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #464
  {DBGFIELD("WriteFMaskedLoad")   2, false, false, false, 102, 6,  7, 1,  0, 0}, // #465
  {DBGFIELD("WriteFMaskedStore32Y") 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #466
  {DBGFIELD("WriteFMaskedStore32") 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #467
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteFMoveY")        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #470
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 526, 11, 22, 1,  0, 0}, // #472
  {DBGFIELD("WriteFShuffleY")     1, false, false, false, 92, 9,  1, 1,  0, 0}, // #473
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteVecStoreY")     2, false, false, false, 51, 4,  2, 1,  0, 0}, // #476
  {DBGFIELD("WriteVecMoveY")      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #477
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 55, 3,  7, 1,  0, 0}, // #479
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, false, 51, 4, 44, 1,  0, 0}, // #480
  {DBGFIELD("WriteFStoreNTY")     2, false, false, false, 51, 4, 45, 1,  0, 0}, // #481
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 3, false, false, false, 617, 11,  2, 1,  6, 1}, // #482
  {DBGFIELD("WriteMPSADY")        2, false, false, false, 582, 9, 14, 1,  0, 0}, // #483
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #484
  {DBGFIELD("WriteFMulY")         1, false, false, false, 108, 5, 14, 1,  0, 0}, // #485
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #488
  {DBGFIELD("WriteFMul64Y")       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #489
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteVecALUYLd")     2, false, false, false, 101, 7, 22, 1,  0, 0}, // #492
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #494
  {DBGFIELD("WriteVecLogicY")     1, false, false, false, 109, 4,  1, 1,  0, 0}, // #495
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #498
  {DBGFIELD("WriteBlendY")        1, false, false, false, 109, 4,  1, 1,  0, 0}, // #499
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 4, false, false, false, 843, 6,  9, 1,  6, 1}, // #500
  {DBGFIELD("WriteVarBlendY")     3, false, false, false, 849, 4,  5, 1,  0, 0}, // #501
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 4, false, false, false, 843, 6,  9, 1,  8, 2}, // #504
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 102, 6,  7, 1,  8, 2}, // #505
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 78, 8, 22, 1,  8, 2}, // #506
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 78, 8, 22, 1, 10, 2}, // #507
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 78, 8,  7, 1,  8, 2}, // #508
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 78, 8,  7, 1, 10, 2}, // #509
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 101, 7, 24, 1, 10, 2}, // #510
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 101, 7, 24, 1, 10, 2}, // #511
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #513
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 526, 11, 22, 1,  8, 2}, // #515
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 526, 11, 22, 1, 10, 2}, // #516
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, false, 92, 9,  1, 1,  0, 0}, // #517
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 526, 11,  7, 1,  8, 2}, // #518
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 526, 11,  7, 1, 10, 2}, // #519
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 92, 9,  1, 1,  0, 0}, // #520
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #521
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #522
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, false, 704, 8,  9, 1,  6, 1}, // #525
  {DBGFIELD("WritePHAddY")        3, false, false, false, 712, 6, 12, 1,  0, 0}, // #526
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 582, 9, 14, 1,  0, 0}, // #527
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, false, 101, 7, 24, 1,  0, 0}, // #528
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, false, 101, 7, 24, 1,  0, 0}, // #529
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteVecMaskedStore32Y") 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #531
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, false, 102, 6, 22, 1,  0, 0}, // #532
  {DBGFIELD("WriteVecMaskedStore32") 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #533
  {DBGFIELD("WriteVecMaskedLoad") 2, false, false, false, 102, 6,  7, 1,  0, 0}, // #534
  {DBGFIELD("WriteVecMaskedStore64Y") 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #535
  {DBGFIELD("WriteVecMaskedStore64") 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #536
  {DBGFIELD("WriteVPMOV256Ld")    2, false, false, false, 526, 11,  8, 1,  0, 0}, // #537
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 92, 9,  5, 1,  0, 0}, // #538
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, false,  3, 9, 14, 1,  0, 0}, // #539
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, false, 113, 7, 13, 1,  6, 1}, // #540
  {DBGFIELD("WritePMULLDY")       2, false, false, false, 120, 5,  9, 1,  0, 0}, // #541
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 78, 8,  7, 1,  8, 2}, // #544
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 78, 8,  7, 1, 10, 2}, // #545
  {DBGFIELD("WriteVecShiftImmXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, false, 108, 5,  1, 1,  0, 0}, // #548
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #551
  {DBGFIELD("WriteVarVecShift")   1, false, false, false, 108, 5,  1, 1,  0, 0}, // #552
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #553
  {DBGFIELD("WriteVarVecShiftY")  1, false, false, false, 108, 5,  1, 1,  0, 0}, // #554
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #558
  {DBGFIELD("WriteVarShuffleY")   1, false, false, false, 86, 6,  1, 1,  0, 0}, // #559
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #563
  {DBGFIELD("WriteVecShiftY")     2, false, false, false, 254, 10, 14, 1,  0, 0}, // #564
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, false, 591, 14,  2, 1,  6, 1}, // #567
  {DBGFIELD("WriteVecTestY")      2, false, false, false, 605, 12,  3, 1,  0, 0}, // #568
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, false, 243, 11,  8, 1,  6, 1}, // #569
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, false, 243, 11,  2, 1,  6, 1}, // #570
  {DBGFIELD("WriteFRcpY")         1, false, false, false,  3, 9, 14, 1,  0, 0}, // #571
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFRcpYLd")       2, false, false, false, 243, 11,  2, 1,  0, 0}, // #574
  {DBGFIELD("WriteFRndYLd")       3, false, false, false, 113, 7, 16, 1,  0, 0}, // #575
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, false, 243, 11,  8, 1,  6, 1}, // #576
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, false, 243, 11,  2, 1,  6, 1}, // #577
  {DBGFIELD("WriteFRsqrtY")       1, false, false, false,  3, 9, 14, 1,  0, 0}, // #578
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, false, 243, 11,  2, 1,  0, 0}, // #581
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #582
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #584
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, false, 243, 11, 15, 1,  6, 1}, // #585
  {DBGFIELD("WriteFSqrtY")        1, false, false, false,  3, 9,  2, 1,  0, 0}, // #586
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #587
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #588
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, false, 243, 11, 46, 1,  0, 0}, // #589
  {DBGFIELD("WriteFSqrt64Y")      1, false, false, false,  3, 9, 13, 1,  0, 0}, // #590
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, false, 243, 11, 41, 1,  6, 1}, // #591
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, false, 243, 11, 46, 1,  6, 1}, // #592
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #593
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #594
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, false, 243, 11, 15, 1,  0, 0}, // #595
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, false, 243, 11,  8, 1,  6, 1}, // #596
  {DBGFIELD("WriteFTestY")        1, false, false, false,  3, 9, 10, 1,  0, 0}, // #597
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 243, 11,  7, 1,  6, 1}, // #598
  {DBGFIELD("WriteFTest")         1, false, false, false,  3, 9,  5, 1,  0, 0}, // #599
  {DBGFIELD("WriteALULd_WriteRMW") 4, false, false, false, 58, 6, 47, 2,  0, 0}, // #600
  {DBGFIELD("COPY")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #601
  {DBGFIELD("XAM_F")              1, false, false, false,  3, 9, 12, 1,  0, 0}, // #602
  {DBGFIELD("LD_Frr")             1, false, false, false, 35, 3,  1, 1,  0, 0}, // #603
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 178, 3,  1, 1,  0, 0}, // #604
  {DBGFIELD("RCL16m1_RCL16m1_EVEX_RCL16mi_RCL16mi_EVEX_RCL32m1_RCL32m1_EVEX_RCL32mi_RCL32mi_EVEX_RCL64m1_RCL64m1_EVEX_RCL64mi_RCL64mi_EVEX_RCL8m1_RCL8m1_EVEX_RCL8mi_RCL8mi_EVEX_RCR16m1_RCR16m1_EVEX_RCR16mi_RCR16mi_EVEX_RCR32m1_RCR32m1_EVEX_RCR32mi_RCR32mi_EVEX_RCR64m1_RCR64m1_EVEX_RCR64mi_RCR64mi_EVEX_RCR8m1_RCR8m1_EVEX_RCR8mi_RCR8mi_EVEX_ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #605
  {DBGFIELD("RCL16m1_ND_RCL16mi_ND_RCL32m1_ND_RCL32mi_ND_RCL64m1_ND_RCL64mi_ND_RCL8m1_ND_RCL8mi_ND_RCR16m1_ND_RCR16mi_ND_RCR32m1_ND_RCR32mi_ND_RCR64m1_ND_RCR64mi_ND_RCR8m1_ND_RCR8mi_ND_ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 6, false, false, false, 725, 5, 35, 2,  0, 0}, // #606
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX_RCR16mCL_RCR16mCL_EVEX_RCR32mCL_RCR32mCL_EVEX_RCR64mCL_RCR64mCL_EVEX_RCR8mCL_RCR8mCL_EVEX_ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #607
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND_RCR16mCL_ND_RCR32mCL_ND_RCR64mCL_ND_RCR8mCL_ND_ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 9, false, false, false, 744, 10, 39, 2,  0, 0}, // #608
  {DBGFIELD("SAR16m1_SAR16m1_EVEX_SAR16m1_NF_SAR16mi_SAR16mi_EVEX_SAR16mi_NF_SAR32m1_SAR32m1_EVEX_SAR32m1_NF_SAR32mi_SAR32mi_EVEX_SAR32mi_NF_SAR64m1_SAR64m1_EVEX_SAR64m1_NF_SAR64mi_SAR64mi_EVEX_SAR64mi_NF_SAR8m1_SAR8m1_EVEX_SAR8m1_NF_SAR8mi_SAR8mi_EVEX_SAR8mi_NF_SHL16m1_SHL16m1_EVEX_SHL16m1_NF_SHL16mi_SHL16mi_EVEX_SHL16mi_NF_SHL32m1_SHL32m1_EVEX_SHL32m1_NF_SHL32mi_SHL32mi_EVEX_SHL32mi_NF_SHL64m1_SHL64m1_EVEX_SHL64m1_NF_SHL64mi_SHL64mi_EVEX_SHL64mi_NF_SHL8m1_SHL8m1_EVEX_SHL8m1_NF_SHL8mi_SHL8mi_EVEX_SHL8mi_NF_SHR16m1_SHR16m1_EVEX_SHR16m1_NF_SHR16mi_SHR16mi_EVEX_SHR16mi_NF_SHR32m1_SHR32m1_EVEX_SHR32m1_NF_SHR32mi_SHR32mi_EVEX_SHR32mi_NF_SHR64m1_SHR64m1_EVEX_SHR64m1_NF_SHR64mi_SHR64mi_EVEX_SHR64mi_NF_SHR8m1_SHR8m1_EVEX_SHR8m1_NF_SHR8mi_SHR8mi_EVEX_SHR8mi_NF") 4, false, false, false, 764, 9, 33, 2,  0, 0}, // #609
  {DBGFIELD("SAR16m1_ND_SAR16m1_NF_ND_SAR16mi_ND_SAR16mi_NF_ND_SAR32m1_ND_SAR32m1_NF_ND_SAR32mi_ND_SAR32mi_NF_ND_SAR64m1_ND_SAR64m1_NF_ND_SAR64mi_ND_SAR64mi_NF_ND_SAR8m1_ND_SAR8m1_NF_ND_SAR8mi_ND_SAR8mi_NF_ND_SHL16m1_ND_SHL16m1_NF_ND_SHL16mi_ND_SHL16mi_NF_ND_SHL32m1_ND_SHL32m1_NF_ND_SHL32mi_ND_SHL32mi_NF_ND_SHL64m1_ND_SHL64m1_NF_ND_SHL64mi_ND_SHL64mi_NF_ND_SHL8m1_ND_SHL8m1_NF_ND_SHL8mi_ND_SHL8mi_NF_ND_SHR16m1_ND_SHR16m1_NF_ND_SHR16mi_ND_SHR16mi_NF_ND_SHR32m1_ND_SHR32m1_NF_ND_SHR32mi_ND_SHR32mi_NF_ND_SHR64m1_ND_SHR64m1_NF_ND_SHR64mi_ND_SHR64mi_NF_ND_SHR8m1_ND_SHR8m1_NF_ND_SHR8mi_ND_SHR8mi_NF_ND") 2, false, false, false, 759, 5, 33, 2,  0, 0}, // #610
  {DBGFIELD("SAR16mCL_SAR16mCL_EVEX_SAR16mCL_NF_SAR32mCL_SAR32mCL_EVEX_SAR32mCL_NF_SAR64mCL_SAR64mCL_EVEX_SAR64mCL_NF_SAR8mCL_SAR8mCL_EVEX_SAR8mCL_NF_SHL16mCL_SHL16mCL_EVEX_SHL16mCL_NF_SHL32mCL_SHL32mCL_EVEX_SHL32mCL_NF_SHL64mCL_SHL64mCL_EVEX_SHL64mCL_NF_SHL8mCL_SHL8mCL_EVEX_SHL8mCL_NF_SHR16mCL_SHR16mCL_EVEX_SHR16mCL_NF_SHR32mCL_SHR32mCL_EVEX_SHR32mCL_NF_SHR64mCL_SHR64mCL_EVEX_SHR64mCL_NF_SHR8mCL_SHR8mCL_EVEX_SHR8mCL_NF") 5, false, false, false, 773, 9, 33, 2,  0, 0}, // #611
  {DBGFIELD("SAR16mCL_ND_SAR16mCL_NF_ND_SAR32mCL_ND_SAR32mCL_NF_ND_SAR64mCL_ND_SAR64mCL_NF_ND_SAR8mCL_ND_SAR8mCL_NF_ND_SHL16mCL_ND_SHL16mCL_NF_ND_SHL32mCL_ND_SHL32mCL_NF_ND_SHL64mCL_ND_SHL64mCL_NF_ND_SHL8mCL_ND_SHL8mCL_NF_ND_SHR16mCL_ND_SHR16mCL_NF_ND_SHR32mCL_ND_SHR32mCL_NF_ND_SHR64mCL_ND_SHR64mCL_NF_ND_SHR8mCL_ND_SHR8mCL_NF_ND") 4, false, false, false, 782, 5, 35, 2,  0, 0}, // #612
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #613
  {DBGFIELD("FCOMPP")             1, false, false, false, 35, 3,  4, 1,  0, 0}, // #614
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false,  3, 9, 12, 1,  0, 0}, // #615
  {DBGFIELD("MMX_CVTPI2PSrr")     2, false, false, false, 287, 9,  6, 1,  0, 0}, // #616
  {DBGFIELD("MMX_CVTPI2PSrm")     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #617
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 2, false, false, false, 873, 9, 22, 1,  0, 0}, // #618
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 55, 3, 10, 1,  0, 0}, // #619
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH16i_PUSH32i_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #620
  {DBGFIELD("XCH_F")              15, false, false, false, 882, 14, 20, 1,  0, 0}, // #621
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 2, false, false, false, 26, 9,  3, 1,  0, 0}, // #622
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 2, false, false, false, 243, 11, 24, 1,  0, 0}, // #623
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, false, 392, 13,  9, 1,  0, 0}, // #624
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 101, 7,  8, 1,  0, 0}, // #625
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 101, 7,  8, 1,  6, 1}, // #626
  {DBGFIELD("CVTSI642SSrr")       3, false, false, false, 896, 10,  7, 1,  0, 1}, // #627
  {DBGFIELD("CVTSI642SSrr_Int")   3, false, false, false, 896, 10,  7, 1,  7, 1}, // #628
  {DBGFIELD("CVTSI642SSrm")       3, false, false, false, 264, 12,  2, 1,  0, 0}, // #629
  {DBGFIELD("CVTSI642SSrm_Int")   3, false, false, false, 264, 12,  2, 1,  6, 1}, // #630
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 3, false, false, false, 906, 12,  7, 1,  0, 0}, // #631
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 3, false, false, false, 906, 12,  7, 1,  0, 0}, // #632
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 3, false, false, false, 276, 11,  2, 1,  0, 0}, // #633
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, false, 122, 3, 12, 1,  0, 0}, // #634
  {DBGFIELD("LFENCE")             1, false, false, false, 12, 5, 12, 1,  0, 0}, // #635
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #636
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, false, 116, 4,  3, 1,  0, 0}, // #637
  {DBGFIELD("POP16r")             2, false, false, false, 104, 4,  3, 1,  0, 0}, // #638
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 3, false, false, false, 46, 5,  1, 1,  0, 0}, // #639
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 4, false, false, false, 845, 4,  3, 1,  0, 0}, // #640
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 35, 3,  4, 1,  0, 0}, // #641
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 918, 5,  1, 1,  0, 0}, // #642
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 35, 3,  1, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false, 548, 6,  1, 1,  0, 0}, // #644
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #645
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #646
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, false, 51, 4,  2, 1,  0, 0}, // #647
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 109, 4,  1, 1,  0, 0}, // #648
  {DBGFIELD("CLD")                2, false, false, false, 73, 5,  5, 1,  0, 0}, // #649
  {DBGFIELD("LDDQUrm")            1, false, false, false, 55, 3,  6, 1,  0, 0}, // #650
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 7, false, false, false, 923, 6,  6, 1,  0, 0}, // #651
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 3, false, false, false, 46, 5,  2, 1,  0, 0}, // #652
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 9, false, false, false, 929, 9, 49, 2,  0, 0}, // #653
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 712, 6, 12, 1,  0, 0}, // #654
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 2, false, false, false, 173, 5,  3, 1,  0, 0}, // #655
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 2, false, false, false, 554, 8, 22, 1,  6, 1}, // #656
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 55, 3,  6, 1,  0, 0}, // #657
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 55, 3,  6, 1,  0, 0}, // #658
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, false, 102, 6,  7, 1,  6, 1}, // #659
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #660
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, false, 938, 5, 12, 1,  0, 0}, // #661
  {DBGFIELD("LD_F80m")            1, false, false, false, 943, 5,  6, 1,  0, 0}, // #662
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 704, 8, 22, 1,  6, 1}, // #663
  {DBGFIELD("MMX_PEXTRWrri_PEXTRWrri_PEXTRWrri_REV") 2, false, false, false, 381, 11, 14, 1,  0, 0}, // #664
  {DBGFIELD("FLDCW16m")           3, false, false, false, 948, 13,  6, 1,  0, 0}, // #665
  {DBGFIELD("ST_FP80m")           2, false, false, false, 918, 5,  1, 1,  0, 0}, // #666
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 573, 9,  5, 1,  0, 0}, // #667
  {DBGFIELD("CMPXCHG8rm")         6, false, false, false, 17, 9, 24, 1,  0, 0}, // #668
  {DBGFIELD("INTO")               1, false, false, false, 35, 3,  4, 1,  0, 0}, // #669
  {DBGFIELD("XLAT")               3, false, false, false, 116, 4,  6, 1,  0, 0}, // #670
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 3, false, false, false, 492, 10, 10, 1,  0, 0}, // #671
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 38, 8,  5, 1,  0, 0}, // #672
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, false, 795, 14,  2, 1,  0, 0}, // #673
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 5, false, false, false, 809, 12,  2, 1,  0, 0}, // #674
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, false, 961, 13, 14, 1,  0, 0}, // #675
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 562, 11,  8, 1,  6, 1}, // #676
  {DBGFIELD("AAD8i8")             1, false, false, false, 35, 3,  4, 1,  0, 0}, // #677
  {DBGFIELD("LOOPE")              11, false, false, false, 974, 10,  5, 1,  0, 0}, // #678
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 918, 5,  1, 1,  0, 0}, // #679
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 3, false, false, false, 492, 10, 10, 1,  0, 0}, // #680
  {DBGFIELD("FNSTCW16m")          3, false, false, false, 984, 10, 12, 1,  0, 0}, // #681
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 943, 5, 10, 1,  0, 0}, // #682
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 918, 5,  1, 1,  0, 0}, // #683
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, false, 795, 14,  2, 1,  0, 0}, // #684
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 5, false, false, false, 809, 12,  2, 1,  0, 0}, // #685
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 38, 8,  5, 1,  0, 0}, // #686
  {DBGFIELD("CMPXCHG8rr")         5, false, false, false, 238, 5,  5, 1,  0, 0}, // #687
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #688
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 35, 3,  4, 1,  0, 0}, // #689
  {DBGFIELD("AAA_AAS")            1, false, false, false, 35, 3,  4, 1,  0, 0}, // #690
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 17, 9,  2, 1,  0, 0}, // #691
  {DBGFIELD("LOOPNE")             11, false, false, false, 974, 10, 12, 1,  0, 0}, // #692
  {DBGFIELD("PAUSE")              2, false, false, false, 994, 10, 14, 1,  0, 0}, // #693
  {DBGFIELD("CMPXCHG8B")          16, false, false, false, 1004, 14, 46, 1,  0, 0}, // #694
  {DBGFIELD("DAA")                1, false, false, false, 35, 3,  4, 1,  0, 0}, // #695
  {DBGFIELD("LOOP")               7, false, false, false, 1018, 10,  5, 1,  0, 0}, // #696
  {DBGFIELD("DAS")                1, false, false, false, 35, 3,  4, 1,  0, 0}, // #697
  {DBGFIELD("AAM8i8")             1, false, false, false, 35, 3,  4, 1,  0, 0}, // #698
  {DBGFIELD("STD")                2, false, false, false, 73, 5,  3, 1,  0, 0}, // #699
  {DBGFIELD("CMPXCHG16B")         22, false, false, false, 1028, 16, 51, 1,  0, 0}, // #700
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 35, 3,  4, 1,  0, 0}, // #701
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, false, 1044, 3, 14, 1,  0, 0}, // #702
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 943, 5, 10, 1,  0, 0}, // #703
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 35, 3,  4, 1,  0, 0}, // #704
  {DBGFIELD("RDTSC_RDTSCP")       21, false, false, false, 1047, 13, 52, 1,  0, 0}, // #705
  {DBGFIELD("ENTER")              57, false, false, false, 1060, 17, 53, 1,  0, 0}, // #706
  {DBGFIELD("POPF16")             10, false, false, false, 1077, 12, 10, 1,  0, 0}, // #707
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 35, 3,  4, 1,  0, 0}, // #708
  {DBGFIELD("FRNDINT")            1, false, false, false, 35, 3,  4, 1,  0, 0}, // #709
  {DBGFIELD("MWAITrr_RDPMC")      10, false, false, false, 1089, 11, 15, 1,  0, 0}, // #710
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 35, 3,  4, 1,  0, 0}, // #711
  {DBGFIELD("FPREM")              1, false, false, false, 35, 3,  4, 1,  0, 0}, // #712
  {DBGFIELD("INSB_INSL_INSW")     86, false, false, false, 1100, 17, 15, 1,  0, 0}, // #713
  {DBGFIELD("FNINIT")             15, false, false, false, 1117, 9, 54, 1,  0, 0}, // #714
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 73, false, false, false, 1126, 17, 55, 1,  0, 0}, // #715
  {DBGFIELD("FPREM1")             1, false, false, false, 35, 3,  4, 1,  0, 0}, // #716
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 35, 3,  4, 1,  0, 0}, // #717
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 73, false, false, false, 1143, 17, 55, 1,  0, 0}, // #718
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  83, false, false, false, 1160, 17,  4, 1,  0, 0}, // #719
  {DBGFIELD("FSCALE")             1, false, false, false, 35, 3,  4, 1,  0, 0}, // #720
  {DBGFIELD("RDMSR")              54, false, false, false, 1177, 12,  4, 1,  0, 0}, // #721
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 2, false, false, false, 26, 9,  3, 1,  0, 0}, // #722
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 87, false, false, false, 1189, 15, 55, 1,  0, 0}, // #723
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 86, false, false, false, 1204, 15, 55, 1,  0, 0}, // #724
  {DBGFIELD("F2XM1")              1, false, false, false, 35, 3,  4, 1,  0, 0}, // #725
  {DBGFIELD("CPUID")              26, false, false, false, 1219, 16, 13, 1,  0, 0}, // #726
  {DBGFIELD("INT")                1, false, false, false, 35, 3,  4, 1,  0, 0}, // #727
  {DBGFIELD("INT3")               1, false, false, false, 35, 3,  4, 1,  0, 0}, // #728
  {DBGFIELD("FXSAVE_FXSAVE64")    110, false, false, false, 1235, 17,  4, 1,  0, 0}, // #729
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, false, 1252, 16, 56, 1,  0, 0}, // #730
  {DBGFIELD("FYL2X")              1, false, false, false, 35, 3,  4, 1,  0, 0}, // #731
  {DBGFIELD("FYL2XP1")            1, false, false, false, 35, 3,  4, 1,  0, 0}, // #732
  {DBGFIELD("FPTAN")              1, false, false, false, 35, 3,  4, 1,  0, 0}, // #733
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 35, 3,  4, 1,  0, 0}, // #734
  {DBGFIELD("FPATAN")             1, false, false, false, 35, 3,  4, 1,  0, 0}, // #735
  {DBGFIELD("WRMSR")              144, false, false, false, 1268, 16,  4, 1,  0, 0}, // #736
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #737
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false, 92, 9,  1, 1,  0, 0}, // #738
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, false, 414, 6, 12, 1,  0, 0}, // #739
  {DBGFIELD("FNOP")               1, false, false, false, 548, 6,  1, 1,  0, 0}, // #740
  {DBGFIELD("RET64")              2, false, false, false, 229, 7,  6, 1,  0, 0}, // #741
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 12, 5,  1, 1,  0, 0}, // #742
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #743
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 92, 9,  1, 1,  0, 0}, // #744
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 4, false, false, false, 845, 4,  3, 1,  0, 0}, // #745
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, false,  3, 9,  5, 1,  0, 0}, // #746
  {DBGFIELD("CWD")                2, false, false, false, 73, 5, 12, 1,  0, 0}, // #747
  {DBGFIELD("FNSTSW16r")          2, false, false, false, 1284, 9,  5, 1,  0, 0}, // #748
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, false, 1293, 6,  5, 1,  0, 0}, // #749
  {DBGFIELD("PUSHFS64")           3, false, false, false, 1299, 11,  1, 1,  0, 0}, // #750
  {DBGFIELD("EXTRACTPSrri_VEXTRACTPSrri") 2, false, false, false, 605, 12, 14, 1,  0, 0}, // #751
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 3, false, false, false, 754, 5, 12, 1,  0, 0}, // #752
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 3, false, false, false, 754, 5, 12, 1,  0, 0}, // #753
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 3, false, false, false, 754, 5, 12, 1,  0, 0}, // #754
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #755
  {DBGFIELD("MOV64sr")            1, false, false, false, 35, 3,  1, 1,  0, 0}, // #756
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCL8rCL_RCL8rCL_EVEX_RCL8rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND_RCR8rCL_RCR8rCL_EVEX_RCR8rCL_ND") 2, false, false, false, 759, 5, 12, 1,  0, 0}, // #757
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #758
  {DBGFIELD("CLI")                3, false, false, false, 1310, 10,  4, 1,  0, 0}, // #759
  {DBGFIELD("PUSHGS64")           3, false, false, false, 1299, 11,  1, 1,  0, 0}, // #760
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, false, 961, 13, 14, 1,  0, 0}, // #761
  {DBGFIELD("CALL64pcrel32")      2, false, false, false, 51, 4,  5, 1,  0, 0}, // #762
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #763
  {DBGFIELD("EXTRACTPSmri_VEXTRACTPSmri") 3, false, false, false, 1320, 12,  2, 1,  0, 0}, // #764
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 4, false, false, false, 1332, 5,  6, 1,  0, 0}, // #765
  {DBGFIELD("PEXTRDmri_PEXTRQmri_VPEXTRDmri_VPEXTRQmri") 3, false, false, false, 372, 9,  2, 1,  0, 0}, // #766
  {DBGFIELD("PUSHF16_PUSHF64")    4, false, false, false, 1337, 13, 14, 1,  0, 0}, // #767
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 3, false, false, false, 856, 5, 12, 1,  0, 0}, // #768
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 55, 3,  6, 1,  0, 0}, // #769
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #770
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #771
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #772
  {DBGFIELD("MOV16sm")            1, false, false, false, 35, 3,  1, 1,  0, 0}, // #773
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, false, 243, 11, 22, 1,  0, 0}, // #774
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, false, 526, 11, 22, 1,  6, 1}, // #775
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, false, 243, 11, 22, 1,  6, 1}, // #776
  {DBGFIELD("LODSL_LODSQ")        3, false, false, false, 116, 4, 10, 1,  0, 0}, // #777
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #778
  {DBGFIELD("VINSERTF128rmi")     2, false, false, false, 102, 6, 22, 1,  6, 1}, // #779
  {DBGFIELD("VERRm_VERWm")        34, false, false, false, 1350, 14, 57, 1,  0, 0}, // #780
  {DBGFIELD("FARJMP64m")          2, false, false, false, 1364, 10,  3, 1,  0, 0}, // #781
  {DBGFIELD("FNSTSWm")            3, false, false, false, 1374, 13,  5, 1,  0, 0}, // #782
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 2, false, false, false, 472, 8,  3, 1,  0, 0}, // #783
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #784
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, false, 64, 9,  6, 1,  0, 0}, // #785
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 243, 11,  7, 1,  6, 1}, // #786
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 7, false, false, false, 1387, 4,  3, 1,  0, 0}, // #787
  {DBGFIELD("ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #788
  {DBGFIELD("ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 6, false, false, false, 725, 5, 35, 2,  0, 0}, // #789
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, false, 1391, 6, 58, 2,  0, 0}, // #790
  {DBGFIELD("FARCALL64m")         5, false, false, false, 1397, 12,  6, 1,  0, 0}, // #791
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 943, 5,  6, 1,  0, 0}, // #792
  {DBGFIELD("ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #793
  {DBGFIELD("ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 9, false, false, false, 744, 10, 39, 2,  0, 0}, // #794
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, false, 1409, 9,  2, 1, 12, 2}, // #795
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, false, 392, 13,  9, 1,  0, 0}, // #796
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, false, 526, 11,  9, 1,  6, 1}, // #797
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, false, 1418, 13,  8, 1,  0, 0}, // #798
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, false, 1431, 13,  8, 1,  0, 0}, // #799
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, false, 1418, 13, 24, 1,  0, 0}, // #800
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, false, 1444, 16, 21, 1,  0, 0}, // #801
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, false, 1431, 13, 19, 1,  0, 0}, // #802
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, false, 1444, 16, 46, 1,  0, 0}, // #803
  {DBGFIELD("VZEROALL")           10, false, false, false, 1460, 10, 16, 1,  0, 0}, // #804
  {DBGFIELD("VZEROUPPER")         0, false, false, false,  0, 0,  0, 1,  0, 0}, // #805
  {DBGFIELD("CLC")                0, false, false, false,  0, 0,  1, 1,  0, 0}, // #806
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #807
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #808
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #809
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false, 109, 4,  1, 1,  0, 0}, // #810
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #811
  {DBGFIELD("PSUBQrr")            1, false, false, false, 109, 4,  1, 1,  0, 0}, // #812
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #813
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #814
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 2, false, false, false, 229, 7,  6, 1,  1, 1}, // #815
  {DBGFIELD("SETCCr")             2, false, false, false, 759, 5, 12, 1,  0, 0}, // #816
  {DBGFIELD("SETCCm")             4, false, false, false, 787, 8, 24, 1,  0, 0}, // #817
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #818
  {DBGFIELD("RETI16_RETI32_RETI64") 3, false, false, false, 1470, 7,  3, 1,  0, 0}, // #819
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 2, false, false, false, 26, 9,  3, 1,  0, 0}, // #820
  {DBGFIELD("RDPMC")              18, false, false, false, 1477, 12,  4, 1,  0, 0}, // #821
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 25, false, false, false, 1489, 15,  4, 1,  0, 0}, // #822
  {DBGFIELD("FBLDm")              1, false, false, false, 35, 3,  4, 1,  0, 0}, // #823
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false, 35, 3,  4, 1,  0, 0}, // #824
  {DBGFIELD("FSAVEm")             1, false, false, false, 35, 3,  4, 1,  0, 0}, // #825
  {DBGFIELD("FRSTORm")            1, false, false, false, 35, 3,  4, 1,  0, 0}, // #826
  {DBGFIELD("FXTRACT")            1, false, false, false, 35, 3,  4, 1,  0, 0}, // #827
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #828
  {DBGFIELD("VBROADCASTF128rm_VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #829
  {DBGFIELD("VBROADCASTI128rm")   1, false, false, false, 55, 3,  7, 1,  0, 0}, // #830
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #831
  {DBGFIELD("FBSTPm")             2, false, false, false, 918, 5,  1, 1,  0, 0}, // #832
  {DBGFIELD("VMPTRSTm")           2, false, false, false, 918, 5,  1, 1,  0, 0}, // #833
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, false, 918, 5,  1, 1,  0, 0}, // #834
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #835
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #836
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #837
  {DBGFIELD("FINCSTP")            1, false, false, false, 548, 6,  1, 1,  0, 0}, // #838
  {DBGFIELD("ANDN32rr_ANDN32rr_EVEX_ANDN32rr_NF_ANDN64rr_ANDN64rr_EVEX_ANDN64rr_NF") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #839
  {DBGFIELD("VPBLENDDYrri")       1, false, false, false, 109, 4,  1, 1,  0, 0}, // #840
  {DBGFIELD("VPBLENDDrri")        1, false, false, false, 109, 4,  1, 1,  0, 0}, // #841
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 7, false, false, false, 1504, 11, 23, 1,  0, 0}, // #842
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #843
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #844
  {DBGFIELD("PDEP32rm_PDEP32rm_EVEX_PDEP64rm_PDEP64rm_EVEX_PEXT32rm_PEXT32rm_EVEX_PEXT64rm_PEXT64rm_EVEX") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #845
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #846
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #847
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 2, false, false, false, 1364, 10,  3, 1,  0, 0}, // #848
  {DBGFIELD("ANDN32rm_ANDN32rm_EVEX_ANDN32rm_NF_ANDN64rm_ANDN64rm_EVEX_ANDN64rm_NF") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #849
  {DBGFIELD("MOVBE16rm_MOVBE16rm_EVEX_MOVBE32rm_MOVBE32rm_EVEX_MOVBE64rm_MOVBE64rm_EVEX") 1, false, false, false,  1, 2,  8, 1,  0, 0}, // #850
  {DBGFIELD("VINSERTI128rmi")     2, false, false, false, 102, 6, 22, 1,  6, 1}, // #851
  {DBGFIELD("VPBLENDDrmi")        2, false, false, false, 102, 6,  7, 1,  6, 1}, // #852
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, false, 102, 6, 22, 1,  6, 1}, // #853
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 55, 3, 10, 1,  0, 0}, // #854
  {DBGFIELD("MOVBE32mr_MOVBE32mr_EVEX_MOVBE64mr_MOVBE64mr_EVEX") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #855
  {DBGFIELD("MOVBE16mr")          3, false, false, false, 1515, 8,  2, 1,  0, 0}, // #856
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #857
  {DBGFIELD("XGETBV")             23, false, false, false, 1523, 10, 14, 1,  0, 0}, // #858
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 3, false, false, false, 1533, 11,  2, 1,  6, 1}, // #859
  {DBGFIELD("LRET64_RET32")       2, false, false, false, 229, 7,  3, 1,  0, 0}, // #860
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 2, false, false, false, 759, 5,  1, 1,  0, 0}, // #861
  {DBGFIELD("PDEP32rr_PDEP32rr_EVEX_PDEP64rr_PDEP64rr_EVEX_PEXT32rr_PEXT32rr_EVEX_PEXT64rr_PEXT64rr_EVEX") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #862
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #863
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #864
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 2, false, false, false, 1544, 9, 14, 1,  0, 0}, // #865
  {DBGFIELD("CLDEMOTE")           3, false, false, false, 856, 5,  5, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 2, false, false, false, 526, 11, 22, 1,  0, 0}, // #867
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 22, false, false, false, 1553, 15, 60, 1,  0, 0}, // #868
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 13, false, false, false, 1568, 15, 61, 1,  0, 0}, // #869
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #870
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, false, 526, 11,  8, 1,  6, 1}, // #871
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 896, 10,  7, 1,  7, 1}, // #872
  {DBGFIELD("STR16r_STR32r_STR64r") 2, false, false, false, 472, 8, 10, 1,  0, 0}, // #873
  {DBGFIELD("XSETBV")             54, false, false, false, 1583, 12, 10, 1,  0, 0}, // #874
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX") 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #875
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND") 9, false, false, false, 744, 10, 39, 2,  0, 0}, // #876
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND") 2, false, false, false, 759, 5, 12, 1,  0, 0}, // #877
  {DBGFIELD("RCL8rCL")            9, false, false, false, 744, 10,  6, 1,  0, 0}, // #878
  {DBGFIELD("RCR8rCL")            10, false, false, false, 1595, 10, 22, 1,  0, 0}, // #879
  {DBGFIELD("RDTSC")              15, false, false, false, 1605, 12, 13, 1,  0, 0}, // #880
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 31, false, false, false, 1617, 15, 62, 1,  0, 0}, // #881
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false,  3, 9, 15, 1,  0, 0}, // #882
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, false, 1431, 13, 63, 1,  0, 0}, // #883
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, false, 1444, 16, 64, 1,  0, 0}, // #884
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false,  3, 9, 11, 1,  0, 0}, // #885
  {DBGFIELD("XSAVE64")            140, false, false, false, 1632, 16, 65, 1,  0, 0}, // #886
  {DBGFIELD("XSAVE")              140, false, false, false, 1632, 16, 52, 1,  0, 0}, // #887
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 156, false, false, false, 1648, 16, 66, 1,  0, 0}, // #888
  {DBGFIELD("VMCLEARm")           18, false, false, false, 1664, 19, 67, 1,  0, 0}, // #889
  {DBGFIELD("FLDENVm")            64, false, false, false, 1683, 13, 68, 1,  0, 0}, // #890
  {DBGFIELD("FXRSTOR64")          88, false, false, false, 1696, 16, 56, 1,  0, 0}, // #891
  {DBGFIELD("FSTENVm")            100, false, false, false, 1712, 18, 69, 1,  0, 0}, // #892
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #893
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #894
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8, false, false, false, 1743, 13, 74, 2,  0, 0}, // #895
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 12, false, false, false, 1756, 13, 76, 2,  0, 0}, // #896
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #897
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #898
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #899
  {DBGFIELD("VPXORYrr")           1, false, false, false, 109, 4,  1, 1,  0, 0}, // #900
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #901
  {DBGFIELD("VPCMPGTQYrr")        1, false, false, false, 92, 9,  5, 1,  0, 0}, // #902
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #903
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #904
  {DBGFIELD("MOVBE16mr_EVEX")     2, false, false, false, 51, 4,  2, 1,  0, 0}, // #905
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, false, 392, 13,  7, 1,  0, 0}, // #906
  {DBGFIELD("LRET64")             3, false, false, false, 1769, 10,  6, 1,  0, 0}, // #907
  {DBGFIELD("POPF64")             7, false, false, false, 1779, 12, 10, 1,  0, 0}, // #908
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #909
  {DBGFIELD("PCMPEQQrr")          1, false, false, false, 108, 5,  1, 1,  0, 0}, // #910
  {DBGFIELD("PCMPGTQrr")          1, false, false, false, 92, 9,  5, 1,  0, 0}, // #911
  {DBGFIELD("PCMPEQQrm")          2, false, false, false, 101, 7,  7, 1,  6, 1}, // #912
  {DBGFIELD("PCMPGTQrm")          2, false, false, false, 526, 11,  9, 1,  6, 1}, // #913
  {DBGFIELD("MOV16rm")            2, false, false, false, 104, 4,  3, 1,  0, 0}, // #914
  {DBGFIELD("POP16rmm")           3, false, false, false, 46, 5,  2, 1,  0, 0}, // #915
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 3, false, false, false, 46, 5,  2, 1,  0, 0}, // #916
  {DBGFIELD("PUSHF16")            4, false, false, false, 1337, 13,  2, 1,  0, 0}, // #917
  {DBGFIELD("LAHF")               1, false, false, false, 12, 5,  5, 1,  0, 0}, // #918
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mi8_EVEX_ADD16mi8_NF_ADD16mi_EVEX_ADD16mi_NF_ADD32mi_ADD32mi8_ADD32mi8_EVEX_ADD32mi8_NF_ADD32mi_EVEX_ADD32mi_NF_ADD64mi32_ADD64mi32_EVEX_ADD64mi32_NF_ADD64mi8_ADD64mi8_EVEX_ADD64mi8_NF_ADD8mi_ADD8mi8_ADD8mi_EVEX_ADD8mi_NF_SUB16mi_SUB16mi8_SUB16mi8_EVEX_SUB16mi8_NF_SUB16mi_EVEX_SUB16mi_NF_SUB32mi_SUB32mi8_SUB32mi8_EVEX_SUB32mi8_NF_SUB32mi_EVEX_SUB32mi_NF_SUB64mi32_SUB64mi32_EVEX_SUB64mi32_NF_SUB64mi8_SUB64mi8_EVEX_SUB64mi8_NF_SUB8mi_SUB8mi8_SUB8mi_EVEX_SUB8mi_NF") 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #919
  {DBGFIELD("ADD16mi8_ND_ADD16mi8_NF_ND_ADD16mi_ND_ADD16mi_NF_ND_ADD16mr_ND_ADD16mr_NF_ND_ADD32mi8_ND_ADD32mi8_NF_ND_ADD32mi_ND_ADD32mi_NF_ND_ADD32mr_ND_ADD32mr_NF_ND_ADD64mi32_ND_ADD64mi32_NF_ND_ADD64mi8_ND_ADD64mi8_NF_ND_ADD64mr_ND_ADD64mr_NF_ND_ADD8mi_ND_ADD8mi_NF_ND_ADD8mr_ND_ADD8mr_NF_ND_SUB16mi8_ND_SUB16mi8_NF_ND_SUB16mi_ND_SUB16mi_NF_ND_SUB16mr_ND_SUB16mr_NF_ND_SUB32mi8_ND_SUB32mi8_NF_ND_SUB32mi_ND_SUB32mi_NF_ND_SUB32mr_ND_SUB32mr_NF_ND_SUB64mi32_ND_SUB64mi32_NF_ND_SUB64mi8_ND_SUB64mi8_NF_ND_SUB64mr_ND_SUB64mr_NF_ND_SUB8mi_ND_SUB8mi_NF_ND_SUB8mr_ND_SUB8mr_NF_ND") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #920
  {DBGFIELD("ADD16mr_ADD16mr_EVEX_ADD32mr_ADD32mr_EVEX_ADD64mr_ADD64mr_EVEX_ADD8mr_ADD8mr_EVEX_SUB16mr_SUB16mr_EVEX_SUB32mr_SUB32mr_EVEX_SUB64mr_SUB64mr_EVEX_SUB8mr_SUB8mr_EVEX") 4, false, false, false, 58, 6,  2, 1,  2, 1}, // #921
  {DBGFIELD("ADD16mr_NF_ADD32mr_NF_ADD64mr_NF_ADD8mr_NF_SUB16mr_NF_SUB32mr_NF_SUB64mr_NF_SUB8mr_NF") 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #922
  {DBGFIELD("ADC16mi_ADC16mi8_ADC16mi8_EVEX_ADC16mi_EVEX_ADC32mi_ADC32mi8_ADC32mi8_EVEX_ADC32mi_EVEX_ADC64mi32_ADC64mi32_EVEX_ADC64mi8_ADC64mi8_EVEX_ADC8mi_ADC8mi8_ADC8mi_EVEX_SBB16mi_SBB16mi8_SBB16mi8_EVEX_SBB16mi_EVEX_SBB32mi_SBB32mi8_SBB32mi8_EVEX_SBB32mi_EVEX_SBB64mi32_SBB64mi32_EVEX_SBB64mi8_SBB64mi8_EVEX_SBB8mi_SBB8mi8_SBB8mi_EVEX") 5, false, false, false, 64, 9,  2, 1,  0, 0}, // #923
  {DBGFIELD("ADC16mi8_ND_ADC16mi_ND_ADC16mr_ND_ADC32mi8_ND_ADC32mi_ND_ADC32mr_ND_ADC64mi32_ND_ADC64mi8_ND_ADC64mr_ND_ADC8mi_ND_ADC8mr_ND_SBB16mi8_ND_SBB16mi_ND_SBB16mr_ND_SBB32mi8_ND_SBB32mi_ND_SBB32mr_ND_SBB64mi32_ND_SBB64mi8_ND_SBB64mr_ND_SBB8mi_ND_SBB8mr_ND") 2, false, false, false, 73, 5,  8, 1,  1, 1}, // #924
  {DBGFIELD("ADC16mr_EVEX_ADC32mr_EVEX_ADC64mr_EVEX_ADC8mr_EVEX_SBB16mr_EVEX_SBB32mr_EVEX_SBB64mr_EVEX_SBB8mr_EVEX") 5, false, false, false, 64, 9,  2, 1,  2, 2}, // #925
  {DBGFIELD("DEC16m_DEC16m_EVEX_DEC16m_NF_DEC32m_DEC32m_EVEX_DEC32m_NF_DEC64m_DEC64m_EVEX_DEC64m_NF_DEC8m_DEC8m_EVEX_DEC8m_NF_INC16m_INC16m_EVEX_INC16m_NF_INC32m_INC32m_EVEX_INC32m_NF_INC64m_INC64m_EVEX_INC64m_NF_INC8m_INC8m_EVEX_INC8m_NF_NEG16m_NEG16m_EVEX_NEG16m_NF_NEG32m_NEG32m_EVEX_NEG32m_NF_NEG64m_NEG64m_EVEX_NEG64m_NF_NEG8m_NEG8m_EVEX_NEG8m_NF_NOT16m_NOT16m_EVEX_NOT32m_NOT32m_EVEX_NOT64m_NOT64m_EVEX_NOT8m_NOT8m_EVEX") 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #926
  {DBGFIELD("DEC16m_ND_DEC16m_NF_ND_DEC32m_ND_DEC32m_NF_ND_DEC64m_ND_DEC64m_NF_ND_DEC8m_ND_DEC8m_NF_ND_INC16m_ND_INC16m_NF_ND_INC32m_ND_INC32m_NF_ND_INC64m_ND_INC64m_NF_ND_INC8m_ND_INC8m_NF_ND_NEG16m_ND_NEG16m_NF_ND_NEG32m_ND_NEG32m_NF_ND_NEG64m_ND_NEG64m_NF_ND_NEG8m_ND_NEG8m_NF_ND_NOT16m_ND_NOT32m_ND_NOT64m_ND_NOT8m_ND") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #927
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 3, false, false, false, 1515, 8,  5, 1,  0, 0}, // #928
  {DBGFIELD("RET16_LRET16_LRET32") 2, false, false, false, 26, 9,  3, 1,  0, 0}, // #929
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, false, 26, 9,  3, 1,  0, 0}, // #930
  {DBGFIELD("AND16mi_AND16mi8_AND16mi8_EVEX_AND16mi8_NF_AND16mi_EVEX_AND16mi_NF_AND32mi_AND32mi8_AND32mi8_EVEX_AND32mi8_NF_AND32mi_EVEX_AND32mi_NF_AND64mi32_AND64mi32_EVEX_AND64mi32_NF_AND64mi8_AND64mi8_EVEX_AND64mi8_NF_AND8mi_AND8mi8_AND8mi_EVEX_AND8mi_NF_OR16mi_OR16mi8_OR16mi8_EVEX_OR16mi8_NF_OR16mi_EVEX_OR16mi_NF_OR32mi_OR32mi8_OR32mi8Locked_OR32mi8_EVEX_OR32mi8_NF_OR32mi_EVEX_OR32mi_NF_OR64mi32_OR64mi32_EVEX_OR64mi32_NF_OR64mi8_OR64mi8_EVEX_OR64mi8_NF_OR8mi_OR8mi8_OR8mi_EVEX_OR8mi_NF_XOR16mi_XOR16mi8_XOR16mi8_EVEX_XOR16mi8_NF_XOR16mi_EVEX_XOR16mi_NF_XOR32mi_XOR32mi8_XOR32mi8_EVEX_XOR32mi8_NF_XOR32mi_EVEX_XOR32mi_NF_XOR64mi32_XOR64mi32_EVEX_XOR64mi32_NF_XOR64mi8_XOR64mi8_EVEX_XOR64mi8_NF_XOR8mi_XOR8mi8_XOR8mi_EVEX_XOR8mi_NF") 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #931
  {DBGFIELD("AND16mi8_ND_AND16mi8_NF_ND_AND16mi_ND_AND16mi_NF_ND_AND16mr_ND_AND16mr_NF_ND_AND32mi8_ND_AND32mi8_NF_ND_AND32mi_ND_AND32mi_NF_ND_AND32mr_ND_AND32mr_NF_ND_AND64mi32_ND_AND64mi32_NF_ND_AND64mi8_ND_AND64mi8_NF_ND_AND64mr_ND_AND64mr_NF_ND_AND8mi_ND_AND8mi_NF_ND_AND8mr_ND_AND8mr_NF_ND_OR16mi8_ND_OR16mi8_NF_ND_OR16mi_ND_OR16mi_NF_ND_OR16mr_ND_OR16mr_NF_ND_OR32mi8_ND_OR32mi8_NF_ND_OR32mi_ND_OR32mi_NF_ND_OR32mr_ND_OR32mr_NF_ND_OR64mi32_ND_OR64mi32_NF_ND_OR64mi8_ND_OR64mi8_NF_ND_OR64mr_ND_OR64mr_NF_ND_OR8mi_ND_OR8mi_NF_ND_OR8mr_ND_OR8mr_NF_ND_XOR16mi8_ND_XOR16mi8_NF_ND_XOR16mi_ND_XOR16mi_NF_ND_XOR16mr_ND_XOR16mr_NF_ND_XOR32mi8_ND_XOR32mi8_NF_ND_XOR32mi_ND_XOR32mi_NF_ND_XOR32mr_ND_XOR32mr_NF_ND_XOR64mi32_ND_XOR64mi32_NF_ND_XOR64mi8_ND_XOR64mi8_NF_ND_XOR64mr_ND_XOR64mr_NF_ND_XOR8mi_ND_XOR8mi_NF_ND_XOR8mr_ND_XOR8mr_NF_ND") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #932
  {DBGFIELD("AND16mr_AND16mr_EVEX_AND32mr_AND32mr_EVEX_AND64mr_AND64mr_EVEX_AND8mr_AND8mr_EVEX_OR16mr_OR16mr_EVEX_OR32mr_OR32mr_EVEX_OR64mr_OR64mr_EVEX_OR8mr_OR8mr_EVEX_XOR16mr_XOR16mr_EVEX_XOR32mr_XOR32mr_EVEX_XOR64mr_XOR64mr_EVEX_XOR8mr_XOR8mr_EVEX") 4, false, false, false, 58, 6,  2, 1,  2, 1}, // #933
  {DBGFIELD("AND16mr_NF_AND32mr_NF_AND64mr_NF_AND8mr_NF_OR16mr_NF_OR32mr_NF_OR64mr_NF_OR8mr_NF_XOR16mr_NF_XOR32mr_NF_XOR64mr_NF_XOR8mr_NF") 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #934
  {DBGFIELD("SHLD16mri8_EVEX_SHLD16mri8_ND_SHLD16mri8_NF_SHLD16mri8_NF_ND_SHLD32mri8_SHLD32mri8_EVEX_SHLD32mri8_ND_SHLD32mri8_NF_SHLD32mri8_NF_ND_SHLD64mri8_EVEX_SHLD64mri8_ND_SHLD64mri8_NF_SHLD64mri8_NF_ND_SHRD16mri8_EVEX_SHRD16mri8_ND_SHRD16mri8_NF_SHRD16mri8_NF_ND_SHRD32mri8_SHRD32mri8_EVEX_SHRD32mri8_ND_SHRD32mri8_NF_SHRD32mri8_NF_ND_SHRD64mri8_EVEX_SHRD64mri8_ND_SHRD64mri8_NF_SHRD64mri8_NF_ND") 5, false, false, false, 809, 12,  2, 1,  0, 0}, // #935
  {DBGFIELD("SHLD16rrCL_EVEX_SHLD16rrCL_ND_SHLD16rrCL_NF_SHLD16rrCL_NF_ND_SHLD32rrCL_SHLD32rrCL_EVEX_SHLD32rrCL_ND_SHLD32rrCL_NF_SHLD32rrCL_NF_ND_SHLD64rrCL_EVEX_SHLD64rrCL_ND_SHLD64rrCL_NF_SHLD64rrCL_NF_ND_SHRD16rrCL_EVEX_SHRD16rrCL_ND_SHRD16rrCL_NF_SHRD16rrCL_NF_ND_SHRD32rrCL_SHRD32rrCL_EVEX_SHRD32rrCL_ND_SHRD32rrCL_NF_SHRD32rrCL_NF_ND_SHRD64rrCL_EVEX_SHRD64rrCL_ND_SHRD64rrCL_NF_SHRD64rrCL_NF_ND") 3, false, false, false, 492, 10, 10, 1,  0, 0}, // #936
  {DBGFIELD("SHLD16mrCL_EVEX_SHLD16mrCL_ND_SHLD16mrCL_NF_SHLD16mrCL_NF_ND_SHLD32mrCL_SHLD32mrCL_EVEX_SHLD32mrCL_ND_SHLD32mrCL_NF_SHLD32mrCL_NF_ND_SHLD64mrCL_EVEX_SHLD64mrCL_ND_SHLD64mrCL_NF_SHLD64mrCL_NF_ND_SHRD16mrCL_EVEX_SHRD16mrCL_ND_SHRD16mrCL_NF_SHRD16mrCL_NF_ND_SHRD32mrCL_SHRD32mrCL_EVEX_SHRD32mrCL_ND_SHRD32mrCL_NF_SHRD32mrCL_NF_ND_SHRD64mrCL_EVEX_SHRD64mrCL_ND_SHRD64mrCL_NF_SHRD64mrCL_NF_ND") 6, false, false, false, 795, 14,  2, 1,  0, 0}, // #937
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, false, 236, 2, 12, 1,  0, 0}, // #938
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #939
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 4, false, false, false, 1791, 12,  2, 1,  0, 0}, // #940
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 918, 5,  1, 1,  0, 0}, // #941
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, false, 918, 5,  1, 1,  0, 0}, // #942
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, false, 102, 6, 22, 1,  0, 0}, // #943
  {DBGFIELD("VPMASKMOVDrm")       2, false, false, false, 102, 6,  7, 1,  0, 0}, // #944
  {DBGFIELD("VPMASKMOVDYmr")      3, false, false, false, 861, 12, 21, 1,  0, 0}, // #945
  {DBGFIELD("VPMASKMOVDmr")       3, false, false, false, 861, 12, 21, 1,  0, 0}, // #946
  {DBGFIELD("VPMASKMOVQYmr")      3, false, false, false, 861, 12, 21, 1,  0, 0}, // #947
  {DBGFIELD("VPMASKMOVQmr")       3, false, false, false, 861, 12, 21, 1,  0, 0}, // #948
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 2, false, false, false, 526, 11,  7, 1,  0, 0}, // #949
  {DBGFIELD("VPGATHERDDYrm")      12, false, false, false, 1756, 13, 76, 2,  0, 0}, // #950
  {DBGFIELD("VPGATHERDDrm")       8, false, false, false, 1743, 13, 74, 2,  0, 0}, // #951
  {DBGFIELD("VPGATHERDQYrm")      8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #952
  {DBGFIELD("VPGATHERDQrm")       5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #953
  {DBGFIELD("VPGATHERQDYrm")      8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #954
  {DBGFIELD("VPGATHERQDrm")       5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #955
  {DBGFIELD("VPGATHERQQYrm")      8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #956
  {DBGFIELD("VPGATHERQQrm")       5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #957
  {DBGFIELD("VPERM2F128rri")      1, false, false, false, 92, 9,  5, 1,  0, 0}, // #958
  {DBGFIELD("VPERM2I128rri")      1, false, false, false, 92, 9,  5, 1,  0, 0}, // #959
  {DBGFIELD("VPERM2F128rmi")      2, false, false, false, 526, 11,  8, 1,  6, 1}, // #960
  {DBGFIELD("VPERM2I128rmi")      2, false, false, false, 526, 11,  8, 1,  6, 1}, // #961
  {DBGFIELD("VBROADCASTF128rm")   1, false, false, false, 55, 3,  7, 1,  0, 0}, // #962
  {DBGFIELD("VEXTRACTF128rri")    1, false, false, false, 92, 9,  5, 1,  0, 0}, // #963
  {DBGFIELD("VEXTRACTI128rri")    1, false, false, false, 92, 9,  5, 1,  0, 0}, // #964
  {DBGFIELD("VEXTRACTF128mri")    2, false, false, false, 51, 4,  2, 1,  0, 0}, // #965
  {DBGFIELD("VEXTRACTI128mri")    2, false, false, false, 51, 4,  2, 1,  0, 0}, // #966
  {DBGFIELD("VINSERTF128rri")     1, false, false, false, 92, 9,  5, 1,  0, 0}, // #967
  {DBGFIELD("VINSERTI128rri")     1, false, false, false, 92, 9,  5, 1,  0, 0}, // #968
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #969
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, false, 254, 10,  6, 1,  0, 0}, // #970
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #971
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_VCVTPD2DQrm_VCVTTPD2DQrm") 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #972
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #973
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #974
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 254, 10,  3, 1,  0, 0}, // #975
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 254, 10,  7, 1,  0, 0}, // #976
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, false, 287, 9,  6, 1,  0, 0}, // #977
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 287, 9,  6, 1,  0, 0}, // #978
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int_VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 276, 11,  2, 1,  0, 0}, // #979
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 254, 10,  6, 1,  0, 1}, // #980
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 254, 10,  6, 1,  7, 1}, // #981
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 287, 9,  6, 1,  0, 0}, // #982
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 287, 9,  6, 1,  0, 0}, // #983
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int") 2, false, false, false, 287, 9,  6, 1,  0, 0}, // #984
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, false, 276, 11,  2, 1,  0, 0}, // #985
  {DBGFIELD("VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int") 3, false, false, false, 276, 11,  2, 1,  0, 0}, // #986
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false, 108, 5,  1, 1,  0, 0}, // #987
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false, 108, 5,  1, 1,  0, 0}, // #988
  {DBGFIELD("SHA256MSG2rm")       3, false, false, false, 1533, 11, 24, 1,  6, 1}, // #989
  {DBGFIELD("SHA256MSG2rr")       2, false, false, false, 1544, 9,  3, 1,  0, 0}, // #990
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 7, false, false, false, 1803, 11, 10, 1,  0, 0}, // #991
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 8, false, false, false, 1814, 13,  2, 1,  6, 1}, // #992
  {DBGFIELD("SHA1MSG2rr")         7, false, false, false, 1827, 9,  3, 1,  0, 0}, // #993
  {DBGFIELD("SHA1MSG2rm")         8, false, false, false, 1836, 11, 24, 1,  6, 1}, // #994
  {DBGFIELD("SHA1NEXTErr")        3, false, false, false, 1847, 7,  5, 1,  0, 0}, // #995
  {DBGFIELD("SHA1NEXTErm")        4, false, false, false, 1854, 9,  7, 1,  6, 1}, // #996
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 92, 9,  3, 1,  0, 0}, // #997
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, false, 526, 11, 24, 1,  6, 1}, // #998
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 92, 9,  3, 1,  0, 0}, // #999
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, false, 526, 11, 24, 1,  6, 1}, // #1000
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, false, 236, 2, 12, 1,  0, 0}, // #1001
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1002
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1003
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1004
  {DBGFIELD("MOV8rm_MOV8rm_NOREX_MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 55, 3, 10, 1,  0, 0}, // #1005
  {DBGFIELD("MOVBE16rm")          3, false, false, false, 1863, 7,  6, 1,  0, 0}, // #1006
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 4, false, false, false, 1337, 13,  2, 1,  0, 0}, // #1007
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1008
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1009
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1010
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 38, 8,  5, 1,  0, 0}, // #1011
  {DBGFIELD("ADC8mr_SBB8mr")      6, false, false, false, 1409, 9, 24, 1, 12, 2}, // #1012
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false, 38, 8,  1, 1,  0, 0}, // #1013
  {DBGFIELD("LEA16r")             2, false, false, false, 472, 8, 12, 1,  0, 0}, // #1014
  {DBGFIELD("LCMPXCHG8")          6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1015
  {DBGFIELD("LCMPXCHG16B")        6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1016
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 3, false, false, false, 236, 2, 12, 1,  0, 0}, // #1017
  {DBGFIELD("XCHG8rm_XCHG16rm")   8, false, false, false, 1870, 9, 78, 2,  0, 0}, // #1018
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 38, 8,  5, 1,  0, 0}, // #1019
  {DBGFIELD("LZCNT16rr")          1, false, false, false, 38, 8,  5, 1,  0, 0}, // #1020
  {DBGFIELD("TZCNT16rr")          1, false, false, false, 38, 8,  5, 1,  0, 0}, // #1021
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #1022
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #1023
  {DBGFIELD("RCL8mi_RCL16mi_RCL32mi_RCL64mi") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #1024
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 1879, 10,  7, 1,  0, 0}, // #1025
  {DBGFIELD("RCR8mCL_RCR16mCL_RCR32mCL_RCR64mCL") 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #1026
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL") 7, false, false, false, 1879, 10,  7, 1,  0, 0}, // #1027
  {DBGFIELD("RCL8mCL_RCL16mCL_RCL32mCL_RCL64mCL") 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #1028
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1029
  {DBGFIELD("MMX_MOVQ2FR64rr_MMX_MOVQ2DQrr") 2, false, false, false, 873, 9,  5, 1,  0, 0}, // #1030
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1031
  {DBGFIELD("EXTRQ")              1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1032
  {DBGFIELD("INSERTQ")            1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1033
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1034
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1035
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1036
  {DBGFIELD("MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 3, false, false, false, 264, 12, 41, 1,  0, 0}, // #1037
  {DBGFIELD("MMX_CVTPI2PDrm")     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1038
  {DBGFIELD("SHA1MSG1rr")         2, false, false, false, 255, 9, 12, 1,  0, 0}, // #1039
  {DBGFIELD("SHA1MSG1rm")         3, false, false, false, 265, 11, 22, 1,  6, 1}, // #1040
  {DBGFIELD("VPERMPSYrm")         2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1041
  {DBGFIELD("VPERMPDYri")         1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1042
  {DBGFIELD("VPERMQYri")          1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1043
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1044
  {DBGFIELD("VPERMQYmi")          2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1045
  {DBGFIELD("VPERMDYrm")          2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1046
  {DBGFIELD("SFENCE")             2, false, false, false, 51, 4, 12, 1,  0, 0}, // #1047
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  1, 2,  0, 1,  0, 0}, // #1048
  {DBGFIELD("MOVSX32rr32")        1, false, false, false, 178, 3,  1, 1,  0, 0}, // #1049
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1050
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1051
  {DBGFIELD("VXORPSrr_VXORPDrr")  1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1052
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1053
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1054
  {DBGFIELD("VPXORrr")            1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1055
  {DBGFIELD("VPANDNrr")           1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1056
  {DBGFIELD("VPANDNYrr")          1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1057
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1058
  {DBGFIELD("KADDBkk_KADDDkk_KADDQkk_KADDWkk_KANDBkk_KANDDkk_KANDQkk_KANDWkk_KANDNBkk_KANDNDkk_KANDNQkk_KANDNWkk_KNOTBkk_KNOTDkk_KNOTQkk_KNOTWkk_KORBkk_KORDkk_KORQkk_KORWkk_KORTESTBkk_KORTESTDkk_KORTESTQkk_KORTESTWkk_KTESTBkk_KTESTDkk_KTESTQkk_KTESTWkk_KXNORBkk_KXNORDkk_KXNORQkk_KXNORWkk_KXORBkk_KXORDkk_KXORQkk_KXORWkk") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1059
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1060
  {DBGFIELD("KUNPCKBWkk_KUNPCKDQkk_KUNPCKWDkk") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1061
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1062
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1063
  {DBGFIELD("VALIGNDZrri_VALIGNQZrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1064
  {DBGFIELD("VALIGNDZ128rri_VALIGNQZ128rri") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1065
  {DBGFIELD("VALIGNDZ256rri_VALIGNQZ256rri") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1066
  {DBGFIELD("VPERMPSYrr")         1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1067
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1068
  {DBGFIELD("VFIXUPIMMPDZ128rrik_VFIXUPIMMPDZ128rrikz_VFIXUPIMMPSZ128rrik_VFIXUPIMMPSZ128rrikz_VFIXUPIMMPDZ128rri_VFIXUPIMMPSZ128rri_VRANGEPDZ128rri_VRANGEPDZ128rrik_VRANGEPDZ128rrikz_VRANGEPSZ128rri_VRANGEPSZ128rrik_VRANGEPSZ128rrikz_VRANGESDZrri_VRANGESDZrrib_VRANGESDZrribk_VRANGESDZrribkz_VRANGESDZrrik_VRANGESDZrrikz_VRANGESSZrri_VRANGESSZrrib_VRANGESSZrribk_VRANGESSZrribkz_VRANGESSZrrik_VRANGESSZrrikz") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1069
  {DBGFIELD("VFIXUPIMMPDZ256rrik_VFIXUPIMMPDZ256rrikz_VFIXUPIMMPSZ256rrik_VFIXUPIMMPSZ256rrikz_VFIXUPIMMPDZ256rri_VFIXUPIMMPDZ256rrib_VFIXUPIMMPDZ256rribk_VFIXUPIMMPDZ256rribkz_VFIXUPIMMPSZ256rri_VFIXUPIMMPSZ256rrib_VFIXUPIMMPSZ256rribk_VFIXUPIMMPSZ256rribkz_VRANGEPDZ256rri_VRANGEPDZ256rrib_VRANGEPDZ256rribk_VRANGEPDZ256rribkz_VRANGEPDZ256rrik_VRANGEPDZ256rrikz_VRANGEPSZ256rri_VRANGEPSZ256rrib_VRANGEPSZ256rribk_VRANGEPSZ256rribkz_VRANGEPSZ256rrik_VRANGEPSZ256rrikz") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1070
  {DBGFIELD("VFIXUPIMMPDZrrik_VFIXUPIMMPDZrrikz_VFIXUPIMMPSZrrik_VFIXUPIMMPSZrrikz_VRANGEPDZrri_VRANGEPDZrrib_VRANGEPDZrribk_VRANGEPDZrribkz_VRANGEPDZrrik_VRANGEPDZrrikz_VRANGEPSZrri_VRANGEPSZrrib_VRANGEPSZrribk_VRANGEPSZrribkz_VRANGEPSZrrik_VRANGEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VFIXUPIMMSDZrrik_VFIXUPIMMSDZrrikz_VFIXUPIMMSSZrrik_VFIXUPIMMSSZrrikz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1072
  {DBGFIELD("VSCALEFSDZrrb_Int_VSCALEFSSZrrb_Int") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1073
  {DBGFIELD("VREDUCEPDZ128rri_VREDUCEPDZ128rrik_VREDUCEPDZ128rrikz_VREDUCEPSZ128rri_VREDUCEPSZ128rrik_VREDUCEPSZ128rrikz_VREDUCESDZrri_VREDUCESDZrrib_VREDUCESDZrribk_VREDUCESDZrribkz_VREDUCESDZrrik_VREDUCESDZrrikz_VREDUCESSZrri_VREDUCESSZrrib_VREDUCESSZrribk_VREDUCESSZrribkz_VREDUCESSZrrik_VREDUCESSZrrikz") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1074
  {DBGFIELD("VREDUCEPDZrri_VREDUCEPDZrrib_VREDUCEPDZrribk_VREDUCEPDZrribkz_VREDUCEPDZrrik_VREDUCEPDZrrikz_VREDUCEPSZrri_VREDUCEPSZrrib_VREDUCEPSZrribk_VREDUCEPSZrribkz_VREDUCEPSZrrik_VREDUCEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1075
  {DBGFIELD("VDPBF16PSZ128r_VDPBF16PSZ128rk_VDPBF16PSZ128rkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1076
  {DBGFIELD("VDPBF16PSZ256r_VDPBF16PSZ256rk_VDPBF16PSZ256rkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1077
  {DBGFIELD("VDPBF16PSZr_VDPBF16PSZrk_VDPBF16PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD("VPDPBUSDSZ128r_VPDPBUSDSZ128rk_VPDPBUSDSZ128rkz_VPDPBUSDZ128r_VPDPBUSDZ128rk_VPDPBUSDZ128rkz_VPDPWSSDSZ128r_VPDPWSSDSZ128rk_VPDPWSSDSZ128rkz_VPDPWSSDZ128r_VPDPWSSDZ128rk_VPDPWSSDZ128rkz_VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1079
  {DBGFIELD("VPDPBUSDSZ256r_VPDPBUSDSZ256rk_VPDPBUSDSZ256rkz_VPDPBUSDZ256r_VPDPBUSDZ256rk_VPDPBUSDZ256rkz_VPDPWSSDSZ256r_VPDPWSSDSZ256rk_VPDPWSSDSZ256rkz_VPDPWSSDZ256r_VPDPWSSDZ256rk_VPDPWSSDZ256rkz_VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1080
  {DBGFIELD("VPDPBUSDSZr_VPDPBUSDSZrk_VPDPBUSDSZrkz_VPDPBUSDZr_VPDPBUSDZrk_VPDPBUSDZrkz_VPDPWSSDSZr_VPDPWSSDSZrk_VPDPWSSDSZrkz_VPDPWSSDZr_VPDPWSSDZrk_VPDPWSSDZrkz_VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz_VPSHLDDZ128rri_VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rri_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHLDWZ128rri_VPSHLDWZ128rrik_VPSHLDWZ128rrikz_VPSHRDDZ128rri_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rri_VPSHRDQZ128rrik_VPSHRDQZ128rrikz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz_VPSHRDWZ128rri_VPSHRDWZ128rrik_VPSHRDWZ128rrikz_VPSHUFBITQMBZ128rr_VPSHUFBITQMBZ128rrk") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1082
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz_VPSHLDDZ256rri_VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rri_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHLDWZ256rri_VPSHLDWZ256rrik_VPSHLDWZ256rrikz_VPSHRDDZ256rri_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rri_VPSHRDQZ256rrik_VPSHRDQZ256rrikz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz_VPSHRDWZ256rri_VPSHRDWZ256rrik_VPSHRDWZ256rrikz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1083
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz_VPSHLDDZrri_VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrri_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHLDVWZrk_VPSHLDVWZrkz_VPSHLDWZrri_VPSHLDWZrrik_VPSHLDWZrrikz_VPSHRDDZrri_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrri_VPSHRDQZrrik_VPSHRDQZrrikz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz_VPSHRDVWZrk_VPSHRDVWZrkz_VPSHRDWZrri_VPSHRDWZrrik_VPSHRDWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1084
  {DBGFIELD("PSLLDrr_PSLLQrr_PSLLWrr_PSRADrr_PSRAWrr_PSRLDrr_PSRLQrr_PSRLWrr_VPSLLDZ128rr_VPSLLDZ128rrk_VPSLLDZ128rrkz_VPSLLDrr_VPSLLQZ128rr_VPSLLQZ128rrk_VPSLLQZ128rrkz_VPSLLQrr_VPSLLWZ128rr_VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSLLWrr_VPSRADZ128rr_VPSRADZ128rrk_VPSRADZ128rrkz_VPSRADrr_VPSRAQZ128rr_VPSRAQZ128rrk_VPSRAQZ128rrkz_VPSRAWZ128rr_VPSRAWZ128rrk_VPSRAWZ128rrkz_VPSRAWrr_VPSRLDZ128rr_VPSRLDZ128rrk_VPSRLDZ128rrkz_VPSRLDrr_VPSRLQZ128rr_VPSRLQZ128rrk_VPSRLQZ128rrkz_VPSRLQrr_VPSRLWZ128rr_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRLWrr") 2, false, false, false, 718, 7, 12, 1,  0, 0}, // #1085
  {DBGFIELD("VPSLLDYrr_VPSLLDZ256rr_VPSLLDZ256rrk_VPSLLDZ256rrkz_VPSLLQYrr_VPSLLQZ256rr_VPSLLQZ256rrk_VPSLLQZ256rrkz_VPSLLWYrr_VPSLLWZ256rr_VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRADYrr_VPSRADZ256rr_VPSRADZ256rrk_VPSRADZ256rrkz_VPSRAQZ256rr_VPSRAQZ256rrk_VPSRAQZ256rrkz_VPSRAWYrr_VPSRAWZ256rr_VPSRAWZ256rrk_VPSRAWZ256rrkz_VPSRLDYrr_VPSRLDZ256rr_VPSRLDZ256rrk_VPSRLDZ256rrkz_VPSRLQYrr_VPSRLQZ256rr_VPSRLQZ256rrk_VPSRLQZ256rrkz_VPSRLWYrr_VPSRLWZ256rr_VPSRLWZ256rrk_VPSRLWZ256rrkz") 2, false, false, false, 254, 10, 14, 1,  0, 0}, // #1086
  {DBGFIELD("VPSLLDZrr_VPSLLDZrrk_VPSLLDZrrkz_VPSLLQZrr_VPSLLQZrrk_VPSLLQZrrkz_VPSLLWZrr_VPSLLWZrrk_VPSLLWZrrkz_VPSRADZrr_VPSRADZrrk_VPSRADZrrkz_VPSRAQZrr_VPSRAQZrrk_VPSRAQZrrkz_VPSRAWZrr_VPSRAWZrrk_VPSRAWZrrkz_VPSRLDZrr_VPSRLDZrrk_VPSRLDZrrkz_VPSRLQZrr_VPSRLQZrrk_VPSRLQZrrkz_VPSRLWZrr_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1087
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri_VPSLLDQZ256ri_VPSRLDQZ256ri") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1088
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1089
  {DBGFIELD("VPSLLDQZri_VPSRLDQZri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("VPSHUFBYrr_VPSHUFBZ256rr_VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1091
  {DBGFIELD("VPSHUFBZ128rr_VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1092
  {DBGFIELD("VPSHUFBZrr_VPSHUFBZrrk_VPSHUFBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1093
  {DBGFIELD("VPROLVDZ128rr_VPROLVDZ128rrk_VPROLVDZ128rrkz_VPROLVQZ128rr_VPROLVQZ128rrk_VPROLVQZ128rrkz_VPRORVDZ128rr_VPRORVDZ128rrk_VPRORVDZ128rrkz_VPRORVQZ128rr_VPRORVQZ128rrk_VPRORVQZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1094
  {DBGFIELD("VPROLVDZ256rr_VPROLVDZ256rrk_VPROLVDZ256rrkz_VPROLVQZ256rr_VPROLVQZ256rrk_VPROLVQZ256rrkz_VPRORVDZ256rr_VPRORVDZ256rrk_VPRORVDZ256rrkz_VPRORVQZ256rr_VPRORVQZ256rrk_VPRORVQZ256rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1095
  {DBGFIELD("VPROLVDZrr_VPROLVDZrrk_VPROLVDZrrkz_VPROLVQZrr_VPROLVQZrrk_VPROLVQZrrkz_VPRORVDZrr_VPRORVDZrrk_VPRORVDZrrkz_VPRORVQZrr_VPRORVQZrrk_VPRORVQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1096
  {DBGFIELD("VPROLDZ256ri_VPROLDZ256rik_VPROLDZ256rikz_VPROLQZ256ri_VPROLQZ256rik_VPROLQZ256rikz_VPRORDZ256ri_VPRORDZ256rik_VPRORDZ256rikz_VPRORQZ256ri_VPRORQZ256rik_VPRORQZ256rikz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1097
  {DBGFIELD("VPROLDZ128ri_VPROLDZ128rik_VPROLDZ128rikz_VPROLQZ128ri_VPROLQZ128rik_VPROLQZ128rikz_VPRORDZ128ri_VPRORDZ128rik_VPRORDZ128rikz_VPRORQZ128ri_VPRORQZ128rik_VPRORQZ128rikz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1098
  {DBGFIELD("VPROLDZri_VPROLDZrik_VPROLDZrikz_VPROLQZri_VPROLQZrik_VPROLQZrikz_VPRORDZri_VPRORDZrik_VPRORDZrikz_VPRORQZri_VPRORQZrik_VPRORQZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1099
  {DBGFIELD("VFMSUB231SSZrkz_Int") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1100
  {DBGFIELD("VPSLLDZ128ri_VPSLLDZ128rik_VPSLLDZ128rikz_VPSLLQZ128ri_VPSLLQZ128rik_VPSLLQZ128rikz_VPSLLWZ128ri_VPSLLWZ128rik_VPSLLWZ128rikz_VPSRADZ128ri_VPSRADZ128rik_VPSRADZ128rikz_VPSRAQZ128ri_VPSRAQZ128rik_VPSRAQZ128rikz_VPSRAWZ128ri_VPSRAWZ128rik_VPSRAWZ128rikz_VPSRLDZ128ri_VPSRLDZ128rik_VPSRLDZ128rikz_VPSRLQZ128ri_VPSRLQZ128rik_VPSRLQZ128rikz_VPSRLWZ128ri_VPSRLWZ128rik_VPSRLWZ128rikz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1101
  {DBGFIELD("VPSLLDZ256ri_VPSLLDZ256rik_VPSLLDZ256rikz_VPSLLQZ256ri_VPSLLQZ256rik_VPSLLQZ256rikz_VPSLLWZ256ri_VPSLLWZ256rik_VPSLLWZ256rikz_VPSRADZ256ri_VPSRADZ256rik_VPSRADZ256rikz_VPSRAQZ256ri_VPSRAQZ256rik_VPSRAQZ256rikz_VPSRAWZ256ri_VPSRAWZ256rik_VPSRAWZ256rikz_VPSRLDZ256ri_VPSRLDZ256rik_VPSRLDZ256rikz_VPSRLQZ256ri_VPSRLQZ256rik_VPSRLQZ256rikz_VPSRLWZ256ri_VPSRLWZ256rik_VPSRLWZ256rikz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1102
  {DBGFIELD("VPSLLDZri_VPSLLDZrik_VPSLLDZrikz_VPSLLQZri_VPSLLQZrik_VPSLLQZrikz_VPSLLWZri_VPSLLWZrik_VPSLLWZrikz_VPSRADZri_VPSRADZrik_VPSRADZrikz_VPSRAQZri_VPSRAQZrik_VPSRAQZrikz_VPSRAWZri_VPSRAWZrik_VPSRAWZrikz_VPSRLDZri_VPSRLDZrik_VPSRLDZrikz_VPSRLQZri_VPSRLQZrik_VPSRLQZrikz_VPSRLWZri_VPSRLWZrik_VPSRLWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1103
  {DBGFIELD("PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1104
  {DBGFIELD("VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1105
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1106
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1107
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1108
  {DBGFIELD("VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1109
  {DBGFIELD("CMPPDrri_VCMPPDrri_VMAXCPDZ128rr_VMAXCPDZ128rrk_VMAXCPDZ128rrkz_VMAXPDZ128rr_VMAXPDZ128rrk_VMAXPDZ128rrkz_VMINCPDZ128rr_VMINCPDZ128rrk_VMINCPDZ128rrkz_VMINPDZ128rr_VMINPDZ128rrk_VMINPDZ128rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1110
  {DBGFIELD("CMPPSrri_VCMPPSrri") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1111
  {DBGFIELD("CMPSDrri_CMPSDrri_Int_VCMPSDrri_VCMPSDrri_Int_MAXSDrr_Int_MINSDrr_Int_VMAXSDZrr_Int_VMAXSDZrrk_Int_VMAXSDZrrkz_Int_VMAXSDrr_Int_VMINSDZrr_Int_VMINSDZrrk_Int_VMINSDZrrkz_Int_VMINSDrr_Int") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1112
  {DBGFIELD("CMPSSrri_CMPSSrri_Int_VCMPSSrri_VCMPSSrri_Int_MAXSSrr_Int_MINSSrr_Int_VMAXSSZrr_Int_VMAXSSZrrk_Int_VMAXSSZrrkz_Int_VMAXSSrr_Int_VMINSSZrr_Int_VMINSSZrrk_Int_VMINSSZrrkz_Int_VMINSSrr_Int") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1113
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1114
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1115
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1116
  {DBGFIELD("VMAXCPDZ256rr_VMAXCPDZ256rrk_VMAXCPDZ256rrkz_VMAXPDZ256rr_VMAXPDZ256rrb_VMAXPDZ256rrbk_VMAXPDZ256rrbkz_VMAXPDZ256rrk_VMAXPDZ256rrkz_VMINCPDZ256rr_VMINCPDZ256rrk_VMINCPDZ256rrkz_VMINPDZ256rr_VMINPDZ256rrb_VMINPDZ256rrbk_VMINPDZ256rrbkz_VMINPDZ256rrk_VMINPDZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1117
  {DBGFIELD("VMAXCPDZrr_VMAXCPDZrrk_VMAXCPDZrrkz_VMAXPDZrr_VMAXPDZrrb_VMAXPDZrrbk_VMAXPDZrrbkz_VMAXPDZrrk_VMAXPDZrrkz_VMINCPDZrr_VMINCPDZrrk_VMINCPDZrrkz_VMINPDZrr_VMINPDZrrb_VMINPDZrrbk_VMINPDZrrbkz_VMINPDZrrk_VMINPDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1118
  {DBGFIELD("VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1119
  {DBGFIELD("VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1120
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD("PMOVSXBDrr_PMOVSXBQrr_PMOVSXBWrr_PMOVSXDQrr_PMOVSXWDrr_PMOVSXWQrr_PMOVZXBDrr_PMOVZXBQrr_PMOVZXBWrr_PMOVZXDQrr_PMOVZXWDrr_PMOVZXWQrr_VPMOVSXBDZ128rr_VPMOVSXBDZ128rrk_VPMOVSXBDZ128rrkz_VPMOVSXBDrr_VPMOVSXBQZ128rr_VPMOVSXBQZ128rrk_VPMOVSXBQZ128rrkz_VPMOVSXBQrr_VPMOVSXBWZ128rr_VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVSXBWrr_VPMOVSXDQZ128rr_VPMOVSXDQZ128rrk_VPMOVSXDQZ128rrkz_VPMOVSXDQrr_VPMOVSXWDZ128rr_VPMOVSXWDZ128rrk_VPMOVSXWDZ128rrkz_VPMOVSXWDrr_VPMOVSXWQZ128rr_VPMOVSXWQZ128rrk_VPMOVSXWQZ128rrkz_VPMOVSXWQrr_VPMOVZXBDZ128rr_VPMOVZXBDZ128rrk_VPMOVZXBDZ128rrkz_VPMOVZXBDrr_VPMOVZXBQZ128rr_VPMOVZXBQZ128rrk_VPMOVZXBQZ128rrkz_VPMOVZXBQrr_VPMOVZXBWZ128rr_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz_VPMOVZXBWrr_VPMOVZXDQZ128rr_VPMOVZXDQZ128rrk_VPMOVZXDQZ128rrkz_VPMOVZXDQrr_VPMOVZXWDZ128rr_VPMOVZXWDZ128rrk_VPMOVZXWDZ128rrkz_VPMOVZXWDrr_VPMOVZXWQZ128rr_VPMOVZXWQZ128rrk_VPMOVZXWQZ128rrkz_VPMOVZXWQrr") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1122
  {DBGFIELD("VPMOVSXBDYrr_VPMOVSXBDZ256rr_VPMOVSXBDZ256rrk_VPMOVSXBDZ256rrkz_VPMOVSXBQYrr_VPMOVSXBQZ256rr_VPMOVSXBQZ256rrk_VPMOVSXBQZ256rrkz_VPMOVSXBWYrr_VPMOVSXBWZ256rr_VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVSXDQYrr_VPMOVSXDQZ256rr_VPMOVSXDQZ256rrk_VPMOVSXDQZ256rrkz_VPMOVSXWDYrr_VPMOVSXWDZ256rr_VPMOVSXWDZ256rrk_VPMOVSXWDZ256rrkz_VPMOVSXWQYrr_VPMOVSXWQZ256rr_VPMOVSXWQZ256rrk_VPMOVSXWQZ256rrkz_VPMOVZXBDYrr_VPMOVZXBDZ256rr_VPMOVZXBDZ256rrk_VPMOVZXBDZ256rrkz_VPMOVZXBQYrr_VPMOVZXBQZ256rr_VPMOVZXBQZ256rrk_VPMOVZXBQZ256rrkz_VPMOVZXBWYrr_VPMOVZXBWZ256rr_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz_VPMOVZXDQYrr_VPMOVZXDQZ256rr_VPMOVZXDQZ256rrk_VPMOVZXDQZ256rrkz_VPMOVZXWDYrr_VPMOVZXWDZ256rr_VPMOVZXWDZ256rrk_VPMOVZXWDZ256rrkz_VPMOVZXWQYrr_VPMOVZXWQZ256rr_VPMOVZXWQZ256rrk_VPMOVZXWQZ256rrkz_VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz_VPMOVQDZ256rr_VPMOVQDZ256rrk_VPMOVQDZ256rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQWZ128rr_VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz_VPMOVUSQWZ256rr_VPMOVUSQWZ256rrk_VPMOVUSQWZ256rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1123
  {DBGFIELD("VPMOVSXBDZrr_VPMOVSXBDZrrk_VPMOVSXBDZrrkz_VPMOVSXBQZrr_VPMOVSXBQZrrk_VPMOVSXBQZrrkz_VPMOVSXBWZrr_VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVSXDQZrr_VPMOVSXDQZrrk_VPMOVSXDQZrrkz_VPMOVSXWDZrr_VPMOVSXWDZrrk_VPMOVSXWDZrrkz_VPMOVSXWQZrr_VPMOVSXWQZrrk_VPMOVSXWQZrrkz_VPMOVZXBDZrr_VPMOVZXBDZrrk_VPMOVZXBDZrrkz_VPMOVZXBQZrr_VPMOVZXBQZrrk_VPMOVZXBQZrrkz_VPMOVZXBWZrr_VPMOVZXBWZrrk_VPMOVZXBWZrrkz_VPMOVZXDQZrr_VPMOVZXDQZrrk_VPMOVZXDQZrrkz_VPMOVZXWDZrr_VPMOVZXWDZrrk_VPMOVZXWDZrrkz_VPMOVZXWQZrr_VPMOVZXWQZrrk_VPMOVZXWQZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1124
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQDZrr_VPMOVQDZrrk_VPMOVQDZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSQWZrr_VPMOVUSQWZrrk_VPMOVUSQWZrrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1125
  {DBGFIELD("VPTESTMBZ128rrk_VPTESTMDZ128rrk_VPTESTMQZ128rrk_VPTESTMWZ128rrk_VPTESTNMBZ128rrk_VPTESTNMDZ128rrk_VPTESTNMQZ128rrk_VPTESTNMWZ128rrk") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1126
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1127
  {DBGFIELD("VPTESTMBZrrk_VPTESTMDZrrk_VPTESTMQZrrk_VPTESTMWZrrk_VPTESTNMBZrrk_VPTESTNMDZrrk_VPTESTNMQZrrk_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz_VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1129
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz_VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1130
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz_VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1131
  {DBGFIELD("VRSQRT14PDZ128r_VRSQRT14PDZ128rk_VRSQRT14PDZ128rkz_VRSQRT14PSZ128r_VRSQRT14PSZ128rk_VRSQRT14PSZ128rkz") 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #1132
  {DBGFIELD("VRSQRT14PDZ256r_VRSQRT14PDZ256rk_VRSQRT14PDZ256rkz_VRSQRT14PSZ256r_VRSQRT14PSZ256rk_VRSQRT14PSZ256rkz") 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #1133
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PDZrk_VRSQRT14PDZrkz_VRSQRT14PSZr_VRSQRT14PSZrk_VRSQRT14PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1134
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1135
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1136
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1137
  {DBGFIELD("VPERMI2PDZ128rr_VPERMI2PDZ128rrk_VPERMI2PDZ128rrkz_VPERMI2PSZ128rr_VPERMI2PSZ128rrk_VPERMI2PSZ128rrkz_VPERMT2PDZ128rr_VPERMT2PDZ128rrk_VPERMT2PDZ128rrkz_VPERMT2PSZ128rr_VPERMT2PSZ128rrk_VPERMT2PSZ128rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1138
  {DBGFIELD("VPERMI2WZ128rr_VPERMI2WZ128rrk_VPERMI2WZ128rrkz_VPERMT2WZ128rr_VPERMT2WZ128rrk_VPERMT2WZ128rrkz_VPERMI2BZ128rr_VPERMI2BZ128rrk_VPERMI2BZ128rrkz_VPERMI2DZ128rr_VPERMI2DZ128rrk_VPERMI2DZ128rrkz_VPERMI2QZ128rr_VPERMI2QZ128rrk_VPERMI2QZ128rrkz_VPERMT2BZ128rr_VPERMT2BZ128rrk_VPERMT2BZ128rrkz_VPERMT2DZ128rr_VPERMT2DZ128rrk_VPERMT2DZ128rrkz_VPERMT2QZ128rr_VPERMT2QZ128rrk_VPERMT2QZ128rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1139
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSBZ128rr_VPCOMPRESSBZ128rrk_VPCOMPRESSBZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSWZ128rr_VPCOMPRESSWZ128rrk_VPCOMPRESSWZ128rrkz_VPERMBZ128rr_VPERMBZ128rrk_VPERMBZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1140
  {DBGFIELD("VPERMI2PDZ256rr_VPERMI2PDZ256rrk_VPERMI2PDZ256rrkz_VPERMI2PSZ256rr_VPERMI2PSZ256rrk_VPERMI2PSZ256rrkz_VPERMT2PDZ256rr_VPERMT2PDZ256rrk_VPERMT2PDZ256rrkz_VPERMT2PSZ256rr_VPERMT2PSZ256rrk_VPERMT2PSZ256rrkz_VPERMPDZ256rr_VPERMPDZ256rrk_VPERMPDZ256rrkz_VPERMPSZ256rr_VPERMPSZ256rrk_VPERMPSZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1141
  {DBGFIELD("VPERMI2WZ256rr_VPERMI2WZ256rrk_VPERMI2WZ256rrkz_VPERMT2WZ256rr_VPERMT2WZ256rrk_VPERMT2WZ256rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSBZ256rr_VPCOMPRESSBZ256rrk_VPCOMPRESSBZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSWZ256rr_VPCOMPRESSWZ256rrk_VPCOMPRESSWZ256rrkz_VPERMBZ256rr_VPERMBZ256rrk_VPERMBZ256rrkz_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMI2BZ256rr_VPERMI2BZ256rrk_VPERMI2BZ256rrkz_VPERMI2DZ256rr_VPERMI2DZ256rrk_VPERMI2DZ256rrkz_VPERMI2QZ256rr_VPERMI2QZ256rrk_VPERMI2QZ256rrkz_VPERMT2BZ256rr_VPERMT2BZ256rrk_VPERMT2BZ256rrkz_VPERMT2DZ256rr_VPERMT2DZ256rrk_VPERMT2DZ256rrkz_VPERMT2QZ256rr_VPERMT2QZ256rrk_VPERMT2QZ256rrkz_VPEXPANDBZ256rr_VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rr_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1142
  {DBGFIELD("VPERMI2PDZrr_VPERMI2PDZrrk_VPERMI2PDZrrkz_VPERMI2PSZrr_VPERMI2PSZrrk_VPERMI2PSZrrkz_VPERMT2PDZrr_VPERMT2PDZrrk_VPERMT2PDZrrkz_VPERMT2PSZrr_VPERMT2PSZrrk_VPERMT2PSZrrkz_VPERMPDZrr_VPERMPDZrrk_VPERMPDZrrkz_VPERMPSZrr_VPERMPSZrrk_VPERMPSZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1143
  {DBGFIELD("VPERMI2WZrr_VPERMI2WZrrk_VPERMI2WZrrkz_VPERMT2WZrr_VPERMT2WZrrk_VPERMT2WZrrkz_VPERMBZrr_VPERMBZrrk_VPERMBZrrkz_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz_VPERMI2BZrr_VPERMI2BZrrk_VPERMI2BZrrkz_VPERMI2DZrr_VPERMI2DZrrk_VPERMI2DZrrkz_VPERMI2QZrr_VPERMI2QZrrk_VPERMI2QZrrkz_VPERMT2BZrr_VPERMT2BZrrk_VPERMT2BZrrkz_VPERMT2DZrr_VPERMT2DZrrk_VPERMT2DZrrkz_VPERMT2QZrr_VPERMT2QZrrk_VPERMT2QZrrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSBZrr_VPCOMPRESSBZrrk_VPCOMPRESSBZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPCOMPRESSWZrr_VPCOMPRESSWZrrk_VPCOMPRESSWZrrkz_VPEXPANDBZrr_VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrr_VPEXPANDWZrrk_VPEXPANDWZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1144
  {DBGFIELD("VPABSBZ128rr_VPABSBZ128rrk_VPABSBZ128rrkz_VPABSDZ128rr_VPABSDZ128rrk_VPABSDZ128rrkz_VPABSQZ128rr_VPABSQZ128rrk_VPABSQZ128rrkz_VPABSWZ128rr_VPABSWZ128rrk_VPABSWZ128rrkz_VPADDSBZ128rr_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rr_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rr_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rr_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rr_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rr_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPOPCNTBZ128rr_VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTDZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rr_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz_VPOPCNTWZ128rr_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz_VPSUBSBZ128rr_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rr_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPSUBUSBZ128rr_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rr_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1145
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr_VANDNPSZ128rr_VANDNPDZ128rr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1146
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr_VANDNPSZ256rr_VANDNPDZ256rr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1147
  {DBGFIELD("VXORPSZrr_VXORPDZrr_VANDNPSZrr_VANDNPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1148
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr_VPANDNDZ128rr_VPANDNQZ128rr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1149
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr_VPANDNDZ256rr_VPANDNQZ256rr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1150
  {DBGFIELD("VPXORDZrr_VPXORQZrr_VPANDNDZrr_VPANDNQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1151
  {DBGFIELD("VPSUBBZ128rr_VPSUBWZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPCMPGTBZ128rr_VPCMPGTWZ128rr_VPCMPGTDZ128rr_VPCMPGTQZ128rr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1152
  {DBGFIELD("VPSUBBZ256rr_VPSUBWZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPCMPGTBZ256rr_VPCMPGTWZ256rr_VPCMPGTDZ256rr_VPCMPGTQZ256rr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1153
  {DBGFIELD("VPSUBBZrr_VPSUBWZrr_VPSUBDZrr_VPSUBQZrr_VPCMPGTBZrr_VPCMPGTWZrr_VPCMPGTDZrr_VPCMPGTQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 15, false, false, false, 1889, 15, 56, 1,  0, 0}, // #1155
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #1156
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1157
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false, false,  1, 2,  8, 1,  0, 0}, // #1158
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #1159
  {DBGFIELD("CRC32r32r16")        1, false, false, false, 38, 8,  5, 1,  0, 0}, // #1160
  {DBGFIELD("CRC32r32r32")        1, false, false, false, 38, 8,  5, 1,  0, 0}, // #1161
  {DBGFIELD("CRC32r64r64")        1, false, false, false, 38, 8,  5, 1,  0, 0}, // #1162
  {DBGFIELD("SAHF")               2, false, false, false, 759, 5, 14, 1,  0, 0}, // #1163
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 163, 10,  3, 1,  0, 0}, // #1164
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 3, false, false, false, 151, 12,  8, 1,  0, 0}, // #1165
  {DBGFIELD("RCR8ri")             3, false, false, false, 754, 5, 12, 1,  0, 0}, // #1166
  {DBGFIELD("RCL16rCL")           7, false, false, false, 1879, 10,  7, 1,  0, 0}, // #1167
  {DBGFIELD("RCR16ri")            3, false, false, false, 754, 5, 12, 1,  0, 0}, // #1168
  {DBGFIELD("RCR32rCL_RCR64rCL")  7, false, false, false, 1879, 10,  7, 1,  0, 0}, // #1169
  {DBGFIELD("RCL16ri")            3, false, false, false, 754, 5, 12, 1,  0, 0}, // #1170
  {DBGFIELD("RCL32ri_RCL64ri")    3, false, false, false, 754, 5, 12, 1,  0, 0}, // #1171
  {DBGFIELD("SHLD16rrCL")         3, false, false, false, 492, 10, 10, 1,  0, 0}, // #1172
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 3, false, false, false, 492, 10, 10, 1,  0, 0}, // #1173
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1174
  {DBGFIELD("TST_F")              1, false, false, false,  3, 9, 12, 1,  0, 0}, // #1175
  {DBGFIELD("VDPPSrri")           6, false, false, false, 361, 11, 21, 1,  0, 0}, // #1176
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1177
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1178
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #1179
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1180
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #1181
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 254, 10,  7, 1,  0, 0}, // #1182
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 254, 10,  6, 1,  0, 1}, // #1183
  {DBGFIELD("VMOVDQUYmr")         2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1184
  {DBGFIELD("MOVDQArr")           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1185
  {DBGFIELD("MMX_MOVQ2DQrr")      2, false, false, false, 873, 9,  5, 1,  0, 0}, // #1186
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, false, 120, 5,  9, 1,  0, 0}, // #1187
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1188
  {DBGFIELD("VPPERMrrm")          2, false, false, false, 78, 8,  7, 1, 10, 2}, // #1189
  {DBGFIELD("VPPERMrmr")          2, false, false, false, 78, 8,  7, 1,  8, 2}, // #1190
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 712, 6, 12, 1,  0, 0}, // #1191
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 704, 8, 22, 1,  6, 1}, // #1192
  {DBGFIELD("VPCLMULQDQrri")      1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1193
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1194
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false, 548, 6,  1, 1,  0, 0}, // #1195
  {DBGFIELD("PANDNrr")            1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1196
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 548, 6,  1, 1,  0, 0}, // #1197
  {DBGFIELD("MMX_PSUBQrr")        1, false, false, false, 548, 6,  1, 1,  0, 0}, // #1198
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1199
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 238, 5,  5, 1,  0, 0}, // #1200
  {DBGFIELD("LCMPXCHG8B")         6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1201
  {DBGFIELD("INC8m_INC16m_INC32m_INC64m_DEC8m_DEC16m_DEC32m_DEC64m_NOT8m_NOT16m_NOT32m_NOT64m_NEG8m_NEG16m_NEG32m_NEG64m") 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #1202
  {DBGFIELD("XCHG8rr")            3, false, false, false, 236, 2, 12, 1,  0, 0}, // #1203
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1204
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1205
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1206
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1207
  {DBGFIELD("CLAC_STAC")          1, false, false, false, 12, 5,  1, 1,  0, 0}, // #1208
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1209
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1210
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1211
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 1904, 12,  5, 1,  0, 0}, // #1212
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 1916, 7, 12, 1,  0, 0}, // #1213
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, false, 1916, 7, 12, 1,  0, 0}, // #1214
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 2, false, false, false, 243, 11, 22, 1,  6, 1}, // #1215
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #1216
  {DBGFIELD("VCVTSS2SI64rr_VCVTTSS2SI64rr") 3, false, false, false, 906, 12,  7, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTSS2SI64rr_Int_VCVTTSS2SI64rr_Int") 3, false, false, false, 906, 12,  7, 1,  0, 0}, // #1218
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #1219
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 1923, 14,  8, 1,  6, 1}, // #1220
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 1937, 9, 22, 1,  6, 1}, // #1221
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, false, 1937, 9,  9, 1,  6, 1}, // #1222
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 186, false, false, false, 1946, 16, 52, 1,  0, 0}, // #1223
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1224
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1225
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1226
  {DBGFIELD("KANDBkk_KANDDkk_KANDQkk_KANDWkk_KANDNBkk_KANDNDkk_KANDNQkk_KANDNWkk_KNOTBkk_KNOTDkk_KNOTQkk_KNOTWkk_KORBkk_KORDkk_KORQkk_KORWkk_KXNORBkk_KXNORDkk_KXNORQkk_KXNORWkk_KXORBkk_KXORDkk_KXORQkk_KXORWkk") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1227
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1228
  {DBGFIELD("KMOVBkk_EVEX_KMOVDkk_EVEX_KMOVQkk_EVEX_KMOVWkk_EVEX_VPMOVB2MZ128kr_VPMOVB2MZ256kr_VPMOVB2MZkr_VPMOVD2MZ128kr_VPMOVD2MZ256kr_VPMOVD2MZkr_VPMOVQ2MZ128kr_VPMOVQ2MZ256kr_VPMOVQ2MZkr_VPMOVW2MZ128kr_VPMOVW2MZ256kr_VPMOVW2MZkr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1229
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1230
  {DBGFIELD("KMOVBkr_EVEX_KMOVDkr_EVEX_KMOVQkr_EVEX_KMOVWkr_EVEX") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1231
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1232
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 3, false, false, false, 849, 4,  5, 1,  0, 0}, // #1233
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1234
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1235
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1236
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1237
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 3, false, false, false, 849, 4,  5, 1,  0, 0}, // #1238
  {DBGFIELD("KMOVBmk_EVEX_KMOVDmk_EVEX_KMOVQmk_EVEX_KMOVWmk_EVEX") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1239
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1240
  {DBGFIELD("KMOVBrk_EVEX_KMOVDrk_EVEX_KMOVQrk_EVEX_KMOVWrk_EVEX") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1241
  {DBGFIELD("KORTESTBkk_KORTESTDkk_KORTESTQkk_KORTESTWkk_KTESTBkk_KTESTDkk_KTESTQkk_KTESTWkk") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1242
  {DBGFIELD("VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1243
  {DBGFIELD("VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1244
  {DBGFIELD("VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1245
  {DBGFIELD("KSHIFTLBki_KSHIFTLDki_KSHIFTLQki_KSHIFTLWki_KSHIFTRBki_KSHIFTRDki_KSHIFTRQki_KSHIFTRWki") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1246
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128ri_VFPCLASSPDZ128rik_VFPCLASSPSZ128ri_VFPCLASSPSZ128rik") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1247
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrib_VCMPPDZ256rribk_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrib_VCMPPSZ256rribk_VCMPPSZ256rrik_VFPCLASSPDZ256ri_VFPCLASSPDZ256rik_VFPCLASSPSZ256ri_VFPCLASSPSZ256rik") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1248
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZri_VFPCLASSPDZrik_VFPCLASSPSZri_VFPCLASSPSZrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VCMPSDZrri_VCMPSDZrri_Int_VCMPSDZrrib_Int_VCMPSDZrribk_Int_VCMPSDZrrik_Int_VCMPSSZrri_VCMPSSZrri_Int_VCMPSSZrrib_Int_VCMPSSZrribk_Int_VCMPSSZrrik_Int_VFPCLASSSDZri_VFPCLASSSDZrik_VFPCLASSSSZri_VFPCLASSSSZrik") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1250
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rrk_VPCMPGTDZ128rrk_VPCMPGTQZ128rrk_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1251
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rrk_VPCMPGTDZ256rrk_VPCMPGTQZ256rrk_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1252
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrrk_VPCMPGTDZrrk_VPCMPGTQZrrk_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD("VPCMPGTBZ128rr_VPCMPGTDZ128rr_VPCMPGTQZ128rr_VPCMPGTWZ128rr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1254
  {DBGFIELD("VPCMPGTBZ256rr_VPCMPGTDZ256rr_VPCMPGTQZ256rr_VPCMPGTWZ256rr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1255
  {DBGFIELD("VPCMPGTBZrr_VPCMPGTDZrr_VPCMPGTQZrr_VPCMPGTWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("VPTESTMBZ128rr_VPTESTMDZ128rr_VPTESTMQZ128rr_VPTESTMWZ128rr_VPTESTNMBZ128rr_VPTESTNMDZ128rr_VPTESTNMQZ128rr_VPTESTNMWZ128rr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1257
  {DBGFIELD("VPTESTMBZrr_VPTESTMDZrr_VPTESTMQZrr_VPTESTMWZrr_VPTESTNMBZrr_VPTESTNMDZrr_VPTESTNMQZrr_VPTESTNMWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1258
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1259
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrb_VCVTPD2QQZ256rrbk_VCVTPD2QQZ256rrbkz_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrb_VCVTPD2UQQZ256rrbk_VCVTPD2UQQZ256rrbkz_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrb_VCVTTPD2QQZ256rrbk_VCVTTPD2QQZ256rrbkz_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrb_VCVTTPD2UQQZ256rrbk_VCVTTPD2UQQZ256rrbkz_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1260
  {DBGFIELD("VCVTPS2DQYrr_VCVTPS2DQZ256rr_VCVTPS2DQZ256rrb_VCVTPS2DQZ256rrbk_VCVTPS2DQZ256rrbkz_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrb_VCVTPS2UDQZ256rrbk_VCVTPS2UDQZ256rrbkz_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrb_VCVTTPS2DQZ256rrbk_VCVTTPS2DQZ256rrbkz_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrb_VCVTTPS2UDQZ256rrbk_VCVTTPS2UDQZ256rrbkz_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1261
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1262
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1263
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1264
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1265
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1266
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1267
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1268
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1269
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1270
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz_CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1271
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1272
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1273
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 254, 10,  6, 1,  7, 1}, // #1274
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, false, 254, 10,  6, 1,  7, 1}, // #1275
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrbk_Int_VCVTSS2SDZrrbkz_Int_VCVTSS2SDZrrk_Int_VCVTSS2SDZrrkz_Int_CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1276
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1277
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, false, 853, 8,  2, 1,  0, 0}, // #1278
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, false, 853, 8,  2, 1,  0, 0}, // #1279
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1281
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1282
  {DBGFIELD("VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1283
  {DBGFIELD("VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1284
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #1285
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 55, 3,  6, 1,  0, 0}, // #1286
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, false, 254, 10,  6, 1,  7, 1}, // #1287
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #1288
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1289
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrb_VCVTPD2DQZ256rrbk_VCVTPD2DQZ256rrbkz_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrb_VCVTPD2UDQZ256rrbk_VCVTPD2UDQZ256rrbkz_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrb_VCVTTPD2DQZ256rrbk_VCVTTPD2DQZ256rrbkz_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrb_VCVTTPD2UDQZ256rrbk_VCVTTPD2UDQZ256rrbkz_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1290
  {DBGFIELD("VCVTPS2PDYrr_VCVTPS2PDZ256rr_VCVTPS2PDZ256rrb_VCVTPS2PDZ256rrbk_VCVTPS2PDZ256rrbkz_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1291
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrb_VCVTPS2QQZ256rrbk_VCVTPS2QQZ256rrbkz_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrb_VCVTPS2UQQZ256rrbk_VCVTPS2UQQZ256rrbkz_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrb_VCVTTPS2QQZ256rrbk_VCVTTPS2QQZ256rrbkz_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrb_VCVTTPS2UQQZ256rrbk_VCVTTPS2UQQZ256rrbkz_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1292
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrb_VCVTQQ2PSZ256rrbk_VCVTQQ2PSZ256rrbkz_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrb_VCVTUQQ2PSZ256rrbk_VCVTUQQ2PSZ256rrbkz_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1293
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1294
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1295
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1296
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1297
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1298
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #1299
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1300
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1301
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #1302
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, false, 526, 11,  7, 1,  0, 0}, // #1303
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #1304
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1305
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #1306
  {DBGFIELD("VPERMI2WZ128rr_VPERMI2WZ128rrk_VPERMI2WZ128rrkz_VPERMT2WZ128rr_VPERMT2WZ128rrk_VPERMT2WZ128rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1307
  {DBGFIELD("VPERMI2WZ256rr_VPERMI2WZ256rrk_VPERMI2WZ256rrkz_VPERMT2WZ256rr_VPERMT2WZ256rrk_VPERMT2WZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1308
  {DBGFIELD("VPERMI2WZrr_VPERMI2WZrrk_VPERMI2WZrrkz_VPERMT2WZrr_VPERMT2WZrrk_VPERMT2WZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1309
  {DBGFIELD("VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 287, 9,  6, 1,  0, 0}, // #1310
  {DBGFIELD("KMOVBkm_KMOVBkm_EVEX_KMOVDkm_KMOVDkm_EVEX_KMOVQkm_KMOVQkm_EVEX_KMOVWkm_KMOVWkm_EVEX") 1, false, false, false, 55, 3, 10, 1,  0, 0}, // #1311
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1312
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1313
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1314
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQDZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPSZmr_VSCATTERQPDZmr") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1315
  {DBGFIELD("VSCATTERDPSZmr")     2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1316
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1317
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 4, false, false, false, 843, 6,  9, 1,  6, 1}, // #1318
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1320
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4Zrm_VBROADCASTF32X4Zrmk_VBROADCASTF32X4Zrmkz_VBROADCASTF32X8Zrm_VBROADCASTF32X8Zrmk_VBROADCASTF32X8Zrmkz_VBROADCASTF64X2Z256rm_VBROADCASTF64X2Z256rmk_VBROADCASTF64X2Z256rmkz_VBROADCASTF64X2Zrm_VBROADCASTF64X2Zrmk_VBROADCASTF64X2Zrmkz_VBROADCASTF64X4Zrm_VBROADCASTF64X4Zrmk_VBROADCASTF64X4Zrmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4Zrm_VBROADCASTI32X4Zrmk_VBROADCASTI32X4Zrmkz_VBROADCASTI32X8Zrm_VBROADCASTI32X8Zrmk_VBROADCASTI32X8Zrmkz_VBROADCASTI64X2Z256rm_VBROADCASTI64X2Z256rmk_VBROADCASTI64X2Z256rmkz_VBROADCASTI64X2Zrm_VBROADCASTI64X2Zrmk_VBROADCASTI64X2Zrmkz_VBROADCASTI64X4Zrm_VBROADCASTI64X4Zrmk_VBROADCASTI64X4Zrmkz") 2, false, false, false, 78, 8, 22, 1,  0, 0}, // #1321
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1322
  {DBGFIELD("VINSERTF32X4Z256rmi_VINSERTF32X4Z256rmik_VINSERTF32X4Z256rmikz_VINSERTF32X4Zrmi_VINSERTF32X4Zrmik_VINSERTF32X4Zrmikz_VINSERTF32X8Zrmi_VINSERTF32X8Zrmik_VINSERTF32X8Zrmikz_VINSERTF64X2Z256rmi_VINSERTF64X2Z256rmik_VINSERTF64X2Z256rmikz_VINSERTF64X2Zrmi_VINSERTF64X2Zrmik_VINSERTF64X2Zrmikz_VINSERTF64X4Zrmi_VINSERTF64X4Zrmik_VINSERTF64X4Zrmikz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1323
  {DBGFIELD("VINSERTI32X4Z256rmi_VINSERTI32X4Z256rmik_VINSERTI32X4Z256rmikz_VINSERTI32X4Zrmi_VINSERTI32X4Zrmik_VINSERTI32X4Zrmikz_VINSERTI32X8Zrmi_VINSERTI32X8Zrmik_VINSERTI32X8Zrmikz_VINSERTI64X2Z256rmi_VINSERTI64X2Z256rmik_VINSERTI64X2Z256rmikz_VINSERTI64X2Zrmi_VINSERTI64X2Zrmik_VINSERTI64X2Zrmikz_VINSERTI64X4Zrmi_VINSERTI64X4Zrmik_VINSERTI64X4Zrmikz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1324
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #1325
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 526, 11, 22, 1,  0, 0}, // #1326
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1327
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #1328
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1329
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1330
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 4, false, false, false, 843, 6,  9, 1,  6, 1}, // #1331
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1332
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1333
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1334
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1335
  {DBGFIELD("VPSCATTERDDZmr")     2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1336
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1337
  {DBGFIELD("VFPCLASSSDZmi_VFPCLASSSDZmik_VFPCLASSSSZmi_VFPCLASSSSZmik") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1338
  {DBGFIELD("VPERMI2DZ128rm_VPERMI2DZ128rmb_VPERMI2DZ128rmbk_VPERMI2DZ128rmbkz_VPERMI2DZ128rmk_VPERMI2DZ128rmkz_VPERMI2QZ128rm_VPERMI2QZ128rmb_VPERMI2QZ128rmbk_VPERMI2QZ128rmbkz_VPERMI2QZ128rmk_VPERMI2QZ128rmkz_VPERMT2DZ128rm_VPERMT2DZ128rmb_VPERMT2DZ128rmbk_VPERMT2DZ128rmbkz_VPERMT2DZ128rmk_VPERMT2DZ128rmkz_VPERMT2QZ128rm_VPERMT2QZ128rmb_VPERMT2QZ128rmbk_VPERMT2QZ128rmbkz_VPERMT2QZ128rmk_VPERMT2QZ128rmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1339
  {DBGFIELD("VPERMI2PDZ128rm_VPERMI2PDZ128rmb_VPERMI2PDZ128rmbk_VPERMI2PDZ128rmbkz_VPERMI2PDZ128rmk_VPERMI2PDZ128rmkz_VPERMI2PSZ128rm_VPERMI2PSZ128rmb_VPERMI2PSZ128rmbk_VPERMI2PSZ128rmbkz_VPERMI2PSZ128rmk_VPERMI2PSZ128rmkz_VPERMT2PDZ128rm_VPERMT2PDZ128rmb_VPERMT2PDZ128rmbk_VPERMT2PDZ128rmbkz_VPERMT2PDZ128rmk_VPERMT2PDZ128rmkz_VPERMT2PSZ128rm_VPERMT2PSZ128rmb_VPERMT2PSZ128rmbk_VPERMT2PSZ128rmbkz_VPERMT2PSZ128rmk_VPERMT2PSZ128rmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1340
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1341
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128mbi_VFPCLASSPDZ128mbik_VFPCLASSPDZ128mi_VFPCLASSPDZ128mik_VFPCLASSPSZ128mbi_VFPCLASSPSZ128mbik_VFPCLASSPSZ128mi_VFPCLASSPSZ128mik") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1342
  {DBGFIELD("VCMPSDZrmi_VCMPSDZrmi_Int_VCMPSDZrmik_Int_VCMPSSZrmi_VCMPSSZrmi_Int_VCMPSSZrmik_Int") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1343
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmbi_VPCMPDZ128rmbik_VPCMPDZ128rmi_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmbi_VPCMPQZ128rmbik_VPCMPQZ128rmi_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmbi_VPCMPUDZ128rmbik_VPCMPUDZ128rmi_VPCMPUDZ128rmik_VPCMPUQZ128rmbi_VPCMPUQZ128rmbik_VPCMPUQZ128rmi_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1344
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #1345
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1346
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1347
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1348
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1349
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1350
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256mbi_VFPCLASSPDZ256mbik_VFPCLASSPDZ256mi_VFPCLASSPDZ256mik_VFPCLASSPSZ256mbi_VFPCLASSPSZ256mbik_VFPCLASSPSZ256mi_VFPCLASSPSZ256mik") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1351
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZmbi_VFPCLASSPDZmbik_VFPCLASSPDZmi_VFPCLASSPDZmik_VFPCLASSPSZmbi_VFPCLASSPSZmbik_VFPCLASSPSZmi_VFPCLASSPSZmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1352
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmbi_VPCMPDZ256rmbik_VPCMPDZ256rmi_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmbi_VPCMPQZ256rmbik_VPCMPQZ256rmi_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmbi_VPCMPUDZ256rmbik_VPCMPUDZ256rmi_VPCMPUDZ256rmik_VPCMPUQZ256rmbi_VPCMPUQZ256rmbik_VPCMPUQZ256rmi_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1353
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmbi_VPCMPDZrmbik_VPCMPDZrmi_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmbi_VPCMPQZrmbik_VPCMPQZrmi_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmbi_VPCMPUDZrmbik_VPCMPUDZrmi_VPCMPUDZrmik_VPCMPUQZrmbi_VPCMPUQZrmbik_VPCMPUQZrmi_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1354
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #1355
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1357
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_CVTDQ2PSrm_VCVTDQ2PSrm_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1358
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #1359
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1360
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_CVTPS2DQrm_VCVTPS2DQrm_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_CVTTPS2DQrm_VCVTTPS2DQrm_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1361
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1362
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrmk_Int_VCVTSS2SDZrmkz_Int_CVTSS2SDrm_CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1363
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1364
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1365
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1366
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1367
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1368
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1369
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1370
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1371
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1372
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1373
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1374
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #1375
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1376
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm_VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1377
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1378
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1379
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1380
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #1381
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #1382
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1383
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1384
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1385
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1386
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #1387
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #1388
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1389
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1390
  {DBGFIELD("VCVTDQ2PDYrm")       2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1391
  {DBGFIELD("VPERMI2WZ128rm_VPERMI2WZ128rmk_VPERMI2WZ128rmkz_VPERMT2WZ128rm_VPERMT2WZ128rmk_VPERMT2WZ128rmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1392
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1393
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1394
  {DBGFIELD("VPERMI2WZ256rm_VPERMI2WZ256rmk_VPERMI2WZ256rmkz_VPERMI2WZrm_VPERMI2WZrmk_VPERMI2WZrmkz_VPERMT2WZ256rm_VPERMT2WZ256rmk_VPERMT2WZ256rmkz_VPERMT2WZrm_VPERMT2WZrmk_VPERMT2WZrmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1395
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #1396
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #1397
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #1398
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1399
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 55, 3, 42, 2,  0, 0}, // #1400
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 1, false, false, false, 55, 3, 42, 2,  0, 0}, // #1401
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 55, 3, 42, 2,  0, 0}, // #1402
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, false, 55, 3, 42, 2,  0, 0}, // #1403
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1404
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #1405
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1406
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #1407
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1408
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1409
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1410
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1411
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1412
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1413
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1414
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1415
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1416
  {DBGFIELD("INSERTPSrri_VINSERTPSZrri_VINSERTPSrri_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1417
  {DBGFIELD("VMOVDDUPYrr_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1418
  {DBGFIELD("VPALIGNRYrri")       1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1419
  {DBGFIELD("VPERMILPDrr_VPERMILPSrr") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1420
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1421
  {DBGFIELD("VPACKSSDWYrr_VPACKSSWBYrr_VPACKUSDWYrr_VPACKUSWBYrr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1422
  {DBGFIELD("VEXTRACTPSZrri")     2, false, false, false, 381, 11, 14, 1,  0, 0}, // #1423
  {DBGFIELD("VEXTRACTPSZmri")     3, false, false, false, 372, 9, 17, 1,  0, 0}, // #1424
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1425
  {DBGFIELD("INSERTPSrmi_VINSERTPSZrmi_VINSERTPSrmi_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #1426
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi") 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1427
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 2, false, false, false, 526, 11,  7, 1,  0, 0}, // #1428
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #1429
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz") 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1430
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 2, false, false, false, 526, 11, 22, 1,  0, 0}, // #1431
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #1432
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #1433
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1434
  {DBGFIELD("VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1435
  {DBGFIELD("VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1436
  {DBGFIELD("AADD64mr_AAND64mr_AOR64mr_AXOR64mr") 3, false, false, false, 1962, 9,  6, 1,  0, 0}, // #1437
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 2, false, false, false, 229, 7,  3, 1,  0, 0}, // #1438
  {DBGFIELD("RET16")              2, false, false, false, 229, 7,  3, 1,  0, 0}, // #1439
  {DBGFIELD("RORX32mi_RORX64mi")  2, false, false, false, 229, 7,  3, 1,  0, 0}, // #1440
  {DBGFIELD("ADC16rm_ADC32rm_ADC64rm_ADC8rm_SBB16rm_SBB32rm_SBB64rm_SBB8rm_ADCX32rm_ADCX64rm_ADOX32rm_ADOX64rm") 2, false, false, false, 229, 7,  3, 1, 12, 2}, // #1441
  {DBGFIELD("ADC8mi_ADC8mi8_SBB8mi_SBB8mi8") 5, false, false, false, 64, 9, 24, 1,  0, 0}, // #1442
  {DBGFIELD("CMP16mi_CMP32mi_CMP8mi_CMP16mi8_CMP32mi8_CMP64mi8_CMP8mi8") 2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1443
  {DBGFIELD("MOV8rm")             2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1444
  {DBGFIELD("POP16rmr_POP32rmr")  2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1445
  {DBGFIELD("POP32r")             2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1446
  {DBGFIELD("CMP64mi32")          2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1447
  {DBGFIELD("MOV8rm_NOREX")       2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1448
  {DBGFIELD("MOVZX16rm8")         2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1449
  {DBGFIELD("ADD16rm_ADD32rm_ADD64rm_ADD8rm_CMP16rm_CMP32rm_CMP64rm_CMP8rm_SUB16rm_SUB32rm_SUB64rm_SUB8rm_AND16rm_AND32rm_AND8rm_OR16rm_OR32rm_OR8rm_XOR16rm_XOR32rm_XOR8rm") 2, false, false, false, 104, 4,  3, 1,  1, 1}, // #1450
  {DBGFIELD("CMP16mr_CMP32mr_CMP64mr_CMP8mr") 2, false, false, false, 104, 4,  3, 1,  1, 1}, // #1451
  {DBGFIELD("ADD64ri8_SUB64ri8_DEC64r_INC64r") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1452
  {DBGFIELD("MOV64rr_MOV64rr_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1453
  {DBGFIELD("JMP_2")              0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1454
  {DBGFIELD("ADD8mi_ADD8mi8_SUB8mi_SUB8mi8") 4, false, false, false, 58, 6, 24, 1,  0, 0}, // #1455
  {DBGFIELD("AND8mi_AND8mi8_OR8mi_OR8mi8_XOR8mi_XOR8mi8") 4, false, false, false, 58, 6, 24, 1,  0, 0}, // #1456
  {DBGFIELD("DEC8m_INC8m_NEG8m_NOT8m") 4, false, false, false, 58, 6, 24, 1,  0, 0}, // #1457
  {DBGFIELD("ADD8mr")             4, false, false, false, 58, 6, 24, 1,  1, 1}, // #1458
  {DBGFIELD("AND8mr_OR8mr_XOR8mr") 4, false, false, false, 58, 6, 24, 1,  1, 1}, // #1459
  {DBGFIELD("SUB8mr")             4, false, false, false, 58, 6, 24, 1,  1, 1}, // #1460
  {DBGFIELD("ADDSSrr_ADDSSrr_Int_SUBSSrr_SUBSSrr_Int_VADDSSrr_VADDSSrr_Int_VSUBSSrr_VSUBSSrr_Int") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1461
  {DBGFIELD("AND16ri8_AND16rr_AND32ri8_AND32rr_AND64ri8_AND64rr_AND8ri8_AND8rr_AND16rr_REV_AND32rr_REV_AND64rr_REV_AND8rr_REV_TEST32i32_TEST64i32_AND32ri_AND8ri_TEST32ri_TEST8ri_AND64ri32_TEST64ri32_TEST8i8_OR16ri8_OR16rr_OR32ri8_OR32rr_OR64ri8_OR64rr_OR8ri8_OR8rr_XOR16ri8_XOR16rr_XOR32ri8_XOR64ri8_XOR8ri8_XOR8rr_OR16rr_REV_OR32rr_REV_OR64rr_REV_OR8rr_REV_XOR16rr_REV_XOR8rr_REV_OR32ri_OR8ri_XOR32ri_XOR8ri_OR64ri32_XOR64ri32_TEST16rr_TEST32rr_TEST64rr_TEST8rr") 1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1462
  {DBGFIELD("AND32i32_AND64i32_AND8i8_OR32i32_OR64i32_XOR32i32_XOR64i32_OR8i8_XOR8i8") 1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1463
  {DBGFIELD("XOR32rr_XOR64rr")    1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1464
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV") 1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1465
  {DBGFIELD("XOR8rr_NOREX")       1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1466
  {DBGFIELD("TEST16mi_TEST32mi_TEST8mi") 2, false, false, false, 104, 4,  6, 1,  0, 0}, // #1467
  {DBGFIELD("TEST64mi32")         2, false, false, false, 104, 4,  6, 1,  0, 0}, // #1468
  {DBGFIELD("OR64rm_XOR64rm")     2, false, false, false, 104, 4,  6, 1,  1, 1}, // #1469
  {DBGFIELD("AND64rm")            2, false, false, false, 104, 4,  6, 1,  1, 1}, // #1470
  {DBGFIELD("TEST16mr_TEST32mr_TEST64mr_TEST8mr") 2, false, false, false, 104, 4,  6, 1,  1, 1}, // #1471
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, false, 173, 5,  6, 1,  1, 1}, // #1472
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 178, 3, 12, 1,  0, 0}, // #1473
  {DBGFIELD("BT64mr")             9, false, false, false, 1971, 12,  9, 1,  0, 0}, // #1474
  {DBGFIELD("BT64rr")             1, false, false, false, 38, 8,  5, 1,  0, 0}, // #1475
  {DBGFIELD("BTC64rr_BTR64rr_BTS64rr") 1, false, false, false, 38, 8,  5, 1,  0, 0}, // #1476
  {DBGFIELD("BTC64mr_BTR64mr_BTS64mr") 10, false, false, false, 1983, 14, 20, 1,  0, 0}, // #1477
  {DBGFIELD("CALL64m_CALL64m_NT") 5, false, false, false, 64, 9,  6, 1,  0, 0}, // #1478
  {DBGFIELD("CALL64r_CALL64r_NT") 3, false, false, false, 1515, 8,  5, 1,  0, 0}, // #1479
  {DBGFIELD("MFENCE")             2, false, false, false, 51, 4,  5, 1,  0, 0}, // #1480
  {DBGFIELD("CDQE_CWDE")          1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1481
  {DBGFIELD("MOVSHDUPrr_MOVSLDUPrr_VMOVSHDUPrr_VMOVSLDUPrr_SHUFPDrri_SHUFPSrri_VSHUFPDrri_VSHUFPSrri") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1482
  {DBGFIELD("VMOVSHDUPYrr_VMOVSLDUPYrr_VSHUFPDYrri_VSHUFPSYrri") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1483
  {DBGFIELD("VPBLENDWYrri")       1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1484
  {DBGFIELD("CLFLUSH")            4, false, false, false, 1997, 8, 12, 1,  0, 0}, // #1485
  {DBGFIELD("CLTS")               10, false, false, false, 2005, 12,  4, 1,  0, 0}, // #1486
  {DBGFIELD("MOV16o16a_MOV16o32a_MOV16o64a") 3, false, false, false, 856, 5, 10, 1,  0, 0}, // #1487
  {DBGFIELD("CLWB")               3, false, false, false, 856, 5, 10, 1,  0, 0}, // #1488
  {DBGFIELD("CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SIrm") 3, false, false, false, 276, 11, 80, 1,  0, 0}, // #1489
  {DBGFIELD("VCVTTSD2SIrm_Int")   3, false, false, false, 276, 11, 80, 1,  0, 0}, // #1490
  {DBGFIELD("VCVTSI642SSrm_Int")  3, false, false, false, 264, 12,  2, 1,  6, 1}, // #1491
  {DBGFIELD("VCVTSI642SSrm")      3, false, false, false, 264, 12,  2, 1,  6, 1}, // #1492
  {DBGFIELD("VCVTSI642SSrr_Int")  3, false, false, false, 896, 10,  7, 1,  7, 1}, // #1493
  {DBGFIELD("JECXZ_JRCXZ")        2, false, false, false, 73, 5, 12, 1,  0, 0}, // #1494
  {DBGFIELD("ST_Frr")             1, false, false, false, 35, 3,  1, 1,  0, 0}, // #1495
  {DBGFIELD("MOV16sr_MOV32sr")    1, false, false, false, 35, 3,  1, 1,  0, 0}, // #1496
  {DBGFIELD("DEC16r_alt_SALC")    1, false, false, false, 35, 3,  1, 1,  0, 0}, // #1497
  {DBGFIELD("SYSCALL")            1, false, false, false, 35, 3,  1, 1,  0, 0}, // #1498
  {DBGFIELD("DEC32r_alt")         1, false, false, false, 764, 9,  6, 1,  0, 0}, // #1499
  {DBGFIELD("DIVR_FPrST0_DIVR_FrST0") 1, false, false, false,  3, 9, 11, 1,  0, 0}, // #1500
  {DBGFIELD("DIVSDrm_Int_VDIVSDrm_Int") 2, false, false, false, 243, 11, 15, 1,  6, 1}, // #1501
  {DBGFIELD("DIV_FPrST0_DIV_FrST0") 1, false, false, false,  3, 9, 15, 1,  0, 0}, // #1502
  {DBGFIELD("SMSW16m")            3, false, false, false, 1320, 12,  2, 1,  0, 0}, // #1503
  {DBGFIELD("MMX_PEXTRWrri")      2, false, false, false, 605, 12, 14, 1,  0, 0}, // #1504
  {DBGFIELD("MMX_PADDBrr_MMX_PADDDrr_MMX_PADDWrr") 1, false, false, false, 548, 6,  1, 1,  0, 0}, // #1505
  {DBGFIELD("GF2P8AFFINEINVQBrmi_GF2P8AFFINEQBrmi_VGF2P8AFFINEINVQBrmi_VGF2P8AFFINEQBrmi") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1506
  {DBGFIELD("GF2P8MULBrm_VGF2P8MULBrm") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1507
  {DBGFIELD("VGF2P8AFFINEINVQBYrmi_VGF2P8AFFINEQBYrmi") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1508
  {DBGFIELD("VGF2P8MULBYrm")      2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1509
  {DBGFIELD("GF2P8MULBrr_VGF2P8MULBrr") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1510
  {DBGFIELD("VGF2P8MULBYrr")      1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1511
  {DBGFIELD("IN16ri")             87, false, false, false, 2017, 15, 55, 1,  0, 0}, // #1512
  {DBGFIELD("IN16rr")             87, false, false, false, 2032, 15, 55, 1,  0, 0}, // #1513
  {DBGFIELD("IN32ri")             94, false, false, false, 2047, 15, 55, 1,  0, 0}, // #1514
  {DBGFIELD("IN32rr")             99, false, false, false, 2062, 15,  1, 1,  0, 0}, // #1515
  {DBGFIELD("INC16r_alt")         4, false, false, false, 12, 5,  1, 1,  0, 0}, // #1516
  {DBGFIELD("INC32r_alt")         1, false, false, false, 55, 3,  6, 1,  0, 0}, // #1517
  {DBGFIELD("INSB")               83, false, false, false, 2077, 17, 15, 1,  0, 0}, // #1518
  {DBGFIELD("INSL")               92, false, false, false, 2094, 17, 15, 1,  0, 0}, // #1519
  {DBGFIELD("INVLPG")             42, false, false, false, 2111, 16,  4, 1,  0, 0}, // #1520
  {DBGFIELD("JMP64r_REX")         1, false, false, false, 2127, 6,  1, 1,  0, 0}, // #1521
  {DBGFIELD("JMP_1_JMP_4")        0, false, false, false,  0, 0,  0, 1,  0, 0}, // #1522
  {DBGFIELD("LAR16rm")            81, false, false, false, 2133, 15, 81, 1,  0, 0}, // #1523
  {DBGFIELD("LAR16rr")            22, false, false, false, 1553, 15, 82, 1,  0, 0}, // #1524
  {DBGFIELD("LAR32rm")            85, false, false, false, 2148, 15, 83, 1,  0, 0}, // #1525
  {DBGFIELD("LAR64rm")            87, false, false, false, 2148, 15, 83, 1,  0, 0}, // #1526
  {DBGFIELD("LEAVE")              4, false, false, false, 845, 4,  3, 1,  0, 0}, // #1527
  {DBGFIELD("LGDT64m")            14, false, false, false, 2163, 16,  4, 1,  0, 0}, // #1528
  {DBGFIELD("LIDT64m")            14, false, false, false, 2179, 15,  4, 1,  0, 0}, // #1529
  {DBGFIELD("LLDT16m")            12, false, false, false, 2194, 14,  4, 1,  0, 0}, // #1530
  {DBGFIELD("LLDT16r")            11, false, false, false, 2208, 14,  4, 1,  0, 0}, // #1531
  {DBGFIELD("LMSW16m")            27, false, false, false, 2222, 17,  4, 1,  0, 0}, // #1532
  {DBGFIELD("LMSW16r")            22, false, false, false, 2239, 15,  4, 1,  0, 0}, // #1533
  {DBGFIELD("MMX_MOVD64mr")       2, false, false, false, 51, 4, 13, 1,  0, 0}, // #1534
  {DBGFIELD("MMX_MOVD64rm_MMX_MOVQ64rm") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #1535
  {DBGFIELD("MMX_MOVD64to64rm")   1, false, false, false, 55, 3,  7, 1,  0, 0}, // #1536
  {DBGFIELD("MMX_MOVFR642Qrr")    2, false, false, false, 1293, 6,  5, 1,  0, 0}, // #1537
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm") 3, false, false, false, 1533, 11,  2, 1,  6, 1}, // #1538
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr") 2, false, false, false, 1544, 9, 14, 1,  0, 0}, // #1539
  {DBGFIELD("MMX_PINSRWrri")      2, false, false, false, 1544, 9, 14, 1,  7, 1}, // #1540
  {DBGFIELD("MMX_PADDBrm_MMX_PADDDrm_MMX_PADDWrm_MMX_PSUBBrm_MMX_PSUBDrm_MMX_PSUBWrm") 2, false, false, false, 554, 8, 22, 1,  6, 1}, // #1541
  {DBGFIELD("MMX_PINSRWrmi")      2, false, false, false, 526, 11, 22, 1,  1, 1}, // #1542
  {DBGFIELD("VPALIGNRYrmi")       2, false, false, false, 526, 11, 22, 1,  6, 1}, // #1543
  {DBGFIELD("MOV16ao16_MOV16ao32_MOV16ao64") 2, false, false, false, 104, 4, 10, 1,  0, 0}, // #1544
  {DBGFIELD("PUSHFS16_PUSHFS32_PUSHGS16_PUSHGS32") 3, false, false, false, 1299, 11,  2, 1,  0, 0}, // #1545
  {DBGFIELD("MOV16ms")            3, false, false, false, 1299, 11,  2, 1,  0, 0}, // #1546
  {DBGFIELD("MOVBE32mr")          3, false, false, false, 1299, 11,  2, 1,  0, 0}, // #1547
  {DBGFIELD("MOV16rs_MOV32rs_MOV64rs") 2, false, false, false, 472, 8,  1, 1,  0, 0}, // #1548
  {DBGFIELD("SLDT16r")            2, false, false, false, 472, 8,  1, 1,  0, 0}, // #1549
  {DBGFIELD("STR16r")             2, false, false, false, 472, 8,  1, 1,  0, 0}, // #1550
  {DBGFIELD("MOV32ao16_MOV32ao32_MOV32ao64") 1, false, false, false, 55, 3,  1, 1,  0, 0}, // #1551
  {DBGFIELD("MOV64ao64")          1, false, false, false, 55, 3,  1, 1,  0, 0}, // #1552
  {DBGFIELD("MOV32o16a_MOV32o32a_MOV8o16a_MOV8o32a_MOV32o64a_MOV64o64a_MOV8o64a") 3, false, false, false, 856, 5,  1, 1,  0, 0}, // #1553
  {DBGFIELD("MOVZX32rr8_MOVZX64rr8") 1, false, false, false,  1, 2,  0, 1,  0, 0}, // #1554
  {DBGFIELD("MOVZX32rr8_NOREX")   1, false, false, false,  1, 2,  0, 1,  0, 0}, // #1555
  {DBGFIELD("MOV64ao32")          1, false, false, false, 55, 3, 10, 1,  0, 0}, // #1556
  {DBGFIELD("MOV64dr")            48, false, false, false, 2254, 15, 84, 1,  0, 0}, // #1557
  {DBGFIELD("MOV64o32a")          2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1558
  {DBGFIELD("MOV64rc")            3, false, false, false, 2269, 10,  4, 1,  0, 0}, // #1559
  {DBGFIELD("MOV64rd")            24, false, false, false, 2279, 12, 85, 1,  0, 0}, // #1560
  {DBGFIELD("MOV8ao16_MOV8ao32_MOV8ao64") 2, false, false, false, 104, 4,  1, 1,  0, 0}, // #1561
  {DBGFIELD("MOV8mi_MOV8mr")      2, false, false, false, 51, 4, 24, 1,  0, 0}, // #1562
  {DBGFIELD("MOV8mr_NOREX")       2, false, false, false, 51, 4, 24, 1,  0, 0}, // #1563
  {DBGFIELD("MOVBE32rm")          2, false, false, false, 181, 10,  3, 1,  0, 0}, // #1564
  {DBGFIELD("SLDT16m")            4, false, false, false, 1337, 13,  2, 1,  0, 0}, // #1565
  {DBGFIELD("STRm")               4, false, false, false, 1337, 13,  2, 1,  0, 0}, // #1566
  {DBGFIELD("MOVBE64rm")          3, false, false, false, 151, 12,  6, 1,  0, 0}, // #1567
  {DBGFIELD("MOVDIR64B16_MOVDIR64B32_MOVDIR64B64") 4, false, false, false, 764, 9,  1, 1,  0, 0}, // #1568
  {DBGFIELD("MOVDIRI32")          2, false, false, false, 51, 4, 25, 1,  0, 0}, // #1569
  {DBGFIELD("MOVDIRI64")          2, false, false, false, 51, 4, 86, 1,  0, 0}, // #1570
  {DBGFIELD("MOVLPDrm_MOVLPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1571
  {DBGFIELD("SHUFPDrmi_SHUFPSrmi_VSHUFPDrmi_VSHUFPSrmi") 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1572
  {DBGFIELD("MOVNTDQmr")          2, false, false, false, 51, 4, 26, 1,  0, 0}, // #1573
  {DBGFIELD("MOVNTImr")           2, false, false, false, 51, 4, 27, 1,  0, 0}, // #1574
  {DBGFIELD("MOVSB")              7, false, false, false, 923, 6,  7, 1,  0, 0}, // #1575
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1576
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32") 1, false, false, false, 55, 3,  3, 1,  0, 0}, // #1577
  {DBGFIELD("MOVSX32rm16_MOVSX32rm32_MOVSX64rm16_MOVSX64rm32_MOVSX32rm8_MOVSX64rm8") 1, false, false, false, 55, 3,  3, 1,  0, 0}, // #1578
  {DBGFIELD("MOVSX32rm8_NOREX")   1, false, false, false, 55, 3,  3, 1,  0, 0}, // #1579
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32") 1, false, false, false, 178, 3,  1, 1,  0, 0}, // #1580
  {DBGFIELD("MOVSX16rr8")         1, false, false, false, 178, 3,  1, 1,  0, 0}, // #1581
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX64rr16_MOVSX64rr8") 1, false, false, false, 178, 3,  1, 1,  0, 0}, // #1582
  {DBGFIELD("MOVSX32rr8_NOREX")   1, false, false, false, 178, 3,  1, 1,  0, 0}, // #1583
  {DBGFIELD("MUL_FPrST0_MUL_FrST0") 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #1584
  {DBGFIELD("OUT16ir")            79, false, false, false, 2291, 17, 55, 1,  0, 0}, // #1585
  {DBGFIELD("OUT16rr")            79, false, false, false, 2308, 17, 55, 1,  0, 0}, // #1586
  {DBGFIELD("OUT32ir")            85, false, false, false, 2325, 17, 55, 1,  0, 0}, // #1587
  {DBGFIELD("OUT32rr")            85, false, false, false, 2342, 17, 55, 1,  0, 0}, // #1588
  {DBGFIELD("OUTSB")              80, false, false, false, 2359, 17,  4, 1,  0, 0}, // #1589
  {DBGFIELD("OUTSL")              89, false, false, false, 2376, 17,  4, 1,  0, 0}, // #1590
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWrm_VPACKSSWBrm_VPACKUSDWrm_VPACKUSWBrm") 2, false, false, false, 526, 11,  9, 1,  6, 1}, // #1591
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWrr_VPACKSSWBrr_VPACKUSDWrr_VPACKUSWBrr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1592
  {DBGFIELD("PALIGNRrmi_VPALIGNRrmi") 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #1593
  {DBGFIELD("PALIGNRrri_VPALIGNRrri") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1594
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, false, 181, 10,  7, 1,  1, 1}, // #1595
  {DBGFIELD("PREFETCHIT0_PREFETCHIT1") 1, false, false, false, 943, 5, 10, 1,  0, 0}, // #1596
  {DBGFIELD("PREFETCHT0_PREFETCHT1_PREFETCHT2") 1, false, false, false, 55, 3,  0, 1,  0, 0}, // #1597
  {DBGFIELD("PREFETCHNTA")        1, false, false, false, 55, 3,  0, 1,  0, 0}, // #1598
  {DBGFIELD("PTWRITE64m_PTWRITEm") 4, false, false, false, 2393, 8,  4, 1,  0, 0}, // #1599
  {DBGFIELD("PTWRITE64r")         3, false, false, false, 2401, 6,  4, 1,  0, 0}, // #1600
  {DBGFIELD("PTWRITEr")           4, false, false, false, 2407, 6,  4, 1,  0, 0}, // #1601
  {DBGFIELD("PUSH64r")            2, false, false, false, 51, 4,  1, 1,  0, 0}, // #1602
  {DBGFIELD("PUSH64rmr")          2, false, false, false, 51, 4,  1, 1,  0, 0}, // #1603
  {DBGFIELD("RCL8m1_RCR8m1")      6, false, false, false, 17, 9, 58, 2,  0, 0}, // #1604
  {DBGFIELD("RCL8mi")             6, false, false, false, 17, 9, 58, 2,  0, 0}, // #1605
  {DBGFIELD("RCR8mi")             6, false, false, false, 17, 9, 58, 2,  0, 0}, // #1606
  {DBGFIELD("RCL8mCL")            11, false, false, false, 2413, 14, 87, 2,  0, 0}, // #1607
  {DBGFIELD("RCR8mCL")            12, false, false, false, 2427, 14, 87, 2,  0, 0}, // #1608
  {DBGFIELD("RDPID64")            1, false, false, false, 38, 8,  4, 1,  0, 0}, // #1609
  {DBGFIELD("RDPKRUr")            3, false, false, false, 492, 10,  4, 1,  0, 0}, // #1610
  {DBGFIELD("RDRAND16r")          25, false, false, false, 1489, 15, 89, 1,  0, 0}, // #1611
  {DBGFIELD("RDSEED16r")          25, false, false, false, 2441, 15, 90, 1,  0, 0}, // #1612
  {DBGFIELD("RDSEED32r_RDSEED64r") 25, false, false, false, 2441, 15,  4, 1,  0, 0}, // #1613
  {DBGFIELD("REX64_PREFIX")       1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1614
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi") 5, false, false, false, 773, 9, 33, 2,  0, 0}, // #1615
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROR16mCL_ROR32mCL_ROR64mCL") 5, false, false, false, 773, 9, 33, 2,  0, 0}, // #1616
  {DBGFIELD("ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16ri_ROR32ri_ROR64ri_ROR8ri") 2, false, false, false, 759, 5,  1, 1,  0, 0}, // #1617
  {DBGFIELD("ROL8m1_ROL8mi_ROR8m1_ROR8mi") 5, false, false, false, 773, 9, 58, 2,  0, 0}, // #1618
  {DBGFIELD("ROL8mCL_ROR8mCL")    5, false, false, false, 773, 9, 58, 2,  0, 0}, // #1619
  {DBGFIELD("SHL8mCL_SAR8mCL_SHR8mCL") 5, false, false, false, 773, 9, 58, 2,  0, 0}, // #1620
  {DBGFIELD("SAR8m1_SAR8mi_SHR8m1_SHR8mi_SHL8m1_SHL8mi") 4, false, false, false, 764, 9, 58, 2,  0, 0}, // #1621
  {DBGFIELD("SARX32rm_SARX64rm_SHRX32rm_SHRX64rm_SHLX32rm_SHLX64rm") 2, false, false, false, 229, 7,  7, 1,  1, 1}, // #1622
  {DBGFIELD("SARX32rr_SARX64rr_SHRX32rr_SHRX64rr_SHLX32rr_SHLX64rr") 1, false, false, false, 12, 5,  5, 1,  0, 0}, // #1623
  {DBGFIELD("SERIALIZE")          7, false, false, false, 2456, 13,  4, 1,  0, 0}, // #1624
  {DBGFIELD("SHRD16mri8")         5, false, false, false, 809, 12, 24, 1,  0, 0}, // #1625
  {DBGFIELD("SMSW16r")            2, false, false, false, 2469, 9,  1, 1,  0, 0}, // #1626
  {DBGFIELD("SMSW32r_SMSW64r")    2, false, false, false, 2469, 9,  4, 1,  0, 0}, // #1627
  {DBGFIELD("SQRTSDm_Int_VSQRTSDm_Int") 2, false, false, false, 243, 11, 41, 1,  6, 1}, // #1628
  {DBGFIELD("STI")                6, false, false, false, 2478, 10,  4, 1,  0, 0}, // #1629
  {DBGFIELD("STOSB")              4, false, false, false, 1332, 5,  7, 1,  0, 0}, // #1630
  {DBGFIELD("VBLENDVPDrmr_VBLENDVPSrmr") 4, false, false, false, 843, 6, 22, 1, 10, 2}, // #1631
  {DBGFIELD("VPBLENDVBrmr")       4, false, false, false, 843, 6, 22, 1, 10, 2}, // #1632
  {DBGFIELD("VBLENDVPDrrr_VBLENDVPSrrr") 3, false, false, false, 849, 4,  5, 1,  0, 0}, // #1633
  {DBGFIELD("VPBLENDVBrrr")       3, false, false, false, 849, 4,  5, 1,  0, 0}, // #1634
  {DBGFIELD("VERRm")              31, false, false, false, 2488, 14, 57, 1,  0, 0}, // #1635
  {DBGFIELD("VERRr")              30, false, false, false, 2502, 14, 91, 1,  0, 0}, // #1636
  {DBGFIELD("VERWr")              33, false, false, false, 2516, 14, 91, 1,  0, 0}, // #1637
  {DBGFIELD("VHADDPDrr_VHADDPSrr_VHSUBPDrr_VHSUBPSrr") 3, false, false, false, 431, 9, 10, 1,  0, 0}, // #1638
  {DBGFIELD("VLDMXCSR")           3, false, false, false, 2530, 11,  6, 1,  0, 0}, // #1639
  {DBGFIELD("VMOVMSKPDYrr_VMOVMSKPSYrr") 1, false, false, false,  3, 9, 10, 1,  0, 0}, // #1640
  {DBGFIELD("VMOVNTDQmr")         2, false, false, false, 51, 4, 92, 1,  0, 0}, // #1641
  {DBGFIELD("VMOVNTPDmr")         2, false, false, false, 51, 4, 93, 1,  0, 0}, // #1642
  {DBGFIELD("VMOVNTPSYmr")        2, false, false, false, 51, 4, 94, 1,  0, 0}, // #1643
  {DBGFIELD("VMOVNTPSmr")         2, false, false, false, 51, 4, 95, 1,  0, 0}, // #1644
  {DBGFIELD("VPACKSSDWYrm_VPACKSSWBYrm_VPACKUSDWYrm_VPACKUSWBYrm") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1645
  {DBGFIELD("VPCLMULQDQYrmi")     2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1646
  {DBGFIELD("VSHUFPDYrmi_VSHUFPSYrmi") 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1647
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1648
  {DBGFIELD("WRPKRUr")            8, false, false, false, 2541, 12,  4, 1,  0, 0}, // #1649
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm") 5, false, false, false, 1391, 6, 33, 2,  0, 0}, // #1650
  {DBGFIELD("XCHG16rm")           8, false, false, false, 1870, 9, 49, 2,  0, 0}, // #1651
  {DBGFIELD("XCHG32rm")           8, false, false, false, 1870, 9, 49, 2,  0, 0}, // #1652
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS") 31, false, false, false, 1617, 15, 62, 1,  0, 0}, // #1653
  {DBGFIELD("XSAVEC")             151, false, false, false, 2553, 17, 52, 1,  0, 0}, // #1654
  {DBGFIELD("XSAVEC64")           152, false, false, false, 2570, 17, 52, 1,  0, 0}, // #1655
  {DBGFIELD("XSAVEOPT")           155, false, false, false, 2587, 16, 66, 1,  0, 0}, // #1656
  {DBGFIELD("XSAVES")             184, false, false, false, 2603, 16, 52, 1,  0, 0}, // #1657
  {DBGFIELD("VMOVAPDZrr_VMOVAPDZrr_REV_VMOVAPSZrr_VMOVAPSZrr_REV_VMOVUPDZrr_VMOVUPDZrr_REV_VMOVUPSZrr_VMOVUPSZrr_REV") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1658
  {DBGFIELD("VMOVDQA32Z256rr_VMOVDQA32Z256rr_REV_VMOVDQA64Z256rr_VMOVDQA64Z256rr_REV_VMOVDQAYrr_VMOVDQAYrr_REV_VMOVDQUYrr_VMOVDQUYrr_REV_VMOVDQU16Z256rr_VMOVDQU16Z256rr_REV_VMOVDQU32Z256rr_VMOVDQU32Z256rr_REV_VMOVDQU64Z256rr_VMOVDQU64Z256rr_REV_VMOVDQU8Z256rr_VMOVDQU8Z256rr_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1659
  {DBGFIELD("VMOVDQA32Zrr_VMOVDQA32Zrr_REV_VMOVDQA64Zrr_VMOVDQA64Zrr_REV_VMOVDQU16Zrr_VMOVDQU16Zrr_REV_VMOVDQU32Zrr_VMOVDQU32Zrr_REV_VMOVDQU64Zrr_VMOVDQU64Zrr_REV_VMOVDQU8Zrr_VMOVDQU8Zrr_REV") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1660
  {DBGFIELD("ADDPSrm_SUBPSrm_VADDPSrm_VSUBPSrm_ADDSUBPSrm_VADDSUBPSrm_VADDPSZ128rm_VADDPSZ128rmb_VADDPSZ128rmbk_VADDPSZ128rmk_VADDPSZ128rmkz_VSUBPSZ128rm_VSUBPSZ128rmb_VSUBPSZ128rmbk_VSUBPSZ128rmk_VSUBPSZ128rmkz_VADDPSZ128rmbkz_VSUBPSZ128rmbkz") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #1661
  {DBGFIELD("ADDPSrr_SUBPSrr_VADDPSrr_VSUBPSrr_ADDSUBPSrr_VADDSUBPSrr_VADDPSZ128rr_VADDPSZ128rrk_VSUBPSZ128rr_VSUBPSZ128rrk") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1662
  {DBGFIELD("VADDPSYrr_VSUBPSYrr_VADDPSZ256rr_VADDPSZ256rrk_VSUBPSZ256rr_VSUBPSZ256rrk") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1663
  {DBGFIELD("VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1664
  {DBGFIELD("VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1665
  {DBGFIELD("VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1666
  {DBGFIELD("VPSHUFHWZ128rik_VPSHUFHWZ128rikz_VPSHUFLWZ128rik_VPSHUFLWZ128rikz_VPUNPCKHBWZ128rrk_VPUNPCKHBWZ128rrkz_VPUNPCKHWDZ128rrk_VPUNPCKHWDZ128rrkz_VPUNPCKLBWZ128rrk_VPUNPCKLBWZ128rrkz_VPUNPCKLWDZ128rrk_VPUNPCKLWDZ128rrkz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1667
  {DBGFIELD("VPSHUFHWZ256rik_VPSHUFHWZ256rikz_VPSHUFLWZ256rik_VPSHUFLWZ256rikz_VPUNPCKHBWZ256rrk_VPUNPCKHBWZ256rrkz_VPUNPCKHWDZ256rrk_VPUNPCKHWDZ256rrkz_VPUNPCKLBWZ256rrk_VPUNPCKLBWZ256rrkz_VPUNPCKLWDZ256rrk_VPUNPCKLWDZ256rrkz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1668
  {DBGFIELD("VADDSUBPSYrr")       1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1669
  {DBGFIELD("VPOPCNTBZ128rm_VPOPCNTDZ128rm_VPOPCNTQZ128rm_VPOPCNTWZ128rm_VPOPCNTDZ128rmb_VPOPCNTDZ128rmk_VPOPCNTDZ128rmkz_VPOPCNTQZ128rmb_VPOPCNTQZ128rmk_VPOPCNTQZ128rmkz_VPOPCNTDZ128rmbk_VPOPCNTDZ128rmbkz_VPOPCNTQZ128rmbk_VPOPCNTQZ128rmbkz") 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #1670
  {DBGFIELD("VFPCLASSPDZ128mbi_VFPCLASSPSZ128mbi") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1671
  {DBGFIELD("VFPCLASSPHZ128mbi")  2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1672
  {DBGFIELD("VPACKSSDWZ128rm_VPACKSSWBZ128rm_VPACKUSDWZ128rm_VPACKUSWBZ128rm_VPACKSSDWZ128rmb_VPACKUSDWZ128rmb") 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1673
  {DBGFIELD("VPMULTISHIFTQBZ128rm_VPMULTISHIFTQBZ128rmb") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1674
  {DBGFIELD("VFPCLASSPHZ128mi")   2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1675
  {DBGFIELD("VFPCLASSPDZ256mi_VFPCLASSPSZ256mi") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1676
  {DBGFIELD("VFPCLASSPDZmi_VFPCLASSPSZmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1677
  {DBGFIELD("VFPCLASSPHZ256mi")   2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1678
  {DBGFIELD("VFPCLASSPHZmi")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1679
  {DBGFIELD("VPERMBZ128rm")       2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1680
  {DBGFIELD("VPEXPANDBZ128rmk_VPEXPANDBZ128rmkz_VPEXPANDBZ256rmk_VPEXPANDBZ256rmkz_VPEXPANDWZ128rmk_VPEXPANDWZ128rmkz_VPEXPANDWZ256rmk_VPEXPANDWZ256rmkz_VPEXPANDBZrmk_VPEXPANDBZrmkz_VPEXPANDWZrmk_VPEXPANDWZrmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1681
  {DBGFIELD("ADD_FPrST0_ADD_FrST0_SUBR_FPrST0_SUBR_FrST0_SUB_FPrST0_SUB_FrST0_SUBR_FST0r_SUB_FST0r") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1682
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVWkr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1683
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256ri_VFPCLASSPDZ256rik_VFPCLASSPSZ256ri_VFPCLASSPSZ256rik") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1684
  {DBGFIELD("VCMPPHZ128rri_VCMPPHZ128rrik_VFPCLASSPHZ128ri_VFPCLASSPHZ128rik") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1685
  {DBGFIELD("VCMPPHZ256rri_VCMPPHZ256rrik_VFPCLASSPHZ256ri_VFPCLASSPHZ256rik") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1686
  {DBGFIELD("VCMPSDZrri_VCMPSSZrri_VCMPSDZrri_Int_VCMPSDZrrik_Int_VCMPSSZrri_Int_VCMPSSZrrik_Int_VFPCLASSSDZri_VFPCLASSSDZrik_VFPCLASSSSZri_VFPCLASSSSZrik") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1687
  {DBGFIELD("VCMPSHZrri_VCMPSHZrri_Int_VCMPSHZrrik_Int_VFPCLASSSHZri_VFPCLASSSHZrik") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1688
  {DBGFIELD("VPACKSSDWZ128rr_VPACKSSWBZ128rr_VPACKUSDWZ128rr_VPACKUSWBZ128rr") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1689
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSWBZ256rr_VPACKUSDWZ256rr_VPACKUSWBZ256rr") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1690
  {DBGFIELD("VPALIGNRZ128rrik_VPALIGNRZ128rrikz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1691
  {DBGFIELD("VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1692
  {DBGFIELD("VPBROADCASTBZ128rrk_VPBROADCASTBZ128rrkz_VPBROADCASTWZ128rrk_VPBROADCASTWZ128rrkz") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1693
  {DBGFIELD("VPERMBZ128rr")       1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1694
  {DBGFIELD("VPERMBZ256rr_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMI2DZ256rr_VPERMI2DZ256rrk_VPERMI2DZ256rrkz_VPERMI2QZ256rr_VPERMI2QZ256rrk_VPERMI2QZ256rrkz_VPERMT2DZ256rr_VPERMT2DZ256rrk_VPERMT2DZ256rrkz_VPERMT2QZ256rr_VPERMT2QZ256rrk_VPERMT2QZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1695
  {DBGFIELD("VPERMBZrr_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMI2DZrr_VPERMI2DZrrk_VPERMI2DZrrkz_VPERMI2QZrr_VPERMI2QZrrk_VPERMI2QZrrkz_VPERMT2DZrr_VPERMT2DZrrk_VPERMT2DZrrkz_VPERMT2QZrr_VPERMT2QZrrk_VPERMT2QZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1696
  {DBGFIELD("VPERMQZrr_VPERMQZrrk_VPERMQZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1697
  {DBGFIELD("VPERMI2DZ128rr_VPERMI2DZ128rrk_VPERMI2DZ128rrkz_VPERMI2QZ128rr_VPERMI2QZ128rrk_VPERMI2QZ128rrkz_VPERMT2DZ128rr_VPERMT2DZ128rrk_VPERMT2DZ128rrkz_VPERMT2QZ128rr_VPERMT2QZ128rrk_VPERMT2QZ128rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1698
  {DBGFIELD("VPMULTISHIFTQBZ128rr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1699
  {DBGFIELD("VPMULTISHIFTQBZ256rr_VPOPCNTBZ256rr_VPOPCNTDZ256rr_VPOPCNTQZ256rr_VPOPCNTWZ256rr_VPOPCNTDZ256rrk_VPOPCNTDZ256rrkz_VPOPCNTQZ256rrk_VPOPCNTQZ256rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1700
  {DBGFIELD("VPOPCNTBZ128rr_VPOPCNTDZ128rr_VPOPCNTQZ128rr_VPOPCNTWZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1701
  {DBGFIELD("VMOVSHDUPZ128rr_VMOVSHDUPZ128rrk_VMOVSHDUPZ128rrkz_VMOVSLDUPZ128rr_VMOVSLDUPZ128rrk_VMOVSLDUPZ128rrkz_VSHUFPDZ128rri_VSHUFPDZ128rrik_VSHUFPDZ128rrikz_VSHUFPSZ128rri_VSHUFPSZ128rrik_VSHUFPSZ128rrikz") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1702
  {DBGFIELD("VMOVSHDUPZ256rr_VMOVSHDUPZ256rrk_VMOVSHDUPZ256rrkz_VMOVSLDUPZ256rr_VMOVSLDUPZ256rrk_VMOVSLDUPZ256rrkz_VSHUFPDZ256rri_VSHUFPDZ256rrik_VSHUFPDZ256rrikz_VSHUFPSZ256rri_VSHUFPSZ256rrik_VSHUFPSZ256rrikz") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1703
  {DBGFIELD("VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1704
  {DBGFIELD("VCVTPD2DQZ128rm_VCVTPD2DQZ128rmb_VCVTPD2DQZ128rmbk_VCVTPD2DQZ128rmk_VCVTPD2DQZ128rmkz_VCVTPD2UDQZ128rm_VCVTPD2UDQZ128rmb_VCVTPD2UDQZ128rmbk_VCVTPD2UDQZ128rmk_VCVTPD2UDQZ128rmkz_VCVTTPD2DQZ128rm_VCVTTPD2DQZ128rmb_VCVTTPD2DQZ128rmbk_VCVTTPD2DQZ128rmk_VCVTTPD2DQZ128rmkz_VCVTTPD2UDQZ128rm_VCVTTPD2UDQZ128rmb_VCVTTPD2UDQZ128rmbk_VCVTTPD2UDQZ128rmk_VCVTTPD2UDQZ128rmkz_VCVTPD2DQZ128rmbkz_VCVTPD2UDQZ128rmbkz_VCVTTPD2DQZ128rmbkz_VCVTTPD2UDQZ128rmbkz") 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #1705
  {DBGFIELD("VCVTPH2PSXZ128rm_VCVTPH2PSXZ128rmb") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1706
  {DBGFIELD("VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz_VCVTQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmbkz") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1707
  {DBGFIELD("VCVTSI642SSZrm_VCVTSI642SSZrm_Int_VCVTUSI642SSZrm_VCVTUSI642SSZrm_Int") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1708
  {DBGFIELD("VCVTSD2SIZrm_VCVTTSD2SIZrm_VCVTSD2SIZrm_Int_VCVTTSD2SIZrm_Int") 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #1709
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_Int") 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #1710
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1711
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1712
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_Int_VCVTSI2SSZrr_VCVTUSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 254, 10,  6, 1,  7, 1}, // #1713
  {DBGFIELD("VCVTSS2SI64Zrr_VCVTTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 287, 9,  6, 1,  0, 0}, // #1714
  {DBGFIELD("DIVSDrm_VDIVSDrm")   2, false, false, false, 243, 11, 17, 1,  6, 1}, // #1715
  {DBGFIELD("VDIVSDZrm")          2, false, false, false, 243, 11, 17, 1,  6, 1}, // #1716
  {DBGFIELD("VSQRTSHZm_Int_VSQRTSHZmk_Int_VSQRTSHZmkz_Int") 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #1717
  {DBGFIELD("VSQRTSHZm")          2, false, false, false, 243, 11, 17, 1,  6, 1}, // #1718
  {DBGFIELD("ENQCMD16_ENQCMD32_ENQCMD64_ENQCMDS16_ENQCMDS32_ENQCMDS64") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1719
  {DBGFIELD("VPMOVQDZ256mr_VPMOVQDZmr") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1720
  {DBGFIELD("VPERMWZrr")          1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1721
  {DBGFIELD("VPEXPANDBZ256rm_VPEXPANDBZrm_VPEXPANDWZ256rm_VPEXPANDWZrm") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1722
  {DBGFIELD("VPADDBZrr_VPADDDZrr_VPADDQZrr_VPADDWZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrrk_VPADDQZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1723
  {DBGFIELD("VPLZCNTDZ256rm_VPLZCNTDZ256rmb_VPLZCNTDZ256rmbk_VPLZCNTDZ256rmk_VPLZCNTDZ256rmkz_VPLZCNTQZ256rm_VPLZCNTQZ256rmb_VPLZCNTQZ256rmbk_VPLZCNTQZ256rmk_VPLZCNTQZ256rmkz_VPLZCNTDZ256rmbkz_VPLZCNTQZ256rmbkz") 2, false, false, false, 101, 7, 24, 1,  0, 0}, // #1724
  {DBGFIELD("VADDPHZ128rm_VADDPHZ128rmb_VADDPHZ128rmbk_VADDPHZ128rmk_VADDPHZ128rmkz_VSUBPHZ128rm_VSUBPHZ128rmb_VSUBPHZ128rmbk_VSUBPHZ128rmk_VSUBPHZ128rmkz_VADDPHZ128rmbkz_VSUBPHZ128rmbkz") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #1725
  {DBGFIELD("VGETEXPPHZ128m_VGETEXPPHZ128mb_VGETEXPPHZ128mbk_VGETEXPPHZ128mk_VGETEXPPHZ128mkz_VGETEXPSHZm_VGETEXPSHZmk_VGETEXPSHZmkz_VGETMANTPHZ128rmbi_VGETMANTPHZ128rmik_VGETMANTPHZ128rmbik_VGETMANTPHZ128rmbikz_VGETMANTPHZ128rmi_VGETMANTPHZ128rmikz_VGETMANTSHZrmi_VGETMANTSHZrmik_VGETMANTSHZrmikz") 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #1726
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rmbi_VGF2P8AFFINEINVQBZ128rmi_VGF2P8AFFINEQBZ128rmbi_VGF2P8AFFINEQBZ128rmi") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #1727
  {DBGFIELD("VMAXCPHZ128rm_VMAXCPHZ128rmb_VMAXCPHZ128rmbk_VMAXCPHZ128rmk_VMAXCPHZ128rmkz_VMINCPHZ128rm_VMINCPHZ128rmb_VMINCPHZ128rmbk_VMINCPHZ128rmk_VMINCPHZ128rmkz_VMAXCPHZ128rmbkz_VMINCPHZ128rmbkz_VMAXPHZ128rm_VMAXPHZ128rmb_VMAXPHZ128rmbk_VMAXPHZ128rmk_VMAXPHZ128rmkz_VMINPHZ128rm_VMINPHZ128rmb_VMINPHZ128rmbk_VMINPHZ128rmk_VMINPHZ128rmkz_VMAXPHZ128rmbkz_VMINPHZ128rmbkz") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1728
  {DBGFIELD("VMULPHZ128rm_VMULPHZ128rmb_VMULPHZ128rmbk_VMULPHZ128rmk_VMULPHZ128rmkz_VMULPHZ128rmbkz") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1729
  {DBGFIELD("VGETEXPPHZ128mbkz")  3, false, false, false, 113, 7, 11, 1,  6, 1}, // #1730
  {DBGFIELD("VGF2P8MULBZ128rm")   2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1731
  {DBGFIELD("VADDSHZrm_VSUBSHZrm_VADDSHZrm_Int_VADDSHZrmk_Int_VADDSHZrmkz_Int_VSUBSHZrm_Int_VSUBSHZrmk_Int_VSUBSHZrmkz_Int") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #1732
  {DBGFIELD("VCVTSH2SSZrm_VCVTSH2SSZrm_Int") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1733
  {DBGFIELD("VMAXCSHZrm_VMINCSHZrm_VMAXSHZrm_VMINSHZrm_VMAXSHZrm_Int_VMAXSHZrmk_Int_VMAXSHZrmkz_Int_VMINSHZrm_Int_VMINSHZrmk_Int_VMINSHZrmkz_Int") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1734
  {DBGFIELD("VMULSHZrm_VMULSHZrm_Int_VMULSHZrmk_Int_VMULSHZrmkz_Int") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1735
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rmbi_VGF2P8AFFINEINVQBZ256rmi_VGF2P8AFFINEQBZ256rmbi_VGF2P8AFFINEQBZ256rmi") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #1736
  {DBGFIELD("VGF2P8MULBZ256rm")   2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1737
  {DBGFIELD("VFMADD132PHZ128m_VFMADD132PHZ128mb_VFMADD132PHZ128mbk_VFMADD132PHZ128mk_VFMADD132PHZ128mkz_VFMADD213PHZ128m_VFMADD213PHZ128mb_VFMADD213PHZ128mbk_VFMADD213PHZ128mk_VFMADD213PHZ128mkz_VFMADD231PHZ128m_VFMADD231PHZ128mb_VFMADD231PHZ128mbk_VFMADD231PHZ128mk_VFMADD231PHZ128mkz_VFMSUB132PHZ128m_VFMSUB132PHZ128mb_VFMSUB132PHZ128mbk_VFMSUB132PHZ128mk_VFMSUB132PHZ128mkz_VFMSUB213PHZ128m_VFMSUB213PHZ128mb_VFMSUB213PHZ128mbk_VFMSUB213PHZ128mk_VFMSUB213PHZ128mkz_VFMSUB231PHZ128m_VFMSUB231PHZ128mb_VFMSUB231PHZ128mbk_VFMSUB231PHZ128mk_VFMSUB231PHZ128mkz_VFNMADD132PHZ128m_VFNMADD132PHZ128mb_VFNMADD132PHZ128mbk_VFNMADD132PHZ128mk_VFNMADD132PHZ128mkz_VFNMADD213PHZ128m_VFNMADD213PHZ128mb_VFNMADD213PHZ128mbk_VFNMADD213PHZ128mk_VFNMADD213PHZ128mkz_VFNMADD231PHZ128m_VFNMADD231PHZ128mb_VFNMADD231PHZ128mbk_VFNMADD231PHZ128mk_VFNMADD231PHZ128mkz_VFNMSUB132PHZ128m_VFNMSUB132PHZ128mb_VFNMSUB132PHZ128mbk_VFNMSUB132PHZ128mk_VFNMSUB132PHZ128mkz_VFNMSUB213PHZ128m_VFNMSUB213PHZ128mb_VFNMSUB213PHZ128mbk_VFNMSUB213PHZ128mk_VFNMSUB213PHZ128mkz_VFNMSUB231PHZ128m_VFNMSUB231PHZ128mb_VFNMSUB231PHZ128mbk_VFNMSUB231PHZ128mk_VFNMSUB231PHZ128mkz_VFMADD132PHZ128mbkz_VFMADD213PHZ128mbkz_VFMADD231PHZ128mbkz_VFMSUB132PHZ128mbkz_VFMSUB213PHZ128mbkz_VFMSUB231PHZ128mbkz_VFNMADD132PHZ128mbkz_VFNMADD213PHZ128mbkz_VFNMADD231PHZ128mbkz_VFNMSUB132PHZ128mbkz_VFNMSUB213PHZ128mbkz_VFNMSUB231PHZ128mbkz_VFMADDSUB132PHZ128m_VFMADDSUB132PHZ128mb_VFMADDSUB132PHZ128mbk_VFMADDSUB132PHZ128mk_VFMADDSUB132PHZ128mkz_VFMADDSUB213PHZ128m_VFMADDSUB213PHZ128mb_VFMADDSUB213PHZ128mbk_VFMADDSUB213PHZ128mk_VFMADDSUB213PHZ128mkz_VFMADDSUB231PHZ128m_VFMADDSUB231PHZ128mb_VFMADDSUB231PHZ128mbk_VFMADDSUB231PHZ128mk_VFMADDSUB231PHZ128mkz_VFMADDSUB132PHZ128mbkz_VFMADDSUB213PHZ128mbkz_VFMADDSUB231PHZ128mbkz_VFMSUBADD132PHZ128m_VFMSUBADD132PHZ128mb_VFMSUBADD132PHZ128mbk_VFMSUBADD132PHZ128mk_VFMSUBADD132PHZ128mkz_VFMSUBADD213PHZ128m_VFMSUBADD213PHZ128mb_VFMSUBADD213PHZ128mbk_VFMSUBADD213PHZ128mk_VFMSUBADD213PHZ128mkz_VFMSUBADD231PHZ128m_VFMSUBADD231PHZ128mb_VFMSUBADD231PHZ128mbk_VFMSUBADD231PHZ128mk_VFMSUBADD231PHZ128mkz_VFMSUBADD132PHZ128mbkz_VFMSUBADD213PHZ128mbkz_VFMSUBADD231PHZ128mbkz") 2, false, false, false, 101, 7,  8, 1, 10, 2}, // #1738
  {DBGFIELD("VFMADD132SHZm_VFMADD213SHZm_VFMADD231SHZm_VFMSUB132SHZm_VFMSUB213SHZm_VFMSUB231SHZm_VFNMADD132SHZm_VFNMADD213SHZm_VFNMADD231SHZm_VFNMSUB132SHZm_VFNMSUB213SHZm_VFNMSUB231SHZm_VFMADD132SHZm_Int_VFMADD132SHZmk_Int_VFMADD132SHZmkz_Int_VFMADD213SHZm_Int_VFMADD213SHZmk_Int_VFMADD213SHZmkz_Int_VFMADD231SHZm_Int_VFMADD231SHZmk_Int_VFMADD231SHZmkz_Int_VFMSUB132SHZm_Int_VFMSUB132SHZmk_Int_VFMSUB132SHZmkz_Int_VFMSUB213SHZm_Int_VFMSUB213SHZmk_Int_VFMSUB213SHZmkz_Int_VFMSUB231SHZm_Int_VFMSUB231SHZmk_Int_VFMSUB231SHZmkz_Int_VFNMADD132SHZm_Int_VFNMADD132SHZmk_Int_VFNMADD132SHZmkz_Int_VFNMADD213SHZm_Int_VFNMADD213SHZmk_Int_VFNMADD213SHZmkz_Int_VFNMADD231SHZm_Int_VFNMADD231SHZmk_Int_VFNMADD231SHZmkz_Int_VFNMSUB132SHZm_Int_VFNMSUB132SHZmk_Int_VFNMSUB132SHZmkz_Int_VFNMSUB213SHZm_Int_VFNMSUB213SHZmk_Int_VFNMSUB213SHZmkz_Int_VFNMSUB231SHZm_Int_VFNMSUB231SHZmk_Int_VFNMSUB231SHZmkz_Int") 2, false, false, false, 101, 7,  8, 1, 10, 2}, // #1739
  {DBGFIELD("VPMADD52HUQZ256m_VPMADD52HUQZ256mb_VPMADD52HUQZ256mbk_VPMADD52HUQZ256mk_VPMADD52HUQZ256mkz_VPMADD52LUQZ256m_VPMADD52LUQZ256mb_VPMADD52LUQZ256mbk_VPMADD52LUQZ256mk_VPMADD52LUQZ256mkz_VPMADD52HUQZ256mbkz_VPMADD52LUQZ256mbkz") 2, false, false, false, 101, 7, 24, 1, 10, 2}, // #1740
  {DBGFIELD("VADDPHZ128rr_VSUBPHZ128rr") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1741
  {DBGFIELD("VADDPHZ256rr_VSUBPHZ256rr") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1742
  {DBGFIELD("VADDSHZrr_VSUBSHZrr_VADDSHZrr_Int_VADDSHZrrb_Int_VSUBSHZrr_Int_VSUBSHZrrb_Int") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1743
  {DBGFIELD("VCVTPH2UWZ128rr_VCVTPH2WZ128rr_VCVTTPH2UWZ128rr_VCVTTPH2WZ128rr_VCVTUW2PHZ128rr_VCVTW2PHZ128rr") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1744
  {DBGFIELD("VCVTPH2UWZ256rr_VCVTPH2WZ256rr_VCVTTPH2UWZ256rr_VCVTTPH2WZ256rr_VCVTUW2PHZ256rr_VCVTW2PHZ256rr") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1745
  {DBGFIELD("VCVTSH2SSZrr_Int_VCVTSH2SSZrrb_Int") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1746
  {DBGFIELD("VFMADD132PHZ128r_VFMADD213PHZ128r_VFMADD231PHZ128r_VFMSUB132PHZ128r_VFMSUB213PHZ128r_VFMSUB231PHZ128r_VFNMADD132PHZ128r_VFNMADD213PHZ128r_VFNMADD231PHZ128r_VFNMSUB132PHZ128r_VFNMSUB213PHZ128r_VFNMSUB231PHZ128r_VFMADDSUB132PHZ128r_VFMADDSUB213PHZ128r_VFMADDSUB231PHZ128r_VFMSUBADD132PHZ128r_VFMSUBADD213PHZ128r_VFMSUBADD231PHZ128r") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1747
  {DBGFIELD("VFMADD132PHZ256r_VFMADD213PHZ256r_VFMADD231PHZ256r_VFMSUB132PHZ256r_VFMSUB213PHZ256r_VFMSUB231PHZ256r_VFNMADD132PHZ256r_VFNMADD213PHZ256r_VFNMADD231PHZ256r_VFNMSUB132PHZ256r_VFNMSUB213PHZ256r_VFNMSUB231PHZ256r_VFMADDSUB132PHZ256r_VFMADDSUB213PHZ256r_VFMADDSUB231PHZ256r_VFMSUBADD132PHZ256r_VFMSUBADD213PHZ256r_VFMSUBADD231PHZ256r") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1748
  {DBGFIELD("VFMADD132SHZr_VFMADD132SHZr_Int_VFMADD132SHZrb_VFMADD132SHZrb_Int_VFMADD213SHZr_VFMADD213SHZr_Int_VFMADD213SHZrb_VFMADD213SHZrb_Int_VFMADD231SHZr_VFMADD231SHZr_Int_VFMADD231SHZrb_VFMADD231SHZrb_Int_VFMSUB132SHZr_VFMSUB132SHZr_Int_VFMSUB132SHZrb_VFMSUB132SHZrb_Int_VFMSUB213SHZr_VFMSUB213SHZr_Int_VFMSUB213SHZrb_VFMSUB213SHZrb_Int_VFMSUB231SHZr_VFMSUB231SHZr_Int_VFMSUB231SHZrb_VFMSUB231SHZrb_Int_VFNMADD132SHZr_VFNMADD132SHZr_Int_VFNMADD132SHZrb_VFNMADD132SHZrb_Int_VFNMADD213SHZr_VFNMADD213SHZr_Int_VFNMADD213SHZrb_VFNMADD213SHZrb_Int_VFNMADD231SHZr_VFNMADD231SHZr_Int_VFNMADD231SHZrb_VFNMADD231SHZrb_Int_VFNMSUB132SHZr_VFNMSUB132SHZr_Int_VFNMSUB132SHZrb_VFNMSUB132SHZrb_Int_VFNMSUB213SHZr_VFNMSUB213SHZr_Int_VFNMSUB213SHZrb_VFNMSUB213SHZrb_Int_VFNMSUB231SHZr_VFNMSUB231SHZr_Int_VFNMSUB231SHZrb_VFNMSUB231SHZrb_Int") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1749
  {DBGFIELD("VGETEXPPHZ128r_VGETEXPSHZr_VGETEXPSHZrb_VGETMANTPHZ128rri_VGETMANTSHZrri_VGETMANTSHZrrib") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1750
  {DBGFIELD("VGETEXPPHZ256r_VGETMANTPHZ256rri") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1751
  {DBGFIELD("VGF2P8MULBZ128rr")   1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1752
  {DBGFIELD("VGF2P8MULBZ256rr")   1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1753
  {DBGFIELD("VMAXCPHZ128rr_VMINCPHZ128rr_VMAXPHZ128rr_VMINPHZ128rr") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1754
  {DBGFIELD("VMAXCPHZ256rr_VMINCPHZ256rr_VMAXPHZ256rr_VMINPHZ256rr") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1755
  {DBGFIELD("VMAXCSHZrr_VMINCSHZrr_VMAXSHZrr_VMINSHZrr_VMAXSHZrr_Int_VMAXSHZrrb_Int_VMINSHZrr_Int_VMINSHZrrb_Int") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1756
  {DBGFIELD("VMULPHZ128rr")       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1757
  {DBGFIELD("VMULPHZ256rr")       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1758
  {DBGFIELD("VMULSHZrr_VMULSHZrr_Int_VMULSHZrrb_Int") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1759
  {DBGFIELD("VCVTSH2SSZrr")       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1760
  {DBGFIELD("VBROADCASTSSZ128rm") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1761
  {DBGFIELD("VMOVDDUPZ128rm_VMOVSHDUPZ128rm_VMOVSLDUPZ128rm") 2, false, false, false, 526, 11,  7, 1,  0, 0}, // #1762
  {DBGFIELD("VPBROADCASTDZ128rm_VPBROADCASTQZ128rm") 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1763
  {DBGFIELD("VBROADCASTI32X2Z128rm") 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1764
  {DBGFIELD("KANDBkk_KANDDkk_KANDNDkk_KANDNQkk_KANDNWkk_KANDQkk_KANDWkk_KNOTBkk_KNOTDkk_KNOTQkk_KNOTWkk_KORBkk_KORDkk_KORQkk_KORWkk_KXNORBkk_KXNORDkk_KXNORQkk_KXNORWkk_KXORBkk_KXORDkk_KXORQkk_KXORWkk") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1765
  {DBGFIELD("VPABSBZrr_VPSUBSBZrr_VPABSDZrr_VPABSQZrr_VPABSWZrr_VPABSDZrrk_VPABSDZrrkz_VPABSQZrrk_VPABSQZrrkz_VPADDSBZrr_VPADDSWZrr_VPADDUSBZrr_VPADDUSWZrr_VPAVGBZrr_VPAVGWZrr_VPMAXSBZrr_VPMAXUDZrr_VPMAXUWZrr_VPMINSBZrr_VPMINUDZrr_VPMINUWZrr_VPMAXSDZrr_VPMAXUBZrr_VPMINSDZrr_VPMINUBZrr_VPMAXSDZrrk_VPMAXSDZrrkz_VPMAXUDZrrk_VPMAXUDZrrkz_VPMINSDZrrk_VPMINSDZrrkz_VPMINUDZrrk_VPMINUDZrrkz_VPMAXSWZrr_VPMINSWZrr_VPSUBSWZrr_VPSUBUSWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1766
  {DBGFIELD("VPSHLDDZrri_VPSHLDQZrri_VPSHLDWZrri_VPSHRDDZrri_VPSHRDQZrri_VPSHRDWZrri_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1767
  {DBGFIELD("VPSHLDVDZr_VPSHLDVQZr_VPSHLDVWZr_VPSHRDVDZr_VPSHRDVQZr_VPSHRDVWZr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1768
  {DBGFIELD("VPSUBUSBZrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1769
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 55, 3, 10, 1,  0, 0}, // #1770
  {DBGFIELD("KMOVBmk")            2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1771
  {DBGFIELD("VBROADCASTSSZ128rr_VBROADCASTSSZ128rrk_VBROADCASTSSZ128rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1772
  {DBGFIELD("VPALIGNRZrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1773
  {DBGFIELD("VPSHUFDZri_VPSHUFHWZri_VPSHUFLWZri_VPSHUFDZrik_VPSHUFDZrikz_VPUNPCKHBWZrr_VPUNPCKHWDZrr_VPUNPCKLBWZrr_VPUNPCKLWDZrr_VPUNPCKHDQZrr_VPUNPCKHDQZrrk_VPUNPCKHDQZrrkz_VPUNPCKLDQZrr_VPUNPCKLDQZrrk_VPUNPCKLDQZrrkz_VPUNPCKLQDQZrr_VPUNPCKLQDQZrrk_VPUNPCKLQDQZrrkz_VPUNPCKHQDQZrr_VPUNPCKHQDQZrrk_VPUNPCKHQDQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1774
  {DBGFIELD("VPSHUFBZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1775
  {DBGFIELD("VPABSBZrrk_VPABSBZrrkz_VPABSWZrrk_VPABSWZrrkz_VPSUBSBZrrk_VPSUBSBZrrkz_VPSUBSWZrrk_VPSUBSWZrrkz_VPADDSBZrrk_VPADDSBZrrkz_VPADDSWZrrk_VPADDSWZrrkz_VPADDUSBZrrk_VPADDUSBZrrkz_VPADDUSWZrrk_VPADDUSWZrrkz_VPAVGBZrrk_VPAVGBZrrkz_VPAVGWZrrk_VPAVGWZrrkz_VPMAXSBZrrk_VPMAXSBZrrkz_VPMAXUWZrrk_VPMAXUWZrrkz_VPMINSBZrrk_VPMINSBZrrkz_VPMINUWZrrk_VPMINUWZrrkz_VPMAXSWZrrk_VPMAXSWZrrkz_VPMAXUBZrrk_VPMAXUBZrrkz_VPMINSWZrrk_VPMINSWZrrkz_VPMINUBZrrk_VPMINUBZrrkz_VPSUBUSBZrrk_VPSUBUSBZrrkz_VPSUBUSWZrrk_VPSUBUSWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1776
  {DBGFIELD("VPSHLDVWZrk_VPSHLDVWZrkz_VPSHRDVWZrk_VPSHRDVWZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1777
  {DBGFIELD("VPSLLVWZrrk_VPSLLVWZrrkz_VPSRLVWZrrk_VPSRLVWZrrkz_VPSRAVWZrrk_VPSRAVWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1778
  {DBGFIELD("VPSLLWZrik_VPSLLWZrikz_VPSRLWZrik_VPSRLWZrikz_VPSRAWZrik_VPSRAWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1779
  {DBGFIELD("VMOVSDto64Zrr")      1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1780
  {DBGFIELD("VCVTPH2DQZ128rr_VCVTPH2UDQZ128rr_VCVTTPH2DQZ128rr_VCVTTPH2UDQZ128rr") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1781
  {DBGFIELD("VCVTPH2DQZ256rr_VCVTPH2UDQZ256rr_VCVTTPH2DQZ256rr_VCVTTPH2UDQZ256rr") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1782
  {DBGFIELD("VCVTPH2PSXZ256rr")   2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1783
  {DBGFIELD("VCVTPS2PHXZ256rr")   2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1784
  {DBGFIELD("VCVTPH2PSXZ128rr")   2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1785
  {DBGFIELD("VCVTPS2PHXZ128rr")   2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1786
  {DBGFIELD("VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1787
  {DBGFIELD("VPERMWZ256rrk_VPERMWZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1788
  {DBGFIELD("VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRLWZ256rrk_VPSRLWZ256rrkz_VPSRAWZ256rrk_VPSRAWZ256rrkz") 2, false, false, false, 254, 10, 14, 1,  0, 0}, // #1789
  {DBGFIELD("VMOVSHZmr_VMOVWmr")  2, false, false, false, 51, 4,  2, 1,  0, 0}, // #1790
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTI32X2Z256rm_VBROADCASTF32X2Zrm_VBROADCASTI32X2Zrm_VPBROADCASTQZrm_VPBROADCASTDZ256rm_VPBROADCASTQZ256rm_VPBROADCASTDZrm") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1791
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTI32X4Z256rm_VBROADCASTF32X8Zrm_VBROADCASTI32X8Zrm_VBROADCASTF32X4Zrm_VBROADCASTF64X4Zrm_VBROADCASTI32X4Zrm_VBROADCASTI64X4Zrm_VBROADCASTF64X2Z256rm_VBROADCASTF64X2Zrm_VBROADCASTI64X2Z256rm_VBROADCASTI64X2Zrm") 2, false, false, false, 78, 8, 22, 1,  0, 0}, // #1792
  {DBGFIELD("VBROADCASTSSZrm_VBROADCASTSDZ256rm_VBROADCASTSSZ256rm_VBROADCASTSDZrm") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1793
  {DBGFIELD("VMOVDDUPZrm_VMOVSHDUPZrm_VMOVSLDUPZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1794
  {DBGFIELD("VMOVDDUPZ256rm_VMOVSHDUPZ256rm_VMOVSLDUPZ256rm") 2, false, false, false, 526, 11, 22, 1,  0, 0}, // #1795
  {DBGFIELD("VPMOVDBZrr_VPMOVQBZrr_VPMOVSQBZrr_VPMOVSWBZrr_VPMOVWBZrr_VPMOVDWZrr_VPMOVQWZrr_VPMOVSDWZrr_VPMOVSQWZrr_VPMOVUSDWZrr_VPMOVSDBZrr_VPMOVSQDZrr_VPMOVUSDBZrr_VPMOVUSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSQBZrr_VPMOVUSWBZrr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1796
  {DBGFIELD("VPMOVUSQWZrr")       1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1797
  {DBGFIELD("VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1798
  {DBGFIELD("VBROADCASTF32X8Zrmk_VBROADCASTF32X8Zrmkz_VBROADCASTI32X8Zrmk_VBROADCASTI32X8Zrmkz_VBROADCASTF32X4Zrmk_VBROADCASTF32X4Zrmkz_VBROADCASTF64X4Zrmk_VBROADCASTF64X4Zrmkz_VBROADCASTI32X4Zrmk_VBROADCASTI32X4Zrmkz_VBROADCASTI64X4Zrmk_VBROADCASTI64X4Zrmkz_VBROADCASTF64X2Zrmk_VBROADCASTF64X2Zrmkz_VBROADCASTI64X2Zrmk_VBROADCASTI64X2Zrmkz") 2, false, false, false, 78, 8, 22, 1,  0, 0}, // #1799
  {DBGFIELD("VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1800
  {DBGFIELD("VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #1801
  {DBGFIELD("VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Zrmk_VMOVDQU64Zrmkz") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #1802
  {DBGFIELD("VINSERTF32X4Zrmi_VINSERTF32X4Zrmik_VINSERTF32X4Zrmikz_VINSERTF64X4Zrmi_VINSERTF64X4Zrmik_VINSERTF64X4Zrmikz_VINSERTF32X8Zrmi_VINSERTF32X8Zrmik_VINSERTF32X8Zrmikz_VINSERTF64X2Zrmi_VINSERTF64X2Zrmik_VINSERTF64X2Zrmikz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1803
  {DBGFIELD("VINSERTI32X4Zrmi_VINSERTI32X4Zrmik_VINSERTI32X4Zrmikz_VINSERTI64X4Zrmi_VINSERTI64X4Zrmik_VINSERTI64X4Zrmikz_VINSERTI32X8Zrmi_VINSERTI32X8Zrmik_VINSERTI32X8Zrmikz_VINSERTI64X2Zrmi_VINSERTI64X2Zrmik_VINSERTI64X2Zrmikz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1804
  {DBGFIELD("VPADDBZrm_VPADDDZrm_VPADDQZrm_VPADDWZrm_VPSUBBZrm_VPSUBDZrm_VPSUBQZrm_VPSUBWZrm_VPADDDZrmb_VPADDDZrmk_VPADDDZrmkz_VPADDQZrmb_VPADDQZrmk_VPADDQZrmkz_VPSUBDZrmb_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrmb_VPSUBQZrmk_VPSUBQZrmkz_VPADDDZrmbk_VPADDDZrmbkz_VPADDQZrmbk_VPADDQZrmbkz_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBQZrmbk_VPSUBQZrmbkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmik_VPTERNLOGQZrmbi_VPTERNLOGQZrmik_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmikz_VPTERNLOGQZrmi_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1805
  {DBGFIELD("VPBROADCASTWZrm_VPBROADCASTBZ256rm_VPBROADCASTWZ256rm_VPBROADCASTBZrm") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1806
  {DBGFIELD("VFPCLASSPDZ128mi_VFPCLASSPSZ128mi") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1807
  {DBGFIELD("VFPCLASSSDZmi_VFPCLASSSSZmi") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1808
  {DBGFIELD("VFPCLASSSHZmi")      2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1809
  {DBGFIELD("VPALIGNRZ256rmi")    2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1810
  {DBGFIELD("VPSHUFBZrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1811
  {DBGFIELD("MOV16ri_MOV64ri_MOV8ri_MOV16ri_alt_MOV8ri_alt_MOV16rr_MOV16rr_REV_MOV8rr_MOV8rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1812
  {DBGFIELD("MOV32ri_MOV32ri_alt") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1813
  {DBGFIELD("MOV8rr_NOREX")       1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1814
  {DBGFIELD("VMOVLPDZ128rm_VMOVLPSZ128rm_VSHUFPDZ128rmbi_VSHUFPDZ128rmik_VSHUFPSZ128rmbi_VSHUFPSZ128rmik_VSHUFPDZ128rmbik_VSHUFPDZ128rmbikz_VSHUFPSZ128rmbik_VSHUFPSZ128rmbikz_VSHUFPDZ128rmi_VSHUFPDZ128rmikz_VSHUFPSZ128rmi_VSHUFPSZ128rmikz") 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #1815
  {DBGFIELD("VMOVAPDZ128rrk_VMOVAPDZ128rrk_REV_VMOVAPDZ128rrkz_VMOVAPDZ128rrkz_REV_VMOVAPSZ128rrk_VMOVAPSZ128rrk_REV_VMOVAPSZ128rrkz_VMOVAPSZ128rrkz_REV_VMOVUPDZ128rrk_VMOVUPDZ128rrk_REV_VMOVUPDZ128rrkz_VMOVUPDZ128rrkz_REV_VMOVUPSZ128rrk_VMOVUPSZ128rrk_REV_VMOVUPSZ128rrkz_VMOVUPSZ128rrkz_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1816
  {DBGFIELD("VMOVAPDZ256rrk_VMOVAPDZ256rrk_REV_VMOVAPDZ256rrkz_VMOVAPDZ256rrkz_REV_VMOVAPSZ256rrk_VMOVAPSZ256rrk_REV_VMOVAPSZ256rrkz_VMOVAPSZ256rrkz_REV_VMOVUPDZ256rrk_VMOVUPDZ256rrk_REV_VMOVUPDZ256rrkz_VMOVUPDZ256rrkz_REV_VMOVUPSZ256rrk_VMOVUPSZ256rrk_REV_VMOVUPSZ256rrkz_VMOVUPSZ256rrkz_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1817
  {DBGFIELD("VMOVDQA32Z128rrk_VMOVDQA32Z128rrk_REV_VMOVDQA32Z128rrkz_VMOVDQA32Z128rrkz_REV_VMOVDQA64Z128rrk_VMOVDQA64Z128rrk_REV_VMOVDQA64Z128rrkz_VMOVDQA64Z128rrkz_REV_VMOVDQU32Z128rrk_VMOVDQU32Z128rrk_REV_VMOVDQU32Z128rrkz_VMOVDQU32Z128rrkz_REV_VMOVDQU64Z128rrk_VMOVDQU64Z128rrk_REV_VMOVDQU64Z128rrkz_VMOVDQU64Z128rrkz_REV_VPMOVM2DZ128rk_VPMOVM2QZ128rk") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1818
  {DBGFIELD("VMOVSHZrr_VMOVSHZrr_REV") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1819
  {DBGFIELD("VPADDBZ128rr_VPADDDZ128rr_VPADDQZ128rr_VPADDWZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rrk_VPADDQZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1820
  {DBGFIELD("VPADDBZ256rr_VPADDDZ256rr_VPADDQZ256rr_VPADDWZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rrk_VPADDQZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1821
  {DBGFIELD("VPABSBZrmk_VPABSBZrmkz_VPABSWZrmk_VPABSWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1822
  {DBGFIELD("VPSLLWZmik_VPSLLWZmikz_VPSRLWZmik_VPSRLWZmikz_VPSRAWZmik_VPSRAWZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1823
  {DBGFIELD("VPADDSBZrmk_VPADDSBZrmkz_VPADDSWZrmk_VPADDSWZrmkz_VPADDUSBZrmk_VPADDUSBZrmkz_VPADDUSWZrmk_VPADDUSWZrmkz_VPSUBSBZrmk_VPSUBSBZrmkz_VPSUBSWZrmk_VPSUBSWZrmkz_VPSUBUSBZrmk_VPSUBUSBZrmkz_VPSUBUSWZrmk_VPSUBUSWZrmkz_VPAVGBZrmk_VPAVGBZrmkz_VPAVGWZrmk_VPAVGWZrmkz_VPMAXSBZrmk_VPMAXSBZrmkz_VPMAXUWZrmk_VPMAXUWZrmkz_VPMINSBZrmk_VPMINSBZrmkz_VPMINUWZrmk_VPMINUWZrmkz_VPMAXSWZrmk_VPMAXSWZrmkz_VPMAXUBZrmk_VPMAXUBZrmkz_VPMINSWZrmk_VPMINSWZrmkz_VPMINUBZrmk_VPMINUBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1824
  {DBGFIELD("VPSHLDVWZmk_VPSHLDVWZmkz_VPSHRDVWZmk_VPSHRDVWZmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1825
  {DBGFIELD("VPSLLVWZrmk_VPSLLVWZrmkz_VPSRLVWZrmk_VPSRLVWZrmkz_VPSRAVWZrmk_VPSRAVWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1826
  {DBGFIELD("VPSLLWZrmk_VPSLLWZrmkz_VPSRLWZrmk_VPSRLWZrmkz_VPSRAWZrmk_VPSRAWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1827
  {DBGFIELD("VCOMISHZrr_VCOMISHZrrb_VUCOMISHZrr_VUCOMISHZrrb_VCOMISHZrr_Int_VUCOMISHZrr_Int") 1, false, false, false,  3, 9,  5, 1,  0, 0}, // #1828
  {DBGFIELD("VCVTPD2QQZrrb_VCVTPD2QQZrrbk_VCVTPD2QQZrrk_VCVTPD2QQZrrkz_VCVTPD2UQQZrrb_VCVTPD2UQQZrrbk_VCVTPD2UQQZrrk_VCVTPD2UQQZrrkz_VCVTTPD2QQZrrb_VCVTTPD2QQZrrbk_VCVTTPD2QQZrrk_VCVTTPD2QQZrrkz_VCVTTPD2UQQZrrb_VCVTTPD2UQQZrrbk_VCVTTPD2UQQZrrk_VCVTTPD2UQQZrrkz_VCVTPD2QQZrrbkz_VCVTPD2UQQZrrbkz_VCVTTPD2QQZrrbkz_VCVTTPD2UQQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1829
  {DBGFIELD("VCVTPS2DQZrrb_VCVTPS2DQZrrbk_VCVTPS2DQZrrk_VCVTPS2DQZrrkz_VCVTPS2UDQZrrb_VCVTPS2UDQZrrbk_VCVTPS2UDQZrrk_VCVTPS2UDQZrrkz_VCVTTPS2DQZrrb_VCVTTPS2DQZrrbk_VCVTTPS2DQZrrk_VCVTTPS2DQZrrkz_VCVTTPS2UDQZrrb_VCVTTPS2UDQZrrbk_VCVTTPS2UDQZrrk_VCVTTPS2UDQZrrkz_VCVTPS2DQZrrbkz_VCVTPS2UDQZrrbkz_VCVTTPS2DQZrrbkz_VCVTTPS2UDQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1830
  {DBGFIELD("VMAXCPSZrr_VMAXCPSZrrk_VMAXCPSZrrkz_VMAXPSZrr_VMAXPSZrrk_VMAXPSZrrkz_VMINCPSZrr_VMINCPSZrrk_VMINCPSZrrkz_VMINPSZrr_VMINPSZrrk_VMINPSZrrkz_VMAXPSZrrb_VMAXPSZrrbk_VMAXPSZrrbkz_VMINPSZrrb_VMINPSZrrbk_VMINPSZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1831
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1832
  {DBGFIELD("VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1833
  {DBGFIELD("VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #1834
  {DBGFIELD("VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #1835
  {DBGFIELD("VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #1836
  {DBGFIELD("VPADDBZ128rm_VPADDDZ128rm_VPADDQZ128rm_VPADDWZ128rm_VPSUBBZ128rm_VPSUBDZ128rm_VPSUBQZ128rm_VPSUBWZ128rm_VPADDDZ128rmb_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rmb_VPADDQZ128rmk_VPADDQZ128rmkz_VPSUBDZ128rmb_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rmb_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmik_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmik_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmikz") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1837
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTWZ128rm") 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1838
  {DBGFIELD("VPALIGNRZ128rmi")    2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1839
  {DBGFIELD("VPEXTRDZmri_VPEXTRQZmri") 3, false, false, false, 372, 9, 17, 1,  0, 0}, // #1840
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1841
  {DBGFIELD("ROUNDPDmi_ROUNDPSmi_VROUNDPDmi_VROUNDPSmi") 3, false, false, false, 113, 7, 11, 1,  0, 0}, // #1842
  {DBGFIELD("ROUNDSDmi_ROUNDSDmi_Int_ROUNDSSmi_ROUNDSSmi_Int_VROUNDSDmi_VROUNDSDmi_Int_VROUNDSSmi_VROUNDSSmi_Int_VRNDSCALEPDZ128rmbi_VRNDSCALEPDZ128rmik_VRNDSCALEPSZ128rmbi_VRNDSCALEPSZ128rmik_VRNDSCALEPDZ128rmbik_VRNDSCALEPDZ128rmbikz_VRNDSCALEPSZ128rmbik_VRNDSCALEPSZ128rmbikz_VRNDSCALEPDZ128rmi_VRNDSCALEPDZ128rmikz_VRNDSCALEPSZ128rmi_VRNDSCALEPSZ128rmikz_VRNDSCALESDZrmi_VRNDSCALESSZrmi_VRNDSCALESDZrmi_Int_VRNDSCALESDZrmik_Int_VRNDSCALESDZrmikz_Int_VRNDSCALESSZrmi_Int_VRNDSCALESSZrmik_Int_VRNDSCALESSZrmikz_Int") 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #1843
  {DBGFIELD("ROUNDPDri_ROUNDSSri_VROUNDPDri_VROUNDSSri_ROUNDPSri_ROUNDSDri_VROUNDPSri_VROUNDSDri_ROUNDSDri_Int_ROUNDSSri_Int_VROUNDSDri_Int_VROUNDSSri_Int_VRNDSCALEPDZ128rri_VRNDSCALEPDZ128rrik_VRNDSCALEPDZ128rrikz_VRNDSCALEPSZ128rri_VRNDSCALEPSZ128rrik_VRNDSCALEPSZ128rrikz_VRNDSCALESDZrri_VRNDSCALESSZrri_VRNDSCALESDZrri_Int_VRNDSCALESDZrrib_Int_VRNDSCALESDZrribk_Int_VRNDSCALESDZrribkz_Int_VRNDSCALESDZrrik_Int_VRNDSCALESDZrrikz_Int_VRNDSCALESSZrri_Int_VRNDSCALESSZrrib_Int_VRNDSCALESSZrribk_Int_VRNDSCALESSZrribkz_Int_VRNDSCALESSZrrik_Int_VRNDSCALESSZrrikz_Int") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1844
  {DBGFIELD("VRNDSCALEPDZ256rri_VRNDSCALEPDZ256rrik_VRNDSCALEPDZ256rrikz_VRNDSCALEPSZ256rri_VRNDSCALEPSZ256rrik_VRNDSCALEPSZ256rrikz_VROUNDPDYri_VROUNDPSYri") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1845
  {DBGFIELD("VPMOVSXBWZ256rmk_VPMOVSXBWZ256rmkz_VPMOVSXBWZrmk_VPMOVSXBWZrmkz_VPMOVZXBWZ256rmk_VPMOVZXBWZ256rmkz_VPMOVZXBWZrmk_VPMOVZXBWZrmkz") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1846
  {DBGFIELD("VPOPCNTBZ128rmk_VPOPCNTBZ128rmkz_VPOPCNTWZ128rmk_VPOPCNTWZ128rmkz") 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #1847
  {DBGFIELD("VPOPCNTBZ256rmk_VPOPCNTBZ256rmkz_VPOPCNTWZ256rmk_VPOPCNTWZ256rmkz") 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #1848
  {DBGFIELD("VPOPCNTBZrmk_VPOPCNTBZrmkz_VPOPCNTWZrmk_VPOPCNTWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1849
  {DBGFIELD("VDBPSADBWZ128rmik_VDBPSADBWZ128rmikz") 2, false, false, false, 526, 11,  9, 1,  6, 1}, // #1850
  {DBGFIELD("VPMULTISHIFTQBZ128rmbk_VPMULTISHIFTQBZ128rmkz_VPMULTISHIFTQBZ128rmbkz_VPMULTISHIFTQBZ128rmk") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1851
  {DBGFIELD("VDBPSADBWZ256rmik_VDBPSADBWZ256rmikz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1852
  {DBGFIELD("VDBPSADBWZrmik_VDBPSADBWZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1853
  {DBGFIELD("VPACKSSDWZ256rmbk_VPACKSSDWZ256rmkz_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmkz_VPACKSSDWZ256rmbkz_VPACKUSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSWBZ256rmk_VPACKUSDWZ256rmk_VPACKUSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSWBZ256rmkz") 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1854
  {DBGFIELD("VPACKSSDWZrmbk_VPACKSSDWZrmkz_VPACKUSDWZrmbk_VPACKUSDWZrmkz_VPACKSSDWZrmbkz_VPACKUSDWZrmbkz_VPACKSSDWZrmk_VPACKSSWBZrmk_VPACKUSDWZrmk_VPACKUSWBZrmk_VPACKSSWBZrmkz_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1855
  {DBGFIELD("VPERMBZ128rmk_VPERMBZ128rmkz_VPERMBZ256rmk_VPERMBZ256rmkz_VPERMBZrmk_VPERMBZrmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1856
  {DBGFIELD("VPMULTISHIFTQBZ256rmbk_VPMULTISHIFTQBZ256rmkz_VPMULTISHIFTQBZ256rmbkz_VPMULTISHIFTQBZ256rmk") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1857
  {DBGFIELD("VPMULTISHIFTQBZrmbk_VPMULTISHIFTQBZrmkz_VPMULTISHIFTQBZrmbkz_VPMULTISHIFTQBZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1858
  {DBGFIELD("VPMOVUSQWZrrk_VPMOVUSQWZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1859
  {DBGFIELD("VSQRTSDZm_Int")      2, false, false, false, 243, 11, 18, 1,  6, 1}, // #1860
  {DBGFIELD("VADDPDZ128rrkz_VSUBPDZ128rrkz") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1861
  {DBGFIELD("VADDPDZ256rrkz_VSUBPDZ256rrkz") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1862
  {DBGFIELD("VADDPSZ128rrkz_VSUBPSZ128rrkz") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1863
  {DBGFIELD("VADDPSZ256rrkz_VSUBPSZ256rrkz") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1864
  {DBGFIELD("VADDSDZrrbkz_Int_VADDSDZrrkz_Int_VSUBSDZrrbkz_Int_VSUBSDZrrkz_Int") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1865
  {DBGFIELD("VADDSSZrrbkz_Int_VADDSSZrrkz_Int_VSUBSSZrrbkz_Int_VSUBSSZrrkz_Int") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1866
  {DBGFIELD("VADDPDZrr_VADDPDZrrb_VSUBPDZrr_VSUBPDZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1867
  {DBGFIELD("VADDPSZrr_VADDPSZrrb_VSUBPSZrr_VSUBPSZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1868
  {DBGFIELD("VMOVDQU16Zrrk_VMOVDQU16Zrrk_REV_VMOVDQU16Zrrkz_VMOVDQU16Zrrkz_REV_VMOVDQU8Zrrk_VMOVDQU8Zrrk_REV_VMOVDQU8Zrrkz_VMOVDQU8Zrrkz_REV_VPMOVM2BZrk_VPMOVM2WZrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1869
  {DBGFIELD("VPBLENDMBZrrk_VPBLENDMBZrrkz_VPBLENDMWZrrk_VPBLENDMWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1870
  {DBGFIELD("VADDPHZ128rrk_VADDPHZ128rrkz_VSUBPHZ128rrk_VSUBPHZ128rrkz") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1871
  {DBGFIELD("VADDPHZ256rrk_VADDPHZ256rrkz_VSUBPHZ256rrk_VSUBPHZ256rrkz") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #1872
  {DBGFIELD("VADDSHZrrbk_Int_VADDSHZrrbkz_Int_VADDSHZrrk_Int_VADDSHZrrkz_Int_VSUBSHZrrbk_Int_VSUBSHZrrbkz_Int_VSUBSHZrrk_Int_VSUBSHZrrkz_Int") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1873
  {DBGFIELD("VCVTPH2UWZ128rrk_VCVTPH2UWZ128rrkz_VCVTPH2WZ128rrk_VCVTPH2WZ128rrkz_VCVTTPH2UWZ128rrk_VCVTTPH2UWZ128rrkz_VCVTTPH2WZ128rrk_VCVTTPH2WZ128rrkz_VCVTUW2PHZ128rrk_VCVTUW2PHZ128rrkz_VCVTW2PHZ128rrk_VCVTW2PHZ128rrkz") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1874
  {DBGFIELD("VCVTPH2UWZ256rrk_VCVTPH2UWZ256rrkz_VCVTPH2WZ256rrk_VCVTPH2WZ256rrkz_VCVTTPH2UWZ256rrk_VCVTTPH2UWZ256rrkz_VCVTTPH2WZ256rrk_VCVTTPH2WZ256rrkz_VCVTUW2PHZ256rrk_VCVTUW2PHZ256rrkz_VCVTW2PHZ256rrk_VCVTW2PHZ256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1875
  {DBGFIELD("VFMADD132PHZ128rk_VFMADD132PHZ128rkz_VFMADD213PHZ128rk_VFMADD213PHZ128rkz_VFMADD231PHZ128rk_VFMADD231PHZ128rkz_VFMSUB132PHZ128rk_VFMSUB132PHZ128rkz_VFMSUB213PHZ128rk_VFMSUB213PHZ128rkz_VFMSUB231PHZ128rk_VFMSUB231PHZ128rkz_VFNMADD132PHZ128rk_VFNMADD132PHZ128rkz_VFNMADD213PHZ128rk_VFNMADD213PHZ128rkz_VFNMADD231PHZ128rk_VFNMADD231PHZ128rkz_VFNMSUB132PHZ128rk_VFNMSUB132PHZ128rkz_VFNMSUB213PHZ128rk_VFNMSUB213PHZ128rkz_VFNMSUB231PHZ128rk_VFNMSUB231PHZ128rkz_VFMADDSUB132PHZ128rk_VFMADDSUB132PHZ128rkz_VFMADDSUB213PHZ128rk_VFMADDSUB213PHZ128rkz_VFMADDSUB231PHZ128rk_VFMADDSUB231PHZ128rkz_VFMSUBADD132PHZ128rk_VFMSUBADD132PHZ128rkz_VFMSUBADD213PHZ128rk_VFMSUBADD213PHZ128rkz_VFMSUBADD231PHZ128rk_VFMSUBADD231PHZ128rkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1876
  {DBGFIELD("VFMADD132PHZ256rk_VFMADD132PHZ256rkz_VFMADD213PHZ256rk_VFMADD213PHZ256rkz_VFMADD231PHZ256rk_VFMADD231PHZ256rkz_VFMSUB132PHZ256rk_VFMSUB132PHZ256rkz_VFMSUB213PHZ256rk_VFMSUB213PHZ256rkz_VFMSUB231PHZ256rk_VFMSUB231PHZ256rkz_VFNMADD132PHZ256rk_VFNMADD132PHZ256rkz_VFNMADD213PHZ256rk_VFNMADD213PHZ256rkz_VFNMADD231PHZ256rk_VFNMADD231PHZ256rkz_VFNMSUB132PHZ256rk_VFNMSUB132PHZ256rkz_VFNMSUB213PHZ256rk_VFNMSUB213PHZ256rkz_VFNMSUB231PHZ256rk_VFNMSUB231PHZ256rkz_VFMADDSUB132PHZ256rk_VFMADDSUB132PHZ256rkz_VFMADDSUB213PHZ256rk_VFMADDSUB213PHZ256rkz_VFMADDSUB231PHZ256rk_VFMADDSUB231PHZ256rkz_VFMSUBADD132PHZ256rk_VFMSUBADD132PHZ256rkz_VFMSUBADD213PHZ256rk_VFMSUBADD213PHZ256rkz_VFMSUBADD231PHZ256rk_VFMSUBADD231PHZ256rkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1877
  {DBGFIELD("VFMADD132SHZrbk_Int_VFMADD132SHZrbkz_Int_VFMADD132SHZrk_Int_VFMADD132SHZrkz_Int_VFMADD213SHZrbk_Int_VFMADD213SHZrbkz_Int_VFMADD213SHZrk_Int_VFMADD213SHZrkz_Int_VFMADD231SHZrbk_Int_VFMADD231SHZrbkz_Int_VFMADD231SHZrk_Int_VFMADD231SHZrkz_Int_VFMSUB132SHZrbk_Int_VFMSUB132SHZrbkz_Int_VFMSUB132SHZrk_Int_VFMSUB132SHZrkz_Int_VFMSUB213SHZrbk_Int_VFMSUB213SHZrbkz_Int_VFMSUB213SHZrk_Int_VFMSUB213SHZrkz_Int_VFMSUB231SHZrbk_Int_VFMSUB231SHZrbkz_Int_VFMSUB231SHZrk_Int_VFMSUB231SHZrkz_Int_VFNMADD132SHZrbk_Int_VFNMADD132SHZrbkz_Int_VFNMADD132SHZrk_Int_VFNMADD132SHZrkz_Int_VFNMADD213SHZrbk_Int_VFNMADD213SHZrbkz_Int_VFNMADD213SHZrk_Int_VFNMADD213SHZrkz_Int_VFNMADD231SHZrbk_Int_VFNMADD231SHZrbkz_Int_VFNMADD231SHZrk_Int_VFNMADD231SHZrkz_Int_VFNMSUB132SHZrbk_Int_VFNMSUB132SHZrbkz_Int_VFNMSUB132SHZrk_Int_VFNMSUB132SHZrkz_Int_VFNMSUB213SHZrbk_Int_VFNMSUB213SHZrbkz_Int_VFNMSUB213SHZrk_Int_VFNMSUB213SHZrkz_Int_VFNMSUB231SHZrbk_Int_VFNMSUB231SHZrbkz_Int_VFNMSUB231SHZrk_Int_VFNMSUB231SHZrkz_Int") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1878
  {DBGFIELD("VGETEXPPHZ128rk_VGETEXPPHZ128rkz_VGETEXPSHZrbk_VGETEXPSHZrkz_VGETEXPSHZrbkz_VGETEXPSHZrk_VGETMANTPHZ128rrik_VGETMANTPHZ128rrikz_VGETMANTSHZrribk_VGETMANTSHZrrikz_VGETMANTSHZrribkz_VGETMANTSHZrrik") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1879
  {DBGFIELD("VGETEXPPHZ256rk_VGETEXPPHZ256rkz_VGETMANTPHZ256rrik_VGETMANTPHZ256rrikz") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1880
  {DBGFIELD("VMAXCPHZ128rrk_VMAXCPHZ128rrkz_VMINCPHZ128rrk_VMINCPHZ128rrkz_VMAXPHZ128rrk_VMAXPHZ128rrkz_VMINPHZ128rrk_VMINPHZ128rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1881
  {DBGFIELD("VMAXCPHZ256rrk_VMAXCPHZ256rrkz_VMINCPHZ256rrk_VMINCPHZ256rrkz_VMAXPHZ256rrk_VMAXPHZ256rrkz_VMINPHZ256rrk_VMINPHZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1882
  {DBGFIELD("VMULPHZ128rrk_VMULPHZ128rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1883
  {DBGFIELD("VMULPHZ256rrk_VMULPHZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1884
  {DBGFIELD("VMAXSHZrrbk_Int_VMAXSHZrrbkz_Int_VMAXSHZrrk_Int_VMAXSHZrrkz_Int_VMINSHZrrbk_Int_VMINSHZrrbkz_Int_VMINSHZrrk_Int_VMINSHZrrkz_Int") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1885
  {DBGFIELD("VMULSHZrrbk_Int_VMULSHZrrbkz_Int_VMULSHZrrk_Int_VMULSHZrrkz_Int") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1886
  {DBGFIELD("VADDPHZrr_VADDPHZrrb_VSUBPHZrr_VSUBPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1887
  {DBGFIELD("VAESDECLASTZrr_VAESDECZrr_VAESENCLASTZrr_VAESENCZrr") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1888
  {DBGFIELD("VCVTPH2UWZrr_VCVTPH2UWZrrb_VCVTPH2WZrr_VCVTPH2WZrrb_VCVTTPH2UWZrr_VCVTTPH2UWZrrb_VCVTTPH2WZrr_VCVTTPH2WZrrb_VCVTUW2PHZrr_VCVTUW2PHZrrb_VCVTW2PHZrr_VCVTW2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1889
  {DBGFIELD("VFMADD132PHZr_VFMADD132PHZrb_VFMADD213PHZr_VFMADD213PHZrb_VFMADD231PHZr_VFMADD231PHZrb_VFMSUB132PHZr_VFMSUB132PHZrb_VFMSUB213PHZr_VFMSUB213PHZrb_VFMSUB231PHZr_VFMSUB231PHZrb_VFNMADD132PHZr_VFNMADD132PHZrb_VFNMADD213PHZr_VFNMADD213PHZrb_VFNMADD231PHZr_VFNMADD231PHZrb_VFNMSUB132PHZr_VFNMSUB132PHZrb_VFNMSUB213PHZr_VFNMSUB213PHZrb_VFNMSUB231PHZr_VFNMSUB231PHZrb_VFMADDSUB132PHZr_VFMADDSUB132PHZrb_VFMADDSUB213PHZr_VFMADDSUB213PHZrb_VFMADDSUB231PHZr_VFMADDSUB231PHZrb_VFMSUBADD132PHZr_VFMSUBADD132PHZrb_VFMSUBADD213PHZr_VFMSUBADD213PHZrb_VFMSUBADD231PHZr_VFMSUBADD231PHZrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1890
  {DBGFIELD("VGETEXPPHZr_VGETEXPPHZrb_VGETMANTPHZrri_VGETMANTPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1891
  {DBGFIELD("VMAXCPHZrr_VMINCPHZrr_VMAXPHZrr_VMAXPHZrrb_VMINPHZrr_VMINPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1892
  {DBGFIELD("VMULPHZrr_VMULPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1893
  {DBGFIELD("VGF2P8MULBZrr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1894
  {DBGFIELD("VADDPHZrrbk_VADDPHZrrkz_VSUBPHZrrbk_VSUBPHZrrkz_VADDPHZrrbkz_VADDPHZrrk_VSUBPHZrrbkz_VSUBPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1895
  {DBGFIELD("VCVTPH2UWZrrbk_VCVTPH2UWZrrkz_VCVTPH2WZrrbk_VCVTPH2WZrrkz_VCVTTPH2UWZrrbk_VCVTTPH2UWZrrkz_VCVTTPH2WZrrbk_VCVTTPH2WZrrkz_VCVTPH2UWZrrbkz_VCVTPH2UWZrrk_VCVTPH2WZrrbkz_VCVTPH2WZrrk_VCVTTPH2UWZrrbkz_VCVTTPH2UWZrrk_VCVTTPH2WZrrbkz_VCVTTPH2WZrrk_VCVTUW2PHZrrbk_VCVTUW2PHZrrkz_VCVTW2PHZrrbk_VCVTW2PHZrrkz_VCVTUW2PHZrrbkz_VCVTUW2PHZrrk_VCVTW2PHZrrbkz_VCVTW2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1896
  {DBGFIELD("VFMADD132PHZrbk_VFMADD132PHZrkz_VFMADD213PHZrbk_VFMADD213PHZrkz_VFMADD231PHZrbk_VFMADD231PHZrkz_VFMSUB132PHZrbk_VFMSUB132PHZrkz_VFMSUB213PHZrbk_VFMSUB213PHZrkz_VFMSUB231PHZrbk_VFMSUB231PHZrkz_VFNMADD132PHZrbk_VFNMADD132PHZrkz_VFNMADD213PHZrbk_VFNMADD213PHZrkz_VFNMADD231PHZrbk_VFNMADD231PHZrkz_VFNMSUB132PHZrbk_VFNMSUB132PHZrkz_VFNMSUB213PHZrbk_VFNMSUB213PHZrkz_VFNMSUB231PHZrbk_VFNMSUB231PHZrkz_VFMADD132PHZrbkz_VFMADD132PHZrk_VFMADD213PHZrbkz_VFMADD213PHZrk_VFMADD231PHZrbkz_VFMADD231PHZrk_VFMSUB132PHZrbkz_VFMSUB132PHZrk_VFMSUB213PHZrbkz_VFMSUB213PHZrk_VFMSUB231PHZrbkz_VFMSUB231PHZrk_VFNMADD132PHZrbkz_VFNMADD132PHZrk_VFNMADD213PHZrbkz_VFNMADD213PHZrk_VFNMADD231PHZrbkz_VFNMADD231PHZrk_VFNMSUB132PHZrbkz_VFNMSUB132PHZrk_VFNMSUB213PHZrbkz_VFNMSUB213PHZrk_VFNMSUB231PHZrbkz_VFNMSUB231PHZrk_VFMADDSUB132PHZrbk_VFMADDSUB132PHZrkz_VFMADDSUB213PHZrbk_VFMADDSUB213PHZrkz_VFMADDSUB231PHZrbk_VFMADDSUB231PHZrkz_VFMADDSUB132PHZrbkz_VFMADDSUB132PHZrk_VFMADDSUB213PHZrbkz_VFMADDSUB213PHZrk_VFMADDSUB231PHZrbkz_VFMADDSUB231PHZrk_VFMSUBADD132PHZrbk_VFMSUBADD132PHZrkz_VFMSUBADD213PHZrbk_VFMSUBADD213PHZrkz_VFMSUBADD231PHZrbk_VFMSUBADD231PHZrkz_VFMSUBADD132PHZrbkz_VFMSUBADD132PHZrk_VFMSUBADD213PHZrbkz_VFMSUBADD213PHZrk_VFMSUBADD231PHZrbkz_VFMSUBADD231PHZrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1897
  {DBGFIELD("VGETEXPPHZrbk_VGETEXPPHZrkz_VGETEXPPHZrbkz_VGETEXPPHZrk_VGETMANTPHZrribk_VGETMANTPHZrrikz_VGETMANTPHZrribkz_VGETMANTPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1898
  {DBGFIELD("VMAXCPHZrrk_VMAXCPHZrrkz_VMINCPHZrrk_VMINCPHZrrkz_VMAXPHZrrbk_VMAXPHZrrkz_VMINPHZrrbk_VMINPHZrrkz_VMAXPHZrrbkz_VMAXPHZrrk_VMINPHZrrbkz_VMINPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1899
  {DBGFIELD("VMULPHZrrbk_VMULPHZrrkz_VMULPHZrrbkz_VMULPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1900
  {DBGFIELD("VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPSHUFHWZ128mik_VPSHUFHWZ128mikz_VPSHUFLWZ128mik_VPSHUFLWZ128mikz") 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1901
  {DBGFIELD("VPSHUFHWZ256mik_VPSHUFHWZ256mikz_VPSHUFLWZ256mik_VPSHUFLWZ256mikz") 2, false, false, false, 78, 8, 22, 1,  0, 0}, // #1902
  {DBGFIELD("VADDPSYrm_VSUBPSYrm_VADDPSZ256rm_VADDPSZ256rmb_VADDPSZ256rmbk_VADDPSZ256rmk_VADDPSZ256rmkz_VSUBPSZ256rm_VSUBPSZ256rmb_VSUBPSZ256rmbk_VSUBPSZ256rmk_VSUBPSZ256rmkz_VADDPSZ256rmbkz_VSUBPSZ256rmbkz") 2, false, false, false, 78, 8,  8, 1,  6, 1}, // #1903
  {DBGFIELD("VPSHUFBZ256rmk_VPSHUFBZ256rmkz") 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1904
  {DBGFIELD("VPUNPCKHBWZ256rmk_VPUNPCKHBWZ256rmkz_VPUNPCKHWDZ256rmk_VPUNPCKHWDZ256rmkz_VPUNPCKLBWZ256rmk_VPUNPCKLBWZ256rmkz_VPUNPCKLWDZ256rmk_VPUNPCKLWDZ256rmkz") 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1905
  {DBGFIELD("VADDSUBPSYrm")       2, false, false, false, 78, 8,  8, 1,  6, 1}, // #1906
  {DBGFIELD("VPSHUFBZ128rmk_VPSHUFBZ128rmkz") 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1907
  {DBGFIELD("VPUNPCKHBWZ128rmk_VPUNPCKHBWZ128rmkz_VPUNPCKHWDZ128rmk_VPUNPCKHWDZ128rmkz_VPUNPCKLBWZ128rmk_VPUNPCKLBWZ128rmkz_VPUNPCKLWDZ128rmk_VPUNPCKLWDZ128rmkz") 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1908
  {DBGFIELD("VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #1909
  {DBGFIELD("VADDPSZrm_VADDPSZrmb_VADDPSZrmbk_VADDPSZrmk_VADDPSZrmkz_VSUBPSZrm_VSUBPSZrmb_VSUBPSZrmbk_VSUBPSZrmk_VSUBPSZrmkz_VADDPSZrmbkz_VSUBPSZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1910
  {DBGFIELD("VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1911
  {DBGFIELD("VADDPSZrrbk_VADDPSZrrkz_VSUBPSZrrbk_VSUBPSZrrkz_VADDPSZrrbkz_VADDPSZrrk_VSUBPSZrrbkz_VSUBPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1912
  {DBGFIELD("VPLZCNTDZrm_VPLZCNTDZrmb_VPLZCNTDZrmbk_VPLZCNTDZrmk_VPLZCNTDZrmkz_VPLZCNTQZrm_VPLZCNTQZrmb_VPLZCNTQZrmbk_VPLZCNTQZrmk_VPLZCNTQZrmkz_VPLZCNTDZrmbkz_VPLZCNTQZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1913
  {DBGFIELD("VAESDECLASTZrm_VAESDECZrm_VAESENCLASTZrm_VAESENCZrm") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1914
  {DBGFIELD("VGF2P8AFFINEINVQBZrmbi_VGF2P8AFFINEINVQBZrmi_VGF2P8AFFINEQBZrmbi_VGF2P8AFFINEQBZrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1915
  {DBGFIELD("VGF2P8MULBZrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1916
  {DBGFIELD("VPMADD52HUQZm_VPMADD52HUQZmb_VPMADD52HUQZmbk_VPMADD52HUQZmk_VPMADD52HUQZmkz_VPMADD52LUQZm_VPMADD52LUQZmb_VPMADD52LUQZmbk_VPMADD52LUQZmk_VPMADD52LUQZmkz_VPMADD52HUQZmbkz_VPMADD52LUQZmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1917
  {DBGFIELD("VPOPCNTBZ256rm_VPOPCNTDZ256rm_VPOPCNTQZ256rm_VPOPCNTWZ256rm_VPOPCNTDZ256rmb_VPOPCNTDZ256rmk_VPOPCNTDZ256rmkz_VPOPCNTQZ256rmb_VPOPCNTQZ256rmk_VPOPCNTQZ256rmkz_VPOPCNTDZ256rmbk_VPOPCNTDZ256rmbkz_VPOPCNTQZ256rmbk_VPOPCNTQZ256rmbkz") 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #1918
  {DBGFIELD("VPOPCNTBZrm_VPOPCNTDZrm_VPOPCNTQZrm_VPOPCNTWZrm_VPOPCNTDZrmb_VPOPCNTDZrmk_VPOPCNTDZrmkz_VPOPCNTQZrmb_VPOPCNTQZrmk_VPOPCNTQZrmkz_VPOPCNTDZrmbk_VPOPCNTDZrmbkz_VPOPCNTQZrmbk_VPOPCNTQZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1919
  {DBGFIELD("VPSHUFHWZmik_VPSHUFHWZmikz_VPSHUFLWZmik_VPSHUFLWZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1920
  {DBGFIELD("VFPCLASSPDZ256mbi_VFPCLASSPSZ256mbi") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1921
  {DBGFIELD("VFPCLASSPDZmbi_VFPCLASSPSZmbi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1922
  {DBGFIELD("VFPCLASSPHZ256mbi")  2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1923
  {DBGFIELD("VFPCLASSPHZmbi")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1924
  {DBGFIELD("VPALIGNRZrmik_VPALIGNRZrmikz_VPUNPCKHBWZrmk_VPUNPCKHBWZrmkz_VPUNPCKHWDZrmk_VPUNPCKHWDZrmkz_VPUNPCKLBWZrmk_VPUNPCKLBWZrmkz_VPUNPCKLWDZrmk_VPUNPCKLWDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1925
  {DBGFIELD("VPMULTISHIFTQBZ256rm_VPMULTISHIFTQBZ256rmb") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1926
  {DBGFIELD("VPMULTISHIFTQBZrm_VPMULTISHIFTQBZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1927
  {DBGFIELD("VPCLMULQDQZrmi")     2, false, false, false, 526, 11,  9, 1,  6, 1}, // #1928
  {DBGFIELD("VPCLMULQDQZ256rmi")  2, false, false, false, 526, 11,  9, 1,  6, 1}, // #1929
  {DBGFIELD("VBLENDVPDYrmr_VBLENDVPSYrmr") 4, false, false, false, 843, 6,  9, 1,  8, 2}, // #1930
  {DBGFIELD("VPBLENDVBYrmr")      4, false, false, false, 843, 6,  9, 1,  8, 2}, // #1931
  {DBGFIELD("VBLENDVPDYrrr_VBLENDVPSYrrr") 3, false, false, false, 849, 4,  5, 1,  0, 0}, // #1932
  {DBGFIELD("VPBLENDVBYrrr")      3, false, false, false, 849, 4,  5, 1,  0, 0}, // #1933
  {DBGFIELD("VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPSZ256rmk_VMOVUPSZ256rmkz") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #1934
  {DBGFIELD("VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #1935
  {DBGFIELD("VPADDBZ256rm_VPADDDZ256rm_VPADDQZ256rm_VPADDWZ256rm_VPSUBBZ256rm_VPSUBDZ256rm_VPSUBQZ256rm_VPSUBWZ256rm_VPADDDZ256rmb_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rmb_VPADDQZ256rmk_VPADDQZ256rmkz_VPSUBDZ256rmb_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rmb_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmik_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmik_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmikz") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1936
  {DBGFIELD("VCMPPHZ128rmbi_VCMPPHZ128rmik_VCMPPHZ128rmbik_VCMPPHZ128rmi_VFPCLASSPHZ128mbik_VFPCLASSPHZ128mik") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1937
  {DBGFIELD("VCMPPHZ256rmbi_VCMPPHZ256rmik_VCMPPHZ256rmbik_VCMPPHZ256rmi_VFPCLASSPHZ256mbik_VFPCLASSPHZ256mik") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1938
  {DBGFIELD("VCMPPHZrmbi_VCMPPHZrmik_VCMPPHZrmbik_VCMPPHZrmi_VFPCLASSPHZmbik_VFPCLASSPHZmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1939
  {DBGFIELD("VCMPSHZrmi_VCMPSHZrmi_Int_VCMPSHZrmik_Int_VFPCLASSSHZmik") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1940
  {DBGFIELD("VCOMISHZrm_VCOMISHZrm_Int_VUCOMISHZrm_VUCOMISHZrm_Int") 2, false, false, false, 243, 11,  7, 1,  6, 1}, // #1941
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ256mr_VCOMPRESSPSZ128mr_VCOMPRESSPSZ256mr_VCOMPRESSPDZmr_VCOMPRESSPSZmr_VPCOMPRESSDZ128mr_VPCOMPRESSDZ256mr_VPCOMPRESSQZ128mr_VPCOMPRESSQZ256mr_VPCOMPRESSDZmr_VPCOMPRESSQZmr") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1942
  {DBGFIELD("VPMOVDBZmr_VPMOVQBZmr_VPMOVSQBZmr_VPMOVSWBZmr_VPMOVWBZmr_VPMOVDWZmr_VPMOVQWZmr_VPMOVSDWZmr_VPMOVSQWZmr_VPMOVUSDWZmr_VPMOVUSQWZmr_VPMOVSDBZmr_VPMOVSQDZmr_VPMOVUSDBZmr_VPMOVUSQDZmr_VPMOVUSQBZmr_VPMOVUSWBZmr") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1943
  {DBGFIELD("VPMOVDBZmrk_VPMOVQBZmrk_VPMOVSQBZmrk_VPMOVSWBZmrk_VPMOVWBZmrk_VPMOVDWZmrk_VPMOVQWZmrk_VPMOVSDWZmrk_VPMOVSQWZmrk_VPMOVUSDWZmrk_VPMOVUSQWZmrk_VPMOVSDBZmrk_VPMOVSQDZmrk_VPMOVUSDBZmrk_VPMOVUSQDZmrk_VPMOVUSQBZmrk_VPMOVUSWBZmrk") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1944
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPSZ128rr_VPCOMPRESSDZ128rr_VPCOMPRESSQZ128rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1945
  {DBGFIELD("VCOMPRESSPDZ256rr_VCOMPRESSPSZ256rr_VPCOMPRESSDZ256rr_VPCOMPRESSQZ256rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1946
  {DBGFIELD("VCOMPRESSPDZrr_VCOMPRESSPSZrr_VPCOMPRESSDZrr_VPCOMPRESSQZrr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1947
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ256rr_VEXPANDPSZ128rr_VEXPANDPSZ256rr_VEXPANDPDZrr_VEXPANDPSZrr_VPEXPANDDZ128rr_VPEXPANDDZ256rr_VPEXPANDQZ128rr_VPEXPANDQZ256rr_VPEXPANDDZrr_VPEXPANDQZrr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1948
  {DBGFIELD("VPCOMPRESSBZ128rr_VPCOMPRESSWZ128rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1949
  {DBGFIELD("VPCOMPRESSBZ256rr_VPCOMPRESSWZ256rr_VPEXPANDBZ256rr_VPEXPANDWZ256rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1950
  {DBGFIELD("VPCOMPRESSBZrr_VPCOMPRESSWZrr_VPEXPANDBZrr_VPEXPANDWZrr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1951
  {DBGFIELD("VPEXPANDBZ128rr_VPEXPANDWZ128rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #1952
  {DBGFIELD("VCVTDQ2PDZrrk_VCVTDQ2PDZrrkz_VCVTUDQ2PDZrrk_VCVTUDQ2PDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1953
  {DBGFIELD("VCVTPS2QQZrrb_VCVTPS2QQZrrbk_VCVTPS2QQZrrk_VCVTPS2QQZrrkz_VCVTPS2UQQZrrb_VCVTPS2UQQZrrbk_VCVTPS2UQQZrrk_VCVTPS2UQQZrrkz_VCVTTPS2QQZrrb_VCVTTPS2QQZrrbk_VCVTTPS2QQZrrk_VCVTTPS2QQZrrkz_VCVTTPS2UQQZrrb_VCVTTPS2UQQZrrbk_VCVTTPS2UQQZrrk_VCVTTPS2UQQZrrkz_VCVTPS2QQZrrbkz_VCVTPS2UQQZrrbkz_VCVTTPS2QQZrrbkz_VCVTTPS2UQQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1954
  {DBGFIELD("VCVTQQ2PSZrrb_VCVTQQ2PSZrrbk_VCVTQQ2PSZrrk_VCVTQQ2PSZrrkz_VCVTUQQ2PSZrrb_VCVTUQQ2PSZrrbk_VCVTUQQ2PSZrrk_VCVTUQQ2PSZrrkz_VCVTQQ2PSZrrbkz_VCVTUQQ2PSZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1955
  {DBGFIELD("VCVTDQ2PHZ128rm_VCVTDQ2PHZ128rmb_VCVTUDQ2PHZ128rm_VCVTUDQ2PHZ128rmb") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1956
  {DBGFIELD("VCVTNEPS2BF16Z128rm_VCVTNEPS2BF16Z128rmb") 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #1957
  {DBGFIELD("VCVTDQ2PHZ128rmbk_VCVTDQ2PHZ128rmkz_VCVTUDQ2PHZ128rmbk_VCVTUDQ2PHZ128rmkz_VCVTDQ2PHZ128rmbkz_VCVTDQ2PHZ128rmk_VCVTUDQ2PHZ128rmbkz_VCVTUDQ2PHZ128rmk") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1958
  {DBGFIELD("VCVTDQ2PHZ128rr_VCVTUDQ2PHZ128rr") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1959
  {DBGFIELD("VCVTDQ2PHZ128rrk_VCVTDQ2PHZ128rrkz_VCVTUDQ2PHZ128rrk_VCVTUDQ2PHZ128rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1960
  {DBGFIELD("VCVTDQ2PHZ256rm_VCVTDQ2PHZ256rmb_VCVTUDQ2PHZ256rm_VCVTUDQ2PHZ256rmb") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1961
  {DBGFIELD("VCVTNEPS2BF16Z128rmbk_VCVTNEPS2BF16Z128rmkz_VCVTNEPS2BF16Z128rmbkz_VCVTNEPS2BF16Z128rmk") 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #1962
  {DBGFIELD("VCVTDQ2PHZ256rmbk_VCVTDQ2PHZ256rmkz_VCVTUDQ2PHZ256rmbk_VCVTUDQ2PHZ256rmkz_VCVTDQ2PHZ256rmbkz_VCVTDQ2PHZ256rmk_VCVTUDQ2PHZ256rmbkz_VCVTUDQ2PHZ256rmk") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1963
  {DBGFIELD("VCVTDQ2PHZ256rr_VCVTUDQ2PHZ256rr") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1964
  {DBGFIELD("VCVTDQ2PHZ256rrk_VCVTDQ2PHZ256rrkz_VCVTUDQ2PHZ256rrk_VCVTUDQ2PHZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1965
  {DBGFIELD("VCVTDQ2PHZrm_VCVTDQ2PHZrmb_VCVTUDQ2PHZrm_VCVTUDQ2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1966
  {DBGFIELD("VCVTDQ2PHZrmbk_VCVTDQ2PHZrmkz_VCVTUDQ2PHZrmbk_VCVTUDQ2PHZrmkz_VCVTDQ2PHZrmbkz_VCVTDQ2PHZrmk_VCVTUDQ2PHZrmbkz_VCVTUDQ2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1967
  {DBGFIELD("VCVTDQ2PHZrr_VCVTDQ2PHZrrb_VCVTUDQ2PHZrr_VCVTUDQ2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1968
  {DBGFIELD("VCVTDQ2PHZrrbk_VCVTDQ2PHZrrkz_VCVTUDQ2PHZrrbk_VCVTUDQ2PHZrrkz_VCVTDQ2PHZrrbkz_VCVTDQ2PHZrrk_VCVTUDQ2PHZrrbkz_VCVTUDQ2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1969
  {DBGFIELD("VCVTNE2PS2BF16Z128rm_VCVTNE2PS2BF16Z128rmb") 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #1970
  {DBGFIELD("VCVTNE2PS2BF16Z128rmbk_VCVTNE2PS2BF16Z128rmkz_VCVTNE2PS2BF16Z128rmbkz_VCVTNE2PS2BF16Z128rmk") 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #1971
  {DBGFIELD("VCVTNE2PS2BF16Z128rr") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1972
  {DBGFIELD("VCVTNE2PS2BF16Z256rr") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1973
  {DBGFIELD("VCVTNE2PS2BF16Z128rrk_VCVTNE2PS2BF16Z128rrkz") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1974
  {DBGFIELD("VCVTNE2PS2BF16Z256rrk_VCVTNE2PS2BF16Z256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1975
  {DBGFIELD("VCVTNE2PS2BF16Z256rm_VCVTNE2PS2BF16Z256rmb") 3, false, false, false, 264, 12, 11, 1,  6, 1}, // #1976
  {DBGFIELD("VCVTNE2PS2BF16Z256rmbk_VCVTNE2PS2BF16Z256rmkz_VCVTNE2PS2BF16Z256rmbkz_VCVTNE2PS2BF16Z256rmk") 3, false, false, false, 264, 12, 11, 1,  6, 1}, // #1977
  {DBGFIELD("VCVTNE2PS2BF16Zrm_VCVTNE2PS2BF16Zrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1978
  {DBGFIELD("VDPBF16PSZm_VDPBF16PSZmb_VDPBF16PSZmbk_VDPBF16PSZmk_VDPBF16PSZmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1979
  {DBGFIELD("VDPBF16PSZmbkz")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1980
  {DBGFIELD("VCVTNE2PS2BF16Zrmbk_VCVTNE2PS2BF16Zrmkz_VCVTNE2PS2BF16Zrmbkz_VCVTNE2PS2BF16Zrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1981
  {DBGFIELD("VCVTNE2PS2BF16Zrr")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1982
  {DBGFIELD("VCVTNE2PS2BF16Zrrk_VCVTNE2PS2BF16Zrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1983
  {DBGFIELD("VCVTNEPS2BF16Z128rr") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1984
  {DBGFIELD("VCVTNEPS2BF16Z256rr") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1985
  {DBGFIELD("VCVTNEPS2BF16Z128rrk_VCVTNEPS2BF16Z128rrkz") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1986
  {DBGFIELD("VCVTNEPS2BF16Z256rrk_VCVTNEPS2BF16Z256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #1987
  {DBGFIELD("VCVTNEPS2BF16Z256rm_VCVTNEPS2BF16Z256rmb") 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #1988
  {DBGFIELD("VCVTNEPS2BF16Z256rmbk_VCVTNEPS2BF16Z256rmkz_VCVTNEPS2BF16Z256rmbkz_VCVTNEPS2BF16Z256rmk") 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #1989
  {DBGFIELD("VCVTNEPS2BF16Zrm_VCVTNEPS2BF16Zrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1990
  {DBGFIELD("VCVTNEPS2BF16Zrmbk_VCVTNEPS2BF16Zrmkz_VCVTNEPS2BF16Zrmbkz_VCVTNEPS2BF16Zrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1991
  {DBGFIELD("VCVTNEPS2BF16Zrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1992
  {DBGFIELD("VCVTNEPS2BF16Zrrk_VCVTNEPS2BF16Zrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1993
  {DBGFIELD("VCVTPD2DQZ256rm_VCVTPD2DQZ256rmb_VCVTPD2UDQZ256rm_VCVTPD2UDQZ256rmb_VCVTTPD2DQZ256rm_VCVTTPD2DQZ256rmb_VCVTTPD2UDQZ256rm_VCVTTPD2UDQZ256rmb_VCVTPD2DQZ256rmbk_VCVTPD2DQZ256rmkz_VCVTPD2UDQZ256rmbk_VCVTPD2UDQZ256rmkz_VCVTTPD2DQZ256rmbk_VCVTTPD2DQZ256rmkz_VCVTTPD2UDQZ256rmbk_VCVTTPD2UDQZ256rmkz_VCVTPD2DQZ256rmbkz_VCVTPD2DQZ256rmk_VCVTPD2UDQZ256rmbkz_VCVTPD2UDQZ256rmk_VCVTTPD2DQZ256rmbkz_VCVTTPD2DQZ256rmk_VCVTTPD2UDQZ256rmbkz_VCVTTPD2UDQZ256rmk") 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #1994
  {DBGFIELD("VCVTPH2DQZ256rm_VCVTPH2DQZ256rmb_VCVTPH2UDQZ256rm_VCVTPH2UDQZ256rmb_VCVTTPH2DQZ256rm_VCVTTPH2DQZ256rmb_VCVTTPH2UDQZ256rm_VCVTTPH2UDQZ256rmb") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1995
  {DBGFIELD("VCVTPH2PSXZ128rmbk_VCVTPH2PSXZ128rmkz_VCVTPH2PSXZ128rmbkz_VCVTPH2PSXZ128rmk") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1996
  {DBGFIELD("VCVTPH2PSXZ256rm_VCVTPH2PSXZ256rmb") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1997
  {DBGFIELD("VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz_VCVTQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmbkz") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1998
  {DBGFIELD("VCVTPH2DQZrm_VCVTPH2DQZrmb_VCVTPH2UDQZrm_VCVTPH2UDQZrmb_VCVTTPH2DQZrm_VCVTTPH2DQZrmb_VCVTTPH2UDQZrm_VCVTTPH2UDQZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1999
  {DBGFIELD("VCVTPH2PSXZrm_VCVTPH2PSXZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2000
  {DBGFIELD("VCVTPD2PHZ128rm_VCVTPD2PHZ128rmb") 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #2001
  {DBGFIELD("VCVTPD2PHZ128rmbk_VCVTPD2PHZ128rmkz_VCVTPD2PHZ128rmbkz_VCVTPD2PHZ128rmk") 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #2002
  {DBGFIELD("VCVTPD2PHZ128rr")    2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2003
  {DBGFIELD("VCVTPD2PHZ128rrk_VCVTPD2PHZ128rrkz") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2004
  {DBGFIELD("VCVTPD2PHZ256rm_VCVTPD2PHZ256rmb") 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #2005
  {DBGFIELD("VCVTPD2PHZ256rmbk_VCVTPD2PHZ256rmkz_VCVTPD2PHZ256rmbkz_VCVTPD2PHZ256rmk") 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #2006
  {DBGFIELD("VCVTPD2PHZ256rr")    2, false, false, false, 254, 10,  6, 1,  0, 0}, // #2007
  {DBGFIELD("VCVTPD2PHZ256rrk_VCVTPD2PHZ256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #2008
  {DBGFIELD("VCVTPD2PHZrm_VCVTPD2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2009
  {DBGFIELD("VCVTPH2PDZrm_VCVTPH2PDZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2010
  {DBGFIELD("VCVTPD2PHZrmbk_VCVTPD2PHZrmkz_VCVTPD2PHZrmbkz_VCVTPD2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2011
  {DBGFIELD("VCVTPH2PDZrmbk_VCVTPH2PDZrmkz_VCVTPH2PDZrmbkz_VCVTPH2PDZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2012
  {DBGFIELD("VCVTPD2PHZrr_VCVTPD2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2013
  {DBGFIELD("VCVTPH2PDZrr_VCVTPH2PDZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2014
  {DBGFIELD("VCVTPD2PHZrrbk_VCVTPD2PHZrrkz_VCVTPD2PHZrrbkz_VCVTPD2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2015
  {DBGFIELD("VCVTPH2PDZrrbk_VCVTPH2PDZrrkz_VCVTPH2PDZrrbkz_VCVTPH2PDZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2016
  {DBGFIELD("VPABSBZ128rmk_VPABSBZ128rmkz_VPABSWZ128rmk_VPABSWZ128rmkz") 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #2017
  {DBGFIELD("VPABSBZ256rmk_VPABSBZ256rmkz_VPABSWZ256rmk_VPABSWZ256rmkz") 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #2018
  {DBGFIELD("VPLZCNTDZ128rm_VPLZCNTDZ128rmb_VPLZCNTDZ128rmbk_VPLZCNTDZ128rmk_VPLZCNTDZ128rmkz_VPLZCNTQZ128rm_VPLZCNTQZ128rmb_VPLZCNTQZ128rmbk_VPLZCNTQZ128rmk_VPLZCNTQZ128rmkz_VPLZCNTDZ128rmbkz_VPLZCNTQZ128rmbkz") 2, false, false, false, 101, 7, 24, 1,  0, 0}, // #2019
  {DBGFIELD("VPSLLWZ128mik_VPSLLWZ128mikz_VPSRLWZ128mik_VPSRLWZ128mikz_VPSRAWZ128mik_VPSRAWZ128mikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2020
  {DBGFIELD("VPSLLWZ256mik_VPSLLWZ256mikz_VPSRLWZ256mik_VPSRLWZ256mikz_VPSRAWZ256mik_VPSRAWZ256mikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2021
  {DBGFIELD("VFIXUPIMMSDZrmi_VFIXUPIMMSDZrmik_VFIXUPIMMSDZrmikz_VFIXUPIMMSSZrmi_VFIXUPIMMSSZrmik_VFIXUPIMMSSZrmikz_VSCALEFSDZrm_VSCALEFSDZrmk_VSCALEFSDZrmkz_VSCALEFSSZrm_VSCALEFSSZrmk_VSCALEFSSZrmkz") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2022
  {DBGFIELD("VPADDSBZ128rmk_VPADDSBZ128rmkz_VPADDSWZ128rmk_VPADDSWZ128rmkz_VPADDUSBZ128rmk_VPADDUSBZ128rmkz_VPADDUSWZ128rmk_VPADDUSWZ128rmkz_VPSUBSBZ128rmk_VPSUBSBZ128rmkz_VPSUBSWZ128rmk_VPSUBSWZ128rmkz_VPSUBUSBZ128rmk_VPSUBUSBZ128rmkz_VPSUBUSWZ128rmk_VPSUBUSWZ128rmkz_VPAVGBZ128rmk_VPAVGBZ128rmkz_VPAVGWZ128rmk_VPAVGWZ128rmkz_VPMAXSBZ128rmk_VPMAXSBZ128rmkz_VPMAXUWZ128rmk_VPMAXUWZ128rmkz_VPMINSBZ128rmk_VPMINSBZ128rmkz_VPMINUWZ128rmk_VPMINUWZ128rmkz_VPMAXSWZ128rmk_VPMAXSWZ128rmkz_VPMAXUBZ128rmk_VPMAXUBZ128rmkz_VPMINSWZ128rmk_VPMINSWZ128rmkz_VPMINUBZ128rmk_VPMINUBZ128rmkz") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2023
  {DBGFIELD("VPSHLDVWZ128mk_VPSHLDVWZ128mkz_VPSHRDVWZ128mk_VPSHRDVWZ128mkz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2024
  {DBGFIELD("VPSLLVWZ128rmk_VPSLLVWZ128rmkz_VPSRLVWZ128rmk_VPSRLVWZ128rmkz_VPSRAVWZ128rmk_VPSRAVWZ128rmkz") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2025
  {DBGFIELD("VPSLLWZ128rmk_VPSLLWZ128rmkz_VPSRLWZ128rmk_VPSRLWZ128rmkz_VPSRAWZ128rmk_VPSRAWZ128rmkz") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2026
  {DBGFIELD("VPADDSBZ256rmk_VPADDSBZ256rmkz_VPADDSWZ256rmk_VPADDSWZ256rmkz_VPADDUSBZ256rmk_VPADDUSBZ256rmkz_VPADDUSWZ256rmk_VPADDUSWZ256rmkz_VPSUBSBZ256rmk_VPSUBSBZ256rmkz_VPSUBSWZ256rmk_VPSUBSWZ256rmkz_VPSUBUSBZ256rmk_VPSUBUSBZ256rmkz_VPSUBUSWZ256rmk_VPSUBUSWZ256rmkz_VPAVGBZ256rmk_VPAVGBZ256rmkz_VPAVGWZ256rmk_VPAVGWZ256rmkz_VPMAXSBZ256rmk_VPMAXSBZ256rmkz_VPMAXUWZ256rmk_VPMAXUWZ256rmkz_VPMINSBZ256rmk_VPMINSBZ256rmkz_VPMINUWZ256rmk_VPMINUWZ256rmkz_VPMAXSWZ256rmk_VPMAXSWZ256rmkz_VPMAXUBZ256rmk_VPMAXUBZ256rmkz_VPMINSWZ256rmk_VPMINSWZ256rmkz_VPMINUBZ256rmk_VPMINUBZ256rmkz") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2027
  {DBGFIELD("VPSHLDVWZ256mk_VPSHLDVWZ256mkz_VPSHRDVWZ256mk_VPSHRDVWZ256mkz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2028
  {DBGFIELD("VPSLLVWZ256rmk_VPSLLVWZ256rmkz_VPSRLVWZ256rmk_VPSRLVWZ256rmkz_VPSRAVWZ256rmk_VPSRAVWZ256rmkz") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2029
  {DBGFIELD("VPSLLWZ256rmk_VPSLLWZ256rmkz_VPSRLWZ256rmk_VPSRLWZ256rmkz_VPSRAWZ256rmk_VPSRAWZ256rmkz") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2030
  {DBGFIELD("VPMADD52HUQZ128m_VPMADD52HUQZ128mb_VPMADD52HUQZ128mbk_VPMADD52HUQZ128mk_VPMADD52HUQZ128mkz_VPMADD52LUQZ128m_VPMADD52LUQZ128mb_VPMADD52LUQZ128mbk_VPMADD52LUQZ128mk_VPMADD52LUQZ128mkz_VPMADD52HUQZ128mbkz_VPMADD52LUQZ128mbkz") 2, false, false, false, 101, 7, 24, 1, 10, 2}, // #2031
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #2032
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2033
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #2034
  {DBGFIELD("VFIXUPIMMSDZrri_VFIXUPIMMSSZrri_VSCALEFSDZrr_VSCALEFSDZrrk_VSCALEFSDZrrkz_VSCALEFSSZrr_VSCALEFSSZrrk_VSCALEFSSZrrkz_VSCALEFSDZrrbk_Int_VSCALEFSDZrrbkz_Int_VSCALEFSSZrrbk_Int_VSCALEFSSZrrbkz_Int") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2035
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2036
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2037
  {DBGFIELD("VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2038
  {DBGFIELD("VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2039
  {DBGFIELD("VFIXUPIMMSDZrrib_VFIXUPIMMSDZrribk_VFIXUPIMMSDZrribkz_VFIXUPIMMSSZrrib_VFIXUPIMMSSZrribk_VFIXUPIMMSSZrribkz") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2040
  {DBGFIELD("VCVTPH2DQZ128rm_VCVTPH2DQZ128rmb_VCVTPH2UDQZ128rm_VCVTPH2UDQZ128rmb_VCVTTPH2DQZ128rm_VCVTTPH2DQZ128rmb_VCVTTPH2UDQZ128rm_VCVTTPH2UDQZ128rmb") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2041
  {DBGFIELD("VCVTPS2PHXZ128rm_VCVTPS2PHXZ128rmb") 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #2042
  {DBGFIELD("VCVTPH2DQZ128rmbk_VCVTPH2DQZ128rmkz_VCVTPH2UDQZ128rmbk_VCVTPH2UDQZ128rmkz_VCVTTPH2DQZ128rmbk_VCVTTPH2DQZ128rmkz_VCVTTPH2UDQZ128rmbk_VCVTTPH2UDQZ128rmkz_VCVTPH2DQZ128rmbkz_VCVTPH2DQZ128rmk_VCVTPH2UDQZ128rmbkz_VCVTPH2UDQZ128rmk_VCVTTPH2DQZ128rmbkz_VCVTTPH2DQZ128rmk_VCVTTPH2UDQZ128rmbkz_VCVTTPH2UDQZ128rmk") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2043
  {DBGFIELD("VCVTPH2DQZ128rrk_VCVTPH2DQZ128rrkz_VCVTPH2UDQZ128rrk_VCVTPH2UDQZ128rrkz_VCVTTPH2DQZ128rrk_VCVTTPH2DQZ128rrkz_VCVTTPH2UDQZ128rrk_VCVTTPH2UDQZ128rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2044
  {DBGFIELD("VCVTPH2DQZ256rrk_VCVTPH2DQZ256rrkz_VCVTPH2UDQZ256rrk_VCVTPH2UDQZ256rrkz_VCVTTPH2DQZ256rrk_VCVTTPH2DQZ256rrkz_VCVTTPH2UDQZ256rrk_VCVTTPH2UDQZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2045
  {DBGFIELD("VCVTPH2PSXZ256rrk_VCVTPH2PSXZ256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #2046
  {DBGFIELD("VCVTPH2PSZ256rrk_VCVTPH2PSZ256rrkz") 2, false, false, false, 254, 10,  7, 1,  0, 0}, // #2047
  {DBGFIELD("VCVTPS2PHXZ256rrk_VCVTPS2PHXZ256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #2048
  {DBGFIELD("VCVTPS2PHZ256rrk_VCVTPS2PHZ256rrkz") 2, false, false, false, 254, 10,  7, 1,  0, 0}, // #2049
  {DBGFIELD("VCVTPH2DQZ256rmbk_VCVTPH2DQZ256rmkz_VCVTPH2UDQZ256rmbk_VCVTPH2UDQZ256rmkz_VCVTTPH2DQZ256rmbk_VCVTTPH2DQZ256rmkz_VCVTTPH2UDQZ256rmbk_VCVTTPH2UDQZ256rmkz_VCVTPH2DQZ256rmbkz_VCVTPH2DQZ256rmk_VCVTPH2UDQZ256rmbkz_VCVTPH2UDQZ256rmk_VCVTTPH2DQZ256rmbkz_VCVTTPH2DQZ256rmk_VCVTTPH2UDQZ256rmbkz_VCVTTPH2UDQZ256rmk") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2050
  {DBGFIELD("VCVTPH2PSXZ256rmbk_VCVTPH2PSXZ256rmkz_VCVTPH2PSXZ256rmbkz_VCVTPH2PSXZ256rmk") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2051
  {DBGFIELD("VCVTPS2PHXZ256rmbk_VCVTPS2PHXZ256rmkz_VCVTPS2PHXZ256rmbkz_VCVTPS2PHXZ256rmk") 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #2052
  {DBGFIELD("VCVTPH2DQZrmbk_VCVTPH2DQZrmkz_VCVTPH2UDQZrmbk_VCVTPH2UDQZrmkz_VCVTTPH2DQZrmbk_VCVTTPH2DQZrmkz_VCVTTPH2UDQZrmbk_VCVTTPH2UDQZrmkz_VCVTPH2DQZrmbkz_VCVTPH2DQZrmk_VCVTPH2UDQZrmbkz_VCVTPH2UDQZrmk_VCVTTPH2DQZrmbkz_VCVTTPH2DQZrmk_VCVTTPH2UDQZrmbkz_VCVTTPH2UDQZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2053
  {DBGFIELD("VCVTPH2PSXZrmbk_VCVTPH2PSXZrmkz_VCVTPH2PSXZrmbkz_VCVTPH2PSXZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2054
  {DBGFIELD("VCVTPS2PHXZrmbk_VCVTPS2PHXZrmkz_VCVTPS2PHXZrmbkz_VCVTPS2PHXZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2055
  {DBGFIELD("VCVTPH2DQZrr_VCVTPH2DQZrrb_VCVTPH2UDQZrr_VCVTPH2UDQZrrb_VCVTTPH2DQZrr_VCVTTPH2DQZrrb_VCVTTPH2UDQZrr_VCVTTPH2UDQZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2056
  {DBGFIELD("VCVTPH2PSXZrr_VCVTPH2PSXZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2057
  {DBGFIELD("VCVTPH2PSZrr_VCVTPH2PSZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2058
  {DBGFIELD("VCVTPS2PHXZrr_VCVTPS2PHXZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2059
  {DBGFIELD("VCVTPS2PHZrr_VCVTPS2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2060
  {DBGFIELD("VPSHUFBITQMBZ128rrk") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2061
  {DBGFIELD("VPSHUFBITQMBZ256rrk") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2062
  {DBGFIELD("VPSHUFBITQMBZrrk")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2063
  {DBGFIELD("VCVTPH2DQZrrbk_VCVTPH2DQZrrkz_VCVTPH2UDQZrrbk_VCVTPH2UDQZrrkz_VCVTTPH2DQZrrbk_VCVTTPH2DQZrrkz_VCVTTPH2UDQZrrbk_VCVTTPH2UDQZrrkz_VCVTPH2DQZrrbkz_VCVTPH2DQZrrk_VCVTPH2UDQZrrbkz_VCVTPH2UDQZrrk_VCVTTPH2DQZrrbkz_VCVTTPH2DQZrrk_VCVTTPH2UDQZrrbkz_VCVTTPH2UDQZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2064
  {DBGFIELD("VCVTPH2PSXZrrbk_VCVTPH2PSXZrrkz_VCVTPH2PSXZrrbkz_VCVTPH2PSXZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2065
  {DBGFIELD("VCVTPS2PHXZrrbk_VCVTPS2PHXZrrkz_VCVTPS2PHXZrrbkz_VCVTPS2PHXZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2066
  {DBGFIELD("VCVTPH2PDZ128rm_VCVTPH2PDZ128rmb") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2067
  {DBGFIELD("VCVTPH2PDZ128rmbk_VCVTPH2PDZ128rmkz_VCVTPH2PDZ128rmbkz_VCVTPH2PDZ128rmk") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2068
  {DBGFIELD("VCVTPH2PDZ128rr")    2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2069
  {DBGFIELD("VCVTPH2PDZ128rrk_VCVTPH2PDZ128rrkz") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2070
  {DBGFIELD("VCVTPH2PDZ256rm_VCVTPH2PDZ256rmb") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2071
  {DBGFIELD("VCVTPH2PDZ256rmbk_VCVTPH2PDZ256rmkz_VCVTPH2PDZ256rmbkz_VCVTPH2PDZ256rmk") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2072
  {DBGFIELD("VCVTPH2PDZ256rr")    2, false, false, false, 254, 10,  6, 1,  0, 0}, // #2073
  {DBGFIELD("VCVTPH2PDZ256rrk_VCVTPH2PDZ256rrkz") 2, false, false, false, 254, 10,  6, 1,  0, 0}, // #2074
  {DBGFIELD("VCVTPH2PSXZ128rrk_VCVTPH2PSXZ128rrkz") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2075
  {DBGFIELD("VCVTPH2PSZ128rrk_VCVTPH2PSZ128rrkz") 2, false, false, false, 254, 10,  3, 1,  0, 0}, // #2076
  {DBGFIELD("VCVTPS2PHXZ128rrk_VCVTPS2PHXZ128rrkz") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2077
  {DBGFIELD("VCVTPS2PHZ128rrk_VCVTPS2PHZ128rrkz") 2, false, false, false, 254, 10,  3, 1,  0, 0}, // #2078
  {DBGFIELD("VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2079
  {DBGFIELD("VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2080
  {DBGFIELD("VCVTSH2SSZrmk_Int_VCVTSH2SSZrmkz_Int") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2081
  {DBGFIELD("VPMADDUBSWZ128rmk_VPMADDUBSWZ128rmkz_VPMULHRSWZ128rmk_VPMULHRSWZ128rmkz_VPMULHUWZ128rmk_VPMULHUWZ128rmkz_VPMULHWZ128rmk_VPMULHWZ128rmkz_VPMULLWZ128rmk_VPMULLWZ128rmkz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2082
  {DBGFIELD("VPMADDUBSWZ256rmk_VPMADDUBSWZ256rmkz_VPMULHRSWZ256rmk_VPMULHRSWZ256rmkz_VPMULHUWZ256rmk_VPMULHUWZ256rmkz_VPMULHWZ256rmk_VPMULHWZ256rmkz_VPMULLWZ256rmk_VPMULLWZ256rmkz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2083
  {DBGFIELD("VCVTPH2PSZrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2084
  {DBGFIELD("VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2085
  {DBGFIELD("VCVTPH2QQZ128rm_VCVTPH2QQZ128rmb_VCVTPH2QQZ128rmbk_VCVTPH2QQZ128rmk_VCVTPH2QQZ128rmkz_VCVTPH2UQQZ128rm_VCVTPH2UQQZ128rmb_VCVTPH2UQQZ128rmbk_VCVTPH2UQQZ128rmk_VCVTPH2UQQZ128rmkz_VCVTTPH2QQZ128rm_VCVTTPH2QQZ128rmb_VCVTTPH2QQZ128rmbk_VCVTTPH2QQZ128rmk_VCVTTPH2QQZ128rmkz_VCVTTPH2UQQZ128rm_VCVTTPH2UQQZ128rmb_VCVTTPH2UQQZ128rmbk_VCVTTPH2UQQZ128rmk_VCVTTPH2UQQZ128rmkz_VCVTPH2QQZ128rmbkz_VCVTPH2UQQZ128rmbkz_VCVTTPH2QQZ128rmbkz_VCVTTPH2UQQZ128rmbkz") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2086
  {DBGFIELD("VCVTPH2QQZ128rr_VCVTPH2QQZ128rrk_VCVTPH2QQZ128rrkz_VCVTPH2UQQZ128rr_VCVTPH2UQQZ128rrk_VCVTPH2UQQZ128rrkz_VCVTTPH2QQZ128rr_VCVTTPH2QQZ128rrk_VCVTTPH2QQZ128rrkz_VCVTTPH2UQQZ128rr_VCVTTPH2UQQZ128rrk_VCVTTPH2UQQZ128rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2087
  {DBGFIELD("VCVTPH2QQZ256rr_VCVTPH2QQZ256rrk_VCVTPH2QQZ256rrkz_VCVTPH2UQQZ256rr_VCVTPH2UQQZ256rrk_VCVTPH2UQQZ256rrkz_VCVTTPH2QQZ256rr_VCVTTPH2QQZ256rrk_VCVTTPH2QQZ256rrkz_VCVTTPH2UQQZ256rr_VCVTTPH2UQQZ256rrk_VCVTTPH2UQQZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2088
  {DBGFIELD("VCVTPH2QQZ256rm_VCVTPH2QQZ256rmb_VCVTPH2QQZ256rmbk_VCVTPH2QQZ256rmk_VCVTPH2QQZ256rmkz_VCVTPH2UQQZ256rm_VCVTPH2UQQZ256rmb_VCVTPH2UQQZ256rmbk_VCVTPH2UQQZ256rmk_VCVTPH2UQQZ256rmkz_VCVTTPH2QQZ256rm_VCVTTPH2QQZ256rmb_VCVTTPH2QQZ256rmbk_VCVTTPH2QQZ256rmk_VCVTTPH2QQZ256rmkz_VCVTTPH2UQQZ256rm_VCVTTPH2UQQZ256rmb_VCVTTPH2UQQZ256rmbk_VCVTTPH2UQQZ256rmk_VCVTTPH2UQQZ256rmkz_VCVTPH2QQZ256rmbkz_VCVTPH2UQQZ256rmbkz_VCVTTPH2QQZ256rmbkz_VCVTTPH2UQQZ256rmbkz") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2089
  {DBGFIELD("VCVTPS2PHXZ128rmbk_VCVTPS2PHXZ128rmkz_VCVTPS2PHXZ128rmbkz_VCVTPS2PHXZ128rmk") 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #2090
  {DBGFIELD("VCVTPS2PHXZ256rm_VCVTPS2PHXZ256rmb") 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #2091
  {DBGFIELD("VCVTPS2PHXZrm_VCVTPS2PHXZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2092
  {DBGFIELD("VCVTPS2PHZ128mrk")   3, false, false, false, 853, 8,  2, 1,  0, 0}, // #2093
  {DBGFIELD("VCVTPS2PHZ256mrk")   3, false, false, false, 853, 8,  2, 1,  0, 0}, // #2094
  {DBGFIELD("VCVTPS2PHZmrk")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2095
  {DBGFIELD("VCVTQQ2PHZ128rm_VCVTQQ2PHZ128rmb_VCVTUQQ2PHZ128rm_VCVTUQQ2PHZ128rmb") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2096
  {DBGFIELD("VCVTQQ2PHZ128rmbk_VCVTQQ2PHZ128rmkz_VCVTUQQ2PHZ128rmbk_VCVTUQQ2PHZ128rmkz_VCVTQQ2PHZ128rmbkz_VCVTQQ2PHZ128rmk_VCVTUQQ2PHZ128rmbkz_VCVTUQQ2PHZ128rmk") 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2097
  {DBGFIELD("VCVTQQ2PHZ128rr_VCVTUQQ2PHZ128rr") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2098
  {DBGFIELD("VCVTQQ2PHZ128rrk_VCVTQQ2PHZ128rrkz_VCVTUQQ2PHZ128rrk_VCVTUQQ2PHZ128rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2099
  {DBGFIELD("VCVTQQ2PHZ256rr_VCVTUQQ2PHZ256rr") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2100
  {DBGFIELD("VCVTQQ2PHZ256rm_VCVTQQ2PHZ256rmb_VCVTUQQ2PHZ256rm_VCVTUQQ2PHZ256rmb") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2101
  {DBGFIELD("VCVTQQ2PHZ256rmbk_VCVTQQ2PHZ256rmkz_VCVTUQQ2PHZ256rmbk_VCVTUQQ2PHZ256rmkz_VCVTQQ2PHZ256rmbkz_VCVTQQ2PHZ256rmk_VCVTUQQ2PHZ256rmbkz_VCVTUQQ2PHZ256rmk") 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2102
  {DBGFIELD("VCVTQQ2PHZ256rrk_VCVTQQ2PHZ256rrkz_VCVTUQQ2PHZ256rrk_VCVTUQQ2PHZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2103
  {DBGFIELD("VCVTQQ2PHZrm_VCVTQQ2PHZrmb_VCVTUQQ2PHZrm_VCVTUQQ2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2104
  {DBGFIELD("VCVTQQ2PHZrmbk_VCVTQQ2PHZrmkz_VCVTUQQ2PHZrmbk_VCVTUQQ2PHZrmkz_VCVTQQ2PHZrmbkz_VCVTQQ2PHZrmk_VCVTUQQ2PHZrmbkz_VCVTUQQ2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2105
  {DBGFIELD("VCVTQQ2PHZrr_VCVTQQ2PHZrrb_VCVTUQQ2PHZrr_VCVTUQQ2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2106
  {DBGFIELD("VCVTQQ2PHZrrbk_VCVTQQ2PHZrrkz_VCVTUQQ2PHZrrbk_VCVTUQQ2PHZrrkz_VCVTQQ2PHZrrbkz_VCVTQQ2PHZrrk_VCVTUQQ2PHZrrbkz_VCVTUQQ2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2107
  {DBGFIELD("VCVTSD2SHZrm_VCVTSD2SHZrm_Int") 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #2108
  {DBGFIELD("VCVTSD2SHZrmk_Int_VCVTSD2SHZrmkz_Int") 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #2109
  {DBGFIELD("VCVTSD2SHZrr_Int_VCVTSD2SHZrrb_Int") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2110
  {DBGFIELD("VCVTSD2SHZrr")       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2111
  {DBGFIELD("VCVTSD2SHZrrbk_Int_VCVTSD2SHZrrbkz_Int_VCVTSD2SHZrrk_Int_VCVTSD2SHZrrkz_Int") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2112
  {DBGFIELD("VCVTSH2SDZrm_VCVTSH2SDZrm_Int") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2113
  {DBGFIELD("VCVTSH2SDZrmk_Int_VCVTSH2SDZrmkz_Int") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2114
  {DBGFIELD("VCVTSH2SDZrr_Int_VCVTSH2SDZrrb_Int") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2115
  {DBGFIELD("VCVTSH2SDZrr")       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2116
  {DBGFIELD("VCVTSH2SDZrrbk_Int_VCVTSH2SDZrrbkz_Int_VCVTSH2SDZrrk_Int_VCVTSH2SDZrrkz_Int") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2117
  {DBGFIELD("VCVTSH2SI64Zrm_Int_VCVTSH2SIZrm_Int_VCVTSH2USI64Zrm_Int_VCVTSH2USIZrm_Int_VCVTTSH2SI64Zrm_Int_VCVTTSH2SIZrm_Int_VCVTTSH2USI64Zrm_Int_VCVTTSH2USIZrm_Int_VCVTTSH2SI64Zrm_VCVTTSH2SIZrm_VCVTTSH2USI64Zrm_VCVTTSH2USIZrm") 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #2118
  {DBGFIELD("VCVTSH2SI64Zrr_Int_VCVTSH2SI64Zrrb_Int_VCVTSH2SIZrr_Int_VCVTSH2SIZrrb_Int_VCVTSH2USI64Zrr_Int_VCVTSH2USI64Zrrb_Int_VCVTSH2USIZrr_Int_VCVTSH2USIZrrb_Int_VCVTTSH2SI64Zrr_Int_VCVTTSH2SI64Zrrb_Int_VCVTTSH2SIZrr_Int_VCVTTSH2SIZrrb_Int_VCVTTSH2USI64Zrr_Int_VCVTTSH2USI64Zrrb_Int_VCVTTSH2USIZrr_Int_VCVTTSH2USIZrrb_Int_VCVTTSH2SI64Zrr_VCVTTSH2SIZrr_VCVTTSH2USI64Zrr_VCVTTSH2USIZrr") 2, false, false, false, 287, 9,  6, 1,  0, 0}, // #2119
  {DBGFIELD("VCVTSH2SSZrrbk_Int_VCVTSH2SSZrrbkz_Int_VCVTSH2SSZrrk_Int_VCVTSH2SSZrrkz_Int") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2120
  {DBGFIELD("VCVTSI2SHZrm_VCVTSI2SHZrm_Int_VCVTSI642SHZrm_VCVTSI642SHZrm_Int_VCVTUSI2SHZrm_VCVTUSI2SHZrm_Int_VCVTUSI642SHZrm_VCVTUSI642SHZrm_Int") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2121
  {DBGFIELD("VCVTSS2SHZrm_VCVTSS2SHZrm_Int") 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #2122
  {DBGFIELD("VCVTSS2SHZrmk_Int_VCVTSS2SHZrmkz_Int") 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #2123
  {DBGFIELD("VCVTSS2SHZrr_Int_VCVTSS2SHZrrb_Int") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2124
  {DBGFIELD("VCVTSS2SHZrr")       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2125
  {DBGFIELD("VCVTSS2SHZrrbk_Int_VCVTSS2SHZrrbkz_Int_VCVTSS2SHZrrk_Int_VCVTSS2SHZrrkz_Int") 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2126
  {DBGFIELD("VDBPSADBWZ128rrik_VDBPSADBWZ128rrikz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2127
  {DBGFIELD("VDBPSADBWZ256rrik_VDBPSADBWZ256rrikz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2128
  {DBGFIELD("VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2129
  {DBGFIELD("VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2130
  {DBGFIELD("VPBROADCASTBZ256rrk_VPBROADCASTBZ256rrkz_VPBROADCASTBZrrk_VPBROADCASTBZrrkz_VPBROADCASTDrZ256rrk_VPBROADCASTDrZ256rrkz_VPBROADCASTDrZrrk_VPBROADCASTDrZrrkz_VPBROADCASTQrZ256rrk_VPBROADCASTQrZ256rrkz_VPBROADCASTQrZrrk_VPBROADCASTQrZrrkz_VPBROADCASTWZ256rrk_VPBROADCASTWZ256rrkz_VPBROADCASTWZrrk_VPBROADCASTWZrrkz_VPBROADCASTWrZ256rrk_VPBROADCASTWrZ256rrkz_VPBROADCASTWrZrrk_VPBROADCASTWrZrrkz_VPBROADCASTBrZ256rr_VPBROADCASTDrZ256rr_VPBROADCASTQrZ256rr_VPBROADCASTWrZ256rr_VPBROADCASTBrZ256rrk_VPBROADCASTBrZ256rrkz_VPBROADCASTBrZrr_VPBROADCASTDrZrr_VPBROADCASTQrZrr_VPBROADCASTWrZrr_VPBROADCASTBrZrrk_VPBROADCASTBrZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2131
  {DBGFIELD("VPBROADCASTBrZ128rr_VPBROADCASTDrZ128rr_VPBROADCASTQrZ128rr_VPBROADCASTWrZ128rr_VPBROADCASTBrZ128rrk_VPBROADCASTBrZ128rrkz_VPBROADCASTDrZ128rrk_VPBROADCASTDrZ128rrkz_VPBROADCASTQrZ128rrk_VPBROADCASTQrZ128rrkz_VPBROADCASTWrZ128rrk_VPBROADCASTWrZ128rrkz") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #2132
  {DBGFIELD("VPERMBZ128rrk_VPERMBZ128rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2133
  {DBGFIELD("VPERMBZ256rrk_VPERMBZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2134
  {DBGFIELD("VPERMBZrrk_VPERMBZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2135
  {DBGFIELD("VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2136
  {DBGFIELD("VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVZXBWZrrk_VPMOVZXBWZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2137
  {DBGFIELD("VPMULTISHIFTQBZ128rrk_VPMULTISHIFTQBZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2138
  {DBGFIELD("VPMULTISHIFTQBZ256rrk_VPMULTISHIFTQBZ256rrkz_VPOPCNTBZ256rrk_VPOPCNTBZ256rrkz_VPOPCNTWZ256rrk_VPOPCNTWZ256rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2139
  {DBGFIELD("VPMULTISHIFTQBZrrk_VPMULTISHIFTQBZrrkz_VPOPCNTBZrrk_VPOPCNTBZrrkz_VPOPCNTWZrrk_VPOPCNTWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2140
  {DBGFIELD("VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2141
  {DBGFIELD("VDIVPHZ128rm_VDIVPHZ128rmb") 2, false, false, false, 243, 11, 13, 1,  6, 1}, // #2142
  {DBGFIELD("VDIVPHZ128rmbk_VDIVPHZ128rmkz_VDIVPHZ128rmbkz_VDIVPHZ128rmk") 2, false, false, false, 243, 11, 13, 1,  6, 1}, // #2143
  {DBGFIELD("VDIVPHZ128rr")       1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2144
  {DBGFIELD("VDIVPHZ256rr")       1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2145
  {DBGFIELD("VDIVPHZ128rrk")      1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2146
  {DBGFIELD("VDIVPHZ256rrk")      1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2147
  {DBGFIELD("VSQRTPHZ128r")       1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2148
  {DBGFIELD("VSQRTPHZ256r")       1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2149
  {DBGFIELD("VDIVPHZ128rrkz")     1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2150
  {DBGFIELD("VDIVPHZ256rm_VDIVPHZ256rmb") 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #2151
  {DBGFIELD("VDIVPHZ256rmbk_VDIVPHZ256rmkz_VDIVPHZ256rmbkz_VDIVPHZ256rmk") 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #2152
  {DBGFIELD("VSQRTPHZ128m_VSQRTPHZ128mb") 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #2153
  {DBGFIELD("VDIVPHZ256rrkz")     1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2154
  {DBGFIELD("VDIVPHZrm_VDIVPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2155
  {DBGFIELD("VDIVPHZrmbk_VDIVPHZrmkz_VDIVPHZrmbkz_VDIVPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2156
  {DBGFIELD("VDIVPHZrr_VDIVPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2157
  {DBGFIELD("VDIVPHZrrbk_VDIVPHZrrkz_VDIVPHZrrbkz_VDIVPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2158
  {DBGFIELD("VDIVPSZrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2159
  {DBGFIELD("VDIVSHZrm_Int_VDIVSHZrmk_Int_VDIVSHZrmkz_Int") 2, false, false, false, 243, 11, 13, 1,  6, 1}, // #2160
  {DBGFIELD("VDIVSHZrm")          2, false, false, false, 243, 11, 13, 1,  6, 1}, // #2161
  {DBGFIELD("VDIVSHZrr_Int")      1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2162
  {DBGFIELD("VSQRTSHZr_Int")      1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2163
  {DBGFIELD("VDPBF16PSZ128m_VDPBF16PSZ128mb_VDPBF16PSZ128mbk_VDPBF16PSZ128mk_VDPBF16PSZ128mkz") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2164
  {DBGFIELD("VDPBF16PSZ128mbkz")  2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2165
  {DBGFIELD("VDPBF16PSZ256m_VDPBF16PSZ256mb_VDPBF16PSZ256mbk_VDPBF16PSZ256mk_VDPBF16PSZ256mkz") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #2166
  {DBGFIELD("VDPBF16PSZ256mbkz")  2, false, false, false, 101, 7,  2, 1,  6, 1}, // #2167
  {DBGFIELD("VPEXPANDBZ128rm_VPEXPANDWZ128rm") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2168
  {DBGFIELD("VFCMADDCPHZ128m_VFCMADDCPHZ128mb_VFMADDCPHZ128m_VFMADDCPHZ128mb") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2169
  {DBGFIELD("VFCMADDCPHZ256m_VFCMADDCPHZ256mb_VFMADDCPHZ256m_VFMADDCPHZ256mb") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2170
  {DBGFIELD("VROUNDPDYmi_VROUNDPSYmi") 3, false, false, false, 113, 7, 16, 1,  0, 0}, // #2171
  {DBGFIELD("VFCMADDCSHZm_VFMADDCSHZm_VFCMULCPHZ128rm_VFCMULCPHZ128rmb_VFMULCPHZ128rm_VFMULCPHZ128rmb_VFCMULCSHZrm_VFMULCSHZrm") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2172
  {DBGFIELD("VRNDSCALEPHZ128rmbi_VRNDSCALEPHZ128rmi_VRNDSCALESHZrmi_VRNDSCALESHZrmi_Int") 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #2173
  {DBGFIELD("VSCALEFPHZ128rm_VSCALEFPHZ128rmb") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2174
  {DBGFIELD("VFCMULCPHZ256rm_VFCMULCPHZ256rmb_VFMULCPHZ256rm_VFMULCPHZ256rmb") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #2175
  {DBGFIELD("VRNDSCALEPDZ256rmbi_VRNDSCALEPDZ256rmi_VRNDSCALEPHZ256rmbi_VRNDSCALEPHZ256rmi_VRNDSCALEPSZ256rmbi_VRNDSCALEPSZ256rmi_VRNDSCALEPDZ256rmbik_VRNDSCALEPDZ256rmbikz_VRNDSCALEPDZ256rmik_VRNDSCALEPDZ256rmikz_VRNDSCALEPSZ256rmbik_VRNDSCALEPSZ256rmbikz_VRNDSCALEPSZ256rmik_VRNDSCALEPSZ256rmikz") 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #2176
  {DBGFIELD("VSCALEFPHZ256rm_VSCALEFPHZ256rmb") 2, false, false, false, 78, 8,  8, 1,  6, 1}, // #2177
  {DBGFIELD("VSCALEFSHZrm")       2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2178
  {DBGFIELD("VFCMADDCPHZ128mbk_VFCMADDCPHZ128mkz_VFMADDCPHZ128mbk_VFMADDCPHZ128mkz_VFCMADDCPHZ128mbkz_VFCMADDCPHZ128mk_VFMADDCPHZ128mbkz_VFMADDCPHZ128mk") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2179
  {DBGFIELD("VFCMADDCPHZ256mbk_VFCMADDCPHZ256mkz_VFMADDCPHZ256mbk_VFMADDCPHZ256mkz_VFCMADDCPHZ256mbkz_VFCMADDCPHZ256mk_VFMADDCPHZ256mbkz_VFMADDCPHZ256mk") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2180
  {DBGFIELD("VFCMADDCSHZmk_VFCMADDCSHZmkz_VFMADDCSHZmk_VFMADDCSHZmkz_VFCMULCPHZ128rmbk_VFCMULCPHZ128rmkz_VFMULCPHZ128rmbk_VFMULCPHZ128rmkz_VFCMULCPHZ128rmbkz_VFCMULCPHZ128rmk_VFMULCPHZ128rmbkz_VFMULCPHZ128rmk_VFCMULCSHZrmk_VFCMULCSHZrmkz_VFMULCSHZrmk_VFMULCSHZrmkz") 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2181
  {DBGFIELD("VFCMULCPHZ256rmbk_VFCMULCPHZ256rmkz_VFMULCPHZ256rmbk_VFMULCPHZ256rmkz_VFCMULCPHZ256rmbkz_VFCMULCPHZ256rmk_VFMULCPHZ256rmbkz_VFMULCPHZ256rmk") 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #2182
  {DBGFIELD("VFCMADDCPHZ128r_VFMADDCPHZ128r_VFCMADDCSHZr_VFCMADDCSHZrb_VFMADDCSHZr_VFMADDCSHZrb_VFCMULCPHZ128rr_VFMULCPHZ128rr_VFCMULCSHZrr_VFCMULCSHZrrb_VFMULCSHZrr_VFMULCSHZrrb") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2183
  {DBGFIELD("VFCMADDCPHZ256r_VFMADDCPHZ256r_VFCMULCPHZ256rr_VFMULCPHZ256rr") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2184
  {DBGFIELD("VRNDSCALEPHZ128rri_VRNDSCALESHZrri_Int_VRNDSCALESHZrrib_Int") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2185
  {DBGFIELD("VRNDSCALEPHZ256rri") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2186
  {DBGFIELD("VSCALEFPHZ128rr")    1, false, false, false, 86, 6,  5, 1,  0, 0}, // #2187
  {DBGFIELD("VSCALEFPHZ256rr")    1, false, false, false, 86, 6,  5, 1,  0, 0}, // #2188
  {DBGFIELD("VRNDSCALESHZrri")    2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2189
  {DBGFIELD("VSCALEFSHZrr_VSCALEFSHZrrb_Int") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2190
  {DBGFIELD("VFCMADDCPHZ128rk_VFCMADDCPHZ128rkz_VFMADDCPHZ128rk_VFMADDCPHZ128rkz_VFCMADDCSHZrbk_VFCMADDCSHZrkz_VFMADDCSHZrbk_VFMADDCSHZrkz_VFCMADDCSHZrbkz_VFCMADDCSHZrk_VFMADDCSHZrbkz_VFMADDCSHZrk_VFCMULCPHZ128rrk_VFCMULCPHZ128rrkz_VFMULCPHZ128rrk_VFMULCPHZ128rrkz_VFCMULCSHZrrbk_VFCMULCSHZrrkz_VFMULCSHZrrbk_VFMULCSHZrrkz_VFCMULCSHZrrbkz_VFCMULCSHZrrk_VFMULCSHZrrbkz_VFMULCSHZrrk") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2191
  {DBGFIELD("VFCMADDCPHZ256rk_VFCMADDCPHZ256rkz_VFMADDCPHZ256rk_VFMADDCPHZ256rkz_VFCMULCPHZ256rrk_VFCMULCPHZ256rrkz_VFMULCPHZ256rrk_VFMULCPHZ256rrkz") 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2192
  {DBGFIELD("VFCMADDCPHZm_VFCMADDCPHZmb_VFMADDCPHZm_VFMADDCPHZmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2193
  {DBGFIELD("VFCMULCPHZrm_VFCMULCPHZrmb_VFMULCPHZrm_VFMULCPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2194
  {DBGFIELD("VRNDSCALEPDZrmbi_VRNDSCALEPDZrmi_VRNDSCALEPHZrmbi_VRNDSCALEPHZrmi_VRNDSCALEPSZrmbi_VRNDSCALEPSZrmi_VRNDSCALEPDZrmbik_VRNDSCALEPDZrmbikz_VRNDSCALEPDZrmik_VRNDSCALEPDZrmikz_VRNDSCALEPSZrmbik_VRNDSCALEPSZrmbikz_VRNDSCALEPSZrmik_VRNDSCALEPSZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2195
  {DBGFIELD("VSCALEFPHZrm_VSCALEFPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2196
  {DBGFIELD("VFCMADDCPHZmbk_VFCMADDCPHZmkz_VFMADDCPHZmbk_VFMADDCPHZmkz_VFCMADDCPHZmbkz_VFCMADDCPHZmk_VFMADDCPHZmbkz_VFMADDCPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2197
  {DBGFIELD("VFCMULCPHZrmbk_VFCMULCPHZrmkz_VFMULCPHZrmbk_VFMULCPHZrmkz_VFCMULCPHZrmbkz_VFCMULCPHZrmk_VFMULCPHZrmbkz_VFMULCPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2198
  {DBGFIELD("VFCMADDCPHZr_VFCMADDCPHZrb_VFMADDCPHZr_VFMADDCPHZrb_VFCMULCPHZrr_VFCMULCPHZrrb_VFMULCPHZrr_VFMULCPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2199
  {DBGFIELD("VRNDSCALEPHZrri_VRNDSCALEPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2200
  {DBGFIELD("VSCALEFPHZrr_VSCALEFPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2201
  {DBGFIELD("VFCMADDCPHZrbk_VFCMADDCPHZrkz_VFMADDCPHZrbk_VFMADDCPHZrkz_VFCMADDCPHZrbkz_VFCMADDCPHZrk_VFMADDCPHZrbkz_VFMADDCPHZrk_VFCMULCPHZrrbk_VFCMULCPHZrrkz_VFMULCPHZrrbk_VFMULCPHZrrkz_VFCMULCPHZrrbkz_VFCMULCPHZrrk_VFMULCPHZrrbkz_VFMULCPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2202
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 55, 3, 42, 2,  0, 0}, // #2203
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQQZ256rm") 1, false, false, false, 55, 3, 42, 2,  0, 0}, // #2204
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm") 1, false, false, false, 55, 3, 42, 2,  0, 0}, // #2205
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, false, 55, 3, 42, 2,  0, 0}, // #2206
  {DBGFIELD("VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 55, 3, 42, 2,  0, 0}, // #2207
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rmbik_VGF2P8AFFINEINVQBZ128rmbikz_VGF2P8AFFINEINVQBZ128rmik_VGF2P8AFFINEINVQBZ128rmikz_VGF2P8AFFINEQBZ128rmbik_VGF2P8AFFINEQBZ128rmbikz_VGF2P8AFFINEQBZ128rmik_VGF2P8AFFINEQBZ128rmikz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2208
  {DBGFIELD("VGF2P8MULBZ128rmk_VGF2P8MULBZ128rmkz") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2209
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rmbik_VGF2P8AFFINEINVQBZ256rmbikz_VGF2P8AFFINEINVQBZ256rmik_VGF2P8AFFINEINVQBZ256rmikz_VGF2P8AFFINEQBZ256rmbik_VGF2P8AFFINEQBZ256rmbikz_VGF2P8AFFINEQBZ256rmik_VGF2P8AFFINEQBZ256rmikz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2210
  {DBGFIELD("VGF2P8MULBZ256rmk_VGF2P8MULBZ256rmkz") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2211
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rrik_VGF2P8AFFINEQBZ128rrik") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2212
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rrik_VGF2P8AFFINEQBZ256rrik") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2213
  {DBGFIELD("VGF2P8MULBZ128rrk")  1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2214
  {DBGFIELD("VGF2P8MULBZ256rrk")  1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2215
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rrikz_VGF2P8AFFINEQBZ128rrikz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2216
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rrikz_VGF2P8AFFINEQBZ256rrikz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2217
  {DBGFIELD("VGF2P8MULBZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2218
  {DBGFIELD("VGF2P8MULBZ256rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2219
  {DBGFIELD("VGF2P8AFFINEINVQBZrmbik_VGF2P8AFFINEINVQBZrmbikz_VGF2P8AFFINEINVQBZrmik_VGF2P8AFFINEINVQBZrmikz_VGF2P8AFFINEQBZrmbik_VGF2P8AFFINEQBZrmbikz_VGF2P8AFFINEQBZrmik_VGF2P8AFFINEQBZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2220
  {DBGFIELD("VGF2P8MULBZrmk_VGF2P8MULBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2221
  {DBGFIELD("VGF2P8AFFINEINVQBZrrik_VGF2P8AFFINEQBZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2222
  {DBGFIELD("VGF2P8MULBZrrk")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2223
  {DBGFIELD("VGF2P8AFFINEINVQBZrrikz_VGF2P8AFFINEQBZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2224
  {DBGFIELD("VGF2P8MULBZrrkz")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2225
  {DBGFIELD("VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #2226
  {DBGFIELD("VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz") 1, false, false, false, 55, 3,  7, 1,  0, 0}, // #2227
  {DBGFIELD("VMOVSHZrmk_VMOVSHZrmkz") 1, false, false, false, 55, 3,  6, 1,  0, 0}, // #2228
  {DBGFIELD("VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #2229
  {DBGFIELD("VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 4, false, false, false, 843, 6,  9, 1,  6, 1}, // #2230
  {DBGFIELD("VMOVDQU16Z128rrk_VMOVDQU16Z128rrk_REV_VMOVDQU16Z128rrkz_VMOVDQU16Z128rrkz_REV_VMOVDQU8Z128rrk_VMOVDQU8Z128rrk_REV_VMOVDQU8Z128rrkz_VMOVDQU8Z128rrkz_REV_VPMOVM2BZ128rk_VPMOVM2WZ128rk") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #2231
  {DBGFIELD("VMOVDQU16Z256rrk_VMOVDQU16Z256rrk_REV_VMOVDQU16Z256rrkz_VMOVDQU16Z256rrkz_REV_VMOVDQU8Z256rrk_VMOVDQU8Z256rrk_REV_VMOVDQU8Z256rrkz_VMOVDQU8Z256rrkz_REV_VPMOVM2BZ256rk_VPMOVM2WZ256rk") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #2232
  {DBGFIELD("VMOVSHZrrk_VMOVSHZrrk_REV_VMOVSHZrrkz_VMOVSHZrrkz_REV") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #2233
  {DBGFIELD("VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #2234
  {DBGFIELD("VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 3, false, false, false, 849, 4,  5, 1,  0, 0}, // #2235
  {DBGFIELD("VMOVDQU8Zmrk")       2, false, false, false, 51, 4,  2, 1,  0, 0}, // #2236
  {DBGFIELD("VMOVNTDQZ128mr")     2, false, false, false, 51, 4, 25, 1,  0, 0}, // #2237
  {DBGFIELD("VMOVNTDQZ256mr")     2, false, false, false, 51, 4, 44, 1,  0, 0}, // #2238
  {DBGFIELD("VMOVNTDQZmr")        2, false, false, false, 51, 4, 44, 1,  0, 0}, // #2239
  {DBGFIELD("VMOVNTPDZ128mr")     2, false, false, false, 51, 4, 27, 1,  0, 0}, // #2240
  {DBGFIELD("VMOVNTPDZ256mr")     2, false, false, false, 51, 4, 45, 1,  0, 0}, // #2241
  {DBGFIELD("VMOVNTPDZmr")        2, false, false, false, 51, 4, 45, 1,  0, 0}, // #2242
  {DBGFIELD("VMOVNTPSZ128mr")     2, false, false, false, 51, 4, 27, 1,  0, 0}, // #2243
  {DBGFIELD("VMOVNTPSZ256mr")     2, false, false, false, 51, 4, 45, 1,  0, 0}, // #2244
  {DBGFIELD("VMOVNTPSZmr")        2, false, false, false, 51, 4, 45, 1,  0, 0}, // #2245
  {DBGFIELD("VP2INTERSECTDZ128rm_VP2INTERSECTDZ128rmb") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2246
  {DBGFIELD("VP2INTERSECTQZ256rm_VP2INTERSECTQZ256rmb") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2247
  {DBGFIELD("VP2INTERSECTDZ128rr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2248
  {DBGFIELD("VP2INTERSECTQZ256rr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2249
  {DBGFIELD("VP2INTERSECTDZ256rm_VP2INTERSECTDZ256rmb") 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2250
  {DBGFIELD("VP2INTERSECTDZ256rr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2251
  {DBGFIELD("VP2INTERSECTDZrm_VP2INTERSECTDZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2252
  {DBGFIELD("VP2INTERSECTDZrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2253
  {DBGFIELD("VP2INTERSECTQZ128rm_VP2INTERSECTQZ128rmb") 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2254
  {DBGFIELD("VP2INTERSECTQZ128rr") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2255
  {DBGFIELD("VP2INTERSECTQZrm_VP2INTERSECTQZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2256
  {DBGFIELD("VP2INTERSECTQZrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2257
  {DBGFIELD("VPABSBZ128rrk_VPABSBZ128rrkz_VPABSWZ128rrk_VPABSWZ128rrkz_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2258
  {DBGFIELD("VPABSBZ256rrk_VPABSBZ256rrkz_VPABSWZ256rrk_VPABSWZ256rrkz_VPSUBSBZ256rrk_VPSUBSBZ256rrkz_VPSUBSWZ256rrk_VPSUBSWZ256rrkz_VPADDSBZ256rrk_VPADDSBZ256rrkz_VPADDSWZ256rrk_VPADDSWZ256rrkz_VPADDUSBZ256rrk_VPADDUSBZ256rrkz_VPADDUSWZ256rrk_VPADDUSWZ256rrkz_VPAVGBZ256rrk_VPAVGBZ256rrkz_VPAVGWZ256rrk_VPAVGWZ256rrkz_VPMAXSBZ256rrk_VPMAXSBZ256rrkz_VPMAXUWZ256rrk_VPMAXUWZ256rrkz_VPMINSBZ256rrk_VPMINSBZ256rrkz_VPMINUWZ256rrk_VPMINUWZ256rrkz_VPMAXSWZ256rrk_VPMAXSWZ256rrkz_VPMAXUBZ256rrk_VPMAXUBZ256rrkz_VPMINSWZ256rrk_VPMINSWZ256rrkz_VPMINUBZ256rrk_VPMINUBZ256rrkz_VPSUBUSBZ256rrk_VPSUBUSBZ256rrkz_VPSUBUSWZ256rrk_VPSUBUSWZ256rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2259
  {DBGFIELD("VPMAXSBZ128rrk_VPMAXSBZ128rrkz_VPMAXUWZ128rrk_VPMAXUWZ128rrkz_VPMINSBZ128rrk_VPMINSBZ128rrkz_VPMINUWZ128rrk_VPMINUWZ128rrkz_VPMAXSWZ128rrk_VPMAXSWZ128rrkz_VPMAXUBZ128rrk_VPMAXUBZ128rrkz_VPMINSWZ128rrk_VPMINSWZ128rrkz_VPMINUBZ128rrk_VPMINUBZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2260
  {DBGFIELD("VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2261
  {DBGFIELD("VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2262
  {DBGFIELD("VPSLLVWZ128rrk_VPSLLVWZ128rrkz_VPSRLVWZ128rrk_VPSRLVWZ128rrkz_VPSRAVWZ128rrk_VPSRAVWZ128rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2263
  {DBGFIELD("VPSLLVWZ256rrk_VPSLLVWZ256rrkz_VPSRLVWZ256rrk_VPSRLVWZ256rrkz_VPSRAVWZ256rrk_VPSRAVWZ256rrkz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2264
  {DBGFIELD("VPSLLWZ128rik_VPSLLWZ128rikz_VPSRLWZ128rik_VPSRLWZ128rikz_VPSRAWZ128rik_VPSRAWZ128rikz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2265
  {DBGFIELD("VPSLLWZ256rik_VPSLLWZ256rikz_VPSRLWZ256rik_VPSRLWZ256rikz_VPSRAWZ256rik_VPSRAWZ256rikz") 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2266
  {DBGFIELD("VSHUFPDZ256rmbi_VSHUFPDZ256rmik_VSHUFPSZ256rmbi_VSHUFPSZ256rmik_VSHUFPDZ256rmbik_VSHUFPDZ256rmbikz_VSHUFPSZ256rmbik_VSHUFPSZ256rmbikz_VSHUFPDZ256rmi_VSHUFPDZ256rmikz_VSHUFPSZ256rmi_VSHUFPSZ256rmikz") 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #2267
  {DBGFIELD("VPBROADCASTMB2QZ128rr_VPBROADCASTMB2QZ256rr_VPBROADCASTMW2DZ128rr_VPBROADCASTMW2DZ256rr_VPBROADCASTMB2QZrr_VPBROADCASTMW2DZrr") 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #2268
  {DBGFIELD("VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2269
  {DBGFIELD("VPSRAWZrrk_VPSRAWZrrkz_VPSLLWZrrk_VPSLLWZrrkz_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2270
  {DBGFIELD("VPSHUFBITQMBZ128rr") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2271
  {DBGFIELD("VPSHUFBITQMBZ256rr") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2272
  {DBGFIELD("VPSHUFBITQMBZrr")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2273
  {DBGFIELD("VPCOMPRESSBZ128mr_VPCOMPRESSBZ256mr_VPCOMPRESSWZ128mr_VPCOMPRESSWZ256mr") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2274
  {DBGFIELD("VPCOMPRESSWZmr")     2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2275
  {DBGFIELD("VPCOMPRESSBZ128mrk_VPCOMPRESSBZ256mrk_VPCOMPRESSWZ128mrk_VPCOMPRESSWZ256mrk") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2276
  {DBGFIELD("VPCOMPRESSWZmrk")    2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2277
  {DBGFIELD("VPCOMPRESSBZmr")     2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2278
  {DBGFIELD("VPCOMPRESSBZmrk")    2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2279
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #2280
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #2281
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2282
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2283
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #2284
  {DBGFIELD("VPERMI2BZ128rm_VPERMT2BZ128rm") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2285
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #2286
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2287
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2288
  {DBGFIELD("VPERMI2BZ128rmk_VPERMI2BZ128rmkz_VPERMT2BZ128rmk_VPERMT2BZ128rmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2289
  {DBGFIELD("VPERMT2WZ128rm")     2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2290
  {DBGFIELD("VPERMI2BZ128rr_VPERMT2BZ128rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2291
  {DBGFIELD("VPERMI2BZ256rr_VPERMT2BZ256rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2292
  {DBGFIELD("VPERMI2BZ256rrk_VPERMI2BZ256rrkz_VPERMT2BZ256rrk_VPERMT2BZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2293
  {DBGFIELD("VPERMI2WZ128rr_VPERMT2WZ128rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2294
  {DBGFIELD("VPERMI2WZ256rr_VPERMT2WZ256rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2295
  {DBGFIELD("VPERMI2BZ256rm_VPERMT2BZ256rm") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2296
  {DBGFIELD("VPERMI2BZ256rmk_VPERMI2BZ256rmkz_VPERMT2BZ256rmk_VPERMT2BZ256rmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2297
  {DBGFIELD("VPERMI2WZ128rm")     2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2298
  {DBGFIELD("VPERMT2WZ256rm")     2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2299
  {DBGFIELD("VPERMI2BZrm_VPERMT2BZrm") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2300
  {DBGFIELD("VPERMI2BZrmk_VPERMI2BZrmkz_VPERMT2BZrmk_VPERMT2BZrmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2301
  {DBGFIELD("VPERMT2WZrm")        2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2302
  {DBGFIELD("VPERMI2BZrr_VPERMT2BZrr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2303
  {DBGFIELD("VPERMI2BZrrk_VPERMI2BZrrkz_VPERMT2BZrrk_VPERMT2BZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2304
  {DBGFIELD("VPERMI2WZrr_VPERMT2WZrr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2305
  {DBGFIELD("VPERMI2WZ128rmk_VPERMI2WZ128rmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2306
  {DBGFIELD("VPERMT2WZ256rmk_VPERMT2WZ256rmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2307
  {DBGFIELD("VPERMI2WZ256rm")     2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2308
  {DBGFIELD("VPERMI2WZ256rmk_VPERMI2WZ256rmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2309
  {DBGFIELD("VPERMI2WZrm")        2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2310
  {DBGFIELD("VPERMI2WZrmk_VPERMI2WZrmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2311
  {DBGFIELD("VPERMWZ128rm")       2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2312
  {DBGFIELD("VPERMWZ256rmk_VPERMWZ256rmkz") 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2313
  {DBGFIELD("VPERMWZ128rr")       1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2314
  {DBGFIELD("VPERMWZ256rr")       1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2315
  {DBGFIELD("VPERMWZ256rm")       2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2316
  {DBGFIELD("VPEXPANDBZ128rrk_VPEXPANDBZ128rrkz_VPEXPANDWZ128rrk_VPEXPANDWZ128rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2317
  {DBGFIELD("VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2318
  {DBGFIELD("VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrrk_VPEXPANDWZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2319
  {DBGFIELD("VPMADDUBSWZ128rrk_VPMADDUBSWZ128rrkz_VPMULHRSWZ128rrk_VPMULHRSWZ128rrkz_VPMULHUWZ128rrk_VPMULHUWZ128rrkz_VPMULHWZ128rrk_VPMULHWZ128rrkz_VPMULLWZ128rrk_VPMULLWZ128rrkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2320
  {DBGFIELD("VPMADDUBSWZ256rrk_VPMADDUBSWZ256rrkz_VPMULHRSWZ256rrk_VPMULHRSWZ256rrkz_VPMULHUWZ256rrk_VPMULHUWZ256rrkz_VPMULHWZ256rrk_VPMULHWZ256rrkz_VPMULLWZ256rrk_VPMULLWZ256rrkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2321
  {DBGFIELD("VPMADDUBSWZrmk_VPMADDUBSWZrmkz_VPMULHRSWZrmk_VPMULHRSWZrmkz_VPMULHUWZrmk_VPMULHUWZrmkz_VPMULHWZrmk_VPMULHWZrmkz_VPMULLWZrmk_VPMULLWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2322
  {DBGFIELD("VPMADDUBSWZrrk_VPMADDUBSWZrrkz_VPMULHRSWZrrk_VPMULHRSWZrrkz_VPMULHUWZrrk_VPMULHUWZrrkz_VPMULHWZrrk_VPMULHWZrrkz_VPMULLWZrrk_VPMULLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2323
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ256mr_VPMOVUSDBZ128mr_VPMOVUSDBZ256mr_VPMOVDWZ128mr_VPMOVDWZ256mr_VPMOVQWZ128mr_VPMOVQWZ256mr_VPMOVSDWZ128mr_VPMOVSDWZ256mr_VPMOVSQWZ128mr_VPMOVSQWZ256mr_VPMOVUSDWZ128mr_VPMOVUSDWZ256mr_VPMOVUSQWZ128mr_VPMOVUSQWZ256mr_VPMOVQBZ256mr_VPMOVSDBZ256mr_VPMOVSWBZ256mr_VPMOVWBZ256mr_VPMOVSDBZ128mr_VPMOVWBZ128mr_VPMOVSQBZ256mr_VPMOVUSQBZ256mr_VPMOVSQDZ128mr_VPMOVSQDZ256mr_VPMOVUSQDZ128mr_VPMOVUSQDZ256mr_VPMOVSWBZ128mr_VPMOVUSWBZ128mr") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2324
  {DBGFIELD("VPMOVUSWBZ256mr")    2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2325
  {DBGFIELD("VPMOVDBZ128mrk_VPMOVQBZ128mrk_VPMOVSQBZ128mrk_VPMOVSWBZ128mrk_VPMOVWBZ128mrk_VPMOVDWZ128mrk_VPMOVQWZ128mrk_VPMOVSDWZ128mrk_VPMOVSQWZ128mrk_VPMOVUSDWZ128mrk_VPMOVUSQWZ128mrk_VPMOVSDBZ128mrk_VPMOVSQDZ128mrk_VPMOVUSDBZ128mrk_VPMOVUSQDZ128mrk_VPMOVUSQBZ128mrk_VPMOVUSWBZ128mrk") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2326
  {DBGFIELD("VPMOVDBZ128rr_VPMOVQBZ128rr_VPMOVSQBZ128rr_VPMOVSWBZ128rr_VPMOVWBZ128rr_VPMOVDWZ128rr_VPMOVQWZ128rr_VPMOVSDWZ128rr_VPMOVSQWZ128rr_VPMOVUSDWZ128rr_VPMOVSDBZ128rr_VPMOVSQDZ128rr_VPMOVUSDBZ128rr_VPMOVUSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSWBZ128rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2327
  {DBGFIELD("VPMOVUSQWZ128rr")    1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2328
  {DBGFIELD("VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVDBZ256rr_VPMOVQBZ256rr_VPMOVSQBZ256rr_VPMOVSWBZ256rr_VPMOVWBZ256rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVDWZ256rr_VPMOVQWZ256rr_VPMOVSDWZ256rr_VPMOVSQWZ256rr_VPMOVUSDWZ256rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSQDZ256rr_VPMOVUSDBZ256rr_VPMOVUSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSWBZ256rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2329
  {DBGFIELD("VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz_VPMOVUSQWZ256rr") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2330
  {DBGFIELD("VPMOVDBZ256mrk_VPMOVQBZ256mrk_VPMOVSQBZ256mrk_VPMOVSWBZ256mrk_VPMOVWBZ256mrk_VPMOVDWZ256mrk_VPMOVQWZ256mrk_VPMOVSDWZ256mrk_VPMOVSQWZ256mrk_VPMOVUSDWZ256mrk_VPMOVUSQWZ256mrk_VPMOVSDBZ256mrk_VPMOVSQDZ256mrk_VPMOVUSDBZ256mrk_VPMOVUSQDZ256mrk_VPMOVUSQBZ256mrk_VPMOVUSWBZ256mrk") 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2331
  {DBGFIELD("VPMOVUSQWZ256rrk_VPMOVUSQWZ256rrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2332
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2333
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2334
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2335
  {DBGFIELD("VPSCATTERQDZ256mr_VSCATTERQPSZ256mr") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #2336
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 2, false, false, false, 51, 4,  2, 1,  0, 0}, // #2337
  {DBGFIELD("VPSHLDDZ128rmbi_VPSHLDQZ128rmbi_VPSHRDDZ128rmbi_VPSHRDQZ128rmbi_VPSHLDDZ128rmi_VPSHLDQZ128rmi_VPSHLDWZ128rmi_VPSHRDDZ128rmi_VPSHRDQZ128rmi_VPSHRDWZ128rmi_VPSHLDVDZ128m_VPSHLDVQZ128m_VPSHLDVWZ128m_VPSHRDVDZ128m_VPSHRDVQZ128m_VPSHRDVWZ128m_VPSHLDVDZ128mb_VPSHLDVDZ128mk_VPSHLDVDZ128mkz_VPSHLDVQZ128mb_VPSHLDVQZ128mk_VPSHLDVQZ128mkz_VPSHRDVDZ128mb_VPSHRDVDZ128mk_VPSHRDVDZ128mkz_VPSHRDVQZ128mb_VPSHRDVQZ128mk_VPSHRDVQZ128mkz_VPSHLDVDZ128mbk_VPSHLDVDZ128mbkz_VPSHLDVQZ128mbk_VPSHLDVQZ128mbkz_VPSHRDVDZ128mbk_VPSHRDVDZ128mbkz_VPSHRDVQZ128mbk_VPSHRDVQZ128mbkz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2338
  {DBGFIELD("VPSHLDDZ128rmbik_VPSHLDDZ128rmbikz_VPSHLDDZ128rmik_VPSHLDDZ128rmikz_VPSHLDQZ128rmbik_VPSHLDQZ128rmbikz_VPSHLDQZ128rmik_VPSHLDQZ128rmikz_VPSHRDDZ128rmbik_VPSHRDDZ128rmbikz_VPSHRDDZ128rmik_VPSHRDDZ128rmikz_VPSHRDQZ128rmbik_VPSHRDQZ128rmbikz_VPSHRDQZ128rmik_VPSHRDQZ128rmikz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2339
  {DBGFIELD("VPSHLDDZ128rri_VPSHLDQZ128rri_VPSHLDWZ128rri_VPSHRDDZ128rri_VPSHRDQZ128rri_VPSHRDWZ128rri_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2340
  {DBGFIELD("VPSHLDDZ256rri_VPSHLDQZ256rri_VPSHLDWZ256rri_VPSHRDDZ256rri_VPSHRDQZ256rri_VPSHRDWZ256rri_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2341
  {DBGFIELD("VPSHLDVDZ128r_VPSHLDVQZ128r_VPSHLDVWZ128r_VPSHRDVDZ128r_VPSHRDVQZ128r_VPSHRDVWZ128r") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2342
  {DBGFIELD("VPSHLDVDZ256r_VPSHLDVQZ256r_VPSHLDVWZ256r_VPSHRDVDZ256r_VPSHRDVQZ256r_VPSHRDVWZ256r") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2343
  {DBGFIELD("VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rrik_VPSHRDQZ128rrikz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2344
  {DBGFIELD("VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rrik_VPSHRDQZ256rrikz") 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2345
  {DBGFIELD("VPSHLDDZ256rmbi_VPSHLDQZ256rmbi_VPSHRDDZ256rmbi_VPSHRDQZ256rmbi_VPSHLDDZ256rmi_VPSHLDQZ256rmi_VPSHLDWZ256rmi_VPSHRDDZ256rmi_VPSHRDQZ256rmi_VPSHRDWZ256rmi_VPSHLDVDZ256m_VPSHLDVQZ256m_VPSHLDVWZ256m_VPSHRDVDZ256m_VPSHRDVQZ256m_VPSHRDVWZ256m_VPSHLDVDZ256mb_VPSHLDVDZ256mk_VPSHLDVDZ256mkz_VPSHLDVQZ256mb_VPSHLDVQZ256mk_VPSHLDVQZ256mkz_VPSHRDVDZ256mb_VPSHRDVDZ256mk_VPSHRDVDZ256mkz_VPSHRDVQZ256mb_VPSHRDVQZ256mk_VPSHRDVQZ256mkz_VPSHLDVDZ256mbk_VPSHLDVDZ256mbkz_VPSHLDVQZ256mbk_VPSHLDVQZ256mbkz_VPSHRDVDZ256mbk_VPSHRDVDZ256mbkz_VPSHRDVQZ256mbk_VPSHRDVQZ256mbkz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2346
  {DBGFIELD("VPSHLDDZ256rmbik_VPSHLDDZ256rmbikz_VPSHLDDZ256rmik_VPSHLDDZ256rmikz_VPSHLDQZ256rmbik_VPSHLDQZ256rmbikz_VPSHLDQZ256rmik_VPSHLDQZ256rmikz_VPSHRDDZ256rmbik_VPSHRDDZ256rmbikz_VPSHRDDZ256rmik_VPSHRDDZ256rmikz_VPSHRDQZ256rmbik_VPSHRDQZ256rmbikz_VPSHRDQZ256rmik_VPSHRDQZ256rmikz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2347
  {DBGFIELD("VPSHLDDZrmbi_VPSHLDQZrmbi_VPSHRDDZrmbi_VPSHRDQZrmbi_VPSHLDDZrmi_VPSHLDQZrmi_VPSHLDWZrmi_VPSHRDDZrmi_VPSHRDQZrmi_VPSHRDWZrmi_VPSHLDVDZm_VPSHLDVQZm_VPSHLDVWZm_VPSHRDVDZm_VPSHRDVQZm_VPSHRDVWZm_VPSHLDVDZmb_VPSHLDVDZmk_VPSHLDVDZmkz_VPSHLDVQZmb_VPSHLDVQZmk_VPSHLDVQZmkz_VPSHRDVDZmb_VPSHRDVDZmk_VPSHRDVDZmkz_VPSHRDVQZmb_VPSHRDVQZmk_VPSHRDVQZmkz_VPSHLDVDZmbk_VPSHLDVDZmbkz_VPSHLDVQZmbk_VPSHLDVQZmbkz_VPSHRDVDZmbk_VPSHRDVDZmbkz_VPSHRDVQZmbk_VPSHRDVQZmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2348
  {DBGFIELD("VPSHLDDZrmbik_VPSHLDDZrmbikz_VPSHLDDZrmik_VPSHLDDZrmikz_VPSHLDQZrmbik_VPSHLDQZrmbikz_VPSHLDQZrmik_VPSHLDQZrmikz_VPSHRDDZrmbik_VPSHRDDZrmbikz_VPSHRDDZrmik_VPSHRDDZrmikz_VPSHRDQZrmbik_VPSHRDQZrmbikz_VPSHRDQZrmik_VPSHRDQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2349
  {DBGFIELD("VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrrik_VPSHRDQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2350
  {DBGFIELD("VPSHLDWZ128rmik_VPSHLDWZ128rmikz_VPSHRDWZ128rmik_VPSHRDWZ128rmikz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2351
  {DBGFIELD("VPSHLDWZ256rmik_VPSHLDWZ256rmikz_VPSHRDWZ256rmik_VPSHRDWZ256rmikz") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2352
  {DBGFIELD("VPSHLDWZrmik_VPSHLDWZrmikz_VPSHRDWZrmik_VPSHRDWZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2353
  {DBGFIELD("VPSHUFBITQMBZ128rm") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2354
  {DBGFIELD("VPSHUFBITQMBZ256rm") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2355
  {DBGFIELD("VPSHUFBITQMBZrm")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2356
  {DBGFIELD("VPSHUFBITQMBZ128rmk") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2357
  {DBGFIELD("VPSHUFBITQMBZ256rmk") 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2358
  {DBGFIELD("VPSHUFBITQMBZrmk")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2359
  {DBGFIELD("VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRAWZ128rrk_VPSRAWZ128rrkz") 2, false, false, false, 718, 7, 12, 1,  0, 0}, // #2360
  {DBGFIELD("VRCPPHZmbk_VRCPPHZmkz_VRCPPHZmbkz_VRCPPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2361
  {DBGFIELD("VRSQRTPHZmbk_VRSQRTPHZmkz_VRSQRTPHZmbkz_VRSQRTPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2362
  {DBGFIELD("VRCPPHZrk_VRCPPHZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2363
  {DBGFIELD("VREDUCEPHZ128rmbi_VREDUCEPHZ128rmi") 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #2364
  {DBGFIELD("VREDUCESHZrmi")      3, false, false, false, 113, 7, 11, 1,  6, 1}, // #2365
  {DBGFIELD("VREDUCEPHZ256rmbi_VREDUCEPHZ256rmi") 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #2366
  {DBGFIELD("VREDUCEPHZ128rmbik_VREDUCEPHZ128rmbikz_VREDUCEPHZ128rmik_VREDUCEPHZ128rmikz_VREDUCESHZrmik_VREDUCESHZrmikz") 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #2367
  {DBGFIELD("VREDUCEPHZ256rmbik_VREDUCEPHZ256rmbikz_VREDUCEPHZ256rmik_VREDUCEPHZ256rmikz") 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #2368
  {DBGFIELD("VREDUCEPHZ128rri_VREDUCESHZrri_VREDUCESHZrrib") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2369
  {DBGFIELD("VREDUCEPHZ256rri")   2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2370
  {DBGFIELD("VREDUCEPHZ128rrik_VREDUCEPHZ128rrikz_VREDUCESHZrribk_VREDUCESHZrrikz_VREDUCESHZrribkz_VREDUCESHZrrik") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2371
  {DBGFIELD("VREDUCEPHZ256rrik_VREDUCEPHZ256rrikz") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2372
  {DBGFIELD("VREDUCEPHZrmbi_VREDUCEPHZrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2373
  {DBGFIELD("VREDUCEPHZrmbik_VREDUCEPHZrmbikz_VREDUCEPHZrmik_VREDUCEPHZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2374
  {DBGFIELD("VREDUCEPHZrri_VREDUCEPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2375
  {DBGFIELD("VREDUCEPHZrribk_VREDUCEPHZrrikz_VREDUCEPHZrribkz_VREDUCEPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2376
  {DBGFIELD("VRNDSCALEPDZrri_VRNDSCALEPDZrrib_VRNDSCALEPDZrribk_VRNDSCALEPDZrrik_VRNDSCALEPDZrrikz_VRNDSCALEPSZrri_VRNDSCALEPSZrrib_VRNDSCALEPSZrribk_VRNDSCALEPSZrrik_VRNDSCALEPSZrrikz_VRNDSCALEPDZrribkz_VRNDSCALEPSZrribkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2377
  {DBGFIELD("VRNDSCALEPHZ128rmbik_VRNDSCALEPHZ128rmbikz_VRNDSCALEPHZ128rmik_VRNDSCALEPHZ128rmikz_VRNDSCALESHZrmik_Int_VRNDSCALESHZrmikz_Int") 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #2378
  {DBGFIELD("VSCALEFPHZ128rmbk_VSCALEFPHZ128rmkz_VSCALEFPHZ128rmbkz_VSCALEFPHZ128rmk") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2379
  {DBGFIELD("VRNDSCALEPHZ256rmbik_VRNDSCALEPHZ256rmbikz_VRNDSCALEPHZ256rmik_VRNDSCALEPHZ256rmikz") 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #2380
  {DBGFIELD("VSCALEFPHZ256rmbk_VSCALEFPHZ256rmkz_VSCALEFPHZ256rmbkz_VSCALEFPHZ256rmk") 2, false, false, false, 78, 8,  8, 1,  6, 1}, // #2381
  {DBGFIELD("VSCALEFSHZrmk_VSCALEFSHZrmkz") 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2382
  {DBGFIELD("VRNDSCALEPHZ128rrik_VRNDSCALEPHZ128rrikz_VRNDSCALESHZrribk_Int_VRNDSCALESHZrribkz_Int_VRNDSCALESHZrrik_Int_VRNDSCALESHZrrikz_Int") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2383
  {DBGFIELD("VRNDSCALEPHZ256rrik_VRNDSCALEPHZ256rrikz") 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2384
  {DBGFIELD("VSCALEFPHZ128rrk_VSCALEFPHZ128rrkz") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #2385
  {DBGFIELD("VSCALEFPHZ256rrk_VSCALEFPHZ256rrkz") 1, false, false, false, 86, 6,  5, 1,  0, 0}, // #2386
  {DBGFIELD("VSCALEFSHZrrbk_Int_VSCALEFSHZrrbkz_Int_VSCALEFSHZrrk_VSCALEFSHZrrkz") 1, false, false, false, 92, 9,  5, 1,  0, 0}, // #2387
  {DBGFIELD("VRNDSCALEPHZrmbik_VRNDSCALEPHZrmbikz_VRNDSCALEPHZrmik_VRNDSCALEPHZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2388
  {DBGFIELD("VSCALEFPHZrmbk_VSCALEFPHZrmkz_VSCALEFPHZrmbkz_VSCALEFPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2389
  {DBGFIELD("VRNDSCALEPHZrribk_VRNDSCALEPHZrrikz_VRNDSCALEPHZrribkz_VRNDSCALEPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2390
  {DBGFIELD("VSCALEFPHZrrbk_VSCALEFPHZrrkz_VSCALEFPHZrrbkz_VSCALEFPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2391
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PSZr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2392
  {DBGFIELD("VRSQRT14PSZrk")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2393
  {DBGFIELD("VRSQRTPHZr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2394
  {DBGFIELD("VSQRTPDYm")          2, false, false, false, 243, 11, 46, 1,  0, 0}, // #2395
  {DBGFIELD("VSQRTPDZ256m_VSQRTPDZ256mb") 2, false, false, false, 243, 11, 46, 1,  6, 1}, // #2396
  {DBGFIELD("VSQRTPDZ128mbk_VSQRTPDZ128mkz_VSQRTPDZ128mbkz_VSQRTPDZ128mk") 2, false, false, false, 243, 11, 41, 1,  6, 1}, // #2397
  {DBGFIELD("VSQRTSDZmk_Int_VSQRTSDZmkz_Int") 2, false, false, false, 243, 11, 18, 1,  6, 1}, // #2398
  {DBGFIELD("VSQRTPDZm")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2399
  {DBGFIELD("VSQRTPDZmb")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2400
  {DBGFIELD("VSQRTPDZr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2401
  {DBGFIELD("VSQRTPHZ128mbk_VSQRTPHZ128mkz_VSQRTPHZ128mbkz_VSQRTPHZ128mk") 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #2402
  {DBGFIELD("VSQRTPHZ128rk")      1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2403
  {DBGFIELD("VSQRTPHZ256rk")      1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2404
  {DBGFIELD("VSQRTPHZ256rkz")     1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2405
  {DBGFIELD("VSQRTPHZ128rkz")     1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2406
  {DBGFIELD("VSQRTPHZ256m_VSQRTPHZ256mb") 2, false, false, false, 243, 11, 15, 1,  6, 1}, // #2407
  {DBGFIELD("VSQRTPHZ256mbk_VSQRTPHZ256mkz_VSQRTPHZ256mbkz_VSQRTPHZ256mk") 2, false, false, false, 243, 11, 15, 1,  6, 1}, // #2408
  {DBGFIELD("VSQRTPHZm_VSQRTPHZmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2409
  {DBGFIELD("VSQRTPHZmbk_VSQRTPHZmkz_VSQRTPHZmbkz_VSQRTPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2410
  {DBGFIELD("VSQRTPHZr_VSQRTPHZrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2411
  {DBGFIELD("VSQRTPHZrbk_VSQRTPHZrkz_VSQRTPHZrbkz_VSQRTPHZrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2412
  {DBGFIELD("VSQRTPSZr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2413
  {DBGFIELD("XTEST")              1, false, false, false, 35, 3,  4, 1,  0, 0}, // #2414
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2415
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2416
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2417
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2418
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2419
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2420
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2421
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2422
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2423
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2424
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2425
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2426
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2427
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2428
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2429
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2430
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2431
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2432
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2433
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2434
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2435
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2436
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2437
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2438
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2439
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2440
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2441
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2442
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2443
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2444
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2445
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2446
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2447
  {DBGFIELD("WriteALU")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2448
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2449
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2450
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2451
  {DBGFIELD("Zn4WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2452
  {DBGFIELD("PdWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2453
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2454
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2455
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2456
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2457
  {DBGFIELD("WriteFLogic")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2458
  {DBGFIELD("WriteFLogicY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2459
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2460
  {DBGFIELD("WriteVecLogicX")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2461
  {DBGFIELD("WriteVecALUX")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2462
  {DBGFIELD("SKLWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2463
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2464
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2465
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2466
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2467
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2468
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2469
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2470
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2471
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2472
  {DBGFIELD("WriteCMOV")          0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2473
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2474
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2475
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2476
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2477
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2478
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2479
  {DBGFIELD("WriteCMOVLd")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2480
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2481
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2482
  {DBGFIELD("PdWriteCMOVm")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2483
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2484
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2485
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2486
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2487
  {DBGFIELD("WriteSETCC")         0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2488
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2489
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2490
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2491
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2492
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2493
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2494
  {DBGFIELD("WriteSETCCStore")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2495
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2496
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2497
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2498
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2499
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2500
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2501
  {DBGFIELD("WriteVecLogicY")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2502
  {DBGFIELD("WriteVecALUY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2503
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2504
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2505
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2506
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2507
  {DBGFIELD("WriteLEA")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2508
  {DBGFIELD("Zn4Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2509
  {DBGFIELD("PdWrite3OpsLEA")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2510
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2511
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2512
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2513
  {DBGFIELD("WriteVecLogic")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2514
  {DBGFIELD("WriteVecALU")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2515
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2516
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2517
}; // AlderlakePModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AtomModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  5, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  5, 1,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false,  4, 2,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    1, false, false, false, 2619, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        1, false, false, false,  4, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  5, 1,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteLEA")           1, false, false, false,  4, 2,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteRMW")           1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteADC")           1, false, false, false,  5, 1,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 114, 1, 12, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreX")       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteFStoreY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #15
  {DBGFIELD("WriteFLoadY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #16
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  5, 1,  4, 1,  0, 0}, // #17
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #18
  {DBGFIELD("WriteFSign")         1, false, false, false,  4, 2,  1, 1,  0, 0}, // #19
  {DBGFIELD("WriteADCRMW")        1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #20
  {DBGFIELD("WriteADCLd_ReadAfterLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #21
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 2621, 2,  1, 1, 15, 2}, // #22
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2621, 2,  1, 1, 17, 2}, // #23
  {DBGFIELD("WriteALURMW")        1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #24
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #25
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2621, 2,  1, 1, 15, 1}, // #26
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 4, false, false, false, 2623, 3,  6, 1, 14, 1}, // #27
  {DBGFIELD("WriteFAdd64X")       3, false, false, false, 2626, 3,  3, 1,  0, 0}, // #28
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, false, 381, 3, 10, 1, 14, 1}, // #29
  {DBGFIELD("WriteFAddX")         1, false, false, false,  4, 2, 10, 1,  0, 0}, // #30
  {DBGFIELD("WriteNop")           1, false, false, false,  5, 1,  1, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, false, 381, 3, 10, 1, 14, 1}, // #32
  {DBGFIELD("WriteFAdd64")        1, false, false, false,  4, 2, 10, 1,  0, 0}, // #33
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, false, 381, 3, 10, 1, 14, 1}, // #34
  {DBGFIELD("WriteFAdd")          1, false, false, false,  4, 2, 10, 1,  0, 0}, // #35
  {DBGFIELD("WriteFAddLd")        1, false, false, false, 381, 3, 10, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("WriteAESDecEnc")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("WriteAESIMCLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #39
  {DBGFIELD("WriteAESIMC")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #40
  {DBGFIELD("WriteAESKeyGenLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #41
  {DBGFIELD("WriteAESKeyGen")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #43
  {DBGFIELD("WriteFLogic")        1, false, false, false,  5, 1,  1, 1,  0, 0}, // #44
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("WriteBEXTR")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #46
  {DBGFIELD("WriteBEXTRLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD("WriteALULd")         1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #48
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #49
  {DBGFIELD("WriteFBlend")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #50
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #51
  {DBGFIELD("WriteFVarBlend")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #52
  {DBGFIELD("WriteBLSLd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #53
  {DBGFIELD("WriteBLS")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #54
  {DBGFIELD("WriteBSFLd")         10, false, false, false, 2629, 3, 16, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSF")           10, false, false, false, 2629, 3, 16, 1,  0, 0}, // #56
  {DBGFIELD("WriteBSRLd")         10, false, false, false, 2629, 3, 16, 1,  0, 0}, // #57
  {DBGFIELD("WriteBSR")           10, false, false, false, 2629, 3, 16, 1,  0, 0}, // #58
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBSWAP64")       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestRegLd")  1, false, false, false, 407, 1, 22, 1,  0, 0}, // #62
  {DBGFIELD("WriteBitTest")       1, false, false, false,  4, 2,  1, 1,  0, 0}, // #63
  {DBGFIELD("WriteBitTestSetImmRMW") 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #64
  {DBGFIELD("WriteBitTestSetRegRMW") 1, false, false, false, 127, 1,  8, 1,  0, 0}, // #65
  {DBGFIELD("WriteBitTestSet")    1, false, false, false,  4, 2,  1, 1,  0, 0}, // #66
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #67
  {DBGFIELD("WriteBZHI")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #68
  {DBGFIELD("WriteCMOV_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #69
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #70
  {DBGFIELD("WriteCMOV")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #71
  {DBGFIELD("WriteLoad")          1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 407, 1, 22, 1,  0, 0}, // #73
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2621, 2,  1, 1, 15, 1}, // #74
  {DBGFIELD("WriteXCHG")          1, false, false, false, 114, 1, 12, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 4, false, false, false, 2623, 3,  6, 1, 14, 1}, // #76
  {DBGFIELD("WriteFCmp64X")       3, false, false, false, 2626, 3,  3, 1,  0, 0}, // #77
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 4, false, false, false, 2623, 3,  6, 1, 14, 1}, // #78
  {DBGFIELD("WriteFCmpX")         3, false, false, false, 2626, 3,  3, 1,  0, 0}, // #79
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, false, 381, 3, 10, 1, 14, 1}, // #80
  {DBGFIELD("WriteFCmp64")        1, false, false, false,  4, 2, 10, 1,  0, 0}, // #81
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, false, 381, 3, 10, 1, 14, 1}, // #82
  {DBGFIELD("WriteFCmp")          1, false, false, false,  4, 2, 10, 1,  0, 0}, // #83
  {DBGFIELD("WriteCMPXCHG")       1, false, false, false, 2632, 1, 11, 1,  0, 0}, // #84
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 5, false, false, false, 2633, 3,  9, 1, 14, 1}, // #85
  {DBGFIELD("WriteFComX")         4, false, false, false, 2636, 3, 22, 1,  0, 0}, // #86
  {DBGFIELD("WriteFCom")          1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #87
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #88
  {DBGFIELD("WriteCRC32")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #89
  {DBGFIELD("WriteCvtI2PDLd")     4, false, false, false, 2641, 3,  7, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2PD")       3, false, false, false, 2623, 3,  6, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2PSLd")     4, false, false, false, 2641, 3,  6, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtI2PS")       3, false, false, false, 2623, 3,  3, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPD2ILd")     5, false, false, false, 2644, 3,  7, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPD2I")       4, false, false, false, 2641, 3,  6, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtPD2PSLd")    5, false, false, false, 2647, 3,  2, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtPD2PS")      4, false, false, false, 2650, 3,  8, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtPS2ILd")     4, false, false, false, 2641, 3,  6, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtPS2I")       3, false, false, false, 2623, 3,  3, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtPS2PDLd")    5, false, false, false, 2641, 3,  7, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtPS2PD")      4, false, false, false, 2623, 3,  6, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtSD2ILd")     4, false, false, false, 2633, 3, 22, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 3, false, false, false, 2644, 3,  7, 1,  0, 0}, // #103
  {DBGFIELD("WriteCvtSD2I")       3, false, false, false, 2644, 3,  7, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 4, false, false, false, 2647, 3,  8, 1, 14, 1}, // #105
  {DBGFIELD("WriteCvtSD2SS")      3, false, false, false, 2633, 3,  9, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SDLd")     3, false, false, false, 2641, 3,  6, 1,  0, 0}, // #107
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 3, false, false, false, 2641, 3,  6, 1, 14, 1}, // #108
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 3, false, false, false, 2623, 3,  3, 1,  0, 1}, // #109
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 3, false, false, false, 2623, 3,  3, 1,  7, 1}, // #110
  {DBGFIELD("WriteCvtI2SSLd")     1, false, false, false, 2623, 3,  6, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 1, false, false, false, 2623, 3,  6, 1, 14, 1}, // #112
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 3, false, false, false, 2623, 3,  3, 1,  0, 1}, // #113
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 3, false, false, false, 2623, 3,  3, 1,  7, 1}, // #114
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 4, false, false, false, 2641, 3,  6, 1, 14, 1}, // #115
  {DBGFIELD("WriteCvtSS2SD")      3, false, false, false, 2623, 3,  3, 1,  0, 0}, // #116
  {DBGFIELD("WriteCvtSS2ILd")     4, false, false, false, 2636, 3, 22, 1,  0, 0}, // #117
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 3, false, false, false, 2644, 3,  7, 1,  0, 0}, // #118
  {DBGFIELD("WriteCvtSS2I")       3, false, false, false, 2644, 3,  7, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 2653, 3, 96, 1, 15, 2}, // #120
  {DBGFIELD("WriteDiv16")         12, false, false, false, 2653, 3, 96, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 2653, 3, 96, 1, 15, 2}, // #122
  {DBGFIELD("WriteDiv32")         12, false, false, false, 2653, 3, 96, 1,  0, 0}, // #123
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 38, false, false, false, 2656, 3, 97, 1, 15, 2}, // #124
  {DBGFIELD("WriteDiv64")         38, false, false, false, 2656, 3, 97, 1,  0, 0}, // #125
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 9, false, false, false, 2659, 3, 98, 1, 15, 2}, // #126
  {DBGFIELD("WriteDiv8")          9, false, false, false, 2653, 3, 96, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 7, false, false, false, 2662, 3, 99, 1, 14, 1}, // #128
  {DBGFIELD("WriteFDiv64X")       6, false, false, false, 2662, 3, 99, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 7, false, false, false, 2665, 3, 61, 1, 14, 1}, // #130
  {DBGFIELD("WriteFDivX")         6, false, false, false, 2665, 3, 61, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd")        4, false, false, false, 2668, 3, 100, 1,  0, 0}, // #132
  {DBGFIELD("WriteFDiv")          3, false, false, false, 2668, 3, 100, 1,  0, 0}, // #133
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 4, false, false, false, 2671, 3, 68, 1, 14, 1}, // #134
  {DBGFIELD("WriteFDiv64")        3, false, false, false, 2671, 3, 68, 1,  0, 0}, // #135
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 4, false, false, false, 2668, 3, 100, 1, 14, 1}, // #136
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #137
  {DBGFIELD("WriteDPPD")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #138
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #139
  {DBGFIELD("WriteDPPS")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #140
  {DBGFIELD("WriteStore")         1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #141
  {DBGFIELD("WriteVecExtractSt")  1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #142
  {DBGFIELD("WriteVecExtract")    1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUX")       1, false, false, false,  5, 1,  1, 1,  0, 0}, // #144
  {DBGFIELD("WriteFComLd")        1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #145
  {DBGFIELD("WriteEMMS")          1, false, false, false, 349, 1, 10, 1,  0, 0}, // #146
  {DBGFIELD("WriteFLDC")          1, false, false, false, 2280, 1,  9, 1,  0, 0}, // #147
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, false, 2674, 2, 10, 1, 14, 1}, // #148
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 2674, 2, 10, 1,  0, 0}, // #149
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #150
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 6, false, false, false, 2636, 3, 22, 1, 14, 1}, // #151
  {DBGFIELD("WriteFHAdd")         5, false, false, false, 2644, 3,  7, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 2671, 3, 68, 1, 15, 2}, // #153
  {DBGFIELD("WriteIDiv16")        29, false, false, false, 2671, 3, 68, 1,  0, 0}, // #154
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 2671, 3, 68, 1, 15, 2}, // #155
  {DBGFIELD("WriteIDiv32")        29, false, false, false, 2671, 3, 68, 1,  0, 0}, // #156
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 60, false, false, false, 2656, 3, 97, 1, 15, 2}, // #157
  {DBGFIELD("WriteIDiv64")        60, false, false, false, 2656, 3, 97, 1,  0, 0}, // #158
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 26, false, false, false, 2671, 3, 68, 1, 15, 2}, // #159
  {DBGFIELD("WriteIDiv8")         26, false, false, false, 2671, 3, 68, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 2644, 3,  7, 1, 15, 2}, // #161
  {DBGFIELD("WriteIMul16")        4, false, false, false, 2641, 3,  6, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 3, false, false, false, 2641, 3,  6, 1, 14, 1}, // #163
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 2641, 3,  6, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul16Reg")     2, false, false, false, 2623, 3,  3, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 2623, 3,  3, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 2641, 3,  6, 1, 15, 2}, // #167
  {DBGFIELD("WriteIMul32")        3, false, false, false, 2623, 3,  3, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, false, 2639, 2, 10, 1, 14, 1}, // #169
  {DBGFIELD("WriteIMul32ImmLd")   1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2647, 3,  2, 1, 15, 2}, // #173
  {DBGFIELD("WriteIMul64")        8, false, false, false, 2647, 3,  2, 1,  0, 0}, // #174
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 6, false, false, false, 2647, 3,  2, 1, 14, 1}, // #175
  {DBGFIELD("WriteIMul64ImmLd")   7, false, false, false, 2676, 3, 21, 1,  0, 0}, // #176
  {DBGFIELD("WriteIMul64Reg")     6, false, false, false, 2647, 3,  2, 1,  0, 0}, // #177
  {DBGFIELD("WriteIMul64Imm")     7, false, false, false, 2676, 3, 21, 1,  0, 0}, // #178
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 2641, 3,  6, 1, 15, 2}, // #179
  {DBGFIELD("WriteIMul8")         3, false, false, false, 2641, 3,  6, 1,  0, 0}, // #180
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #181
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecLogicX")     1, false, false, false,  5, 1,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteShuffle")       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 114, 1, 12, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 2626, 3, 10, 1,  0, 0}, // #187
  {DBGFIELD("WriteFLD0")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteFLD1")          1, false, false, false, 630, 1,  3, 1,  0, 0}, // #189
  {DBGFIELD("WriteFence")         1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteLZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #191
  {DBGFIELD("WriteLZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #192
  {DBGFIELD("WriteVecStoreX")     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStore")      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 2679, 2,  5, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteVecMoveX")      1, false, false, false,  5, 1,  1, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecStoreNT")    1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #199
  {DBGFIELD("WriteVecMove")       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #200
  {DBGFIELD("WriteVecALULd")      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #201
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #202
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #203
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #204
  {DBGFIELD("WriteVecLogic")      1, false, false, false,  5, 1,  1, 1,  0, 0}, // #205
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 2681, 3, 14, 1, 14, 1}, // #206
  {DBGFIELD("WritePHAdd")         3, false, false, false, 2684, 3,  5, 1,  0, 0}, // #207
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #208
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 1, false, false, false, 2621, 2,  1, 1,  7, 1}, // #209
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, false, 2621, 2, 14, 1, 14, 1}, // #210
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 2621, 2, 14, 1,  0, 0}, // #211
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false, 2679, 2,  5, 1,  0, 0}, // #212
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 1, false, false, false, 2621, 2, 14, 1, 14, 1}, // #213
  {DBGFIELD("WritePSADBW")        1, false, false, false, 2621, 2, 14, 1,  0, 0}, // #214
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #215
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteShuffleLd")     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 3, false, false, false, 2687, 3,  5, 1, 14, 1}, // #219
  {DBGFIELD("WriteVecShift")      2, false, false, false, 381, 3, 12, 1,  0, 0}, // #220
  {DBGFIELD("WriteFMoveX")        1, false, false, false,  5, 1,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFShuffleLd")    1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStore")        1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #223
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false, 2679, 2,  5, 1,  0, 0}, // #224
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #225
  {DBGFIELD("WriteStoreNT")       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #226
  {DBGFIELD("WriteFStoreNTX")     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #227
  {DBGFIELD("WriteFStoreNT")      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #228
  {DBGFIELD("WriteFLoad")         1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #229
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #230
  {DBGFIELD("WriteMPSAD")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #231
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 7, false, false, false, 2633, 3,  9, 1, 14, 1}, // #232
  {DBGFIELD("WriteFMul64X")       6, false, false, false, 2636, 3, 22, 1,  0, 0}, // #233
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, false, 2674, 2, 10, 1, 14, 1}, // #234
  {DBGFIELD("WriteFMulX")         1, false, false, false, 2674, 2, 10, 1,  0, 0}, // #235
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, false, 2674, 2, 10, 1, 14, 1}, // #236
  {DBGFIELD("WriteFMul64")        1, false, false, false, 2674, 2, 10, 1,  0, 0}, // #237
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, false, 2674, 2, 14, 1, 14, 1}, // #238
  {DBGFIELD("WriteFMul")          1, false, false, false, 2674, 2, 14, 1,  0, 0}, // #239
  {DBGFIELD("WriteMULX32Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("WriteMULX32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteIMulH_WriteMULX32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #243
  {DBGFIELD("WriteMULX64Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #244
  {DBGFIELD("WriteMULX64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #245
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #246
  {DBGFIELD("WriteIMulH_WriteMULX64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #247
  {DBGFIELD("WriteFMulLd")        1, false, false, false, 2674, 2, 14, 1,  0, 0}, // #248
  {DBGFIELD("WriteVecALUXLd")     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #249
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #250
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #252
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #253
  {DBGFIELD("WriteVarBlend")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #254
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #255
  {DBGFIELD("WriteBlend")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #256
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #257
  {DBGFIELD("WriteCLMul")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #258
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #259
  {DBGFIELD("WritePCmpEStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #260
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #261
  {DBGFIELD("WritePCmpEStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #262
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #263
  {DBGFIELD("WritePCmpIStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #264
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #265
  {DBGFIELD("WritePCmpIStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #266
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 4, false, false, false, 2641, 3,  6, 1, 14, 1}, // #267
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 2644, 3,  7, 1, 14, 1}, // #268
  {DBGFIELD("WritePHAddX")        3, false, false, false, 2641, 3,  6, 1,  0, 0}, // #269
  {DBGFIELD("WritePHMINPOSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #270
  {DBGFIELD("WritePHMINPOS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #271
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 4, false, false, false, 2641, 3,  6, 1, 14, 1}, // #272
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false, 2679, 2,  5, 1,  0, 0}, // #273
  {DBGFIELD("WriteShuffleXLd")    1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #274
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #275
  {DBGFIELD("WritePMULLD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #276
  {DBGFIELD("WriteCopy")          2, false, false, false, 2674, 2, 12, 1,  0, 0}, // #277
  {DBGFIELD("WritePOPCNTLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #278
  {DBGFIELD("WritePOPCNT")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #279
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 1, false, false, false, 2674, 2, 10, 1, 14, 1}, // #280
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 2674, 2, 10, 1,  0, 0}, // #281
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 5, false, false, false, 2681, 3, 10, 1, 14, 1}, // #282
  {DBGFIELD("WriteVarShuffleX")   4, false, false, false, 2684, 3, 14, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #284
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 3, false, false, false, 2687, 3,  5, 1, 14, 1}, // #285
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 381, 3, 12, 1,  0, 0}, // #286
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #287
  {DBGFIELD("WriteVecTest")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #288
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #289
  {DBGFIELD("WriteRotateLd_WriteRotate") 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #290
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #291
  {DBGFIELD("WriteRotateCLLd_WriteRotateCL") 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #292
  {DBGFIELD("WriteRotate")        1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #293
  {DBGFIELD("WriteRotateCL")      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #294
  {DBGFIELD("WriteFRcpXLd")       6, false, false, false, 2633, 3,  9, 1,  0, 0}, // #295
  {DBGFIELD("WriteFRcpX")         5, false, false, false, 2636, 3, 22, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRcpLd")        1, false, false, false, 2690, 2, 14, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, false, 2690, 2, 14, 1, 14, 1}, // #298
  {DBGFIELD("WriteFRcp")          1, false, false, false, 2690, 2, 14, 1,  0, 0}, // #299
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #300
  {DBGFIELD("WriteShift")         1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRndLd")        1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRnd")          1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, false, 2639, 2, 10, 1, 14, 1}, // #304
  {DBGFIELD("WriteFRsqrtXLd")     6, false, false, false, 2633, 3,  9, 1,  0, 0}, // #305
  {DBGFIELD("WriteFRsqrtX")       5, false, false, false, 2636, 3, 22, 1,  0, 0}, // #306
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, false, 2690, 2, 14, 1,  0, 0}, // #307
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, false, 2690, 2, 14, 1, 14, 1}, // #308
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 2690, 2, 14, 1,  0, 0}, // #309
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #310
  {DBGFIELD("WriteShiftLd_WriteShift") 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #311
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #312
  {DBGFIELD("WriteShiftCLLd_WriteShiftCL") 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #313
  {DBGFIELD("WriteShiftCL")       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #314
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2621, 2,  1, 1, 15, 1}, // #315
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 114, 1, 12, 1,  0, 0}, // #316
  {DBGFIELD("WriteSETCC")         1, false, false, false,  5, 1,  1, 1,  0, 0}, // #317
  {DBGFIELD("WriteSHDmrcl")       1, false, false, false, 1461, 1, 14, 1,  0, 0}, // #318
  {DBGFIELD("WriteSHDmri")        1, false, false, false, 1461, 1, 14, 1,  0, 0}, // #319
  {DBGFIELD("WriteSHDrrcl")       1, false, false, false, 114, 1, 12, 1,  0, 0}, // #320
  {DBGFIELD("WriteFSqrt64XLd")    6, false, false, false, 2662, 3, 99, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrt64X")      5, false, false, false, 2662, 3, 99, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtXLd")      6, false, false, false, 2665, 3, 61, 1,  0, 0}, // #323
  {DBGFIELD("WriteFSqrtX")        5, false, false, false, 2665, 3, 61, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt64Ld")     4, false, false, false, 2671, 3, 68, 1,  0, 0}, // #325
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 4, false, false, false, 2671, 3, 68, 1, 14, 1}, // #326
  {DBGFIELD("WriteFSqrt64")       3, false, false, false, 2671, 3, 68, 1,  0, 0}, // #327
  {DBGFIELD("WriteFSqrtLd")       4, false, false, false, 2668, 3, 100, 1,  0, 0}, // #328
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 4, false, false, false, 2668, 3, 100, 1, 14, 1}, // #329
  {DBGFIELD("WriteFSqrt")         3, false, false, false, 2668, 3, 100, 1,  0, 0}, // #330
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 2692, 2, 83, 1,  0, 0}, // #331
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 2694, 3, 11, 1,  0, 0}, // #332
  {DBGFIELD("WriteTZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteTZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFMALd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFAddY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFAdd64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteShuffleY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFLogicY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteCvtPH2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteCvtPH2PS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteFVarBlendY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("WriteFBlendY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteShuffle256Ld")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteShuffle256")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteShuffleYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteFShuffle256")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteFShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteFCmpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteFCmp64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteVarShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 5, false, false, false, 2647, 3,  2, 1, 14, 1}, // #376
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("WriteCvtPD2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteVecIMulY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtI2PDYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtI2PDY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtI2PSYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtI2PSY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPD2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD("WriteCvtPD2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteCvtPD2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PDYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PDY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #407
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteCvtPH2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WriteCvtPH2PSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WriteCvtPS2PHYSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteCvtPS2PHY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteCvtPS2PHSt")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteCvtPS2PH")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 4, false, false, false, 2633, 3, 22, 1, 14, 1}, // #417
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 4, false, false, false, 2636, 3, 22, 1, 14, 1}, // #418
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WritePSADBWY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteFDivY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #427
  {DBGFIELD("WriteFDiv64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteFMAX")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFMAY")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteDPPSY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteFMA")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteFRndY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteVecALUY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("WriteFHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #458
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteVecLoadY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFMaskedLoadY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFMaskedLoad")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteFMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteFMoveY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteFShuffleYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteFShuffleY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteVecStoreY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteVecMoveY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteVecLoadNTY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteVecStoreNTY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFStoreNTY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("WriteMPSADY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteFMulY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteFMul64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteVecALUYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVecLogicY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteBlendY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteVarBlendY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #501
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #506
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #507
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2621, 2,  1, 1, 17, 2}, // #508
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2621, 2,  1, 1, 19, 2}, // #509
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2674, 2, 10, 1, 19, 2}, // #510
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("WriteFVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WriteFVarShuffleY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WriteFVarShuffle")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WritePHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVecInsert")     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #527
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, false, 2674, 2, 10, 1,  0, 0}, // #528
  {DBGFIELD("WriteVecIMulYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteVecMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteVecMaskedLoadY") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteVecMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVecMaskedLoad") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVecMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WriteVecMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #536
  {DBGFIELD("WriteVPMOV256Ld")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #537
  {DBGFIELD("WriteVPMOV256")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteVecMOVMSKY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WritePMULLDY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 5, false, false, false, 2681, 3, 10, 1, 17, 2}, // #544
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 5, false, false, false, 2681, 3, 10, 1, 19, 2}, // #545
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #546
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarVecShift")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVarVecShiftY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #557
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteVarShuffleY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #559
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteVecShiftY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #567
  {DBGFIELD("WriteVecTestY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #568
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 6, false, false, false, 2633, 3,  9, 1, 14, 1}, // #569
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRcpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFRcpYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFRndYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #575
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 6, false, false, false, 2633, 3,  9, 1, 14, 1}, // #576
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #577
  {DBGFIELD("WriteFRsqrtY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #578
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFRsqrtYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #581
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #582
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 6, false, false, false, 2665, 3, 61, 1, 14, 1}, // #584
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFSqrtY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #586
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #587
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #588
  {DBGFIELD("WriteFSqrt64YLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #589
  {DBGFIELD("WriteFSqrt64Y")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #590
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 6, false, false, false, 2662, 3, 99, 1, 14, 1}, // #591
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #592
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #593
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #594
  {DBGFIELD("WriteFSqrtYLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #595
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #596
  {DBGFIELD("WriteFTestY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #597
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #598
  {DBGFIELD("WriteFTest")         1, false, false, false,  5, 1,  1, 1,  0, 0}, // #599
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #600
  {DBGFIELD("COPY")               1, false, false, false,  5, 1,  1, 1,  0, 0}, // #601
  {DBGFIELD("XAM_F")              1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #602
  {DBGFIELD("LD_Frr")             1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #603
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #604
  {DBGFIELD("RCL16m1_RCL16m1_EVEX_RCL16mi_RCL16mi_EVEX_RCL32m1_RCL32m1_EVEX_RCL32mi_RCL32mi_EVEX_RCL64m1_RCL64m1_EVEX_RCL64mi_RCL64mi_EVEX_RCL8m1_RCL8m1_EVEX_RCL8mi_RCL8mi_EVEX_RCR16m1_RCR16m1_EVEX_RCR16mi_RCR16mi_EVEX_RCR32m1_RCR32m1_EVEX_RCR32mi_RCR32mi_EVEX_RCR64m1_RCR64m1_EVEX_RCR64mi_RCR64mi_EVEX_RCR8m1_RCR8m1_EVEX_RCR8mi_RCR8mi_EVEX_ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #605
  {DBGFIELD("RCL16m1_ND_RCL16mi_ND_RCL32m1_ND_RCL32mi_ND_RCL64m1_ND_RCL64mi_ND_RCL8m1_ND_RCL8mi_ND_RCR16m1_ND_RCR16mi_ND_RCR32m1_ND_RCR32mi_ND_RCR64m1_ND_RCR64mi_ND_RCR8m1_ND_RCR8mi_ND_ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #606
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX_RCR16mCL_RCR16mCL_EVEX_RCR32mCL_RCR32mCL_EVEX_RCR64mCL_RCR64mCL_EVEX_RCR8mCL_RCR8mCL_EVEX_ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #607
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND_RCR16mCL_ND_RCR32mCL_ND_RCR64mCL_ND_RCR8mCL_ND_ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #608
  {DBGFIELD("SAR16m1_SAR16m1_EVEX_SAR16m1_NF_SAR16mi_SAR16mi_EVEX_SAR16mi_NF_SAR32m1_SAR32m1_EVEX_SAR32m1_NF_SAR32mi_SAR32mi_EVEX_SAR32mi_NF_SAR64m1_SAR64m1_EVEX_SAR64m1_NF_SAR64mi_SAR64mi_EVEX_SAR64mi_NF_SAR8m1_SAR8m1_EVEX_SAR8m1_NF_SAR8mi_SAR8mi_EVEX_SAR8mi_NF_SHL16m1_SHL16m1_EVEX_SHL16m1_NF_SHL16mi_SHL16mi_EVEX_SHL16mi_NF_SHL32m1_SHL32m1_EVEX_SHL32m1_NF_SHL32mi_SHL32mi_EVEX_SHL32mi_NF_SHL64m1_SHL64m1_EVEX_SHL64m1_NF_SHL64mi_SHL64mi_EVEX_SHL64mi_NF_SHL8m1_SHL8m1_EVEX_SHL8m1_NF_SHL8mi_SHL8mi_EVEX_SHL8mi_NF_SHR16m1_SHR16m1_EVEX_SHR16m1_NF_SHR16mi_SHR16mi_EVEX_SHR16mi_NF_SHR32m1_SHR32m1_EVEX_SHR32m1_NF_SHR32mi_SHR32mi_EVEX_SHR32mi_NF_SHR64m1_SHR64m1_EVEX_SHR64m1_NF_SHR64mi_SHR64mi_EVEX_SHR64mi_NF_SHR8m1_SHR8m1_EVEX_SHR8m1_NF_SHR8mi_SHR8mi_EVEX_SHR8mi_NF") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #609
  {DBGFIELD("SAR16m1_ND_SAR16m1_NF_ND_SAR16mi_ND_SAR16mi_NF_ND_SAR32m1_ND_SAR32m1_NF_ND_SAR32mi_ND_SAR32mi_NF_ND_SAR64m1_ND_SAR64m1_NF_ND_SAR64mi_ND_SAR64mi_NF_ND_SAR8m1_ND_SAR8m1_NF_ND_SAR8mi_ND_SAR8mi_NF_ND_SHL16m1_ND_SHL16m1_NF_ND_SHL16mi_ND_SHL16mi_NF_ND_SHL32m1_ND_SHL32m1_NF_ND_SHL32mi_ND_SHL32mi_NF_ND_SHL64m1_ND_SHL64m1_NF_ND_SHL64mi_ND_SHL64mi_NF_ND_SHL8m1_ND_SHL8m1_NF_ND_SHL8mi_ND_SHL8mi_NF_ND_SHR16m1_ND_SHR16m1_NF_ND_SHR16mi_ND_SHR16mi_NF_ND_SHR32m1_ND_SHR32m1_NF_ND_SHR32mi_ND_SHR32mi_NF_ND_SHR64m1_ND_SHR64m1_NF_ND_SHR64mi_ND_SHR64mi_NF_ND_SHR8m1_ND_SHR8m1_NF_ND_SHR8mi_ND_SHR8mi_NF_ND") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #610
  {DBGFIELD("SAR16mCL_SAR16mCL_EVEX_SAR16mCL_NF_SAR32mCL_SAR32mCL_EVEX_SAR32mCL_NF_SAR64mCL_SAR64mCL_EVEX_SAR64mCL_NF_SAR8mCL_SAR8mCL_EVEX_SAR8mCL_NF_SHL16mCL_SHL16mCL_EVEX_SHL16mCL_NF_SHL32mCL_SHL32mCL_EVEX_SHL32mCL_NF_SHL64mCL_SHL64mCL_EVEX_SHL64mCL_NF_SHL8mCL_SHL8mCL_EVEX_SHL8mCL_NF_SHR16mCL_SHR16mCL_EVEX_SHR16mCL_NF_SHR32mCL_SHR32mCL_EVEX_SHR32mCL_NF_SHR64mCL_SHR64mCL_EVEX_SHR64mCL_NF_SHR8mCL_SHR8mCL_EVEX_SHR8mCL_NF") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #611
  {DBGFIELD("SAR16mCL_ND_SAR16mCL_NF_ND_SAR32mCL_ND_SAR32mCL_NF_ND_SAR64mCL_ND_SAR64mCL_NF_ND_SAR8mCL_ND_SAR8mCL_NF_ND_SHL16mCL_ND_SHL16mCL_NF_ND_SHL32mCL_ND_SHL32mCL_NF_ND_SHL64mCL_ND_SHL64mCL_NF_ND_SHL8mCL_ND_SHL8mCL_NF_ND_SHR16mCL_ND_SHR16mCL_NF_ND_SHR32mCL_ND_SHR32mCL_NF_ND_SHR64mCL_ND_SHR64mCL_NF_ND_SHR8mCL_ND_SHR8mCL_NF_ND") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #612
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #613
  {DBGFIELD("FCOMPP")             1, false, false, false,  4, 2,  1, 1,  0, 0}, // #614
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #615
  {DBGFIELD("MMX_CVTPI2PSrr")     1, false, false, false, 1523, 2, 10, 1,  0, 0}, // #616
  {DBGFIELD("MMX_CVTPI2PSrm")     1, false, false, false, 1523, 2, 10, 1,  0, 0}, // #617
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 1, false, false, false, 1523, 2, 10, 1,  0, 0}, // #618
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 381, 3,  1, 1,  0, 0}, // #619
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH16i_PUSH32i_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 381, 3,  1, 1,  0, 0}, // #620
  {DBGFIELD("XCH_F")              1, false, false, false, 381, 3,  1, 1,  0, 0}, // #621
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 1, false, false, false, 381, 3,  1, 1,  0, 0}, // #622
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 1, false, false, false, 2626, 3, 10, 1,  0, 0}, // #623
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, false, 2626, 3, 10, 1,  0, 0}, // #624
  {DBGFIELD("CVTSI642SDrm")       1, false, false, false, 2623, 3,  6, 1,  0, 0}, // #625
  {DBGFIELD("CVTSI642SDrm_Int")   1, false, false, false, 2623, 3,  6, 1,  0, 0}, // #626
  {DBGFIELD("CVTSI642SSrr")       4, false, false, false, 2644, 3,  6, 1,  0, 0}, // #627
  {DBGFIELD("CVTSI642SSrr_Int")   4, false, false, false, 2644, 3,  6, 1,  0, 0}, // #628
  {DBGFIELD("CVTSI642SSrm")       4, false, false, false, 2644, 3,  6, 1,  0, 0}, // #629
  {DBGFIELD("CVTSI642SSrm_Int")   4, false, false, false, 2644, 3,  6, 1,  0, 0}, // #630
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 4, false, false, false, 2636, 3, 22, 1,  0, 0}, // #631
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 4, false, false, false, 2636, 3, 22, 1,  0, 0}, // #632
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 5, false, false, false, 2650, 3,  9, 1,  0, 0}, // #633
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #634
  {DBGFIELD("LFENCE")             1, false, false, false,  5, 1,  1, 1,  0, 0}, // #635
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #636
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, false, 114, 1, 12, 1,  0, 0}, // #637
  {DBGFIELD("POP16r")             1, false, false, false, 114, 1, 12, 1,  0, 0}, // #638
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #639
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #640
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #641
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #642
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 114, 1, 12, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #644
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #645
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #646
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, false, 114, 1, 12, 1,  0, 0}, // #647
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 114, 1, 12, 1,  0, 0}, // #648
  {DBGFIELD("CLD")                1, false, false, false, 297, 1,  5, 1,  0, 0}, // #649
  {DBGFIELD("LDDQUrm")            1, false, false, false, 297, 1,  5, 1,  0, 0}, // #650
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false, 297, 1,  5, 1,  0, 0}, // #651
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, false, 297, 1,  5, 1,  0, 0}, // #652
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 1, false, false, false, 297, 1,  5, 1,  0, 0}, // #653
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, false, 297, 1,  5, 1,  0, 0}, // #654
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 297, 1,  5, 1,  0, 0}, // #655
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 1, false, false, false, 297, 1,  5, 1,  0, 0}, // #656
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 297, 1,  5, 1,  0, 0}, // #657
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 297, 1,  5, 1,  0, 0}, // #658
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, false, 297, 1,  5, 1,  0, 0}, // #659
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 1461, 1, 14, 1,  0, 0}, // #660
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, false, 1461, 1, 14, 1,  0, 0}, // #661
  {DBGFIELD("LD_F80m")            1, false, false, false, 1461, 1, 14, 1,  0, 0}, // #662
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, false, 1461, 1, 14, 1,  0, 0}, // #663
  {DBGFIELD("MMX_PEXTRWrri_PEXTRWrri_PEXTRWrri_REV") 1, false, false, false, 1461, 1, 14, 1,  0, 0}, // #664
  {DBGFIELD("FLDCW16m")           1, false, false, false, 349, 1, 10, 1,  0, 0}, // #665
  {DBGFIELD("ST_FP80m")           1, false, false, false, 349, 1, 10, 1,  0, 0}, // #666
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, false, 349, 1, 10, 1,  0, 0}, // #667
  {DBGFIELD("CMPXCHG8rm")         1, false, false, false, 630, 1,  3, 1,  0, 0}, // #668
  {DBGFIELD("INTO")               1, false, false, false, 630, 1,  3, 1,  0, 0}, // #669
  {DBGFIELD("XLAT")               1, false, false, false, 630, 1,  3, 1,  0, 0}, // #670
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 1, false, false, false, 630, 1,  3, 1,  0, 0}, // #671
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 630, 1,  3, 1,  0, 0}, // #672
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 1, false, false, false, 630, 1,  3, 1,  0, 0}, // #673
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 1, false, false, false, 630, 1,  3, 1,  0, 0}, // #674
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, false, 630, 1,  3, 1,  0, 0}, // #675
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false, false, 630, 1,  3, 1,  0, 0}, // #676
  {DBGFIELD("AAD8i8")             1, false, false, false, 645, 1,  6, 1,  0, 0}, // #677
  {DBGFIELD("LOOPE")              1, false, false, false, 673, 1,  7, 1,  0, 0}, // #678
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 673, 1,  7, 1,  0, 0}, // #679
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 1, false, false, false, 673, 1,  7, 1,  0, 0}, // #680
  {DBGFIELD("FNSTCW16m")          1, false, false, false, 673, 1,  7, 1,  0, 0}, // #681
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 407, 1, 22, 1,  0, 0}, // #682
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 407, 1, 22, 1,  0, 0}, // #683
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 1, false, false, false, 407, 1, 22, 1,  0, 0}, // #684
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 1, false, false, false, 407, 1, 22, 1,  0, 0}, // #685
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 407, 1, 22, 1,  0, 0}, // #686
  {DBGFIELD("CMPXCHG8rr")         1, false, false, false, 407, 1, 22, 1,  0, 0}, // #687
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 407, 1, 22, 1,  0, 0}, // #688
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 127, 1,  8, 1,  0, 0}, // #689
  {DBGFIELD("AAA_AAS")            1, false, false, false, 1062, 1, 24, 1,  0, 0}, // #690
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 1, false, false, false, 1221, 1, 21, 1,  0, 0}, // #691
  {DBGFIELD("LOOPNE")             1, false, false, false, 1237, 1, 20, 1,  0, 0}, // #692
  {DBGFIELD("PAUSE")              1, false, false, false, 1237, 1, 20, 1,  0, 0}, // #693
  {DBGFIELD("CMPXCHG8B")          1, false, false, false, 2113, 1, 13, 1,  0, 0}, // #694
  {DBGFIELD("DAA")                1, false, false, false, 2113, 1, 13, 1,  0, 0}, // #695
  {DBGFIELD("LOOP")               1, false, false, false, 2113, 1, 13, 1,  0, 0}, // #696
  {DBGFIELD("DAS")                1, false, false, false, 2635, 1, 15, 1,  0, 0}, // #697
  {DBGFIELD("AAM8i8")             1, false, false, false, 2697, 1, 23, 1,  0, 0}, // #698
  {DBGFIELD("STD")                1, false, false, false, 2697, 1, 23, 1,  0, 0}, // #699
  {DBGFIELD("CMPXCHG16B")         1, false, false, false, 2255, 1, 19, 1,  0, 0}, // #700
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 1178, 1, 18, 1,  0, 0}, // #701
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, false, 2698, 1, 46, 1,  0, 0}, // #702
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 1714, 1, 80, 1,  0, 0}, // #703
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 2699, 1, 72, 1,  0, 0}, // #704
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, false, 2696, 1, 64, 1,  0, 0}, // #705
  {DBGFIELD("ENTER")              1, false, false, false, 2631, 1, 51, 1,  0, 0}, // #706
  {DBGFIELD("POPF16")             1, false, false, false, 2631, 1, 51, 1,  0, 0}, // #707
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 2700, 1, 103, 1,  0, 0}, // #708
  {DBGFIELD("FRNDINT")            1, false, false, false, 1191, 1, 66, 1,  0, 0}, // #709
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false, 1191, 1, 66, 1,  0, 0}, // #710
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 2049, 1, 104, 1,  0, 0}, // #711
  {DBGFIELD("FPREM")              1, false, false, false, 2701, 1, 105, 1,  0, 0}, // #712
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, false, 2702, 1, 106, 1,  0, 0}, // #713
  {DBGFIELD("FNINIT")             1, false, false, false, 2703, 1, 56, 1,  0, 0}, // #714
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, false, 2670, 1, 98, 1,  0, 0}, // #715
  {DBGFIELD("FPREM1")             1, false, false, false, 2693, 1, 83, 1,  0, 0}, // #716
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 2693, 1, 83, 1,  0, 0}, // #717
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, false, 2704, 1, 107, 1,  0, 0}, // #718
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false, 2705, 1, 91, 1,  0, 0}, // #719
  {DBGFIELD("FSCALE")             1, false, false, false, 2706, 1, 108, 1,  0, 0}, // #720
  {DBGFIELD("RDMSR")              1, false, false, false, 2707, 1, 109, 1,  0, 0}, // #721
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 1, false, false, false, 1270, 1, 110, 1,  0, 0}, // #722
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, false, 2708, 1, 111, 1,  0, 0}, // #723
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, false, 2709, 1, 112, 1,  0, 0}, // #724
  {DBGFIELD("F2XM1")              1, false, false, false, 2710, 1, 113, 1,  0, 0}, // #725
  {DBGFIELD("CPUID")              1, false, false, false, 2711, 1, 114, 1,  0, 0}, // #726
  {DBGFIELD("INT")                1, false, false, false, 2712, 1, 115, 1,  0, 0}, // #727
  {DBGFIELD("INT3")               1, false, false, false, 2713, 1, 97, 1,  0, 0}, // #728
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false, 2667, 1, 116, 1,  0, 0}, // #729
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, false, 2714, 1, 117, 1,  0, 0}, // #730
  {DBGFIELD("FYL2X")              1, false, false, false, 2715, 1, 118, 1,  0, 0}, // #731
  {DBGFIELD("FYL2XP1")            1, false, false, false, 2716, 1, 119, 1,  0, 0}, // #732
  {DBGFIELD("FPTAN")              1, false, false, false, 2717, 1, 120, 1,  0, 0}, // #733
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 2718, 1, 121, 1,  0, 0}, // #734
  {DBGFIELD("FPATAN")             1, false, false, false, 2719, 1, 122, 1,  0, 0}, // #735
  {DBGFIELD("WRMSR")              1, false, false, false, 2720, 1, 123, 1,  0, 0}, // #736
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #737
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false,  4, 2,  1, 1,  0, 0}, // #738
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #739
  {DBGFIELD("FNOP")               1, false, false, false,  5, 1,  1, 1,  0, 0}, // #740
  {DBGFIELD("RET64")              1, false, false, false, 1270, 1, 110, 1,  0, 0}, // #741
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 1461, 1, 14, 1,  0, 0}, // #742
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #743
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #744
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #745
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 4, false, false, false, 2636, 3, 22, 1,  0, 0}, // #746
  {DBGFIELD("CWD")                1, false, false, false, 1461, 1, 14, 1,  0, 0}, // #747
  {DBGFIELD("FNSTSW16r")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #748
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, false,  5, 1,  1, 1,  0, 0}, // #749
  {DBGFIELD("PUSHFS64")           1, false, false, false, 114, 1, 12, 1,  0, 0}, // #750
  {DBGFIELD("EXTRACTPSrri_VEXTRACTPSrri") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #751
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #752
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #753
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #754
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 407, 1, 22, 1,  0, 0}, // #755
  {DBGFIELD("MOV64sr")            1, false, false, false,  5, 1,  1, 1,  0, 0}, // #756
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCL8rCL_RCL8rCL_EVEX_RCL8rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND_RCR8rCL_RCR8rCL_EVEX_RCR8rCL_ND") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #757
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, false, 381, 3,  1, 1,  0, 0}, // #758
  {DBGFIELD("CLI")                1, false, false, false,  5, 1,  4, 1,  0, 0}, // #759
  {DBGFIELD("PUSHGS64")           1, false, false, false, 114, 1, 12, 1,  0, 0}, // #760
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #761
  {DBGFIELD("CALL64pcrel32")      1, false, false, false,  4, 2,  1, 1,  0, 0}, // #762
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #763
  {DBGFIELD("EXTRACTPSmri_VEXTRACTPSmri") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #764
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #765
  {DBGFIELD("PEXTRDmri_PEXTRQmri_VPEXTRDmri_VPEXTRQmri") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #766
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, false, 407, 1, 22, 1,  0, 0}, // #767
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #768
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #769
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #770
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #771
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #772
  {DBGFIELD("MOV16sm")            1, false, false, false,  5, 1,  1, 1,  0, 0}, // #773
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #774
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #775
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #776
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false, 114, 1, 12, 1,  0, 0}, // #777
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #778
  {DBGFIELD("VINSERTF128rmi")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #779
  {DBGFIELD("VERRm_VERWm")        1, false, false, false,  5, 1,  4, 1,  0, 0}, // #780
  {DBGFIELD("FARJMP64m")          1, false, false, false,  4, 2,  1, 1,  0, 0}, // #781
  {DBGFIELD("FNSTSWm")            1, false, false, false,  5, 1,  4, 1,  0, 0}, // #782
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #783
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #784
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #785
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 5, false, false, false, 2633, 3,  9, 1, 14, 1}, // #786
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false, 297, 1,  5, 1,  0, 0}, // #787
  {DBGFIELD("ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #788
  {DBGFIELD("ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #789
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 1, false, false, false, 297, 1,  5, 1,  0, 0}, // #790
  {DBGFIELD("FARCALL64m")         1, false, false, false,  4, 2,  1, 1,  0, 0}, // #791
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #792
  {DBGFIELD("ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #793
  {DBGFIELD("ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #794
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false, false, 2621, 2,  1, 1, 15, 2}, // #795
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, false, 381, 3, 10, 1,  0, 0}, // #796
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #797
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #798
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, false, 2674, 2, 14, 1,  0, 0}, // #799
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, false, 381, 3, 10, 1,  0, 0}, // #800
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, false, 2674, 2, 14, 1,  0, 0}, // #801
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 4, false, false, false, 2668, 3, 100, 1,  0, 0}, // #802
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 4, false, false, false, 2668, 3, 100, 1,  0, 0}, // #803
  {DBGFIELD("VZEROALL")           1, false, false, false,  5, 1,  4, 1,  0, 0}, // #804
  {DBGFIELD("VZEROUPPER")         1, false, false, false,  5, 1,  4, 1,  0, 0}, // #805
  {DBGFIELD("CLC")                1, false, false, false,  5, 1,  1, 1,  0, 0}, // #806
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #807
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #808
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #809
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false,  5, 1,  1, 1,  0, 0}, // #810
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #811
  {DBGFIELD("PSUBQrr")            1, false, false, false, 114, 1, 12, 1,  0, 0}, // #812
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #813
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #814
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #815
  {DBGFIELD("SETCCr")             1, false, false, false,  5, 1,  1, 1,  0, 0}, // #816
  {DBGFIELD("SETCCm")             1, false, false, false, 114, 1, 12, 1,  0, 0}, // #817
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #818
  {DBGFIELD("RETI16_RETI32_RETI64") 1, false, false, false, 381, 3,  1, 1,  0, 0}, // #819
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 1, false, false, false, 1270, 1, 110, 1,  0, 0}, // #820
  {DBGFIELD("RDPMC")              1, false, false, false, 1191, 1, 66, 1,  0, 0}, // #821
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #822
  {DBGFIELD("FBLDm")              1, false, false, false,  5, 1,  4, 1,  0, 0}, // #823
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  5, 1,  1, 1,  0, 0}, // #824
  {DBGFIELD("FSAVEm")             1, false, false, false,  5, 1,  4, 1,  0, 0}, // #825
  {DBGFIELD("FRSTORm")            1, false, false, false,  5, 1,  4, 1,  0, 0}, // #826
  {DBGFIELD("FXTRACT")            1, false, false, false, 2698, 1, 46, 1,  0, 0}, // #827
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #828
  {DBGFIELD("VBROADCASTF128rm_VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #829
  {DBGFIELD("VBROADCASTI128rm")   1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #830
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #831
  {DBGFIELD("FBSTPm")             1, false, false, false,  5, 1,  4, 1,  0, 0}, // #832
  {DBGFIELD("VMPTRSTm")           1, false, false, false,  5, 1,  4, 1,  0, 0}, // #833
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, false, 114, 1, 12, 1,  0, 0}, // #834
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #835
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #836
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #837
  {DBGFIELD("FINCSTP")            1, false, false, false,  5, 1,  1, 1,  0, 0}, // #838
  {DBGFIELD("ANDN32rr_ANDN32rr_EVEX_ANDN32rr_NF_ANDN64rr_ANDN64rr_EVEX_ANDN64rr_NF") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #839
  {DBGFIELD("VPBLENDDYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #840
  {DBGFIELD("VPBLENDDrri")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #841
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #842
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #843
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #844
  {DBGFIELD("PDEP32rm_PDEP32rm_EVEX_PDEP64rm_PDEP64rm_EVEX_PEXT32rm_PEXT32rm_EVEX_PEXT64rm_PEXT64rm_EVEX") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #845
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #846
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #847
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #848
  {DBGFIELD("ANDN32rm_ANDN32rm_EVEX_ANDN32rm_NF_ANDN64rm_ANDN64rm_EVEX_ANDN64rm_NF") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #849
  {DBGFIELD("MOVBE16rm_MOVBE16rm_EVEX_MOVBE32rm_MOVBE32rm_EVEX_MOVBE64rm_MOVBE64rm_EVEX") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #850
  {DBGFIELD("VINSERTI128rmi")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #851
  {DBGFIELD("VPBLENDDrmi")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #852
  {DBGFIELD("VPBLENDDYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #853
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 381, 3,  1, 1,  0, 0}, // #854
  {DBGFIELD("MOVBE32mr_MOVBE32mr_EVEX_MOVBE64mr_MOVBE64mr_EVEX") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #855
  {DBGFIELD("MOVBE16mr")          1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #856
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, false, 381, 3,  1, 1,  0, 0}, // #857
  {DBGFIELD("XGETBV")             1, false, false, false,  5, 1,  4, 1,  0, 0}, // #858
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #859
  {DBGFIELD("LRET64_RET32")       1, false, false, false, 1270, 1, 110, 1,  0, 0}, // #860
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #861
  {DBGFIELD("PDEP32rr_PDEP32rr_EVEX_PDEP64rr_PDEP64rr_EVEX_PEXT32rr_PEXT32rr_EVEX_PEXT64rr_PEXT64rr_EVEX") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #862
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #863
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #864
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #865
  {DBGFIELD("CLDEMOTE")           1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #867
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #868
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #869
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 2674, 2, 14, 1,  0, 0}, // #870
  {DBGFIELD("VPCMPGTQYrm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #871
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 2623, 3,  3, 1,  7, 1}, // #872
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #873
  {DBGFIELD("XSETBV")             1, false, false, false,  5, 1,  4, 1,  0, 0}, // #874
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #875
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #876
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #877
  {DBGFIELD("RCL8rCL")            1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #878
  {DBGFIELD("RCR8rCL")            1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #879
  {DBGFIELD("RDTSC")              1, false, false, false, 2696, 1, 64, 1,  0, 0}, // #880
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #881
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 3, false, false, false, 2668, 3, 100, 1,  0, 0}, // #882
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 4, false, false, false, 2668, 3, 100, 1,  0, 0}, // #883
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 4, false, false, false, 2668, 3, 100, 1,  0, 0}, // #884
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 3, false, false, false, 2668, 3, 100, 1,  0, 0}, // #885
  {DBGFIELD("XSAVE64")            1, false, false, false,  5, 1,  4, 1,  0, 0}, // #886
  {DBGFIELD("XSAVE")              1, false, false, false,  5, 1,  4, 1,  0, 0}, // #887
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #888
  {DBGFIELD("VMCLEARm")           1, false, false, false,  5, 1,  4, 1,  0, 0}, // #889
  {DBGFIELD("FLDENVm")            1, false, false, false,  5, 1,  4, 1,  0, 0}, // #890
  {DBGFIELD("FXRSTOR64")          1, false, false, false, 2714, 1, 117, 1,  0, 0}, // #891
  {DBGFIELD("FSTENVm")            1, false, false, false,  5, 1,  4, 1,  0, 0}, // #892
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #893
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #894
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #895
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #896
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #897
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #898
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #899
  {DBGFIELD("VPXORYrr")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #900
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #901
  {DBGFIELD("VPCMPGTQYrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #902
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #903
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #904
  {DBGFIELD("MOVBE16mr_EVEX")     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #905
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #906
  {DBGFIELD("LRET64")             1, false, false, false, 1270, 1, 110, 1,  0, 0}, // #907
  {DBGFIELD("POPF64")             1, false, false, false, 1714, 1, 80, 1,  0, 0}, // #908
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #909
  {DBGFIELD("PCMPEQQrr")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #910
  {DBGFIELD("PCMPGTQrr")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #911
  {DBGFIELD("PCMPEQQrm")          1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #912
  {DBGFIELD("PCMPGTQrm")          1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #913
  {DBGFIELD("MOV16rm")            1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #914
  {DBGFIELD("POP16rmm")           1, false, false, false, 297, 1,  5, 1,  0, 0}, // #915
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #916
  {DBGFIELD("PUSHF16")            1, false, false, false, 407, 1, 22, 1,  0, 0}, // #917
  {DBGFIELD("LAHF")               1, false, false, false, 114, 1, 12, 1,  0, 0}, // #918
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mi8_EVEX_ADD16mi8_NF_ADD16mi_EVEX_ADD16mi_NF_ADD32mi_ADD32mi8_ADD32mi8_EVEX_ADD32mi8_NF_ADD32mi_EVEX_ADD32mi_NF_ADD64mi32_ADD64mi32_EVEX_ADD64mi32_NF_ADD64mi8_ADD64mi8_EVEX_ADD64mi8_NF_ADD8mi_ADD8mi8_ADD8mi_EVEX_ADD8mi_NF_SUB16mi_SUB16mi8_SUB16mi8_EVEX_SUB16mi8_NF_SUB16mi_EVEX_SUB16mi_NF_SUB32mi_SUB32mi8_SUB32mi8_EVEX_SUB32mi8_NF_SUB32mi_EVEX_SUB32mi_NF_SUB64mi32_SUB64mi32_EVEX_SUB64mi32_NF_SUB64mi8_SUB64mi8_EVEX_SUB64mi8_NF_SUB8mi_SUB8mi8_SUB8mi_EVEX_SUB8mi_NF") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #919
  {DBGFIELD("ADD16mi8_ND_ADD16mi8_NF_ND_ADD16mi_ND_ADD16mi_NF_ND_ADD16mr_ND_ADD16mr_NF_ND_ADD32mi8_ND_ADD32mi8_NF_ND_ADD32mi_ND_ADD32mi_NF_ND_ADD32mr_ND_ADD32mr_NF_ND_ADD64mi32_ND_ADD64mi32_NF_ND_ADD64mi8_ND_ADD64mi8_NF_ND_ADD64mr_ND_ADD64mr_NF_ND_ADD8mi_ND_ADD8mi_NF_ND_ADD8mr_ND_ADD8mr_NF_ND_SUB16mi8_ND_SUB16mi8_NF_ND_SUB16mi_ND_SUB16mi_NF_ND_SUB16mr_ND_SUB16mr_NF_ND_SUB32mi8_ND_SUB32mi8_NF_ND_SUB32mi_ND_SUB32mi_NF_ND_SUB32mr_ND_SUB32mr_NF_ND_SUB64mi32_ND_SUB64mi32_NF_ND_SUB64mi8_ND_SUB64mi8_NF_ND_SUB64mr_ND_SUB64mr_NF_ND_SUB8mi_ND_SUB8mi_NF_ND_SUB8mr_ND_SUB8mr_NF_ND") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #920
  {DBGFIELD("ADD16mr_ADD16mr_EVEX_ADD32mr_ADD32mr_EVEX_ADD64mr_ADD64mr_EVEX_ADD8mr_ADD8mr_EVEX_SUB16mr_SUB16mr_EVEX_SUB32mr_SUB32mr_EVEX_SUB64mr_SUB64mr_EVEX_SUB8mr_SUB8mr_EVEX") 1, false, false, false, 2621, 2,  1, 1, 15, 1}, // #921
  {DBGFIELD("ADD16mr_NF_ADD32mr_NF_ADD64mr_NF_ADD8mr_NF_SUB16mr_NF_SUB32mr_NF_SUB64mr_NF_SUB8mr_NF") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #922
  {DBGFIELD("ADC16mi_ADC16mi8_ADC16mi8_EVEX_ADC16mi_EVEX_ADC32mi_ADC32mi8_ADC32mi8_EVEX_ADC32mi_EVEX_ADC64mi32_ADC64mi32_EVEX_ADC64mi8_ADC64mi8_EVEX_ADC8mi_ADC8mi8_ADC8mi_EVEX_SBB16mi_SBB16mi8_SBB16mi8_EVEX_SBB16mi_EVEX_SBB32mi_SBB32mi8_SBB32mi8_EVEX_SBB32mi_EVEX_SBB64mi32_SBB64mi32_EVEX_SBB64mi8_SBB64mi8_EVEX_SBB8mi_SBB8mi8_SBB8mi_EVEX") 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #923
  {DBGFIELD("ADC16mi8_ND_ADC16mi_ND_ADC16mr_ND_ADC32mi8_ND_ADC32mi_ND_ADC32mr_ND_ADC64mi32_ND_ADC64mi8_ND_ADC64mr_ND_ADC8mi_ND_ADC8mr_ND_SBB16mi8_ND_SBB16mi_ND_SBB16mr_ND_SBB32mi8_ND_SBB32mi_ND_SBB32mr_ND_SBB64mi32_ND_SBB64mi8_ND_SBB64mr_ND_SBB8mi_ND_SBB8mr_ND") 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #924
  {DBGFIELD("ADC16mr_EVEX_ADC32mr_EVEX_ADC64mr_EVEX_ADC8mr_EVEX_SBB16mr_EVEX_SBB32mr_EVEX_SBB64mr_EVEX_SBB8mr_EVEX") 1, false, false, false, 2621, 2,  1, 1, 15, 2}, // #925
  {DBGFIELD("DEC16m_DEC16m_EVEX_DEC16m_NF_DEC32m_DEC32m_EVEX_DEC32m_NF_DEC64m_DEC64m_EVEX_DEC64m_NF_DEC8m_DEC8m_EVEX_DEC8m_NF_INC16m_INC16m_EVEX_INC16m_NF_INC32m_INC32m_EVEX_INC32m_NF_INC64m_INC64m_EVEX_INC64m_NF_INC8m_INC8m_EVEX_INC8m_NF_NEG16m_NEG16m_EVEX_NEG16m_NF_NEG32m_NEG32m_EVEX_NEG32m