
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_winspool.h"
#include "bin/default/librpc/gen_ndr/ndr_winspool_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/winreg.h"
#include "librpc/gen_ndr/spoolss.h"
static PyTypeObject winspool_NOTIFY_REPLY_CONTAINER_Type;
static PyTypeObject winspool_NOTIFY_OPTIONS_CONTAINER_Type;
static PyTypeObject winspool_PrintPropertyValueUnion_Type;
static PyTypeObject winspool_PrintPropertyValue_Type;
static PyTypeObject winspool_PrintNamedProperty_Type;
static PyTypeObject winspool_PrintPropertiesCollection_Type;
static PyTypeObject iremotewinspool_InterfaceType;
static PyTypeObject winspool_AsyncOpenPrinter_Type;
static PyTypeObject winspool_AsyncAddPrinter_Type;
static PyTypeObject winspool_AsyncSetJob_Type;
static PyTypeObject winspool_AsyncGetJob_Type;
static PyTypeObject winspool_AsyncEnumJobs_Type;
static PyTypeObject winspool_AsyncAddJob_Type;
static PyTypeObject winspool_AsyncScheduleJob_Type;
static PyTypeObject winspool_AsyncDeletePrinter_Type;
static PyTypeObject winspool_AsyncSetPrinter_Type;
static PyTypeObject winspool_AsyncGetPrinter_Type;
static PyTypeObject winspool_AsyncStartDocPrinter_Type;
static PyTypeObject winspool_AsyncStartPagePrinter_Type;
static PyTypeObject winspool_AsyncWritePrinter_Type;
static PyTypeObject winspool_AsyncEndPagePrinter_Type;
static PyTypeObject winspool_AsyncEndDocPrinter_Type;
static PyTypeObject winspool_AsyncAbortPrinter_Type;
static PyTypeObject winspool_AsyncGetPrinterData_Type;
static PyTypeObject winspool_AsyncGetPrinterDataEx_Type;
static PyTypeObject winspool_AsyncSetPrinterData_Type;
static PyTypeObject winspool_AsyncSetPrinterDataEx_Type;
static PyTypeObject winspool_AsyncClosePrinter_Type;
static PyTypeObject winspool_AsyncAddForm_Type;
static PyTypeObject winspool_AsyncDeleteForm_Type;
static PyTypeObject winspool_AsyncGetForm_Type;
static PyTypeObject winspool_AsyncSetForm_Type;
static PyTypeObject winspool_AsyncEnumForms_Type;
static PyTypeObject winspool_AsyncGetPrinterDriver_Type;
static PyTypeObject winspool_AsyncEnumPrinterData_Type;
static PyTypeObject winspool_AsyncEnumPrinterDataEx_Type;
static PyTypeObject winspool_AsyncEnumPrinterKey_Type;
static PyTypeObject winspool_AsyncDeletePrinterData_Type;
static PyTypeObject winspool_AsyncDeletePrinterDataEx_Type;
static PyTypeObject winspool_AsyncDeletePrinterKey_Type;
static PyTypeObject winspool_AsyncXcvData_Type;
static PyTypeObject winspool_AsyncSendRecvBidiData_Type;
static PyTypeObject winspool_AsyncCreatePrinterIC_Type;
static PyTypeObject winspool_AsyncPlayGdiScriptOnPrinterIC_Type;
static PyTypeObject winspool_AsyncDeletePrinterIC_Type;
static PyTypeObject winspool_AsyncEnumPrinters_Type;
static PyTypeObject winspool_AsyncAddPrinterDriver_Type;
static PyTypeObject winspool_AsyncEnumPrinterDrivers_Type;
static PyTypeObject winspool_AsyncGetPrinterDriverDirectory_Type;
static PyTypeObject winspool_AsyncDeletePrinterDriver_Type;
static PyTypeObject winspool_AsyncDeletePrinterDriverEx_Type;
static PyTypeObject winspool_AsyncAddPrintProcessor_Type;
static PyTypeObject winspool_AsyncEnumPrintProcessors_Type;
static PyTypeObject winspool_AsyncGetPrintProcessorDirectory_Type;
static PyTypeObject winspool_AsyncEnumPorts_Type;
static PyTypeObject winspool_AsyncEnumMonitors_Type;
static PyTypeObject winspool_AsyncAddPort_Type;
static PyTypeObject winspool_AsyncSetPort_Type;
static PyTypeObject winspool_AsyncAddMonitor_Type;
static PyTypeObject winspool_AsyncDeleteMonitor_Type;
static PyTypeObject winspool_AsyncDeletePrintProcessor_Type;
static PyTypeObject winspool_AsyncEnumPrintProcessorDatatypes_Type;
static PyTypeObject winspool_AsyncAddPerMachineConnection_Type;
static PyTypeObject winspool_AsyncDeletePerMachineConnection_Type;
static PyTypeObject winspool_AsyncEnumPerMachineConnections_Type;
static PyTypeObject winspool_SyncRegisterForRemoteNotifications_Type;
static PyTypeObject winspool_SyncUnRegisterForRemoteNotifications_Type;
static PyTypeObject winspool_SyncRefreshRemoteNotifications_Type;
static PyTypeObject winspool_AsyncGetRemoteNotifications_Type;
static PyTypeObject winspool_AsyncInstallPrinterDriverFromPackage_Type;
static PyTypeObject winspool_AsyncUploadPrinterDriverPackage_Type;
static PyTypeObject winspool_AsyncGetCorePrinterDrivers_Type;
static PyTypeObject winspool_AsyncCorePrinterDriverInstalled_Type;
static PyTypeObject winspool_AsyncGetPrinterDriverPackagePath_Type;
static PyTypeObject winspool_AsyncDeletePrinterDriverPackage_Type;
static PyTypeObject winspool_AsyncReadPrinter_Type;
static PyTypeObject winspool_AsyncResetPrinter_Type;
static PyTypeObject winspool_AsyncGetJobNamedPropertyValue_Type;
static PyTypeObject winspool_AsyncSetJobNamedProperty_Type;
static PyTypeObject winspool_AsyncDeleteJobNamedProperty_Type;
static PyTypeObject winspool_AsyncEnumJobNamedProperties_Type;
static PyTypeObject winspool_AsyncLogJobInfoForBranchOffice_Type;

static PyTypeObject *spoolss_NotifyInfo_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *spoolss_NotifyOption_Type;
static PyTypeObject *spoolss_TimeCtr_Type;
static PyTypeObject *spoolss_DevmodeContainer_Type;
static PyTypeObject *sec_desc_buf_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *spoolss_UserLevelCtr_Type;
static PyTypeObject *spoolss_SetPrinterInfoCtr_Type;
static PyTypeObject *spoolss_JobInfoContainer_Type;
static PyTypeObject *spoolss_DocumentInfoCtr_Type;
static PyTypeObject *spoolss_AddFormInfoCtr_Type;
static PyTypeObject *RPC_BIDI_REQUEST_CONTAINER_Type;
static PyTypeObject *RPC_BIDI_RESPONSE_CONTAINER_Type;
static PyTypeObject *spoolss_AddDriverInfoCtr_Type;
static PyTypeObject *spoolss_SetPortInfoContainer_Type;
static PyTypeObject *spoolss_PortVarContainer_Type;
static PyTypeObject *spoolss_MonitorContainer_Type;
static PyTypeObject *spoolss_CorePrinterDriver_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *spoolss_PrintPropertyValue_Type;
static PyTypeObject *spoolss_PrintNamedProperty_Type;
static PyTypeObject *spoolss_BranchOfficeJobDataContainer_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_winspool_NOTIFY_REPLY_CONTAINER_get_pInfo(PyObject *obj, void *closure)
{
	struct winspool_NOTIFY_REPLY_CONTAINER *object = pytalloc_get_ptr(obj);
	PyObject *py_pInfo;
	if (object->pInfo == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pInfo == NULL) {
		py_pInfo = Py_None;
		Py_INCREF(py_pInfo);
	} else {
		py_pInfo = pytalloc_reference_ex(spoolss_NotifyInfo_Type, object->pInfo, object->pInfo);
	}
	return py_pInfo;
}

static int py_winspool_NOTIFY_REPLY_CONTAINER_set_pInfo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_NOTIFY_REPLY_CONTAINER *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pInfo));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pInfo");
		return -1;
	}
	if (value == Py_None) {
		object->pInfo = NULL;
	} else {
		object->pInfo = NULL;
		PY_CHECK_TYPE(spoolss_NotifyInfo_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pInfo = (struct spoolss_NotifyInfo *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_winspool_NOTIFY_REPLY_CONTAINER_getsetters[] = {
	{
		.name = discard_const_p(char, "pInfo"),
		.get = py_winspool_NOTIFY_REPLY_CONTAINER_get_pInfo,
		.set = py_winspool_NOTIFY_REPLY_CONTAINER_set_pInfo,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_NotifyInfo")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_NOTIFY_REPLY_CONTAINER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct winspool_NOTIFY_REPLY_CONTAINER, type);
}


static PyTypeObject winspool_NOTIFY_REPLY_CONTAINER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.NOTIFY_REPLY_CONTAINER",
	.tp_getset = py_winspool_NOTIFY_REPLY_CONTAINER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_NOTIFY_REPLY_CONTAINER_new,
};


static PyObject *py_winspool_NOTIFY_OPTIONS_CONTAINER_get_pOptions(PyObject *obj, void *closure)
{
	struct winspool_NOTIFY_OPTIONS_CONTAINER *object = pytalloc_get_ptr(obj);
	PyObject *py_pOptions;
	if (object->pOptions == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pOptions == NULL) {
		py_pOptions = Py_None;
		Py_INCREF(py_pOptions);
	} else {
		py_pOptions = pytalloc_reference_ex(spoolss_NotifyOption_Type, object->pOptions, object->pOptions);
	}
	return py_pOptions;
}

static int py_winspool_NOTIFY_OPTIONS_CONTAINER_set_pOptions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_NOTIFY_OPTIONS_CONTAINER *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pOptions));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pOptions");
		return -1;
	}
	if (value == Py_None) {
		object->pOptions = NULL;
	} else {
		object->pOptions = NULL;
		PY_CHECK_TYPE(spoolss_NotifyOption_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pOptions = (struct spoolss_NotifyOption *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_winspool_NOTIFY_OPTIONS_CONTAINER_getsetters[] = {
	{
		.name = discard_const_p(char, "pOptions"),
		.get = py_winspool_NOTIFY_OPTIONS_CONTAINER_get_pOptions,
		.set = py_winspool_NOTIFY_OPTIONS_CONTAINER_set_pOptions,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_NotifyOption")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_NOTIFY_OPTIONS_CONTAINER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct winspool_NOTIFY_OPTIONS_CONTAINER, type);
}


static PyTypeObject winspool_NOTIFY_OPTIONS_CONTAINER_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.NOTIFY_OPTIONS_CONTAINER",
	.tp_getset = py_winspool_NOTIFY_OPTIONS_CONTAINER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_NOTIFY_OPTIONS_CONTAINER_new,
};

static PyObject *py_import_winspool_PrintPropertyValueUnion(TALLOC_CTX *mem_ctx, int level, union winspool_PrintPropertyValueUnion *in)
{
	PyObject *ret;

	switch (level) {
		case winspool_PropertyTypeString:
			if (in->propertyString == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->propertyString == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->propertyString, strlen(in->propertyString), "utf-8", "ignore");
				}
			}
			return ret;

		case winspool_PropertyTypeInt32:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->propertyInt32));
			return ret;

		case winspool_PropertyTypeInt64:
			ret = PyLong_FromUnsignedLongLong(in->propertyInt64);
			return ret;

		case winspool_PropertyTypeByte:
			ret = PyLong_FromLong((uint16_t)(in->propertyByte));
			return ret;

		case winspool_PropertyTypeTime:
			ret = pytalloc_reference_ex(spoolss_TimeCtr_Type, mem_ctx, &in->propertyTimeContainer);
			return ret;

		case winspool_PropertyTypeDevMode:
			ret = pytalloc_reference_ex(spoolss_DevmodeContainer_Type, mem_ctx, &in->propertyDevModeContainer);
			return ret;

		case winspool_PropertyTypeSD:
			ret = pytalloc_reference_ex(sec_desc_buf_Type, mem_ctx, &in->propertySDContainer);
			return ret;

		case winspool_PropertyTypeNotificationReply:
			ret = pytalloc_reference_ex(&winspool_NOTIFY_REPLY_CONTAINER_Type, mem_ctx, &in->propertyReplyContainer);
			return ret;

		case winspool_PropertyTypeNotificationOptions:
			ret = pytalloc_reference_ex(&winspool_NOTIFY_OPTIONS_CONTAINER_Type, mem_ctx, &in->propertyOptionsContainer);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union winspool_PrintPropertyValueUnion *py_export_winspool_PrintPropertyValueUnion(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union winspool_PrintPropertyValueUnion *ret = talloc_zero(mem_ctx, union winspool_PrintPropertyValueUnion);
	switch (level) {
		case winspool_PropertyTypeString:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->propertyString");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->propertyString = NULL;
			} else {
				ret->propertyString = NULL;
				{
					const char *test_str;
					const char *talloc_str;
					PyObject *unicode = NULL;
					if (PyUnicode_Check(in)) {
						unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
						if (unicode == NULL) {
							talloc_free(ret); return NULL;
						}
						test_str = PyBytes_AS_STRING(unicode);
					} else if (PyBytes_Check(in)) {
						test_str = PyBytes_AS_STRING(in);
					} else {
						PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
						talloc_free(ret); return NULL;
					}
					talloc_str = talloc_strdup(mem_ctx, test_str);
					if (unicode != NULL) {
						Py_DECREF(unicode);
					}
					if (talloc_str == NULL) {
						PyErr_NoMemory();
						talloc_free(ret); return NULL;
					}
					ret->propertyString = talloc_str;
				}
			}
			break;

		case winspool_PropertyTypeInt32:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->propertyInt32");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->propertyInt32));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->propertyInt32 = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case winspool_PropertyTypeInt64:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->propertyInt64");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->propertyInt64));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->propertyInt64 = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case winspool_PropertyTypeByte:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->propertyByte");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->propertyByte));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->propertyByte = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case winspool_PropertyTypeTime:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->propertyTimeContainer");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(spoolss_TimeCtr_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->propertyTimeContainer = *(struct spoolss_TimeCtr *)pytalloc_get_ptr(in);
			break;

		case winspool_PropertyTypeDevMode:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->propertyDevModeContainer");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(spoolss_DevmodeContainer_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->propertyDevModeContainer = *(struct spoolss_DevmodeContainer *)pytalloc_get_ptr(in);
			break;

		case winspool_PropertyTypeSD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->propertySDContainer");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(sec_desc_buf_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->propertySDContainer = *(struct sec_desc_buf *)pytalloc_get_ptr(in);
			break;

		case winspool_PropertyTypeNotificationReply:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->propertyReplyContainer");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&winspool_NOTIFY_REPLY_CONTAINER_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->propertyReplyContainer = *(struct winspool_NOTIFY_REPLY_CONTAINER *)pytalloc_get_ptr(in);
			break;

		case winspool_PropertyTypeNotificationOptions:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->propertyOptionsContainer");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&winspool_NOTIFY_OPTIONS_CONTAINER_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->propertyOptionsContainer = *(struct winspool_NOTIFY_OPTIONS_CONTAINER *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_winspool_PrintPropertyValueUnion_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union winspool_PrintPropertyValueUnion *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union winspool_PrintPropertyValueUnion *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union winspool_PrintPropertyValueUnion!");
		return NULL;
	}

	return py_import_winspool_PrintPropertyValueUnion(mem_ctx, level, in);
}

static PyObject *py_winspool_PrintPropertyValueUnion_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union winspool_PrintPropertyValueUnion *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_winspool_PrintPropertyValueUnion(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_winspool_PrintPropertyValueUnion_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_PrintPropertyValueUnion_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_PrintPropertyValueUnion_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_winspool_PrintPropertyValueUnion_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject winspool_PrintPropertyValueUnion_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.PrintPropertyValueUnion",
	.tp_getset = NULL,
	.tp_methods = py_winspool_PrintPropertyValueUnion_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_PrintPropertyValueUnion_new,
};


static PyObject *py_winspool_PrintPropertyValue_get_PropertyType(PyObject *obj, void *closure)
{
	struct winspool_PrintPropertyValue *object = pytalloc_get_ptr(obj);
	PyObject *py_PropertyType;
	py_PropertyType = PyLong_FromLong((uint16_t)(object->PropertyType));
	return py_PropertyType;
}

static int py_winspool_PrintPropertyValue_set_PropertyType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_PrintPropertyValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->PropertyType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->PropertyType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->PropertyType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_PrintPropertyValue_get_value(PyObject *obj, void *closure)
{
	struct winspool_PrintPropertyValue *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	py_value = pyrpc_import_union(&winspool_PrintPropertyValueUnion_Type, pytalloc_get_mem_ctx(obj), object->PropertyType, &object->value, "union winspool_PrintPropertyValueUnion");
	if (py_value == NULL) {
		return NULL;
	}
	return py_value;
}

static int py_winspool_PrintPropertyValue_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_PrintPropertyValue *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value");
		return -1;
	}
	{
		union winspool_PrintPropertyValueUnion *value_switch_0;
		value_switch_0 = (union winspool_PrintPropertyValueUnion *)pyrpc_export_union(&winspool_PrintPropertyValueUnion_Type, pytalloc_get_mem_ctx(py_obj), object->PropertyType, value, "union winspool_PrintPropertyValueUnion");
		if (value_switch_0 == NULL) {
			return -1;
		}
		object->value = *value_switch_0;
	}
	return 0;
}

static PyGetSetDef py_winspool_PrintPropertyValue_getsetters[] = {
	{
		.name = discard_const_p(char, "PropertyType"),
		.get = py_winspool_PrintPropertyValue_get_PropertyType,
		.set = py_winspool_PrintPropertyValue_set_PropertyType,
		.doc = discard_const_p(char, "PIDL-generated element of base type winspool_PrintPropertyType")
	},
	{
		.name = discard_const_p(char, "value"),
		.get = py_winspool_PrintPropertyValue_get_value,
		.set = py_winspool_PrintPropertyValue_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type winspool_PrintPropertyValueUnion")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_PrintPropertyValue_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct winspool_PrintPropertyValue, type);
}


static PyTypeObject winspool_PrintPropertyValue_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.PrintPropertyValue",
	.tp_getset = py_winspool_PrintPropertyValue_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_PrintPropertyValue_new,
};


static PyObject *py_winspool_PrintNamedProperty_get_propertyName(PyObject *obj, void *closure)
{
	struct winspool_PrintNamedProperty *object = pytalloc_get_ptr(obj);
	PyObject *py_propertyName;
	if (object->propertyName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->propertyName == NULL) {
		py_propertyName = Py_None;
		Py_INCREF(py_propertyName);
	} else {
		if (object->propertyName == NULL) {
			py_propertyName = Py_None;
			Py_INCREF(py_propertyName);
		} else {
			py_propertyName = PyUnicode_Decode(object->propertyName, strlen(object->propertyName), "utf-8", "ignore");
		}
	}
	return py_propertyName;
}

static int py_winspool_PrintNamedProperty_set_propertyName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_PrintNamedProperty *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->propertyName");
		return -1;
	}
	if (value == Py_None) {
		object->propertyName = NULL;
	} else {
		object->propertyName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->propertyName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_PrintNamedProperty_get_propertyValue(PyObject *obj, void *closure)
{
	struct winspool_PrintNamedProperty *object = pytalloc_get_ptr(obj);
	PyObject *py_propertyValue;
	py_propertyValue = pytalloc_reference_ex(&winspool_PrintPropertyValue_Type, pytalloc_get_mem_ctx(obj), &object->propertyValue);
	return py_propertyValue;
}

static int py_winspool_PrintNamedProperty_set_propertyValue(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_PrintNamedProperty *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->propertyValue");
		return -1;
	}
	PY_CHECK_TYPE(&winspool_PrintPropertyValue_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->propertyValue = *(struct winspool_PrintPropertyValue *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_winspool_PrintNamedProperty_getsetters[] = {
	{
		.name = discard_const_p(char, "propertyName"),
		.get = py_winspool_PrintNamedProperty_get_propertyName,
		.set = py_winspool_PrintNamedProperty_set_propertyName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "propertyValue"),
		.get = py_winspool_PrintNamedProperty_get_propertyValue,
		.set = py_winspool_PrintNamedProperty_set_propertyValue,
		.doc = discard_const_p(char, "PIDL-generated element of base type winspool_PrintPropertyValue")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_PrintNamedProperty_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct winspool_PrintNamedProperty, type);
}


static PyTypeObject winspool_PrintNamedProperty_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.PrintNamedProperty",
	.tp_getset = py_winspool_PrintNamedProperty_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_PrintNamedProperty_new,
};


static PyObject *py_winspool_PrintPropertiesCollection_get_numberOfProperties(PyObject *obj, void *closure)
{
	struct winspool_PrintPropertiesCollection *object = pytalloc_get_ptr(obj);
	PyObject *py_numberOfProperties;
	py_numberOfProperties = PyLong_FromUnsignedLongLong((uint32_t)(object->numberOfProperties));
	return py_numberOfProperties;
}

static int py_winspool_PrintPropertiesCollection_set_numberOfProperties(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_PrintPropertiesCollection *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->numberOfProperties");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->numberOfProperties));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->numberOfProperties = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_PrintPropertiesCollection_get_propertiesCollection(PyObject *obj, void *closure)
{
	struct winspool_PrintPropertiesCollection *object = pytalloc_get_ptr(obj);
	PyObject *py_propertiesCollection;
	if (object->propertiesCollection == NULL) {
		Py_RETURN_NONE;
	}
	if (object->propertiesCollection == NULL) {
		py_propertiesCollection = Py_None;
		Py_INCREF(py_propertiesCollection);
	} else {
		py_propertiesCollection = PyList_New(object->numberOfProperties);
		if (py_propertiesCollection == NULL) {
			return NULL;
		}
		{
			int propertiesCollection_cntr_1;
			for (propertiesCollection_cntr_1 = 0; propertiesCollection_cntr_1 < (object->numberOfProperties); propertiesCollection_cntr_1++) {
				PyObject *py_propertiesCollection_1;
				py_propertiesCollection_1 = pytalloc_reference_ex(&winspool_PrintNamedProperty_Type, object->propertiesCollection, &(object->propertiesCollection)[propertiesCollection_cntr_1]);
				PyList_SetItem(py_propertiesCollection, propertiesCollection_cntr_1, py_propertiesCollection_1);
			}
		}
	}
	return py_propertiesCollection;
}

static int py_winspool_PrintPropertiesCollection_set_propertiesCollection(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_PrintPropertiesCollection *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->propertiesCollection));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->propertiesCollection");
		return -1;
	}
	if (value == Py_None) {
		object->propertiesCollection = NULL;
	} else {
		object->propertiesCollection = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int propertiesCollection_cntr_1;
			object->propertiesCollection = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->propertiesCollection, PyList_GET_SIZE(value));
			if (!object->propertiesCollection) { return -1; }
			talloc_set_name_const(object->propertiesCollection, "ARRAY: object->propertiesCollection");
			for (propertiesCollection_cntr_1 = 0; propertiesCollection_cntr_1 < PyList_GET_SIZE(value); propertiesCollection_cntr_1++) {
				if (PyList_GET_ITEM(value, propertiesCollection_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->propertiesCollection)[propertiesCollection_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&winspool_PrintNamedProperty_Type, PyList_GET_ITEM(value, propertiesCollection_cntr_1), return -1;);
				if (talloc_reference(object->propertiesCollection, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, propertiesCollection_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->propertiesCollection)[propertiesCollection_cntr_1] = *(struct winspool_PrintNamedProperty *)pytalloc_get_ptr(PyList_GET_ITEM(value, propertiesCollection_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_winspool_PrintPropertiesCollection_getsetters[] = {
	{
		.name = discard_const_p(char, "numberOfProperties"),
		.get = py_winspool_PrintPropertiesCollection_get_numberOfProperties,
		.set = py_winspool_PrintPropertiesCollection_set_numberOfProperties,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "propertiesCollection"),
		.get = py_winspool_PrintPropertiesCollection_get_propertiesCollection,
		.set = py_winspool_PrintPropertiesCollection_set_propertiesCollection,
		.doc = discard_const_p(char, "PIDL-generated element of base type winspool_PrintNamedProperty")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_PrintPropertiesCollection_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct winspool_PrintPropertiesCollection, type);
}


static PyTypeObject winspool_PrintPropertiesCollection_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.PrintPropertiesCollection",
	.tp_getset = py_winspool_PrintPropertiesCollection_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_PrintPropertiesCollection_new,
};



static PyObject *py_winspool_AsyncOpenPrinter_in_get_pPrinterName(PyObject *obj, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pPrinterName;
	if (object->in.pPrinterName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pPrinterName == NULL) {
		py_pPrinterName = Py_None;
		Py_INCREF(py_pPrinterName);
	} else {
		if (object->in.pPrinterName == NULL) {
			py_pPrinterName = Py_None;
			Py_INCREF(py_pPrinterName);
		} else {
			py_pPrinterName = PyUnicode_Decode(object->in.pPrinterName, strlen(object->in.pPrinterName), "utf-8", "ignore");
		}
	}
	return py_pPrinterName;
}

static int py_winspool_AsyncOpenPrinter_in_set_pPrinterName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pPrinterName");
		return -1;
	}
	if (value == Py_None) {
		object->in.pPrinterName = NULL;
	} else {
		object->in.pPrinterName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pPrinterName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncOpenPrinter_out_get_pHandle(PyObject *obj, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pHandle;
	if (object->out.pHandle == NULL) {
		Py_RETURN_NONE;
	}
	py_pHandle = pytalloc_reference_ex(policy_handle_Type, object->out.pHandle, object->out.pHandle);
	return py_pHandle;
}

static int py_winspool_AsyncOpenPrinter_out_set_pHandle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pHandle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pHandle");
		return -1;
	}
	object->out.pHandle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pHandle);
	if (object->out.pHandle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.pHandle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncOpenPrinter_in_get_pDatatype(PyObject *obj, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pDatatype;
	if (object->in.pDatatype == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pDatatype == NULL) {
		py_pDatatype = Py_None;
		Py_INCREF(py_pDatatype);
	} else {
		if (object->in.pDatatype == NULL) {
			py_pDatatype = Py_None;
			Py_INCREF(py_pDatatype);
		} else {
			py_pDatatype = PyUnicode_Decode(object->in.pDatatype, strlen(object->in.pDatatype), "utf-8", "ignore");
		}
	}
	return py_pDatatype;
}

static int py_winspool_AsyncOpenPrinter_in_set_pDatatype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pDatatype");
		return -1;
	}
	if (value == Py_None) {
		object->in.pDatatype = NULL;
	} else {
		object->in.pDatatype = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pDatatype = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncOpenPrinter_in_get_pDevModeContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pDevModeContainer;
	if (object->in.pDevModeContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pDevModeContainer = pytalloc_reference_ex(spoolss_DevmodeContainer_Type, object->in.pDevModeContainer, object->in.pDevModeContainer);
	return py_pDevModeContainer;
}

static int py_winspool_AsyncOpenPrinter_in_set_pDevModeContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pDevModeContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pDevModeContainer");
		return -1;
	}
	object->in.pDevModeContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pDevModeContainer);
	if (object->in.pDevModeContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_DevmodeContainer_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pDevModeContainer = (struct spoolss_DevmodeContainer *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncOpenPrinter_in_get_AccessRequired(PyObject *obj, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_AccessRequired;
	py_AccessRequired = PyLong_FromUnsignedLongLong((uint32_t)(object->in.AccessRequired));
	return py_AccessRequired;
}

static int py_winspool_AsyncOpenPrinter_in_set_AccessRequired(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.AccessRequired");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.AccessRequired));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.AccessRequired = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncOpenPrinter_in_get_pClientInfo(PyObject *obj, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pClientInfo;
	if (object->in.pClientInfo == NULL) {
		Py_RETURN_NONE;
	}
	py_pClientInfo = pytalloc_reference_ex(spoolss_UserLevelCtr_Type, object->in.pClientInfo, object->in.pClientInfo);
	return py_pClientInfo;
}

static int py_winspool_AsyncOpenPrinter_in_set_pClientInfo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pClientInfo));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pClientInfo");
		return -1;
	}
	object->in.pClientInfo = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pClientInfo);
	if (object->in.pClientInfo == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_UserLevelCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pClientInfo = (struct spoolss_UserLevelCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncOpenPrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncOpenPrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncOpenPrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_pPrinterName"),
		.get = py_winspool_AsyncOpenPrinter_in_get_pPrinterName,
		.set = py_winspool_AsyncOpenPrinter_in_set_pPrinterName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_pHandle"),
		.get = py_winspool_AsyncOpenPrinter_out_get_pHandle,
		.set = py_winspool_AsyncOpenPrinter_out_set_pHandle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pDatatype"),
		.get = py_winspool_AsyncOpenPrinter_in_get_pDatatype,
		.set = py_winspool_AsyncOpenPrinter_in_set_pDatatype,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pDevModeContainer"),
		.get = py_winspool_AsyncOpenPrinter_in_get_pDevModeContainer,
		.set = py_winspool_AsyncOpenPrinter_in_set_pDevModeContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_DevmodeContainer")
	},
	{
		.name = discard_const_p(char, "in_AccessRequired"),
		.get = py_winspool_AsyncOpenPrinter_in_get_AccessRequired,
		.set = py_winspool_AsyncOpenPrinter_in_set_AccessRequired,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pClientInfo"),
		.get = py_winspool_AsyncOpenPrinter_in_get_pClientInfo,
		.set = py_winspool_AsyncOpenPrinter_in_set_pClientInfo,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_UserLevelCtr")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncOpenPrinter_get_result,
		.set = py_winspool_AsyncOpenPrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncOpenPrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncOpenPrinter, type);
	struct winspool_AsyncOpenPrinter *_self = (struct winspool_AsyncOpenPrinter *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pHandle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.pDevModeContainer = talloc_zero(mem_ctx, struct spoolss_DevmodeContainer);
	_self->in.pClientInfo = talloc_zero(mem_ctx, struct spoolss_UserLevelCtr);
	return self;
}

static PyObject *py_winspool_AsyncOpenPrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_winspool_AsyncOpenPrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncOpenPrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncOpenPrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncOpenPrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncOpenPrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncOpenPrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncOpenPrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncOpenPrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncOpenPrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncOpenPrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncOpenPrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncOpenPrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncOpenPrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncOpenPrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncOpenPrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncOpenPrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncOpenPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncOpenPrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncOpenPrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncOpenPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncOpenPrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncOpenPrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncOpenPrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncOpenPrinter.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncOpenPrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncOpenPrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncOpenPrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncOpenPrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncOpenPrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncOpenPrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncOpenPrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncOpenPrinter",
	.tp_getset = py_winspool_AsyncOpenPrinter_getsetters,
	.tp_methods = py_winspool_AsyncOpenPrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncOpenPrinter_new,
};

static bool pack_py_winspool_AsyncOpenPrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncOpenPrinter *r)
{
	PyObject *py_pPrinterName;
	PyObject *py_pDatatype;
	PyObject *py_pDevModeContainer;
	PyObject *py_AccessRequired;
	PyObject *py_pClientInfo;
	const char *kwnames[] = {
		"pPrinterName", "pDatatype", "pDevModeContainer", "AccessRequired", "pClientInfo", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winspool_AsyncOpenPrinter", discard_const_p(char *, kwnames), &py_pPrinterName, &py_pDatatype, &py_pDevModeContainer, &py_AccessRequired, &py_pClientInfo)) {
		return false;
	}

	if (py_pPrinterName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pPrinterName");
		return false;
	}
	if (py_pPrinterName == Py_None) {
		r->in.pPrinterName = NULL;
	} else {
		r->in.pPrinterName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pPrinterName)) {
				unicode = PyUnicode_AsEncodedString(py_pPrinterName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pPrinterName)) {
				test_str = PyBytes_AS_STRING(py_pPrinterName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pPrinterName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pPrinterName = talloc_str;
		}
	}
	if (py_pDatatype == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pDatatype");
		return false;
	}
	if (py_pDatatype == Py_None) {
		r->in.pDatatype = NULL;
	} else {
		r->in.pDatatype = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pDatatype)) {
				unicode = PyUnicode_AsEncodedString(py_pDatatype, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pDatatype)) {
				test_str = PyBytes_AS_STRING(py_pDatatype);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pDatatype)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pDatatype = talloc_str;
		}
	}
	if (py_pDevModeContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pDevModeContainer");
		return false;
	}
	r->in.pDevModeContainer = talloc_ptrtype(r, r->in.pDevModeContainer);
	if (r->in.pDevModeContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_DevmodeContainer_Type, py_pDevModeContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pDevModeContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pDevModeContainer = (struct spoolss_DevmodeContainer *)pytalloc_get_ptr(py_pDevModeContainer);
	if (py_AccessRequired == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.AccessRequired");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.AccessRequired));
		if (PyLong_Check(py_AccessRequired)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_AccessRequired);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.AccessRequired = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pClientInfo == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pClientInfo");
		return false;
	}
	r->in.pClientInfo = talloc_ptrtype(r, r->in.pClientInfo);
	if (r->in.pClientInfo == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_UserLevelCtr_Type, py_pClientInfo, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pClientInfo)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pClientInfo = (struct spoolss_UserLevelCtr *)pytalloc_get_ptr(py_pClientInfo);
	return true;
}

static PyObject *unpack_py_winspool_AsyncOpenPrinter_args_out(struct winspool_AsyncOpenPrinter *r, bool raise_result_exception)
{
	PyObject *py_pHandle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pHandle = pytalloc_reference_ex(policy_handle_Type, r->out.pHandle, r->out.pHandle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_pHandle);
	}
	if (result_size == 1) {
		result = py_pHandle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncAddPrinter_in_get_pName(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pName;
	if (object->in.pName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pName == NULL) {
		py_pName = Py_None;
		Py_INCREF(py_pName);
	} else {
		if (object->in.pName == NULL) {
			py_pName = Py_None;
			Py_INCREF(py_pName);
		} else {
			py_pName = PyUnicode_Decode(object->in.pName, strlen(object->in.pName), "utf-8", "ignore");
		}
	}
	return py_pName;
}

static int py_winspool_AsyncAddPrinter_in_set_pName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pName");
		return -1;
	}
	if (value == Py_None) {
		object->in.pName = NULL;
	} else {
		object->in.pName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncAddPrinter_in_get_pPrinterContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pPrinterContainer;
	if (object->in.pPrinterContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pPrinterContainer = pytalloc_reference_ex(spoolss_SetPrinterInfoCtr_Type, object->in.pPrinterContainer, object->in.pPrinterContainer);
	return py_pPrinterContainer;
}

static int py_winspool_AsyncAddPrinter_in_set_pPrinterContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pPrinterContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pPrinterContainer");
		return -1;
	}
	object->in.pPrinterContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pPrinterContainer);
	if (object->in.pPrinterContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_SetPrinterInfoCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pPrinterContainer = (struct spoolss_SetPrinterInfoCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncAddPrinter_in_get_pDevModeContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pDevModeContainer;
	if (object->in.pDevModeContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pDevModeContainer = pytalloc_reference_ex(spoolss_DevmodeContainer_Type, object->in.pDevModeContainer, object->in.pDevModeContainer);
	return py_pDevModeContainer;
}

static int py_winspool_AsyncAddPrinter_in_set_pDevModeContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pDevModeContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pDevModeContainer");
		return -1;
	}
	object->in.pDevModeContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pDevModeContainer);
	if (object->in.pDevModeContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_DevmodeContainer_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pDevModeContainer = (struct spoolss_DevmodeContainer *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncAddPrinter_in_get_pSecurityContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pSecurityContainer;
	if (object->in.pSecurityContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pSecurityContainer = pytalloc_reference_ex(sec_desc_buf_Type, object->in.pSecurityContainer, object->in.pSecurityContainer);
	return py_pSecurityContainer;
}

static int py_winspool_AsyncAddPrinter_in_set_pSecurityContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pSecurityContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pSecurityContainer");
		return -1;
	}
	object->in.pSecurityContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pSecurityContainer);
	if (object->in.pSecurityContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pSecurityContainer = (struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncAddPrinter_in_get_pClientInfo(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pClientInfo;
	if (object->in.pClientInfo == NULL) {
		Py_RETURN_NONE;
	}
	py_pClientInfo = pytalloc_reference_ex(spoolss_UserLevelCtr_Type, object->in.pClientInfo, object->in.pClientInfo);
	return py_pClientInfo;
}

static int py_winspool_AsyncAddPrinter_in_set_pClientInfo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pClientInfo));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pClientInfo");
		return -1;
	}
	object->in.pClientInfo = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pClientInfo);
	if (object->in.pClientInfo == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_UserLevelCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pClientInfo = (struct spoolss_UserLevelCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncAddPrinter_out_get_pHandle(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pHandle;
	if (object->out.pHandle == NULL) {
		Py_RETURN_NONE;
	}
	py_pHandle = pytalloc_reference_ex(policy_handle_Type, object->out.pHandle, object->out.pHandle);
	return py_pHandle;
}

static int py_winspool_AsyncAddPrinter_out_set_pHandle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pHandle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pHandle");
		return -1;
	}
	object->out.pHandle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pHandle);
	if (object->out.pHandle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.pHandle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncAddPrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncAddPrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncAddPrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_pName"),
		.get = py_winspool_AsyncAddPrinter_in_get_pName,
		.set = py_winspool_AsyncAddPrinter_in_set_pName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pPrinterContainer"),
		.get = py_winspool_AsyncAddPrinter_in_get_pPrinterContainer,
		.set = py_winspool_AsyncAddPrinter_in_set_pPrinterContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_SetPrinterInfoCtr")
	},
	{
		.name = discard_const_p(char, "in_pDevModeContainer"),
		.get = py_winspool_AsyncAddPrinter_in_get_pDevModeContainer,
		.set = py_winspool_AsyncAddPrinter_in_set_pDevModeContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_DevmodeContainer")
	},
	{
		.name = discard_const_p(char, "in_pSecurityContainer"),
		.get = py_winspool_AsyncAddPrinter_in_get_pSecurityContainer,
		.set = py_winspool_AsyncAddPrinter_in_set_pSecurityContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "in_pClientInfo"),
		.get = py_winspool_AsyncAddPrinter_in_get_pClientInfo,
		.set = py_winspool_AsyncAddPrinter_in_set_pClientInfo,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_UserLevelCtr")
	},
	{
		.name = discard_const_p(char, "out_pHandle"),
		.get = py_winspool_AsyncAddPrinter_out_get_pHandle,
		.set = py_winspool_AsyncAddPrinter_out_set_pHandle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncAddPrinter_get_result,
		.set = py_winspool_AsyncAddPrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncAddPrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncAddPrinter, type);
	struct winspool_AsyncAddPrinter *_self = (struct winspool_AsyncAddPrinter *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pPrinterContainer = talloc_zero(mem_ctx, struct spoolss_SetPrinterInfoCtr);
	_self->in.pDevModeContainer = talloc_zero(mem_ctx, struct spoolss_DevmodeContainer);
	_self->in.pSecurityContainer = talloc_zero(mem_ctx, struct sec_desc_buf);
	_self->in.pClientInfo = talloc_zero(mem_ctx, struct spoolss_UserLevelCtr);
	_self->out.pHandle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winspool_AsyncAddPrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_winspool_AsyncAddPrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddPrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncAddPrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncAddPrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncAddPrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncAddPrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncAddPrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddPrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncAddPrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncAddPrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncAddPrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncAddPrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncAddPrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddPrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddPrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncAddPrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncAddPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncAddPrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncAddPrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncAddPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncAddPrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncAddPrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncAddPrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncAddPrinter.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncAddPrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncAddPrinter",
	.tp_getset = py_winspool_AsyncAddPrinter_getsetters,
	.tp_methods = py_winspool_AsyncAddPrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncAddPrinter_new,
};

static bool pack_py_winspool_AsyncAddPrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncAddPrinter *r)
{
	PyObject *py_pName;
	PyObject *py_pPrinterContainer;
	PyObject *py_pDevModeContainer;
	PyObject *py_pSecurityContainer;
	PyObject *py_pClientInfo;
	const char *kwnames[] = {
		"pName", "pPrinterContainer", "pDevModeContainer", "pSecurityContainer", "pClientInfo", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winspool_AsyncAddPrinter", discard_const_p(char *, kwnames), &py_pName, &py_pPrinterContainer, &py_pDevModeContainer, &py_pSecurityContainer, &py_pClientInfo)) {
		return false;
	}

	if (py_pName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pName");
		return false;
	}
	if (py_pName == Py_None) {
		r->in.pName = NULL;
	} else {
		r->in.pName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pName)) {
				unicode = PyUnicode_AsEncodedString(py_pName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pName)) {
				test_str = PyBytes_AS_STRING(py_pName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pName = talloc_str;
		}
	}
	if (py_pPrinterContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pPrinterContainer");
		return false;
	}
	r->in.pPrinterContainer = talloc_ptrtype(r, r->in.pPrinterContainer);
	if (r->in.pPrinterContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_SetPrinterInfoCtr_Type, py_pPrinterContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pPrinterContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pPrinterContainer = (struct spoolss_SetPrinterInfoCtr *)pytalloc_get_ptr(py_pPrinterContainer);
	if (py_pDevModeContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pDevModeContainer");
		return false;
	}
	r->in.pDevModeContainer = talloc_ptrtype(r, r->in.pDevModeContainer);
	if (r->in.pDevModeContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_DevmodeContainer_Type, py_pDevModeContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pDevModeContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pDevModeContainer = (struct spoolss_DevmodeContainer *)pytalloc_get_ptr(py_pDevModeContainer);
	if (py_pSecurityContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pSecurityContainer");
		return false;
	}
	r->in.pSecurityContainer = talloc_ptrtype(r, r->in.pSecurityContainer);
	if (r->in.pSecurityContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, py_pSecurityContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pSecurityContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pSecurityContainer = (struct sec_desc_buf *)pytalloc_get_ptr(py_pSecurityContainer);
	if (py_pClientInfo == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pClientInfo");
		return false;
	}
	r->in.pClientInfo = talloc_ptrtype(r, r->in.pClientInfo);
	if (r->in.pClientInfo == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_UserLevelCtr_Type, py_pClientInfo, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pClientInfo)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pClientInfo = (struct spoolss_UserLevelCtr *)pytalloc_get_ptr(py_pClientInfo);
	return true;
}

static PyObject *unpack_py_winspool_AsyncAddPrinter_args_out(struct winspool_AsyncAddPrinter *r, bool raise_result_exception)
{
	PyObject *py_pHandle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pHandle = pytalloc_reference_ex(policy_handle_Type, r->out.pHandle, r->out.pHandle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_pHandle);
	}
	if (result_size == 1) {
		result = py_pHandle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncSetJob_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncSetJob_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncSetJob_in_get_JobId(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_JobId;
	py_JobId = PyLong_FromUnsignedLongLong((uint32_t)(object->in.JobId));
	return py_JobId;
}

static int py_winspool_AsyncSetJob_in_set_JobId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.JobId");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.JobId));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.JobId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetJob_in_get_pJobContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_pJobContainer;
	if (object->in.pJobContainer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pJobContainer == NULL) {
		py_pJobContainer = Py_None;
		Py_INCREF(py_pJobContainer);
	} else {
		py_pJobContainer = pytalloc_reference_ex(spoolss_JobInfoContainer_Type, object->in.pJobContainer, object->in.pJobContainer);
	}
	return py_pJobContainer;
}

static int py_winspool_AsyncSetJob_in_set_pJobContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pJobContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pJobContainer");
		return -1;
	}
	if (value == Py_None) {
		object->in.pJobContainer = NULL;
	} else {
		object->in.pJobContainer = NULL;
		PY_CHECK_TYPE(spoolss_JobInfoContainer_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pJobContainer = (struct spoolss_JobInfoContainer *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetJob_in_get_Command(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_Command;
	py_Command = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Command));
	return py_Command;
}

static int py_winspool_AsyncSetJob_in_set_Command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Command");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Command));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetJob_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncSetJob_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncSetJob_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncSetJob_in_get_hPrinter,
		.set = py_winspool_AsyncSetJob_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_JobId"),
		.get = py_winspool_AsyncSetJob_in_get_JobId,
		.set = py_winspool_AsyncSetJob_in_set_JobId,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pJobContainer"),
		.get = py_winspool_AsyncSetJob_in_get_pJobContainer,
		.set = py_winspool_AsyncSetJob_in_set_pJobContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_JobInfoContainer")
	},
	{
		.name = discard_const_p(char, "in_Command"),
		.get = py_winspool_AsyncSetJob_in_get_Command,
		.set = py_winspool_AsyncSetJob_in_set_Command,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncSetJob_get_result,
		.set = py_winspool_AsyncSetJob_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncSetJob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncSetJob, type);
	return self;
}

static PyObject *py_winspool_AsyncSetJob_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_winspool_AsyncSetJob_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetJob_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncSetJob_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSetJob_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSetJob_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSetJob_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSetJob_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetJob_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncSetJob_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSetJob_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSetJob_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSetJob_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSetJob_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetJob *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetJob_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncSetJob_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSetJob_ndr_print(py_obj, args, kwargs, "winspool_AsyncSetJob_in", NDR_IN);
}

static PyObject *py_winspool_AsyncSetJob_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSetJob_ndr_print(py_obj, args, kwargs, "winspool_AsyncSetJob_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncSetJob_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncSetJob_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncSetJob.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetJob_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetJob_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetJob_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetJob_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetJob_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetJob_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncSetJob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncSetJob",
	.tp_getset = py_winspool_AsyncSetJob_getsetters,
	.tp_methods = py_winspool_AsyncSetJob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncSetJob_new,
};

static bool pack_py_winspool_AsyncSetJob_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncSetJob *r)
{
	PyObject *py_hPrinter;
	PyObject *py_JobId;
	PyObject *py_pJobContainer;
	PyObject *py_Command;
	const char *kwnames[] = {
		"hPrinter", "JobId", "pJobContainer", "Command", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winspool_AsyncSetJob", discard_const_p(char *, kwnames), &py_hPrinter, &py_JobId, &py_pJobContainer, &py_Command)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_JobId == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.JobId");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.JobId));
		if (PyLong_Check(py_JobId)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_JobId);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.JobId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pJobContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pJobContainer");
		return false;
	}
	if (py_pJobContainer == Py_None) {
		r->in.pJobContainer = NULL;
	} else {
		r->in.pJobContainer = NULL;
		PY_CHECK_TYPE(spoolss_JobInfoContainer_Type, py_pJobContainer, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pJobContainer)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pJobContainer = (struct spoolss_JobInfoContainer *)pytalloc_get_ptr(py_pJobContainer);
	}
	if (py_Command == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Command");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Command));
		if (PyLong_Check(py_Command)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Command);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncSetJob_args_out(struct winspool_AsyncSetJob *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncGetJob_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncGetJob_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncGetJob_in_get_JobId(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_JobId;
	py_JobId = PyLong_FromUnsignedLongLong((uint32_t)(object->in.JobId));
	return py_JobId;
}

static int py_winspool_AsyncGetJob_in_set_JobId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.JobId");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.JobId));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.JobId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetJob_in_get_Level(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_Level;
	py_Level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Level));
	return py_Level;
}

static int py_winspool_AsyncGetJob_in_set_Level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetJob_in_get_pJob(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_pJob;
	if (object->in.pJob == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pJob == NULL) {
		py_pJob = Py_None;
		Py_INCREF(py_pJob);
	} else {
		py_pJob = PyList_New(object->in.cbBuf);
		if (py_pJob == NULL) {
			return NULL;
		}
		{
			int pJob_cntr_1;
			for (pJob_cntr_1 = 0; pJob_cntr_1 < (object->in.cbBuf); pJob_cntr_1++) {
				PyObject *py_pJob_1;
				py_pJob_1 = PyLong_FromLong((uint16_t)((object->in.pJob)[pJob_cntr_1]));
				PyList_SetItem(py_pJob, pJob_cntr_1, py_pJob_1);
			}
		}
	}
	return py_pJob;
}

static int py_winspool_AsyncGetJob_in_set_pJob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pJob));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pJob");
		return -1;
	}
	if (value == Py_None) {
		object->in.pJob = NULL;
	} else {
		object->in.pJob = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pJob_cntr_1;
			object->in.pJob = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pJob, PyList_GET_SIZE(value));
			if (!object->in.pJob) { return -1; }
			talloc_set_name_const(object->in.pJob, "ARRAY: object->in.pJob");
			for (pJob_cntr_1 = 0; pJob_cntr_1 < PyList_GET_SIZE(value); pJob_cntr_1++) {
				if (PyList_GET_ITEM(value, pJob_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pJob)[pJob_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pJob)[pJob_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pJob_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pJob_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.pJob)[pJob_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetJob_out_get_pJob(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_pJob;
	if (object->out.pJob == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.pJob == NULL) {
		py_pJob = Py_None;
		Py_INCREF(py_pJob);
	} else {
		py_pJob = PyList_New(object->in.cbBuf);
		if (py_pJob == NULL) {
			return NULL;
		}
		{
			int pJob_cntr_1;
			for (pJob_cntr_1 = 0; pJob_cntr_1 < (object->in.cbBuf); pJob_cntr_1++) {
				PyObject *py_pJob_1;
				py_pJob_1 = PyLong_FromLong((uint16_t)((object->out.pJob)[pJob_cntr_1]));
				PyList_SetItem(py_pJob, pJob_cntr_1, py_pJob_1);
			}
		}
	}
	return py_pJob;
}

static int py_winspool_AsyncGetJob_out_set_pJob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pJob));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pJob");
		return -1;
	}
	if (value == Py_None) {
		object->out.pJob = NULL;
	} else {
		object->out.pJob = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pJob_cntr_1;
			object->out.pJob = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pJob, PyList_GET_SIZE(value));
			if (!object->out.pJob) { return -1; }
			talloc_set_name_const(object->out.pJob, "ARRAY: object->out.pJob");
			for (pJob_cntr_1 = 0; pJob_cntr_1 < PyList_GET_SIZE(value); pJob_cntr_1++) {
				if (PyList_GET_ITEM(value, pJob_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pJob)[pJob_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pJob)[pJob_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pJob_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pJob_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.pJob)[pJob_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetJob_in_get_cbBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_cbBuf;
	py_cbBuf = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbBuf));
	return py_cbBuf;
}

static int py_winspool_AsyncGetJob_in_set_cbBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbBuf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbBuf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbBuf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetJob_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncGetJob_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetJob_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncGetJob_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncGetJob_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncGetJob_in_get_hPrinter,
		.set = py_winspool_AsyncGetJob_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_JobId"),
		.get = py_winspool_AsyncGetJob_in_get_JobId,
		.set = py_winspool_AsyncGetJob_in_set_JobId,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_Level"),
		.get = py_winspool_AsyncGetJob_in_get_Level,
		.set = py_winspool_AsyncGetJob_in_set_Level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pJob"),
		.get = py_winspool_AsyncGetJob_in_get_pJob,
		.set = py_winspool_AsyncGetJob_in_set_pJob,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pJob"),
		.get = py_winspool_AsyncGetJob_out_get_pJob,
		.set = py_winspool_AsyncGetJob_out_set_pJob,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbBuf"),
		.get = py_winspool_AsyncGetJob_in_get_cbBuf,
		.set = py_winspool_AsyncGetJob_in_set_cbBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncGetJob_out_get_pcbNeeded,
		.set = py_winspool_AsyncGetJob_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncGetJob_get_result,
		.set = py_winspool_AsyncGetJob_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncGetJob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncGetJob, type);
	struct winspool_AsyncGetJob *_self = (struct winspool_AsyncGetJob *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncGetJob_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_winspool_AsyncGetJob_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetJob_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncGetJob_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetJob_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetJob_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetJob_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetJob_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetJob_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncGetJob_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetJob_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetJob_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetJob_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetJob_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetJob *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetJob_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[3];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncGetJob_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetJob_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetJob_in", NDR_IN);
}

static PyObject *py_winspool_AsyncGetJob_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetJob_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetJob_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncGetJob_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncGetJob_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncGetJob.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetJob_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetJob_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetJob_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetJob_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetJob_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetJob_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncGetJob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncGetJob",
	.tp_getset = py_winspool_AsyncGetJob_getsetters,
	.tp_methods = py_winspool_AsyncGetJob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncGetJob_new,
};

static bool pack_py_winspool_AsyncGetJob_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncGetJob *r)
{
	PyObject *py_hPrinter;
	PyObject *py_JobId;
	PyObject *py_Level;
	PyObject *py_pJob;
	const char *kwnames[] = {
		"hPrinter", "JobId", "Level", "pJob", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winspool_AsyncGetJob", discard_const_p(char *, kwnames), &py_hPrinter, &py_JobId, &py_Level, &py_pJob)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_JobId == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.JobId");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.JobId));
		if (PyLong_Check(py_JobId)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_JobId);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.JobId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_Level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Level));
		if (PyLong_Check(py_Level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pJob == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pJob");
		return false;
	}
	if (py_pJob == Py_None) {
		r->in.pJob = NULL;
	} else {
		r->in.pJob = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_pJob, return false;);
		{
			int pJob_cntr_1;
			r->in.pJob = talloc_array_ptrtype(r, r->in.pJob, PyList_GET_SIZE(py_pJob));
			if (!r->in.pJob) { return false; }
			talloc_set_name_const(r->in.pJob, "ARRAY: r->in.pJob");
			for (pJob_cntr_1 = 0; pJob_cntr_1 < PyList_GET_SIZE(py_pJob); pJob_cntr_1++) {
				if (PyList_GET_ITEM(py_pJob, pJob_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pJob)[pJob_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pJob)[pJob_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_pJob, pJob_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pJob, pJob_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.pJob)[pJob_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pJob, return false;);
	r->in.cbBuf = PyList_GET_SIZE(py_pJob);
	return true;
}

static PyObject *unpack_py_winspool_AsyncGetJob_args_out(struct winspool_AsyncGetJob *r, bool raise_result_exception)
{
	PyObject *py_pJob = NULL;
	PyObject *py_pcbNeeded = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.pJob == NULL) {
		py_pJob = Py_None;
		Py_INCREF(py_pJob);
	} else {
		py_pJob = PyList_New(r->in.cbBuf);
		if (py_pJob == NULL) {
			return NULL;
		}
		{
			int pJob_cntr_1;
			for (pJob_cntr_1 = 0; pJob_cntr_1 < (r->in.cbBuf); pJob_cntr_1++) {
				PyObject *py_pJob_1;
				py_pJob_1 = PyLong_FromLong((uint16_t)((r->out.pJob)[pJob_cntr_1]));
				PyList_SetItem(py_pJob, pJob_cntr_1, py_pJob_1);
			}
		}
	}
	PyTuple_SetItem(result, 0, py_pJob);

	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbNeeded));
	PyTuple_SetItem(result, 1, py_pcbNeeded);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncEnumJobs_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncEnumJobs_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncEnumJobs_in_get_FirstJob(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(obj);
	PyObject *py_FirstJob;
	py_FirstJob = PyLong_FromUnsignedLongLong((uint32_t)(object->in.FirstJob));
	return py_FirstJob;
}

static int py_winspool_AsyncEnumJobs_in_set_FirstJob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.FirstJob");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.FirstJob));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.FirstJob = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumJobs_in_get_NoJobs(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(obj);
	PyObject *py_NoJobs;
	py_NoJobs = PyLong_FromUnsignedLongLong((uint32_t)(object->in.NoJobs));
	return py_NoJobs;
}

static int py_winspool_AsyncEnumJobs_in_set_NoJobs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.NoJobs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.NoJobs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.NoJobs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumJobs_in_get_Level(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(obj);
	PyObject *py_Level;
	py_Level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Level));
	return py_Level;
}

static int py_winspool_AsyncEnumJobs_in_set_Level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumJobs_in_get_pJob(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(obj);
	PyObject *py_pJob;
	if (object->in.pJob == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pJob == NULL) {
		py_pJob = Py_None;
		Py_INCREF(py_pJob);
	} else {
		py_pJob = PyList_New(object->in.cbBuf);
		if (py_pJob == NULL) {
			return NULL;
		}
		{
			int pJob_cntr_1;
			for (pJob_cntr_1 = 0; pJob_cntr_1 < (object->in.cbBuf); pJob_cntr_1++) {
				PyObject *py_pJob_1;
				py_pJob_1 = PyLong_FromLong((uint16_t)((object->in.pJob)[pJob_cntr_1]));
				PyList_SetItem(py_pJob, pJob_cntr_1, py_pJob_1);
			}
		}
	}
	return py_pJob;
}

static int py_winspool_AsyncEnumJobs_in_set_pJob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pJob));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pJob");
		return -1;
	}
	if (value == Py_None) {
		object->in.pJob = NULL;
	} else {
		object->in.pJob = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pJob_cntr_1;
			object->in.pJob = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pJob, PyList_GET_SIZE(value));
			if (!object->in.pJob) { return -1; }
			talloc_set_name_const(object->in.pJob, "ARRAY: object->in.pJob");
			for (pJob_cntr_1 = 0; pJob_cntr_1 < PyList_GET_SIZE(value); pJob_cntr_1++) {
				if (PyList_GET_ITEM(value, pJob_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pJob)[pJob_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pJob)[pJob_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pJob_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pJob_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.pJob)[pJob_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumJobs_out_get_pJob(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(obj);
	PyObject *py_pJob;
	if (object->out.pJob == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.pJob == NULL) {
		py_pJob = Py_None;
		Py_INCREF(py_pJob);
	} else {
		py_pJob = PyList_New(object->in.cbBuf);
		if (py_pJob == NULL) {
			return NULL;
		}
		{
			int pJob_cntr_1;
			for (pJob_cntr_1 = 0; pJob_cntr_1 < (object->in.cbBuf); pJob_cntr_1++) {
				PyObject *py_pJob_1;
				py_pJob_1 = PyLong_FromLong((uint16_t)((object->out.pJob)[pJob_cntr_1]));
				PyList_SetItem(py_pJob, pJob_cntr_1, py_pJob_1);
			}
		}
	}
	return py_pJob;
}

static int py_winspool_AsyncEnumJobs_out_set_pJob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pJob));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pJob");
		return -1;
	}
	if (value == Py_None) {
		object->out.pJob = NULL;
	} else {
		object->out.pJob = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pJob_cntr_1;
			object->out.pJob = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pJob, PyList_GET_SIZE(value));
			if (!object->out.pJob) { return -1; }
			talloc_set_name_const(object->out.pJob, "ARRAY: object->out.pJob");
			for (pJob_cntr_1 = 0; pJob_cntr_1 < PyList_GET_SIZE(value); pJob_cntr_1++) {
				if (PyList_GET_ITEM(value, pJob_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pJob)[pJob_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pJob)[pJob_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pJob_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pJob_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.pJob)[pJob_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumJobs_in_get_cbBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(obj);
	PyObject *py_cbBuf;
	py_cbBuf = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbBuf));
	return py_cbBuf;
}

static int py_winspool_AsyncEnumJobs_in_set_cbBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbBuf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbBuf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbBuf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumJobs_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncEnumJobs_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumJobs_out_get_pcReturned(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(obj);
	PyObject *py_pcReturned;
	if (object->out.pcReturned == NULL) {
		Py_RETURN_NONE;
	}
	py_pcReturned = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcReturned));
	return py_pcReturned;
}

static int py_winspool_AsyncEnumJobs_out_set_pcReturned(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcReturned));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcReturned");
		return -1;
	}
	object->out.pcReturned = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcReturned);
	if (object->out.pcReturned == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcReturned));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcReturned = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumJobs_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncEnumJobs_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncEnumJobs_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncEnumJobs_in_get_hPrinter,
		.set = py_winspool_AsyncEnumJobs_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_FirstJob"),
		.get = py_winspool_AsyncEnumJobs_in_get_FirstJob,
		.set = py_winspool_AsyncEnumJobs_in_set_FirstJob,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_NoJobs"),
		.get = py_winspool_AsyncEnumJobs_in_get_NoJobs,
		.set = py_winspool_AsyncEnumJobs_in_set_NoJobs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_Level"),
		.get = py_winspool_AsyncEnumJobs_in_get_Level,
		.set = py_winspool_AsyncEnumJobs_in_set_Level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pJob"),
		.get = py_winspool_AsyncEnumJobs_in_get_pJob,
		.set = py_winspool_AsyncEnumJobs_in_set_pJob,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pJob"),
		.get = py_winspool_AsyncEnumJobs_out_get_pJob,
		.set = py_winspool_AsyncEnumJobs_out_set_pJob,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbBuf"),
		.get = py_winspool_AsyncEnumJobs_in_get_cbBuf,
		.set = py_winspool_AsyncEnumJobs_in_set_cbBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncEnumJobs_out_get_pcbNeeded,
		.set = py_winspool_AsyncEnumJobs_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcReturned"),
		.get = py_winspool_AsyncEnumJobs_out_get_pcReturned,
		.set = py_winspool_AsyncEnumJobs_out_set_pcReturned,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncEnumJobs_get_result,
		.set = py_winspool_AsyncEnumJobs_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncEnumJobs_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncEnumJobs, type);
	struct winspool_AsyncEnumJobs *_self = (struct winspool_AsyncEnumJobs *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	_self->out.pcReturned = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncEnumJobs_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_winspool_AsyncEnumJobs_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumJobs_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncEnumJobs_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumJobs_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumJobs_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumJobs_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumJobs_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumJobs_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncEnumJobs_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumJobs_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumJobs_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumJobs_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumJobs_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumJobs *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumJobs_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[4];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncEnumJobs_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumJobs_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumJobs_in", NDR_IN);
}

static PyObject *py_winspool_AsyncEnumJobs_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumJobs_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumJobs_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncEnumJobs_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncEnumJobs_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncEnumJobs.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumJobs_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumJobs_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumJobs_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumJobs_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumJobs_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumJobs_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncEnumJobs_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncEnumJobs",
	.tp_getset = py_winspool_AsyncEnumJobs_getsetters,
	.tp_methods = py_winspool_AsyncEnumJobs_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncEnumJobs_new,
};

static bool pack_py_winspool_AsyncEnumJobs_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncEnumJobs *r)
{
	PyObject *py_hPrinter;
	PyObject *py_FirstJob;
	PyObject *py_NoJobs;
	PyObject *py_Level;
	PyObject *py_pJob;
	const char *kwnames[] = {
		"hPrinter", "FirstJob", "NoJobs", "Level", "pJob", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winspool_AsyncEnumJobs", discard_const_p(char *, kwnames), &py_hPrinter, &py_FirstJob, &py_NoJobs, &py_Level, &py_pJob)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_FirstJob == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.FirstJob");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.FirstJob));
		if (PyLong_Check(py_FirstJob)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_FirstJob);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.FirstJob = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_NoJobs == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.NoJobs");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.NoJobs));
		if (PyLong_Check(py_NoJobs)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_NoJobs);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.NoJobs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_Level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Level));
		if (PyLong_Check(py_Level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pJob == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pJob");
		return false;
	}
	if (py_pJob == Py_None) {
		r->in.pJob = NULL;
	} else {
		r->in.pJob = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_pJob, return false;);
		{
			int pJob_cntr_1;
			r->in.pJob = talloc_array_ptrtype(r, r->in.pJob, PyList_GET_SIZE(py_pJob));
			if (!r->in.pJob) { return false; }
			talloc_set_name_const(r->in.pJob, "ARRAY: r->in.pJob");
			for (pJob_cntr_1 = 0; pJob_cntr_1 < PyList_GET_SIZE(py_pJob); pJob_cntr_1++) {
				if (PyList_GET_ITEM(py_pJob, pJob_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pJob)[pJob_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pJob)[pJob_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_pJob, pJob_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pJob, pJob_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.pJob)[pJob_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pJob, return false;);
	r->in.cbBuf = PyList_GET_SIZE(py_pJob);
	return true;
}

static PyObject *unpack_py_winspool_AsyncEnumJobs_args_out(struct winspool_AsyncEnumJobs *r, bool raise_result_exception)
{
	PyObject *py_pJob = NULL;
	PyObject *py_pcbNeeded = NULL;
	PyObject *py_pcReturned = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.pJob == NULL) {
		py_pJob = Py_None;
		Py_INCREF(py_pJob);
	} else {
		py_pJob = PyList_New(r->in.cbBuf);
		if (py_pJob == NULL) {
			return NULL;
		}
		{
			int pJob_cntr_1;
			for (pJob_cntr_1 = 0; pJob_cntr_1 < (r->in.cbBuf); pJob_cntr_1++) {
				PyObject *py_pJob_1;
				py_pJob_1 = PyLong_FromLong((uint16_t)((r->out.pJob)[pJob_cntr_1]));
				PyList_SetItem(py_pJob, pJob_cntr_1, py_pJob_1);
			}
		}
	}
	PyTuple_SetItem(result, 0, py_pJob);

	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbNeeded));
	PyTuple_SetItem(result, 1, py_pcbNeeded);

	py_pcReturned = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcReturned));
	PyTuple_SetItem(result, 2, py_pcReturned);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncAddJob_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncAddJob_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncAddJob_in_get_Level(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(obj);
	PyObject *py_Level;
	py_Level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Level));
	return py_Level;
}

static int py_winspool_AsyncAddJob_in_set_Level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncAddJob_in_get_pAddJob(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(obj);
	PyObject *py_pAddJob;
	if (object->in.pAddJob == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pAddJob == NULL) {
		py_pAddJob = Py_None;
		Py_INCREF(py_pAddJob);
	} else {
		py_pAddJob = PyList_New(object->in.cbBuf);
		if (py_pAddJob == NULL) {
			return NULL;
		}
		{
			int pAddJob_cntr_1;
			for (pAddJob_cntr_1 = 0; pAddJob_cntr_1 < (object->in.cbBuf); pAddJob_cntr_1++) {
				PyObject *py_pAddJob_1;
				py_pAddJob_1 = PyLong_FromLong((uint16_t)((object->in.pAddJob)[pAddJob_cntr_1]));
				PyList_SetItem(py_pAddJob, pAddJob_cntr_1, py_pAddJob_1);
			}
		}
	}
	return py_pAddJob;
}

static int py_winspool_AsyncAddJob_in_set_pAddJob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pAddJob));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pAddJob");
		return -1;
	}
	if (value == Py_None) {
		object->in.pAddJob = NULL;
	} else {
		object->in.pAddJob = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pAddJob_cntr_1;
			object->in.pAddJob = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pAddJob, PyList_GET_SIZE(value));
			if (!object->in.pAddJob) { return -1; }
			talloc_set_name_const(object->in.pAddJob, "ARRAY: object->in.pAddJob");
			for (pAddJob_cntr_1 = 0; pAddJob_cntr_1 < PyList_GET_SIZE(value); pAddJob_cntr_1++) {
				if (PyList_GET_ITEM(value, pAddJob_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pAddJob)[pAddJob_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pAddJob)[pAddJob_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pAddJob_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pAddJob_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.pAddJob)[pAddJob_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncAddJob_out_get_pAddJob(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(obj);
	PyObject *py_pAddJob;
	if (object->out.pAddJob == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.pAddJob == NULL) {
		py_pAddJob = Py_None;
		Py_INCREF(py_pAddJob);
	} else {
		py_pAddJob = PyList_New(object->in.cbBuf);
		if (py_pAddJob == NULL) {
			return NULL;
		}
		{
			int pAddJob_cntr_1;
			for (pAddJob_cntr_1 = 0; pAddJob_cntr_1 < (object->in.cbBuf); pAddJob_cntr_1++) {
				PyObject *py_pAddJob_1;
				py_pAddJob_1 = PyLong_FromLong((uint16_t)((object->out.pAddJob)[pAddJob_cntr_1]));
				PyList_SetItem(py_pAddJob, pAddJob_cntr_1, py_pAddJob_1);
			}
		}
	}
	return py_pAddJob;
}

static int py_winspool_AsyncAddJob_out_set_pAddJob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pAddJob));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pAddJob");
		return -1;
	}
	if (value == Py_None) {
		object->out.pAddJob = NULL;
	} else {
		object->out.pAddJob = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pAddJob_cntr_1;
			object->out.pAddJob = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pAddJob, PyList_GET_SIZE(value));
			if (!object->out.pAddJob) { return -1; }
			talloc_set_name_const(object->out.pAddJob, "ARRAY: object->out.pAddJob");
			for (pAddJob_cntr_1 = 0; pAddJob_cntr_1 < PyList_GET_SIZE(value); pAddJob_cntr_1++) {
				if (PyList_GET_ITEM(value, pAddJob_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pAddJob)[pAddJob_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pAddJob)[pAddJob_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pAddJob_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pAddJob_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.pAddJob)[pAddJob_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncAddJob_in_get_cbBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(obj);
	PyObject *py_cbBuf;
	py_cbBuf = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbBuf));
	return py_cbBuf;
}

static int py_winspool_AsyncAddJob_in_set_cbBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbBuf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbBuf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbBuf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncAddJob_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncAddJob_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncAddJob_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncAddJob_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncAddJob_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncAddJob_in_get_hPrinter,
		.set = py_winspool_AsyncAddJob_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_Level"),
		.get = py_winspool_AsyncAddJob_in_get_Level,
		.set = py_winspool_AsyncAddJob_in_set_Level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pAddJob"),
		.get = py_winspool_AsyncAddJob_in_get_pAddJob,
		.set = py_winspool_AsyncAddJob_in_set_pAddJob,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pAddJob"),
		.get = py_winspool_AsyncAddJob_out_get_pAddJob,
		.set = py_winspool_AsyncAddJob_out_set_pAddJob,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbBuf"),
		.get = py_winspool_AsyncAddJob_in_get_cbBuf,
		.set = py_winspool_AsyncAddJob_in_set_cbBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncAddJob_out_get_pcbNeeded,
		.set = py_winspool_AsyncAddJob_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncAddJob_get_result,
		.set = py_winspool_AsyncAddJob_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncAddJob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncAddJob, type);
	struct winspool_AsyncAddJob *_self = (struct winspool_AsyncAddJob *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncAddJob_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(5);
}

static PyObject *py_winspool_AsyncAddJob_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddJob_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[5];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncAddJob_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncAddJob_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncAddJob_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncAddJob_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncAddJob_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddJob_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[5];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncAddJob_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncAddJob_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncAddJob_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncAddJob_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncAddJob_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddJob *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddJob_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[5];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncAddJob_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncAddJob_ndr_print(py_obj, args, kwargs, "winspool_AsyncAddJob_in", NDR_IN);
}

static PyObject *py_winspool_AsyncAddJob_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncAddJob_ndr_print(py_obj, args, kwargs, "winspool_AsyncAddJob_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncAddJob_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncAddJob_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncAddJob.opnum() -> 5 (0x05) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddJob_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddJob_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddJob_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddJob_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddJob_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddJob_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncAddJob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncAddJob",
	.tp_getset = py_winspool_AsyncAddJob_getsetters,
	.tp_methods = py_winspool_AsyncAddJob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncAddJob_new,
};

static bool pack_py_winspool_AsyncAddJob_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncAddJob *r)
{
	PyObject *py_hPrinter;
	PyObject *py_Level;
	PyObject *py_pAddJob;
	const char *kwnames[] = {
		"hPrinter", "Level", "pAddJob", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winspool_AsyncAddJob", discard_const_p(char *, kwnames), &py_hPrinter, &py_Level, &py_pAddJob)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_Level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Level));
		if (PyLong_Check(py_Level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pAddJob == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pAddJob");
		return false;
	}
	if (py_pAddJob == Py_None) {
		r->in.pAddJob = NULL;
	} else {
		r->in.pAddJob = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_pAddJob, return false;);
		{
			int pAddJob_cntr_1;
			r->in.pAddJob = talloc_array_ptrtype(r, r->in.pAddJob, PyList_GET_SIZE(py_pAddJob));
			if (!r->in.pAddJob) { return false; }
			talloc_set_name_const(r->in.pAddJob, "ARRAY: r->in.pAddJob");
			for (pAddJob_cntr_1 = 0; pAddJob_cntr_1 < PyList_GET_SIZE(py_pAddJob); pAddJob_cntr_1++) {
				if (PyList_GET_ITEM(py_pAddJob, pAddJob_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pAddJob)[pAddJob_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pAddJob)[pAddJob_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_pAddJob, pAddJob_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pAddJob, pAddJob_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.pAddJob)[pAddJob_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pAddJob, return false;);
	r->in.cbBuf = PyList_GET_SIZE(py_pAddJob);
	return true;
}

static PyObject *unpack_py_winspool_AsyncAddJob_args_out(struct winspool_AsyncAddJob *r, bool raise_result_exception)
{
	PyObject *py_pAddJob = NULL;
	PyObject *py_pcbNeeded = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.pAddJob == NULL) {
		py_pAddJob = Py_None;
		Py_INCREF(py_pAddJob);
	} else {
		py_pAddJob = PyList_New(r->in.cbBuf);
		if (py_pAddJob == NULL) {
			return NULL;
		}
		{
			int pAddJob_cntr_1;
			for (pAddJob_cntr_1 = 0; pAddJob_cntr_1 < (r->in.cbBuf); pAddJob_cntr_1++) {
				PyObject *py_pAddJob_1;
				py_pAddJob_1 = PyLong_FromLong((uint16_t)((r->out.pAddJob)[pAddJob_cntr_1]));
				PyList_SetItem(py_pAddJob, pAddJob_cntr_1, py_pAddJob_1);
			}
		}
	}
	PyTuple_SetItem(result, 0, py_pAddJob);

	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbNeeded));
	PyTuple_SetItem(result, 1, py_pcbNeeded);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncScheduleJob_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncScheduleJob *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncScheduleJob_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncScheduleJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncScheduleJob_in_get_JobId(PyObject *obj, void *closure)
{
	struct winspool_AsyncScheduleJob *object = pytalloc_get_ptr(obj);
	PyObject *py_JobId;
	py_JobId = PyLong_FromUnsignedLongLong((uint32_t)(object->in.JobId));
	return py_JobId;
}

static int py_winspool_AsyncScheduleJob_in_set_JobId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncScheduleJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.JobId");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.JobId));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.JobId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncScheduleJob_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncScheduleJob *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncScheduleJob_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncScheduleJob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncScheduleJob_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncScheduleJob_in_get_hPrinter,
		.set = py_winspool_AsyncScheduleJob_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_JobId"),
		.get = py_winspool_AsyncScheduleJob_in_get_JobId,
		.set = py_winspool_AsyncScheduleJob_in_set_JobId,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncScheduleJob_get_result,
		.set = py_winspool_AsyncScheduleJob_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncScheduleJob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncScheduleJob, type);
	return self;
}

static PyObject *py_winspool_AsyncScheduleJob_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(6);
}

static PyObject *py_winspool_AsyncScheduleJob_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncScheduleJob *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncScheduleJob_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[6];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncScheduleJob_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncScheduleJob_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncScheduleJob_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncScheduleJob_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncScheduleJob_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncScheduleJob *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncScheduleJob_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[6];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncScheduleJob_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncScheduleJob_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncScheduleJob_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncScheduleJob_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncScheduleJob_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncScheduleJob *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncScheduleJob_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[6];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncScheduleJob_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncScheduleJob_ndr_print(py_obj, args, kwargs, "winspool_AsyncScheduleJob_in", NDR_IN);
}

static PyObject *py_winspool_AsyncScheduleJob_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncScheduleJob_ndr_print(py_obj, args, kwargs, "winspool_AsyncScheduleJob_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncScheduleJob_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncScheduleJob_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncScheduleJob.opnum() -> 6 (0x06) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncScheduleJob_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncScheduleJob_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncScheduleJob_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncScheduleJob_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncScheduleJob_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncScheduleJob_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncScheduleJob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncScheduleJob",
	.tp_getset = py_winspool_AsyncScheduleJob_getsetters,
	.tp_methods = py_winspool_AsyncScheduleJob_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncScheduleJob_new,
};

static bool pack_py_winspool_AsyncScheduleJob_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncScheduleJob *r)
{
	PyObject *py_hPrinter;
	PyObject *py_JobId;
	const char *kwnames[] = {
		"hPrinter", "JobId", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winspool_AsyncScheduleJob", discard_const_p(char *, kwnames), &py_hPrinter, &py_JobId)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_JobId == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.JobId");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.JobId));
		if (PyLong_Check(py_JobId)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_JobId);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.JobId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncScheduleJob_args_out(struct winspool_AsyncScheduleJob *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncDeletePrinter_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncDeletePrinter_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncDeletePrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncDeletePrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncDeletePrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncDeletePrinter_in_get_hPrinter,
		.set = py_winspool_AsyncDeletePrinter_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncDeletePrinter_get_result,
		.set = py_winspool_AsyncDeletePrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncDeletePrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncDeletePrinter, type);
	return self;
}

static PyObject *py_winspool_AsyncDeletePrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(7);
}

static PyObject *py_winspool_AsyncDeletePrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[7];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncDeletePrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeletePrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeletePrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeletePrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeletePrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[7];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncDeletePrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeletePrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeletePrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeletePrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeletePrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[7];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncDeletePrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeletePrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeletePrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncDeletePrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeletePrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeletePrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncDeletePrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncDeletePrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncDeletePrinter.opnum() -> 7 (0x07) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncDeletePrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncDeletePrinter",
	.tp_getset = py_winspool_AsyncDeletePrinter_getsetters,
	.tp_methods = py_winspool_AsyncDeletePrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncDeletePrinter_new,
};

static bool pack_py_winspool_AsyncDeletePrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncDeletePrinter *r)
{
	PyObject *py_hPrinter;
	const char *kwnames[] = {
		"hPrinter", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winspool_AsyncDeletePrinter", discard_const_p(char *, kwnames), &py_hPrinter)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	return true;
}

static PyObject *unpack_py_winspool_AsyncDeletePrinter_args_out(struct winspool_AsyncDeletePrinter *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncSetPrinter_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncSetPrinter_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinter_in_get_pPrinterContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pPrinterContainer;
	if (object->in.pPrinterContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pPrinterContainer = pytalloc_reference_ex(spoolss_SetPrinterInfoCtr_Type, object->in.pPrinterContainer, object->in.pPrinterContainer);
	return py_pPrinterContainer;
}

static int py_winspool_AsyncSetPrinter_in_set_pPrinterContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pPrinterContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pPrinterContainer");
		return -1;
	}
	object->in.pPrinterContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pPrinterContainer);
	if (object->in.pPrinterContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_SetPrinterInfoCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pPrinterContainer = (struct spoolss_SetPrinterInfoCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinter_in_get_pDevModeContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pDevModeContainer;
	if (object->in.pDevModeContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pDevModeContainer = pytalloc_reference_ex(spoolss_DevmodeContainer_Type, object->in.pDevModeContainer, object->in.pDevModeContainer);
	return py_pDevModeContainer;
}

static int py_winspool_AsyncSetPrinter_in_set_pDevModeContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pDevModeContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pDevModeContainer");
		return -1;
	}
	object->in.pDevModeContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pDevModeContainer);
	if (object->in.pDevModeContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_DevmodeContainer_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pDevModeContainer = (struct spoolss_DevmodeContainer *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinter_in_get_pSecurityContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pSecurityContainer;
	if (object->in.pSecurityContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pSecurityContainer = pytalloc_reference_ex(sec_desc_buf_Type, object->in.pSecurityContainer, object->in.pSecurityContainer);
	return py_pSecurityContainer;
}

static int py_winspool_AsyncSetPrinter_in_set_pSecurityContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pSecurityContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pSecurityContainer");
		return -1;
	}
	object->in.pSecurityContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pSecurityContainer);
	if (object->in.pSecurityContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pSecurityContainer = (struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinter_in_get_Command(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_Command;
	py_Command = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Command));
	return py_Command;
}

static int py_winspool_AsyncSetPrinter_in_set_Command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Command");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Command));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncSetPrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncSetPrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncSetPrinter_in_get_hPrinter,
		.set = py_winspool_AsyncSetPrinter_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pPrinterContainer"),
		.get = py_winspool_AsyncSetPrinter_in_get_pPrinterContainer,
		.set = py_winspool_AsyncSetPrinter_in_set_pPrinterContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_SetPrinterInfoCtr")
	},
	{
		.name = discard_const_p(char, "in_pDevModeContainer"),
		.get = py_winspool_AsyncSetPrinter_in_get_pDevModeContainer,
		.set = py_winspool_AsyncSetPrinter_in_set_pDevModeContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_DevmodeContainer")
	},
	{
		.name = discard_const_p(char, "in_pSecurityContainer"),
		.get = py_winspool_AsyncSetPrinter_in_get_pSecurityContainer,
		.set = py_winspool_AsyncSetPrinter_in_set_pSecurityContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "in_Command"),
		.get = py_winspool_AsyncSetPrinter_in_get_Command,
		.set = py_winspool_AsyncSetPrinter_in_set_Command,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncSetPrinter_get_result,
		.set = py_winspool_AsyncSetPrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncSetPrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncSetPrinter, type);
	struct winspool_AsyncSetPrinter *_self = (struct winspool_AsyncSetPrinter *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pPrinterContainer = talloc_zero(mem_ctx, struct spoolss_SetPrinterInfoCtr);
	_self->in.pDevModeContainer = talloc_zero(mem_ctx, struct spoolss_DevmodeContainer);
	_self->in.pSecurityContainer = talloc_zero(mem_ctx, struct sec_desc_buf);
	return self;
}

static PyObject *py_winspool_AsyncSetPrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(8);
}

static PyObject *py_winspool_AsyncSetPrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetPrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[8];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncSetPrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSetPrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSetPrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSetPrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSetPrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetPrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[8];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncSetPrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSetPrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSetPrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSetPrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSetPrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetPrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetPrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[8];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncSetPrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSetPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncSetPrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncSetPrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSetPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncSetPrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncSetPrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncSetPrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncSetPrinter.opnum() -> 8 (0x08) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncSetPrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncSetPrinter",
	.tp_getset = py_winspool_AsyncSetPrinter_getsetters,
	.tp_methods = py_winspool_AsyncSetPrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncSetPrinter_new,
};

static bool pack_py_winspool_AsyncSetPrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncSetPrinter *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pPrinterContainer;
	PyObject *py_pDevModeContainer;
	PyObject *py_pSecurityContainer;
	PyObject *py_Command;
	const char *kwnames[] = {
		"hPrinter", "pPrinterContainer", "pDevModeContainer", "pSecurityContainer", "Command", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winspool_AsyncSetPrinter", discard_const_p(char *, kwnames), &py_hPrinter, &py_pPrinterContainer, &py_pDevModeContainer, &py_pSecurityContainer, &py_Command)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pPrinterContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pPrinterContainer");
		return false;
	}
	r->in.pPrinterContainer = talloc_ptrtype(r, r->in.pPrinterContainer);
	if (r->in.pPrinterContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_SetPrinterInfoCtr_Type, py_pPrinterContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pPrinterContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pPrinterContainer = (struct spoolss_SetPrinterInfoCtr *)pytalloc_get_ptr(py_pPrinterContainer);
	if (py_pDevModeContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pDevModeContainer");
		return false;
	}
	r->in.pDevModeContainer = talloc_ptrtype(r, r->in.pDevModeContainer);
	if (r->in.pDevModeContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_DevmodeContainer_Type, py_pDevModeContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pDevModeContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pDevModeContainer = (struct spoolss_DevmodeContainer *)pytalloc_get_ptr(py_pDevModeContainer);
	if (py_pSecurityContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pSecurityContainer");
		return false;
	}
	r->in.pSecurityContainer = talloc_ptrtype(r, r->in.pSecurityContainer);
	if (r->in.pSecurityContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, py_pSecurityContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pSecurityContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pSecurityContainer = (struct sec_desc_buf *)pytalloc_get_ptr(py_pSecurityContainer);
	if (py_Command == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Command");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Command));
		if (PyLong_Check(py_Command)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Command);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncSetPrinter_args_out(struct winspool_AsyncSetPrinter *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncGetPrinter_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncGetPrinter_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinter_in_get_Level(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_Level;
	py_Level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Level));
	return py_Level;
}

static int py_winspool_AsyncGetPrinter_in_set_Level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinter_in_get_pPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pPrinter;
	if (object->in.pPrinter == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pPrinter == NULL) {
		py_pPrinter = Py_None;
		Py_INCREF(py_pPrinter);
	} else {
		py_pPrinter = PyList_New(object->in.cbBuf);
		if (py_pPrinter == NULL) {
			return NULL;
		}
		{
			int pPrinter_cntr_1;
			for (pPrinter_cntr_1 = 0; pPrinter_cntr_1 < (object->in.cbBuf); pPrinter_cntr_1++) {
				PyObject *py_pPrinter_1;
				py_pPrinter_1 = PyLong_FromLong((uint16_t)((object->in.pPrinter)[pPrinter_cntr_1]));
				PyList_SetItem(py_pPrinter, pPrinter_cntr_1, py_pPrinter_1);
			}
		}
	}
	return py_pPrinter;
}

static int py_winspool_AsyncGetPrinter_in_set_pPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pPrinter));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pPrinter");
		return -1;
	}
	if (value == Py_None) {
		object->in.pPrinter = NULL;
	} else {
		object->in.pPrinter = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pPrinter_cntr_1;
			object->in.pPrinter = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pPrinter, PyList_GET_SIZE(value));
			if (!object->in.pPrinter) { return -1; }
			talloc_set_name_const(object->in.pPrinter, "ARRAY: object->in.pPrinter");
			for (pPrinter_cntr_1 = 0; pPrinter_cntr_1 < PyList_GET_SIZE(value); pPrinter_cntr_1++) {
				if (PyList_GET_ITEM(value, pPrinter_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pPrinter)[pPrinter_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pPrinter)[pPrinter_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pPrinter_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pPrinter_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.pPrinter)[pPrinter_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinter_out_get_pPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pPrinter;
	if (object->out.pPrinter == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.pPrinter == NULL) {
		py_pPrinter = Py_None;
		Py_INCREF(py_pPrinter);
	} else {
		py_pPrinter = PyList_New(object->in.cbBuf);
		if (py_pPrinter == NULL) {
			return NULL;
		}
		{
			int pPrinter_cntr_1;
			for (pPrinter_cntr_1 = 0; pPrinter_cntr_1 < (object->in.cbBuf); pPrinter_cntr_1++) {
				PyObject *py_pPrinter_1;
				py_pPrinter_1 = PyLong_FromLong((uint16_t)((object->out.pPrinter)[pPrinter_cntr_1]));
				PyList_SetItem(py_pPrinter, pPrinter_cntr_1, py_pPrinter_1);
			}
		}
	}
	return py_pPrinter;
}

static int py_winspool_AsyncGetPrinter_out_set_pPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pPrinter));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pPrinter");
		return -1;
	}
	if (value == Py_None) {
		object->out.pPrinter = NULL;
	} else {
		object->out.pPrinter = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pPrinter_cntr_1;
			object->out.pPrinter = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pPrinter, PyList_GET_SIZE(value));
			if (!object->out.pPrinter) { return -1; }
			talloc_set_name_const(object->out.pPrinter, "ARRAY: object->out.pPrinter");
			for (pPrinter_cntr_1 = 0; pPrinter_cntr_1 < PyList_GET_SIZE(value); pPrinter_cntr_1++) {
				if (PyList_GET_ITEM(value, pPrinter_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pPrinter)[pPrinter_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pPrinter)[pPrinter_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pPrinter_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pPrinter_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.pPrinter)[pPrinter_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinter_in_get_cbBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_cbBuf;
	py_cbBuf = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbBuf));
	return py_cbBuf;
}

static int py_winspool_AsyncGetPrinter_in_set_cbBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbBuf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbBuf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbBuf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinter_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncGetPrinter_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncGetPrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncGetPrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncGetPrinter_in_get_hPrinter,
		.set = py_winspool_AsyncGetPrinter_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_Level"),
		.get = py_winspool_AsyncGetPrinter_in_get_Level,
		.set = py_winspool_AsyncGetPrinter_in_set_Level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pPrinter"),
		.get = py_winspool_AsyncGetPrinter_in_get_pPrinter,
		.set = py_winspool_AsyncGetPrinter_in_set_pPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pPrinter"),
		.get = py_winspool_AsyncGetPrinter_out_get_pPrinter,
		.set = py_winspool_AsyncGetPrinter_out_set_pPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbBuf"),
		.get = py_winspool_AsyncGetPrinter_in_get_cbBuf,
		.set = py_winspool_AsyncGetPrinter_in_set_cbBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncGetPrinter_out_get_pcbNeeded,
		.set = py_winspool_AsyncGetPrinter_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncGetPrinter_get_result,
		.set = py_winspool_AsyncGetPrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncGetPrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncGetPrinter, type);
	struct winspool_AsyncGetPrinter *_self = (struct winspool_AsyncGetPrinter *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncGetPrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(9);
}

static PyObject *py_winspool_AsyncGetPrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[9];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncGetPrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetPrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetPrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetPrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetPrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[9];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncGetPrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetPrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetPrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetPrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetPrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[9];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncGetPrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetPrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncGetPrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetPrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncGetPrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncGetPrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncGetPrinter.opnum() -> 9 (0x09) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncGetPrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncGetPrinter",
	.tp_getset = py_winspool_AsyncGetPrinter_getsetters,
	.tp_methods = py_winspool_AsyncGetPrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncGetPrinter_new,
};

static bool pack_py_winspool_AsyncGetPrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncGetPrinter *r)
{
	PyObject *py_hPrinter;
	PyObject *py_Level;
	PyObject *py_pPrinter;
	const char *kwnames[] = {
		"hPrinter", "Level", "pPrinter", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winspool_AsyncGetPrinter", discard_const_p(char *, kwnames), &py_hPrinter, &py_Level, &py_pPrinter)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_Level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Level));
		if (PyLong_Check(py_Level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pPrinter");
		return false;
	}
	if (py_pPrinter == Py_None) {
		r->in.pPrinter = NULL;
	} else {
		r->in.pPrinter = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_pPrinter, return false;);
		{
			int pPrinter_cntr_1;
			r->in.pPrinter = talloc_array_ptrtype(r, r->in.pPrinter, PyList_GET_SIZE(py_pPrinter));
			if (!r->in.pPrinter) { return false; }
			talloc_set_name_const(r->in.pPrinter, "ARRAY: r->in.pPrinter");
			for (pPrinter_cntr_1 = 0; pPrinter_cntr_1 < PyList_GET_SIZE(py_pPrinter); pPrinter_cntr_1++) {
				if (PyList_GET_ITEM(py_pPrinter, pPrinter_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pPrinter)[pPrinter_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pPrinter)[pPrinter_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_pPrinter, pPrinter_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pPrinter, pPrinter_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.pPrinter)[pPrinter_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pPrinter, return false;);
	r->in.cbBuf = PyList_GET_SIZE(py_pPrinter);
	return true;
}

static PyObject *unpack_py_winspool_AsyncGetPrinter_args_out(struct winspool_AsyncGetPrinter *r, bool raise_result_exception)
{
	PyObject *py_pPrinter = NULL;
	PyObject *py_pcbNeeded = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.pPrinter == NULL) {
		py_pPrinter = Py_None;
		Py_INCREF(py_pPrinter);
	} else {
		py_pPrinter = PyList_New(r->in.cbBuf);
		if (py_pPrinter == NULL) {
			return NULL;
		}
		{
			int pPrinter_cntr_1;
			for (pPrinter_cntr_1 = 0; pPrinter_cntr_1 < (r->in.cbBuf); pPrinter_cntr_1++) {
				PyObject *py_pPrinter_1;
				py_pPrinter_1 = PyLong_FromLong((uint16_t)((r->out.pPrinter)[pPrinter_cntr_1]));
				PyList_SetItem(py_pPrinter, pPrinter_cntr_1, py_pPrinter_1);
			}
		}
	}
	PyTuple_SetItem(result, 0, py_pPrinter);

	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbNeeded));
	PyTuple_SetItem(result, 1, py_pcbNeeded);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncStartDocPrinter_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncStartDocPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncStartDocPrinter_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncStartDocPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncStartDocPrinter_in_get_pDocInfoContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncStartDocPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pDocInfoContainer;
	if (object->in.pDocInfoContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pDocInfoContainer = pytalloc_reference_ex(spoolss_DocumentInfoCtr_Type, object->in.pDocInfoContainer, object->in.pDocInfoContainer);
	return py_pDocInfoContainer;
}

static int py_winspool_AsyncStartDocPrinter_in_set_pDocInfoContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncStartDocPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pDocInfoContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pDocInfoContainer");
		return -1;
	}
	object->in.pDocInfoContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pDocInfoContainer);
	if (object->in.pDocInfoContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_DocumentInfoCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pDocInfoContainer = (struct spoolss_DocumentInfoCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncStartDocPrinter_out_get_pJobId(PyObject *obj, void *closure)
{
	struct winspool_AsyncStartDocPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pJobId;
	if (object->out.pJobId == NULL) {
		Py_RETURN_NONE;
	}
	py_pJobId = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pJobId));
	return py_pJobId;
}

static int py_winspool_AsyncStartDocPrinter_out_set_pJobId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncStartDocPrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pJobId));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pJobId");
		return -1;
	}
	object->out.pJobId = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pJobId);
	if (object->out.pJobId == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pJobId));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pJobId = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncStartDocPrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncStartDocPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncStartDocPrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncStartDocPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncStartDocPrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncStartDocPrinter_in_get_hPrinter,
		.set = py_winspool_AsyncStartDocPrinter_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pDocInfoContainer"),
		.get = py_winspool_AsyncStartDocPrinter_in_get_pDocInfoContainer,
		.set = py_winspool_AsyncStartDocPrinter_in_set_pDocInfoContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_DocumentInfoCtr")
	},
	{
		.name = discard_const_p(char, "out_pJobId"),
		.get = py_winspool_AsyncStartDocPrinter_out_get_pJobId,
		.set = py_winspool_AsyncStartDocPrinter_out_set_pJobId,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncStartDocPrinter_get_result,
		.set = py_winspool_AsyncStartDocPrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncStartDocPrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncStartDocPrinter, type);
	struct winspool_AsyncStartDocPrinter *_self = (struct winspool_AsyncStartDocPrinter *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pDocInfoContainer = talloc_zero(mem_ctx, struct spoolss_DocumentInfoCtr);
	_self->out.pJobId = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncStartDocPrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(10);
}

static PyObject *py_winspool_AsyncStartDocPrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncStartDocPrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncStartDocPrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[10];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncStartDocPrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncStartDocPrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncStartDocPrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncStartDocPrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncStartDocPrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncStartDocPrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncStartDocPrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[10];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncStartDocPrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncStartDocPrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncStartDocPrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncStartDocPrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncStartDocPrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncStartDocPrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncStartDocPrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[10];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncStartDocPrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncStartDocPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncStartDocPrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncStartDocPrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncStartDocPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncStartDocPrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncStartDocPrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncStartDocPrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncStartDocPrinter.opnum() -> 10 (0x0a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartDocPrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartDocPrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartDocPrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartDocPrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartDocPrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartDocPrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncStartDocPrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncStartDocPrinter",
	.tp_getset = py_winspool_AsyncStartDocPrinter_getsetters,
	.tp_methods = py_winspool_AsyncStartDocPrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncStartDocPrinter_new,
};

static bool pack_py_winspool_AsyncStartDocPrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncStartDocPrinter *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pDocInfoContainer;
	const char *kwnames[] = {
		"hPrinter", "pDocInfoContainer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winspool_AsyncStartDocPrinter", discard_const_p(char *, kwnames), &py_hPrinter, &py_pDocInfoContainer)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pDocInfoContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pDocInfoContainer");
		return false;
	}
	r->in.pDocInfoContainer = talloc_ptrtype(r, r->in.pDocInfoContainer);
	if (r->in.pDocInfoContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_DocumentInfoCtr_Type, py_pDocInfoContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pDocInfoContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pDocInfoContainer = (struct spoolss_DocumentInfoCtr *)pytalloc_get_ptr(py_pDocInfoContainer);
	return true;
}

static PyObject *unpack_py_winspool_AsyncStartDocPrinter_args_out(struct winspool_AsyncStartDocPrinter *r, bool raise_result_exception)
{
	PyObject *py_pJobId = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pJobId = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pJobId));
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_pJobId);
	}
	if (result_size == 1) {
		result = py_pJobId;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncStartPagePrinter_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncStartPagePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncStartPagePrinter_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncStartPagePrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncStartPagePrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncStartPagePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncStartPagePrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncStartPagePrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncStartPagePrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncStartPagePrinter_in_get_hPrinter,
		.set = py_winspool_AsyncStartPagePrinter_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncStartPagePrinter_get_result,
		.set = py_winspool_AsyncStartPagePrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncStartPagePrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncStartPagePrinter, type);
	return self;
}

static PyObject *py_winspool_AsyncStartPagePrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(11);
}

static PyObject *py_winspool_AsyncStartPagePrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncStartPagePrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncStartPagePrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[11];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncStartPagePrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncStartPagePrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncStartPagePrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncStartPagePrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncStartPagePrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncStartPagePrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncStartPagePrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[11];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncStartPagePrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncStartPagePrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncStartPagePrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncStartPagePrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncStartPagePrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncStartPagePrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncStartPagePrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[11];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncStartPagePrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncStartPagePrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncStartPagePrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncStartPagePrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncStartPagePrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncStartPagePrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncStartPagePrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncStartPagePrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncStartPagePrinter.opnum() -> 11 (0x0b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartPagePrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartPagePrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartPagePrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartPagePrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartPagePrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncStartPagePrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncStartPagePrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncStartPagePrinter",
	.tp_getset = py_winspool_AsyncStartPagePrinter_getsetters,
	.tp_methods = py_winspool_AsyncStartPagePrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncStartPagePrinter_new,
};

static bool pack_py_winspool_AsyncStartPagePrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncStartPagePrinter *r)
{
	PyObject *py_hPrinter;
	const char *kwnames[] = {
		"hPrinter", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winspool_AsyncStartPagePrinter", discard_const_p(char *, kwnames), &py_hPrinter)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	return true;
}

static PyObject *unpack_py_winspool_AsyncStartPagePrinter_args_out(struct winspool_AsyncStartPagePrinter *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncWritePrinter_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncWritePrinter_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncWritePrinter_in_get_pBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pBuf;
	if (object->in.pBuf == NULL) {
		Py_RETURN_NONE;
	}
	py_pBuf = PyList_New(object->in.cbBuf);
	if (py_pBuf == NULL) {
		return NULL;
	}
	{
		int pBuf_cntr_1;
		for (pBuf_cntr_1 = 0; pBuf_cntr_1 < (object->in.cbBuf); pBuf_cntr_1++) {
			PyObject *py_pBuf_1;
			py_pBuf_1 = PyLong_FromLong((uint16_t)((object->in.pBuf)[pBuf_cntr_1]));
			PyList_SetItem(py_pBuf, pBuf_cntr_1, py_pBuf_1);
		}
	}
	return py_pBuf;
}

static int py_winspool_AsyncWritePrinter_in_set_pBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pBuf));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pBuf");
		return -1;
	}
	object->in.pBuf = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pBuf);
	if (object->in.pBuf == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pBuf_cntr_1;
		object->in.pBuf = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pBuf, PyList_GET_SIZE(value));
		if (!object->in.pBuf) { return -1; }
		talloc_set_name_const(object->in.pBuf, "ARRAY: object->in.pBuf");
		for (pBuf_cntr_1 = 0; pBuf_cntr_1 < PyList_GET_SIZE(value); pBuf_cntr_1++) {
			if (PyList_GET_ITEM(value, pBuf_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pBuf)[pBuf_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pBuf)[pBuf_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pBuf_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pBuf_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.pBuf)[pBuf_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncWritePrinter_in_get_cbBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_cbBuf;
	py_cbBuf = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbBuf));
	return py_cbBuf;
}

static int py_winspool_AsyncWritePrinter_in_set_cbBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbBuf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbBuf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbBuf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncWritePrinter_out_get_pcWritten(PyObject *obj, void *closure)
{
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_pcWritten;
	if (object->out.pcWritten == NULL) {
		Py_RETURN_NONE;
	}
	py_pcWritten = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcWritten));
	return py_pcWritten;
}

static int py_winspool_AsyncWritePrinter_out_set_pcWritten(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcWritten));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcWritten");
		return -1;
	}
	object->out.pcWritten = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcWritten);
	if (object->out.pcWritten == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcWritten));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcWritten = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncWritePrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncWritePrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncWritePrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncWritePrinter_in_get_hPrinter,
		.set = py_winspool_AsyncWritePrinter_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pBuf"),
		.get = py_winspool_AsyncWritePrinter_in_get_pBuf,
		.set = py_winspool_AsyncWritePrinter_in_set_pBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbBuf"),
		.get = py_winspool_AsyncWritePrinter_in_get_cbBuf,
		.set = py_winspool_AsyncWritePrinter_in_set_cbBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcWritten"),
		.get = py_winspool_AsyncWritePrinter_out_get_pcWritten,
		.set = py_winspool_AsyncWritePrinter_out_set_pcWritten,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncWritePrinter_get_result,
		.set = py_winspool_AsyncWritePrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncWritePrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncWritePrinter, type);
	struct winspool_AsyncWritePrinter *_self = (struct winspool_AsyncWritePrinter *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pBuf = talloc_zero(mem_ctx, uint8_t);
	_self->out.pcWritten = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncWritePrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(12);
}

static PyObject *py_winspool_AsyncWritePrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncWritePrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[12];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncWritePrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncWritePrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncWritePrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncWritePrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncWritePrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncWritePrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[12];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncWritePrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncWritePrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncWritePrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncWritePrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncWritePrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncWritePrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncWritePrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[12];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncWritePrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncWritePrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncWritePrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncWritePrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncWritePrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncWritePrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncWritePrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncWritePrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncWritePrinter.opnum() -> 12 (0x0c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncWritePrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncWritePrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncWritePrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncWritePrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncWritePrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncWritePrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncWritePrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncWritePrinter",
	.tp_getset = py_winspool_AsyncWritePrinter_getsetters,
	.tp_methods = py_winspool_AsyncWritePrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncWritePrinter_new,
};

static bool pack_py_winspool_AsyncWritePrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncWritePrinter *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pBuf;
	const char *kwnames[] = {
		"hPrinter", "pBuf", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winspool_AsyncWritePrinter", discard_const_p(char *, kwnames), &py_hPrinter, &py_pBuf)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pBuf == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pBuf");
		return false;
	}
	r->in.pBuf = talloc_ptrtype(r, r->in.pBuf);
	if (r->in.pBuf == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_pBuf, return false;);
	{
		int pBuf_cntr_1;
		r->in.pBuf = talloc_array_ptrtype(r, r->in.pBuf, PyList_GET_SIZE(py_pBuf));
		if (!r->in.pBuf) { return false; }
		talloc_set_name_const(r->in.pBuf, "ARRAY: r->in.pBuf");
		for (pBuf_cntr_1 = 0; pBuf_cntr_1 < PyList_GET_SIZE(py_pBuf); pBuf_cntr_1++) {
			if (PyList_GET_ITEM(py_pBuf, pBuf_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pBuf)[pBuf_cntr_1]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pBuf)[pBuf_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(py_pBuf, pBuf_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pBuf, pBuf_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.pBuf)[pBuf_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pBuf, return false;);
	r->in.cbBuf = PyList_GET_SIZE(py_pBuf);
	return true;
}

static PyObject *unpack_py_winspool_AsyncWritePrinter_args_out(struct winspool_AsyncWritePrinter *r, bool raise_result_exception)
{
	PyObject *py_pcWritten = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pcWritten = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcWritten));
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_pcWritten);
	}
	if (result_size == 1) {
		result = py_pcWritten;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncEndPagePrinter_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncEndPagePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncEndPagePrinter_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEndPagePrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncEndPagePrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncEndPagePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncEndPagePrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEndPagePrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncEndPagePrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncEndPagePrinter_in_get_hPrinter,
		.set = py_winspool_AsyncEndPagePrinter_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncEndPagePrinter_get_result,
		.set = py_winspool_AsyncEndPagePrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncEndPagePrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncEndPagePrinter, type);
	return self;
}

static PyObject *py_winspool_AsyncEndPagePrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(13);
}

static PyObject *py_winspool_AsyncEndPagePrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEndPagePrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEndPagePrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[13];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncEndPagePrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEndPagePrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEndPagePrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEndPagePrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEndPagePrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEndPagePrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEndPagePrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[13];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncEndPagePrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEndPagePrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEndPagePrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEndPagePrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEndPagePrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEndPagePrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEndPagePrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[13];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncEndPagePrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEndPagePrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncEndPagePrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncEndPagePrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEndPagePrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncEndPagePrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncEndPagePrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncEndPagePrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncEndPagePrinter.opnum() -> 13 (0x0d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndPagePrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndPagePrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndPagePrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndPagePrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndPagePrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndPagePrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncEndPagePrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncEndPagePrinter",
	.tp_getset = py_winspool_AsyncEndPagePrinter_getsetters,
	.tp_methods = py_winspool_AsyncEndPagePrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncEndPagePrinter_new,
};

static bool pack_py_winspool_AsyncEndPagePrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncEndPagePrinter *r)
{
	PyObject *py_hPrinter;
	const char *kwnames[] = {
		"hPrinter", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winspool_AsyncEndPagePrinter", discard_const_p(char *, kwnames), &py_hPrinter)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	return true;
}

static PyObject *unpack_py_winspool_AsyncEndPagePrinter_args_out(struct winspool_AsyncEndPagePrinter *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncEndDocPrinter_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncEndDocPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncEndDocPrinter_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEndDocPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncEndDocPrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncEndDocPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncEndDocPrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEndDocPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncEndDocPrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncEndDocPrinter_in_get_hPrinter,
		.set = py_winspool_AsyncEndDocPrinter_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncEndDocPrinter_get_result,
		.set = py_winspool_AsyncEndDocPrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncEndDocPrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncEndDocPrinter, type);
	return self;
}

static PyObject *py_winspool_AsyncEndDocPrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(14);
}

static PyObject *py_winspool_AsyncEndDocPrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEndDocPrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEndDocPrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[14];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncEndDocPrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEndDocPrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEndDocPrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEndDocPrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEndDocPrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEndDocPrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEndDocPrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[14];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncEndDocPrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEndDocPrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEndDocPrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEndDocPrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEndDocPrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEndDocPrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEndDocPrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[14];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncEndDocPrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEndDocPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncEndDocPrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncEndDocPrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEndDocPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncEndDocPrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncEndDocPrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncEndDocPrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncEndDocPrinter.opnum() -> 14 (0x0e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndDocPrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndDocPrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndDocPrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndDocPrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndDocPrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEndDocPrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncEndDocPrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncEndDocPrinter",
	.tp_getset = py_winspool_AsyncEndDocPrinter_getsetters,
	.tp_methods = py_winspool_AsyncEndDocPrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncEndDocPrinter_new,
};

static bool pack_py_winspool_AsyncEndDocPrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncEndDocPrinter *r)
{
	PyObject *py_hPrinter;
	const char *kwnames[] = {
		"hPrinter", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winspool_AsyncEndDocPrinter", discard_const_p(char *, kwnames), &py_hPrinter)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	return true;
}

static PyObject *unpack_py_winspool_AsyncEndDocPrinter_args_out(struct winspool_AsyncEndDocPrinter *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncAbortPrinter_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncAbortPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncAbortPrinter_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAbortPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncAbortPrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncAbortPrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncAbortPrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAbortPrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncAbortPrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncAbortPrinter_in_get_hPrinter,
		.set = py_winspool_AsyncAbortPrinter_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncAbortPrinter_get_result,
		.set = py_winspool_AsyncAbortPrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncAbortPrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncAbortPrinter, type);
	return self;
}

static PyObject *py_winspool_AsyncAbortPrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(15);
}

static PyObject *py_winspool_AsyncAbortPrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAbortPrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAbortPrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[15];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncAbortPrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncAbortPrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncAbortPrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncAbortPrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncAbortPrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAbortPrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAbortPrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[15];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncAbortPrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncAbortPrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncAbortPrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncAbortPrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncAbortPrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAbortPrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAbortPrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[15];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncAbortPrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncAbortPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncAbortPrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncAbortPrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncAbortPrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncAbortPrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncAbortPrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncAbortPrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncAbortPrinter.opnum() -> 15 (0x0f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAbortPrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAbortPrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAbortPrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAbortPrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAbortPrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAbortPrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncAbortPrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncAbortPrinter",
	.tp_getset = py_winspool_AsyncAbortPrinter_getsetters,
	.tp_methods = py_winspool_AsyncAbortPrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncAbortPrinter_new,
};

static bool pack_py_winspool_AsyncAbortPrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncAbortPrinter *r)
{
	PyObject *py_hPrinter;
	const char *kwnames[] = {
		"hPrinter", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winspool_AsyncAbortPrinter", discard_const_p(char *, kwnames), &py_hPrinter)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	return true;
}

static PyObject *unpack_py_winspool_AsyncAbortPrinter_args_out(struct winspool_AsyncAbortPrinter *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncGetPrinterData_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncGetPrinterData_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterData_in_get_pValueName(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pValueName;
	if (object->in.pValueName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pValueName == NULL) {
		py_pValueName = Py_None;
		Py_INCREF(py_pValueName);
	} else {
		py_pValueName = PyUnicode_Decode(object->in.pValueName, strlen(object->in.pValueName), "utf-8", "ignore");
	}
	return py_pValueName;
}

static int py_winspool_AsyncGetPrinterData_in_set_pValueName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pValueName");
		return -1;
	}
	object->in.pValueName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pValueName);
	if (object->in.pValueName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pValueName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterData_out_get_pType(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pType;
	if (object->out.pType == NULL) {
		Py_RETURN_NONE;
	}
	py_pType = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pType));
	return py_pType;
}

static int py_winspool_AsyncGetPrinterData_out_set_pType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pType));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pType");
		return -1;
	}
	object->out.pType = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pType);
	if (object->out.pType == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterData_out_get_pData(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pData;
	if (object->out.pData == NULL) {
		Py_RETURN_NONE;
	}
	py_pData = PyList_New(object->in.nSize);
	if (py_pData == NULL) {
		return NULL;
	}
	{
		int pData_cntr_1;
		for (pData_cntr_1 = 0; pData_cntr_1 < (object->in.nSize); pData_cntr_1++) {
			PyObject *py_pData_1;
			py_pData_1 = PyLong_FromLong((uint16_t)((object->out.pData)[pData_cntr_1]));
			PyList_SetItem(py_pData, pData_cntr_1, py_pData_1);
		}
	}
	return py_pData;
}

static int py_winspool_AsyncGetPrinterData_out_set_pData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pData");
		return -1;
	}
	object->out.pData = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pData);
	if (object->out.pData == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pData_cntr_1;
		object->out.pData = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pData, PyList_GET_SIZE(value));
		if (!object->out.pData) { return -1; }
		talloc_set_name_const(object->out.pData, "ARRAY: object->out.pData");
		for (pData_cntr_1 = 0; pData_cntr_1 < PyList_GET_SIZE(value); pData_cntr_1++) {
			if (PyList_GET_ITEM(value, pData_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pData)[pData_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pData)[pData_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pData_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pData_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.pData)[pData_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterData_in_get_nSize(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_nSize;
	py_nSize = PyLong_FromUnsignedLongLong((uint32_t)(object->in.nSize));
	return py_nSize;
}

static int py_winspool_AsyncGetPrinterData_in_set_nSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.nSize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.nSize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.nSize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterData_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncGetPrinterData_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterData_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncGetPrinterData_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncGetPrinterData_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncGetPrinterData_in_get_hPrinter,
		.set = py_winspool_AsyncGetPrinterData_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pValueName"),
		.get = py_winspool_AsyncGetPrinterData_in_get_pValueName,
		.set = py_winspool_AsyncGetPrinterData_in_set_pValueName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_pType"),
		.get = py_winspool_AsyncGetPrinterData_out_get_pType,
		.set = py_winspool_AsyncGetPrinterData_out_set_pType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pData"),
		.get = py_winspool_AsyncGetPrinterData_out_get_pData,
		.set = py_winspool_AsyncGetPrinterData_out_set_pData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_nSize"),
		.get = py_winspool_AsyncGetPrinterData_in_get_nSize,
		.set = py_winspool_AsyncGetPrinterData_in_set_nSize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncGetPrinterData_out_get_pcbNeeded,
		.set = py_winspool_AsyncGetPrinterData_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncGetPrinterData_get_result,
		.set = py_winspool_AsyncGetPrinterData_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncGetPrinterData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncGetPrinterData, type);
	struct winspool_AsyncGetPrinterData *_self = (struct winspool_AsyncGetPrinterData *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pType = talloc_zero(mem_ctx, uint32_t);
	_self->out.pData = talloc_zero(mem_ctx, uint8_t);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncGetPrinterData_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(16);
}

static PyObject *py_winspool_AsyncGetPrinterData_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinterData_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[16];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncGetPrinterData_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetPrinterData_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetPrinterData_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetPrinterData_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetPrinterData_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinterData_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[16];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncGetPrinterData_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetPrinterData_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetPrinterData_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetPrinterData_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetPrinterData_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinterData *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinterData_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[16];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncGetPrinterData_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetPrinterData_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetPrinterData_in", NDR_IN);
}

static PyObject *py_winspool_AsyncGetPrinterData_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetPrinterData_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetPrinterData_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncGetPrinterData_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncGetPrinterData_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncGetPrinterData.opnum() -> 16 (0x10) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterData_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterData_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterData_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterData_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterData_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterData_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncGetPrinterData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncGetPrinterData",
	.tp_getset = py_winspool_AsyncGetPrinterData_getsetters,
	.tp_methods = py_winspool_AsyncGetPrinterData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncGetPrinterData_new,
};

static bool pack_py_winspool_AsyncGetPrinterData_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncGetPrinterData *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pValueName;
	PyObject *py_nSize;
	const char *kwnames[] = {
		"hPrinter", "pValueName", "nSize", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winspool_AsyncGetPrinterData", discard_const_p(char *, kwnames), &py_hPrinter, &py_pValueName, &py_nSize)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pValueName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pValueName");
		return false;
	}
	r->in.pValueName = talloc_ptrtype(r, r->in.pValueName);
	if (r->in.pValueName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pValueName)) {
			unicode = PyUnicode_AsEncodedString(py_pValueName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pValueName)) {
			test_str = PyBytes_AS_STRING(py_pValueName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pValueName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pValueName = talloc_str;
	}
	if (py_nSize == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.nSize");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.nSize));
		if (PyLong_Check(py_nSize)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_nSize);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.nSize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncGetPrinterData_args_out(struct winspool_AsyncGetPrinterData *r, bool raise_result_exception)
{
	PyObject *py_pType = NULL;
	PyObject *py_pData = NULL;
	PyObject *py_pcbNeeded = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pType = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pType));
	PyTuple_SetItem(result, 0, py_pType);

	py_pData = PyList_New(r->in.nSize);
	if (py_pData == NULL) {
		return NULL;
	}
	{
		int pData_cntr_1;
		for (pData_cntr_1 = 0; pData_cntr_1 < (r->in.nSize); pData_cntr_1++) {
			PyObject *py_pData_1;
			py_pData_1 = PyLong_FromLong((uint16_t)((r->out.pData)[pData_cntr_1]));
			PyList_SetItem(py_pData, pData_cntr_1, py_pData_1);
		}
	}
	PyTuple_SetItem(result, 1, py_pData);

	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbNeeded));
	PyTuple_SetItem(result, 2, py_pcbNeeded);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncGetPrinterDataEx_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncGetPrinterDataEx_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_in_get_pKeyName(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pKeyName;
	if (object->in.pKeyName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pKeyName == NULL) {
		py_pKeyName = Py_None;
		Py_INCREF(py_pKeyName);
	} else {
		py_pKeyName = PyUnicode_Decode(object->in.pKeyName, strlen(object->in.pKeyName), "utf-8", "ignore");
	}
	return py_pKeyName;
}

static int py_winspool_AsyncGetPrinterDataEx_in_set_pKeyName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pKeyName");
		return -1;
	}
	object->in.pKeyName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pKeyName);
	if (object->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pKeyName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_in_get_pValueName(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pValueName;
	if (object->in.pValueName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pValueName == NULL) {
		py_pValueName = Py_None;
		Py_INCREF(py_pValueName);
	} else {
		py_pValueName = PyUnicode_Decode(object->in.pValueName, strlen(object->in.pValueName), "utf-8", "ignore");
	}
	return py_pValueName;
}

static int py_winspool_AsyncGetPrinterDataEx_in_set_pValueName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pValueName");
		return -1;
	}
	object->in.pValueName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pValueName);
	if (object->in.pValueName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pValueName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_out_get_pType(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pType;
	if (object->out.pType == NULL) {
		Py_RETURN_NONE;
	}
	py_pType = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pType));
	return py_pType;
}

static int py_winspool_AsyncGetPrinterDataEx_out_set_pType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pType));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pType");
		return -1;
	}
	object->out.pType = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pType);
	if (object->out.pType == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_out_get_pData(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pData;
	if (object->out.pData == NULL) {
		Py_RETURN_NONE;
	}
	py_pData = PyList_New(object->in.nSize);
	if (py_pData == NULL) {
		return NULL;
	}
	{
		int pData_cntr_1;
		for (pData_cntr_1 = 0; pData_cntr_1 < (object->in.nSize); pData_cntr_1++) {
			PyObject *py_pData_1;
			py_pData_1 = PyLong_FromLong((uint16_t)((object->out.pData)[pData_cntr_1]));
			PyList_SetItem(py_pData, pData_cntr_1, py_pData_1);
		}
	}
	return py_pData;
}

static int py_winspool_AsyncGetPrinterDataEx_out_set_pData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pData");
		return -1;
	}
	object->out.pData = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pData);
	if (object->out.pData == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pData_cntr_1;
		object->out.pData = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pData, PyList_GET_SIZE(value));
		if (!object->out.pData) { return -1; }
		talloc_set_name_const(object->out.pData, "ARRAY: object->out.pData");
		for (pData_cntr_1 = 0; pData_cntr_1 < PyList_GET_SIZE(value); pData_cntr_1++) {
			if (PyList_GET_ITEM(value, pData_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pData)[pData_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pData)[pData_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pData_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pData_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.pData)[pData_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_in_get_nSize(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_nSize;
	py_nSize = PyLong_FromUnsignedLongLong((uint32_t)(object->in.nSize));
	return py_nSize;
}

static int py_winspool_AsyncGetPrinterDataEx_in_set_nSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.nSize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.nSize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.nSize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncGetPrinterDataEx_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncGetPrinterDataEx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncGetPrinterDataEx_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncGetPrinterDataEx_in_get_hPrinter,
		.set = py_winspool_AsyncGetPrinterDataEx_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pKeyName"),
		.get = py_winspool_AsyncGetPrinterDataEx_in_get_pKeyName,
		.set = py_winspool_AsyncGetPrinterDataEx_in_set_pKeyName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pValueName"),
		.get = py_winspool_AsyncGetPrinterDataEx_in_get_pValueName,
		.set = py_winspool_AsyncGetPrinterDataEx_in_set_pValueName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_pType"),
		.get = py_winspool_AsyncGetPrinterDataEx_out_get_pType,
		.set = py_winspool_AsyncGetPrinterDataEx_out_set_pType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pData"),
		.get = py_winspool_AsyncGetPrinterDataEx_out_get_pData,
		.set = py_winspool_AsyncGetPrinterDataEx_out_set_pData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_nSize"),
		.get = py_winspool_AsyncGetPrinterDataEx_in_get_nSize,
		.set = py_winspool_AsyncGetPrinterDataEx_in_set_nSize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncGetPrinterDataEx_out_get_pcbNeeded,
		.set = py_winspool_AsyncGetPrinterDataEx_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncGetPrinterDataEx_get_result,
		.set = py_winspool_AsyncGetPrinterDataEx_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncGetPrinterDataEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncGetPrinterDataEx, type);
	struct winspool_AsyncGetPrinterDataEx *_self = (struct winspool_AsyncGetPrinterDataEx *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pType = talloc_zero(mem_ctx, uint32_t);
	_self->out.pData = talloc_zero(mem_ctx, uint8_t);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(17);
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinterDataEx_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[17];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetPrinterDataEx_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetPrinterDataEx_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinterDataEx_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[17];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetPrinterDataEx_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetPrinterDataEx_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinterDataEx_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[17];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetPrinterDataEx_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetPrinterDataEx_in", NDR_IN);
}

static PyObject *py_winspool_AsyncGetPrinterDataEx_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetPrinterDataEx_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetPrinterDataEx_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncGetPrinterDataEx_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncGetPrinterDataEx_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncGetPrinterDataEx.opnum() -> 17 (0x11) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDataEx_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDataEx_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDataEx_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDataEx_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDataEx_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDataEx_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncGetPrinterDataEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncGetPrinterDataEx",
	.tp_getset = py_winspool_AsyncGetPrinterDataEx_getsetters,
	.tp_methods = py_winspool_AsyncGetPrinterDataEx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncGetPrinterDataEx_new,
};

static bool pack_py_winspool_AsyncGetPrinterDataEx_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncGetPrinterDataEx *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pKeyName;
	PyObject *py_pValueName;
	PyObject *py_nSize;
	const char *kwnames[] = {
		"hPrinter", "pKeyName", "pValueName", "nSize", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winspool_AsyncGetPrinterDataEx", discard_const_p(char *, kwnames), &py_hPrinter, &py_pKeyName, &py_pValueName, &py_nSize)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pKeyName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pKeyName");
		return false;
	}
	r->in.pKeyName = talloc_ptrtype(r, r->in.pKeyName);
	if (r->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pKeyName)) {
			unicode = PyUnicode_AsEncodedString(py_pKeyName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pKeyName)) {
			test_str = PyBytes_AS_STRING(py_pKeyName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pKeyName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pKeyName = talloc_str;
	}
	if (py_pValueName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pValueName");
		return false;
	}
	r->in.pValueName = talloc_ptrtype(r, r->in.pValueName);
	if (r->in.pValueName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pValueName)) {
			unicode = PyUnicode_AsEncodedString(py_pValueName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pValueName)) {
			test_str = PyBytes_AS_STRING(py_pValueName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pValueName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pValueName = talloc_str;
	}
	if (py_nSize == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.nSize");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.nSize));
		if (PyLong_Check(py_nSize)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_nSize);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.nSize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncGetPrinterDataEx_args_out(struct winspool_AsyncGetPrinterDataEx *r, bool raise_result_exception)
{
	PyObject *py_pType = NULL;
	PyObject *py_pData = NULL;
	PyObject *py_pcbNeeded = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pType = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pType));
	PyTuple_SetItem(result, 0, py_pType);

	py_pData = PyList_New(r->in.nSize);
	if (py_pData == NULL) {
		return NULL;
	}
	{
		int pData_cntr_1;
		for (pData_cntr_1 = 0; pData_cntr_1 < (r->in.nSize); pData_cntr_1++) {
			PyObject *py_pData_1;
			py_pData_1 = PyLong_FromLong((uint16_t)((r->out.pData)[pData_cntr_1]));
			PyList_SetItem(py_pData, pData_cntr_1, py_pData_1);
		}
	}
	PyTuple_SetItem(result, 1, py_pData);

	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbNeeded));
	PyTuple_SetItem(result, 2, py_pcbNeeded);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncSetPrinterData_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncSetPrinterData_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinterData_in_get_pValueName(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pValueName;
	if (object->in.pValueName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pValueName == NULL) {
		py_pValueName = Py_None;
		Py_INCREF(py_pValueName);
	} else {
		py_pValueName = PyUnicode_Decode(object->in.pValueName, strlen(object->in.pValueName), "utf-8", "ignore");
	}
	return py_pValueName;
}

static int py_winspool_AsyncSetPrinterData_in_set_pValueName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pValueName");
		return -1;
	}
	object->in.pValueName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pValueName);
	if (object->in.pValueName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pValueName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinterData_in_get_Type(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_Type;
	py_Type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Type));
	return py_Type;
}

static int py_winspool_AsyncSetPrinterData_in_set_Type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinterData_in_get_pData(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pData;
	if (object->in.pData == NULL) {
		Py_RETURN_NONE;
	}
	py_pData = PyList_New(object->in.cbData);
	if (py_pData == NULL) {
		return NULL;
	}
	{
		int pData_cntr_1;
		for (pData_cntr_1 = 0; pData_cntr_1 < (object->in.cbData); pData_cntr_1++) {
			PyObject *py_pData_1;
			py_pData_1 = PyLong_FromLong((uint16_t)((object->in.pData)[pData_cntr_1]));
			PyList_SetItem(py_pData, pData_cntr_1, py_pData_1);
		}
	}
	return py_pData;
}

static int py_winspool_AsyncSetPrinterData_in_set_pData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pData");
		return -1;
	}
	object->in.pData = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pData);
	if (object->in.pData == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pData_cntr_1;
		object->in.pData = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pData, PyList_GET_SIZE(value));
		if (!object->in.pData) { return -1; }
		talloc_set_name_const(object->in.pData, "ARRAY: object->in.pData");
		for (pData_cntr_1 = 0; pData_cntr_1 < PyList_GET_SIZE(value); pData_cntr_1++) {
			if (PyList_GET_ITEM(value, pData_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pData)[pData_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pData)[pData_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pData_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pData_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.pData)[pData_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinterData_in_get_cbData(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_cbData;
	py_cbData = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbData));
	return py_cbData;
}

static int py_winspool_AsyncSetPrinterData_in_set_cbData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbData");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbData));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbData = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinterData_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncSetPrinterData_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncSetPrinterData_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncSetPrinterData_in_get_hPrinter,
		.set = py_winspool_AsyncSetPrinterData_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pValueName"),
		.get = py_winspool_AsyncSetPrinterData_in_get_pValueName,
		.set = py_winspool_AsyncSetPrinterData_in_set_pValueName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Type"),
		.get = py_winspool_AsyncSetPrinterData_in_get_Type,
		.set = py_winspool_AsyncSetPrinterData_in_set_Type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pData"),
		.get = py_winspool_AsyncSetPrinterData_in_get_pData,
		.set = py_winspool_AsyncSetPrinterData_in_set_pData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbData"),
		.get = py_winspool_AsyncSetPrinterData_in_get_cbData,
		.set = py_winspool_AsyncSetPrinterData_in_set_cbData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncSetPrinterData_get_result,
		.set = py_winspool_AsyncSetPrinterData_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncSetPrinterData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncSetPrinterData, type);
	struct winspool_AsyncSetPrinterData *_self = (struct winspool_AsyncSetPrinterData *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pData = talloc_zero(mem_ctx, uint8_t);
	return self;
}

static PyObject *py_winspool_AsyncSetPrinterData_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(18);
}

static PyObject *py_winspool_AsyncSetPrinterData_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetPrinterData_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[18];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncSetPrinterData_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSetPrinterData_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSetPrinterData_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSetPrinterData_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSetPrinterData_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetPrinterData_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[18];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncSetPrinterData_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSetPrinterData_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSetPrinterData_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSetPrinterData_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSetPrinterData_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetPrinterData *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetPrinterData_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[18];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncSetPrinterData_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSetPrinterData_ndr_print(py_obj, args, kwargs, "winspool_AsyncSetPrinterData_in", NDR_IN);
}

static PyObject *py_winspool_AsyncSetPrinterData_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSetPrinterData_ndr_print(py_obj, args, kwargs, "winspool_AsyncSetPrinterData_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncSetPrinterData_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncSetPrinterData_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncSetPrinterData.opnum() -> 18 (0x12) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterData_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterData_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterData_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterData_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterData_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterData_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncSetPrinterData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncSetPrinterData",
	.tp_getset = py_winspool_AsyncSetPrinterData_getsetters,
	.tp_methods = py_winspool_AsyncSetPrinterData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncSetPrinterData_new,
};

static bool pack_py_winspool_AsyncSetPrinterData_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncSetPrinterData *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pValueName;
	PyObject *py_Type;
	PyObject *py_pData;
	const char *kwnames[] = {
		"hPrinter", "pValueName", "Type", "pData", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winspool_AsyncSetPrinterData", discard_const_p(char *, kwnames), &py_hPrinter, &py_pValueName, &py_Type, &py_pData)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pValueName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pValueName");
		return false;
	}
	r->in.pValueName = talloc_ptrtype(r, r->in.pValueName);
	if (r->in.pValueName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pValueName)) {
			unicode = PyUnicode_AsEncodedString(py_pValueName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pValueName)) {
			test_str = PyBytes_AS_STRING(py_pValueName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pValueName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pValueName = talloc_str;
	}
	if (py_Type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Type));
		if (PyLong_Check(py_Type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pData == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pData");
		return false;
	}
	r->in.pData = talloc_ptrtype(r, r->in.pData);
	if (r->in.pData == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_pData, return false;);
	{
		int pData_cntr_1;
		r->in.pData = talloc_array_ptrtype(r, r->in.pData, PyList_GET_SIZE(py_pData));
		if (!r->in.pData) { return false; }
		talloc_set_name_const(r->in.pData, "ARRAY: r->in.pData");
		for (pData_cntr_1 = 0; pData_cntr_1 < PyList_GET_SIZE(py_pData); pData_cntr_1++) {
			if (PyList_GET_ITEM(py_pData, pData_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pData)[pData_cntr_1]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pData)[pData_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(py_pData, pData_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pData, pData_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.pData)[pData_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pData, return false;);
	r->in.cbData = PyList_GET_SIZE(py_pData);
	return true;
}

static PyObject *unpack_py_winspool_AsyncSetPrinterData_args_out(struct winspool_AsyncSetPrinterData *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncSetPrinterDataEx_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncSetPrinterDataEx_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_in_get_pKeyName(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pKeyName;
	if (object->in.pKeyName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pKeyName == NULL) {
		py_pKeyName = Py_None;
		Py_INCREF(py_pKeyName);
	} else {
		py_pKeyName = PyUnicode_Decode(object->in.pKeyName, strlen(object->in.pKeyName), "utf-8", "ignore");
	}
	return py_pKeyName;
}

static int py_winspool_AsyncSetPrinterDataEx_in_set_pKeyName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pKeyName");
		return -1;
	}
	object->in.pKeyName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pKeyName);
	if (object->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pKeyName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_in_get_pValueName(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pValueName;
	if (object->in.pValueName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pValueName == NULL) {
		py_pValueName = Py_None;
		Py_INCREF(py_pValueName);
	} else {
		py_pValueName = PyUnicode_Decode(object->in.pValueName, strlen(object->in.pValueName), "utf-8", "ignore");
	}
	return py_pValueName;
}

static int py_winspool_AsyncSetPrinterDataEx_in_set_pValueName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pValueName");
		return -1;
	}
	object->in.pValueName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pValueName);
	if (object->in.pValueName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pValueName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_in_get_Type(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_Type;
	py_Type = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Type));
	return py_Type;
}

static int py_winspool_AsyncSetPrinterDataEx_in_set_Type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_in_get_pData(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pData;
	if (object->in.pData == NULL) {
		Py_RETURN_NONE;
	}
	py_pData = PyList_New(object->in.cbData);
	if (py_pData == NULL) {
		return NULL;
	}
	{
		int pData_cntr_1;
		for (pData_cntr_1 = 0; pData_cntr_1 < (object->in.cbData); pData_cntr_1++) {
			PyObject *py_pData_1;
			py_pData_1 = PyLong_FromLong((uint16_t)((object->in.pData)[pData_cntr_1]));
			PyList_SetItem(py_pData, pData_cntr_1, py_pData_1);
		}
	}
	return py_pData;
}

static int py_winspool_AsyncSetPrinterDataEx_in_set_pData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pData");
		return -1;
	}
	object->in.pData = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pData);
	if (object->in.pData == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pData_cntr_1;
		object->in.pData = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pData, PyList_GET_SIZE(value));
		if (!object->in.pData) { return -1; }
		talloc_set_name_const(object->in.pData, "ARRAY: object->in.pData");
		for (pData_cntr_1 = 0; pData_cntr_1 < PyList_GET_SIZE(value); pData_cntr_1++) {
			if (PyList_GET_ITEM(value, pData_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pData)[pData_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pData)[pData_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pData_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pData_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.pData)[pData_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_in_get_cbData(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_cbData;
	py_cbData = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbData));
	return py_cbData;
}

static int py_winspool_AsyncSetPrinterDataEx_in_set_cbData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbData");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbData));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbData = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncSetPrinterDataEx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncSetPrinterDataEx_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncSetPrinterDataEx_in_get_hPrinter,
		.set = py_winspool_AsyncSetPrinterDataEx_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pKeyName"),
		.get = py_winspool_AsyncSetPrinterDataEx_in_get_pKeyName,
		.set = py_winspool_AsyncSetPrinterDataEx_in_set_pKeyName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pValueName"),
		.get = py_winspool_AsyncSetPrinterDataEx_in_get_pValueName,
		.set = py_winspool_AsyncSetPrinterDataEx_in_set_pValueName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Type"),
		.get = py_winspool_AsyncSetPrinterDataEx_in_get_Type,
		.set = py_winspool_AsyncSetPrinterDataEx_in_set_Type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pData"),
		.get = py_winspool_AsyncSetPrinterDataEx_in_get_pData,
		.set = py_winspool_AsyncSetPrinterDataEx_in_set_pData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbData"),
		.get = py_winspool_AsyncSetPrinterDataEx_in_get_cbData,
		.set = py_winspool_AsyncSetPrinterDataEx_in_set_cbData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncSetPrinterDataEx_get_result,
		.set = py_winspool_AsyncSetPrinterDataEx_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncSetPrinterDataEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncSetPrinterDataEx, type);
	struct winspool_AsyncSetPrinterDataEx *_self = (struct winspool_AsyncSetPrinterDataEx *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pData = talloc_zero(mem_ctx, uint8_t);
	return self;
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(19);
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetPrinterDataEx_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[19];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSetPrinterDataEx_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSetPrinterDataEx_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetPrinterDataEx_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[19];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSetPrinterDataEx_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSetPrinterDataEx_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetPrinterDataEx_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[19];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSetPrinterDataEx_ndr_print(py_obj, args, kwargs, "winspool_AsyncSetPrinterDataEx_in", NDR_IN);
}

static PyObject *py_winspool_AsyncSetPrinterDataEx_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSetPrinterDataEx_ndr_print(py_obj, args, kwargs, "winspool_AsyncSetPrinterDataEx_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncSetPrinterDataEx_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncSetPrinterDataEx_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncSetPrinterDataEx.opnum() -> 19 (0x13) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterDataEx_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterDataEx_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterDataEx_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterDataEx_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterDataEx_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetPrinterDataEx_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncSetPrinterDataEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncSetPrinterDataEx",
	.tp_getset = py_winspool_AsyncSetPrinterDataEx_getsetters,
	.tp_methods = py_winspool_AsyncSetPrinterDataEx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncSetPrinterDataEx_new,
};

static bool pack_py_winspool_AsyncSetPrinterDataEx_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncSetPrinterDataEx *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pKeyName;
	PyObject *py_pValueName;
	PyObject *py_Type;
	PyObject *py_pData;
	const char *kwnames[] = {
		"hPrinter", "pKeyName", "pValueName", "Type", "pData", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winspool_AsyncSetPrinterDataEx", discard_const_p(char *, kwnames), &py_hPrinter, &py_pKeyName, &py_pValueName, &py_Type, &py_pData)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pKeyName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pKeyName");
		return false;
	}
	r->in.pKeyName = talloc_ptrtype(r, r->in.pKeyName);
	if (r->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pKeyName)) {
			unicode = PyUnicode_AsEncodedString(py_pKeyName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pKeyName)) {
			test_str = PyBytes_AS_STRING(py_pKeyName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pKeyName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pKeyName = talloc_str;
	}
	if (py_pValueName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pValueName");
		return false;
	}
	r->in.pValueName = talloc_ptrtype(r, r->in.pValueName);
	if (r->in.pValueName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pValueName)) {
			unicode = PyUnicode_AsEncodedString(py_pValueName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pValueName)) {
			test_str = PyBytes_AS_STRING(py_pValueName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pValueName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pValueName = talloc_str;
	}
	if (py_Type == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Type");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Type));
		if (PyLong_Check(py_Type)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Type);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pData == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pData");
		return false;
	}
	r->in.pData = talloc_ptrtype(r, r->in.pData);
	if (r->in.pData == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_pData, return false;);
	{
		int pData_cntr_1;
		r->in.pData = talloc_array_ptrtype(r, r->in.pData, PyList_GET_SIZE(py_pData));
		if (!r->in.pData) { return false; }
		talloc_set_name_const(r->in.pData, "ARRAY: r->in.pData");
		for (pData_cntr_1 = 0; pData_cntr_1 < PyList_GET_SIZE(py_pData); pData_cntr_1++) {
			if (PyList_GET_ITEM(py_pData, pData_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pData)[pData_cntr_1]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pData)[pData_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(py_pData, pData_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pData, pData_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.pData)[pData_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pData, return false;);
	r->in.cbData = PyList_GET_SIZE(py_pData);
	return true;
}

static PyObject *unpack_py_winspool_AsyncSetPrinterDataEx_args_out(struct winspool_AsyncSetPrinterDataEx *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncClosePrinter_in_get_phPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncClosePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_phPrinter;
	if (object->in.phPrinter == NULL) {
		Py_RETURN_NONE;
	}
	py_phPrinter = pytalloc_reference_ex(policy_handle_Type, object->in.phPrinter, object->in.phPrinter);
	return py_phPrinter;
}

static int py_winspool_AsyncClosePrinter_in_set_phPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncClosePrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.phPrinter));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.phPrinter");
		return -1;
	}
	object->in.phPrinter = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.phPrinter);
	if (object->in.phPrinter == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.phPrinter = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncClosePrinter_out_get_phPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncClosePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_phPrinter;
	if (object->out.phPrinter == NULL) {
		Py_RETURN_NONE;
	}
	py_phPrinter = pytalloc_reference_ex(policy_handle_Type, object->out.phPrinter, object->out.phPrinter);
	return py_phPrinter;
}

static int py_winspool_AsyncClosePrinter_out_set_phPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncClosePrinter *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.phPrinter));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.phPrinter");
		return -1;
	}
	object->out.phPrinter = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.phPrinter);
	if (object->out.phPrinter == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.phPrinter = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncClosePrinter_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncClosePrinter *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncClosePrinter_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncClosePrinter *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncClosePrinter_getsetters[] = {
	{
		.name = discard_const_p(char, "in_phPrinter"),
		.get = py_winspool_AsyncClosePrinter_in_get_phPrinter,
		.set = py_winspool_AsyncClosePrinter_in_set_phPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_phPrinter"),
		.get = py_winspool_AsyncClosePrinter_out_get_phPrinter,
		.set = py_winspool_AsyncClosePrinter_out_set_phPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncClosePrinter_get_result,
		.set = py_winspool_AsyncClosePrinter_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncClosePrinter_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncClosePrinter, type);
	struct winspool_AsyncClosePrinter *_self = (struct winspool_AsyncClosePrinter *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.phPrinter = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.phPrinter = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winspool_AsyncClosePrinter_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(20);
}

static PyObject *py_winspool_AsyncClosePrinter_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncClosePrinter *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncClosePrinter_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[20];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncClosePrinter_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncClosePrinter_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncClosePrinter_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncClosePrinter_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncClosePrinter_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncClosePrinter *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncClosePrinter_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[20];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncClosePrinter_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncClosePrinter_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncClosePrinter_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncClosePrinter_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncClosePrinter_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncClosePrinter *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncClosePrinter_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[20];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncClosePrinter_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncClosePrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncClosePrinter_in", NDR_IN);
}

static PyObject *py_winspool_AsyncClosePrinter_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncClosePrinter_ndr_print(py_obj, args, kwargs, "winspool_AsyncClosePrinter_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncClosePrinter_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncClosePrinter_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncClosePrinter.opnum() -> 20 (0x14) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncClosePrinter_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncClosePrinter_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncClosePrinter_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncClosePrinter_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncClosePrinter_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncClosePrinter_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncClosePrinter_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncClosePrinter",
	.tp_getset = py_winspool_AsyncClosePrinter_getsetters,
	.tp_methods = py_winspool_AsyncClosePrinter_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncClosePrinter_new,
};

static bool pack_py_winspool_AsyncClosePrinter_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncClosePrinter *r)
{
	PyObject *py_phPrinter;
	const char *kwnames[] = {
		"phPrinter", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winspool_AsyncClosePrinter", discard_const_p(char *, kwnames), &py_phPrinter)) {
		return false;
	}

	if (py_phPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.phPrinter");
		return false;
	}
	r->in.phPrinter = talloc_ptrtype(r, r->in.phPrinter);
	if (r->in.phPrinter == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_phPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_phPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.phPrinter = (struct policy_handle *)pytalloc_get_ptr(py_phPrinter);
	return true;
}

static PyObject *unpack_py_winspool_AsyncClosePrinter_args_out(struct winspool_AsyncClosePrinter *r, bool raise_result_exception)
{
	PyObject *py_phPrinter = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_phPrinter = pytalloc_reference_ex(policy_handle_Type, r->out.phPrinter, r->out.phPrinter);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_phPrinter);
	}
	if (result_size == 1) {
		result = py_phPrinter;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncAddForm_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddForm *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncAddForm_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncAddForm_in_get_pFormInfoContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddForm *object = pytalloc_get_ptr(obj);
	PyObject *py_pFormInfoContainer;
	if (object->in.pFormInfoContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pFormInfoContainer = pytalloc_reference_ex(spoolss_AddFormInfoCtr_Type, object->in.pFormInfoContainer, object->in.pFormInfoContainer);
	return py_pFormInfoContainer;
}

static int py_winspool_AsyncAddForm_in_set_pFormInfoContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddForm *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pFormInfoContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pFormInfoContainer");
		return -1;
	}
	object->in.pFormInfoContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pFormInfoContainer);
	if (object->in.pFormInfoContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_AddFormInfoCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pFormInfoContainer = (struct spoolss_AddFormInfoCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncAddForm_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddForm *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncAddForm_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncAddForm_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncAddForm_in_get_hPrinter,
		.set = py_winspool_AsyncAddForm_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pFormInfoContainer"),
		.get = py_winspool_AsyncAddForm_in_get_pFormInfoContainer,
		.set = py_winspool_AsyncAddForm_in_set_pFormInfoContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_AddFormInfoCtr")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncAddForm_get_result,
		.set = py_winspool_AsyncAddForm_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncAddForm_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncAddForm, type);
	struct winspool_AsyncAddForm *_self = (struct winspool_AsyncAddForm *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pFormInfoContainer = talloc_zero(mem_ctx, struct spoolss_AddFormInfoCtr);
	return self;
}

static PyObject *py_winspool_AsyncAddForm_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(21);
}

static PyObject *py_winspool_AsyncAddForm_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddForm *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddForm_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[21];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncAddForm_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncAddForm_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncAddForm_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncAddForm_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncAddForm_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddForm *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddForm_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[21];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncAddForm_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncAddForm_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncAddForm_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncAddForm_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncAddForm_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddForm *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddForm_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[21];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncAddForm_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncAddForm_ndr_print(py_obj, args, kwargs, "winspool_AsyncAddForm_in", NDR_IN);
}

static PyObject *py_winspool_AsyncAddForm_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncAddForm_ndr_print(py_obj, args, kwargs, "winspool_AsyncAddForm_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncAddForm_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncAddForm_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncAddForm.opnum() -> 21 (0x15) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddForm_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddForm_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddForm_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddForm_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddForm_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddForm_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncAddForm_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncAddForm",
	.tp_getset = py_winspool_AsyncAddForm_getsetters,
	.tp_methods = py_winspool_AsyncAddForm_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncAddForm_new,
};

static bool pack_py_winspool_AsyncAddForm_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncAddForm *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pFormInfoContainer;
	const char *kwnames[] = {
		"hPrinter", "pFormInfoContainer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winspool_AsyncAddForm", discard_const_p(char *, kwnames), &py_hPrinter, &py_pFormInfoContainer)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pFormInfoContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pFormInfoContainer");
		return false;
	}
	r->in.pFormInfoContainer = talloc_ptrtype(r, r->in.pFormInfoContainer);
	if (r->in.pFormInfoContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_AddFormInfoCtr_Type, py_pFormInfoContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pFormInfoContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pFormInfoContainer = (struct spoolss_AddFormInfoCtr *)pytalloc_get_ptr(py_pFormInfoContainer);
	return true;
}

static PyObject *unpack_py_winspool_AsyncAddForm_args_out(struct winspool_AsyncAddForm *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncDeleteForm_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeleteForm *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncDeleteForm_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeleteForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncDeleteForm_in_get_pFormName(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeleteForm *object = pytalloc_get_ptr(obj);
	PyObject *py_pFormName;
	if (object->in.pFormName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pFormName == NULL) {
		py_pFormName = Py_None;
		Py_INCREF(py_pFormName);
	} else {
		py_pFormName = PyUnicode_Decode(object->in.pFormName, strlen(object->in.pFormName), "utf-8", "ignore");
	}
	return py_pFormName;
}

static int py_winspool_AsyncDeleteForm_in_set_pFormName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeleteForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pFormName");
		return -1;
	}
	object->in.pFormName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pFormName);
	if (object->in.pFormName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pFormName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncDeleteForm_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeleteForm *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncDeleteForm_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeleteForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncDeleteForm_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncDeleteForm_in_get_hPrinter,
		.set = py_winspool_AsyncDeleteForm_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pFormName"),
		.get = py_winspool_AsyncDeleteForm_in_get_pFormName,
		.set = py_winspool_AsyncDeleteForm_in_set_pFormName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncDeleteForm_get_result,
		.set = py_winspool_AsyncDeleteForm_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncDeleteForm_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncDeleteForm, type);
	return self;
}

static PyObject *py_winspool_AsyncDeleteForm_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(22);
}

static PyObject *py_winspool_AsyncDeleteForm_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeleteForm *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeleteForm_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[22];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncDeleteForm_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeleteForm_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeleteForm_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeleteForm_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeleteForm_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeleteForm *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeleteForm_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[22];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncDeleteForm_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeleteForm_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeleteForm_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeleteForm_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeleteForm_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeleteForm *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeleteForm_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[22];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncDeleteForm_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeleteForm_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeleteForm_in", NDR_IN);
}

static PyObject *py_winspool_AsyncDeleteForm_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeleteForm_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeleteForm_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncDeleteForm_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncDeleteForm_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncDeleteForm.opnum() -> 22 (0x16) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeleteForm_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeleteForm_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeleteForm_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeleteForm_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeleteForm_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeleteForm_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncDeleteForm_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncDeleteForm",
	.tp_getset = py_winspool_AsyncDeleteForm_getsetters,
	.tp_methods = py_winspool_AsyncDeleteForm_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncDeleteForm_new,
};

static bool pack_py_winspool_AsyncDeleteForm_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncDeleteForm *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pFormName;
	const char *kwnames[] = {
		"hPrinter", "pFormName", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winspool_AsyncDeleteForm", discard_const_p(char *, kwnames), &py_hPrinter, &py_pFormName)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pFormName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pFormName");
		return false;
	}
	r->in.pFormName = talloc_ptrtype(r, r->in.pFormName);
	if (r->in.pFormName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pFormName)) {
			unicode = PyUnicode_AsEncodedString(py_pFormName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pFormName)) {
			test_str = PyBytes_AS_STRING(py_pFormName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pFormName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pFormName = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncDeleteForm_args_out(struct winspool_AsyncDeleteForm *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncGetForm_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncGetForm_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncGetForm_in_get_pFormName(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_pFormName;
	if (object->in.pFormName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pFormName == NULL) {
		py_pFormName = Py_None;
		Py_INCREF(py_pFormName);
	} else {
		py_pFormName = PyUnicode_Decode(object->in.pFormName, strlen(object->in.pFormName), "utf-8", "ignore");
	}
	return py_pFormName;
}

static int py_winspool_AsyncGetForm_in_set_pFormName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pFormName");
		return -1;
	}
	object->in.pFormName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pFormName);
	if (object->in.pFormName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pFormName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetForm_in_get_Level(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_Level;
	py_Level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Level));
	return py_Level;
}

static int py_winspool_AsyncGetForm_in_set_Level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetForm_in_get_pForm(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_pForm;
	if (object->in.pForm == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pForm == NULL) {
		py_pForm = Py_None;
		Py_INCREF(py_pForm);
	} else {
		py_pForm = PyList_New(object->in.cbBuf);
		if (py_pForm == NULL) {
			return NULL;
		}
		{
			int pForm_cntr_1;
			for (pForm_cntr_1 = 0; pForm_cntr_1 < (object->in.cbBuf); pForm_cntr_1++) {
				PyObject *py_pForm_1;
				py_pForm_1 = PyLong_FromLong((uint16_t)((object->in.pForm)[pForm_cntr_1]));
				PyList_SetItem(py_pForm, pForm_cntr_1, py_pForm_1);
			}
		}
	}
	return py_pForm;
}

static int py_winspool_AsyncGetForm_in_set_pForm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pForm));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pForm");
		return -1;
	}
	if (value == Py_None) {
		object->in.pForm = NULL;
	} else {
		object->in.pForm = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pForm_cntr_1;
			object->in.pForm = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pForm, PyList_GET_SIZE(value));
			if (!object->in.pForm) { return -1; }
			talloc_set_name_const(object->in.pForm, "ARRAY: object->in.pForm");
			for (pForm_cntr_1 = 0; pForm_cntr_1 < PyList_GET_SIZE(value); pForm_cntr_1++) {
				if (PyList_GET_ITEM(value, pForm_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pForm)[pForm_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pForm)[pForm_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pForm_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pForm_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.pForm)[pForm_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetForm_out_get_pForm(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_pForm;
	if (object->out.pForm == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.pForm == NULL) {
		py_pForm = Py_None;
		Py_INCREF(py_pForm);
	} else {
		py_pForm = PyList_New(object->in.cbBuf);
		if (py_pForm == NULL) {
			return NULL;
		}
		{
			int pForm_cntr_1;
			for (pForm_cntr_1 = 0; pForm_cntr_1 < (object->in.cbBuf); pForm_cntr_1++) {
				PyObject *py_pForm_1;
				py_pForm_1 = PyLong_FromLong((uint16_t)((object->out.pForm)[pForm_cntr_1]));
				PyList_SetItem(py_pForm, pForm_cntr_1, py_pForm_1);
			}
		}
	}
	return py_pForm;
}

static int py_winspool_AsyncGetForm_out_set_pForm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pForm));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pForm");
		return -1;
	}
	if (value == Py_None) {
		object->out.pForm = NULL;
	} else {
		object->out.pForm = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pForm_cntr_1;
			object->out.pForm = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pForm, PyList_GET_SIZE(value));
			if (!object->out.pForm) { return -1; }
			talloc_set_name_const(object->out.pForm, "ARRAY: object->out.pForm");
			for (pForm_cntr_1 = 0; pForm_cntr_1 < PyList_GET_SIZE(value); pForm_cntr_1++) {
				if (PyList_GET_ITEM(value, pForm_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pForm)[pForm_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pForm)[pForm_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pForm_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pForm_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.pForm)[pForm_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetForm_in_get_cbBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_cbBuf;
	py_cbBuf = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbBuf));
	return py_cbBuf;
}

static int py_winspool_AsyncGetForm_in_set_cbBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbBuf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbBuf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbBuf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetForm_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncGetForm_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetForm_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncGetForm_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncGetForm_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncGetForm_in_get_hPrinter,
		.set = py_winspool_AsyncGetForm_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pFormName"),
		.get = py_winspool_AsyncGetForm_in_get_pFormName,
		.set = py_winspool_AsyncGetForm_in_set_pFormName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Level"),
		.get = py_winspool_AsyncGetForm_in_get_Level,
		.set = py_winspool_AsyncGetForm_in_set_Level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pForm"),
		.get = py_winspool_AsyncGetForm_in_get_pForm,
		.set = py_winspool_AsyncGetForm_in_set_pForm,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pForm"),
		.get = py_winspool_AsyncGetForm_out_get_pForm,
		.set = py_winspool_AsyncGetForm_out_set_pForm,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbBuf"),
		.get = py_winspool_AsyncGetForm_in_get_cbBuf,
		.set = py_winspool_AsyncGetForm_in_set_cbBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncGetForm_out_get_pcbNeeded,
		.set = py_winspool_AsyncGetForm_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncGetForm_get_result,
		.set = py_winspool_AsyncGetForm_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncGetForm_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncGetForm, type);
	struct winspool_AsyncGetForm *_self = (struct winspool_AsyncGetForm *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncGetForm_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(23);
}

static PyObject *py_winspool_AsyncGetForm_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetForm_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[23];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncGetForm_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetForm_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetForm_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetForm_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetForm_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetForm_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[23];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncGetForm_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetForm_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetForm_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetForm_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetForm_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetForm *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetForm_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[23];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncGetForm_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetForm_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetForm_in", NDR_IN);
}

static PyObject *py_winspool_AsyncGetForm_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetForm_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetForm_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncGetForm_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncGetForm_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncGetForm.opnum() -> 23 (0x17) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetForm_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetForm_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetForm_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetForm_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetForm_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetForm_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncGetForm_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncGetForm",
	.tp_getset = py_winspool_AsyncGetForm_getsetters,
	.tp_methods = py_winspool_AsyncGetForm_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncGetForm_new,
};

static bool pack_py_winspool_AsyncGetForm_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncGetForm *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pFormName;
	PyObject *py_Level;
	PyObject *py_pForm;
	const char *kwnames[] = {
		"hPrinter", "pFormName", "Level", "pForm", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winspool_AsyncGetForm", discard_const_p(char *, kwnames), &py_hPrinter, &py_pFormName, &py_Level, &py_pForm)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pFormName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pFormName");
		return false;
	}
	r->in.pFormName = talloc_ptrtype(r, r->in.pFormName);
	if (r->in.pFormName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pFormName)) {
			unicode = PyUnicode_AsEncodedString(py_pFormName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pFormName)) {
			test_str = PyBytes_AS_STRING(py_pFormName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pFormName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pFormName = talloc_str;
	}
	if (py_Level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Level));
		if (PyLong_Check(py_Level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pForm == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pForm");
		return false;
	}
	if (py_pForm == Py_None) {
		r->in.pForm = NULL;
	} else {
		r->in.pForm = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_pForm, return false;);
		{
			int pForm_cntr_1;
			r->in.pForm = talloc_array_ptrtype(r, r->in.pForm, PyList_GET_SIZE(py_pForm));
			if (!r->in.pForm) { return false; }
			talloc_set_name_const(r->in.pForm, "ARRAY: r->in.pForm");
			for (pForm_cntr_1 = 0; pForm_cntr_1 < PyList_GET_SIZE(py_pForm); pForm_cntr_1++) {
				if (PyList_GET_ITEM(py_pForm, pForm_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pForm)[pForm_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pForm)[pForm_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_pForm, pForm_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pForm, pForm_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.pForm)[pForm_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pForm, return false;);
	r->in.cbBuf = PyList_GET_SIZE(py_pForm);
	return true;
}

static PyObject *unpack_py_winspool_AsyncGetForm_args_out(struct winspool_AsyncGetForm *r, bool raise_result_exception)
{
	PyObject *py_pForm = NULL;
	PyObject *py_pcbNeeded = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.pForm == NULL) {
		py_pForm = Py_None;
		Py_INCREF(py_pForm);
	} else {
		py_pForm = PyList_New(r->in.cbBuf);
		if (py_pForm == NULL) {
			return NULL;
		}
		{
			int pForm_cntr_1;
			for (pForm_cntr_1 = 0; pForm_cntr_1 < (r->in.cbBuf); pForm_cntr_1++) {
				PyObject *py_pForm_1;
				py_pForm_1 = PyLong_FromLong((uint16_t)((r->out.pForm)[pForm_cntr_1]));
				PyList_SetItem(py_pForm, pForm_cntr_1, py_pForm_1);
			}
		}
	}
	PyTuple_SetItem(result, 0, py_pForm);

	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbNeeded));
	PyTuple_SetItem(result, 1, py_pcbNeeded);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncSetForm_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncSetForm_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncSetForm_in_get_pFormName(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_pFormName;
	if (object->in.pFormName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pFormName == NULL) {
		py_pFormName = Py_None;
		Py_INCREF(py_pFormName);
	} else {
		py_pFormName = PyUnicode_Decode(object->in.pFormName, strlen(object->in.pFormName), "utf-8", "ignore");
	}
	return py_pFormName;
}

static int py_winspool_AsyncSetForm_in_set_pFormName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pFormName");
		return -1;
	}
	object->in.pFormName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pFormName);
	if (object->in.pFormName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pFormName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncSetForm_in_get_pFormInfoContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_pFormInfoContainer;
	if (object->in.pFormInfoContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pFormInfoContainer = pytalloc_reference_ex(spoolss_AddFormInfoCtr_Type, object->in.pFormInfoContainer, object->in.pFormInfoContainer);
	return py_pFormInfoContainer;
}

static int py_winspool_AsyncSetForm_in_set_pFormInfoContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetForm *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pFormInfoContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pFormInfoContainer");
		return -1;
	}
	object->in.pFormInfoContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pFormInfoContainer);
	if (object->in.pFormInfoContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_AddFormInfoCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pFormInfoContainer = (struct spoolss_AddFormInfoCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncSetForm_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncSetForm *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncSetForm_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSetForm *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncSetForm_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncSetForm_in_get_hPrinter,
		.set = py_winspool_AsyncSetForm_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pFormName"),
		.get = py_winspool_AsyncSetForm_in_get_pFormName,
		.set = py_winspool_AsyncSetForm_in_set_pFormName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pFormInfoContainer"),
		.get = py_winspool_AsyncSetForm_in_get_pFormInfoContainer,
		.set = py_winspool_AsyncSetForm_in_set_pFormInfoContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_AddFormInfoCtr")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncSetForm_get_result,
		.set = py_winspool_AsyncSetForm_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncSetForm_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncSetForm, type);
	struct winspool_AsyncSetForm *_self = (struct winspool_AsyncSetForm *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pFormInfoContainer = talloc_zero(mem_ctx, struct spoolss_AddFormInfoCtr);
	return self;
}

static PyObject *py_winspool_AsyncSetForm_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(24);
}

static PyObject *py_winspool_AsyncSetForm_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetForm *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetForm_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[24];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncSetForm_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSetForm_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSetForm_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSetForm_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSetForm_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetForm *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetForm_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[24];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncSetForm_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSetForm_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSetForm_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSetForm_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSetForm_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSetForm *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSetForm_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[24];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncSetForm_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSetForm_ndr_print(py_obj, args, kwargs, "winspool_AsyncSetForm_in", NDR_IN);
}

static PyObject *py_winspool_AsyncSetForm_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSetForm_ndr_print(py_obj, args, kwargs, "winspool_AsyncSetForm_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncSetForm_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncSetForm_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncSetForm.opnum() -> 24 (0x18) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetForm_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetForm_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetForm_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetForm_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetForm_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSetForm_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncSetForm_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncSetForm",
	.tp_getset = py_winspool_AsyncSetForm_getsetters,
	.tp_methods = py_winspool_AsyncSetForm_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncSetForm_new,
};

static bool pack_py_winspool_AsyncSetForm_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncSetForm *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pFormName;
	PyObject *py_pFormInfoContainer;
	const char *kwnames[] = {
		"hPrinter", "pFormName", "pFormInfoContainer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winspool_AsyncSetForm", discard_const_p(char *, kwnames), &py_hPrinter, &py_pFormName, &py_pFormInfoContainer)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pFormName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pFormName");
		return false;
	}
	r->in.pFormName = talloc_ptrtype(r, r->in.pFormName);
	if (r->in.pFormName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pFormName)) {
			unicode = PyUnicode_AsEncodedString(py_pFormName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pFormName)) {
			test_str = PyBytes_AS_STRING(py_pFormName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pFormName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pFormName = talloc_str;
	}
	if (py_pFormInfoContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pFormInfoContainer");
		return false;
	}
	r->in.pFormInfoContainer = talloc_ptrtype(r, r->in.pFormInfoContainer);
	if (r->in.pFormInfoContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_AddFormInfoCtr_Type, py_pFormInfoContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pFormInfoContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pFormInfoContainer = (struct spoolss_AddFormInfoCtr *)pytalloc_get_ptr(py_pFormInfoContainer);
	return true;
}

static PyObject *unpack_py_winspool_AsyncSetForm_args_out(struct winspool_AsyncSetForm *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncEnumForms_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncEnumForms_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncEnumForms_in_get_Level(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(obj);
	PyObject *py_Level;
	py_Level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Level));
	return py_Level;
}

static int py_winspool_AsyncEnumForms_in_set_Level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumForms_in_get_pForm(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(obj);
	PyObject *py_pForm;
	if (object->in.pForm == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pForm == NULL) {
		py_pForm = Py_None;
		Py_INCREF(py_pForm);
	} else {
		py_pForm = PyList_New(object->in.cbBuf);
		if (py_pForm == NULL) {
			return NULL;
		}
		{
			int pForm_cntr_1;
			for (pForm_cntr_1 = 0; pForm_cntr_1 < (object->in.cbBuf); pForm_cntr_1++) {
				PyObject *py_pForm_1;
				py_pForm_1 = PyLong_FromLong((uint16_t)((object->in.pForm)[pForm_cntr_1]));
				PyList_SetItem(py_pForm, pForm_cntr_1, py_pForm_1);
			}
		}
	}
	return py_pForm;
}

static int py_winspool_AsyncEnumForms_in_set_pForm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pForm));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pForm");
		return -1;
	}
	if (value == Py_None) {
		object->in.pForm = NULL;
	} else {
		object->in.pForm = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pForm_cntr_1;
			object->in.pForm = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pForm, PyList_GET_SIZE(value));
			if (!object->in.pForm) { return -1; }
			talloc_set_name_const(object->in.pForm, "ARRAY: object->in.pForm");
			for (pForm_cntr_1 = 0; pForm_cntr_1 < PyList_GET_SIZE(value); pForm_cntr_1++) {
				if (PyList_GET_ITEM(value, pForm_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pForm)[pForm_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pForm)[pForm_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pForm_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pForm_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.pForm)[pForm_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumForms_out_get_pForm(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(obj);
	PyObject *py_pForm;
	if (object->out.pForm == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.pForm == NULL) {
		py_pForm = Py_None;
		Py_INCREF(py_pForm);
	} else {
		py_pForm = PyList_New(object->in.cbBuf);
		if (py_pForm == NULL) {
			return NULL;
		}
		{
			int pForm_cntr_1;
			for (pForm_cntr_1 = 0; pForm_cntr_1 < (object->in.cbBuf); pForm_cntr_1++) {
				PyObject *py_pForm_1;
				py_pForm_1 = PyLong_FromLong((uint16_t)((object->out.pForm)[pForm_cntr_1]));
				PyList_SetItem(py_pForm, pForm_cntr_1, py_pForm_1);
			}
		}
	}
	return py_pForm;
}

static int py_winspool_AsyncEnumForms_out_set_pForm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pForm));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pForm");
		return -1;
	}
	if (value == Py_None) {
		object->out.pForm = NULL;
	} else {
		object->out.pForm = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pForm_cntr_1;
			object->out.pForm = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pForm, PyList_GET_SIZE(value));
			if (!object->out.pForm) { return -1; }
			talloc_set_name_const(object->out.pForm, "ARRAY: object->out.pForm");
			for (pForm_cntr_1 = 0; pForm_cntr_1 < PyList_GET_SIZE(value); pForm_cntr_1++) {
				if (PyList_GET_ITEM(value, pForm_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pForm)[pForm_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pForm)[pForm_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pForm_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pForm_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.pForm)[pForm_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumForms_in_get_cbBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(obj);
	PyObject *py_cbBuf;
	py_cbBuf = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbBuf));
	return py_cbBuf;
}

static int py_winspool_AsyncEnumForms_in_set_cbBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbBuf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbBuf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbBuf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumForms_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncEnumForms_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumForms_out_get_pcReturned(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(obj);
	PyObject *py_pcReturned;
	if (object->out.pcReturned == NULL) {
		Py_RETURN_NONE;
	}
	py_pcReturned = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcReturned));
	return py_pcReturned;
}

static int py_winspool_AsyncEnumForms_out_set_pcReturned(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcReturned));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcReturned");
		return -1;
	}
	object->out.pcReturned = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcReturned);
	if (object->out.pcReturned == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcReturned));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcReturned = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumForms_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncEnumForms_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncEnumForms_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncEnumForms_in_get_hPrinter,
		.set = py_winspool_AsyncEnumForms_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_Level"),
		.get = py_winspool_AsyncEnumForms_in_get_Level,
		.set = py_winspool_AsyncEnumForms_in_set_Level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pForm"),
		.get = py_winspool_AsyncEnumForms_in_get_pForm,
		.set = py_winspool_AsyncEnumForms_in_set_pForm,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pForm"),
		.get = py_winspool_AsyncEnumForms_out_get_pForm,
		.set = py_winspool_AsyncEnumForms_out_set_pForm,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbBuf"),
		.get = py_winspool_AsyncEnumForms_in_get_cbBuf,
		.set = py_winspool_AsyncEnumForms_in_set_cbBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncEnumForms_out_get_pcbNeeded,
		.set = py_winspool_AsyncEnumForms_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcReturned"),
		.get = py_winspool_AsyncEnumForms_out_get_pcReturned,
		.set = py_winspool_AsyncEnumForms_out_set_pcReturned,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncEnumForms_get_result,
		.set = py_winspool_AsyncEnumForms_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncEnumForms_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncEnumForms, type);
	struct winspool_AsyncEnumForms *_self = (struct winspool_AsyncEnumForms *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	_self->out.pcReturned = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncEnumForms_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(25);
}

static PyObject *py_winspool_AsyncEnumForms_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumForms_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[25];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncEnumForms_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumForms_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumForms_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumForms_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumForms_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumForms_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[25];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncEnumForms_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumForms_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumForms_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumForms_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumForms_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumForms *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumForms_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[25];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncEnumForms_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumForms_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumForms_in", NDR_IN);
}

static PyObject *py_winspool_AsyncEnumForms_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumForms_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumForms_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncEnumForms_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncEnumForms_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncEnumForms.opnum() -> 25 (0x19) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumForms_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumForms_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumForms_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumForms_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumForms_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumForms_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncEnumForms_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncEnumForms",
	.tp_getset = py_winspool_AsyncEnumForms_getsetters,
	.tp_methods = py_winspool_AsyncEnumForms_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncEnumForms_new,
};

static bool pack_py_winspool_AsyncEnumForms_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncEnumForms *r)
{
	PyObject *py_hPrinter;
	PyObject *py_Level;
	PyObject *py_pForm;
	const char *kwnames[] = {
		"hPrinter", "Level", "pForm", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winspool_AsyncEnumForms", discard_const_p(char *, kwnames), &py_hPrinter, &py_Level, &py_pForm)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_Level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Level));
		if (PyLong_Check(py_Level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pForm == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pForm");
		return false;
	}
	if (py_pForm == Py_None) {
		r->in.pForm = NULL;
	} else {
		r->in.pForm = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_pForm, return false;);
		{
			int pForm_cntr_1;
			r->in.pForm = talloc_array_ptrtype(r, r->in.pForm, PyList_GET_SIZE(py_pForm));
			if (!r->in.pForm) { return false; }
			talloc_set_name_const(r->in.pForm, "ARRAY: r->in.pForm");
			for (pForm_cntr_1 = 0; pForm_cntr_1 < PyList_GET_SIZE(py_pForm); pForm_cntr_1++) {
				if (PyList_GET_ITEM(py_pForm, pForm_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pForm)[pForm_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pForm)[pForm_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_pForm, pForm_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pForm, pForm_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.pForm)[pForm_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pForm, return false;);
	r->in.cbBuf = PyList_GET_SIZE(py_pForm);
	return true;
}

static PyObject *unpack_py_winspool_AsyncEnumForms_args_out(struct winspool_AsyncEnumForms *r, bool raise_result_exception)
{
	PyObject *py_pForm = NULL;
	PyObject *py_pcbNeeded = NULL;
	PyObject *py_pcReturned = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.pForm == NULL) {
		py_pForm = Py_None;
		Py_INCREF(py_pForm);
	} else {
		py_pForm = PyList_New(r->in.cbBuf);
		if (py_pForm == NULL) {
			return NULL;
		}
		{
			int pForm_cntr_1;
			for (pForm_cntr_1 = 0; pForm_cntr_1 < (r->in.cbBuf); pForm_cntr_1++) {
				PyObject *py_pForm_1;
				py_pForm_1 = PyLong_FromLong((uint16_t)((r->out.pForm)[pForm_cntr_1]));
				PyList_SetItem(py_pForm, pForm_cntr_1, py_pForm_1);
			}
		}
	}
	PyTuple_SetItem(result, 0, py_pForm);

	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbNeeded));
	PyTuple_SetItem(result, 1, py_pcbNeeded);

	py_pcReturned = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcReturned));
	PyTuple_SetItem(result, 2, py_pcReturned);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncGetPrinterDriver_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncGetPrinterDriver_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_in_get_pEnvironment(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_pEnvironment;
	if (object->in.pEnvironment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pEnvironment == NULL) {
		py_pEnvironment = Py_None;
		Py_INCREF(py_pEnvironment);
	} else {
		if (object->in.pEnvironment == NULL) {
			py_pEnvironment = Py_None;
			Py_INCREF(py_pEnvironment);
		} else {
			py_pEnvironment = PyUnicode_Decode(object->in.pEnvironment, strlen(object->in.pEnvironment), "utf-8", "ignore");
		}
	}
	return py_pEnvironment;
}

static int py_winspool_AsyncGetPrinterDriver_in_set_pEnvironment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pEnvironment");
		return -1;
	}
	if (value == Py_None) {
		object->in.pEnvironment = NULL;
	} else {
		object->in.pEnvironment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pEnvironment = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_in_get_Level(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_Level;
	py_Level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Level));
	return py_Level;
}

static int py_winspool_AsyncGetPrinterDriver_in_set_Level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_in_get_pDriver(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_pDriver;
	if (object->in.pDriver == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pDriver == NULL) {
		py_pDriver = Py_None;
		Py_INCREF(py_pDriver);
	} else {
		py_pDriver = PyList_New(object->in.cbBuf);
		if (py_pDriver == NULL) {
			return NULL;
		}
		{
			int pDriver_cntr_1;
			for (pDriver_cntr_1 = 0; pDriver_cntr_1 < (object->in.cbBuf); pDriver_cntr_1++) {
				PyObject *py_pDriver_1;
				py_pDriver_1 = PyLong_FromLong((uint16_t)((object->in.pDriver)[pDriver_cntr_1]));
				PyList_SetItem(py_pDriver, pDriver_cntr_1, py_pDriver_1);
			}
		}
	}
	return py_pDriver;
}

static int py_winspool_AsyncGetPrinterDriver_in_set_pDriver(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pDriver));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pDriver");
		return -1;
	}
	if (value == Py_None) {
		object->in.pDriver = NULL;
	} else {
		object->in.pDriver = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pDriver_cntr_1;
			object->in.pDriver = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pDriver, PyList_GET_SIZE(value));
			if (!object->in.pDriver) { return -1; }
			talloc_set_name_const(object->in.pDriver, "ARRAY: object->in.pDriver");
			for (pDriver_cntr_1 = 0; pDriver_cntr_1 < PyList_GET_SIZE(value); pDriver_cntr_1++) {
				if (PyList_GET_ITEM(value, pDriver_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pDriver)[pDriver_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pDriver)[pDriver_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pDriver_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pDriver_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.pDriver)[pDriver_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_out_get_pDriver(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_pDriver;
	if (object->out.pDriver == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.pDriver == NULL) {
		py_pDriver = Py_None;
		Py_INCREF(py_pDriver);
	} else {
		py_pDriver = PyList_New(object->in.cbBuf);
		if (py_pDriver == NULL) {
			return NULL;
		}
		{
			int pDriver_cntr_1;
			for (pDriver_cntr_1 = 0; pDriver_cntr_1 < (object->in.cbBuf); pDriver_cntr_1++) {
				PyObject *py_pDriver_1;
				py_pDriver_1 = PyLong_FromLong((uint16_t)((object->out.pDriver)[pDriver_cntr_1]));
				PyList_SetItem(py_pDriver, pDriver_cntr_1, py_pDriver_1);
			}
		}
	}
	return py_pDriver;
}

static int py_winspool_AsyncGetPrinterDriver_out_set_pDriver(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pDriver));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pDriver");
		return -1;
	}
	if (value == Py_None) {
		object->out.pDriver = NULL;
	} else {
		object->out.pDriver = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pDriver_cntr_1;
			object->out.pDriver = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pDriver, PyList_GET_SIZE(value));
			if (!object->out.pDriver) { return -1; }
			talloc_set_name_const(object->out.pDriver, "ARRAY: object->out.pDriver");
			for (pDriver_cntr_1 = 0; pDriver_cntr_1 < PyList_GET_SIZE(value); pDriver_cntr_1++) {
				if (PyList_GET_ITEM(value, pDriver_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pDriver)[pDriver_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pDriver)[pDriver_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pDriver_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pDriver_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.pDriver)[pDriver_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_in_get_cbBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_cbBuf;
	py_cbBuf = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbBuf));
	return py_cbBuf;
}

static int py_winspool_AsyncGetPrinterDriver_in_set_cbBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbBuf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbBuf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbBuf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncGetPrinterDriver_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_in_get_dwClientMajorVersion(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_dwClientMajorVersion;
	py_dwClientMajorVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dwClientMajorVersion));
	return py_dwClientMajorVersion;
}

static int py_winspool_AsyncGetPrinterDriver_in_set_dwClientMajorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dwClientMajorVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dwClientMajorVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dwClientMajorVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_in_get_dwClientMinorVersion(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_dwClientMinorVersion;
	py_dwClientMinorVersion = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dwClientMinorVersion));
	return py_dwClientMinorVersion;
}

static int py_winspool_AsyncGetPrinterDriver_in_set_dwClientMinorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dwClientMinorVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dwClientMinorVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dwClientMinorVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_out_get_pdwServerMaxVersion(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_pdwServerMaxVersion;
	if (object->out.pdwServerMaxVersion == NULL) {
		Py_RETURN_NONE;
	}
	py_pdwServerMaxVersion = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pdwServerMaxVersion));
	return py_pdwServerMaxVersion;
}

static int py_winspool_AsyncGetPrinterDriver_out_set_pdwServerMaxVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pdwServerMaxVersion));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pdwServerMaxVersion");
		return -1;
	}
	object->out.pdwServerMaxVersion = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pdwServerMaxVersion);
	if (object->out.pdwServerMaxVersion == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pdwServerMaxVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pdwServerMaxVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_out_get_pdwServerMinVersion(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_pdwServerMinVersion;
	if (object->out.pdwServerMinVersion == NULL) {
		Py_RETURN_NONE;
	}
	py_pdwServerMinVersion = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pdwServerMinVersion));
	return py_pdwServerMinVersion;
}

static int py_winspool_AsyncGetPrinterDriver_out_set_pdwServerMinVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pdwServerMinVersion));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pdwServerMinVersion");
		return -1;
	}
	object->out.pdwServerMinVersion = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pdwServerMinVersion);
	if (object->out.pdwServerMinVersion == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pdwServerMinVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pdwServerMinVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncGetPrinterDriver_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncGetPrinterDriver_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncGetPrinterDriver_in_get_hPrinter,
		.set = py_winspool_AsyncGetPrinterDriver_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pEnvironment"),
		.get = py_winspool_AsyncGetPrinterDriver_in_get_pEnvironment,
		.set = py_winspool_AsyncGetPrinterDriver_in_set_pEnvironment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Level"),
		.get = py_winspool_AsyncGetPrinterDriver_in_get_Level,
		.set = py_winspool_AsyncGetPrinterDriver_in_set_Level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pDriver"),
		.get = py_winspool_AsyncGetPrinterDriver_in_get_pDriver,
		.set = py_winspool_AsyncGetPrinterDriver_in_set_pDriver,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pDriver"),
		.get = py_winspool_AsyncGetPrinterDriver_out_get_pDriver,
		.set = py_winspool_AsyncGetPrinterDriver_out_set_pDriver,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbBuf"),
		.get = py_winspool_AsyncGetPrinterDriver_in_get_cbBuf,
		.set = py_winspool_AsyncGetPrinterDriver_in_set_cbBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncGetPrinterDriver_out_get_pcbNeeded,
		.set = py_winspool_AsyncGetPrinterDriver_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_dwClientMajorVersion"),
		.get = py_winspool_AsyncGetPrinterDriver_in_get_dwClientMajorVersion,
		.set = py_winspool_AsyncGetPrinterDriver_in_set_dwClientMajorVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_dwClientMinorVersion"),
		.get = py_winspool_AsyncGetPrinterDriver_in_get_dwClientMinorVersion,
		.set = py_winspool_AsyncGetPrinterDriver_in_set_dwClientMinorVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pdwServerMaxVersion"),
		.get = py_winspool_AsyncGetPrinterDriver_out_get_pdwServerMaxVersion,
		.set = py_winspool_AsyncGetPrinterDriver_out_set_pdwServerMaxVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pdwServerMinVersion"),
		.get = py_winspool_AsyncGetPrinterDriver_out_get_pdwServerMinVersion,
		.set = py_winspool_AsyncGetPrinterDriver_out_set_pdwServerMinVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncGetPrinterDriver_get_result,
		.set = py_winspool_AsyncGetPrinterDriver_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncGetPrinterDriver_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncGetPrinterDriver, type);
	struct winspool_AsyncGetPrinterDriver *_self = (struct winspool_AsyncGetPrinterDriver *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	_self->out.pdwServerMaxVersion = talloc_zero(mem_ctx, uint32_t);
	_self->out.pdwServerMinVersion = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(26);
}

static PyObject *py_winspool_AsyncGetPrinterDriver_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinterDriver_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[26];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetPrinterDriver_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetPrinterDriver_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetPrinterDriver_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetPrinterDriver_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinterDriver_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[26];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetPrinterDriver_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetPrinterDriver_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncGetPrinterDriver_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncGetPrinterDriver_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinterDriver *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinterDriver_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[26];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncGetPrinterDriver_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetPrinterDriver_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetPrinterDriver_in", NDR_IN);
}

static PyObject *py_winspool_AsyncGetPrinterDriver_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncGetPrinterDriver_ndr_print(py_obj, args, kwargs, "winspool_AsyncGetPrinterDriver_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncGetPrinterDriver_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncGetPrinterDriver_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncGetPrinterDriver.opnum() -> 26 (0x1a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDriver_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDriver_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDriver_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDriver_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDriver_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncGetPrinterDriver_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncGetPrinterDriver_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncGetPrinterDriver",
	.tp_getset = py_winspool_AsyncGetPrinterDriver_getsetters,
	.tp_methods = py_winspool_AsyncGetPrinterDriver_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncGetPrinterDriver_new,
};

static bool pack_py_winspool_AsyncGetPrinterDriver_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncGetPrinterDriver *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pEnvironment;
	PyObject *py_Level;
	PyObject *py_pDriver;
	PyObject *py_dwClientMajorVersion;
	PyObject *py_dwClientMinorVersion;
	const char *kwnames[] = {
		"hPrinter", "pEnvironment", "Level", "pDriver", "dwClientMajorVersion", "dwClientMinorVersion", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:winspool_AsyncGetPrinterDriver", discard_const_p(char *, kwnames), &py_hPrinter, &py_pEnvironment, &py_Level, &py_pDriver, &py_dwClientMajorVersion, &py_dwClientMinorVersion)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pEnvironment == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pEnvironment");
		return false;
	}
	if (py_pEnvironment == Py_None) {
		r->in.pEnvironment = NULL;
	} else {
		r->in.pEnvironment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pEnvironment)) {
				unicode = PyUnicode_AsEncodedString(py_pEnvironment, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pEnvironment)) {
				test_str = PyBytes_AS_STRING(py_pEnvironment);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pEnvironment)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pEnvironment = talloc_str;
		}
	}
	if (py_Level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Level));
		if (PyLong_Check(py_Level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pDriver == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pDriver");
		return false;
	}
	if (py_pDriver == Py_None) {
		r->in.pDriver = NULL;
	} else {
		r->in.pDriver = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_pDriver, return false;);
		{
			int pDriver_cntr_1;
			r->in.pDriver = talloc_array_ptrtype(r, r->in.pDriver, PyList_GET_SIZE(py_pDriver));
			if (!r->in.pDriver) { return false; }
			talloc_set_name_const(r->in.pDriver, "ARRAY: r->in.pDriver");
			for (pDriver_cntr_1 = 0; pDriver_cntr_1 < PyList_GET_SIZE(py_pDriver); pDriver_cntr_1++) {
				if (PyList_GET_ITEM(py_pDriver, pDriver_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pDriver)[pDriver_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pDriver)[pDriver_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_pDriver, pDriver_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pDriver, pDriver_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.pDriver)[pDriver_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pDriver, return false;);
	r->in.cbBuf = PyList_GET_SIZE(py_pDriver);
	if (py_dwClientMajorVersion == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dwClientMajorVersion");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.dwClientMajorVersion));
		if (PyLong_Check(py_dwClientMajorVersion)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_dwClientMajorVersion);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.dwClientMajorVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_dwClientMinorVersion == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dwClientMinorVersion");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.dwClientMinorVersion));
		if (PyLong_Check(py_dwClientMinorVersion)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_dwClientMinorVersion);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.dwClientMinorVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncGetPrinterDriver_args_out(struct winspool_AsyncGetPrinterDriver *r, bool raise_result_exception)
{
	PyObject *py_pDriver = NULL;
	PyObject *py_pcbNeeded = NULL;
	PyObject *py_pdwServerMaxVersion = NULL;
	PyObject *py_pdwServerMinVersion = NULL;
	PyObject *result = NULL;
	size_t result_size = 4;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.pDriver == NULL) {
		py_pDriver = Py_None;
		Py_INCREF(py_pDriver);
	} else {
		py_pDriver = PyList_New(r->in.cbBuf);
		if (py_pDriver == NULL) {
			return NULL;
		}
		{
			int pDriver_cntr_1;
			for (pDriver_cntr_1 = 0; pDriver_cntr_1 < (r->in.cbBuf); pDriver_cntr_1++) {
				PyObject *py_pDriver_1;
				py_pDriver_1 = PyLong_FromLong((uint16_t)((r->out.pDriver)[pDriver_cntr_1]));
				PyList_SetItem(py_pDriver, pDriver_cntr_1, py_pDriver_1);
			}
		}
	}
	PyTuple_SetItem(result, 0, py_pDriver);

	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbNeeded));
	PyTuple_SetItem(result, 1, py_pcbNeeded);

	py_pdwServerMaxVersion = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pdwServerMaxVersion));
	PyTuple_SetItem(result, 2, py_pdwServerMaxVersion);

	py_pdwServerMinVersion = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pdwServerMinVersion));
	PyTuple_SetItem(result, 3, py_pdwServerMinVersion);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 4, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncEnumPrinterData_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncEnumPrinterData_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterData_in_get_dwIndex(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_dwIndex;
	py_dwIndex = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dwIndex));
	return py_dwIndex;
}

static int py_winspool_AsyncEnumPrinterData_in_set_dwIndex(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dwIndex");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dwIndex));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dwIndex = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterData_out_get_pValueName(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pValueName;
	if (object->out.pValueName == NULL) {
		Py_RETURN_NONE;
	}
	py_pValueName = PyList_New(object->in.cbValueName / 2);
	if (py_pValueName == NULL) {
		return NULL;
	}
	{
		int pValueName_cntr_1;
		for (pValueName_cntr_1 = 0; pValueName_cntr_1 < (object->in.cbValueName / 2); pValueName_cntr_1++) {
			PyObject *py_pValueName_1;
			py_pValueName_1 = PyLong_FromLong((uint16_t)((object->out.pValueName)[pValueName_cntr_1]));
			PyList_SetItem(py_pValueName, pValueName_cntr_1, py_pValueName_1);
		}
	}
	return py_pValueName;
}

static int py_winspool_AsyncEnumPrinterData_out_set_pValueName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pValueName));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pValueName");
		return -1;
	}
	object->out.pValueName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pValueName);
	if (object->out.pValueName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pValueName_cntr_1;
		object->out.pValueName = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pValueName, PyList_GET_SIZE(value));
		if (!object->out.pValueName) { return -1; }
		talloc_set_name_const(object->out.pValueName, "ARRAY: object->out.pValueName");
		for (pValueName_cntr_1 = 0; pValueName_cntr_1 < PyList_GET_SIZE(value); pValueName_cntr_1++) {
			if (PyList_GET_ITEM(value, pValueName_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pValueName)[pValueName_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pValueName)[pValueName_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pValueName_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pValueName_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.pValueName)[pValueName_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterData_in_get_cbValueName(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_cbValueName;
	py_cbValueName = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbValueName));
	return py_cbValueName;
}

static int py_winspool_AsyncEnumPrinterData_in_set_cbValueName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbValueName");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbValueName));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbValueName = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterData_out_get_pcbValueName(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbValueName;
	if (object->out.pcbValueName == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbValueName = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbValueName));
	return py_pcbValueName;
}

static int py_winspool_AsyncEnumPrinterData_out_set_pcbValueName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbValueName));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbValueName");
		return -1;
	}
	object->out.pcbValueName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbValueName);
	if (object->out.pcbValueName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbValueName));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbValueName = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterData_out_get_pType(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pType;
	if (object->out.pType == NULL) {
		Py_RETURN_NONE;
	}
	py_pType = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pType));
	return py_pType;
}

static int py_winspool_AsyncEnumPrinterData_out_set_pType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pType));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pType");
		return -1;
	}
	object->out.pType = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pType);
	if (object->out.pType == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterData_out_get_pData(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pData;
	if (object->out.pData == NULL) {
		Py_RETURN_NONE;
	}
	py_pData = PyList_New(object->in.cbData);
	if (py_pData == NULL) {
		return NULL;
	}
	{
		int pData_cntr_1;
		for (pData_cntr_1 = 0; pData_cntr_1 < (object->in.cbData); pData_cntr_1++) {
			PyObject *py_pData_1;
			py_pData_1 = PyLong_FromLong((uint16_t)((object->out.pData)[pData_cntr_1]));
			PyList_SetItem(py_pData, pData_cntr_1, py_pData_1);
		}
	}
	return py_pData;
}

static int py_winspool_AsyncEnumPrinterData_out_set_pData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pData");
		return -1;
	}
	object->out.pData = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pData);
	if (object->out.pData == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pData_cntr_1;
		object->out.pData = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pData, PyList_GET_SIZE(value));
		if (!object->out.pData) { return -1; }
		talloc_set_name_const(object->out.pData, "ARRAY: object->out.pData");
		for (pData_cntr_1 = 0; pData_cntr_1 < PyList_GET_SIZE(value); pData_cntr_1++) {
			if (PyList_GET_ITEM(value, pData_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pData)[pData_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pData)[pData_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pData_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pData_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.pData)[pData_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterData_in_get_cbData(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_cbData;
	py_cbData = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbData));
	return py_cbData;
}

static int py_winspool_AsyncEnumPrinterData_in_set_cbData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbData");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbData));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbData = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterData_out_get_pcbData(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbData;
	if (object->out.pcbData == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbData = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbData));
	return py_pcbData;
}

static int py_winspool_AsyncEnumPrinterData_out_set_pcbData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbData");
		return -1;
	}
	object->out.pcbData = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbData);
	if (object->out.pcbData == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbData));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbData = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterData_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncEnumPrinterData_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncEnumPrinterData_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncEnumPrinterData_in_get_hPrinter,
		.set = py_winspool_AsyncEnumPrinterData_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_dwIndex"),
		.get = py_winspool_AsyncEnumPrinterData_in_get_dwIndex,
		.set = py_winspool_AsyncEnumPrinterData_in_set_dwIndex,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pValueName"),
		.get = py_winspool_AsyncEnumPrinterData_out_get_pValueName,
		.set = py_winspool_AsyncEnumPrinterData_out_set_pValueName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_cbValueName"),
		.get = py_winspool_AsyncEnumPrinterData_in_get_cbValueName,
		.set = py_winspool_AsyncEnumPrinterData_in_set_cbValueName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbValueName"),
		.get = py_winspool_AsyncEnumPrinterData_out_get_pcbValueName,
		.set = py_winspool_AsyncEnumPrinterData_out_set_pcbValueName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pType"),
		.get = py_winspool_AsyncEnumPrinterData_out_get_pType,
		.set = py_winspool_AsyncEnumPrinterData_out_set_pType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pData"),
		.get = py_winspool_AsyncEnumPrinterData_out_get_pData,
		.set = py_winspool_AsyncEnumPrinterData_out_set_pData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbData"),
		.get = py_winspool_AsyncEnumPrinterData_in_get_cbData,
		.set = py_winspool_AsyncEnumPrinterData_in_set_cbData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbData"),
		.get = py_winspool_AsyncEnumPrinterData_out_get_pcbData,
		.set = py_winspool_AsyncEnumPrinterData_out_set_pcbData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncEnumPrinterData_get_result,
		.set = py_winspool_AsyncEnumPrinterData_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncEnumPrinterData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncEnumPrinterData, type);
	struct winspool_AsyncEnumPrinterData *_self = (struct winspool_AsyncEnumPrinterData *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pValueName = talloc_zero(mem_ctx, uint16_t);
	_self->out.pcbValueName = talloc_zero(mem_ctx, uint32_t);
	_self->out.pType = talloc_zero(mem_ctx, uint32_t);
	_self->out.pData = talloc_zero(mem_ctx, uint8_t);
	_self->out.pcbData = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncEnumPrinterData_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(27);
}

static PyObject *py_winspool_AsyncEnumPrinterData_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterData_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[27];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncEnumPrinterData_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumPrinterData_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumPrinterData_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumPrinterData_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumPrinterData_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterData_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[27];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncEnumPrinterData_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumPrinterData_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumPrinterData_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumPrinterData_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumPrinterData_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterData *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterData_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[27];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncEnumPrinterData_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumPrinterData_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumPrinterData_in", NDR_IN);
}

static PyObject *py_winspool_AsyncEnumPrinterData_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumPrinterData_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumPrinterData_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncEnumPrinterData_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncEnumPrinterData_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncEnumPrinterData.opnum() -> 27 (0x1b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterData_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterData_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterData_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterData_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterData_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterData_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncEnumPrinterData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncEnumPrinterData",
	.tp_getset = py_winspool_AsyncEnumPrinterData_getsetters,
	.tp_methods = py_winspool_AsyncEnumPrinterData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncEnumPrinterData_new,
};

static bool pack_py_winspool_AsyncEnumPrinterData_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncEnumPrinterData *r)
{
	PyObject *py_hPrinter;
	PyObject *py_dwIndex;
	PyObject *py_cbValueName;
	PyObject *py_cbData;
	const char *kwnames[] = {
		"hPrinter", "dwIndex", "cbValueName", "cbData", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winspool_AsyncEnumPrinterData", discard_const_p(char *, kwnames), &py_hPrinter, &py_dwIndex, &py_cbValueName, &py_cbData)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_dwIndex == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dwIndex");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.dwIndex));
		if (PyLong_Check(py_dwIndex)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_dwIndex);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.dwIndex = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_cbValueName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.cbValueName");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.cbValueName));
		if (PyLong_Check(py_cbValueName)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_cbValueName);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.cbValueName = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_cbData == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.cbData");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.cbData));
		if (PyLong_Check(py_cbData)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_cbData);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.cbData = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncEnumPrinterData_args_out(struct winspool_AsyncEnumPrinterData *r, bool raise_result_exception)
{
	PyObject *py_pValueName = NULL;
	PyObject *py_pcbValueName = NULL;
	PyObject *py_pType = NULL;
	PyObject *py_pData = NULL;
	PyObject *py_pcbData = NULL;
	PyObject *result = NULL;
	size_t result_size = 5;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pValueName = PyList_New(r->in.cbValueName / 2);
	if (py_pValueName == NULL) {
		return NULL;
	}
	{
		int pValueName_cntr_1;
		for (pValueName_cntr_1 = 0; pValueName_cntr_1 < (r->in.cbValueName / 2); pValueName_cntr_1++) {
			PyObject *py_pValueName_1;
			py_pValueName_1 = PyLong_FromLong((uint16_t)((r->out.pValueName)[pValueName_cntr_1]));
			PyList_SetItem(py_pValueName, pValueName_cntr_1, py_pValueName_1);
		}
	}
	PyTuple_SetItem(result, 0, py_pValueName);

	py_pcbValueName = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbValueName));
	PyTuple_SetItem(result, 1, py_pcbValueName);

	py_pType = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pType));
	PyTuple_SetItem(result, 2, py_pType);

	py_pData = PyList_New(r->in.cbData);
	if (py_pData == NULL) {
		return NULL;
	}
	{
		int pData_cntr_1;
		for (pData_cntr_1 = 0; pData_cntr_1 < (r->in.cbData); pData_cntr_1++) {
			PyObject *py_pData_1;
			py_pData_1 = PyLong_FromLong((uint16_t)((r->out.pData)[pData_cntr_1]));
			PyList_SetItem(py_pData, pData_cntr_1, py_pData_1);
		}
	}
	PyTuple_SetItem(result, 3, py_pData);

	py_pcbData = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbData));
	PyTuple_SetItem(result, 4, py_pcbData);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 5, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncEnumPrinterDataEx_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncEnumPrinterDataEx_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_in_get_pKeyName(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pKeyName;
	if (object->in.pKeyName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pKeyName == NULL) {
		py_pKeyName = Py_None;
		Py_INCREF(py_pKeyName);
	} else {
		py_pKeyName = PyUnicode_Decode(object->in.pKeyName, strlen(object->in.pKeyName), "utf-8", "ignore");
	}
	return py_pKeyName;
}

static int py_winspool_AsyncEnumPrinterDataEx_in_set_pKeyName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pKeyName");
		return -1;
	}
	object->in.pKeyName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pKeyName);
	if (object->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pKeyName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_out_get_pEnumValues(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pEnumValues;
	if (object->out.pEnumValues == NULL) {
		Py_RETURN_NONE;
	}
	py_pEnumValues = PyList_New(object->in.cbEnumValues);
	if (py_pEnumValues == NULL) {
		return NULL;
	}
	{
		int pEnumValues_cntr_1;
		for (pEnumValues_cntr_1 = 0; pEnumValues_cntr_1 < (object->in.cbEnumValues); pEnumValues_cntr_1++) {
			PyObject *py_pEnumValues_1;
			py_pEnumValues_1 = PyLong_FromLong((uint16_t)((object->out.pEnumValues)[pEnumValues_cntr_1]));
			PyList_SetItem(py_pEnumValues, pEnumValues_cntr_1, py_pEnumValues_1);
		}
	}
	return py_pEnumValues;
}

static int py_winspool_AsyncEnumPrinterDataEx_out_set_pEnumValues(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pEnumValues));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pEnumValues");
		return -1;
	}
	object->out.pEnumValues = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pEnumValues);
	if (object->out.pEnumValues == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pEnumValues_cntr_1;
		object->out.pEnumValues = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pEnumValues, PyList_GET_SIZE(value));
		if (!object->out.pEnumValues) { return -1; }
		talloc_set_name_const(object->out.pEnumValues, "ARRAY: object->out.pEnumValues");
		for (pEnumValues_cntr_1 = 0; pEnumValues_cntr_1 < PyList_GET_SIZE(value); pEnumValues_cntr_1++) {
			if (PyList_GET_ITEM(value, pEnumValues_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pEnumValues)[pEnumValues_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pEnumValues)[pEnumValues_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pEnumValues_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pEnumValues_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.pEnumValues)[pEnumValues_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_in_get_cbEnumValues(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_cbEnumValues;
	py_cbEnumValues = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbEnumValues));
	return py_cbEnumValues;
}

static int py_winspool_AsyncEnumPrinterDataEx_in_set_cbEnumValues(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbEnumValues");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbEnumValues));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbEnumValues = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_out_get_pcbEnumValues(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbEnumValues;
	if (object->out.pcbEnumValues == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbEnumValues = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbEnumValues));
	return py_pcbEnumValues;
}

static int py_winspool_AsyncEnumPrinterDataEx_out_set_pcbEnumValues(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbEnumValues));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbEnumValues");
		return -1;
	}
	object->out.pcbEnumValues = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbEnumValues);
	if (object->out.pcbEnumValues == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbEnumValues));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbEnumValues = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_out_get_pnEnumValues(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pnEnumValues;
	if (object->out.pnEnumValues == NULL) {
		Py_RETURN_NONE;
	}
	py_pnEnumValues = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pnEnumValues));
	return py_pnEnumValues;
}

static int py_winspool_AsyncEnumPrinterDataEx_out_set_pnEnumValues(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pnEnumValues));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pnEnumValues");
		return -1;
	}
	object->out.pnEnumValues = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pnEnumValues);
	if (object->out.pnEnumValues == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pnEnumValues));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pnEnumValues = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncEnumPrinterDataEx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncEnumPrinterDataEx_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncEnumPrinterDataEx_in_get_hPrinter,
		.set = py_winspool_AsyncEnumPrinterDataEx_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pKeyName"),
		.get = py_winspool_AsyncEnumPrinterDataEx_in_get_pKeyName,
		.set = py_winspool_AsyncEnumPrinterDataEx_in_set_pKeyName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_pEnumValues"),
		.get = py_winspool_AsyncEnumPrinterDataEx_out_get_pEnumValues,
		.set = py_winspool_AsyncEnumPrinterDataEx_out_set_pEnumValues,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbEnumValues"),
		.get = py_winspool_AsyncEnumPrinterDataEx_in_get_cbEnumValues,
		.set = py_winspool_AsyncEnumPrinterDataEx_in_set_cbEnumValues,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbEnumValues"),
		.get = py_winspool_AsyncEnumPrinterDataEx_out_get_pcbEnumValues,
		.set = py_winspool_AsyncEnumPrinterDataEx_out_set_pcbEnumValues,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pnEnumValues"),
		.get = py_winspool_AsyncEnumPrinterDataEx_out_get_pnEnumValues,
		.set = py_winspool_AsyncEnumPrinterDataEx_out_set_pnEnumValues,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncEnumPrinterDataEx_get_result,
		.set = py_winspool_AsyncEnumPrinterDataEx_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncEnumPrinterDataEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncEnumPrinterDataEx, type);
	struct winspool_AsyncEnumPrinterDataEx *_self = (struct winspool_AsyncEnumPrinterDataEx *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pEnumValues = talloc_zero(mem_ctx, uint8_t);
	_self->out.pcbEnumValues = talloc_zero(mem_ctx, uint32_t);
	_self->out.pnEnumValues = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(28);
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterDataEx_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[28];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumPrinterDataEx_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumPrinterDataEx_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterDataEx_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[28];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumPrinterDataEx_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumPrinterDataEx_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterDataEx *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterDataEx_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[28];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumPrinterDataEx_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumPrinterDataEx_in", NDR_IN);
}

static PyObject *py_winspool_AsyncEnumPrinterDataEx_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumPrinterDataEx_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumPrinterDataEx_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncEnumPrinterDataEx_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncEnumPrinterDataEx_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncEnumPrinterDataEx.opnum() -> 28 (0x1c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDataEx_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDataEx_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDataEx_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDataEx_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDataEx_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDataEx_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncEnumPrinterDataEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncEnumPrinterDataEx",
	.tp_getset = py_winspool_AsyncEnumPrinterDataEx_getsetters,
	.tp_methods = py_winspool_AsyncEnumPrinterDataEx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncEnumPrinterDataEx_new,
};

static bool pack_py_winspool_AsyncEnumPrinterDataEx_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncEnumPrinterDataEx *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pKeyName;
	PyObject *py_cbEnumValues;
	const char *kwnames[] = {
		"hPrinter", "pKeyName", "cbEnumValues", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winspool_AsyncEnumPrinterDataEx", discard_const_p(char *, kwnames), &py_hPrinter, &py_pKeyName, &py_cbEnumValues)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pKeyName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pKeyName");
		return false;
	}
	r->in.pKeyName = talloc_ptrtype(r, r->in.pKeyName);
	if (r->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pKeyName)) {
			unicode = PyUnicode_AsEncodedString(py_pKeyName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pKeyName)) {
			test_str = PyBytes_AS_STRING(py_pKeyName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pKeyName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pKeyName = talloc_str;
	}
	if (py_cbEnumValues == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.cbEnumValues");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.cbEnumValues));
		if (PyLong_Check(py_cbEnumValues)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_cbEnumValues);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.cbEnumValues = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncEnumPrinterDataEx_args_out(struct winspool_AsyncEnumPrinterDataEx *r, bool raise_result_exception)
{
	PyObject *py_pEnumValues = NULL;
	PyObject *py_pcbEnumValues = NULL;
	PyObject *py_pnEnumValues = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pEnumValues = PyList_New(r->in.cbEnumValues);
	if (py_pEnumValues == NULL) {
		return NULL;
	}
	{
		int pEnumValues_cntr_1;
		for (pEnumValues_cntr_1 = 0; pEnumValues_cntr_1 < (r->in.cbEnumValues); pEnumValues_cntr_1++) {
			PyObject *py_pEnumValues_1;
			py_pEnumValues_1 = PyLong_FromLong((uint16_t)((r->out.pEnumValues)[pEnumValues_cntr_1]));
			PyList_SetItem(py_pEnumValues, pEnumValues_cntr_1, py_pEnumValues_1);
		}
	}
	PyTuple_SetItem(result, 0, py_pEnumValues);

	py_pcbEnumValues = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbEnumValues));
	PyTuple_SetItem(result, 1, py_pcbEnumValues);

	py_pnEnumValues = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pnEnumValues));
	PyTuple_SetItem(result, 2, py_pnEnumValues);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncEnumPrinterKey_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncEnumPrinterKey_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterKey_in_get_pKeyName(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(obj);
	PyObject *py_pKeyName;
	if (object->in.pKeyName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pKeyName == NULL) {
		py_pKeyName = Py_None;
		Py_INCREF(py_pKeyName);
	} else {
		py_pKeyName = PyUnicode_Decode(object->in.pKeyName, strlen(object->in.pKeyName), "utf-8", "ignore");
	}
	return py_pKeyName;
}

static int py_winspool_AsyncEnumPrinterKey_in_set_pKeyName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pKeyName");
		return -1;
	}
	object->in.pKeyName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pKeyName);
	if (object->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pKeyName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterKey_out_get_pSubkey(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(obj);
	PyObject *py_pSubkey;
	if (object->out.pSubkey == NULL) {
		Py_RETURN_NONE;
	}
	py_pSubkey = PyList_New(object->in.cbSubkey / 2);
	if (py_pSubkey == NULL) {
		return NULL;
	}
	{
		int pSubkey_cntr_1;
		for (pSubkey_cntr_1 = 0; pSubkey_cntr_1 < (object->in.cbSubkey / 2); pSubkey_cntr_1++) {
			PyObject *py_pSubkey_1;
			py_pSubkey_1 = PyLong_FromLong((uint16_t)((object->out.pSubkey)[pSubkey_cntr_1]));
			PyList_SetItem(py_pSubkey, pSubkey_cntr_1, py_pSubkey_1);
		}
	}
	return py_pSubkey;
}

static int py_winspool_AsyncEnumPrinterKey_out_set_pSubkey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pSubkey));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pSubkey");
		return -1;
	}
	object->out.pSubkey = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pSubkey);
	if (object->out.pSubkey == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pSubkey_cntr_1;
		object->out.pSubkey = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pSubkey, PyList_GET_SIZE(value));
		if (!object->out.pSubkey) { return -1; }
		talloc_set_name_const(object->out.pSubkey, "ARRAY: object->out.pSubkey");
		for (pSubkey_cntr_1 = 0; pSubkey_cntr_1 < PyList_GET_SIZE(value); pSubkey_cntr_1++) {
			if (PyList_GET_ITEM(value, pSubkey_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pSubkey)[pSubkey_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pSubkey)[pSubkey_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pSubkey_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pSubkey_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.pSubkey)[pSubkey_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterKey_in_get_cbSubkey(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(obj);
	PyObject *py_cbSubkey;
	py_cbSubkey = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbSubkey));
	return py_cbSubkey;
}

static int py_winspool_AsyncEnumPrinterKey_in_set_cbSubkey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbSubkey");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbSubkey));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbSubkey = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterKey_out_get_pcbSubkey(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbSubkey;
	if (object->out.pcbSubkey == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbSubkey = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbSubkey));
	return py_pcbSubkey;
}

static int py_winspool_AsyncEnumPrinterKey_out_set_pcbSubkey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbSubkey));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbSubkey");
		return -1;
	}
	object->out.pcbSubkey = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbSubkey);
	if (object->out.pcbSubkey == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbSubkey));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbSubkey = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterKey_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncEnumPrinterKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncEnumPrinterKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncEnumPrinterKey_in_get_hPrinter,
		.set = py_winspool_AsyncEnumPrinterKey_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pKeyName"),
		.get = py_winspool_AsyncEnumPrinterKey_in_get_pKeyName,
		.set = py_winspool_AsyncEnumPrinterKey_in_set_pKeyName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "out_pSubkey"),
		.get = py_winspool_AsyncEnumPrinterKey_out_get_pSubkey,
		.set = py_winspool_AsyncEnumPrinterKey_out_set_pSubkey,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_cbSubkey"),
		.get = py_winspool_AsyncEnumPrinterKey_in_get_cbSubkey,
		.set = py_winspool_AsyncEnumPrinterKey_in_set_cbSubkey,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbSubkey"),
		.get = py_winspool_AsyncEnumPrinterKey_out_get_pcbSubkey,
		.set = py_winspool_AsyncEnumPrinterKey_out_set_pcbSubkey,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncEnumPrinterKey_get_result,
		.set = py_winspool_AsyncEnumPrinterKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncEnumPrinterKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncEnumPrinterKey, type);
	struct winspool_AsyncEnumPrinterKey *_self = (struct winspool_AsyncEnumPrinterKey *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pSubkey = talloc_zero(mem_ctx, uint16_t);
	_self->out.pcbSubkey = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncEnumPrinterKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(29);
}

static PyObject *py_winspool_AsyncEnumPrinterKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[29];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncEnumPrinterKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumPrinterKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumPrinterKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumPrinterKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumPrinterKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[29];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncEnumPrinterKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumPrinterKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumPrinterKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumPrinterKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumPrinterKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 30) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[29];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncEnumPrinterKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumPrinterKey_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumPrinterKey_in", NDR_IN);
}

static PyObject *py_winspool_AsyncEnumPrinterKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumPrinterKey_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumPrinterKey_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncEnumPrinterKey_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncEnumPrinterKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncEnumPrinterKey.opnum() -> 29 (0x1d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncEnumPrinterKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncEnumPrinterKey",
	.tp_getset = py_winspool_AsyncEnumPrinterKey_getsetters,
	.tp_methods = py_winspool_AsyncEnumPrinterKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncEnumPrinterKey_new,
};

static bool pack_py_winspool_AsyncEnumPrinterKey_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncEnumPrinterKey *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pKeyName;
	PyObject *py_cbSubkey;
	const char *kwnames[] = {
		"hPrinter", "pKeyName", "cbSubkey", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winspool_AsyncEnumPrinterKey", discard_const_p(char *, kwnames), &py_hPrinter, &py_pKeyName, &py_cbSubkey)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pKeyName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pKeyName");
		return false;
	}
	r->in.pKeyName = talloc_ptrtype(r, r->in.pKeyName);
	if (r->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pKeyName)) {
			unicode = PyUnicode_AsEncodedString(py_pKeyName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pKeyName)) {
			test_str = PyBytes_AS_STRING(py_pKeyName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pKeyName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pKeyName = talloc_str;
	}
	if (py_cbSubkey == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.cbSubkey");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.cbSubkey));
		if (PyLong_Check(py_cbSubkey)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_cbSubkey);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.cbSubkey = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncEnumPrinterKey_args_out(struct winspool_AsyncEnumPrinterKey *r, bool raise_result_exception)
{
	PyObject *py_pSubkey = NULL;
	PyObject *py_pcbSubkey = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pSubkey = PyList_New(r->in.cbSubkey / 2);
	if (py_pSubkey == NULL) {
		return NULL;
	}
	{
		int pSubkey_cntr_1;
		for (pSubkey_cntr_1 = 0; pSubkey_cntr_1 < (r->in.cbSubkey / 2); pSubkey_cntr_1++) {
			PyObject *py_pSubkey_1;
			py_pSubkey_1 = PyLong_FromLong((uint16_t)((r->out.pSubkey)[pSubkey_cntr_1]));
			PyList_SetItem(py_pSubkey, pSubkey_cntr_1, py_pSubkey_1);
		}
	}
	PyTuple_SetItem(result, 0, py_pSubkey);

	py_pcbSubkey = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbSubkey));
	PyTuple_SetItem(result, 1, py_pcbSubkey);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncDeletePrinterData_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncDeletePrinterData_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncDeletePrinterData_in_get_pValueName(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_pValueName;
	if (object->in.pValueName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pValueName == NULL) {
		py_pValueName = Py_None;
		Py_INCREF(py_pValueName);
	} else {
		py_pValueName = PyUnicode_Decode(object->in.pValueName, strlen(object->in.pValueName), "utf-8", "ignore");
	}
	return py_pValueName;
}

static int py_winspool_AsyncDeletePrinterData_in_set_pValueName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pValueName");
		return -1;
	}
	object->in.pValueName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pValueName);
	if (object->in.pValueName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pValueName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncDeletePrinterData_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterData *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncDeletePrinterData_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncDeletePrinterData_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncDeletePrinterData_in_get_hPrinter,
		.set = py_winspool_AsyncDeletePrinterData_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pValueName"),
		.get = py_winspool_AsyncDeletePrinterData_in_get_pValueName,
		.set = py_winspool_AsyncDeletePrinterData_in_set_pValueName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncDeletePrinterData_get_result,
		.set = py_winspool_AsyncDeletePrinterData_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncDeletePrinterData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncDeletePrinterData, type);
	return self;
}

static PyObject *py_winspool_AsyncDeletePrinterData_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(30);
}

static PyObject *py_winspool_AsyncDeletePrinterData_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterData_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[30];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncDeletePrinterData_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeletePrinterData_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeletePrinterData_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeletePrinterData_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeletePrinterData_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterData *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterData_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[30];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncDeletePrinterData_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeletePrinterData_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeletePrinterData_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeletePrinterData_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeletePrinterData_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterData *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 31) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterData_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[30];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncDeletePrinterData_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeletePrinterData_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeletePrinterData_in", NDR_IN);
}

static PyObject *py_winspool_AsyncDeletePrinterData_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeletePrinterData_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeletePrinterData_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncDeletePrinterData_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncDeletePrinterData_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncDeletePrinterData.opnum() -> 30 (0x1e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterData_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterData_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterData_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterData_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterData_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterData_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncDeletePrinterData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncDeletePrinterData",
	.tp_getset = py_winspool_AsyncDeletePrinterData_getsetters,
	.tp_methods = py_winspool_AsyncDeletePrinterData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncDeletePrinterData_new,
};

static bool pack_py_winspool_AsyncDeletePrinterData_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncDeletePrinterData *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pValueName;
	const char *kwnames[] = {
		"hPrinter", "pValueName", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winspool_AsyncDeletePrinterData", discard_const_p(char *, kwnames), &py_hPrinter, &py_pValueName)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pValueName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pValueName");
		return false;
	}
	r->in.pValueName = talloc_ptrtype(r, r->in.pValueName);
	if (r->in.pValueName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pValueName)) {
			unicode = PyUnicode_AsEncodedString(py_pValueName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pValueName)) {
			test_str = PyBytes_AS_STRING(py_pValueName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pValueName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pValueName = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncDeletePrinterData_args_out(struct winspool_AsyncDeletePrinterData *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncDeletePrinterDataEx_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncDeletePrinterDataEx_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_in_get_pKeyName(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pKeyName;
	if (object->in.pKeyName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pKeyName == NULL) {
		py_pKeyName = Py_None;
		Py_INCREF(py_pKeyName);
	} else {
		py_pKeyName = PyUnicode_Decode(object->in.pKeyName, strlen(object->in.pKeyName), "utf-8", "ignore");
	}
	return py_pKeyName;
}

static int py_winspool_AsyncDeletePrinterDataEx_in_set_pKeyName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pKeyName");
		return -1;
	}
	object->in.pKeyName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pKeyName);
	if (object->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pKeyName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_in_get_pValueName(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_pValueName;
	if (object->in.pValueName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pValueName == NULL) {
		py_pValueName = Py_None;
		Py_INCREF(py_pValueName);
	} else {
		py_pValueName = PyUnicode_Decode(object->in.pValueName, strlen(object->in.pValueName), "utf-8", "ignore");
	}
	return py_pValueName;
}

static int py_winspool_AsyncDeletePrinterDataEx_in_set_pValueName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pValueName");
		return -1;
	}
	object->in.pValueName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pValueName);
	if (object->in.pValueName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pValueName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterDataEx *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncDeletePrinterDataEx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterDataEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncDeletePrinterDataEx_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncDeletePrinterDataEx_in_get_hPrinter,
		.set = py_winspool_AsyncDeletePrinterDataEx_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pKeyName"),
		.get = py_winspool_AsyncDeletePrinterDataEx_in_get_pKeyName,
		.set = py_winspool_AsyncDeletePrinterDataEx_in_set_pKeyName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pValueName"),
		.get = py_winspool_AsyncDeletePrinterDataEx_in_get_pValueName,
		.set = py_winspool_AsyncDeletePrinterDataEx_in_set_pValueName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncDeletePrinterDataEx_get_result,
		.set = py_winspool_AsyncDeletePrinterDataEx_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncDeletePrinterDataEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncDeletePrinterDataEx, type);
	return self;
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(31);
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterDataEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterDataEx_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[31];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeletePrinterDataEx_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeletePrinterDataEx_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterDataEx *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterDataEx_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[31];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeletePrinterDataEx_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeletePrinterDataEx_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterDataEx *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 32) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterDataEx_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[31];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeletePrinterDataEx_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeletePrinterDataEx_in", NDR_IN);
}

static PyObject *py_winspool_AsyncDeletePrinterDataEx_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeletePrinterDataEx_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeletePrinterDataEx_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncDeletePrinterDataEx_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncDeletePrinterDataEx_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncDeletePrinterDataEx.opnum() -> 31 (0x1f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterDataEx_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterDataEx_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterDataEx_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterDataEx_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterDataEx_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterDataEx_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncDeletePrinterDataEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncDeletePrinterDataEx",
	.tp_getset = py_winspool_AsyncDeletePrinterDataEx_getsetters,
	.tp_methods = py_winspool_AsyncDeletePrinterDataEx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncDeletePrinterDataEx_new,
};

static bool pack_py_winspool_AsyncDeletePrinterDataEx_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncDeletePrinterDataEx *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pKeyName;
	PyObject *py_pValueName;
	const char *kwnames[] = {
		"hPrinter", "pKeyName", "pValueName", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winspool_AsyncDeletePrinterDataEx", discard_const_p(char *, kwnames), &py_hPrinter, &py_pKeyName, &py_pValueName)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pKeyName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pKeyName");
		return false;
	}
	r->in.pKeyName = talloc_ptrtype(r, r->in.pKeyName);
	if (r->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pKeyName)) {
			unicode = PyUnicode_AsEncodedString(py_pKeyName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pKeyName)) {
			test_str = PyBytes_AS_STRING(py_pKeyName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pKeyName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pKeyName = talloc_str;
	}
	if (py_pValueName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pValueName");
		return false;
	}
	r->in.pValueName = talloc_ptrtype(r, r->in.pValueName);
	if (r->in.pValueName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pValueName)) {
			unicode = PyUnicode_AsEncodedString(py_pValueName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pValueName)) {
			test_str = PyBytes_AS_STRING(py_pValueName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pValueName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pValueName = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncDeletePrinterDataEx_args_out(struct winspool_AsyncDeletePrinterDataEx *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncDeletePrinterKey_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterKey *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncDeletePrinterKey_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncDeletePrinterKey_in_get_pKeyName(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterKey *object = pytalloc_get_ptr(obj);
	PyObject *py_pKeyName;
	if (object->in.pKeyName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pKeyName == NULL) {
		py_pKeyName = Py_None;
		Py_INCREF(py_pKeyName);
	} else {
		py_pKeyName = PyUnicode_Decode(object->in.pKeyName, strlen(object->in.pKeyName), "utf-8", "ignore");
	}
	return py_pKeyName;
}

static int py_winspool_AsyncDeletePrinterKey_in_set_pKeyName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pKeyName");
		return -1;
	}
	object->in.pKeyName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pKeyName);
	if (object->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pKeyName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncDeletePrinterKey_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterKey *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncDeletePrinterKey_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterKey *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncDeletePrinterKey_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncDeletePrinterKey_in_get_hPrinter,
		.set = py_winspool_AsyncDeletePrinterKey_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pKeyName"),
		.get = py_winspool_AsyncDeletePrinterKey_in_get_pKeyName,
		.set = py_winspool_AsyncDeletePrinterKey_in_set_pKeyName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncDeletePrinterKey_get_result,
		.set = py_winspool_AsyncDeletePrinterKey_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncDeletePrinterKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncDeletePrinterKey, type);
	return self;
}

static PyObject *py_winspool_AsyncDeletePrinterKey_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(32);
}

static PyObject *py_winspool_AsyncDeletePrinterKey_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterKey *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterKey_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[32];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncDeletePrinterKey_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeletePrinterKey_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeletePrinterKey_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeletePrinterKey_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeletePrinterKey_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterKey *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterKey_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[32];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncDeletePrinterKey_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeletePrinterKey_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeletePrinterKey_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeletePrinterKey_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeletePrinterKey_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterKey *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 33) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterKey_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[32];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncDeletePrinterKey_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeletePrinterKey_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeletePrinterKey_in", NDR_IN);
}

static PyObject *py_winspool_AsyncDeletePrinterKey_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeletePrinterKey_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeletePrinterKey_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncDeletePrinterKey_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncDeletePrinterKey_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncDeletePrinterKey.opnum() -> 32 (0x20) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterKey_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterKey_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterKey_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterKey_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterKey_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterKey_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncDeletePrinterKey_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncDeletePrinterKey",
	.tp_getset = py_winspool_AsyncDeletePrinterKey_getsetters,
	.tp_methods = py_winspool_AsyncDeletePrinterKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncDeletePrinterKey_new,
};

static bool pack_py_winspool_AsyncDeletePrinterKey_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncDeletePrinterKey *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pKeyName;
	const char *kwnames[] = {
		"hPrinter", "pKeyName", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winspool_AsyncDeletePrinterKey", discard_const_p(char *, kwnames), &py_hPrinter, &py_pKeyName)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pKeyName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pKeyName");
		return false;
	}
	r->in.pKeyName = talloc_ptrtype(r, r->in.pKeyName);
	if (r->in.pKeyName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pKeyName)) {
			unicode = PyUnicode_AsEncodedString(py_pKeyName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pKeyName)) {
			test_str = PyBytes_AS_STRING(py_pKeyName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pKeyName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pKeyName = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncDeletePrinterKey_args_out(struct winspool_AsyncDeletePrinterKey *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncXcvData_in_get_hXcv(PyObject *obj, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(obj);
	PyObject *py_hXcv;
	py_hXcv = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hXcv);
	return py_hXcv;
}

static int py_winspool_AsyncXcvData_in_set_hXcv(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hXcv");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hXcv = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncXcvData_in_get_pszDataName(PyObject *obj, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(obj);
	PyObject *py_pszDataName;
	if (object->in.pszDataName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pszDataName == NULL) {
		py_pszDataName = Py_None;
		Py_INCREF(py_pszDataName);
	} else {
		py_pszDataName = PyUnicode_Decode(object->in.pszDataName, strlen(object->in.pszDataName), "utf-8", "ignore");
	}
	return py_pszDataName;
}

static int py_winspool_AsyncXcvData_in_set_pszDataName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pszDataName");
		return -1;
	}
	object->in.pszDataName = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pszDataName);
	if (object->in.pszDataName == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.pszDataName = talloc_str;
	}
	return 0;
}

static PyObject *py_winspool_AsyncXcvData_in_get_pInputData(PyObject *obj, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(obj);
	PyObject *py_pInputData;
	if (object->in.pInputData == NULL) {
		Py_RETURN_NONE;
	}
	py_pInputData = PyList_New(object->in.cbInputData);
	if (py_pInputData == NULL) {
		return NULL;
	}
	{
		int pInputData_cntr_1;
		for (pInputData_cntr_1 = 0; pInputData_cntr_1 < (object->in.cbInputData); pInputData_cntr_1++) {
			PyObject *py_pInputData_1;
			py_pInputData_1 = PyLong_FromLong((uint16_t)((object->in.pInputData)[pInputData_cntr_1]));
			PyList_SetItem(py_pInputData, pInputData_cntr_1, py_pInputData_1);
		}
	}
	return py_pInputData;
}

static int py_winspool_AsyncXcvData_in_set_pInputData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pInputData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pInputData");
		return -1;
	}
	object->in.pInputData = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pInputData);
	if (object->in.pInputData == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pInputData_cntr_1;
		object->in.pInputData = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pInputData, PyList_GET_SIZE(value));
		if (!object->in.pInputData) { return -1; }
		talloc_set_name_const(object->in.pInputData, "ARRAY: object->in.pInputData");
		for (pInputData_cntr_1 = 0; pInputData_cntr_1 < PyList_GET_SIZE(value); pInputData_cntr_1++) {
			if (PyList_GET_ITEM(value, pInputData_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pInputData)[pInputData_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pInputData)[pInputData_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pInputData_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pInputData_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.pInputData)[pInputData_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncXcvData_in_get_cbInputData(PyObject *obj, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(obj);
	PyObject *py_cbInputData;
	py_cbInputData = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbInputData));
	return py_cbInputData;
}

static int py_winspool_AsyncXcvData_in_set_cbInputData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbInputData");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbInputData));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbInputData = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncXcvData_out_get_pOutputData(PyObject *obj, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(obj);
	PyObject *py_pOutputData;
	if (object->out.pOutputData == NULL) {
		Py_RETURN_NONE;
	}
	py_pOutputData = PyList_New(object->in.cbOutputData);
	if (py_pOutputData == NULL) {
		return NULL;
	}
	{
		int pOutputData_cntr_1;
		for (pOutputData_cntr_1 = 0; pOutputData_cntr_1 < (object->in.cbOutputData); pOutputData_cntr_1++) {
			PyObject *py_pOutputData_1;
			py_pOutputData_1 = PyLong_FromLong((uint16_t)((object->out.pOutputData)[pOutputData_cntr_1]));
			PyList_SetItem(py_pOutputData, pOutputData_cntr_1, py_pOutputData_1);
		}
	}
	return py_pOutputData;
}

static int py_winspool_AsyncXcvData_out_set_pOutputData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pOutputData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pOutputData");
		return -1;
	}
	object->out.pOutputData = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pOutputData);
	if (object->out.pOutputData == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pOutputData_cntr_1;
		object->out.pOutputData = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pOutputData, PyList_GET_SIZE(value));
		if (!object->out.pOutputData) { return -1; }
		talloc_set_name_const(object->out.pOutputData, "ARRAY: object->out.pOutputData");
		for (pOutputData_cntr_1 = 0; pOutputData_cntr_1 < PyList_GET_SIZE(value); pOutputData_cntr_1++) {
			if (PyList_GET_ITEM(value, pOutputData_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pOutputData)[pOutputData_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pOutputData)[pOutputData_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pOutputData_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pOutputData_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.pOutputData)[pOutputData_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncXcvData_in_get_cbOutputData(PyObject *obj, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(obj);
	PyObject *py_cbOutputData;
	py_cbOutputData = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbOutputData));
	return py_cbOutputData;
}

static int py_winspool_AsyncXcvData_in_set_cbOutputData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbOutputData");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbOutputData));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbOutputData = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncXcvData_out_get_pcbOutputNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbOutputNeeded;
	if (object->out.pcbOutputNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbOutputNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbOutputNeeded));
	return py_pcbOutputNeeded;
}

static int py_winspool_AsyncXcvData_out_set_pcbOutputNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbOutputNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbOutputNeeded");
		return -1;
	}
	object->out.pcbOutputNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbOutputNeeded);
	if (object->out.pcbOutputNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbOutputNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbOutputNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncXcvData_in_get_pdwStatus(PyObject *obj, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(obj);
	PyObject *py_pdwStatus;
	if (object->in.pdwStatus == NULL) {
		Py_RETURN_NONE;
	}
	py_pdwStatus = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.pdwStatus));
	return py_pdwStatus;
}

static int py_winspool_AsyncXcvData_in_set_pdwStatus(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pdwStatus));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pdwStatus");
		return -1;
	}
	object->in.pdwStatus = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pdwStatus);
	if (object->in.pdwStatus == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.pdwStatus));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.pdwStatus = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncXcvData_out_get_pdwStatus(PyObject *obj, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(obj);
	PyObject *py_pdwStatus;
	if (object->out.pdwStatus == NULL) {
		Py_RETURN_NONE;
	}
	py_pdwStatus = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pdwStatus));
	return py_pdwStatus;
}

static int py_winspool_AsyncXcvData_out_set_pdwStatus(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pdwStatus));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pdwStatus");
		return -1;
	}
	object->out.pdwStatus = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pdwStatus);
	if (object->out.pdwStatus == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pdwStatus));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pdwStatus = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncXcvData_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncXcvData_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncXcvData_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hXcv"),
		.get = py_winspool_AsyncXcvData_in_get_hXcv,
		.set = py_winspool_AsyncXcvData_in_set_hXcv,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pszDataName"),
		.get = py_winspool_AsyncXcvData_in_get_pszDataName,
		.set = py_winspool_AsyncXcvData_in_set_pszDataName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pInputData"),
		.get = py_winspool_AsyncXcvData_in_get_pInputData,
		.set = py_winspool_AsyncXcvData_in_set_pInputData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbInputData"),
		.get = py_winspool_AsyncXcvData_in_get_cbInputData,
		.set = py_winspool_AsyncXcvData_in_set_cbInputData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pOutputData"),
		.get = py_winspool_AsyncXcvData_out_get_pOutputData,
		.set = py_winspool_AsyncXcvData_out_set_pOutputData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbOutputData"),
		.get = py_winspool_AsyncXcvData_in_get_cbOutputData,
		.set = py_winspool_AsyncXcvData_in_set_cbOutputData,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbOutputNeeded"),
		.get = py_winspool_AsyncXcvData_out_get_pcbOutputNeeded,
		.set = py_winspool_AsyncXcvData_out_set_pcbOutputNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pdwStatus"),
		.get = py_winspool_AsyncXcvData_in_get_pdwStatus,
		.set = py_winspool_AsyncXcvData_in_set_pdwStatus,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pdwStatus"),
		.get = py_winspool_AsyncXcvData_out_get_pdwStatus,
		.set = py_winspool_AsyncXcvData_out_set_pdwStatus,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncXcvData_get_result,
		.set = py_winspool_AsyncXcvData_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncXcvData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncXcvData, type);
	struct winspool_AsyncXcvData *_self = (struct winspool_AsyncXcvData *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pInputData = talloc_zero(mem_ctx, uint8_t);
	_self->out.pOutputData = talloc_zero(mem_ctx, uint8_t);
	_self->out.pcbOutputNeeded = talloc_zero(mem_ctx, uint32_t);
	_self->in.pdwStatus = talloc_zero(mem_ctx, uint32_t);
	_self->out.pdwStatus = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncXcvData_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(33);
}

static PyObject *py_winspool_AsyncXcvData_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncXcvData_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[33];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncXcvData_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncXcvData_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncXcvData_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncXcvData_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncXcvData_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncXcvData_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[33];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncXcvData_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncXcvData_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncXcvData_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncXcvData_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncXcvData_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncXcvData *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 34) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncXcvData_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[33];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncXcvData_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncXcvData_ndr_print(py_obj, args, kwargs, "winspool_AsyncXcvData_in", NDR_IN);
}

static PyObject *py_winspool_AsyncXcvData_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncXcvData_ndr_print(py_obj, args, kwargs, "winspool_AsyncXcvData_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncXcvData_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncXcvData_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncXcvData.opnum() -> 33 (0x21) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncXcvData_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncXcvData_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncXcvData_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncXcvData_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncXcvData_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncXcvData_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncXcvData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncXcvData",
	.tp_getset = py_winspool_AsyncXcvData_getsetters,
	.tp_methods = py_winspool_AsyncXcvData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncXcvData_new,
};

static bool pack_py_winspool_AsyncXcvData_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncXcvData *r)
{
	PyObject *py_hXcv;
	PyObject *py_pszDataName;
	PyObject *py_pInputData;
	PyObject *py_cbOutputData;
	PyObject *py_pdwStatus;
	const char *kwnames[] = {
		"hXcv", "pszDataName", "pInputData", "cbOutputData", "pdwStatus", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:winspool_AsyncXcvData", discard_const_p(char *, kwnames), &py_hXcv, &py_pszDataName, &py_pInputData, &py_cbOutputData, &py_pdwStatus)) {
		return false;
	}

	if (py_hXcv == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hXcv");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hXcv, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hXcv)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hXcv = *(struct policy_handle *)pytalloc_get_ptr(py_hXcv);
	if (py_pszDataName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pszDataName");
		return false;
	}
	r->in.pszDataName = talloc_ptrtype(r, r->in.pszDataName);
	if (r->in.pszDataName == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_pszDataName)) {
			unicode = PyUnicode_AsEncodedString(py_pszDataName, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_pszDataName)) {
			test_str = PyBytes_AS_STRING(py_pszDataName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszDataName)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pszDataName = talloc_str;
	}
	if (py_pInputData == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pInputData");
		return false;
	}
	r->in.pInputData = talloc_ptrtype(r, r->in.pInputData);
	if (r->in.pInputData == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_pInputData, return false;);
	{
		int pInputData_cntr_1;
		r->in.pInputData = talloc_array_ptrtype(r, r->in.pInputData, PyList_GET_SIZE(py_pInputData));
		if (!r->in.pInputData) { return false; }
		talloc_set_name_const(r->in.pInputData, "ARRAY: r->in.pInputData");
		for (pInputData_cntr_1 = 0; pInputData_cntr_1 < PyList_GET_SIZE(py_pInputData); pInputData_cntr_1++) {
			if (PyList_GET_ITEM(py_pInputData, pInputData_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pInputData)[pInputData_cntr_1]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pInputData)[pInputData_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(py_pInputData, pInputData_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pInputData, pInputData_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.pInputData)[pInputData_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pInputData, return false;);
	r->in.cbInputData = PyList_GET_SIZE(py_pInputData);
	if (py_cbOutputData == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.cbOutputData");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.cbOutputData));
		if (PyLong_Check(py_cbOutputData)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_cbOutputData);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.cbOutputData = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pdwStatus == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pdwStatus");
		return false;
	}
	r->in.pdwStatus = talloc_ptrtype(r, r->in.pdwStatus);
	if (r->in.pdwStatus == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.pdwStatus));
		if (PyLong_Check(py_pdwStatus)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_pdwStatus);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.pdwStatus = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncXcvData_args_out(struct winspool_AsyncXcvData *r, bool raise_result_exception)
{
	PyObject *py_pOutputData = NULL;
	PyObject *py_pcbOutputNeeded = NULL;
	PyObject *py_pdwStatus = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pOutputData = PyList_New(r->in.cbOutputData);
	if (py_pOutputData == NULL) {
		return NULL;
	}
	{
		int pOutputData_cntr_1;
		for (pOutputData_cntr_1 = 0; pOutputData_cntr_1 < (r->in.cbOutputData); pOutputData_cntr_1++) {
			PyObject *py_pOutputData_1;
			py_pOutputData_1 = PyLong_FromLong((uint16_t)((r->out.pOutputData)[pOutputData_cntr_1]));
			PyList_SetItem(py_pOutputData, pOutputData_cntr_1, py_pOutputData_1);
		}
	}
	PyTuple_SetItem(result, 0, py_pOutputData);

	py_pcbOutputNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbOutputNeeded));
	PyTuple_SetItem(result, 1, py_pcbOutputNeeded);

	py_pdwStatus = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pdwStatus));
	PyTuple_SetItem(result, 2, py_pdwStatus);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncSendRecvBidiData_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncSendRecvBidiData_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncSendRecvBidiData_in_get_pAction(PyObject *obj, void *closure)
{
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(obj);
	PyObject *py_pAction;
	if (object->in.pAction == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pAction == NULL) {
		py_pAction = Py_None;
		Py_INCREF(py_pAction);
	} else {
		if (object->in.pAction == NULL) {
			py_pAction = Py_None;
			Py_INCREF(py_pAction);
		} else {
			py_pAction = PyUnicode_Decode(object->in.pAction, strlen(object->in.pAction), "utf-8", "ignore");
		}
	}
	return py_pAction;
}

static int py_winspool_AsyncSendRecvBidiData_in_set_pAction(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pAction");
		return -1;
	}
	if (value == Py_None) {
		object->in.pAction = NULL;
	} else {
		object->in.pAction = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pAction = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncSendRecvBidiData_in_get_pReqData(PyObject *obj, void *closure)
{
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(obj);
	PyObject *py_pReqData;
	if (object->in.pReqData == NULL) {
		Py_RETURN_NONE;
	}
	py_pReqData = pytalloc_reference_ex(RPC_BIDI_REQUEST_CONTAINER_Type, object->in.pReqData, object->in.pReqData);
	return py_pReqData;
}

static int py_winspool_AsyncSendRecvBidiData_in_set_pReqData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pReqData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pReqData");
		return -1;
	}
	object->in.pReqData = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pReqData);
	if (object->in.pReqData == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(RPC_BIDI_REQUEST_CONTAINER_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pReqData = (struct RPC_BIDI_REQUEST_CONTAINER *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncSendRecvBidiData_out_get_ppRespData(PyObject *obj, void *closure)
{
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(obj);
	PyObject *py_ppRespData;
	if (object->out.ppRespData == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.ppRespData == NULL) {
		py_ppRespData = Py_None;
		Py_INCREF(py_ppRespData);
	} else {
		py_ppRespData = pytalloc_reference_ex(RPC_BIDI_RESPONSE_CONTAINER_Type, *object->out.ppRespData, *object->out.ppRespData);
	}
	return py_ppRespData;
}

static int py_winspool_AsyncSendRecvBidiData_out_set_ppRespData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.ppRespData));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.ppRespData");
		return -1;
	}
	object->out.ppRespData = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.ppRespData);
	if (object->out.ppRespData == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.ppRespData = NULL;
	} else {
		*object->out.ppRespData = NULL;
		PY_CHECK_TYPE(RPC_BIDI_RESPONSE_CONTAINER_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.ppRespData = (struct RPC_BIDI_RESPONSE_CONTAINER *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_winspool_AsyncSendRecvBidiData_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncSendRecvBidiData_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncSendRecvBidiData_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncSendRecvBidiData_in_get_hPrinter,
		.set = py_winspool_AsyncSendRecvBidiData_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pAction"),
		.get = py_winspool_AsyncSendRecvBidiData_in_get_pAction,
		.set = py_winspool_AsyncSendRecvBidiData_in_set_pAction,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pReqData"),
		.get = py_winspool_AsyncSendRecvBidiData_in_get_pReqData,
		.set = py_winspool_AsyncSendRecvBidiData_in_set_pReqData,
		.doc = discard_const_p(char, "PIDL-generated element of base type RPC_BIDI_REQUEST_CONTAINER")
	},
	{
		.name = discard_const_p(char, "out_ppRespData"),
		.get = py_winspool_AsyncSendRecvBidiData_out_get_ppRespData,
		.set = py_winspool_AsyncSendRecvBidiData_out_set_ppRespData,
		.doc = discard_const_p(char, "PIDL-generated element of base type RPC_BIDI_RESPONSE_CONTAINER")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncSendRecvBidiData_get_result,
		.set = py_winspool_AsyncSendRecvBidiData_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncSendRecvBidiData_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncSendRecvBidiData, type);
	struct winspool_AsyncSendRecvBidiData *_self = (struct winspool_AsyncSendRecvBidiData *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pReqData = talloc_zero(mem_ctx, struct RPC_BIDI_REQUEST_CONTAINER);
	/* a pointer to a NULL pointer */
	_self->out.ppRespData = talloc_zero(mem_ctx, struct RPC_BIDI_RESPONSE_CONTAINER *);
	return self;
}

static PyObject *py_winspool_AsyncSendRecvBidiData_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(34);
}

static PyObject *py_winspool_AsyncSendRecvBidiData_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSendRecvBidiData_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[34];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncSendRecvBidiData_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSendRecvBidiData_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSendRecvBidiData_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncSendRecvBidiData_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncSendRecvBidiData_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSendRecvBidiData_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[34];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncSendRecvBidiData_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSendRecvBidiData_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSendRecvBidiData_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncSendRecvBidiData_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncSendRecvBidiData_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncSendRecvBidiData *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 35) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncSendRecvBidiData_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[34];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncSendRecvBidiData_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSendRecvBidiData_ndr_print(py_obj, args, kwargs, "winspool_AsyncSendRecvBidiData_in", NDR_IN);
}

static PyObject *py_winspool_AsyncSendRecvBidiData_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncSendRecvBidiData_ndr_print(py_obj, args, kwargs, "winspool_AsyncSendRecvBidiData_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncSendRecvBidiData_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncSendRecvBidiData_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncSendRecvBidiData.opnum() -> 34 (0x22) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSendRecvBidiData_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSendRecvBidiData_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSendRecvBidiData_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSendRecvBidiData_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSendRecvBidiData_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncSendRecvBidiData_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncSendRecvBidiData_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncSendRecvBidiData",
	.tp_getset = py_winspool_AsyncSendRecvBidiData_getsetters,
	.tp_methods = py_winspool_AsyncSendRecvBidiData_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncSendRecvBidiData_new,
};

static bool pack_py_winspool_AsyncSendRecvBidiData_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncSendRecvBidiData *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pAction;
	PyObject *py_pReqData;
	const char *kwnames[] = {
		"hPrinter", "pAction", "pReqData", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winspool_AsyncSendRecvBidiData", discard_const_p(char *, kwnames), &py_hPrinter, &py_pAction, &py_pReqData)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pAction == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pAction");
		return false;
	}
	if (py_pAction == Py_None) {
		r->in.pAction = NULL;
	} else {
		r->in.pAction = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pAction)) {
				unicode = PyUnicode_AsEncodedString(py_pAction, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pAction)) {
				test_str = PyBytes_AS_STRING(py_pAction);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pAction)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pAction = talloc_str;
		}
	}
	if (py_pReqData == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pReqData");
		return false;
	}
	r->in.pReqData = talloc_ptrtype(r, r->in.pReqData);
	if (r->in.pReqData == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(RPC_BIDI_REQUEST_CONTAINER_Type, py_pReqData, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pReqData)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pReqData = (struct RPC_BIDI_REQUEST_CONTAINER *)pytalloc_get_ptr(py_pReqData);
	return true;
}

static PyObject *unpack_py_winspool_AsyncSendRecvBidiData_args_out(struct winspool_AsyncSendRecvBidiData *r, bool raise_result_exception)
{
	PyObject *py_ppRespData = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.ppRespData == NULL) {
		py_ppRespData = Py_None;
		Py_INCREF(py_ppRespData);
	} else {
		py_ppRespData = pytalloc_reference_ex(RPC_BIDI_RESPONSE_CONTAINER_Type, *r->out.ppRespData, *r->out.ppRespData);
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_ppRespData);
	}
	if (result_size == 1) {
		result = py_ppRespData;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncCreatePrinterIC_in_get_hPrinter(PyObject *obj, void *closure)
{
	struct winspool_AsyncCreatePrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinter;
	py_hPrinter = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinter);
	return py_hPrinter;
}

static int py_winspool_AsyncCreatePrinterIC_in_set_hPrinter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncCreatePrinterIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinter");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncCreatePrinterIC_out_get_pHandle(PyObject *obj, void *closure)
{
	struct winspool_AsyncCreatePrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_pHandle;
	if (object->out.pHandle == NULL) {
		Py_RETURN_NONE;
	}
	py_pHandle = pytalloc_reference_ex(policy_handle_Type, object->out.pHandle, object->out.pHandle);
	return py_pHandle;
}

static int py_winspool_AsyncCreatePrinterIC_out_set_pHandle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncCreatePrinterIC *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pHandle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pHandle");
		return -1;
	}
	object->out.pHandle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pHandle);
	if (object->out.pHandle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.pHandle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncCreatePrinterIC_in_get_pDevModeContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncCreatePrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_pDevModeContainer;
	if (object->in.pDevModeContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pDevModeContainer = pytalloc_reference_ex(spoolss_DevmodeContainer_Type, object->in.pDevModeContainer, object->in.pDevModeContainer);
	return py_pDevModeContainer;
}

static int py_winspool_AsyncCreatePrinterIC_in_set_pDevModeContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncCreatePrinterIC *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pDevModeContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pDevModeContainer");
		return -1;
	}
	object->in.pDevModeContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pDevModeContainer);
	if (object->in.pDevModeContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_DevmodeContainer_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pDevModeContainer = (struct spoolss_DevmodeContainer *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncCreatePrinterIC_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncCreatePrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncCreatePrinterIC_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncCreatePrinterIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncCreatePrinterIC_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinter"),
		.get = py_winspool_AsyncCreatePrinterIC_in_get_hPrinter,
		.set = py_winspool_AsyncCreatePrinterIC_in_set_hPrinter,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_pHandle"),
		.get = py_winspool_AsyncCreatePrinterIC_out_get_pHandle,
		.set = py_winspool_AsyncCreatePrinterIC_out_set_pHandle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pDevModeContainer"),
		.get = py_winspool_AsyncCreatePrinterIC_in_get_pDevModeContainer,
		.set = py_winspool_AsyncCreatePrinterIC_in_set_pDevModeContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_DevmodeContainer")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncCreatePrinterIC_get_result,
		.set = py_winspool_AsyncCreatePrinterIC_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncCreatePrinterIC_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncCreatePrinterIC, type);
	struct winspool_AsyncCreatePrinterIC *_self = (struct winspool_AsyncCreatePrinterIC *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pHandle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.pDevModeContainer = talloc_zero(mem_ctx, struct spoolss_DevmodeContainer);
	return self;
}

static PyObject *py_winspool_AsyncCreatePrinterIC_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(35);
}

static PyObject *py_winspool_AsyncCreatePrinterIC_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncCreatePrinterIC *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 36) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncCreatePrinterIC_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[35];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncCreatePrinterIC_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncCreatePrinterIC_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncCreatePrinterIC_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncCreatePrinterIC_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncCreatePrinterIC_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncCreatePrinterIC *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 36) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncCreatePrinterIC_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[35];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncCreatePrinterIC_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncCreatePrinterIC_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncCreatePrinterIC_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncCreatePrinterIC_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncCreatePrinterIC_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncCreatePrinterIC *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 36) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncCreatePrinterIC_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[35];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncCreatePrinterIC_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncCreatePrinterIC_ndr_print(py_obj, args, kwargs, "winspool_AsyncCreatePrinterIC_in", NDR_IN);
}

static PyObject *py_winspool_AsyncCreatePrinterIC_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncCreatePrinterIC_ndr_print(py_obj, args, kwargs, "winspool_AsyncCreatePrinterIC_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncCreatePrinterIC_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncCreatePrinterIC_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncCreatePrinterIC.opnum() -> 35 (0x23) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncCreatePrinterIC_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncCreatePrinterIC_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncCreatePrinterIC_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncCreatePrinterIC_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncCreatePrinterIC_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncCreatePrinterIC_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncCreatePrinterIC_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncCreatePrinterIC",
	.tp_getset = py_winspool_AsyncCreatePrinterIC_getsetters,
	.tp_methods = py_winspool_AsyncCreatePrinterIC_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncCreatePrinterIC_new,
};

static bool pack_py_winspool_AsyncCreatePrinterIC_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncCreatePrinterIC *r)
{
	PyObject *py_hPrinter;
	PyObject *py_pDevModeContainer;
	const char *kwnames[] = {
		"hPrinter", "pDevModeContainer", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:winspool_AsyncCreatePrinterIC", discard_const_p(char *, kwnames), &py_hPrinter, &py_pDevModeContainer)) {
		return false;
	}

	if (py_hPrinter == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinter");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinter, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinter)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinter = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinter);
	if (py_pDevModeContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pDevModeContainer");
		return false;
	}
	r->in.pDevModeContainer = talloc_ptrtype(r, r->in.pDevModeContainer);
	if (r->in.pDevModeContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_DevmodeContainer_Type, py_pDevModeContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pDevModeContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pDevModeContainer = (struct spoolss_DevmodeContainer *)pytalloc_get_ptr(py_pDevModeContainer);
	return true;
}

static PyObject *unpack_py_winspool_AsyncCreatePrinterIC_args_out(struct winspool_AsyncCreatePrinterIC *r, bool raise_result_exception)
{
	PyObject *py_pHandle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pHandle = pytalloc_reference_ex(policy_handle_Type, r->out.pHandle, r->out.pHandle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_pHandle);
	}
	if (result_size == 1) {
		result = py_pHandle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_get_hPrinterIC(PyObject *obj, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_hPrinterIC;
	py_hPrinterIC = pytalloc_reference_ex(policy_handle_Type, pytalloc_get_mem_ctx(obj), &object->in.hPrinterIC);
	return py_hPrinterIC;
}

static int py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_set_hPrinterIC(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hPrinterIC");
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.hPrinterIC = *(struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_get_pIn(PyObject *obj, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_pIn;
	if (object->in.pIn == NULL) {
		Py_RETURN_NONE;
	}
	py_pIn = PyList_New(object->in.cIn);
	if (py_pIn == NULL) {
		return NULL;
	}
	{
		int pIn_cntr_1;
		for (pIn_cntr_1 = 0; pIn_cntr_1 < (object->in.cIn); pIn_cntr_1++) {
			PyObject *py_pIn_1;
			py_pIn_1 = PyLong_FromLong((uint16_t)((object->in.pIn)[pIn_cntr_1]));
			PyList_SetItem(py_pIn, pIn_cntr_1, py_pIn_1);
		}
	}
	return py_pIn;
}

static int py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_set_pIn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pIn));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pIn");
		return -1;
	}
	object->in.pIn = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pIn);
	if (object->in.pIn == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pIn_cntr_1;
		object->in.pIn = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pIn, PyList_GET_SIZE(value));
		if (!object->in.pIn) { return -1; }
		talloc_set_name_const(object->in.pIn, "ARRAY: object->in.pIn");
		for (pIn_cntr_1 = 0; pIn_cntr_1 < PyList_GET_SIZE(value); pIn_cntr_1++) {
			if (PyList_GET_ITEM(value, pIn_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pIn)[pIn_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pIn)[pIn_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pIn_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pIn_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.pIn)[pIn_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_get_cIn(PyObject *obj, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_cIn;
	py_cIn = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cIn));
	return py_cIn;
}

static int py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_set_cIn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cIn");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cIn));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cIn = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_out_get_pOut(PyObject *obj, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_pOut;
	if (object->out.pOut == NULL) {
		Py_RETURN_NONE;
	}
	py_pOut = PyList_New(object->in.cOut);
	if (py_pOut == NULL) {
		return NULL;
	}
	{
		int pOut_cntr_1;
		for (pOut_cntr_1 = 0; pOut_cntr_1 < (object->in.cOut); pOut_cntr_1++) {
			PyObject *py_pOut_1;
			py_pOut_1 = PyLong_FromLong((uint16_t)((object->out.pOut)[pOut_cntr_1]));
			PyList_SetItem(py_pOut, pOut_cntr_1, py_pOut_1);
		}
	}
	return py_pOut;
}

static int py_winspool_AsyncPlayGdiScriptOnPrinterIC_out_set_pOut(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pOut));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pOut");
		return -1;
	}
	object->out.pOut = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pOut);
	if (object->out.pOut == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pOut_cntr_1;
		object->out.pOut = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pOut, PyList_GET_SIZE(value));
		if (!object->out.pOut) { return -1; }
		talloc_set_name_const(object->out.pOut, "ARRAY: object->out.pOut");
		for (pOut_cntr_1 = 0; pOut_cntr_1 < PyList_GET_SIZE(value); pOut_cntr_1++) {
			if (PyList_GET_ITEM(value, pOut_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pOut)[pOut_cntr_1]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pOut)[pOut_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(value, pOut_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pOut_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->out.pOut)[pOut_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_get_cOut(PyObject *obj, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_cOut;
	py_cOut = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cOut));
	return py_cOut;
}

static int py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_set_cOut(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cOut");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cOut));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cOut = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_get_ul(PyObject *obj, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_ul;
	py_ul = PyLong_FromUnsignedLongLong((uint32_t)(object->in.ul));
	return py_ul;
}

static int py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_set_ul(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.ul");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.ul));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.ul = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncPlayGdiScriptOnPrinterIC_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncPlayGdiScriptOnPrinterIC_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hPrinterIC"),
		.get = py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_get_hPrinterIC,
		.set = py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_set_hPrinterIC,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_pIn"),
		.get = py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_get_pIn,
		.set = py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_set_pIn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cIn"),
		.get = py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_get_cIn,
		.set = py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_set_cIn,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pOut"),
		.get = py_winspool_AsyncPlayGdiScriptOnPrinterIC_out_get_pOut,
		.set = py_winspool_AsyncPlayGdiScriptOnPrinterIC_out_set_pOut,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cOut"),
		.get = py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_get_cOut,
		.set = py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_set_cOut,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_ul"),
		.get = py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_get_ul,
		.set = py_winspool_AsyncPlayGdiScriptOnPrinterIC_in_set_ul,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncPlayGdiScriptOnPrinterIC_get_result,
		.set = py_winspool_AsyncPlayGdiScriptOnPrinterIC_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncPlayGdiScriptOnPrinterIC, type);
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *_self = (struct winspool_AsyncPlayGdiScriptOnPrinterIC *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pIn = talloc_zero(mem_ctx, uint8_t);
	_self->out.pOut = talloc_zero(mem_ctx, uint8_t);
	return self;
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(36);
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 37) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[36];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 37) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[36];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncPlayGdiScriptOnPrinterIC *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 37) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[36];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_print(py_obj, args, kwargs, "winspool_AsyncPlayGdiScriptOnPrinterIC_in", NDR_IN);
}

static PyObject *py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_print(py_obj, args, kwargs, "winspool_AsyncPlayGdiScriptOnPrinterIC_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncPlayGdiScriptOnPrinterIC_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncPlayGdiScriptOnPrinterIC.opnum() -> 36 (0x24) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncPlayGdiScriptOnPrinterIC_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncPlayGdiScriptOnPrinterIC_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncPlayGdiScriptOnPrinterIC",
	.tp_getset = py_winspool_AsyncPlayGdiScriptOnPrinterIC_getsetters,
	.tp_methods = py_winspool_AsyncPlayGdiScriptOnPrinterIC_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncPlayGdiScriptOnPrinterIC_new,
};

static bool pack_py_winspool_AsyncPlayGdiScriptOnPrinterIC_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncPlayGdiScriptOnPrinterIC *r)
{
	PyObject *py_hPrinterIC;
	PyObject *py_pIn;
	PyObject *py_cOut;
	PyObject *py_ul;
	const char *kwnames[] = {
		"hPrinterIC", "pIn", "cOut", "ul", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winspool_AsyncPlayGdiScriptOnPrinterIC", discard_const_p(char *, kwnames), &py_hPrinterIC, &py_pIn, &py_cOut, &py_ul)) {
		return false;
	}

	if (py_hPrinterIC == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hPrinterIC");
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_hPrinterIC, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_hPrinterIC)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.hPrinterIC = *(struct policy_handle *)pytalloc_get_ptr(py_hPrinterIC);
	if (py_pIn == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pIn");
		return false;
	}
	r->in.pIn = talloc_ptrtype(r, r->in.pIn);
	if (r->in.pIn == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_pIn, return false;);
	{
		int pIn_cntr_1;
		r->in.pIn = talloc_array_ptrtype(r, r->in.pIn, PyList_GET_SIZE(py_pIn));
		if (!r->in.pIn) { return false; }
		talloc_set_name_const(r->in.pIn, "ARRAY: r->in.pIn");
		for (pIn_cntr_1 = 0; pIn_cntr_1 < PyList_GET_SIZE(py_pIn); pIn_cntr_1++) {
			if (PyList_GET_ITEM(py_pIn, pIn_cntr_1) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pIn)[pIn_cntr_1]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pIn)[pIn_cntr_1]));
				if (PyLong_Check(PyList_GET_ITEM(py_pIn, pIn_cntr_1))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pIn, pIn_cntr_1));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.pIn)[pIn_cntr_1] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pIn, return false;);
	r->in.cIn = PyList_GET_SIZE(py_pIn);
	if (py_cOut == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.cOut");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.cOut));
		if (PyLong_Check(py_cOut)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_cOut);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.cOut = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_ul == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.ul");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.ul));
		if (PyLong_Check(py_ul)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_ul);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.ul = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncPlayGdiScriptOnPrinterIC_args_out(struct winspool_AsyncPlayGdiScriptOnPrinterIC *r, bool raise_result_exception)
{
	PyObject *py_pOut = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_pOut = PyList_New(r->in.cOut);
	if (py_pOut == NULL) {
		return NULL;
	}
	{
		int pOut_cntr_1;
		for (pOut_cntr_1 = 0; pOut_cntr_1 < (r->in.cOut); pOut_cntr_1++) {
			PyObject *py_pOut_1;
			py_pOut_1 = PyLong_FromLong((uint16_t)((r->out.pOut)[pOut_cntr_1]));
			PyList_SetItem(py_pOut, pOut_cntr_1, py_pOut_1);
		}
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_pOut);
	}
	if (result_size == 1) {
		result = py_pOut;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncDeletePrinterIC_in_get_phPrinterIC(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_phPrinterIC;
	if (object->in.phPrinterIC == NULL) {
		Py_RETURN_NONE;
	}
	py_phPrinterIC = pytalloc_reference_ex(policy_handle_Type, object->in.phPrinterIC, object->in.phPrinterIC);
	return py_phPrinterIC;
}

static int py_winspool_AsyncDeletePrinterIC_in_set_phPrinterIC(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterIC *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.phPrinterIC));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.phPrinterIC");
		return -1;
	}
	object->in.phPrinterIC = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.phPrinterIC);
	if (object->in.phPrinterIC == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.phPrinterIC = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncDeletePrinterIC_out_get_phPrinterIC(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_phPrinterIC;
	if (object->out.phPrinterIC == NULL) {
		Py_RETURN_NONE;
	}
	py_phPrinterIC = pytalloc_reference_ex(policy_handle_Type, object->out.phPrinterIC, object->out.phPrinterIC);
	return py_phPrinterIC;
}

static int py_winspool_AsyncDeletePrinterIC_out_set_phPrinterIC(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterIC *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.phPrinterIC));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.phPrinterIC");
		return -1;
	}
	object->out.phPrinterIC = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.phPrinterIC);
	if (object->out.phPrinterIC == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.phPrinterIC = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncDeletePrinterIC_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncDeletePrinterIC *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncDeletePrinterIC_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncDeletePrinterIC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncDeletePrinterIC_getsetters[] = {
	{
		.name = discard_const_p(char, "in_phPrinterIC"),
		.get = py_winspool_AsyncDeletePrinterIC_in_get_phPrinterIC,
		.set = py_winspool_AsyncDeletePrinterIC_in_set_phPrinterIC,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_phPrinterIC"),
		.get = py_winspool_AsyncDeletePrinterIC_out_get_phPrinterIC,
		.set = py_winspool_AsyncDeletePrinterIC_out_set_phPrinterIC,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncDeletePrinterIC_get_result,
		.set = py_winspool_AsyncDeletePrinterIC_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncDeletePrinterIC_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncDeletePrinterIC, type);
	struct winspool_AsyncDeletePrinterIC *_self = (struct winspool_AsyncDeletePrinterIC *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.phPrinterIC = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.phPrinterIC = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_winspool_AsyncDeletePrinterIC_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(37);
}

static PyObject *py_winspool_AsyncDeletePrinterIC_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterIC *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 38) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterIC_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[37];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncDeletePrinterIC_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeletePrinterIC_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeletePrinterIC_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncDeletePrinterIC_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncDeletePrinterIC_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterIC *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 38) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterIC_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[37];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncDeletePrinterIC_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeletePrinterIC_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeletePrinterIC_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncDeletePrinterIC_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncDeletePrinterIC_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncDeletePrinterIC *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 38) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncDeletePrinterIC_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[37];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncDeletePrinterIC_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeletePrinterIC_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeletePrinterIC_in", NDR_IN);
}

static PyObject *py_winspool_AsyncDeletePrinterIC_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncDeletePrinterIC_ndr_print(py_obj, args, kwargs, "winspool_AsyncDeletePrinterIC_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncDeletePrinterIC_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncDeletePrinterIC_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncDeletePrinterIC.opnum() -> 37 (0x25) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterIC_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterIC_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterIC_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterIC_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterIC_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncDeletePrinterIC_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncDeletePrinterIC_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncDeletePrinterIC",
	.tp_getset = py_winspool_AsyncDeletePrinterIC_getsetters,
	.tp_methods = py_winspool_AsyncDeletePrinterIC_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncDeletePrinterIC_new,
};

static bool pack_py_winspool_AsyncDeletePrinterIC_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncDeletePrinterIC *r)
{
	PyObject *py_phPrinterIC;
	const char *kwnames[] = {
		"phPrinterIC", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:winspool_AsyncDeletePrinterIC", discard_const_p(char *, kwnames), &py_phPrinterIC)) {
		return false;
	}

	if (py_phPrinterIC == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.phPrinterIC");
		return false;
	}
	r->in.phPrinterIC = talloc_ptrtype(r, r->in.phPrinterIC);
	if (r->in.phPrinterIC == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_phPrinterIC, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_phPrinterIC)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.phPrinterIC = (struct policy_handle *)pytalloc_get_ptr(py_phPrinterIC);
	return true;
}

static PyObject *unpack_py_winspool_AsyncDeletePrinterIC_args_out(struct winspool_AsyncDeletePrinterIC *r, bool raise_result_exception)
{
	PyObject *py_phPrinterIC = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_phPrinterIC = pytalloc_reference_ex(policy_handle_Type, r->out.phPrinterIC, r->out.phPrinterIC);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_phPrinterIC);
	}
	if (result_size == 1) {
		result = py_phPrinterIC;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncEnumPrinters_in_get_Flags(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Flags));
	return py_Flags;
}

static int py_winspool_AsyncEnumPrinters_in_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinters_in_get_pName(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(obj);
	PyObject *py_pName;
	if (object->in.pName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pName == NULL) {
		py_pName = Py_None;
		Py_INCREF(py_pName);
	} else {
		if (object->in.pName == NULL) {
			py_pName = Py_None;
			Py_INCREF(py_pName);
		} else {
			py_pName = PyUnicode_Decode(object->in.pName, strlen(object->in.pName), "utf-8", "ignore");
		}
	}
	return py_pName;
}

static int py_winspool_AsyncEnumPrinters_in_set_pName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pName");
		return -1;
	}
	if (value == Py_None) {
		object->in.pName = NULL;
	} else {
		object->in.pName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinters_in_get_Level(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(obj);
	PyObject *py_Level;
	py_Level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Level));
	return py_Level;
}

static int py_winspool_AsyncEnumPrinters_in_set_Level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinters_in_get_pPrinterEnum(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(obj);
	PyObject *py_pPrinterEnum;
	if (object->in.pPrinterEnum == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pPrinterEnum == NULL) {
		py_pPrinterEnum = Py_None;
		Py_INCREF(py_pPrinterEnum);
	} else {
		py_pPrinterEnum = PyList_New(object->in.cbBuf);
		if (py_pPrinterEnum == NULL) {
			return NULL;
		}
		{
			int pPrinterEnum_cntr_1;
			for (pPrinterEnum_cntr_1 = 0; pPrinterEnum_cntr_1 < (object->in.cbBuf); pPrinterEnum_cntr_1++) {
				PyObject *py_pPrinterEnum_1;
				py_pPrinterEnum_1 = PyLong_FromLong((uint16_t)((object->in.pPrinterEnum)[pPrinterEnum_cntr_1]));
				PyList_SetItem(py_pPrinterEnum, pPrinterEnum_cntr_1, py_pPrinterEnum_1);
			}
		}
	}
	return py_pPrinterEnum;
}

static int py_winspool_AsyncEnumPrinters_in_set_pPrinterEnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pPrinterEnum));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pPrinterEnum");
		return -1;
	}
	if (value == Py_None) {
		object->in.pPrinterEnum = NULL;
	} else {
		object->in.pPrinterEnum = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pPrinterEnum_cntr_1;
			object->in.pPrinterEnum = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pPrinterEnum, PyList_GET_SIZE(value));
			if (!object->in.pPrinterEnum) { return -1; }
			talloc_set_name_const(object->in.pPrinterEnum, "ARRAY: object->in.pPrinterEnum");
			for (pPrinterEnum_cntr_1 = 0; pPrinterEnum_cntr_1 < PyList_GET_SIZE(value); pPrinterEnum_cntr_1++) {
				if (PyList_GET_ITEM(value, pPrinterEnum_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pPrinterEnum)[pPrinterEnum_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pPrinterEnum)[pPrinterEnum_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pPrinterEnum_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pPrinterEnum_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.pPrinterEnum)[pPrinterEnum_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinters_out_get_pPrinterEnum(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(obj);
	PyObject *py_pPrinterEnum;
	if (object->out.pPrinterEnum == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.pPrinterEnum == NULL) {
		py_pPrinterEnum = Py_None;
		Py_INCREF(py_pPrinterEnum);
	} else {
		py_pPrinterEnum = PyList_New(object->in.cbBuf);
		if (py_pPrinterEnum == NULL) {
			return NULL;
		}
		{
			int pPrinterEnum_cntr_1;
			for (pPrinterEnum_cntr_1 = 0; pPrinterEnum_cntr_1 < (object->in.cbBuf); pPrinterEnum_cntr_1++) {
				PyObject *py_pPrinterEnum_1;
				py_pPrinterEnum_1 = PyLong_FromLong((uint16_t)((object->out.pPrinterEnum)[pPrinterEnum_cntr_1]));
				PyList_SetItem(py_pPrinterEnum, pPrinterEnum_cntr_1, py_pPrinterEnum_1);
			}
		}
	}
	return py_pPrinterEnum;
}

static int py_winspool_AsyncEnumPrinters_out_set_pPrinterEnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pPrinterEnum));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pPrinterEnum");
		return -1;
	}
	if (value == Py_None) {
		object->out.pPrinterEnum = NULL;
	} else {
		object->out.pPrinterEnum = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pPrinterEnum_cntr_1;
			object->out.pPrinterEnum = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pPrinterEnum, PyList_GET_SIZE(value));
			if (!object->out.pPrinterEnum) { return -1; }
			talloc_set_name_const(object->out.pPrinterEnum, "ARRAY: object->out.pPrinterEnum");
			for (pPrinterEnum_cntr_1 = 0; pPrinterEnum_cntr_1 < PyList_GET_SIZE(value); pPrinterEnum_cntr_1++) {
				if (PyList_GET_ITEM(value, pPrinterEnum_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pPrinterEnum)[pPrinterEnum_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pPrinterEnum)[pPrinterEnum_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pPrinterEnum_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pPrinterEnum_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.pPrinterEnum)[pPrinterEnum_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinters_in_get_cbBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(obj);
	PyObject *py_cbBuf;
	py_cbBuf = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbBuf));
	return py_cbBuf;
}

static int py_winspool_AsyncEnumPrinters_in_set_cbBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbBuf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbBuf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbBuf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinters_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncEnumPrinters_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinters_out_get_pcReturned(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(obj);
	PyObject *py_pcReturned;
	if (object->out.pcReturned == NULL) {
		Py_RETURN_NONE;
	}
	py_pcReturned = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcReturned));
	return py_pcReturned;
}

static int py_winspool_AsyncEnumPrinters_out_set_pcReturned(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcReturned));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcReturned");
		return -1;
	}
	object->out.pcReturned = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcReturned);
	if (object->out.pcReturned == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcReturned));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcReturned = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinters_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncEnumPrinters_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncEnumPrinters_getsetters[] = {
	{
		.name = discard_const_p(char, "in_Flags"),
		.get = py_winspool_AsyncEnumPrinters_in_get_Flags,
		.set = py_winspool_AsyncEnumPrinters_in_set_Flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pName"),
		.get = py_winspool_AsyncEnumPrinters_in_get_pName,
		.set = py_winspool_AsyncEnumPrinters_in_set_pName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Level"),
		.get = py_winspool_AsyncEnumPrinters_in_get_Level,
		.set = py_winspool_AsyncEnumPrinters_in_set_Level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pPrinterEnum"),
		.get = py_winspool_AsyncEnumPrinters_in_get_pPrinterEnum,
		.set = py_winspool_AsyncEnumPrinters_in_set_pPrinterEnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pPrinterEnum"),
		.get = py_winspool_AsyncEnumPrinters_out_get_pPrinterEnum,
		.set = py_winspool_AsyncEnumPrinters_out_set_pPrinterEnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbBuf"),
		.get = py_winspool_AsyncEnumPrinters_in_get_cbBuf,
		.set = py_winspool_AsyncEnumPrinters_in_set_cbBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncEnumPrinters_out_get_pcbNeeded,
		.set = py_winspool_AsyncEnumPrinters_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcReturned"),
		.get = py_winspool_AsyncEnumPrinters_out_get_pcReturned,
		.set = py_winspool_AsyncEnumPrinters_out_set_pcReturned,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncEnumPrinters_get_result,
		.set = py_winspool_AsyncEnumPrinters_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncEnumPrinters_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncEnumPrinters, type);
	struct winspool_AsyncEnumPrinters *_self = (struct winspool_AsyncEnumPrinters *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	_self->out.pcReturned = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncEnumPrinters_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(38);
}

static PyObject *py_winspool_AsyncEnumPrinters_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 39) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinters_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[38];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncEnumPrinters_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumPrinters_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumPrinters_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumPrinters_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumPrinters_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 39) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinters_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[38];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncEnumPrinters_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumPrinters_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumPrinters_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumPrinters_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumPrinters_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinters *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 39) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinters_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[38];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncEnumPrinters_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumPrinters_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumPrinters_in", NDR_IN);
}

static PyObject *py_winspool_AsyncEnumPrinters_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumPrinters_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumPrinters_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncEnumPrinters_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncEnumPrinters_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncEnumPrinters.opnum() -> 38 (0x26) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinters_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinters_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinters_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinters_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinters_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinters_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncEnumPrinters_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncEnumPrinters",
	.tp_getset = py_winspool_AsyncEnumPrinters_getsetters,
	.tp_methods = py_winspool_AsyncEnumPrinters_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncEnumPrinters_new,
};

static bool pack_py_winspool_AsyncEnumPrinters_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncEnumPrinters *r)
{
	PyObject *py_Flags;
	PyObject *py_pName;
	PyObject *py_Level;
	PyObject *py_pPrinterEnum;
	const char *kwnames[] = {
		"Flags", "pName", "Level", "pPrinterEnum", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winspool_AsyncEnumPrinters", discard_const_p(char *, kwnames), &py_Flags, &py_pName, &py_Level, &py_pPrinterEnum)) {
		return false;
	}

	if (py_Flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Flags));
		if (PyLong_Check(py_Flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pName");
		return false;
	}
	if (py_pName == Py_None) {
		r->in.pName = NULL;
	} else {
		r->in.pName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pName)) {
				unicode = PyUnicode_AsEncodedString(py_pName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pName)) {
				test_str = PyBytes_AS_STRING(py_pName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pName = talloc_str;
		}
	}
	if (py_Level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Level));
		if (PyLong_Check(py_Level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pPrinterEnum == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pPrinterEnum");
		return false;
	}
	if (py_pPrinterEnum == Py_None) {
		r->in.pPrinterEnum = NULL;
	} else {
		r->in.pPrinterEnum = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_pPrinterEnum, return false;);
		{
			int pPrinterEnum_cntr_1;
			r->in.pPrinterEnum = talloc_array_ptrtype(r, r->in.pPrinterEnum, PyList_GET_SIZE(py_pPrinterEnum));
			if (!r->in.pPrinterEnum) { return false; }
			talloc_set_name_const(r->in.pPrinterEnum, "ARRAY: r->in.pPrinterEnum");
			for (pPrinterEnum_cntr_1 = 0; pPrinterEnum_cntr_1 < PyList_GET_SIZE(py_pPrinterEnum); pPrinterEnum_cntr_1++) {
				if (PyList_GET_ITEM(py_pPrinterEnum, pPrinterEnum_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pPrinterEnum)[pPrinterEnum_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pPrinterEnum)[pPrinterEnum_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_pPrinterEnum, pPrinterEnum_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pPrinterEnum, pPrinterEnum_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.pPrinterEnum)[pPrinterEnum_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pPrinterEnum, return false;);
	r->in.cbBuf = PyList_GET_SIZE(py_pPrinterEnum);
	return true;
}

static PyObject *unpack_py_winspool_AsyncEnumPrinters_args_out(struct winspool_AsyncEnumPrinters *r, bool raise_result_exception)
{
	PyObject *py_pPrinterEnum = NULL;
	PyObject *py_pcbNeeded = NULL;
	PyObject *py_pcReturned = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.pPrinterEnum == NULL) {
		py_pPrinterEnum = Py_None;
		Py_INCREF(py_pPrinterEnum);
	} else {
		py_pPrinterEnum = PyList_New(r->in.cbBuf);
		if (py_pPrinterEnum == NULL) {
			return NULL;
		}
		{
			int pPrinterEnum_cntr_1;
			for (pPrinterEnum_cntr_1 = 0; pPrinterEnum_cntr_1 < (r->in.cbBuf); pPrinterEnum_cntr_1++) {
				PyObject *py_pPrinterEnum_1;
				py_pPrinterEnum_1 = PyLong_FromLong((uint16_t)((r->out.pPrinterEnum)[pPrinterEnum_cntr_1]));
				PyList_SetItem(py_pPrinterEnum, pPrinterEnum_cntr_1, py_pPrinterEnum_1);
			}
		}
	}
	PyTuple_SetItem(result, 0, py_pPrinterEnum);

	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbNeeded));
	PyTuple_SetItem(result, 1, py_pcbNeeded);

	py_pcReturned = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcReturned));
	PyTuple_SetItem(result, 2, py_pcReturned);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncAddPrinterDriver_in_get_pName(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_pName;
	if (object->in.pName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pName == NULL) {
		py_pName = Py_None;
		Py_INCREF(py_pName);
	} else {
		if (object->in.pName == NULL) {
			py_pName = Py_None;
			Py_INCREF(py_pName);
		} else {
			py_pName = PyUnicode_Decode(object->in.pName, strlen(object->in.pName), "utf-8", "ignore");
		}
	}
	return py_pName;
}

static int py_winspool_AsyncAddPrinterDriver_in_set_pName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddPrinterDriver *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pName");
		return -1;
	}
	if (value == Py_None) {
		object->in.pName = NULL;
	} else {
		object->in.pName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncAddPrinterDriver_in_get_pDriverContainer(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_pDriverContainer;
	if (object->in.pDriverContainer == NULL) {
		Py_RETURN_NONE;
	}
	py_pDriverContainer = pytalloc_reference_ex(spoolss_AddDriverInfoCtr_Type, object->in.pDriverContainer, object->in.pDriverContainer);
	return py_pDriverContainer;
}

static int py_winspool_AsyncAddPrinterDriver_in_set_pDriverContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddPrinterDriver *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pDriverContainer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pDriverContainer");
		return -1;
	}
	object->in.pDriverContainer = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pDriverContainer);
	if (object->in.pDriverContainer == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(spoolss_AddDriverInfoCtr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.pDriverContainer = (struct spoolss_AddDriverInfoCtr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_winspool_AsyncAddPrinterDriver_in_get_dwFileCopyFlags(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_dwFileCopyFlags;
	py_dwFileCopyFlags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dwFileCopyFlags));
	return py_dwFileCopyFlags;
}

static int py_winspool_AsyncAddPrinterDriver_in_set_dwFileCopyFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddPrinterDriver *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dwFileCopyFlags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dwFileCopyFlags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dwFileCopyFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncAddPrinterDriver_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncAddPrinterDriver *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncAddPrinterDriver_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncAddPrinterDriver *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncAddPrinterDriver_getsetters[] = {
	{
		.name = discard_const_p(char, "in_pName"),
		.get = py_winspool_AsyncAddPrinterDriver_in_get_pName,
		.set = py_winspool_AsyncAddPrinterDriver_in_set_pName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pDriverContainer"),
		.get = py_winspool_AsyncAddPrinterDriver_in_get_pDriverContainer,
		.set = py_winspool_AsyncAddPrinterDriver_in_set_pDriverContainer,
		.doc = discard_const_p(char, "PIDL-generated element of base type spoolss_AddDriverInfoCtr")
	},
	{
		.name = discard_const_p(char, "in_dwFileCopyFlags"),
		.get = py_winspool_AsyncAddPrinterDriver_in_get_dwFileCopyFlags,
		.set = py_winspool_AsyncAddPrinterDriver_in_set_dwFileCopyFlags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncAddPrinterDriver_get_result,
		.set = py_winspool_AsyncAddPrinterDriver_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncAddPrinterDriver_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncAddPrinterDriver, type);
	struct winspool_AsyncAddPrinterDriver *_self = (struct winspool_AsyncAddPrinterDriver *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.pDriverContainer = talloc_zero(mem_ctx, struct spoolss_AddDriverInfoCtr);
	return self;
}

static PyObject *py_winspool_AsyncAddPrinterDriver_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(39);
}

static PyObject *py_winspool_AsyncAddPrinterDriver_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddPrinterDriver *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 40) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddPrinterDriver_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[39];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncAddPrinterDriver_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncAddPrinterDriver_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncAddPrinterDriver_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncAddPrinterDriver_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncAddPrinterDriver_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddPrinterDriver *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 40) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddPrinterDriver_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[39];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncAddPrinterDriver_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncAddPrinterDriver_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncAddPrinterDriver_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncAddPrinterDriver_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncAddPrinterDriver_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncAddPrinterDriver *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 40) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncAddPrinterDriver_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[39];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncAddPrinterDriver_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncAddPrinterDriver_ndr_print(py_obj, args, kwargs, "winspool_AsyncAddPrinterDriver_in", NDR_IN);
}

static PyObject *py_winspool_AsyncAddPrinterDriver_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncAddPrinterDriver_ndr_print(py_obj, args, kwargs, "winspool_AsyncAddPrinterDriver_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncAddPrinterDriver_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncAddPrinterDriver_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncAddPrinterDriver.opnum() -> 39 (0x27) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinterDriver_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinterDriver_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinterDriver_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinterDriver_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinterDriver_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncAddPrinterDriver_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncAddPrinterDriver_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncAddPrinterDriver",
	.tp_getset = py_winspool_AsyncAddPrinterDriver_getsetters,
	.tp_methods = py_winspool_AsyncAddPrinterDriver_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncAddPrinterDriver_new,
};

static bool pack_py_winspool_AsyncAddPrinterDriver_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncAddPrinterDriver *r)
{
	PyObject *py_pName;
	PyObject *py_pDriverContainer;
	PyObject *py_dwFileCopyFlags;
	const char *kwnames[] = {
		"pName", "pDriverContainer", "dwFileCopyFlags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:winspool_AsyncAddPrinterDriver", discard_const_p(char *, kwnames), &py_pName, &py_pDriverContainer, &py_dwFileCopyFlags)) {
		return false;
	}

	if (py_pName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pName");
		return false;
	}
	if (py_pName == Py_None) {
		r->in.pName = NULL;
	} else {
		r->in.pName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pName)) {
				unicode = PyUnicode_AsEncodedString(py_pName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pName)) {
				test_str = PyBytes_AS_STRING(py_pName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pName = talloc_str;
		}
	}
	if (py_pDriverContainer == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pDriverContainer");
		return false;
	}
	r->in.pDriverContainer = talloc_ptrtype(r, r->in.pDriverContainer);
	if (r->in.pDriverContainer == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(spoolss_AddDriverInfoCtr_Type, py_pDriverContainer, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_pDriverContainer)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pDriverContainer = (struct spoolss_AddDriverInfoCtr *)pytalloc_get_ptr(py_pDriverContainer);
	if (py_dwFileCopyFlags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dwFileCopyFlags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.dwFileCopyFlags));
		if (PyLong_Check(py_dwFileCopyFlags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_dwFileCopyFlags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.dwFileCopyFlags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_winspool_AsyncAddPrinterDriver_args_out(struct winspool_AsyncAddPrinterDriver *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_winspool_AsyncEnumPrinterDrivers_in_get_pName(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(obj);
	PyObject *py_pName;
	if (object->in.pName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pName == NULL) {
		py_pName = Py_None;
		Py_INCREF(py_pName);
	} else {
		if (object->in.pName == NULL) {
			py_pName = Py_None;
			Py_INCREF(py_pName);
		} else {
			py_pName = PyUnicode_Decode(object->in.pName, strlen(object->in.pName), "utf-8", "ignore");
		}
	}
	return py_pName;
}

static int py_winspool_AsyncEnumPrinterDrivers_in_set_pName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pName");
		return -1;
	}
	if (value == Py_None) {
		object->in.pName = NULL;
	} else {
		object->in.pName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_in_get_pEnvironment(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(obj);
	PyObject *py_pEnvironment;
	if (object->in.pEnvironment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pEnvironment == NULL) {
		py_pEnvironment = Py_None;
		Py_INCREF(py_pEnvironment);
	} else {
		if (object->in.pEnvironment == NULL) {
			py_pEnvironment = Py_None;
			Py_INCREF(py_pEnvironment);
		} else {
			py_pEnvironment = PyUnicode_Decode(object->in.pEnvironment, strlen(object->in.pEnvironment), "utf-8", "ignore");
		}
	}
	return py_pEnvironment;
}

static int py_winspool_AsyncEnumPrinterDrivers_in_set_pEnvironment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pEnvironment");
		return -1;
	}
	if (value == Py_None) {
		object->in.pEnvironment = NULL;
	} else {
		object->in.pEnvironment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pEnvironment = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_in_get_Level(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(obj);
	PyObject *py_Level;
	py_Level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Level));
	return py_Level;
}

static int py_winspool_AsyncEnumPrinterDrivers_in_set_Level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_in_get_pDrivers(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(obj);
	PyObject *py_pDrivers;
	if (object->in.pDrivers == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pDrivers == NULL) {
		py_pDrivers = Py_None;
		Py_INCREF(py_pDrivers);
	} else {
		py_pDrivers = PyList_New(object->in.cbBuf);
		if (py_pDrivers == NULL) {
			return NULL;
		}
		{
			int pDrivers_cntr_1;
			for (pDrivers_cntr_1 = 0; pDrivers_cntr_1 < (object->in.cbBuf); pDrivers_cntr_1++) {
				PyObject *py_pDrivers_1;
				py_pDrivers_1 = PyLong_FromLong((uint16_t)((object->in.pDrivers)[pDrivers_cntr_1]));
				PyList_SetItem(py_pDrivers, pDrivers_cntr_1, py_pDrivers_1);
			}
		}
	}
	return py_pDrivers;
}

static int py_winspool_AsyncEnumPrinterDrivers_in_set_pDrivers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pDrivers));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pDrivers");
		return -1;
	}
	if (value == Py_None) {
		object->in.pDrivers = NULL;
	} else {
		object->in.pDrivers = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pDrivers_cntr_1;
			object->in.pDrivers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pDrivers, PyList_GET_SIZE(value));
			if (!object->in.pDrivers) { return -1; }
			talloc_set_name_const(object->in.pDrivers, "ARRAY: object->in.pDrivers");
			for (pDrivers_cntr_1 = 0; pDrivers_cntr_1 < PyList_GET_SIZE(value); pDrivers_cntr_1++) {
				if (PyList_GET_ITEM(value, pDrivers_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pDrivers)[pDrivers_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pDrivers)[pDrivers_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pDrivers_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pDrivers_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.pDrivers)[pDrivers_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_out_get_pDrivers(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(obj);
	PyObject *py_pDrivers;
	if (object->out.pDrivers == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.pDrivers == NULL) {
		py_pDrivers = Py_None;
		Py_INCREF(py_pDrivers);
	} else {
		py_pDrivers = PyList_New(object->in.cbBuf);
		if (py_pDrivers == NULL) {
			return NULL;
		}
		{
			int pDrivers_cntr_1;
			for (pDrivers_cntr_1 = 0; pDrivers_cntr_1 < (object->in.cbBuf); pDrivers_cntr_1++) {
				PyObject *py_pDrivers_1;
				py_pDrivers_1 = PyLong_FromLong((uint16_t)((object->out.pDrivers)[pDrivers_cntr_1]));
				PyList_SetItem(py_pDrivers, pDrivers_cntr_1, py_pDrivers_1);
			}
		}
	}
	return py_pDrivers;
}

static int py_winspool_AsyncEnumPrinterDrivers_out_set_pDrivers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pDrivers));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pDrivers");
		return -1;
	}
	if (value == Py_None) {
		object->out.pDrivers = NULL;
	} else {
		object->out.pDrivers = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pDrivers_cntr_1;
			object->out.pDrivers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pDrivers, PyList_GET_SIZE(value));
			if (!object->out.pDrivers) { return -1; }
			talloc_set_name_const(object->out.pDrivers, "ARRAY: object->out.pDrivers");
			for (pDrivers_cntr_1 = 0; pDrivers_cntr_1 < PyList_GET_SIZE(value); pDrivers_cntr_1++) {
				if (PyList_GET_ITEM(value, pDrivers_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pDrivers)[pDrivers_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pDrivers)[pDrivers_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pDrivers_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pDrivers_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.pDrivers)[pDrivers_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_in_get_cbBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(obj);
	PyObject *py_cbBuf;
	py_cbBuf = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbBuf));
	return py_cbBuf;
}

static int py_winspool_AsyncEnumPrinterDrivers_in_set_cbBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbBuf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbBuf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbBuf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncEnumPrinterDrivers_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_out_get_pcReturned(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(obj);
	PyObject *py_pcReturned;
	if (object->out.pcReturned == NULL) {
		Py_RETURN_NONE;
	}
	py_pcReturned = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcReturned));
	return py_pcReturned;
}

static int py_winspool_AsyncEnumPrinterDrivers_out_set_pcReturned(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcReturned));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcReturned");
		return -1;
	}
	object->out.pcReturned = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcReturned);
	if (object->out.pcReturned == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcReturned));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcReturned = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncEnumPrinterDrivers_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncEnumPrinterDrivers_getsetters[] = {
	{
		.name = discard_const_p(char, "in_pName"),
		.get = py_winspool_AsyncEnumPrinterDrivers_in_get_pName,
		.set = py_winspool_AsyncEnumPrinterDrivers_in_set_pName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pEnvironment"),
		.get = py_winspool_AsyncEnumPrinterDrivers_in_get_pEnvironment,
		.set = py_winspool_AsyncEnumPrinterDrivers_in_set_pEnvironment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Level"),
		.get = py_winspool_AsyncEnumPrinterDrivers_in_get_Level,
		.set = py_winspool_AsyncEnumPrinterDrivers_in_set_Level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pDrivers"),
		.get = py_winspool_AsyncEnumPrinterDrivers_in_get_pDrivers,
		.set = py_winspool_AsyncEnumPrinterDrivers_in_set_pDrivers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pDrivers"),
		.get = py_winspool_AsyncEnumPrinterDrivers_out_get_pDrivers,
		.set = py_winspool_AsyncEnumPrinterDrivers_out_set_pDrivers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbBuf"),
		.get = py_winspool_AsyncEnumPrinterDrivers_in_get_cbBuf,
		.set = py_winspool_AsyncEnumPrinterDrivers_in_set_cbBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncEnumPrinterDrivers_out_get_pcbNeeded,
		.set = py_winspool_AsyncEnumPrinterDrivers_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcReturned"),
		.get = py_winspool_AsyncEnumPrinterDrivers_out_get_pcReturned,
		.set = py_winspool_AsyncEnumPrinterDrivers_out_set_pcReturned,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncEnumPrinterDrivers_get_result,
		.set = py_winspool_AsyncEnumPrinterDrivers_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncEnumPrinterDrivers_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncEnumPrinterDrivers, type);
	struct winspool_AsyncEnumPrinterDrivers *_self = (struct winspool_AsyncEnumPrinterDrivers *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	_self->out.pcReturned = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(40);
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 41) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterDrivers_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[40];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumPrinterDrivers_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncEnumPrinterDrivers_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 41) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterDrivers_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[40];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumPrinterDrivers_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_winspool_AsyncEnumPrinterDrivers_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncEnumPrinterDrivers *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_iremotewinspool.num_calls < 41) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncEnumPrinterDrivers_ndr_print");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[40];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumPrinterDrivers_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumPrinterDrivers_in", NDR_IN);
}

static PyObject *py_winspool_AsyncEnumPrinterDrivers_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_winspool_AsyncEnumPrinterDrivers_ndr_print(py_obj, args, kwargs, "winspool_AsyncEnumPrinterDrivers_out", NDR_OUT);
}

static PyMethodDef py_winspool_AsyncEnumPrinterDrivers_methods[] = {
	{ "opnum", (PyCFunction)py_winspool_AsyncEnumPrinterDrivers_ndr_opnum, METH_NOARGS|METH_CLASS,
		"winspool.AsyncEnumPrinterDrivers.opnum() -> 40 (0x28) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDrivers_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDrivers_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDrivers_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDrivers_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDrivers_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winspool_AsyncEnumPrinterDrivers_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject winspool_AsyncEnumPrinterDrivers_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "winspool.AsyncEnumPrinterDrivers",
	.tp_getset = py_winspool_AsyncEnumPrinterDrivers_getsetters,
	.tp_methods = py_winspool_AsyncEnumPrinterDrivers_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winspool_AsyncEnumPrinterDrivers_new,
};

static bool pack_py_winspool_AsyncEnumPrinterDrivers_args_in(PyObject *args, PyObject *kwargs, struct winspool_AsyncEnumPrinterDrivers *r)
{
	PyObject *py_pName;
	PyObject *py_pEnvironment;
	PyObject *py_Level;
	PyObject *py_pDrivers;
	const char *kwnames[] = {
		"pName", "pEnvironment", "Level", "pDrivers", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:winspool_AsyncEnumPrinterDrivers", discard_const_p(char *, kwnames), &py_pName, &py_pEnvironment, &py_Level, &py_pDrivers)) {
		return false;
	}

	if (py_pName == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pName");
		return false;
	}
	if (py_pName == Py_None) {
		r->in.pName = NULL;
	} else {
		r->in.pName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pName)) {
				unicode = PyUnicode_AsEncodedString(py_pName, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pName)) {
				test_str = PyBytes_AS_STRING(py_pName);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pName)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pName = talloc_str;
		}
	}
	if (py_pEnvironment == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pEnvironment");
		return false;
	}
	if (py_pEnvironment == Py_None) {
		r->in.pEnvironment = NULL;
	} else {
		r->in.pEnvironment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_pEnvironment)) {
				unicode = PyUnicode_AsEncodedString(py_pEnvironment, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_pEnvironment)) {
				test_str = PyBytes_AS_STRING(py_pEnvironment);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pEnvironment)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.pEnvironment = talloc_str;
		}
	}
	if (py_Level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.Level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.Level));
		if (PyLong_Check(py_Level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_Level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_pDrivers == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.pDrivers");
		return false;
	}
	if (py_pDrivers == Py_None) {
		r->in.pDrivers = NULL;
	} else {
		r->in.pDrivers = NULL;
		PY_CHECK_TYPE(&PyList_Type, py_pDrivers, return false;);
		{
			int pDrivers_cntr_1;
			r->in.pDrivers = talloc_array_ptrtype(r, r->in.pDrivers, PyList_GET_SIZE(py_pDrivers));
			if (!r->in.pDrivers) { return false; }
			talloc_set_name_const(r->in.pDrivers, "ARRAY: r->in.pDrivers");
			for (pDrivers_cntr_1 = 0; pDrivers_cntr_1 < PyList_GET_SIZE(py_pDrivers); pDrivers_cntr_1++) {
				if (PyList_GET_ITEM(py_pDrivers, pDrivers_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.pDrivers)[pDrivers_cntr_1]");
					return false;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.pDrivers)[pDrivers_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(py_pDrivers, pDrivers_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_pDrivers, pDrivers_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return false;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return false;
						}
						(r->in.pDrivers)[pDrivers_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return false;
					}
				}
			}
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_pDrivers, return false;);
	r->in.cbBuf = PyList_GET_SIZE(py_pDrivers);
	return true;
}

static PyObject *unpack_py_winspool_AsyncEnumPrinterDrivers_args_out(struct winspool_AsyncEnumPrinterDrivers *r, bool raise_result_exception)
{
	PyObject *py_pDrivers = NULL;
	PyObject *py_pcbNeeded = NULL;
	PyObject *py_pcReturned = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.pDrivers == NULL) {
		py_pDrivers = Py_None;
		Py_INCREF(py_pDrivers);
	} else {
		py_pDrivers = PyList_New(r->in.cbBuf);
		if (py_pDrivers == NULL) {
			return NULL;
		}
		{
			int pDrivers_cntr_1;
			for (pDrivers_cntr_1 = 0; pDrivers_cntr_1 < (r->in.cbBuf); pDrivers_cntr_1++) {
				PyObject *py_pDrivers_1;
				py_pDrivers_1 = PyLong_FromLong((uint16_t)((r->out.pDrivers)[pDrivers_cntr_1]));
				PyList_SetItem(py_pDrivers, pDrivers_cntr_1, py_pDrivers_1);
			}
		}
	}
	PyTuple_SetItem(result, 0, py_pDrivers);

	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcbNeeded));
	PyTuple_SetItem(result, 1, py_pcbNeeded);

	py_pcReturned = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.pcReturned));
	PyTuple_SetItem(result, 2, py_pcReturned);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_in_get_pName(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(obj);
	PyObject *py_pName;
	if (object->in.pName == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pName == NULL) {
		py_pName = Py_None;
		Py_INCREF(py_pName);
	} else {
		if (object->in.pName == NULL) {
			py_pName = Py_None;
			Py_INCREF(py_pName);
		} else {
			py_pName = PyUnicode_Decode(object->in.pName, strlen(object->in.pName), "utf-8", "ignore");
		}
	}
	return py_pName;
}

static int py_winspool_AsyncGetPrinterDriverDirectory_in_set_pName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pName");
		return -1;
	}
	if (value == Py_None) {
		object->in.pName = NULL;
	} else {
		object->in.pName = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pName = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_in_get_pEnvironment(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(obj);
	PyObject *py_pEnvironment;
	if (object->in.pEnvironment == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pEnvironment == NULL) {
		py_pEnvironment = Py_None;
		Py_INCREF(py_pEnvironment);
	} else {
		if (object->in.pEnvironment == NULL) {
			py_pEnvironment = Py_None;
			Py_INCREF(py_pEnvironment);
		} else {
			py_pEnvironment = PyUnicode_Decode(object->in.pEnvironment, strlen(object->in.pEnvironment), "utf-8", "ignore");
		}
	}
	return py_pEnvironment;
}

static int py_winspool_AsyncGetPrinterDriverDirectory_in_set_pEnvironment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pEnvironment");
		return -1;
	}
	if (value == Py_None) {
		object->in.pEnvironment = NULL;
	} else {
		object->in.pEnvironment = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.pEnvironment = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_in_get_Level(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(obj);
	PyObject *py_Level;
	py_Level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.Level));
	return py_Level;
}

static int py_winspool_AsyncGetPrinterDriverDirectory_in_set_Level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.Level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.Level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.Level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_in_get_pDriverDirectory(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(obj);
	PyObject *py_pDriverDirectory;
	if (object->in.pDriverDirectory == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.pDriverDirectory == NULL) {
		py_pDriverDirectory = Py_None;
		Py_INCREF(py_pDriverDirectory);
	} else {
		py_pDriverDirectory = PyList_New(object->in.cbBuf);
		if (py_pDriverDirectory == NULL) {
			return NULL;
		}
		{
			int pDriverDirectory_cntr_1;
			for (pDriverDirectory_cntr_1 = 0; pDriverDirectory_cntr_1 < (object->in.cbBuf); pDriverDirectory_cntr_1++) {
				PyObject *py_pDriverDirectory_1;
				py_pDriverDirectory_1 = PyLong_FromLong((uint16_t)((object->in.pDriverDirectory)[pDriverDirectory_cntr_1]));
				PyList_SetItem(py_pDriverDirectory, pDriverDirectory_cntr_1, py_pDriverDirectory_1);
			}
		}
	}
	return py_pDriverDirectory;
}

static int py_winspool_AsyncGetPrinterDriverDirectory_in_set_pDriverDirectory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.pDriverDirectory));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.pDriverDirectory");
		return -1;
	}
	if (value == Py_None) {
		object->in.pDriverDirectory = NULL;
	} else {
		object->in.pDriverDirectory = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pDriverDirectory_cntr_1;
			object->in.pDriverDirectory = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.pDriverDirectory, PyList_GET_SIZE(value));
			if (!object->in.pDriverDirectory) { return -1; }
			talloc_set_name_const(object->in.pDriverDirectory, "ARRAY: object->in.pDriverDirectory");
			for (pDriverDirectory_cntr_1 = 0; pDriverDirectory_cntr_1 < PyList_GET_SIZE(value); pDriverDirectory_cntr_1++) {
				if (PyList_GET_ITEM(value, pDriverDirectory_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.pDriverDirectory)[pDriverDirectory_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.pDriverDirectory)[pDriverDirectory_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pDriverDirectory_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pDriverDirectory_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->in.pDriverDirectory)[pDriverDirectory_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_out_get_pDriverDirectory(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(obj);
	PyObject *py_pDriverDirectory;
	if (object->out.pDriverDirectory == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.pDriverDirectory == NULL) {
		py_pDriverDirectory = Py_None;
		Py_INCREF(py_pDriverDirectory);
	} else {
		py_pDriverDirectory = PyList_New(object->in.cbBuf);
		if (py_pDriverDirectory == NULL) {
			return NULL;
		}
		{
			int pDriverDirectory_cntr_1;
			for (pDriverDirectory_cntr_1 = 0; pDriverDirectory_cntr_1 < (object->in.cbBuf); pDriverDirectory_cntr_1++) {
				PyObject *py_pDriverDirectory_1;
				py_pDriverDirectory_1 = PyLong_FromLong((uint16_t)((object->out.pDriverDirectory)[pDriverDirectory_cntr_1]));
				PyList_SetItem(py_pDriverDirectory, pDriverDirectory_cntr_1, py_pDriverDirectory_1);
			}
		}
	}
	return py_pDriverDirectory;
}

static int py_winspool_AsyncGetPrinterDriverDirectory_out_set_pDriverDirectory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pDriverDirectory));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pDriverDirectory");
		return -1;
	}
	if (value == Py_None) {
		object->out.pDriverDirectory = NULL;
	} else {
		object->out.pDriverDirectory = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pDriverDirectory_cntr_1;
			object->out.pDriverDirectory = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pDriverDirectory, PyList_GET_SIZE(value));
			if (!object->out.pDriverDirectory) { return -1; }
			talloc_set_name_const(object->out.pDriverDirectory, "ARRAY: object->out.pDriverDirectory");
			for (pDriverDirectory_cntr_1 = 0; pDriverDirectory_cntr_1 < PyList_GET_SIZE(value); pDriverDirectory_cntr_1++) {
				if (PyList_GET_ITEM(value, pDriverDirectory_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.pDriverDirectory)[pDriverDirectory_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->out.pDriverDirectory)[pDriverDirectory_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, pDriverDirectory_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, pDriverDirectory_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->out.pDriverDirectory)[pDriverDirectory_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_in_get_cbBuf(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(obj);
	PyObject *py_cbBuf;
	py_cbBuf = PyLong_FromUnsignedLongLong((uint32_t)(object->in.cbBuf));
	return py_cbBuf;
}

static int py_winspool_AsyncGetPrinterDriverDirectory_in_set_cbBuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.cbBuf");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.cbBuf));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.cbBuf = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_out_get_pcbNeeded(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(obj);
	PyObject *py_pcbNeeded;
	if (object->out.pcbNeeded == NULL) {
		Py_RETURN_NONE;
	}
	py_pcbNeeded = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.pcbNeeded));
	return py_pcbNeeded;
}

static int py_winspool_AsyncGetPrinterDriverDirectory_out_set_pcbNeeded(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.pcbNeeded));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.pcbNeeded");
		return -1;
	}
	object->out.pcbNeeded = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.pcbNeeded);
	if (object->out.pcbNeeded == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.pcbNeeded));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.pcbNeeded = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_get_result(PyObject *obj, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_winspool_AsyncGetPrinterDriverDirectory_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_winspool_AsyncGetPrinterDriverDirectory_getsetters[] = {
	{
		.name = discard_const_p(char, "in_pName"),
		.get = py_winspool_AsyncGetPrinterDriverDirectory_in_get_pName,
		.set = py_winspool_AsyncGetPrinterDriverDirectory_in_set_pName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_pEnvironment"),
		.get = py_winspool_AsyncGetPrinterDriverDirectory_in_get_pEnvironment,
		.set = py_winspool_AsyncGetPrinterDriverDirectory_in_set_pEnvironment,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_Level"),
		.get = py_winspool_AsyncGetPrinterDriverDirectory_in_get_Level,
		.set = py_winspool_AsyncGetPrinterDriverDirectory_in_set_Level,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_pDriverDirectory"),
		.get = py_winspool_AsyncGetPrinterDriverDirectory_in_get_pDriverDirectory,
		.set = py_winspool_AsyncGetPrinterDriverDirectory_in_set_pDriverDirectory,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "out_pDriverDirectory"),
		.get = py_winspool_AsyncGetPrinterDriverDirectory_out_get_pDriverDirectory,
		.set = py_winspool_AsyncGetPrinterDriverDirectory_out_set_pDriverDirectory,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_cbBuf"),
		.get = py_winspool_AsyncGetPrinterDriverDirectory_in_get_cbBuf,
		.set = py_winspool_AsyncGetPrinterDriverDirectory_in_set_cbBuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_pcbNeeded"),
		.get = py_winspool_AsyncGetPrinterDriverDirectory_out_get_pcbNeeded,
		.set = py_winspool_AsyncGetPrinterDriverDirectory_out_set_pcbNeeded,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_winspool_AsyncGetPrinterDriverDirectory_get_result,
		.set = py_winspool_AsyncGetPrinterDriverDirectory_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct winspool_AsyncGetPrinterDriverDirectory, type);
	struct winspool_AsyncGetPrinterDriverDirectory *_self = (struct winspool_AsyncGetPrinterDriverDirectory *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.pcbNeeded = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(41);
}

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct winspool_AsyncGetPrinterDriverDirectory *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_iremotewinspool.num_calls < 42) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_winspool_AsyncGetPrinterDriverDirectory_ndr_pack");
		return NULL;
	}
	call = &ndr_table_iremotewinspool.calls[41];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_winspool_AsyncGetPrinterDriverDirectory_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_winspool_AsyncGetPrinterDriverDirectory_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&