// This file is @generated by prost-build.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CastMessage {
    #[prost(enumeration = "cast_message::ProtocolVersion", required, tag = "1")]
    pub protocol_version: i32,
    /// source and destination ids identify the origin and destination of the
    /// message.  They are used to route messages between endpoints that share a
    /// device-to-device channel.
    ///
    /// For messages between applications:
    ///    - The sender application id is a unique identifier generated on behalf of
    ///      the sender application.
    ///    - The receiver id is always the the session id for the application.
    ///
    /// For messages to or from the sender or receiver platform, the special ids
    /// 'sender-0' and 'receiver-0' can be used.
    ///
    /// For messages intended for all endpoints using a given channel, the
    /// wildcard destination_id '*' can be used.
    #[prost(string, required, tag = "2")]
    pub source_id: ::prost::alloc::string::String,
    #[prost(string, required, tag = "3")]
    pub destination_id: ::prost::alloc::string::String,
    /// This is the core multiplexing key.  All messages are sent on a namespace
    /// and endpoints sharing a channel listen on one or more namespaces.  The
    /// namespace defines the protocol and semantics of the message.
    #[prost(string, required, tag = "4")]
    pub namespace: ::prost::alloc::string::String,
    #[prost(enumeration = "cast_message::PayloadType", required, tag = "5")]
    pub payload_type: i32,
    /// Depending on payload_type, exactly one of the following optional fields
    /// will always be set.
    #[prost(string, optional, tag = "6")]
    pub payload_utf8: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(bytes = "vec", optional, tag = "7")]
    pub payload_binary: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
    /// Flag indicating whether there are more chunks to follow for this message.
    /// If the flag is false or is not present, then this is the last (or only)
    /// chunk of the message.
    #[prost(bool, optional, tag = "8")]
    pub continued: ::core::option::Option<bool>,
    /// If this is a chunk of a larger message, and the remaining length of the
    /// message payload (the sum of the lengths of the payloads of the remaining
    /// chunks) is known, this field will indicate that length. For a given
    /// chunked message, this field should either be present in all of the chunks,
    /// or in none of them.
    #[prost(uint32, optional, tag = "9")]
    pub remaining_length: ::core::option::Option<u32>,
}
/// Nested message and enum types in `CastMessage`.
pub mod cast_message {
    /// Always pass a version of the protocol for future compatibility
    /// requirements.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum ProtocolVersion {
        Castv210 = 0,
        /// message chunking support (deprecated).
        Castv211 = 1,
        /// reworked message chunking.
        Castv212 = 2,
        /// binary payload over utf8.
        Castv213 = 3,
    }
    impl ProtocolVersion {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                ProtocolVersion::Castv210 => "CASTV2_1_0",
                ProtocolVersion::Castv211 => "CASTV2_1_1",
                ProtocolVersion::Castv212 => "CASTV2_1_2",
                ProtocolVersion::Castv213 => "CASTV2_1_3",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "CASTV2_1_0" => Some(Self::Castv210),
                "CASTV2_1_1" => Some(Self::Castv211),
                "CASTV2_1_2" => Some(Self::Castv212),
                "CASTV2_1_3" => Some(Self::Castv213),
                _ => None,
            }
        }
    }
    /// What type of data do we have in this message.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum PayloadType {
        String = 0,
        Binary = 1,
    }
    impl PayloadType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                PayloadType::String => "STRING",
                PayloadType::Binary => "BINARY",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "STRING" => Some(Self::String),
                "BINARY" => Some(Self::Binary),
                _ => None,
            }
        }
    }
}
/// Messages for authentication protocol between a sender and a receiver.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AuthChallenge {
    #[prost(
        enumeration = "SignatureAlgorithm",
        optional,
        tag = "1",
        default = "RsassaPkcs1v15"
    )]
    pub signature_algorithm: ::core::option::Option<i32>,
    #[prost(bytes = "vec", optional, tag = "2")]
    pub sender_nonce: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
    #[prost(enumeration = "HashAlgorithm", optional, tag = "3", default = "Sha1")]
    pub hash_algorithm: ::core::option::Option<i32>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AuthResponse {
    #[prost(bytes = "vec", required, tag = "1")]
    pub signature: ::prost::alloc::vec::Vec<u8>,
    #[prost(bytes = "vec", required, tag = "2")]
    pub client_auth_certificate: ::prost::alloc::vec::Vec<u8>,
    #[prost(bytes = "vec", repeated, tag = "3")]
    pub intermediate_certificate: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
    #[prost(
        enumeration = "SignatureAlgorithm",
        optional,
        tag = "4",
        default = "RsassaPkcs1v15"
    )]
    pub signature_algorithm: ::core::option::Option<i32>,
    #[prost(bytes = "vec", optional, tag = "5")]
    pub sender_nonce: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
    #[prost(enumeration = "HashAlgorithm", optional, tag = "6", default = "Sha1")]
    pub hash_algorithm: ::core::option::Option<i32>,
    #[prost(bytes = "vec", optional, tag = "7")]
    pub crl: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct AuthError {
    #[prost(enumeration = "auth_error::ErrorType", required, tag = "1")]
    pub error_type: i32,
}
/// Nested message and enum types in `AuthError`.
pub mod auth_error {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum ErrorType {
        InternalError = 0,
        /// The underlying connection is not TLS
        NoTls = 1,
        SignatureAlgorithmUnavailable = 2,
    }
    impl ErrorType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                ErrorType::InternalError => "INTERNAL_ERROR",
                ErrorType::NoTls => "NO_TLS",
                ErrorType::SignatureAlgorithmUnavailable => "SIGNATURE_ALGORITHM_UNAVAILABLE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "INTERNAL_ERROR" => Some(Self::InternalError),
                "NO_TLS" => Some(Self::NoTls),
                "SIGNATURE_ALGORITHM_UNAVAILABLE" => Some(Self::SignatureAlgorithmUnavailable),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[allow(dead_code)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeviceAuthMessage {
    /// Request fields
    #[prost(message, optional, tag = "1")]
    pub challenge: ::core::option::Option<AuthChallenge>,
    /// Response fields
    #[prost(message, optional, tag = "2")]
    pub response: ::core::option::Option<AuthResponse>,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<AuthError>,
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum SignatureAlgorithm {
    Unspecified = 0,
    RsassaPkcs1v15 = 1,
    RsassaPss = 2,
}
impl SignatureAlgorithm {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            SignatureAlgorithm::Unspecified => "UNSPECIFIED",
            SignatureAlgorithm::RsassaPkcs1v15 => "RSASSA_PKCS1v15",
            SignatureAlgorithm::RsassaPss => "RSASSA_PSS",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "UNSPECIFIED" => Some(Self::Unspecified),
            "RSASSA_PKCS1v15" => Some(Self::RsassaPkcs1v15),
            "RSASSA_PSS" => Some(Self::RsassaPss),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum HashAlgorithm {
    Sha1 = 0,
    Sha256 = 1,
}
impl HashAlgorithm {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            HashAlgorithm::Sha1 => "SHA1",
            HashAlgorithm::Sha256 => "SHA256",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "SHA1" => Some(Self::Sha1),
            "SHA256" => Some(Self::Sha256),
            _ => None,
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[allow(dead_code)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AuthorityKeys {
    #[prost(message, repeated, tag = "1")]
    pub keys: ::prost::alloc::vec::Vec<authority_keys::Key>,
}
/// Nested message and enum types in `AuthorityKeys`.
pub mod authority_keys {
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[allow(dead_code)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Key {
        #[prost(bytes = "vec", required, tag = "1")]
        pub fingerprint: ::prost::alloc::vec::Vec<u8>,
        #[prost(bytes = "vec", required, tag = "2")]
        pub public_key: ::prost::alloc::vec::Vec<u8>,
    }
}
