/* ShortcutListBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ShortcutListBox.vala, do not modify */

/*
* Copyright 2022 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include "keyboard.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define KEYBOARD_SHORTCUTS_TYPE_SHORTCUT_LIST_BOX (keyboard_shortcuts_shortcut_list_box_get_type ())
#define KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_SHORTCUTS_TYPE_SHORTCUT_LIST_BOX, KeyboardShortcutsShortcutListBox))
#define KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_SHORTCUTS_TYPE_SHORTCUT_LIST_BOX, KeyboardShortcutsShortcutListBoxClass))
#define KEYBOARD_SHORTCUTS_IS_SHORTCUT_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_SHORTCUTS_TYPE_SHORTCUT_LIST_BOX))
#define KEYBOARD_SHORTCUTS_IS_SHORTCUT_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_SHORTCUTS_TYPE_SHORTCUT_LIST_BOX))
#define KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_SHORTCUTS_TYPE_SHORTCUT_LIST_BOX, KeyboardShortcutsShortcutListBoxClass))

typedef struct _KeyboardShortcutsShortcutListBox KeyboardShortcutsShortcutListBox;
typedef struct _KeyboardShortcutsShortcutListBoxClass KeyboardShortcutsShortcutListBoxClass;
typedef struct _KeyboardShortcutsShortcutListBoxPrivate KeyboardShortcutsShortcutListBoxPrivate;
typedef enum  {
	KEYBOARD_SHORTCUTS_SCHEMA_WM,
	KEYBOARD_SHORTCUTS_SCHEMA_MUTTER,
	KEYBOARD_SHORTCUTS_SCHEMA_GALA,
	KEYBOARD_SHORTCUTS_SCHEMA_MEDIA,
	KEYBOARD_SHORTCUTS_SCHEMA_SOUND_INDICATOR,
	KEYBOARD_SHORTCUTS_SCHEMA_IBUS,
	KEYBOARD_SHORTCUTS_SCHEMA_DOCK,
	KEYBOARD_SHORTCUTS_SCHEMA_COUNT
} KeyboardShortcutsSchema;

#define KEYBOARD_SHORTCUTS_TYPE_SCHEMA (keyboard_shortcuts_schema_get_type ())
enum  {
	KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_0_PROPERTY,
	KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_GROUP_PROPERTY,
	KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* keyboard_shortcuts_shortcut_list_box_properties[KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_NUM_PROPERTIES];

#define KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_TYPE_SHORTCUT_ROW (keyboard_shortcuts_shortcut_list_box_shortcut_row_get_type ())
#define KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_TYPE_SHORTCUT_ROW, KeyboardShortcutsShortcutListBoxShortcutRow))
#define KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_TYPE_SHORTCUT_ROW, KeyboardShortcutsShortcutListBoxShortcutRowClass))
#define KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_IS_SHORTCUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_TYPE_SHORTCUT_ROW))
#define KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_IS_SHORTCUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_TYPE_SHORTCUT_ROW))
#define KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_TYPE_SHORTCUT_ROW, KeyboardShortcutsShortcutListBoxShortcutRowClass))

typedef struct _KeyboardShortcutsShortcutListBoxShortcutRow KeyboardShortcutsShortcutListBoxShortcutRow;
typedef struct _KeyboardShortcutsShortcutListBoxShortcutRowClass KeyboardShortcutsShortcutListBoxShortcutRowClass;
typedef struct _KeyboardShortcutsShortcutListBoxShortcutRowPrivate KeyboardShortcutsShortcutListBoxShortcutRowPrivate;
enum  {
	KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_0_PROPERTY,
	KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_ACTION_PROPERTY,
	KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_SCHEMA_PROPERTY,
	KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_GSETTINGS_KEY_PROPERTY,
	KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_NUM_PROPERTIES
};
static GParamSpec* keyboard_shortcuts_shortcut_list_box_shortcut_row_properties[KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;

#define KEYBOARD_SHORTCUTS_TYPE_SETTINGS (keyboard_shortcuts_settings_get_type ())
#define KEYBOARD_SHORTCUTS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_SHORTCUTS_TYPE_SETTINGS, KeyboardShortcutsSettings))
#define KEYBOARD_SHORTCUTS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_SHORTCUTS_TYPE_SETTINGS, KeyboardShortcutsSettingsClass))
#define KEYBOARD_SHORTCUTS_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_SHORTCUTS_TYPE_SETTINGS))
#define KEYBOARD_SHORTCUTS_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_SHORTCUTS_TYPE_SETTINGS))
#define KEYBOARD_SHORTCUTS_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_SHORTCUTS_TYPE_SETTINGS, KeyboardShortcutsSettingsClass))

typedef struct _KeyboardShortcutsSettings KeyboardShortcutsSettings;
typedef struct _KeyboardShortcutsSettingsClass KeyboardShortcutsSettingsClass;
typedef struct _KeyboardShortcutsSettingsPrivate KeyboardShortcutsSettingsPrivate;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block23Data Block23Data;

#define KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST (keyboard_shortcuts_shortcuts_list_get_type ())
#define KEYBOARD_SHORTCUTS_SHORTCUTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST, KeyboardShortcutsShortcutsList))
#define KEYBOARD_SHORTCUTS_SHORTCUTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST, KeyboardShortcutsShortcutsListClass))
#define KEYBOARD_SHORTCUTS_IS_SHORTCUTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST))
#define KEYBOARD_SHORTCUTS_IS_SHORTCUTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST))
#define KEYBOARD_SHORTCUTS_SHORTCUTS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST, KeyboardShortcutsShortcutsListClass))

typedef struct _KeyboardShortcutsShortcutsList KeyboardShortcutsShortcutsList;
typedef struct _KeyboardShortcutsShortcutsListClass KeyboardShortcutsShortcutsListClass;

struct _KeyboardShortcutsShortcutListBox {
	GtkBox parent_instance;
	KeyboardShortcutsShortcutListBoxPrivate * priv;
};

struct _KeyboardShortcutsShortcutListBoxClass {
	GtkBoxClass parent_class;
};

struct _KeyboardShortcutsShortcutListBoxPrivate {
	KeyboardShortcutsSectionID _group;
	gchar** actions;
	gint actions_length1;
	gint _actions_size_;
	KeyboardShortcutsSchema* schemas;
	gint schemas_length1;
	gint _schemas_size_;
	gchar** keys;
	gint keys_length1;
	gint _keys_size_;
};

struct _KeyboardShortcutsShortcutListBoxShortcutRow {
	GtkListBoxRow parent_instance;
	KeyboardShortcutsShortcutListBoxShortcutRowPrivate * priv;
};

struct _KeyboardShortcutsShortcutListBoxShortcutRowClass {
	GtkListBoxRowClass parent_class;
};

struct _KeyboardShortcutsShortcutListBoxShortcutRowPrivate {
	gchar* _action;
	KeyboardShortcutsSchema _schema;
	gchar* _gsettings_key;
	GtkButton* clear_button;
	GtkButton* reset_button;
	GtkBox* keycap_box;
	GtkLabel* status_label;
	GtkStack* keycap_stack;
	gboolean is_editing_shortcut;
	GdkDevice* keyboard_device;
};

struct _Block21Data {
	int _ref_count_;
	KeyboardShortcutsShortcutListBoxShortcutRow* self;
	GtkEventControllerFocus* focus_controller;
};

struct _Block22Data {
	int _ref_count_;
	KeyboardShortcutsShortcutListBoxShortcutRow* self;
	GraniteMessageDialog* message_dialog;
};

struct _KeyboardShortcutsSettings {
	GObject parent_instance;
	KeyboardShortcutsSettingsPrivate * priv;
	GSettings** schemas;
	gint schemas_length1;
	gint _schemas_size_;
};

struct _KeyboardShortcutsSettingsClass {
	GObjectClass parent_class;
};

struct _Block23Data {
	int _ref_count_;
	KeyboardShortcutsShortcutListBoxShortcutRow* self;
	GtkPopover* popover;
	KeyboardShortcutsSettings* settings;
};

static gint KeyboardShortcutsShortcutListBox_private_offset;
static gpointer keyboard_shortcuts_shortcut_list_box_parent_class = NULL;
static gint KeyboardShortcutsShortcutListBoxShortcutRow_private_offset;
static gpointer keyboard_shortcuts_shortcut_list_box_shortcut_row_parent_class = NULL;

VALA_EXTERN GType keyboard_shortcuts_shortcut_list_box_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType keyboard_shortcuts_schema_get_type (void) G_GNUC_CONST ;
VALA_EXTERN KeyboardShortcutsShortcutListBox* keyboard_shortcuts_shortcut_list_box_new (KeyboardShortcutsSectionID group);
VALA_EXTERN KeyboardShortcutsShortcutListBox* keyboard_shortcuts_shortcut_list_box_construct (GType object_type,
                                                                                  KeyboardShortcutsSectionID group);
VALA_EXTERN KeyboardShortcutsSectionID keyboard_shortcuts_shortcut_list_box_get_group (KeyboardShortcutsShortcutListBox* self);
static void keyboard_shortcuts_shortcut_list_box_set_group (KeyboardShortcutsShortcutListBox* self,
                                                     KeyboardShortcutsSectionID value);
static GType keyboard_shortcuts_shortcut_list_box_shortcut_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static KeyboardShortcutsShortcutListBoxShortcutRow* keyboard_shortcuts_shortcut_list_box_shortcut_row_new (const gchar* action,
                                                                                                    KeyboardShortcutsSchema schema,
                                                                                                    const gchar* gsettings_key);
static KeyboardShortcutsShortcutListBoxShortcutRow* keyboard_shortcuts_shortcut_list_box_shortcut_row_construct (GType object_type,
                                                                                                          const gchar* action,
                                                                                                          KeyboardShortcutsSchema schema,
                                                                                                          const gchar* gsettings_key);
static void keyboard_shortcuts_shortcut_list_box_shortcut_row_edit_shortcut (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                                      gboolean start_editing);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static void ___lambda59_ (Block21Data* _data21_);
static void ____lambda59__gtk_event_controller_focus_leave (GtkEventControllerFocus* _sender,
                                                     gpointer self);
static void keyboard_shortcuts_shortcut_list_box_shortcut_row_render_keycaps (KeyboardShortcutsShortcutListBoxShortcutRow* self);
static void keyboard_shortcuts_shortcut_list_box_shortcut_row_on_key_released (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                                        GtkEventControllerKey* controller,
                                                                        guint keyval,
                                                                        guint keycode,
                                                                        GdkModifierType state);
static void keyboard_shortcuts_shortcut_list_box_shortcut_row_update_binding (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                                       KeyboardShortcutsShortcut* shortcut);
VALA_EXTERN gboolean keyboard_shortcuts_conflicts_manager_shortcut_conflicts (KeyboardShortcutsShortcut* shortcut,
                                                                  gchar** name,
                                                                  gchar** group);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void ___lambda60_ (Block22Data* _data22_);
static void ____lambda60__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
VALA_EXTERN GType keyboard_shortcuts_settings_get_type (void) G_GNUC_CONST ;
VALA_EXTERN KeyboardShortcutsSettings* keyboard_shortcuts_settings_get_default (void);
static KeyboardShortcutsSchema keyboard_shortcuts_shortcut_list_box_shortcut_row_get_schema (KeyboardShortcutsShortcutListBoxShortcutRow* self);
static const gchar* keyboard_shortcuts_shortcut_list_box_shortcut_row_get_gsettings_key (KeyboardShortcutsShortcutListBoxShortcutRow* self);
static const gchar* keyboard_shortcuts_shortcut_list_box_shortcut_row_get_action (KeyboardShortcutsShortcutListBoxShortcutRow* self);
static void keyboard_shortcuts_shortcut_list_box_shortcut_row_set_action (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                                   const gchar* value);
static void keyboard_shortcuts_shortcut_list_box_shortcut_row_set_schema (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                                   KeyboardShortcutsSchema value);
static void keyboard_shortcuts_shortcut_list_box_shortcut_row_set_gsettings_key (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                                          const gchar* value);
static GObject * keyboard_shortcuts_shortcut_list_box_shortcut_row_constructor (GType type,
                                                                         guint n_construct_properties,
                                                                         GObjectConstructParam * construct_properties);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void _keyboard_shortcuts_shortcut_list_box_shortcut_row_render_keycaps_g_settings_changed (GSettings* _sender,
                                                                                           const gchar* key,
                                                                                           gpointer self);
static void _keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda61_ (Block23Data* _data23_);
static void __keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda61__gtk_button_clicked (GtkButton* _sender,
                                                                                         gpointer self);
static void _keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda62_ (Block23Data* _data23_);
static void __keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda62__gtk_button_clicked (GtkButton* _sender,
                                                                                         gpointer self);
static void _keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda63_ (Block23Data* _data23_);
static void __keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda63__gtk_button_clicked (GtkButton* _sender,
                                                                                         gpointer self);
static void _keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda64_ (KeyboardShortcutsShortcutListBoxShortcutRow* self);
static void __keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda64__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                                 gint n_press,
                                                                                                 gdouble x,
                                                                                                 gdouble y,
                                                                                                 gpointer self);
static void _keyboard_shortcuts_shortcut_list_box_shortcut_row_on_key_released_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                                               guint keyval,
                                                                                                               guint keycode,
                                                                                                               GdkModifierType state,
                                                                                                               gpointer self);
static void keyboard_shortcuts_shortcut_list_box_shortcut_row_finalize (GObject * obj);
static GType keyboard_shortcuts_shortcut_list_box_shortcut_row_get_type_once (void);
static void _vala_keyboard_shortcuts_shortcut_list_box_shortcut_row_get_property (GObject * object,
                                                                           guint property_id,
                                                                           GValue * value,
                                                                           GParamSpec * pspec);
static void _vala_keyboard_shortcuts_shortcut_list_box_shortcut_row_set_property (GObject * object,
                                                                           guint property_id,
                                                                           const GValue * value,
                                                                           GParamSpec * pspec);
static GObject * keyboard_shortcuts_shortcut_list_box_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties);
VALA_EXTERN GType keyboard_shortcuts_shortcuts_list_get_type (void) G_GNUC_CONST ;
VALA_EXTERN KeyboardShortcutsShortcutsList* keyboard_shortcuts_shortcuts_list_get_default (void);
VALA_EXTERN void keyboard_shortcuts_shortcuts_list_get_group (KeyboardShortcutsShortcutsList* self,
                                                  KeyboardShortcutsSectionID group,
                                                  gchar*** a,
                                                  gint* a_length1,
                                                  KeyboardShortcutsSchema** s,
                                                  gint* s_length1,
                                                  gchar*** k,
                                                  gint* k_length1);
VALA_EXTERN gboolean keyboard_shortcuts_settings_valid (KeyboardShortcutsSettings* self,
                                            KeyboardShortcutsSchema schema,
                                            const gchar* key);
static void keyboard_shortcuts_shortcut_list_box_finalize (GObject * obj);
static GType keyboard_shortcuts_shortcut_list_box_get_type_once (void);
static void _vala_keyboard_shortcuts_shortcut_list_box_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_keyboard_shortcuts_shortcut_list_box_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
keyboard_shortcuts_shortcut_list_box_get_instance_private (KeyboardShortcutsShortcutListBox* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardShortcutsShortcutListBox_private_offset);
}

KeyboardShortcutsShortcutListBox*
keyboard_shortcuts_shortcut_list_box_construct (GType object_type,
                                                KeyboardShortcutsSectionID group)
{
	KeyboardShortcutsShortcutListBox * self = NULL;
	self = (KeyboardShortcutsShortcutListBox*) g_object_new (object_type, "group", group, NULL);
	return self;
}

KeyboardShortcutsShortcutListBox*
keyboard_shortcuts_shortcut_list_box_new (KeyboardShortcutsSectionID group)
{
	return keyboard_shortcuts_shortcut_list_box_construct (KEYBOARD_SHORTCUTS_TYPE_SHORTCUT_LIST_BOX, group);
}

KeyboardShortcutsSectionID
keyboard_shortcuts_shortcut_list_box_get_group (KeyboardShortcutsShortcutListBox* self)
{
	KeyboardShortcutsSectionID result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_group;
	return result;
}

static void
keyboard_shortcuts_shortcut_list_box_set_group (KeyboardShortcutsShortcutListBox* self,
                                                KeyboardShortcutsSectionID value)
{
	KeyboardShortcutsSectionID old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_shortcuts_shortcut_list_box_get_group (self);
	if (old_value != value) {
		self->priv->_group = value;
		g_object_notify_by_pspec ((GObject *) self, keyboard_shortcuts_shortcut_list_box_properties[KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_GROUP_PROPERTY]);
	}
}

static inline gpointer
keyboard_shortcuts_shortcut_list_box_shortcut_row_get_instance_private (KeyboardShortcutsShortcutListBoxShortcutRow* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardShortcutsShortcutListBoxShortcutRow_private_offset);
}

static KeyboardShortcutsShortcutListBoxShortcutRow*
keyboard_shortcuts_shortcut_list_box_shortcut_row_construct (GType object_type,
                                                             const gchar* action,
                                                             KeyboardShortcutsSchema schema,
                                                             const gchar* gsettings_key)
{
	KeyboardShortcutsShortcutListBoxShortcutRow * self = NULL;
	g_return_val_if_fail (action != NULL, NULL);
	g_return_val_if_fail (gsettings_key != NULL, NULL);
	self = (KeyboardShortcutsShortcutListBoxShortcutRow*) g_object_new (object_type, "action", action, "schema", schema, "gsettings-key", gsettings_key, NULL);
	return self;
}

static KeyboardShortcutsShortcutListBoxShortcutRow*
keyboard_shortcuts_shortcut_list_box_shortcut_row_new (const gchar* action,
                                                       KeyboardShortcutsSchema schema,
                                                       const gchar* gsettings_key)
{
	return keyboard_shortcuts_shortcut_list_box_shortcut_row_construct (KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_TYPE_SHORTCUT_ROW, action, schema, gsettings_key);
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		KeyboardShortcutsShortcutListBoxShortcutRow* self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->focus_controller);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static void
___lambda59_ (Block21Data* _data21_)
{
	KeyboardShortcutsShortcutListBoxShortcutRow* self;
	GtkEventControllerFocus* _tmp0_;
	self = _data21_->self;
	_tmp0_ = _data21_->focus_controller;
	g_object_run_dispose ((GObject*) _tmp0_);
	keyboard_shortcuts_shortcut_list_box_shortcut_row_edit_shortcut (self, FALSE);
}

static void
____lambda59__gtk_event_controller_focus_leave (GtkEventControllerFocus* _sender,
                                                gpointer self)
{
	___lambda59_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
keyboard_shortcuts_shortcut_list_box_shortcut_row_edit_shortcut (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                                 gboolean start_editing)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (start_editing) {
		_tmp0_ = !self->priv->is_editing_shortcut;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Block21Data* _data21_;
		GtkRoot* _tmp1_;
		GdkSurface* _tmp2_;
		GtkStack* _tmp3_;
		GtkLabel* _tmp4_;
		GtkLabel* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		GtkEventControllerFocus* _tmp8_;
		GtkEventControllerFocus* _tmp9_;
		GtkEventControllerFocus* _tmp10_;
		GtkEventController* _tmp11_;
		_data21_ = g_slice_new0 (Block21Data);
		_data21_->_ref_count_ = 1;
		_data21_->self = g_object_ref (self);
		_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp2_ = gtk_native_get_surface ((GtkNative*) _tmp1_);
		gdk_toplevel_inhibit_system_shortcuts (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gdk_toplevel_get_type (), GdkToplevel), NULL);
		_tmp3_ = self->priv->keycap_stack;
		_tmp4_ = self->priv->status_label;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->status_label;
		gtk_label_set_label (_tmp5_, _ ("Enter new shortcut…"));
		_tmp6_ = gtk_widget_get_parent ((GtkWidget*) self);
		_tmp7_ = _tmp6_;
		gtk_list_box_select_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_list_box_get_type (), GtkListBox), (GtkListBoxRow*) self);
		gtk_widget_grab_focus ((GtkWidget*) self);
		_tmp8_ = (GtkEventControllerFocus*) gtk_event_controller_focus_new ();
		_data21_->focus_controller = _tmp8_;
		_tmp9_ = _data21_->focus_controller;
		g_signal_connect_data (_tmp9_, "leave", (GCallback) ____lambda59__gtk_event_controller_focus_leave, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
		_tmp10_ = _data21_->focus_controller;
		_tmp11_ = _g_object_ref0 ((GtkEventController*) _tmp10_);
		gtk_widget_add_controller ((GtkWidget*) self, _tmp11_);
		block21_data_unref (_data21_);
		_data21_ = NULL;
	} else {
		gboolean _tmp12_ = FALSE;
		if (!start_editing) {
			_tmp12_ = self->priv->is_editing_shortcut;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			GtkRoot* _tmp13_;
			GdkSurface* _tmp14_;
			_tmp13_ = gtk_widget_get_root ((GtkWidget*) self);
			_tmp14_ = gtk_native_get_surface ((GtkNative*) _tmp13_);
			gdk_toplevel_restore_system_shortcuts (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gdk_toplevel_get_type (), GdkToplevel));
			keyboard_shortcuts_shortcut_list_box_shortcut_row_render_keycaps (self);
		}
	}
	self->priv->is_editing_shortcut = start_editing;
}

static void
keyboard_shortcuts_shortcut_list_box_shortcut_row_on_key_released (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                                   GtkEventControllerKey* controller,
                                                                   guint keyval,
                                                                   guint keycode,
                                                                   GdkModifierType state)
{
	GdkModifierType mods = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	if (!self->priv->is_editing_shortcut) {
		return;
	}
	mods = state & gtk_accelerator_get_default_mod_mask ();
	if (mods > 0) {
		KeyboardShortcutsShortcut* shortcut = NULL;
		KeyboardShortcutsShortcut* _tmp0_;
		KeyboardShortcutsShortcut* _tmp1_;
		_tmp0_ = keyboard_shortcuts_shortcut_new (keyval, mods);
		shortcut = _tmp0_;
		_tmp1_ = shortcut;
		keyboard_shortcuts_shortcut_list_box_shortcut_row_update_binding (self, _tmp1_);
		_g_object_unref0 (shortcut);
	} else {
		switch (keyval) {
			case GDK_KEY_Escape:
			{
				break;
			}
			case GDK_KEY_F2:
			case GDK_KEY_F3:
			case GDK_KEY_F4:
			case GDK_KEY_F5:
			case GDK_KEY_F6:
			case GDK_KEY_F7:
			case GDK_KEY_F8:
			case GDK_KEY_F9:
			case GDK_KEY_F10:
			case GDK_KEY_F12:
			case GDK_KEY_Menu:
			case GDK_KEY_Print:
			case GDK_KEY_Mail:
			case GDK_KEY_Explorer:
			case GDK_KEY_AudioMedia:
			case GDK_KEY_WWW:
			case GDK_KEY_AudioRaiseVolume:
			case GDK_KEY_AudioLowerVolume:
			case GDK_KEY_AudioMute:
			case GDK_KEY_AudioPlay:
			case GDK_KEY_AudioPause:
			case GDK_KEY_AudioStop:
			case GDK_KEY_AudioPrev:
			case GDK_KEY_AudioNext:
			case GDK_KEY_Eject:
			{
				KeyboardShortcutsShortcut* shortcut = NULL;
				KeyboardShortcutsShortcut* _tmp2_;
				KeyboardShortcutsShortcut* _tmp3_;
				_tmp2_ = keyboard_shortcuts_shortcut_new (keyval, mods);
				shortcut = _tmp2_;
				_tmp3_ = shortcut;
				keyboard_shortcuts_shortcut_list_box_shortcut_row_update_binding (self, _tmp3_);
				_g_object_unref0 (shortcut);
				break;
			}
			default:
			{
				return;
			}
		}
	}
	keyboard_shortcuts_shortcut_list_box_shortcut_row_edit_shortcut (self, FALSE);
	keyboard_shortcuts_shortcut_list_box_shortcut_row_render_keycaps (self);
	return;
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		KeyboardShortcutsShortcutListBoxShortcutRow* self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->message_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static void
___lambda60_ (Block22Data* _data22_)
{
	KeyboardShortcutsShortcutListBoxShortcutRow* self;
	GraniteMessageDialog* _tmp0_;
	self = _data22_->self;
	_tmp0_ = _data22_->message_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
____lambda60__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda60_ (self);
}

static void
keyboard_shortcuts_shortcut_list_box_shortcut_row_update_binding (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                                  KeyboardShortcutsShortcut* shortcut)
{
	gchar* conflict_name = NULL;
	gchar* _tmp0_;
	gchar* group = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (shortcut != NULL);
	_tmp0_ = g_strdup ("");
	conflict_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	group = _tmp1_;
	_tmp4_ = keyboard_shortcuts_conflicts_manager_shortcut_conflicts (shortcut, &_tmp2_, &_tmp3_);
	_g_free0 (conflict_name);
	conflict_name = _tmp2_;
	_g_free0 (group);
	group = _tmp3_;
	if (_tmp4_) {
		Block22Data* _data22_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GThemedIcon* _tmp11_;
		GThemedIcon* _tmp12_;
		GThemedIcon* _tmp13_;
		GtkRoot* _tmp14_;
		GtkWindow* _tmp15_;
		GraniteMessageDialog* _tmp16_ = NULL;
		GraniteMessageDialog* _tmp17_;
		GraniteMessageDialog* _tmp18_;
		GraniteMessageDialog* _tmp19_;
		_data22_ = g_slice_new0 (Block22Data);
		_data22_->_ref_count_ = 1;
		_data22_->self = g_object_ref (self);
		_tmp5_ = keyboard_shortcuts_shortcut_to_readable (shortcut);
		_tmp6_ = _tmp5_;
		_tmp7_ = group;
		_tmp8_ = conflict_name;
		_tmp9_ = g_strdup_printf (_ ("“%s” is already used for “%s → %s”."), _tmp6_, _tmp7_, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = (GThemedIcon*) g_themed_icon_new ("preferences-desktop-keyboard");
		_tmp12_ = _tmp11_;
		_tmp13_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp14_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_window_get_type (), GtkWindow));
		_tmp16_ = granite_message_dialog_new (_ ("Unable to set new shortcut due to conflicts"), _tmp10_, (GIcon*) _tmp12_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp16_, (GIcon*) _tmp13_);
		_g_object_unref0 (_tmp13_);
		gtk_window_set_modal ((GtkWindow*) _tmp16_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp16_, _tmp15_);
		_g_object_unref0 (_tmp15_);
		g_object_ref_sink (_tmp16_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp6_);
		_data22_->message_dialog = _tmp17_;
		_tmp18_ = _data22_->message_dialog;
		g_signal_connect_data ((GtkDialog*) _tmp18_, "response", (GCallback) ____lambda60__gtk_dialog_response, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
		_tmp19_ = _data22_->message_dialog;
		gtk_window_present ((GtkWindow*) _tmp19_);
		block22_data_unref (_data22_);
		_data22_ = NULL;
	} else {
		KeyboardShortcutsSettings* settings = NULL;
		KeyboardShortcutsSettings* _tmp20_;
		GVariant* key_value = NULL;
		KeyboardShortcutsSettings* _tmp21_;
		GSettings** _tmp22_;
		gint _tmp22__length1;
		KeyboardShortcutsSchema _tmp23_;
		GSettings* _tmp24_;
		const gchar* _tmp25_;
		GVariant* _tmp26_;
		GVariant* _tmp27_;
		const GVariantType* _tmp28_;
		_tmp20_ = keyboard_shortcuts_settings_get_default ();
		settings = _tmp20_;
		_tmp21_ = settings;
		_tmp22_ = _tmp21_->schemas;
		_tmp22__length1 = _tmp21_->schemas_length1;
		_tmp23_ = self->priv->_schema;
		_tmp24_ = _tmp22_[_tmp23_];
		_tmp25_ = self->priv->_gsettings_key;
		_tmp26_ = g_settings_get_value (_tmp24_, _tmp25_);
		key_value = _tmp26_;
		_tmp27_ = key_value;
		_tmp28_ = G_VARIANT_TYPE_ARRAY;
		if (g_variant_is_of_type (_tmp27_, _tmp28_)) {
			KeyboardShortcutsSettings* _tmp29_;
			GSettings** _tmp30_;
			gint _tmp30__length1;
			KeyboardShortcutsSchema _tmp31_;
			GSettings* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar** _tmp35_;
			gchar** _tmp36_;
			gint _tmp36__length1;
			_tmp29_ = settings;
			_tmp30_ = _tmp29_->schemas;
			_tmp30__length1 = _tmp29_->schemas_length1;
			_tmp31_ = self->priv->_schema;
			_tmp32_ = _tmp30_[_tmp31_];
			_tmp33_ = self->priv->_gsettings_key;
			_tmp34_ = keyboard_shortcuts_shortcut_to_gsettings (shortcut);
			_tmp35_ = g_new0 (gchar*, 1 + 1);
			_tmp35_[0] = _tmp34_;
			_tmp36_ = _tmp35_;
			_tmp36__length1 = 1;
			g_settings_set_strv (_tmp32_, _tmp33_, _tmp36_);
			_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
		} else {
			KeyboardShortcutsSettings* _tmp37_;
			GSettings** _tmp38_;
			gint _tmp38__length1;
			KeyboardShortcutsSchema _tmp39_;
			GSettings* _tmp40_;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp37_ = settings;
			_tmp38_ = _tmp37_->schemas;
			_tmp38__length1 = _tmp37_->schemas_length1;
			_tmp39_ = self->priv->_schema;
			_tmp40_ = _tmp38_[_tmp39_];
			_tmp41_ = self->priv->_gsettings_key;
			_tmp42_ = keyboard_shortcuts_shortcut_to_gsettings (shortcut);
			_tmp43_ = _tmp42_;
			g_settings_set_string (_tmp40_, _tmp41_, _tmp43_);
			_g_free0 (_tmp43_);
		}
		_g_variant_unref0 (key_value);
	}
	_g_free0 (group);
	_g_free0 (conflict_name);
}

static void
keyboard_shortcuts_shortcut_list_box_shortcut_row_render_keycaps (KeyboardShortcutsShortcutListBoxShortcutRow* self)
{
	KeyboardShortcutsSettings* settings = NULL;
	KeyboardShortcutsSettings* _tmp0_;
	GVariant* key_value = NULL;
	KeyboardShortcutsSettings* _tmp1_;
	GSettings** _tmp2_;
	gint _tmp2__length1;
	KeyboardShortcutsSchema _tmp3_;
	GSettings* _tmp4_;
	const gchar* _tmp5_;
	GVariant* _tmp6_;
	gchar** accels = NULL;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint accels_length1;
	gint _accels_size_;
	GVariant* _tmp9_;
	const GVariantType* _tmp10_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	const gchar* _tmp35_;
	KeyboardShortcutsSettings* _tmp55_;
	GSettings** _tmp56_;
	gint _tmp56__length1;
	KeyboardShortcutsSchema _tmp57_;
	GSettings* _tmp58_;
	const gchar* _tmp59_;
	GVariant* _tmp60_;
	GVariant* _tmp61_;
	gboolean _tmp62_;
	g_return_if_fail (self != NULL);
	_tmp0_ = keyboard_shortcuts_settings_get_default ();
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = _tmp1_->schemas;
	_tmp2__length1 = _tmp1_->schemas_length1;
	_tmp3_ = self->priv->_schema;
	_tmp4_ = _tmp2_[_tmp3_];
	_tmp5_ = self->priv->_gsettings_key;
	_tmp6_ = g_settings_get_value (_tmp4_, _tmp5_);
	key_value = _tmp6_;
	_tmp7_ = g_strdup ("");
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	accels = _tmp8_;
	accels_length1 = 1;
	_accels_size_ = accels_length1;
	_tmp9_ = key_value;
	_tmp10_ = G_VARIANT_TYPE_ARRAY;
	if (g_variant_is_of_type (_tmp9_, _tmp10_)) {
		const gchar** key_value_strv = NULL;
		GVariant* _tmp11_;
		gsize _tmp12_ = 0;
		const gchar** _tmp13_;
		gint key_value_strv_length1;
		gint _key_value_strv_size_;
		gboolean _tmp14_ = FALSE;
		const gchar** _tmp15_;
		gint _tmp15__length1;
		_tmp11_ = key_value;
		_tmp13_ = g_variant_get_strv (_tmp11_, &_tmp12_);
		key_value_strv = _tmp13_;
		key_value_strv_length1 = _tmp12_;
		_key_value_strv_size_ = key_value_strv_length1;
		_tmp15_ = key_value_strv;
		_tmp15__length1 = key_value_strv_length1;
		if (_tmp15__length1 > 0) {
			const gchar** _tmp16_;
			gint _tmp16__length1;
			const gchar* _tmp17_;
			_tmp16_ = key_value_strv;
			_tmp16__length1 = key_value_strv_length1;
			_tmp17_ = _tmp16_[0];
			_tmp14_ = g_strcmp0 (_tmp17_, "") != 0;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			gchar* accels_string = NULL;
			const gchar** _tmp18_;
			gint _tmp18__length1;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp18_ = key_value_strv;
			_tmp18__length1 = key_value_strv_length1;
			_tmp19_ = _tmp18_[0];
			_tmp20_ = granite_accel_to_string (_tmp19_);
			accels_string = _tmp20_;
			_tmp21_ = accels_string;
			if (_tmp21_ != NULL) {
				const gchar* _tmp22_;
				gchar** _tmp23_;
				gchar** _tmp24_;
				_tmp22_ = accels_string;
				_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, " + ", 0);
				accels = (_vala_array_free (accels, accels_length1, (GDestroyNotify) g_free), NULL);
				accels = _tmp24_;
				accels_length1 = _vala_array_length (_tmp23_);
				_accels_size_ = accels_length1;
			}
			_g_free0 (accels_string);
		}
		key_value_strv = (g_free (key_value_strv), NULL);
	} else {
		gchar* value_string = NULL;
		GVariant* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		_tmp25_ = key_value;
		_tmp26_ = g_variant_dup_string (_tmp25_, NULL);
		value_string = _tmp26_;
		_tmp27_ = value_string;
		if (g_strcmp0 (_tmp27_, "") != 0) {
			gchar* accels_string = NULL;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			_tmp28_ = value_string;
			_tmp29_ = granite_accel_to_string (_tmp28_);
			accels_string = _tmp29_;
			_tmp30_ = accels_string;
			if (_tmp30_ != NULL) {
				const gchar* _tmp31_;
				gchar** _tmp32_;
				gchar** _tmp33_;
				_tmp31_ = accels_string;
				_tmp33_ = _tmp32_ = g_strsplit (_tmp31_, " + ", 0);
				accels = (_vala_array_free (accels, accels_length1, (GDestroyNotify) g_free), NULL);
				accels = _tmp33_;
				accels_length1 = _vala_array_length (_tmp32_);
				_accels_size_ = accels_length1;
			}
			_g_free0 (accels_string);
		}
		_g_free0 (value_string);
	}
	_tmp34_ = accels;
	_tmp34__length1 = accels_length1;
	_tmp35_ = _tmp34_[0];
	if (g_strcmp0 (_tmp35_, "") != 0) {
		gchar** _tmp41_;
		gint _tmp41__length1;
		GtkButton* _tmp48_;
		GtkStack* _tmp49_;
		GtkBox* _tmp50_;
		while (TRUE) {
			GtkBox* _tmp36_;
			GtkWidget* _tmp37_;
			GtkBox* _tmp38_;
			GtkBox* _tmp39_;
			GtkWidget* _tmp40_;
			_tmp36_ = self->priv->keycap_box;
			_tmp37_ = gtk_widget_get_first_child ((GtkWidget*) _tmp36_);
			if (!(_tmp37_ != NULL)) {
				break;
			}
			_tmp38_ = self->priv->keycap_box;
			_tmp39_ = self->priv->keycap_box;
			_tmp40_ = gtk_widget_get_first_child ((GtkWidget*) _tmp39_);
			gtk_box_remove (_tmp38_, _tmp40_);
		}
		_tmp41_ = accels;
		_tmp41__length1 = accels_length1;
		{
			gchar** accel_collection = NULL;
			gint accel_collection_length1 = 0;
			gint _accel_collection_size_ = 0;
			gint accel_it = 0;
			accel_collection = _tmp41_;
			accel_collection_length1 = _tmp41__length1;
			for (accel_it = 0; accel_it < accel_collection_length1; accel_it = accel_it + 1) {
				const gchar* accel = NULL;
				accel = accel_collection[accel_it];
				{
					const gchar* _tmp42_;
					GtkLabel* keycap_label = NULL;
					const gchar* _tmp43_;
					GtkLabel* _tmp44_;
					GtkLabel* _tmp45_;
					GtkBox* _tmp46_;
					GtkLabel* _tmp47_;
					_tmp42_ = accel;
					if (g_strcmp0 (_tmp42_, "") == 0) {
						continue;
					}
					_tmp43_ = accel;
					_tmp44_ = (GtkLabel*) gtk_label_new (_tmp43_);
					g_object_ref_sink (_tmp44_);
					keycap_label = _tmp44_;
					_tmp45_ = keycap_label;
					gtk_widget_add_css_class ((GtkWidget*) _tmp45_, "keycap");
					_tmp46_ = self->priv->keycap_box;
					_tmp47_ = keycap_label;
					gtk_box_append (_tmp46_, (GtkWidget*) _tmp47_);
					_g_object_unref0 (keycap_label);
				}
			}
		}
		_tmp48_ = self->priv->clear_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp48_, TRUE);
		_tmp49_ = self->priv->keycap_stack;
		_tmp50_ = self->priv->keycap_box;
		gtk_stack_set_visible_child (_tmp49_, (GtkWidget*) _tmp50_);
	} else {
		GtkButton* _tmp51_;
		GtkStack* _tmp52_;
		GtkLabel* _tmp53_;
		GtkLabel* _tmp54_;
		_tmp51_ = self->priv->clear_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp51_, FALSE);
		_tmp52_ = self->priv->keycap_stack;
		_tmp53_ = self->priv->status_label;
		gtk_stack_set_visible_child (_tmp52_, (GtkWidget*) _tmp53_);
		_tmp54_ = self->priv->status_label;
		gtk_label_set_label (_tmp54_, _ ("Disabled"));
	}
	_tmp55_ = settings;
	_tmp56_ = _tmp55_->schemas;
	_tmp56__length1 = _tmp55_->schemas_length1;
	_tmp57_ = self->priv->_schema;
	_tmp58_ = _tmp56_[_tmp57_];
	_tmp59_ = self->priv->_gsettings_key;
	_tmp60_ = g_settings_get_user_value (_tmp58_, _tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = _tmp61_ == NULL;
	_g_variant_unref0 (_tmp61_);
	if (_tmp62_) {
		GtkButton* _tmp63_;
		_tmp63_ = self->priv->reset_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp63_, FALSE);
	} else {
		GtkButton* _tmp64_;
		_tmp64_ = self->priv->reset_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp64_, TRUE);
	}
	accels = (_vala_array_free (accels, accels_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (key_value);
}

static const gchar*
keyboard_shortcuts_shortcut_list_box_shortcut_row_get_action (KeyboardShortcutsShortcutListBoxShortcutRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_action;
	result = _tmp0_;
	return result;
}

static void
keyboard_shortcuts_shortcut_list_box_shortcut_row_set_action (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_shortcuts_shortcut_list_box_shortcut_row_get_action (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_action);
		self->priv->_action = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, keyboard_shortcuts_shortcut_list_box_shortcut_row_properties[KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_ACTION_PROPERTY]);
	}
}

static KeyboardShortcutsSchema
keyboard_shortcuts_shortcut_list_box_shortcut_row_get_schema (KeyboardShortcutsShortcutListBoxShortcutRow* self)
{
	KeyboardShortcutsSchema result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_schema;
	return result;
}

static void
keyboard_shortcuts_shortcut_list_box_shortcut_row_set_schema (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                              KeyboardShortcutsSchema value)
{
	KeyboardShortcutsSchema old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_shortcuts_shortcut_list_box_shortcut_row_get_schema (self);
	if (old_value != value) {
		self->priv->_schema = value;
		g_object_notify_by_pspec ((GObject *) self, keyboard_shortcuts_shortcut_list_box_shortcut_row_properties[KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_SCHEMA_PROPERTY]);
	}
}

static const gchar*
keyboard_shortcuts_shortcut_list_box_shortcut_row_get_gsettings_key (KeyboardShortcutsShortcutListBoxShortcutRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gsettings_key;
	result = _tmp0_;
	return result;
}

static void
keyboard_shortcuts_shortcut_list_box_shortcut_row_set_gsettings_key (KeyboardShortcutsShortcutListBoxShortcutRow* self,
                                                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = keyboard_shortcuts_shortcut_list_box_shortcut_row_get_gsettings_key (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_gsettings_key);
		self->priv->_gsettings_key = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, keyboard_shortcuts_shortcut_list_box_shortcut_row_properties[KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_GSETTINGS_KEY_PROPERTY]);
	}
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		KeyboardShortcutsShortcutListBoxShortcutRow* self;
		self = _data23_->self;
		_g_object_unref0 (_data23_->popover);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static void
_keyboard_shortcuts_shortcut_list_box_shortcut_row_render_keycaps_g_settings_changed (GSettings* _sender,
                                                                                      const gchar* key,
                                                                                      gpointer self)
{
	keyboard_shortcuts_shortcut_list_box_shortcut_row_render_keycaps ((KeyboardShortcutsShortcutListBoxShortcutRow*) self);
}

static void
_keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda61_ (Block23Data* _data23_)
{
	KeyboardShortcutsShortcutListBoxShortcutRow* self;
	GtkPopover* _tmp0_;
	GVariant* key_value = NULL;
	KeyboardShortcutsSettings* _tmp1_;
	GSettings** _tmp2_;
	gint _tmp2__length1;
	KeyboardShortcutsSchema _tmp3_;
	GSettings* _tmp4_;
	const gchar* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	const GVariantType* _tmp8_;
	self = _data23_->self;
	_tmp0_ = _data23_->popover;
	gtk_popover_popdown (_tmp0_);
	_tmp1_ = _data23_->settings;
	_tmp2_ = _tmp1_->schemas;
	_tmp2__length1 = _tmp1_->schemas_length1;
	_tmp3_ = self->priv->_schema;
	_tmp4_ = _tmp2_[_tmp3_];
	_tmp5_ = self->priv->_gsettings_key;
	_tmp6_ = g_settings_get_value (_tmp4_, _tmp5_);
	key_value = _tmp6_;
	_tmp7_ = key_value;
	_tmp8_ = G_VARIANT_TYPE_ARRAY;
	if (g_variant_is_of_type (_tmp7_, _tmp8_)) {
		KeyboardShortcutsSettings* _tmp9_;
		GSettings** _tmp10_;
		gint _tmp10__length1;
		KeyboardShortcutsSchema _tmp11_;
		GSettings* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar** _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp9_ = _data23_->settings;
		_tmp10_ = _tmp9_->schemas;
		_tmp10__length1 = _tmp9_->schemas_length1;
		_tmp11_ = self->priv->_schema;
		_tmp12_ = _tmp10_[_tmp11_];
		_tmp13_ = self->priv->_gsettings_key;
		_tmp14_ = g_strdup ("");
		_tmp15_ = g_new0 (gchar*, 1 + 1);
		_tmp15_[0] = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp16__length1 = 1;
		g_settings_set_strv (_tmp12_, _tmp13_, _tmp16_);
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	} else {
		KeyboardShortcutsSettings* _tmp17_;
		GSettings** _tmp18_;
		gint _tmp18__length1;
		KeyboardShortcutsSchema _tmp19_;
		GSettings* _tmp20_;
		const gchar* _tmp21_;
		_tmp17_ = _data23_->settings;
		_tmp18_ = _tmp17_->schemas;
		_tmp18__length1 = _tmp17_->schemas_length1;
		_tmp19_ = self->priv->_schema;
		_tmp20_ = _tmp18_[_tmp19_];
		_tmp21_ = self->priv->_gsettings_key;
		g_settings_set_string (_tmp20_, _tmp21_, "");
	}
	_g_variant_unref0 (key_value);
}

static void
__keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda61__gtk_button_clicked (GtkButton* _sender,
                                                                                    gpointer self)
{
	_keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda61_ (self);
}

static void
_keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda62_ (Block23Data* _data23_)
{
	KeyboardShortcutsShortcutListBoxShortcutRow* self;
	GtkPopover* _tmp0_;
	KeyboardShortcutsSettings* _tmp1_;
	GSettings** _tmp2_;
	gint _tmp2__length1;
	KeyboardShortcutsSchema _tmp3_;
	GSettings* _tmp4_;
	const gchar* _tmp5_;
	self = _data23_->self;
	_tmp0_ = _data23_->popover;
	gtk_popover_popdown (_tmp0_);
	_tmp1_ = _data23_->settings;
	_tmp2_ = _tmp1_->schemas;
	_tmp2__length1 = _tmp1_->schemas_length1;
	_tmp3_ = self->priv->_schema;
	_tmp4_ = _tmp2_[_tmp3_];
	_tmp5_ = self->priv->_gsettings_key;
	g_settings_reset (_tmp4_, _tmp5_);
}

static void
__keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda62__gtk_button_clicked (GtkButton* _sender,
                                                                                    gpointer self)
{
	_keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda62_ (self);
}

static void
_keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda63_ (Block23Data* _data23_)
{
	KeyboardShortcutsShortcutListBoxShortcutRow* self;
	GtkPopover* _tmp0_;
	self = _data23_->self;
	_tmp0_ = _data23_->popover;
	gtk_popover_popdown (_tmp0_);
	keyboard_shortcuts_shortcut_list_box_shortcut_row_edit_shortcut (self, TRUE);
}

static void
__keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda63__gtk_button_clicked (GtkButton* _sender,
                                                                                    gpointer self)
{
	_keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda63_ (self);
}

static void
_keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda64_ (KeyboardShortcutsShortcutListBoxShortcutRow* self)
{
	keyboard_shortcuts_shortcut_list_box_shortcut_row_edit_shortcut (self, TRUE);
}

static void
__keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda64__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                            gint n_press,
                                                                                            gdouble x,
                                                                                            gdouble y,
                                                                                            gpointer self)
{
	_keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda64_ ((KeyboardShortcutsShortcutListBoxShortcutRow*) self);
}

static void
_keyboard_shortcuts_shortcut_list_box_shortcut_row_on_key_released_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                                          guint keyval,
                                                                                                          guint keycode,
                                                                                                          GdkModifierType state,
                                                                                                          gpointer self)
{
	keyboard_shortcuts_shortcut_list_box_shortcut_row_on_key_released ((KeyboardShortcutsShortcutListBoxShortcutRow*) self, _sender, keyval, keycode, state);
}

static GObject *
keyboard_shortcuts_shortcut_list_box_shortcut_row_constructor (GType type,
                                                               guint n_construct_properties,
                                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	KeyboardShortcutsShortcutListBoxShortcutRow * self;
	Block23Data* _data23_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GtkLabel* label = NULL;
	const gchar* _tmp10_;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_;
	GtkBox* _tmp14_ = NULL;
	GtkStack* _tmp15_ = NULL;
	GtkStack* _tmp16_;
	GtkBox* _tmp17_;
	GtkStack* _tmp18_;
	GtkLabel* _tmp19_;
	GtkButton* set_accel_button = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* _tmp22_;
	GtkLabel* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	GtkButton* _tmp25_;
	GtkLabel* _tmp26_ = NULL;
	GtkButton* _tmp27_ = NULL;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GtkBox* action_box = NULL;
	GtkBox* _tmp30_;
	GtkBox* _tmp31_;
	GtkButton* _tmp32_;
	GtkBox* _tmp33_;
	GtkButton* _tmp34_;
	GtkBox* _tmp35_;
	GtkButton* _tmp36_;
	GtkBox* _tmp37_;
	GtkWidget* _tmp38_;
	GtkPopover* _tmp39_ = NULL;
	GtkPopover* _tmp40_;
	GtkMenuButton* menubutton = NULL;
	gchar* _tmp41_;
	GtkPopover* _tmp42_;
	GtkPopover* _tmp43_;
	GtkMenuButton* _tmp44_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp45_ = NULL;
	GtkBox* _tmp46_;
	GtkLabel* _tmp47_;
	GtkBox* _tmp48_;
	GtkStack* _tmp49_;
	GtkBox* _tmp50_;
	GtkMenuButton* _tmp51_;
	GtkBox* _tmp52_;
	KeyboardShortcutsSettings* _tmp53_;
	KeyboardShortcutsSettings* _tmp54_;
	GSettings** _tmp55_;
	gint _tmp55__length1;
	KeyboardShortcutsSchema _tmp56_;
	GSettings* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	GtkButton* _tmp60_;
	GtkButton* _tmp61_;
	GtkButton* _tmp62_;
	GtkGestureClick* keycap_controller = NULL;
	GtkGestureClick* _tmp63_;
	GtkStack* _tmp64_;
	GtkGestureClick* _tmp65_;
	GtkEventController* _tmp66_;
	GtkGestureClick* _tmp67_;
	GtkEventControllerKey* key_controller = NULL;
	GtkEventControllerKey* _tmp68_;
	GtkEventControllerKey* _tmp69_;
	GtkEventControllerKey* _tmp70_;
	GtkEventController* _tmp71_;
	parent_class = G_OBJECT_CLASS (keyboard_shortcuts_shortcut_list_box_shortcut_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_TYPE_SHORTCUT_ROW, KeyboardShortcutsShortcutListBoxShortcutRow);
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_data23_->self = g_object_ref (self);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ != NULL) {
		GdkSeat* seat = NULL;
		GdkDisplay* _tmp3_;
		GdkSeat* _tmp4_;
		GdkSeat* _tmp5_;
		GdkSeat* _tmp6_;
		_tmp3_ = display;
		_tmp4_ = gdk_display_get_default_seat (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		seat = _tmp5_;
		_tmp6_ = seat;
		if (_tmp6_ != NULL) {
			GdkSeat* _tmp7_;
			GdkDevice* _tmp8_;
			GdkDevice* _tmp9_;
			_tmp7_ = seat;
			_tmp8_ = gdk_seat_get_keyboard (_tmp7_);
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (self->priv->keyboard_device);
			self->priv->keyboard_device = _tmp9_;
		}
		_g_object_unref0 (seat);
	}
	_tmp10_ = self->priv->_action;
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, TRUE);
	g_object_ref_sink (_tmp11_);
	label = _tmp11_;
	_tmp12_ = (GtkLabel*) gtk_label_new (_ ("Disabled"));
	gtk_widget_set_halign ((GtkWidget*) _tmp12_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->status_label);
	self->priv->status_label = _tmp12_;
	_tmp13_ = self->priv->status_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp13_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp14_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) _tmp14_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->keycap_box);
	self->priv->keycap_box = _tmp14_;
	_tmp15_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp15_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->keycap_stack);
	self->priv->keycap_stack = _tmp15_;
	_tmp16_ = self->priv->keycap_stack;
	_tmp17_ = self->priv->keycap_box;
	gtk_stack_add_child (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->keycap_stack;
	_tmp19_ = self->priv->status_label;
	gtk_stack_add_child (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = (GtkLabel*) gtk_label_new (_ ("Set New Shortcut"));
	gtk_widget_set_halign ((GtkWidget*) _tmp20_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp20_);
	_tmp21_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp21_, (GtkWidget*) _tmp20_);
	_g_object_unref0 (_tmp20_);
	g_object_ref_sink (_tmp21_);
	set_accel_button = _tmp21_;
	_tmp22_ = set_accel_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp22_, GRANITE_STYLE_CLASS_MENUITEM);
	_tmp23_ = (GtkLabel*) gtk_label_new (_ ("Reset to Default"));
	gtk_widget_set_halign ((GtkWidget*) _tmp23_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp23_);
	_tmp24_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp24_, (GtkWidget*) _tmp23_);
	_g_object_unref0 (_tmp23_);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->reset_button);
	self->priv->reset_button = _tmp24_;
	_tmp25_ = self->priv->reset_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp25_, GRANITE_STYLE_CLASS_MENUITEM);
	_tmp26_ = (GtkLabel*) gtk_label_new (_ ("Disable"));
	gtk_widget_set_halign ((GtkWidget*) _tmp26_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp26_);
	_tmp27_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp27_, (GtkWidget*) _tmp26_);
	_g_object_unref0 (_tmp26_);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->clear_button);
	self->priv->clear_button = _tmp27_;
	_tmp28_ = self->priv->clear_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp28_, GRANITE_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp29_ = self->priv->clear_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp29_, GRANITE_STYLE_CLASS_MENUITEM);
	_tmp30_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp30_);
	action_box = _tmp30_;
	_tmp31_ = action_box;
	_tmp32_ = set_accel_button;
	gtk_box_append (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = action_box;
	_tmp34_ = self->priv->reset_button;
	gtk_box_append (_tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = action_box;
	_tmp36_ = self->priv->clear_button;
	gtk_box_append (_tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = action_box;
	_tmp38_ = _g_object_ref0 ((GtkWidget*) _tmp37_);
	_tmp39_ = (GtkPopover*) gtk_popover_new ();
	gtk_popover_set_child (_tmp39_, _tmp38_);
	_g_object_unref0 (_tmp38_);
	g_object_ref_sink (_tmp39_);
	_data23_->popover = _tmp39_;
	_tmp40_ = _data23_->popover;
	gtk_widget_add_css_class ((GtkWidget*) _tmp40_, GRANITE_STYLE_CLASS_MENU);
	_tmp41_ = g_strdup ("open-menu-symbolic");
	_tmp42_ = _data23_->popover;
	_tmp43_ = _g_object_ref0 (_tmp42_);
	_tmp44_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_has_frame (_tmp44_, FALSE);
	gtk_menu_button_set_icon_name (_tmp44_, _tmp41_);
	_g_free0 (_tmp41_);
	gtk_menu_button_set_popover (_tmp44_, _tmp43_);
	_g_object_unref0 (_tmp43_);
	g_object_ref_sink (_tmp44_);
	menubutton = _tmp44_;
	_tmp45_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp45_, 3);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp45_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp45_, 3);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp45_, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp45_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp45_);
	box = _tmp45_;
	_tmp46_ = box;
	_tmp47_ = label;
	gtk_box_append (_tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = box;
	_tmp49_ = self->priv->keycap_stack;
	gtk_box_append (_tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = box;
	_tmp51_ = menubutton;
	gtk_box_append (_tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = box;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp52_);
	keyboard_shortcuts_shortcut_list_box_shortcut_row_render_keycaps (self);
	_tmp53_ = keyboard_shortcuts_settings_get_default ();
	_data23_->settings = _tmp53_;
	_tmp54_ = _data23_->settings;
	_tmp55_ = _tmp54_->schemas;
	_tmp55__length1 = _tmp54_->schemas_length1;
	_tmp56_ = self->priv->_schema;
	_tmp57_ = _tmp55_[_tmp56_];
	_tmp58_ = self->priv->_gsettings_key;
	_tmp59_ = g_strconcat ("changed::", _tmp58_, NULL);
	g_signal_connect_object (_tmp57_, _tmp59_, (GCallback) _keyboard_shortcuts_shortcut_list_box_shortcut_row_render_keycaps_g_settings_changed, self, 0);
	_g_free0 (_tmp59_);
	_tmp60_ = self->priv->clear_button;
	g_signal_connect_data (_tmp60_, "clicked", (GCallback) __keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda61__gtk_button_clicked, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
	_tmp61_ = self->priv->reset_button;
	g_signal_connect_data (_tmp61_, "clicked", (GCallback) __keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda62__gtk_button_clicked, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
	_tmp62_ = set_accel_button;
	g_signal_connect_data (_tmp62_, "clicked", (GCallback) __keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda63__gtk_button_clicked, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
	_tmp63_ = (GtkGestureClick*) gtk_gesture_click_new ();
	keycap_controller = _tmp63_;
	_tmp64_ = self->priv->keycap_stack;
	_tmp65_ = keycap_controller;
	_tmp66_ = _g_object_ref0 ((GtkEventController*) _tmp65_);
	gtk_widget_add_controller ((GtkWidget*) _tmp64_, _tmp66_);
	_tmp67_ = keycap_controller;
	g_signal_connect_object (_tmp67_, "released", (GCallback) __keyboard_shortcuts_shortcut_list_box_shortcut_row___lambda64__gtk_gesture_click_released, self, 0);
	_tmp68_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	key_controller = _tmp68_;
	_tmp69_ = key_controller;
	g_signal_connect_object (_tmp69_, "key-released", (GCallback) _keyboard_shortcuts_shortcut_list_box_shortcut_row_on_key_released_gtk_event_controller_key_key_released, self, 0);
	_tmp70_ = key_controller;
	_tmp71_ = _g_object_ref0 ((GtkEventController*) _tmp70_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp71_);
	_g_object_unref0 (key_controller);
	_g_object_unref0 (keycap_controller);
	_g_object_unref0 (box);
	_g_object_unref0 (menubutton);
	_g_object_unref0 (action_box);
	_g_object_unref0 (set_accel_button);
	_g_object_unref0 (label);
	_g_object_unref0 (display);
	block23_data_unref (_data23_);
	_data23_ = NULL;
	return obj;
}

static void
keyboard_shortcuts_shortcut_list_box_shortcut_row_class_init (KeyboardShortcutsShortcutListBoxShortcutRowClass * klass,
                                                              gpointer klass_data)
{
	keyboard_shortcuts_shortcut_list_box_shortcut_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardShortcutsShortcutListBoxShortcutRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_keyboard_shortcuts_shortcut_list_box_shortcut_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_keyboard_shortcuts_shortcut_list_box_shortcut_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = keyboard_shortcuts_shortcut_list_box_shortcut_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = keyboard_shortcuts_shortcut_list_box_shortcut_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_ACTION_PROPERTY, keyboard_shortcuts_shortcut_list_box_shortcut_row_properties[KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_ACTION_PROPERTY] = g_param_spec_string ("action", "action", "action", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_SCHEMA_PROPERTY, keyboard_shortcuts_shortcut_list_box_shortcut_row_properties[KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_SCHEMA_PROPERTY] = g_param_spec_enum ("schema", "schema", "schema", KEYBOARD_SHORTCUTS_TYPE_SCHEMA, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_GSETTINGS_KEY_PROPERTY, keyboard_shortcuts_shortcut_list_box_shortcut_row_properties[KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_GSETTINGS_KEY_PROPERTY] = g_param_spec_string ("gsettings-key", "gsettings-key", "gsettings-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
keyboard_shortcuts_shortcut_list_box_shortcut_row_instance_init (KeyboardShortcutsShortcutListBoxShortcutRow * self,
                                                                 gpointer klass)
{
	self->priv = keyboard_shortcuts_shortcut_list_box_shortcut_row_get_instance_private (self);
	self->priv->is_editing_shortcut = FALSE;
	self->priv->keyboard_device = NULL;
}

static void
keyboard_shortcuts_shortcut_list_box_shortcut_row_finalize (GObject * obj)
{
	KeyboardShortcutsShortcutListBoxShortcutRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_TYPE_SHORTCUT_ROW, KeyboardShortcutsShortcutListBoxShortcutRow);
	_g_free0 (self->priv->_action);
	_g_free0 (self->priv->_gsettings_key);
	_g_object_unref0 (self->priv->clear_button);
	_g_object_unref0 (self->priv->reset_button);
	_g_object_unref0 (self->priv->keycap_box);
	_g_object_unref0 (self->priv->status_label);
	_g_object_unref0 (self->priv->keycap_stack);
	_g_object_unref0 (self->priv->keyboard_device);
	G_OBJECT_CLASS (keyboard_shortcuts_shortcut_list_box_shortcut_row_parent_class)->finalize (obj);
}

static GType
keyboard_shortcuts_shortcut_list_box_shortcut_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardShortcutsShortcutListBoxShortcutRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_shortcuts_shortcut_list_box_shortcut_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardShortcutsShortcutListBoxShortcutRow), 0, (GInstanceInitFunc) keyboard_shortcuts_shortcut_list_box_shortcut_row_instance_init, NULL };
	GType keyboard_shortcuts_shortcut_list_box_shortcut_row_type_id;
	keyboard_shortcuts_shortcut_list_box_shortcut_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "KeyboardShortcutsShortcutListBoxShortcutRow", &g_define_type_info, 0);
	KeyboardShortcutsShortcutListBoxShortcutRow_private_offset = g_type_add_instance_private (keyboard_shortcuts_shortcut_list_box_shortcut_row_type_id, sizeof (KeyboardShortcutsShortcutListBoxShortcutRowPrivate));
	return keyboard_shortcuts_shortcut_list_box_shortcut_row_type_id;
}

static GType
keyboard_shortcuts_shortcut_list_box_shortcut_row_get_type (void)
{
	static volatile gsize keyboard_shortcuts_shortcut_list_box_shortcut_row_type_id__once = 0;
	if (g_once_init_enter (&keyboard_shortcuts_shortcut_list_box_shortcut_row_type_id__once)) {
		GType keyboard_shortcuts_shortcut_list_box_shortcut_row_type_id;
		keyboard_shortcuts_shortcut_list_box_shortcut_row_type_id = keyboard_shortcuts_shortcut_list_box_shortcut_row_get_type_once ();
		g_once_init_leave (&keyboard_shortcuts_shortcut_list_box_shortcut_row_type_id__once, keyboard_shortcuts_shortcut_list_box_shortcut_row_type_id);
	}
	return keyboard_shortcuts_shortcut_list_box_shortcut_row_type_id__once;
}

static void
_vala_keyboard_shortcuts_shortcut_list_box_shortcut_row_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec)
{
	KeyboardShortcutsShortcutListBoxShortcutRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_TYPE_SHORTCUT_ROW, KeyboardShortcutsShortcutListBoxShortcutRow);
	switch (property_id) {
		case KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_ACTION_PROPERTY:
		g_value_set_string (value, keyboard_shortcuts_shortcut_list_box_shortcut_row_get_action (self));
		break;
		case KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_SCHEMA_PROPERTY:
		g_value_set_enum (value, keyboard_shortcuts_shortcut_list_box_shortcut_row_get_schema (self));
		break;
		case KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_GSETTINGS_KEY_PROPERTY:
		g_value_set_string (value, keyboard_shortcuts_shortcut_list_box_shortcut_row_get_gsettings_key (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_keyboard_shortcuts_shortcut_list_box_shortcut_row_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec)
{
	KeyboardShortcutsShortcutListBoxShortcutRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_TYPE_SHORTCUT_ROW, KeyboardShortcutsShortcutListBoxShortcutRow);
	switch (property_id) {
		case KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_ACTION_PROPERTY:
		keyboard_shortcuts_shortcut_list_box_shortcut_row_set_action (self, g_value_get_string (value));
		break;
		case KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_SCHEMA_PROPERTY:
		keyboard_shortcuts_shortcut_list_box_shortcut_row_set_schema (self, g_value_get_enum (value));
		break;
		case KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_SHORTCUT_ROW_GSETTINGS_KEY_PROPERTY:
		keyboard_shortcuts_shortcut_list_box_shortcut_row_set_gsettings_key (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
keyboard_shortcuts_shortcut_list_box_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	KeyboardShortcutsShortcutListBox * self;
	KeyboardShortcutsShortcutsList* _tmp0_;
	KeyboardShortcutsSectionID _tmp1_;
	gchar** _tmp2_ = NULL;
	gint _tmp3_ = 0;
	KeyboardShortcutsSchema* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkListBox* list_box = NULL;
	GtkListBox* _tmp8_ = NULL;
	GtkSizeGroup* sizegroup = NULL;
	GtkSizeGroup* _tmp9_;
	GtkListBox* _tmp29_;
	parent_class = G_OBJECT_CLASS (keyboard_shortcuts_shortcut_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_SHORTCUTS_TYPE_SHORTCUT_LIST_BOX, KeyboardShortcutsShortcutListBox);
	_tmp0_ = keyboard_shortcuts_shortcuts_list_get_default ();
	_tmp1_ = self->priv->_group;
	keyboard_shortcuts_shortcuts_list_get_group (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
	self->priv->actions = (_vala_array_free (self->priv->actions, self->priv->actions_length1, (GDestroyNotify) g_free), NULL);
	self->priv->actions = _tmp2_;
	self->priv->actions_length1 = _tmp3_;
	self->priv->_actions_size_ = self->priv->actions_length1;
	self->priv->schemas = (g_free (self->priv->schemas), NULL);
	self->priv->schemas = _tmp4_;
	self->priv->schemas_length1 = _tmp5_;
	self->priv->_schemas_size_ = self->priv->schemas_length1;
	self->priv->keys = (_vala_array_free (self->priv->keys, self->priv->keys_length1, (GDestroyNotify) g_free), NULL);
	self->priv->keys = _tmp6_;
	self->priv->keys_length1 = _tmp7_;
	self->priv->_keys_size_ = self->priv->keys_length1;
	_tmp8_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	g_object_ref_sink (_tmp8_);
	list_box = _tmp8_;
	_tmp9_ = gtk_size_group_new (GTK_SIZE_GROUP_VERTICAL);
	sizegroup = _tmp9_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gchar** _tmp12_;
				gint _tmp12__length1;
				KeyboardShortcutsSettings* _tmp13_;
				KeyboardShortcutsSchema* _tmp14_;
				gint _tmp14__length1;
				KeyboardShortcutsSchema _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = self->priv->actions;
				_tmp12__length1 = self->priv->actions_length1;
				if (!(i < _tmp12__length1)) {
					break;
				}
				_tmp13_ = keyboard_shortcuts_settings_get_default ();
				_tmp14_ = self->priv->schemas;
				_tmp14__length1 = self->priv->schemas_length1;
				_tmp15_ = _tmp14_[i];
				_tmp16_ = self->priv->keys;
				_tmp16__length1 = self->priv->keys_length1;
				_tmp17_ = _tmp16_[i];
				if (keyboard_shortcuts_settings_valid (_tmp13_, _tmp15_, _tmp17_)) {
					KeyboardShortcutsShortcutListBoxShortcutRow* row = NULL;
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					KeyboardShortcutsSchema* _tmp20_;
					gint _tmp20__length1;
					KeyboardShortcutsSchema _tmp21_;
					gchar** _tmp22_;
					gint _tmp22__length1;
					const gchar* _tmp23_;
					KeyboardShortcutsShortcutListBoxShortcutRow* _tmp24_;
					GtkListBox* _tmp25_;
					KeyboardShortcutsShortcutListBoxShortcutRow* _tmp26_;
					GtkSizeGroup* _tmp27_;
					KeyboardShortcutsShortcutListBoxShortcutRow* _tmp28_;
					_tmp18_ = self->priv->actions;
					_tmp18__length1 = self->priv->actions_length1;
					_tmp19_ = _tmp18_[i];
					_tmp20_ = self->priv->schemas;
					_tmp20__length1 = self->priv->schemas_length1;
					_tmp21_ = _tmp20_[i];
					_tmp22_ = self->priv->keys;
					_tmp22__length1 = self->priv->keys_length1;
					_tmp23_ = _tmp22_[i];
					_tmp24_ = keyboard_shortcuts_shortcut_list_box_shortcut_row_new (_tmp19_, _tmp21_, _tmp23_);
					g_object_ref_sink (_tmp24_);
					row = _tmp24_;
					_tmp25_ = list_box;
					_tmp26_ = row;
					gtk_list_box_append (_tmp25_, (GtkWidget*) _tmp26_);
					_tmp27_ = sizegroup;
					_tmp28_ = row;
					gtk_size_group_add_widget (_tmp27_, (GtkWidget*) _tmp28_);
					_g_object_unref0 (row);
				}
			}
		}
	}
	_tmp29_ = list_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp29_);
	_g_object_unref0 (sizegroup);
	_g_object_unref0 (list_box);
	return obj;
}

static void
keyboard_shortcuts_shortcut_list_box_class_init (KeyboardShortcutsShortcutListBoxClass * klass,
                                                 gpointer klass_data)
{
	keyboard_shortcuts_shortcut_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardShortcutsShortcutListBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_keyboard_shortcuts_shortcut_list_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_keyboard_shortcuts_shortcut_list_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = keyboard_shortcuts_shortcut_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = keyboard_shortcuts_shortcut_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_GROUP_PROPERTY, keyboard_shortcuts_shortcut_list_box_properties[KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_GROUP_PROPERTY] = g_param_spec_enum ("group", "group", "group", KEYBOARD_SHORTCUTS_TYPE_SECTION_ID, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
keyboard_shortcuts_shortcut_list_box_instance_init (KeyboardShortcutsShortcutListBox * self,
                                                    gpointer klass)
{
	self->priv = keyboard_shortcuts_shortcut_list_box_get_instance_private (self);
}

static void
keyboard_shortcuts_shortcut_list_box_finalize (GObject * obj)
{
	KeyboardShortcutsShortcutListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_SHORTCUTS_TYPE_SHORTCUT_LIST_BOX, KeyboardShortcutsShortcutListBox);
	self->priv->actions = (_vala_array_free (self->priv->actions, self->priv->actions_length1, (GDestroyNotify) g_free), NULL);
	self->priv->schemas = (g_free (self->priv->schemas), NULL);
	self->priv->keys = (_vala_array_free (self->priv->keys, self->priv->keys_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (keyboard_shortcuts_shortcut_list_box_parent_class)->finalize (obj);
}

static GType
keyboard_shortcuts_shortcut_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardShortcutsShortcutListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_shortcuts_shortcut_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardShortcutsShortcutListBox), 0, (GInstanceInitFunc) keyboard_shortcuts_shortcut_list_box_instance_init, NULL };
	GType keyboard_shortcuts_shortcut_list_box_type_id;
	keyboard_shortcuts_shortcut_list_box_type_id = g_type_register_static (gtk_box_get_type (), "KeyboardShortcutsShortcutListBox", &g_define_type_info, 0);
	KeyboardShortcutsShortcutListBox_private_offset = g_type_add_instance_private (keyboard_shortcuts_shortcut_list_box_type_id, sizeof (KeyboardShortcutsShortcutListBoxPrivate));
	return keyboard_shortcuts_shortcut_list_box_type_id;
}

GType
keyboard_shortcuts_shortcut_list_box_get_type (void)
{
	static volatile gsize keyboard_shortcuts_shortcut_list_box_type_id__once = 0;
	if (g_once_init_enter (&keyboard_shortcuts_shortcut_list_box_type_id__once)) {
		GType keyboard_shortcuts_shortcut_list_box_type_id;
		keyboard_shortcuts_shortcut_list_box_type_id = keyboard_shortcuts_shortcut_list_box_get_type_once ();
		g_once_init_leave (&keyboard_shortcuts_shortcut_list_box_type_id__once, keyboard_shortcuts_shortcut_list_box_type_id);
	}
	return keyboard_shortcuts_shortcut_list_box_type_id__once;
}

static void
_vala_keyboard_shortcuts_shortcut_list_box_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	KeyboardShortcutsShortcutListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_SHORTCUTS_TYPE_SHORTCUT_LIST_BOX, KeyboardShortcutsShortcutListBox);
	switch (property_id) {
		case KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_GROUP_PROPERTY:
		g_value_set_enum (value, keyboard_shortcuts_shortcut_list_box_get_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_keyboard_shortcuts_shortcut_list_box_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	KeyboardShortcutsShortcutListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KEYBOARD_SHORTCUTS_TYPE_SHORTCUT_LIST_BOX, KeyboardShortcutsShortcutListBox);
	switch (property_id) {
		case KEYBOARD_SHORTCUTS_SHORTCUT_LIST_BOX_GROUP_PROPERTY:
		keyboard_shortcuts_shortcut_list_box_set_group (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

