// This file is part of Desktop App Toolkit,
// a set of libraries for developing nice desktop applications.
//
// For license and copyright information please follow this link:
// https://github.com/desktop-app/legal/blob/master/LEGAL
//
#pragma once

#include "base/qt_connection.h"
#include "ui/widgets/buttons.h"
#include "ui/widgets/menu/menu.h"
#include "ui/widgets/menu/menu_common.h"
#include "styles/style_widgets.h"

namespace Ui::Menu {

class Menu;

class ItemBase : public RippleButton {
public:
	ItemBase(not_null<RpWidget*> parent, const style::Menu &st);

	TriggeredSource lastTriggeredSource() const;

	rpl::producer<CallbackData> selects() const;
	void setSelected(
		bool selected,
		TriggeredSource source = TriggeredSource::Mouse);
	bool isSelected() const;

	int index() const;
	void setIndex(int index);

	void setClicked(TriggeredSource source = TriggeredSource::Mouse);

	rpl::producer<CallbackData> clicks() const;

	void setClickedCallback(Fn<void()> callback);

	rpl::producer<int> minWidthValue() const;
	int minWidth() const;
	void setMinWidth(int w);

	virtual void handleKeyPress(not_null<QKeyEvent*> e) {
	}

	void setMenuAsParent(not_null<Menu*> menu);

	virtual not_null<QAction*> action() const = 0;
	virtual bool isEnabled() const = 0;

	virtual void finishAnimating();

protected:
	void initResizeHook(rpl::producer<QSize> &&size);

	void enableMouseSelecting();
	void enableMouseSelecting(not_null<RpWidget*> widget);

	virtual int contentHeight() const = 0;

	void mousePressEvent(QMouseEvent *e) override;
	void mouseMoveEvent(QMouseEvent *e) override;
	void mouseReleaseEvent(QMouseEvent *e) override;

private:
	bool _mousePressed = false;
	int _index = -1;

	rpl::variable<bool> _selected = false;
	rpl::event_stream<> _clicks;

	rpl::variable<int> _minWidth = 0;

	TriggeredSource _lastTriggeredSource = TriggeredSource::Mouse;

	base::qt_connection _connection;

	Menu *_menu = nullptr;

};

} // namespace Ui::Menu
