/* Snapshot.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Snapshot.vala, do not modify */

/*
 * Snapshot.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <gtk/gtk.h>

#define CONSTANTS_VERSION "25.12.2"
#define AppVersion CONSTANTS_VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;
typedef struct _SnapshotPrivate SnapshotPrivate;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_FS_TAB_ENTRY (fs_tab_entry_get_type ())
#define FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FS_TAB_ENTRY, FsTabEntry))
#define FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FS_TAB_ENTRY, FsTabEntryClass))
#define IS_FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FS_TAB_ENTRY))
#define IS_FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FS_TAB_ENTRY))
#define FS_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FS_TAB_ENTRY, FsTabEntryClass))

typedef struct _FsTabEntry FsTabEntry;
typedef struct _FsTabEntryClass FsTabEntryClass;

#define TYPE_CRYPT_TAB_ENTRY (crypt_tab_entry_get_type ())
#define CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntry))
#define CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))
#define IS_CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRYPT_TAB_ENTRY))
#define IS_CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRYPT_TAB_ENTRY))
#define CRYPT_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))

typedef struct _CryptTabEntry CryptTabEntry;
typedef struct _CryptTabEntryClass CryptTabEntryClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;
enum  {
	SNAPSHOT_0_PROPERTY,
	SNAPSHOT_DATE_FORMATTED_PROPERTY,
	SNAPSHOT_RSYNC_LOG_FILE_PROPERTY,
	SNAPSHOT_RSYNC_CHANGES_LOG_FILE_PROPERTY,
	SNAPSHOT_RSYNC_RESTORE_LOG_FILE_PROPERTY,
	SNAPSHOT_RSYNC_RESTORE_CHANGES_LOG_FILE_PROPERTY,
	SNAPSHOT_EXCLUDE_FILE_FOR_BACKUP_PROPERTY,
	SNAPSHOT_EXCLUDE_FILE_FOR_RESTORE_PROPERTY,
	SNAPSHOT_TAGLIST_PROPERTY,
	SNAPSHOT_TAGLIST_SHORT_PROPERTY,
	SNAPSHOT_SUBVOLUMES_SORTED_PROPERTY,
	SNAPSHOT_NUM_PROPERTIES
};
static GParamSpec* snapshot_properties[SNAPSHOT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SnapshotRepoPrivate SnapshotRepoPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;
typedef enum  {
	SNAPSHOT_LOCATION_STATUS_NOT_SELECTED = -2,
	SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE = -1,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE = 0,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE = 1,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE = 2,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE = 3,
	SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS = 4,
	SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED = 5,
	SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM = 6
} SnapshotLocationStatus;

#define TYPE_SNAPSHOT_LOCATION_STATUS (snapshot_location_status_get_type ())
typedef struct _SubvolumePrivate SubvolumePrivate;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _FsTabEntryPrivate FsTabEntryPrivate;
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())
typedef struct _DeleteFileTaskPrivate DeleteFileTaskPrivate;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_FILE_ITEM (file_item_get_type ())
#define FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_ITEM, FileItem))
#define FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_ITEM, FileItemClass))
#define IS_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_ITEM))
#define IS_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_ITEM))
#define FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_ITEM, FileItemClass))

typedef struct _FileItem FileItem;
typedef struct _FileItemClass FileItemClass;

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;

struct _Snapshot {
	GObject parent_instance;
	SnapshotPrivate * priv;
	gchar* path;
	gchar* name;
	GDateTime* date;
	gchar* sys_uuid;
	gchar* sys_distro;
	gchar* app_version;
	gchar* description;
	gint64 file_count;
	GeeArrayList* tags;
	GeeArrayList* exclude_list;
	GeeHashMap* subvolumes;
	GeeArrayList* fstab_list;
	GeeArrayList* cryttab_list;
	gboolean valid;
	gboolean live;
	gboolean marked_for_deletion;
	LinuxDistro* distro;
	SnapshotRepo* repo;
	gboolean btrfs_mode;
	GeeHashMap* paths;
	gchar* mount_path_root;
	gchar* mount_path_home;
	DeleteFileTask* delete_file_task;
};

struct _SnapshotClass {
	GObjectClass parent_class;
};

struct _SnapshotRepo {
	GObject parent_instance;
	SnapshotRepoPrivate * priv;
	Device* device;
	Device* device_home;
	gchar* mount_path;
	GeeHashMap* mount_paths;
	gboolean btrfs_mode;
	GeeArrayList* snapshots;
	GeeArrayList* invalid_snapshots;
	gchar* status_message;
	gchar* status_details;
	SnapshotLocationStatus status_code;
	gboolean last_snapshot_failed_space;
};

struct _SnapshotRepoClass {
	GObjectClass parent_class;
};

struct _Subvolume {
	GObject parent_instance;
	SubvolumePrivate * priv;
	gchar* device_uuid;
	gchar* name;
	gchar* path;
	glong id;
	gint64 total_bytes;
	gint64 unshared_bytes;
	gchar* mount_path;
	SnapshotRepo* repo;
};

struct _SubvolumeClass {
	GObjectClass parent_class;
};

struct _FsTabEntry {
	GObject parent_instance;
	FsTabEntryPrivate * priv;
	gboolean is_comment;
	gboolean is_empty_line;
	gchar* device_string;
	gchar* mount_point;
	gchar* type;
	gchar* options;
	gchar* dump;
	gchar* pass;
	gchar* line;
};

struct _FsTabEntryClass {
	GObjectClass parent_class;
};

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*prepare) (AsyncTask* self);
	gchar* (*build_script) (AsyncTask* self);
	gboolean (*begin) (AsyncTask* self);
	void (*execute) (AsyncTask* self);
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _DeleteFileTask {
	AsyncTask parent_instance;
	DeleteFileTaskPrivate * priv;
	gchar* dest_path;
	gboolean verbose;
	gboolean io_nice;
	gboolean use_rsync;
	gint64 status_line_count;
	gint64 total_size;
	gchar* status_message;
	gchar* time_remaining;
};

struct _DeleteFileTaskClass {
	AsyncTaskClass parent_class;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

static gpointer snapshot_parent_class = NULL;
VALA_EXTERN gint64 main_first_snapshot_count;
VALA_EXTERN Main* App;

VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType fs_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FsTabEntry, g_object_unref)
VALA_EXTERN GType crypt_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CryptTabEntry, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN Snapshot* snapshot_new (const gchar* dir_path,
                        gboolean btrfs_snapshot,
                        SnapshotRepo* _repo);
VALA_EXTERN Snapshot* snapshot_construct (GType object_type,
                              const gchar* dir_path,
                              gboolean btrfs_snapshot,
                              SnapshotRepo* _repo);
VALA_EXTERN DeleteFileTask* delete_file_task_new (void);
VALA_EXTERN DeleteFileTask* delete_file_task_construct (GType object_type);
VALA_EXTERN void snapshot_read_control_file (Snapshot* self);
VALA_EXTERN void snapshot_read_exclude_list (Snapshot* self);
VALA_EXTERN void snapshot_read_fstab_file (Snapshot* self);
VALA_EXTERN void snapshot_read_crypttab_file (Snapshot* self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN void snapshot_add_tag (Snapshot* self,
                       const gchar* tag);
VALA_EXTERN void snapshot_update_control_file (Snapshot* self);
VALA_EXTERN void snapshot_remove_tag (Snapshot* self,
                          const gchar* tag);
VALA_EXTERN gboolean snapshot_has_tag (Snapshot* self,
                           const gchar* tag);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN gchar* tee_jee_json_helper_json_get_string (JsonObject* jobj,
                                            const gchar* member,
                                            const gchar* def_value);
VALA_EXTERN void snapshot_set_taglist (Snapshot* self,
                           const gchar* value);
VALA_EXTERN guint64 tee_jee_json_helper_json_get_uint64 (JsonObject* jobj,
                                             const gchar* member,
                                             guint64 def_value);
VALA_EXTERN gboolean tee_jee_json_helper_json_get_bool (JsonObject* jobj,
                                            const gchar* member,
                                            gboolean def_value);
VALA_EXTERN LinuxDistro* linux_distro_get_dist_info (const gchar* root_path);
VALA_EXTERN gchar* tee_jee_file_system_path_combine (const gchar* path1,
                                         const gchar* path2);
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType snapshot_location_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean tee_jee_file_system_dir_exists (const gchar* dir_path);
VALA_EXTERN Subvolume* subvolume_new (const gchar* name,
                          const gchar* path,
                          const gchar* parent_dev_uuid,
                          SnapshotRepo* parent_repo);
VALA_EXTERN Subvolume* subvolume_construct (GType object_type,
                                const gchar* name,
                                const gchar* path,
                                const gchar* parent_dev_uuid,
                                SnapshotRepo* parent_repo);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
VALA_EXTERN GeeArrayList* fs_tab_entry_read_file (const gchar* file_path);
VALA_EXTERN GeeArrayList* crypt_tab_entry_read_file (const gchar* file_path);
VALA_EXTERN gchar* snapshot_get_taglist (Snapshot* self);
VALA_EXTERN void snapshot_remove_control_file (Snapshot* self);
VALA_EXTERN gboolean tee_jee_file_system_file_delete (const gchar* file_path);
VALA_EXTERN Snapshot* snapshot_write_control_file (const gchar* snapshot_path,
                                       GDateTime* dt_created,
                                       const gchar* root_uuid,
                                       const gchar* distro_full_name,
                                       const gchar* tag,
                                       const gchar* comments,
                                       gint64 item_count,
                                       gboolean is_btrfs,
                                       gboolean is_live,
                                       SnapshotRepo* repo,
                                       gboolean silent);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN gboolean snapshot_has_subvolumes (Snapshot* self);
VALA_EXTERN gboolean snapshot_remove (Snapshot* self,
                          gboolean wait);
VALA_EXTERN gboolean snapshot_remove_btrfs (Snapshot* self);
VALA_EXTERN gboolean snapshot_remove_rsync (Snapshot* self,
                                gboolean wait);
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void async_task_execute (AsyncTask* self);
VALA_EXTERN void tee_jee_system_sleep (gint milliseconds);
VALA_EXTERN void tee_jee_gtk_helper_gtk_do_events (void);
VALA_EXTERN gchar* async_task_get_stat_time_remaining (AsyncTask* self);
VALA_EXTERN gboolean subvolume_remove (Subvolume* self);
VALA_EXTERN gboolean tee_jee_file_system_dir_delete (const gchar* dir_path,
                                         gboolean show_message);
VALA_EXTERN void snapshot_mark_for_deletion (Snapshot* self);
VALA_EXTERN gboolean tee_jee_file_system_file_write (const gchar* file_path,
                                         const gchar* contents);
VALA_EXTERN void snapshot_parse_log_file (Snapshot* self);
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN RsyncTask* rsync_task_new (void);
VALA_EXTERN RsyncTask* rsync_task_construct (GType object_type);
VALA_EXTERN GType file_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileItem, g_object_unref)
VALA_EXTERN GeeArrayList* rsync_task_parse_log (RsyncTask* self,
                                    const gchar* log_file_path);
VALA_EXTERN gchar* snapshot_get_rsync_log_file (Snapshot* self);
VALA_EXTERN gchar* snapshot_get_date_formatted (Snapshot* self);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN gchar* snapshot_get_rsync_changes_log_file (Snapshot* self);
VALA_EXTERN gchar* snapshot_get_rsync_restore_log_file (Snapshot* self);
VALA_EXTERN gchar* snapshot_get_rsync_restore_changes_log_file (Snapshot* self);
VALA_EXTERN gchar* snapshot_get_exclude_file_for_backup (Snapshot* self);
VALA_EXTERN gchar* snapshot_get_exclude_file_for_restore (Snapshot* self);
VALA_EXTERN gchar* snapshot_get_taglist_short (Snapshot* self);
VALA_EXTERN GeeArrayList* snapshot_get_subvolumes_sorted (Snapshot* self);
static gint _snapshot_subvolumes_sorted___lambda9_ (Snapshot* self,
                                             Subvolume* a,
                                             Subvolume* b);
static gint __snapshot_subvolumes_sorted___lambda9__gcompare_data_func (gconstpointer a,
                                                                 gconstpointer b,
                                                                 gpointer self);
static void snapshot_finalize (GObject * obj);
static GType snapshot_get_type_once (void);
static void _vala_snapshot_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_snapshot_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Snapshot*
snapshot_construct (GType object_type,
                    const gchar* dir_path,
                    gboolean btrfs_snapshot,
                    SnapshotRepo* _repo)
{
	Snapshot * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (dir_path != NULL, NULL);
	g_return_val_if_fail (_repo != NULL, NULL);
	self = (Snapshot*) g_object_new (object_type, NULL);
	{
		GFile* f = NULL;
		GFile* _tmp0_;
		GFileInfo* info = NULL;
		GFileInfo* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		SnapshotRepo* _tmp6_;
		GDateTime* _tmp7_;
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		DeleteFileTask* _tmp11_;
		GeeHashMap* _tmp12_;
		GeeHashMap* _tmp13_;
		_tmp0_ = g_file_new_for_path (dir_path);
		f = _tmp0_;
		_tmp1_ = g_file_query_info (f, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (f);
			goto __catch0_g_error;
		}
		_tmp2_ = g_strdup (dir_path);
		_g_free0 (self->path);
		self->path = _tmp2_;
		_tmp3_ = g_file_info_get_name (info);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->name);
		self->name = _tmp4_;
		_tmp5_ = g_strdup ("");
		_g_free0 (self->description);
		self->description = _tmp5_;
		self->btrfs_mode = btrfs_snapshot;
		_tmp6_ = _g_object_ref0 (_repo);
		_g_object_unref0 (self->repo);
		self->repo = _tmp6_;
		_tmp7_ = g_date_time_new_from_unix_utc ((gint64) 0);
		_g_date_time_unref0 (self->date);
		self->date = _tmp7_;
		_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (self->tags);
		self->tags = _tmp8_;
		_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (self->exclude_list);
		self->exclude_list = _tmp9_;
		_tmp10_ = gee_array_list_new (TYPE_FS_TAB_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->fstab_list);
		self->fstab_list = _tmp10_;
		_tmp11_ = delete_file_task_new ();
		_g_object_unref0 (self->delete_file_task);
		self->delete_file_task = _tmp11_;
		_tmp12_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_SUBVOLUME, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->subvolumes);
		self->subvolumes = _tmp12_;
		_tmp13_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->paths);
		self->paths = _tmp13_;
		snapshot_read_control_file (self);
		snapshot_read_exclude_list (self);
		snapshot_read_fstab_file (self);
		snapshot_read_crypttab_file (self);
		_g_object_unref0 (info);
		_g_object_unref0 (f);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		tee_jee_logging_log_error (_tmp15_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

Snapshot*
snapshot_new (const gchar* dir_path,
              gboolean btrfs_snapshot,
              SnapshotRepo* _repo)
{
	return snapshot_construct (TYPE_SNAPSHOT, dir_path, btrfs_snapshot, _repo);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
snapshot_add_tag (Snapshot* self,
                  const gchar* tag)
{
	GeeArrayList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = string_strip (tag);
	_tmp2_ = _tmp1_;
	_tmp3_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		GeeArrayList* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->tags;
		_tmp5_ = string_strip (tag);
		_tmp6_ = _tmp5_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
		snapshot_update_control_file (self);
	}
}

void
snapshot_remove_tag (Snapshot* self,
                     const gchar* tag)
{
	GeeArrayList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = string_strip (tag);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		GeeArrayList* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->tags;
		_tmp5_ = string_strip (tag);
		_tmp6_ = _tmp5_;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
		snapshot_update_control_file (self);
	}
}

gboolean
snapshot_has_tag (Snapshot* self,
                  const gchar* tag)
{
	GeeArrayList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tag != NULL, FALSE);
	_tmp0_ = self->tags;
	_tmp1_ = string_strip (tag);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static glong
long_parse (const gchar* str,
            guint _base)
{
	glong result;
	g_return_val_if_fail (str != NULL, 0L);
	result = strtol (str, NULL, (gint) _base);
	return result;
}

void
snapshot_read_control_file (Snapshot* self)
{
	gchar* ctl_file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* f = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->path;
	_tmp1_ = g_strconcat (_tmp0_, "/info.json", NULL);
	ctl_file = _tmp1_;
	_tmp2_ = ctl_file;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	f = _tmp3_;
	_tmp4_ = f;
	if (g_file_query_exists (_tmp4_, NULL)) {
		JsonParser* parser = NULL;
		JsonParser* _tmp5_;
		JsonNode* node = NULL;
		JsonParser* _tmp10_;
		JsonNode* _tmp11_;
		JsonNode* _tmp12_;
		JsonObject* config = NULL;
		JsonNode* _tmp13_;
		JsonObject* _tmp14_;
		JsonObject* _tmp15_;
		gboolean _tmp16_ = FALSE;
		JsonNode* _tmp17_;
		gchar* val = NULL;
		JsonObject* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		JsonObject* _tmp28_;
		gchar* _tmp29_;
		JsonObject* _tmp30_;
		gchar* _tmp31_;
		JsonObject* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		JsonObject* _tmp35_;
		gchar* _tmp36_;
		JsonObject* _tmp37_;
		gchar* _tmp38_;
		JsonObject* _tmp39_;
		JsonObject* _tmp40_;
		gchar* type = NULL;
		JsonObject* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_;
		gchar* extension = NULL;
		gchar* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		LinuxDistro* _tmp51_;
		JsonObject* _tmp52_;
		gchar* delete_trigger_file = NULL;
		const gchar* _tmp110_;
		gchar* _tmp111_;
		const gchar* _tmp112_;
		_tmp5_ = json_parser_new ();
		parser = _tmp5_;
		{
			JsonParser* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = parser;
			_tmp7_ = ctl_file;
			json_parser_load_from_file (_tmp6_, _tmp7_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			tee_jee_logging_log_error (_tmp9_, FALSE, FALSE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parser);
			_g_object_unref0 (f);
			_g_free0 (ctl_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp10_ = parser;
		_tmp11_ = json_parser_get_root (_tmp10_);
		_tmp12_ = __vala_JsonNode_copy0 (_tmp11_);
		node = _tmp12_;
		_tmp13_ = node;
		_tmp14_ = json_node_get_object (_tmp13_);
		_tmp15_ = _json_object_ref0 (_tmp14_);
		config = _tmp15_;
		_tmp17_ = node;
		if (_tmp17_ == NULL) {
			_tmp16_ = TRUE;
		} else {
			JsonObject* _tmp18_;
			_tmp18_ = config;
			_tmp16_ = _tmp18_ == NULL;
		}
		if (_tmp16_) {
			self->valid = FALSE;
			_json_object_unref0 (config);
			__vala_JsonNode_free0 (node);
			_g_object_unref0 (parser);
			_g_object_unref0 (f);
			_g_free0 (ctl_file);
			return;
		}
		_tmp19_ = config;
		_tmp20_ = tee_jee_json_helper_json_get_string (_tmp19_, "created", "");
		val = _tmp20_;
		_tmp21_ = val;
		_tmp22_ = strlen (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ > 0) {
			GDateTime* date_utc = NULL;
			const gchar* _tmp24_;
			GDateTime* _tmp25_;
			GDateTime* _tmp26_;
			GDateTime* _tmp27_;
			_tmp24_ = val;
			_tmp25_ = g_date_time_new_from_unix_utc (int64_parse (_tmp24_, (guint) 0));
			date_utc = _tmp25_;
			_tmp26_ = date_utc;
			_tmp27_ = g_date_time_to_local (_tmp26_);
			_g_date_time_unref0 (self->date);
			self->date = _tmp27_;
			_g_date_time_unref0 (date_utc);
		}
		_tmp28_ = config;
		_tmp29_ = tee_jee_json_helper_json_get_string (_tmp28_, "sys-uuid", "");
		_g_free0 (self->sys_uuid);
		self->sys_uuid = _tmp29_;
		_tmp30_ = config;
		_tmp31_ = tee_jee_json_helper_json_get_string (_tmp30_, "sys-distro", "");
		_g_free0 (self->sys_distro);
		self->sys_distro = _tmp31_;
		_tmp32_ = config;
		_tmp33_ = tee_jee_json_helper_json_get_string (_tmp32_, "tags", "");
		_tmp34_ = _tmp33_;
		snapshot_set_taglist (self, _tmp34_);
		_g_free0 (_tmp34_);
		_tmp35_ = config;
		_tmp36_ = tee_jee_json_helper_json_get_string (_tmp35_, "comments", "");
		_g_free0 (self->description);
		self->description = _tmp36_;
		_tmp37_ = config;
		_tmp38_ = tee_jee_json_helper_json_get_string (_tmp37_, "app-version", "");
		_g_free0 (self->app_version);
		self->app_version = _tmp38_;
		_tmp39_ = config;
		self->file_count = (gint64) tee_jee_json_helper_json_get_uint64 (_tmp39_, "file_count", (guint64) self->file_count);
		_tmp40_ = config;
		self->live = tee_jee_json_helper_json_get_bool (_tmp40_, "live", FALSE);
		_tmp41_ = config;
		_tmp42_ = json_object_get_string_member_with_default (_tmp41_, "type", "rsync");
		_tmp43_ = g_strdup (_tmp42_);
		type = _tmp43_;
		_tmp45_ = type;
		if (g_strcmp0 (_tmp45_, "btrfs") == 0) {
			_tmp44_ = "@";
		} else {
			_tmp44_ = "localhost";
		}
		_tmp46_ = g_strdup (_tmp44_);
		extension = _tmp46_;
		_tmp47_ = self->path;
		_tmp48_ = extension;
		_tmp49_ = tee_jee_file_system_path_combine (_tmp47_, _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = linux_distro_get_dist_info (_tmp50_);
		_g_object_unref0 (self->distro);
		self->distro = _tmp51_;
		_g_free0 (_tmp50_);
		_tmp52_ = config;
		if (json_object_has_member (_tmp52_, "subvolumes")) {
			JsonObject* subvols = NULL;
			JsonObject* _tmp53_;
			JsonObject* _tmp54_;
			JsonObject* _tmp55_;
			JsonObject* _tmp56_;
			GList* _tmp57_;
			_tmp53_ = config;
			_tmp54_ = json_object_get_object_member (_tmp53_, "subvolumes");
			_tmp55_ = _json_object_ref0 ((JsonObject*) _tmp54_);
			subvols = _tmp55_;
			_tmp56_ = subvols;
			_tmp57_ = json_object_get_members (_tmp56_);
			{
				GList* subvol_name_collection = NULL;
				GList* subvol_name_it = NULL;
				subvol_name_collection = _tmp57_;
				for (subvol_name_it = subvol_name_collection; subvol_name_it != NULL; subvol_name_it = subvol_name_it->next) {
					gchar* _tmp58_;
					gchar* subvol_name = NULL;
					_tmp58_ = g_strdup ((const gchar*) subvol_name_it->data);
					subvol_name = _tmp58_;
					{
						gboolean _tmp59_ = FALSE;
						const gchar* _tmp60_;
						GeeHashMap* _tmp62_;
						const gchar* _tmp63_;
						const gchar* _tmp64_;
						SnapshotRepo* _tmp65_;
						const gchar* _tmp66_;
						SnapshotRepo* _tmp67_;
						GeeHashMap* _tmp68_;
						const gchar* _tmp69_;
						gpointer _tmp70_;
						gchar* _tmp71_;
						gchar* _tmp72_;
						gchar* _tmp73_;
						gchar* subvol_path = NULL;
						GeeHashMap* _tmp74_;
						const gchar* _tmp75_;
						gpointer _tmp76_;
						gchar* _tmp77_;
						const gchar* _tmp78_;
						gchar* _tmp79_;
						gchar* _tmp80_;
						const gchar* _tmp81_;
						Subvolume* subvolume = NULL;
						const gchar* _tmp82_;
						const gchar* _tmp83_;
						SnapshotRepo* _tmp84_;
						Subvolume* _tmp85_;
						GeeHashMap* _tmp86_;
						const gchar* _tmp87_;
						Subvolume* _tmp88_;
						gint index = 0;
						JsonObject* _tmp89_;
						const gchar* _tmp90_;
						JsonArray* _tmp91_;
						GList* _tmp92_;
						_tmp60_ = subvol_name;
						if (g_strcmp0 (_tmp60_, "@") != 0) {
							const gchar* _tmp61_;
							_tmp61_ = subvol_name;
							_tmp59_ = g_strcmp0 (_tmp61_, "@home") != 0;
						} else {
							_tmp59_ = FALSE;
						}
						if (_tmp59_) {
							_g_free0 (subvol_name);
							continue;
						}
						_tmp62_ = self->paths;
						_tmp63_ = subvol_name;
						_tmp64_ = self->path;
						_tmp65_ = self->repo;
						_tmp66_ = _tmp65_->mount_path;
						_tmp67_ = self->repo;
						_tmp68_ = _tmp67_->mount_paths;
						_tmp69_ = subvol_name;
						_tmp70_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp68_, _tmp69_);
						_tmp71_ = (gchar*) _tmp70_;
						_tmp72_ = string_replace (_tmp64_, _tmp66_, _tmp71_);
						_tmp73_ = _tmp72_;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp62_, _tmp63_, _tmp73_);
						_g_free0 (_tmp73_);
						_g_free0 (_tmp71_);
						_tmp74_ = self->paths;
						_tmp75_ = subvol_name;
						_tmp76_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp74_, _tmp75_);
						_tmp77_ = (gchar*) _tmp76_;
						_tmp78_ = subvol_name;
						_tmp79_ = tee_jee_file_system_path_combine (_tmp77_, _tmp78_);
						_tmp80_ = _tmp79_;
						_g_free0 (_tmp77_);
						subvol_path = _tmp80_;
						_tmp81_ = subvol_path;
						if (!tee_jee_file_system_dir_exists (_tmp81_)) {
							_g_free0 (subvol_path);
							_g_free0 (subvol_name);
							continue;
						}
						_tmp82_ = subvol_name;
						_tmp83_ = subvol_path;
						_tmp84_ = self->repo;
						_tmp85_ = subvolume_new (_tmp82_, _tmp83_, "", _tmp84_);
						subvolume = _tmp85_;
						_tmp86_ = self->subvolumes;
						_tmp87_ = subvol_name;
						_tmp88_ = subvolume;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp86_, _tmp87_, _tmp88_);
						index = -1;
						_tmp89_ = subvols;
						_tmp90_ = subvol_name;
						_tmp91_ = json_object_get_array_member (_tmp89_, _tmp90_);
						_tmp92_ = json_array_get_elements (_tmp91_);
						{
							GList* jnode_collection = NULL;
							GList* jnode_it = NULL;
							jnode_collection = _tmp92_;
							for (jnode_it = jnode_collection; jnode_it != NULL; jnode_it = jnode_it->next) {
								JsonNode* _tmp93_;
								JsonNode* jnode = NULL;
								_tmp93_ = __vala_JsonNode_copy0 ((JsonNode*) jnode_it->data);
								jnode = _tmp93_;
								{
									gchar* item = NULL;
									JsonNode* _tmp94_;
									const gchar* _tmp95_;
									gchar* _tmp96_;
									gint _tmp97_;
									_tmp94_ = jnode;
									_tmp95_ = json_node_get_string (_tmp94_);
									_tmp96_ = g_strdup (_tmp95_);
									item = _tmp96_;
									index = index + 1;
									_tmp97_ = index;
									switch (_tmp97_) {
										case 0:
										{
											Subvolume* _tmp98_;
											const gchar* _tmp99_;
											gchar* _tmp100_;
											_tmp98_ = subvolume;
											_tmp99_ = item;
											_tmp100_ = g_strdup (_tmp99_);
											_g_free0 (_tmp98_->name);
											_tmp98_->name = _tmp100_;
											break;
										}
										case 1:
										{
											Subvolume* _tmp101_;
											const gchar* _tmp102_;
											_tmp101_ = subvolume;
											_tmp102_ = item;
											_tmp101_->id = long_parse (_tmp102_, (guint) 0);
											break;
										}
										case 2:
										{
											Subvolume* _tmp103_;
											const gchar* _tmp104_;
											_tmp103_ = subvolume;
											_tmp104_ = item;
											_tmp103_->total_bytes = int64_parse (_tmp104_, (guint) 0);
											break;
										}
										case 3:
										{
											Subvolume* _tmp105_;
											const gchar* _tmp106_;
											_tmp105_ = subvolume;
											_tmp106_ = item;
											_tmp105_->unshared_bytes = int64_parse (_tmp106_, (guint) 0);
											break;
										}
										case 4:
										{
											Subvolume* _tmp107_;
											const gchar* _tmp108_;
											gchar* _tmp109_;
											_tmp107_ = subvolume;
											_tmp108_ = item;
											_tmp109_ = string_strip (_tmp108_);
											_g_free0 (_tmp107_->device_uuid);
											_tmp107_->device_uuid = _tmp109_;
											break;
										}
										default:
										break;
									}
									_g_free0 (item);
									__vala_JsonNode_free0 (jnode);
								}
							}
							(jnode_collection == NULL) ? NULL : (jnode_collection = (g_list_free (jnode_collection), NULL));
						}
						_g_object_unref0 (subvolume);
						_g_free0 (subvol_path);
						_g_free0 (subvol_name);
					}
				}
				(subvol_name_collection == NULL) ? NULL : (subvol_name_collection = (g_list_free (subvol_name_collection), NULL));
			}
			_json_object_unref0 (subvols);
		}
		_tmp110_ = self->path;
		_tmp111_ = g_strconcat (_tmp110_, "/delete", NULL);
		delete_trigger_file = _tmp111_;
		_tmp112_ = delete_trigger_file;
		if (tee_jee_file_system_file_exists (_tmp112_)) {
			self->marked_for_deletion = TRUE;
		}
		_g_free0 (delete_trigger_file);
		_g_free0 (extension);
		_g_free0 (type);
		_g_free0 (val);
		_json_object_unref0 (config);
		__vala_JsonNode_free0 (node);
		_g_object_unref0 (parser);
	} else {
		self->valid = FALSE;
	}
	_g_object_unref0 (f);
	_g_free0 (ctl_file);
}

void
snapshot_read_exclude_list (Snapshot* self)
{
	gchar* list_file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* _tmp2_;
	GFile* f = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->path;
	_tmp1_ = g_strconcat (_tmp0_, "/exclude.list", NULL);
	list_file = _tmp1_;
	_tmp2_ = self->exclude_list;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	_tmp3_ = list_file;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	f = _tmp4_;
	_tmp5_ = f;
	if (g_file_query_exists (_tmp5_, NULL)) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp6_ = list_file;
		_tmp7_ = tee_jee_file_system_file_read (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "\n", 0);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _vala_array_length (_tmp9_);
		_g_free0 (_tmp8_);
		{
			gchar** path_collection = NULL;
			gint path_collection_length1 = 0;
			gint _path_collection_size_ = 0;
			gint path_it = 0;
			path_collection = _tmp11_;
			path_collection_length1 = _tmp11__length1;
			for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
				gchar* _tmp12_;
				gchar* path = NULL;
				_tmp12_ = g_strdup (path_collection[path_it]);
				path = _tmp12_;
				{
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gboolean _tmp15_ = FALSE;
					GeeArrayList* _tmp16_;
					const gchar* _tmp17_;
					_tmp13_ = path;
					_tmp14_ = string_strip (_tmp13_);
					_g_free0 (path);
					path = _tmp14_;
					_tmp16_ = self->exclude_list;
					_tmp17_ = path;
					if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp16_, _tmp17_)) {
						const gchar* _tmp18_;
						gint _tmp19_;
						gint _tmp20_;
						_tmp18_ = path;
						_tmp19_ = strlen (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp15_ = _tmp20_ > 0;
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						GeeArrayList* _tmp21_;
						const gchar* _tmp22_;
						_tmp21_ = self->exclude_list;
						_tmp22_ = path;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
					}
					_g_free0 (path);
				}
			}
			path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	} else {
		if (!self->btrfs_mode) {
			self->valid = FALSE;
		}
	}
	_g_object_unref0 (f);
	_g_free0 (list_file);
}

void
snapshot_read_fstab_file (Snapshot* self)
{
	gchar* fstab_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp4_;
	GeeArrayList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->path;
	_tmp1_ = tee_jee_file_system_path_combine (_tmp0_, "/localhost/etc/fstab");
	fstab_path = _tmp1_;
	if (self->btrfs_mode) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->path;
		_tmp3_ = tee_jee_file_system_path_combine (_tmp2_, "/@/etc/fstab");
		_g_free0 (fstab_path);
		fstab_path = _tmp3_;
	}
	_tmp4_ = fstab_path;
	_tmp5_ = fs_tab_entry_read_file (_tmp4_);
	_g_object_unref0 (self->fstab_list);
	self->fstab_list = _tmp5_;
	_g_free0 (fstab_path);
}

void
snapshot_read_crypttab_file (Snapshot* self)
{
	gchar* crypttab_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp4_;
	GeeArrayList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->path;
	_tmp1_ = tee_jee_file_system_path_combine (_tmp0_, "/localhost/etc/crypttab");
	crypttab_path = _tmp1_;
	if (self->btrfs_mode) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->path;
		_tmp3_ = tee_jee_file_system_path_combine (_tmp2_, "/@/etc/crypttab");
		_g_free0 (crypttab_path);
		crypttab_path = _tmp3_;
	}
	_tmp4_ = crypttab_path;
	_tmp5_ = crypt_tab_entry_read_file (_tmp4_);
	_g_object_unref0 (self->cryttab_list);
	self->cryttab_list = _tmp5_;
	_g_free0 (crypttab_path);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

void
snapshot_update_control_file (Snapshot* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* ctl_file = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		GFile* f = NULL;
		const gchar* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp0_ = self->path;
		_tmp1_ = g_strconcat (_tmp0_, "/info.json", NULL);
		ctl_file = _tmp1_;
		_tmp2_ = ctl_file;
		_tmp3_ = g_file_new_for_path (_tmp2_);
		f = _tmp3_;
		_tmp4_ = f;
		if (g_file_query_exists (_tmp4_, NULL)) {
			JsonParser* parser = NULL;
			JsonParser* _tmp5_;
			JsonNode* node = NULL;
			JsonParser* _tmp10_;
			JsonNode* _tmp11_;
			JsonNode* _tmp12_;
			JsonObject* config = NULL;
			JsonNode* _tmp13_;
			JsonObject* _tmp14_;
			JsonObject* _tmp15_;
			JsonObject* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			JsonObject* _tmp20_;
			const gchar* _tmp21_;
			JsonObject* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			JsonGenerator* json = NULL;
			JsonGenerator* _tmp62_;
			JsonGenerator* _tmp63_;
			JsonGenerator* _tmp64_;
			JsonNode* _tmp65_;
			JsonObject* _tmp66_;
			JsonGenerator* _tmp67_;
			JsonNode* _tmp68_;
			GFile* _tmp69_;
			JsonGenerator* _tmp70_;
			const gchar* _tmp71_;
			_tmp5_ = json_parser_new ();
			parser = _tmp5_;
			{
				JsonParser* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = parser;
				_tmp7_ = ctl_file;
				json_parser_load_from_file (_tmp6_, _tmp7_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp8_;
				const gchar* _tmp9_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp8_ = e;
				_tmp9_ = _tmp8_->message;
				tee_jee_logging_log_error (_tmp9_, FALSE, FALSE);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (parser);
				_g_object_unref0 (f);
				_g_free0 (ctl_file);
				goto __catch0_g_error;
			}
			_tmp10_ = parser;
			_tmp11_ = json_parser_get_root (_tmp10_);
			_tmp12_ = __vala_JsonNode_copy0 (_tmp11_);
			node = _tmp12_;
			_tmp13_ = node;
			_tmp14_ = json_node_get_object (_tmp13_);
			_tmp15_ = _json_object_ref0 (_tmp14_);
			config = _tmp15_;
			_tmp16_ = config;
			_tmp17_ = snapshot_get_taglist (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp18_;
			json_object_set_string_member (_tmp16_, "tags", _tmp19_);
			_g_free0 (_tmp19_);
			_tmp20_ = config;
			_tmp21_ = self->description;
			json_object_set_string_member (_tmp20_, "comments", _tmp21_);
			_tmp22_ = config;
			_tmp23_ = bool_to_string (self->live);
			_tmp24_ = _tmp23_;
			json_object_set_string_member (_tmp22_, "live", _tmp24_);
			_g_free0 (_tmp24_);
			if (self->btrfs_mode) {
				JsonObject* subvols = NULL;
				JsonObject* _tmp25_;
				JsonObject* _tmp26_;
				JsonObject* _tmp27_;
				JsonObject* _tmp28_;
				_tmp25_ = json_object_new ();
				subvols = _tmp25_;
				_tmp26_ = config;
				_tmp27_ = subvols;
				_tmp28_ = _json_object_ref0 (_tmp27_);
				json_object_set_object_member (_tmp26_, "subvolumes", _tmp28_);
				{
					GeeIterator* _subvol_it = NULL;
					GeeHashMap* _tmp29_;
					GeeCollection* _tmp30_;
					GeeCollection* _tmp31_;
					GeeCollection* _tmp32_;
					GeeIterator* _tmp33_;
					GeeIterator* _tmp34_;
					_tmp29_ = self->subvolumes;
					_tmp30_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = _tmp31_;
					_tmp33_ = gee_iterable_iterator ((GeeIterable*) _tmp32_);
					_tmp34_ = _tmp33_;
					_g_object_unref0 (_tmp32_);
					_subvol_it = _tmp34_;
					while (TRUE) {
						GeeIterator* _tmp35_;
						Subvolume* subvol = NULL;
						GeeIterator* _tmp36_;
						gpointer _tmp37_;
						JsonArray* arr = NULL;
						JsonArray* _tmp38_;
						JsonArray* _tmp39_;
						Subvolume* _tmp40_;
						const gchar* _tmp41_;
						JsonArray* _tmp42_;
						Subvolume* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						JsonArray* _tmp46_;
						Subvolume* _tmp47_;
						gchar* _tmp48_;
						gchar* _tmp49_;
						JsonArray* _tmp50_;
						Subvolume* _tmp51_;
						gchar* _tmp52_;
						gchar* _tmp53_;
						JsonArray* _tmp54_;
						Subvolume* _tmp55_;
						const gchar* _tmp56_;
						JsonObject* _tmp57_;
						Subvolume* _tmp58_;
						const gchar* _tmp59_;
						JsonArray* _tmp60_;
						JsonArray* _tmp61_;
						_tmp35_ = _subvol_it;
						if (!gee_iterator_next (_tmp35_)) {
							break;
						}
						_tmp36_ = _subvol_it;
						_tmp37_ = gee_iterator_get (_tmp36_);
						subvol = (Subvolume*) _tmp37_;
						_tmp38_ = json_array_new ();
						arr = _tmp38_;
						_tmp39_ = arr;
						_tmp40_ = subvol;
						_tmp41_ = _tmp40_->name;
						json_array_add_string_element (_tmp39_, _tmp41_);
						_tmp42_ = arr;
						_tmp43_ = subvol;
						_tmp44_ = g_strdup_printf ("%li", _tmp43_->id);
						_tmp45_ = _tmp44_;
						json_array_add_string_element (_tmp42_, _tmp45_);
						_g_free0 (_tmp45_);
						_tmp46_ = arr;
						_tmp47_ = subvol;
						_tmp48_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp47_->total_bytes);
						_tmp49_ = _tmp48_;
						json_array_add_string_element (_tmp46_, _tmp49_);
						_g_free0 (_tmp49_);
						_tmp50_ = arr;
						_tmp51_ = subvol;
						_tmp52_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp51_->unshared_bytes);
						_tmp53_ = _tmp52_;
						json_array_add_string_element (_tmp50_, _tmp53_);
						_g_free0 (_tmp53_);
						_tmp54_ = arr;
						_tmp55_ = subvol;
						_tmp56_ = _tmp55_->device_uuid;
						json_array_add_string_element (_tmp54_, _tmp56_);
						_tmp57_ = subvols;
						_tmp58_ = subvol;
						_tmp59_ = _tmp58_->name;
						_tmp60_ = arr;
						_tmp61_ = _json_array_ref0 (_tmp60_);
						json_object_set_array_member (_tmp57_, _tmp59_, _tmp61_);
						_json_array_unref0 (arr);
						_g_object_unref0 (subvol);
					}
					_g_object_unref0 (_subvol_it);
				}
				_json_object_unref0 (subvols);
			}
			_tmp62_ = json_generator_new ();
			json = _tmp62_;
			_tmp63_ = json;
			json_generator_set_pretty (_tmp63_, TRUE);
			_tmp64_ = json;
			json_generator_set_indent (_tmp64_, (guint) 2);
			_tmp65_ = node;
			_tmp66_ = config;
			json_node_set_object (_tmp65_, _tmp66_);
			_tmp67_ = json;
			_tmp68_ = node;
			json_generator_set_root (_tmp67_, _tmp68_);
			_tmp69_ = f;
			g_file_delete (_tmp69_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (json);
				_json_object_unref0 (config);
				__vala_JsonNode_free0 (node);
				_g_object_unref0 (parser);
				_g_object_unref0 (f);
				_g_free0 (ctl_file);
				goto __catch0_g_error;
			}
			_tmp70_ = json;
			_tmp71_ = ctl_file;
			json_generator_to_file (_tmp70_, _tmp71_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (json);
				_json_object_unref0 (config);
				__vala_JsonNode_free0 (node);
				_g_object_unref0 (parser);
				_g_object_unref0 (f);
				_g_free0 (ctl_file);
				goto __catch0_g_error;
			}
			_g_object_unref0 (json);
			_json_object_unref0 (config);
			__vala_JsonNode_free0 (node);
			_g_object_unref0 (parser);
		}
		_g_object_unref0 (f);
		_g_free0 (ctl_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp72_;
		const gchar* _tmp73_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp72_ = e;
		_tmp73_ = _tmp72_->message;
		tee_jee_logging_log_error (_tmp73_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
snapshot_remove_control_file (Snapshot* self)
{
	gchar* ctl_file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->path;
	_tmp1_ = g_strconcat (_tmp0_, "/info.json", NULL);
	ctl_file = _tmp1_;
	tee_jee_file_system_file_delete (ctl_file);
	_g_free0 (ctl_file);
}

Snapshot*
snapshot_write_control_file (const gchar* snapshot_path,
                             GDateTime* dt_created,
                             const gchar* root_uuid,
                             const gchar* distro_full_name,
                             const gchar* tag,
                             const gchar* comments,
                             gint64 item_count,
                             gboolean is_btrfs,
                             gboolean is_live,
                             SnapshotRepo* repo,
                             gboolean silent)
{
	gchar* ctl_path = NULL;
	gchar* _tmp0_;
	JsonObject* config = NULL;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	JsonObject* _tmp7_;
	JsonObject* _tmp8_;
	JsonObject* _tmp9_;
	JsonObject* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	JsonObject* _tmp13_;
	JsonObject* _tmp14_;
	JsonObject* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_ = NULL;
	JsonObject* _tmp19_;
	JsonGenerator* json = NULL;
	JsonGenerator* _tmp20_;
	JsonGenerator* _tmp21_;
	JsonGenerator* _tmp22_;
	JsonNode* node = NULL;
	JsonNode* _tmp23_;
	JsonNode* _tmp24_;
	JsonObject* _tmp25_;
	JsonGenerator* _tmp26_;
	JsonNode* _tmp27_;
	Snapshot* _tmp41_;
	GError* _inner_error0_ = NULL;
	Snapshot* result;
	g_return_val_if_fail (snapshot_path != NULL, NULL);
	g_return_val_if_fail (dt_created != NULL, NULL);
	g_return_val_if_fail (root_uuid != NULL, NULL);
	g_return_val_if_fail (distro_full_name != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	g_return_val_if_fail (comments != NULL, NULL);
	g_return_val_if_fail (repo != NULL, NULL);
	_tmp0_ = g_strconcat (snapshot_path, "/info.json", NULL);
	ctl_path = _tmp0_;
	_tmp1_ = json_object_new ();
	config = _tmp1_;
	_tmp2_ = config;
	_tmp3_ = g_date_time_to_utc (dt_created);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_date_time_to_unix (_tmp4_));
	_tmp6_ = _tmp5_;
	json_object_set_string_member (_tmp2_, "created", _tmp6_);
	_g_free0 (_tmp6_);
	_g_date_time_unref0 (_tmp4_);
	_tmp7_ = config;
	json_object_set_string_member (_tmp7_, "sys-uuid", root_uuid);
	_tmp8_ = config;
	json_object_set_string_member (_tmp8_, "sys-distro", distro_full_name);
	_tmp9_ = config;
	json_object_set_string_member (_tmp9_, "app-version", AppVersion);
	_tmp10_ = config;
	_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, item_count);
	_tmp12_ = _tmp11_;
	json_object_set_string_member (_tmp10_, "file_count", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = config;
	json_object_set_string_member (_tmp13_, "tags", tag);
	_tmp14_ = config;
	json_object_set_string_member (_tmp14_, "comments", comments);
	_tmp15_ = config;
	_tmp16_ = bool_to_string (is_live);
	_tmp17_ = _tmp16_;
	json_object_set_string_member (_tmp15_, "live", _tmp17_);
	_g_free0 (_tmp17_);
	if (is_btrfs) {
		_tmp18_ = "btrfs";
	} else {
		_tmp18_ = "rsync";
	}
	_tmp19_ = config;
	json_object_set_string_member (_tmp19_, "type", _tmp18_);
	_tmp20_ = json_generator_new ();
	json = _tmp20_;
	_tmp21_ = json;
	json_generator_set_pretty (_tmp21_, TRUE);
	_tmp22_ = json;
	json_generator_set_indent (_tmp22_, (guint) 2);
	_tmp23_ = json_node_new (JSON_NODE_OBJECT);
	node = _tmp23_;
	_tmp24_ = node;
	_tmp25_ = config;
	json_node_set_object (_tmp24_, _tmp25_);
	_tmp26_ = json;
	_tmp27_ = node;
	json_generator_set_root (_tmp26_, _tmp27_);
	{
		GFile* f = NULL;
		const gchar* _tmp28_;
		GFile* _tmp29_;
		GFile* _tmp30_;
		JsonGenerator* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = ctl_path;
		_tmp29_ = g_file_new_for_path (_tmp28_);
		f = _tmp29_;
		_tmp30_ = f;
		if (g_file_query_exists (_tmp30_, NULL)) {
			GFile* _tmp31_;
			_tmp31_ = f;
			g_file_delete (_tmp31_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (f);
				goto __catch0_g_error;
			}
		}
		_tmp32_ = json;
		_tmp33_ = ctl_path;
		json_generator_to_file (_tmp32_, _tmp33_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (f);
			goto __catch0_g_error;
		}
		_g_object_unref0 (f);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = e;
		_tmp35_ = _tmp34_->message;
		tee_jee_logging_log_error (_tmp35_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		__vala_JsonNode_free0 (node);
		_g_object_unref0 (json);
		_json_object_unref0 (config);
		_g_free0 (ctl_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	if (!silent) {
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp36_ = ctl_path;
		_tmp37_ = g_strdup_printf (": %s", _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_ ("Created control file"), _tmp38_, NULL);
		_tmp40_ = _tmp39_;
		tee_jee_logging_log_msg (_tmp40_, FALSE);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
	}
	_tmp41_ = snapshot_new (snapshot_path, is_btrfs, repo);
	result = _tmp41_;
	__vala_JsonNode_free0 (node);
	_g_object_unref0 (json);
	_json_object_unref0 (config);
	_g_free0 (ctl_path);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
snapshot_has_subvolumes (Snapshot* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _en_list = NULL;
		GeeArrayList* _tmp0_;
		gint _en_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _en_index = 0;
		_tmp0_ = self->fstab_list;
		_en_list = _tmp0_;
		_tmp1_ = _en_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_en_size = _tmp3_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FsTabEntry* en = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			FsTabEntry* _tmp8_;
			const gchar* _tmp9_;
			_en_index = _en_index + 1;
			_tmp4_ = _en_index;
			_tmp5_ = _en_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _en_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _en_index);
			en = (FsTabEntry*) _tmp7_;
			_tmp8_ = en;
			_tmp9_ = _tmp8_->options;
			if (string_contains (_tmp9_, "subvol=@")) {
				result = TRUE;
				_g_object_unref0 (en);
				return result;
			}
			_g_object_unref0 (en);
		}
	}
	result = FALSE;
	return result;
}

gboolean
snapshot_remove (Snapshot* self,
                 gboolean wait)
{
	const gchar* _tmp0_;
	gboolean status = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->path;
	if (!tee_jee_file_system_dir_exists (_tmp0_)) {
		result = TRUE;
		return result;
	}
	status = TRUE;
	if (self->btrfs_mode) {
		status = snapshot_remove_btrfs (self);
	} else {
		status = snapshot_remove_rsync (self, wait);
	}
	result = status;
	return result;
}

gboolean
snapshot_remove_rsync (Snapshot* self,
                       gboolean wait)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* message = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	DeleteFileTask* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	DeleteFileTask* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	DeleteFileTask* _tmp14_;
	DeleteFileTask* _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strnfill ((gsize) 78, '-');
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_msg (_tmp1_, FALSE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->name;
	_tmp3_ = g_strdup_printf (" '%s'...", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_ ("Removing"), _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	message = _tmp6_;
	_tmp7_ = message;
	tee_jee_logging_log_msg (_tmp7_, FALSE);
	_tmp8_ = self->delete_file_task;
	_tmp9_ = self->path;
	_tmp10_ = g_strdup_printf ("%s/", _tmp9_);
	_g_free0 (_tmp8_->dest_path);
	_tmp8_->dest_path = _tmp10_;
	_tmp11_ = self->delete_file_task;
	_tmp12_ = message;
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 (_tmp11_->status_message);
	_tmp11_->status_message = _tmp13_;
	_tmp14_ = self->delete_file_task;
	((AsyncTask*) _tmp14_)->prg_count_total = main_first_snapshot_count;
	_tmp15_ = self->delete_file_task;
	async_task_execute ((AsyncTask*) _tmp15_);
	if (wait) {
		FILE* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		FILE* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		while (TRUE) {
			DeleteFileTask* _tmp16_;
			FILE* _tmp17_;
			DeleteFileTask* _tmp18_;
			DeleteFileTask* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			FILE* _tmp25_;
			_tmp16_ = self->delete_file_task;
			if (!(((AsyncTask*) _tmp16_)->status == APP_STATUS_RUNNING)) {
				break;
			}
			tee_jee_system_sleep (1000);
			tee_jee_gtk_helper_gtk_do_events ();
			_tmp17_ = stdout;
			_tmp18_ = self->delete_file_task;
			_tmp19_ = self->delete_file_task;
			_tmp20_ = async_task_get_stat_time_remaining ((AsyncTask*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strdup_printf ("%6.2f%% %s (%s %s)\r", ((AsyncTask*) _tmp18_)->progress * 100.0, _ ("complete"), _tmp22_, _ ("remaining"));
			_tmp24_ = _tmp23_;
			fprintf (_tmp17_, "%s", _tmp24_);
			_g_free0 (_tmp24_);
			_g_free0 (_tmp22_);
			_tmp25_ = stdout;
			fflush (_tmp25_);
		}
		_tmp26_ = stdout;
		_tmp27_ = g_strnfill ((gsize) 80, ' ');
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat (_tmp28_, "\r", NULL);
		_tmp30_ = _tmp29_;
		fprintf (_tmp26_, "%s", _tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		_tmp31_ = stdout;
		fflush (_tmp31_);
		_tmp32_ = self->name;
		_tmp33_ = g_strdup_printf ("%s '%s'", _ ("Removed"), _tmp32_);
		_g_free0 (message);
		message = _tmp33_;
		_tmp34_ = message;
		tee_jee_logging_log_msg (_tmp34_, FALSE);
		_tmp35_ = g_strnfill ((gsize) 78, '-');
		_tmp36_ = _tmp35_;
		tee_jee_logging_log_msg (_tmp36_, FALSE);
		_g_free0 (_tmp36_);
	}
	result = TRUE;
	_g_free0 (message);
	return result;
}

gboolean
snapshot_remove_btrfs (Snapshot* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* message = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp47_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strnfill ((gsize) 78, '-');
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_msg (_tmp1_, FALSE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->name;
	_tmp3_ = g_strdup_printf (": %s", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_ ("Removing snapshot"), _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	message = _tmp6_;
	_tmp7_ = message;
	tee_jee_logging_log_msg (_tmp7_, FALSE);
	{
		GeeIterator* _subvol_it = NULL;
		GeeHashMap* _tmp8_;
		GeeCollection* _tmp9_;
		GeeCollection* _tmp10_;
		GeeCollection* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _tmp13_;
		_tmp8_ = self->subvolumes;
		_tmp9_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_subvol_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			Subvolume* subvol = NULL;
			GeeIterator* _tmp15_;
			gpointer _tmp16_;
			gboolean ok = FALSE;
			Subvolume* _tmp17_;
			_tmp14_ = _subvol_it;
			if (!gee_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _subvol_it;
			_tmp16_ = gee_iterator_get (_tmp15_);
			subvol = (Subvolume*) _tmp16_;
			_tmp17_ = subvol;
			ok = subvolume_remove (_tmp17_);
			if (!ok) {
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp18_ = self->name;
				_tmp19_ = g_strdup_printf (": %s", _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strconcat (_ ("Failed to remove snapshot"), _tmp20_, NULL);
				_tmp22_ = _tmp21_;
				tee_jee_logging_log_error (_tmp22_, FALSE, FALSE);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
				_tmp23_ = g_strnfill ((gsize) 78, '-');
				_tmp24_ = _tmp23_;
				tee_jee_logging_log_msg (_tmp24_, FALSE);
				_g_free0 (_tmp24_);
				result = FALSE;
				_g_object_unref0 (subvol);
				_g_object_unref0 (_subvol_it);
				_g_free0 (message);
				return result;
			}
			_g_object_unref0 (subvol);
		}
		_g_object_unref0 (_subvol_it);
	}
	{
		GeeIterator* _subvol_it = NULL;
		GeeHashMap* _tmp25_;
		GeeCollection* _tmp26_;
		GeeCollection* _tmp27_;
		GeeCollection* _tmp28_;
		GeeIterator* _tmp29_;
		GeeIterator* _tmp30_;
		_tmp25_ = self->subvolumes;
		_tmp26_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_;
		_tmp29_ = gee_iterable_iterator ((GeeIterable*) _tmp28_);
		_tmp30_ = _tmp29_;
		_g_object_unref0 (_tmp28_);
		_subvol_it = _tmp30_;
		while (TRUE) {
			GeeIterator* _tmp31_;
			Subvolume* subvol = NULL;
			GeeIterator* _tmp32_;
			gpointer _tmp33_;
			gboolean ok = FALSE;
			GeeHashMap* _tmp34_;
			Subvolume* _tmp35_;
			const gchar* _tmp36_;
			gpointer _tmp37_;
			gchar* _tmp38_;
			gboolean _tmp39_;
			_tmp31_ = _subvol_it;
			if (!gee_iterator_next (_tmp31_)) {
				break;
			}
			_tmp32_ = _subvol_it;
			_tmp33_ = gee_iterator_get (_tmp32_);
			subvol = (Subvolume*) _tmp33_;
			_tmp34_ = self->paths;
			_tmp35_ = subvol;
			_tmp36_ = _tmp35_->name;
			_tmp37_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp34_, _tmp36_);
			_tmp38_ = (gchar*) _tmp37_;
			_tmp39_ = tee_jee_file_system_dir_delete (_tmp38_, TRUE);
			_g_free0 (_tmp38_);
			ok = _tmp39_;
			if (!ok) {
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				_tmp40_ = self->name;
				_tmp41_ = g_strdup_printf (": %s", _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strconcat (_ ("Failed to remove snapshot"), _tmp42_, NULL);
				_tmp44_ = _tmp43_;
				tee_jee_logging_log_error (_tmp44_, FALSE, FALSE);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_tmp45_ = g_strnfill ((gsize) 78, '-');
				_tmp46_ = _tmp45_;
				tee_jee_logging_log_msg (_tmp46_, FALSE);
				_g_free0 (_tmp46_);
				result = FALSE;
				_g_object_unref0 (subvol);
				_g_object_unref0 (_subvol_it);
				_g_free0 (message);
				return result;
			}
			_g_object_unref0 (subvol);
		}
		_g_object_unref0 (_subvol_it);
	}
	_tmp47_ = self->path;
	if (!tee_jee_file_system_dir_delete (_tmp47_, TRUE)) {
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp48_ = self->name;
		_tmp49_ = g_strdup_printf (": %s", _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strconcat (_ ("Failed to remove snapshot"), _tmp50_, NULL);
		_tmp52_ = _tmp51_;
		tee_jee_logging_log_error (_tmp52_, FALSE, FALSE);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
		_tmp53_ = g_strnfill ((gsize) 78, '-');
		_tmp54_ = _tmp53_;
		tee_jee_logging_log_msg (_tmp54_, FALSE);
		_g_free0 (_tmp54_);
		result = FALSE;
		_g_free0 (message);
		return result;
	}
	_tmp55_ = self->name;
	_tmp56_ = g_strdup_printf (": %s", _tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = g_strconcat (_ ("Removed snapshot"), _tmp57_, NULL);
	_tmp59_ = _tmp58_;
	tee_jee_logging_log_msg (_tmp59_, FALSE);
	_g_free0 (_tmp59_);
	_g_free0 (_tmp57_);
	_tmp60_ = g_strnfill ((gsize) 78, '-');
	_tmp61_ = _tmp60_;
	tee_jee_logging_log_msg (_tmp61_, FALSE);
	_g_free0 (_tmp61_);
	result = TRUE;
	_g_free0 (message);
	return result;
}

void
snapshot_mark_for_deletion (Snapshot* self)
{
	gchar* delete_trigger_file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->path;
	_tmp1_ = g_strconcat (_tmp0_, "/delete", NULL);
	delete_trigger_file = _tmp1_;
	_tmp2_ = delete_trigger_file;
	if (!tee_jee_file_system_file_exists (_tmp2_)) {
		const gchar* _tmp3_;
		_tmp3_ = delete_trigger_file;
		tee_jee_file_system_file_write (_tmp3_, "");
		self->marked_for_deletion = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = delete_trigger_file;
		tee_jee_file_system_file_delete (_tmp4_);
		self->marked_for_deletion = FALSE;
	}
	_g_free0 (delete_trigger_file);
}

void
snapshot_parse_log_file (Snapshot* self)
{
	RsyncTask* task = NULL;
	RsyncTask* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = rsync_task_new ();
	task = _tmp0_;
	_tmp1_ = snapshot_get_rsync_log_file (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = rsync_task_parse_log (task, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (task);
}

gchar*
snapshot_get_date_formatted (Snapshot* self)
{
	gchar* result;
	GDateTime* _tmp0_;
	Main* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->date;
	_tmp1_ = App;
	_tmp2_ = _tmp1_->date_format;
	_tmp3_ = g_date_time_format (_tmp0_, _tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
snapshot_get_rsync_log_file (Snapshot* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->path;
	_tmp1_ = tee_jee_file_system_path_combine (_tmp0_, "rsync-log");
	result = _tmp1_;
	return result;
}

gchar*
snapshot_get_rsync_changes_log_file (Snapshot* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->path;
	_tmp1_ = tee_jee_file_system_path_combine (_tmp0_, "rsync-log-changes");
	result = _tmp1_;
	return result;
}

gchar*
snapshot_get_rsync_restore_log_file (Snapshot* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->path;
	_tmp1_ = tee_jee_file_system_path_combine (_tmp0_, "rsync-log-restore");
	result = _tmp1_;
	return result;
}

gchar*
snapshot_get_rsync_restore_changes_log_file (Snapshot* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->path;
	_tmp1_ = tee_jee_file_system_path_combine (_tmp0_, "rsync-log-restore-changes");
	result = _tmp1_;
	return result;
}

gchar*
snapshot_get_exclude_file_for_backup (Snapshot* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->path;
	_tmp1_ = tee_jee_file_system_path_combine (_tmp0_, "exclude.list");
	result = _tmp1_;
	return result;
}

gchar*
snapshot_get_exclude_file_for_restore (Snapshot* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->path;
	_tmp1_ = tee_jee_file_system_path_combine (_tmp0_, "exclude-restore.list");
	result = _tmp1_;
	return result;
}

gchar*
snapshot_get_taglist (Snapshot* self)
{
	gchar* result;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	str = _tmp0_;
	{
		GeeArrayList* _tag_list = NULL;
		GeeArrayList* _tmp1_;
		gint _tag_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tag_index = 0;
		_tmp1_ = self->tags;
		_tag_list = _tmp1_;
		_tmp2_ = _tag_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tag_size = _tmp4_;
		_tag_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* tag = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tag_index = _tag_index + 1;
			_tmp5_ = _tag_index;
			_tmp6_ = _tag_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _tag_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tag_index);
			tag = (gchar*) _tmp8_;
			_tmp9_ = str;
			_tmp10_ = tag;
			_tmp11_ = g_strconcat (" ", _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
			_g_free0 (str);
			str = _tmp13_;
			_g_free0 (_tmp12_);
			_g_free0 (tag);
		}
	}
	_tmp14_ = str;
	_tmp15_ = string_strip (_tmp14_);
	result = _tmp15_;
	_g_free0 (str);
	return result;
}

void
snapshot_set_taglist (Snapshot* self,
                      const gchar* value)
{
	GeeArrayList* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_ = g_strsplit (value, " ", 0);
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
		tag_collection = _tmp2_;
		tag_collection_length1 = _vala_array_length (_tmp1_);
		for (tag_it = 0; tag_it < tag_collection_length1; tag_it = tag_it + 1) {
			gchar* _tmp3_;
			gchar* tag = NULL;
			_tmp3_ = g_strdup (tag_collection[tag_it]);
			tag = _tmp3_;
			{
				GeeArrayList* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gboolean _tmp8_;
				_tmp4_ = self->tags;
				_tmp5_ = tag;
				_tmp6_ = string_strip (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, _tmp7_);
				_g_free0 (_tmp7_);
				if (_tmp8_) {
					GeeArrayList* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp9_ = self->tags;
					_tmp10_ = tag;
					_tmp11_ = string_strip (_tmp10_);
					_tmp12_ = _tmp11_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp12_);
					_g_free0 (_tmp12_);
				}
				_g_free0 (tag);
			}
		}
		tag_collection = (_vala_array_free (tag_collection, tag_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	g_object_notify_by_pspec ((GObject *) self, snapshot_properties[SNAPSHOT_TAGLIST_PROPERTY]);
}

gchar*
snapshot_get_taglist_short (Snapshot* self)
{
	gchar* result;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	str = _tmp0_;
	{
		GeeArrayList* _tag_list = NULL;
		GeeArrayList* _tmp1_;
		gint _tag_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tag_index = 0;
		_tmp1_ = self->tags;
		_tag_list = _tmp1_;
		_tmp2_ = _tag_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tag_size = _tmp4_;
		_tag_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* tag = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tag_index = _tag_index + 1;
			_tmp5_ = _tag_index;
			_tmp6_ = _tag_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _tag_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tag_index);
			tag = (gchar*) _tmp8_;
			_tmp9_ = str;
			_tmp10_ = tag;
			_tmp11_ = string_replace (_tmp10_, "ondemand", "O");
			_tmp12_ = _tmp11_;
			_tmp13_ = string_replace (_tmp12_, "boot", "B");
			_tmp14_ = _tmp13_;
			_tmp15_ = string_replace (_tmp14_, "hourly", "H");
			_tmp16_ = _tmp15_;
			_tmp17_ = string_replace (_tmp16_, "daily", "D");
			_tmp18_ = _tmp17_;
			_tmp19_ = string_replace (_tmp18_, "weekly", "W");
			_tmp20_ = _tmp19_;
			_tmp21_ = string_replace (_tmp20_, "monthly", "M");
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat (" ", _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp9_, _tmp24_, NULL);
			_g_free0 (str);
			str = _tmp25_;
			_g_free0 (_tmp24_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
			_g_free0 (tag);
		}
	}
	_tmp26_ = str;
	_tmp27_ = string_strip (_tmp26_);
	result = _tmp27_;
	_g_free0 (str);
	return result;
}

static gint
_snapshot_subvolumes_sorted___lambda9_ (Snapshot* self,
                                        Subvolume* a,
                                        Subvolume* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = a->name;
	_tmp2_ = b->name;
	result = _tmp0_ (_tmp1_, _tmp2_);
	return result;
}

static gint
__snapshot_subvolumes_sorted___lambda9__gcompare_data_func (gconstpointer a,
                                                            gconstpointer b,
                                                            gpointer self)
{
	gint result;
	result = _snapshot_subvolumes_sorted___lambda9_ ((Snapshot*) self, (Subvolume*) a, (Subvolume*) b);
	return result;
}

GeeArrayList*
snapshot_get_subvolumes_sorted (Snapshot* self)
{
	GeeArrayList* result;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_SUBVOLUME, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	{
		GeeIterator* _subvol_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->subvolumes;
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_subvol_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			Subvolume* subvol = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GeeArrayList* _tmp10_;
			Subvolume* _tmp11_;
			_tmp7_ = _subvol_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _subvol_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			subvol = (Subvolume*) _tmp9_;
			_tmp10_ = list;
			_tmp11_ = subvol;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			_g_object_unref0 (subvol);
		}
		_g_object_unref0 (_subvol_it);
	}
	_tmp12_ = list;
	gee_list_sort ((GeeList*) _tmp12_, __snapshot_subvolumes_sorted___lambda9__gcompare_data_func, g_object_ref (self), g_object_unref);
	result = list;
	return result;
}

static void
snapshot_class_init (SnapshotClass * klass,
                     gpointer klass_data)
{
	snapshot_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_snapshot_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_snapshot_set_property;
	G_OBJECT_CLASS (klass)->finalize = snapshot_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_DATE_FORMATTED_PROPERTY, snapshot_properties[SNAPSHOT_DATE_FORMATTED_PROPERTY] = g_param_spec_string ("date-formatted", "date-formatted", "date-formatted", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_RSYNC_LOG_FILE_PROPERTY, snapshot_properties[SNAPSHOT_RSYNC_LOG_FILE_PROPERTY] = g_param_spec_string ("rsync-log-file", "rsync-log-file", "rsync-log-file", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_RSYNC_CHANGES_LOG_FILE_PROPERTY, snapshot_properties[SNAPSHOT_RSYNC_CHANGES_LOG_FILE_PROPERTY] = g_param_spec_string ("rsync-changes-log-file", "rsync-changes-log-file", "rsync-changes-log-file", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_RSYNC_RESTORE_LOG_FILE_PROPERTY, snapshot_properties[SNAPSHOT_RSYNC_RESTORE_LOG_FILE_PROPERTY] = g_param_spec_string ("rsync-restore-log-file", "rsync-restore-log-file", "rsync-restore-log-file", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_RSYNC_RESTORE_CHANGES_LOG_FILE_PROPERTY, snapshot_properties[SNAPSHOT_RSYNC_RESTORE_CHANGES_LOG_FILE_PROPERTY] = g_param_spec_string ("rsync-restore-changes-log-file", "rsync-restore-changes-log-file", "rsync-restore-changes-log-file", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_EXCLUDE_FILE_FOR_BACKUP_PROPERTY, snapshot_properties[SNAPSHOT_EXCLUDE_FILE_FOR_BACKUP_PROPERTY] = g_param_spec_string ("exclude-file-for-backup", "exclude-file-for-backup", "exclude-file-for-backup", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_EXCLUDE_FILE_FOR_RESTORE_PROPERTY, snapshot_properties[SNAPSHOT_EXCLUDE_FILE_FOR_RESTORE_PROPERTY] = g_param_spec_string ("exclude-file-for-restore", "exclude-file-for-restore", "exclude-file-for-restore", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_TAGLIST_PROPERTY, snapshot_properties[SNAPSHOT_TAGLIST_PROPERTY] = g_param_spec_string ("taglist", "taglist", "taglist", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_TAGLIST_SHORT_PROPERTY, snapshot_properties[SNAPSHOT_TAGLIST_SHORT_PROPERTY] = g_param_spec_string ("taglist-short", "taglist-short", "taglist-short", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_SUBVOLUMES_SORTED_PROPERTY, snapshot_properties[SNAPSHOT_SUBVOLUMES_SORTED_PROPERTY] = g_param_spec_object ("subvolumes-sorted", "subvolumes-sorted", "subvolumes-sorted", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
snapshot_instance_init (Snapshot * self,
                        gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = g_strdup ("");
	self->path = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->name = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->sys_uuid = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->sys_distro = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->app_version = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->description = _tmp5_;
	self->file_count = (gint64) 0;
	self->valid = TRUE;
	self->live = FALSE;
	self->marked_for_deletion = FALSE;
	self->btrfs_mode = FALSE;
	_tmp6_ = g_strdup ("");
	self->mount_path_root = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->mount_path_home = _tmp7_;
}

static void
snapshot_finalize (GObject * obj)
{
	Snapshot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SNAPSHOT, Snapshot);
	_g_free0 (self->path);
	_g_free0 (self->name);
	_g_date_time_unref0 (self->date);
	_g_free0 (self->sys_uuid);
	_g_free0 (self->sys_distro);
	_g_free0 (self->app_version);
	_g_free0 (self->description);
	_g_object_unref0 (self->tags);
	_g_object_unref0 (self->exclude_list);
	_g_object_unref0 (self->subvolumes);
	_g_object_unref0 (self->fstab_list);
	_g_object_unref0 (self->cryttab_list);
	_g_object_unref0 (self->distro);
	_g_object_unref0 (self->repo);
	_g_object_unref0 (self->paths);
	_g_free0 (self->mount_path_root);
	_g_free0 (self->mount_path_home);
	_g_object_unref0 (self->delete_file_task);
	G_OBJECT_CLASS (snapshot_parent_class)->finalize (obj);
}

static GType
snapshot_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SnapshotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) snapshot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Snapshot), 0, (GInstanceInitFunc) snapshot_instance_init, NULL };
	GType snapshot_type_id;
	snapshot_type_id = g_type_register_static (G_TYPE_OBJECT, "Snapshot", &g_define_type_info, 0);
	return snapshot_type_id;
}

GType
snapshot_get_type (void)
{
	static volatile gsize snapshot_type_id__once = 0;
	if (g_once_init_enter (&snapshot_type_id__once)) {
		GType snapshot_type_id;
		snapshot_type_id = snapshot_get_type_once ();
		g_once_init_leave (&snapshot_type_id__once, snapshot_type_id);
	}
	return snapshot_type_id__once;
}

static void
_vala_snapshot_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Snapshot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SNAPSHOT, Snapshot);
	switch (property_id) {
		case SNAPSHOT_DATE_FORMATTED_PROPERTY:
		g_value_take_string (value, snapshot_get_date_formatted (self));
		break;
		case SNAPSHOT_RSYNC_LOG_FILE_PROPERTY:
		g_value_take_string (value, snapshot_get_rsync_log_file (self));
		break;
		case SNAPSHOT_RSYNC_CHANGES_LOG_FILE_PROPERTY:
		g_value_take_string (value, snapshot_get_rsync_changes_log_file (self));
		break;
		case SNAPSHOT_RSYNC_RESTORE_LOG_FILE_PROPERTY:
		g_value_take_string (value, snapshot_get_rsync_restore_log_file (self));
		break;
		case SNAPSHOT_RSYNC_RESTORE_CHANGES_LOG_FILE_PROPERTY:
		g_value_take_string (value, snapshot_get_rsync_restore_changes_log_file (self));
		break;
		case SNAPSHOT_EXCLUDE_FILE_FOR_BACKUP_PROPERTY:
		g_value_take_string (value, snapshot_get_exclude_file_for_backup (self));
		break;
		case SNAPSHOT_EXCLUDE_FILE_FOR_RESTORE_PROPERTY:
		g_value_take_string (value, snapshot_get_exclude_file_for_restore (self));
		break;
		case SNAPSHOT_TAGLIST_PROPERTY:
		g_value_take_string (value, snapshot_get_taglist (self));
		break;
		case SNAPSHOT_TAGLIST_SHORT_PROPERTY:
		g_value_take_string (value, snapshot_get_taglist_short (self));
		break;
		case SNAPSHOT_SUBVOLUMES_SORTED_PROPERTY:
		g_value_take_object (value, snapshot_get_subvolumes_sorted (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_snapshot_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Snapshot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SNAPSHOT, Snapshot);
	switch (property_id) {
		case SNAPSHOT_TAGLIST_PROPERTY:
		snapshot_set_taglist (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

