/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "knative.dev/networking/pkg/apis/networking/v1alpha1"
	scheme "knative.dev/networking/pkg/client/clientset/versioned/scheme"
)

// ClusterDomainClaimsGetter has a method to return a ClusterDomainClaimInterface.
// A group's client should implement this interface.
type ClusterDomainClaimsGetter interface {
	ClusterDomainClaims() ClusterDomainClaimInterface
}

// ClusterDomainClaimInterface has methods to work with ClusterDomainClaim resources.
type ClusterDomainClaimInterface interface {
	Create(ctx context.Context, clusterDomainClaim *v1alpha1.ClusterDomainClaim, opts v1.CreateOptions) (*v1alpha1.ClusterDomainClaim, error)
	Update(ctx context.Context, clusterDomainClaim *v1alpha1.ClusterDomainClaim, opts v1.UpdateOptions) (*v1alpha1.ClusterDomainClaim, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ClusterDomainClaim, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ClusterDomainClaimList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterDomainClaim, err error)
	ClusterDomainClaimExpansion
}

// clusterDomainClaims implements ClusterDomainClaimInterface
type clusterDomainClaims struct {
	client rest.Interface
}

// newClusterDomainClaims returns a ClusterDomainClaims
func newClusterDomainClaims(c *NetworkingV1alpha1Client) *clusterDomainClaims {
	return &clusterDomainClaims{
		client: c.RESTClient(),
	}
}

// Get takes name of the clusterDomainClaim, and returns the corresponding clusterDomainClaim object, and an error if there is any.
func (c *clusterDomainClaims) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ClusterDomainClaim, err error) {
	result = &v1alpha1.ClusterDomainClaim{}
	err = c.client.Get().
		Resource("clusterdomainclaims").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterDomainClaims that match those selectors.
func (c *clusterDomainClaims) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ClusterDomainClaimList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ClusterDomainClaimList{}
	err = c.client.Get().
		Resource("clusterdomainclaims").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterDomainClaims.
func (c *clusterDomainClaims) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("clusterdomainclaims").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a clusterDomainClaim and creates it.  Returns the server's representation of the clusterDomainClaim, and an error, if there is any.
func (c *clusterDomainClaims) Create(ctx context.Context, clusterDomainClaim *v1alpha1.ClusterDomainClaim, opts v1.CreateOptions) (result *v1alpha1.ClusterDomainClaim, err error) {
	result = &v1alpha1.ClusterDomainClaim{}
	err = c.client.Post().
		Resource("clusterdomainclaims").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterDomainClaim).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a clusterDomainClaim and updates it. Returns the server's representation of the clusterDomainClaim, and an error, if there is any.
func (c *clusterDomainClaims) Update(ctx context.Context, clusterDomainClaim *v1alpha1.ClusterDomainClaim, opts v1.UpdateOptions) (result *v1alpha1.ClusterDomainClaim, err error) {
	result = &v1alpha1.ClusterDomainClaim{}
	err = c.client.Put().
		Resource("clusterdomainclaims").
		Name(clusterDomainClaim.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterDomainClaim).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the clusterDomainClaim and deletes it. Returns an error if one occurs.
func (c *clusterDomainClaims) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("clusterdomainclaims").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterDomainClaims) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("clusterdomainclaims").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched clusterDomainClaim.
func (c *clusterDomainClaims) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterDomainClaim, err error) {
	result = &v1alpha1.ClusterDomainClaim{}
	err = c.client.Patch(pt).
		Resource("clusterdomainclaims").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
