/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_APP_ID_RESOLVER_V1_SERVER_PROTOCOL_H
#define TREELAND_APP_ID_RESOLVER_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_app_id_resolver_v1 The treeland_app_id_resolver_v1 protocol
 * @section page_ifaces_treeland_app_id_resolver_v1 Interfaces
 * - @subpage page_iface_treeland_app_id_resolver_manager_v1 - manager for app id resolver
 * - @subpage page_iface_treeland_app_id_resolver_v1 - app id resolver
 * @section page_copyright_treeland_app_id_resolver_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_app_id_resolver_manager_v1;
struct treeland_app_id_resolver_v1;

#ifndef TREELAND_APP_ID_RESOLVER_MANAGER_V1_INTERFACE
#define TREELAND_APP_ID_RESOLVER_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_app_id_resolver_manager_v1 treeland_app_id_resolver_manager_v1
 * @section page_iface_treeland_app_id_resolver_manager_v1_desc Description
 *
 * Create a resolver object. Typically exactly one privileged helper
 * (a Wayland client with DBus access) binds this interface and serves
 * identification requests coming from the compositor.
 * @section page_iface_treeland_app_id_resolver_manager_v1_api API
 * See @ref iface_treeland_app_id_resolver_manager_v1.
 */
/**
 * @defgroup iface_treeland_app_id_resolver_manager_v1 The treeland_app_id_resolver_manager_v1 interface
 *
 * Create a resolver object. Typically exactly one privileged helper
 * (a Wayland client with DBus access) binds this interface and serves
 * identification requests coming from the compositor.
 */
extern const struct wl_interface treeland_app_id_resolver_manager_v1_interface;
#endif
#ifndef TREELAND_APP_ID_RESOLVER_V1_INTERFACE
#define TREELAND_APP_ID_RESOLVER_V1_INTERFACE
/**
 * @page page_iface_treeland_app_id_resolver_v1 treeland_app_id_resolver_v1
 * @section page_iface_treeland_app_id_resolver_v1_desc Description
 *
 * The compositor sends identify_request with a unique request_id and a pidfd.
 * The client must answer exactly once via respond(request_id, app_id). If
 * resolution fails respond with an empty string.
 * @section page_iface_treeland_app_id_resolver_v1_api API
 * See @ref iface_treeland_app_id_resolver_v1.
 */
/**
 * @defgroup iface_treeland_app_id_resolver_v1 The treeland_app_id_resolver_v1 interface
 *
 * The compositor sends identify_request with a unique request_id and a pidfd.
 * The client must answer exactly once via respond(request_id, app_id). If
 * resolution fails respond with an empty string.
 */
extern const struct wl_interface treeland_app_id_resolver_v1_interface;
#endif

#ifndef TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_ENUM
#define TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_ENUM
enum treeland_app_id_resolver_manager_v1_error {
	/**
	 * A resolver is already registered in this session with the manager
	 */
	TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_RESOLVER_ALREADY_EXISTS = 1,
};
#endif /* TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_ENUM */

#ifndef TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_ENUM_IS_VALID
#define TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_app_id_resolver_manager_v1
 * Validate a treeland_app_id_resolver_manager_v1 error value.
 *
 * @return true on success, false on error.
 * @ref treeland_app_id_resolver_manager_v1_error
 */
static inline bool
treeland_app_id_resolver_manager_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_RESOLVER_ALREADY_EXISTS:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_APP_ID_RESOLVER_MANAGER_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_app_id_resolver_manager_v1
 * @struct treeland_app_id_resolver_manager_v1_interface
 */
struct treeland_app_id_resolver_manager_v1_interface {
	/**
	 * destroy the manager
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create/bind a resolver object
	 *
	 * Create or bind a resolver object. Only one resolver may be
	 * registered per session. Treeland is a multi-user compositor;
	 * different user sessions may each register their own resolver. If
	 * a resolver is already bound in the same session, the compositor
	 * will report an error on the manager and will NOT create a new
	 * resolver object for this request.
	 */
	void (*get_resolver)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t id);
};


/**
 * @ingroup iface_treeland_app_id_resolver_manager_v1
 */
#define TREELAND_APP_ID_RESOLVER_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_app_id_resolver_manager_v1
 */
#define TREELAND_APP_ID_RESOLVER_MANAGER_V1_GET_RESOLVER_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_app_id_resolver_v1
 * @struct treeland_app_id_resolver_v1_interface
 */
struct treeland_app_id_resolver_v1_interface {
	/**
	 * respond with app id and sandbox_engine_name (empty app_id on failure)
	 *
	 * Respond to an identify_request. The sandbox_engine_name must
	 * be provided and matches the context in which the process is
	 * running (container, sandbox, etc). If resolution fails, respond
	 * with an empty app_id.
	 * @param sandbox_engine_name the sandbox engine / security context name (required, non-empty)
	 */
	void (*respond)(struct wl_client *client,
			struct wl_resource *resource,
			uint32_t request_id,
			const char *app_id,
			const char *sandbox_engine_name);
	/**
	 * destroy resolver
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_APP_ID_RESOLVER_V1_IDENTIFY_REQUEST 0

/**
 * @ingroup iface_treeland_app_id_resolver_v1
 */
#define TREELAND_APP_ID_RESOLVER_V1_IDENTIFY_REQUEST_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_app_id_resolver_v1
 */
#define TREELAND_APP_ID_RESOLVER_V1_RESPOND_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_app_id_resolver_v1
 */
#define TREELAND_APP_ID_RESOLVER_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_app_id_resolver_v1
 * Sends an identify_request event to the client owning the resource.
 * @param resource_ The client's resource
 * @param request_id monotonic id generated by compositor
 * @param pidfd pidfd referencing the target process
 */
static inline void
treeland_app_id_resolver_v1_send_identify_request(struct wl_resource *resource_, uint32_t request_id, int32_t pidfd)
{
	wl_resource_post_event(resource_, TREELAND_APP_ID_RESOLVER_V1_IDENTIFY_REQUEST, request_id, pidfd);
}

#ifdef  __cplusplus
}
#endif

#endif
