// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "ShadowPropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

ShadowPropertyGroup::ShadowPropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_offset = std::make_unique<OffsetPropertyGroup>(m_style);
    m_left = std::make_unique<LinePropertyGroup>(m_style);
    m_right = std::make_unique<LinePropertyGroup>(m_style);
    m_top = std::make_unique<LinePropertyGroup>(m_style);
    m_bottom = std::make_unique<LinePropertyGroup>(m_style);
    m_topLeft = std::make_unique<CornerPropertyGroup>(m_style);
    m_topRight = std::make_unique<CornerPropertyGroup>(m_style);
    m_bottomLeft = std::make_unique<CornerPropertyGroup>(m_style);
    m_bottomRight = std::make_unique<CornerPropertyGroup>(m_style);
}

void ShadowPropertyGroup::update(const std::optional<ShadowProperty> &newState)
{
    m_state = newState;

    if (!newState) {
        m_offset->update(std::nullopt);
        m_left->update(std::nullopt);
        m_right->update(std::nullopt);
        m_top->update(std::nullopt);
        m_bottom->update(std::nullopt);
        m_topLeft->update(std::nullopt);
        m_topRight->update(std::nullopt);
        m_bottomLeft->update(std::nullopt);
        m_bottomRight->update(std::nullopt);
    } else {
        m_offset->update(newState.value().offset());
        m_left->update(newState.value().left());
        m_right->update(newState.value().right());
        m_top->update(newState.value().top());
        m_bottom->update(newState.value().bottom());
        m_topLeft->update(newState.value().topLeft());
        m_topRight->update(newState.value().topRight());
        m_bottomLeft->update(newState.value().bottomLeft());
        m_bottomRight->update(newState.value().bottomRight());
    }

    Q_EMIT colorChanged();
    Q_EMIT sizeChanged();
    Q_EMIT blurChanged();
    Q_EMIT updated();
}

OffsetPropertyGroup *ShadowPropertyGroup::offset() const
{
    return m_offset.get();
}

QJSValue ShadowPropertyGroup::color() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().color();
    if (value) {
        return m_style->engine()->toScriptValue(value.value().toQColor());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue ShadowPropertyGroup::size() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().size();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue ShadowPropertyGroup::blur() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().blur();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

LinePropertyGroup *ShadowPropertyGroup::left() const
{
    return m_left.get();
}

LinePropertyGroup *ShadowPropertyGroup::right() const
{
    return m_right.get();
}

LinePropertyGroup *ShadowPropertyGroup::top() const
{
    return m_top.get();
}

LinePropertyGroup *ShadowPropertyGroup::bottom() const
{
    return m_bottom.get();
}

CornerPropertyGroup *ShadowPropertyGroup::topLeft() const
{
    return m_topLeft.get();
}

CornerPropertyGroup *ShadowPropertyGroup::topRight() const
{
    return m_topRight.get();
}

CornerPropertyGroup *ShadowPropertyGroup::bottomLeft() const
{
    return m_bottomLeft.get();
}

CornerPropertyGroup *ShadowPropertyGroup::bottomRight() const
{
    return m_bottomRight.get();
}

#include "moc_ShadowPropertyGroup.cpp"