/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMouseEventInit.h"

#include "EventTargetInlines.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSEventTarget.h"
#include "JSWindowProxy.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<MouseEventInit>> convertDictionary<MouseEventInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MouseEventInit result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto detailConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, detailValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (detailConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.detail = detailConversionResult.releaseReturnValue();
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto viewConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<WindowProxy>>> { return typename Converter<IDLNullable<IDLInterface<WindowProxy>>>::ReturnType { nullptr }; });
    if (viewConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.view = viewConversionResult.releaseReturnValue();
    JSValue altKeyValue;
    if (isNullOrUndefined)
        altKeyValue = jsUndefined();
    else {
        altKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "altKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto altKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, altKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (altKeyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.altKey = altKeyConversionResult.releaseReturnValue();
    JSValue ctrlKeyValue;
    if (isNullOrUndefined)
        ctrlKeyValue = jsUndefined();
    else {
        ctrlKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ctrlKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto ctrlKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, ctrlKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (ctrlKeyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.ctrlKey = ctrlKeyConversionResult.releaseReturnValue();
    JSValue metaKeyValue;
    if (isNullOrUndefined)
        metaKeyValue = jsUndefined();
    else {
        metaKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "metaKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto metaKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, metaKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (metaKeyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.metaKey = metaKeyConversionResult.releaseReturnValue();
    JSValue modifierAltGraphValue;
    if (isNullOrUndefined)
        modifierAltGraphValue = jsUndefined();
    else {
        modifierAltGraphValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierAltGraph"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto modifierAltGraphConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, modifierAltGraphValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (modifierAltGraphConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.modifierAltGraph = modifierAltGraphConversionResult.releaseReturnValue();
    JSValue modifierCapsLockValue;
    if (isNullOrUndefined)
        modifierCapsLockValue = jsUndefined();
    else {
        modifierCapsLockValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierCapsLock"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto modifierCapsLockConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, modifierCapsLockValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (modifierCapsLockConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.modifierCapsLock = modifierCapsLockConversionResult.releaseReturnValue();
    JSValue shiftKeyValue;
    if (isNullOrUndefined)
        shiftKeyValue = jsUndefined();
    else {
        shiftKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shiftKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto shiftKeyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, shiftKeyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (shiftKeyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.shiftKey = shiftKeyConversionResult.releaseReturnValue();
    JSValue buttonValue;
    if (isNullOrUndefined)
        buttonValue = jsUndefined();
    else {
        buttonValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "button"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto buttonConversionResult = convertOptionalWithDefault<IDLShort>(lexicalGlobalObject, buttonValue, [&]() -> ConversionResult<IDLShort> { return Converter<IDLShort>::ReturnType { 0 }; });
    if (buttonConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.button = buttonConversionResult.releaseReturnValue();
    JSValue buttonsValue;
    if (isNullOrUndefined)
        buttonsValue = jsUndefined();
    else {
        buttonsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buttons"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto buttonsConversionResult = convertOptionalWithDefault<IDLUnsignedShort>(lexicalGlobalObject, buttonsValue, [&]() -> ConversionResult<IDLUnsignedShort> { return Converter<IDLUnsignedShort>::ReturnType { 0 }; });
    if (buttonsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.buttons = buttonsConversionResult.releaseReturnValue();
    JSValue clientXValue;
    if (isNullOrUndefined)
        clientXValue = jsUndefined();
    else {
        clientXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto clientXConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, clientXValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (clientXConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.clientX = clientXConversionResult.releaseReturnValue();
    JSValue clientYValue;
    if (isNullOrUndefined)
        clientYValue = jsUndefined();
    else {
        clientYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto clientYConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, clientYValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (clientYConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.clientY = clientYConversionResult.releaseReturnValue();
    JSValue movementXValue;
    if (isNullOrUndefined)
        movementXValue = jsUndefined();
    else {
        movementXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "movementX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto movementXConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, movementXValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (movementXConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.movementX = movementXConversionResult.releaseReturnValue();
    JSValue movementYValue;
    if (isNullOrUndefined)
        movementYValue = jsUndefined();
    else {
        movementYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "movementY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto movementYConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, movementYValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (movementYConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.movementY = movementYConversionResult.releaseReturnValue();
    JSValue relatedTargetValue;
    if (isNullOrUndefined)
        relatedTargetValue = jsUndefined();
    else {
        relatedTargetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "relatedTarget"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto relatedTargetConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<EventTarget>>>(lexicalGlobalObject, relatedTargetValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<EventTarget>>> { return typename Converter<IDLNullable<IDLInterface<EventTarget>>>::ReturnType { nullptr }; });
    if (relatedTargetConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.relatedTarget = relatedTargetConversionResult.releaseReturnValue();
    JSValue screenXValue;
    if (isNullOrUndefined)
        screenXValue = jsUndefined();
    else {
        screenXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenX"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto screenXConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, screenXValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (screenXConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.screenX = screenXConversionResult.releaseReturnValue();
    JSValue screenYValue;
    if (isNullOrUndefined)
        screenYValue = jsUndefined();
    else {
        screenYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenY"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto screenYConversionResult = convertOptionalWithDefault<IDLLong>(lexicalGlobalObject, screenYValue, [&]() -> ConversionResult<IDLLong> { return Converter<IDLLong>::ReturnType { 0 }; });
    if (screenYConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.screenY = screenYConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

