/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCommandLineAPIHost.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "EventTargetInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventTarget.h"
#include "JSStorage.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Vector.h>
#include <wtf/text/MakeString.h>

#if ENABLE(WEB_RTC)
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertNullable.h"
#include "JSRTCLogsCallback.h"
#endif

namespace WebCore {
using namespace JSC;

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const CommandLineAPIHost::ListenerEntry& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto listenerValue = toJS<IDLObject>(lexicalGlobalObject, throwScope, dictionary.listener);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "listener"_s), listenerValue);
    auto onceValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.once);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "once"_s), onceValue);
    auto passiveValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.passive);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "passive"_s), passiveValue);
    auto useCaptureValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.useCapture);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "useCapture"_s), useCaptureValue);
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_copyText);
static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_inspect);
static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_inspectedObject);
static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_getEventListeners);
#if ENABLE(WEB_RTC)
static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_gatherRTCLogs);
#endif
static JSC_DECLARE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_storageId);

class JSCommandLineAPIHostPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCommandLineAPIHostPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCommandLineAPIHostPrototype* ptr = new (NotNull, JSC::allocateCell<JSCommandLineAPIHostPrototype>(vm)) JSCommandLineAPIHostPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCommandLineAPIHostPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCommandLineAPIHostPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCommandLineAPIHostPrototype, JSCommandLineAPIHostPrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSCommandLineAPIHostPrototypeTableValues {
    HashTableValue { "copyText"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_copyText, 1 } },
    HashTableValue { "inspect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_inspect, 2 } },
    HashTableValue { "inspectedObject"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_inspectedObject, 0 } },
    HashTableValue { "getEventListeners"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_getEventListeners, 1 } },
#if ENABLE(WEB_RTC)
    HashTableValue { "gatherRTCLogs"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_gatherRTCLogs, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "storageId"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCommandLineAPIHostPrototypeFunction_storageId, 1 } },
};

const ClassInfo JSCommandLineAPIHostPrototype::s_info = { "CommandLineAPIHost"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCommandLineAPIHostPrototype) };

void JSCommandLineAPIHostPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCommandLineAPIHost::info(), JSCommandLineAPIHostPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCommandLineAPIHost::s_info = { "CommandLineAPIHost"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCommandLineAPIHost) };

JSCommandLineAPIHost::JSCommandLineAPIHost(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CommandLineAPIHost>&& impl)
    : JSDOMWrapper<CommandLineAPIHost>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CommandLineAPIHost>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCommandLineAPIHost::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCommandLineAPIHostPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCommandLineAPIHostPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCommandLineAPIHost::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCommandLineAPIHost>(vm, globalObject);
}

void JSCommandLineAPIHost::destroy(JSC::JSCell* cell)
{
    JSCommandLineAPIHost* thisObject = static_cast<JSCommandLineAPIHost*>(cell);
    thisObject->JSCommandLineAPIHost::~JSCommandLineAPIHost();
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_copyTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto textConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (textConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyText(textConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_copyText, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_copyTextBody>(*lexicalGlobalObject, *callFrame, "copyText");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_inspectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto objectToInspectConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (objectToInspectConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto hintsConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument1.value());
    if (hintsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.inspect(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), objectToInspectConversionResult.releaseReturnValue(), hintsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_inspect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_inspectBody>(*lexicalGlobalObject, *callFrame, "inspect");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_inspectedObjectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, impl.inspectedObject(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)))));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_inspectedObject, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_inspectedObjectBody>(*lexicalGlobalObject, *callFrame, "inspectedObject");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_getEventListenersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto targetConversionResult = convert<IDLInterface<EventTarget>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target"_s, "CommandLineAPIHost"_s, "getEventListeners"_s, "EventTarget"_s); });
    if (targetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLRecord<IDLDOMString, IDLSequence<IDLDictionary<CommandLineAPIHost::ListenerEntry>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getEventListeners(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), *targetConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_getEventListeners, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_getEventListenersBody>(*lexicalGlobalObject, *callFrame, "getEventListeners");
}

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_gatherRTCLogsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSRTCLogsCallback>>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback"_s, "CommandLineAPIHost"_s, "gatherRTCLogs"_s); });
    if (callbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.gatherRTCLogs(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), callbackConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_gatherRTCLogs, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_gatherRTCLogsBody>(*lexicalGlobalObject, *callFrame, "gatherRTCLogs");
}

#endif

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunction_storageIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto storageConversionResult = convert<IDLInterface<Storage>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "storage"_s, "CommandLineAPIHost"_s, "storageId"_s, "Storage"_s); });
    if (storageConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.storageId(*storageConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsCommandLineAPIHostPrototypeFunction_storageId, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunction_storageIdBody>(*lexicalGlobalObject, *callFrame, "storageId");
}

JSC::GCClient::IsoSubspace* JSCommandLineAPIHost::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCommandLineAPIHost, UseCustomHeapCellType::No>(vm, "JSCommandLineAPIHost"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCommandLineAPIHost.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCommandLineAPIHost = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCommandLineAPIHost.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCommandLineAPIHost = std::forward<decltype(space)>(space); }
    );
}

void JSCommandLineAPIHost::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCommandLineAPIHost*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSCommandLineAPIHostOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCommandLineAPIHostOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCommandLineAPIHost = static_cast<JSCommandLineAPIHost*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCommandLineAPIHost->protectedWrapped().ptr(), jsCommandLineAPIHost);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CommandLineAPIHost@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18CommandLineAPIHostE[]; }
#endif
template<std::same_as<CommandLineAPIHost> T>
static inline void verifyVTable(CommandLineAPIHost* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CommandLineAPIHost@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18CommandLineAPIHostE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CommandLineAPIHost has subclasses. If CommandLineAPIHost has subclasses that get passed
        // to toJS() we currently require CommandLineAPIHost you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CommandLineAPIHost>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CommandLineAPIHost>(impl.ptr());
#endif
    return createWrapper<CommandLineAPIHost>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CommandLineAPIHost& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CommandLineAPIHost* JSCommandLineAPIHost::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCommandLineAPIHost*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
