// ResonanceUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef ResonanceUI_h
#define ResonanceUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2010, Alan Calvert
// Copyright 2015-2023, Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of the ZynAddSubFX original


#include <FL/Fl_Box.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Value_Output.H>
#include "UI/ScaleTrackedWindow.h"
#include "UI/MiscGui.h"
#include "UI/WidgetPDial.h"
#include "UI/WidgetCheckButton.h"
#include "UI/WidgetMWSlider.h"
#include "PresetsUI.h"
#include "Synth/Resonance.h"
#include "Misc/SynthEngine.h"

class ResonanceGraph : public Fl_Box {
public:
  ResonanceGraph(int x,int y, int w, int h, const char *label=0);
  void send_data(int action, int control, float value, int type);
  void init(Resonance *respar_, Fl_Value_Output *khzvalue_, Fl_Value_Output *dbvalue_, int npart_, int kititem_, int engine_);
  void draw_freq_line(float freq);
  void draw();
  int handle(int event);
private:
  Fl_Value_Output *khzvalue;
  Fl_Value_Output *dbvalue;
  SynthEngine *synth;
  int npart;
  int kititem;
  int engine;
  Resonance *respar;
  int oldx,oldy;
public:
  float khzval;
private:
  Fl_Widget *cbwidget,*applybutton;
};
#include <FL/Fl_Group.H>
#include <FL/Fl_Value_Output.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Box.H>

class ResonanceUI : PresetsUI_ {
public:
  ScaleTrackedWindow* make_window();
  ScaleTrackedWindow *resonancewindow;
private:
  inline void cb_resonancewindow_i(ScaleTrackedWindow*, void*);
  static void cb_resonancewindow(ScaleTrackedWindow*, void*);
public:
  Fl_Group *editor;
  Fl_Value_Output *khzvalue;
  Fl_Value_Output *dbvalue;
  Fl_Group *frame;
  mwheel_slider_rev *maxdb;
private:
  inline void cb_maxdb_i(mwheel_slider_rev*, void*);
  static void cb_maxdb(mwheel_slider_rev*, void*);
public:
  Fl_Value_Output *maxdbvo;
private:
  inline void cb_maxdbvo_i(Fl_Value_Output*, void*);
  static void cb_maxdbvo(Fl_Value_Output*, void*);
public:
  mwheel_slider_rev *centerfreq;
private:
  inline void cb_centerfreq_i(mwheel_slider_rev*, void*);
  static void cb_centerfreq(mwheel_slider_rev*, void*);
public:
  Fl_Value_Output *centerfreqvo;
private:
  inline void cb_centerfreqvo_i(Fl_Value_Output*, void*);
  static void cb_centerfreqvo(Fl_Value_Output*, void*);
public:
  mwheel_slider_rev *octavesfreq;
private:
  inline void cb_octavesfreq_i(mwheel_slider_rev*, void*);
  static void cb_octavesfreq(mwheel_slider_rev*, void*);
public:
  Fl_Value_Output *octavesfreqvo;
private:
  inline void cb_octavesfreqvo_i(Fl_Value_Output*, void*);
  static void cb_octavesfreqvo(Fl_Value_Output*, void*);
public:
  Fl_Button *clearbutton;
private:
  inline void cb_clearbutton_i(Fl_Button*, void*);
  static void cb_clearbutton(Fl_Button*, void*);
public:
  Fl_Button *smoothbutton;
private:
  inline void cb_smoothbutton_i(Fl_Button*, void*);
  static void cb_smoothbutton(Fl_Button*, void*);
public:
  Fl_Button *rnd1;
private:
  inline void cb_rnd1_i(Fl_Button*, void*);
  static void cb_rnd1(Fl_Button*, void*);
public:
  Fl_Button *rnd2;
private:
  inline void cb_rnd2_i(Fl_Button*, void*);
  static void cb_rnd2(Fl_Button*, void*);
public:
  Fl_Button *rnd3;
private:
  inline void cb_rnd3_i(Fl_Button*, void*);
  static void cb_rnd3(Fl_Button*, void*);
public:
  Fl_Check_Button2 *p1st;
private:
  inline void cb_p1st_i(Fl_Check_Button2*, void*);
  static void cb_p1st(Fl_Check_Button2*, void*);
public:
  Fl_Text_Display *interpk;
  Fl_Button *sbutton;
private:
  inline void cb_sbutton_i(Fl_Button*, void*);
  static void cb_sbutton(Fl_Button*, void*);
public:
  Fl_Button *lbutton;
private:
  inline void cb_lbutton_i(Fl_Button*, void*);
  static void cb_lbutton(Fl_Button*, void*);
public:
  Fl_Button *cbutton;
private:
  inline void cb_cbutton_i(Fl_Button*, void*);
  static void cb_cbutton(Fl_Button*, void*);
public:
  Fl_Button *pbutton;
private:
  inline void cb_pbutton_i(Fl_Button*, void*);
  static void cb_pbutton(Fl_Button*, void*);
public:
  Fl_Check_Button2 *enabled;
private:
  inline void cb_enabled_i(Fl_Check_Button2*, void*);
  static void cb_enabled(Fl_Check_Button2*, void*);
public:
  Fl_Button *applybutton;
private:
  inline void cb_applybutton_i(Fl_Button*, void*);
  static void cb_applybutton(Fl_Button*, void*);
public:
  Fl_Button *resClose;
private:
  inline void cb_resClose_i(Fl_Button*, void*);
  static void cb_resClose(Fl_Button*, void*);
public:
  void send_data(int action, int control, float value, int type);
  void returns_update(CommandBlock *getData);
  ResonanceUI(Resonance *respar_, int npart_, int kititem_, int engine_);
  virtual ~ResonanceUI();
  void refresh();
  void Show();
  void resonanceRtext();
  Resonance *respar;
private:
  ResonanceGraph *rg;
  SynthEngine *synth;
  int npart;
  int kititem;
  int engine;
  bool resSeen;
  float resDW;
  float resDH;
};
#endif
