﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ds/DirectoryService_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DirectoryService {
namespace Model {
class UpdateTrustResult {
 public:
  AWS_DIRECTORYSERVICE_API UpdateTrustResult() = default;
  AWS_DIRECTORYSERVICE_API UpdateTrustResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DIRECTORYSERVICE_API UpdateTrustResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateTrustResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Identifier of the trust relationship.</p>
   */
  inline const Aws::String& GetTrustId() const { return m_trustId; }
  template <typename TrustIdT = Aws::String>
  void SetTrustId(TrustIdT&& value) {
    m_trustIdHasBeenSet = true;
    m_trustId = std::forward<TrustIdT>(value);
  }
  template <typename TrustIdT = Aws::String>
  UpdateTrustResult& WithTrustId(TrustIdT&& value) {
    SetTrustId(std::forward<TrustIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_requestId;

  Aws::String m_trustId;
  bool m_requestIdHasBeenSet = false;
  bool m_trustIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DirectoryService
}  // namespace Aws
